#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    se
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Processing_Settings
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  class ProcessingSettings
    def initialize(md)
      @md=md
    end
    def cnf_rc #sisurc.yml
      @rc=SiSU_Env::GetInit.new.sisu_yaml.rc
    end
    def env_rc #env rc (including sisurc.yml)
      @env_rc ||=SiSU_Env::InfoEnv.new(@md.fns)
    end
    def doc_rc #document rc, make instructions
      (defined? @md.make) \
      ? @md.make
      : nil
    end
    def cmd_rc_act #command-line rc
      @cmd_rc_act=@md.opt.opt_act
    end
    def build
      def ocn?
        if cmd_rc_act[:ocn][:set]==:on
          true
        elsif cmd_rc_act[:ocn][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.ocn? \
        and doc_rc.toc? ==:off
          false
        elsif env_rc.build.ocn? ==:off
          false
        else
          true
        end
      end
      def plaintext_ocn?
        if cmd_rc_act[:txt_ocn][:set]==:on \
        or cmd_rc_act[:ocn][:set]==:on
          true
        elsif cmd_rc_act[:txt_ocn][:set]==:off \
        or cmd_rc_act[:ocn][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.ocn? \
        and doc_rc.toc? ==:off
          false
        elsif env_rc.build.ocn? ==:off
          false
        else
          true
        end
      end
      def odt_ocn?
        if cmd_rc_act[:odt_ocn][:set]==:on \
        or cmd_rc_act[:ocn][:set]==:on
          true
        elsif cmd_rc_act[:odt_ocn][:set]==:off \
        or cmd_rc_act[:ocn][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.ocn? \
        and doc_rc.toc? ==:off
          false
        elsif env_rc.build.ocn? ==:off
          false
        else
          true
        end
      end
      def html_strict?
        if cmd_rc_act[:html_strict][:set]==:on
          true
        elsif cmd_rc_act[:html_strict][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.html_strict? \
        and doc_rc.html_strict? ==:on
          true
        else
          false
        end
      end
      def toc?
        if cmd_rc_act[:toc][:set]==:on
          true
        elsif cmd_rc_act[:toc][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.toc? \
        and doc_rc.toc? ==:off
          false
        elsif env_rc.build.toc? ==:off
          false
        else
          true
        end
      end
      def manifest?
        if cmd_rc_act[:manifest][:set]==:on
          true
        elsif cmd_rc_act[:manifest][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.manifest? \
        and doc_rc.manifest? ==:off
          false
        elsif env_rc.build.manifest? ==:off
          false
        else
          true
        end
      end
      def links_to_manifest?
        if cmd_rc_act[:links_to_manifest][:set]==:on
          true
        elsif cmd_rc_act[:links_to_manifest][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.links_to_manifest? \
        and doc_rc.links_to_manifest? ==:off
          false
        elsif env_rc.build.links_to_manifest? ==:off
          false
        else
          true
        end
      end
      def metadata?
        if cmd_rc_act[:metadata][:set]==:on
          true
        elsif cmd_rc_act[:metadata][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.metadata? \
        and doc_rc.metadata? ==:off
          false
        elsif env_rc.build.metadata? ==:off
          false
        else
          true
        end
      end
      def minitoc?
        if html_top_band? == false #one form of navigation necessary
          true
        elsif cmd_rc_act[:minitoc][:set]==:on
          true
        elsif cmd_rc_act[:minitoc][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.minitoc? \
        and doc_rc.minitoc? ==:off
          false
        elsif env_rc.build.minitoc? ==:off
          false
        else
          false
        end
      end
      def manifest_minitoc?
        if html_top_band? == false #one form of navigation necessary
          true
        elsif cmd_rc_act[:manifest_minitoc][:set]==:on \
        || cmd_rc_act[:minitoc][:set]==:on
          true
        elsif cmd_rc_act[:manifest_minitoc][:set]==:off \
        || cmd_rc_act[:minitoc][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.manifest_minitoc? \
        and (doc_rc.manifest_minitoc? ==:off \
        || doc_rc.minitoc? ==:off)
          false
        elsif env_rc.build.manifest_minitoc? ==:off \
        || env_rc.build.minitoc? ==:off
          false
        elsif minitoc? == false
          false
        else
          false
        end
      end
      def html_minitoc?
        if html_top_band? == false #one form of navigation necessary
          true
        elsif cmd_rc_act[:html_minitoc][:set]==:on \
        || cmd_rc_act[:minitoc][:set]==:on
          true
        elsif cmd_rc_act[:html_minitoc][:set]==:off \
        || cmd_rc_act[:minitoc][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.html_minitoc? \
        and (doc_rc.html_minitoc? ==:off \
        || doc_rc.minitoc? ==:off)
          false
        elsif env_rc.build.html_minitoc? ==:off \
        || env_rc.build.minitoc? ==:off
          false
        elsif minitoc? == false
          false
        else
          false
        end
      end
      def html_top_band?
        if cmd_rc_act[:html_top_band][:set]==:on
          true
        elsif cmd_rc_act[:html_top_band][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.html_top_band? \
        and doc_rc.html_top_band? ==:off
          false
        elsif env_rc.build.html_top_band? ==:off
          false
        else
          true
        end
      end
      def html_navigation?
        if cmd_rc_act[:html_navigation][:set]==:on
          true
        elsif cmd_rc_act[:html_navigation][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.html_navigation? \
        and doc_rc.html_navigation? ==:off
          false
        elsif env_rc.build.html_navigation? ==:off
          false
        else
          true
        end
      end
      def html_navigation_bar?
        if cmd_rc_act[:html_navigation_bar][:set]==:on
          true
        elsif cmd_rc_act[:html_navigation_bar][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.html_navigation_bar? \
        and doc_rc.html_navigation_bar? ==:off
          false
        elsif env_rc.build.html_navigation_bar? ==:off
          false
        else
          false
        end
      end
      def search_form?
        if cmd_rc_act[:search_form][:set]==:on
          true
        elsif cmd_rc_act[:search_form][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.html_search_form? \
        and doc_rc.search_form? ==:off
          false
        elsif env_rc.build.search_form? ==:off
          false
        else
          true
        end
      end
      def html_search_form?
        if cmd_rc_act[:html_search_form][:set]==:on \
        || cmd_rc_act[:search_form][:set]==:on
          true
        elsif cmd_rc_act[:html_search_form][:set]==:off \
        || cmd_rc_act[:search_form][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.html_search_form? \
        and (doc_rc.html_search_form? ==:off \
        || doc_rc.search_form? ==:off)
          false
        elsif env_rc.build.html_search_form? ==:off \
        || env_rc.build.search_form? ==:off
          false
        elsif search_form? == false
          false
        else
          true
        end
      end
      def html_right_pane?
        if cmd_rc_act[:html_right_pane][:set]==:on
          true
        elsif cmd_rc_act[:html_right_pane][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.html_right_pane? \
        and doc_rc.html_right_pane? ==:off
          false
        elsif env_rc.build.html_right_pane? ==:off
          false
        else
          true
        end
      end
      def segsubtoc?
        if cmd_rc_act[:segsubtoc][:set]==:on
          true
        elsif cmd_rc_act[:segsubtoc][:set]==:off
          false
        elsif doc_rc.is_a?(Method) \
        and defined? doc_rc.segsubtoc? \
        and doc_rc.segsubtoc? ==:off
          false
        elsif env_rc.build.segsubtoc? ==:off
          false
        else
          true
        end
      end
      self
    end
    def ocn_html_identifier
      (build.html_strict?) \
      ? Mx[:ocn_id_char]
      : ''
    end
    def output_dir_structure
      def by_language_code?
        if cmd_rc_act[:output_by][:set] == :language
          true
        elsif cmd_rc_act[:output_by][:set] == :filetype \
        or cmd_rc_act[:output_by][:set] == :filename
          false
        elsif cmd_rc_act[:output_by][:set] == :language
          true
        else
          env_rc.output_dir_structure.by_language_code?
        end
      end
      def by_filetype?
        if cmd_rc_act[:output_by][:set] == :filetype
          true
        elsif cmd_rc_act[:output_by][:set] == :language \
        or cmd_rc_act[:output_by][:set] == :filename
          false
        elsif cmd_rc_act[:output_by][:set] == :filetype
          true
        else
          env_rc.output_dir_structure.by_filetype?
        end
      end
      def by_filename?
        if cmd_rc_act[:output_by][:set] == :filename
          true
        elsif cmd_rc_act[:output_by][:set] == :language \
        or cmd_rc_act[:output_by][:set] == :filetype
          false
        elsif cmd_rc_act[:output_by][:set] == :filename
          true
        else
          env_rc.output_dir_structure.by_filename?
        end
      end
      def multilingual?
        by_language_code?
      end
      def dump?
        ((cmd_rc_act[:dump][:bool] \
        &&  cmd_rc_act[:dump][:inst]) \
        || (env_rc.output_dir_structure.dump?)) \
        ? true
        : false
      end
      def redirect?
        ((cmd_rc_act[:redirect][:bool] \
        &&  cmd_rc_act[:redirect][:inst]) \
        || (env_rc.output_dir_structure.redirect?)) \
        ? true
        : false
      end
      def dump_or_redirect?
        ((dump?) || (redirect?)) \
        ? true
        : false
      end
      def by?
        if dump?
          :dump
        elsif redirect?
          :redirect
        elsif by_language_code?
          :language
        elsif by_filetype?
          :filetype
        elsif by_filename?
          :filename
        else #recheck current default
          :language
        end
      end
      self
    end
  end
end
module SiSU_Info_Processing_Flag
  class InfoProcessingFlag
    attr_accessor :color,:act_0,:act_1,:act_2,:act_3,:act_4,:act_5,:act_6,:act_7,:act_8,:act_9
    def initialize
      @rc=SiSU_Get_Init::GetInit.new.sisu_yaml.rc
    end
    def color                          #configurable processing flag shortcuts
      (defined? @rc['flag']['color']) \
      ? @rc['flag']['color']
      : false
    end
    def act_0                           #configurable processing flag shortcuts
      def default
        '--manifest --digest --qrcode --text --html --epub --concordance --pdf --odf --docbook --xhtml --xml-sax --xml-dom --sqlite --verbose'
      end
      def str
        if defined? @rc['flag']['act0'] \
        and @rc['flag']['act0'].is_a?(String)
          @rc['flag']['act0']
        elsif defined? @rc['flag']['default'] \
        and @rc['flag']['default'].is_a?(String)
          @rc['flag']['default']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_1                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html'
      end
      def str
        if defined? @rc['flag']['act1'] \
        and @rc['flag']['act1'].is_a?(String)
          @rc['flag']['act1']
        elsif defined? @rc['flag']['i'] \
        and @rc['flag']['i'].is_a?(String)
          @rc['flag']['i']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_2                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html --epub --pdf'
      end
      def str
        if defined? @rc['flag']['act2'] \
        and @rc['flag']['act2'].is_a?(String)
          @rc['flag']['act2']
        elsif defined? @rc['flag']['ii'] \
        and @rc['flag']['ii'].is_a?(String)
          @rc['flag']['ii']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_3                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html --epub --pdf --concordance --qrcode'
      end
      def str
        if defined? @rc['flag']['act3'] \
        and @rc['flag']['act3'].is_a?(String)
          @rc['flag']['act3']
        elsif defined? @rc['flag']['iii'] \
        and @rc['flag']['iii'].is_a?(String)
          @rc['flag']['iii']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_4                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html --epub --pdf --concordance --qrcode --digest --odf --docbook'
      end
      def str
        if defined? @rc['flag']['act4'] \
        and @rc['flag']['act4'].is_a?(String)
          @rc['flag']['act4']
        elsif defined? @rc['flag']['iv'] \
        and @rc['flag']['iv'].is_a?(String)
          @rc['flag']['iv']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_5                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html --epub --pdf --concordance --qrcode --digest --odf --docbook --sqlite'
      end
      def str
        if defined? @rc['flag']['act5'] \
        and @rc['flag']['act5'].is_a?(String)
          @rc['flag']['act5']
        elsif defined? @rc['flag']['v'] \
        and @rc['flag']['v'].is_a?(String)
          @rc['flag']['v']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_6                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html --epub --pdf --concordance --qrcode --digest --odf --docbook --sqlite --xhtml --xml-sax --xml-dom'
      end
      def str
        if defined? @rc['flag']['act6'] \
        and @rc['flag']['act6'].is_a?(String)
          @rc['flag']['act6']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_7                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html --epub --pdf --concordance --qrcode --digest --odf --docbook --sqlite --xhtml --xml-sax --xml-dom --source --sisupod'
      end
      def str
        if defined? @rc['flag']['act7'] \
        and @rc['flag']['act7'].is_a?(String)
          @rc['flag']['act7']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_8                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html --epub --pdf --concordance --qrcode --digest --odf --docbook --xhtml --xml-sax --xml-dom --pg --update'
      end
      def str
        if defined? @rc['flag']['act8'] \
        and @rc['flag']['act8'].is_a?(String)
          @rc['flag']['act8']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_9                           #configurable processing flag shortcuts
      def default
        '--manifest --text --html --epub --pdf --concordance --qrcode --digest --odf --docbook --xhtml --xml-sax --xml-dom --pg --update --source --sisupod'
      end
      def str
        if defined? @rc['flag']['act9'] \
        and @rc['flag']['act9'].is_a?(String)
          @rc['flag']['act9']
        else default
        end
      end
      def arr
        str.scan(/\S+/)
      end
      self
    end
    def act_info
      puts 'current "act" settings:'
      acts=%w[ act_0 act_1 act_2 act_3 act_4 act_5 act_6 act_7 act_8 act_9 ]
      acts.each_with_index do |m,i|
        puts '--act-' + i.to_s + ' == ' \
        + send(m).str
      end
    end
  end
end
__END__
