# salt-call completion for fish shell
# See salt_common.fish in the same folder for the information

# hack to load functions from salt_common completion
complete --do-complete='salt_common --' >/dev/null

# salt-call general options (from --help)
complete -c salt-call        -r      -l file-root            -d "Set this directory as the base file root."
complete -c salt-call        -f -s g -l grains               -d "Return the information generated by the salt grains "
complete -c salt-call        -f      -l id                   -d "Specify the minion id to use. If this option is omitted, the id option from the minion config will be used."
complete -c salt-call        -f      -l local                -d "Run salt-call locally, as if there was no master running."
complete -c salt-call        -x      -l master               -d "Specify the master to use. The minion must be authenticated with the master. If this option is omitted, the master options from the minion config will be used. If multi masters are set up the first listed master that responds will be used."
complete -c salt-call        -r -s m -l module-dirs          -d "Specify an additional directory to pull modules from.  Multiple directories can be provided by passing `-m /--module-dirs` multiple times."
complete -c salt-call        -r      -l pillar-root          -d "Set this directory as the base pillar root."
complete -c salt-call        -f      -l refresh-grains-cache -d "Force a refresh of the grains cache"
complete -c salt-call        -f      -l retcode-passthrough  -d "Exit with the salt call retcode and not the salt binary retcode"
complete -c salt-call        -f      -l skip-grains          -d "Do not load grains."

# functions
complete -c salt-call    -f  -a '(__fish_salt_list_function)'
# complete -c salt         -f -n 'not __fish_salt_extract_function' -a '(__fish_salt_list_function)'
# arguments and name values
complete -c salt-call    -f -n '__fish_salt_extract_function'                                       -a '(__fish_salt_list_arg_name) (__fish_salt_list_arg_value)'
