#ifndef _RHEO_OUT_SPARSE_MATLAB_H
#define _RHEO_OUT_SPARSE_MATLAB_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// output in sparse matlab format, without the header
// 	a = zeros (nrow,ncol);
//
# include "rheolef/compiler.h"
namespace rheolef { 

template <
    class InputIterator1,
    class InputIterator2,
    class InputIterator3>
void
csr_output_sparse_matlab (
    std::ostream&       out,
    const std::string&  name,
    InputIterator1      ia,
    InputIterator1      last_ia,
    InputIterator2      ja,
    InputIterator3      first_a)
{
    typename std::iterator_traits<InputIterator2>::value_type  i = 1;
    InputIterator3 a = first_a + (*ia++);
    while (ia != last_ia) {
        InputIterator3 last_a = first_a + (*ia++);
        while (a != last_a) {
            out << name << "(" << i << "," << (*ja++)+1 << ")=" << *a++ << ";" << std::endl;
        }
        ++i;
    }
}
}// namespace rheolef
#endif // _RHEO_OUT_SPARSE_MATLAB_H
