% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.statcheck.R
\name{plot.statcheck}
\alias{plot.statcheck}
\title{Plot method for statcheck}
\usage{
\method{plot}{statcheck}(x, alpha = 0.05, APAstyle = TRUE, group = NULL, ...)
}
\arguments{
\item{x}{A statcheck object. See \code{\link{statcheck}}.}

\item{alpha}{assumed level of significance in the scanned texts. Defaults to 
.05.}

\item{APAstyle}{If TRUE, prints plot in APA style.}

\item{group}{Indicate grouping variable to facet plot. Only works when 
\code{APAstyle==TRUE}}

\item{...}{arguments to be passed to methods, such as graphical parameters 
(see \code{\link{par}}).}
}
\description{
Function for plotting of \code{statcheck} objects. Reported p values are 
plotted against recalculated p values, which allows the user to easily spot 
if articles contain miscalculations of statistical results.
}
\details{
If APAstyle = FALSE, inconsistencies between the reported and the recalculated p value are indicated with an orange dot. Recalculations of the p value that render a previously non significant result (p >= .5) as significant (p < .05), and vice versa, are considered decision errors, and are indicated with a red dot. Exactly reported p values (i.e. p = ..., as opposed to p < ... or p > ...) are indicated with a diamond.
}
\section{Acknowledgements}{

Many thanks to John Sakaluk who adapted the plot code to create graphs in 
APA style.
}

\examples{
# First we need a statcheck object
# Here, we create one by running statcheck on some raw text

txt <- "This test is consistent t(28) = 0.2, p = .84, but this one is 
inconsistent: F(2, 28) = 4.2, p = .01. This final test is even a
gross/decision inconsistency: z = 1.23, p = .03"

result <- statcheck(txt)

# We can then plot the statcheck object 'result' by simply calling plot() on 
# "result". R will know what kind of plot to make, because "result" is of 
# class "statcheck"
plot(result)

}
\seealso{
\code{\link{statcheck}}
}
