% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_s3.R
\name{cache_s3}
\alias{cache_s3}
\title{Amazon Web Services S3 Cache
Amazon Web Services S3 backed cache, for remote caching.}
\usage{
cache_s3(cache_name, algo = "sha512")
}
\arguments{
\item{cache_name}{Bucket name for storing cache files.}

\item{algo}{The hashing algorithm used for the cache, see
\code{\link[digest]{digest}} for available algorithms.}
}
\description{
Amazon Web Services S3 Cache
Amazon Web Services S3 backed cache, for remote caching.
}
\examples{

\dontrun{
# Set AWS credentials.
Sys.setenv("AWS_ACCESS_KEY_ID" = "<access key>",
           "AWS_SECRET_ACCESS_KEY" = "<access secret>")

# Set up a unique bucket name.
s3 <- cache_s3("unique-bucket-name")
mem_runif <- memoise(runif, cache = s3)
}


}
