% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_subsample.R
\name{loo_subsample}
\alias{loo_subsample}
\alias{loo_subsample.function}
\title{Efficient approximate leave-one-out cross-validation (LOO) using subsampling}
\usage{
loo_subsample(x, ...)

\method{loo_subsample}{`function`}(
  x,
  ...,
  data = NULL,
  draws = NULL,
  observations = 400,
  log_p = NULL,
  log_g = NULL,
  r_eff = NULL,
  save_psis = FALSE,
  cores = getOption("mc.cores", 1),
  loo_approximation = "plpd",
  loo_approximation_draws = NULL,
  estimator = "diff_srs",
  llgrad = NULL,
  llhess = NULL
)
}
\arguments{
\item{x}{A function. The \strong{Methods (by class)} section, below, has detailed
descriptions of how to specify the inputs.}

\item{data, draws, ...}{For \code{loo_subsample.function()}, these are the data,
posterior draws, and other arguments to pass to the log-likelihood
function. Note that for some \code{loo_approximation}s, the draws will be replaced
by the posteriors summary statistics to compute loo approximations. See
argument \code{loo_approximation} for details.}

\item{observations}{The subsample observations to use. The argument can take
four (4) types of arguments:
\itemize{
\item \code{NULL} to use all observations. The algorithm then just uses
standard \code{loo()} or \code{loo_approximate_posterior()}.
\item A single integer to specify the number of observations to be subsampled.
\item A vector of integers to provide the indices used to subset the data.
\emph{These observations need to be subsampled with the same scheme as given by
the \code{estimator} argument}.
\item A \code{psis_loo_ss} object to use the same observations that were used in a
previous call to \code{loo_subsample()}.
}}

\item{log_p, log_g}{Should be supplied only if approximate posterior draws are
used. The default (\code{NULL}) indicates draws are from "true" posterior (i.e.
using MCMC). If not \code{NULL} then they should be specified as described in
\code{\link[=loo_approximate_posterior]{loo_approximate_posterior()}}.}

\item{r_eff}{Vector of relative effective sample size estimates for the
likelihood (\code{exp(log_lik)}) of each observation. This is related to
the relative efficiency of estimating the normalizing term in
self-normalizing importance sampling when using posterior draws obtained
with MCMC. If MCMC draws are used and \code{r_eff} is not provided then
the reported PSIS effective sample sizes and Monte Carlo error estimates
will be over-optimistic. If the posterior draws are independent then
\code{r_eff=1} and can be omitted. The warning message thrown when \code{r_eff} is
not specified can be disabled by setting \code{r_eff} to \code{NA}. See the
\code{\link[=relative_eff]{relative_eff()}} helper functions for computing \code{r_eff}.}

\item{save_psis}{Should the \code{"psis"} object created internally by
\code{loo_subsample()} be saved in the returned object? See \code{\link[=loo]{loo()}} for details.}

\item{cores}{The number of cores to use for parallelization. This defaults to
the option \code{mc.cores} which can be set for an entire R session by
\code{options(mc.cores = NUMBER)}. The old option \code{loo.cores} is now
deprecated but will be given precedence over \code{mc.cores} until
\code{loo.cores} is removed in a future release. \strong{As of version
2.0.0 the default is now 1 core if \code{mc.cores} is not set}, but we
recommend using as many (or close to as many) cores as possible.
\itemize{
\item Note for Windows 10 users: it is \strong{strongly}
\href{https://github.com/stan-dev/loo/issues/94}{recommended} to avoid using
the \code{.Rprofile} file to set \code{mc.cores} (using the \code{cores} argument or
setting \code{mc.cores} interactively or in a script is fine).
}}

\item{loo_approximation}{What type of approximation of the loo_i's should be used?
The default is \code{"plpd"} (the log predictive density using the posterior expectation).
There are six different methods implemented to approximate loo_i's
(see the references for more details):
\itemize{
\item \code{"plpd"}: uses the lpd based on point estimates (i.e., \eqn{p(y_i|\hat{\theta})}).
\item \code{"lpd"}: uses the lpds (i,e., \eqn{p(y_i|y)}).
\item \code{"tis"}: uses truncated importance sampling to approximate PSIS-LOO.
\item \code{"waic"}: uses waic (i.e., \eqn{p(y_i|y) - p_{waic}}).
\item \code{"waic_grad_marginal"}: uses waic approximation using first order delta
method and posterior marginal variances to approximate \eqn{p_{waic}} (ie.
\eqn{p(y_i|\hat{\theta})}-p_waic_grad_marginal). Requires gradient of
likelihood function.
\item \code{"waic_grad"}: uses waic approximation using first order delta method and
posterior covariance to approximate \eqn{p_{waic}} (ie.
\eqn{p(y_i|\hat{\theta})}-p_waic_grad). Requires gradient of likelihood
function.
\item \code{"waic_hess"}: uses waic approximation using second order delta method and
posterior covariance to approximate \eqn{p_{waic}} (ie.
\eqn{p(y_i|\hat{\theta})}-p_waic_grad). Requires gradient and Hessian of
likelihood function.
}

As point estimates of \eqn{\hat{\theta}}, the posterior expectations
of the parameters are used.}

\item{loo_approximation_draws}{The number of posterior draws used when
integrating over the posterior. This is used if \code{loo_approximation} is set
to \code{"lpd"}, \code{"waic"}, or \code{"tis"}.}

\item{estimator}{How should \code{elpd_loo}, \code{p_loo} and \code{looic} be estimated?
The default is \code{"diff_srs"}.
\itemize{
\item \code{"diff_srs"}: uses the difference estimator with simple random sampling
(srs). \code{p_loo} is estimated using standard srs.
\item \code{"hh"}: uses the Hansen-Hurwitz estimator with sampling proportional to
size, where \code{abs} of loo_approximation is used as size.
\item \code{"srs"}: uses simple random sampling and ordinary estimation.
}}

\item{llgrad}{The gradient of the log-likelihood. This
is only used when \code{loo_approximation} is \code{"waic_grad"},
\code{"waic_grad_marginal"}, or \code{"waic_hess"}. The default is \code{NULL}.}

\item{llhess}{The hessian of the log-likelihood. This is only used
with \code{loo_approximation = "waic_hess"}. The default is \code{NULL}.}
}
\value{
\code{loo_subsample()} returns a named list with class \code{c("psis_loo_ss", "psis_loo", "loo")}. This has the same structure as objects returned by
\code{\link[=loo]{loo()}} but with the additional slot:
\itemize{
\item \code{loo_subsampling}: A list with two vectors, \code{log_p} and \code{log_g}, of the
same length containing the posterior density and the approximation density
for the individual draws.
}
}
\description{
Efficient approximate leave-one-out cross-validation (LOO) using subsampling
}
\details{
The \code{loo_subsample()} function is an S3 generic and a methods is
currently provided for log-likelihood functions. The implementation works
for both MCMC and for posterior approximations where it is possible to
compute the log density for the approximation.
}
\section{Methods (by class)}{
\itemize{
\item \code{loo_subsample(`function`)}: A function \code{f()} that takes arguments \code{data_i} and \code{draws} and returns a
vector containing the log-likelihood for a single observation \code{i} evaluated
at each posterior draw. The function should be written such that, for each
observation \code{i} in \code{1:N}, evaluating

\if{html}{\out{<div class="sourceCode">}}\preformatted{f(data_i = data[i,, drop=FALSE], draws = draws)
}\if{html}{\out{</div>}}

results in a vector of length \code{S} (size of posterior sample). The
log-likelihood function can also have additional arguments but \code{data_i} and
\code{draws} are required.

If using the function method then the arguments \code{data} and \code{draws} must also
be specified in the call to \code{loo()}:
\itemize{
\item \code{data}: A data frame or matrix containing the data (e.g.
observed outcome and predictors) needed to compute the pointwise
log-likelihood. For each observation \code{i}, the \code{i}th row of
\code{data} will be passed to the \code{data_i} argument of the
log-likelihood function.
\item \code{draws}: An object containing the posterior draws for any
parameters needed to compute the pointwise log-likelihood. Unlike
\code{data}, which is indexed by observation, for each observation the
entire object \code{draws} will be passed to the \code{draws} argument of
the log-likelihood function.
\item The \code{...} can be used if your log-likelihood function takes additional
arguments. These arguments are used like the \code{draws} argument in that they
are recycled for each observation.
}

}}
\references{
Magnusson, M., Riis Andersen, M., Jonasson, J. and Vehtari, A. (2019).
Leave-One-Out Cross-Validation for Large Data.
In \emph{International Conference on Machine Learning}

Magnusson, M., Riis Andersen, M., Jonasson, J. and Vehtari, A. (2020).
Leave-One-Out Cross-Validation for Model Comparison in Large Data.
In \emph{International Conference on Artificial Intelligence and Statistics (AISTATS)}
}
\seealso{
\code{\link[=loo]{loo()}}, \code{\link[=psis]{psis()}}, \code{\link[=loo_compare]{loo_compare()}}
}
