% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_spanning_seq}
\alias{date_spanning_seq}
\title{Spanning sequence: date and date-time}
\usage{
date_spanning_seq(x)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date or date-time vector.}
}
\value{
A sequence along \verb{[min(x), max(x)]}.
}
\description{
\code{date_spanning_seq()} generates a regular sequence along the span of
\code{x}, i.e. along \verb{[min(x), max(x)]}. For dates, this generates a day precision
sequence, and for date-times it generates a second precision sequence.
}
\details{
Missing and infinite values are automatically removed before the sequence is
generated.

For date-times, sys-time based sequences are generated, consistent with
\code{\link[=posixt-sequence]{date_seq()}} when using a second precision \code{by} value.

If you need more precise sequence generation, call \code{\link[=range]{range()}} and \code{\link[=date_seq]{date_seq()}}
directly.
}
\examples{
x <- date_build(2020, c(1, 2, 1), c(10, 5, 12))
date_spanning_seq(x)

# Missing and infinite dates are removed before the sequence is generated
x <- c(x, NA, Inf, -Inf)
x

date_spanning_seq(x)

# For date-times, sequences are generated at second precision
x <- date_time_build(
  2020, 1, 2, 3, c(5, 4, 5), c(10, 48, 12),
  zone = "America/New_York"
)
x

date_spanning_seq(x)
}
