% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_selectors.R
\name{process_selectors}
\alias{process_selectors}
\alias{process_formula_selectors}
\alias{fill_formula_selectors}
\alias{process_selectors.data.frame}
\alias{process_formula_selectors.data.frame}
\alias{fill_formula_selectors.data.frame}
\alias{compute_formula_selector}
\alias{check_list_elements}
\alias{cards_select}
\title{Process tidyselectors}
\usage{
process_selectors(data, ...)

process_formula_selectors(data, ...)

fill_formula_selectors(data, ...)

\method{process_selectors}{data.frame}(data, ..., env = caller_env())

\method{process_formula_selectors}{data.frame}(
  data,
  ...,
  env = caller_env(),
  include_env = FALSE,
  allow_empty = TRUE
)

\method{fill_formula_selectors}{data.frame}(data, ..., env = caller_env())

compute_formula_selector(
  data,
  x,
  arg_name = caller_arg(x),
  env = caller_env(),
  strict = TRUE,
  include_env = FALSE,
  allow_empty = TRUE
)

check_list_elements(
  x,
  predicate,
  error_msg = NULL,
  arg_name = rlang::caller_arg(x)
)

cards_select(expr, data, ..., arg_name = NULL)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{...}{(\code{\link[rlang:dyn-dots]{dynamic-dots}})\cr
named arguments where the value of the argument is processed with tidyselect.
\itemize{
\item \code{process_selectors()}: the values are tidyselect-compatible selectors
\item \code{process_formula_selectors()}: the values are named lists, list of formulas
a combination of both, or a single formula. Users may pass \code{~value} as a
shortcut for \code{everything() ~ value}.
\item \code{check_list_elements()}: named arguments where the name matches an existing
list in the \code{env} environment, and the value is a predicate function
to test each element of the list, e.g. each element must be a string or
a function.
}}

\item{env}{(\code{environment})\cr
env to save the results to. Default is the calling environment.}

\item{include_env}{(\code{logical})\cr
whether to include the environment from the formula object in the returned
named list. Default is \code{FALSE}}

\item{allow_empty}{(\code{logical})\cr
Logical indicating whether empty result is acceptable while process
formula-list selectors. Default is \code{TRUE}.}

\item{x}{\itemize{
\item \code{compute_formula_selector()}: (\code{\link[=syntax]{formula-list-selector}})\cr
a named list, list of formulas, or a single formula that will be
converted to a named list.
\item \code{check_list_elements()}: (named \code{list})\cr
a named list
}}

\item{arg_name}{(\code{string})\cr
the name of the argument being processed. Used
in error messaging. Default is \code{caller_arg(x)}.}

\item{strict}{(\code{logical})\cr
whether to throw an error if a variable doesn't exist in the reference data
(passed to \code{\link[tidyselect:eval_select]{tidyselect::eval_select()}})}

\item{predicate}{(\code{function})\cr
a predicate function that returns \code{TRUE} or \code{FALSE}}

\item{error_msg}{(\code{character})\cr
a character vector that will
be used in error messaging when mis-specified arguments are passed. Elements
\code{"{arg_name}"} and \code{"{variable}"} are available using glue syntax for messaging.}

\item{expr}{(\code{expression})\cr
Defused R code describing a selection according to the tidyselect syntax.}
}
\value{
\code{process_selectors()}, \code{fill_formula_selectors()}, \code{process_formula_selectors()}
and \code{check_list_elements()} return NULL. \code{compute_formula_selector()} returns a
named list.
}
\description{
Functions process tidyselect arguments passed to functions in the cards package.
The processed values are saved to the calling environment, by default.
\itemize{
\item \code{process_selectors()}: the arguments will be processed with tidyselect and
converted to a vector of character column names.
\item \code{process_formula_selectors()}: for arguments that expect named lists or
lists of formulas (where the LHS of the formula is a tidyselector). This
function processes these inputs and returns a named list. If a name is
repeated, the last entry is kept.
\item \code{fill_formula_selectors()}: when users override the default argument values,
it can be important to ensure that each column from a data frame is assigned
a value. This function checks that each column in \code{data} has an assigned
value, and if not, fills the value in with the default value passed here.
\item \code{compute_formula_selector()}: used in \code{process_formula_selectors()} to
evaluate a single argument.
\item \code{check_list_elements()}: used to check the class/type/values of the list
elements, primarily those processed with \code{process_formula_selectors()}.
\item \code{cards_select()}: wraps \code{tidyselect::eval_select() |> names()}, and returns
better contextual messaging when errors occur.
}
}
\examples{
example_env <- rlang::new_environment()

process_selectors(ADSL, variables = starts_with("TRT"), env = example_env)
get(x = "variables", envir = example_env)

fill_formula_selectors(ADSL, env = example_env)

process_formula_selectors(
  ADSL,
  statistic = list(starts_with("TRT") ~ mean, TRTSDT = min),
  env = example_env
)
get(x = "statistic", envir = example_env)

check_list_elements(
  get(x = "statistic", envir = example_env),
  predicate = function(x) !is.null(x),
  error_msg = c(
    "Error in the argument {.arg {arg_name}} for variable {.val {variable}}.",
    "i" = "Value must be a named list of functions."
  )
)

# process one list
compute_formula_selector(ADSL, x = starts_with("U") ~ 1L)
}
