% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5F.R
\name{H5Fget_name}
\alias{H5Fget_name}
\title{Retrieve the name of the file to which an object belongs}
\usage{
H5Fget_name(h5obj)
}
\arguments{
\item{h5obj}{An object of class \linkS4class{H5IdComponent}.  Despite this being
an H5F function, it works equally well on H5 file, group, dataset and
attribute datatypes.}
}
\description{
Retrieve the name of the file to which an object belongs
}
\examples{

## use an example file and show its location
h5file <- system.file("testfiles", "h5ex_t_array.h5", package = "rhdf5")
h5file

## open a file handle and confirm we can identify the file it points to
fid <- H5Fopen(h5file)
H5Fget_name(fid)

## H5Fget_name() can be applied to group and dataset handles too
gid <- H5Gopen(fid, name = "/")
did <- H5Dopen(fid, name = "DS1")
H5Fget_name(gid)
H5Fget_name(did)

## tidy up
H5Dclose(did)
H5Gclose(gid)
H5Fclose(fid)

}
