% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_data_heatmap}
\alias{plot_data_heatmap}
\title{Plot heatmap of relevant features}
\usage{
plot_data_heatmap(
  object,
  factor,
  view = 1,
  groups = "all",
  features = 50,
  annotation_features = NULL,
  annotation_samples = NULL,
  transpose = FALSE,
  imputed = FALSE,
  denoise = FALSE,
  max.value = NULL,
  min.value = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{factor}{a string with the factor name, or an integer with the index of the factor.}

\item{view}{a string with the view name, or an integer with the index of the view. Default is the first view.}

\item{groups}{groups to plot. Default is "all".}

\item{features}{if an integer (default), the total number of features to plot based on the absolute value of the weights.
If a character vector, a set of manually defined features.}

\item{annotation_features}{annotation metadata for features (rows). 
Either a character vector specifying columns in the feature metadata, or a data.frame that will be passed to \code{\link[pheatmap]{pheatmap}} as \code{annotation_col}}

\item{annotation_samples}{annotation metadata for samples (columns). 
Either a character vector specifying columns in the sample metadata, or a data.frame that will be passed to \code{\link[pheatmap]{pheatmap}} as \code{annotation_row}}

\item{transpose}{logical indicating whether to transpose the heatmap. 
Default corresponds to features as rows and samples as columns.}

\item{imputed}{logical indicating whether to plot the imputed data instead of the original data. Default is FALSE.}

\item{denoise}{logical indicating whether to plot a denoised version of the data reconstructed using the MOFA factors.}

\item{max.value}{numeric indicating the maximum value to display in the heatmap (i.e. the matrix values will be capped at \code{max.value} ).}

\item{min.value}{numeric indicating the minimum value to display in the heatmap (i.e. the matrix values will be capped at \code{min.value} ).
See \code{\link{predict}}. Default is FALSE.}

\item{...}{further arguments that can be passed to \code{\link[pheatmap]{pheatmap}}}
}
\value{
A  \code{\link[pheatmap]{pheatmap}} object
}
\description{
Function to plot a heatmap of the data for relevant features, typically the ones with high weights.
}
\details{
One of the first steps for the annotation of a given factor is to visualise the corresponding weights, 
using for example \code{\link{plot_weights}} or \code{\link{plot_top_weights}}. \cr
However, one might also be interested in visualising the direct relationship between features and factors, rather than looking at "abstract" weights. \cr
This function generates a heatmap for selected features, which should reveal the underlying pattern that is captured by the latent factor. \cr
A similar function for doing scatterplots rather than heatmaps is \code{\link{plot_data_scatter}}.
}
\examples{
# Using an existing trained model
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
plot_data_heatmap(model, factor = 1, show_rownames = FALSE, show_colnames = FALSE)
}
