
##############################################################################
#
# Copyright (c) 2003-2017 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

from __future__ import print_function, division

__copyright__="""Copyright (c) 2003-2017 by The University of Queensland
http://www.uq.edu.au
Primary Business: Queensland, Australia"""
__license__="""Licensed under the Apache License, version 2.0
http://www.apache.org/licenses/LICENSE-2.0"""
__url__="https://launchpad.net/escript-finley"

"""
Tests for interpolation on domains in the unit square/cube.

This file was auto-generated.
"""

import esys.escriptcore.utestselect as unittest
from esys.escript import *
import numpy

class Test_Util_Interpolation_noContact(unittest.TestCase):
    RES_TOL=1.e-8

    def test_interpolateC_onFunction_fromData_ContinuousFunction_rank0(self):
        """
        tests interpolation of rank 0 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.189625580297+0.361216087009j)*x[0]**o + ((-0.0476116922474+0.00391800873429j))*x[0] + ((0.98236241877-0.564222937815j))*x[1]**o + ((-0.229349253987-0.664506784588j))*x[1]
        ref=(-0.189625580297+0.361216087009j)*x_ref[0]**o + ((-0.0476116922474+0.00391800873429j))*x_ref[0] + ((0.98236241877-0.564222937815j))*x_ref[1]**o + ((-0.229349253987-0.664506784588j))*x_ref[1]
        if dim==3:
            arg+=((0.599750966654+0.291585131321j))*x[2]**o + ((-0.141763811987-0.816643592976j))*x[2]
            ref+=((0.599750966654+0.291585131321j))*x_ref[2]**o + ((-0.141763811987-0.816643592976j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ContinuousFunction_rank1(self):
        """
        tests interpolation of rank 1 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,),w_ref)
        arg[(0,)]=(-0.0618446671571-0.726938407432j)*x[0]**o + ((-0.33515760696+0.683097756922j))*x[0] + ((-0.816137994377-0.165179129953j))*x[1]**o + ((-0.932695349229+0.739187942617j))*x[1]
        ref[(0,)]=(-0.0618446671571-0.726938407432j)*x_ref[0]**o + ((-0.33515760696+0.683097756922j))*x_ref[0] + ((-0.816137994377-0.165179129953j))*x_ref[1]**o + ((-0.932695349229+0.739187942617j))*x_ref[1]
        arg[(1,)]=(-0.626967113316-0.796260518314j)*x[0]**o + ((-0.361325667473-0.138264110069j))*x[0] + ((-0.686581069921-0.691962361366j))*x[1]**o + ((-0.957546781819-0.0583443186696j))*x[1]
        ref[(1,)]=(-0.626967113316-0.796260518314j)*x_ref[0]**o + ((-0.361325667473-0.138264110069j))*x_ref[0] + ((-0.686581069921-0.691962361366j))*x_ref[1]**o + ((-0.957546781819-0.0583443186696j))*x_ref[1]
        arg[(2,)]=(0.72648702661-0.365322864969j)*x[0]**o + ((-0.808311225431+0.84045028031j))*x[0] + ((-0.792638592797-0.0639931408925j))*x[1]**o + ((0.954608036457+0.428003995906j))*x[1]
        ref[(2,)]=(0.72648702661-0.365322864969j)*x_ref[0]**o + ((-0.808311225431+0.84045028031j))*x_ref[0] + ((-0.792638592797-0.0639931408925j))*x_ref[1]**o + ((0.954608036457+0.428003995906j))*x_ref[1]
        arg[(3,)]=(0.450634382495-0.112738627314j)*x[0]**o + ((-0.751020647342+0.835887227921j))*x[0] + ((0.926026179724-0.0816511354564j))*x[1]**o + ((-0.155289135548+0.580502757913j))*x[1]
        ref[(3,)]=(0.450634382495-0.112738627314j)*x_ref[0]**o + ((-0.751020647342+0.835887227921j))*x_ref[0] + ((0.926026179724-0.0816511354564j))*x_ref[1]**o + ((-0.155289135548+0.580502757913j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(0.5325842815+0.401729375286j)*x[2]**o + ((0.0695760042965+0.328054853217j))*x[2]
            ref[(0,)]+=(0.5325842815+0.401729375286j)*x_ref[2]**o + ((0.0695760042965+0.328054853217j))*x_ref[2]
            arg[(1,)]+=(0.0210769773964+0.171108736948j)*x[2]**o + ((0.804228848131-0.303415361013j))*x[2]
            ref[(1,)]+=(0.0210769773964+0.171108736948j)*x_ref[2]**o + ((0.804228848131-0.303415361013j))*x_ref[2]
            arg[(2,)]+=(-0.367863986265+0.184793333699j)*x[2]**o + ((-0.740074861936+0.884197369108j))*x[2]
            ref[(2,)]+=(-0.367863986265+0.184793333699j)*x_ref[2]**o + ((-0.740074861936+0.884197369108j))*x_ref[2]
            arg[(3,)]+=(-0.657740759963+0.220178241986j)*x[2]**o + ((0.42402121892-0.852186509109j))*x[2]
            ref[(3,)]+=(-0.657740759963+0.220178241986j)*x_ref[2]**o + ((0.42402121892-0.852186509109j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ContinuousFunction_rank2(self):
        """
        tests interpolation of rank 2 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2),w_ref)
        arg[(0, 0)]=(-0.146866327912+0.313945712066j)*x[0]**o + ((-0.091058870998+0.156598930641j))*x[0] + ((-0.901225760031+0.302870487894j))*x[1]**o + ((-0.638016015001+0.127264707382j))*x[1]
        ref[(0, 0)]=(-0.146866327912+0.313945712066j)*x_ref[0]**o + ((-0.091058870998+0.156598930641j))*x_ref[0] + ((-0.901225760031+0.302870487894j))*x_ref[1]**o + ((-0.638016015001+0.127264707382j))*x_ref[1]
        arg[(0, 1)]=(-0.0435161877487+0.395136573305j)*x[0]**o + ((-0.97715793528+0.699195069328j))*x[0] + ((-0.0867635363436+0.354582345518j))*x[1]**o + ((-0.784568287346+0.515338987561j))*x[1]
        ref[(0, 1)]=(-0.0435161877487+0.395136573305j)*x_ref[0]**o + ((-0.97715793528+0.699195069328j))*x_ref[0] + ((-0.0867635363436+0.354582345518j))*x_ref[1]**o + ((-0.784568287346+0.515338987561j))*x_ref[1]
        arg[(1, 0)]=(-0.99365140645+0.183220895466j)*x[0]**o + ((-0.704722154302-0.737681298478j))*x[0] + ((0.982536994159+0.679722531672j))*x[1]**o + ((0.0836317897012-0.465373954323j))*x[1]
        ref[(1, 0)]=(-0.99365140645+0.183220895466j)*x_ref[0]**o + ((-0.704722154302-0.737681298478j))*x_ref[0] + ((0.982536994159+0.679722531672j))*x_ref[1]**o + ((0.0836317897012-0.465373954323j))*x_ref[1]
        arg[(1, 1)]=(0.0851002140156+0.814499635895j)*x[0]**o + ((-0.86564423205-0.429782764197j))*x[0] + ((-0.75212684569+0.226008321543j))*x[1]**o + ((-0.0858565684374-0.836862400829j))*x[1]
        ref[(1, 1)]=(0.0851002140156+0.814499635895j)*x_ref[0]**o + ((-0.86564423205-0.429782764197j))*x_ref[0] + ((-0.75212684569+0.226008321543j))*x_ref[1]**o + ((-0.0858565684374-0.836862400829j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(-0.405391250101+0.871177811717j)*x[2]**o + ((0.691286183226+0.0796615245385j))*x[2]
            ref[(0, 0)]+=(-0.405391250101+0.871177811717j)*x_ref[2]**o + ((0.691286183226+0.0796615245385j))*x_ref[2]
            arg[(0, 1)]+=(0.691222916568+0.707502072861j)*x[2]**o + ((0.890111189906-0.380861433169j))*x[2]
            ref[(0, 1)]+=(0.691222916568+0.707502072861j)*x_ref[2]**o + ((0.890111189906-0.380861433169j))*x_ref[2]
            arg[(1, 0)]+=(-0.369590578817+0.168582101947j)*x[2]**o + ((0.153582779597-0.929439609675j))*x[2]
            ref[(1, 0)]+=(-0.369590578817+0.168582101947j)*x_ref[2]**o + ((0.153582779597-0.929439609675j))*x_ref[2]
            arg[(1, 1)]+=(-0.597407189272+0.16376498267j)*x[2]**o + ((-0.827690080237-0.737197927469j))*x[2]
            ref[(1, 1)]+=(-0.597407189272+0.16376498267j)*x_ref[2]**o + ((-0.827690080237-0.737197927469j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ContinuousFunction_rank3(self):
        """
        tests interpolation of rank 3 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2, 4),w)
        ref = Data(0,(4, 2, 4),w_ref)
        arg[(0, 0, 0)]=(-0.356245851858+0.136902609671j)*x[0]**o + ((-0.695978256864-0.392429330318j))*x[0] + ((0.899656038024+0.976485455467j))*x[1]**o + ((-0.372000857991+0.0763618033716j))*x[1]
        ref[(0, 0, 0)]=(-0.356245851858+0.136902609671j)*x_ref[0]**o + ((-0.695978256864-0.392429330318j))*x_ref[0] + ((0.899656038024+0.976485455467j))*x_ref[1]**o + ((-0.372000857991+0.0763618033716j))*x_ref[1]
        arg[(0, 0, 1)]=(-0.143193549733+0.862804094316j)*x[0]**o + ((0.822022159598-0.427599265361j))*x[0] + ((0.642306232533+0.939720812231j))*x[1]**o + ((-0.695962173702-0.317830381106j))*x[1]
        ref[(0, 0, 1)]=(-0.143193549733+0.862804094316j)*x_ref[0]**o + ((0.822022159598-0.427599265361j))*x_ref[0] + ((0.642306232533+0.939720812231j))*x_ref[1]**o + ((-0.695962173702-0.317830381106j))*x_ref[1]
        arg[(0, 0, 2)]=(0.428752467167-0.0500302658491j)*x[0]**o + ((-0.806462208802+0.707029633225j))*x[0] + ((0.312027970374+0.472767557077j))*x[1]**o + ((0.942326621211-0.774407683228j))*x[1]
        ref[(0, 0, 2)]=(0.428752467167-0.0500302658491j)*x_ref[0]**o + ((-0.806462208802+0.707029633225j))*x_ref[0] + ((0.312027970374+0.472767557077j))*x_ref[1]**o + ((0.942326621211-0.774407683228j))*x_ref[1]
        arg[(0, 0, 3)]=(-0.301669467553+0.154001822272j)*x[0]**o + ((0.641018554239+0.6729837662j))*x[0] + ((-0.0771780013081+0.824999143233j))*x[1]**o + ((0.0420634017229-0.106252127035j))*x[1]
        ref[(0, 0, 3)]=(-0.301669467553+0.154001822272j)*x_ref[0]**o + ((0.641018554239+0.6729837662j))*x_ref[0] + ((-0.0771780013081+0.824999143233j))*x_ref[1]**o + ((0.0420634017229-0.106252127035j))*x_ref[1]
        arg[(0, 1, 0)]=(0.72752559449+0.0295024756512j)*x[0]**o + ((-0.448259317096+0.942552075176j))*x[0] + ((-0.684151539336+0.898251232472j))*x[1]**o + ((0.551596015245-0.24652392455j))*x[1]
        ref[(0, 1, 0)]=(0.72752559449+0.0295024756512j)*x_ref[0]**o + ((-0.448259317096+0.942552075176j))*x_ref[0] + ((-0.684151539336+0.898251232472j))*x_ref[1]**o + ((0.551596015245-0.24652392455j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.682456140271-0.800858308271j)*x[0]**o + ((0.0128434868894-0.617545407453j))*x[0] + ((0.65909150227-0.868708698141j))*x[1]**o + ((0.0572287472569-0.269432625082j))*x[1]
        ref[(0, 1, 1)]=(-0.682456140271-0.800858308271j)*x_ref[0]**o + ((0.0128434868894-0.617545407453j))*x_ref[0] + ((0.65909150227-0.868708698141j))*x_ref[1]**o + ((0.0572287472569-0.269432625082j))*x_ref[1]
        arg[(0, 1, 2)]=(0.408162421306+0.220938739503j)*x[0]**o + ((-0.732011977779-0.996086427354j))*x[0] + ((-0.575404056574+0.43201674029j))*x[1]**o + ((0.765675421855-0.296512759574j))*x[1]
        ref[(0, 1, 2)]=(0.408162421306+0.220938739503j)*x_ref[0]**o + ((-0.732011977779-0.996086427354j))*x_ref[0] + ((-0.575404056574+0.43201674029j))*x_ref[1]**o + ((0.765675421855-0.296512759574j))*x_ref[1]
        arg[(0, 1, 3)]=(0.527860881193-0.483894210364j)*x[0]**o + ((0.202497904465-0.257404282256j))*x[0] + ((-0.355139264527-0.974107693632j))*x[1]**o + ((-0.796062156813-0.636338218532j))*x[1]
        ref[(0, 1, 3)]=(0.527860881193-0.483894210364j)*x_ref[0]**o + ((0.202497904465-0.257404282256j))*x_ref[0] + ((-0.355139264527-0.974107693632j))*x_ref[1]**o + ((-0.796062156813-0.636338218532j))*x_ref[1]
        arg[(1, 0, 0)]=(0.691555894021+0.123021807158j)*x[0]**o + ((0.541038753818+0.389888130705j))*x[0] + ((0.422730537402+0.867595145633j))*x[1]**o + ((0.718766169201+0.380520548823j))*x[1]
        ref[(1, 0, 0)]=(0.691555894021+0.123021807158j)*x_ref[0]**o + ((0.541038753818+0.389888130705j))*x_ref[0] + ((0.422730537402+0.867595145633j))*x_ref[1]**o + ((0.718766169201+0.380520548823j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.277987974071-0.484273866838j)*x[0]**o + ((0.395810783266+0.502255387873j))*x[0] + ((0.972789807445-0.783557988924j))*x[1]**o + ((0.648573848772-0.265248263469j))*x[1]
        ref[(1, 0, 1)]=(-0.277987974071-0.484273866838j)*x_ref[0]**o + ((0.395810783266+0.502255387873j))*x_ref[0] + ((0.972789807445-0.783557988924j))*x_ref[1]**o + ((0.648573848772-0.265248263469j))*x_ref[1]
        arg[(1, 0, 2)]=(-0.336301033171-0.379136384682j)*x[0]**o + ((-0.585808617287-0.295202655894j))*x[0] + ((-0.710491962237-0.0715530695281j))*x[1]**o + ((-0.926257401833+0.677671778398j))*x[1]
        ref[(1, 0, 2)]=(-0.336301033171-0.379136384682j)*x_ref[0]**o + ((-0.585808617287-0.295202655894j))*x_ref[0] + ((-0.710491962237-0.0715530695281j))*x_ref[1]**o + ((-0.926257401833+0.677671778398j))*x_ref[1]
        arg[(1, 0, 3)]=(0.850868841162-0.580605618866j)*x[0]**o + ((0.965847210589+0.793471584633j))*x[0] + ((-0.920393993137+0.351752363316j))*x[1]**o + ((-0.0409905406465+0.286097865489j))*x[1]
        ref[(1, 0, 3)]=(0.850868841162-0.580605618866j)*x_ref[0]**o + ((0.965847210589+0.793471584633j))*x_ref[0] + ((-0.920393993137+0.351752363316j))*x_ref[1]**o + ((-0.0409905406465+0.286097865489j))*x_ref[1]
        arg[(1, 1, 0)]=(0.730899406586-0.681874594525j)*x[0]**o + ((-0.297831013113+0.35285774602j))*x[0] + ((0.729635005211-0.124114567274j))*x[1]**o + ((0.125047432869+0.651208738202j))*x[1]
        ref[(1, 1, 0)]=(0.730899406586-0.681874594525j)*x_ref[0]**o + ((-0.297831013113+0.35285774602j))*x_ref[0] + ((0.729635005211-0.124114567274j))*x_ref[1]**o + ((0.125047432869+0.651208738202j))*x_ref[1]
        arg[(1, 1, 1)]=(-0.50055107582-0.3132897016j)*x[0]**o + ((-0.0401470141443-0.789393520521j))*x[0] + ((-0.856191513333+0.63562625875j))*x[1]**o + ((-0.820629352774-0.190745515318j))*x[1]
        ref[(1, 1, 1)]=(-0.50055107582-0.3132897016j)*x_ref[0]**o + ((-0.0401470141443-0.789393520521j))*x_ref[0] + ((-0.856191513333+0.63562625875j))*x_ref[1]**o + ((-0.820629352774-0.190745515318j))*x_ref[1]
        arg[(1, 1, 2)]=(0.271416809213+0.550169460589j)*x[0]**o + ((0.465287208304+0.830585554201j))*x[0] + ((0.296535968019-0.761053252499j))*x[1]**o + ((0.430624373827-0.0133528340901j))*x[1]
        ref[(1, 1, 2)]=(0.271416809213+0.550169460589j)*x_ref[0]**o + ((0.465287208304+0.830585554201j))*x_ref[0] + ((0.296535968019-0.761053252499j))*x_ref[1]**o + ((0.430624373827-0.0133528340901j))*x_ref[1]
        arg[(1, 1, 3)]=(-0.415939766757-0.144938683887j)*x[0]**o + ((-0.16815155821-0.549474648277j))*x[0] + ((0.191845525852-0.93329972791j))*x[1]**o + ((0.359315185031-0.573379260849j))*x[1]
        ref[(1, 1, 3)]=(-0.415939766757-0.144938683887j)*x_ref[0]**o + ((-0.16815155821-0.549474648277j))*x_ref[0] + ((0.191845525852-0.93329972791j))*x_ref[1]**o + ((0.359315185031-0.573379260849j))*x_ref[1]
        arg[(2, 0, 0)]=(0.417250675377-0.536476091711j)*x[0]**o + ((-0.755156602987-0.32417234387j))*x[0] + ((0.413973942323-0.266278194437j))*x[1]**o + ((-0.779980766874-0.659124334983j))*x[1]
        ref[(2, 0, 0)]=(0.417250675377-0.536476091711j)*x_ref[0]**o + ((-0.755156602987-0.32417234387j))*x_ref[0] + ((0.413973942323-0.266278194437j))*x_ref[1]**o + ((-0.779980766874-0.659124334983j))*x_ref[1]
        arg[(2, 0, 1)]=(-0.72203776903+0.408227383373j)*x[0]**o + ((-0.707814918811-0.240375766288j))*x[0] + ((-0.282733408103+0.0427443611231j))*x[1]**o + ((-0.388118170856+0.252348137222j))*x[1]
        ref[(2, 0, 1)]=(-0.72203776903+0.408227383373j)*x_ref[0]**o + ((-0.707814918811-0.240375766288j))*x_ref[0] + ((-0.282733408103+0.0427443611231j))*x_ref[1]**o + ((-0.388118170856+0.252348137222j))*x_ref[1]
        arg[(2, 0, 2)]=(-0.193287465553+0.405278809953j)*x[0]**o + ((-0.882984282394-0.816233940792j))*x[0] + ((0.905708640302+0.86904455945j))*x[1]**o + ((-0.897291622625-0.714664654723j))*x[1]
        ref[(2, 0, 2)]=(-0.193287465553+0.405278809953j)*x_ref[0]**o + ((-0.882984282394-0.816233940792j))*x_ref[0] + ((0.905708640302+0.86904455945j))*x_ref[1]**o + ((-0.897291622625-0.714664654723j))*x_ref[1]
        arg[(2, 0, 3)]=(0.957858374174+0.389824837754j)*x[0]**o + ((0.242785933625-0.0252989644947j))*x[0] + ((0.31977777439+0.538862947234j))*x[1]**o + ((0.946032274234+0.810999548915j))*x[1]
        ref[(2, 0, 3)]=(0.957858374174+0.389824837754j)*x_ref[0]**o + ((0.242785933625-0.0252989644947j))*x_ref[0] + ((0.31977777439+0.538862947234j))*x_ref[1]**o + ((0.946032274234+0.810999548915j))*x_ref[1]
        arg[(2, 1, 0)]=(-0.429976110798-0.572191161042j)*x[0]**o + ((0.489584401724-0.649071694922j))*x[0] + ((0.574255152421+0.0166446113426j))*x[1]**o + ((-0.0814263805689-0.161359682045j))*x[1]
        ref[(2, 1, 0)]=(-0.429976110798-0.572191161042j)*x_ref[0]**o + ((0.489584401724-0.649071694922j))*x_ref[0] + ((0.574255152421+0.0166446113426j))*x_ref[1]**o + ((-0.0814263805689-0.161359682045j))*x_ref[1]
        arg[(2, 1, 1)]=(-0.982898818281-0.854825047241j)*x[0]**o + ((0.951033881993-0.966662924321j))*x[0] + ((-0.606142266183-0.243784350306j))*x[1]**o + ((-0.973845270734-0.37301796735j))*x[1]
        ref[(2, 1, 1)]=(-0.982898818281-0.854825047241j)*x_ref[0]**o + ((0.951033881993-0.966662924321j))*x_ref[0] + ((-0.606142266183-0.243784350306j))*x_ref[1]**o + ((-0.973845270734-0.37301796735j))*x_ref[1]
        arg[(2, 1, 2)]=(-0.0231190535953-0.536419540809j)*x[0]**o + ((0.644955346821+0.569339932436j))*x[0] + ((0.509783151209-0.384623120759j))*x[1]**o + ((0.420119484196+0.0110721910033j))*x[1]
        ref[(2, 1, 2)]=(-0.0231190535953-0.536419540809j)*x_ref[0]**o + ((0.644955346821+0.569339932436j))*x_ref[0] + ((0.509783151209-0.384623120759j))*x_ref[1]**o + ((0.420119484196+0.0110721910033j))*x_ref[1]
        arg[(2, 1, 3)]=(0.248649217589-0.932635999558j)*x[0]**o + ((-0.436959244535+0.784919762159j))*x[0] + ((0.688528759372-0.564962395493j))*x[1]**o + ((-0.0527171258177-0.162698751114j))*x[1]
        ref[(2, 1, 3)]=(0.248649217589-0.932635999558j)*x_ref[0]**o + ((-0.436959244535+0.784919762159j))*x_ref[0] + ((0.688528759372-0.564962395493j))*x_ref[1]**o + ((-0.0527171258177-0.162698751114j))*x_ref[1]
        arg[(3, 0, 0)]=(0.893675341844+0.325161852564j)*x[0]**o + ((0.338143953765+0.0966013375988j))*x[0] + ((-0.312241770923+0.667687842007j))*x[1]**o + ((-0.462479743428+0.986589423929j))*x[1]
        ref[(3, 0, 0)]=(0.893675341844+0.325161852564j)*x_ref[0]**o + ((0.338143953765+0.0966013375988j))*x_ref[0] + ((-0.312241770923+0.667687842007j))*x_ref[1]**o + ((-0.462479743428+0.986589423929j))*x_ref[1]
        arg[(3, 0, 1)]=(0.53710911915+0.544078928707j)*x[0]**o + ((0.222732430627+0.361780506396j))*x[0] + ((-0.176096186969-0.575174940456j))*x[1]**o + ((0.723502384009+0.380698414678j))*x[1]
        ref[(3, 0, 1)]=(0.53710911915+0.544078928707j)*x_ref[0]**o + ((0.222732430627+0.361780506396j))*x_ref[0] + ((-0.176096186969-0.575174940456j))*x_ref[1]**o + ((0.723502384009+0.380698414678j))*x_ref[1]
        arg[(3, 0, 2)]=(0.808537661056+0.158683181014j)*x[0]**o + ((-0.239876935469-0.0649393658006j))*x[0] + ((-0.603669208657-0.0959793148167j))*x[1]**o + ((0.418924724545-0.368636933909j))*x[1]
        ref[(3, 0, 2)]=(0.808537661056+0.158683181014j)*x_ref[0]**o + ((-0.239876935469-0.0649393658006j))*x_ref[0] + ((-0.603669208657-0.0959793148167j))*x_ref[1]**o + ((0.418924724545-0.368636933909j))*x_ref[1]
        arg[(3, 0, 3)]=(-0.000486194723323-0.695544300801j)*x[0]**o + ((-0.0905661036466-0.686603624296j))*x[0] + ((-0.468071017566+0.518956888717j))*x[1]**o + ((-0.456781600632+0.506218524472j))*x[1]
        ref[(3, 0, 3)]=(-0.000486194723323-0.695544300801j)*x_ref[0]**o + ((-0.0905661036466-0.686603624296j))*x_ref[0] + ((-0.468071017566+0.518956888717j))*x_ref[1]**o + ((-0.456781600632+0.506218524472j))*x_ref[1]
        arg[(3, 1, 0)]=(-0.658802334925+0.849162870711j)*x[0]**o + ((0.799056098579+0.400030808999j))*x[0] + ((0.136581443842+0.462612153223j))*x[1]**o + ((-0.820213453718-0.39376942722j))*x[1]
        ref[(3, 1, 0)]=(-0.658802334925+0.849162870711j)*x_ref[0]**o + ((0.799056098579+0.400030808999j))*x_ref[0] + ((0.136581443842+0.462612153223j))*x_ref[1]**o + ((-0.820213453718-0.39376942722j))*x_ref[1]
        arg[(3, 1, 1)]=(0.872084305416+0.591539000792j)*x[0]**o + ((-0.0815085503048+0.356850146417j))*x[0] + ((-0.0785594225142+0.877092610643j))*x[1]**o + ((-0.755354153363+0.693517633706j))*x[1]
        ref[(3, 1, 1)]=(0.872084305416+0.591539000792j)*x_ref[0]**o + ((-0.0815085503048+0.356850146417j))*x_ref[0] + ((-0.0785594225142+0.877092610643j))*x_ref[1]**o + ((-0.755354153363+0.693517633706j))*x_ref[1]
        arg[(3, 1, 2)]=(0.123504494013-0.747186500211j)*x[0]**o + ((0.136435592334-0.522483238565j))*x[0] + ((-0.812901442877+0.712361200993j))*x[1]**o + ((0.230410704059-0.461515038916j))*x[1]
        ref[(3, 1, 2)]=(0.123504494013-0.747186500211j)*x_ref[0]**o + ((0.136435592334-0.522483238565j))*x_ref[0] + ((-0.812901442877+0.712361200993j))*x_ref[1]**o + ((0.230410704059-0.461515038916j))*x_ref[1]
        arg[(3, 1, 3)]=(-0.0523659359198-0.821255250153j)*x[0]**o + ((0.277815911649+0.569993359225j))*x[0] + ((0.775861008416-0.61098679754j))*x[1]**o + ((0.283021386965-0.606476804516j))*x[1]
        ref[(3, 1, 3)]=(-0.0523659359198-0.821255250153j)*x_ref[0]**o + ((0.277815911649+0.569993359225j))*x_ref[0] + ((0.775861008416-0.61098679754j))*x_ref[1]**o + ((0.283021386965-0.606476804516j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.625145040135-0.44312825466j)*x[2]**o + ((-0.736132149101-0.240511449337j))*x[2]
            ref[(0, 0, 0)]+=(-0.625145040135-0.44312825466j)*x_ref[2]**o + ((-0.736132149101-0.240511449337j))*x_ref[2]
            arg[(0, 0, 1)]+=(0.494951833979+0.629192308364j)*x[2]**o + ((0.730334152158-0.82596679165j))*x[2]
            ref[(0, 0, 1)]+=(0.494951833979+0.629192308364j)*x_ref[2]**o + ((0.730334152158-0.82596679165j))*x_ref[2]
            arg[(0, 0, 2)]+=(-0.158767129762-0.765624171447j)*x[2]**o + ((-0.815958919468+0.529122863448j))*x[2]
            ref[(0, 0, 2)]+=(-0.158767129762-0.765624171447j)*x_ref[2]**o + ((-0.815958919468+0.529122863448j))*x_ref[2]
            arg[(0, 0, 3)]+=(-0.469791628308-0.337154846388j)*x[2]**o + ((-0.965721928006+0.310529989768j))*x[2]
            ref[(0, 0, 3)]+=(-0.469791628308-0.337154846388j)*x_ref[2]**o + ((-0.965721928006+0.310529989768j))*x_ref[2]
            arg[(0, 1, 0)]+=(-0.0736346341166+0.544138990209j)*x[2]**o + ((0.095273786179+0.740366736734j))*x[2]
            ref[(0, 1, 0)]+=(-0.0736346341166+0.544138990209j)*x_ref[2]**o + ((0.095273786179+0.740366736734j))*x_ref[2]
            arg[(0, 1, 1)]+=(0.451084117885+0.450956612471j)*x[2]**o + ((0.163434712359-0.156487717798j))*x[2]
            ref[(0, 1, 1)]+=(0.451084117885+0.450956612471j)*x_ref[2]**o + ((0.163434712359-0.156487717798j))*x_ref[2]
            arg[(0, 1, 2)]+=(0.304771717952+0.221620390829j)*x[2]**o + ((0.488659789929-0.230518662473j))*x[2]
            ref[(0, 1, 2)]+=(0.304771717952+0.221620390829j)*x_ref[2]**o + ((0.488659789929-0.230518662473j))*x_ref[2]
            arg[(0, 1, 3)]+=(-0.528909329679+0.271871076555j)*x[2]**o + ((0.234032707295+0.659980256863j))*x[2]
            ref[(0, 1, 3)]+=(-0.528909329679+0.271871076555j)*x_ref[2]**o + ((0.234032707295+0.659980256863j))*x_ref[2]
            arg[(1, 0, 0)]+=(-0.220639026223+0.0311900862058j)*x[2]**o + ((-0.441924303608+0.875931873237j))*x[2]
            ref[(1, 0, 0)]+=(-0.220639026223+0.0311900862058j)*x_ref[2]**o + ((-0.441924303608+0.875931873237j))*x_ref[2]
            arg[(1, 0, 1)]+=(-0.358724855379-0.637057554658j)*x[2]**o + ((-0.78475256462+0.949929171663j))*x[2]
            ref[(1, 0, 1)]+=(-0.358724855379-0.637057554658j)*x_ref[2]**o + ((-0.78475256462+0.949929171663j))*x_ref[2]
            arg[(1, 0, 2)]+=(0.565904372819+0.704679432955j)*x[2]**o + ((-0.458392306139+0.72964405793j))*x[2]
            ref[(1, 0, 2)]+=(0.565904372819+0.704679432955j)*x_ref[2]**o + ((-0.458392306139+0.72964405793j))*x_ref[2]
            arg[(1, 0, 3)]+=(0.143706580149-0.858500580248j)*x[2]**o + ((-0.135949602683-0.824812901942j))*x[2]
            ref[(1, 0, 3)]+=(0.143706580149-0.858500580248j)*x_ref[2]**o + ((-0.135949602683-0.824812901942j))*x_ref[2]
            arg[(1, 1, 0)]+=(0.312162763863+0.0546571116061j)*x[2]**o + ((0.0935365476569-0.292524697047j))*x[2]
            ref[(1, 1, 0)]+=(0.312162763863+0.0546571116061j)*x_ref[2]**o + ((0.0935365476569-0.292524697047j))*x_ref[2]
            arg[(1, 1, 1)]+=(0.176257962579-0.800402207679j)*x[2]**o + ((0.0318200968511-0.591982729239j))*x[2]
            ref[(1, 1, 1)]+=(0.176257962579-0.800402207679j)*x_ref[2]**o + ((0.0318200968511-0.591982729239j))*x_ref[2]
            arg[(1, 1, 2)]+=(-0.272286493724-0.43853575527j)*x[2]**o + ((-0.867244914368-0.249432268267j))*x[2]
            ref[(1, 1, 2)]+=(-0.272286493724-0.43853575527j)*x_ref[2]**o + ((-0.867244914368-0.249432268267j))*x_ref[2]
            arg[(1, 1, 3)]+=(-0.403421216027+0.515692776908j)*x[2]**o + ((-0.575258466528+0.92697690415j))*x[2]
            ref[(1, 1, 3)]+=(-0.403421216027+0.515692776908j)*x_ref[2]**o + ((-0.575258466528+0.92697690415j))*x_ref[2]
            arg[(2, 0, 0)]+=(0.00560935110148-0.648140037588j)*x[2]**o + ((0.454473455946-0.855093919501j))*x[2]
            ref[(2, 0, 0)]+=(0.00560935110148-0.648140037588j)*x_ref[2]**o + ((0.454473455946-0.855093919501j))*x_ref[2]
            arg[(2, 0, 1)]+=(0.991825799504+0.972058164919j)*x[2]**o + ((0.157736350978-0.463460924479j))*x[2]
            ref[(2, 0, 1)]+=(0.991825799504+0.972058164919j)*x_ref[2]**o + ((0.157736350978-0.463460924479j))*x_ref[2]
            arg[(2, 0, 2)]+=(0.382241935531-0.643160609874j)*x[2]**o + ((-0.209628603188+0.126494019659j))*x[2]
            ref[(2, 0, 2)]+=(0.382241935531-0.643160609874j)*x_ref[2]**o + ((-0.209628603188+0.126494019659j))*x_ref[2]
            arg[(2, 0, 3)]+=(0.246565779774-0.783297370118j)*x[2]**o + ((-0.297551799207+0.161615055904j))*x[2]
            ref[(2, 0, 3)]+=(0.246565779774-0.783297370118j)*x_ref[2]**o + ((-0.297551799207+0.161615055904j))*x_ref[2]
            arg[(2, 1, 0)]+=(-0.0546919094336-0.141684719379j)*x[2]**o + ((-0.845996137078-0.538194955448j))*x[2]
            ref[(2, 1, 0)]+=(-0.0546919094336-0.141684719379j)*x_ref[2]**o + ((-0.845996137078-0.538194955448j))*x_ref[2]
            arg[(2, 1, 1)]+=(0.695844880496+0.871251793739j)*x[2]**o + ((0.268574465013-0.933733090412j))*x[2]
            ref[(2, 1, 1)]+=(0.695844880496+0.871251793739j)*x_ref[2]**o + ((0.268574465013-0.933733090412j))*x_ref[2]
            arg[(2, 1, 2)]+=(-0.197846305669-0.395117705101j)*x[2]**o + ((-0.299164764691+0.63485157644j))*x[2]
            ref[(2, 1, 2)]+=(-0.197846305669-0.395117705101j)*x_ref[2]**o + ((-0.299164764691+0.63485157644j))*x_ref[2]
            arg[(2, 1, 3)]+=(-0.814489194322+0.95513149791j)*x[2]**o + ((-0.0267355497747+0.637087538471j))*x[2]
            ref[(2, 1, 3)]+=(-0.814489194322+0.95513149791j)*x_ref[2]**o + ((-0.0267355497747+0.637087538471j))*x_ref[2]
            arg[(3, 0, 0)]+=(-0.385376972885+0.375930436093j)*x[2]**o + ((-0.523848627658+0.557609290311j))*x[2]
            ref[(3, 0, 0)]+=(-0.385376972885+0.375930436093j)*x_ref[2]**o + ((-0.523848627658+0.557609290311j))*x_ref[2]
            arg[(3, 0, 1)]+=(-0.958037615264-0.976863997605j)*x[2]**o + ((0.292745069001-0.321045723284j))*x[2]
            ref[(3, 0, 1)]+=(-0.958037615264-0.976863997605j)*x_ref[2]**o + ((0.292745069001-0.321045723284j))*x_ref[2]
            arg[(3, 0, 2)]+=(-0.744904228289+0.6221780442j)*x[2]**o + ((0.304545181902+0.273333166667j))*x[2]
            ref[(3, 0, 2)]+=(-0.744904228289+0.6221780442j)*x_ref[2]**o + ((0.304545181902+0.273333166667j))*x_ref[2]
            arg[(3, 0, 3)]+=(0.320985007603-0.328758618303j)*x[2]**o + ((0.291427853671-0.306435066353j))*x[2]
            ref[(3, 0, 3)]+=(0.320985007603-0.328758618303j)*x_ref[2]**o + ((0.291427853671-0.306435066353j))*x_ref[2]
            arg[(3, 1, 0)]+=(0.540192513873+0.0561342929962j)*x[2]**o + ((0.0704361833313-0.20292093524j))*x[2]
            ref[(3, 1, 0)]+=(0.540192513873+0.0561342929962j)*x_ref[2]**o + ((0.0704361833313-0.20292093524j))*x_ref[2]
            arg[(3, 1, 1)]+=(-0.637571234274+0.289911795347j)*x[2]**o + ((0.146381368233-0.954590949695j))*x[2]
            ref[(3, 1, 1)]+=(-0.637571234274+0.289911795347j)*x_ref[2]**o + ((0.146381368233-0.954590949695j))*x_ref[2]
            arg[(3, 1, 2)]+=(-0.362681248718+0.948439692186j)*x[2]**o + ((0.598375416358-0.644351012055j))*x[2]
            ref[(3, 1, 2)]+=(-0.362681248718+0.948439692186j)*x_ref[2]**o + ((0.598375416358-0.644351012055j))*x_ref[2]
            arg[(3, 1, 3)]+=(0.423629803506-0.612233105228j)*x[2]**o + ((-0.340619569016+0.89080475264j))*x[2]
            ref[(3, 1, 3)]+=(0.423629803506-0.612233105228j)*x_ref[2]**o + ((-0.340619569016+0.89080475264j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 2, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ContinuousFunction_rank4(self):
        """
        tests interpolation of rank 4 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 2, 2),w)
        ref = Data(0,(3, 4, 2, 2),w_ref)
        arg[(0, 0, 0, 0)]=(0.400910094117-0.755603590897j)*x[0]**o + ((-0.749748964106+0.380424167862j))*x[0] + ((-0.856468672854+0.269761796621j))*x[1]**o + ((0.314116293166-0.0609172595618j))*x[1]
        ref[(0, 0, 0, 0)]=(0.400910094117-0.755603590897j)*x_ref[0]**o + ((-0.749748964106+0.380424167862j))*x_ref[0] + ((-0.856468672854+0.269761796621j))*x_ref[1]**o + ((0.314116293166-0.0609172595618j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(0.221969775416+0.652596260602j)*x[0]**o + ((-0.817189511455+0.28214149764j))*x[0] + ((-0.963321809549+0.0604550413082j))*x[1]**o + ((0.724007315464+0.532852524764j))*x[1]
        ref[(0, 0, 0, 1)]=(0.221969775416+0.652596260602j)*x_ref[0]**o + ((-0.817189511455+0.28214149764j))*x_ref[0] + ((-0.963321809549+0.0604550413082j))*x_ref[1]**o + ((0.724007315464+0.532852524764j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(-0.728410848882+0.290360105147j)*x[0]**o + ((-0.739722633666+0.591418583118j))*x[0] + ((0.923155135199-0.455688815128j))*x[1]**o + ((-0.60650836073+0.0621925394518j))*x[1]
        ref[(0, 0, 1, 0)]=(-0.728410848882+0.290360105147j)*x_ref[0]**o + ((-0.739722633666+0.591418583118j))*x_ref[0] + ((0.923155135199-0.455688815128j))*x_ref[1]**o + ((-0.60650836073+0.0621925394518j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.588291314788+0.787743018167j)*x[0]**o + ((-0.141626681622+0.640451593018j))*x[0] + ((-0.779128277872-0.185982257745j))*x[1]**o + ((0.289056266058+0.523039824368j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.588291314788+0.787743018167j)*x_ref[0]**o + ((-0.141626681622+0.640451593018j))*x_ref[0] + ((-0.779128277872-0.185982257745j))*x_ref[1]**o + ((0.289056266058+0.523039824368j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.804186889572+0.0863727034434j)*x[0]**o + ((0.741954277485+0.900401491778j))*x[0] + ((-0.125532610348+0.605459908741j))*x[1]**o + ((-0.386196078583+0.89729734019j))*x[1]
        ref[(0, 1, 0, 0)]=(0.804186889572+0.0863727034434j)*x_ref[0]**o + ((0.741954277485+0.900401491778j))*x_ref[0] + ((-0.125532610348+0.605459908741j))*x_ref[1]**o + ((-0.386196078583+0.89729734019j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(-0.449199917072-0.1802601559j)*x[0]**o + ((-0.0682638278312+0.509543955211j))*x[0] + ((-0.499566399435+0.880125708668j))*x[1]**o + ((0.732987820758-0.465614121226j))*x[1]
        ref[(0, 1, 0, 1)]=(-0.449199917072-0.1802601559j)*x_ref[0]**o + ((-0.0682638278312+0.509543955211j))*x_ref[0] + ((-0.499566399435+0.880125708668j))*x_ref[1]**o + ((0.732987820758-0.465614121226j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.833183980494+0.275102196499j)*x[0]**o + ((-0.309324140387+0.173583031647j))*x[0] + ((-0.1345022837-0.0368535295875j))*x[1]**o + ((0.0416211019992-0.844066342366j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.833183980494+0.275102196499j)*x_ref[0]**o + ((-0.309324140387+0.173583031647j))*x_ref[0] + ((-0.1345022837-0.0368535295875j))*x_ref[1]**o + ((0.0416211019992-0.844066342366j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(0.822412428623-0.776770548243j)*x[0]**o + ((0.273718525272-0.215586028686j))*x[0] + ((-0.462728270189+0.132881079021j))*x[1]**o + ((0.248126931923-0.077120745774j))*x[1]
        ref[(0, 1, 1, 1)]=(0.822412428623-0.776770548243j)*x_ref[0]**o + ((0.273718525272-0.215586028686j))*x_ref[0] + ((-0.462728270189+0.132881079021j))*x_ref[1]**o + ((0.248126931923-0.077120745774j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(-0.559445128559+0.665975108244j)*x[0]**o + ((0.888523076484-0.775409222369j))*x[0] + ((-0.0689742233539-0.167959530386j))*x[1]**o + ((-0.790281763117+0.429626589238j))*x[1]
        ref[(0, 2, 0, 0)]=(-0.559445128559+0.665975108244j)*x_ref[0]**o + ((0.888523076484-0.775409222369j))*x_ref[0] + ((-0.0689742233539-0.167959530386j))*x_ref[1]**o + ((-0.790281763117+0.429626589238j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(0.699329796832-0.48266106024j)*x[0]**o + ((-0.532830287761+0.785013013824j))*x[0] + ((-0.995889560252-0.643241009778j))*x[1]**o + ((0.197829170041+0.882637297547j))*x[1]
        ref[(0, 2, 0, 1)]=(0.699329796832-0.48266106024j)*x_ref[0]**o + ((-0.532830287761+0.785013013824j))*x_ref[0] + ((-0.995889560252-0.643241009778j))*x_ref[1]**o + ((0.197829170041+0.882637297547j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(-0.447831484988-0.249091401695j)*x[0]**o + ((-0.153146346418-0.406861198016j))*x[0] + ((-0.247520418847-0.535695083613j))*x[1]**o + ((0.709754920098-0.276577440644j))*x[1]
        ref[(0, 2, 1, 0)]=(-0.447831484988-0.249091401695j)*x_ref[0]**o + ((-0.153146346418-0.406861198016j))*x_ref[0] + ((-0.247520418847-0.535695083613j))*x_ref[1]**o + ((0.709754920098-0.276577440644j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(-0.956272411697+0.0635268191803j)*x[0]**o + ((0.726547814057+0.942618169094j))*x[0] + ((0.170981031276-0.751969338546j))*x[1]**o + ((-0.781289031835+0.316151023402j))*x[1]
        ref[(0, 2, 1, 1)]=(-0.956272411697+0.0635268191803j)*x_ref[0]**o + ((0.726547814057+0.942618169094j))*x_ref[0] + ((0.170981031276-0.751969338546j))*x_ref[1]**o + ((-0.781289031835+0.316151023402j))*x_ref[1]
        arg[(0, 3, 0, 0)]=(0.342548312763+0.885005665756j)*x[0]**o + ((0.719249185996+0.120593565903j))*x[0] + ((-0.997147485825+0.197625890995j))*x[1]**o + ((-0.391415811862-0.687006549588j))*x[1]
        ref[(0, 3, 0, 0)]=(0.342548312763+0.885005665756j)*x_ref[0]**o + ((0.719249185996+0.120593565903j))*x_ref[0] + ((-0.997147485825+0.197625890995j))*x_ref[1]**o + ((-0.391415811862-0.687006549588j))*x_ref[1]
        arg[(0, 3, 0, 1)]=(-0.305418059964+0.253077589715j)*x[0]**o + ((-0.474690638456-0.779154037276j))*x[0] + ((0.368175887859-0.822764939084j))*x[1]**o + ((0.043465416009-0.739377165323j))*x[1]
        ref[(0, 3, 0, 1)]=(-0.305418059964+0.253077589715j)*x_ref[0]**o + ((-0.474690638456-0.779154037276j))*x_ref[0] + ((0.368175887859-0.822764939084j))*x_ref[1]**o + ((0.043465416009-0.739377165323j))*x_ref[1]
        arg[(0, 3, 1, 0)]=(0.17618516497+0.969764906706j)*x[0]**o + ((0.0919577289718+0.202331685338j))*x[0] + ((-0.71624960517-0.467281027924j))*x[1]**o + ((0.454587945692+0.923607563261j))*x[1]
        ref[(0, 3, 1, 0)]=(0.17618516497+0.969764906706j)*x_ref[0]**o + ((0.0919577289718+0.202331685338j))*x_ref[0] + ((-0.71624960517-0.467281027924j))*x_ref[1]**o + ((0.454587945692+0.923607563261j))*x_ref[1]
        arg[(0, 3, 1, 1)]=(-0.704304862528+0.226173036172j)*x[0]**o + ((0.902737483067-0.385959636828j))*x[0] + ((0.21871842659+0.371250023918j))*x[1]**o + ((-0.71764414333-0.44542981289j))*x[1]
        ref[(0, 3, 1, 1)]=(-0.704304862528+0.226173036172j)*x_ref[0]**o + ((0.902737483067-0.385959636828j))*x_ref[0] + ((0.21871842659+0.371250023918j))*x_ref[1]**o + ((-0.71764414333-0.44542981289j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.0877547650439-0.341365014575j)*x[0]**o + ((-0.803203709368-0.96447344994j))*x[0] + ((-0.896579365233-0.0728865512422j))*x[1]**o + ((0.87027257873-0.632193642513j))*x[1]
        ref[(1, 0, 0, 0)]=(0.0877547650439-0.341365014575j)*x_ref[0]**o + ((-0.803203709368-0.96447344994j))*x_ref[0] + ((-0.896579365233-0.0728865512422j))*x_ref[1]**o + ((0.87027257873-0.632193642513j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.103183345515+0.716002196958j)*x[0]**o + ((0.290850531792+0.112548000347j))*x[0] + ((-0.723954445749+0.00214307459462j))*x[1]**o + ((0.887368455277+0.555404176589j))*x[1]
        ref[(1, 0, 0, 1)]=(0.103183345515+0.716002196958j)*x_ref[0]**o + ((0.290850531792+0.112548000347j))*x_ref[0] + ((-0.723954445749+0.00214307459462j))*x_ref[1]**o + ((0.887368455277+0.555404176589j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.77492666812+0.405999401901j)*x[0]**o + ((0.218662604932-0.891234458884j))*x[0] + ((-0.6394894636-0.838468113905j))*x[1]**o + ((0.920576810662-0.351716420228j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.77492666812+0.405999401901j)*x_ref[0]**o + ((0.218662604932-0.891234458884j))*x_ref[0] + ((-0.6394894636-0.838468113905j))*x_ref[1]**o + ((0.920576810662-0.351716420228j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(0.848723231104-0.269754441071j)*x[0]**o + ((0.576311541195+0.451487410665j))*x[0] + ((-0.882648312829-0.154607537394j))*x[1]**o + ((0.312308869053+0.0275948675954j))*x[1]
        ref[(1, 0, 1, 1)]=(0.848723231104-0.269754441071j)*x_ref[0]**o + ((0.576311541195+0.451487410665j))*x_ref[0] + ((-0.882648312829-0.154607537394j))*x_ref[1]**o + ((0.312308869053+0.0275948675954j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(-0.303455969237-0.930929254087j)*x[0]**o + ((-0.0850282772184+0.328535116887j))*x[0] + ((0.0904672487414+0.853814529892j))*x[1]**o + ((0.221367060727+0.644390613059j))*x[1]
        ref[(1, 1, 0, 0)]=(-0.303455969237-0.930929254087j)*x_ref[0]**o + ((-0.0850282772184+0.328535116887j))*x_ref[0] + ((0.0904672487414+0.853814529892j))*x_ref[1]**o + ((0.221367060727+0.644390613059j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(-0.740261834432+0.725828305568j)*x[0]**o + ((0.814632227496-0.727037270726j))*x[0] + ((0.270431026762+0.582176681323j))*x[1]**o + ((-0.947035077221+0.765913140778j))*x[1]
        ref[(1, 1, 0, 1)]=(-0.740261834432+0.725828305568j)*x_ref[0]**o + ((0.814632227496-0.727037270726j))*x_ref[0] + ((0.270431026762+0.582176681323j))*x_ref[1]**o + ((-0.947035077221+0.765913140778j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(-0.851981716793-0.217674760951j)*x[0]**o + ((-0.348765225271-0.673210902943j))*x[0] + ((0.864819861085-0.150696566437j))*x[1]**o + ((0.702276706931-0.431454810992j))*x[1]
        ref[(1, 1, 1, 0)]=(-0.851981716793-0.217674760951j)*x_ref[0]**o + ((-0.348765225271-0.673210902943j))*x_ref[0] + ((0.864819861085-0.150696566437j))*x_ref[1]**o + ((0.702276706931-0.431454810992j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.77170947879-0.920808469895j)*x[0]**o + ((0.26268951482+0.815519407881j))*x[0] + ((0.603778142348-0.9370808498j))*x[1]**o + ((0.863297876064-0.464874519376j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.77170947879-0.920808469895j)*x_ref[0]**o + ((0.26268951482+0.815519407881j))*x_ref[0] + ((0.603778142348-0.9370808498j))*x_ref[1]**o + ((0.863297876064-0.464874519376j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(0.563130853193+0.22486163049j)*x[0]**o + ((-0.800491163004-0.355556915398j))*x[0] + ((0.418426801033-0.0245133279868j))*x[1]**o + ((0.114098442858-0.848242711065j))*x[1]
        ref[(1, 2, 0, 0)]=(0.563130853193+0.22486163049j)*x_ref[0]**o + ((-0.800491163004-0.355556915398j))*x_ref[0] + ((0.418426801033-0.0245133279868j))*x_ref[1]**o + ((0.114098442858-0.848242711065j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(0.312943147169-0.967276593722j)*x[0]**o + ((0.344395730475-0.832076562454j))*x[0] + ((-0.828605169277-0.0925613232536j))*x[1]**o + ((-0.464287808955+0.190330033908j))*x[1]
        ref[(1, 2, 0, 1)]=(0.312943147169-0.967276593722j)*x_ref[0]**o + ((0.344395730475-0.832076562454j))*x_ref[0] + ((-0.828605169277-0.0925613232536j))*x_ref[1]**o + ((-0.464287808955+0.190330033908j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(0.743701785782+0.667339547477j)*x[0]**o + ((-0.924826177095-0.99640149724j))*x[0] + ((0.210266636436+0.270305670366j))*x[1]**o + ((-0.835036427691-0.0281267595902j))*x[1]
        ref[(1, 2, 1, 0)]=(0.743701785782+0.667339547477j)*x_ref[0]**o + ((-0.924826177095-0.99640149724j))*x_ref[0] + ((0.210266636436+0.270305670366j))*x_ref[1]**o + ((-0.835036427691-0.0281267595902j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(0.965832136838+0.0426760024322j)*x[0]**o + ((-0.775971195026+0.87773447516j))*x[0] + ((0.482217874552+0.0579732695875j))*x[1]**o + ((-0.830451006681+0.194918600841j))*x[1]
        ref[(1, 2, 1, 1)]=(0.965832136838+0.0426760024322j)*x_ref[0]**o + ((-0.775971195026+0.87773447516j))*x_ref[0] + ((0.482217874552+0.0579732695875j))*x_ref[1]**o + ((-0.830451006681+0.194918600841j))*x_ref[1]
        arg[(1, 3, 0, 0)]=(0.616660957287+0.804002417251j)*x[0]**o + ((-0.054416182167-0.239664107582j))*x[0] + ((-0.752069351341+0.585655316016j))*x[1]**o + ((-0.395437864192-0.153527752667j))*x[1]
        ref[(1, 3, 0, 0)]=(0.616660957287+0.804002417251j)*x_ref[0]**o + ((-0.054416182167-0.239664107582j))*x_ref[0] + ((-0.752069351341+0.585655316016j))*x_ref[1]**o + ((-0.395437864192-0.153527752667j))*x_ref[1]
        arg[(1, 3, 0, 1)]=(-0.381185611834-0.178329397887j)*x[0]**o + ((-0.316299612023-0.354621675856j))*x[0] + ((-0.769633262048+0.339207879546j))*x[1]**o + ((-0.613620481024+0.0600544482648j))*x[1]
        ref[(1, 3, 0, 1)]=(-0.381185611834-0.178329397887j)*x_ref[0]**o + ((-0.316299612023-0.354621675856j))*x_ref[0] + ((-0.769633262048+0.339207879546j))*x_ref[1]**o + ((-0.613620481024+0.0600544482648j))*x_ref[1]
        arg[(1, 3, 1, 0)]=(-0.91724889886-0.569766366149j)*x[0]**o + ((-0.11158013131+0.775977181746j))*x[0] + ((0.518357501912+0.507932066287j))*x[1]**o + ((-0.454836974951-0.777732633891j))*x[1]
        ref[(1, 3, 1, 0)]=(-0.91724889886-0.569766366149j)*x_ref[0]**o + ((-0.11158013131+0.775977181746j))*x_ref[0] + ((0.518357501912+0.507932066287j))*x_ref[1]**o + ((-0.454836974951-0.777732633891j))*x_ref[1]
        arg[(1, 3, 1, 1)]=(0.502798779481+0.171215618801j)*x[0]**o + ((-0.473705820209+0.983198399768j))*x[0] + ((0.259923965882+0.907606387454j))*x[1]**o + ((-0.843213674522+0.970645034409j))*x[1]
        ref[(1, 3, 1, 1)]=(0.502798779481+0.171215618801j)*x_ref[0]**o + ((-0.473705820209+0.983198399768j))*x_ref[0] + ((0.259923965882+0.907606387454j))*x_ref[1]**o + ((-0.843213674522+0.970645034409j))*x_ref[1]
        arg[(2, 0, 0, 0)]=(-0.0881031287571+0.0324514816002j)*x[0]**o + ((0.111677260287+0.690320349934j))*x[0] + ((0.202182112529-0.452955966698j))*x[1]**o + ((-0.372841043276+0.570148676542j))*x[1]
        ref[(2, 0, 0, 0)]=(-0.0881031287571+0.0324514816002j)*x_ref[0]**o + ((0.111677260287+0.690320349934j))*x_ref[0] + ((0.202182112529-0.452955966698j))*x_ref[1]**o + ((-0.372841043276+0.570148676542j))*x_ref[1]
        arg[(2, 0, 0, 1)]=(-0.341113755832-0.301057312304j)*x[0]**o + ((0.976486052435-0.798151779111j))*x[0] + ((0.75568032243+0.0719534486252j))*x[1]**o + ((0.470436333183+0.207411712733j))*x[1]
        ref[(2, 0, 0, 1)]=(-0.341113755832-0.301057312304j)*x_ref[0]**o + ((0.976486052435-0.798151779111j))*x_ref[0] + ((0.75568032243+0.0719534486252j))*x_ref[1]**o + ((0.470436333183+0.207411712733j))*x_ref[1]
        arg[(2, 0, 1, 0)]=(-0.214189101513-0.735317928324j)*x[0]**o + ((-0.936463215522-0.227136828502j))*x[0] + ((0.398241616442-0.382362820583j))*x[1]**o + ((-0.950881505718-0.487667022374j))*x[1]
        ref[(2, 0, 1, 0)]=(-0.214189101513-0.735317928324j)*x_ref[0]**o + ((-0.936463215522-0.227136828502j))*x_ref[0] + ((0.398241616442-0.382362820583j))*x_ref[1]**o + ((-0.950881505718-0.487667022374j))*x_ref[1]
        arg[(2, 0, 1, 1)]=(-0.595798467226+0.636682092829j)*x[0]**o + ((-0.862642022036-0.863799215432j))*x[0] + ((-0.891944937204+0.666732524077j))*x[1]**o + ((-0.541149035657-0.651974942853j))*x[1]
        ref[(2, 0, 1, 1)]=(-0.595798467226+0.636682092829j)*x_ref[0]**o + ((-0.862642022036-0.863799215432j))*x_ref[0] + ((-0.891944937204+0.666732524077j))*x_ref[1]**o + ((-0.541149035657-0.651974942853j))*x_ref[1]
        arg[(2, 1, 0, 0)]=(-0.943632619479-0.352278650494j)*x[0]**o + ((0.620749799559+0.474742882493j))*x[0] + ((0.067613261406-0.32057277295j))*x[1]**o + ((-0.345666269127-0.141703777911j))*x[1]
        ref[(2, 1, 0, 0)]=(-0.943632619479-0.352278650494j)*x_ref[0]**o + ((0.620749799559+0.474742882493j))*x_ref[0] + ((0.067613261406-0.32057277295j))*x_ref[1]**o + ((-0.345666269127-0.141703777911j))*x_ref[1]
        arg[(2, 1, 0, 1)]=(0.0766423627876+0.117813396331j)*x[0]**o + ((-0.665437187661-0.784831124174j))*x[0] + ((-0.0988999936258+0.476681271146j))*x[1]**o + ((0.182018349721-0.493380662226j))*x[1]
        ref[(2, 1, 0, 1)]=(0.0766423627876+0.117813396331j)*x_ref[0]**o + ((-0.665437187661-0.784831124174j))*x_ref[0] + ((-0.0988999936258+0.476681271146j))*x_ref[1]**o + ((0.182018349721-0.493380662226j))*x_ref[1]
        arg[(2, 1, 1, 0)]=(-0.181937863019-0.100556129066j)*x[0]**o + ((0.697003962218-0.537513477782j))*x[0] + ((-0.0243813011192+0.384229482362j))*x[1]**o + ((-0.960967002404+0.537503449508j))*x[1]
        ref[(2, 1, 1, 0)]=(-0.181937863019-0.100556129066j)*x_ref[0]**o + ((0.697003962218-0.537513477782j))*x_ref[0] + ((-0.0243813011192+0.384229482362j))*x_ref[1]**o + ((-0.960967002404+0.537503449508j))*x_ref[1]
        arg[(2, 1, 1, 1)]=(-0.851729159997-0.263906699509j)*x[0]**o + ((-0.573109839211-0.54193742468j))*x[0] + ((-0.0476760505953-0.879832217906j))*x[1]**o + ((0.693544417222-0.424319522653j))*x[1]
        ref[(2, 1, 1, 1)]=(-0.851729159997-0.263906699509j)*x_ref[0]**o + ((-0.573109839211-0.54193742468j))*x_ref[0] + ((-0.0476760505953-0.879832217906j))*x_ref[1]**o + ((0.693544417222-0.424319522653j))*x_ref[1]
        arg[(2, 2, 0, 0)]=(-0.0813247444359+0.84156855759j)*x[0]**o + ((-0.659532288631+0.651009736481j))*x[0] + ((0.770217342712+0.81460437576j))*x[1]**o + ((0.61204734161-0.487676337145j))*x[1]
        ref[(2, 2, 0, 0)]=(-0.0813247444359+0.84156855759j)*x_ref[0]**o + ((-0.659532288631+0.651009736481j))*x_ref[0] + ((0.770217342712+0.81460437576j))*x_ref[1]**o + ((0.61204734161-0.487676337145j))*x_ref[1]
        arg[(2, 2, 0, 1)]=(0.158463030009-0.396807599544j)*x[0]**o + ((0.751698745608-0.775977824853j))*x[0] + ((0.397095616916-0.26807693192j))*x[1]**o + ((-0.35440230517-0.123201908284j))*x[1]
        ref[(2, 2, 0, 1)]=(0.158463030009-0.396807599544j)*x_ref[0]**o + ((0.751698745608-0.775977824853j))*x_ref[0] + ((0.397095616916-0.26807693192j))*x_ref[1]**o + ((-0.35440230517-0.123201908284j))*x_ref[1]
        arg[(2, 2, 1, 0)]=(0.863680723061-0.149366660257j)*x[0]**o + ((-0.367508453982+0.719956715554j))*x[0] + ((0.610656884647-0.0500431929376j))*x[1]**o + ((0.941667806408+0.118553902789j))*x[1]
        ref[(2, 2, 1, 0)]=(0.863680723061-0.149366660257j)*x_ref[0]**o + ((-0.367508453982+0.719956715554j))*x_ref[0] + ((0.610656884647-0.0500431929376j))*x_ref[1]**o + ((0.941667806408+0.118553902789j))*x_ref[1]
        arg[(2, 2, 1, 1)]=(0.529915050458+0.567674844429j)*x[0]**o + ((0.0167152529425+0.319321046883j))*x[0] + ((-0.617076012511+0.814835581266j))*x[1]**o + ((-0.128518803428+0.380579797828j))*x[1]
        ref[(2, 2, 1, 1)]=(0.529915050458+0.567674844429j)*x_ref[0]**o + ((0.0167152529425+0.319321046883j))*x_ref[0] + ((-0.617076012511+0.814835581266j))*x_ref[1]**o + ((-0.128518803428+0.380579797828j))*x_ref[1]
        arg[(2, 3, 0, 0)]=(-0.537924329326+0.101669060412j)*x[0]**o + ((0.85821806028-0.0712615073724j))*x[0] + ((-0.705129079345-0.545836511093j))*x[1]**o + ((0.804662403256-0.652474820867j))*x[1]
        ref[(2, 3, 0, 0)]=(-0.537924329326+0.101669060412j)*x_ref[0]**o + ((0.85821806028-0.0712615073724j))*x_ref[0] + ((-0.705129079345-0.545836511093j))*x_ref[1]**o + ((0.804662403256-0.652474820867j))*x_ref[1]
        arg[(2, 3, 0, 1)]=(-0.668249460687+0.418328265016j)*x[0]**o + ((-0.305542789067+0.733590021787j))*x[0] + ((-0.694290941086-0.263412875645j))*x[1]**o + ((0.402056141846-0.656503149127j))*x[1]
        ref[(2, 3, 0, 1)]=(-0.668249460687+0.418328265016j)*x_ref[0]**o + ((-0.305542789067+0.733590021787j))*x_ref[0] + ((-0.694290941086-0.263412875645j))*x_ref[1]**o + ((0.402056141846-0.656503149127j))*x_ref[1]
        arg[(2, 3, 1, 0)]=(-0.974487968292+0.0239992724819j)*x[0]**o + ((-0.764910185614-0.914340458313j))*x[0] + ((0.733067083421+0.383633837011j))*x[1]**o + ((-0.589581499092+0.141145078502j))*x[1]
        ref[(2, 3, 1, 0)]=(-0.974487968292+0.0239992724819j)*x_ref[0]**o + ((-0.764910185614-0.914340458313j))*x_ref[0] + ((0.733067083421+0.383633837011j))*x_ref[1]**o + ((-0.589581499092+0.141145078502j))*x_ref[1]
        arg[(2, 3, 1, 1)]=(-0.777438178027+0.947300075489j)*x[0]**o + ((0.543424730224+0.586506215521j))*x[0] + ((-0.38745924502-0.740374894176j))*x[1]**o + ((-0.338184656756+0.592440390376j))*x[1]
        ref[(2, 3, 1, 1)]=(-0.777438178027+0.947300075489j)*x_ref[0]**o + ((0.543424730224+0.586506215521j))*x_ref[0] + ((-0.38745924502-0.740374894176j))*x_ref[1]**o + ((-0.338184656756+0.592440390376j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.766458978221-0.515191360758j)*x[2]**o + ((0.967149083187+0.976218303979j))*x[2]
            ref[(0, 0, 0, 0)]+=(-0.766458978221-0.515191360758j)*x_ref[2]**o + ((0.967149083187+0.976218303979j))*x_ref[2]
            arg[(0, 0, 0, 1)]+=(-0.0804623459415-0.195795466929j)*x[2]**o + ((-0.384056075524-0.800376040037j))*x[2]
            ref[(0, 0, 0, 1)]+=(-0.0804623459415-0.195795466929j)*x_ref[2]**o + ((-0.384056075524-0.800376040037j))*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.56862854375+0.899029505724j)*x[2]**o + ((-0.887789327814+0.593079748093j))*x[2]
            ref[(0, 0, 1, 0)]+=(-0.56862854375+0.899029505724j)*x_ref[2]**o + ((-0.887789327814+0.593079748093j))*x_ref[2]
            arg[(0, 0, 1, 1)]+=(-0.691044302058-0.273917896746j)*x[2]**o + ((-0.232150922178-0.580517199578j))*x[2]
            ref[(0, 0, 1, 1)]+=(-0.691044302058-0.273917896746j)*x_ref[2]**o + ((-0.232150922178-0.580517199578j))*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.681435076399+0.347018205131j)*x[2]**o + ((-0.280909387523+0.845738781432j))*x[2]
            ref[(0, 1, 0, 0)]+=(-0.681435076399+0.347018205131j)*x_ref[2]**o + ((-0.280909387523+0.845738781432j))*x_ref[2]
            arg[(0, 1, 0, 1)]+=(-0.475420466317-0.712503125108j)*x[2]**o + ((-0.575784250225+0.672801524975j))*x[2]
            ref[(0, 1, 0, 1)]+=(-0.475420466317-0.712503125108j)*x_ref[2]**o + ((-0.575784250225+0.672801524975j))*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.665541569051+0.231588610233j)*x[2]**o + ((0.738475655477-0.549503591755j))*x[2]
            ref[(0, 1, 1, 0)]+=(-0.665541569051+0.231588610233j)*x_ref[2]**o + ((0.738475655477-0.549503591755j))*x_ref[2]
            arg[(0, 1, 1, 1)]+=(-0.999974062004+0.214191668839j)*x[2]**o + ((0.0419350386982+0.883564485678j))*x[2]
            ref[(0, 1, 1, 1)]+=(-0.999974062004+0.214191668839j)*x_ref[2]**o + ((0.0419350386982+0.883564485678j))*x_ref[2]
            arg[(0, 2, 0, 0)]+=(-0.968196924139-0.605302502132j)*x[2]**o + ((0.272276513477-0.383019105004j))*x[2]
            ref[(0, 2, 0, 0)]+=(-0.968196924139-0.605302502132j)*x_ref[2]**o + ((0.272276513477-0.383019105004j))*x_ref[2]
            arg[(0, 2, 0, 1)]+=(-0.598053762737-0.441721767493j)*x[2]**o + ((0.0934363433702+0.865034069212j))*x[2]
            ref[(0, 2, 0, 1)]+=(-0.598053762737-0.441721767493j)*x_ref[2]**o + ((0.0934363433702+0.865034069212j))*x_ref[2]
            arg[(0, 2, 1, 0)]+=(0.261451895622+0.253813738553j)*x[2]**o + ((0.144120687739+0.958662939651j))*x[2]
            ref[(0, 2, 1, 0)]+=(0.261451895622+0.253813738553j)*x_ref[2]**o + ((0.144120687739+0.958662939651j))*x_ref[2]
            arg[(0, 2, 1, 1)]+=(0.797188011834+0.314727389877j)*x[2]**o + ((0.735564017676+0.438640612196j))*x[2]
            ref[(0, 2, 1, 1)]+=(0.797188011834+0.314727389877j)*x_ref[2]**o + ((0.735564017676+0.438640612196j))*x_ref[2]
            arg[(0, 3, 0, 0)]+=(-0.390896799582+0.866243684211j)*x[2]**o + ((0.49628756292+0.488025856722j))*x[2]
            ref[(0, 3, 0, 0)]+=(-0.390896799582+0.866243684211j)*x_ref[2]**o + ((0.49628756292+0.488025856722j))*x_ref[2]
            arg[(0, 3, 0, 1)]+=(-0.641066474048-0.709724194666j)*x[2]**o + ((0.274784581644+0.755004202019j))*x[2]
            ref[(0, 3, 0, 1)]+=(-0.641066474048-0.709724194666j)*x_ref[2]**o + ((0.274784581644+0.755004202019j))*x_ref[2]
            arg[(0, 3, 1, 0)]+=(0.188462320355+0.606492276553j)*x[2]**o + ((-0.658206456561-0.991897299399j))*x[2]
            ref[(0, 3, 1, 0)]+=(0.188462320355+0.606492276553j)*x_ref[2]**o + ((-0.658206456561-0.991897299399j))*x_ref[2]
            arg[(0, 3, 1, 1)]+=(0.26833562462+0.198202154303j)*x[2]**o + ((-0.67805549444-0.518078444115j))*x[2]
            ref[(0, 3, 1, 1)]+=(0.26833562462+0.198202154303j)*x_ref[2]**o + ((-0.67805549444-0.518078444115j))*x_ref[2]
            arg[(1, 0, 0, 0)]+=(-0.258432290219-0.867161739418j)*x[2]**o + ((-0.608932417176+0.361320427272j))*x[2]
            ref[(1, 0, 0, 0)]+=(-0.258432290219-0.867161739418j)*x_ref[2]**o + ((-0.608932417176+0.361320427272j))*x_ref[2]
            arg[(1, 0, 0, 1)]+=(-0.411799223813-0.721551859463j)*x[2]**o + ((0.0499053889867+0.793946046881j))*x[2]
            ref[(1, 0, 0, 1)]+=(-0.411799223813-0.721551859463j)*x_ref[2]**o + ((0.0499053889867+0.793946046881j))*x_ref[2]
            arg[(1, 0, 1, 0)]+=(-0.688362139979+0.97216528124j)*x[2]**o + ((-0.696027660406-0.855656320571j))*x[2]
            ref[(1, 0, 1, 0)]+=(-0.688362139979+0.97216528124j)*x_ref[2]**o + ((-0.696027660406-0.855656320571j))*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.417067173222+0.760264051822j)*x[2]**o + ((-0.354467049091+0.949811591269j))*x[2]
            ref[(1, 0, 1, 1)]+=(0.417067173222+0.760264051822j)*x_ref[2]**o + ((-0.354467049091+0.949811591269j))*x_ref[2]
            arg[(1, 1, 0, 0)]+=(-0.502342293007-0.213021058335j)*x[2]**o + ((-0.38029330165+0.400891168344j))*x[2]
            ref[(1, 1, 0, 0)]+=(-0.502342293007-0.213021058335j)*x_ref[2]**o + ((-0.38029330165+0.400891168344j))*x_ref[2]
            arg[(1, 1, 0, 1)]+=(0.520491314061+0.767633981405j)*x[2]**o + ((-0.630210041521+0.731131623646j))*x[2]
            ref[(1, 1, 0, 1)]+=(0.520491314061+0.767633981405j)*x_ref[2]**o + ((-0.630210041521+0.731131623646j))*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.51228336945+0.986836404454j)*x[2]**o + ((-0.12609572466-0.495568642128j))*x[2]
            ref[(1, 1, 1, 0)]+=(0.51228336945+0.986836404454j)*x_ref[2]**o + ((-0.12609572466-0.495568642128j))*x_ref[2]
            arg[(1, 1, 1, 1)]+=(0.0562732941854+0.416656625744j)*x[2]**o + ((-0.0743926302896-0.598572576038j))*x[2]
            ref[(1, 1, 1, 1)]+=(0.0562732941854+0.416656625744j)*x_ref[2]**o + ((-0.0743926302896-0.598572576038j))*x_ref[2]
            arg[(1, 2, 0, 0)]+=(0.923121415335-0.941678304748j)*x[2]**o + ((0.610339535753-0.382122247858j))*x[2]
            ref[(1, 2, 0, 0)]+=(0.923121415335-0.941678304748j)*x_ref[2]**o + ((0.610339535753-0.382122247858j))*x_ref[2]
            arg[(1, 2, 0, 1)]+=(-0.777595961713+0.177009012919j)*x[2]**o + ((0.14769303247+0.476433314358j))*x[2]
            ref[(1, 2, 0, 1)]+=(-0.777595961713+0.177009012919j)*x_ref[2]**o + ((0.14769303247+0.476433314358j))*x_ref[2]
            arg[(1, 2, 1, 0)]+=(0.692594996996+0.261597623254j)*x[2]**o + ((-0.874367110935-0.321041048417j))*x[2]
            ref[(1, 2, 1, 0)]+=(0.692594996996+0.261597623254j)*x_ref[2]**o + ((-0.874367110935-0.321041048417j))*x_ref[2]
            arg[(1, 2, 1, 1)]+=(-0.986172541459+0.612777665447j)*x[2]**o + ((0.832197461125-0.492721803402j))*x[2]
            ref[(1, 2, 1, 1)]+=(-0.986172541459+0.612777665447j)*x_ref[2]**o + ((0.832197461125-0.492721803402j))*x_ref[2]
            arg[(1, 3, 0, 0)]+=(-0.0925069774129-0.176044848714j)*x[2]**o + ((0.710381963909-0.262837098271j))*x[2]
            ref[(1, 3, 0, 0)]+=(-0.0925069774129-0.176044848714j)*x_ref[2]**o + ((0.710381963909-0.262837098271j))*x_ref[2]
            arg[(1, 3, 0, 1)]+=(0.647781190364-0.631818906683j)*x[2]**o + ((0.573016391199-0.243345844178j))*x[2]
            ref[(1, 3, 0, 1)]+=(0.647781190364-0.631818906683j)*x_ref[2]**o + ((0.573016391199-0.243345844178j))*x_ref[2]
            arg[(1, 3, 1, 0)]+=(0.638512029931+0.833662742434j)*x[2]**o + ((0.797081752477-0.983231581424j))*x[2]
            ref[(1, 3, 1, 0)]+=(0.638512029931+0.833662742434j)*x_ref[2]**o + ((0.797081752477-0.983231581424j))*x_ref[2]
            arg[(1, 3, 1, 1)]+=(0.673714107177-0.875616873405j)*x[2]**o + ((-0.200042441671-0.852669286429j))*x[2]
            ref[(1, 3, 1, 1)]+=(0.673714107177-0.875616873405j)*x_ref[2]**o + ((-0.200042441671-0.852669286429j))*x_ref[2]
            arg[(2, 0, 0, 0)]+=(-0.273874811532+0.862892735801j)*x[2]**o + ((0.478328911502+0.79922586656j))*x[2]
            ref[(2, 0, 0, 0)]+=(-0.273874811532+0.862892735801j)*x_ref[2]**o + ((0.478328911502+0.79922586656j))*x_ref[2]
            arg[(2, 0, 0, 1)]+=(-0.452106732965-0.549680829468j)*x[2]**o + ((-0.596529211657-0.477324105658j))*x[2]
            ref[(2, 0, 0, 1)]+=(-0.452106732965-0.549680829468j)*x_ref[2]**o + ((-0.596529211657-0.477324105658j))*x_ref[2]
            arg[(2, 0, 1, 0)]+=(0.223492426246-0.188237171785j)*x[2]**o + ((-0.264880063369+0.970258285352j))*x[2]
            ref[(2, 0, 1, 0)]+=(0.223492426246-0.188237171785j)*x_ref[2]**o + ((-0.264880063369+0.970258285352j))*x_ref[2]
            arg[(2, 0, 1, 1)]+=(-0.856342086625+0.614893249266j)*x[2]**o + ((0.717337553225-0.417802705087j))*x[2]
            ref[(2, 0, 1, 1)]+=(-0.856342086625+0.614893249266j)*x_ref[2]**o + ((0.717337553225-0.417802705087j))*x_ref[2]
            arg[(2, 1, 0, 0)]+=(-0.179772922145-0.351263525952j)*x[2]**o + ((-0.480332804489+0.25145842277j))*x[2]
            ref[(2, 1, 0, 0)]+=(-0.179772922145-0.351263525952j)*x_ref[2]**o + ((-0.480332804489+0.25145842277j))*x_ref[2]
            arg[(2, 1, 0, 1)]+=(0.277579348071+0.998669102369j)*x[2]**o + ((0.727358339322+0.652026290907j))*x[2]
            ref[(2, 1, 0, 1)]+=(0.277579348071+0.998669102369j)*x_ref[2]**o + ((0.727358339322+0.652026290907j))*x_ref[2]
            arg[(2, 1, 1, 0)]+=(0.75976646788+0.330779854979j)*x[2]**o + ((0.798028729114-0.527452580019j))*x[2]
            ref[(2, 1, 1, 0)]+=(0.75976646788+0.330779854979j)*x_ref[2]**o + ((0.798028729114-0.527452580019j))*x_ref[2]
            arg[(2, 1, 1, 1)]+=(0.648892616468-0.390752960852j)*x[2]**o + ((-0.673395866481-0.32641878354j))*x[2]
            ref[(2, 1, 1, 1)]+=(0.648892616468-0.390752960852j)*x_ref[2]**o + ((-0.673395866481-0.32641878354j))*x_ref[2]
            arg[(2, 2, 0, 0)]+=(0.0154516276186-0.712173065813j)*x[2]**o + ((0.629187497971+0.899107680254j))*x[2]
            ref[(2, 2, 0, 0)]+=(0.0154516276186-0.712173065813j)*x_ref[2]**o + ((0.629187497971+0.899107680254j))*x_ref[2]
            arg[(2, 2, 0, 1)]+=(-0.0945687684822+0.0887775495187j)*x[2]**o + ((-0.778553934333-0.469910176759j))*x[2]
            ref[(2, 2, 0, 1)]+=(-0.0945687684822+0.0887775495187j)*x_ref[2]**o + ((-0.778553934333-0.469910176759j))*x_ref[2]
            arg[(2, 2, 1, 0)]+=(0.980940048215-0.458388077173j)*x[2]**o + ((0.654782015653+0.0362461990281j))*x[2]
            ref[(2, 2, 1, 0)]+=(0.980940048215-0.458388077173j)*x_ref[2]**o + ((0.654782015653+0.0362461990281j))*x_ref[2]
            arg[(2, 2, 1, 1)]+=(-0.0655889309834-0.792401682413j)*x[2]**o + ((-0.0102761900182+0.182008893989j))*x[2]
            ref[(2, 2, 1, 1)]+=(-0.0655889309834-0.792401682413j)*x_ref[2]**o + ((-0.0102761900182+0.182008893989j))*x_ref[2]
            arg[(2, 3, 0, 0)]+=(0.68601435142+0.129055876411j)*x[2]**o + ((0.73288910109-0.730220116085j))*x[2]
            ref[(2, 3, 0, 0)]+=(0.68601435142+0.129055876411j)*x_ref[2]**o + ((0.73288910109-0.730220116085j))*x_ref[2]
            arg[(2, 3, 0, 1)]+=(-0.134087597711-0.59034357238j)*x[2]**o + ((0.268530959326+0.0279936596314j))*x[2]
            ref[(2, 3, 0, 1)]+=(-0.134087597711-0.59034357238j)*x_ref[2]**o + ((0.268530959326+0.0279936596314j))*x_ref[2]
            arg[(2, 3, 1, 0)]+=(0.997718058883+0.880452708227j)*x[2]**o + ((-0.0792984671025-0.547858741812j))*x[2]
            ref[(2, 3, 1, 0)]+=(0.997718058883+0.880452708227j)*x_ref[2]**o + ((-0.0792984671025-0.547858741812j))*x_ref[2]
            arg[(2, 3, 1, 1)]+=(0.476303118761-0.193075272107j)*x[2]**o + ((-0.0513861491508-0.0190309458388j))*x[2]
            ref[(2, 3, 1, 1)]+=(0.476303118761-0.193075272107j)*x_ref[2]**o + ((-0.0513861491508-0.0190309458388j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3, 4, 2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Solution_rank0(self):
        """
        tests interpolation of rank 0 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.52166128061-0.666122053521j)*x[0]**o + ((0.817622647431-0.152787756076j))*x[0] + ((-0.653077225262+0.0540888071949j))*x[1]**o + ((0.0869028851631+0.418520306248j))*x[1]
        ref=(-0.52166128061-0.666122053521j)*x_ref[0]**o + ((0.817622647431-0.152787756076j))*x_ref[0] + ((-0.653077225262+0.0540888071949j))*x_ref[1]**o + ((0.0869028851631+0.418520306248j))*x_ref[1]
        if dim==3:
            arg+=((0.0771122192234+0.85112062096j))*x[2]**o + ((-0.370850112416-0.306069931246j))*x[2]
            ref+=((0.0771122192234+0.85112062096j))*x_ref[2]**o + ((-0.370850112416-0.306069931246j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Solution_rank1(self):
        """
        tests interpolation of rank 1 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,),w_ref)
        arg[(0,)]=(-0.944282507355-0.81767027796j)*x[0]**o + ((-0.04435023564-0.739402982165j))*x[0] + ((-0.574805380087+0.205993031107j))*x[1]**o + ((-0.887366335216+0.660905898346j))*x[1]
        ref[(0,)]=(-0.944282507355-0.81767027796j)*x_ref[0]**o + ((-0.04435023564-0.739402982165j))*x_ref[0] + ((-0.574805380087+0.205993031107j))*x_ref[1]**o + ((-0.887366335216+0.660905898346j))*x_ref[1]
        arg[(1,)]=(-0.629603087692-0.426559394146j)*x[0]**o + ((0.489345817778-0.00575642866589j))*x[0] + ((0.629647034727+0.651351916557j))*x[1]**o + ((0.934642318839-0.312642249161j))*x[1]
        ref[(1,)]=(-0.629603087692-0.426559394146j)*x_ref[0]**o + ((0.489345817778-0.00575642866589j))*x_ref[0] + ((0.629647034727+0.651351916557j))*x_ref[1]**o + ((0.934642318839-0.312642249161j))*x_ref[1]
        arg[(2,)]=(-0.49407717905-0.0191205941227j)*x[0]**o + ((-0.44317083379+0.5934872624j))*x[0] + ((-0.476929769407-0.763129426009j))*x[1]**o + ((-0.988623525301-0.50335083816j))*x[1]
        ref[(2,)]=(-0.49407717905-0.0191205941227j)*x_ref[0]**o + ((-0.44317083379+0.5934872624j))*x_ref[0] + ((-0.476929769407-0.763129426009j))*x_ref[1]**o + ((-0.988623525301-0.50335083816j))*x_ref[1]
        arg[(3,)]=(-0.852025031196+0.957232689728j)*x[0]**o + ((-0.0994079224085-0.490966928913j))*x[0] + ((-0.880205049883+0.467660557545j))*x[1]**o + ((0.881838369203-0.565811746767j))*x[1]
        ref[(3,)]=(-0.852025031196+0.957232689728j)*x_ref[0]**o + ((-0.0994079224085-0.490966928913j))*x_ref[0] + ((-0.880205049883+0.467660557545j))*x_ref[1]**o + ((0.881838369203-0.565811746767j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.00835125220226-0.32310389024j)*x[2]**o + ((-0.0930098865533-0.181111334013j))*x[2]
            ref[(0,)]+=(-0.00835125220226-0.32310389024j)*x_ref[2]**o + ((-0.0930098865533-0.181111334013j))*x_ref[2]
            arg[(1,)]+=(0.347887461613-0.58371187594j)*x[2]**o + ((0.088035751189-0.0799547887745j))*x[2]
            ref[(1,)]+=(0.347887461613-0.58371187594j)*x_ref[2]**o + ((0.088035751189-0.0799547887745j))*x_ref[2]
            arg[(2,)]+=(0.487097106268-0.397891044027j)*x[2]**o + ((-0.472638752013-0.607096887206j))*x[2]
            ref[(2,)]+=(0.487097106268-0.397891044027j)*x_ref[2]**o + ((-0.472638752013-0.607096887206j))*x_ref[2]
            arg[(3,)]+=(-0.496743615048+0.676813728188j)*x[2]**o + ((0.377556230489+0.782923550638j))*x[2]
            ref[(3,)]+=(-0.496743615048+0.676813728188j)*x_ref[2]**o + ((0.377556230489+0.782923550638j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Solution_rank2(self):
        """
        tests interpolation of rank 2 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3),w_ref)
        arg[(0, 0)]=(0.633658336971+0.696809306275j)*x[0]**o + ((0.534402413397+0.0357457835443j))*x[0] + ((0.768565580483-0.79991635855j))*x[1]**o + ((-0.822824769061-0.909651096227j))*x[1]
        ref[(0, 0)]=(0.633658336971+0.696809306275j)*x_ref[0]**o + ((0.534402413397+0.0357457835443j))*x_ref[0] + ((0.768565580483-0.79991635855j))*x_ref[1]**o + ((-0.822824769061-0.909651096227j))*x_ref[1]
        arg[(0, 1)]=(-0.737150893479-0.12821068086j)*x[0]**o + ((0.63340536188-0.379004247728j))*x[0] + ((-0.633574975416-0.343559815188j))*x[1]**o + ((-0.770705061152+0.851306055831j))*x[1]
        ref[(0, 1)]=(-0.737150893479-0.12821068086j)*x_ref[0]**o + ((0.63340536188-0.379004247728j))*x_ref[0] + ((-0.633574975416-0.343559815188j))*x_ref[1]**o + ((-0.770705061152+0.851306055831j))*x_ref[1]
        arg[(0, 2)]=(-0.233884560663+0.62442476977j)*x[0]**o + ((0.893070844807+0.828986178303j))*x[0] + ((-0.0602890351747-0.666989104194j))*x[1]**o + ((-0.696352529357+0.778163751838j))*x[1]
        ref[(0, 2)]=(-0.233884560663+0.62442476977j)*x_ref[0]**o + ((0.893070844807+0.828986178303j))*x_ref[0] + ((-0.0602890351747-0.666989104194j))*x_ref[1]**o + ((-0.696352529357+0.778163751838j))*x_ref[1]
        arg[(1, 0)]=(-0.440002493684-0.733564105325j)*x[0]**o + ((-0.317746496044+0.0209352950303j))*x[0] + ((-0.547266633267-0.435646036782j))*x[1]**o + ((-0.900426947127+0.747598574018j))*x[1]
        ref[(1, 0)]=(-0.440002493684-0.733564105325j)*x_ref[0]**o + ((-0.317746496044+0.0209352950303j))*x_ref[0] + ((-0.547266633267-0.435646036782j))*x_ref[1]**o + ((-0.900426947127+0.747598574018j))*x_ref[1]
        arg[(1, 1)]=(-0.0262173212192-0.130854881933j)*x[0]**o + ((-0.446022676536+0.141292366837j))*x[0] + ((0.740041825782+0.866505047656j))*x[1]**o + ((-0.652497223058+0.905405995821j))*x[1]
        ref[(1, 1)]=(-0.0262173212192-0.130854881933j)*x_ref[0]**o + ((-0.446022676536+0.141292366837j))*x_ref[0] + ((0.740041825782+0.866505047656j))*x_ref[1]**o + ((-0.652497223058+0.905405995821j))*x_ref[1]
        arg[(1, 2)]=(-0.306135777172+0.898694675195j)*x[0]**o + ((0.603922789239+0.234767993986j))*x[0] + ((-0.228190495363+0.326514478599j))*x[1]**o + ((-0.594277500924-0.024805760005j))*x[1]
        ref[(1, 2)]=(-0.306135777172+0.898694675195j)*x_ref[0]**o + ((0.603922789239+0.234767993986j))*x_ref[0] + ((-0.228190495363+0.326514478599j))*x_ref[1]**o + ((-0.594277500924-0.024805760005j))*x_ref[1]
        arg[(2, 0)]=(-0.931493537089+0.644195519742j)*x[0]**o + ((-0.252659924647+0.737164575147j))*x[0] + ((0.139310319943+0.144608653594j))*x[1]**o + ((-0.791470354047+0.32806890625j))*x[1]
        ref[(2, 0)]=(-0.931493537089+0.644195519742j)*x_ref[0]**o + ((-0.252659924647+0.737164575147j))*x_ref[0] + ((0.139310319943+0.144608653594j))*x_ref[1]**o + ((-0.791470354047+0.32806890625j))*x_ref[1]
        arg[(2, 1)]=(-0.108636803109+0.0355332623298j)*x[0]**o + ((-0.681349439951-0.738568692799j))*x[0] + ((0.601767506897-0.247336304284j))*x[1]**o + ((-0.655278870613-0.0206477001071j))*x[1]
        ref[(2, 1)]=(-0.108636803109+0.0355332623298j)*x_ref[0]**o + ((-0.681349439951-0.738568692799j))*x_ref[0] + ((0.601767506897-0.247336304284j))*x_ref[1]**o + ((-0.655278870613-0.0206477001071j))*x_ref[1]
        arg[(2, 2)]=(0.37657058979+0.547910854945j)*x[0]**o + ((-0.913324777551-0.325086848398j))*x[0] + ((0.742351258407+0.868123624479j))*x[1]**o + ((0.0777243248037-0.742902513973j))*x[1]
        ref[(2, 2)]=(0.37657058979+0.547910854945j)*x_ref[0]**o + ((-0.913324777551-0.325086848398j))*x_ref[0] + ((0.742351258407+0.868123624479j))*x_ref[1]**o + ((0.0777243248037-0.742902513973j))*x_ref[1]
        arg[(3, 0)]=(0.927961680134-0.270761160255j)*x[0]**o + ((0.0945404642457+0.272147207689j))*x[0] + ((-0.142245885528+0.420883781526j))*x[1]**o + ((0.197568183167-0.325520180653j))*x[1]
        ref[(3, 0)]=(0.927961680134-0.270761160255j)*x_ref[0]**o + ((0.0945404642457+0.272147207689j))*x_ref[0] + ((-0.142245885528+0.420883781526j))*x_ref[1]**o + ((0.197568183167-0.325520180653j))*x_ref[1]
        arg[(3, 1)]=(0.884744845614+0.606194699153j)*x[0]**o + ((-0.254520802555-0.478163667403j))*x[0] + ((-0.566285278876+0.609039713088j))*x[1]**o + ((-0.499268670623+0.702229073636j))*x[1]
        ref[(3, 1)]=(0.884744845614+0.606194699153j)*x_ref[0]**o + ((-0.254520802555-0.478163667403j))*x_ref[0] + ((-0.566285278876+0.609039713088j))*x_ref[1]**o + ((-0.499268670623+0.702229073636j))*x_ref[1]
        arg[(3, 2)]=(0.213528248043-0.604043182624j)*x[0]**o + ((0.0692090487552-0.334008043798j))*x[0] + ((-0.0739631485818-0.0540555613927j))*x[1]**o + ((-0.492922188362+0.812548088164j))*x[1]
        ref[(3, 2)]=(0.213528248043-0.604043182624j)*x_ref[0]**o + ((0.0692090487552-0.334008043798j))*x_ref[0] + ((-0.0739631485818-0.0540555613927j))*x_ref[1]**o + ((-0.492922188362+0.812548088164j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(-0.706270539623+0.0275540030817j)*x[2]**o + ((0.252194791074+0.551279450162j))*x[2]
            ref[(0, 0)]+=(-0.706270539623+0.0275540030817j)*x_ref[2]**o + ((0.252194791074+0.551279450162j))*x_ref[2]
            arg[(0, 1)]+=(0.64806221654-0.545182858379j)*x[2]**o + ((-0.836244106682+0.322544637561j))*x[2]
            ref[(0, 1)]+=(0.64806221654-0.545182858379j)*x_ref[2]**o + ((-0.836244106682+0.322544637561j))*x_ref[2]
            arg[(0, 2)]+=(-0.0676095346381-0.71890244719j)*x[2]**o + ((-0.16966098232+0.428192864243j))*x[2]
            ref[(0, 2)]+=(-0.0676095346381-0.71890244719j)*x_ref[2]**o + ((-0.16966098232+0.428192864243j))*x_ref[2]
            arg[(1, 0)]+=(-0.0681459172025-0.844799144557j)*x[2]**o + ((0.917521854127-0.67715432286j))*x[2]
            ref[(1, 0)]+=(-0.0681459172025-0.844799144557j)*x_ref[2]**o + ((0.917521854127-0.67715432286j))*x_ref[2]
            arg[(1, 1)]+=(-0.872585353212+0.133797404786j)*x[2]**o + ((-0.55288248792-0.136651616704j))*x[2]
            ref[(1, 1)]+=(-0.872585353212+0.133797404786j)*x_ref[2]**o + ((-0.55288248792-0.136651616704j))*x_ref[2]
            arg[(1, 2)]+=(0.0491178409957+0.687906600037j)*x[2]**o + ((0.363442777456+0.546501204814j))*x[2]
            ref[(1, 2)]+=(0.0491178409957+0.687906600037j)*x_ref[2]**o + ((0.363442777456+0.546501204814j))*x_ref[2]
            arg[(2, 0)]+=(0.262073682115-0.480256728331j)*x[2]**o + ((-0.803245213498-0.987393276649j))*x[2]
            ref[(2, 0)]+=(0.262073682115-0.480256728331j)*x_ref[2]**o + ((-0.803245213498-0.987393276649j))*x_ref[2]
            arg[(2, 1)]+=(0.391458464834-0.324751874184j)*x[2]**o + ((-0.0666463677376+0.630326400925j))*x[2]
            ref[(2, 1)]+=(0.391458464834-0.324751874184j)*x_ref[2]**o + ((-0.0666463677376+0.630326400925j))*x_ref[2]
            arg[(2, 2)]+=(0.290088968584+0.208361736108j)*x[2]**o + ((0.372399115731-0.391304995524j))*x[2]
            ref[(2, 2)]+=(0.290088968584+0.208361736108j)*x_ref[2]**o + ((0.372399115731-0.391304995524j))*x_ref[2]
            arg[(3, 0)]+=(-0.343307599136-0.196342454583j)*x[2]**o + ((0.246512239537-0.186076154553j))*x[2]
            ref[(3, 0)]+=(-0.343307599136-0.196342454583j)*x_ref[2]**o + ((0.246512239537-0.186076154553j))*x_ref[2]
            arg[(3, 1)]+=(-0.301412409075-0.117880293911j)*x[2]**o + ((0.241784118559+0.516641917996j))*x[2]
            ref[(3, 1)]+=(-0.301412409075-0.117880293911j)*x_ref[2]**o + ((0.241784118559+0.516641917996j))*x_ref[2]
            arg[(3, 2)]+=(-0.924705107871-0.0410573371669j)*x[2]**o + ((0.246158283098-0.670331040794j))*x[2]
            ref[(3, 2)]+=(-0.924705107871-0.0410573371669j)*x_ref[2]**o + ((0.246158283098-0.670331040794j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Solution_rank3(self):
        """
        tests interpolation of rank 3 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 4),w)
        ref = Data(0,(4, 3, 4),w_ref)
        arg[(0, 0, 0)]=(-0.406894136991-0.620820396612j)*x[0]**o + ((0.655237444929-0.00192810883238j))*x[0] + ((0.662157633328-0.218826389545j))*x[1]**o + ((-0.66043361716-0.703754049544j))*x[1]
        ref[(0, 0, 0)]=(-0.406894136991-0.620820396612j)*x_ref[0]**o + ((0.655237444929-0.00192810883238j))*x_ref[0] + ((0.662157633328-0.218826389545j))*x_ref[1]**o + ((-0.66043361716-0.703754049544j))*x_ref[1]
        arg[(0, 0, 1)]=(0.400827159819+0.886557465148j)*x[0]**o + ((-0.56291554093-0.810494866798j))*x[0] + ((-0.229932761918-0.747948244062j))*x[1]**o + ((0.0639391211776-0.834082049258j))*x[1]
        ref[(0, 0, 1)]=(0.400827159819+0.886557465148j)*x_ref[0]**o + ((-0.56291554093-0.810494866798j))*x_ref[0] + ((-0.229932761918-0.747948244062j))*x_ref[1]**o + ((0.0639391211776-0.834082049258j))*x_ref[1]
        arg[(0, 0, 2)]=(0.0871688266878+0.795434670681j)*x[0]**o + ((0.256464798527-0.191531846859j))*x[0] + ((0.829972516105+0.124509414717j))*x[1]**o + ((-0.362185119344+0.622249557826j))*x[1]
        ref[(0, 0, 2)]=(0.0871688266878+0.795434670681j)*x_ref[0]**o + ((0.256464798527-0.191531846859j))*x_ref[0] + ((0.829972516105+0.124509414717j))*x_ref[1]**o + ((-0.362185119344+0.622249557826j))*x_ref[1]
        arg[(0, 0, 3)]=(-0.212737759431-0.173978308917j)*x[0]**o + ((0.994085877958-0.452406679413j))*x[0] + ((0.961643418989-0.92855569147j))*x[1]**o + ((-0.679921838927+0.735361253064j))*x[1]
        ref[(0, 0, 3)]=(-0.212737759431-0.173978308917j)*x_ref[0]**o + ((0.994085877958-0.452406679413j))*x_ref[0] + ((0.961643418989-0.92855569147j))*x_ref[1]**o + ((-0.679921838927+0.735361253064j))*x_ref[1]
        arg[(0, 1, 0)]=(-0.429033368092-0.847504628682j)*x[0]**o + ((-0.975917387206-0.353396161777j))*x[0] + ((0.959177061766+0.24376422556j))*x[1]**o + ((0.963066292557-0.692282025641j))*x[1]
        ref[(0, 1, 0)]=(-0.429033368092-0.847504628682j)*x_ref[0]**o + ((-0.975917387206-0.353396161777j))*x_ref[0] + ((0.959177061766+0.24376422556j))*x_ref[1]**o + ((0.963066292557-0.692282025641j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.350930643993-0.130451475837j)*x[0]**o + ((0.280706020158-0.797659894868j))*x[0] + ((-0.635975954919-0.0309224520881j))*x[1]**o + ((-0.841383111195+0.869165244285j))*x[1]
        ref[(0, 1, 1)]=(-0.350930643993-0.130451475837j)*x_ref[0]**o + ((0.280706020158-0.797659894868j))*x_ref[0] + ((-0.635975954919-0.0309224520881j))*x_ref[1]**o + ((-0.841383111195+0.869165244285j))*x_ref[1]
        arg[(0, 1, 2)]=(-0.777770536476-0.770954257768j)*x[0]**o + ((0.136872667035+0.129143482171j))*x[0] + ((0.00826898905697+0.562983953953j))*x[1]**o + ((-0.422606788127+0.87695023674j))*x[1]
        ref[(0, 1, 2)]=(-0.777770536476-0.770954257768j)*x_ref[0]**o + ((0.136872667035+0.129143482171j))*x_ref[0] + ((0.00826898905697+0.562983953953j))*x_ref[1]**o + ((-0.422606788127+0.87695023674j))*x_ref[1]
        arg[(0, 1, 3)]=(0.918915889921-0.243288940447j)*x[0]**o + ((0.493084508735+0.183959358226j))*x[0] + ((-0.90849574002+0.96627763565j))*x[1]**o + ((0.522677615902-0.254570541654j))*x[1]
        ref[(0, 1, 3)]=(0.918915889921-0.243288940447j)*x_ref[0]**o + ((0.493084508735+0.183959358226j))*x_ref[0] + ((-0.90849574002+0.96627763565j))*x_ref[1]**o + ((0.522677615902-0.254570541654j))*x_ref[1]
        arg[(0, 2, 0)]=(-0.114113521749-0.627141820445j)*x[0]**o + ((-0.912893231227+0.107368811733j))*x[0] + ((-0.151581042108-0.352256631151j))*x[1]**o + ((-0.0281375314334+0.441392748151j))*x[1]
        ref[(0, 2, 0)]=(-0.114113521749-0.627141820445j)*x_ref[0]**o + ((-0.912893231227+0.107368811733j))*x_ref[0] + ((-0.151581042108-0.352256631151j))*x_ref[1]**o + ((-0.0281375314334+0.441392748151j))*x_ref[1]
        arg[(0, 2, 1)]=(-0.2893154002-0.213712808085j)*x[0]**o + ((-0.56553049842+0.243306599538j))*x[0] + ((-0.271056371847-0.792808303568j))*x[1]**o + ((0.297138969446-0.220242348565j))*x[1]
        ref[(0, 2, 1)]=(-0.2893154002-0.213712808085j)*x_ref[0]**o + ((-0.56553049842+0.243306599538j))*x_ref[0] + ((-0.271056371847-0.792808303568j))*x_ref[1]**o + ((0.297138969446-0.220242348565j))*x_ref[1]
        arg[(0, 2, 2)]=(-0.414075415157+0.698775179936j)*x[0]**o + ((0.845288425345+0.213368395631j))*x[0] + ((-0.476413427586-0.887148692724j))*x[1]**o + ((0.0953002029411+0.628947561154j))*x[1]
        ref[(0, 2, 2)]=(-0.414075415157+0.698775179936j)*x_ref[0]**o + ((0.845288425345+0.213368395631j))*x_ref[0] + ((-0.476413427586-0.887148692724j))*x_ref[1]**o + ((0.0953002029411+0.628947561154j))*x_ref[1]
        arg[(0, 2, 3)]=(0.680646261635+0.578468254313j)*x[0]**o + ((0.222532030391-0.802966812388j))*x[0] + ((0.369969758217-0.993546003174j))*x[1]**o + ((-0.488158880908+0.818080233872j))*x[1]
        ref[(0, 2, 3)]=(0.680646261635+0.578468254313j)*x_ref[0]**o + ((0.222532030391-0.802966812388j))*x_ref[0] + ((0.369969758217-0.993546003174j))*x_ref[1]**o + ((-0.488158880908+0.818080233872j))*x_ref[1]
        arg[(1, 0, 0)]=(0.815503362905-0.407215501126j)*x[0]**o + ((-0.318552579876-0.886011757171j))*x[0] + ((0.0610884123537-0.253668160199j))*x[1]**o + ((-0.657956789893+0.237924659503j))*x[1]
        ref[(1, 0, 0)]=(0.815503362905-0.407215501126j)*x_ref[0]**o + ((-0.318552579876-0.886011757171j))*x_ref[0] + ((0.0610884123537-0.253668160199j))*x_ref[1]**o + ((-0.657956789893+0.237924659503j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.479455103177-0.132108552446j)*x[0]**o + ((-0.175690886036+0.446772592299j))*x[0] + ((0.739001982349-0.385441762672j))*x[1]**o + ((0.191664598737-0.0605664869337j))*x[1]
        ref[(1, 0, 1)]=(-0.479455103177-0.132108552446j)*x_ref[0]**o + ((-0.175690886036+0.446772592299j))*x_ref[0] + ((0.739001982349-0.385441762672j))*x_ref[1]**o + ((0.191664598737-0.0605664869337j))*x_ref[1]
        arg[(1, 0, 2)]=(0.666239397084+0.609351492481j)*x[0]**o + ((-0.277769563556-0.411916682218j))*x[0] + ((-0.83787366169+0.391754469731j))*x[1]**o + ((-0.0275107858918+0.380919541126j))*x[1]
        ref[(1, 0, 2)]=(0.666239397084+0.609351492481j)*x_ref[0]**o + ((-0.277769563556-0.411916682218j))*x_ref[0] + ((-0.83787366169+0.391754469731j))*x_ref[1]**o + ((-0.0275107858918+0.380919541126j))*x_ref[1]
        arg[(1, 0, 3)]=(-0.0295178308593+0.932930154727j)*x[0]**o + ((-0.714021267975-0.82010909876j))*x[0] + ((0.379831267571-0.626564013657j))*x[1]**o + ((-0.224135852179-0.00334117952455j))*x[1]
        ref[(1, 0, 3)]=(-0.0295178308593+0.932930154727j)*x_ref[0]**o + ((-0.714021267975-0.82010909876j))*x_ref[0] + ((0.379831267571-0.626564013657j))*x_ref[1]**o + ((-0.224135852179-0.00334117952455j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.576904141004+0.497245986909j)*x[0]**o + ((0.0456304748297-0.138731266431j))*x[0] + ((0.722391052801+0.2568605047j))*x[1]**o + ((0.64294446135-0.464082879797j))*x[1]
        ref[(1, 1, 0)]=(-0.576904141004+0.497245986909j)*x_ref[0]**o + ((0.0456304748297-0.138731266431j))*x_ref[0] + ((0.722391052801+0.2568605047j))*x_ref[1]**o + ((0.64294446135-0.464082879797j))*x_ref[1]
        arg[(1, 1, 1)]=(0.0717768833866-0.642373217782j)*x[0]**o + ((-0.529618744283+0.0230675695259j))*x[0] + ((-0.802401176826-0.214766564777j))*x[1]**o + ((0.82363133706+0.56073088938j))*x[1]
        ref[(1, 1, 1)]=(0.0717768833866-0.642373217782j)*x_ref[0]**o + ((-0.529618744283+0.0230675695259j))*x_ref[0] + ((-0.802401176826-0.214766564777j))*x_ref[1]**o + ((0.82363133706+0.56073088938j))*x_ref[1]
        arg[(1, 1, 2)]=(-0.494006891437+0.516308483794j)*x[0]**o + ((0.366220392896+0.380880968547j))*x[0] + ((0.410137799272-0.408342935703j))*x[1]**o + ((0.211726481918+0.742575470046j))*x[1]
        ref[(1, 1, 2)]=(-0.494006891437+0.516308483794j)*x_ref[0]**o + ((0.366220392896+0.380880968547j))*x_ref[0] + ((0.410137799272-0.408342935703j))*x_ref[1]**o + ((0.211726481918+0.742575470046j))*x_ref[1]
        arg[(1, 1, 3)]=(-0.744172206395+0.414838209472j)*x[0]**o + ((-0.8887493087-0.893116913166j))*x[0] + ((0.557500440671-0.484171055477j))*x[1]**o + ((0.795044345237-0.229269762114j))*x[1]
        ref[(1, 1, 3)]=(-0.744172206395+0.414838209472j)*x_ref[0]**o + ((-0.8887493087-0.893116913166j))*x_ref[0] + ((0.557500440671-0.484171055477j))*x_ref[1]**o + ((0.795044345237-0.229269762114j))*x_ref[1]
        arg[(1, 2, 0)]=(-0.102739797827+0.46217692717j)*x[0]**o + ((-0.860145812945-0.472489324676j))*x[0] + ((-0.205839747265-0.0422646315404j))*x[1]**o + ((0.102821671326-0.0770738290895j))*x[1]
        ref[(1, 2, 0)]=(-0.102739797827+0.46217692717j)*x_ref[0]**o + ((-0.860145812945-0.472489324676j))*x_ref[0] + ((-0.205839747265-0.0422646315404j))*x_ref[1]**o + ((0.102821671326-0.0770738290895j))*x_ref[1]
        arg[(1, 2, 1)]=(-0.568262952399+0.228646811333j)*x[0]**o + ((0.849195128101+0.120495316685j))*x[0] + ((0.153043170175-0.45617207061j))*x[1]**o + ((-0.784751133956-0.249415492717j))*x[1]
        ref[(1, 2, 1)]=(-0.568262952399+0.228646811333j)*x_ref[0]**o + ((0.849195128101+0.120495316685j))*x_ref[0] + ((0.153043170175-0.45617207061j))*x_ref[1]**o + ((-0.784751133956-0.249415492717j))*x_ref[1]
        arg[(1, 2, 2)]=(-0.956173366484-0.940269390181j)*x[0]**o + ((-0.451558656076-0.474484457081j))*x[0] + ((0.727869099735+0.0332366832847j))*x[1]**o + ((-0.240645312638-0.428661080351j))*x[1]
        ref[(1, 2, 2)]=(-0.956173366484-0.940269390181j)*x_ref[0]**o + ((-0.451558656076-0.474484457081j))*x_ref[0] + ((0.727869099735+0.0332366832847j))*x_ref[1]**o + ((-0.240645312638-0.428661080351j))*x_ref[1]
        arg[(1, 2, 3)]=(-0.730004322838+0.123683107736j)*x[0]**o + ((0.393901311117+0.622398215297j))*x[0] + ((-0.585074258105+0.817198236856j))*x[1]**o + ((-0.496386017877-0.13726534368j))*x[1]
        ref[(1, 2, 3)]=(-0.730004322838+0.123683107736j)*x_ref[0]**o + ((0.393901311117+0.622398215297j))*x_ref[0] + ((-0.585074258105+0.817198236856j))*x_ref[1]**o + ((-0.496386017877-0.13726534368j))*x_ref[1]
        arg[(2, 0, 0)]=(0.853913139843-0.826570115787j)*x[0]**o + ((-0.373353582165-0.998978800401j))*x[0] + ((0.227549884188-0.834676334843j))*x[1]**o + ((0.627135365192+0.164786667051j))*x[1]
        ref[(2, 0, 0)]=(0.853913139843-0.826570115787j)*x_ref[0]**o + ((-0.373353582165-0.998978800401j))*x_ref[0] + ((0.227549884188-0.834676334843j))*x_ref[1]**o + ((0.627135365192+0.164786667051j))*x_ref[1]
        arg[(2, 0, 1)]=(0.837499258151+0.268212965116j)*x[0]**o + ((0.568488141871+0.12288922737j))*x[0] + ((-0.467336532173-0.446063443543j))*x[1]**o + ((0.482905504269+0.103111814342j))*x[1]
        ref[(2, 0, 1)]=(0.837499258151+0.268212965116j)*x_ref[0]**o + ((0.568488141871+0.12288922737j))*x_ref[0] + ((-0.467336532173-0.446063443543j))*x_ref[1]**o + ((0.482905504269+0.103111814342j))*x_ref[1]
        arg[(2, 0, 2)]=(-0.966630898134+0.0585255229507j)*x[0]**o + ((-0.60253528927+0.395710370213j))*x[0] + ((-0.106422893153+0.649370700694j))*x[1]**o + ((0.00716266071935+0.483603199652j))*x[1]
        ref[(2, 0, 2)]=(-0.966630898134+0.0585255229507j)*x_ref[0]**o + ((-0.60253528927+0.395710370213j))*x_ref[0] + ((-0.106422893153+0.649370700694j))*x_ref[1]**o + ((0.00716266071935+0.483603199652j))*x_ref[1]
        arg[(2, 0, 3)]=(0.26813568303-0.483896162522j)*x[0]**o + ((-0.489364816139+0.96482127475j))*x[0] + ((-0.900350341-0.505269389064j))*x[1]**o + ((-0.129138910773+0.949404440308j))*x[1]
        ref[(2, 0, 3)]=(0.26813568303-0.483896162522j)*x_ref[0]**o + ((-0.489364816139+0.96482127475j))*x_ref[0] + ((-0.900350341-0.505269389064j))*x_ref[1]**o + ((-0.129138910773+0.949404440308j))*x_ref[1]
        arg[(2, 1, 0)]=(0.761912986708+0.788787682265j)*x[0]**o + ((0.197466170494+0.963367256044j))*x[0] + ((-0.821900712001+0.00992732124259j))*x[1]**o + ((-0.313336347646-0.512962073819j))*x[1]
        ref[(2, 1, 0)]=(0.761912986708+0.788787682265j)*x_ref[0]**o + ((0.197466170494+0.963367256044j))*x_ref[0] + ((-0.821900712001+0.00992732124259j))*x_ref[1]**o + ((-0.313336347646-0.512962073819j))*x_ref[1]
        arg[(2, 1, 1)]=(-0.80720755529+0.254765833502j)*x[0]**o + ((0.524668770682-0.352927027008j))*x[0] + ((0.801988419318+0.122594368537j))*x[1]**o + ((0.107942894557-0.61470559289j))*x[1]
        ref[(2, 1, 1)]=(-0.80720755529+0.254765833502j)*x_ref[0]**o + ((0.524668770682-0.352927027008j))*x_ref[0] + ((0.801988419318+0.122594368537j))*x_ref[1]**o + ((0.107942894557-0.61470559289j))*x_ref[1]
        arg[(2, 1, 2)]=(-0.605728893625+0.137686181924j)*x[0]**o + ((-0.564090210657-0.98722047374j))*x[0] + ((-0.366486861498+0.0264555401797j))*x[1]**o + ((-0.36668188006+0.478264410028j))*x[1]
        ref[(2, 1, 2)]=(-0.605728893625+0.137686181924j)*x_ref[0]**o + ((-0.564090210657-0.98722047374j))*x_ref[0] + ((-0.366486861498+0.0264555401797j))*x_ref[1]**o + ((-0.36668188006+0.478264410028j))*x_ref[1]
        arg[(2, 1, 3)]=(-0.441185219042+0.308783129688j)*x[0]**o + ((-0.242353513119+0.904754419081j))*x[0] + ((-0.547456461329-0.330746334794j))*x[1]**o + ((0.261824803147+0.554262910642j))*x[1]
        ref[(2, 1, 3)]=(-0.441185219042+0.308783129688j)*x_ref[0]**o + ((-0.242353513119+0.904754419081j))*x_ref[0] + ((-0.547456461329-0.330746334794j))*x_ref[1]**o + ((0.261824803147+0.554262910642j))*x_ref[1]
        arg[(2, 2, 0)]=(-0.171399878808+0.224703682323j)*x[0]**o + ((0.200461316211+0.514081470236j))*x[0] + ((0.985374487992+0.123681991755j))*x[1]**o + ((-0.516494255777-0.343085064557j))*x[1]
        ref[(2, 2, 0)]=(-0.171399878808+0.224703682323j)*x_ref[0]**o + ((0.200461316211+0.514081470236j))*x_ref[0] + ((0.985374487992+0.123681991755j))*x_ref[1]**o + ((-0.516494255777-0.343085064557j))*x_ref[1]
        arg[(2, 2, 1)]=(0.303320471752+0.232262803063j)*x[0]**o + ((-0.55826879184+0.317626328382j))*x[0] + ((-0.0429805387236+0.443176198709j))*x[1]**o + ((-0.134932452937+0.116232617323j))*x[1]
        ref[(2, 2, 1)]=(0.303320471752+0.232262803063j)*x_ref[0]**o + ((-0.55826879184+0.317626328382j))*x_ref[0] + ((-0.0429805387236+0.443176198709j))*x_ref[1]**o + ((-0.134932452937+0.116232617323j))*x_ref[1]
        arg[(2, 2, 2)]=(0.846600409576+0.181620902149j)*x[0]**o + ((-0.0442428330798+0.0302248722982j))*x[0] + ((0.236567603964-0.427038379098j))*x[1]**o + ((-0.371785397354+0.250893322915j))*x[1]
        ref[(2, 2, 2)]=(0.846600409576+0.181620902149j)*x_ref[0]**o + ((-0.0442428330798+0.0302248722982j))*x_ref[0] + ((0.236567603964-0.427038379098j))*x_ref[1]**o + ((-0.371785397354+0.250893322915j))*x_ref[1]
        arg[(2, 2, 3)]=(0.968854897449-0.826669903924j)*x[0]**o + ((0.323328756181-0.561890056303j))*x[0] + ((0.842657047911-0.877015213428j))*x[1]**o + ((0.0190299048544-0.353603466749j))*x[1]
        ref[(2, 2, 3)]=(0.968854897449-0.826669903924j)*x_ref[0]**o + ((0.323328756181-0.561890056303j))*x_ref[0] + ((0.842657047911-0.877015213428j))*x_ref[1]**o + ((0.0190299048544-0.353603466749j))*x_ref[1]
        arg[(3, 0, 0)]=(0.888071693862-0.935654156662j)*x[0]**o + ((-0.42122794591-0.650407034956j))*x[0] + ((-0.845190739883+0.0837055793839j))*x[1]**o + ((0.370564114802-0.528157275907j))*x[1]
        ref[(3, 0, 0)]=(0.888071693862-0.935654156662j)*x_ref[0]**o + ((-0.42122794591-0.650407034956j))*x_ref[0] + ((-0.845190739883+0.0837055793839j))*x_ref[1]**o + ((0.370564114802-0.528157275907j))*x_ref[1]
        arg[(3, 0, 1)]=(-0.427767321647+0.803093364888j)*x[0]**o + ((0.508617152808-0.919194801779j))*x[0] + ((-0.276929166324-0.0224997214171j))*x[1]**o + ((0.684975477094+0.705392457659j))*x[1]
        ref[(3, 0, 1)]=(-0.427767321647+0.803093364888j)*x_ref[0]**o + ((0.508617152808-0.919194801779j))*x_ref[0] + ((-0.276929166324-0.0224997214171j))*x_ref[1]**o + ((0.684975477094+0.705392457659j))*x_ref[1]
        arg[(3, 0, 2)]=(-0.0296455601547+0.164516571054j)*x[0]**o + ((0.941865213333+0.45216953173j))*x[0] + ((0.412309482532+0.488106785467j))*x[1]**o + ((0.959490971775+0.535815221075j))*x[1]
        ref[(3, 0, 2)]=(-0.0296455601547+0.164516571054j)*x_ref[0]**o + ((0.941865213333+0.45216953173j))*x_ref[0] + ((0.412309482532+0.488106785467j))*x_ref[1]**o + ((0.959490971775+0.535815221075j))*x_ref[1]
        arg[(3, 0, 3)]=(-0.215401296432-0.0847298142128j)*x[0]**o + ((-0.147272621965-0.935034714248j))*x[0] + ((-0.730294200991-0.611496425185j))*x[1]**o + ((-0.324762812435+0.190139792114j))*x[1]
        ref[(3, 0, 3)]=(-0.215401296432-0.0847298142128j)*x_ref[0]**o + ((-0.147272621965-0.935034714248j))*x_ref[0] + ((-0.730294200991-0.611496425185j))*x_ref[1]**o + ((-0.324762812435+0.190139792114j))*x_ref[1]
        arg[(3, 1, 0)]=(0.702359222466+0.0701532187961j)*x[0]**o + ((0.843530842942+0.536645731843j))*x[0] + ((0.535616106344-0.446729545387j))*x[1]**o + ((0.662690906934+0.99748546846j))*x[1]
        ref[(3, 1, 0)]=(0.702359222466+0.0701532187961j)*x_ref[0]**o + ((0.843530842942+0.536645731843j))*x_ref[0] + ((0.535616106344-0.446729545387j))*x_ref[1]**o + ((0.662690906934+0.99748546846j))*x_ref[1]
        arg[(3, 1, 1)]=(0.839033926301+0.690536448001j)*x[0]**o + ((-0.217288027787+0.715173481557j))*x[0] + ((-0.240973892479+0.247991266323j))*x[1]**o + ((0.707993294353+0.0789635239818j))*x[1]
        ref[(3, 1, 1)]=(0.839033926301+0.690536448001j)*x_ref[0]**o + ((-0.217288027787+0.715173481557j))*x_ref[0] + ((-0.240973892479+0.247991266323j))*x_ref[1]**o + ((0.707993294353+0.0789635239818j))*x_ref[1]
        arg[(3, 1, 2)]=(0.976072393025-0.278211043184j)*x[0]**o + ((0.428506326178-0.250456795629j))*x[0] + ((0.99548954181+0.503235176039j))*x[1]**o + ((0.818935976751-0.705215819768j))*x[1]
        ref[(3, 1, 2)]=(0.976072393025-0.278211043184j)*x_ref[0]**o + ((0.428506326178-0.250456795629j))*x_ref[0] + ((0.99548954181+0.503235176039j))*x_ref[1]**o + ((0.818935976751-0.705215819768j))*x_ref[1]
        arg[(3, 1, 3)]=(-0.941088457523+0.659489407926j)*x[0]**o + ((-0.349351545219+0.0899797403802j))*x[0] + ((0.392849985989-0.0833042858892j))*x[1]**o + ((-0.154894858037+0.705655105867j))*x[1]
        ref[(3, 1, 3)]=(-0.941088457523+0.659489407926j)*x_ref[0]**o + ((-0.349351545219+0.0899797403802j))*x_ref[0] + ((0.392849985989-0.0833042858892j))*x_ref[1]**o + ((-0.154894858037+0.705655105867j))*x_ref[1]
        arg[(3, 2, 0)]=(0.276670996914+0.107983016386j)*x[0]**o + ((-0.895428465168-0.0647599157859j))*x[0] + ((0.165679970766-0.782730049629j))*x[1]**o + ((-0.27502736185+0.482072959426j))*x[1]
        ref[(3, 2, 0)]=(0.276670996914+0.107983016386j)*x_ref[0]**o + ((-0.895428465168-0.0647599157859j))*x_ref[0] + ((0.165679970766-0.782730049629j))*x_ref[1]**o + ((-0.27502736185+0.482072959426j))*x_ref[1]
        arg[(3, 2, 1)]=(0.32144471253-0.66629796217j)*x[0]**o + ((-0.325507634247-0.960940723583j))*x[0] + ((-0.839150488592-0.398402220116j))*x[1]**o + ((-0.568634956988+0.834327863895j))*x[1]
        ref[(3, 2, 1)]=(0.32144471253-0.66629796217j)*x_ref[0]**o + ((-0.325507634247-0.960940723583j))*x_ref[0] + ((-0.839150488592-0.398402220116j))*x_ref[1]**o + ((-0.568634956988+0.834327863895j))*x_ref[1]
        arg[(3, 2, 2)]=(-0.552476602842-0.642888388915j)*x[0]**o + ((-0.77717079441+0.223575330664j))*x[0] + ((-0.678223651264+0.375391298851j))*x[1]**o + ((0.535019512617-0.288171799757j))*x[1]
        ref[(3, 2, 2)]=(-0.552476602842-0.642888388915j)*x_ref[0]**o + ((-0.77717079441+0.223575330664j))*x_ref[0] + ((-0.678223651264+0.375391298851j))*x_ref[1]**o + ((0.535019512617-0.288171799757j))*x_ref[1]
        arg[(3, 2, 3)]=(0.132639112884-0.367758549671j)*x[0]**o + ((-0.531960013434+0.325181380449j))*x[0] + ((-0.307559657173+0.850472740709j))*x[1]**o + ((0.630213950867+0.400175264379j))*x[1]
        ref[(3, 2, 3)]=(0.132639112884-0.367758549671j)*x_ref[0]**o + ((-0.531960013434+0.325181380449j))*x_ref[0] + ((-0.307559657173+0.850472740709j))*x_ref[1]**o + ((0.630213950867+0.400175264379j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(0.773983448671-0.883723831924j)*x[2]**o + ((0.275771022866+0.587153034525j))*x[2]
            ref[(0, 0, 0)]+=(0.773983448671-0.883723831924j)*x_ref[2]**o + ((0.275771022866+0.587153034525j))*x_ref[2]
            arg[(0, 0, 1)]+=(0.618193429622+0.322374212678j)*x[2]**o + ((-0.0254353857854+0.0975454893281j))*x[2]
            ref[(0, 0, 1)]+=(0.618193429622+0.322374212678j)*x_ref[2]**o + ((-0.0254353857854+0.0975454893281j))*x_ref[2]
            arg[(0, 0, 2)]+=(-0.993129005939-0.636183882495j)*x[2]**o + ((-0.925872320951+0.58225504899j))*x[2]
            ref[(0, 0, 2)]+=(-0.993129005939-0.636183882495j)*x_ref[2]**o + ((-0.925872320951+0.58225504899j))*x_ref[2]
            arg[(0, 0, 3)]+=(-0.0281713282193-0.428779060594j)*x[2]**o + ((-0.498498120661-0.559462665266j))*x[2]
            ref[(0, 0, 3)]+=(-0.0281713282193-0.428779060594j)*x_ref[2]**o + ((-0.498498120661-0.559462665266j))*x_ref[2]
            arg[(0, 1, 0)]+=(0.821259391162-0.756010244044j)*x[2]**o + ((-0.863127798935+0.0294991751895j))*x[2]
            ref[(0, 1, 0)]+=(0.821259391162-0.756010244044j)*x_ref[2]**o + ((-0.863127798935+0.0294991751895j))*x_ref[2]
            arg[(0, 1, 1)]+=(0.762908345076+0.611013877173j)*x[2]**o + ((-0.369576918801-0.00622467138883j))*x[2]
            ref[(0, 1, 1)]+=(0.762908345076+0.611013877173j)*x_ref[2]**o + ((-0.369576918801-0.00622467138883j))*x_ref[2]
            arg[(0, 1, 2)]+=(0.810208020719-0.863879583355j)*x[2]**o + ((-0.837535746869-0.601725176043j))*x[2]
            ref[(0, 1, 2)]+=(0.810208020719-0.863879583355j)*x_ref[2]**o + ((-0.837535746869-0.601725176043j))*x_ref[2]
            arg[(0, 1, 3)]+=(-0.713039318925-0.113520615398j)*x[2]**o + ((-0.509178833766-0.345552406633j))*x[2]
            ref[(0, 1, 3)]+=(-0.713039318925-0.113520615398j)*x_ref[2]**o + ((-0.509178833766-0.345552406633j))*x_ref[2]
            arg[(0, 2, 0)]+=(-0.975058790792+0.31932809718j)*x[2]**o + ((0.173359176035+0.839208872201j))*x[2]
            ref[(0, 2, 0)]+=(-0.975058790792+0.31932809718j)*x_ref[2]**o + ((0.173359176035+0.839208872201j))*x_ref[2]
            arg[(0, 2, 1)]+=(-0.385905742269-0.196316785362j)*x[2]**o + ((-0.413672596336-0.362332937759j))*x[2]
            ref[(0, 2, 1)]+=(-0.385905742269-0.196316785362j)*x_ref[2]**o + ((-0.413672596336-0.362332937759j))*x_ref[2]
            arg[(0, 2, 2)]+=(-0.222269632139+0.230510234517j)*x[2]**o + ((0.981789991558+0.541114808534j))*x[2]
            ref[(0, 2, 2)]+=(-0.222269632139+0.230510234517j)*x_ref[2]**o + ((0.981789991558+0.541114808534j))*x_ref[2]
            arg[(0, 2, 3)]+=(0.788158642075+0.0789563649002j)*x[2]**o + ((0.112739443349+0.444178729002j))*x[2]
            ref[(0, 2, 3)]+=(0.788158642075+0.0789563649002j)*x_ref[2]**o + ((0.112739443349+0.444178729002j))*x_ref[2]
            arg[(1, 0, 0)]+=(-0.0492292230732-0.40228728359j)*x[2]**o + ((-0.514484263716-0.589613256872j))*x[2]
            ref[(1, 0, 0)]+=(-0.0492292230732-0.40228728359j)*x_ref[2]**o + ((-0.514484263716-0.589613256872j))*x_ref[2]
            arg[(1, 0, 1)]+=(0.587820603239-0.0350407886629j)*x[2]**o + ((0.880926039218+0.973284320364j))*x[2]
            ref[(1, 0, 1)]+=(0.587820603239-0.0350407886629j)*x_ref[2]**o + ((0.880926039218+0.973284320364j))*x_ref[2]
            arg[(1, 0, 2)]+=(0.802134600154-0.0343670982955j)*x[2]**o + ((-0.364263689539+0.369753003677j))*x[2]
            ref[(1, 0, 2)]+=(0.802134600154-0.0343670982955j)*x_ref[2]**o + ((-0.364263689539+0.369753003677j))*x_ref[2]
            arg[(1, 0, 3)]+=(-0.287586056143-0.96882832573j)*x[2]**o + ((0.939411227939-0.905948195992j))*x[2]
            ref[(1, 0, 3)]+=(-0.287586056143-0.96882832573j)*x_ref[2]**o + ((0.939411227939-0.905948195992j))*x_ref[2]
            arg[(1, 1, 0)]+=(0.854357206026+0.00972299880944j)*x[2]**o + ((-0.961363478116+0.377852267062j))*x[2]
            ref[(1, 1, 0)]+=(0.854357206026+0.00972299880944j)*x_ref[2]**o + ((-0.961363478116+0.377852267062j))*x_ref[2]
            arg[(1, 1, 1)]+=(-0.337510733135+0.0893241318366j)*x[2]**o + ((0.943743471615+0.290590111462j))*x[2]
            ref[(1, 1, 1)]+=(-0.337510733135+0.0893241318366j)*x_ref[2]**o + ((0.943743471615+0.290590111462j))*x_ref[2]
            arg[(1, 1, 2)]+=(0.784740107849+0.753788985695j)*x[2]**o + ((-0.10478703332-0.842184725413j))*x[2]
            ref[(1, 1, 2)]+=(0.784740107849+0.753788985695j)*x_ref[2]**o + ((-0.10478703332-0.842184725413j))*x_ref[2]
            arg[(1, 1, 3)]+=(0.766668132533+0.0222705162164j)*x[2]**o + ((0.613122705908+0.954359341449j))*x[2]
            ref[(1, 1, 3)]+=(0.766668132533+0.0222705162164j)*x_ref[2]**o + ((0.613122705908+0.954359341449j))*x_ref[2]
            arg[(1, 2, 0)]+=(0.846566928175-0.38177758803j)*x[2]**o + ((-0.745641648461+0.472958805915j))*x[2]
            ref[(1, 2, 0)]+=(0.846566928175-0.38177758803j)*x_ref[2]**o + ((-0.745641648461+0.472958805915j))*x_ref[2]
            arg[(1, 2, 1)]+=(0.754709896867+0.660762939679j)*x[2]**o + ((0.762834946308-0.894452061431j))*x[2]
            ref[(1, 2, 1)]+=(0.754709896867+0.660762939679j)*x_ref[2]**o + ((0.762834946308-0.894452061431j))*x_ref[2]
            arg[(1, 2, 2)]+=(0.246302287018-0.975502479175j)*x[2]**o + ((-0.143967386257-0.185852666777j))*x[2]
            ref[(1, 2, 2)]+=(0.246302287018-0.975502479175j)*x_ref[2]**o + ((-0.143967386257-0.185852666777j))*x_ref[2]
            arg[(1, 2, 3)]+=(-0.881189014418+0.630552775253j)*x[2]**o + ((-0.75323195592+0.86353329102j))*x[2]
            ref[(1, 2, 3)]+=(-0.881189014418+0.630552775253j)*x_ref[2]**o + ((-0.75323195592+0.86353329102j))*x_ref[2]
            arg[(2, 0, 0)]+=(0.277166661762-0.236011752436j)*x[2]**o + ((0.297759958747-0.497339520195j))*x[2]
            ref[(2, 0, 0)]+=(0.277166661762-0.236011752436j)*x_ref[2]**o + ((0.297759958747-0.497339520195j))*x_ref[2]
            arg[(2, 0, 1)]+=(0.217529303748-0.914483705212j)*x[2]**o + ((-0.191091058203-0.347106402584j))*x[2]
            ref[(2, 0, 1)]+=(0.217529303748-0.914483705212j)*x_ref[2]**o + ((-0.191091058203-0.347106402584j))*x_ref[2]
            arg[(2, 0, 2)]+=(-0.219814063641+0.403983387754j)*x[2]**o + ((0.655190352765+0.863015812437j))*x[2]
            ref[(2, 0, 2)]+=(-0.219814063641+0.403983387754j)*x_ref[2]**o + ((0.655190352765+0.863015812437j))*x_ref[2]
            arg[(2, 0, 3)]+=(-0.877481622515+0.970866944946j)*x[2]**o + ((-0.547253812772+0.112362095894j))*x[2]
            ref[(2, 0, 3)]+=(-0.877481622515+0.970866944946j)*x_ref[2]**o + ((-0.547253812772+0.112362095894j))*x_ref[2]
            arg[(2, 1, 0)]+=(-0.733593700729-0.546742805431j)*x[2]**o + ((0.39285443719+0.570521442896j))*x[2]
            ref[(2, 1, 0)]+=(-0.733593700729-0.546742805431j)*x_ref[2]**o + ((0.39285443719+0.570521442896j))*x_ref[2]
            arg[(2, 1, 1)]+=(0.528860812856+0.0703307790549j)*x[2]**o + ((0.0920560343502-0.295616927153j))*x[2]
            ref[(2, 1, 1)]+=(0.528860812856+0.0703307790549j)*x_ref[2]**o + ((0.0920560343502-0.295616927153j))*x_ref[2]
            arg[(2, 1, 2)]+=(0.411671031004-0.9132542844j)*x[2]**o + ((0.742420766145+0.113410376945j))*x[2]
            ref[(2, 1, 2)]+=(0.411671031004-0.9132542844j)*x_ref[2]**o + ((0.742420766145+0.113410376945j))*x_ref[2]
            arg[(2, 1, 3)]+=(-0.644352393979-0.761110600007j)*x[2]**o + ((-0.59247403295-0.625184374865j))*x[2]
            ref[(2, 1, 3)]+=(-0.644352393979-0.761110600007j)*x_ref[2]**o + ((-0.59247403295-0.625184374865j))*x_ref[2]
            arg[(2, 2, 0)]+=(-0.659458523848-0.726622337071j)*x[2]**o + ((0.0452578482987-0.247484190374j))*x[2]
            ref[(2, 2, 0)]+=(-0.659458523848-0.726622337071j)*x_ref[2]**o + ((0.0452578482987-0.247484190374j))*x_ref[2]
            arg[(2, 2, 1)]+=(0.979420225426+0.0883270654905j)*x[2]**o + ((-0.261980877523-0.0842475488393j))*x[2]
            ref[(2, 2, 1)]+=(0.979420225426+0.0883270654905j)*x_ref[2]**o + ((-0.261980877523-0.0842475488393j))*x_ref[2]
            arg[(2, 2, 2)]+=(-0.698654025726-0.00141137551184j)*x[2]**o + ((0.260883003105-0.199260627391j))*x[2]
            ref[(2, 2, 2)]+=(-0.698654025726-0.00141137551184j)*x_ref[2]**o + ((0.260883003105-0.199260627391j))*x_ref[2]
            arg[(2, 2, 3)]+=(-0.408361036491-0.00680521377362j)*x[2]**o + ((0.931847741682-0.584396155039j))*x[2]
            ref[(2, 2, 3)]+=(-0.408361036491-0.00680521377362j)*x_ref[2]**o + ((0.931847741682-0.584396155039j))*x_ref[2]
            arg[(3, 0, 0)]+=(0.417250513284+0.0915293293225j)*x[2]**o + ((0.32325753074+0.941594366711j))*x[2]
            ref[(3, 0, 0)]+=(0.417250513284+0.0915293293225j)*x_ref[2]**o + ((0.32325753074+0.941594366711j))*x_ref[2]
            arg[(3, 0, 1)]+=(0.983573621748-0.11755595747j)*x[2]**o + ((0.392624960594+0.364523749558j))*x[2]
            ref[(3, 0, 1)]+=(0.983573621748-0.11755595747j)*x_ref[2]**o + ((0.392624960594+0.364523749558j))*x_ref[2]
            arg[(3, 0, 2)]+=(0.874577557037+0.742211639405j)*x[2]**o + ((0.900534761398+0.432369096979j))*x[2]
            ref[(3, 0, 2)]+=(0.874577557037+0.742211639405j)*x_ref[2]**o + ((0.900534761398+0.432369096979j))*x_ref[2]
            arg[(3, 0, 3)]+=(0.386318381264-0.711034765769j)*x[2]**o + ((-0.237804939809-0.889745855748j))*x[2]
            ref[(3, 0, 3)]+=(0.386318381264-0.711034765769j)*x_ref[2]**o + ((-0.237804939809-0.889745855748j))*x_ref[2]
            arg[(3, 1, 0)]+=(-0.93969894953-0.415838599923j)*x[2]**o + ((-0.701934229394+0.940384600311j))*x[2]
            ref[(3, 1, 0)]+=(-0.93969894953-0.415838599923j)*x_ref[2]**o + ((-0.701934229394+0.940384600311j))*x_ref[2]
            arg[(3, 1, 1)]+=(0.278184362638+0.740888177223j)*x[2]**o + ((-0.180348528455-0.612499271303j))*x[2]
            ref[(3, 1, 1)]+=(0.278184362638+0.740888177223j)*x_ref[2]**o + ((-0.180348528455-0.612499271303j))*x_ref[2]
            arg[(3, 1, 2)]+=(-0.362215622053-0.146590381652j)*x[2]**o + ((0.259747372036+0.51269389658j))*x[2]
            ref[(3, 1, 2)]+=(-0.362215622053-0.146590381652j)*x_ref[2]**o + ((0.259747372036+0.51269389658j))*x_ref[2]
            arg[(3, 1, 3)]+=(-0.00519288608366+0.0167759111858j)*x[2]**o + ((-0.244261592808+0.883904387347j))*x[2]
            ref[(3, 1, 3)]+=(-0.00519288608366+0.0167759111858j)*x_ref[2]**o + ((-0.244261592808+0.883904387347j))*x_ref[2]
            arg[(3, 2, 0)]+=(-0.452159278964-0.900491701785j)*x[2]**o + ((-0.215485571254+0.0477537686223j))*x[2]
            ref[(3, 2, 0)]+=(-0.452159278964-0.900491701785j)*x_ref[2]**o + ((-0.215485571254+0.0477537686223j))*x_ref[2]
            arg[(3, 2, 1)]+=(0.788880592647+0.734982350113j)*x[2]**o + ((0.137117701999+0.922696915687j))*x[2]
            ref[(3, 2, 1)]+=(0.788880592647+0.734982350113j)*x_ref[2]**o + ((0.137117701999+0.922696915687j))*x_ref[2]
            arg[(3, 2, 2)]+=(-0.836268085445-0.375894355965j)*x[2]**o + ((-0.611777439182+0.311378477709j))*x[2]
            ref[(3, 2, 2)]+=(-0.836268085445-0.375894355965j)*x_ref[2]**o + ((-0.611777439182+0.311378477709j))*x_ref[2]
            arg[(3, 2, 3)]+=(0.46037655089-0.44998579452j)*x[2]**o + ((0.660271363774-0.306066344182j))*x[2]
            ref[(3, 2, 3)]+=(0.46037655089-0.44998579452j)*x_ref[2]**o + ((0.660271363774-0.306066344182j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Solution_rank4(self):
        """
        tests interpolation of rank 4 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4, 3, 2),w)
        ref = Data(0,(2, 4, 3, 2),w_ref)
        arg[(0, 0, 0, 0)]=(0.433587586429-0.0617578297746j)*x[0]**o + ((-0.139736398322-0.550934391781j))*x[0] + ((-0.334640801849+0.377615827507j))*x[1]**o + ((0.661769800665+0.586854741167j))*x[1]
        ref[(0, 0, 0, 0)]=(0.433587586429-0.0617578297746j)*x_ref[0]**o + ((-0.139736398322-0.550934391781j))*x_ref[0] + ((-0.334640801849+0.377615827507j))*x_ref[1]**o + ((0.661769800665+0.586854741167j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.709619774534-0.620352575816j)*x[0]**o + ((-0.842600444951+0.574153718884j))*x[0] + ((-0.48171536393+0.434519306739j))*x[1]**o + ((-0.503375899665+0.567433242927j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.709619774534-0.620352575816j)*x_ref[0]**o + ((-0.842600444951+0.574153718884j))*x_ref[0] + ((-0.48171536393+0.434519306739j))*x_ref[1]**o + ((-0.503375899665+0.567433242927j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(0.379640873977+0.145301500785j)*x[0]**o + ((0.349215092901+0.398272095008j))*x[0] + ((-0.620468284089-0.599806686466j))*x[1]**o + ((0.433214812403+0.139233291011j))*x[1]
        ref[(0, 0, 1, 0)]=(0.379640873977+0.145301500785j)*x_ref[0]**o + ((0.349215092901+0.398272095008j))*x_ref[0] + ((-0.620468284089-0.599806686466j))*x_ref[1]**o + ((0.433214812403+0.139233291011j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(0.0804161349762-0.311430139943j)*x[0]**o + ((0.50349136001+0.418578792546j))*x[0] + ((-0.311775336547-0.129871317288j))*x[1]**o + ((0.0427477887677-0.568269908455j))*x[1]
        ref[(0, 0, 1, 1)]=(0.0804161349762-0.311430139943j)*x_ref[0]**o + ((0.50349136001+0.418578792546j))*x_ref[0] + ((-0.311775336547-0.129871317288j))*x_ref[1]**o + ((0.0427477887677-0.568269908455j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(0.78958354902+0.0571339415021j)*x[0]**o + ((0.736555454859+0.763379211766j))*x[0] + ((0.332481921323+0.437427036828j))*x[1]**o + ((-0.82386912652+0.817684610503j))*x[1]
        ref[(0, 0, 2, 0)]=(0.78958354902+0.0571339415021j)*x_ref[0]**o + ((0.736555454859+0.763379211766j))*x_ref[0] + ((0.332481921323+0.437427036828j))*x_ref[1]**o + ((-0.82386912652+0.817684610503j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(0.887451129215-0.92103598534j)*x[0]**o + ((0.268765374005-0.772116346646j))*x[0] + ((0.828186569776+0.0677014249038j))*x[1]**o + ((0.580065109775-0.56516843593j))*x[1]
        ref[(0, 0, 2, 1)]=(0.887451129215-0.92103598534j)*x_ref[0]**o + ((0.268765374005-0.772116346646j))*x_ref[0] + ((0.828186569776+0.0677014249038j))*x_ref[1]**o + ((0.580065109775-0.56516843593j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.994262077997+0.0573301199942j)*x[0]**o + ((0.318844450892+0.882354487138j))*x[0] + ((0.772012625284+0.203919261189j))*x[1]**o + ((0.453698635568+0.416047358508j))*x[1]
        ref[(0, 1, 0, 0)]=(0.994262077997+0.0573301199942j)*x_ref[0]**o + ((0.318844450892+0.882354487138j))*x_ref[0] + ((0.772012625284+0.203919261189j))*x_ref[1]**o + ((0.453698635568+0.416047358508j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(0.996318701445-0.319207945497j)*x[0]**o + ((0.937916821312-0.499253847379j))*x[0] + ((-0.879010978024-0.36548555273j))*x[1]**o + ((0.818554078963+0.528453131109j))*x[1]
        ref[(0, 1, 0, 1)]=(0.996318701445-0.319207945497j)*x_ref[0]**o + ((0.937916821312-0.499253847379j))*x_ref[0] + ((-0.879010978024-0.36548555273j))*x_ref[1]**o + ((0.818554078963+0.528453131109j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(0.0761128624888-0.924539006538j)*x[0]**o + ((-0.220179940931-0.986438125349j))*x[0] + ((-0.139127952844-0.221250958734j))*x[1]**o + ((0.156029546987-0.383308724895j))*x[1]
        ref[(0, 1, 1, 0)]=(0.0761128624888-0.924539006538j)*x_ref[0]**o + ((-0.220179940931-0.986438125349j))*x_ref[0] + ((-0.139127952844-0.221250958734j))*x_ref[1]**o + ((0.156029546987-0.383308724895j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(-0.763263122858+0.647524977396j)*x[0]**o + ((0.704666922222+0.459911886619j))*x[0] + ((0.460817916915-0.807279160432j))*x[1]**o + ((0.155399674455-0.0676265505077j))*x[1]
        ref[(0, 1, 1, 1)]=(-0.763263122858+0.647524977396j)*x_ref[0]**o + ((0.704666922222+0.459911886619j))*x_ref[0] + ((0.460817916915-0.807279160432j))*x_ref[1]**o + ((0.155399674455-0.0676265505077j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(0.651926119651+0.594451264865j)*x[0]**o + ((-0.451489644246-0.741844323049j))*x[0] + ((0.186743430443+0.209113134442j))*x[1]**o + ((-0.958551656811-0.64147355446j))*x[1]
        ref[(0, 1, 2, 0)]=(0.651926119651+0.594451264865j)*x_ref[0]**o + ((-0.451489644246-0.741844323049j))*x_ref[0] + ((0.186743430443+0.209113134442j))*x_ref[1]**o + ((-0.958551656811-0.64147355446j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(0.309488731635-0.584062739183j)*x[0]**o + ((-0.692771801491-0.737863499597j))*x[0] + ((0.146988529193+0.951954846763j))*x[1]**o + ((-0.0755441261106-0.328055412652j))*x[1]
        ref[(0, 1, 2, 1)]=(0.309488731635-0.584062739183j)*x_ref[0]**o + ((-0.692771801491-0.737863499597j))*x_ref[0] + ((0.146988529193+0.951954846763j))*x_ref[1]**o + ((-0.0755441261106-0.328055412652j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(0.958060965262-0.515225264131j)*x[0]**o + ((0.943932415772-0.986453160659j))*x[0] + ((0.479448481692-0.21436680202j))*x[1]**o + ((-0.664616699093-0.428361948135j))*x[1]
        ref[(0, 2, 0, 0)]=(0.958060965262-0.515225264131j)*x_ref[0]**o + ((0.943932415772-0.986453160659j))*x_ref[0] + ((0.479448481692-0.21436680202j))*x_ref[1]**o + ((-0.664616699093-0.428361948135j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(0.313198040166-0.415777899425j)*x[0]**o + ((0.159849905231-0.767304582721j))*x[0] + ((0.699117586066+0.350261200158j))*x[1]**o + ((0.0725015953372+0.98953980165j))*x[1]
        ref[(0, 2, 0, 1)]=(0.313198040166-0.415777899425j)*x_ref[0]**o + ((0.159849905231-0.767304582721j))*x_ref[0] + ((0.699117586066+0.350261200158j))*x_ref[1]**o + ((0.0725015953372+0.98953980165j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(0.954553071422-0.0194870311166j)*x[0]**o + ((-0.00882730255865-0.55563884748j))*x[0] + ((0.521941066674-0.903317973149j))*x[1]**o + ((0.0399340393193+0.335244205806j))*x[1]
        ref[(0, 2, 1, 0)]=(0.954553071422-0.0194870311166j)*x_ref[0]**o + ((-0.00882730255865-0.55563884748j))*x_ref[0] + ((0.521941066674-0.903317973149j))*x_ref[1]**o + ((0.0399340393193+0.335244205806j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(-0.959870753247-0.653143690044j)*x[0]**o + ((-0.865493986867-0.76792578856j))*x[0] + ((0.201291789041+0.201606182453j))*x[1]**o + ((0.454261130909-0.981720396756j))*x[1]
        ref[(0, 2, 1, 1)]=(-0.959870753247-0.653143690044j)*x_ref[0]**o + ((-0.865493986867-0.76792578856j))*x_ref[0] + ((0.201291789041+0.201606182453j))*x_ref[1]**o + ((0.454261130909-0.981720396756j))*x_ref[1]
        arg[(0, 2, 2, 0)]=(-0.115733946107-0.73266894071j)*x[0]**o + ((-0.846886914119+0.560770947569j))*x[0] + ((0.489747238148+0.154464757687j))*x[1]**o + ((-0.0938018880389-0.919078540461j))*x[1]
        ref[(0, 2, 2, 0)]=(-0.115733946107-0.73266894071j)*x_ref[0]**o + ((-0.846886914119+0.560770947569j))*x_ref[0] + ((0.489747238148+0.154464757687j))*x_ref[1]**o + ((-0.0938018880389-0.919078540461j))*x_ref[1]
        arg[(0, 2, 2, 1)]=(-0.935209103341+0.493197647372j)*x[0]**o + ((-0.426679241274-0.981264273962j))*x[0] + ((-0.180290604141-0.8211923846j))*x[1]**o + ((-0.668866136516-0.726854835776j))*x[1]
        ref[(0, 2, 2, 1)]=(-0.935209103341+0.493197647372j)*x_ref[0]**o + ((-0.426679241274-0.981264273962j))*x_ref[0] + ((-0.180290604141-0.8211923846j))*x_ref[1]**o + ((-0.668866136516-0.726854835776j))*x_ref[1]
        arg[(0, 3, 0, 0)]=(-0.21711169363-0.106705753277j)*x[0]**o + ((0.670565810898-0.741292579745j))*x[0] + ((0.549838719463+0.407593983071j))*x[1]**o + ((-0.716480806373+0.962007510796j))*x[1]
        ref[(0, 3, 0, 0)]=(-0.21711169363-0.106705753277j)*x_ref[0]**o + ((0.670565810898-0.741292579745j))*x_ref[0] + ((0.549838719463+0.407593983071j))*x_ref[1]**o + ((-0.716480806373+0.962007510796j))*x_ref[1]
        arg[(0, 3, 0, 1)]=(-0.206572382395+0.695425157051j)*x[0]**o + ((-0.220220184982-0.132458408951j))*x[0] + ((0.0787449129291-0.701084661703j))*x[1]**o + ((0.0228226175551-0.10517401455j))*x[1]
        ref[(0, 3, 0, 1)]=(-0.206572382395+0.695425157051j)*x_ref[0]**o + ((-0.220220184982-0.132458408951j))*x_ref[0] + ((0.0787449129291-0.701084661703j))*x_ref[1]**o + ((0.0228226175551-0.10517401455j))*x_ref[1]
        arg[(0, 3, 1, 0)]=(-0.919310143495+0.938712403338j)*x[0]**o + ((0.400540299124-0.290734486265j))*x[0] + ((0.845230986812-0.385647167282j))*x[1]**o + ((0.027068221337-0.785557692105j))*x[1]
        ref[(0, 3, 1, 0)]=(-0.919310143495+0.938712403338j)*x_ref[0]**o + ((0.400540299124-0.290734486265j))*x_ref[0] + ((0.845230986812-0.385647167282j))*x_ref[1]**o + ((0.027068221337-0.785557692105j))*x_ref[1]
        arg[(0, 3, 1, 1)]=(0.240680617293-0.177634098538j)*x[0]**o + ((0.696975325362+0.890286647412j))*x[0] + ((-0.657298966493+0.772701155339j))*x[1]**o + ((0.429753557006-0.35728389891j))*x[1]
        ref[(0, 3, 1, 1)]=(0.240680617293-0.177634098538j)*x_ref[0]**o + ((0.696975325362+0.890286647412j))*x_ref[0] + ((-0.657298966493+0.772701155339j))*x_ref[1]**o + ((0.429753557006-0.35728389891j))*x_ref[1]
        arg[(0, 3, 2, 0)]=(0.634608291805+0.344064662305j)*x[0]**o + ((-0.925728093441+0.84299737084j))*x[0] + ((0.842689205811+0.0733353239855j))*x[1]**o + ((-0.465134113067-0.25995054383j))*x[1]
        ref[(0, 3, 2, 0)]=(0.634608291805+0.344064662305j)*x_ref[0]**o + ((-0.925728093441+0.84299737084j))*x_ref[0] + ((0.842689205811+0.0733353239855j))*x_ref[1]**o + ((-0.465134113067-0.25995054383j))*x_ref[1]
        arg[(0, 3, 2, 1)]=(0.947865937387+0.158938914861j)*x[0]**o + ((0.716928907283-0.53901457574j))*x[0] + ((-0.415996571465+0.28889926015j))*x[1]**o + ((0.705417341275+0.502382662094j))*x[1]
        ref[(0, 3, 2, 1)]=(0.947865937387+0.158938914861j)*x_ref[0]**o + ((0.716928907283-0.53901457574j))*x_ref[0] + ((-0.415996571465+0.28889926015j))*x_ref[1]**o + ((0.705417341275+0.502382662094j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(-0.850872143893-0.741174160803j)*x[0]**o + ((-0.110846221889-0.200910298046j))*x[0] + ((0.866436914459+0.33123556895j))*x[1]**o + ((-0.357847993222-0.703933719762j))*x[1]
        ref[(1, 0, 0, 0)]=(-0.850872143893-0.741174160803j)*x_ref[0]**o + ((-0.110846221889-0.200910298046j))*x_ref[0] + ((0.866436914459+0.33123556895j))*x_ref[1]**o + ((-0.357847993222-0.703933719762j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.933032350169-0.455793916775j)*x[0]**o + ((0.0587612772948+0.364622262994j))*x[0] + ((0.497485474278-0.586106961051j))*x[1]**o + ((0.482095531483-0.882257001458j))*x[1]
        ref[(1, 0, 0, 1)]=(0.933032350169-0.455793916775j)*x_ref[0]**o + ((0.0587612772948+0.364622262994j))*x_ref[0] + ((0.497485474278-0.586106961051j))*x_ref[1]**o + ((0.482095531483-0.882257001458j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(0.543513731371-0.244767409262j)*x[0]**o + ((0.750977466374+0.864000252129j))*x[0] + ((-0.254050243486-0.227677535054j))*x[1]**o + ((-0.55131273111-0.876509995813j))*x[1]
        ref[(1, 0, 1, 0)]=(0.543513731371-0.244767409262j)*x_ref[0]**o + ((0.750977466374+0.864000252129j))*x_ref[0] + ((-0.254050243486-0.227677535054j))*x_ref[1]**o + ((-0.55131273111-0.876509995813j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(-0.429596101093-0.33010546025j)*x[0]**o + ((0.326979105196-0.4730622492j))*x[0] + ((-0.972546021377-0.384805604481j))*x[1]**o + ((-0.889058898653+0.73753255502j))*x[1]
        ref[(1, 0, 1, 1)]=(-0.429596101093-0.33010546025j)*x_ref[0]**o + ((0.326979105196-0.4730622492j))*x_ref[0] + ((-0.972546021377-0.384805604481j))*x_ref[1]**o + ((-0.889058898653+0.73753255502j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(-0.24199135479-0.284955874771j)*x[0]**o + ((0.593124412123+0.260865527823j))*x[0] + ((-0.806078347878-0.246458438533j))*x[1]**o + ((-0.759001723451+0.747209288255j))*x[1]
        ref[(1, 0, 2, 0)]=(-0.24199135479-0.284955874771j)*x_ref[0]**o + ((0.593124412123+0.260865527823j))*x_ref[0] + ((-0.806078347878-0.246458438533j))*x_ref[1]**o + ((-0.759001723451+0.747209288255j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(0.629977751719+0.343150811553j)*x[0]**o + ((0.571389988851+0.334414667653j))*x[0] + ((0.116508683523+0.194152509132j))*x[1]**o + ((0.890681673757+0.230509637349j))*x[1]
        ref[(1, 0, 2, 1)]=(0.629977751719+0.343150811553j)*x_ref[0]**o + ((0.571389988851+0.334414667653j))*x_ref[0] + ((0.116508683523+0.194152509132j))*x_ref[1]**o + ((0.890681673757+0.230509637349j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(-0.576244255049-0.242826170252j)*x[0]**o + ((-0.195620366511-0.893680286979j))*x[0] + ((-0.969384288997-0.719301447444j))*x[1]**o + ((0.596088410631-0.539032768548j))*x[1]
        ref[(1, 1, 0, 0)]=(-0.576244255049-0.242826170252j)*x_ref[0]**o + ((-0.195620366511-0.893680286979j))*x_ref[0] + ((-0.969384288997-0.719301447444j))*x_ref[1]**o + ((0.596088410631-0.539032768548j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(-0.584133781943+0.563444986679j)*x[0]**o + ((0.448290541432+0.316690552703j))*x[0] + ((0.775009163944-0.99413172108j))*x[1]**o + ((0.763978312065-0.362500341119j))*x[1]
        ref[(1, 1, 0, 1)]=(-0.584133781943+0.563444986679j)*x_ref[0]**o + ((0.448290541432+0.316690552703j))*x_ref[0] + ((0.775009163944-0.99413172108j))*x_ref[1]**o + ((0.763978312065-0.362500341119j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(-0.456440554076+0.960058946359j)*x[0]**o + ((0.547682906857-0.735955592282j))*x[0] + ((-0.278232131934+0.749218887321j))*x[1]**o + ((0.901570231414+0.69366630402j))*x[1]
        ref[(1, 1, 1, 0)]=(-0.456440554076+0.960058946359j)*x_ref[0]**o + ((0.547682906857-0.735955592282j))*x_ref[0] + ((-0.278232131934+0.749218887321j))*x_ref[1]**o + ((0.901570231414+0.69366630402j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(0.996821926409-0.0350444900503j)*x[0]**o + ((-0.751234138188+0.15140376671j))*x[0] + ((-0.294485387769-0.799235390621j))*x[1]**o + ((-0.0727877979488+0.139471408178j))*x[1]
        ref[(1, 1, 1, 1)]=(0.996821926409-0.0350444900503j)*x_ref[0]**o + ((-0.751234138188+0.15140376671j))*x_ref[0] + ((-0.294485387769-0.799235390621j))*x_ref[1]**o + ((-0.0727877979488+0.139471408178j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(-0.990613572023+0.873775620209j)*x[0]**o + ((0.908095408407+0.891539261948j))*x[0] + ((0.839449909056-0.0493905965441j))*x[1]**o + ((0.385411807512-0.269993647141j))*x[1]
        ref[(1, 1, 2, 0)]=(-0.990613572023+0.873775620209j)*x_ref[0]**o + ((0.908095408407+0.891539261948j))*x_ref[0] + ((0.839449909056-0.0493905965441j))*x_ref[1]**o + ((0.385411807512-0.269993647141j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(-0.358308277127-0.0391937116794j)*x[0]**o + ((0.581134080015+0.321779023772j))*x[0] + ((-0.236317538644+0.284409377702j))*x[1]**o + ((-0.708068704153+0.734200162308j))*x[1]
        ref[(1, 1, 2, 1)]=(-0.358308277127-0.0391937116794j)*x_ref[0]**o + ((0.581134080015+0.321779023772j))*x_ref[0] + ((-0.236317538644+0.284409377702j))*x_ref[1]**o + ((-0.708068704153+0.734200162308j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(0.918498591941-0.281778484401j)*x[0]**o + ((0.556331982079+0.0877099326468j))*x[0] + ((0.00338192322499-0.994643897618j))*x[1]**o + ((-0.301174877777+0.90424643171j))*x[1]
        ref[(1, 2, 0, 0)]=(0.918498591941-0.281778484401j)*x_ref[0]**o + ((0.556331982079+0.0877099326468j))*x_ref[0] + ((0.00338192322499-0.994643897618j))*x_ref[1]**o + ((-0.301174877777+0.90424643171j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(0.260891965984+0.573899368156j)*x[0]**o + ((-0.554529117048+0.25118082707j))*x[0] + ((0.0964766136902+0.393933842759j))*x[1]**o + ((-0.415196472878+0.641461283385j))*x[1]
        ref[(1, 2, 0, 1)]=(0.260891965984+0.573899368156j)*x_ref[0]**o + ((-0.554529117048+0.25118082707j))*x_ref[0] + ((0.0964766136902+0.393933842759j))*x_ref[1]**o + ((-0.415196472878+0.641461283385j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(-0.583034048264-0.706193968115j)*x[0]**o + ((-0.941505664791-0.338502907269j))*x[0] + ((0.0434050218767+0.915056519447j))*x[1]**o + ((0.470893365177+0.612495652752j))*x[1]
        ref[(1, 2, 1, 0)]=(-0.583034048264-0.706193968115j)*x_ref[0]**o + ((-0.941505664791-0.338502907269j))*x_ref[0] + ((0.0434050218767+0.915056519447j))*x_ref[1]**o + ((0.470893365177+0.612495652752j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(0.0285196444927-0.642394888578j)*x[0]**o + ((-0.972057703216-0.914315414507j))*x[0] + ((-0.189822211415-0.710807487277j))*x[1]**o + ((-0.789094970559-0.0171584790367j))*x[1]
        ref[(1, 2, 1, 1)]=(0.0285196444927-0.642394888578j)*x_ref[0]**o + ((-0.972057703216-0.914315414507j))*x_ref[0] + ((-0.189822211415-0.710807487277j))*x_ref[1]**o + ((-0.789094970559-0.0171584790367j))*x_ref[1]
        arg[(1, 2, 2, 0)]=(0.658389023464+0.635319605323j)*x[0]**o + ((0.0330335565305+0.573981972782j))*x[0] + ((0.173523311967+0.614621673201j))*x[1]**o + ((-0.921255333807-0.851564364088j))*x[1]
        ref[(1, 2, 2, 0)]=(0.658389023464+0.635319605323j)*x_ref[0]**o + ((0.0330335565305+0.573981972782j))*x_ref[0] + ((0.173523311967+0.614621673201j))*x_ref[1]**o + ((-0.921255333807-0.851564364088j))*x_ref[1]
        arg[(1, 2, 2, 1)]=(-0.601292092109+0.747104184594j)*x[0]**o + ((-0.64125898163+0.630714780805j))*x[0] + ((0.410697730567-0.0821069237451j))*x[1]**o + ((-0.585526330171-0.0138340117604j))*x[1]
        ref[(1, 2, 2, 1)]=(-0.601292092109+0.747104184594j)*x_ref[0]**o + ((-0.64125898163+0.630714780805j))*x_ref[0] + ((0.410697730567-0.0821069237451j))*x_ref[1]**o + ((-0.585526330171-0.0138340117604j))*x_ref[1]
        arg[(1, 3, 0, 0)]=(-0.170315721958-0.682879830938j)*x[0]**o + ((0.912587629149+0.812191993914j))*x[0] + ((0.508864463564+0.659242622032j))*x[1]**o + ((0.721980910987+0.272926344296j))*x[1]
        ref[(1, 3, 0, 0)]=(-0.170315721958-0.682879830938j)*x_ref[0]**o + ((0.912587629149+0.812191993914j))*x_ref[0] + ((0.508864463564+0.659242622032j))*x_ref[1]**o + ((0.721980910987+0.272926344296j))*x_ref[1]
        arg[(1, 3, 0, 1)]=(-0.303789187913+0.336024136576j)*x[0]**o + ((-0.120179066739-0.645504034604j))*x[0] + ((0.308122406598+0.718429625891j))*x[1]**o + ((0.326203029094-0.291176757041j))*x[1]
        ref[(1, 3, 0, 1)]=(-0.303789187913+0.336024136576j)*x_ref[0]**o + ((-0.120179066739-0.645504034604j))*x_ref[0] + ((0.308122406598+0.718429625891j))*x_ref[1]**o + ((0.326203029094-0.291176757041j))*x_ref[1]
        arg[(1, 3, 1, 0)]=(-0.241062289677-0.538508178587j)*x[0]**o + ((0.775977361618+0.0745216977405j))*x[0] + ((0.655356633868-0.455964097748j))*x[1]**o + ((0.239766203558-0.213240827201j))*x[1]
        ref[(1, 3, 1, 0)]=(-0.241062289677-0.538508178587j)*x_ref[0]**o + ((0.775977361618+0.0745216977405j))*x_ref[0] + ((0.655356633868-0.455964097748j))*x_ref[1]**o + ((0.239766203558-0.213240827201j))*x_ref[1]
        arg[(1, 3, 1, 1)]=(0.647140929233+0.436437714794j)*x[0]**o + ((0.645908970875+0.936111911792j))*x[0] + ((0.628461523811-0.596400827887j))*x[1]**o + ((0.848547006575+0.00348066694044j))*x[1]
        ref[(1, 3, 1, 1)]=(0.647140929233+0.436437714794j)*x_ref[0]**o + ((0.645908970875+0.936111911792j))*x_ref[0] + ((0.628461523811-0.596400827887j))*x_ref[1]**o + ((0.848547006575+0.00348066694044j))*x_ref[1]
        arg[(1, 3, 2, 0)]=(0.804973918771-0.621473831426j)*x[0]**o + ((-0.155606834176+0.173289328855j))*x[0] + ((0.638239760855-0.909572824946j))*x[1]**o + ((0.0184104444699+0.0900337892725j))*x[1]
        ref[(1, 3, 2, 0)]=(0.804973918771-0.621473831426j)*x_ref[0]**o + ((-0.155606834176+0.173289328855j))*x_ref[0] + ((0.638239760855-0.909572824946j))*x_ref[1]**o + ((0.0184104444699+0.0900337892725j))*x_ref[1]
        arg[(1, 3, 2, 1)]=(-0.718385749463-0.811806506408j)*x[0]**o + ((0.937454599818-0.163875112608j))*x[0] + ((-0.162071290611+0.581098250077j))*x[1]**o + ((0.966946061355-0.774042455403j))*x[1]
        ref[(1, 3, 2, 1)]=(-0.718385749463-0.811806506408j)*x_ref[0]**o + ((0.937454599818-0.163875112608j))*x_ref[0] + ((-0.162071290611+0.581098250077j))*x_ref[1]**o + ((0.966946061355-0.774042455403j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.317365559676+0.509450918212j)*x[2]**o + ((-0.864350668581-0.74804428982j))*x[2]
            ref[(0, 0, 0, 0)]+=(-0.317365559676+0.509450918212j)*x_ref[2]**o + ((-0.864350668581-0.74804428982j))*x_ref[2]
            arg[(0, 0, 0, 1)]+=(-0.418583207521+0.839574918739j)*x[2]**o + ((0.846696670669-0.526890313405j))*x[2]
            ref[(0, 0, 0, 1)]+=(-0.418583207521+0.839574918739j)*x_ref[2]**o + ((0.846696670669-0.526890313405j))*x_ref[2]
            arg[(0, 0, 1, 0)]+=(0.484144800981+0.839787940536j)*x[2]**o + ((0.717697869338-0.62741767623j))*x[2]
            ref[(0, 0, 1, 0)]+=(0.484144800981+0.839787940536j)*x_ref[2]**o + ((0.717697869338-0.62741767623j))*x_ref[2]
            arg[(0, 0, 1, 1)]+=(-0.877720834384+0.664461945304j)*x[2]**o + ((-0.566287904719+0.274819055532j))*x[2]
            ref[(0, 0, 1, 1)]+=(-0.877720834384+0.664461945304j)*x_ref[2]**o + ((-0.566287904719+0.274819055532j))*x_ref[2]
            arg[(0, 0, 2, 0)]+=(-0.712735188929-0.816103763594j)*x[2]**o + ((-0.241503283814-0.47524447512j))*x[2]
            ref[(0, 0, 2, 0)]+=(-0.712735188929-0.816103763594j)*x_ref[2]**o + ((-0.241503283814-0.47524447512j))*x_ref[2]
            arg[(0, 0, 2, 1)]+=(0.635884200522-0.454107543212j)*x[2]**o + ((-0.187964967935-0.931673861557j))*x[2]
            ref[(0, 0, 2, 1)]+=(0.635884200522-0.454107543212j)*x_ref[2]**o + ((-0.187964967935-0.931673861557j))*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.357446752176-0.726559416219j)*x[2]**o + ((0.293566201033+0.456062297936j))*x[2]
            ref[(0, 1, 0, 0)]+=(-0.357446752176-0.726559416219j)*x_ref[2]**o + ((0.293566201033+0.456062297936j))*x_ref[2]
            arg[(0, 1, 0, 1)]+=(0.799076223642+0.540954145207j)*x[2]**o + ((0.727644379489+0.642870400774j))*x[2]
            ref[(0, 1, 0, 1)]+=(0.799076223642+0.540954145207j)*x_ref[2]**o + ((0.727644379489+0.642870400774j))*x_ref[2]
            arg[(0, 1, 1, 0)]+=(0.0285881257684-0.595127122752j)*x[2]**o + ((0.707719771248-0.338270964078j))*x[2]
            ref[(0, 1, 1, 0)]+=(0.0285881257684-0.595127122752j)*x_ref[2]**o + ((0.707719771248-0.338270964078j))*x_ref[2]
            arg[(0, 1, 1, 1)]+=(0.384812326209-0.7012432544j)*x[2]**o + ((-0.0454181347556+0.8806110846j))*x[2]
            ref[(0, 1, 1, 1)]+=(0.384812326209-0.7012432544j)*x_ref[2]**o + ((-0.0454181347556+0.8806110846j))*x_ref[2]
            arg[(0, 1, 2, 0)]+=(0.510932890935+0.755509841682j)*x[2]**o + ((0.0493357741462-0.0976686465761j))*x[2]
            ref[(0, 1, 2, 0)]+=(0.510932890935+0.755509841682j)*x_ref[2]**o + ((0.0493357741462-0.0976686465761j))*x_ref[2]
            arg[(0, 1, 2, 1)]+=(0.675063918649+0.747222608306j)*x[2]**o + ((0.891557200772+0.764610223617j))*x[2]
            ref[(0, 1, 2, 1)]+=(0.675063918649+0.747222608306j)*x_ref[2]**o + ((0.891557200772+0.764610223617j))*x_ref[2]
            arg[(0, 2, 0, 0)]+=(-0.670012928679+0.806508344253j)*x[2]**o + ((-0.218483466503-0.0572005990657j))*x[2]
            ref[(0, 2, 0, 0)]+=(-0.670012928679+0.806508344253j)*x_ref[2]**o + ((-0.218483466503-0.0572005990657j))*x_ref[2]
            arg[(0, 2, 0, 1)]+=(0.725818708093-0.429734609139j)*x[2]**o + ((0.612878179023-0.878527028923j))*x[2]
            ref[(0, 2, 0, 1)]+=(0.725818708093-0.429734609139j)*x_ref[2]**o + ((0.612878179023-0.878527028923j))*x_ref[2]
            arg[(0, 2, 1, 0)]+=(-0.421415207725-0.268072882652j)*x[2]**o + ((-0.354126017918+0.542191874307j))*x[2]
            ref[(0, 2, 1, 0)]+=(-0.421415207725-0.268072882652j)*x_ref[2]**o + ((-0.354126017918+0.542191874307j))*x_ref[2]
            arg[(0, 2, 1, 1)]+=(-0.322599734061-0.182949926373j)*x[2]**o + ((-0.651210799272-0.831215173678j))*x[2]
            ref[(0, 2, 1, 1)]+=(-0.322599734061-0.182949926373j)*x_ref[2]**o + ((-0.651210799272-0.831215173678j))*x_ref[2]
            arg[(0, 2, 2, 0)]+=(0.664402248622-0.94126253661j)*x[2]**o + ((-0.476255563986+0.684293285347j))*x[2]
            ref[(0, 2, 2, 0)]+=(0.664402248622-0.94126253661j)*x_ref[2]**o + ((-0.476255563986+0.684293285347j))*x_ref[2]
            arg[(0, 2, 2, 1)]+=(-0.260526364769+0.506454446735j)*x[2]**o + ((0.990430758339+0.96387853647j))*x[2]
            ref[(0, 2, 2, 1)]+=(-0.260526364769+0.506454446735j)*x_ref[2]**o + ((0.990430758339+0.96387853647j))*x_ref[2]
            arg[(0, 3, 0, 0)]+=(-0.647686342244+0.0637577282518j)*x[2]**o + ((0.862484365747-0.534272643474j))*x[2]
            ref[(0, 3, 0, 0)]+=(-0.647686342244+0.0637577282518j)*x_ref[2]**o + ((0.862484365747-0.534272643474j))*x_ref[2]
            arg[(0, 3, 0, 1)]+=(0.836698590004-0.941451295915j)*x[2]**o + ((0.86483380272-0.446761524723j))*x[2]
            ref[(0, 3, 0, 1)]+=(0.836698590004-0.941451295915j)*x_ref[2]**o + ((0.86483380272-0.446761524723j))*x_ref[2]
            arg[(0, 3, 1, 0)]+=(0.355854851882-0.663213803151j)*x[2]**o + ((-0.0784004372339-0.10012455387j))*x[2]
            ref[(0, 3, 1, 0)]+=(0.355854851882-0.663213803151j)*x_ref[2]**o + ((-0.0784004372339-0.10012455387j))*x_ref[2]
            arg[(0, 3, 1, 1)]+=(-0.0420513100513+0.655633620241j)*x[2]**o + ((-0.539322105591+0.88467633978j))*x[2]
            ref[(0, 3, 1, 1)]+=(-0.0420513100513+0.655633620241j)*x_ref[2]**o + ((-0.539322105591+0.88467633978j))*x_ref[2]
            arg[(0, 3, 2, 0)]+=(-0.181894729494-0.564755240206j)*x[2]**o + ((-0.921179441749-0.221361751128j))*x[2]
            ref[(0, 3, 2, 0)]+=(-0.181894729494-0.564755240206j)*x_ref[2]**o + ((-0.921179441749-0.221361751128j))*x_ref[2]
            arg[(0, 3, 2, 1)]+=(0.858180231922-0.46248185488j)*x[2]**o + ((0.421985636453-0.0515428093653j))*x[2]
            ref[(0, 3, 2, 1)]+=(0.858180231922-0.46248185488j)*x_ref[2]**o + ((0.421985636453-0.0515428093653j))*x_ref[2]
            arg[(1, 0, 0, 0)]+=(0.504634191884-0.159844313285j)*x[2]**o + ((-0.409510075506+0.807987740997j))*x[2]
            ref[(1, 0, 0, 0)]+=(0.504634191884-0.159844313285j)*x_ref[2]**o + ((-0.409510075506+0.807987740997j))*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.152782218538-0.252647571814j)*x[2]**o + ((-0.594744638223-0.169566314207j))*x[2]
            ref[(1, 0, 0, 1)]+=(0.152782218538-0.252647571814j)*x_ref[2]**o + ((-0.594744638223-0.169566314207j))*x_ref[2]
            arg[(1, 0, 1, 0)]+=(-0.033950774788+0.82548750763j)*x[2]**o + ((-0.266585866931-0.604786282411j))*x[2]
            ref[(1, 0, 1, 0)]+=(-0.033950774788+0.82548750763j)*x_ref[2]**o + ((-0.266585866931-0.604786282411j))*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.0724099306224+0.771740739375j)*x[2]**o + ((0.773093064432+0.412932461533j))*x[2]
            ref[(1, 0, 1, 1)]+=(0.0724099306224+0.771740739375j)*x_ref[2]**o + ((0.773093064432+0.412932461533j))*x_ref[2]
            arg[(1, 0, 2, 0)]+=(-0.0372295177639-0.256613092088j)*x[2]**o + ((-0.978072389863+0.825932419906j))*x[2]
            ref[(1, 0, 2, 0)]+=(-0.0372295177639-0.256613092088j)*x_ref[2]**o + ((-0.978072389863+0.825932419906j))*x_ref[2]
            arg[(1, 0, 2, 1)]+=(-0.445732014723-0.0332618971149j)*x[2]**o + ((0.752696997516+0.515190525139j))*x[2]
            ref[(1, 0, 2, 1)]+=(-0.445732014723-0.0332618971149j)*x_ref[2]**o + ((0.752696997516+0.515190525139j))*x_ref[2]
            arg[(1, 1, 0, 0)]+=(0.174714226665+0.5408799383j)*x[2]**o + ((-0.875919505205+0.656198681723j))*x[2]
            ref[(1, 1, 0, 0)]+=(0.174714226665+0.5408799383j)*x_ref[2]**o + ((-0.875919505205+0.656198681723j))*x_ref[2]
            arg[(1, 1, 0, 1)]+=(-0.579853147485-0.62501378133j)*x[2]**o + ((0.31846361007-0.262562923523j))*x[2]
            ref[(1, 1, 0, 1)]+=(-0.579853147485-0.62501378133j)*x_ref[2]**o + ((0.31846361007-0.262562923523j))*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.427137898027-0.652375893602j)*x[2]**o + ((-0.359883430992+0.791898196632j))*x[2]
            ref[(1, 1, 1, 0)]+=(0.427137898027-0.652375893602j)*x_ref[2]**o + ((-0.359883430992+0.791898196632j))*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.198529671583-0.955016541738j)*x[2]**o + ((-0.660648588595-0.167323019284j))*x[2]
            ref[(1, 1, 1, 1)]+=(-0.198529671583-0.955016541738j)*x_ref[2]**o + ((-0.660648588595-0.167323019284j))*x_ref[2]
            arg[(1, 1, 2, 0)]+=(-0.105080666085+0.639149194487j)*x[2]**o + ((0.790382519265+0.134406049626j))*x[2]
            ref[(1, 1, 2, 0)]+=(-0.105080666085+0.639149194487j)*x_ref[2]**o + ((0.790382519265+0.134406049626j))*x_ref[2]
            arg[(1, 1, 2, 1)]+=(-0.162806811177-0.523741495971j)*x[2]**o + ((0.94303861716-0.973262153965j))*x[2]
            ref[(1, 1, 2, 1)]+=(-0.162806811177-0.523741495971j)*x_ref[2]**o + ((0.94303861716-0.973262153965j))*x_ref[2]
            arg[(1, 2, 0, 0)]+=(0.635977618201+0.493282357854j)*x[2]**o + ((-0.229636798325-0.700174993683j))*x[2]
            ref[(1, 2, 0, 0)]+=(0.635977618201+0.493282357854j)*x_ref[2]**o + ((-0.229636798325-0.700174993683j))*x_ref[2]
            arg[(1, 2, 0, 1)]+=(0.275464481064-0.370553374108j)*x[2]**o + ((-0.594734313451-0.31805152509j))*x[2]
            ref[(1, 2, 0, 1)]+=(0.275464481064-0.370553374108j)*x_ref[2]**o + ((-0.594734313451-0.31805152509j))*x_ref[2]
            arg[(1, 2, 1, 0)]+=(-0.427622483748-0.800042187677j)*x[2]**o + ((-0.125829140947-0.579124441863j))*x[2]
            ref[(1, 2, 1, 0)]+=(-0.427622483748-0.800042187677j)*x_ref[2]**o + ((-0.125829140947-0.579124441863j))*x_ref[2]
            arg[(1, 2, 1, 1)]+=(0.722378284332-0.0737673231555j)*x[2]**o + ((-0.25116467064-0.727772506035j))*x[2]
            ref[(1, 2, 1, 1)]+=(0.722378284332-0.0737673231555j)*x_ref[2]**o + ((-0.25116467064-0.727772506035j))*x_ref[2]
            arg[(1, 2, 2, 0)]+=(0.516779848805-0.388748984318j)*x[2]**o + ((-0.847883977926+0.279141484371j))*x[2]
            ref[(1, 2, 2, 0)]+=(0.516779848805-0.388748984318j)*x_ref[2]**o + ((-0.847883977926+0.279141484371j))*x_ref[2]
            arg[(1, 2, 2, 1)]+=(0.765616102346-0.391114782254j)*x[2]**o + ((0.900671778731+0.673321879475j))*x[2]
            ref[(1, 2, 2, 1)]+=(0.765616102346-0.391114782254j)*x_ref[2]**o + ((0.900671778731+0.673321879475j))*x_ref[2]
            arg[(1, 3, 0, 0)]+=(0.3758553099+0.0145588839943j)*x[2]**o + ((0.708984228076-0.985796823608j))*x[2]
            ref[(1, 3, 0, 0)]+=(0.3758553099+0.0145588839943j)*x_ref[2]**o + ((0.708984228076-0.985796823608j))*x_ref[2]
            arg[(1, 3, 0, 1)]+=(0.0453428065583-0.545746773092j)*x[2]**o + ((-0.52470593748-0.747841031272j))*x[2]
            ref[(1, 3, 0, 1)]+=(0.0453428065583-0.545746773092j)*x_ref[2]**o + ((-0.52470593748-0.747841031272j))*x_ref[2]
            arg[(1, 3, 1, 0)]+=(-0.952438209126+0.795953820108j)*x[2]**o + ((-0.830401005927-0.0706726740441j))*x[2]
            ref[(1, 3, 1, 0)]+=(-0.952438209126+0.795953820108j)*x_ref[2]**o + ((-0.830401005927-0.0706726740441j))*x_ref[2]
            arg[(1, 3, 1, 1)]+=(-0.314533997617+0.158069568278j)*x[2]**o + ((0.843446209234-0.433802418861j))*x[2]
            ref[(1, 3, 1, 1)]+=(-0.314533997617+0.158069568278j)*x_ref[2]**o + ((0.843446209234-0.433802418861j))*x_ref[2]
            arg[(1, 3, 2, 0)]+=(0.862445365534+0.622755444812j)*x[2]**o + ((-0.584319135973-0.756523305413j))*x[2]
            ref[(1, 3, 2, 0)]+=(0.862445365534+0.622755444812j)*x_ref[2]**o + ((-0.584319135973-0.756523305413j))*x_ref[2]
            arg[(1, 3, 2, 1)]+=(0.92072421511+0.841680466324j)*x[2]**o + ((-0.0247619733422-0.528592858047j))*x[2]
            ref[(1, 3, 2, 1)]+=(0.92072421511+0.841680466324j)*x_ref[2]**o + ((-0.0247619733422-0.528592858047j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 4, 3, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedSolution_rank0(self):
        """
        tests interpolation of rank 0 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(0.438850259538+0.271938348589j)*x[0] + ((-0.54318957348+0.73599491086j))*x[1]
        ref=(0.438850259538+0.271938348589j)*x_ref[0] + ((-0.54318957348+0.73599491086j))*x_ref[1]
        if dim==3:
            arg+=((0.655827311755-0.0407121842584j))*x[2]
            ref+=((0.655827311755-0.0407121842584j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedSolution_rank1(self):
        """
        tests interpolation of rank 1 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,),w_ref)
        arg[(0,)]=(-0.66200232529+0.837750820678j)*x[0] + ((-0.227696244674-0.32118174033j))*x[1]
        ref[(0,)]=(-0.66200232529+0.837750820678j)*x_ref[0] + ((-0.227696244674-0.32118174033j))*x_ref[1]
        arg[(1,)]=(0.579274343307+0.793363511379j)*x[0] + ((0.699877695632-0.654353655504j))*x[1]
        ref[(1,)]=(0.579274343307+0.793363511379j)*x_ref[0] + ((0.699877695632-0.654353655504j))*x_ref[1]
        arg[(2,)]=(0.944280240843+0.266288560163j)*x[0] + ((0.55749903564-0.952010517544j))*x[1]
        ref[(2,)]=(0.944280240843+0.266288560163j)*x_ref[0] + ((0.55749903564-0.952010517544j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.246834500892-0.726290329095j)*x[2]
            ref[(0,)]+=(-0.246834500892-0.726290329095j)*x_ref[2]
            arg[(1,)]+=(-0.533141565217-0.178124390405j)*x[2]
            ref[(1,)]+=(-0.533141565217-0.178124390405j)*x_ref[2]
            arg[(2,)]+=(-0.0100433160098+0.63065425183j)*x[2]
            ref[(2,)]+=(-0.0100433160098+0.63065425183j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedSolution_rank2(self):
        """
        tests interpolation of rank 2 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2),w_ref)
        arg[(0, 0)]=(-0.61506537007+0.373411884659j)*x[0] + ((0.881390473769+0.613868273933j))*x[1]
        ref[(0, 0)]=(-0.61506537007+0.373411884659j)*x_ref[0] + ((0.881390473769+0.613868273933j))*x_ref[1]
        arg[(0, 1)]=(-0.426574832973+0.994313238009j)*x[0] + ((-0.0161653251759+0.634314028344j))*x[1]
        ref[(0, 1)]=(-0.426574832973+0.994313238009j)*x_ref[0] + ((-0.0161653251759+0.634314028344j))*x_ref[1]
        arg[(1, 0)]=(0.580219178358-0.0973164626485j)*x[0] + ((0.188189356451+0.482888579143j))*x[1]
        ref[(1, 0)]=(0.580219178358-0.0973164626485j)*x_ref[0] + ((0.188189356451+0.482888579143j))*x_ref[1]
        arg[(1, 1)]=(0.672985057874-0.918221907369j)*x[0] + ((0.0880487759826-0.175527358938j))*x[1]
        ref[(1, 1)]=(0.672985057874-0.918221907369j)*x_ref[0] + ((0.0880487759826-0.175527358938j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(0.461825943602-0.486928791497j)*x[2]
            ref[(0, 0)]+=(0.461825943602-0.486928791497j)*x_ref[2]
            arg[(0, 1)]+=(-0.518355081925-0.889581366677j)*x[2]
            ref[(0, 1)]+=(-0.518355081925-0.889581366677j)*x_ref[2]
            arg[(1, 0)]+=(-0.903478113139-0.174542019331j)*x[2]
            ref[(1, 0)]+=(-0.903478113139-0.174542019331j)*x_ref[2]
            arg[(1, 1)]+=(0.264679072593-0.0325214419041j)*x[2]
            ref[(1, 1)]+=(0.264679072593-0.0325214419041j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedSolution_rank3(self):
        """
        tests interpolation of rank 3 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 4),w)
        ref = Data(0,(4, 3, 4),w_ref)
        arg[(0, 0, 0)]=(-0.201117437878-0.525640262642j)*x[0] + ((-0.698328992611+0.483089407053j))*x[1]
        ref[(0, 0, 0)]=(-0.201117437878-0.525640262642j)*x_ref[0] + ((-0.698328992611+0.483089407053j))*x_ref[1]
        arg[(0, 0, 1)]=(0.900658305126-0.359030553763j)*x[0] + ((-0.465331375535+0.433996472429j))*x[1]
        ref[(0, 0, 1)]=(0.900658305126-0.359030553763j)*x_ref[0] + ((-0.465331375535+0.433996472429j))*x_ref[1]
        arg[(0, 0, 2)]=(0.956550937322-0.0080481260797j)*x[0] + ((-0.289264087273-0.773315720708j))*x[1]
        ref[(0, 0, 2)]=(0.956550937322-0.0080481260797j)*x_ref[0] + ((-0.289264087273-0.773315720708j))*x_ref[1]
        arg[(0, 0, 3)]=(0.3014623331-0.155442401912j)*x[0] + ((0.26961227099-0.379808396274j))*x[1]
        ref[(0, 0, 3)]=(0.3014623331-0.155442401912j)*x_ref[0] + ((0.26961227099-0.379808396274j))*x_ref[1]
        arg[(0, 1, 0)]=(0.558232962364+0.815491631689j)*x[0] + ((-0.481403903706-0.56880386468j))*x[1]
        ref[(0, 1, 0)]=(0.558232962364+0.815491631689j)*x_ref[0] + ((-0.481403903706-0.56880386468j))*x_ref[1]
        arg[(0, 1, 1)]=(0.227811582644-0.0507980549015j)*x[0] + ((0.809472842011+0.83523879853j))*x[1]
        ref[(0, 1, 1)]=(0.227811582644-0.0507980549015j)*x_ref[0] + ((0.809472842011+0.83523879853j))*x_ref[1]
        arg[(0, 1, 2)]=(0.692905690535+0.0244929956142j)*x[0] + ((-0.845113697699+0.111806951315j))*x[1]
        ref[(0, 1, 2)]=(0.692905690535+0.0244929956142j)*x_ref[0] + ((-0.845113697699+0.111806951315j))*x_ref[1]
        arg[(0, 1, 3)]=(-0.877153235157-0.118294035411j)*x[0] + ((-0.761851604868-0.427805394787j))*x[1]
        ref[(0, 1, 3)]=(-0.877153235157-0.118294035411j)*x_ref[0] + ((-0.761851604868-0.427805394787j))*x_ref[1]
        arg[(0, 2, 0)]=(-0.486082282782-0.57927127139j)*x[0] + ((-0.51797313149+0.994641346208j))*x[1]
        ref[(0, 2, 0)]=(-0.486082282782-0.57927127139j)*x_ref[0] + ((-0.51797313149+0.994641346208j))*x_ref[1]
        arg[(0, 2, 1)]=(0.971962538338-0.400876437541j)*x[0] + ((-0.382883121394-0.857711418594j))*x[1]
        ref[(0, 2, 1)]=(0.971962538338-0.400876437541j)*x_ref[0] + ((-0.382883121394-0.857711418594j))*x_ref[1]
        arg[(0, 2, 2)]=(-0.354369323397+0.520919026423j)*x[0] + ((-0.836886009467-0.0159536288955j))*x[1]
        ref[(0, 2, 2)]=(-0.354369323397+0.520919026423j)*x_ref[0] + ((-0.836886009467-0.0159536288955j))*x_ref[1]
        arg[(0, 2, 3)]=(0.32400349137+0.404061669333j)*x[0] + ((0.940421212902-0.42695104245j))*x[1]
        ref[(0, 2, 3)]=(0.32400349137+0.404061669333j)*x_ref[0] + ((0.940421212902-0.42695104245j))*x_ref[1]
        arg[(1, 0, 0)]=(0.847563481614-0.900740375368j)*x[0] + ((0.257426107773+0.439593477019j))*x[1]
        ref[(1, 0, 0)]=(0.847563481614-0.900740375368j)*x_ref[0] + ((0.257426107773+0.439593477019j))*x_ref[1]
        arg[(1, 0, 1)]=(0.38867675237+0.311708999467j)*x[0] + ((-0.80590283936-0.9082348666j))*x[1]
        ref[(1, 0, 1)]=(0.38867675237+0.311708999467j)*x_ref[0] + ((-0.80590283936-0.9082348666j))*x_ref[1]
        arg[(1, 0, 2)]=(0.444523332819+0.112466389861j)*x[0] + ((-0.77104876514-0.129109648248j))*x[1]
        ref[(1, 0, 2)]=(0.444523332819+0.112466389861j)*x_ref[0] + ((-0.77104876514-0.129109648248j))*x_ref[1]
        arg[(1, 0, 3)]=(0.130606479363-0.0687778272659j)*x[0] + ((-0.599721462279-0.739005599749j))*x[1]
        ref[(1, 0, 3)]=(0.130606479363-0.0687778272659j)*x_ref[0] + ((-0.599721462279-0.739005599749j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.022079819182-0.939516710548j)*x[0] + ((-0.689215629496+0.52235600102j))*x[1]
        ref[(1, 1, 0)]=(-0.022079819182-0.939516710548j)*x_ref[0] + ((-0.689215629496+0.52235600102j))*x_ref[1]
        arg[(1, 1, 1)]=(0.803618062118-0.447719594924j)*x[0] + ((0.150221768828+0.745554596851j))*x[1]
        ref[(1, 1, 1)]=(0.803618062118-0.447719594924j)*x_ref[0] + ((0.150221768828+0.745554596851j))*x_ref[1]
        arg[(1, 1, 2)]=(0.00351199113841+0.916800438674j)*x[0] + ((0.222856407385+0.456511274836j))*x[1]
        ref[(1, 1, 2)]=(0.00351199113841+0.916800438674j)*x_ref[0] + ((0.222856407385+0.456511274836j))*x_ref[1]
        arg[(1, 1, 3)]=(0.379391566923-0.186801033837j)*x[0] + ((0.81977529917+0.755548606364j))*x[1]
        ref[(1, 1, 3)]=(0.379391566923-0.186801033837j)*x_ref[0] + ((0.81977529917+0.755548606364j))*x_ref[1]
        arg[(1, 2, 0)]=(-0.604381364862+0.36845285769j)*x[0] + ((-0.777630709188-0.278380801029j))*x[1]
        ref[(1, 2, 0)]=(-0.604381364862+0.36845285769j)*x_ref[0] + ((-0.777630709188-0.278380801029j))*x_ref[1]
        arg[(1, 2, 1)]=(0.175412583375-0.761247678537j)*x[0] + ((0.594079746168-0.515267947708j))*x[1]
        ref[(1, 2, 1)]=(0.175412583375-0.761247678537j)*x_ref[0] + ((0.594079746168-0.515267947708j))*x_ref[1]
        arg[(1, 2, 2)]=(0.023759997814-0.411749845799j)*x[0] + ((0.924871877104-0.753085378925j))*x[1]
        ref[(1, 2, 2)]=(0.023759997814-0.411749845799j)*x_ref[0] + ((0.924871877104-0.753085378925j))*x_ref[1]
        arg[(1, 2, 3)]=(-0.731705620368+0.632812981367j)*x[0] + ((-0.175340151594+0.913915266074j))*x[1]
        ref[(1, 2, 3)]=(-0.731705620368+0.632812981367j)*x_ref[0] + ((-0.175340151594+0.913915266074j))*x_ref[1]
        arg[(2, 0, 0)]=(0.155544623574-0.539917908747j)*x[0] + ((-0.134690676783+0.76499635553j))*x[1]
        ref[(2, 0, 0)]=(0.155544623574-0.539917908747j)*x_ref[0] + ((-0.134690676783+0.76499635553j))*x_ref[1]
        arg[(2, 0, 1)]=(-0.652519009556-0.184985433409j)*x[0] + ((0.667281617647+0.888565708698j))*x[1]
        ref[(2, 0, 1)]=(-0.652519009556-0.184985433409j)*x_ref[0] + ((0.667281617647+0.888565708698j))*x_ref[1]
        arg[(2, 0, 2)]=(0.691856472418+0.761700560617j)*x[0] + ((-0.391922092339-0.407374604027j))*x[1]
        ref[(2, 0, 2)]=(0.691856472418+0.761700560617j)*x_ref[0] + ((-0.391922092339-0.407374604027j))*x_ref[1]
        arg[(2, 0, 3)]=(0.0868436731063-0.0125656699377j)*x[0] + ((0.0941226974972-0.16261336441j))*x[1]
        ref[(2, 0, 3)]=(0.0868436731063-0.0125656699377j)*x_ref[0] + ((0.0941226974972-0.16261336441j))*x_ref[1]
        arg[(2, 1, 0)]=(-0.722795141635+0.330793135491j)*x[0] + ((-0.362507765237+0.797184090653j))*x[1]
        ref[(2, 1, 0)]=(-0.722795141635+0.330793135491j)*x_ref[0] + ((-0.362507765237+0.797184090653j))*x_ref[1]
        arg[(2, 1, 1)]=(0.874748448314-0.0866805338178j)*x[0] + ((-0.543090090143+0.398214088355j))*x[1]
        ref[(2, 1, 1)]=(0.874748448314-0.0866805338178j)*x_ref[0] + ((-0.543090090143+0.398214088355j))*x_ref[1]
        arg[(2, 1, 2)]=(0.773121985967+0.786540975537j)*x[0] + ((-0.358584016874+0.242891319787j))*x[1]
        ref[(2, 1, 2)]=(0.773121985967+0.786540975537j)*x_ref[0] + ((-0.358584016874+0.242891319787j))*x_ref[1]
        arg[(2, 1, 3)]=(0.346764990858-0.926099824469j)*x[0] + ((-0.874661786027-0.211864945935j))*x[1]
        ref[(2, 1, 3)]=(0.346764990858-0.926099824469j)*x_ref[0] + ((-0.874661786027-0.211864945935j))*x_ref[1]
        arg[(2, 2, 0)]=(-0.667809441392-0.888615229883j)*x[0] + ((0.850987873461-0.576499753624j))*x[1]
        ref[(2, 2, 0)]=(-0.667809441392-0.888615229883j)*x_ref[0] + ((0.850987873461-0.576499753624j))*x_ref[1]
        arg[(2, 2, 1)]=(0.411525811916+0.460769484297j)*x[0] + ((-0.307884728267+0.612407762625j))*x[1]
        ref[(2, 2, 1)]=(0.411525811916+0.460769484297j)*x_ref[0] + ((-0.307884728267+0.612407762625j))*x_ref[1]
        arg[(2, 2, 2)]=(0.643452198013-0.664578972087j)*x[0] + ((-0.663506788374+0.149975035065j))*x[1]
        ref[(2, 2, 2)]=(0.643452198013-0.664578972087j)*x_ref[0] + ((-0.663506788374+0.149975035065j))*x_ref[1]
        arg[(2, 2, 3)]=(-0.47421468164-0.436403884625j)*x[0] + ((0.293012627103-0.755420885345j))*x[1]
        ref[(2, 2, 3)]=(-0.47421468164-0.436403884625j)*x_ref[0] + ((0.293012627103-0.755420885345j))*x_ref[1]
        arg[(3, 0, 0)]=(-0.140374960003+0.556764015108j)*x[0] + ((0.036524363336-0.156370785876j))*x[1]
        ref[(3, 0, 0)]=(-0.140374960003+0.556764015108j)*x_ref[0] + ((0.036524363336-0.156370785876j))*x_ref[1]
        arg[(3, 0, 1)]=(-0.94394720643+0.040887288489j)*x[0] + ((0.54237504512+0.401204168437j))*x[1]
        ref[(3, 0, 1)]=(-0.94394720643+0.040887288489j)*x_ref[0] + ((0.54237504512+0.401204168437j))*x_ref[1]
        arg[(3, 0, 2)]=(-0.474464771417+0.842841769058j)*x[0] + ((0.374382236584+0.139023584278j))*x[1]
        ref[(3, 0, 2)]=(-0.474464771417+0.842841769058j)*x_ref[0] + ((0.374382236584+0.139023584278j))*x_ref[1]
        arg[(3, 0, 3)]=(-0.880144391468-0.442689696592j)*x[0] + ((-0.330516516652-0.74263285876j))*x[1]
        ref[(3, 0, 3)]=(-0.880144391468-0.442689696592j)*x_ref[0] + ((-0.330516516652-0.74263285876j))*x_ref[1]
        arg[(3, 1, 0)]=(-0.922182873126-0.732214481822j)*x[0] + ((0.19862157964-0.125426522556j))*x[1]
        ref[(3, 1, 0)]=(-0.922182873126-0.732214481822j)*x_ref[0] + ((0.19862157964-0.125426522556j))*x_ref[1]
        arg[(3, 1, 1)]=(0.440552417896+0.575960994875j)*x[0] + ((0.288928575303-0.919146594346j))*x[1]
        ref[(3, 1, 1)]=(0.440552417896+0.575960994875j)*x_ref[0] + ((0.288928575303-0.919146594346j))*x_ref[1]
        arg[(3, 1, 2)]=(-0.175610287898+0.725673307029j)*x[0] + ((0.84052731212-0.361912851341j))*x[1]
        ref[(3, 1, 2)]=(-0.175610287898+0.725673307029j)*x_ref[0] + ((0.84052731212-0.361912851341j))*x_ref[1]
        arg[(3, 1, 3)]=(0.0328029619129+0.537478772224j)*x[0] + ((-0.331165655058-0.381699899502j))*x[1]
        ref[(3, 1, 3)]=(0.0328029619129+0.537478772224j)*x_ref[0] + ((-0.331165655058-0.381699899502j))*x_ref[1]
        arg[(3, 2, 0)]=(0.835681549987+0.609090847269j)*x[0] + ((0.417460858906+0.727547479803j))*x[1]
        ref[(3, 2, 0)]=(0.835681549987+0.609090847269j)*x_ref[0] + ((0.417460858906+0.727547479803j))*x_ref[1]
        arg[(3, 2, 1)]=(0.757358824718+0.0452590174467j)*x[0] + ((0.620393733928+0.777033571385j))*x[1]
        ref[(3, 2, 1)]=(0.757358824718+0.0452590174467j)*x_ref[0] + ((0.620393733928+0.777033571385j))*x_ref[1]
        arg[(3, 2, 2)]=(0.131240595305-0.391048012534j)*x[0] + ((-0.0383323323861-0.757745435014j))*x[1]
        ref[(3, 2, 2)]=(0.131240595305-0.391048012534j)*x_ref[0] + ((-0.0383323323861-0.757745435014j))*x_ref[1]
        arg[(3, 2, 3)]=(0.691194456564-0.00789224555926j)*x[0] + ((-0.709103863715-0.813829353464j))*x[1]
        ref[(3, 2, 3)]=(0.691194456564-0.00789224555926j)*x_ref[0] + ((-0.709103863715-0.813829353464j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.894073230389+0.347494291185j)*x[2]
            ref[(0, 0, 0)]+=(-0.894073230389+0.347494291185j)*x_ref[2]
            arg[(0, 0, 1)]+=(0.994543088163-0.626692537241j)*x[2]
            ref[(0, 0, 1)]+=(0.994543088163-0.626692537241j)*x_ref[2]
            arg[(0, 0, 2)]+=(-0.230833900367-0.30361839933j)*x[2]
            ref[(0, 0, 2)]+=(-0.230833900367-0.30361839933j)*x_ref[2]
            arg[(0, 0, 3)]+=(-0.227193925999-0.806095050177j)*x[2]
            ref[(0, 0, 3)]+=(-0.227193925999-0.806095050177j)*x_ref[2]
            arg[(0, 1, 0)]+=(-0.423636633996+0.845031452635j)*x[2]
            ref[(0, 1, 0)]+=(-0.423636633996+0.845031452635j)*x_ref[2]
            arg[(0, 1, 1)]+=(0.779608183422-0.874469229721j)*x[2]
            ref[(0, 1, 1)]+=(0.779608183422-0.874469229721j)*x_ref[2]
            arg[(0, 1, 2)]+=(0.863157219858+0.86523117163j)*x[2]
            ref[(0, 1, 2)]+=(0.863157219858+0.86523117163j)*x_ref[2]
            arg[(0, 1, 3)]+=(0.473254188713+0.909601776315j)*x[2]
            ref[(0, 1, 3)]+=(0.473254188713+0.909601776315j)*x_ref[2]
            arg[(0, 2, 0)]+=(0.780754934488+0.733247756266j)*x[2]
            ref[(0, 2, 0)]+=(0.780754934488+0.733247756266j)*x_ref[2]
            arg[(0, 2, 1)]+=(0.298915004403+0.664228128127j)*x[2]
            ref[(0, 2, 1)]+=(0.298915004403+0.664228128127j)*x_ref[2]
            arg[(0, 2, 2)]+=(-0.480451691163+0.606084557576j)*x[2]
            ref[(0, 2, 2)]+=(-0.480451691163+0.606084557576j)*x_ref[2]
            arg[(0, 2, 3)]+=(-0.172076186611+0.15885114841j)*x[2]
            ref[(0, 2, 3)]+=(-0.172076186611+0.15885114841j)*x_ref[2]
            arg[(1, 0, 0)]+=(-0.907293101823+0.582351061667j)*x[2]
            ref[(1, 0, 0)]+=(-0.907293101823+0.582351061667j)*x_ref[2]
            arg[(1, 0, 1)]+=(0.464129036589-0.993270709123j)*x[2]
            ref[(1, 0, 1)]+=(0.464129036589-0.993270709123j)*x_ref[2]
            arg[(1, 0, 2)]+=(0.681667612787+0.660462422182j)*x[2]
            ref[(1, 0, 2)]+=(0.681667612787+0.660462422182j)*x_ref[2]
            arg[(1, 0, 3)]+=(-0.334975042756+0.21459179635j)*x[2]
            ref[(1, 0, 3)]+=(-0.334975042756+0.21459179635j)*x_ref[2]
            arg[(1, 1, 0)]+=(-0.759700771377-0.550598017419j)*x[2]
            ref[(1, 1, 0)]+=(-0.759700771377-0.550598017419j)*x_ref[2]
            arg[(1, 1, 1)]+=(0.26429598458+0.806782356528j)*x[2]
            ref[(1, 1, 1)]+=(0.26429598458+0.806782356528j)*x_ref[2]
            arg[(1, 1, 2)]+=(0.751492880991-0.169931053241j)*x[2]
            ref[(1, 1, 2)]+=(0.751492880991-0.169931053241j)*x_ref[2]
            arg[(1, 1, 3)]+=(-0.741024425437+0.976809600265j)*x[2]
            ref[(1, 1, 3)]+=(-0.741024425437+0.976809600265j)*x_ref[2]
            arg[(1, 2, 0)]+=(-0.967805540917+0.782385860474j)*x[2]
            ref[(1, 2, 0)]+=(-0.967805540917+0.782385860474j)*x_ref[2]
            arg[(1, 2, 1)]+=(-0.542146388523+0.420274320153j)*x[2]
            ref[(1, 2, 1)]+=(-0.542146388523+0.420274320153j)*x_ref[2]
            arg[(1, 2, 2)]+=(0.889551808615+0.199947340565j)*x[2]
            ref[(1, 2, 2)]+=(0.889551808615+0.199947340565j)*x_ref[2]
            arg[(1, 2, 3)]+=(-0.972895808658+0.318497177187j)*x[2]
            ref[(1, 2, 3)]+=(-0.972895808658+0.318497177187j)*x_ref[2]
            arg[(2, 0, 0)]+=(-0.751614831024+0.348225736616j)*x[2]
            ref[(2, 0, 0)]+=(-0.751614831024+0.348225736616j)*x_ref[2]
            arg[(2, 0, 1)]+=(-0.182943744241+0.176653147776j)*x[2]
            ref[(2, 0, 1)]+=(-0.182943744241+0.176653147776j)*x_ref[2]
            arg[(2, 0, 2)]+=(0.0190220404152+0.25229102775j)*x[2]
            ref[(2, 0, 2)]+=(0.0190220404152+0.25229102775j)*x_ref[2]
            arg[(2, 0, 3)]+=(0.151896223556-0.0378981083643j)*x[2]
            ref[(2, 0, 3)]+=(0.151896223556-0.0378981083643j)*x_ref[2]
            arg[(2, 1, 0)]+=(0.719940715911+0.0263520714957j)*x[2]
            ref[(2, 1, 0)]+=(0.719940715911+0.0263520714957j)*x_ref[2]
            arg[(2, 1, 1)]+=(-0.876977492243+0.594955454631j)*x[2]
            ref[(2, 1, 1)]+=(-0.876977492243+0.594955454631j)*x_ref[2]
            arg[(2, 1, 2)]+=(-0.355827616493+0.591593969601j)*x[2]
            ref[(2, 1, 2)]+=(-0.355827616493+0.591593969601j)*x_ref[2]
            arg[(2, 1, 3)]+=(-0.60462530033-0.332386782862j)*x[2]
            ref[(2, 1, 3)]+=(-0.60462530033-0.332386782862j)*x_ref[2]
            arg[(2, 2, 0)]+=(0.00608544215604+0.606369487317j)*x[2]
            ref[(2, 2, 0)]+=(0.00608544215604+0.606369487317j)*x_ref[2]
            arg[(2, 2, 1)]+=(0.190378453272-0.687688778835j)*x[2]
            ref[(2, 2, 1)]+=(0.190378453272-0.687688778835j)*x_ref[2]
            arg[(2, 2, 2)]+=(-0.347413430172-0.47884653967j)*x[2]
            ref[(2, 2, 2)]+=(-0.347413430172-0.47884653967j)*x_ref[2]
            arg[(2, 2, 3)]+=(-0.708733584537-0.688720802763j)*x[2]
            ref[(2, 2, 3)]+=(-0.708733584537-0.688720802763j)*x_ref[2]
            arg[(3, 0, 0)]+=(0.868303696285+0.835302111266j)*x[2]
            ref[(3, 0, 0)]+=(0.868303696285+0.835302111266j)*x_ref[2]
            arg[(3, 0, 1)]+=(0.820367550937-0.0825205449279j)*x[2]
            ref[(3, 0, 1)]+=(0.820367550937-0.0825205449279j)*x_ref[2]
            arg[(3, 0, 2)]+=(0.191945737407-0.124996837387j)*x[2]
            ref[(3, 0, 2)]+=(0.191945737407-0.124996837387j)*x_ref[2]
            arg[(3, 0, 3)]+=(-0.877620105967-0.424985633685j)*x[2]
            ref[(3, 0, 3)]+=(-0.877620105967-0.424985633685j)*x_ref[2]
            arg[(3, 1, 0)]+=(-0.936664542866-0.351581348584j)*x[2]
            ref[(3, 1, 0)]+=(-0.936664542866-0.351581348584j)*x_ref[2]
            arg[(3, 1, 1)]+=(-0.216714569184+0.873637044367j)*x[2]
            ref[(3, 1, 1)]+=(-0.216714569184+0.873637044367j)*x_ref[2]
            arg[(3, 1, 2)]+=(0.466497283064-0.719190629822j)*x[2]
            ref[(3, 1, 2)]+=(0.466497283064-0.719190629822j)*x_ref[2]
            arg[(3, 1, 3)]+=(0.533755326363+0.781408698991j)*x[2]
            ref[(3, 1, 3)]+=(0.533755326363+0.781408698991j)*x_ref[2]
            arg[(3, 2, 0)]+=(-0.954039764947+0.718406570014j)*x[2]
            ref[(3, 2, 0)]+=(-0.954039764947+0.718406570014j)*x_ref[2]
            arg[(3, 2, 1)]+=(0.177434180919+0.175886193639j)*x[2]
            ref[(3, 2, 1)]+=(0.177434180919+0.175886193639j)*x_ref[2]
            arg[(3, 2, 2)]+=(0.0412376341343-0.753423056306j)*x[2]
            ref[(3, 2, 2)]+=(0.0412376341343-0.753423056306j)*x_ref[2]
            arg[(3, 2, 3)]+=(0.917717393151+0.683611621993j)*x[2]
            ref[(3, 2, 3)]+=(0.917717393151+0.683611621993j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedSolution_rank4(self):
        """
        tests interpolation of rank 4 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3, 4, 4),w)
        ref = Data(0,(3, 3, 4, 4),w_ref)
        arg[(0, 0, 0, 0)]=(-0.890015522304-0.617427061869j)*x[0] + ((-0.712433750539+0.393943083991j))*x[1]
        ref[(0, 0, 0, 0)]=(-0.890015522304-0.617427061869j)*x_ref[0] + ((-0.712433750539+0.393943083991j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(0.891966884729-0.482574034175j)*x[0] + ((0.499318626612-0.980847510708j))*x[1]
        ref[(0, 0, 0, 1)]=(0.891966884729-0.482574034175j)*x_ref[0] + ((0.499318626612-0.980847510708j))*x_ref[1]
        arg[(0, 0, 0, 2)]=(-0.443269251391-0.118643960038j)*x[0] + ((-0.908985029407-0.218828461012j))*x[1]
        ref[(0, 0, 0, 2)]=(-0.443269251391-0.118643960038j)*x_ref[0] + ((-0.908985029407-0.218828461012j))*x_ref[1]
        arg[(0, 0, 0, 3)]=(0.272623043968+0.373041253396j)*x[0] + ((-0.100547241465-0.170630682953j))*x[1]
        ref[(0, 0, 0, 3)]=(0.272623043968+0.373041253396j)*x_ref[0] + ((-0.100547241465-0.170630682953j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(0.0820083342215-0.525886609783j)*x[0] + ((0.965763377589+0.444392321691j))*x[1]
        ref[(0, 0, 1, 0)]=(0.0820083342215-0.525886609783j)*x_ref[0] + ((0.965763377589+0.444392321691j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.484752243259+0.946028552866j)*x[0] + ((-0.79657787747+0.0177008612294j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.484752243259+0.946028552866j)*x_ref[0] + ((-0.79657787747+0.0177008612294j))*x_ref[1]
        arg[(0, 0, 1, 2)]=(-0.940269517498+0.227260055861j)*x[0] + ((0.687511393172+0.902614609679j))*x[1]
        ref[(0, 0, 1, 2)]=(-0.940269517498+0.227260055861j)*x_ref[0] + ((0.687511393172+0.902614609679j))*x_ref[1]
        arg[(0, 0, 1, 3)]=(-0.266336662322+0.451197553553j)*x[0] + ((0.00867652309578+0.158962114255j))*x[1]
        ref[(0, 0, 1, 3)]=(-0.266336662322+0.451197553553j)*x_ref[0] + ((0.00867652309578+0.158962114255j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(-0.0750427469302-0.422969320771j)*x[0] + ((-0.104795643565+0.829535545327j))*x[1]
        ref[(0, 0, 2, 0)]=(-0.0750427469302-0.422969320771j)*x_ref[0] + ((-0.104795643565+0.829535545327j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(-0.273397339695+0.494430088398j)*x[0] + ((0.828151450018+0.845740103018j))*x[1]
        ref[(0, 0, 2, 1)]=(-0.273397339695+0.494430088398j)*x_ref[0] + ((0.828151450018+0.845740103018j))*x_ref[1]
        arg[(0, 0, 2, 2)]=(0.692564672984+0.35833629249j)*x[0] + ((0.473297372771+0.142671962675j))*x[1]
        ref[(0, 0, 2, 2)]=(0.692564672984+0.35833629249j)*x_ref[0] + ((0.473297372771+0.142671962675j))*x_ref[1]
        arg[(0, 0, 2, 3)]=(0.323603841366-0.932991177808j)*x[0] + ((0.563587988372+0.0626559181029j))*x[1]
        ref[(0, 0, 2, 3)]=(0.323603841366-0.932991177808j)*x_ref[0] + ((0.563587988372+0.0626559181029j))*x_ref[1]
        arg[(0, 0, 3, 0)]=(-0.914828758856+0.845993987228j)*x[0] + ((-0.254922798934+0.820962066227j))*x[1]
        ref[(0, 0, 3, 0)]=(-0.914828758856+0.845993987228j)*x_ref[0] + ((-0.254922798934+0.820962066227j))*x_ref[1]
        arg[(0, 0, 3, 1)]=(-0.88796417872-0.249820002731j)*x[0] + ((0.523572790713+0.539132500055j))*x[1]
        ref[(0, 0, 3, 1)]=(-0.88796417872-0.249820002731j)*x_ref[0] + ((0.523572790713+0.539132500055j))*x_ref[1]
        arg[(0, 0, 3, 2)]=(-0.962060113744+0.688822839222j)*x[0] + ((0.514985844514+0.124800939727j))*x[1]
        ref[(0, 0, 3, 2)]=(-0.962060113744+0.688822839222j)*x_ref[0] + ((0.514985844514+0.124800939727j))*x_ref[1]
        arg[(0, 0, 3, 3)]=(-0.617202691931+0.848401153062j)*x[0] + ((0.500067734292+0.50111474973j))*x[1]
        ref[(0, 0, 3, 3)]=(-0.617202691931+0.848401153062j)*x_ref[0] + ((0.500067734292+0.50111474973j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.404588275527-0.736338835043j)*x[0] + ((-0.456809342921+0.207522957222j))*x[1]
        ref[(0, 1, 0, 0)]=(0.404588275527-0.736338835043j)*x_ref[0] + ((-0.456809342921+0.207522957222j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(0.445404653117-0.729037144184j)*x[0] + ((0.553401169135+0.0272260494943j))*x[1]
        ref[(0, 1, 0, 1)]=(0.445404653117-0.729037144184j)*x_ref[0] + ((0.553401169135+0.0272260494943j))*x_ref[1]
        arg[(0, 1, 0, 2)]=(0.0973360418107+0.431664861397j)*x[0] + ((0.167111176542-0.341786138702j))*x[1]
        ref[(0, 1, 0, 2)]=(0.0973360418107+0.431664861397j)*x_ref[0] + ((0.167111176542-0.341786138702j))*x_ref[1]
        arg[(0, 1, 0, 3)]=(-0.559880419181+0.0730743253642j)*x[0] + ((0.260887273919-0.50919006712j))*x[1]
        ref[(0, 1, 0, 3)]=(-0.559880419181+0.0730743253642j)*x_ref[0] + ((0.260887273919-0.50919006712j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.656598401632-0.894614766825j)*x[0] + ((-0.308271278131-0.70816542918j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.656598401632-0.894614766825j)*x_ref[0] + ((-0.308271278131-0.70816542918j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(0.333992428511-0.381502448261j)*x[0] + ((0.961350966944+0.160019735294j))*x[1]
        ref[(0, 1, 1, 1)]=(0.333992428511-0.381502448261j)*x_ref[0] + ((0.961350966944+0.160019735294j))*x_ref[1]
        arg[(0, 1, 1, 2)]=(-0.333568947236-0.539485819812j)*x[0] + ((-0.767468214396+0.376131033017j))*x[1]
        ref[(0, 1, 1, 2)]=(-0.333568947236-0.539485819812j)*x_ref[0] + ((-0.767468214396+0.376131033017j))*x_ref[1]
        arg[(0, 1, 1, 3)]=(0.886848447741-0.572364936164j)*x[0] + ((0.204681965246+0.183131655076j))*x[1]
        ref[(0, 1, 1, 3)]=(0.886848447741-0.572364936164j)*x_ref[0] + ((0.204681965246+0.183131655076j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(-0.410797539008-0.00913697211464j)*x[0] + ((0.554084661557+0.35147963735j))*x[1]
        ref[(0, 1, 2, 0)]=(-0.410797539008-0.00913697211464j)*x_ref[0] + ((0.554084661557+0.35147963735j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(-0.889094556197-0.292993397226j)*x[0] + ((0.930796258751+0.111814575704j))*x[1]
        ref[(0, 1, 2, 1)]=(-0.889094556197-0.292993397226j)*x_ref[0] + ((0.930796258751+0.111814575704j))*x_ref[1]
        arg[(0, 1, 2, 2)]=(-0.595987707658-0.282257408332j)*x[0] + ((-0.453579348188+0.994165204444j))*x[1]
        ref[(0, 1, 2, 2)]=(-0.595987707658-0.282257408332j)*x_ref[0] + ((-0.453579348188+0.994165204444j))*x_ref[1]
        arg[(0, 1, 2, 3)]=(0.748091676442-0.838398747241j)*x[0] + ((0.890276454035+0.912277026749j))*x[1]
        ref[(0, 1, 2, 3)]=(0.748091676442-0.838398747241j)*x_ref[0] + ((0.890276454035+0.912277026749j))*x_ref[1]
        arg[(0, 1, 3, 0)]=(-0.892794806281-0.140374077126j)*x[0] + ((-0.460405604549-0.0650866991359j))*x[1]
        ref[(0, 1, 3, 0)]=(-0.892794806281-0.140374077126j)*x_ref[0] + ((-0.460405604549-0.0650866991359j))*x_ref[1]
        arg[(0, 1, 3, 1)]=(0.905857384247+0.521710138164j)*x[0] + ((0.142945139003+0.275263724164j))*x[1]
        ref[(0, 1, 3, 1)]=(0.905857384247+0.521710138164j)*x_ref[0] + ((0.142945139003+0.275263724164j))*x_ref[1]
        arg[(0, 1, 3, 2)]=(-0.909313970645-0.318616336541j)*x[0] + ((-0.690144286759-0.19693307506j))*x[1]
        ref[(0, 1, 3, 2)]=(-0.909313970645-0.318616336541j)*x_ref[0] + ((-0.690144286759-0.19693307506j))*x_ref[1]
        arg[(0, 1, 3, 3)]=(0.928876965734-0.319349374802j)*x[0] + ((-0.600014996495+0.802990242194j))*x[1]
        ref[(0, 1, 3, 3)]=(0.928876965734-0.319349374802j)*x_ref[0] + ((-0.600014996495+0.802990242194j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(-0.88537382296+0.67984103142j)*x[0] + ((0.114916903294-0.509380299778j))*x[1]
        ref[(0, 2, 0, 0)]=(-0.88537382296+0.67984103142j)*x_ref[0] + ((0.114916903294-0.509380299778j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(-0.37358965353-0.544319460269j)*x[0] + ((-0.0676553699972-0.933792067723j))*x[1]
        ref[(0, 2, 0, 1)]=(-0.37358965353-0.544319460269j)*x_ref[0] + ((-0.0676553699972-0.933792067723j))*x_ref[1]
        arg[(0, 2, 0, 2)]=(0.12880136542-0.292396716663j)*x[0] + ((-0.842870847053+0.426433653519j))*x[1]
        ref[(0, 2, 0, 2)]=(0.12880136542-0.292396716663j)*x_ref[0] + ((-0.842870847053+0.426433653519j))*x_ref[1]
        arg[(0, 2, 0, 3)]=(-0.460237750488-0.169111734852j)*x[0] + ((0.719668213572+0.541285430987j))*x[1]
        ref[(0, 2, 0, 3)]=(-0.460237750488-0.169111734852j)*x_ref[0] + ((0.719668213572+0.541285430987j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(-0.814781371892+0.621313155203j)*x[0] + ((0.0995538153298-0.83382200184j))*x[1]
        ref[(0, 2, 1, 0)]=(-0.814781371892+0.621313155203j)*x_ref[0] + ((0.0995538153298-0.83382200184j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(0.909181820684+0.444597535406j)*x[0] + ((0.902276804721-0.6052999974j))*x[1]
        ref[(0, 2, 1, 1)]=(0.909181820684+0.444597535406j)*x_ref[0] + ((0.902276804721-0.6052999974j))*x_ref[1]
        arg[(0, 2, 1, 2)]=(0.974532058365-0.317614618898j)*x[0] + ((-0.442837987314+0.66883253685j))*x[1]
        ref[(0, 2, 1, 2)]=(0.974532058365-0.317614618898j)*x_ref[0] + ((-0.442837987314+0.66883253685j))*x_ref[1]
        arg[(0, 2, 1, 3)]=(0.730165105164+0.463459529572j)*x[0] + ((-0.62330979064+0.136894591022j))*x[1]
        ref[(0, 2, 1, 3)]=(0.730165105164+0.463459529572j)*x_ref[0] + ((-0.62330979064+0.136894591022j))*x_ref[1]
        arg[(0, 2, 2, 0)]=(-0.0153522590439+0.721895584318j)*x[0] + ((-0.687514278719-0.564249087578j))*x[1]
        ref[(0, 2, 2, 0)]=(-0.0153522590439+0.721895584318j)*x_ref[0] + ((-0.687514278719-0.564249087578j))*x_ref[1]
        arg[(0, 2, 2, 1)]=(-0.215365331322+0.41645089822j)*x[0] + ((0.382134034898-0.0419457251491j))*x[1]
        ref[(0, 2, 2, 1)]=(-0.215365331322+0.41645089822j)*x_ref[0] + ((0.382134034898-0.0419457251491j))*x_ref[1]
        arg[(0, 2, 2, 2)]=(-0.959083784071-0.32677701701j)*x[0] + ((-0.365713398281-0.783772596732j))*x[1]
        ref[(0, 2, 2, 2)]=(-0.959083784071-0.32677701701j)*x_ref[0] + ((-0.365713398281-0.783772596732j))*x_ref[1]
        arg[(0, 2, 2, 3)]=(0.158921028888+0.890114042945j)*x[0] + ((-0.103581662378-0.070037650996j))*x[1]
        ref[(0, 2, 2, 3)]=(0.158921028888+0.890114042945j)*x_ref[0] + ((-0.103581662378-0.070037650996j))*x_ref[1]
        arg[(0, 2, 3, 0)]=(0.815085929007+0.690774727106j)*x[0] + ((-0.109458382471+0.860513551593j))*x[1]
        ref[(0, 2, 3, 0)]=(0.815085929007+0.690774727106j)*x_ref[0] + ((-0.109458382471+0.860513551593j))*x_ref[1]
        arg[(0, 2, 3, 1)]=(0.891404619999+0.472288554375j)*x[0] + ((0.72296751007+0.763219429713j))*x[1]
        ref[(0, 2, 3, 1)]=(0.891404619999+0.472288554375j)*x_ref[0] + ((0.72296751007+0.763219429713j))*x_ref[1]
        arg[(0, 2, 3, 2)]=(-0.206975237227+0.881393477316j)*x[0] + ((0.195862305237-0.151559889784j))*x[1]
        ref[(0, 2, 3, 2)]=(-0.206975237227+0.881393477316j)*x_ref[0] + ((0.195862305237-0.151559889784j))*x_ref[1]
        arg[(0, 2, 3, 3)]=(-0.18484336868+0.908265862389j)*x[0] + ((-0.379960227072-0.943279460909j))*x[1]
        ref[(0, 2, 3, 3)]=(-0.18484336868+0.908265862389j)*x_ref[0] + ((-0.379960227072-0.943279460909j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(-0.799272153332+0.262094021913j)*x[0] + ((0.730140642712-0.948998592822j))*x[1]
        ref[(1, 0, 0, 0)]=(-0.799272153332+0.262094021913j)*x_ref[0] + ((0.730140642712-0.948998592822j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.254866769606-0.315484974347j)*x[0] + ((-0.519268122785-0.944887970617j))*x[1]
        ref[(1, 0, 0, 1)]=(0.254866769606-0.315484974347j)*x_ref[0] + ((-0.519268122785-0.944887970617j))*x_ref[1]
        arg[(1, 0, 0, 2)]=(0.289894411649+0.167333610533j)*x[0] + ((-0.672259928831+0.0200470203575j))*x[1]
        ref[(1, 0, 0, 2)]=(0.289894411649+0.167333610533j)*x_ref[0] + ((-0.672259928831+0.0200470203575j))*x_ref[1]
        arg[(1, 0, 0, 3)]=(-0.206387586245+0.707921717594j)*x[0] + ((-0.855724186215+0.599673161791j))*x[1]
        ref[(1, 0, 0, 3)]=(-0.206387586245+0.707921717594j)*x_ref[0] + ((-0.855724186215+0.599673161791j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.458331887841-0.572315983541j)*x[0] + ((-0.433109719452-0.176553445894j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.458331887841-0.572315983541j)*x_ref[0] + ((-0.433109719452-0.176553445894j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(0.227137141768-0.381679870857j)*x[0] + ((0.845596661208+0.388802418463j))*x[1]
        ref[(1, 0, 1, 1)]=(0.227137141768-0.381679870857j)*x_ref[0] + ((0.845596661208+0.388802418463j))*x_ref[1]
        arg[(1, 0, 1, 2)]=(-0.057005519234+0.610960348251j)*x[0] + ((0.686467926482+0.159612602357j))*x[1]
        ref[(1, 0, 1, 2)]=(-0.057005519234+0.610960348251j)*x_ref[0] + ((0.686467926482+0.159612602357j))*x_ref[1]
        arg[(1, 0, 1, 3)]=(0.770467283545-0.290551401376j)*x[0] + ((-0.880529351495+0.836894496799j))*x[1]
        ref[(1, 0, 1, 3)]=(0.770467283545-0.290551401376j)*x_ref[0] + ((-0.880529351495+0.836894496799j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(0.813813722086-0.138567605127j)*x[0] + ((0.76761137152-0.605782601267j))*x[1]
        ref[(1, 0, 2, 0)]=(0.813813722086-0.138567605127j)*x_ref[0] + ((0.76761137152-0.605782601267j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(0.0325525659166+0.46400763509j)*x[0] + ((-0.698211747245-0.754961382155j))*x[1]
        ref[(1, 0, 2, 1)]=(0.0325525659166+0.46400763509j)*x_ref[0] + ((-0.698211747245-0.754961382155j))*x_ref[1]
        arg[(1, 0, 2, 2)]=(0.863176724816+0.407877262745j)*x[0] + ((0.9351733353-0.00317999702669j))*x[1]
        ref[(1, 0, 2, 2)]=(0.863176724816+0.407877262745j)*x_ref[0] + ((0.9351733353-0.00317999702669j))*x_ref[1]
        arg[(1, 0, 2, 3)]=(0.0364958582067+0.536965943077j)*x[0] + ((-0.811309048736+0.927575478093j))*x[1]
        ref[(1, 0, 2, 3)]=(0.0364958582067+0.536965943077j)*x_ref[0] + ((-0.811309048736+0.927575478093j))*x_ref[1]
        arg[(1, 0, 3, 0)]=(-0.897020640839-0.317920846559j)*x[0] + ((-0.373458307153-0.804676567557j))*x[1]
        ref[(1, 0, 3, 0)]=(-0.897020640839-0.317920846559j)*x_ref[0] + ((-0.373458307153-0.804676567557j))*x_ref[1]
        arg[(1, 0, 3, 1)]=(0.428492872267+0.200640909199j)*x[0] + ((0.953649026397+0.444676558884j))*x[1]
        ref[(1, 0, 3, 1)]=(0.428492872267+0.200640909199j)*x_ref[0] + ((0.953649026397+0.444676558884j))*x_ref[1]
        arg[(1, 0, 3, 2)]=(-0.287479028391-0.625428409947j)*x[0] + ((-0.907936309919-0.00798646010879j))*x[1]
        ref[(1, 0, 3, 2)]=(-0.287479028391-0.625428409947j)*x_ref[0] + ((-0.907936309919-0.00798646010879j))*x_ref[1]
        arg[(1, 0, 3, 3)]=(0.764710447975+0.954111601611j)*x[0] + ((0.822455070628-0.455851098887j))*x[1]
        ref[(1, 0, 3, 3)]=(0.764710447975+0.954111601611j)*x_ref[0] + ((0.822455070628-0.455851098887j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(-0.569301013891+0.183838668993j)*x[0] + ((0.2063738691+0.0127520959793j))*x[1]
        ref[(1, 1, 0, 0)]=(-0.569301013891+0.183838668993j)*x_ref[0] + ((0.2063738691+0.0127520959793j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(0.709510247795+0.510195720342j)*x[0] + ((-0.0736234427527+0.497438871084j))*x[1]
        ref[(1, 1, 0, 1)]=(0.709510247795+0.510195720342j)*x_ref[0] + ((-0.0736234427527+0.497438871084j))*x_ref[1]
        arg[(1, 1, 0, 2)]=(0.0122623626754-0.379771969208j)*x[0] + ((-0.708275799859+0.72999242485j))*x[1]
        ref[(1, 1, 0, 2)]=(0.0122623626754-0.379771969208j)*x_ref[0] + ((-0.708275799859+0.72999242485j))*x_ref[1]
        arg[(1, 1, 0, 3)]=(0.598450631871-0.814035202562j)*x[0] + ((0.034187294819+0.0245102680466j))*x[1]
        ref[(1, 1, 0, 3)]=(0.598450631871-0.814035202562j)*x_ref[0] + ((0.034187294819+0.0245102680466j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.025335725084-0.0123202694237j)*x[0] + ((0.697512243564-0.905190748668j))*x[1]
        ref[(1, 1, 1, 0)]=(0.025335725084-0.0123202694237j)*x_ref[0] + ((0.697512243564-0.905190748668j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(0.791593680776-0.276755285782j)*x[0] + ((0.48585039998+0.187604252672j))*x[1]
        ref[(1, 1, 1, 1)]=(0.791593680776-0.276755285782j)*x_ref[0] + ((0.48585039998+0.187604252672j))*x_ref[1]
        arg[(1, 1, 1, 2)]=(0.104053941681+0.491272246935j)*x[0] + ((-0.548255467495+0.832724573371j))*x[1]
        ref[(1, 1, 1, 2)]=(0.104053941681+0.491272246935j)*x_ref[0] + ((-0.548255467495+0.832724573371j))*x_ref[1]
        arg[(1, 1, 1, 3)]=(-0.922144478476-0.902737675299j)*x[0] + ((0.062161215744-0.81949073255j))*x[1]
        ref[(1, 1, 1, 3)]=(-0.922144478476-0.902737675299j)*x_ref[0] + ((0.062161215744-0.81949073255j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(-0.23790615432+0.181568478168j)*x[0] + ((0.783862815764+0.330962033422j))*x[1]
        ref[(1, 1, 2, 0)]=(-0.23790615432+0.181568478168j)*x_ref[0] + ((0.783862815764+0.330962033422j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(0.89124113109+0.250213719951j)*x[0] + ((-0.985768738609+0.162158142469j))*x[1]
        ref[(1, 1, 2, 1)]=(0.89124113109+0.250213719951j)*x_ref[0] + ((-0.985768738609+0.162158142469j))*x_ref[1]
        arg[(1, 1, 2, 2)]=(-0.963410029993+0.252323774734j)*x[0] + ((0.824336328656+0.303552968738j))*x[1]
        ref[(1, 1, 2, 2)]=(-0.963410029993+0.252323774734j)*x_ref[0] + ((0.824336328656+0.303552968738j))*x_ref[1]
        arg[(1, 1, 2, 3)]=(0.759890786939+0.272818361164j)*x[0] + ((-0.558978566311+0.343911198816j))*x[1]
        ref[(1, 1, 2, 3)]=(0.759890786939+0.272818361164j)*x_ref[0] + ((-0.558978566311+0.343911198816j))*x_ref[1]
        arg[(1, 1, 3, 0)]=(0.703866854473-0.0459433492647j)*x[0] + ((0.672637583524+0.54493001903j))*x[1]
        ref[(1, 1, 3, 0)]=(0.703866854473-0.0459433492647j)*x_ref[0] + ((0.672637583524+0.54493001903j))*x_ref[1]
        arg[(1, 1, 3, 1)]=(0.61423626411+0.0983613486092j)*x[0] + ((0.698688879283+0.602569828329j))*x[1]
        ref[(1, 1, 3, 1)]=(0.61423626411+0.0983613486092j)*x_ref[0] + ((0.698688879283+0.602569828329j))*x_ref[1]
        arg[(1, 1, 3, 2)]=(0.15688665455-0.823583274309j)*x[0] + ((0.933154153205-0.901521457118j))*x[1]
        ref[(1, 1, 3, 2)]=(0.15688665455-0.823583274309j)*x_ref[0] + ((0.933154153205-0.901521457118j))*x_ref[1]
        arg[(1, 1, 3, 3)]=(0.511540583433-0.328291088461j)*x[0] + ((-0.736116831806+0.417225318913j))*x[1]
        ref[(1, 1, 3, 3)]=(0.511540583433-0.328291088461j)*x_ref[0] + ((-0.736116831806+0.417225318913j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(0.373932184784-0.269129093299j)*x[0] + ((0.238837675903-0.877387557108j))*x[1]
        ref[(1, 2, 0, 0)]=(0.373932184784-0.269129093299j)*x_ref[0] + ((0.238837675903-0.877387557108j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(0.593526317187-0.0240630857317j)*x[0] + ((0.573907210605-0.189558519618j))*x[1]
        ref[(1, 2, 0, 1)]=(0.593526317187-0.0240630857317j)*x_ref[0] + ((0.573907210605-0.189558519618j))*x_ref[1]
        arg[(1, 2, 0, 2)]=(0.505469653859-0.950817241589j)*x[0] + ((-0.0434582084242+0.807674276059j))*x[1]
        ref[(1, 2, 0, 2)]=(0.505469653859-0.950817241589j)*x_ref[0] + ((-0.0434582084242+0.807674276059j))*x_ref[1]
        arg[(1, 2, 0, 3)]=(-0.48547984723-0.85800738835j)*x[0] + ((-0.02435641287-0.314256224594j))*x[1]
        ref[(1, 2, 0, 3)]=(-0.48547984723-0.85800738835j)*x_ref[0] + ((-0.02435641287-0.314256224594j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(0.818937457705+0.943534714046j)*x[0] + ((0.205809629842-0.711639831726j))*x[1]
        ref[(1, 2, 1, 0)]=(0.818937457705+0.943534714046j)*x_ref[0] + ((0.205809629842-0.711639831726j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(-0.987136055347-0.0212247849042j)*x[0] + ((0.529196297653+0.33770496929j))*x[1]
        ref[(1, 2, 1, 1)]=(-0.987136055347-0.0212247849042j)*x_ref[0] + ((0.529196297653+0.33770496929j))*x_ref[1]
        arg[(1, 2, 1, 2)]=(0.0630048552348+0.264723537738j)*x[0] + ((0.0855290124628+0.836424290276j))*x[1]
        ref[(1, 2, 1, 2)]=(0.0630048552348+0.264723537738j)*x_ref[0] + ((0.0855290124628+0.836424290276j))*x_ref[1]
        arg[(1, 2, 1, 3)]=(-0.49738033635-0.63492183915j)*x[0] + ((0.982142153542-0.585170449274j))*x[1]
        ref[(1, 2, 1, 3)]=(-0.49738033635-0.63492183915j)*x_ref[0] + ((0.982142153542-0.585170449274j))*x_ref[1]
        arg[(1, 2, 2, 0)]=(0.418112845142+0.383555105099j)*x[0] + ((0.971311424648+0.750244032449j))*x[1]
        ref[(1, 2, 2, 0)]=(0.418112845142+0.383555105099j)*x_ref[0] + ((0.971311424648+0.750244032449j))*x_ref[1]
        arg[(1, 2, 2, 1)]=(-0.133479124607-0.923087242631j)*x[0] + ((-0.275309408266+0.0395507379918j))*x[1]
        ref[(1, 2, 2, 1)]=(-0.133479124607-0.923087242631j)*x_ref[0] + ((-0.275309408266+0.0395507379918j))*x_ref[1]
        arg[(1, 2, 2, 2)]=(-0.319033927438-0.128740116505j)*x[0] + ((-0.264292232014+0.0588550981287j))*x[1]
        ref[(1, 2, 2, 2)]=(-0.319033927438-0.128740116505j)*x_ref[0] + ((-0.264292232014+0.0588550981287j))*x_ref[1]
        arg[(1, 2, 2, 3)]=(-0.419451930328+0.920552641782j)*x[0] + ((-0.668472702852-0.257593229651j))*x[1]
        ref[(1, 2, 2, 3)]=(-0.419451930328+0.920552641782j)*x_ref[0] + ((-0.668472702852-0.257593229651j))*x_ref[1]
        arg[(1, 2, 3, 0)]=(0.0381335836439-0.497156485128j)*x[0] + ((-0.929039843392+0.171470762583j))*x[1]
        ref[(1, 2, 3, 0)]=(0.0381335836439-0.497156485128j)*x_ref[0] + ((-0.929039843392+0.171470762583j))*x_ref[1]
        arg[(1, 2, 3, 1)]=(0.410042397298-0.105627587517j)*x[0] + ((0.411274467312+0.502159919713j))*x[1]
        ref[(1, 2, 3, 1)]=(0.410042397298-0.105627587517j)*x_ref[0] + ((0.411274467312+0.502159919713j))*x_ref[1]
        arg[(1, 2, 3, 2)]=(-0.881309332638-0.958620853317j)*x[0] + ((0.965088173348+0.503109712726j))*x[1]
        ref[(1, 2, 3, 2)]=(-0.881309332638-0.958620853317j)*x_ref[0] + ((0.965088173348+0.503109712726j))*x_ref[1]
        arg[(1, 2, 3, 3)]=(0.325676112212-0.447260066467j)*x[0] + ((0.766601810897-0.0345880587188j))*x[1]
        ref[(1, 2, 3, 3)]=(0.325676112212-0.447260066467j)*x_ref[0] + ((0.766601810897-0.0345880587188j))*x_ref[1]
        arg[(2, 0, 0, 0)]=(-0.735474404597-0.627640649938j)*x[0] + ((-0.60355947123+0.103276018301j))*x[1]
        ref[(2, 0, 0, 0)]=(-0.735474404597-0.627640649938j)*x_ref[0] + ((-0.60355947123+0.103276018301j))*x_ref[1]
        arg[(2, 0, 0, 1)]=(-0.98285902162+0.382831352941j)*x[0] + ((0.239280999106+0.0368077104788j))*x[1]
        ref[(2, 0, 0, 1)]=(-0.98285902162+0.382831352941j)*x_ref[0] + ((0.239280999106+0.0368077104788j))*x_ref[1]
        arg[(2, 0, 0, 2)]=(-0.885283429353+0.903101005056j)*x[0] + ((-8.18529433413e-05-0.248635489729j))*x[1]
        ref[(2, 0, 0, 2)]=(-0.885283429353+0.903101005056j)*x_ref[0] + ((-8.18529433413e-05-0.248635489729j))*x_ref[1]
        arg[(2, 0, 0, 3)]=(-0.0673468995256-0.977169547577j)*x[0] + ((-0.662423284387+0.550090598821j))*x[1]
        ref[(2, 0, 0, 3)]=(-0.0673468995256-0.977169547577j)*x_ref[0] + ((-0.662423284387+0.550090598821j))*x_ref[1]
        arg[(2, 0, 1, 0)]=(0.946778322469+0.402540516609j)*x[0] + ((-0.19237256003-0.0273649534586j))*x[1]
        ref[(2, 0, 1, 0)]=(0.946778322469+0.402540516609j)*x_ref[0] + ((-0.19237256003-0.0273649534586j))*x_ref[1]
        arg[(2, 0, 1, 1)]=(-0.17050498153+0.754046703236j)*x[0] + ((-0.503338738911-0.436278917781j))*x[1]
        ref[(2, 0, 1, 1)]=(-0.17050498153+0.754046703236j)*x_ref[0] + ((-0.503338738911-0.436278917781j))*x_ref[1]
        arg[(2, 0, 1, 2)]=(0.294897790892+0.490383837004j)*x[0] + ((-0.156201705548-0.984315462887j))*x[1]
        ref[(2, 0, 1, 2)]=(0.294897790892+0.490383837004j)*x_ref[0] + ((-0.156201705548-0.984315462887j))*x_ref[1]
        arg[(2, 0, 1, 3)]=(0.0544066420349+0.951193491229j)*x[0] + ((0.349334979013+0.97612649816j))*x[1]
        ref[(2, 0, 1, 3)]=(0.0544066420349+0.951193491229j)*x_ref[0] + ((0.349334979013+0.97612649816j))*x_ref[1]
        arg[(2, 0, 2, 0)]=(0.606504597607+0.76751426138j)*x[0] + ((0.00464227825875+0.166535837612j))*x[1]
        ref[(2, 0, 2, 0)]=(0.606504597607+0.76751426138j)*x_ref[0] + ((0.00464227825875+0.166535837612j))*x_ref[1]
        arg[(2, 0, 2, 1)]=(0.273662270481+0.740854179316j)*x[0] + ((-0.558517822737-0.554222958987j))*x[1]
        ref[(2, 0, 2, 1)]=(0.273662270481+0.740854179316j)*x_ref[0] + ((-0.558517822737-0.554222958987j))*x_ref[1]
        arg[(2, 0, 2, 2)]=(0.93941629074-0.620913828581j)*x[0] + ((-0.935712467673-0.311250862183j))*x[1]
        ref[(2, 0, 2, 2)]=(0.93941629074-0.620913828581j)*x_ref[0] + ((-0.935712467673-0.311250862183j))*x_ref[1]
        arg[(2, 0, 2, 3)]=(-0.588533934225-0.508424901542j)*x[0] + ((-0.424007049548-0.18669388246j))*x[1]
        ref[(2, 0, 2, 3)]=(-0.588533934225-0.508424901542j)*x_ref[0] + ((-0.424007049548-0.18669388246j))*x_ref[1]
        arg[(2, 0, 3, 0)]=(0.408685593951+0.517036278245j)*x[0] + ((0.151503500874-0.731122726207j))*x[1]
        ref[(2, 0, 3, 0)]=(0.408685593951+0.517036278245j)*x_ref[0] + ((0.151503500874-0.731122726207j))*x_ref[1]
        arg[(2, 0, 3, 1)]=(0.999514529399-0.128843664134j)*x[0] + ((0.28550650218-0.681887238765j))*x[1]
        ref[(2, 0, 3, 1)]=(0.999514529399-0.128843664134j)*x_ref[0] + ((0.28550650218-0.681887238765j))*x_ref[1]
        arg[(2, 0, 3, 2)]=(-0.31653397804-0.716752452693j)*x[0] + ((0.547449396454+0.364767904069j))*x[1]
        ref[(2, 0, 3, 2)]=(-0.31653397804-0.716752452693j)*x_ref[0] + ((0.547449396454+0.364767904069j))*x_ref[1]
        arg[(2, 0, 3, 3)]=(-0.871449402207+0.263645811061j)*x[0] + ((-0.865829502819+0.871238084257j))*x[1]
        ref[(2, 0, 3, 3)]=(-0.871449402207+0.263645811061j)*x_ref[0] + ((-0.865829502819+0.871238084257j))*x_ref[1]
        arg[(2, 1, 0, 0)]=(0.980343745813+0.727833805059j)*x[0] + ((0.356222678105+0.92577102264j))*x[1]
        ref[(2, 1, 0, 0)]=(0.980343745813+0.727833805059j)*x_ref[0] + ((0.356222678105+0.92577102264j))*x_ref[1]
        arg[(2, 1, 0, 1)]=(-0.339011542219-0.901208320509j)*x[0] + ((-0.669770043416+0.344584086262j))*x[1]
        ref[(2, 1, 0, 1)]=(-0.339011542219-0.901208320509j)*x_ref[0] + ((-0.669770043416+0.344584086262j))*x_ref[1]
        arg[(2, 1, 0, 2)]=(-0.719664578621+0.208266951948j)*x[0] + ((0.774556148163-0.251590350409j))*x[1]
        ref[(2, 1, 0, 2)]=(-0.719664578621+0.208266951948j)*x_ref[0] + ((0.774556148163-0.251590350409j))*x_ref[1]
        arg[(2, 1, 0, 3)]=(-0.0962773550774+0.5350323185j)*x[0] + ((-0.427709957449-0.364221434632j))*x[1]
        ref[(2, 1, 0, 3)]=(-0.0962773550774+0.5350323185j)*x_ref[0] + ((-0.427709957449-0.364221434632j))*x_ref[1]
        arg[(2, 1, 1, 0)]=(-0.470050646539-0.838215356692j)*x[0] + ((0.541896086051-0.120158957837j))*x[1]
        ref[(2, 1, 1, 0)]=(-0.470050646539-0.838215356692j)*x_ref[0] + ((0.541896086051-0.120158957837j))*x_ref[1]
        arg[(2, 1, 1, 1)]=(-0.551339976303-0.848835426897j)*x[0] + ((0.196106410852-0.360385086049j))*x[1]
        ref[(2, 1, 1, 1)]=(-0.551339976303-0.848835426897j)*x_ref[0] + ((0.196106410852-0.360385086049j))*x_ref[1]
        arg[(2, 1, 1, 2)]=(-0.251423492417+0.815353672561j)*x[0] + ((-0.635991865786-0.758822982164j))*x[1]
        ref[(2, 1, 1, 2)]=(-0.251423492417+0.815353672561j)*x_ref[0] + ((-0.635991865786-0.758822982164j))*x_ref[1]
        arg[(2, 1, 1, 3)]=(0.479707229485-0.88330000536j)*x[0] + ((0.00017921229431-0.663425699985j))*x[1]
        ref[(2, 1, 1, 3)]=(0.479707229485-0.88330000536j)*x_ref[0] + ((0.00017921229431-0.663425699985j))*x_ref[1]
        arg[(2, 1, 2, 0)]=(0.592026691834-0.323985876488j)*x[0] + ((-0.185321047742+0.38901855475j))*x[1]
        ref[(2, 1, 2, 0)]=(0.592026691834-0.323985876488j)*x_ref[0] + ((-0.185321047742+0.38901855475j))*x_ref[1]
        arg[(2, 1, 2, 1)]=(0.34847474333+0.940908713299j)*x[0] + ((0.1248524293-0.887498446192j))*x[1]
        ref[(2, 1, 2, 1)]=(0.34847474333+0.940908713299j)*x_ref[0] + ((0.1248524293-0.887498446192j))*x_ref[1]
        arg[(2, 1, 2, 2)]=(-0.537257612257-0.709806003453j)*x[0] + ((-0.0823623293892+0.0122632208208j))*x[1]
        ref[(2, 1, 2, 2)]=(-0.537257612257-0.709806003453j)*x_ref[0] + ((-0.0823623293892+0.0122632208208j))*x_ref[1]
        arg[(2, 1, 2, 3)]=(-0.220773061393+0.957244020551j)*x[0] + ((0.51134687851-0.0670734506203j))*x[1]
        ref[(2, 1, 2, 3)]=(-0.220773061393+0.957244020551j)*x_ref[0] + ((0.51134687851-0.0670734506203j))*x_ref[1]
        arg[(2, 1, 3, 0)]=(0.0951107043888+0.539891221352j)*x[0] + ((0.827673226794-0.206065986249j))*x[1]
        ref[(2, 1, 3, 0)]=(0.0951107043888+0.539891221352j)*x_ref[0] + ((0.827673226794-0.206065986249j))*x_ref[1]
        arg[(2, 1, 3, 1)]=(-0.822585994588+0.909367506589j)*x[0] + ((-0.881149145277-0.785831318914j))*x[1]
        ref[(2, 1, 3, 1)]=(-0.822585994588+0.909367506589j)*x_ref[0] + ((-0.881149145277-0.785831318914j))*x_ref[1]
        arg[(2, 1, 3, 2)]=(0.972481085599+0.269225019762j)*x[0] + ((-0.323458184462+0.510988460759j))*x[1]
        ref[(2, 1, 3, 2)]=(0.972481085599+0.269225019762j)*x_ref[0] + ((-0.323458184462+0.510988460759j))*x_ref[1]
        arg[(2, 1, 3, 3)]=(-0.49700542416+0.0934627919805j)*x[0] + ((-0.216661636791+0.217509916585j))*x[1]
        ref[(2, 1, 3, 3)]=(-0.49700542416+0.0934627919805j)*x_ref[0] + ((-0.216661636791+0.217509916585j))*x_ref[1]
        arg[(2, 2, 0, 0)]=(-0.997645731976+0.251047443627j)*x[0] + ((0.661593651216+0.129986742414j))*x[1]
        ref[(2, 2, 0, 0)]=(-0.997645731976+0.251047443627j)*x_ref[0] + ((0.661593651216+0.129986742414j))*x_ref[1]
        arg[(2, 2, 0, 1)]=(-0.0946725986346-0.0808654079043j)*x[0] + ((-0.840454879167-0.456063796456j))*x[1]
        ref[(2, 2, 0, 1)]=(-0.0946725986346-0.0808654079043j)*x_ref[0] + ((-0.840454879167-0.456063796456j))*x_ref[1]
        arg[(2, 2, 0, 2)]=(0.856252085172+0.452811165664j)*x[0] + ((-0.938081966749+0.855157873435j))*x[1]
        ref[(2, 2, 0, 2)]=(0.856252085172+0.452811165664j)*x_ref[0] + ((-0.938081966749+0.855157873435j))*x_ref[1]
        arg[(2, 2, 0, 3)]=(-0.278785997818+0.695340385278j)*x[0] + ((-0.55116946632-0.389251346924j))*x[1]
        ref[(2, 2, 0, 3)]=(-0.278785997818+0.695340385278j)*x_ref[0] + ((-0.55116946632-0.389251346924j))*x_ref[1]
        arg[(2, 2, 1, 0)]=(-0.654313924646-0.109993625358j)*x[0] + ((-0.023033071988+0.39749121838j))*x[1]
        ref[(2, 2, 1, 0)]=(-0.654313924646-0.109993625358j)*x_ref[0] + ((-0.023033071988+0.39749121838j))*x_ref[1]
        arg[(2, 2, 1, 1)]=(0.396379688061+0.835899769589j)*x[0] + ((0.422830246359+0.995815749625j))*x[1]
        ref[(2, 2, 1, 1)]=(0.396379688061+0.835899769589j)*x_ref[0] + ((0.422830246359+0.995815749625j))*x_ref[1]
        arg[(2, 2, 1, 2)]=(-0.262726261265-0.763907545309j)*x[0] + ((-0.98668559088+0.494038587804j))*x[1]
        ref[(2, 2, 1, 2)]=(-0.262726261265-0.763907545309j)*x_ref[0] + ((-0.98668559088+0.494038587804j))*x_ref[1]
        arg[(2, 2, 1, 3)]=(0.731993270734+0.347473946685j)*x[0] + ((0.561472240334+0.246096105641j))*x[1]
        ref[(2, 2, 1, 3)]=(0.731993270734+0.347473946685j)*x_ref[0] + ((0.561472240334+0.246096105641j))*x_ref[1]
        arg[(2, 2, 2, 0)]=(0.348748493441-0.92380462857j)*x[0] + ((0.811378842335+0.149013965165j))*x[1]
        ref[(2, 2, 2, 0)]=(0.348748493441-0.92380462857j)*x_ref[0] + ((0.811378842335+0.149013965165j))*x_ref[1]
        arg[(2, 2, 2, 1)]=(-0.280660518557+0.892577187348j)*x[0] + ((0.801013751239+0.798435210112j))*x[1]
        ref[(2, 2, 2, 1)]=(-0.280660518557+0.892577187348j)*x_ref[0] + ((0.801013751239+0.798435210112j))*x_ref[1]
        arg[(2, 2, 2, 2)]=(-0.460719706527+0.927587337043j)*x[0] + ((0.458534893225-0.335556831893j))*x[1]
        ref[(2, 2, 2, 2)]=(-0.460719706527+0.927587337043j)*x_ref[0] + ((0.458534893225-0.335556831893j))*x_ref[1]
        arg[(2, 2, 2, 3)]=(-0.156479115209-0.236164004708j)*x[0] + ((-0.808898414235-0.751628485309j))*x[1]
        ref[(2, 2, 2, 3)]=(-0.156479115209-0.236164004708j)*x_ref[0] + ((-0.808898414235-0.751628485309j))*x_ref[1]
        arg[(2, 2, 3, 0)]=(-0.0731770046143+0.15444069855j)*x[0] + ((0.924041126287+0.479834908712j))*x[1]
        ref[(2, 2, 3, 0)]=(-0.0731770046143+0.15444069855j)*x_ref[0] + ((0.924041126287+0.479834908712j))*x_ref[1]
        arg[(2, 2, 3, 1)]=(0.758161487044-0.594641526428j)*x[0] + ((0.0890721658528-0.529305243802j))*x[1]
        ref[(2, 2, 3, 1)]=(0.758161487044-0.594641526428j)*x_ref[0] + ((0.0890721658528-0.529305243802j))*x_ref[1]
        arg[(2, 2, 3, 2)]=(-0.931955464664-0.547843767513j)*x[0] + ((0.254616010899+0.762205305109j))*x[1]
        ref[(2, 2, 3, 2)]=(-0.931955464664-0.547843767513j)*x_ref[0] + ((0.254616010899+0.762205305109j))*x_ref[1]
        arg[(2, 2, 3, 3)]=(0.238418738588+0.797653465701j)*x[0] + ((0.709876405878-0.0900054803859j))*x[1]
        ref[(2, 2, 3, 3)]=(0.238418738588+0.797653465701j)*x_ref[0] + ((0.709876405878-0.0900054803859j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(0.470642599779-0.0659889627355j)*x[2]
            ref[(0, 0, 0, 0)]+=(0.470642599779-0.0659889627355j)*x_ref[2]
            arg[(0, 0, 0, 1)]+=(-0.571887828428+0.844920938646j)*x[2]
            ref[(0, 0, 0, 1)]+=(-0.571887828428+0.844920938646j)*x_ref[2]
            arg[(0, 0, 0, 2)]+=(0.939567753148+0.0312213243843j)*x[2]
            ref[(0, 0, 0, 2)]+=(0.939567753148+0.0312213243843j)*x_ref[2]
            arg[(0, 0, 0, 3)]+=(-0.396775015264-0.530750182523j)*x[2]
            ref[(0, 0, 0, 3)]+=(-0.396775015264-0.530750182523j)*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.303946916594-0.0768252984491j)*x[2]
            ref[(0, 0, 1, 0)]+=(-0.303946916594-0.0768252984491j)*x_ref[2]
            arg[(0, 0, 1, 1)]+=(0.534994164019-0.156084045567j)*x[2]
            ref[(0, 0, 1, 1)]+=(0.534994164019-0.156084045567j)*x_ref[2]
            arg[(0, 0, 1, 2)]+=(-0.251722333739+0.794307212376j)*x[2]
            ref[(0, 0, 1, 2)]+=(-0.251722333739+0.794307212376j)*x_ref[2]
            arg[(0, 0, 1, 3)]+=(-0.05983759996+0.579098032013j)*x[2]
            ref[(0, 0, 1, 3)]+=(-0.05983759996+0.579098032013j)*x_ref[2]
            arg[(0, 0, 2, 0)]+=(0.82089014936+0.644024865359j)*x[2]
            ref[(0, 0, 2, 0)]+=(0.82089014936+0.644024865359j)*x_ref[2]
            arg[(0, 0, 2, 1)]+=(-0.0611864218439+0.51127677276j)*x[2]
            ref[(0, 0, 2, 1)]+=(-0.0611864218439+0.51127677276j)*x_ref[2]
            arg[(0, 0, 2, 2)]+=(0.871576310982-0.0353451062158j)*x[2]
            ref[(0, 0, 2, 2)]+=(0.871576310982-0.0353451062158j)*x_ref[2]
            arg[(0, 0, 2, 3)]+=(0.477731913848+0.582105376886j)*x[2]
            ref[(0, 0, 2, 3)]+=(0.477731913848+0.582105376886j)*x_ref[2]
            arg[(0, 0, 3, 0)]+=(-0.503315972548+0.869153746948j)*x[2]
            ref[(0, 0, 3, 0)]+=(-0.503315972548+0.869153746948j)*x_ref[2]
            arg[(0, 0, 3, 1)]+=(0.918727058328-0.190067142695j)*x[2]
            ref[(0, 0, 3, 1)]+=(0.918727058328-0.190067142695j)*x_ref[2]
            arg[(0, 0, 3, 2)]+=(0.906247649404+0.449557182549j)*x[2]
            ref[(0, 0, 3, 2)]+=(0.906247649404+0.449557182549j)*x_ref[2]
            arg[(0, 0, 3, 3)]+=(-0.943836046033+0.767515530667j)*x[2]
            ref[(0, 0, 3, 3)]+=(-0.943836046033+0.767515530667j)*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.860634680747+0.146848800239j)*x[2]
            ref[(0, 1, 0, 0)]+=(-0.860634680747+0.146848800239j)*x_ref[2]
            arg[(0, 1, 0, 1)]+=(-0.126844361951+0.215962785234j)*x[2]
            ref[(0, 1, 0, 1)]+=(-0.126844361951+0.215962785234j)*x_ref[2]
            arg[(0, 1, 0, 2)]+=(0.424917682775+0.920981086791j)*x[2]
            ref[(0, 1, 0, 2)]+=(0.424917682775+0.920981086791j)*x_ref[2]
            arg[(0, 1, 0, 3)]+=(-0.952687309351-0.694311438117j)*x[2]
            ref[(0, 1, 0, 3)]+=(-0.952687309351-0.694311438117j)*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.0994963640464-0.857954963399j)*x[2]
            ref[(0, 1, 1, 0)]+=(-0.0994963640464-0.857954963399j)*x_ref[2]
            arg[(0, 1, 1, 1)]+=(-0.278333070739-0.746440880404j)*x[2]
            ref[(0, 1, 1, 1)]+=(-0.278333070739-0.746440880404j)*x_ref[2]
            arg[(0, 1, 1, 2)]+=(0.0968309548139+0.743084064028j)*x[2]
            ref[(0, 1, 1, 2)]+=(0.0968309548139+0.743084064028j)*x_ref[2]
            arg[(0, 1, 1, 3)]+=(-0.652415415736+0.410558062845j)*x[2]
            ref[(0, 1, 1, 3)]+=(-0.652415415736+0.410558062845j)*x_ref[2]
            arg[(0, 1, 2, 0)]+=(-0.25996627249+0.251920103253j)*x[2]
            ref[(0, 1, 2, 0)]+=(-0.25996627249+0.251920103253j)*x_ref[2]
            arg[(0, 1, 2, 1)]+=(-0.925887225406+0.0325631166924j)*x[2]
            ref[(0, 1, 2, 1)]+=(-0.925887225406+0.0325631166924j)*x_ref[2]
            arg[(0, 1, 2, 2)]+=(0.949792291023+0.826372064499j)*x[2]
            ref[(0, 1, 2, 2)]+=(0.949792291023+0.826372064499j)*x_ref[2]
            arg[(0, 1, 2, 3)]+=(-0.517208316673-0.626658249836j)*x[2]
            ref[(0, 1, 2, 3)]+=(-0.517208316673-0.626658249836j)*x_ref[2]
            arg[(0, 1, 3, 0)]+=(-0.736740575588-0.970593307655j)*x[2]
            ref[(0, 1, 3, 0)]+=(-0.736740575588-0.970593307655j)*x_ref[2]
            arg[(0, 1, 3, 1)]+=(-0.195157740807+0.908561131604j)*x[2]
            ref[(0, 1, 3, 1)]+=(-0.195157740807+0.908561131604j)*x_ref[2]
            arg[(0, 1, 3, 2)]+=(0.331728629656-0.694875378672j)*x[2]
            ref[(0, 1, 3, 2)]+=(0.331728629656-0.694875378672j)*x_ref[2]
            arg[(0, 1, 3, 3)]+=(0.721061588711-0.930983642067j)*x[2]
            ref[(0, 1, 3, 3)]+=(0.721061588711-0.930983642067j)*x_ref[2]
            arg[(0, 2, 0, 0)]+=(0.0949018671343+0.310095294379j)*x[2]
            ref[(0, 2, 0, 0)]+=(0.0949018671343+0.310095294379j)*x_ref[2]
            arg[(0, 2, 0, 1)]+=(-0.0854217974543+0.234636943416j)*x[2]
            ref[(0, 2, 0, 1)]+=(-0.0854217974543+0.234636943416j)*x_ref[2]
            arg[(0, 2, 0, 2)]+=(0.145585515301+0.313192680718j)*x[2]
            ref[(0, 2, 0, 2)]+=(0.145585515301+0.313192680718j)*x_ref[2]
            arg[(0, 2, 0, 3)]+=(0.0143769538201+0.902570440876j)*x[2]
            ref[(0, 2, 0, 3)]+=(0.0143769538201+0.902570440876j)*x_ref[2]
            arg[(0, 2, 1, 0)]+=(0.0387093359588+0.868877971497j)*x[2]
            ref[(0, 2, 1, 0)]+=(0.0387093359588+0.868877971497j)*x_ref[2]
            arg[(0, 2, 1, 1)]+=(-0.469204912333+0.891177503428j)*x[2]
            ref[(0, 2, 1, 1)]+=(-0.469204912333+0.891177503428j)*x_ref[2]
            arg[(0, 2, 1, 2)]+=(0.267614710388-0.443086248665j)*x[2]
            ref[(0, 2, 1, 2)]+=(0.267614710388-0.443086248665j)*x_ref[2]
            arg[(0, 2, 1, 3)]+=(0.988377496413-0.19364716585j)*x[2]
            ref[(0, 2, 1, 3)]+=(0.988377496413-0.19364716585j)*x_ref[2]
            arg[(0, 2, 2, 0)]+=(0.132776443782+0.947644604589j)*x[2]
            ref[(0, 2, 2, 0)]+=(0.132776443782+0.947644604589j)*x_ref[2]
            arg[(0, 2, 2, 1)]+=(-0.890237809924-0.698537244542j)*x[2]
            ref[(0, 2, 2, 1)]+=(-0.890237809924-0.698537244542j)*x_ref[2]
            arg[(0, 2, 2, 2)]+=(-0.364432239398-0.392327428696j)*x[2]
            ref[(0, 2, 2, 2)]+=(-0.364432239398-0.392327428696j)*x_ref[2]
            arg[(0, 2, 2, 3)]+=(-0.954195528903+0.598846200262j)*x[2]
            ref[(0, 2, 2, 3)]+=(-0.954195528903+0.598846200262j)*x_ref[2]
            arg[(0, 2, 3, 0)]+=(-0.177366971864-0.312467358791j)*x[2]
            ref[(0, 2, 3, 0)]+=(-0.177366971864-0.312467358791j)*x_ref[2]
            arg[(0, 2, 3, 1)]+=(0.542471603591-0.5231881612j)*x[2]
            ref[(0, 2, 3, 1)]+=(0.542471603591-0.5231881612j)*x_ref[2]
            arg[(0, 2, 3, 2)]+=(0.0203038898932+0.421119435822j)*x[2]
            ref[(0, 2, 3, 2)]+=(0.0203038898932+0.421119435822j)*x_ref[2]
            arg[(0, 2, 3, 3)]+=(-0.595784960208+0.915194965013j)*x[2]
            ref[(0, 2, 3, 3)]+=(-0.595784960208+0.915194965013j)*x_ref[2]
            arg[(1, 0, 0, 0)]+=(0.222632270764-0.563467834128j)*x[2]
            ref[(1, 0, 0, 0)]+=(0.222632270764-0.563467834128j)*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.909494400291-0.742117771591j)*x[2]
            ref[(1, 0, 0, 1)]+=(0.909494400291-0.742117771591j)*x_ref[2]
            arg[(1, 0, 0, 2)]+=(-0.308431396216-0.938764300284j)*x[2]
            ref[(1, 0, 0, 2)]+=(-0.308431396216-0.938764300284j)*x_ref[2]
            arg[(1, 0, 0, 3)]+=(0.659276946085-0.139300621501j)*x[2]
            ref[(1, 0, 0, 3)]+=(0.659276946085-0.139300621501j)*x_ref[2]
            arg[(1, 0, 1, 0)]+=(-0.980909337027+0.262063039865j)*x[2]
            ref[(1, 0, 1, 0)]+=(-0.980909337027+0.262063039865j)*x_ref[2]
            arg[(1, 0, 1, 1)]+=(-0.882197826511+0.739784974972j)*x[2]
            ref[(1, 0, 1, 1)]+=(-0.882197826511+0.739784974972j)*x_ref[2]
            arg[(1, 0, 1, 2)]+=(-0.426919975697+0.79790971166j)*x[2]
            ref[(1, 0, 1, 2)]+=(-0.426919975697+0.79790971166j)*x_ref[2]
            arg[(1, 0, 1, 3)]+=(0.658756365173+0.64066929361j)*x[2]
            ref[(1, 0, 1, 3)]+=(0.658756365173+0.64066929361j)*x_ref[2]
            arg[(1, 0, 2, 0)]+=(0.0996215885307+0.938498609512j)*x[2]
            ref[(1, 0, 2, 0)]+=(0.0996215885307+0.938498609512j)*x_ref[2]
            arg[(1, 0, 2, 1)]+=(0.287976133213-0.719307877039j)*x[2]
            ref[(1, 0, 2, 1)]+=(0.287976133213-0.719307877039j)*x_ref[2]
            arg[(1, 0, 2, 2)]+=(-0.84043776452-0.0632307134j)*x[2]
            ref[(1, 0, 2, 2)]+=(-0.84043776452-0.0632307134j)*x_ref[2]
            arg[(1, 0, 2, 3)]+=(-0.828080578764+0.881264074127j)*x[2]
            ref[(1, 0, 2, 3)]+=(-0.828080578764+0.881264074127j)*x_ref[2]
            arg[(1, 0, 3, 0)]+=(-0.787546417849+0.224842996281j)*x[2]
            ref[(1, 0, 3, 0)]+=(-0.787546417849+0.224842996281j)*x_ref[2]
            arg[(1, 0, 3, 1)]+=(0.909495935982+0.466454072695j)*x[2]
            ref[(1, 0, 3, 1)]+=(0.909495935982+0.466454072695j)*x_ref[2]
            arg[(1, 0, 3, 2)]+=(0.238831859984-0.981159373348j)*x[2]
            ref[(1, 0, 3, 2)]+=(0.238831859984-0.981159373348j)*x_ref[2]
            arg[(1, 0, 3, 3)]+=(0.353540387447+0.16926251322j)*x[2]
            ref[(1, 0, 3, 3)]+=(0.353540387447+0.16926251322j)*x_ref[2]
            arg[(1, 1, 0, 0)]+=(-0.743621474829+0.6476504688j)*x[2]
            ref[(1, 1, 0, 0)]+=(-0.743621474829+0.6476504688j)*x_ref[2]
            arg[(1, 1, 0, 1)]+=(0.374105966749-0.245763062j)*x[2]
            ref[(1, 1, 0, 1)]+=(0.374105966749-0.245763062j)*x_ref[2]
            arg[(1, 1, 0, 2)]+=(0.962808165853+0.567518321707j)*x[2]
            ref[(1, 1, 0, 2)]+=(0.962808165853+0.567518321707j)*x_ref[2]
            arg[(1, 1, 0, 3)]+=(0.98258881665-0.744670210851j)*x[2]
            ref[(1, 1, 0, 3)]+=(0.98258881665-0.744670210851j)*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.332828568947-0.740172304206j)*x[2]
            ref[(1, 1, 1, 0)]+=(0.332828568947-0.740172304206j)*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.752318040224-0.24702881403j)*x[2]
            ref[(1, 1, 1, 1)]+=(-0.752318040224-0.24702881403j)*x_ref[2]
            arg[(1, 1, 1, 2)]+=(-0.701076837388-0.312398064557j)*x[2]
            ref[(1, 1, 1, 2)]+=(-0.701076837388-0.312398064557j)*x_ref[2]
            arg[(1, 1, 1, 3)]+=(0.0706338875798+0.714541206435j)*x[2]
            ref[(1, 1, 1, 3)]+=(0.0706338875798+0.714541206435j)*x_ref[2]
            arg[(1, 1, 2, 0)]+=(0.447102537981+0.850417833175j)*x[2]
            ref[(1, 1, 2, 0)]+=(0.447102537981+0.850417833175j)*x_ref[2]
            arg[(1, 1, 2, 1)]+=(0.385783654628+0.274503501708j)*x[2]
            ref[(1, 1, 2, 1)]+=(0.385783654628+0.274503501708j)*x_ref[2]
            arg[(1, 1, 2, 2)]+=(0.103750898168-0.992276606136j)*x[2]
            ref[(1, 1, 2, 2)]+=(0.103750898168-0.992276606136j)*x_ref[2]
            arg[(1, 1, 2, 3)]+=(0.00201527794632+0.22272648764j)*x[2]
            ref[(1, 1, 2, 3)]+=(0.00201527794632+0.22272648764j)*x_ref[2]
            arg[(1, 1, 3, 0)]+=(-0.48469951814+0.305104651582j)*x[2]
            ref[(1, 1, 3, 0)]+=(-0.48469951814+0.305104651582j)*x_ref[2]
            arg[(1, 1, 3, 1)]+=(-0.760786257454-0.719517774775j)*x[2]
            ref[(1, 1, 3, 1)]+=(-0.760786257454-0.719517774775j)*x_ref[2]
            arg[(1, 1, 3, 2)]+=(0.781851772208-0.490289050732j)*x[2]
            ref[(1, 1, 3, 2)]+=(0.781851772208-0.490289050732j)*x_ref[2]
            arg[(1, 1, 3, 3)]+=(0.664654350393+0.087911706329j)*x[2]
            ref[(1, 1, 3, 3)]+=(0.664654350393+0.087911706329j)*x_ref[2]
            arg[(1, 2, 0, 0)]+=(0.501586783326+0.614840202998j)*x[2]
            ref[(1, 2, 0, 0)]+=(0.501586783326+0.614840202998j)*x_ref[2]
            arg[(1, 2, 0, 1)]+=(-0.115126844046+0.596155797426j)*x[2]
            ref[(1, 2, 0, 1)]+=(-0.115126844046+0.596155797426j)*x_ref[2]
            arg[(1, 2, 0, 2)]+=(0.705673503555-0.700691917276j)*x[2]
            ref[(1, 2, 0, 2)]+=(0.705673503555-0.700691917276j)*x_ref[2]
            arg[(1, 2, 0, 3)]+=(-0.464704395203-0.942050807519j)*x[2]
            ref[(1, 2, 0, 3)]+=(-0.464704395203-0.942050807519j)*x_ref[2]
            arg[(1, 2, 1, 0)]+=(-0.513373155787-0.507486736444j)*x[2]
            ref[(1, 2, 1, 0)]+=(-0.513373155787-0.507486736444j)*x_ref[2]
            arg[(1, 2, 1, 1)]+=(-0.958869679942+0.269386914234j)*x[2]
            ref[(1, 2, 1, 1)]+=(-0.958869679942+0.269386914234j)*x_ref[2]
            arg[(1, 2, 1, 2)]+=(-0.0883313572046-0.198150300047j)*x[2]
            ref[(1, 2, 1, 2)]+=(-0.0883313572046-0.198150300047j)*x_ref[2]
            arg[(1, 2, 1, 3)]+=(0.555176097099-0.017987711124j)*x[2]
            ref[(1, 2, 1, 3)]+=(0.555176097099-0.017987711124j)*x_ref[2]
            arg[(1, 2, 2, 0)]+=(-0.708697465398+0.942784483886j)*x[2]
            ref[(1, 2, 2, 0)]+=(-0.708697465398+0.942784483886j)*x_ref[2]
            arg[(1, 2, 2, 1)]+=(-0.365139598127+0.452352667292j)*x[2]
            ref[(1, 2, 2, 1)]+=(-0.365139598127+0.452352667292j)*x_ref[2]
            arg[(1, 2, 2, 2)]+=(0.54893882003-0.904503847607j)*x[2]
            ref[(1, 2, 2, 2)]+=(0.54893882003-0.904503847607j)*x_ref[2]
            arg[(1, 2, 2, 3)]+=(0.737477625279+0.22682937281j)*x[2]
            ref[(1, 2, 2, 3)]+=(0.737477625279+0.22682937281j)*x_ref[2]
            arg[(1, 2, 3, 0)]+=(-0.869757993024-0.521641883872j)*x[2]
            ref[(1, 2, 3, 0)]+=(-0.869757993024-0.521641883872j)*x_ref[2]
            arg[(1, 2, 3, 1)]+=(-0.524285086952+0.812928461143j)*x[2]
            ref[(1, 2, 3, 1)]+=(-0.524285086952+0.812928461143j)*x_ref[2]
            arg[(1, 2, 3, 2)]+=(0.552379730657+0.100293619405j)*x[2]
            ref[(1, 2, 3, 2)]+=(0.552379730657+0.100293619405j)*x_ref[2]
            arg[(1, 2, 3, 3)]+=(-0.718095853524-0.66994935933j)*x[2]
            ref[(1, 2, 3, 3)]+=(-0.718095853524-0.66994935933j)*x_ref[2]
            arg[(2, 0, 0, 0)]+=(-0.866826670601-0.329334559252j)*x[2]
            ref[(2, 0, 0, 0)]+=(-0.866826670601-0.329334559252j)*x_ref[2]
            arg[(2, 0, 0, 1)]+=(-0.880290140914-0.42052742391j)*x[2]
            ref[(2, 0, 0, 1)]+=(-0.880290140914-0.42052742391j)*x_ref[2]
            arg[(2, 0, 0, 2)]+=(0.463412506784+0.944845733058j)*x[2]
            ref[(2, 0, 0, 2)]+=(0.463412506784+0.944845733058j)*x_ref[2]
            arg[(2, 0, 0, 3)]+=(-0.865309236354-0.541388707336j)*x[2]
            ref[(2, 0, 0, 3)]+=(-0.865309236354-0.541388707336j)*x_ref[2]
            arg[(2, 0, 1, 0)]+=(0.936893411439+0.791143311597j)*x[2]
            ref[(2, 0, 1, 0)]+=(0.936893411439+0.791143311597j)*x_ref[2]
            arg[(2, 0, 1, 1)]+=(0.103943038232-0.0744164048341j)*x[2]
            ref[(2, 0, 1, 1)]+=(0.103943038232-0.0744164048341j)*x_ref[2]
            arg[(2, 0, 1, 2)]+=(0.604832726428+0.225458179288j)*x[2]
            ref[(2, 0, 1, 2)]+=(0.604832726428+0.225458179288j)*x_ref[2]
            arg[(2, 0, 1, 3)]+=(-0.576819865951-0.0452254742107j)*x[2]
            ref[(2, 0, 1, 3)]+=(-0.576819865951-0.0452254742107j)*x_ref[2]
            arg[(2, 0, 2, 0)]+=(-0.289671376368+0.274945843729j)*x[2]
            ref[(2, 0, 2, 0)]+=(-0.289671376368+0.274945843729j)*x_ref[2]
            arg[(2, 0, 2, 1)]+=(-0.353595627734+0.515152756614j)*x[2]
            ref[(2, 0, 2, 1)]+=(-0.353595627734+0.515152756614j)*x_ref[2]
            arg[(2, 0, 2, 2)]+=(-0.224961765455-0.416350648193j)*x[2]
            ref[(2, 0, 2, 2)]+=(-0.224961765455-0.416350648193j)*x_ref[2]
            arg[(2, 0, 2, 3)]+=(-0.005712160621-0.0255149001203j)*x[2]
            ref[(2, 0, 2, 3)]+=(-0.005712160621-0.0255149001203j)*x_ref[2]
            arg[(2, 0, 3, 0)]+=(-0.671636671066+0.205439133064j)*x[2]
            ref[(2, 0, 3, 0)]+=(-0.671636671066+0.205439133064j)*x_ref[2]
            arg[(2, 0, 3, 1)]+=(0.967476704176+0.876372674045j)*x[2]
            ref[(2, 0, 3, 1)]+=(0.967476704176+0.876372674045j)*x_ref[2]
            arg[(2, 0, 3, 2)]+=(0.782632430003-0.845063132132j)*x[2]
            ref[(2, 0, 3, 2)]+=(0.782632430003-0.845063132132j)*x_ref[2]
            arg[(2, 0, 3, 3)]+=(0.945433896934-0.0178902631483j)*x[2]
            ref[(2, 0, 3, 3)]+=(0.945433896934-0.0178902631483j)*x_ref[2]
            arg[(2, 1, 0, 0)]+=(-0.584305069564+0.266698333609j)*x[2]
            ref[(2, 1, 0, 0)]+=(-0.584305069564+0.266698333609j)*x_ref[2]
            arg[(2, 1, 0, 1)]+=(-0.631504850342+0.74092587259j)*x[2]
            ref[(2, 1, 0, 1)]+=(-0.631504850342+0.74092587259j)*x_ref[2]
            arg[(2, 1, 0, 2)]+=(0.181687725207-0.2773039321j)*x[2]
            ref[(2, 1, 0, 2)]+=(0.181687725207-0.2773039321j)*x_ref[2]
            arg[(2, 1, 0, 3)]+=(-0.126153635475-0.892852809033j)*x[2]
            ref[(2, 1, 0, 3)]+=(-0.126153635475-0.892852809033j)*x_ref[2]
            arg[(2, 1, 1, 0)]+=(0.899519772134+0.791523904342j)*x[2]
            ref[(2, 1, 1, 0)]+=(0.899519772134+0.791523904342j)*x_ref[2]
            arg[(2, 1, 1, 1)]+=(-0.329504595315+0.762503292013j)*x[2]
            ref[(2, 1, 1, 1)]+=(-0.329504595315+0.762503292013j)*x_ref[2]
            arg[(2, 1, 1, 2)]+=(-0.576358606852+0.328946703388j)*x[2]
            ref[(2, 1, 1, 2)]+=(-0.576358606852+0.328946703388j)*x_ref[2]
            arg[(2, 1, 1, 3)]+=(-0.480622825248+0.74244278639j)*x[2]
            ref[(2, 1, 1, 3)]+=(-0.480622825248+0.74244278639j)*x_ref[2]
            arg[(2, 1, 2, 0)]+=(-0.654602956736-0.158372643238j)*x[2]
            ref[(2, 1, 2, 0)]+=(-0.654602956736-0.158372643238j)*x_ref[2]
            arg[(2, 1, 2, 1)]+=(0.788791425048-0.0484743096931j)*x[2]
            ref[(2, 1, 2, 1)]+=(0.788791425048-0.0484743096931j)*x_ref[2]
            arg[(2, 1, 2, 2)]+=(-0.155402716217-0.536334434154j)*x[2]
            ref[(2, 1, 2, 2)]+=(-0.155402716217-0.536334434154j)*x_ref[2]
            arg[(2, 1, 2, 3)]+=(-0.240936800921+0.0195977776438j)*x[2]
            ref[(2, 1, 2, 3)]+=(-0.240936800921+0.0195977776438j)*x_ref[2]
            arg[(2, 1, 3, 0)]+=(-0.172544858562-0.548972749649j)*x[2]
            ref[(2, 1, 3, 0)]+=(-0.172544858562-0.548972749649j)*x_ref[2]
            arg[(2, 1, 3, 1)]+=(-0.956491060803-0.148931984153j)*x[2]
            ref[(2, 1, 3, 1)]+=(-0.956491060803-0.148931984153j)*x_ref[2]
            arg[(2, 1, 3, 2)]+=(0.13062255458-0.778412192811j)*x[2]
            ref[(2, 1, 3, 2)]+=(0.13062255458-0.778412192811j)*x_ref[2]
            arg[(2, 1, 3, 3)]+=(0.824713641361+0.368551240628j)*x[2]
            ref[(2, 1, 3, 3)]+=(0.824713641361+0.368551240628j)*x_ref[2]
            arg[(2, 2, 0, 0)]+=(0.600798900105+0.406146410335j)*x[2]
            ref[(2, 2, 0, 0)]+=(0.600798900105+0.406146410335j)*x_ref[2]
            arg[(2, 2, 0, 1)]+=(-0.247219446697+0.0420449507j)*x[2]
            ref[(2, 2, 0, 1)]+=(-0.247219446697+0.0420449507j)*x_ref[2]
            arg[(2, 2, 0, 2)]+=(-0.813369723412+0.866662091775j)*x[2]
            ref[(2, 2, 0, 2)]+=(-0.813369723412+0.866662091775j)*x_ref[2]
            arg[(2, 2, 0, 3)]+=(0.155537379001+0.918260342754j)*x[2]
            ref[(2, 2, 0, 3)]+=(0.155537379001+0.918260342754j)*x_ref[2]
            arg[(2, 2, 1, 0)]+=(-0.195288462921-0.189366498194j)*x[2]
            ref[(2, 2, 1, 0)]+=(-0.195288462921-0.189366498194j)*x_ref[2]
            arg[(2, 2, 1, 1)]+=(-0.4708229981+0.0195626557346j)*x[2]
            ref[(2, 2, 1, 1)]+=(-0.4708229981+0.0195626557346j)*x_ref[2]
            arg[(2, 2, 1, 2)]+=(-0.359132119442-0.113155272402j)*x[2]
            ref[(2, 2, 1, 2)]+=(-0.359132119442-0.113155272402j)*x_ref[2]
            arg[(2, 2, 1, 3)]+=(-0.564012399465+0.927818693393j)*x[2]
            ref[(2, 2, 1, 3)]+=(-0.564012399465+0.927818693393j)*x_ref[2]
            arg[(2, 2, 2, 0)]+=(-0.661575133014+0.215663832156j)*x[2]
            ref[(2, 2, 2, 0)]+=(-0.661575133014+0.215663832156j)*x_ref[2]
            arg[(2, 2, 2, 1)]+=(-0.298110035679-0.298451768574j)*x[2]
            ref[(2, 2, 2, 1)]+=(-0.298110035679-0.298451768574j)*x_ref[2]
            arg[(2, 2, 2, 2)]+=(0.79247636569-0.0836147377465j)*x[2]
            ref[(2, 2, 2, 2)]+=(0.79247636569-0.0836147377465j)*x_ref[2]
            arg[(2, 2, 2, 3)]+=(0.606402430362-0.873313898169j)*x[2]
            ref[(2, 2, 2, 3)]+=(0.606402430362-0.873313898169j)*x_ref[2]
            arg[(2, 2, 3, 0)]+=(0.367822916683-0.768977690587j)*x[2]
            ref[(2, 2, 3, 0)]+=(0.367822916683-0.768977690587j)*x_ref[2]
            arg[(2, 2, 3, 1)]+=(-0.919596343336+0.167728399067j)*x[2]
            ref[(2, 2, 3, 1)]+=(-0.919596343336+0.167728399067j)*x_ref[2]
            arg[(2, 2, 3, 2)]+=(-0.324158394456-0.0345522278457j)*x[2]
            ref[(2, 2, 3, 2)]+=(-0.324158394456-0.0345522278457j)*x_ref[2]
            arg[(2, 2, 3, 3)]+=(-0.690979437362+0.341321118865j)*x[2]
            ref[(2, 2, 3, 3)]+=(-0.690979437362+0.341321118865j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3, 3, 4, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests interpolation of rank 0 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.795883870454+0.452628709205j)*x[0] + ((0.328137296043+0.115669612606j))*x[1]
        ref=(-0.795883870454+0.452628709205j)*x_ref[0] + ((0.328137296043+0.115669612606j))*x_ref[1]
        if dim==3:
            arg+=((0.595624998921-0.510298575735j))*x[2]
            ref+=((0.595624998921-0.510298575735j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests interpolation of rank 1 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,),w_ref)
        arg[(0,)]=(0.456612180793-0.444688880635j)*x[0] + ((-0.939204666686+0.110827276344j))*x[1]
        ref[(0,)]=(0.456612180793-0.444688880635j)*x_ref[0] + ((-0.939204666686+0.110827276344j))*x_ref[1]
        arg[(1,)]=(-0.958690337768-0.852206801482j)*x[0] + ((-0.00752454112142+0.330448082906j))*x[1]
        ref[(1,)]=(-0.958690337768-0.852206801482j)*x_ref[0] + ((-0.00752454112142+0.330448082906j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.0183028517792-0.0661922692878j)*x[2]
            ref[(0,)]+=(-0.0183028517792-0.0661922692878j)*x_ref[2]
            arg[(1,)]+=(-0.901969856681+0.437345813412j)*x[2]
            ref[(1,)]+=(-0.901969856681+0.437345813412j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests interpolation of rank 2 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3),w)
        ref = Data(0,(3, 3),w_ref)
        arg[(0, 0)]=(0.370685789206+0.37845139266j)*x[0] + ((0.327084918505-0.24750665582j))*x[1]
        ref[(0, 0)]=(0.370685789206+0.37845139266j)*x_ref[0] + ((0.327084918505-0.24750665582j))*x_ref[1]
        arg[(0, 1)]=(-0.278174341343+0.371481494743j)*x[0] + ((-0.143398547819+0.996836080842j))*x[1]
        ref[(0, 1)]=(-0.278174341343+0.371481494743j)*x_ref[0] + ((-0.143398547819+0.996836080842j))*x_ref[1]
        arg[(0, 2)]=(0.883687906965+0.449014438575j)*x[0] + ((-0.501750429249-0.446886685484j))*x[1]
        ref[(0, 2)]=(0.883687906965+0.449014438575j)*x_ref[0] + ((-0.501750429249-0.446886685484j))*x_ref[1]
        arg[(1, 0)]=(-0.828362528192-0.495066732496j)*x[0] + ((0.244641406808+0.196154122795j))*x[1]
        ref[(1, 0)]=(-0.828362528192-0.495066732496j)*x_ref[0] + ((0.244641406808+0.196154122795j))*x_ref[1]
        arg[(1, 1)]=(-0.141312019783+0.513754368965j)*x[0] + ((0.392387852823-0.203658898097j))*x[1]
        ref[(1, 1)]=(-0.141312019783+0.513754368965j)*x_ref[0] + ((0.392387852823-0.203658898097j))*x_ref[1]
        arg[(1, 2)]=(-0.882723824934-0.410675076709j)*x[0] + ((-0.982583526906+0.235964866764j))*x[1]
        ref[(1, 2)]=(-0.882723824934-0.410675076709j)*x_ref[0] + ((-0.982583526906+0.235964866764j))*x_ref[1]
        arg[(2, 0)]=(-0.225180635869+0.861936854971j)*x[0] + ((0.517543453491+0.383939255663j))*x[1]
        ref[(2, 0)]=(-0.225180635869+0.861936854971j)*x_ref[0] + ((0.517543453491+0.383939255663j))*x_ref[1]
        arg[(2, 1)]=(0.807374582257-0.97768570388j)*x[0] + ((0.361761213864-0.993703079041j))*x[1]
        ref[(2, 1)]=(0.807374582257-0.97768570388j)*x_ref[0] + ((0.361761213864-0.993703079041j))*x_ref[1]
        arg[(2, 2)]=(-0.367089989715+0.665146592781j)*x[0] + ((0.743060787819+0.312073093982j))*x[1]
        ref[(2, 2)]=(-0.367089989715+0.665146592781j)*x_ref[0] + ((0.743060787819+0.312073093982j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(0.115797500607+0.526693885781j)*x[2]
            ref[(0, 0)]+=(0.115797500607+0.526693885781j)*x_ref[2]
            arg[(0, 1)]+=(-0.771143366695+0.456391541418j)*x[2]
            ref[(0, 1)]+=(-0.771143366695+0.456391541418j)*x_ref[2]
            arg[(0, 2)]+=(-0.0364636557826+0.841392987704j)*x[2]
            ref[(0, 2)]+=(-0.0364636557826+0.841392987704j)*x_ref[2]
            arg[(1, 0)]+=(0.322742379622-0.64438148516j)*x[2]
            ref[(1, 0)]+=(0.322742379622-0.64438148516j)*x_ref[2]
            arg[(1, 1)]+=(0.4065000133-0.797538461014j)*x[2]
            ref[(1, 1)]+=(0.4065000133-0.797538461014j)*x_ref[2]
            arg[(1, 2)]+=(0.944928964143-0.561239709477j)*x[2]
            ref[(1, 2)]+=(0.944928964143-0.561239709477j)*x_ref[2]
            arg[(2, 0)]+=(0.520038663207+0.195517531274j)*x[2]
            ref[(2, 0)]+=(0.520038663207+0.195517531274j)*x_ref[2]
            arg[(2, 1)]+=(0.290825285266-0.954471067848j)*x[2]
            ref[(2, 1)]+=(0.290825285266-0.954471067848j)*x_ref[2]
            arg[(2, 2)]+=(0.134768772744+0.914672898339j)*x[2]
            ref[(2, 2)]+=(0.134768772744+0.914672898339j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests interpolation of rank 3 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4, 3),w)
        ref = Data(0,(2, 4, 3),w_ref)
        arg[(0, 0, 0)]=(-0.800885000513-0.723467008889j)*x[0] + ((0.63001606392+0.140240455371j))*x[1]
        ref[(0, 0, 0)]=(-0.800885000513-0.723467008889j)*x_ref[0] + ((0.63001606392+0.140240455371j))*x_ref[1]
        arg[(0, 0, 1)]=(-0.749357501776+0.0132566546659j)*x[0] + ((-0.260462033196-0.837875392457j))*x[1]
        ref[(0, 0, 1)]=(-0.749357501776+0.0132566546659j)*x_ref[0] + ((-0.260462033196-0.837875392457j))*x_ref[1]
        arg[(0, 0, 2)]=(-0.102521511045-0.64759347722j)*x[0] + ((-0.279286003437+0.471559727983j))*x[1]
        ref[(0, 0, 2)]=(-0.102521511045-0.64759347722j)*x_ref[0] + ((-0.279286003437+0.471559727983j))*x_ref[1]
        arg[(0, 1, 0)]=(0.891187643916+0.783891509462j)*x[0] + ((-0.890488819635+0.473257631096j))*x[1]
        ref[(0, 1, 0)]=(0.891187643916+0.783891509462j)*x_ref[0] + ((-0.890488819635+0.473257631096j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.525781136808+0.00984582818403j)*x[0] + ((-0.072356511506+0.404754063855j))*x[1]
        ref[(0, 1, 1)]=(-0.525781136808+0.00984582818403j)*x_ref[0] + ((-0.072356511506+0.404754063855j))*x_ref[1]
        arg[(0, 1, 2)]=(0.180519179664-0.251260642191j)*x[0] + ((0.237551366383+0.139892863665j))*x[1]
        ref[(0, 1, 2)]=(0.180519179664-0.251260642191j)*x_ref[0] + ((0.237551366383+0.139892863665j))*x_ref[1]
        arg[(0, 2, 0)]=(-0.459328562632+0.135923416067j)*x[0] + ((0.768496402282-0.516999571456j))*x[1]
        ref[(0, 2, 0)]=(-0.459328562632+0.135923416067j)*x_ref[0] + ((0.768496402282-0.516999571456j))*x_ref[1]
        arg[(0, 2, 1)]=(0.511386519054+0.742969361662j)*x[0] + ((-0.400480410784-0.156560045139j))*x[1]
        ref[(0, 2, 1)]=(0.511386519054+0.742969361662j)*x_ref[0] + ((-0.400480410784-0.156560045139j))*x_ref[1]
        arg[(0, 2, 2)]=(-0.320739877027-0.927002694343j)*x[0] + ((0.308253316432+0.513834338062j))*x[1]
        ref[(0, 2, 2)]=(-0.320739877027-0.927002694343j)*x_ref[0] + ((0.308253316432+0.513834338062j))*x_ref[1]
        arg[(0, 3, 0)]=(0.194130105552+0.971550743664j)*x[0] + ((0.496913952252+0.602685198747j))*x[1]
        ref[(0, 3, 0)]=(0.194130105552+0.971550743664j)*x_ref[0] + ((0.496913952252+0.602685198747j))*x_ref[1]
        arg[(0, 3, 1)]=(0.0943485394212+0.0721394722683j)*x[0] + ((0.772591063618-0.393838984291j))*x[1]
        ref[(0, 3, 1)]=(0.0943485394212+0.0721394722683j)*x_ref[0] + ((0.772591063618-0.393838984291j))*x_ref[1]
        arg[(0, 3, 2)]=(0.543817013456+0.614275919352j)*x[0] + ((0.0920277943552+0.315104677922j))*x[1]
        ref[(0, 3, 2)]=(0.543817013456+0.614275919352j)*x_ref[0] + ((0.0920277943552+0.315104677922j))*x_ref[1]
        arg[(1, 0, 0)]=(-0.626949482653-0.676481002891j)*x[0] + ((0.337318644333+0.278278437488j))*x[1]
        ref[(1, 0, 0)]=(-0.626949482653-0.676481002891j)*x_ref[0] + ((0.337318644333+0.278278437488j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.288525082679-0.787037682491j)*x[0] + ((-0.541370508022+0.982049660904j))*x[1]
        ref[(1, 0, 1)]=(-0.288525082679-0.787037682491j)*x_ref[0] + ((-0.541370508022+0.982049660904j))*x_ref[1]
        arg[(1, 0, 2)]=(0.582142256218+0.0599773725086j)*x[0] + ((0.73051792889-0.745498073563j))*x[1]
        ref[(1, 0, 2)]=(0.582142256218+0.0599773725086j)*x_ref[0] + ((0.73051792889-0.745498073563j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.641819606018+0.359942545368j)*x[0] + ((-0.456546662904-0.886637380399j))*x[1]
        ref[(1, 1, 0)]=(-0.641819606018+0.359942545368j)*x_ref[0] + ((-0.456546662904-0.886637380399j))*x_ref[1]
        arg[(1, 1, 1)]=(-0.456001881901+0.533244950906j)*x[0] + ((-0.93372951835-0.0671452303059j))*x[1]
        ref[(1, 1, 1)]=(-0.456001881901+0.533244950906j)*x_ref[0] + ((-0.93372951835-0.0671452303059j))*x_ref[1]
        arg[(1, 1, 2)]=(-0.393594373029-0.346842777665j)*x[0] + ((-0.848745797795-0.106879678186j))*x[1]
        ref[(1, 1, 2)]=(-0.393594373029-0.346842777665j)*x_ref[0] + ((-0.848745797795-0.106879678186j))*x_ref[1]
        arg[(1, 2, 0)]=(0.294457504965-0.780538561582j)*x[0] + ((-0.487438042537-0.894464136075j))*x[1]
        ref[(1, 2, 0)]=(0.294457504965-0.780538561582j)*x_ref[0] + ((-0.487438042537-0.894464136075j))*x_ref[1]
        arg[(1, 2, 1)]=(0.255386391587-0.183741948147j)*x[0] + ((-0.858623029843+0.86663645082j))*x[1]
        ref[(1, 2, 1)]=(0.255386391587-0.183741948147j)*x_ref[0] + ((-0.858623029843+0.86663645082j))*x_ref[1]
        arg[(1, 2, 2)]=(0.514739780265-0.973201099651j)*x[0] + ((-0.929944118712+0.388193907912j))*x[1]
        ref[(1, 2, 2)]=(0.514739780265-0.973201099651j)*x_ref[0] + ((-0.929944118712+0.388193907912j))*x_ref[1]
        arg[(1, 3, 0)]=(-0.147519825777+0.063234437118j)*x[0] + ((0.59239279603+0.330635480214j))*x[1]
        ref[(1, 3, 0)]=(-0.147519825777+0.063234437118j)*x_ref[0] + ((0.59239279603+0.330635480214j))*x_ref[1]
        arg[(1, 3, 1)]=(0.95698418029+0.835721396574j)*x[0] + ((0.647845690304+0.842246543389j))*x[1]
        ref[(1, 3, 1)]=(0.95698418029+0.835721396574j)*x_ref[0] + ((0.647845690304+0.842246543389j))*x_ref[1]
        arg[(1, 3, 2)]=(0.658447279545+0.447728602371j)*x[0] + ((0.599737672218-0.295980198243j))*x[1]
        ref[(1, 3, 2)]=(0.658447279545+0.447728602371j)*x_ref[0] + ((0.599737672218-0.295980198243j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.602322860437+0.569699583898j)*x[2]
            ref[(0, 0, 0)]+=(-0.602322860437+0.569699583898j)*x_ref[2]
            arg[(0, 0, 1)]+=(0.595044445335-0.315246646735j)*x[2]
            ref[(0, 0, 1)]+=(0.595044445335-0.315246646735j)*x_ref[2]
            arg[(0, 0, 2)]+=(-0.607142697527-0.958397194717j)*x[2]
            ref[(0, 0, 2)]+=(-0.607142697527-0.958397194717j)*x_ref[2]
            arg[(0, 1, 0)]+=(0.29514650053+0.514321906554j)*x[2]
            ref[(0, 1, 0)]+=(0.29514650053+0.514321906554j)*x_ref[2]
            arg[(0, 1, 1)]+=(0.358727103733-0.305163963167j)*x[2]
            ref[(0, 1, 1)]+=(0.358727103733-0.305163963167j)*x_ref[2]
            arg[(0, 1, 2)]+=(0.131967612556-0.401870306666j)*x[2]
            ref[(0, 1, 2)]+=(0.131967612556-0.401870306666j)*x_ref[2]
            arg[(0, 2, 0)]+=(0.0949277519034-0.121174117544j)*x[2]
            ref[(0, 2, 0)]+=(0.0949277519034-0.121174117544j)*x_ref[2]
            arg[(0, 2, 1)]+=(0.361720648541+0.86494341954j)*x[2]
            ref[(0, 2, 1)]+=(0.361720648541+0.86494341954j)*x_ref[2]
            arg[(0, 2, 2)]+=(0.710023861657+0.449150603433j)*x[2]
            ref[(0, 2, 2)]+=(0.710023861657+0.449150603433j)*x_ref[2]
            arg[(0, 3, 0)]+=(-0.259456663319-0.944134095986j)*x[2]
            ref[(0, 3, 0)]+=(-0.259456663319-0.944134095986j)*x_ref[2]
            arg[(0, 3, 1)]+=(-0.0684534629832+0.673846633658j)*x[2]
            ref[(0, 3, 1)]+=(-0.0684534629832+0.673846633658j)*x_ref[2]
            arg[(0, 3, 2)]+=(0.548594650945+0.603667094716j)*x[2]
            ref[(0, 3, 2)]+=(0.548594650945+0.603667094716j)*x_ref[2]
            arg[(1, 0, 0)]+=(0.851918913807-0.871339130352j)*x[2]
            ref[(1, 0, 0)]+=(0.851918913807-0.871339130352j)*x_ref[2]
            arg[(1, 0, 1)]+=(-0.348234252973-0.514311255915j)*x[2]
            ref[(1, 0, 1)]+=(-0.348234252973-0.514311255915j)*x_ref[2]
            arg[(1, 0, 2)]+=(0.91695157493+0.861921442561j)*x[2]
            ref[(1, 0, 2)]+=(0.91695157493+0.861921442561j)*x_ref[2]
            arg[(1, 1, 0)]+=(-0.3702100668+0.811341867767j)*x[2]
            ref[(1, 1, 0)]+=(-0.3702100668+0.811341867767j)*x_ref[2]
            arg[(1, 1, 1)]+=(-0.208023821436-0.216686525369j)*x[2]
            ref[(1, 1, 1)]+=(-0.208023821436-0.216686525369j)*x_ref[2]
            arg[(1, 1, 2)]+=(0.800827466366-0.396180395779j)*x[2]
            ref[(1, 1, 2)]+=(0.800827466366-0.396180395779j)*x_ref[2]
            arg[(1, 2, 0)]+=(0.0594460359847-0.528280681813j)*x[2]
            ref[(1, 2, 0)]+=(0.0594460359847-0.528280681813j)*x_ref[2]
            arg[(1, 2, 1)]+=(-0.548580549417+0.0451163129415j)*x[2]
            ref[(1, 2, 1)]+=(-0.548580549417+0.0451163129415j)*x_ref[2]
            arg[(1, 2, 2)]+=(0.97585679895+0.906931599457j)*x[2]
            ref[(1, 2, 2)]+=(0.97585679895+0.906931599457j)*x_ref[2]
            arg[(1, 3, 0)]+=(-0.94014547208-0.350121664412j)*x[2]
            ref[(1, 3, 0)]+=(-0.94014547208-0.350121664412j)*x_ref[2]
            arg[(1, 3, 1)]+=(-0.468947055145+0.188938751084j)*x[2]
            ref[(1, 3, 1)]+=(-0.468947055145+0.188938751084j)*x_ref[2]
            arg[(1, 3, 2)]+=(0.340177268025-0.517085614531j)*x[2]
            ref[(1, 3, 2)]+=(0.340177268025-0.517085614531j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 4, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_ReducedContinuousFunction_rank4(self):
        """
        tests interpolation of rank 4 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2, 3, 2),w)
        ref = Data(0,(4, 2, 3, 2),w_ref)
        arg[(0, 0, 0, 0)]=(0.560233793409-0.347435293874j)*x[0] + ((-0.738586297773+0.48299530183j))*x[1]
        ref[(0, 0, 0, 0)]=(0.560233793409-0.347435293874j)*x_ref[0] + ((-0.738586297773+0.48299530183j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.347689902753+0.844511464424j)*x[0] + ((0.637913619591-0.838057257811j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.347689902753+0.844511464424j)*x_ref[0] + ((0.637913619591-0.838057257811j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(-0.633953500656-0.135054923747j)*x[0] + ((-0.3549152977+0.731492774206j))*x[1]
        ref[(0, 0, 1, 0)]=(-0.633953500656-0.135054923747j)*x_ref[0] + ((-0.3549152977+0.731492774206j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.535203449113-0.674494553773j)*x[0] + ((0.738217558667-0.653562030005j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.535203449113-0.674494553773j)*x_ref[0] + ((0.738217558667-0.653562030005j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(0.942465830139+0.00170581061263j)*x[0] + ((0.0759383593326-0.616989278511j))*x[1]
        ref[(0, 0, 2, 0)]=(0.942465830139+0.00170581061263j)*x_ref[0] + ((0.0759383593326-0.616989278511j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(-0.60270307062-0.180903560333j)*x[0] + ((-0.311169826178-0.594489636895j))*x[1]
        ref[(0, 0, 2, 1)]=(-0.60270307062-0.180903560333j)*x_ref[0] + ((-0.311169826178-0.594489636895j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.650685412819+0.727198710504j)*x[0] + ((-0.666015702862+0.314144124628j))*x[1]
        ref[(0, 1, 0, 0)]=(0.650685412819+0.727198710504j)*x_ref[0] + ((-0.666015702862+0.314144124628j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(0.404788647539-0.190429635652j)*x[0] + ((-0.688681828202-0.540279134582j))*x[1]
        ref[(0, 1, 0, 1)]=(0.404788647539-0.190429635652j)*x_ref[0] + ((-0.688681828202-0.540279134582j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.404655814324-0.828356448668j)*x[0] + ((-0.216502268406+0.514470453286j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.404655814324-0.828356448668j)*x_ref[0] + ((-0.216502268406+0.514470453286j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(0.94118336971-0.241755758914j)*x[0] + ((0.469690022388+0.711978231758j))*x[1]
        ref[(0, 1, 1, 1)]=(0.94118336971-0.241755758914j)*x_ref[0] + ((0.469690022388+0.711978231758j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(0.542627683703+0.819126126477j)*x[0] + ((0.354974736285+0.0768657137585j))*x[1]
        ref[(0, 1, 2, 0)]=(0.542627683703+0.819126126477j)*x_ref[0] + ((0.354974736285+0.0768657137585j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(-0.591256868537-0.81651487962j)*x[0] + ((0.701160314017-0.437053521797j))*x[1]
        ref[(0, 1, 2, 1)]=(-0.591256868537-0.81651487962j)*x_ref[0] + ((0.701160314017-0.437053521797j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(-0.767176149659-0.141606997871j)*x[0] + ((-0.0774018056996-0.96234045492j))*x[1]
        ref[(1, 0, 0, 0)]=(-0.767176149659-0.141606997871j)*x_ref[0] + ((-0.0774018056996-0.96234045492j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(-0.687602199463-0.606191991415j)*x[0] + ((-0.907201329003+0.891790149193j))*x[1]
        ref[(1, 0, 0, 1)]=(-0.687602199463-0.606191991415j)*x_ref[0] + ((-0.907201329003+0.891790149193j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(0.647906505901+0.266237053688j)*x[0] + ((-0.337449578635-0.483545689972j))*x[1]
        ref[(1, 0, 1, 0)]=(0.647906505901+0.266237053688j)*x_ref[0] + ((-0.337449578635-0.483545689972j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(0.945071427607+0.51940179808j)*x[0] + ((-0.0138885727184-0.947990673409j))*x[1]
        ref[(1, 0, 1, 1)]=(0.945071427607+0.51940179808j)*x_ref[0] + ((-0.0138885727184-0.947990673409j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(-0.665532497029+0.15976735083j)*x[0] + ((0.400808809832-0.321836053992j))*x[1]
        ref[(1, 0, 2, 0)]=(-0.665532497029+0.15976735083j)*x_ref[0] + ((0.400808809832-0.321836053992j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(-0.0709409426766-0.257172756436j)*x[0] + ((0.752009870138-0.491410175672j))*x[1]
        ref[(1, 0, 2, 1)]=(-0.0709409426766-0.257172756436j)*x_ref[0] + ((0.752009870138-0.491410175672j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(-0.85846339039-0.0681910557308j)*x[0] + ((-0.471159148254+0.2933280627j))*x[1]
        ref[(1, 1, 0, 0)]=(-0.85846339039-0.0681910557308j)*x_ref[0] + ((-0.471159148254+0.2933280627j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(-0.195507775938+0.640722855402j)*x[0] + ((0.236602852526+0.610931477707j))*x[1]
        ref[(1, 1, 0, 1)]=(-0.195507775938+0.640722855402j)*x_ref[0] + ((0.236602852526+0.610931477707j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.0594250120379+0.962153544837j)*x[0] + ((0.436703067978-0.390255254816j))*x[1]
        ref[(1, 1, 1, 0)]=(0.0594250120379+0.962153544837j)*x_ref[0] + ((0.436703067978-0.390255254816j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(0.912156458215-0.166981400412j)*x[0] + ((-0.577282069472-0.0398892772684j))*x[1]
        ref[(1, 1, 1, 1)]=(0.912156458215-0.166981400412j)*x_ref[0] + ((-0.577282069472-0.0398892772684j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(0.763099902799-0.712722745773j)*x[0] + ((0.120451926665-0.448119725071j))*x[1]
        ref[(1, 1, 2, 0)]=(0.763099902799-0.712722745773j)*x_ref[0] + ((0.120451926665-0.448119725071j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(-0.979498081379+0.6882626998j)*x[0] + ((0.389371527692-0.0239423675216j))*x[1]
        ref[(1, 1, 2, 1)]=(-0.979498081379+0.6882626998j)*x_ref[0] + ((0.389371527692-0.0239423675216j))*x_ref[1]
        arg[(2, 0, 0, 0)]=(-0.223302705079+0.0464655434707j)*x[0] + ((0.522614752849-0.231259834696j))*x[1]
        ref[(2, 0, 0, 0)]=(-0.223302705079+0.0464655434707j)*x_ref[0] + ((0.522614752849-0.231259834696j))*x_ref[1]
        arg[(2, 0, 0, 1)]=(0.822041628409+0.77257991287j)*x[0] + ((-0.750002614071-0.827180686633j))*x[1]
        ref[(2, 0, 0, 1)]=(0.822041628409+0.77257991287j)*x_ref[0] + ((-0.750002614071-0.827180686633j))*x_ref[1]
        arg[(2, 0, 1, 0)]=(-0.323364625636+0.953559178139j)*x[0] + ((-0.709017479755-0.44168022443j))*x[1]
        ref[(2, 0, 1, 0)]=(-0.323364625636+0.953559178139j)*x_ref[0] + ((-0.709017479755-0.44168022443j))*x_ref[1]
        arg[(2, 0, 1, 1)]=(-0.353101994466+0.366021504628j)*x[0] + ((-0.777732787184+0.607382951334j))*x[1]
        ref[(2, 0, 1, 1)]=(-0.353101994466+0.366021504628j)*x_ref[0] + ((-0.777732787184+0.607382951334j))*x_ref[1]
        arg[(2, 0, 2, 0)]=(0.917392340946-0.916199560261j)*x[0] + ((0.423957785087+0.708489667334j))*x[1]
        ref[(2, 0, 2, 0)]=(0.917392340946-0.916199560261j)*x_ref[0] + ((0.423957785087+0.708489667334j))*x_ref[1]
        arg[(2, 0, 2, 1)]=(0.704240199391+0.305173030818j)*x[0] + ((0.931192842428+0.550955767082j))*x[1]
        ref[(2, 0, 2, 1)]=(0.704240199391+0.305173030818j)*x_ref[0] + ((0.931192842428+0.550955767082j))*x_ref[1]
        arg[(2, 1, 0, 0)]=(0.915238951479+0.4726519275j)*x[0] + ((-0.668111065291+0.918734731952j))*x[1]
        ref[(2, 1, 0, 0)]=(0.915238951479+0.4726519275j)*x_ref[0] + ((-0.668111065291+0.918734731952j))*x_ref[1]
        arg[(2, 1, 0, 1)]=(0.457391904691-0.789696324265j)*x[0] + ((-0.348344320113-0.785572881437j))*x[1]
        ref[(2, 1, 0, 1)]=(0.457391904691-0.789696324265j)*x_ref[0] + ((-0.348344320113-0.785572881437j))*x_ref[1]
        arg[(2, 1, 1, 0)]=(-0.696741458553-0.525704315942j)*x[0] + ((0.673348780674-0.580887830265j))*x[1]
        ref[(2, 1, 1, 0)]=(-0.696741458553-0.525704315942j)*x_ref[0] + ((0.673348780674-0.580887830265j))*x_ref[1]
        arg[(2, 1, 1, 1)]=(0.678068187523+0.802065267019j)*x[0] + ((-0.215006361474+0.74082903649j))*x[1]
        ref[(2, 1, 1, 1)]=(0.678068187523+0.802065267019j)*x_ref[0] + ((-0.215006361474+0.74082903649j))*x_ref[1]
        arg[(2, 1, 2, 0)]=(-0.0663838070778+0.557161579478j)*x[0] + ((0.966935153883+0.827231931333j))*x[1]
        ref[(2, 1, 2, 0)]=(-0.0663838070778+0.557161579478j)*x_ref[0] + ((0.966935153883+0.827231931333j))*x_ref[1]
        arg[(2, 1, 2, 1)]=(-0.528170207938+0.715267459948j)*x[0] + ((-0.919028219914-0.839105021728j))*x[1]
        ref[(2, 1, 2, 1)]=(-0.528170207938+0.715267459948j)*x_ref[0] + ((-0.919028219914-0.839105021728j))*x_ref[1]
        arg[(3, 0, 0, 0)]=(0.216589934028-0.270573094081j)*x[0] + ((0.795910921072+0.238373215056j))*x[1]
        ref[(3, 0, 0, 0)]=(0.216589934028-0.270573094081j)*x_ref[0] + ((0.795910921072+0.238373215056j))*x_ref[1]
        arg[(3, 0, 0, 1)]=(-0.649309538731+0.303773394579j)*x[0] + ((0.533497673384-0.372224174803j))*x[1]
        ref[(3, 0, 0, 1)]=(-0.649309538731+0.303773394579j)*x_ref[0] + ((0.533497673384-0.372224174803j))*x_ref[1]
        arg[(3, 0, 1, 0)]=(0.9398963185+0.861587594762j)*x[0] + ((0.317766453043-0.344106846124j))*x[1]
        ref[(3, 0, 1, 0)]=(0.9398963185+0.861587594762j)*x_ref[0] + ((0.317766453043-0.344106846124j))*x_ref[1]
        arg[(3, 0, 1, 1)]=(-0.967202679609-0.336386407542j)*x[0] + ((0.0105355981404-0.969173346677j))*x[1]
        ref[(3, 0, 1, 1)]=(-0.967202679609-0.336386407542j)*x_ref[0] + ((0.0105355981404-0.969173346677j))*x_ref[1]
        arg[(3, 0, 2, 0)]=(-0.0955853159691+0.756602373974j)*x[0] + ((-0.189460895151-0.871095076823j))*x[1]
        ref[(3, 0, 2, 0)]=(-0.0955853159691+0.756602373974j)*x_ref[0] + ((-0.189460895151-0.871095076823j))*x_ref[1]
        arg[(3, 0, 2, 1)]=(-0.844539666978-0.516168496716j)*x[0] + ((-0.325544754153+0.998935732416j))*x[1]
        ref[(3, 0, 2, 1)]=(-0.844539666978-0.516168496716j)*x_ref[0] + ((-0.325544754153+0.998935732416j))*x_ref[1]
        arg[(3, 1, 0, 0)]=(0.0955394280374+0.663423843183j)*x[0] + ((-0.300415577295-0.883432072144j))*x[1]
        ref[(3, 1, 0, 0)]=(0.0955394280374+0.663423843183j)*x_ref[0] + ((-0.300415577295-0.883432072144j))*x_ref[1]
        arg[(3, 1, 0, 1)]=(0.6413590348-0.0762084386113j)*x[0] + ((-0.131962739342+0.194569092544j))*x[1]
        ref[(3, 1, 0, 1)]=(0.6413590348-0.0762084386113j)*x_ref[0] + ((-0.131962739342+0.194569092544j))*x_ref[1]
        arg[(3, 1, 1, 0)]=(-0.585267760975+0.317943877729j)*x[0] + ((-0.622663134336+0.663720673501j))*x[1]
        ref[(3, 1, 1, 0)]=(-0.585267760975+0.317943877729j)*x_ref[0] + ((-0.622663134336+0.663720673501j))*x_ref[1]
        arg[(3, 1, 1, 1)]=(0.693598923314+0.418310083407j)*x[0] + ((-0.83561511298+0.107573095258j))*x[1]
        ref[(3, 1, 1, 1)]=(0.693598923314+0.418310083407j)*x_ref[0] + ((-0.83561511298+0.107573095258j))*x_ref[1]
        arg[(3, 1, 2, 0)]=(-0.475128013356-0.624179896002j)*x[0] + ((0.985032233287-0.987814106592j))*x[1]
        ref[(3, 1, 2, 0)]=(-0.475128013356-0.624179896002j)*x_ref[0] + ((0.985032233287-0.987814106592j))*x_ref[1]
        arg[(3, 1, 2, 1)]=(0.049073444857-0.680132897642j)*x[0] + ((0.386125491977-0.409665810704j))*x[1]
        ref[(3, 1, 2, 1)]=(0.049073444857-0.680132897642j)*x_ref[0] + ((0.386125491977-0.409665810704j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.453444706697-0.673603299714j)*x[2]
            ref[(0, 0, 0, 0)]+=(-0.453444706697-0.673603299714j)*x_ref[2]
            arg[(0, 0, 0, 1)]+=(-0.0878578917045+0.839505238049j)*x[2]
            ref[(0, 0, 0, 1)]+=(-0.0878578917045+0.839505238049j)*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.881608240786-0.0453393971996j)*x[2]
            ref[(0, 0, 1, 0)]+=(-0.881608240786-0.0453393971996j)*x_ref[2]
            arg[(0, 0, 1, 1)]+=(0.782992328966+0.0547413497002j)*x[2]
            ref[(0, 0, 1, 1)]+=(0.782992328966+0.0547413497002j)*x_ref[2]
            arg[(0, 0, 2, 0)]+=(-0.823607126718+0.825114494573j)*x[2]
            ref[(0, 0, 2, 0)]+=(-0.823607126718+0.825114494573j)*x_ref[2]
            arg[(0, 0, 2, 1)]+=(-0.225702122752+0.291336071004j)*x[2]
            ref[(0, 0, 2, 1)]+=(-0.225702122752+0.291336071004j)*x_ref[2]
            arg[(0, 1, 0, 0)]+=(0.710268884237-0.333446280132j)*x[2]
            ref[(0, 1, 0, 0)]+=(0.710268884237-0.333446280132j)*x_ref[2]
            arg[(0, 1, 0, 1)]+=(0.331589597829+0.262792468498j)*x[2]
            ref[(0, 1, 0, 1)]+=(0.331589597829+0.262792468498j)*x_ref[2]
            arg[(0, 1, 1, 0)]+=(0.924896517991-0.524471196605j)*x[2]
            ref[(0, 1, 1, 0)]+=(0.924896517991-0.524471196605j)*x_ref[2]
            arg[(0, 1, 1, 1)]+=(-0.240907771486-0.5837829947j)*x[2]
            ref[(0, 1, 1, 1)]+=(-0.240907771486-0.5837829947j)*x_ref[2]
            arg[(0, 1, 2, 0)]+=(-0.198261889232-0.87039585262j)*x[2]
            ref[(0, 1, 2, 0)]+=(-0.198261889232-0.87039585262j)*x_ref[2]
            arg[(0, 1, 2, 1)]+=(-0.143458780357-0.737711946336j)*x[2]
            ref[(0, 1, 2, 1)]+=(-0.143458780357-0.737711946336j)*x_ref[2]
            arg[(1, 0, 0, 0)]+=(-0.513243181731-0.960964248275j)*x[2]
            ref[(1, 0, 0, 0)]+=(-0.513243181731-0.960964248275j)*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.152361429395+0.967697647258j)*x[2]
            ref[(1, 0, 0, 1)]+=(0.152361429395+0.967697647258j)*x_ref[2]
            arg[(1, 0, 1, 0)]+=(0.0888235491749+0.273555094834j)*x[2]
            ref[(1, 0, 1, 0)]+=(0.0888235491749+0.273555094834j)*x_ref[2]
            arg[(1, 0, 1, 1)]+=(-0.692091740019+0.653595122294j)*x[2]
            ref[(1, 0, 1, 1)]+=(-0.692091740019+0.653595122294j)*x_ref[2]
            arg[(1, 0, 2, 0)]+=(0.828975139207+0.349995433781j)*x[2]
            ref[(1, 0, 2, 0)]+=(0.828975139207+0.349995433781j)*x_ref[2]
            arg[(1, 0, 2, 1)]+=(-0.937602384367-0.0227693096503j)*x[2]
            ref[(1, 0, 2, 1)]+=(-0.937602384367-0.0227693096503j)*x_ref[2]
            arg[(1, 1, 0, 0)]+=(0.99304330085-0.684293380824j)*x[2]
            ref[(1, 1, 0, 0)]+=(0.99304330085-0.684293380824j)*x_ref[2]
            arg[(1, 1, 0, 1)]+=(-0.564511052637+0.0455742244642j)*x[2]
            ref[(1, 1, 0, 1)]+=(-0.564511052637+0.0455742244642j)*x_ref[2]
            arg[(1, 1, 1, 0)]+=(-0.180695878518+0.0346566825016j)*x[2]
            ref[(1, 1, 1, 0)]+=(-0.180695878518+0.0346566825016j)*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.891326510721-0.934972228956j)*x[2]
            ref[(1, 1, 1, 1)]+=(-0.891326510721-0.934972228956j)*x_ref[2]
            arg[(1, 1, 2, 0)]+=(-0.625105157341+0.856116885824j)*x[2]
            ref[(1, 1, 2, 0)]+=(-0.625105157341+0.856116885824j)*x_ref[2]
            arg[(1, 1, 2, 1)]+=(-0.264398534345+0.336721661648j)*x[2]
            ref[(1, 1, 2, 1)]+=(-0.264398534345+0.336721661648j)*x_ref[2]
            arg[(2, 0, 0, 0)]+=(-0.834016289187+0.935874577227j)*x[2]
            ref[(2, 0, 0, 0)]+=(-0.834016289187+0.935874577227j)*x_ref[2]
            arg[(2, 0, 0, 1)]+=(-0.834192734829+0.669631006587j)*x[2]
            ref[(2, 0, 0, 1)]+=(-0.834192734829+0.669631006587j)*x_ref[2]
            arg[(2, 0, 1, 0)]+=(-0.951153750177-0.617112534255j)*x[2]
            ref[(2, 0, 1, 0)]+=(-0.951153750177-0.617112534255j)*x_ref[2]
            arg[(2, 0, 1, 1)]+=(0.468396288735-0.228858501731j)*x[2]
            ref[(2, 0, 1, 1)]+=(0.468396288735-0.228858501731j)*x_ref[2]
            arg[(2, 0, 2, 0)]+=(-0.259080721748+0.460412677927j)*x[2]
            ref[(2, 0, 2, 0)]+=(-0.259080721748+0.460412677927j)*x_ref[2]
            arg[(2, 0, 2, 1)]+=(-0.0524326671337+0.0622307139215j)*x[2]
            ref[(2, 0, 2, 1)]+=(-0.0524326671337+0.0622307139215j)*x_ref[2]
            arg[(2, 1, 0, 0)]+=(-0.754914323028+0.887147014362j)*x[2]
            ref[(2, 1, 0, 0)]+=(-0.754914323028+0.887147014362j)*x_ref[2]
            arg[(2, 1, 0, 1)]+=(-0.13425710837+0.453048728793j)*x[2]
            ref[(2, 1, 0, 1)]+=(-0.13425710837+0.453048728793j)*x_ref[2]
            arg[(2, 1, 1, 0)]+=(0.650395471302+0.355360789908j)*x[2]
            ref[(2, 1, 1, 0)]+=(0.650395471302+0.355360789908j)*x_ref[2]
            arg[(2, 1, 1, 1)]+=(0.814603055349+0.0432585217325j)*x[2]
            ref[(2, 1, 1, 1)]+=(0.814603055349+0.0432585217325j)*x_ref[2]
            arg[(2, 1, 2, 0)]+=(-0.391012771009-0.388937334819j)*x[2]
            ref[(2, 1, 2, 0)]+=(-0.391012771009-0.388937334819j)*x_ref[2]
            arg[(2, 1, 2, 1)]+=(0.919526666734-0.435358382297j)*x[2]
            ref[(2, 1, 2, 1)]+=(0.919526666734-0.435358382297j)*x_ref[2]
            arg[(3, 0, 0, 0)]+=(-0.147403210503-0.684387005009j)*x[2]
            ref[(3, 0, 0, 0)]+=(-0.147403210503-0.684387005009j)*x_ref[2]
            arg[(3, 0, 0, 1)]+=(-0.969571112908-0.439491652075j)*x[2]
            ref[(3, 0, 0, 1)]+=(-0.969571112908-0.439491652075j)*x_ref[2]
            arg[(3, 0, 1, 0)]+=(-0.368194862706+0.862572035557j)*x[2]
            ref[(3, 0, 1, 0)]+=(-0.368194862706+0.862572035557j)*x_ref[2]
            arg[(3, 0, 1, 1)]+=(-0.529673295417-0.153221145546j)*x[2]
            ref[(3, 0, 1, 1)]+=(-0.529673295417-0.153221145546j)*x_ref[2]
            arg[(3, 0, 2, 0)]+=(-0.819194509095+0.799206289059j)*x[2]
            ref[(3, 0, 2, 0)]+=(-0.819194509095+0.799206289059j)*x_ref[2]
            arg[(3, 0, 2, 1)]+=(-0.0719582654344+0.37211771946j)*x[2]
            ref[(3, 0, 2, 1)]+=(-0.0719582654344+0.37211771946j)*x_ref[2]
            arg[(3, 1, 0, 0)]+=(0.0301825906886-0.511273782012j)*x[2]
            ref[(3, 1, 0, 0)]+=(0.0301825906886-0.511273782012j)*x_ref[2]
            arg[(3, 1, 0, 1)]+=(-0.81627105051-0.911452191365j)*x[2]
            ref[(3, 1, 0, 1)]+=(-0.81627105051-0.911452191365j)*x_ref[2]
            arg[(3, 1, 1, 0)]+=(-0.92178447552-0.219150799166j)*x[2]
            ref[(3, 1, 1, 0)]+=(-0.92178447552-0.219150799166j)*x_ref[2]
            arg[(3, 1, 1, 1)]+=(-0.998099582242-0.760046301779j)*x[2]
            ref[(3, 1, 1, 1)]+=(-0.998099582242-0.760046301779j)*x_ref[2]
            arg[(3, 1, 2, 0)]+=(-0.23137510604+0.516613295652j)*x[2]
            ref[(3, 1, 2, 0)]+=(-0.23137510604+0.516613295652j)*x_ref[2]
            arg[(3, 1, 2, 1)]+=(-0.594071416649-0.65306573985j)*x[2]
            ref[(3, 1, 2, 1)]+=(-0.594071416649-0.65306573985j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 2, 3, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Function_rank0(self):
        """
        tests interpolation of rank 0 Data on Function

        assumptions: Function(self.domain) exists
                     self.domain supports interpolation from Function to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Function(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.472089537524+0.292931355344j)*x[0]**o + ((-0.904025322418-0.03457164945j))*x[0] + ((0.362872316398-0.29385678346j))*x[1]**o + ((-0.695675133554-0.934190272636j))*x[1]
        ref=(-0.472089537524+0.292931355344j)*x_ref[0]**o + ((-0.904025322418-0.03457164945j))*x_ref[0] + ((0.362872316398-0.29385678346j))*x_ref[1]**o + ((-0.695675133554-0.934190272636j))*x_ref[1]
        if dim==3:
            arg+=((0.582500893114+0.840367664457j))*x[2]**o + ((0.0417675695754-0.254876208537j))*x[2]
            ref+=((0.582500893114+0.840367664457j))*x_ref[2]**o + ((0.0417675695754-0.254876208537j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Function_rank1(self):
        """
        tests interpolation of rank 1 Data on Function

        assumptions: Function(self.domain) exists
                     self.domain supports interpolation from Function to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Function(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,),w_ref)
        arg[(0,)]=(-0.896830355839+0.564002647023j)*x[0]**o + ((-0.842590934976-0.0555537119182j))*x[0] + ((-0.657587764228+0.326573630087j))*x[1]**o + ((-0.470908886329+0.465596706428j))*x[1]
        ref[(0,)]=(-0.896830355839+0.564002647023j)*x_ref[0]**o + ((-0.842590934976-0.0555537119182j))*x_ref[0] + ((-0.657587764228+0.326573630087j))*x_ref[1]**o + ((-0.470908886329+0.465596706428j))*x_ref[1]
        arg[(1,)]=(-0.22491021224+0.100376772045j)*x[0]**o + ((-0.434398811362-0.621898619665j))*x[0] + ((0.996230316444-0.479605351564j))*x[1]**o + ((0.9377274879-0.778385327552j))*x[1]
        ref[(1,)]=(-0.22491021224+0.100376772045j)*x_ref[0]**o + ((-0.434398811362-0.621898619665j))*x_ref[0] + ((0.996230316444-0.479605351564j))*x_ref[1]**o + ((0.9377274879-0.778385327552j))*x_ref[1]
        arg[(2,)]=(-0.268798954983+0.587481507534j)*x[0]**o + ((0.598273417428+0.59543182134j))*x[0] + ((-0.891753842523+0.7069739431j))*x[1]**o + ((0.141910587477+0.761576420638j))*x[1]
        ref[(2,)]=(-0.268798954983+0.587481507534j)*x_ref[0]**o + ((0.598273417428+0.59543182134j))*x_ref[0] + ((-0.891753842523+0.7069739431j))*x_ref[1]**o + ((0.141910587477+0.761576420638j))*x_ref[1]
        arg[(3,)]=(0.746517039323+0.760741509966j)*x[0]**o + ((0.297908948889-0.668636035844j))*x[0] + ((0.843097484814-0.71718250873j))*x[1]**o + ((-0.149763159457+0.944726506867j))*x[1]
        ref[(3,)]=(0.746517039323+0.760741509966j)*x_ref[0]**o + ((0.297908948889-0.668636035844j))*x_ref[0] + ((0.843097484814-0.71718250873j))*x_ref[1]**o + ((-0.149763159457+0.944726506867j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(0.673710986481-0.0378910898241j)*x[2]**o + ((-0.480640903085-0.0979187484268j))*x[2]
            ref[(0,)]+=(0.673710986481-0.0378910898241j)*x_ref[2]**o + ((-0.480640903085-0.0979187484268j))*x_ref[2]
            arg[(1,)]+=(-0.740303569015-0.347774023835j)*x[2]**o + ((-0.897570083549+0.127925605023j))*x[2]
            ref[(1,)]+=(-0.740303569015-0.347774023835j)*x_ref[2]**o + ((-0.897570083549+0.127925605023j))*x_ref[2]
            arg[(2,)]+=(0.250163347777-0.914918872349j)*x[2]**o + ((0.626927498737+0.350088638373j))*x[2]
            ref[(2,)]+=(0.250163347777-0.914918872349j)*x_ref[2]**o + ((0.626927498737+0.350088638373j))*x_ref[2]
            arg[(3,)]+=(0.352557553189-0.739619715748j)*x[2]**o + ((0.192353808365-0.989291080622j))*x[2]
            ref[(3,)]+=(0.352557553189-0.739619715748j)*x_ref[2]**o + ((0.192353808365-0.989291080622j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Function_rank2(self):
        """
        tests interpolation of rank 2 Data on Function

        assumptions: Function(self.domain) exists
                     self.domain supports interpolation from Function to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Function(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2),w_ref)
        arg[(0, 0)]=(0.25676677318+0.035359888882j)*x[0]**o + ((-0.276060935631-0.624334326852j))*x[0] + ((0.921634848601-0.748371620623j))*x[1]**o + ((0.395521521613+0.066575294628j))*x[1]
        ref[(0, 0)]=(0.25676677318+0.035359888882j)*x_ref[0]**o + ((-0.276060935631-0.624334326852j))*x_ref[0] + ((0.921634848601-0.748371620623j))*x_ref[1]**o + ((0.395521521613+0.066575294628j))*x_ref[1]
        arg[(0, 1)]=(0.296108857086+0.362409536217j)*x[0]**o + ((-0.731420091134-0.056581167705j))*x[0] + ((-0.147080436495+0.586622851619j))*x[1]**o + ((0.704167507455+0.570662574181j))*x[1]
        ref[(0, 1)]=(0.296108857086+0.362409536217j)*x_ref[0]**o + ((-0.731420091134-0.056581167705j))*x_ref[0] + ((-0.147080436495+0.586622851619j))*x_ref[1]**o + ((0.704167507455+0.570662574181j))*x_ref[1]
        arg[(1, 0)]=(0.00489203221104+0.989905265955j)*x[0]**o + ((-0.528316434304-0.129769244997j))*x[0] + ((-0.93928452216-0.441637765956j))*x[1]**o + ((0.735177517205-0.583852570633j))*x[1]
        ref[(1, 0)]=(0.00489203221104+0.989905265955j)*x_ref[0]**o + ((-0.528316434304-0.129769244997j))*x_ref[0] + ((-0.93928452216-0.441637765956j))*x_ref[1]**o + ((0.735177517205-0.583852570633j))*x_ref[1]
        arg[(1, 1)]=(0.195185036932-0.0751540215507j)*x[0]**o + ((0.0787061375057-0.520426282003j))*x[0] + ((-0.120054715555-0.177431217137j))*x[1]**o + ((0.273010831644-0.581930822429j))*x[1]
        ref[(1, 1)]=(0.195185036932-0.0751540215507j)*x_ref[0]**o + ((0.0787061375057-0.520426282003j))*x_ref[0] + ((-0.120054715555-0.177431217137j))*x_ref[1]**o + ((0.273010831644-0.581930822429j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(0.0285991114692+0.031596714126j)*x[2]**o + ((-0.0886039807723-0.242871227684j))*x[2]
            ref[(0, 0)]+=(0.0285991114692+0.031596714126j)*x_ref[2]**o + ((-0.0886039807723-0.242871227684j))*x_ref[2]
            arg[(0, 1)]+=(-0.993728267283+0.880951257516j)*x[2]**o + ((0.220654487345-0.0942601002435j))*x[2]
            ref[(0, 1)]+=(-0.993728267283+0.880951257516j)*x_ref[2]**o + ((0.220654487345-0.0942601002435j))*x_ref[2]
            arg[(1, 0)]+=(-0.576049591181+0.0271496235762j)*x[2]**o + ((0.823306185288-0.251475599308j))*x[2]
            ref[(1, 0)]+=(-0.576049591181+0.0271496235762j)*x_ref[2]**o + ((0.823306185288-0.251475599308j))*x_ref[2]
            arg[(1, 1)]+=(0.688435354234-0.853338898012j)*x[2]**o + ((0.0430724766966+0.597527593355j))*x[2]
            ref[(1, 1)]+=(0.688435354234-0.853338898012j)*x_ref[2]**o + ((0.0430724766966+0.597527593355j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Function_rank3(self):
        """
        tests interpolation of rank 3 Data on Function

        assumptions: Function(self.domain) exists
                     self.domain supports interpolation from Function to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Function(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2, 3),w)
        ref = Data(0,(4, 2, 3),w_ref)
        arg[(0, 0, 0)]=(-0.162997383394+0.0993245569141j)*x[0]**o + ((0.268515098926-0.976572562712j))*x[0] + ((-0.517849801008+0.7425411274j))*x[1]**o + ((-0.258121149579-0.208076169145j))*x[1]
        ref[(0, 0, 0)]=(-0.162997383394+0.0993245569141j)*x_ref[0]**o + ((0.268515098926-0.976572562712j))*x_ref[0] + ((-0.517849801008+0.7425411274j))*x_ref[1]**o + ((-0.258121149579-0.208076169145j))*x_ref[1]
        arg[(0, 0, 1)]=(-0.374147900186+0.983711515901j)*x[0]**o + ((-0.313680306032-0.43293613732j))*x[0] + ((-0.382688776834-0.962072417689j))*x[1]**o + ((-0.709214142697-0.182315750117j))*x[1]
        ref[(0, 0, 1)]=(-0.374147900186+0.983711515901j)*x_ref[0]**o + ((-0.313680306032-0.43293613732j))*x_ref[0] + ((-0.382688776834-0.962072417689j))*x_ref[1]**o + ((-0.709214142697-0.182315750117j))*x_ref[1]
        arg[(0, 0, 2)]=(0.952146468539-0.62140927921j)*x[0]**o + ((0.691600333013-0.21031162281j))*x[0] + ((0.589443334046-0.265049642237j))*x[1]**o + ((-0.19854569552-0.0497521071673j))*x[1]
        ref[(0, 0, 2)]=(0.952146468539-0.62140927921j)*x_ref[0]**o + ((0.691600333013-0.21031162281j))*x_ref[0] + ((0.589443334046-0.265049642237j))*x_ref[1]**o + ((-0.19854569552-0.0497521071673j))*x_ref[1]
        arg[(0, 1, 0)]=(-0.61402048691+0.661990595283j)*x[0]**o + ((0.604184211118-0.521673192364j))*x[0] + ((0.782983023738-0.0274138416037j))*x[1]**o + ((0.941805804952-0.524563071071j))*x[1]
        ref[(0, 1, 0)]=(-0.61402048691+0.661990595283j)*x_ref[0]**o + ((0.604184211118-0.521673192364j))*x_ref[0] + ((0.782983023738-0.0274138416037j))*x_ref[1]**o + ((0.941805804952-0.524563071071j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.685848766332-0.821964033264j)*x[0]**o + ((0.1411957359+0.513972101516j))*x[0] + ((-0.764769637632-0.701107935657j))*x[1]**o + ((-0.449609664724+0.79238311645j))*x[1]
        ref[(0, 1, 1)]=(-0.685848766332-0.821964033264j)*x_ref[0]**o + ((0.1411957359+0.513972101516j))*x_ref[0] + ((-0.764769637632-0.701107935657j))*x_ref[1]**o + ((-0.449609664724+0.79238311645j))*x_ref[1]
        arg[(0, 1, 2)]=(0.790972510071-0.865833171714j)*x[0]**o + ((0.376087575796-0.791127152857j))*x[0] + ((0.2990774312-0.499929806646j))*x[1]**o + ((0.745023898599+0.868399076946j))*x[1]
        ref[(0, 1, 2)]=(0.790972510071-0.865833171714j)*x_ref[0]**o + ((0.376087575796-0.791127152857j))*x_ref[0] + ((0.2990774312-0.499929806646j))*x_ref[1]**o + ((0.745023898599+0.868399076946j))*x_ref[1]
        arg[(1, 0, 0)]=(0.848498747415+0.329672873351j)*x[0]**o + ((-0.00418837783003+0.333494381074j))*x[0] + ((-0.703305128841-0.738867942143j))*x[1]**o + ((-0.932836324087-0.878257614744j))*x[1]
        ref[(1, 0, 0)]=(0.848498747415+0.329672873351j)*x_ref[0]**o + ((-0.00418837783003+0.333494381074j))*x_ref[0] + ((-0.703305128841-0.738867942143j))*x_ref[1]**o + ((-0.932836324087-0.878257614744j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.813598481069+0.680790747542j)*x[0]**o + ((-0.875899905224+0.572841879962j))*x[0] + ((-0.943709225838-0.146039982359j))*x[1]**o + ((-0.455910919685+0.108720872672j))*x[1]
        ref[(1, 0, 1)]=(-0.813598481069+0.680790747542j)*x_ref[0]**o + ((-0.875899905224+0.572841879962j))*x_ref[0] + ((-0.943709225838-0.146039982359j))*x_ref[1]**o + ((-0.455910919685+0.108720872672j))*x_ref[1]
        arg[(1, 0, 2)]=(0.748848032496+0.673910974757j)*x[0]**o + ((-0.486893179083-0.0512225042936j))*x[0] + ((-0.168814914296+0.530756528611j))*x[1]**o + ((-0.0508389532113-0.901165392049j))*x[1]
        ref[(1, 0, 2)]=(0.748848032496+0.673910974757j)*x_ref[0]**o + ((-0.486893179083-0.0512225042936j))*x_ref[0] + ((-0.168814914296+0.530756528611j))*x_ref[1]**o + ((-0.0508389532113-0.901165392049j))*x_ref[1]
        arg[(1, 1, 0)]=(0.910207011353-0.0314743188652j)*x[0]**o + ((-0.107665601952+0.847549599405j))*x[0] + ((-0.268044170762-0.274362602391j))*x[1]**o + ((-0.696622851897-0.91765918462j))*x[1]
        ref[(1, 1, 0)]=(0.910207011353-0.0314743188652j)*x_ref[0]**o + ((-0.107665601952+0.847549599405j))*x_ref[0] + ((-0.268044170762-0.274362602391j))*x_ref[1]**o + ((-0.696622851897-0.91765918462j))*x_ref[1]
        arg[(1, 1, 1)]=(-0.293622749328+0.827617472513j)*x[0]**o + ((-0.0754794115619+0.33801117384j))*x[0] + ((-0.688852939437-0.88250540131j))*x[1]**o + ((0.881235468525+0.258218889194j))*x[1]
        ref[(1, 1, 1)]=(-0.293622749328+0.827617472513j)*x_ref[0]**o + ((-0.0754794115619+0.33801117384j))*x_ref[0] + ((-0.688852939437-0.88250540131j))*x_ref[1]**o + ((0.881235468525+0.258218889194j))*x_ref[1]
        arg[(1, 1, 2)]=(-0.91607817384+0.192237536375j)*x[0]**o + ((0.427853517709-0.915817219521j))*x[0] + ((-0.0411388625227-0.684988799846j))*x[1]**o + ((-0.956586253245+0.187624495245j))*x[1]
        ref[(1, 1, 2)]=(-0.91607817384+0.192237536375j)*x_ref[0]**o + ((0.427853517709-0.915817219521j))*x_ref[0] + ((-0.0411388625227-0.684988799846j))*x_ref[1]**o + ((-0.956586253245+0.187624495245j))*x_ref[1]
        arg[(2, 0, 0)]=(-0.646366268918+0.592611672754j)*x[0]**o + ((0.843416479954-0.396607236429j))*x[0] + ((-0.989564260952+0.419677893597j))*x[1]**o + ((-0.433072807208-0.637919607697j))*x[1]
        ref[(2, 0, 0)]=(-0.646366268918+0.592611672754j)*x_ref[0]**o + ((0.843416479954-0.396607236429j))*x_ref[0] + ((-0.989564260952+0.419677893597j))*x_ref[1]**o + ((-0.433072807208-0.637919607697j))*x_ref[1]
        arg[(2, 0, 1)]=(0.152478003857+0.727728892841j)*x[0]**o + ((0.078366141188-0.994132421823j))*x[0] + ((-0.67289459082-0.911010012864j))*x[1]**o + ((0.13449533171-0.120123950382j))*x[1]
        ref[(2, 0, 1)]=(0.152478003857+0.727728892841j)*x_ref[0]**o + ((0.078366141188-0.994132421823j))*x_ref[0] + ((-0.67289459082-0.911010012864j))*x_ref[1]**o + ((0.13449533171-0.120123950382j))*x_ref[1]
        arg[(2, 0, 2)]=(0.208969201256-0.692499676187j)*x[0]**o + ((-0.679431575754-0.796299017955j))*x[0] + ((0.2304237933+0.0972866623544j))*x[1]**o + ((0.73383274041-0.0201938957334j))*x[1]
        ref[(2, 0, 2)]=(0.208969201256-0.692499676187j)*x_ref[0]**o + ((-0.679431575754-0.796299017955j))*x_ref[0] + ((0.2304237933+0.0972866623544j))*x_ref[1]**o + ((0.73383274041-0.0201938957334j))*x_ref[1]
        arg[(2, 1, 0)]=(0.274563782771-0.69417117282j)*x[0]**o + ((0.638534147242-0.680109969638j))*x[0] + ((-0.333059619717+0.687756738994j))*x[1]**o + ((-0.724218713771+0.557644671366j))*x[1]
        ref[(2, 1, 0)]=(0.274563782771-0.69417117282j)*x_ref[0]**o + ((0.638534147242-0.680109969638j))*x_ref[0] + ((-0.333059619717+0.687756738994j))*x_ref[1]**o + ((-0.724218713771+0.557644671366j))*x_ref[1]
        arg[(2, 1, 1)]=(0.810482811446-0.221714568357j)*x[0]**o + ((-0.0908602823615-0.1182838411j))*x[0] + ((0.358868676153-0.533114332467j))*x[1]**o + ((0.751057206451+0.616956231562j))*x[1]
        ref[(2, 1, 1)]=(0.810482811446-0.221714568357j)*x_ref[0]**o + ((-0.0908602823615-0.1182838411j))*x_ref[0] + ((0.358868676153-0.533114332467j))*x_ref[1]**o + ((0.751057206451+0.616956231562j))*x_ref[1]
        arg[(2, 1, 2)]=(-0.955866701435-0.493674615981j)*x[0]**o + ((0.708987305614+0.789123463659j))*x[0] + ((0.973062215002+0.78148131142j))*x[1]**o + ((-0.609438840713-0.437501317435j))*x[1]
        ref[(2, 1, 2)]=(-0.955866701435-0.493674615981j)*x_ref[0]**o + ((0.708987305614+0.789123463659j))*x_ref[0] + ((0.973062215002+0.78148131142j))*x_ref[1]**o + ((-0.609438840713-0.437501317435j))*x_ref[1]
        arg[(3, 0, 0)]=(-0.601988853485-0.272024489896j)*x[0]**o + ((-0.436993209938-0.804708008952j))*x[0] + ((-0.713463155879-0.904950883229j))*x[1]**o + ((0.0818924608476-0.238357904917j))*x[1]
        ref[(3, 0, 0)]=(-0.601988853485-0.272024489896j)*x_ref[0]**o + ((-0.436993209938-0.804708008952j))*x_ref[0] + ((-0.713463155879-0.904950883229j))*x_ref[1]**o + ((0.0818924608476-0.238357904917j))*x_ref[1]
        arg[(3, 0, 1)]=(0.0638121156946+0.985367359491j)*x[0]**o + ((-0.237540227648-0.945953938747j))*x[0] + ((0.0188071527727+0.114786147002j))*x[1]**o + ((-0.657052625026-0.975770573546j))*x[1]
        ref[(3, 0, 1)]=(0.0638121156946+0.985367359491j)*x_ref[0]**o + ((-0.237540227648-0.945953938747j))*x_ref[0] + ((0.0188071527727+0.114786147002j))*x_ref[1]**o + ((-0.657052625026-0.975770573546j))*x_ref[1]
        arg[(3, 0, 2)]=(0.274322393782-0.57303001624j)*x[0]**o + ((-0.542790224866+0.532090757322j))*x[0] + ((-0.0804823058632-0.0960290659851j))*x[1]**o + ((-0.654790422321-0.135634649891j))*x[1]
        ref[(3, 0, 2)]=(0.274322393782-0.57303001624j)*x_ref[0]**o + ((-0.542790224866+0.532090757322j))*x_ref[0] + ((-0.0804823058632-0.0960290659851j))*x_ref[1]**o + ((-0.654790422321-0.135634649891j))*x_ref[1]
        arg[(3, 1, 0)]=(-0.564644459429-0.651580633065j)*x[0]**o + ((-0.693471989089+0.867352666387j))*x[0] + ((0.587672202288+0.884861405861j))*x[1]**o + ((0.128451647085+0.714713681103j))*x[1]
        ref[(3, 1, 0)]=(-0.564644459429-0.651580633065j)*x_ref[0]**o + ((-0.693471989089+0.867352666387j))*x_ref[0] + ((0.587672202288+0.884861405861j))*x_ref[1]**o + ((0.128451647085+0.714713681103j))*x_ref[1]
        arg[(3, 1, 1)]=(-0.765808221574-0.6765343734j)*x[0]**o + ((-0.535542382395+0.202669958368j))*x[0] + ((-0.334543565843+0.431999551531j))*x[1]**o + ((0.37934849797-0.767563035893j))*x[1]
        ref[(3, 1, 1)]=(-0.765808221574-0.6765343734j)*x_ref[0]**o + ((-0.535542382395+0.202669958368j))*x_ref[0] + ((-0.334543565843+0.431999551531j))*x_ref[1]**o + ((0.37934849797-0.767563035893j))*x_ref[1]
        arg[(3, 1, 2)]=(0.694116977841-0.204557055584j)*x[0]**o + ((0.653370369678+0.297614926334j))*x[0] + ((0.310357450886-0.335354743358j))*x[1]**o + ((-0.861201842455+0.624425576717j))*x[1]
        ref[(3, 1, 2)]=(0.694116977841-0.204557055584j)*x_ref[0]**o + ((0.653370369678+0.297614926334j))*x_ref[0] + ((0.310357450886-0.335354743358j))*x_ref[1]**o + ((-0.861201842455+0.624425576717j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(0.890031816344-0.482167995098j)*x[2]**o + ((-0.141732860804-0.889426823313j))*x[2]
            ref[(0, 0, 0)]+=(0.890031816344-0.482167995098j)*x_ref[2]**o + ((-0.141732860804-0.889426823313j))*x_ref[2]
            arg[(0, 0, 1)]+=(-0.784222772881-0.767257494518j)*x[2]**o + ((0.962106580861-0.267371828003j))*x[2]
            ref[(0, 0, 1)]+=(-0.784222772881-0.767257494518j)*x_ref[2]**o + ((0.962106580861-0.267371828003j))*x_ref[2]
            arg[(0, 0, 2)]+=(-0.288785285616-0.726038195602j)*x[2]**o + ((-0.204828463332+0.536986101695j))*x[2]
            ref[(0, 0, 2)]+=(-0.288785285616-0.726038195602j)*x_ref[2]**o + ((-0.204828463332+0.536986101695j))*x_ref[2]
            arg[(0, 1, 0)]+=(0.0738236977175-0.595465692231j)*x[2]**o + ((0.264513516717-0.853862751525j))*x[2]
            ref[(0, 1, 0)]+=(0.0738236977175-0.595465692231j)*x_ref[2]**o + ((0.264513516717-0.853862751525j))*x_ref[2]
            arg[(0, 1, 1)]+=(-0.446026429722+0.730634940385j)*x[2]**o + ((-0.698595670585+0.477818290585j))*x[2]
            ref[(0, 1, 1)]+=(-0.446026429722+0.730634940385j)*x_ref[2]**o + ((-0.698595670585+0.477818290585j))*x_ref[2]
            arg[(0, 1, 2)]+=(0.584663437383-0.477597543842j)*x[2]**o + ((-0.981194923069+0.570026811397j))*x[2]
            ref[(0, 1, 2)]+=(0.584663437383-0.477597543842j)*x_ref[2]**o + ((-0.981194923069+0.570026811397j))*x_ref[2]
            arg[(1, 0, 0)]+=(0.136640466319+0.139324413395j)*x[2]**o + ((0.802607350954-0.273498316487j))*x[2]
            ref[(1, 0, 0)]+=(0.136640466319+0.139324413395j)*x_ref[2]**o + ((0.802607350954-0.273498316487j))*x_ref[2]
            arg[(1, 0, 1)]+=(-0.723777440902+0.626356241762j)*x[2]**o + ((0.0588152546395-0.929731400425j))*x[2]
            ref[(1, 0, 1)]+=(-0.723777440902+0.626356241762j)*x_ref[2]**o + ((0.0588152546395-0.929731400425j))*x_ref[2]
            arg[(1, 0, 2)]+=(-0.934240682904-0.980025014198j)*x[2]**o + ((-0.705553686109+0.7744658202j))*x[2]
            ref[(1, 0, 2)]+=(-0.934240682904-0.980025014198j)*x_ref[2]**o + ((-0.705553686109+0.7744658202j))*x_ref[2]
            arg[(1, 1, 0)]+=(-0.0743007958336-0.891918988303j)*x[2]**o + ((-0.150422306968-0.783695572292j))*x[2]
            ref[(1, 1, 0)]+=(-0.0743007958336-0.891918988303j)*x_ref[2]**o + ((-0.150422306968-0.783695572292j))*x_ref[2]
            arg[(1, 1, 1)]+=(-0.890992725787-0.116001897695j)*x[2]**o + ((0.243629991238-0.428160724769j))*x[2]
            ref[(1, 1, 1)]+=(-0.890992725787-0.116001897695j)*x_ref[2]**o + ((0.243629991238-0.428160724769j))*x_ref[2]
            arg[(1, 1, 2)]+=(0.914762414172+0.147876172866j)*x[2]**o + ((-0.987564513217-0.484011554944j))*x[2]
            ref[(1, 1, 2)]+=(0.914762414172+0.147876172866j)*x_ref[2]**o + ((-0.987564513217-0.484011554944j))*x_ref[2]
            arg[(2, 0, 0)]+=(0.487013296082-0.908538126886j)*x[2]**o + ((0.946468098931+0.664602132181j))*x[2]
            ref[(2, 0, 0)]+=(0.487013296082-0.908538126886j)*x_ref[2]**o + ((0.946468098931+0.664602132181j))*x_ref[2]
            arg[(2, 0, 1)]+=(-0.82086017344+0.192655455227j)*x[2]**o + ((0.234434476027-0.0483495624563j))*x[2]
            ref[(2, 0, 1)]+=(-0.82086017344+0.192655455227j)*x_ref[2]**o + ((0.234434476027-0.0483495624563j))*x_ref[2]
            arg[(2, 0, 2)]+=(0.653444596159-0.518508173434j)*x[2]**o + ((-0.980721938897+0.0329789671362j))*x[2]
            ref[(2, 0, 2)]+=(0.653444596159-0.518508173434j)*x_ref[2]**o + ((-0.980721938897+0.0329789671362j))*x_ref[2]
            arg[(2, 1, 0)]+=(-0.466948232379+0.875635742007j)*x[2]**o + ((-0.67467479833-0.668580471969j))*x[2]
            ref[(2, 1, 0)]+=(-0.466948232379+0.875635742007j)*x_ref[2]**o + ((-0.67467479833-0.668580471969j))*x_ref[2]
            arg[(2, 1, 1)]+=(0.257474281959-0.573133600379j)*x[2]**o + ((0.115794115176+0.0846082777003j))*x[2]
            ref[(2, 1, 1)]+=(0.257474281959-0.573133600379j)*x_ref[2]**o + ((0.115794115176+0.0846082777003j))*x_ref[2]
            arg[(2, 1, 2)]+=(-0.599863263253+0.714050043553j)*x[2]**o + ((-0.120204722675-0.265609756137j))*x[2]
            ref[(2, 1, 2)]+=(-0.599863263253+0.714050043553j)*x_ref[2]**o + ((-0.120204722675-0.265609756137j))*x_ref[2]
            arg[(3, 0, 0)]+=(0.436052943656-0.04861147262j)*x[2]**o + ((0.970918633399+0.502476538454j))*x[2]
            ref[(3, 0, 0)]+=(0.436052943656-0.04861147262j)*x_ref[2]**o + ((0.970918633399+0.502476538454j))*x_ref[2]
            arg[(3, 0, 1)]+=(-0.242032678499+0.189318029754j)*x[2]**o + ((0.834562256509+0.0049898181356j))*x[2]
            ref[(3, 0, 1)]+=(-0.242032678499+0.189318029754j)*x_ref[2]**o + ((0.834562256509+0.0049898181356j))*x_ref[2]
            arg[(3, 0, 2)]+=(0.469711452717+0.442032960572j)*x[2]**o + ((0.415674609279+0.249723603128j))*x[2]
            ref[(3, 0, 2)]+=(0.469711452717+0.442032960572j)*x_ref[2]**o + ((0.415674609279+0.249723603128j))*x_ref[2]
            arg[(3, 1, 0)]+=(0.497817545199-0.439053854403j)*x[2]**o + ((-0.431831576327+0.352837425929j))*x[2]
            ref[(3, 1, 0)]+=(0.497817545199-0.439053854403j)*x_ref[2]**o + ((-0.431831576327+0.352837425929j))*x_ref[2]
            arg[(3, 1, 1)]+=(0.089433911351+0.202632664039j)*x[2]**o + ((-0.276849822362-0.152858013744j))*x[2]
            ref[(3, 1, 1)]+=(0.089433911351+0.202632664039j)*x_ref[2]**o + ((-0.276849822362-0.152858013744j))*x_ref[2]
            arg[(3, 1, 2)]+=(0.840389985065+0.253397710079j)*x[2]**o + ((-0.69142579962+0.135915640806j))*x[2]
            ref[(3, 1, 2)]+=(0.840389985065+0.253397710079j)*x_ref[2]**o + ((-0.69142579962+0.135915640806j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 2, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunction_fromData_Function_rank4(self):
        """
        tests interpolation of rank 4 Data on Function

        assumptions: Function(self.domain) exists
                     self.domain supports interpolation from Function to Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Function(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 3, 3),w)
        ref = Data(0,(4, 3, 3, 3),w_ref)
        arg[(0, 0, 0, 0)]=(-0.477409028512+0.161429757217j)*x[0]**o + ((-0.500708098344+0.8289277756j))*x[0] + ((-0.932234608826-0.561028582779j))*x[1]**o + ((0.00831685744855+0.953912696383j))*x[1]
        ref[(0, 0, 0, 0)]=(-0.477409028512+0.161429757217j)*x_ref[0]**o + ((-0.500708098344+0.8289277756j))*x_ref[0] + ((-0.932234608826-0.561028582779j))*x_ref[1]**o + ((0.00831685744855+0.953912696383j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(0.705453900501+0.208190569869j)*x[0]**o + ((0.416884132708-0.883805507744j))*x[0] + ((0.14551091452+0.446779465092j))*x[1]**o + ((-0.424799896945+0.541804955265j))*x[1]
        ref[(0, 0, 0, 1)]=(0.705453900501+0.208190569869j)*x_ref[0]**o + ((0.416884132708-0.883805507744j))*x_ref[0] + ((0.14551091452+0.446779465092j))*x_ref[1]**o + ((-0.424799896945+0.541804955265j))*x_ref[1]
        arg[(0, 0, 0, 2)]=(0.572508265952+0.514564926735j)*x[0]**o + ((0.446071800792-0.243332733656j))*x[0] + ((0.420018272214-0.158758810892j))*x[1]**o + ((0.103228931929+0.603877694073j))*x[1]
        ref[(0, 0, 0, 2)]=(0.572508265952+0.514564926735j)*x_ref[0]**o + ((0.446071800792-0.243332733656j))*x_ref[0] + ((0.420018272214-0.158758810892j))*x_ref[1]**o + ((0.103228931929+0.603877694073j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(-0.397194469873+0.369532156802j)*x[0]**o + ((0.300475563808-0.127300844917j))*x[0] + ((-0.725974373353+0.663229335871j))*x[1]**o + ((0.997276090695-0.592403989356j))*x[1]
        ref[(0, 0, 1, 0)]=(-0.397194469873+0.369532156802j)*x_ref[0]**o + ((0.300475563808-0.127300844917j))*x_ref[0] + ((-0.725974373353+0.663229335871j))*x_ref[1]**o + ((0.997276090695-0.592403989356j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(0.055597854028+0.392616611016j)*x[0]**o + ((0.107382334393+0.714870059539j))*x[0] + ((0.0499670219276-0.385783249414j))*x[1]**o + ((0.75133070042+0.783963292577j))*x[1]
        ref[(0, 0, 1, 1)]=(0.055597854028+0.392616611016j)*x_ref[0]**o + ((0.107382334393+0.714870059539j))*x_ref[0] + ((0.0499670219276-0.385783249414j))*x_ref[1]**o + ((0.75133070042+0.783963292577j))*x_ref[1]
        arg[(0, 0, 1, 2)]=(0.429278319917-0.453255599169j)*x[0]**o + ((-0.468869878977-0.139830943696j))*x[0] + ((-0.691282525305-0.294763280858j))*x[1]**o + ((-0.70244122457+0.221979467023j))*x[1]
        ref[(0, 0, 1, 2)]=(0.429278319917-0.453255599169j)*x_ref[0]**o + ((-0.468869878977-0.139830943696j))*x_ref[0] + ((-0.691282525305-0.294763280858j))*x_ref[1]**o + ((-0.70244122457+0.221979467023j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(-0.453033393005+0.323459617155j)*x[0]**o + ((0.745896721398-0.415203015668j))*x[0] + ((0.908493847812+0.240689104108j))*x[1]**o + ((0.183582900085+0.829242456037j))*x[1]
        ref[(0, 0, 2, 0)]=(-0.453033393005+0.323459617155j)*x_ref[0]**o + ((0.745896721398-0.415203015668j))*x_ref[0] + ((0.908493847812+0.240689104108j))*x_ref[1]**o + ((0.183582900085+0.829242456037j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(0.838106748423-0.188119092551j)*x[0]**o + ((-0.240038762513+0.697104869727j))*x[0] + ((-0.864789940816-0.18231415347j))*x[1]**o + ((-0.275652236506-0.75000317555j))*x[1]
        ref[(0, 0, 2, 1)]=(0.838106748423-0.188119092551j)*x_ref[0]**o + ((-0.240038762513+0.697104869727j))*x_ref[0] + ((-0.864789940816-0.18231415347j))*x_ref[1]**o + ((-0.275652236506-0.75000317555j))*x_ref[1]
        arg[(0, 0, 2, 2)]=(0.81835377964+0.672346999143j)*x[0]**o + ((0.161384511864+0.186872033905j))*x[0] + ((-0.470022446128-0.0307301620768j))*x[1]**o + ((0.887089783767+0.857774172777j))*x[1]
        ref[(0, 0, 2, 2)]=(0.81835377964+0.672346999143j)*x_ref[0]**o + ((0.161384511864+0.186872033905j))*x_ref[0] + ((-0.470022446128-0.0307301620768j))*x_ref[1]**o + ((0.887089783767+0.857774172777j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(-0.642505189988-0.359774800198j)*x[0]**o + ((0.983052432909+0.219508437378j))*x[0] + ((-0.936607514743-0.188135878307j))*x[1]**o + ((-0.600824007311-0.265191989524j))*x[1]
        ref[(0, 1, 0, 0)]=(-0.642505189988-0.359774800198j)*x_ref[0]**o + ((0.983052432909+0.219508437378j))*x_ref[0] + ((-0.936607514743-0.188135878307j))*x_ref[1]**o + ((-0.600824007311-0.265191989524j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(-0.990015450885-0.776588182428j)*x[0]**o + ((-0.534457541141+0.601179528733j))*x[0] + ((-0.197017227119-0.683835368872j))*x[1]**o + ((-0.648633600533+0.440111393045j))*x[1]
        ref[(0, 1, 0, 1)]=(-0.990015450885-0.776588182428j)*x_ref[0]**o + ((-0.534457541141+0.601179528733j))*x_ref[0] + ((-0.197017227119-0.683835368872j))*x_ref[1]**o + ((-0.648633600533+0.440111393045j))*x_ref[1]
        arg[(0, 1, 0, 2)]=(-0.0253833350483+0.979649264819j)*x[0]**o + ((0.0490845865689+0.818692534367j))*x[0] + ((-0.697400937856-0.0922981313929j))*x[1]**o + ((-0.618569025842+0.76149817828j))*x[1]
        ref[(0, 1, 0, 2)]=(-0.0253833350483+0.979649264819j)*x_ref[0]**o + ((0.0490845865689+0.818692534367j))*x_ref[0] + ((-0.697400937856-0.0922981313929j))*x_ref[1]**o + ((-0.618569025842+0.76149817828j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(0.250732370132-0.00536560952489j)*x[0]**o + ((-0.0397659877456-0.79704118366j))*x[0] + ((0.214453808496-0.00238646220594j))*x[1]**o + ((-0.545392759693-0.158332895063j))*x[1]
        ref[(0, 1, 1, 0)]=(0.250732370132-0.00536560952489j)*x_ref[0]**o + ((-0.0397659877456-0.79704118366j))*x_ref[0] + ((0.214453808496-0.00238646220594j))*x_ref[1]**o + ((-0.545392759693-0.158332895063j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(-0.700896085557-0.167077481295j)*x[0]**o + ((-0.721957303751-0.169727325559j))*x[0] + ((-0.609298937896-0.404741741018j))*x[1]**o + ((-0.246563483747-0.802217414483j))*x[1]
        ref[(0, 1, 1, 1)]=(-0.700896085557-0.167077481295j)*x_ref[0]**o + ((-0.721957303751-0.169727325559j))*x_ref[0] + ((-0.609298937896-0.404741741018j))*x_ref[1]**o + ((-0.246563483747-0.802217414483j))*x_ref[1]
        arg[(0, 1, 1, 2)]=(0.638384918363-0.598438273277j)*x[0]**o + ((0.0213765185135+0.616589541373j))*x[0] + ((-0.0572159752229-0.286125786807j))*x[1]**o + ((0.36996978136-0.563121775786j))*x[1]
        ref[(0, 1, 1, 2)]=(0.638384918363-0.598438273277j)*x_ref[0]**o + ((0.0213765185135+0.616589541373j))*x_ref[0] + ((-0.0572159752229-0.286125786807j))*x_ref[1]**o + ((0.36996978136-0.563121775786j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(-0.168323444824-0.033874467092j)*x[0]**o + ((0.855351236665-0.762235120832j))*x[0] + ((0.618776433379+0.357835747789j))*x[1]**o + ((-0.92729622683+0.549081715225j))*x[1]
        ref[(0, 1, 2, 0)]=(-0.168323444824-0.033874467092j)*x_ref[0]**o + ((0.855351236665-0.762235120832j))*x_ref[0] + ((0.618776433379+0.357835747789j))*x_ref[1]**o + ((-0.92729622683+0.549081715225j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(0.861164841049-0.306929519548j)*x[0]**o + ((-0.164123341515+0.514787797026j))*x[0] + ((-0.530431156998-0.54952695844j))*x[1]**o + ((-0.287256582449-0.329809797267j))*x[1]
        ref[(0, 1, 2, 1)]=(0.861164841049-0.306929519548j)*x_ref[0]**o + ((-0.164123341515+0.514787797026j))*x_ref[0] + ((-0.530431156998-0.54952695844j))*x_ref[1]**o + ((-0.287256582449-0.329809797267j))*x_ref[1]
        arg[(0, 1, 2, 2)]=(-0.641857696261-0.353489421406j)*x[0]**o + ((0.760218936018+0.895760152942j))*x[0] + ((0.607597565616-0.0582571816108j))*x[1]**o + ((0.999234607605+0.154277664891j))*x[1]
        ref[(0, 1, 2, 2)]=(-0.641857696261-0.353489421406j)*x_ref[0]**o + ((0.760218936018+0.895760152942j))*x_ref[0] + ((0.607597565616-0.0582571816108j))*x_ref[1]**o + ((0.999234607605+0.154277664891j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(0.87342816967+0.269252455368j)*x[0]**o + ((0.262977652317-0.0679374676236j))*x[0] + ((0.774855028146+0.583172040759j))*x[1]**o + ((0.356667977044+0.466652727859j))*x[1]
        ref[(0, 2, 0, 0)]=(0.87342816967+0.269252455368j)*x_ref[0]**o + ((0.262977652317-0.0679374676236j))*x_ref[0] + ((0.774855028146+0.583172040759j))*x_ref[1]**o + ((0.356667977044+0.466652727859j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(-0.583903991611+0.81161794499j)*x[0]**o + ((-0.1610085059+0.260663993474j))*x[0] + ((-0.711933904577-0.42282325877j))*x[1]**o + ((-0.102009061726-0.424227804554j))*x[1]
        ref[(0, 2, 0, 1)]=(-0.583903991611+0.81161794499j)*x_ref[0]**o + ((-0.1610085059+0.260663993474j))*x_ref[0] + ((-0.711933904577-0.42282325877j))*x_ref[1]**o + ((-0.102009061726-0.424227804554j))*x_ref[1]
        arg[(0, 2, 0, 2)]=(-0.610129696311+0.871419119437j)*x[0]**o + ((0.378448730698-0.998334592723j))*x[0] + ((0.332967262715+0.692255273852j))*x[1]**o + ((0.348268711044+0.0445349849115j))*x[1]
        ref[(0, 2, 0, 2)]=(-0.610129696311+0.871419119437j)*x_ref[0]**o + ((0.378448730698-0.998334592723j))*x_ref[0] + ((0.332967262715+0.692255273852j))*x_ref[1]**o + ((0.348268711044+0.0445349849115j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(0.781559630397-0.284006562521j)*x[0]**o + ((-0.695045146323+0.123681677003j))*x[0] + ((0.318468976161-0.37841233625j))*x[1]**o + ((0.641124122573+0.136091344307j))*x[1]
        ref[(0, 2, 1, 0)]=(0.781559630397-0.284006562521j)*x_ref[0]**o + ((-0.695045146323+0.123681677003j))*x_ref[0] + ((0.318468976161-0.37841233625j))*x_ref[1]**o + ((0.641124122573+0.136091344307j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(-0.936951688787+0.90360034771j)*x[0]**o + ((-0.943649173375-0.66606369104j))*x[0] + ((0.367793643796-0.366560174828j))*x[1]**o + ((0.209794946947-0.210998254263j))*x[1]
        ref[(0, 2, 1, 1)]=(-0.936951688787+0.90360034771j)*x_ref[0]**o + ((-0.943649173375-0.66606369104j))*x_ref[0] + ((0.367793643796-0.366560174828j))*x_ref[1]**o + ((0.209794946947-0.210998254263j))*x_ref[1]
        arg[(0, 2, 1, 2)]=(-0.527503503844+0.453337074072j)*x[0]**o + ((-0.466460268001+0.0978569567023j))*x[0] + ((-0.558984432295+0.915698764493j))*x[1]**o + ((-0.216035424894+0.529372842836j))*x[1]
        ref[(0, 2, 1, 2)]=(-0.527503503844+0.453337074072j)*x_ref[0]**o + ((-0.466460268001+0.0978569567023j))*x_ref[0] + ((-0.558984432295+0.915698764493j))*x_ref[1]**o + ((-0.216035424894+0.529372842836j))*x_ref[1]
        arg[(0, 2, 2, 0)]=(0.807529271879+0.0284495575221j)*x[0]**o + ((-0.681747162814-0.775301129129j))*x[0] + ((-0.988924199478-0.957723122063j))*x[1]**o + ((-0.931616830393+0.492273319141j))*x[1]
        ref[(0, 2, 2, 0)]=(0.807529271879+0.0284495575221j)*x_ref[0]**o + ((-0.681747162814-0.775301129129j))*x_ref[0] + ((-0.988924199478-0.957723122063j))*x_ref[1]**o + ((-0.931616830393+0.492273319141j))*x_ref[1]
        arg[(0, 2, 2, 1)]=(0.205422949863-0.667367357166j)*x[0]**o + ((0.944186321996+0.116747628871j))*x[0] + ((-0.502470951503+0.0158840889942j))*x[1]**o + ((-0.127244145439-0.307030191734j))*x[1]
        ref[(0, 2, 2, 1)]=(0.205422949863-0.667367357166j)*x_ref[0]**o + ((0.944186321996+0.116747628871j))*x_ref[0] + ((-0.502470951503+0.0158840889942j))*x_ref[1]**o + ((-0.127244145439-0.307030191734j))*x_ref[1]
        arg[(0, 2, 2, 2)]=(0.194990224499+0.18063083046j)*x[0]**o + ((-0.514918146362-0.58020414648j))*x[0] + ((-0.756170482939+0.949760049091j))*x[1]**o + ((0.164787325605+0.103616278887j))*x[1]
        ref[(0, 2, 2, 2)]=(0.194990224499+0.18063083046j)*x_ref[0]**o + ((-0.514918146362-0.58020414648j))*x_ref[0] + ((-0.756170482939+0.949760049091j))*x_ref[1]**o + ((0.164787325605+0.103616278887j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.898476904944+0.715810511234j)*x[0]**o + ((-0.635923568567-0.275698233353j))*x[0] + ((-0.52426451189+0.102053240303j))*x[1]**o + ((0.707865966699-0.739030450015j))*x[1]
        ref[(1, 0, 0, 0)]=(0.898476904944+0.715810511234j)*x_ref[0]**o + ((-0.635923568567-0.275698233353j))*x_ref[0] + ((-0.52426451189+0.102053240303j))*x_ref[1]**o + ((0.707865966699-0.739030450015j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.831245095501-0.733718218924j)*x[0]**o + ((-0.23513252882-0.134081972543j))*x[0] + ((-0.440238108902+0.506144458572j))*x[1]**o + ((-0.81919835715-0.343825081344j))*x[1]
        ref[(1, 0, 0, 1)]=(0.831245095501-0.733718218924j)*x_ref[0]**o + ((-0.23513252882-0.134081972543j))*x_ref[0] + ((-0.440238108902+0.506144458572j))*x_ref[1]**o + ((-0.81919835715-0.343825081344j))*x_ref[1]
        arg[(1, 0, 0, 2)]=(0.842390138947-0.37068595119j)*x[0]**o + ((-0.442453140411+0.315301488813j))*x[0] + ((0.898976018267+0.130191618281j))*x[1]**o + ((-0.720741637821+0.881295764539j))*x[1]
        ref[(1, 0, 0, 2)]=(0.842390138947-0.37068595119j)*x_ref[0]**o + ((-0.442453140411+0.315301488813j))*x_ref[0] + ((0.898976018267+0.130191618281j))*x_ref[1]**o + ((-0.720741637821+0.881295764539j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.236165793749+0.950934286436j)*x[0]**o + ((0.339640196459-0.12746281235j))*x[0] + ((-0.453860694267-0.940392725856j))*x[1]**o + ((-0.851858885396-0.945941882234j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.236165793749+0.950934286436j)*x_ref[0]**o + ((0.339640196459-0.12746281235j))*x_ref[0] + ((-0.453860694267-0.940392725856j))*x_ref[1]**o + ((-0.851858885396-0.945941882234j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(-0.0791747612221-0.895922282907j)*x[0]**o + ((0.926402970381-0.674356234313j))*x[0] + ((-0.969149643169-0.138912239366j))*x[1]**o + ((0.404449610156-0.709687626639j))*x[1]
        ref[(1, 0, 1, 1)]=(-0.0791747612221-0.895922282907j)*x_ref[0]**o + ((0.926402970381-0.674356234313j))*x_ref[0] + ((-0.969149643169-0.138912239366j))*x_ref[1]**o + ((0.404449610156-0.709687626639j))*x_ref[1]
        arg[(1, 0, 1, 2)]=(0.961238789826-0.362837861451j)*x[0]**o + ((-0.370163035732-0.67986542325j))*x[0] + ((0.619510817188+0.741311061352j))*x[1]**o + ((0.245133059781+0.30242378274j))*x[1]
        ref[(1, 0, 1, 2)]=(0.961238789826-0.362837861451j)*x_ref[0]**o + ((-0.370163035732-0.67986542325j))*x_ref[0] + ((0.619510817188+0.741311061352j))*x_ref[1]**o + ((0.245133059781+0.30242378274j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(0.709498986444-0.795764639887j)*x[0]**o + ((-0.234195005471+0.0073956404799j))*x[0] + ((-0.914985912459+0.996408304677j))*x[1]**o + ((0.726017048333+0.53913234935j))*x[1]
        ref[(1, 0, 2, 0)]=(0.709498986444-0.795764639887j)*x_ref[0]**o + ((-0.234195005471+0.0073956404799j))*x_ref[0] + ((-0.914985912459+0.996408304677j))*x_ref[1]**o + ((0.726017048333+0.53913234935j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(-0.478683506095-0.860913627688j)*x[0]**o + ((0.798153185258+0.747082181118j))*x[0] + ((-0.587930534527-0.185672886389j))*x[1]**o + ((-0.38841366029-0.398816975052j))*x[1]
        ref[(1, 0, 2, 1)]=(-0.478683506095-0.860913627688j)*x_ref[0]**o + ((0.798153185258+0.747082181118j))*x_ref[0] + ((-0.587930534527-0.185672886389j))*x_ref[1]**o + ((-0.38841366029-0.398816975052j))*x_ref[1]
        arg[(1, 0, 2, 2)]=(0.746631342335+0.719902170746j)*x[0]**o + ((0.681185783551-0.885861847613j))*x[0] + ((0.0447028728609-0.147119202792j))*x[1]**o + ((-0.724974715238-0.147737342739j))*x[1]
        ref[(1, 0, 2, 2)]=(0.746631342335+0.719902170746j)*x_ref[0]**o + ((0.681185783551-0.885861847613j))*x_ref[0] + ((0.0447028728609-0.147119202792j))*x_ref[1]**o + ((-0.724974715238-0.147737342739j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(-0.172187261241+0.790584525332j)*x[0]**o + ((0.461196261617+0.32341541967j))*x[0] + ((0.248250415555+0.518973181876j))*x[1]**o + ((-0.299079824784-0.0575843368022j))*x[1]
        ref[(1, 1, 0, 0)]=(-0.172187261241+0.790584525332j)*x_ref[0]**o + ((0.461196261617+0.32341541967j))*x_ref[0] + ((0.248250415555+0.518973181876j))*x_ref[1]**o + ((-0.299079824784-0.0575843368022j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(-0.798041138658+0.133619357837j)*x[0]**o + ((-0.105026409315+0.254994019992j))*x[0] + ((-0.502797745146-0.517638073483j))*x[1]**o + ((-0.588381174936+0.466134293012j))*x[1]
        ref[(1, 1, 0, 1)]=(-0.798041138658+0.133619357837j)*x_ref[0]**o + ((-0.105026409315+0.254994019992j))*x_ref[0] + ((-0.502797745146-0.517638073483j))*x_ref[1]**o + ((-0.588381174936+0.466134293012j))*x_ref[1]
        arg[(1, 1, 0, 2)]=(0.72637705708-0.535286448182j)*x[0]**o + ((-0.710062719373+0.207409227941j))*x[0] + ((0.90716228444+0.643171956084j))*x[1]**o + ((-0.257602865436-0.841866304983j))*x[1]
        ref[(1, 1, 0, 2)]=(0.72637705708-0.535286448182j)*x_ref[0]**o + ((-0.710062719373+0.207409227941j))*x_ref[0] + ((0.90716228444+0.643171956084j))*x_ref[1]**o + ((-0.257602865436-0.841866304983j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.550922821715+0.0177966024768j)*x[0]**o + ((-0.595801488735+0.17591712356j))*x[0] + ((-0.263275645676+0.369602272266j))*x[1]**o + ((-0.240417465803-0.69014661237j))*x[1]
        ref[(1, 1, 1, 0)]=(0.550922821715+0.0177966024768j)*x_ref[0]**o + ((-0.595801488735+0.17591712356j))*x_ref[0] + ((-0.263275645676+0.369602272266j))*x_ref[1]**o + ((-0.240417465803-0.69014661237j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(0.633632854523+0.964300530142j)*x[0]**o + ((0.963632854274+0.492594474153j))*x[0] + ((-0.745718630941+0.0319427326294j))*x[1]**o + ((-0.93918443234+0.635157960269j))*x[1]
        ref[(1, 1, 1, 1)]=(0.633632854523+0.964300530142j)*x_ref[0]**o + ((0.963632854274+0.492594474153j))*x_ref[0] + ((-0.745718630941+0.0319427326294j))*x_ref[1]**o + ((-0.93918443234+0.635157960269j))*x_ref[1]
        arg[(1, 1, 1, 2)]=(0.381804361556+0.831778260322j)*x[0]**o + ((-0.539996817403-0.678552707741j))*x[0] + ((-0.108275172294-0.992170259777j))*x[1]**o + ((0.880579417501+0.138561245853j))*x[1]
        ref[(1, 1, 1, 2)]=(0.381804361556+0.831778260322j)*x_ref[0]**o + ((-0.539996817403-0.678552707741j))*x_ref[0] + ((-0.108275172294-0.992170259777j))*x_ref[1]**o + ((0.880579417501+0.138561245853j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(0.609365499934-0.15212538089j)*x[0]**o + ((0.951596405855-0.086369493036j))*x[0] + ((0.00574270400004-0.477554134561j))*x[1]**o + ((-0.499231411225-0.110811603921j))*x[1]
        ref[(1, 1, 2, 0)]=(0.609365499934-0.15212538089j)*x_ref[0]**o + ((0.951596405855-0.086369493036j))*x_ref[0] + ((0.00574270400004-0.477554134561j))*x_ref[1]**o + ((-0.499231411225-0.110811603921j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(0.720144443767+0.441601996289j)*x[0]**o + ((-0.461166341839-0.165631551592j))*x[0] + ((-0.308006976004+0.360257906652j))*x[1]**o + ((-0.960587923529-0.510960294129j))*x[1]
        ref[(1, 1, 2, 1)]=(0.720144443767+0.441601996289j)*x_ref[0]**o + ((-0.461166341839-0.165631551592j))*x_ref[0] + ((-0.308006976004+0.360257906652j))*x_ref[1]**o + ((-0.960587923529-0.510960294129j))*x_ref[1]
        arg[(1, 1, 2, 2)]=(0.135640188052-0.952987018969j)*x[0]**o + ((0.927543638538+0.677711754746j))*x[0] + ((-0.140853405044-0.717469729225j))*x[1]**o + ((-0.820571013679-0.489291676156j))*x[1]
        ref[(1, 1, 2, 2)]=(0.135640188052-0.952987018969j)*x_ref[0]**o + ((0.927543638538+0.677711754746j))*x_ref[0] + ((-0.140853405044-0.717469729225j))*x_ref[1]**o + ((-0.820571013679-0.489291676156j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(0.684810500571+0.105478761377j)*x[0]**o + ((-0.659094899019+0.698299775421j))*x[0] + ((-0.708971578983+0.444287121541j))*x[1]**o + ((0.909352492878+0.968239167625j))*x[1]
        ref[(1, 2, 0, 0)]=(0.684810500571+0.105478761377j)*x_ref[0]**o + ((-0.659094899019+0.698299775421j))*x_ref[0] + ((-0.708971578983+0.444287121541j))*x_ref[1]**o + ((0.909352492878+0.968239167625j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(-0.506839832408-0.371130825106j)*x[0]**o + ((0.646802292781-0.1672065664j))*x[0] + ((0.592171296921+0.102635589084j))*x[1]**o + ((-0.342632889232-0.871365287612j))*x[1]
        ref[(1, 2, 0, 1)]=(-0.506839832408-0.371130825106j)*x_ref[0]**o + ((0.646802292781-0.1672065664j))*x_ref[0] + ((0.592171296921+0.102635589084j))*x_ref[1]**o + ((-0.342632889232-0.871365287612j))*x_ref[1]
        arg[(1, 2, 0, 2)]=(-0.392506495307-0.313856786184j)*x[0]**o + ((-0.551662501913-0.146160321224j))*x[0] + ((-0.794819726634+0.974146484655j))*x[1]**o + ((0.533220435397+0.372662412716j))*x[1]
        ref[(1, 2, 0, 2)]=(-0.392506495307-0.313856786184j)*x_ref[0]**o + ((-0.551662501913-0.146160321224j))*x_ref[0] + ((-0.794819726634+0.974146484655j))*x_ref[1]**o + ((0.533220435397+0.372662412716j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(-0.269978190445+0.859759193601j)*x[0]**o + ((0.16243269435+0.194980960228j))*x[0] + ((0.886695422699-0.177604535339j))*x[1]**o + ((0.913073860872+0.121813527113j))*x[1]
        ref[(1, 2, 1, 0)]=(-0.269978190445+0.859759193601j)*x_ref[0]**o + ((0.16243269435+0.194980960228j))*x_ref[0] + ((0.886695422699-0.177604535339j))*x_ref[1]**o + ((0.913073860872+0.121813527113j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(0.145276024054-0.104400584325j)*x[0]**o + ((0.397252376284-0.732120703523j))*x[0] + ((-0.811490797747+0.0363740849427j))*x[1]**o + ((0.613369421527-0.868945810769j))*x[1]
        ref[(1, 2, 1, 1)]=(0.145276024054-0.104400584325j)*x_ref[0]**o + ((0.397252376284-0.732120703523j))*x_ref[0] + ((-0.811490797747+0.0363740849427j))*x_ref[1]**o + ((0.613369421527-0.868945810769j))*x_ref[1]
        arg[(1, 2, 1, 2)]=(-0.0149583280119-0.288463343826j)*x[0]**o + ((-0.409637991566+0.0191039514848j))*x[0] + ((0.124489405528-0.246757030415j))*x[1]**o + ((-0.906775232637+0.0236280883647j))*x[1]
        ref[(1, 2, 1, 2)]=(-0.0149583280119-0.288463343826j)*x_ref[0]**o + ((-0.409637991566+0.0191039514848j))*x_ref[0] + ((0.124489405528-0.246757030415j))*x_ref[1]**o + ((-0.906775232637+0.0236280883647j))*x_ref[1]
        arg[(1, 2, 2, 0)]=(0.474009460155+0.0948810973702j)*x[0]**o + ((-0.397024374418-0.234216143436j))*x[0] + ((0.593703365552-0.823306613424j))*x[1]**o + ((-0.93931529251+0.390173631644j))*x[1]
        ref[(1, 2, 2, 0)]=(0.474009460155+0.0948810973702j)*x_ref[0]**o + ((-0.397024374418-0.234216143436j))*x_ref[0] + ((0.593703365552-0.823306613424j))*x_ref[1]**o + ((-0.93931529251+0.390173631644j))*x_ref[1]
        arg[(1, 2, 2, 1)]=(-0.863580864084+0.15573914845j)*x[0]**o + ((-0.281780613623-0.755401126274j))*x[0] + ((0.440014295331+0.205370413269j))*x[1]**o + ((0.457412644711+0.169836227829j))*x[1]
        ref[(1, 2, 2, 1)]=(-0.863580864084+0.15573914845j)*x_ref[0]**o + ((-0.281780613623-0.755401126274j))*x_ref[0] + ((0.440014295331+0.205370413269j))*x_ref[1]**o + ((0.457412644711+0.169836227829j))*x_ref[1]
        arg[(1, 2, 2, 2)]=(-0.658935071085+0.362450352165j)*x[0]**o + ((-0.94047640887-0.380927900895j))*x[0] + ((-0.374698841743-0.419756650222j))*x[1]**o + ((-0.629169930763-0.868220648023j))*x[1]
        ref[(1, 2, 2, 2)]=(-0.658935071085+0.362450352165j)*x_ref[0]**o + ((-0.94047640887-0.380927900895j))*x_ref[0] + ((-0.374698841743-0.419756650222j))*x_ref[1]**o + ((-0.629169930763-0.868220648023j))*x_ref[1]
        arg[(2, 0, 0, 0)]=(-0.94460742599-0.674288461354j)*x[0]**o + ((-0.611470484793-0.794247992932j))*x[0] + ((-0.137634186514-0.56885367593j))*x[1]**o + ((0.459410951401+0.341133750379j))*x[1]
        ref[(2, 0, 0, 0)]=(-0.94460742599-0.674288461354j)*x_ref[0]**o + ((-0.611470484793-0.794247992932j))*x_ref[0] + ((-0.137634186514-0.56885367593j))*x_ref[1]**o + ((0.459410951401+0.341133750379j))*x_ref[1]
        arg[(2, 0, 0, 1)]=(0.989964307578+0.218254432761j)*x[0]**o + ((-0.548016183373+0.936606879675j))*x[0] + ((-0.726765674008+0.43534822522j))*x[1]**o + ((-0.559928318227-0.969861335503j))*x[1]
        ref[(2, 0, 0, 1)]=(0.989964307578+0.218254432761j)*x_ref[0]**o + ((-0.548016183373+0.936606879675j))*x_ref[0] + ((-0.726765674008+0.43534822522j))*x_ref[1]**o + ((-0.559928318227-0.969861335503j))*x_ref[1]
        arg[(2, 0, 0, 2)]=(-0.0166775721056-0.634973256725j)*x[0]**o + ((-0.0970410700065+0.560746166995j))*x[0] + ((0.179135369161-0.161448819008j))*x[1]**o + ((-0.796572240854+0.5306671016j))*x[1]
        ref[(2, 0, 0, 2)]=(-0.0166775721056-0.634973256725j)*x_ref[0]**o + ((-0.0970410700065+0.560746166995j))*x_ref[0] + ((0.179135369161-0.161448819008j))*x_ref[1]**o + ((-0.796572240854+0.5306671016j))*x_ref[1]
        arg[(2, 0, 1, 0)]=(-0.1595247266-0.206123883619j)*x[0]**o + ((0.840836891872-0.96810466262j))*x[0] + ((-0.857577625909+0.975362717651j))*x[1]**o + ((0.760659610373+0.277578251439j))*x[1]
        ref[(2, 0, 1, 0)]=(-0.1595247266-0.206123883619j)*x_ref[0]**o + ((0.840836891872-0.96810466262j))*x_ref[0] + ((-0.857577625909+0.975362717651j))*x_ref[1]**o + ((0.760659610373+0.277578251439j))*x_ref[1]
        arg[(2, 0, 1, 1)]=(0.903319849966+0.337493059016j)*x[0]**o + ((-0.445274969973-0.605106909323j))*x[0] + ((-0.735905940037+0.206653255766j))*x[1]**o + ((-0.805673070834+0.828469658551j))*x[1]
        ref[(2, 0, 1, 1)]=(0.903319849966+0.337493059016j)*x_ref[0]**o + ((-0.445274969973-0.605106909323j))*x_ref[0] + ((-0.735905940037+0.206653255766j))*x_ref[1]**o + ((-0.805673070834+0.828469658551j))*x_ref[1]
        arg[(2, 0, 1, 2)]=(-0.0151868032948-0.368843809928j)*x[0]**o + ((-0.180923264156-0.990881492762j))*x[0] + ((-0.500368597781-0.302609401306j))*x[1]**o + ((0.319736367336+0.756320935598j))*x[1]
        ref[(2, 0, 1, 2)]=(-0.0151868032948-0.368843809928j)*x_ref[0]**o + ((-0.180923264156-0.990881492762j))*x_ref[0] + ((-0.500368597781-0.302609401306j))*x_ref[1]**o + ((0.319736367336+0.756320935598j))*x_ref[1]
        arg[(2, 0, 2, 0)]=(0.618981257789+0.659592059846j)*x[0]**o + ((-0.540934383969+0.501678145551j))*x[0] + ((-0.124163100895-0.260050668786j))*x[1]**o + ((-0.42979918326+0.312848967018j))*x[1]
        ref[(2, 0, 2, 0)]=(0.618981257789+0.659592059846j)*x_ref[0]**o + ((-0.540934383969+0.501678145551j))*x_ref[0] + ((-0.124163100895-0.260050668786j))*x_ref[1]**o + ((-0.42979918326+0.312848967018j))*x_ref[1]
        arg[(2, 0, 2, 1)]=(0.333305692825+0.760046717912j)*x[0]**o + ((-0.654814137665+0.561184020617j))*x[0] + ((-0.682967286341+0.980550290494j))*x[1]**o + ((0.752652999698-0.12644100558j))*x[1]
        ref[(2, 0, 2, 1)]=(0.333305692825+0.760046717912j)*x_ref[0]**o + ((-0.654814137665+0.561184020617j))*x_ref[0] + ((-0.682967286341+0.980550290494j))*x_ref[1]**o + ((0.752652999698-0.12644100558j))*x_ref[1]
        arg[(2, 0, 2, 2)]=(-0.261185283336+0.866829048867j)*x[0]**o + ((0.806530601551+0.0247859433332j))*x[0] + ((0.393231630786-0.502668196726j))*x[1]**o + ((-0.241772331351-0.207251570556j))*x[1]
        ref[(2, 0, 2, 2)]=(-0.261185283336+0.866829048867j)*x_ref[0]**o + ((0.806530601551+0.0247859433332j))*x_ref[0] + ((0.393231630786-0.502668196726j))*x_ref[1]**o + ((-0.241772331351-0.207251570556j))*x_ref[1]
        arg[(2, 1, 0, 0)]=(0.185293379108+0.649141464961j)*x[0]**o + ((-0.535564385609+0.348294635913j))*x[0] + ((0.290146692787-0.652435601919j))*x[1]**o + ((0.204891916136-0.961219149848j))*x[1]
        ref[(2, 1, 0, 0)]=(0.185293379108+0.649141464961j)*x_ref[0]**o + ((-0.535564385609+0.348294635913j))*x_ref[0] + ((0.290146692787-0.652435601919j))*x_ref[1]**o + ((0.204891916136-0.961219149848j))*x_ref[1]
        arg[(2, 1, 0, 1)]=(-0.606031905674+0.28059986212j)*x[0]**o + ((-0.112223777167-0.546061572988j))*x[0] + ((0.220484631912-0.289660797034j))*x[1]**o + ((-0.427776515532+0.744028790402j))*x[1]
        ref[(2, 1, 0, 1)]=(-0.606031905674+0.28059986212j)*x_ref[0]**o + ((-0.112223777167-0.546061572988j))*x_ref[0] + ((0.220484631912-0.289660797034j))*x_ref[1]**o + ((-0.427776515532+0.744028790402j))*x_ref[1]
        arg[(2, 1, 0, 2)]=(0.849601421931+0.0798848633512j)*x[0]**o + ((0.514365058968+0.935273817723j))*x[0] + ((0.0202307066661+0.99051428205j))*x[1]**o + ((0.119705092577-0.988473300918j))*x[1]
        ref[(2, 1, 0, 2)]=(0.849601421931+0.0798848633512j)*x_ref[0]**o + ((0.514365058968+0.935273817723j))*x_ref[0] + ((0.0202307066661+0.99051428205j))*x_ref[1]**o + ((0.119705092577-0.988473300918j))*x_ref[1]
        arg[(2, 1, 1, 0)]=(0.281711049671+0.328431904497j)*x[0]**o + ((-0.0593856205843+0.352462690458j))*x[0] + ((-0.952501981335+0.880227373503j))*x[1]**o + ((-0.749344101095+0.797444196229j))*x[1]
        ref[(2, 1, 1, 0)]=(0.281711049671+0.328431904497j)*x_ref[0]**o + ((-0.0593856205843+0.352462690458j))*x_ref[0] + ((-0.952501981335+0.880227373503j))*x_ref[1]**o + ((-0.749344101095+0.797444196229j))*x_ref[1]
        arg[(2, 1, 1, 1)]=(-0.774613190813-0.80410383806j)*x[0]**o + ((0.704467281691+0.927209617074j))*x[0] + ((0.343487597353-0.518775074099j))*x[1]**o + ((-0.186261558223-0.509654215231j))*x[1]
        ref[(2, 1, 1, 1)]=(-0.774613190813-0.80410383806j)*x_ref[0]**o + ((0.704467281691+0.927209617074j))*x_ref[0] + ((0.343487597353-0.518775074099j))*x_ref[1]**o + ((-0.186261558223-0.509654215231j))*x_ref[1]
        arg[(2, 1, 1, 2)]=(0.483771868833+0.959968268925j)*x[0]**o + ((0.406724040954-0.906811106546j))*x[0] + ((0.475857912395-0.278137031312j))*x[1]**o + ((-0.741364444162-0.805518697316j))*x[1]
        ref[(2, 1, 1, 2)]=(0.483771868833+0.959968268925j)*x_ref[0]**o + ((0.406724040954-0.906811106546j))*x_ref[0] + ((0.475857912395-0.278137031312j))*x_ref[1]**o + ((-0.741364444162-0.805518697316j))*x_ref[1]
        arg[(2, 1, 2, 0)]=(-0.47290464112-0.587621040078j)*x[0]**o + ((0.706976556076+0.29368759195j))*x[0] + ((-0.773890577631-0.530322819478j))*x[1]**o + ((-0.683796945878+0.466236271351j))*x[1]
        ref[(2, 1, 2, 0)]=(-0.47290464112-0.587621040078j)*x_ref[0]**o + ((0.706976556076+0.29368759195j))*x_ref[0] + ((-0.773890577631-0.530322819478j))*x_ref[1]**o + ((-0.683796945878+0.466236271351j))*x_ref[1]
        arg[(2, 1, 2, 1)]=(0.64974367663+0.775753084406j)*x[0]**o + ((0.877652064006+0.737811787771j))*x[0] + ((0.772602230957-0.308126809545j))*x[1]**o + ((0.278304928772+0.159387074968j))*x[1]
        ref[(2, 1, 2, 1)]=(0.64974367663+0.775753084406j)*x_ref[0]**o + ((0.877652064006+0.737811787771j))*x_ref[0] + ((0.772602230957-0.308126809545j))*x_ref[1]**o + ((0.278304928772+0.159387074968j))*x_ref[1]
        arg[(2, 1, 2, 2)]=(0.844774443019+0.929634715801j)*x[0]**o + ((-0.341079659949+0.692374772551j))*x[0] + ((0.0183077986093-0.902381906294j))*x[1]**o + ((-0.156921514459-0.966493029757j))*x[1]
        ref[(2, 1, 2, 2)]=(0.844774443019+0.929634715801j)*x_ref[0]**o + ((-0.341079659949+0.692374772551j))*x_ref[0] + ((0.0183077986093-0.902381906294j))*x_ref[1]**o + ((-0.156921514459-0.966493029757j))*x_ref[1]
        arg[(2, 2, 0, 0)]=(0.728381538206+0.449950254565j)*x[0]**o + ((-0.405015677314-0.139586299041j))*x[0] + ((0.448662850649+0.289932749478j))*x[1]**o + ((-0.422492447509+0.84068290559j))*x[1]
        ref[(2, 2, 0, 0)]=(0.728381538206+0.449950254565j)*x_ref[0]**o + ((-0.405015677314-0.139586299041j))*x_ref[0] + ((0.448662850649+0.289932749478j))*x_ref[1]**o + ((-0.422492447509+0.84068290559j))*x_ref[1]
        arg[(2, 2, 0, 1)]=(-0.270271116846+0.633018339944j)*x[0]**o + ((0.400725388829-0.481640297645j))*x[0] + ((0.865112148539+0.294714866248j))*x[1]**o + ((-0.410849785744-0.400288797676j))*x[1]
        ref[(2, 2, 0, 1)]=(-0.270271116846+0.633018339944j)*x_ref[0]**o + ((0.400725388829-0.481640297645j))*x_ref[0] + ((0.865112148539+0.294714866248j))*x_ref[1]**o + ((-0.410849785744-0.400288797676j))*x_ref[1]
        arg[(2, 2, 0, 2)]=(0.0558472153169-0.0535418805384j)*x[0]**o + ((0.855523078066+0.410089804372j))*x[0] + ((0.43827525166-0.315459011764j))*x[1]**o + ((0.441315855007-0.515102154001j))*x[1]
        ref[(2, 2, 0, 2)]=(0.0558472153169-0.0535418805384j)*x_ref[0]**o + ((0.855523078066+0.410089804372j))*x_ref[0] + ((0.43827525166-0.315459011764j))*x_ref[1]**o + ((0.441315855007-0.515102154001j))*x_ref[1]
        arg[(2, 2, 1, 0)]=(-0.138636334186-0.339211514686j)*x[0]**o + ((-0.154794127445-0.362894097109j))*x[0] + ((0.833750625031+0.222636844459j))*x[1]**o + ((0.326263547841+0.210623717585j))*x[1]
        ref[(2, 2, 1, 0)]=(-0.138636334186-0.339211514686j)*x_ref[0]**o + ((-0.154794127445-0.362894097109j))*x_ref[0] + ((0.833750625031+0.222636844459j))*x_ref[1]**o + ((0.326263547841+0.210623717585j))*x_ref[1]
        arg[(2, 2, 1, 1)]=(-0.690102771708-0.131842788483j)*x[0]**o + ((-0.656077658934-0.675936349527j))*x[0] + ((0.443775820471+0.328944102735j))*x[1]**o + ((0.738759024311-0.540520900611j))*x[1]
        ref[(2, 2, 1, 1)]=(-0.690102771708-0.131842788483j)*x_ref[0]**o + ((-0.656077658934-0.675936349527j))*x_ref[0] + ((0.443775820471+0.328944102735j))*x_ref[1]**o + ((0.738759024311-0.540520900611j))*x_ref[1]
        arg[(2, 2, 1, 2)]=(0.0728911648158-0.65931022005j)*x[0]**o + ((-0.196232959029-0.84144428115j))*x[0] + ((0.775688324524-0.625734866231j))*x[1]**o + ((0.562976971543-0.62422770679j))*x[1]
        ref[(2, 2, 1, 2)]=(0.0728911648158-0.65931022005j)*x_ref[0]**o + ((-0.196232959029-0.84144428115j))*x_ref[0] + ((0.775688324524-0.625734866231j))*x_ref[1]**o + ((0.562976971543-0.62422770679j))*x_ref[1]
        arg[(2, 2, 2, 0)]=(0.30027845402+0.615108229151j)*x[0]**o + ((-0.736338413656-0.18113730295j))*x[0] + ((0.983690331629-0.375179471685j))*x[1]**o + ((-0.70679025265+0.271454031909j))*x[1]
        ref[(2, 2, 2, 0)]=(0.30027845402+0.615108229151j)*x_ref[0]**o + ((-0.736338413656-0.18113730295j))*x_ref[0] + ((0.983690331629-0.375179471685j))*x_ref[1]**o + ((-0.70679025265+0.271454031909j))*x_ref[1]
        arg[(2, 2, 2, 1)]=(0.294251932932-0.204700916472j)*x[0]**o + ((-0.438238083386+0.206279290254j))*x[0] + ((0.77965009264-0.884336065573j))*x[1]**o + ((0.640752319748+0.865999032572j))*x[1]
        ref[(2, 2, 2, 1)]=(0.294251932932-0.204700916472j)*x_ref[0]**o + ((-0.438238083386+0.206279290254j))*x_ref[0] + ((0.77965009264-0.884336065573j))*x_ref[1]**o + ((0.640752319748+0.865999032572j))*x_ref[1]
        arg[(2, 2, 2, 2)]=(-0.60682740367+0.0860762883271j)*x[0]**o + ((0.0209850123249-0.941040375583j))*x[0] + ((0.565639770754-0.839967204851j))*x[1]**o + ((0.387544510367+0.501399136286j))*x[1]
        ref[(2, 2, 2, 2)]=(-0.60682740367+0.0860762883271j)*x_ref[0]**o + ((0.0209850123249-0.941040375583j))*x_ref[0] + ((0.565639770754-0.839967204851j))*x_ref[1]**o + ((0.387544510367+0.501399136286j))*x_ref[1]
        arg[(3, 0, 0, 0)]=(-0.63600748059-0.891693248684j)*x[0]**o + ((0.717402137615+0.342490677703j))*x[0] + ((-0.636654032686-0.458708410275j))*x[1]**o + ((0.946731495087+0.68193099948j))*x[1]
        ref[(3, 0, 0, 0)]=(-0.63600748059-0.891693248684j)*x_ref[0]**o + ((0.717402137615+0.342490677703j))*x_ref[0] + ((-0.636654032686-0.458708410275j))*x_ref[1]**o + ((0.946731495087+0.68193099948j))*x_ref[1]
        arg[(3, 0, 0, 1)]=(0.134195335958-0.0414603077563j)*x[0]**o + ((0.56007113598+0.332281595683j))*x[0] + ((0.298131112502+0.875245827918j))*x[1]**o + ((0.537942638023-0.100207622843j))*x[1]
        ref[(3, 0, 0, 1)]=(0.134195335958-0.0414603077563j)*x_ref[0]**o + ((0.56007113598+0.332281595683j))*x_ref[0] + ((0.298131112502+0.875245827918j))*x_ref[1]**o + ((0.537942638023-0.100207622843j))*x_ref[1]
        arg[(3, 0, 0, 2)]=(-0.724236893998+0.806350220505j)*x[0]**o + ((-0.538292284203-0.977627332263j))*x[0] + ((-0.18227603301-0.933117670903j))*x[1]**o + ((-0.584496831887+0.578611623032j))*x[1]
        ref[(3, 0, 0, 2)]=(-0.724236893998+0.806350220505j)*x_ref[0]**o + ((-0.538292284203-0.977627332263j))*x_ref[0] + ((-0.18227603301-0.933117670903j))*x_ref[1]**o + ((-0.584496831887+0.578611623032j))*x_ref[1]
        arg[(3, 0, 1, 0)]=(-0.922351900993-0.227442359567j)*x[0]**o + ((0.00484746901732+0.740304968245j))*x[0] + ((0.66025239115-0.0614752939566j))*x[1]**o + ((0.726606546723+0.539602883351j))*x[1]
        ref[(3, 0, 1, 0)]=(-0.922351900993-0.227442359567j)*x_ref[0]**o + ((0.00484746901732+0.740304968245j))*x_ref[0] + ((0.66025239115-0.0614752939566j))*x_ref[1]**o + ((0.726606546723+0.539602883351j))*x_ref[1]
        arg[(3, 0, 1, 1)]=(-0.587384631535+0.691224408311j)*x[0]**o + ((0.576769344496+0.429752648181j))*x[0] + ((0.264095764881+0.625529273368j))*x[1]**o + ((0.713249125971+0.784452389952j))*x[1]
        ref[(3, 0, 1, 1)]=(-0.587384631535+0.691224408311j)*x_ref[0]**o + ((0.576769344496+0.429752648181j))*x_ref[0] + ((0.264095764881+0.625529273368j))*x_ref[1]**o + ((0.713249125971+0.784452389952j))*x_ref[1]
        arg[(3, 0, 1, 2)]=(0.743033713991-0.91098389533j)*x[0]**o + ((-0.72945068046-0.315472715298j))*x[0] + ((0.583492793882+0.628686469423j))*x[1]**o + ((-0.234688472379+0.252865248601j))*x[1]
        ref[(3, 0, 1, 2)]=(0.743033713991-0.91098389533j)*x_ref[0]**o + ((-0.72945068046-0.315472715298j))*x_ref[0] + ((0.583492793882+0.628686469423j))*x_ref[1]**o + ((-0.234688472379+0.252865248601j))*x_ref[1]
        arg[(3, 0, 2, 0)]=(0.765080176215+0.75054040309j)*x[0]**o + ((0.165005455421-0.597815783655j))*x[0] + ((-0.418823627936-0.300504088066j))*x[1]**o + ((0.585736451036-0.890880360503j))*x[1]
        ref[(3, 0, 2, 0)]=(0.765080176215+0.75054040309j)*x_ref[0]**o + ((0.165005455421-0.597815783655j))*x_ref[0] + ((-0.418823627936-0.300504088066j))*x_ref[1]**o + ((0.585736451036-0.890880360503j))*x_ref[1]
        arg[(3, 0, 2, 1)]=(0.397148928381+0.552091018367j)*x[0]**o + ((0.346439336415-0.158875076351j))*x[0] + ((-0.288850616781-0.809988841915j))*x[1]**o + ((-0.676264428783+0.143855848447j))*x[1]
        ref[(3, 0, 2, 1)]=(0.397148928381+0.552091018367j)*x_ref[0]**o + ((0.346439336415-0.158875076351j))*x_ref[0] + ((-0.288850616781-0.809988841915j))*x_ref[1]**o + ((-0.676264428783+0.143855848447j))*x_ref[1]
        arg[(3, 0, 2, 2)]=(-0.74522544408+0.153355242222j)*x[0]**o + ((0.390968822473+0.379996411697j))*x[0] + ((-0.564683361115+0.76565775961j))*x[1]**o + ((0.523447291717+0.830139551324j))*x[1]
        ref[(3, 0, 2, 2)]=(-0.74522544408+0.153355242222j)*x_ref[0]**o + ((0.390968822473+0.379996411697j))*x_ref[0] + ((-0.564683361115+0.76565775961j))*x_ref[1]**o + ((0.523447291717+0.830139551324j))*x_ref[1]
        arg[(3, 1, 0, 0)]=(-0.166273012517+0.680850412272j)*x[0]**o + ((-0.0120702335245+0.849457419879j))*x[0] + ((0.219077974224-0.162461145709j))*x[1]**o + ((0.267382187742-0.705959844237j))*x[1]
        ref[(3, 1, 0, 0)]=(-0.166273012517+0.680850412272j)*x_ref[0]**o + ((-0.0120702335245+0.849457419879j))*x_ref[0] + ((0.219077974224-0.162461145709j))*x_ref[1]**o + ((0.267382187742-0.705959844237j))*x_ref[1]
        arg[(3, 1, 0, 1)]=(0.893011391637+0.825677749396j)*x[0]**o + ((-0.0238304966309-0.827885783038j))*x[0] + ((0.178584909959+0.95727247503j))*x[1]**o + ((0.0246529431075-0.986861195166j))*x[1]
        ref[(3, 1, 0, 1)]=(0.893011391637+0.825677749396j)*x_ref[0]**o + ((-0.0238304966309-0.827885783038j))*x_ref[0] + ((0.178584909959+0.95727247503j))*x_ref[1]**o + ((0.0246529431075-0.986861195166j))*x_ref[1]
        arg[(3, 1, 0, 2)]=(-0.194818960382-0.164105381639j)*x[0]**o + ((0.124348925454-0.738590953328j))*x[0] + ((0.945020315618-0.276995091468j))*x[1]**o + ((-0.970158174021-0.599625918456j))*x[1]
        ref[(3, 1, 0, 2)]=(-0.194818960382-0.164105381639j)*x_ref[0]**o + ((0.124348925454-0.738590953328j))*x_ref[0] + ((0.945020315618-0.276995091468j))*x_ref[1]**o + ((-0.970158174021-0.599625918456j))*x_ref[1]
        arg[(3, 1, 1, 0)]=(-0.515964300584-0.102683717306j)*x[0]**o + ((0.895007117781-0.434848948595j))*x[0] + ((0.494331734098-0.959380516379j))*x[1]**o + ((-0.810298376313-0.147545517012j))*x[1]
        ref[(3, 1, 1, 0)]=(-0.515964300584-0.102683717306j)*x_ref[0]**o + ((0.895007117781-0.434848948595j))*x_ref[0] + ((0.494331734098-0.959380516379j))*x_ref[1]**o + ((-0.810298376313-0.147545517012j))*x_ref[1]
        arg[(3, 1, 1, 1)]=(0.0495697693277+0.296478147198j)*x[0]**o + ((0.850750563783+0.955092124033j))*x[0] + ((0.325060069141+0.590023136741j))*x[1]**o + ((0.0781053793921+0.480405465036j))*x[1]
        ref[(3, 1, 1, 1)]=(0.0495697693277+0.296478147198j)*x_ref[0]**o + ((0.850750563783+0.955092124033j))*x_ref[0] + ((0.325060069141+0.590023136741j))*x_ref[1]**o + ((0.0781053793921+0.480405465036j))*x_ref[1]
        arg[(3, 1, 1, 2)]=(-0.942380665233+0.149540652715j)*x[0]**o + ((-0.83680533919-0.876449355218j))*x[0] + ((0.938622530665-0.503093259413j))*x[1]**o + ((0.745858743088-0.0182722607795j))*x[1]
        ref[(3, 1, 1, 2)]=(-0.942380665233+0.149540652715j)*x_ref[0]**o + ((-0.83680533919-0.876449355218j))*x_ref[0] + ((0.938622530665-0.503093259413j))*x_ref[1]**o + ((0.745858743088-0.0182722607795j))*x_ref[1]
        arg[(3, 1, 2, 0)]=(-0.105913656863+0.626316180947j)*x[0]**o + ((-0.850353423494-0.472480217477j))*x[0] + ((-0.173460175043-0.69359808763j))*x[1]**o + ((0.856054564607+0.798973471584j))*x[1]
        ref[(3, 1, 2, 0)]=(-0.105913656863+0.626316180947j)*x_ref[0]**o + ((-0.850353423494-0.472480217477j))*x_ref[0] + ((-0.173460175043-0.69359808763j))*x_ref[1]**o + ((0.856054564607+0.798973471584j))*x_ref[1]
        arg[(3, 1, 2, 1)]=(-0.901790712784+0.575944649964j)*x[0]**o + ((0.498977507312-0.22707875922j))*x[0] + ((0.262065136786+0.566730731149j))*x[1]**o + ((-0.487517082381-0.692499554385j))*x[1]
        ref[(3, 1, 2, 1)]=(-0.901790712784+0.575944649964j)*x_ref[0]**o + ((0.498977507312-0.22707875922j))*x_ref[0] + ((0.262065136786+0.566730731149j))*x_ref[1]**o + ((-0.487517082381-0.692499554385j))*x_ref[1]
        arg[(3, 1, 2, 2)]=(0.374340258227-0.365476937683j)*x[0]**o + ((-0.812782931259-0.370513661442j))*x[0] + ((0.0758838221474-0.51486712322j))*x[1]**o + ((-0.668313549017+0.462041977677j))*x[1]
        ref[(3, 1, 2, 2)]=(0.374340258227-0.365476937683j)*x_ref[0]**o + ((-0.812782931259-0.370513661442j))*x_ref[0] + ((0.0758838221474-0.51486712322j))*x_ref[1]**o + ((-0.668313549017+0.462041977677j))*x_ref[1]
        arg[(3, 2, 0, 0)]=(-0.517374482626-0.864167346669j)*x[0]**o + ((-0.83660748202+0.754315441345j))*x[0] + ((0.500658266329+0.692587541036j))*x[1]**o + ((0.980061035301+0.882385922317j))*x[1]
        ref[(3, 2, 0, 0)]=(-0.517374482626-0.864167346669j)*x_ref[0]**o + ((-0.83660748202+0.754315441345j))*x_ref[0] + ((0.500658266329+0.692587541036j))*x_ref[1]**o + ((0.980061035301+0.882385922317j))*x_ref[1]
        arg[(3, 2, 0, 1)]=(0.312152727908+0.900214082787j)*x[0]**o + ((0.975977360527+0.831184199741j))*x[0] + ((0.283517696121-0.836987553175j))*x[1]**o + ((-0.44917164541+0.263046133993j))*x[1]
        ref[(3, 2, 0, 1)]=(0.312152727908+0.900214082787j)*x_ref[0]**o + ((0.975977360527+0.831184199741j))*x_ref[0] + ((0.283517696121-0.836987553175j))*x_ref[1]**o + ((-0.44917164541+0.263046133993j))*x_ref[1]
        arg[(3, 2, 0, 2)]=(0.476528581893+0.769230799304j)*x[0]**o + ((0.237887787711-0.16330441602j))*x[0] + ((0.403269389241-0.558582151766j))*x[1]**o + ((-0.437466524692+0.186505022473j))*x[1]
        ref[(3, 2, 0, 2)]=(0.476528581893+0.769230799304j)*x_ref[0]**o + ((0.237887787711-0.16330441602j))*x_ref[0] + ((0.403269389241-0.558582151766j))*x_ref[1]**o + ((-0.437466524692+0.186505022473j))*x_ref[1]
        arg[(3, 2, 1, 0)]=(0.727774588308-0.980386088056j)*x[0]**o + ((-0.543535817468+0.0688694190941j))*x[0] + ((-0.044759504862-0.261662478406j))*x[1]**o + ((0.87387533582+0.816077783178j))*x[1]
        ref[(3, 2, 1, 0)]=(0.727774588308-0.980386088056j)*x_ref[0]**o + ((-0.543535817468+0.0688694190941j))*x_ref[0] + ((-0.044759504862-0.261662478406j))*x_ref[1]**o + ((0.87387533582+0.816077783178j))*x_ref[1]
        arg[(3, 2, 1, 1)]=(-0.499795195496+0.381778106607j)*x[0]**o + ((0.888769505957-0.10828451644j))*x[0] + ((0.644213327918+0.580880262982j))*x[1]**o + ((0.0936772835273+0.461854484017j))*x[1]
        ref[(3, 2, 1, 1)]=(-0.499795195496+0.381778106607j)*x_ref[0]**o + ((0.888769505957-0.10828451644j))*x_ref[0] + ((0.644213327918+0.580880262982j))*x_ref[1]**o + ((0.0936772835273+0.461854484017j))*x_ref[1]
        arg[(3, 2, 1, 2)]=(-0.700049931248+0.282670489574j)*x[0]**o + ((-0.818712604051-0.877104147048j))*x[0] + ((-0.209177841087-0.638591948585j))*x[1]**o + ((-0.816012824357+0.249958806924j))*x[1]
        ref[(3, 2, 1, 2)]=(-0.700049931248+0.282670489574j)*x_ref[0]**o + ((-0.818712604051-0.877104147048j))*x_ref[0] + ((-0.209177841087-0.638591948585j))*x_ref[1]**o + ((-0.816012824357+0.249958806924j))*x_ref[1]
        arg[(3, 2, 2, 0)]=(-0.616764832686-0.994739587859j)*x[0]**o + ((0.548933638739+0.0990305932699j))*x[0] + ((0.0750603452356+0.161495728769j))*x[1]**o + ((0.00454607017837-0.604714001401j))*x[1]
        ref[(3, 2, 2, 0)]=(-0.616764832686-0.994739587859j)*x_ref[0]**o + ((0.548933638739+0.0990305932699j))*x_ref[0] + ((0.0750603452356+0.161495728769j))*x_ref[1]**o + ((0.00454607017837-0.604714001401j))*x_ref[1]
        arg[(3, 2, 2, 1)]=(0.351277812698+0.807996962825j)*x[0]**o + ((0.293432753647-0.639101570296j))*x[0] + ((0.847610485875-0.184249420854j))*x[1]**o + ((0.735243327467+0.970542964153j))*x[1]
        ref[(3, 2, 2, 1)]=(0.351277812698+0.807996962825j)*x_ref[0]**o + ((0.293432753647-0.639101570296j))*x_ref[0] + ((0.847610485875-0.184249420854j))*x_ref[1]**o + ((0.735243327467+0.970542964153j))*x_ref[1]
        arg[(3, 2, 2, 2)]=(0.808685254354-0.566069273307j)*x[0]**o + ((-0.985073147507-0.150059858681j))*x[0] + ((-0.88583283125-0.922387257846j))*x[1]**o + ((-0.153658633927+0.994335011676j))*x[1]
        ref[(3, 2, 2, 2)]=(0.808685254354-0.566069273307j)*x_ref[0]**o + ((-0.985073147507-0.150059858681j))*x_ref[0] + ((-0.88583283125-0.922387257846j))*x_ref[1]**o + ((-0.153658633927+0.994335011676j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.670285049563+0.25282711999j)*x[2]**o + ((-0.970956125525-0.818411004394j))*x[2]
            ref[(0, 0, 0, 0)]+=(-0.670285049563+0.25282711999j)*x_ref[2]**o + ((-0.970956125525-0.818411004394j))*x_ref[2]
            arg[(0, 0, 0, 1)]+=(0.968988498784+0.825955575929j)*x[2]**o + ((0.691338407111-0.68599161857j))*x[2]
            ref[(0, 0, 0, 1)]+=(0.968988498784+0.825955575929j)*x_ref[2]**o + ((0.691338407111-0.68599161857j))*x_ref[2]
            arg[(0, 0, 0, 2)]+=(0.450485713846-0.653496204237j)*x[2]**o + ((-0.847785835606-0.369722343057j))*x[2]
            ref[(0, 0, 0, 2)]+=(0.450485713846-0.653496204237j)*x_ref[2]**o + ((-0.847785835606-0.369722343057j))*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.127634766279+0.434413652547j)*x[2]**o + ((-0.412880855381-0.0519884422404j))*x[2]
            ref[(0, 0, 1, 0)]+=(-0.127634766279+0.434413652547j)*x_ref[2]**o + ((-0.412880855381-0.0519884422404j))*x_ref[2]
            arg[(0, 0, 1, 1)]+=(0.534258568626-0.66468591408j)*x[2]**o + ((-0.105904436598+0.721482688879j))*x[2]
            ref[(0, 0, 1, 1)]+=(0.534258568626-0.66468591408j)*x_ref[2]**o + ((-0.105904436598+0.721482688879j))*x_ref[2]
            arg[(0, 0, 1, 2)]+=(0.168031997745+0.876672317353j)*x[2]**o + ((-0.370622784969-0.204035166477j))*x[2]
            ref[(0, 0, 1, 2)]+=(0.168031997745+0.876672317353j)*x_ref[2]**o + ((-0.370622784969-0.204035166477j))*x_ref[2]
            arg[(0, 0, 2, 0)]+=(-0.490762007628+0.0274109903295j)*x[2]**o + ((0.471338325981-0.51692901139j))*x[2]
            ref[(0, 0, 2, 0)]+=(-0.490762007628+0.0274109903295j)*x_ref[2]**o + ((0.471338325981-0.51692901139j))*x_ref[2]
            arg[(0, 0, 2, 1)]+=(0.516639201589+0.217438649785j)*x[2]**o + ((0.247321514047+0.503479990639j))*x[2]
            ref[(0, 0, 2, 1)]+=(0.516639201589+0.217438649785j)*x_ref[2]**o + ((0.247321514047+0.503479990639j))*x_ref[2]
            arg[(0, 0, 2, 2)]+=(0.609603998615+0.282872022261j)*x[2]**o + ((0.899067617491-0.26621499008j))*x[2]
            ref[(0, 0, 2, 2)]+=(0.609603998615+0.282872022261j)*x_ref[2]**o + ((0.899067617491-0.26621499008j))*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.0554941597603+0.550601641964j)*x[2]**o + ((0.243526656105+0.957735070453j))*x[2]
            ref[(0, 1, 0, 0)]+=(-0.0554941597603+0.550601641964j)*x_ref[2]**o + ((0.243526656105+0.957735070453j))*x_ref[2]
            arg[(0, 1, 0, 1)]+=(-0.502810542177+0.282940958222j)*x[2]**o + ((0.152960208+0.4217078156j))*x[2]
            ref[(0, 1, 0, 1)]+=(-0.502810542177+0.282940958222j)*x_ref[2]**o + ((0.152960208+0.4217078156j))*x_ref[2]
            arg[(0, 1, 0, 2)]+=(0.24910928249+0.247154780464j)*x[2]**o + ((0.0318604335598+0.025339184192j))*x[2]
            ref[(0, 1, 0, 2)]+=(0.24910928249+0.247154780464j)*x_ref[2]**o + ((0.0318604335598+0.025339184192j))*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.398723825595+0.126186647495j)*x[2]**o + ((-0.219834650843-0.769869560267j))*x[2]
            ref[(0, 1, 1, 0)]+=(-0.398723825595+0.126186647495j)*x_ref[2]**o + ((-0.219834650843-0.769869560267j))*x_ref[2]
            arg[(0, 1, 1, 1)]+=(-0.478720520751-0.0365175004477j)*x[2]**o + ((0.761890428422-0.461228190745j))*x[2]
            ref[(0, 1, 1, 1)]+=(-0.478720520751-0.0365175004477j)*x_ref[2]**o + ((0.761890428422-0.461228190745j))*x_ref[2]
            arg[(0, 1, 1, 2)]+=(-0.928269223498+0.141007467213j)*x[2]**o + ((-0.502268648429+0.416943602654j))*x[2]
            ref[(0, 1, 1, 2)]+=(-0.928269223498+0.141007467213j)*x_ref[2]**o + ((-0.502268648429+0.416943602654j))*x_ref[2]
            arg[(0, 1, 2, 0)]+=(-0.0245426545392+0.999781088275j)*x[2]**o + ((-0.478193336544-0.275296093256j))*x[2]
            ref[(0, 1, 2, 0)]+=(-0.0245426545392+0.999781088275j)*x_ref[2]**o + ((-0.478193336544-0.275296093256j))*x_ref[2]
            arg[(0, 1, 2, 1)]+=(0.0606339767294+0.507403478691j)*x[2]**o + ((-0.249611165395+0.71739182533j))*x[2]
            ref[(0, 1, 2, 1)]+=(0.0606339767294+0.507403478691j)*x_ref[2]**o + ((-0.249611165395+0.71739182533j))*x_ref[2]
            arg[(0, 1, 2, 2)]+=(-0.499740220888+0.718648947479j)*x[2]**o + ((-0.656927590995+0.909688408249j))*x[2]
            ref[(0, 1, 2, 2)]+=(-0.499740220888+0.718648947479j)*x_ref[2]**o + ((-0.656927590995+0.909688408249j))*x_ref[2]
            arg[(0, 2, 0, 0)]+=(-0.869016529628+0.982619414404j)*x[2]**o + ((0.304164555666-0.870374237351j))*x[2]
            ref[(0, 2, 0, 0)]+=(-0.869016529628+0.982619414404j)*x_ref[2]**o + ((0.304164555666-0.870374237351j))*x_ref[2]
            arg[(0, 2, 0, 1)]+=(0.990262999635+0.152176588846j)*x[2]**o + ((-0.980772944736-0.684162516457j))*x[2]
            ref[(0, 2, 0, 1)]+=(0.990262999635+0.152176588846j)*x_ref[2]**o + ((-0.980772944736-0.684162516457j))*x_ref[2]
            arg[(0, 2, 0, 2)]+=(0.596069666131+0.734636003863j)*x[2]**o + ((0.493770350363+0.242553479596j))*x[2]
            ref[(0, 2, 0, 2)]+=(0.596069666131+0.734636003863j)*x_ref[2]**o + ((0.493770350363+0.242553479596j))*x_ref[2]
            arg[(0, 2, 1, 0)]+=(-0.0364576283237+0.182828193474j)*x[2]**o + ((0.667363431456+0.8781394357j))*x[2]
            ref[(0, 2, 1, 0)]+=(-0.0364576283237+0.182828193474j)*x_ref[2]**o + ((0.667363431456+0.8781394357j))*x_ref[2]
            arg[(0, 2, 1, 1)]+=(-0.295438081906+0.80194213629j)*x[2]**o + ((0.265156689634+0.44457724579j))*x[2]
            ref[(0, 2, 1, 1)]+=(-0.295438081906+0.80194213629j)*x_ref[2]**o + ((0.265156689634+0.44457724579j))*x_ref[2]
            arg[(0, 2, 1, 2)]+=(0.384528847176-0.244164481076j)*x[2]**o + ((-0.0483225887312+0.0448129937726j))*x[2]
            ref[(0, 2, 1, 2)]+=(0.384528847176-0.244164481076j)*x_ref[2]**o + ((-0.0483225887312+0.0448129937726j))*x_ref[2]
            arg[(0, 2, 2, 0)]+=(0.193288319402-0.999144933996j)*x[2]**o + ((0.0310137757819-0.252817420448j))*x[2]
            ref[(0, 2, 2, 0)]+=(0.193288319402-0.999144933996j)*x_ref[2]**o + ((0.0310137757819-0.252817420448j))*x_ref[2]
            arg[(0, 2, 2, 1)]+=(-0.753992223313-0.0960828229152j)*x[2]**o + ((0.532449832331-0.535456978057j))*x[2]
            ref[(0, 2, 2, 1)]+=(-0.753992223313-0.0960828229152j)*x_ref[2]**o + ((0.532449832331-0.535456978057j))*x_ref[2]
            arg[(0, 2, 2, 2)]+=(-0.699204139255-0.680185783003j)*x[2]**o + ((0.911167755183+0.517711159008j))*x[2]
            ref[(0, 2, 2, 2)]+=(-0.699204139255-0.680185783003j)*x_ref[2]**o + ((0.911167755183+0.517711159008j))*x_ref[2]
            arg[(1, 0, 0, 0)]+=(0.643005391264+0.0225769657121j)*x[2]**o + ((-0.809275962778+0.753507158469j))*x[2]
            ref[(1, 0, 0, 0)]+=(0.643005391264+0.0225769657121j)*x_ref[2]**o + ((-0.809275962778+0.753507158469j))*x_ref[2]
            arg[(1, 0, 0, 1)]+=(-0.191614849156-0.556937735695j)*x[2]**o + ((0.671907619761-0.458646054946j))*x[2]
            ref[(1, 0, 0, 1)]+=(-0.191614849156-0.556937735695j)*x_ref[2]**o + ((0.671907619761-0.458646054946j))*x_ref[2]
            arg[(1, 0, 0, 2)]+=(-0.374626616181-0.386605492005j)*x[2]**o + ((-0.423553503401-0.325103730045j))*x[2]
            ref[(1, 0, 0, 2)]+=(-0.374626616181-0.386605492005j)*x_ref[2]**o + ((-0.423553503401-0.325103730045j))*x_ref[2]
            arg[(1, 0, 1, 0)]+=(0.663695703723-0.749128593817j)*x[2]**o + ((0.443307686224-0.524190780752j))*x[2]
            ref[(1, 0, 1, 0)]+=(0.663695703723-0.749128593817j)*x_ref[2]**o + ((0.443307686224-0.524190780752j))*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.364353454636-0.475831317645j)*x[2]**o + ((-0.0756045826433+0.177174602216j))*x[2]
            ref[(1, 0, 1, 1)]+=(0.364353454636-0.475831317645j)*x_ref[2]**o + ((-0.0756045826433+0.177174602216j))*x_ref[2]
            arg[(1, 0, 1, 2)]+=(-0.47824504395+0.819015580613j)*x[2]**o + ((-0.634918873694-0.982798708136j))*x[2]
            ref[(1, 0, 1, 2)]+=(-0.47824504395+0.819015580613j)*x_ref[2]**o + ((-0.634918873694-0.982798708136j))*x_ref[2]
            arg[(1, 0, 2, 0)]+=(0.291219146291-0.925783513426j)*x[2]**o + ((-0.404464269929-0.734763880583j))*x[2]
            ref[(1, 0, 2, 0)]+=(0.291219146291-0.925783513426j)*x_ref[2]**o + ((-0.404464269929-0.734763880583j))*x_ref[2]
            arg[(1, 0, 2, 1)]+=(-0.992336930017+0.096099065036j)*x[2]**o + ((-0.3776439325-0.561591145794j))*x[2]
            ref[(1, 0, 2, 1)]+=(-0.992336930017+0.096099065036j)*x_ref[2]**o + ((-0.3776439325-0.561591145794j))*x_ref[2]
            arg[(1, 0, 2, 2)]+=(-0.150107442176+0.858171970998j)*x[2]**o + ((-0.664869429383-0.485956087316j))*x[2]
            ref[(1, 0, 2, 2)]+=(-0.150107442176+0.858171970998j)*x_ref[2]**o + ((-0.664869429383-0.485956087316j))*x_ref[2]
            arg[(1, 1, 0, 0)]+=(0.108995263466+0.0526992490772j)*x[2]**o + ((-0.897303272985-0.553219209142j))*x[2]
            ref[(1, 1, 0, 0)]+=(0.108995263466+0.0526992490772j)*x_ref[2]**o + ((-0.897303272985-0.553219209142j))*x_ref[2]
            arg[(1, 1, 0, 1)]+=(-0.649487992578+0.530438656156j)*x[2]**o + ((-0.609582990999-0.329783804121j))*x[2]
            ref[(1, 1, 0, 1)]+=(-0.649487992578+0.530438656156j)*x_ref[2]**o + ((-0.609582990999-0.329783804121j))*x_ref[2]
            arg[(1, 1, 0, 2)]+=(0.746396156132-0.623063365842j)*x[2]**o + ((-0.439990725297+0.811176189254j))*x[2]
            ref[(1, 1, 0, 2)]+=(0.746396156132-0.623063365842j)*x_ref[2]**o + ((-0.439990725297+0.811176189254j))*x_ref[2]
            arg[(1, 1, 1, 0)]+=(-0.269971078669-0.810784880063j)*x[2]**o + ((0.799293052231-0.080968308673j))*x[2]
            ref[(1, 1, 1, 0)]+=(-0.269971078669-0.810784880063j)*x_ref[2]**o + ((0.799293052231-0.080968308673j))*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.880722552069+0.615840287665j)*x[2]**o + ((0.793715664241+0.643304589234j))*x[2]
            ref[(1, 1, 1, 1)]+=(-0.880722552069+0.615840287665j)*x_ref[2]**o + ((0.793715664241+0.643304589234j))*x_ref[2]
            arg[(1, 1, 1, 2)]+=(0.0255095785616-0.257612755841j)*x[2]**o + ((0.921452579326-0.600679764138j))*x[2]
            ref[(1, 1, 1, 2)]+=(0.0255095785616-0.257612755841j)*x_ref[2]**o + ((0.921452579326-0.600679764138j))*x_ref[2]
            arg[(1, 1, 2, 0)]+=(0.521124489595+0.741918094052j)*x[2]**o + ((0.480902174082+0.624988992321j))*x[2]
            ref[(1, 1, 2, 0)]+=(0.521124489595+0.741918094052j)*x_ref[2]**o + ((0.480902174082+0.624988992321j))*x_ref[2]
            arg[(1, 1, 2, 1)]+=(0.997102389284-0.668157096598j)*x[2]**o + ((0.00371286970162+0.912912076815j))*x[2]
            ref[(1, 1, 2, 1)]+=(0.997102389284-0.668157096598j)*x_ref[2]**o + ((0.00371286970162+0.912912076815j))*x_ref[2]
            arg[(1, 1, 2, 2)]+=(0.788645645212-0.652177931922j)*x[2]**o + ((-0.0361230669798-0.10125408631j))*x[2]
            ref[(1, 1, 2, 2)]+=(0.788645645212-0.652177931922j)*x_ref[2]**o + ((-0.0361230669798-0.10125408631j))*x_ref[2]
            arg[(1, 2, 0, 0)]+=(-0.324002230031-0.938395690453j)*x[2]**o + ((-0.0708818679636+0.591520729316j))*x[2]
            ref[(1, 2, 0, 0)]+=(-0.324002230031-0.938395690453j)*x_ref[2]**o + ((-0.0708818679636+0.591520729316j))*x_ref[2]
            arg[(1, 2, 0, 1)]+=(0.674303996456-0.718588682985j)*x[2]**o + ((0.703852149083+0.789183400395j))*x[2]
            ref[(1, 2, 0, 1)]+=(0.674303996456-0.718588682985j)*x_ref[2]**o + ((0.703852149083+0.789183400395j))*x_ref[2]
            arg[(1, 2, 0, 2)]+=(-0.227006746502-0.677289585788j)*x[2]**o + ((-0.526497763988+0.75948694298j))*x[2]
            ref[(1, 2, 0, 2)]+=(-0.227006746502-0.677289585788j)*x_ref[2]**o + ((-0.526497763988+0.75948694298j))*x_ref[2]
            arg[(1, 2, 1, 0)]+=(-0.268081376878+0.144279548007j)*x[2]**o + ((-0.432620738708+0.781988952814j))*x[2]
            ref[(1, 2, 1, 0)]+=(-0.268081376878+0.144279548007j)*x_ref[2]**o + ((-0.432620738708+0.781988952814j))*x_ref[2]
            arg[(1, 2, 1, 1)]+=(0.72102819997+0.530615895873j)*x[2]**o + ((-0.676693030273+0.448791831671j))*x[2]
            ref[(1, 2, 1, 1)]+=(0.72102819997+0.530615895873j)*x_ref[2]**o + ((-0.676693030273+0.448791831671j))*x_ref[2]
            arg[(1, 2, 1, 2)]+=(0.484446292123-0.722783466008j)*x[2]**o + ((-0.663920296386+0.175755089385j))*x[2]
            ref[(1, 2, 1, 2)]+=(0.484446292123-0.722783466008j)*x_ref[2]**o + ((-0.663920296386+0.175755089385j))*x_ref[2]
            arg[(1, 2, 2, 0)]+=(0.490280013041+0.083211476092j)*x[2]**o + ((0.237592789368-0.567677771157j))*x[2]
            ref[(1, 2, 2, 0)]+=(0.490280013041+0.083211476092j)*x_ref[2]**o + ((0.237592789368-0.567677771157j))*x_ref[2]
            arg[(1, 2, 2, 1)]+=(-0.908721758581-0.871611321522j)*x[2]**o + ((0.881718745922+0.30895412436j))*x[2]
            ref[(1, 2, 2, 1)]+=(-0.908721758581-0.871611321522j)*x_ref[2]**o + ((0.881718745922+0.30895412436j))*x_ref[2]
            arg[(1, 2, 2, 2)]+=(-0.0425373643036+0.198008095195j)*x[2]**o + ((-0.0107942920785+0.488722303988j))*x[2]
            ref[(1, 2, 2, 2)]+=(-0.0425373643036+0.198008095195j)*x_ref[2]**o + ((-0.0107942920785+0.488722303988j))*x_ref[2]
            arg[(2, 0, 0, 0)]+=(0.207666064979+0.523401606627j)*x[2]**o + ((-0.513919563348-0.597374166756j))*x[2]
            ref[(2, 0, 0, 0)]+=(0.207666064979+0.523401606627j)*x_ref[2]**o + ((-0.513919563348-0.597374166756j))*x_ref[2]
            arg[(2, 0, 0, 1)]+=(-0.733567791664+0.272176797959j)*x[2]**o + ((0.23026383113+0.198556126676j))*x[2]
            ref[(2, 0, 0, 1)]+=(-0.733567791664+0.272176797959j)*x_ref[2]**o + ((0.23026383113+0.198556126676j))*x_ref[2]
            arg[(2, 0, 0, 2)]+=(0.91937974494+0.319063207824j)*x[2]**o + ((0.416250875083-0.0999484454546j))*x[2]
            ref[(2, 0, 0, 2)]+=(0.91937974494+0.319063207824j)*x_ref[2]**o + ((0.416250875083-0.0999484454546j))*x_ref[2]
            arg[(2, 0, 1, 0)]+=(-0.262497147848-0.888389509878j)*x[2]**o + ((-0.114934450889-0.720689022438j))*x[2]
            ref[(2, 0, 1, 0)]+=(-0.262497147848-0.888389509878j)*x_ref[2]**o + ((-0.114934450889-0.720689022438j))*x_ref[2]
            arg[(2, 0, 1, 1)]+=(-0.350398903224-0.659093583866j)*x[2]**o + ((-0.0424387275662-0.0531216779511j))*x[2]
            ref[(2, 0, 1, 1)]+=(-0.350398903224-0.659093583866j)*x_ref[2]**o + ((-0.0424387275662-0.0531216779511j))*x_ref[2]
            arg[(2, 0, 1, 2)]+=(0.930788292712-0.114972472033j)*x[2]**o + ((-0.60856768709-0.974943426452j))*x[2]
            ref[(2, 0, 1, 2)]+=(0.930788292712-0.114972472033j)*x_ref[2]**o + ((-0.60856768709-0.974943426452j))*x_ref[2]
            arg[(2, 0, 2, 0)]+=(-0.963042143946-0.369977318065j)*x[2]**o + ((0.589361029177-0.70907611368j))*x[2]
            ref[(2, 0, 2, 0)]+=(-0.963042143946-0.369977318065j)*x_ref[2]**o + ((0.589361029177-0.70907611368j))*x_ref[2]
            arg[(2, 0, 2, 1)]+=(0.861811571029-0.16171385505j)*x[2]**o + ((-0.702166950408+0.49425149166j))*x[2]
            ref[(2, 0, 2, 1)]+=(0.861811571029-0.16171385505j)*x_ref[2]**o + ((-0.702166950408+0.49425149166j))*x_ref[2]
            arg[(2, 0, 2, 2)]+=(-0.267687877374-0.527255751557j)*x[2]**o + ((-0.920918147166-0.720039045966j))*x[2]
            ref[(2, 0, 2, 2)]+=(-0.267687877374-0.527255751557j)*x_ref[2]**o + ((-0.920918147166-0.720039045966j))*x_ref[2]
            arg[(2, 1, 0, 0)]+=(-0.0654836192184+0.648213228392j)*x[2]**o + ((-0.145366177023-0.171354252747j))*x[2]
            ref[(2, 1, 0, 0)]+=(-0.0654836192184+0.648213228392j)*x_ref[2]**o + ((-0.145366177023-0.171354252747j))*x_ref[2]
            arg[(2, 1, 0, 1)]+=(0.923630051733-0.0651548769877j)*x[2]**o + ((0.0927761521714-0.0013748785198j))*x[2]
            ref[(2, 1, 0, 1)]+=(0.923630051733-0.0651548769877j)*x_ref[2]**o + ((0.0927761521714-0.0013748785198j))*x_ref[2]
            arg[(2, 1, 0, 2)]+=(-0.638977826763+0.819215441846j)*x[2]**o + ((-0.34820199375-0.2394104193j))*x[2]
            ref[(2, 1, 0, 2)]+=(-0.638977826763+0.819215441846j)*x_ref[2]**o + ((-0.34820199375-0.2394104193j))*x_ref[2]
            arg[(2, 1, 1, 0)]+=(0.823268508888-0.0302814914981j)*x[2]**o + ((0.347861538993+0.74093401698j))*x[2]
            ref[(2, 1, 1, 0)]+=(0.823268508888-0.0302814914981j)*x_ref[2]**o + ((0.347861538993+0.74093401698j))*x_ref[2]
            arg[(2, 1, 1, 1)]+=(0.882194920188+0.323677160476j)*x[2]**o + ((0.984501762912+0.0356056363017j))*x[2]
            ref[(2, 1, 1, 1)]+=(0.882194920188+0.323677160476j)*x_ref[2]**o + ((0.984501762912+0.0356056363017j))*x_ref[2]
            arg[(2, 1, 1, 2)]+=(0.82401874056+0.639655166104j)*x[2]**o + ((0.626959985451+0.46957454641j))*x[2]
            ref[(2, 1, 1, 2)]+=(0.82401874056+0.639655166104j)*x_ref[2]**o + ((0.626959985451+0.46957454641j))*x_ref[2]
            arg[(2, 1, 2, 0)]+=(-0.474180132913-0.0620794518784j)*x[2]**o + ((0.107348044717+0.541115494835j))*x[2]
            ref[(2, 1, 2, 0)]+=(-0.474180132913-0.0620794518784j)*x_ref[2]**o + ((0.107348044717+0.541115494835j))*x_ref[2]
            arg[(2, 1, 2, 1)]+=(0.1624969548-0.319848432576j)*x[2]**o + ((-0.54886632025+0.35102707581j))*x[2]
            ref[(2, 1, 2, 1)]+=(0.1624969548-0.319848432576j)*x_ref[2]**o + ((-0.54886632025+0.35102707581j))*x_ref[2]
            arg[(2, 1, 2, 2)]+=(0.327217382061+0.960931596899j)*x[2]**o + ((-0.521288529061+0.52591403662j))*x[2]
            ref[(2, 1, 2, 2)]+=(0.327217382061+0.960931596899j)*x_ref[2]**o + ((-0.521288529061+0.52591403662j))*x_ref[2]
            arg[(2, 2, 0, 0)]+=(0.911784584234+0.234830955623j)*x[2]**o + ((0.113263858623+0.198746428209j))*x[2]
            ref[(2, 2, 0, 0)]+=(0.911784584234+0.234830955623j)*x_ref[2]**o + ((0.113263858623+0.198746428209j))*x_ref[2]
            arg[(2, 2, 0, 1)]+=(-0.426826730638+0.420619448485j)*x[2]**o + ((-0.243616205775-0.835707428763j))*x[2]
            ref[(2, 2, 0, 1)]+=(-0.426826730638+0.420619448485j)*x_ref[2]**o + ((-0.243616205775-0.835707428763j))*x_ref[2]
            arg[(2, 2, 0, 2)]+=(-0.506299000445-0.227923834821j)*x[2]**o + ((-0.087587791637+0.74742874032j))*x[2]
            ref[(2, 2, 0, 2)]+=(-0.506299000445-0.227923834821j)*x_ref[2]**o + ((-0.087587791637+0.74742874032j))*x_ref[2]
            arg[(2, 2, 1, 0)]+=(0.908533286664+0.992581176385j)*x[2]**o + ((0.484116552133+0.86325053016j))*x[2]
            ref[(2, 2, 1, 0)]+=(0.908533286664+0.992581176385j)*x_ref[2]**o + ((0.484116552133+0.86325053016j))*x_ref[2]
            arg[(2, 2, 1, 1)]+=(0.510056669342+0.470370381283j)*x[2]**o + ((-0.0112477851649+0.166043359152j))*x[2]
            ref[(2, 2, 1, 1)]+=(0.510056669342+0.470370381283j)*x_ref[2]**o + ((-0.0112477851649+0.166043359152j))*x_ref[2]
            arg[(2, 2, 1, 2)]+=(0.535006227747+0.253468066055j)*x[2]**o + ((0.457491079753-0.303826276193j))*x[2]
            ref[(2, 2, 1, 2)]+=(0.535006227747+0.253468066055j)*x_ref[2]**o + ((0.457491079753-0.303826276193j))*x_ref[2]
            arg[(2, 2, 2, 0)]+=(0.903820033453-0.128324484046j)*x[2]**o + ((0.0910931322368-0.551290377988j))*x[2]
            ref[(2, 2, 2, 0)]+=(0.903820033453-0.128324484046j)*x_ref[2]**o + ((0.0910931322368-0.551290377988j))*x_ref[2]
            arg[(2, 2, 2, 1)]+=(0.267425972106+0.135212443943j)*x[2]**o + ((-0.37996814581-0.577622752547j))*x[2]
            ref[(2, 2, 2, 1)]+=(0.267425972106+0.135212443943j)*x_ref[2]**o + ((-0.37996814581-0.577622752547j))*x_ref[2]
            arg[(2, 2, 2, 2)]+=(-0.218665986582+0.140328422362j)*x[2]**o + ((0.0696037318567+0.872078799477j))*x[2]
            ref[(2, 2, 2, 2)]+=(-0.218665986582+0.140328422362j)*x_ref[2]**o + ((0.0696037318567+0.872078799477j))*x_ref[2]
            arg[(3, 0, 0, 0)]+=(-0.383488529829-0.560570344736j)*x[2]**o + ((0.660742890959+0.193455291241j))*x[2]
            ref[(3, 0, 0, 0)]+=(-0.383488529829-0.560570344736j)*x_ref[2]**o + ((0.660742890959+0.193455291241j))*x_ref[2]
            arg[(3, 0, 0, 1)]+=(0.942228676562+0.738058217624j)*x[2]**o + ((0.525699634306+0.769590977876j))*x[2]
            ref[(3, 0, 0, 1)]+=(0.942228676562+0.738058217624j)*x_ref[2]**o + ((0.525699634306+0.769590977876j))*x_ref[2]
            arg[(3, 0, 0, 2)]+=(-0.554309880133+0.312020771101j)*x[2]**o + ((-0.269697573118-0.848393038327j))*x[2]
            ref[(3, 0, 0, 2)]+=(-0.554309880133+0.312020771101j)*x_ref[2]**o + ((-0.269697573118-0.848393038327j))*x_ref[2]
            arg[(3, 0, 1, 0)]+=(0.837207995053+0.503449070629j)*x[2]**o + ((-0.397596429937-0.98332150567j))*x[2]
            ref[(3, 0, 1, 0)]+=(0.837207995053+0.503449070629j)*x_ref[2]**o + ((-0.397596429937-0.98332150567j))*x_ref[2]
            arg[(3, 0, 1, 1)]+=(0.425325591978-0.893720402511j)*x[2]**o + ((-0.611721694719-0.823101617982j))*x[2]
            ref[(3, 0, 1, 1)]+=(0.425325591978-0.893720402511j)*x_ref[2]**o + ((-0.611721694719-0.823101617982j))*x_ref[2]
            arg[(3, 0, 1, 2)]+=(-0.0193617118246+0.831998574802j)*x[2]**o + ((-0.333759189853-0.719406715928j))*x[2]
            ref[(3, 0, 1, 2)]+=(-0.0193617118246+0.831998574802j)*x_ref[2]**o + ((-0.333759189853-0.719406715928j))*x_ref[2]
            arg[(3, 0, 2, 0)]+=(-0.735045591286-0.333954991639j)*x[2]**o + ((-0.280813326288+0.686079656707j))*x[2]
            ref[(3, 0, 2, 0)]+=(-0.735045591286-0.333954991639j)*x_ref[2]**o + ((-0.280813326288+0.686079656707j))*x_ref[2]
            arg[(3, 0, 2, 1)]+=(-0.354984939224+0.795289530555j)*x[2]**o + ((0.309542451801-0.458424438603j))*x[2]
            ref[(3, 0, 2, 1)]+=(-0.354984939224+0.795289530555j)*x_ref[2]**o + ((0.309542451801-0.458424438603j))*x_ref[2]
            arg[(3, 0, 2, 2)]+=(0.0756848216177-0.154031796896j)*x[2]**o + ((0.914162373032+0.415761671233j))*x[2]
            ref[(3, 0, 2, 2)]+=(0.0756848216177-0.154031796896j)*x_ref[2]**o + ((0.914162373032+0.415761671233j))*x_ref[2]
            arg[(3, 1, 0, 0)]+=(0.429883013068-0.537035447607j)*x[2]**o + ((0.818405947214+0.0875308096098j))*x[2]
            ref[(3, 1, 0, 0)]+=(0.429883013068-0.537035447607j)*x_ref[2]**o + ((0.818405947214+0.0875308096098j))*x_ref[2]
            arg[(3, 1, 0, 1)]+=(0.757743815805+0.856048504991j)*x[2]**o + ((-0.543343345172-0.303032295272j))*x[2]
            ref[(3, 1, 0, 1)]+=(0.757743815805+0.856048504991j)*x_ref[2]**o + ((-0.543343345172-0.303032295272j))*x_ref[2]
            arg[(3, 1, 0, 2)]+=(-0.378864656579+0.731059145425j)*x[2]**o + ((0.188816602533+0.00772482525756j))*x[2]
            ref[(3, 1, 0, 2)]+=(-0.378864656579+0.731059145425j)*x_ref[2]**o + ((0.188816602533+0.00772482525756j))*x_ref[2]
            arg[(3, 1, 1, 0)]+=(0.191969513463+0.46594633578j)*x[2]**o + ((0.760403382555+0.419422247328j))*x[2]
            ref[(3, 1, 1, 0)]+=(0.191969513463+0.46594633578j)*x_ref[2]**o + ((0.760403382555+0.419422247328j))*x_ref[2]
            arg[(3, 1, 1, 1)]+=(0.404243692852+0.15664548668j)*x[2]**o + ((-0.290404242702+0.0160603421058j))*x[2]
            ref[(3, 1, 1, 1)]+=(0.404243692852+0.15664548668j)*x_ref[2]**o + ((-0.290404242702+0.0160603421058j))*x_ref[2]
            arg[(3, 1, 1, 2)]+=(-0.0324088774525-0.135075267378j)*x[2]**o + ((-0.601075383927+0.11939330733j))*x[2]
            ref[(3, 1, 1, 2)]+=(-0.0324088774525-0.135075267378j)*x_ref[2]**o + ((-0.601075383927+0.11939330733j))*x_ref[2]
            arg[(3, 1, 2, 0)]+=(-0.897824611024-0.125819994468j)*x[2]**o + ((0.0883149219254+0.745771677769j))*x[2]
            ref[(3, 1, 2, 0)]+=(-0.897824611024-0.125819994468j)*x_ref[2]**o + ((0.0883149219254+0.745771677769j))*x_ref[2]
            arg[(3, 1, 2, 1)]+=(-0.282547264587+0.241044066897j)*x[2]**o + ((-0.163310450439-0.614392484717j))*x[2]
            ref[(3, 1, 2, 1)]+=(-0.282547264587+0.241044066897j)*x_ref[2]**o + ((-0.163310450439-0.614392484717j))*x_ref[2]
            arg[(3, 1, 2, 2)]+=(-0.387951053527+0.809228396636j)*x[2]**o + ((-0.862582792237+0.415437418747j))*x[2]
            ref[(3, 1, 2, 2)]+=(-0.387951053527+0.809228396636j)*x_ref[2]**o + ((-0.862582792237+0.415437418747j))*x_ref[2]
            arg[(3, 2, 0, 0)]+=(0.0661666708646+0.494449742172j)*x[2]**o + ((-0.849815106082+0.945214706856j))*x[2]
            ref[(3, 2, 0, 0)]+=(0.0661666708646+0.494449742172j)*x_ref[2]**o + ((-0.849815106082+0.945214706856j))*x_ref[2]
            arg[(3, 2, 0, 1)]+=(0.875086064809+0.447380582963j)*x[2]**o + ((-0.78024061437+0.382686889192j))*x[2]
            ref[(3, 2, 0, 1)]+=(0.875086064809+0.447380582963j)*x_ref[2]**o + ((-0.78024061437+0.382686889192j))*x_ref[2]
            arg[(3, 2, 0, 2)]+=(0.190740721306+0.605314824669j)*x[2]**o + ((0.794298397109-0.759658599863j))*x[2]
            ref[(3, 2, 0, 2)]+=(0.190740721306+0.605314824669j)*x_ref[2]**o + ((0.794298397109-0.759658599863j))*x_ref[2]
            arg[(3, 2, 1, 0)]+=(-0.315046410125+0.17515741064j)*x[2]**o + ((0.200456399816+0.778314054372j))*x[2]
            ref[(3, 2, 1, 0)]+=(-0.315046410125+0.17515741064j)*x_ref[2]**o + ((0.200456399816+0.778314054372j))*x_ref[2]
            arg[(3, 2, 1, 1)]+=(0.709584126457-0.0822550886876j)*x[2]**o + ((-0.399790738427+0.692460947767j))*x[2]
            ref[(3, 2, 1, 1)]+=(0.709584126457-0.0822550886876j)*x_ref[2]**o + ((-0.399790738427+0.692460947767j))*x_ref[2]
            arg[(3, 2, 1, 2)]+=(-0.632087359308+0.857408467842j)*x[2]**o + ((0.67414371329-0.553715551222j))*x[2]
            ref[(3, 2, 1, 2)]+=(-0.632087359308+0.857408467842j)*x_ref[2]**o + ((0.67414371329-0.553715551222j))*x_ref[2]
            arg[(3, 2, 2, 0)]+=(0.6631556733-0.662483564872j)*x[2]**o + ((-0.18284389108-0.300032305427j))*x[2]
            ref[(3, 2, 2, 0)]+=(0.6631556733-0.662483564872j)*x_ref[2]**o + ((-0.18284389108-0.300032305427j))*x_ref[2]
            arg[(3, 2, 2, 1)]+=(0.480817494631-0.947194123146j)*x[2]**o + ((0.685916885248+0.359126589244j))*x[2]
            ref[(3, 2, 2, 1)]+=(0.480817494631-0.947194123146j)*x_ref[2]**o + ((0.685916885248+0.359126589244j))*x_ref[2]
            arg[(3, 2, 2, 2)]+=(0.269260162948-0.274621051646j)*x[2]**o + ((0.972924971752-0.681385951287j))*x[2]
            ref[(3, 2, 2, 2)]+=(0.269260162948-0.274621051646j)*x_ref[2]**o + ((0.972924971752-0.681385951287j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3, 3, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ContinuousFunction_rank0(self):
        """
        tests interpolation of rank 0 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(0.817235632077-0.532113653868j)*x[0]**o + ((0.764419074553+0.704228525794j))*x[0] + ((-0.804499995277-0.0301574436062j))*x[1]**o + ((-0.0391448633172+0.747608205218j))*x[1]
        ref=(0.817235632077-0.532113653868j)*x_ref[0]**o + ((0.764419074553+0.704228525794j))*x_ref[0] + ((-0.804499995277-0.0301574436062j))*x_ref[1]**o + ((-0.0391448633172+0.747608205218j))*x_ref[1]
        if dim==3:
            arg+=((-0.573105080146-0.738213208121j))*x[2]**o + ((-0.952948825623+0.557485859702j))*x[2]
            ref+=((-0.573105080146-0.738213208121j))*x_ref[2]**o + ((-0.952948825623+0.557485859702j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ContinuousFunction_rank1(self):
        """
        tests interpolation of rank 1 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,),w_ref)
        arg[(0,)]=(0.92877651718+0.262625835396j)*x[0]**o + ((-0.151335231812+0.484474444543j))*x[0] + ((0.183373901825-0.279287695125j))*x[1]**o + ((0.876984494581+0.201872366911j))*x[1]
        ref[(0,)]=(0.92877651718+0.262625835396j)*x_ref[0]**o + ((-0.151335231812+0.484474444543j))*x_ref[0] + ((0.183373901825-0.279287695125j))*x_ref[1]**o + ((0.876984494581+0.201872366911j))*x_ref[1]
        arg[(1,)]=(-0.520234786413-0.580756930442j)*x[0]**o + ((-0.197777966939+0.36971637714j))*x[0] + ((-0.142968729725+0.740370488132j))*x[1]**o + ((-0.947041473575+0.798696456769j))*x[1]
        ref[(1,)]=(-0.520234786413-0.580756930442j)*x_ref[0]**o + ((-0.197777966939+0.36971637714j))*x_ref[0] + ((-0.142968729725+0.740370488132j))*x_ref[1]**o + ((-0.947041473575+0.798696456769j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.162283114199-0.451030020809j)*x[2]**o + ((-0.109595157417-0.5761033316j))*x[2]
            ref[(0,)]+=(-0.162283114199-0.451030020809j)*x_ref[2]**o + ((-0.109595157417-0.5761033316j))*x_ref[2]
            arg[(1,)]+=(0.0109892286808-0.75036630282j)*x[2]**o + ((0.240511738222+0.815198152284j))*x[2]
            ref[(1,)]+=(0.0109892286808-0.75036630282j)*x_ref[2]**o + ((0.240511738222+0.815198152284j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ContinuousFunction_rank2(self):
        """
        tests interpolation of rank 2 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4),w_ref)
        arg[(0, 0)]=(0.351280447079+0.730837543053j)*x[0]**o + ((0.441323797464-0.515033081961j))*x[0] + ((0.172418844582-0.210643154801j))*x[1]**o + ((0.186996289825+0.573209711449j))*x[1]
        ref[(0, 0)]=(0.351280447079+0.730837543053j)*x_ref[0]**o + ((0.441323797464-0.515033081961j))*x_ref[0] + ((0.172418844582-0.210643154801j))*x_ref[1]**o + ((0.186996289825+0.573209711449j))*x_ref[1]
        arg[(0, 1)]=(0.126066130907+0.411724546321j)*x[0]**o + ((-0.265756238339-0.0591405721722j))*x[0] + ((-0.292869332576+0.402943797635j))*x[1]**o + ((0.299865367978+0.123299626686j))*x[1]
        ref[(0, 1)]=(0.126066130907+0.411724546321j)*x_ref[0]**o + ((-0.265756238339-0.0591405721722j))*x_ref[0] + ((-0.292869332576+0.402943797635j))*x_ref[1]**o + ((0.299865367978+0.123299626686j))*x_ref[1]
        arg[(0, 2)]=(-0.463342184611+0.487449318218j)*x[0]**o + ((-0.848805657421+0.535125083096j))*x[0] + ((0.68437000068+0.355810391567j))*x[1]**o + ((-0.350832055454-0.703898470131j))*x[1]
        ref[(0, 2)]=(-0.463342184611+0.487449318218j)*x_ref[0]**o + ((-0.848805657421+0.535125083096j))*x_ref[0] + ((0.68437000068+0.355810391567j))*x_ref[1]**o + ((-0.350832055454-0.703898470131j))*x_ref[1]
        arg[(0, 3)]=(-0.604767140621-0.860135133721j)*x[0]**o + ((-0.316745297392+0.927286336346j))*x[0] + ((0.29073861697-0.583907012394j))*x[1]**o + ((-0.229274273364-0.888665299865j))*x[1]
        ref[(0, 3)]=(-0.604767140621-0.860135133721j)*x_ref[0]**o + ((-0.316745297392+0.927286336346j))*x_ref[0] + ((0.29073861697-0.583907012394j))*x_ref[1]**o + ((-0.229274273364-0.888665299865j))*x_ref[1]
        arg[(1, 0)]=(0.418696405359-0.74971544437j)*x[0]**o + ((-0.0057422252615-0.760861457753j))*x[0] + ((0.991620077383+0.935815186014j))*x[1]**o + ((0.0384767230899-0.716659040883j))*x[1]
        ref[(1, 0)]=(0.418696405359-0.74971544437j)*x_ref[0]**o + ((-0.0057422252615-0.760861457753j))*x_ref[0] + ((0.991620077383+0.935815186014j))*x_ref[1]**o + ((0.0384767230899-0.716659040883j))*x_ref[1]
        arg[(1, 1)]=(-0.360811965986-0.240574314173j)*x[0]**o + ((-0.766907245989-0.93090471591j))*x[0] + ((-0.685986226902-0.924759569246j))*x[1]**o + ((0.270695179298-0.42570466724j))*x[1]
        ref[(1, 1)]=(-0.360811965986-0.240574314173j)*x_ref[0]**o + ((-0.766907245989-0.93090471591j))*x_ref[0] + ((-0.685986226902-0.924759569246j))*x_ref[1]**o + ((0.270695179298-0.42570466724j))*x_ref[1]
        arg[(1, 2)]=(-0.230056970056+0.789599184441j)*x[0]**o + ((0.0223919511599-0.444863874323j))*x[0] + ((0.578379570127+0.871060849907j))*x[1]**o + ((-0.296952152303+0.868765174861j))*x[1]
        ref[(1, 2)]=(-0.230056970056+0.789599184441j)*x_ref[0]**o + ((0.0223919511599-0.444863874323j))*x_ref[0] + ((0.578379570127+0.871060849907j))*x_ref[1]**o + ((-0.296952152303+0.868765174861j))*x_ref[1]
        arg[(1, 3)]=(0.402207308455+0.9417548216j)*x[0]**o + ((0.506232867384+0.0373492809515j))*x[0] + ((0.110370351448-0.40286315007j))*x[1]**o + ((-0.200769404179+0.447437064038j))*x[1]
        ref[(1, 3)]=(0.402207308455+0.9417548216j)*x_ref[0]**o + ((0.506232867384+0.0373492809515j))*x_ref[0] + ((0.110370351448-0.40286315007j))*x_ref[1]**o + ((-0.200769404179+0.447437064038j))*x_ref[1]
        arg[(2, 0)]=(-0.6286777138-0.573627119201j)*x[0]**o + ((0.00128221564329+0.496171840306j))*x[0] + ((0.895838753163+0.752222544649j))*x[1]**o + ((0.933356796816+0.331783822549j))*x[1]
        ref[(2, 0)]=(-0.6286777138-0.573627119201j)*x_ref[0]**o + ((0.00128221564329+0.496171840306j))*x_ref[0] + ((0.895838753163+0.752222544649j))*x_ref[1]**o + ((0.933356796816+0.331783822549j))*x_ref[1]
        arg[(2, 1)]=(0.169205313189-0.849331487038j)*x[0]**o + ((-0.875205481969-0.828197180912j))*x[0] + ((-0.557632732032+0.897611985355j))*x[1]**o + ((-0.423039022213+0.548287062101j))*x[1]
        ref[(2, 1)]=(0.169205313189-0.849331487038j)*x_ref[0]**o + ((-0.875205481969-0.828197180912j))*x_ref[0] + ((-0.557632732032+0.897611985355j))*x_ref[1]**o + ((-0.423039022213+0.548287062101j))*x_ref[1]
        arg[(2, 2)]=(0.0275973375457+0.858288766512j)*x[0]**o + ((0.205182037699+0.770939298695j))*x[0] + ((-0.949821925185+0.0208305960572j))*x[1]**o + ((-0.164643585235+0.451612423642j))*x[1]
        ref[(2, 2)]=(0.0275973375457+0.858288766512j)*x_ref[0]**o + ((0.205182037699+0.770939298695j))*x_ref[0] + ((-0.949821925185+0.0208305960572j))*x_ref[1]**o + ((-0.164643585235+0.451612423642j))*x_ref[1]
        arg[(2, 3)]=(0.627162614275+0.254159432562j)*x[0]**o + ((0.875687691198-0.0970897942673j))*x[0] + ((-0.150754316096+0.529171195639j))*x[1]**o + ((0.370784742543-0.897010163531j))*x[1]
        ref[(2, 3)]=(0.627162614275+0.254159432562j)*x_ref[0]**o + ((0.875687691198-0.0970897942673j))*x_ref[0] + ((-0.150754316096+0.529171195639j))*x_ref[1]**o + ((0.370784742543-0.897010163531j))*x_ref[1]
        arg[(3, 0)]=(-0.0750415958677-0.383750203528j)*x[0]**o + ((0.417623467277+0.267428961489j))*x[0] + ((0.527661237109-0.287076250577j))*x[1]**o + ((0.418246138568+0.553719421591j))*x[1]
        ref[(3, 0)]=(-0.0750415958677-0.383750203528j)*x_ref[0]**o + ((0.417623467277+0.267428961489j))*x_ref[0] + ((0.527661237109-0.287076250577j))*x_ref[1]**o + ((0.418246138568+0.553719421591j))*x_ref[1]
        arg[(3, 1)]=(-0.332627651459-0.349325184866j)*x[0]**o + ((-0.275524638875+0.679422635592j))*x[0] + ((-0.674786962439-0.118139279292j))*x[1]**o + ((-0.733187508555-0.273670454497j))*x[1]
        ref[(3, 1)]=(-0.332627651459-0.349325184866j)*x_ref[0]**o + ((-0.275524638875+0.679422635592j))*x_ref[0] + ((-0.674786962439-0.118139279292j))*x_ref[1]**o + ((-0.733187508555-0.273670454497j))*x_ref[1]
        arg[(3, 2)]=(-0.679693996055-0.673088322217j)*x[0]**o + ((-0.52400411527+0.604378071819j))*x[0] + ((-0.291024618102+0.445321020095j))*x[1]**o + ((0.141392146404-0.635380952539j))*x[1]
        ref[(3, 2)]=(-0.679693996055-0.673088322217j)*x_ref[0]**o + ((-0.52400411527+0.604378071819j))*x_ref[0] + ((-0.291024618102+0.445321020095j))*x_ref[1]**o + ((0.141392146404-0.635380952539j))*x_ref[1]
        arg[(3, 3)]=(-0.87542297899+0.0605243172401j)*x[0]**o + ((0.395540049718+0.956741679299j))*x[0] + ((-0.467622397233-0.398083891199j))*x[1]**o + ((-0.287926473924+0.371392218651j))*x[1]
        ref[(3, 3)]=(-0.87542297899+0.0605243172401j)*x_ref[0]**o + ((0.395540049718+0.956741679299j))*x_ref[0] + ((-0.467622397233-0.398083891199j))*x_ref[1]**o + ((-0.287926473924+0.371392218651j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(0.977554561297-0.65395764548j)*x[2]**o + ((-0.407949223494-0.293272848403j))*x[2]
            ref[(0, 0)]+=(0.977554561297-0.65395764548j)*x_ref[2]**o + ((-0.407949223494-0.293272848403j))*x_ref[2]
            arg[(0, 1)]+=(0.166616593131+0.0374559401949j)*x[2]**o + ((-0.604212404988+0.9068969144j))*x[2]
            ref[(0, 1)]+=(0.166616593131+0.0374559401949j)*x_ref[2]**o + ((-0.604212404988+0.9068969144j))*x_ref[2]
            arg[(0, 2)]+=(-0.600984763343-0.742247064784j)*x[2]**o + ((0.744249526987-0.0128370251435j))*x[2]
            ref[(0, 2)]+=(-0.600984763343-0.742247064784j)*x_ref[2]**o + ((0.744249526987-0.0128370251435j))*x_ref[2]
            arg[(0, 3)]+=(0.559494934017-0.664280660874j)*x[2]**o + ((0.196766415974+0.276978670466j))*x[2]
            ref[(0, 3)]+=(0.559494934017-0.664280660874j)*x_ref[2]**o + ((0.196766415974+0.276978670466j))*x_ref[2]
            arg[(1, 0)]+=(0.301579931271+0.605875219068j)*x[2]**o + ((0.589585719738-0.295153842004j))*x[2]
            ref[(1, 0)]+=(0.301579931271+0.605875219068j)*x_ref[2]**o + ((0.589585719738-0.295153842004j))*x_ref[2]
            arg[(1, 1)]+=(-0.457662344671-0.88836146922j)*x[2]**o + ((0.0550057090438+0.142326933913j))*x[2]
            ref[(1, 1)]+=(-0.457662344671-0.88836146922j)*x_ref[2]**o + ((0.0550057090438+0.142326933913j))*x_ref[2]
            arg[(1, 2)]+=(-0.196546858232-0.634219033837j)*x[2]**o + ((0.284823473126-0.135986351819j))*x[2]
            ref[(1, 2)]+=(-0.196546858232-0.634219033837j)*x_ref[2]**o + ((0.284823473126-0.135986351819j))*x_ref[2]
            arg[(1, 3)]+=(0.480573195096+0.530483573509j)*x[2]**o + ((0.699260368299+0.175114563872j))*x[2]
            ref[(1, 3)]+=(0.480573195096+0.530483573509j)*x_ref[2]**o + ((0.699260368299+0.175114563872j))*x_ref[2]
            arg[(2, 0)]+=(0.901543057379+0.621579976195j)*x[2]**o + ((0.713613437681-0.080544917966j))*x[2]
            ref[(2, 0)]+=(0.901543057379+0.621579976195j)*x_ref[2]**o + ((0.713613437681-0.080544917966j))*x_ref[2]
            arg[(2, 1)]+=(0.321361315255+0.309300776374j)*x[2]**o + ((-0.654051970843+0.44688649948j))*x[2]
            ref[(2, 1)]+=(0.321361315255+0.309300776374j)*x_ref[2]**o + ((-0.654051970843+0.44688649948j))*x_ref[2]
            arg[(2, 2)]+=(0.991203932549+0.736907521413j)*x[2]**o + ((0.845801965484+0.841289664228j))*x[2]
            ref[(2, 2)]+=(0.991203932549+0.736907521413j)*x_ref[2]**o + ((0.845801965484+0.841289664228j))*x_ref[2]
            arg[(2, 3)]+=(0.71966263602-0.219900870153j)*x[2]**o + ((0.992167837937+0.490551067059j))*x[2]
            ref[(2, 3)]+=(0.71966263602-0.219900870153j)*x_ref[2]**o + ((0.992167837937+0.490551067059j))*x_ref[2]
            arg[(3, 0)]+=(-0.852497371355-0.650765604365j)*x[2]**o + ((-0.644511566836-0.643123764954j))*x[2]
            ref[(3, 0)]+=(-0.852497371355-0.650765604365j)*x_ref[2]**o + ((-0.644511566836-0.643123764954j))*x_ref[2]
            arg[(3, 1)]+=(0.280857630015-0.332607617548j)*x[2]**o + ((-0.357912328147-0.354173670349j))*x[2]
            ref[(3, 1)]+=(0.280857630015-0.332607617548j)*x_ref[2]**o + ((-0.357912328147-0.354173670349j))*x_ref[2]
            arg[(3, 2)]+=(-0.670676656381-0.13454498668j)*x[2]**o + ((-0.730002522221+0.621408319618j))*x[2]
            ref[(3, 2)]+=(-0.670676656381-0.13454498668j)*x_ref[2]**o + ((-0.730002522221+0.621408319618j))*x_ref[2]
            arg[(3, 3)]+=(-0.870430343586+0.10002293054j)*x[2]**o + ((-0.599785227974-0.739774346871j))*x[2]
            ref[(3, 3)]+=(-0.870430343586+0.10002293054j)*x_ref[2]**o + ((-0.599785227974-0.739774346871j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ContinuousFunction_rank3(self):
        """
        tests interpolation of rank 3 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 4),w)
        ref = Data(0,(4, 3, 4),w_ref)
        arg[(0, 0, 0)]=(0.916984983412+0.0346199769783j)*x[0]**o + ((-0.896720096012-0.688421174299j))*x[0] + ((-0.395223138331-0.512473936616j))*x[1]**o + ((-0.971255203255+0.242033893324j))*x[1]
        ref[(0, 0, 0)]=(0.916984983412+0.0346199769783j)*x_ref[0]**o + ((-0.896720096012-0.688421174299j))*x_ref[0] + ((-0.395223138331-0.512473936616j))*x_ref[1]**o + ((-0.971255203255+0.242033893324j))*x_ref[1]
        arg[(0, 0, 1)]=(0.283161120475+0.990365256932j)*x[0]**o + ((-0.713640247064+0.499980611317j))*x[0] + ((-0.101443746734-0.657520341168j))*x[1]**o + ((-0.751820046672-0.638232807718j))*x[1]
        ref[(0, 0, 1)]=(0.283161120475+0.990365256932j)*x_ref[0]**o + ((-0.713640247064+0.499980611317j))*x_ref[0] + ((-0.101443746734-0.657520341168j))*x_ref[1]**o + ((-0.751820046672-0.638232807718j))*x_ref[1]
        arg[(0, 0, 2)]=(-0.117424837666+0.455220842459j)*x[0]**o + ((-0.772016564082+0.608851472335j))*x[0] + ((-0.910345354975+0.756351420496j))*x[1]**o + ((-0.976381925823-0.678237774734j))*x[1]
        ref[(0, 0, 2)]=(-0.117424837666+0.455220842459j)*x_ref[0]**o + ((-0.772016564082+0.608851472335j))*x_ref[0] + ((-0.910345354975+0.756351420496j))*x_ref[1]**o + ((-0.976381925823-0.678237774734j))*x_ref[1]
        arg[(0, 0, 3)]=(-0.688827252907+0.977421690308j)*x[0]**o + ((0.909393123049+0.422407561413j))*x[0] + ((0.477317205137+0.722637368044j))*x[1]**o + ((0.0460355589854+0.20115876023j))*x[1]
        ref[(0, 0, 3)]=(-0.688827252907+0.977421690308j)*x_ref[0]**o + ((0.909393123049+0.422407561413j))*x_ref[0] + ((0.477317205137+0.722637368044j))*x_ref[1]**o + ((0.0460355589854+0.20115876023j))*x_ref[1]
        arg[(0, 1, 0)]=(0.155393617415+0.596602241709j)*x[0]**o + ((-0.674931753145+0.515954624306j))*x[0] + ((0.553826184848+0.202804703653j))*x[1]**o + ((0.977495355532-0.589021011951j))*x[1]
        ref[(0, 1, 0)]=(0.155393617415+0.596602241709j)*x_ref[0]**o + ((-0.674931753145+0.515954624306j))*x_ref[0] + ((0.553826184848+0.202804703653j))*x_ref[1]**o + ((0.977495355532-0.589021011951j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.28125240243-0.547147405954j)*x[0]**o + ((0.56075108927-0.875518526205j))*x[0] + ((0.63286846724-0.669590775854j))*x[1]**o + ((-0.565725756084-0.609874996265j))*x[1]
        ref[(0, 1, 1)]=(-0.28125240243-0.547147405954j)*x_ref[0]**o + ((0.56075108927-0.875518526205j))*x_ref[0] + ((0.63286846724-0.669590775854j))*x_ref[1]**o + ((-0.565725756084-0.609874996265j))*x_ref[1]
        arg[(0, 1, 2)]=(0.201667481746+0.815198490664j)*x[0]**o + ((0.95952333118+0.448036705319j))*x[0] + ((0.0260923190774+0.835245736398j))*x[1]**o + ((0.201205945882+0.930803592046j))*x[1]
        ref[(0, 1, 2)]=(0.201667481746+0.815198490664j)*x_ref[0]**o + ((0.95952333118+0.448036705319j))*x_ref[0] + ((0.0260923190774+0.835245736398j))*x_ref[1]**o + ((0.201205945882+0.930803592046j))*x_ref[1]
        arg[(0, 1, 3)]=(-0.956470494931-0.422041795601j)*x[0]**o + ((0.0741407721994-0.984729730103j))*x[0] + ((-0.448163758001-0.523160319712j))*x[1]**o + ((-0.796452417648+0.228365932228j))*x[1]
        ref[(0, 1, 3)]=(-0.956470494931-0.422041795601j)*x_ref[0]**o + ((0.0741407721994-0.984729730103j))*x_ref[0] + ((-0.448163758001-0.523160319712j))*x_ref[1]**o + ((-0.796452417648+0.228365932228j))*x_ref[1]
        arg[(0, 2, 0)]=(0.768366893393+0.126447069938j)*x[0]**o + ((0.843041515007-0.627174823897j))*x[0] + ((-0.270921814351+0.808183373659j))*x[1]**o + ((0.791866292347-0.135908124562j))*x[1]
        ref[(0, 2, 0)]=(0.768366893393+0.126447069938j)*x_ref[0]**o + ((0.843041515007-0.627174823897j))*x_ref[0] + ((-0.270921814351+0.808183373659j))*x_ref[1]**o + ((0.791866292347-0.135908124562j))*x_ref[1]
        arg[(0, 2, 1)]=(0.766519730162-0.906864923034j)*x[0]**o + ((0.184820587169-0.593597833352j))*x[0] + ((0.568104415794+0.351796898126j))*x[1]**o + ((-0.541575256076-0.830999686831j))*x[1]
        ref[(0, 2, 1)]=(0.766519730162-0.906864923034j)*x_ref[0]**o + ((0.184820587169-0.593597833352j))*x_ref[0] + ((0.568104415794+0.351796898126j))*x_ref[1]**o + ((-0.541575256076-0.830999686831j))*x_ref[1]
        arg[(0, 2, 2)]=(-0.828562036466+0.19213945265j)*x[0]**o + ((-0.388469282637+0.670568345682j))*x[0] + ((0.897419210091+0.0521553933848j))*x[1]**o + ((0.508389554262+0.500497032024j))*x[1]
        ref[(0, 2, 2)]=(-0.828562036466+0.19213945265j)*x_ref[0]**o + ((-0.388469282637+0.670568345682j))*x_ref[0] + ((0.897419210091+0.0521553933848j))*x_ref[1]**o + ((0.508389554262+0.500497032024j))*x_ref[1]
        arg[(0, 2, 3)]=(-0.751493261226+0.577944900917j)*x[0]**o + ((0.0750835541266+0.680812841627j))*x[0] + ((-0.795107916992-0.81868258918j))*x[1]**o + ((0.0469790683512+0.644319478627j))*x[1]
        ref[(0, 2, 3)]=(-0.751493261226+0.577944900917j)*x_ref[0]**o + ((0.0750835541266+0.680812841627j))*x_ref[0] + ((-0.795107916992-0.81868258918j))*x_ref[1]**o + ((0.0469790683512+0.644319478627j))*x_ref[1]
        arg[(1, 0, 0)]=(0.595386886236-0.970636739313j)*x[0]**o + ((0.536037948998-0.0285304977303j))*x[0] + ((0.0693086101981+0.16720987169j))*x[1]**o + ((-0.979723536591+0.862058701933j))*x[1]
        ref[(1, 0, 0)]=(0.595386886236-0.970636739313j)*x_ref[0]**o + ((0.536037948998-0.0285304977303j))*x_ref[0] + ((0.0693086101981+0.16720987169j))*x_ref[1]**o + ((-0.979723536591+0.862058701933j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.841823222388+0.282143181546j)*x[0]**o + ((-0.897650845211-0.145610685965j))*x[0] + ((-0.952810189022+0.33744419299j))*x[1]**o + ((0.0347434223902-0.501182758475j))*x[1]
        ref[(1, 0, 1)]=(-0.841823222388+0.282143181546j)*x_ref[0]**o + ((-0.897650845211-0.145610685965j))*x_ref[0] + ((-0.952810189022+0.33744419299j))*x_ref[1]**o + ((0.0347434223902-0.501182758475j))*x_ref[1]
        arg[(1, 0, 2)]=(0.0543502033131-0.123917602869j)*x[0]**o + ((0.913898955567-0.871550548457j))*x[0] + ((-0.452361399015-0.608010311172j))*x[1]**o + ((-0.19154102915-0.011044548981j))*x[1]
        ref[(1, 0, 2)]=(0.0543502033131-0.123917602869j)*x_ref[0]**o + ((0.913898955567-0.871550548457j))*x_ref[0] + ((-0.452361399015-0.608010311172j))*x_ref[1]**o + ((-0.19154102915-0.011044548981j))*x_ref[1]
        arg[(1, 0, 3)]=(-0.0994928143233+0.400532732558j)*x[0]**o + ((0.0940522792329-0.494983706995j))*x[0] + ((-0.573588915996+0.197400999866j))*x[1]**o + ((0.795329804189+0.737943588485j))*x[1]
        ref[(1, 0, 3)]=(-0.0994928143233+0.400532732558j)*x_ref[0]**o + ((0.0940522792329-0.494983706995j))*x_ref[0] + ((-0.573588915996+0.197400999866j))*x_ref[1]**o + ((0.795329804189+0.737943588485j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.611849680466+0.354428335799j)*x[0]**o + ((0.427774269352-0.0436290813412j))*x[0] + ((0.105665590947+0.730291107778j))*x[1]**o + ((0.404244929018-0.291786267267j))*x[1]
        ref[(1, 1, 0)]=(-0.611849680466+0.354428335799j)*x_ref[0]**o + ((0.427774269352-0.0436290813412j))*x_ref[0] + ((0.105665590947+0.730291107778j))*x_ref[1]**o + ((0.404244929018-0.291786267267j))*x_ref[1]
        arg[(1, 1, 1)]=(0.870577668796-0.863936024185j)*x[0]**o + ((0.321878350827-0.846353420617j))*x[0] + ((0.824655083161-0.194215869933j))*x[1]**o + ((0.837930106057+0.821039458358j))*x[1]
        ref[(1, 1, 1)]=(0.870577668796-0.863936024185j)*x_ref[0]**o + ((0.321878350827-0.846353420617j))*x_ref[0] + ((0.824655083161-0.194215869933j))*x_ref[1]**o + ((0.837930106057+0.821039458358j))*x_ref[1]
        arg[(1, 1, 2)]=(0.337137203959-0.645150803971j)*x[0]**o + ((0.508266521432+0.725865604182j))*x[0] + ((0.33890988941+0.211179902392j))*x[1]**o + ((-0.853670354255+0.514240031478j))*x[1]
        ref[(1, 1, 2)]=(0.337137203959-0.645150803971j)*x_ref[0]**o + ((0.508266521432+0.725865604182j))*x_ref[0] + ((0.33890988941+0.211179902392j))*x_ref[1]**o + ((-0.853670354255+0.514240031478j))*x_ref[1]
        arg[(1, 1, 3)]=(0.399058382696-0.590192484774j)*x[0]**o + ((0.749544643957+0.891115402585j))*x[0] + ((0.345070129308-0.252972677879j))*x[1]**o + ((-0.14292588523+0.578693396656j))*x[1]
        ref[(1, 1, 3)]=(0.399058382696-0.590192484774j)*x_ref[0]**o + ((0.749544643957+0.891115402585j))*x_ref[0] + ((0.345070129308-0.252972677879j))*x_ref[1]**o + ((-0.14292588523+0.578693396656j))*x_ref[1]
        arg[(1, 2, 0)]=(0.938608939563+0.138852492269j)*x[0]**o + ((-0.704187261126-0.542974030412j))*x[0] + ((-0.927908080796-0.830752267042j))*x[1]**o + ((-0.00904149946063-0.746640345358j))*x[1]
        ref[(1, 2, 0)]=(0.938608939563+0.138852492269j)*x_ref[0]**o + ((-0.704187261126-0.542974030412j))*x_ref[0] + ((-0.927908080796-0.830752267042j))*x_ref[1]**o + ((-0.00904149946063-0.746640345358j))*x_ref[1]
        arg[(1, 2, 1)]=(0.35834956462-0.665061842029j)*x[0]**o + ((0.425454691387-0.720870879205j))*x[0] + ((-0.723388672471-0.399560204666j))*x[1]**o + ((-0.30445936557+0.766105007618j))*x[1]
        ref[(1, 2, 1)]=(0.35834956462-0.665061842029j)*x_ref[0]**o + ((0.425454691387-0.720870879205j))*x_ref[0] + ((-0.723388672471-0.399560204666j))*x_ref[1]**o + ((-0.30445936557+0.766105007618j))*x_ref[1]
        arg[(1, 2, 2)]=(0.935048318386+0.0108118312623j)*x[0]**o + ((-0.755796764705-0.42695081048j))*x[0] + ((-0.423237290305+0.359010693331j))*x[1]**o + ((-0.343946671615+0.439076407411j))*x[1]
        ref[(1, 2, 2)]=(0.935048318386+0.0108118312623j)*x_ref[0]**o + ((-0.755796764705-0.42695081048j))*x_ref[0] + ((-0.423237290305+0.359010693331j))*x_ref[1]**o + ((-0.343946671615+0.439076407411j))*x_ref[1]
        arg[(1, 2, 3)]=(0.480377959179-0.817156633578j)*x[0]**o + ((-0.485603762155-0.430411329463j))*x[0] + ((0.994771785915-0.144727666892j))*x[1]**o + ((0.956852177338-0.847737645219j))*x[1]
        ref[(1, 2, 3)]=(0.480377959179-0.817156633578j)*x_ref[0]**o + ((-0.485603762155-0.430411329463j))*x_ref[0] + ((0.994771785915-0.144727666892j))*x_ref[1]**o + ((0.956852177338-0.847737645219j))*x_ref[1]
        arg[(2, 0, 0)]=(-0.210403551866-0.134068769922j)*x[0]**o + ((0.129427114824-0.596344596116j))*x[0] + ((-0.761576257022+0.857868412026j))*x[1]**o + ((0.653138947936+0.467288197068j))*x[1]
        ref[(2, 0, 0)]=(-0.210403551866-0.134068769922j)*x_ref[0]**o + ((0.129427114824-0.596344596116j))*x_ref[0] + ((-0.761576257022+0.857868412026j))*x_ref[1]**o + ((0.653138947936+0.467288197068j))*x_ref[1]
        arg[(2, 0, 1)]=(-0.36179885763-0.335098580255j)*x[0]**o + ((0.496918897097+0.126080122898j))*x[0] + ((-0.641160367306-0.772320133749j))*x[1]**o + ((-0.984798469057+0.284870663434j))*x[1]
        ref[(2, 0, 1)]=(-0.36179885763-0.335098580255j)*x_ref[0]**o + ((0.496918897097+0.126080122898j))*x_ref[0] + ((-0.641160367306-0.772320133749j))*x_ref[1]**o + ((-0.984798469057+0.284870663434j))*x_ref[1]
        arg[(2, 0, 2)]=(-0.917636195053-0.0516310868189j)*x[0]**o + ((-0.0978977591081-0.764839532453j))*x[0] + ((0.605001453971+0.946382368036j))*x[1]**o + ((-0.572679303701+0.0982537589457j))*x[1]
        ref[(2, 0, 2)]=(-0.917636195053-0.0516310868189j)*x_ref[0]**o + ((-0.0978977591081-0.764839532453j))*x_ref[0] + ((0.605001453971+0.946382368036j))*x_ref[1]**o + ((-0.572679303701+0.0982537589457j))*x_ref[1]
        arg[(2, 0, 3)]=(-0.835892141961-0.513174808944j)*x[0]**o + ((-0.100058999254+0.952448409546j))*x[0] + ((-0.663328070227+0.311011824012j))*x[1]**o + ((0.843525079776-0.457065555228j))*x[1]
        ref[(2, 0, 3)]=(-0.835892141961-0.513174808944j)*x_ref[0]**o + ((-0.100058999254+0.952448409546j))*x_ref[0] + ((-0.663328070227+0.311011824012j))*x_ref[1]**o + ((0.843525079776-0.457065555228j))*x_ref[1]
        arg[(2, 1, 0)]=(-0.917458723439-0.415697548695j)*x[0]**o + ((0.95902759945-0.0473202425806j))*x[0] + ((-0.89851526603+0.972867466423j))*x[1]**o + ((0.906530389968+0.818709998446j))*x[1]
        ref[(2, 1, 0)]=(-0.917458723439-0.415697548695j)*x_ref[0]**o + ((0.95902759945-0.0473202425806j))*x_ref[0] + ((-0.89851526603+0.972867466423j))*x_ref[1]**o + ((0.906530389968+0.818709998446j))*x_ref[1]
        arg[(2, 1, 1)]=(-0.418149361233+0.961793786806j)*x[0]**o + ((-0.680216245227-0.471904896862j))*x[0] + ((-0.421840285633+0.0747110068092j))*x[1]**o + ((0.758264205124+0.0290885633801j))*x[1]
        ref[(2, 1, 1)]=(-0.418149361233+0.961793786806j)*x_ref[0]**o + ((-0.680216245227-0.471904896862j))*x_ref[0] + ((-0.421840285633+0.0747110068092j))*x_ref[1]**o + ((0.758264205124+0.0290885633801j))*x_ref[1]
        arg[(2, 1, 2)]=(0.285664977511-0.404783046905j)*x[0]**o + ((0.607274109051+0.157496430834j))*x[0] + ((-0.78878613036+0.574773492559j))*x[1]**o + ((-0.414594112091-0.76372972904j))*x[1]
        ref[(2, 1, 2)]=(0.285664977511-0.404783046905j)*x_ref[0]**o + ((0.607274109051+0.157496430834j))*x_ref[0] + ((-0.78878613036+0.574773492559j))*x_ref[1]**o + ((-0.414594112091-0.76372972904j))*x_ref[1]
        arg[(2, 1, 3)]=(0.750951722162-0.434966372715j)*x[0]**o + ((-0.300118450543+0.841694900694j))*x[0] + ((0.24901037618-0.119355128937j))*x[1]**o + ((-0.0511544479816-0.697717051617j))*x[1]
        ref[(2, 1, 3)]=(0.750951722162-0.434966372715j)*x_ref[0]**o + ((-0.300118450543+0.841694900694j))*x_ref[0] + ((0.24901037618-0.119355128937j))*x_ref[1]**o + ((-0.0511544479816-0.697717051617j))*x_ref[1]
        arg[(2, 2, 0)]=(-0.960826758807+0.647021899697j)*x[0]**o + ((0.162672230849+0.757379855817j))*x[0] + ((0.157770417508-0.671091093747j))*x[1]**o + ((-0.680215240634+0.799744244119j))*x[1]
        ref[(2, 2, 0)]=(-0.960826758807+0.647021899697j)*x_ref[0]**o + ((0.162672230849+0.757379855817j))*x_ref[0] + ((0.157770417508-0.671091093747j))*x_ref[1]**o + ((-0.680215240634+0.799744244119j))*x_ref[1]
        arg[(2, 2, 1)]=(0.231961332903+0.837604513549j)*x[0]**o + ((-0.973317113468+0.0624427460043j))*x[0] + ((0.57678181385+0.548535125025j))*x[1]**o + ((-0.782668263085+0.815993421538j))*x[1]
        ref[(2, 2, 1)]=(0.231961332903+0.837604513549j)*x_ref[0]**o + ((-0.973317113468+0.0624427460043j))*x_ref[0] + ((0.57678181385+0.548535125025j))*x_ref[1]**o + ((-0.782668263085+0.815993421538j))*x_ref[1]
        arg[(2, 2, 2)]=(-0.555807703392-0.0995783868432j)*x[0]**o + ((-0.0672004850314+0.449208190541j))*x[0] + ((0.580397751189-0.583332056146j))*x[1]**o + ((0.529315134687+0.656220255969j))*x[1]
        ref[(2, 2, 2)]=(-0.555807703392-0.0995783868432j)*x_ref[0]**o + ((-0.0672004850314+0.449208190541j))*x_ref[0] + ((0.580397751189-0.583332056146j))*x_ref[1]**o + ((0.529315134687+0.656220255969j))*x_ref[1]
        arg[(2, 2, 3)]=(0.566188016492+0.664053036197j)*x[0]**o + ((0.585153974635-0.439602901812j))*x[0] + ((0.742155037561+0.993226457932j))*x[1]**o + ((0.2879467595-0.321233649115j))*x[1]
        ref[(2, 2, 3)]=(0.566188016492+0.664053036197j)*x_ref[0]**o + ((0.585153974635-0.439602901812j))*x_ref[0] + ((0.742155037561+0.993226457932j))*x_ref[1]**o + ((0.2879467595-0.321233649115j))*x_ref[1]
        arg[(3, 0, 0)]=(-0.703005064943+0.647862894418j)*x[0]**o + ((0.61261141105+0.429417645514j))*x[0] + ((0.615207529071-0.341511484457j))*x[1]**o + ((-0.018771410044+0.801236431161j))*x[1]
        ref[(3, 0, 0)]=(-0.703005064943+0.647862894418j)*x_ref[0]**o + ((0.61261141105+0.429417645514j))*x_ref[0] + ((0.615207529071-0.341511484457j))*x_ref[1]**o + ((-0.018771410044+0.801236431161j))*x_ref[1]
        arg[(3, 0, 1)]=(-0.911992210035-0.299113094019j)*x[0]**o + ((0.0303516193729+0.194276293334j))*x[0] + ((-0.9787554046-0.698442552301j))*x[1]**o + ((-0.486760260182-0.0692898131093j))*x[1]
        ref[(3, 0, 1)]=(-0.911992210035-0.299113094019j)*x_ref[0]**o + ((0.0303516193729+0.194276293334j))*x_ref[0] + ((-0.9787554046-0.698442552301j))*x_ref[1]**o + ((-0.486760260182-0.0692898131093j))*x_ref[1]
        arg[(3, 0, 2)]=(0.243001393101-0.310730121822j)*x[0]**o + ((-0.173045087182+0.549700711306j))*x[0] + ((-0.758988835387+0.594840621861j))*x[1]**o + ((-0.713553663973-0.671010061783j))*x[1]
        ref[(3, 0, 2)]=(0.243001393101-0.310730121822j)*x_ref[0]**o + ((-0.173045087182+0.549700711306j))*x_ref[0] + ((-0.758988835387+0.594840621861j))*x_ref[1]**o + ((-0.713553663973-0.671010061783j))*x_ref[1]
        arg[(3, 0, 3)]=(-0.524471237514+0.879469413257j)*x[0]**o + ((-0.828823366401-0.3838956179j))*x[0] + ((-0.206244895661-0.549593825527j))*x[1]**o + ((0.695782174273+0.21322340813j))*x[1]
        ref[(3, 0, 3)]=(-0.524471237514+0.879469413257j)*x_ref[0]**o + ((-0.828823366401-0.3838956179j))*x_ref[0] + ((-0.206244895661-0.549593825527j))*x_ref[1]**o + ((0.695782174273+0.21322340813j))*x_ref[1]
        arg[(3, 1, 0)]=(-0.202272148696+0.0685980889476j)*x[0]**o + ((0.579990778523+0.403117974257j))*x[0] + ((-0.293161989933+0.427678142333j))*x[1]**o + ((0.536542180268-0.590435008615j))*x[1]
        ref[(3, 1, 0)]=(-0.202272148696+0.0685980889476j)*x_ref[0]**o + ((0.579990778523+0.403117974257j))*x_ref[0] + ((-0.293161989933+0.427678142333j))*x_ref[1]**o + ((0.536542180268-0.590435008615j))*x_ref[1]
        arg[(3, 1, 1)]=(-0.943050455775-0.241335675104j)*x[0]**o + ((-0.8451048949+0.62834658312j))*x[0] + ((-0.618954648919-0.516323548466j))*x[1]**o + ((-0.629118678792+0.133969045059j))*x[1]
        ref[(3, 1, 1)]=(-0.943050455775-0.241335675104j)*x_ref[0]**o + ((-0.8451048949+0.62834658312j))*x_ref[0] + ((-0.618954648919-0.516323548466j))*x_ref[1]**o + ((-0.629118678792+0.133969045059j))*x_ref[1]
        arg[(3, 1, 2)]=(-0.705721628275-0.25614849338j)*x[0]**o + ((0.602978339544+0.0955814207574j))*x[0] + ((-0.215492639331-0.135709608813j))*x[1]**o + ((0.749876663777+0.040828583398j))*x[1]
        ref[(3, 1, 2)]=(-0.705721628275-0.25614849338j)*x_ref[0]**o + ((0.602978339544+0.0955814207574j))*x_ref[0] + ((-0.215492639331-0.135709608813j))*x_ref[1]**o + ((0.749876663777+0.040828583398j))*x_ref[1]
        arg[(3, 1, 3)]=(0.432640908672+0.292570560871j)*x[0]**o + ((-0.590411965513+0.747216762216j))*x[0] + ((-0.984492875542+0.368171770239j))*x[1]**o + ((-0.208008045065-0.289885027581j))*x[1]
        ref[(3, 1, 3)]=(0.432640908672+0.292570560871j)*x_ref[0]**o + ((-0.590411965513+0.747216762216j))*x_ref[0] + ((-0.984492875542+0.368171770239j))*x_ref[1]**o + ((-0.208008045065-0.289885027581j))*x_ref[1]
        arg[(3, 2, 0)]=(0.97715440536+0.0730675412581j)*x[0]**o + ((-0.668494386119-0.716486657094j))*x[0] + ((-0.715250402993-0.197669761375j))*x[1]**o + ((0.146607555752-0.874279283916j))*x[1]
        ref[(3, 2, 0)]=(0.97715440536+0.0730675412581j)*x_ref[0]**o + ((-0.668494386119-0.716486657094j))*x_ref[0] + ((-0.715250402993-0.197669761375j))*x_ref[1]**o + ((0.146607555752-0.874279283916j))*x_ref[1]
        arg[(3, 2, 1)]=(-0.0320292824046-0.894396978918j)*x[0]**o + ((0.666012038996-0.782604813188j))*x[0] + ((0.212495262253+0.129025403181j))*x[1]**o + ((-0.239943374808-0.909008201613j))*x[1]
        ref[(3, 2, 1)]=(-0.0320292824046-0.894396978918j)*x_ref[0]**o + ((0.666012038996-0.782604813188j))*x_ref[0] + ((0.212495262253+0.129025403181j))*x_ref[1]**o + ((-0.239943374808-0.909008201613j))*x_ref[1]
        arg[(3, 2, 2)]=(0.142513301503-0.138608355956j)*x[0]**o + ((-0.4599653058-0.0584792344805j))*x[0] + ((0.0794133499838-0.563713900825j))*x[1]**o + ((-0.650505893482+0.990698118907j))*x[1]
        ref[(3, 2, 2)]=(0.142513301503-0.138608355956j)*x_ref[0]**o + ((-0.4599653058-0.0584792344805j))*x_ref[0] + ((0.0794133499838-0.563713900825j))*x_ref[1]**o + ((-0.650505893482+0.990698118907j))*x_ref[1]
        arg[(3, 2, 3)]=(0.82004056335+0.220851479281j)*x[0]**o + ((-0.999915875935-0.135800377927j))*x[0] + ((-0.172844877787+0.265185492401j))*x[1]**o + ((0.367471210768+0.786911177279j))*x[1]
        ref[(3, 2, 3)]=(0.82004056335+0.220851479281j)*x_ref[0]**o + ((-0.999915875935-0.135800377927j))*x_ref[0] + ((-0.172844877787+0.265185492401j))*x_ref[1]**o + ((0.367471210768+0.786911177279j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.363517965862-0.503880033245j)*x[2]**o + ((-0.588703984556+0.176122107212j))*x[2]
            ref[(0, 0, 0)]+=(-0.363517965862-0.503880033245j)*x_ref[2]**o + ((-0.588703984556+0.176122107212j))*x_ref[2]
            arg[(0, 0, 1)]+=(0.728519462577-0.474338294743j)*x[2]**o + ((0.543907293301-0.564886026436j))*x[2]
            ref[(0, 0, 1)]+=(0.728519462577-0.474338294743j)*x_ref[2]**o + ((0.543907293301-0.564886026436j))*x_ref[2]
            arg[(0, 0, 2)]+=(0.990014913962-0.378161325001j)*x[2]**o + ((0.632501715704+0.165824513339j))*x[2]
            ref[(0, 0, 2)]+=(0.990014913962-0.378161325001j)*x_ref[2]**o + ((0.632501715704+0.165824513339j))*x_ref[2]
            arg[(0, 0, 3)]+=(-0.801040945936-0.649819218206j)*x[2]**o + ((0.313346137564-0.182723001409j))*x[2]
            ref[(0, 0, 3)]+=(-0.801040945936-0.649819218206j)*x_ref[2]**o + ((0.313346137564-0.182723001409j))*x_ref[2]
            arg[(0, 1, 0)]+=(0.506115287372-0.620758725491j)*x[2]**o + ((0.203540959709+0.675515589938j))*x[2]
            ref[(0, 1, 0)]+=(0.506115287372-0.620758725491j)*x_ref[2]**o + ((0.203540959709+0.675515589938j))*x_ref[2]
            arg[(0, 1, 1)]+=(0.29380268692+0.845358175225j)*x[2]**o + ((0.93302581858+0.854429798006j))*x[2]
            ref[(0, 1, 1)]+=(0.29380268692+0.845358175225j)*x_ref[2]**o + ((0.93302581858+0.854429798006j))*x_ref[2]
            arg[(0, 1, 2)]+=(-0.327256992887+0.251923671207j)*x[2]**o + ((0.965188198412+0.80926292053j))*x[2]
            ref[(0, 1, 2)]+=(-0.327256992887+0.251923671207j)*x_ref[2]**o + ((0.965188198412+0.80926292053j))*x_ref[2]
            arg[(0, 1, 3)]+=(0.201350131494-0.833882456495j)*x[2]**o + ((0.453702931206-0.659194395395j))*x[2]
            ref[(0, 1, 3)]+=(0.201350131494-0.833882456495j)*x_ref[2]**o + ((0.453702931206-0.659194395395j))*x_ref[2]
            arg[(0, 2, 0)]+=(-0.141738393314+0.730851844247j)*x[2]**o + ((0.877333447582+0.675512605712j))*x[2]
            ref[(0, 2, 0)]+=(-0.141738393314+0.730851844247j)*x_ref[2]**o + ((0.877333447582+0.675512605712j))*x_ref[2]
            arg[(0, 2, 1)]+=(0.344956480459+0.50606005056j)*x[2]**o + ((0.713701978265+0.288641616323j))*x[2]
            ref[(0, 2, 1)]+=(0.344956480459+0.50606005056j)*x_ref[2]**o + ((0.713701978265+0.288641616323j))*x_ref[2]
            arg[(0, 2, 2)]+=(0.561332461085-0.258095360447j)*x[2]**o + ((0.779713782417-0.0469436302566j))*x[2]
            ref[(0, 2, 2)]+=(0.561332461085-0.258095360447j)*x_ref[2]**o + ((0.779713782417-0.0469436302566j))*x_ref[2]
            arg[(0, 2, 3)]+=(0.520773817405-0.658311600452j)*x[2]**o + ((0.618557497507-0.103243209357j))*x[2]
            ref[(0, 2, 3)]+=(0.520773817405-0.658311600452j)*x_ref[2]**o + ((0.618557497507-0.103243209357j))*x_ref[2]
            arg[(1, 0, 0)]+=(0.401277746335+0.84719314972j)*x[2]**o + ((-0.650205288711-0.0124646690295j))*x[2]
            ref[(1, 0, 0)]+=(0.401277746335+0.84719314972j)*x_ref[2]**o + ((-0.650205288711-0.0124646690295j))*x_ref[2]
            arg[(1, 0, 1)]+=(-0.0612928306798-0.26276357034j)*x[2]**o + ((-0.305052403691+0.856924048576j))*x[2]
            ref[(1, 0, 1)]+=(-0.0612928306798-0.26276357034j)*x_ref[2]**o + ((-0.305052403691+0.856924048576j))*x_ref[2]
            arg[(1, 0, 2)]+=(-0.330200463072+0.821990576436j)*x[2]**o + ((0.338245989633-0.853327837698j))*x[2]
            ref[(1, 0, 2)]+=(-0.330200463072+0.821990576436j)*x_ref[2]**o + ((0.338245989633-0.853327837698j))*x_ref[2]
            arg[(1, 0, 3)]+=(0.434973690758-0.929156691773j)*x[2]**o + ((0.284843662616+0.547876013501j))*x[2]
            ref[(1, 0, 3)]+=(0.434973690758-0.929156691773j)*x_ref[2]**o + ((0.284843662616+0.547876013501j))*x_ref[2]
            arg[(1, 1, 0)]+=(0.499859151878+0.0181485905011j)*x[2]**o + ((0.215901548364-0.469099079464j))*x[2]
            ref[(1, 1, 0)]+=(0.499859151878+0.0181485905011j)*x_ref[2]**o + ((0.215901548364-0.469099079464j))*x_ref[2]
            arg[(1, 1, 1)]+=(-0.385985821574-0.994300289538j)*x[2]**o + ((0.89881680075+0.559311221688j))*x[2]
            ref[(1, 1, 1)]+=(-0.385985821574-0.994300289538j)*x_ref[2]**o + ((0.89881680075+0.559311221688j))*x_ref[2]
            arg[(1, 1, 2)]+=(0.644563060082+0.948709750517j)*x[2]**o + ((-0.361850913569-0.0759400951993j))*x[2]
            ref[(1, 1, 2)]+=(0.644563060082+0.948709750517j)*x_ref[2]**o + ((-0.361850913569-0.0759400951993j))*x_ref[2]
            arg[(1, 1, 3)]+=(-0.0103141745223-0.409548137533j)*x[2]**o + ((0.873605822745-0.683572768386j))*x[2]
            ref[(1, 1, 3)]+=(-0.0103141745223-0.409548137533j)*x_ref[2]**o + ((0.873605822745-0.683572768386j))*x_ref[2]
            arg[(1, 2, 0)]+=(-0.145290875656+0.785780158727j)*x[2]**o + ((0.962289140694+0.235200047448j))*x[2]
            ref[(1, 2, 0)]+=(-0.145290875656+0.785780158727j)*x_ref[2]**o + ((0.962289140694+0.235200047448j))*x_ref[2]
            arg[(1, 2, 1)]+=(0.121658900464+0.310081953527j)*x[2]**o + ((-0.624015351179-0.562748618404j))*x[2]
            ref[(1, 2, 1)]+=(0.121658900464+0.310081953527j)*x_ref[2]**o + ((-0.624015351179-0.562748618404j))*x_ref[2]
            arg[(1, 2, 2)]+=(0.0927826507997-0.520444355626j)*x[2]**o + ((0.0694629730444+0.576196609808j))*x[2]
            ref[(1, 2, 2)]+=(0.0927826507997-0.520444355626j)*x_ref[2]**o + ((0.0694629730444+0.576196609808j))*x_ref[2]
            arg[(1, 2, 3)]+=(0.599677704437+0.201308533436j)*x[2]**o + ((-0.445811025212-0.426246548101j))*x[2]
            ref[(1, 2, 3)]+=(0.599677704437+0.201308533436j)*x_ref[2]**o + ((-0.445811025212-0.426246548101j))*x_ref[2]
            arg[(2, 0, 0)]+=(0.506709163198+0.500972719922j)*x[2]**o + ((0.972758017097-0.117652158747j))*x[2]
            ref[(2, 0, 0)]+=(0.506709163198+0.500972719922j)*x_ref[2]**o + ((0.972758017097-0.117652158747j))*x_ref[2]
            arg[(2, 0, 1)]+=(0.938384705848-0.244801808583j)*x[2]**o + ((-0.219925087122-0.0765578160614j))*x[2]
            ref[(2, 0, 1)]+=(0.938384705848-0.244801808583j)*x_ref[2]**o + ((-0.219925087122-0.0765578160614j))*x_ref[2]
            arg[(2, 0, 2)]+=(-0.273795340274+0.502659303209j)*x[2]**o + ((-0.092311307117+0.384483712154j))*x[2]
            ref[(2, 0, 2)]+=(-0.273795340274+0.502659303209j)*x_ref[2]**o + ((-0.092311307117+0.384483712154j))*x_ref[2]
            arg[(2, 0, 3)]+=(0.562351114354+0.177655611964j)*x[2]**o + ((-0.308344010442-0.383408983035j))*x[2]
            ref[(2, 0, 3)]+=(0.562351114354+0.177655611964j)*x_ref[2]**o + ((-0.308344010442-0.383408983035j))*x_ref[2]
            arg[(2, 1, 0)]+=(-0.150673852071+0.262345244569j)*x[2]**o + ((-0.473089872354+0.256356035285j))*x[2]
            ref[(2, 1, 0)]+=(-0.150673852071+0.262345244569j)*x_ref[2]**o + ((-0.473089872354+0.256356035285j))*x_ref[2]
            arg[(2, 1, 1)]+=(-0.346248524883-0.775750862842j)*x[2]**o + ((0.26685294591+0.477022746216j))*x[2]
            ref[(2, 1, 1)]+=(-0.346248524883-0.775750862842j)*x_ref[2]**o + ((0.26685294591+0.477022746216j))*x_ref[2]
            arg[(2, 1, 2)]+=(-0.130974046963+0.870566373033j)*x[2]**o + ((0.704564635522+0.414246062945j))*x[2]
            ref[(2, 1, 2)]+=(-0.130974046963+0.870566373033j)*x_ref[2]**o + ((0.704564635522+0.414246062945j))*x_ref[2]
            arg[(2, 1, 3)]+=(0.770245844358-0.70691849228j)*x[2]**o + ((-0.970020956875+0.808315901588j))*x[2]
            ref[(2, 1, 3)]+=(0.770245844358-0.70691849228j)*x_ref[2]**o + ((-0.970020956875+0.808315901588j))*x_ref[2]
            arg[(2, 2, 0)]+=(0.414848556542-0.868577877784j)*x[2]**o + ((0.635614529595+0.68329020886j))*x[2]
            ref[(2, 2, 0)]+=(0.414848556542-0.868577877784j)*x_ref[2]**o + ((0.635614529595+0.68329020886j))*x_ref[2]
            arg[(2, 2, 1)]+=(0.125071105887+0.831859248866j)*x[2]**o + ((0.661151621049+0.743626621471j))*x[2]
            ref[(2, 2, 1)]+=(0.125071105887+0.831859248866j)*x_ref[2]**o + ((0.661151621049+0.743626621471j))*x_ref[2]
            arg[(2, 2, 2)]+=(-0.0282266492791+0.787398514862j)*x[2]**o + ((-0.326310001863+0.470826456557j))*x[2]
            ref[(2, 2, 2)]+=(-0.0282266492791+0.787398514862j)*x_ref[2]**o + ((-0.326310001863+0.470826456557j))*x_ref[2]
            arg[(2, 2, 3)]+=(0.00448178822433+0.675120753242j)*x[2]**o + ((-0.191687089221+0.641740818207j))*x[2]
            ref[(2, 2, 3)]+=(0.00448178822433+0.675120753242j)*x_ref[2]**o + ((-0.191687089221+0.641740818207j))*x_ref[2]
            arg[(3, 0, 0)]+=(0.486674875617-0.660833752285j)*x[2]**o + ((-0.432500907335-0.512778489132j))*x[2]
            ref[(3, 0, 0)]+=(0.486674875617-0.660833752285j)*x_ref[2]**o + ((-0.432500907335-0.512778489132j))*x_ref[2]
            arg[(3, 0, 1)]+=(-0.542001632835+0.752930640567j)*x[2]**o + ((0.988723013514-0.652644696755j))*x[2]
            ref[(3, 0, 1)]+=(-0.542001632835+0.752930640567j)*x_ref[2]**o + ((0.988723013514-0.652644696755j))*x_ref[2]
            arg[(3, 0, 2)]+=(0.161361908694-0.60852863231j)*x[2]**o + ((0.359446313103-0.521524004329j))*x[2]
            ref[(3, 0, 2)]+=(0.161361908694-0.60852863231j)*x_ref[2]**o + ((0.359446313103-0.521524004329j))*x_ref[2]
            arg[(3, 0, 3)]+=(-0.181666985859-0.766431538621j)*x[2]**o + ((-0.757552773105-0.00635410769266j))*x[2]
            ref[(3, 0, 3)]+=(-0.181666985859-0.766431538621j)*x_ref[2]**o + ((-0.757552773105-0.00635410769266j))*x_ref[2]
            arg[(3, 1, 0)]+=(-0.892514526688+0.475400744762j)*x[2]**o + ((-0.243443169557+0.839476023345j))*x[2]
            ref[(3, 1, 0)]+=(-0.892514526688+0.475400744762j)*x_ref[2]**o + ((-0.243443169557+0.839476023345j))*x_ref[2]
            arg[(3, 1, 1)]+=(-0.159723518291-0.153707381434j)*x[2]**o + ((0.720390592794+0.738692885089j))*x[2]
            ref[(3, 1, 1)]+=(-0.159723518291-0.153707381434j)*x_ref[2]**o + ((0.720390592794+0.738692885089j))*x_ref[2]
            arg[(3, 1, 2)]+=(0.827433029121-0.934601905526j)*x[2]**o + ((-0.175225837127+0.063846509378j))*x[2]
            ref[(3, 1, 2)]+=(0.827433029121-0.934601905526j)*x_ref[2]**o + ((-0.175225837127+0.063846509378j))*x_ref[2]
            arg[(3, 1, 3)]+=(0.0372146563435+0.268020518191j)*x[2]**o + ((-0.580594190988+0.387939041704j))*x[2]
            ref[(3, 1, 3)]+=(0.0372146563435+0.268020518191j)*x_ref[2]**o + ((-0.580594190988+0.387939041704j))*x_ref[2]
            arg[(3, 2, 0)]+=(0.0175264109833+0.923957238757j)*x[2]**o + ((0.43251530824+0.780220072576j))*x[2]
            ref[(3, 2, 0)]+=(0.0175264109833+0.923957238757j)*x_ref[2]**o + ((0.43251530824+0.780220072576j))*x_ref[2]
            arg[(3, 2, 1)]+=(-0.429408618032-0.763127914348j)*x[2]**o + ((-0.305769703493+0.0278473081306j))*x[2]
            ref[(3, 2, 1)]+=(-0.429408618032-0.763127914348j)*x_ref[2]**o + ((-0.305769703493+0.0278473081306j))*x_ref[2]
            arg[(3, 2, 2)]+=(0.951210241502+0.117402602585j)*x[2]**o + ((-0.90112846813+0.349763205042j))*x[2]
            ref[(3, 2, 2)]+=(0.951210241502+0.117402602585j)*x_ref[2]**o + ((-0.90112846813+0.349763205042j))*x_ref[2]
            arg[(3, 2, 3)]+=(0.495656900465+0.964677113013j)*x[2]**o + ((-0.874370734659-0.191804547764j))*x[2]
            ref[(3, 2, 3)]+=(0.495656900465+0.964677113013j)*x_ref[2]**o + ((-0.874370734659-0.191804547764j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ContinuousFunction_rank4(self):
        """
        tests interpolation of rank 4 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4, 3, 2),w)
        ref = Data(0,(2, 4, 3, 2),w_ref)
        arg[(0, 0, 0, 0)]=(-0.644123477877+0.0608688204549j)*x[0]**o + ((-0.179401253253-0.225263450917j))*x[0] + ((0.0747808036155+0.589657976182j))*x[1]**o + ((-0.555317844078+0.492457943486j))*x[1]
        ref[(0, 0, 0, 0)]=(-0.644123477877+0.0608688204549j)*x_ref[0]**o + ((-0.179401253253-0.225263450917j))*x_ref[0] + ((0.0747808036155+0.589657976182j))*x_ref[1]**o + ((-0.555317844078+0.492457943486j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.0845071717346+0.675676171502j)*x[0]**o + ((0.862826816302+0.415738168719j))*x[0] + ((0.964080173425-0.329207005779j))*x[1]**o + ((0.800978048647-0.347430481383j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.0845071717346+0.675676171502j)*x_ref[0]**o + ((0.862826816302+0.415738168719j))*x_ref[0] + ((0.964080173425-0.329207005779j))*x_ref[1]**o + ((0.800978048647-0.347430481383j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(-0.104218645501-0.87221097551j)*x[0]**o + ((-0.1585228613-0.969274951538j))*x[0] + ((-0.208043190023-0.987452422047j))*x[1]**o + ((0.401684009011+0.615397259108j))*x[1]
        ref[(0, 0, 1, 0)]=(-0.104218645501-0.87221097551j)*x_ref[0]**o + ((-0.1585228613-0.969274951538j))*x_ref[0] + ((-0.208043190023-0.987452422047j))*x_ref[1]**o + ((0.401684009011+0.615397259108j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(0.876779582383+0.562218963356j)*x[0]**o + ((0.00190792654355-0.83463416087j))*x[0] + ((-0.929191882613+0.817750605604j))*x[1]**o + ((-0.140287373194+0.743227776747j))*x[1]
        ref[(0, 0, 1, 1)]=(0.876779582383+0.562218963356j)*x_ref[0]**o + ((0.00190792654355-0.83463416087j))*x_ref[0] + ((-0.929191882613+0.817750605604j))*x_ref[1]**o + ((-0.140287373194+0.743227776747j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(0.443884297835-0.469984334827j)*x[0]**o + ((0.936431195171-0.38724478288j))*x[0] + ((0.878254088142-0.580311646696j))*x[1]**o + ((0.233304834268+0.895211527656j))*x[1]
        ref[(0, 0, 2, 0)]=(0.443884297835-0.469984334827j)*x_ref[0]**o + ((0.936431195171-0.38724478288j))*x_ref[0] + ((0.878254088142-0.580311646696j))*x_ref[1]**o + ((0.233304834268+0.895211527656j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(-0.98464944487-0.80626284338j)*x[0]**o + ((0.63036972628-0.405224467279j))*x[0] + ((0.495765946063-0.11598599408j))*x[1]**o + ((0.731874735131+0.160360341367j))*x[1]
        ref[(0, 0, 2, 1)]=(-0.98464944487-0.80626284338j)*x_ref[0]**o + ((0.63036972628-0.405224467279j))*x_ref[0] + ((0.495765946063-0.11598599408j))*x_ref[1]**o + ((0.731874735131+0.160360341367j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.991374194546+0.705346392799j)*x[0]**o + ((0.601811979751+0.931127593453j))*x[0] + ((-0.127698091664+0.479644605867j))*x[1]**o + ((0.839108352875-0.822826466469j))*x[1]
        ref[(0, 1, 0, 0)]=(0.991374194546+0.705346392799j)*x_ref[0]**o + ((0.601811979751+0.931127593453j))*x_ref[0] + ((-0.127698091664+0.479644605867j))*x_ref[1]**o + ((0.839108352875-0.822826466469j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(-0.509874535405+0.269333404521j)*x[0]**o + ((-0.816273189153-0.881335822604j))*x[0] + ((-0.984530515549-0.962593254376j))*x[1]**o + ((-0.00207843202236+0.990207396526j))*x[1]
        ref[(0, 1, 0, 1)]=(-0.509874535405+0.269333404521j)*x_ref[0]**o + ((-0.816273189153-0.881335822604j))*x_ref[0] + ((-0.984530515549-0.962593254376j))*x_ref[1]**o + ((-0.00207843202236+0.990207396526j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.805942138674-0.70365194251j)*x[0]**o + ((0.483301248919-0.818279688726j))*x[0] + ((-0.550516723448+0.841138100732j))*x[1]**o + ((0.0224744865298-0.973375962018j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.805942138674-0.70365194251j)*x_ref[0]**o + ((0.483301248919-0.818279688726j))*x_ref[0] + ((-0.550516723448+0.841138100732j))*x_ref[1]**o + ((0.0224744865298-0.973375962018j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(-0.407351034396-0.613997851964j)*x[0]**o + ((-0.515093429962+0.81060241045j))*x[0] + ((-0.94235475661+0.725291376114j))*x[1]**o + ((0.132156322035-0.0406179491871j))*x[1]
        ref[(0, 1, 1, 1)]=(-0.407351034396-0.613997851964j)*x_ref[0]**o + ((-0.515093429962+0.81060241045j))*x_ref[0] + ((-0.94235475661+0.725291376114j))*x_ref[1]**o + ((0.132156322035-0.0406179491871j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(-0.0846091128832+0.00727961627364j)*x[0]**o + ((-0.77571266559+0.329186578106j))*x[0] + ((-0.31222323373+0.401645381042j))*x[1]**o + ((0.586315652873+0.29484481478j))*x[1]
        ref[(0, 1, 2, 0)]=(-0.0846091128832+0.00727961627364j)*x_ref[0]**o + ((-0.77571266559+0.329186578106j))*x_ref[0] + ((-0.31222323373+0.401645381042j))*x_ref[1]**o + ((0.586315652873+0.29484481478j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(0.807526925366+0.176772077642j)*x[0]**o + ((-0.124249563997-0.203840043555j))*x[0] + ((0.373231642428-0.926068575269j))*x[1]**o + ((0.811183569102-0.43599199156j))*x[1]
        ref[(0, 1, 2, 1)]=(0.807526925366+0.176772077642j)*x_ref[0]**o + ((-0.124249563997-0.203840043555j))*x_ref[0] + ((0.373231642428-0.926068575269j))*x_ref[1]**o + ((0.811183569102-0.43599199156j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(0.695060253845+0.222942878016j)*x[0]**o + ((0.392886177738+0.165493534403j))*x[0] + ((0.832513443542+0.731152513043j))*x[1]**o + ((0.702533385921+0.769843588937j))*x[1]
        ref[(0, 2, 0, 0)]=(0.695060253845+0.222942878016j)*x_ref[0]**o + ((0.392886177738+0.165493534403j))*x_ref[0] + ((0.832513443542+0.731152513043j))*x_ref[1]**o + ((0.702533385921+0.769843588937j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(0.594316185385+0.233996236897j)*x[0]**o + ((-0.773696476318-0.551859183454j))*x[0] + ((0.952927387533+0.733577961433j))*x[1]**o + ((-0.451948894969-0.832440157651j))*x[1]
        ref[(0, 2, 0, 1)]=(0.594316185385+0.233996236897j)*x_ref[0]**o + ((-0.773696476318-0.551859183454j))*x_ref[0] + ((0.952927387533+0.733577961433j))*x_ref[1]**o + ((-0.451948894969-0.832440157651j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(-0.469255733011-0.130226066767j)*x[0]**o + ((-0.73559359757-0.281748866299j))*x[0] + ((0.947315519155+0.646878328514j))*x[1]**o + ((0.956049481699+0.664053066233j))*x[1]
        ref[(0, 2, 1, 0)]=(-0.469255733011-0.130226066767j)*x_ref[0]**o + ((-0.73559359757-0.281748866299j))*x_ref[0] + ((0.947315519155+0.646878328514j))*x_ref[1]**o + ((0.956049481699+0.664053066233j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(0.405665122731+0.541374839659j)*x[0]**o + ((-0.180632013243+0.83519810275j))*x[0] + ((-0.046599836383+0.0450341928138j))*x[1]**o + ((0.742824745691-0.98120609467j))*x[1]
        ref[(0, 2, 1, 1)]=(0.405665122731+0.541374839659j)*x_ref[0]**o + ((-0.180632013243+0.83519810275j))*x_ref[0] + ((-0.046599836383+0.0450341928138j))*x_ref[1]**o + ((0.742824745691-0.98120609467j))*x_ref[1]
        arg[(0, 2, 2, 0)]=(0.797638953857+0.434233108879j)*x[0]**o + ((0.181350162744-0.446851083648j))*x[0] + ((0.301243230151-0.235468064458j))*x[1]**o + ((-0.888444636478+0.414325686465j))*x[1]
        ref[(0, 2, 2, 0)]=(0.797638953857+0.434233108879j)*x_ref[0]**o + ((0.181350162744-0.446851083648j))*x_ref[0] + ((0.301243230151-0.235468064458j))*x_ref[1]**o + ((-0.888444636478+0.414325686465j))*x_ref[1]
        arg[(0, 2, 2, 1)]=(0.351889447695-0.236307813912j)*x[0]**o + ((0.216301836598+0.280040750806j))*x[0] + ((0.869330904279-0.258682025326j))*x[1]**o + ((-0.807053627885-0.71946102318j))*x[1]
        ref[(0, 2, 2, 1)]=(0.351889447695-0.236307813912j)*x_ref[0]**o + ((0.216301836598+0.280040750806j))*x_ref[0] + ((0.869330904279-0.258682025326j))*x_ref[1]**o + ((-0.807053627885-0.71946102318j))*x_ref[1]
        arg[(0, 3, 0, 0)]=(0.271348455611-0.141582993975j)*x[0]**o + ((0.876182009972+0.89973717575j))*x[0] + ((0.365627079429-0.865145106053j))*x[1]**o + ((-0.0161112852385+0.989022993047j))*x[1]
        ref[(0, 3, 0, 0)]=(0.271348455611-0.141582993975j)*x_ref[0]**o + ((0.876182009972+0.89973717575j))*x_ref[0] + ((0.365627079429-0.865145106053j))*x_ref[1]**o + ((-0.0161112852385+0.989022993047j))*x_ref[1]
        arg[(0, 3, 0, 1)]=(0.758282939322+0.817418654639j)*x[0]**o + ((-0.803355260508-0.478768339807j))*x[0] + ((-0.734788433788+0.99366158892j))*x[1]**o + ((0.424664039959+0.476685568981j))*x[1]
        ref[(0, 3, 0, 1)]=(0.758282939322+0.817418654639j)*x_ref[0]**o + ((-0.803355260508-0.478768339807j))*x_ref[0] + ((-0.734788433788+0.99366158892j))*x_ref[1]**o + ((0.424664039959+0.476685568981j))*x_ref[1]
        arg[(0, 3, 1, 0)]=(0.773511551566-0.502050928502j)*x[0]**o + ((0.75341210355-0.51328730786j))*x[0] + ((0.0707676791602+0.915509240479j))*x[1]**o + ((0.482671726125+0.758791184059j))*x[1]
        ref[(0, 3, 1, 0)]=(0.773511551566-0.502050928502j)*x_ref[0]**o + ((0.75341210355-0.51328730786j))*x_ref[0] + ((0.0707676791602+0.915509240479j))*x_ref[1]**o + ((0.482671726125+0.758791184059j))*x_ref[1]
        arg[(0, 3, 1, 1)]=(0.814048444681-0.00336613351092j)*x[0]**o + ((0.223836827597+0.741187200597j))*x[0] + ((0.598777097358-0.27754705029j))*x[1]**o + ((-0.496417398456-0.90592961578j))*x[1]
        ref[(0, 3, 1, 1)]=(0.814048444681-0.00336613351092j)*x_ref[0]**o + ((0.223836827597+0.741187200597j))*x_ref[0] + ((0.598777097358-0.27754705029j))*x_ref[1]**o + ((-0.496417398456-0.90592961578j))*x_ref[1]
        arg[(0, 3, 2, 0)]=(0.260273840164+0.240894784916j)*x[0]**o + ((-0.636760148527-0.808275210286j))*x[0] + ((-0.652479302111+0.981032143947j))*x[1]**o + ((-0.390722529005-0.292772321639j))*x[1]
        ref[(0, 3, 2, 0)]=(0.260273840164+0.240894784916j)*x_ref[0]**o + ((-0.636760148527-0.808275210286j))*x_ref[0] + ((-0.652479302111+0.981032143947j))*x_ref[1]**o + ((-0.390722529005-0.292772321639j))*x_ref[1]
        arg[(0, 3, 2, 1)]=(0.827671639586-0.294998672046j)*x[0]**o + ((0.874487106674+0.402223521219j))*x[0] + ((-0.600106632414+0.103730009676j))*x[1]**o + ((0.505431354928+0.305951616596j))*x[1]
        ref[(0, 3, 2, 1)]=(0.827671639586-0.294998672046j)*x_ref[0]**o + ((0.874487106674+0.402223521219j))*x_ref[0] + ((-0.600106632414+0.103730009676j))*x_ref[1]**o + ((0.505431354928+0.305951616596j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.177896526017+0.16285152594j)*x[0]**o + ((-0.663505957967+0.570137148108j))*x[0] + ((-0.268243798839-0.565315504914j))*x[1]**o + ((0.58961168828+0.817017188219j))*x[1]
        ref[(1, 0, 0, 0)]=(0.177896526017+0.16285152594j)*x_ref[0]**o + ((-0.663505957967+0.570137148108j))*x_ref[0] + ((-0.268243798839-0.565315504914j))*x_ref[1]**o + ((0.58961168828+0.817017188219j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.415366255782+0.0667089421275j)*x[0]**o + ((-0.261458877541-0.293822471862j))*x[0] + ((0.26412995968-0.773189977679j))*x[1]**o + ((-0.62786184962+0.589922630255j))*x[1]
        ref[(1, 0, 0, 1)]=(0.415366255782+0.0667089421275j)*x_ref[0]**o + ((-0.261458877541-0.293822471862j))*x_ref[0] + ((0.26412995968-0.773189977679j))*x_ref[1]**o + ((-0.62786184962+0.589922630255j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.12798324223+0.967400652606j)*x[0]**o + ((0.375343854274-0.405587974137j))*x[0] + ((-0.9098731405-0.415868023022j))*x[1]**o + ((0.891781823757+0.974469142462j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.12798324223+0.967400652606j)*x_ref[0]**o + ((0.375343854274-0.405587974137j))*x_ref[0] + ((-0.9098731405-0.415868023022j))*x_ref[1]**o + ((0.891781823757+0.974469142462j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(-0.156198468907-0.808357007541j)*x[0]**o + ((-0.010831487083+0.478874741939j))*x[0] + ((-0.404505285535+0.602810852557j))*x[1]**o + ((0.755803544604+0.144152349297j))*x[1]
        ref[(1, 0, 1, 1)]=(-0.156198468907-0.808357007541j)*x_ref[0]**o + ((-0.010831487083+0.478874741939j))*x_ref[0] + ((-0.404505285535+0.602810852557j))*x_ref[1]**o + ((0.755803544604+0.144152349297j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(-0.344438492318-0.236580930719j)*x[0]**o + ((0.13648812873+0.480053916466j))*x[0] + ((-0.775470232774+0.42370298035j))*x[1]**o + ((0.570859570391-0.726038509775j))*x[1]
        ref[(1, 0, 2, 0)]=(-0.344438492318-0.236580930719j)*x_ref[0]**o + ((0.13648812873+0.480053916466j))*x_ref[0] + ((-0.775470232774+0.42370298035j))*x_ref[1]**o + ((0.570859570391-0.726038509775j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(0.711938531089+0.475326484824j)*x[0]**o + ((-0.357574807713-0.908775017651j))*x[0] + ((0.195194392844-0.314065988029j))*x[1]**o + ((-0.060000743426+0.167833419569j))*x[1]
        ref[(1, 0, 2, 1)]=(0.711938531089+0.475326484824j)*x_ref[0]**o + ((-0.357574807713-0.908775017651j))*x_ref[0] + ((0.195194392844-0.314065988029j))*x_ref[1]**o + ((-0.060000743426+0.167833419569j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(0.910157230534+0.957709309634j)*x[0]**o + ((-0.327333996437+0.829700946848j))*x[0] + ((0.27921531971+0.142126339055j))*x[1]**o + ((-0.840535281348-0.85347586027j))*x[1]
        ref[(1, 1, 0, 0)]=(0.910157230534+0.957709309634j)*x_ref[0]**o + ((-0.327333996437+0.829700946848j))*x_ref[0] + ((0.27921531971+0.142126339055j))*x_ref[1]**o + ((-0.840535281348-0.85347586027j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(0.893507469453+0.0906644823733j)*x[0]**o + ((0.396900839459-0.189626930037j))*x[0] + ((0.785486088832+0.03363941272j))*x[1]**o + ((0.164516569302+0.331623315546j))*x[1]
        ref[(1, 1, 0, 1)]=(0.893507469453+0.0906644823733j)*x_ref[0]**o + ((0.396900839459-0.189626930037j))*x_ref[0] + ((0.785486088832+0.03363941272j))*x_ref[1]**o + ((0.164516569302+0.331623315546j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(-0.0434115918077+0.615194493384j)*x[0]**o + ((-0.872181387866+0.346669561233j))*x[0] + ((0.272727551462+0.497693459749j))*x[1]**o + ((0.780358075227-0.531172247849j))*x[1]
        ref[(1, 1, 1, 0)]=(-0.0434115918077+0.615194493384j)*x_ref[0]**o + ((-0.872181387866+0.346669561233j))*x_ref[0] + ((0.272727551462+0.497693459749j))*x_ref[1]**o + ((0.780358075227-0.531172247849j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.730215436415-0.0794540530848j)*x[0]**o + ((0.562702489484+0.564914311994j))*x[0] + ((-0.210413158328-0.323277363825j))*x[1]**o + ((-0.801153936061+0.611827316473j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.730215436415-0.0794540530848j)*x_ref[0]**o + ((0.562702489484+0.564914311994j))*x_ref[0] + ((-0.210413158328-0.323277363825j))*x_ref[1]**o + ((-0.801153936061+0.611827316473j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(0.442431106933+0.411294400425j)*x[0]**o + ((-0.299682025837+0.774040755914j))*x[0] + ((0.736827838282+0.44507018968j))*x[1]**o + ((0.762781101515+0.748069060946j))*x[1]
        ref[(1, 1, 2, 0)]=(0.442431106933+0.411294400425j)*x_ref[0]**o + ((-0.299682025837+0.774040755914j))*x_ref[0] + ((0.736827838282+0.44507018968j))*x_ref[1]**o + ((0.762781101515+0.748069060946j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(0.472836135658-0.345292395992j)*x[0]**o + ((0.515134179149+0.305236552218j))*x[0] + ((-0.54001213165+0.193334260661j))*x[1]**o + ((-0.594487674071-0.665941651862j))*x[1]
        ref[(1, 1, 2, 1)]=(0.472836135658-0.345292395992j)*x_ref[0]**o + ((0.515134179149+0.305236552218j))*x_ref[0] + ((-0.54001213165+0.193334260661j))*x_ref[1]**o + ((-0.594487674071-0.665941651862j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(-0.806015194479-0.792265488986j)*x[0]**o + ((0.840343300942+0.466966194932j))*x[0] + ((0.739771706831-0.416097231993j))*x[1]**o + ((-0.867372593695-0.934279191936j))*x[1]
        ref[(1, 2, 0, 0)]=(-0.806015194479-0.792265488986j)*x_ref[0]**o + ((0.840343300942+0.466966194932j))*x_ref[0] + ((0.739771706831-0.416097231993j))*x_ref[1]**o + ((-0.867372593695-0.934279191936j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(0.733234085605-0.31656061952j)*x[0]**o + ((-0.385463404775-0.695884579299j))*x[0] + ((-0.5771343714-0.0732122163233j))*x[1]**o + ((0.72370890036+0.539382667983j))*x[1]
        ref[(1, 2, 0, 1)]=(0.733234085605-0.31656061952j)*x_ref[0]**o + ((-0.385463404775-0.695884579299j))*x_ref[0] + ((-0.5771343714-0.0732122163233j))*x_ref[1]**o + ((0.72370890036+0.539382667983j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(0.328498086109-0.261638220916j)*x[0]**o + ((-0.196209798868+0.922015422761j))*x[0] + ((0.696767467335-0.0521728767706j))*x[1]**o + ((0.123050164122+0.564888731403j))*x[1]
        ref[(1, 2, 1, 0)]=(0.328498086109-0.261638220916j)*x_ref[0]**o + ((-0.196209798868+0.922015422761j))*x_ref[0] + ((0.696767467335-0.0521728767706j))*x_ref[1]**o + ((0.123050164122+0.564888731403j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(0.777589091963-0.730853491179j)*x[0]**o + ((0.946232661503+0.0568039920123j))*x[0] + ((0.562840730921-0.769685219174j))*x[1]**o + ((-0.764603347229+0.814737917885j))*x[1]
        ref[(1, 2, 1, 1)]=(0.777589091963-0.730853491179j)*x_ref[0]**o + ((0.946232661503+0.0568039920123j))*x_ref[0] + ((0.562840730921-0.769685219174j))*x_ref[1]**o + ((-0.764603347229+0.814737917885j))*x_ref[1]
        arg[(1, 2, 2, 0)]=(-0.707311188492-0.690650027815j)*x[0]**o + ((-0.637169093645+0.00297643995807j))*x[0] + ((0.0454729615656+0.254196762837j))*x[1]**o + ((0.347457760515+0.931266500431j))*x[1]
        ref[(1, 2, 2, 0)]=(-0.707311188492-0.690650027815j)*x_ref[0]**o + ((-0.637169093645+0.00297643995807j))*x_ref[0] + ((0.0454729615656+0.254196762837j))*x_ref[1]**o + ((0.347457760515+0.931266500431j))*x_ref[1]
        arg[(1, 2, 2, 1)]=(-0.388365011382+0.250198405217j)*x[0]**o + ((-0.57961413687-0.815915238169j))*x[0] + ((-0.509858225751-0.357970695601j))*x[1]**o + ((-0.575470945077+0.813393753002j))*x[1]
        ref[(1, 2, 2, 1)]=(-0.388365011382+0.250198405217j)*x_ref[0]**o + ((-0.57961413687-0.815915238169j))*x_ref[0] + ((-0.509858225751-0.357970695601j))*x_ref[1]**o + ((-0.575470945077+0.813393753002j))*x_ref[1]
        arg[(1, 3, 0, 0)]=(-0.624410447556-0.602633308928j)*x[0]**o + ((0.669170287454+0.979056248602j))*x[0] + ((0.940211882329+0.21976648088j))*x[1]**o + ((0.985413318299-0.115276717802j))*x[1]
        ref[(1, 3, 0, 0)]=(-0.624410447556-0.602633308928j)*x_ref[0]**o + ((0.669170287454+0.979056248602j))*x_ref[0] + ((0.940211882329+0.21976648088j))*x_ref[1]**o + ((0.985413318299-0.115276717802j))*x_ref[1]
        arg[(1, 3, 0, 1)]=(-0.532924868626+0.541295053249j)*x[0]**o + ((-0.0760822219208+0.88696772708j))*x[0] + ((-0.827857465315-0.160576837571j))*x[1]**o + ((-0.249203954802+0.218196956549j))*x[1]
        ref[(1, 3, 0, 1)]=(-0.532924868626+0.541295053249j)*x_ref[0]**o + ((-0.0760822219208+0.88696772708j))*x_ref[0] + ((-0.827857465315-0.160576837571j))*x_ref[1]**o + ((-0.249203954802+0.218196956549j))*x_ref[1]
        arg[(1, 3, 1, 0)]=(-0.0315959928789-0.849865587208j)*x[0]**o + ((-0.258375266734+0.304093554927j))*x[0] + ((0.483191751953+0.97598108832j))*x[1]**o + ((0.692184671402-0.17265607021j))*x[1]
        ref[(1, 3, 1, 0)]=(-0.0315959928789-0.849865587208j)*x_ref[0]**o + ((-0.258375266734+0.304093554927j))*x_ref[0] + ((0.483191751953+0.97598108832j))*x_ref[1]**o + ((0.692184671402-0.17265607021j))*x_ref[1]
        arg[(1, 3, 1, 1)]=(-0.555685165253+0.794770153525j)*x[0]**o + ((0.260902401217+0.742823099318j))*x[0] + ((0.579838559324-0.0773654366123j))*x[1]**o + ((0.274503852097+0.773949729754j))*x[1]
        ref[(1, 3, 1, 1)]=(-0.555685165253+0.794770153525j)*x_ref[0]**o + ((0.260902401217+0.742823099318j))*x_ref[0] + ((0.579838559324-0.0773654366123j))*x_ref[1]**o + ((0.274503852097+0.773949729754j))*x_ref[1]
        arg[(1, 3, 2, 0)]=(0.801258102323-0.601326199183j)*x[0]**o + ((0.227721441833-0.976695138858j))*x[0] + ((0.50519878772+0.184601677617j))*x[1]**o + ((0.382886431349+0.00299905525254j))*x[1]
        ref[(1, 3, 2, 0)]=(0.801258102323-0.601326199183j)*x_ref[0]**o + ((0.227721441833-0.976695138858j))*x_ref[0] + ((0.50519878772+0.184601677617j))*x_ref[1]**o + ((0.382886431349+0.00299905525254j))*x_ref[1]
        arg[(1, 3, 2, 1)]=(0.854576288572-0.239721755878j)*x[0]**o + ((-0.899663130071+0.206294149985j))*x[0] + ((-0.93972019538-0.399317320065j))*x[1]**o + ((-0.273338856687-0.811894684019j))*x[1]
        ref[(1, 3, 2, 1)]=(0.854576288572-0.239721755878j)*x_ref[0]**o + ((-0.899663130071+0.206294149985j))*x_ref[0] + ((-0.93972019538-0.399317320065j))*x_ref[1]**o + ((-0.273338856687-0.811894684019j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.451638681993-0.0223795464056j)*x[2]**o + ((-0.89311727934-0.777862850457j))*x[2]
            ref[(0, 0, 0, 0)]+=(-0.451638681993-0.0223795464056j)*x_ref[2]**o + ((-0.89311727934-0.777862850457j))*x_ref[2]
            arg[(0, 0, 0, 1)]+=(0.457140180831-0.261637063605j)*x[2]**o + ((-0.977997015851+0.195425385407j))*x[2]
            ref[(0, 0, 0, 1)]+=(0.457140180831-0.261637063605j)*x_ref[2]**o + ((-0.977997015851+0.195425385407j))*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.382450181833+0.126123661476j)*x[2]**o + ((0.521622239162-0.627606558058j))*x[2]
            ref[(0, 0, 1, 0)]+=(-0.382450181833+0.126123661476j)*x_ref[2]**o + ((0.521622239162-0.627606558058j))*x_ref[2]
            arg[(0, 0, 1, 1)]+=(-0.242877523592-0.0917763984262j)*x[2]**o + ((-0.83206657695-0.530419316093j))*x[2]
            ref[(0, 0, 1, 1)]+=(-0.242877523592-0.0917763984262j)*x_ref[2]**o + ((-0.83206657695-0.530419316093j))*x_ref[2]
            arg[(0, 0, 2, 0)]+=(-0.951425910532-0.534690953826j)*x[2]**o + ((-0.561314408776-0.689322789728j))*x[2]
            ref[(0, 0, 2, 0)]+=(-0.951425910532-0.534690953826j)*x_ref[2]**o + ((-0.561314408776-0.689322789728j))*x_ref[2]
            arg[(0, 0, 2, 1)]+=(-0.516652776689-0.509261753763j)*x[2]**o + ((-0.347791197761-0.835698949775j))*x[2]
            ref[(0, 0, 2, 1)]+=(-0.516652776689-0.509261753763j)*x_ref[2]**o + ((-0.347791197761-0.835698949775j))*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.250420328449+0.26749481178j)*x[2]**o + ((-0.688606149132-0.684670946281j))*x[2]
            ref[(0, 1, 0, 0)]+=(-0.250420328449+0.26749481178j)*x_ref[2]**o + ((-0.688606149132-0.684670946281j))*x_ref[2]
            arg[(0, 1, 0, 1)]+=(0.280946251796+0.399185573056j)*x[2]**o + ((-0.51209857185+0.185784881742j))*x[2]
            ref[(0, 1, 0, 1)]+=(0.280946251796+0.399185573056j)*x_ref[2]**o + ((-0.51209857185+0.185784881742j))*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.927112010646+0.97740881354j)*x[2]**o + ((-0.51753093474+0.294894270844j))*x[2]
            ref[(0, 1, 1, 0)]+=(-0.927112010646+0.97740881354j)*x_ref[2]**o + ((-0.51753093474+0.294894270844j))*x_ref[2]
            arg[(0, 1, 1, 1)]+=(0.0377393694036+0.94117526284j)*x[2]**o + ((-0.995179743149+0.506243511361j))*x[2]
            ref[(0, 1, 1, 1)]+=(0.0377393694036+0.94117526284j)*x_ref[2]**o + ((-0.995179743149+0.506243511361j))*x_ref[2]
            arg[(0, 1, 2, 0)]+=(-0.765234397005+0.00938285704084j)*x[2]**o + ((0.104682827896-0.616954962914j))*x[2]
            ref[(0, 1, 2, 0)]+=(-0.765234397005+0.00938285704084j)*x_ref[2]**o + ((0.104682827896-0.616954962914j))*x_ref[2]
            arg[(0, 1, 2, 1)]+=(0.525622022373-0.0248479564643j)*x[2]**o + ((0.73278542092+0.837412705974j))*x[2]
            ref[(0, 1, 2, 1)]+=(0.525622022373-0.0248479564643j)*x_ref[2]**o + ((0.73278542092+0.837412705974j))*x_ref[2]
            arg[(0, 2, 0, 0)]+=(0.762528277992-0.80944631096j)*x[2]**o + ((-0.661275209861-0.247366346504j))*x[2]
            ref[(0, 2, 0, 0)]+=(0.762528277992-0.80944631096j)*x_ref[2]**o + ((-0.661275209861-0.247366346504j))*x_ref[2]
            arg[(0, 2, 0, 1)]+=(-0.591409504186+0.310973602356j)*x[2]**o + ((0.798046870411+0.534748717412j))*x[2]
            ref[(0, 2, 0, 1)]+=(-0.591409504186+0.310973602356j)*x_ref[2]**o + ((0.798046870411+0.534748717412j))*x_ref[2]
            arg[(0, 2, 1, 0)]+=(-0.340418531548+0.599634151932j)*x[2]**o + ((-0.210108964792-0.406197879741j))*x[2]
            ref[(0, 2, 1, 0)]+=(-0.340418531548+0.599634151932j)*x_ref[2]**o + ((-0.210108964792-0.406197879741j))*x_ref[2]
            arg[(0, 2, 1, 1)]+=(0.609993619833-0.668444216222j)*x[2]**o + ((0.0911050167271-0.998460727087j))*x[2]
            ref[(0, 2, 1, 1)]+=(0.609993619833-0.668444216222j)*x_ref[2]**o + ((0.0911050167271-0.998460727087j))*x_ref[2]
            arg[(0, 2, 2, 0)]+=(0.166078749885+0.156277074163j)*x[2]**o + ((-0.360091690205-0.429826938476j))*x[2]
            ref[(0, 2, 2, 0)]+=(0.166078749885+0.156277074163j)*x_ref[2]**o + ((-0.360091690205-0.429826938476j))*x_ref[2]
            arg[(0, 2, 2, 1)]+=(0.809899217804+0.98238302372j)*x[2]**o + ((-0.166590586059-0.700894366393j))*x[2]
            ref[(0, 2, 2, 1)]+=(0.809899217804+0.98238302372j)*x_ref[2]**o + ((-0.166590586059-0.700894366393j))*x_ref[2]
            arg[(0, 3, 0, 0)]+=(-0.450627673748+0.471721292864j)*x[2]**o + ((0.334576638228+0.0130904599171j))*x[2]
            ref[(0, 3, 0, 0)]+=(-0.450627673748+0.471721292864j)*x_ref[2]**o + ((0.334576638228+0.0130904599171j))*x_ref[2]
            arg[(0, 3, 0, 1)]+=(0.272760947945-0.448854148658j)*x[2]**o + ((0.0736353176036+0.244325735025j))*x[2]
            ref[(0, 3, 0, 1)]+=(0.272760947945-0.448854148658j)*x_ref[2]**o + ((0.0736353176036+0.244325735025j))*x_ref[2]
            arg[(0, 3, 1, 0)]+=(0.0452699323397-0.200049582771j)*x[2]**o + ((-0.0224919789922+0.385924323907j))*x[2]
            ref[(0, 3, 1, 0)]+=(0.0452699323397-0.200049582771j)*x_ref[2]**o + ((-0.0224919789922+0.385924323907j))*x_ref[2]
            arg[(0, 3, 1, 1)]+=(0.862811539973-0.984915171895j)*x[2]**o + ((0.493630029738-0.887272425206j))*x[2]
            ref[(0, 3, 1, 1)]+=(0.862811539973-0.984915171895j)*x_ref[2]**o + ((0.493630029738-0.887272425206j))*x_ref[2]
            arg[(0, 3, 2, 0)]+=(-0.726417147786+0.118693931067j)*x[2]**o + ((-0.785914389641+0.763012352518j))*x[2]
            ref[(0, 3, 2, 0)]+=(-0.726417147786+0.118693931067j)*x_ref[2]**o + ((-0.785914389641+0.763012352518j))*x_ref[2]
            arg[(0, 3, 2, 1)]+=(0.832451643472+0.970732147639j)*x[2]**o + ((-0.635050118262+0.33790252316j))*x[2]
            ref[(0, 3, 2, 1)]+=(0.832451643472+0.970732147639j)*x_ref[2]**o + ((-0.635050118262+0.33790252316j))*x_ref[2]
            arg[(1, 0, 0, 0)]+=(0.737202518583-0.666103513481j)*x[2]**o + ((-0.722040886211+0.0313152420588j))*x[2]
            ref[(1, 0, 0, 0)]+=(0.737202518583-0.666103513481j)*x_ref[2]**o + ((-0.722040886211+0.0313152420588j))*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.139193618912+0.490961593492j)*x[2]**o + ((-0.850166002331+0.496334755985j))*x[2]
            ref[(1, 0, 0, 1)]+=(0.139193618912+0.490961593492j)*x_ref[2]**o + ((-0.850166002331+0.496334755985j))*x_ref[2]
            arg[(1, 0, 1, 0)]+=(0.344463514862-0.278943896236j)*x[2]**o + ((0.408762219624+0.8352182738j))*x[2]
            ref[(1, 0, 1, 0)]+=(0.344463514862-0.278943896236j)*x_ref[2]**o + ((0.408762219624+0.8352182738j))*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.176382710715-0.897369540654j)*x[2]**o + ((-0.312056277885-0.950366238809j))*x[2]
            ref[(1, 0, 1, 1)]+=(0.176382710715-0.897369540654j)*x_ref[2]**o + ((-0.312056277885-0.950366238809j))*x_ref[2]
            arg[(1, 0, 2, 0)]+=(0.529930494801-0.1372205418j)*x[2]**o + ((-0.395734868267+0.527117022694j))*x[2]
            ref[(1, 0, 2, 0)]+=(0.529930494801-0.1372205418j)*x_ref[2]**o + ((-0.395734868267+0.527117022694j))*x_ref[2]
            arg[(1, 0, 2, 1)]+=(0.0162540473575-0.0125216060196j)*x[2]**o + ((-0.29409666504+0.429460074031j))*x[2]
            ref[(1, 0, 2, 1)]+=(0.0162540473575-0.0125216060196j)*x_ref[2]**o + ((-0.29409666504+0.429460074031j))*x_ref[2]
            arg[(1, 1, 0, 0)]+=(0.3357001142-0.617404909703j)*x[2]**o + ((0.834879691034-0.232191837732j))*x[2]
            ref[(1, 1, 0, 0)]+=(0.3357001142-0.617404909703j)*x_ref[2]**o + ((0.834879691034-0.232191837732j))*x_ref[2]
            arg[(1, 1, 0, 1)]+=(-0.128626849803+0.84670765251j)*x[2]**o + ((-0.573590962962-0.614729956425j))*x[2]
            ref[(1, 1, 0, 1)]+=(-0.128626849803+0.84670765251j)*x_ref[2]**o + ((-0.573590962962-0.614729956425j))*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.677425223634+0.0574851238555j)*x[2]**o + ((-0.408360911722+0.534343603017j))*x[2]
            ref[(1, 1, 1, 0)]+=(0.677425223634+0.0574851238555j)*x_ref[2]**o + ((-0.408360911722+0.534343603017j))*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.400913930667-0.822977479842j)*x[2]**o + ((0.875782366419-0.830042886985j))*x[2]
            ref[(1, 1, 1, 1)]+=(-0.400913930667-0.822977479842j)*x_ref[2]**o + ((0.875782366419-0.830042886985j))*x_ref[2]
            arg[(1, 1, 2, 0)]+=(-0.170948850062+0.617603565317j)*x[2]**o + ((-0.150912463527+0.584888524509j))*x[2]
            ref[(1, 1, 2, 0)]+=(-0.170948850062+0.617603565317j)*x_ref[2]**o + ((-0.150912463527+0.584888524509j))*x_ref[2]
            arg[(1, 1, 2, 1)]+=(-0.435216082044-0.357019236051j)*x[2]**o + ((0.637352980043-0.57848222817j))*x[2]
            ref[(1, 1, 2, 1)]+=(-0.435216082044-0.357019236051j)*x_ref[2]**o + ((0.637352980043-0.57848222817j))*x_ref[2]
            arg[(1, 2, 0, 0)]+=(0.727671346631-0.75494231493j)*x[2]**o + ((0.725781437667-0.605665195956j))*x[2]
            ref[(1, 2, 0, 0)]+=(0.727671346631-0.75494231493j)*x_ref[2]**o + ((0.725781437667-0.605665195956j))*x_ref[2]
            arg[(1, 2, 0, 1)]+=(-0.695443525664+0.201481435808j)*x[2]**o + ((-0.0171553934495+0.214293149689j))*x[2]
            ref[(1, 2, 0, 1)]+=(-0.695443525664+0.201481435808j)*x_ref[2]**o + ((-0.0171553934495+0.214293149689j))*x_ref[2]
            arg[(1, 2, 1, 0)]+=(-0.439194662066-0.504549405744j)*x[2]**o + ((-0.988628254212+0.166935943019j))*x[2]
            ref[(1, 2, 1, 0)]+=(-0.439194662066-0.504549405744j)*x_ref[2]**o + ((-0.988628254212+0.166935943019j))*x_ref[2]
            arg[(1, 2, 1, 1)]+=(0.477095053157+0.679947266334j)*x[2]**o + ((-0.0822070320794+0.60580419546j))*x[2]
            ref[(1, 2, 1, 1)]+=(0.477095053157+0.679947266334j)*x_ref[2]**o + ((-0.0822070320794+0.60580419546j))*x_ref[2]
            arg[(1, 2, 2, 0)]+=(-0.950761502829+0.3239829221j)*x[2]**o + ((0.0405136574224-0.95879912487j))*x[2]
            ref[(1, 2, 2, 0)]+=(-0.950761502829+0.3239829221j)*x_ref[2]**o + ((0.0405136574224-0.95879912487j))*x_ref[2]
            arg[(1, 2, 2, 1)]+=(0.720309464442+0.301126354656j)*x[2]**o + ((-0.744425691555-0.689439312254j))*x[2]
            ref[(1, 2, 2, 1)]+=(0.720309464442+0.301126354656j)*x_ref[2]**o + ((-0.744425691555-0.689439312254j))*x_ref[2]
            arg[(1, 3, 0, 0)]+=(-0.546398741359+0.265110563831j)*x[2]**o + ((-0.779474102935-0.721413238977j))*x[2]
            ref[(1, 3, 0, 0)]+=(-0.546398741359+0.265110563831j)*x_ref[2]**o + ((-0.779474102935-0.721413238977j))*x_ref[2]
            arg[(1, 3, 0, 1)]+=(0.152573985423-0.417447972902j)*x[2]**o + ((0.855946228028-0.531542724213j))*x[2]
            ref[(1, 3, 0, 1)]+=(0.152573985423-0.417447972902j)*x_ref[2]**o + ((0.855946228028-0.531542724213j))*x_ref[2]
            arg[(1, 3, 1, 0)]+=(-0.24254262696-0.343092571681j)*x[2]**o + ((0.729273632949+0.630309749393j))*x[2]
            ref[(1, 3, 1, 0)]+=(-0.24254262696-0.343092571681j)*x_ref[2]**o + ((0.729273632949+0.630309749393j))*x_ref[2]
            arg[(1, 3, 1, 1)]+=(-0.347217430949+0.336619581496j)*x[2]**o + ((0.226956604918+0.692291194063j))*x[2]
            ref[(1, 3, 1, 1)]+=(-0.347217430949+0.336619581496j)*x_ref[2]**o + ((0.226956604918+0.692291194063j))*x_ref[2]
            arg[(1, 3, 2, 0)]+=(-0.648097774431+0.00699509247675j)*x[2]**o + ((-0.797685627071-0.844702923154j))*x[2]
            ref[(1, 3, 2, 0)]+=(-0.648097774431+0.00699509247675j)*x_ref[2]**o + ((-0.797685627071-0.844702923154j))*x_ref[2]
            arg[(1, 3, 2, 1)]+=(0.42943659607+0.579955607591j)*x[2]**o + ((0.0665099138078+0.534723699396j))*x[2]
            ref[(1, 3, 2, 1)]+=(0.42943659607+0.579955607591j)*x_ref[2]**o + ((0.0665099138078+0.534723699396j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 4, 3, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_Solution_rank0(self):
        """
        tests interpolation of rank 0 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(0.481567518754-0.666348860481j)*x[0]**o + ((-0.486112158242-0.826087577058j))*x[0] + ((0.518885182537-0.0956098640677j))*x[1]**o + ((0.817509093632-0.053631067811j))*x[1]
        ref=(0.481567518754-0.666348860481j)*x_ref[0]**o + ((-0.486112158242-0.826087577058j))*x_ref[0] + ((0.518885182537-0.0956098640677j))*x_ref[1]**o + ((0.817509093632-0.053631067811j))*x_ref[1]
        if dim==3:
            arg+=((-0.199274562612-0.262821806409j))*x[2]**o + ((-0.47740168199+0.115905418197j))*x[2]
            ref+=((-0.199274562612-0.262821806409j))*x_ref[2]**o + ((-0.47740168199+0.115905418197j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_Solution_rank1(self):
        """
        tests interpolation of rank 1 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,),w_ref)
        arg[(0,)]=(0.217814587118+0.45151286531j)*x[0]**o + ((-0.075544217573+0.188385628414j))*x[0] + ((0.576685948498-0.687197503967j))*x[1]**o + ((-0.920598494307+0.527648704069j))*x[1]
        ref[(0,)]=(0.217814587118+0.45151286531j)*x_ref[0]**o + ((-0.075544217573+0.188385628414j))*x_ref[0] + ((0.576685948498-0.687197503967j))*x_ref[1]**o + ((-0.920598494307+0.527648704069j))*x_ref[1]
        arg[(1,)]=(-0.992932320755-0.879573127242j)*x[0]**o + ((-0.693851171229-0.919587191954j))*x[0] + ((0.337226164151-0.214857936459j))*x[1]**o + ((-0.721727295489-0.298977798185j))*x[1]
        ref[(1,)]=(-0.992932320755-0.879573127242j)*x_ref[0]**o + ((-0.693851171229-0.919587191954j))*x_ref[0] + ((0.337226164151-0.214857936459j))*x_ref[1]**o + ((-0.721727295489-0.298977798185j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.933315060836+0.912151032971j)*x[2]**o + ((0.287097121473-0.804518252342j))*x[2]
            ref[(0,)]+=(-0.933315060836+0.912151032971j)*x_ref[2]**o + ((0.287097121473-0.804518252342j))*x_ref[2]
            arg[(1,)]+=(0.059165865926+0.174892346267j)*x[2]**o + ((0.560802083537-0.0523244511601j))*x[2]
            ref[(1,)]+=(0.059165865926+0.174892346267j)*x_ref[2]**o + ((0.560802083537-0.0523244511601j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_Solution_rank2(self):
        """
        tests interpolation of rank 2 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2),w_ref)
        arg[(0, 0)]=(0.480076347512+0.103049683245j)*x[0]**o + ((0.192631671522+0.628213789888j))*x[0] + ((-0.108543882832-0.0280209277122j))*x[1]**o + ((-0.643864564326-0.942976269986j))*x[1]
        ref[(0, 0)]=(0.480076347512+0.103049683245j)*x_ref[0]**o + ((0.192631671522+0.628213789888j))*x_ref[0] + ((-0.108543882832-0.0280209277122j))*x_ref[1]**o + ((-0.643864564326-0.942976269986j))*x_ref[1]
        arg[(0, 1)]=(-0.220819537763-0.651555458812j)*x[0]**o + ((0.488010592629+0.0706154929941j))*x[0] + ((0.494348837495+0.941747477146j))*x[1]**o + ((-0.409552222855-0.186091133083j))*x[1]
        ref[(0, 1)]=(-0.220819537763-0.651555458812j)*x_ref[0]**o + ((0.488010592629+0.0706154929941j))*x_ref[0] + ((0.494348837495+0.941747477146j))*x_ref[1]**o + ((-0.409552222855-0.186091133083j))*x_ref[1]
        arg[(1, 0)]=(-0.213029268899-0.992172931852j)*x[0]**o + ((0.0478656692343+0.355827440687j))*x[0] + ((-0.951368916814+0.698284819082j))*x[1]**o + ((0.761151814634+0.548225564967j))*x[1]
        ref[(1, 0)]=(-0.213029268899-0.992172931852j)*x_ref[0]**o + ((0.0478656692343+0.355827440687j))*x_ref[0] + ((-0.951368916814+0.698284819082j))*x_ref[1]**o + ((0.761151814634+0.548225564967j))*x_ref[1]
        arg[(1, 1)]=(0.497587035096+0.943758407348j)*x[0]**o + ((-0.677285117096-0.845580308793j))*x[0] + ((-0.410923474223-0.520680784509j))*x[1]**o + ((-0.397808377098-0.687417248331j))*x[1]
        ref[(1, 1)]=(0.497587035096+0.943758407348j)*x_ref[0]**o + ((-0.677285117096-0.845580308793j))*x_ref[0] + ((-0.410923474223-0.520680784509j))*x_ref[1]**o + ((-0.397808377098-0.687417248331j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(-0.537405632616-0.464509940732j)*x[2]**o + ((0.995155229979+0.139845831561j))*x[2]
            ref[(0, 0)]+=(-0.537405632616-0.464509940732j)*x_ref[2]**o + ((0.995155229979+0.139845831561j))*x_ref[2]
            arg[(0, 1)]+=(0.517439423599-0.237928811494j)*x[2]**o + ((-0.361090962135+0.00990157167598j))*x[2]
            ref[(0, 1)]+=(0.517439423599-0.237928811494j)*x_ref[2]**o + ((-0.361090962135+0.00990157167598j))*x_ref[2]
            arg[(1, 0)]+=(-0.547692099488-0.607910541123j)*x[2]**o + ((0.935648176424+0.328123141637j))*x[2]
            ref[(1, 0)]+=(-0.547692099488-0.607910541123j)*x_ref[2]**o + ((0.935648176424+0.328123141637j))*x_ref[2]
            arg[(1, 1)]+=(0.380187009517-0.693898777917j)*x[2]**o + ((0.716430885645-0.662582287881j))*x[2]
            ref[(1, 1)]+=(0.380187009517-0.693898777917j)*x_ref[2]**o + ((0.716430885645-0.662582287881j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_Solution_rank3(self):
        """
        tests interpolation of rank 3 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 2),w)
        ref = Data(0,(2, 2, 2),w_ref)
        arg[(0, 0, 0)]=(0.496528750963-0.687127481781j)*x[0]**o + ((0.943224231232-0.847895462981j))*x[0] + ((-0.552732806691-0.537752485613j))*x[1]**o + ((-0.359130136814+0.00271800260808j))*x[1]
        ref[(0, 0, 0)]=(0.496528750963-0.687127481781j)*x_ref[0]**o + ((0.943224231232-0.847895462981j))*x_ref[0] + ((-0.552732806691-0.537752485613j))*x_ref[1]**o + ((-0.359130136814+0.00271800260808j))*x_ref[1]
        arg[(0, 0, 1)]=(-0.961656561274+0.463001689256j)*x[0]**o + ((0.460353824457-0.910938015902j))*x[0] + ((-0.487889957083-0.811303502146j))*x[1]**o + ((0.030894073547-0.72801323377j))*x[1]
        ref[(0, 0, 1)]=(-0.961656561274+0.463001689256j)*x_ref[0]**o + ((0.460353824457-0.910938015902j))*x_ref[0] + ((-0.487889957083-0.811303502146j))*x_ref[1]**o + ((0.030894073547-0.72801323377j))*x_ref[1]
        arg[(0, 1, 0)]=(0.340489933066+0.477708094626j)*x[0]**o + ((0.352872767213+0.300501775545j))*x[0] + ((-0.155888497807+0.00598631000325j))*x[1]**o + ((-0.385372299455+0.581744506419j))*x[1]
        ref[(0, 1, 0)]=(0.340489933066+0.477708094626j)*x_ref[0]**o + ((0.352872767213+0.300501775545j))*x_ref[0] + ((-0.155888497807+0.00598631000325j))*x_ref[1]**o + ((-0.385372299455+0.581744506419j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.28993130269+0.036857739371j)*x[0]**o + ((-0.273146789226-0.161499117997j))*x[0] + ((0.689016831346+0.729087601647j))*x[1]**o + ((-0.195453495241-0.746750998849j))*x[1]
        ref[(0, 1, 1)]=(-0.28993130269+0.036857739371j)*x_ref[0]**o + ((-0.273146789226-0.161499117997j))*x_ref[0] + ((0.689016831346+0.729087601647j))*x_ref[1]**o + ((-0.195453495241-0.746750998849j))*x_ref[1]
        arg[(1, 0, 0)]=(-0.712558229506-0.825906097798j)*x[0]**o + ((-0.302978835663+0.245365084883j))*x[0] + ((-0.678448386146+0.441082456775j))*x[1]**o + ((-0.434175734882+0.0186846104569j))*x[1]
        ref[(1, 0, 0)]=(-0.712558229506-0.825906097798j)*x_ref[0]**o + ((-0.302978835663+0.245365084883j))*x_ref[0] + ((-0.678448386146+0.441082456775j))*x_ref[1]**o + ((-0.434175734882+0.0186846104569j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.172289415656-0.13575383443j)*x[0]**o + ((0.737653725525-0.722840995865j))*x[0] + ((-0.405241630525-0.398576787498j))*x[1]**o + ((0.135967194497-0.42468474682j))*x[1]
        ref[(1, 0, 1)]=(-0.172289415656-0.13575383443j)*x_ref[0]**o + ((0.737653725525-0.722840995865j))*x_ref[0] + ((-0.405241630525-0.398576787498j))*x_ref[1]**o + ((0.135967194497-0.42468474682j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.017856432854+0.788777912429j)*x[0]**o + ((-0.728836294302-0.894896302638j))*x[0] + ((0.24330796518-0.582132153151j))*x[1]**o + ((-0.140351457403-0.412435854694j))*x[1]
        ref[(1, 1, 0)]=(-0.017856432854+0.788777912429j)*x_ref[0]**o + ((-0.728836294302-0.894896302638j))*x_ref[0] + ((0.24330796518-0.582132153151j))*x_ref[1]**o + ((-0.140351457403-0.412435854694j))*x_ref[1]
        arg[(1, 1, 1)]=(0.303608483866-0.701727833873j)*x[0]**o + ((0.451232200232-0.975137739963j))*x[0] + ((-0.726282824206+0.587401503279j))*x[1]**o + ((0.584120202887+0.994629169422j))*x[1]
        ref[(1, 1, 1)]=(0.303608483866-0.701727833873j)*x_ref[0]**o + ((0.451232200232-0.975137739963j))*x_ref[0] + ((-0.726282824206+0.587401503279j))*x_ref[1]**o + ((0.584120202887+0.994629169422j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.462652677613-0.961382691204j)*x[2]**o + ((0.223127498969-0.612851641937j))*x[2]
            ref[(0, 0, 0)]+=(-0.462652677613-0.961382691204j)*x_ref[2]**o + ((0.223127498969-0.612851641937j))*x_ref[2]
            arg[(0, 0, 1)]+=(-0.874788259794+0.436350625354j)*x[2]**o + ((0.526545895523-0.938199072239j))*x[2]
            ref[(0, 0, 1)]+=(-0.874788259794+0.436350625354j)*x_ref[2]**o + ((0.526545895523-0.938199072239j))*x_ref[2]
            arg[(0, 1, 0)]+=(0.317546248478+0.775738186549j)*x[2]**o + ((-0.993432370522-0.191765307522j))*x[2]
            ref[(0, 1, 0)]+=(0.317546248478+0.775738186549j)*x_ref[2]**o + ((-0.993432370522-0.191765307522j))*x_ref[2]
            arg[(0, 1, 1)]+=(-0.549223241917+0.697021849104j)*x[2]**o + ((-0.0459201820855+0.289227051462j))*x[2]
            ref[(0, 1, 1)]+=(-0.549223241917+0.697021849104j)*x_ref[2]**o + ((-0.0459201820855+0.289227051462j))*x_ref[2]
            arg[(1, 0, 0)]+=(-0.296453429594-0.771031301212j)*x[2]**o + ((0.678516311454-0.674552525985j))*x[2]
            ref[(1, 0, 0)]+=(-0.296453429594-0.771031301212j)*x_ref[2]**o + ((0.678516311454-0.674552525985j))*x_ref[2]
            arg[(1, 0, 1)]+=(0.570282092139+0.0590335523947j)*x[2]**o + ((-0.876736068107-0.511317582346j))*x[2]
            ref[(1, 0, 1)]+=(0.570282092139+0.0590335523947j)*x_ref[2]**o + ((-0.876736068107-0.511317582346j))*x_ref[2]
            arg[(1, 1, 0)]+=(-0.00249675692396-0.404748647928j)*x[2]**o + ((-0.12851502305+0.0870264143735j))*x[2]
            ref[(1, 1, 0)]+=(-0.00249675692396-0.404748647928j)*x_ref[2]**o + ((-0.12851502305+0.0870264143735j))*x_ref[2]
            arg[(1, 1, 1)]+=(-0.268724927703+0.711890427808j)*x[2]**o + ((0.142853265745+0.719124506672j))*x[2]
            ref[(1, 1, 1)]+=(-0.268724927703+0.711890427808j)*x_ref[2]**o + ((0.142853265745+0.719124506672j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_Solution_rank4(self):
        """
        tests interpolation of rank 4 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3, 3, 2),w)
        ref = Data(0,(3, 3, 3, 2),w_ref)
        arg[(0, 0, 0, 0)]=(0.782653866315+0.802461541325j)*x[0]**o + ((-0.565434741665+0.0679541975213j))*x[0] + ((0.855088077574-0.47100592463j))*x[1]**o + ((0.0569908290042-0.192795521487j))*x[1]
        ref[(0, 0, 0, 0)]=(0.782653866315+0.802461541325j)*x_ref[0]**o + ((-0.565434741665+0.0679541975213j))*x_ref[0] + ((0.855088077574-0.47100592463j))*x_ref[1]**o + ((0.0569908290042-0.192795521487j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.87953166534-0.507495443642j)*x[0]**o + ((-0.735361978397+0.165885309916j))*x[0] + ((-0.558837198454-0.343555638331j))*x[1]**o + ((0.970136568855-0.48166867918j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.87953166534-0.507495443642j)*x_ref[0]**o + ((-0.735361978397+0.165885309916j))*x_ref[0] + ((-0.558837198454-0.343555638331j))*x_ref[1]**o + ((0.970136568855-0.48166867918j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(0.301568023329-0.175516597417j)*x[0]**o + ((0.554657176105+0.9617102119j))*x[0] + ((-0.0734155082242-0.399286078985j))*x[1]**o + ((0.300115187192-0.300675250869j))*x[1]
        ref[(0, 0, 1, 0)]=(0.301568023329-0.175516597417j)*x_ref[0]**o + ((0.554657176105+0.9617102119j))*x_ref[0] + ((-0.0734155082242-0.399286078985j))*x_ref[1]**o + ((0.300115187192-0.300675250869j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.124111395325+0.829267225131j)*x[0]**o + ((-0.981925931658+0.00965434647981j))*x[0] + ((0.207859353604-0.657874932827j))*x[1]**o + ((0.738868651421+0.400019779818j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.124111395325+0.829267225131j)*x_ref[0]**o + ((-0.981925931658+0.00965434647981j))*x_ref[0] + ((0.207859353604-0.657874932827j))*x_ref[1]**o + ((0.738868651421+0.400019779818j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(-0.769940158363-0.086790343484j)*x[0]**o + ((-0.301942187893+0.0659652273942j))*x[0] + ((-0.179566968449+0.828971057251j))*x[1]**o + ((0.673514699108-0.11675419586j))*x[1]
        ref[(0, 0, 2, 0)]=(-0.769940158363-0.086790343484j)*x_ref[0]**o + ((-0.301942187893+0.0659652273942j))*x_ref[0] + ((-0.179566968449+0.828971057251j))*x_ref[1]**o + ((0.673514699108-0.11675419586j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(-0.957831947724-0.614452284509j)*x[0]**o + ((-0.327892506852+0.609953360077j))*x[0] + ((0.771909948645-0.261229062119j))*x[1]**o + ((0.281339528067-0.147820126179j))*x[1]
        ref[(0, 0, 2, 1)]=(-0.957831947724-0.614452284509j)*x_ref[0]**o + ((-0.327892506852+0.609953360077j))*x_ref[0] + ((0.771909948645-0.261229062119j))*x_ref[1]**o + ((0.281339528067-0.147820126179j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(-0.544700218916+0.866070511404j)*x[0]**o + ((0.326333348856+0.343579522069j))*x[0] + ((0.167914696095+0.319268426503j))*x[1]**o + ((0.466979933272+0.900287374969j))*x[1]
        ref[(0, 1, 0, 0)]=(-0.544700218916+0.866070511404j)*x_ref[0]**o + ((0.326333348856+0.343579522069j))*x_ref[0] + ((0.167914696095+0.319268426503j))*x_ref[1]**o + ((0.466979933272+0.900287374969j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(0.866039701621+0.554309146513j)*x[0]**o + ((0.32025934525+0.0308433132112j))*x[0] + ((0.835777701653+0.176074410514j))*x[1]**o + ((-0.983604081013+0.685895029288j))*x[1]
        ref[(0, 1, 0, 1)]=(0.866039701621+0.554309146513j)*x_ref[0]**o + ((0.32025934525+0.0308433132112j))*x_ref[0] + ((0.835777701653+0.176074410514j))*x_ref[1]**o + ((-0.983604081013+0.685895029288j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(0.535938702081+0.505606460579j)*x[0]**o + ((0.701017734897-0.233789627274j))*x[0] + ((0.760540220489+0.865658430614j))*x[1]**o + ((-0.374210327307+0.854926354524j))*x[1]
        ref[(0, 1, 1, 0)]=(0.535938702081+0.505606460579j)*x_ref[0]**o + ((0.701017734897-0.233789627274j))*x_ref[0] + ((0.760540220489+0.865658430614j))*x_ref[1]**o + ((-0.374210327307+0.854926354524j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(-0.728945435717+0.0561180221486j)*x[0]**o + ((0.325324501145+0.225677729111j))*x[0] + ((-0.967021400028-0.117848998309j))*x[1]**o + ((-0.316432899976-0.553454403429j))*x[1]
        ref[(0, 1, 1, 1)]=(-0.728945435717+0.0561180221486j)*x_ref[0]**o + ((0.325324501145+0.225677729111j))*x_ref[0] + ((-0.967021400028-0.117848998309j))*x_ref[1]**o + ((-0.316432899976-0.553454403429j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(0.5282570939-0.579372413845j)*x[0]**o + ((0.978761181003+0.804692905944j))*x[0] + ((-0.42916447231-0.402676670002j))*x[1]**o + ((-0.307352924312-0.0503798259165j))*x[1]
        ref[(0, 1, 2, 0)]=(0.5282570939-0.579372413845j)*x_ref[0]**o + ((0.978761181003+0.804692905944j))*x_ref[0] + ((-0.42916447231-0.402676670002j))*x_ref[1]**o + ((-0.307352924312-0.0503798259165j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(0.288338594266+0.952561323236j)*x[0]**o + ((-0.682486105887-0.0744381732108j))*x[0] + ((0.402101876072+0.107246416209j))*x[1]**o + ((0.956828728177+0.0189737430935j))*x[1]
        ref[(0, 1, 2, 1)]=(0.288338594266+0.952561323236j)*x_ref[0]**o + ((-0.682486105887-0.0744381732108j))*x_ref[0] + ((0.402101876072+0.107246416209j))*x_ref[1]**o + ((0.956828728177+0.0189737430935j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(0.00968261502967-0.737164748834j)*x[0]**o + ((-0.438734712508-0.567259047059j))*x[0] + ((-0.208323022449+0.644036182013j))*x[1]**o + ((-0.80741416164+0.499824045048j))*x[1]
        ref[(0, 2, 0, 0)]=(0.00968261502967-0.737164748834j)*x_ref[0]**o + ((-0.438734712508-0.567259047059j))*x_ref[0] + ((-0.208323022449+0.644036182013j))*x_ref[1]**o + ((-0.80741416164+0.499824045048j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(-0.780989070193-0.464857130718j)*x[0]**o + ((-0.893051520703-0.31153671019j))*x[0] + ((-0.432357314366+0.999288401944j))*x[1]**o + ((0.535656920927+0.738098195888j))*x[1]
        ref[(0, 2, 0, 1)]=(-0.780989070193-0.464857130718j)*x_ref[0]**o + ((-0.893051520703-0.31153671019j))*x_ref[0] + ((-0.432357314366+0.999288401944j))*x_ref[1]**o + ((0.535656920927+0.738098195888j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(-0.727387509021+0.173375001999j)*x[0]**o + ((0.105066391253+0.618863135277j))*x[0] + ((-0.403350119506-0.106810456239j))*x[1]**o + ((-0.441690573604-0.655069788805j))*x[1]
        ref[(0, 2, 1, 0)]=(-0.727387509021+0.173375001999j)*x_ref[0]**o + ((0.105066391253+0.618863135277j))*x_ref[0] + ((-0.403350119506-0.106810456239j))*x_ref[1]**o + ((-0.441690573604-0.655069788805j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(0.796434385436+0.256727875379j)*x[0]**o + ((0.940522490654-0.741091913528j))*x[0] + ((0.45499663364-0.272182499042j))*x[1]**o + ((-0.232168824858-0.510268060424j))*x[1]
        ref[(0, 2, 1, 1)]=(0.796434385436+0.256727875379j)*x_ref[0]**o + ((0.940522490654-0.741091913528j))*x_ref[0] + ((0.45499663364-0.272182499042j))*x_ref[1]**o + ((-0.232168824858-0.510268060424j))*x_ref[1]
        arg[(0, 2, 2, 0)]=(0.114426714208+0.692633767102j)*x[0]**o + ((-0.163339006607-0.358855168212j))*x[0] + ((-0.268583806776-0.363226808728j))*x[1]**o + ((0.703952182601-0.513517392326j))*x[1]
        ref[(0, 2, 2, 0)]=(0.114426714208+0.692633767102j)*x_ref[0]**o + ((-0.163339006607-0.358855168212j))*x_ref[0] + ((-0.268583806776-0.363226808728j))*x_ref[1]**o + ((0.703952182601-0.513517392326j))*x_ref[1]
        arg[(0, 2, 2, 1)]=(0.72461999427+0.655715336215j)*x[0]**o + ((-0.500681101826+0.842723157027j))*x[0] + ((0.556898969748-0.588660802134j))*x[1]**o + ((-0.0233938956563+0.237589382099j))*x[1]
        ref[(0, 2, 2, 1)]=(0.72461999427+0.655715336215j)*x_ref[0]**o + ((-0.500681101826+0.842723157027j))*x_ref[0] + ((0.556898969748-0.588660802134j))*x_ref[1]**o + ((-0.0233938956563+0.237589382099j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.336504553693-0.878691115084j)*x[0]**o + ((-0.838357236172-0.504028074723j))*x[0] + ((-0.135425183152+0.387255407799j))*x[1]**o + ((-0.850268566635+0.753777896148j))*x[1]
        ref[(1, 0, 0, 0)]=(0.336504553693-0.878691115084j)*x_ref[0]**o + ((-0.838357236172-0.504028074723j))*x_ref[0] + ((-0.135425183152+0.387255407799j))*x_ref[1]**o + ((-0.850268566635+0.753777896148j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.00292102525097+0.485550005076j)*x[0]**o + ((-0.892829363873-0.874691362864j))*x[0] + ((-0.208198424043+0.862804316451j))*x[1]**o + ((-0.910841790475-0.845650205439j))*x[1]
        ref[(1, 0, 0, 1)]=(0.00292102525097+0.485550005076j)*x_ref[0]**o + ((-0.892829363873-0.874691362864j))*x_ref[0] + ((-0.208198424043+0.862804316451j))*x_ref[1]**o + ((-0.910841790475-0.845650205439j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(0.0855821705136-0.547518231054j)*x[0]**o + ((0.0636577147602-0.825076992425j))*x[0] + ((-0.408801746191-0.497413089256j))*x[1]**o + ((0.392244788559-0.150607058965j))*x[1]
        ref[(1, 0, 1, 0)]=(0.0855821705136-0.547518231054j)*x_ref[0]**o + ((0.0636577147602-0.825076992425j))*x_ref[0] + ((-0.408801746191-0.497413089256j))*x_ref[1]**o + ((0.392244788559-0.150607058965j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(-0.867911681239+0.962843047023j)*x[0]**o + ((-0.289536378564-0.799236945737j))*x[0] + ((-0.724452111513-0.940925842253j))*x[1]**o + ((0.204305021539-0.305878181618j))*x[1]
        ref[(1, 0, 1, 1)]=(-0.867911681239+0.962843047023j)*x_ref[0]**o + ((-0.289536378564-0.799236945737j))*x_ref[0] + ((-0.724452111513-0.940925842253j))*x_ref[1]**o + ((0.204305021539-0.305878181618j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(-0.0266155075822-0.547940308731j)*x[0]**o + ((0.448306274911-0.516704863217j))*x[0] + ((0.422483089807+0.569719090157j))*x[1]**o + ((-0.62684159448+0.296157437813j))*x[1]
        ref[(1, 0, 2, 0)]=(-0.0266155075822-0.547940308731j)*x_ref[0]**o + ((0.448306274911-0.516704863217j))*x_ref[0] + ((0.422483089807+0.569719090157j))*x_ref[1]**o + ((-0.62684159448+0.296157437813j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(0.0762257161134+0.994414231657j)*x[0]**o + ((-0.790974466866+0.529140399519j))*x[0] + ((0.89538572186-0.58758589519j))*x[1]**o + ((0.192116928349+0.143425599644j))*x[1]
        ref[(1, 0, 2, 1)]=(0.0762257161134+0.994414231657j)*x_ref[0]**o + ((-0.790974466866+0.529140399519j))*x_ref[0] + ((0.89538572186-0.58758589519j))*x_ref[1]**o + ((0.192116928349+0.143425599644j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(0.357257594057-0.578856983926j)*x[0]**o + ((-0.873483978354+0.418068282226j))*x[0] + ((0.424031850744-0.127676773643j))*x[1]**o + ((0.304159361634+0.627139700346j))*x[1]
        ref[(1, 1, 0, 0)]=(0.357257594057-0.578856983926j)*x_ref[0]**o + ((-0.873483978354+0.418068282226j))*x_ref[0] + ((0.424031850744-0.127676773643j))*x_ref[1]**o + ((0.304159361634+0.627139700346j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(0.502770576746+0.459918855574j)*x[0]**o + ((0.830497831954-0.0106835885418j))*x[0] + ((0.553461865006-0.859246120887j))*x[1]**o + ((0.74935601954-0.723492250961j))*x[1]
        ref[(1, 1, 0, 1)]=(0.502770576746+0.459918855574j)*x_ref[0]**o + ((0.830497831954-0.0106835885418j))*x_ref[0] + ((0.553461865006-0.859246120887j))*x_ref[1]**o + ((0.74935601954-0.723492250961j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(-0.430245878545-0.576048551873j)*x[0]**o + ((0.753436220466-0.462439125102j))*x[0] + ((0.200578886396-0.887855401323j))*x[1]**o + ((0.60989344782-0.42641409892j))*x[1]
        ref[(1, 1, 1, 0)]=(-0.430245878545-0.576048551873j)*x_ref[0]**o + ((0.753436220466-0.462439125102j))*x_ref[0] + ((0.200578886396-0.887855401323j))*x_ref[1]**o + ((0.60989344782-0.42641409892j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.600771770204-0.565199116222j)*x[0]**o + ((-0.00324791804974+0.293565752031j))*x[0] + ((0.216691404732+0.367944394075j))*x[1]**o + ((0.428158112931+0.541927232838j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.600771770204-0.565199116222j)*x_ref[0]**o + ((-0.00324791804974+0.293565752031j))*x_ref[0] + ((0.216691404732+0.367944394075j))*x_ref[1]**o + ((0.428158112931+0.541927232838j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(-0.725322738258-0.00420540187405j)*x[0]**o + ((0.617934117613+0.494938020708j))*x[0] + ((0.876929621629-0.751636877162j))*x[1]**o + ((0.620924501496-0.241648138725j))*x[1]
        ref[(1, 1, 2, 0)]=(-0.725322738258-0.00420540187405j)*x_ref[0]**o + ((0.617934117613+0.494938020708j))*x_ref[0] + ((0.876929621629-0.751636877162j))*x_ref[1]**o + ((0.620924501496-0.241648138725j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(-0.318448127936-0.0446648437523j)*x[0]**o + ((0.515014370847-0.533961868648j))*x[0] + ((-0.992345597302-0.651910660207j))*x[1]**o + ((0.145261524466+0.888676856554j))*x[1]
        ref[(1, 1, 2, 1)]=(-0.318448127936-0.0446648437523j)*x_ref[0]**o + ((0.515014370847-0.533961868648j))*x_ref[0] + ((-0.992345597302-0.651910660207j))*x_ref[1]**o + ((0.145261524466+0.888676856554j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(0.549014375845-0.531169725821j)*x[0]**o + ((0.887815355316-0.419756917266j))*x[0] + ((0.398139659303-0.438239975839j))*x[1]**o + ((0.545071982339+0.633769951072j))*x[1]
        ref[(1, 2, 0, 0)]=(0.549014375845-0.531169725821j)*x_ref[0]**o + ((0.887815355316-0.419756917266j))*x_ref[0] + ((0.398139659303-0.438239975839j))*x_ref[1]**o + ((0.545071982339+0.633769951072j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(-0.313512759004-0.905328021302j)*x[0]**o + ((-0.116360829106+0.00155808019573j))*x[0] + ((0.340342426374+0.295917535034j))*x[1]**o + ((0.313427534453-0.563028232693j))*x[1]
        ref[(1, 2, 0, 1)]=(-0.313512759004-0.905328021302j)*x_ref[0]**o + ((-0.116360829106+0.00155808019573j))*x_ref[0] + ((0.340342426374+0.295917535034j))*x_ref[1]**o + ((0.313427534453-0.563028232693j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(0.397917190721-0.269968374677j)*x[0]**o + ((-0.0786517783292+0.0950860761964j))*x[0] + ((-0.0940757383756-0.201564758184j))*x[1]**o + ((-0.771367699023-0.572475581956j))*x[1]
        ref[(1, 2, 1, 0)]=(0.397917190721-0.269968374677j)*x_ref[0]**o + ((-0.0786517783292+0.0950860761964j))*x_ref[0] + ((-0.0940757383756-0.201564758184j))*x_ref[1]**o + ((-0.771367699023-0.572475581956j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(0.96536451958+0.561360862891j)*x[0]**o + ((-0.937837861123+0.394508847297j))*x[0] + ((-0.440230594075+0.834119529179j))*x[1]**o + ((-0.565493378549-0.569664247843j))*x[1]
        ref[(1, 2, 1, 1)]=(0.96536451958+0.561360862891j)*x_ref[0]**o + ((-0.937837861123+0.394508847297j))*x_ref[0] + ((-0.440230594075+0.834119529179j))*x_ref[1]**o + ((-0.565493378549-0.569664247843j))*x_ref[1]
        arg[(1, 2, 2, 0)]=(0.0189214516978+0.990858709989j)*x[0]**o + ((-0.281806820762-0.128922150459j))*x[0] + ((0.9914083505-0.51139662159j))*x[1]**o + ((0.215298658727+0.770289501263j))*x[1]
        ref[(1, 2, 2, 0)]=(0.0189214516978+0.990858709989j)*x_ref[0]**o + ((-0.281806820762-0.128922150459j))*x_ref[0] + ((0.9914083505-0.51139662159j))*x_ref[1]**o + ((0.215298658727+0.770289501263j))*x_ref[1]
        arg[(1, 2, 2, 1)]=(-0.837498810891-0.0523102247673j)*x[0]**o + ((-0.489654788074-0.707899250559j))*x[0] + ((-0.594716053614-0.201016744064j))*x[1]**o + ((0.302751642841-0.721273176701j))*x[1]
        ref[(1, 2, 2, 1)]=(-0.837498810891-0.0523102247673j)*x_ref[0]**o + ((-0.489654788074-0.707899250559j))*x_ref[0] + ((-0.594716053614-0.201016744064j))*x_ref[1]**o + ((0.302751642841-0.721273176701j))*x_ref[1]
        arg[(2, 0, 0, 0)]=(0.670632303943-0.613098685221j)*x[0]**o + ((-0.22818491389-0.771717814324j))*x[0] + ((-0.50303562811-0.288835076225j))*x[1]**o + ((0.77548927345+0.532676513353j))*x[1]
        ref[(2, 0, 0, 0)]=(0.670632303943-0.613098685221j)*x_ref[0]**o + ((-0.22818491389-0.771717814324j))*x_ref[0] + ((-0.50303562811-0.288835076225j))*x_ref[1]**o + ((0.77548927345+0.532676513353j))*x_ref[1]
        arg[(2, 0, 0, 1)]=(0.46683514709+0.979961041776j)*x[0]**o + ((0.757340784911+0.0760592578341j))*x[0] + ((-0.750072337737+0.839934374131j))*x[1]**o + ((0.0662620791138+0.504662238189j))*x[1]
        ref[(2, 0, 0, 1)]=(0.46683514709+0.979961041776j)*x_ref[0]**o + ((0.757340784911+0.0760592578341j))*x_ref[0] + ((-0.750072337737+0.839934374131j))*x_ref[1]**o + ((0.0662620791138+0.504662238189j))*x_ref[1]
        arg[(2, 0, 1, 0)]=(-0.152347969807-0.147408778714j)*x[0]**o + ((-0.922734102883-0.559441544353j))*x[0] + ((0.520024710661-0.606076843898j))*x[1]**o + ((-0.0879473102494+0.952462945827j))*x[1]
        ref[(2, 0, 1, 0)]=(-0.152347969807-0.147408778714j)*x_ref[0]**o + ((-0.922734102883-0.559441544353j))*x_ref[0] + ((0.520024710661-0.606076843898j))*x_ref[1]**o + ((-0.0879473102494+0.952462945827j))*x_ref[1]
        arg[(2, 0, 1, 1)]=(0.891331679303+0.783962309606j)*x[0]**o + ((0.260200915711-0.770134482376j))*x[0] + ((0.579389740142+0.147767945262j))*x[1]**o + ((0.00170189642353+0.119307603725j))*x[1]
        ref[(2, 0, 1, 1)]=(0.891331679303+0.783962309606j)*x_ref[0]**o + ((0.260200915711-0.770134482376j))*x_ref[0] + ((0.579389740142+0.147767945262j))*x_ref[1]**o + ((0.00170189642353+0.119307603725j))*x_ref[1]
        arg[(2, 0, 2, 0)]=(-0.858338844997-0.861313478782j)*x[0]**o + ((0.990717139796+0.468380843547j))*x[0] + ((0.822503312305+0.690949455336j))*x[1]**o + ((0.202918297391-0.218623615147j))*x[1]
        ref[(2, 0, 2, 0)]=(-0.858338844997-0.861313478782j)*x_ref[0]**o + ((0.990717139796+0.468380843547j))*x_ref[0] + ((0.822503312305+0.690949455336j))*x_ref[1]**o + ((0.202918297391-0.218623615147j))*x_ref[1]
        arg[(2, 0, 2, 1)]=(-0.533209923798-0.447232346461j)*x[0]**o + ((-0.883893902653-0.99054439545j))*x[0] + ((-0.659635978817-0.825298458288j))*x[1]**o + ((-0.0152997813664-0.575877717723j))*x[1]
        ref[(2, 0, 2, 1)]=(-0.533209923798-0.447232346461j)*x_ref[0]**o + ((-0.883893902653-0.99054439545j))*x_ref[0] + ((-0.659635978817-0.825298458288j))*x_ref[1]**o + ((-0.0152997813664-0.575877717723j))*x_ref[1]
        arg[(2, 1, 0, 0)]=(-0.35214696082+0.0224033076598j)*x[0]**o + ((-0.977564387269-0.639245819194j))*x[0] + ((-0.827534000192+0.990908853552j))*x[1]**o + ((0.818498058335-0.73213535927j))*x[1]
        ref[(2, 1, 0, 0)]=(-0.35214696082+0.0224033076598j)*x_ref[0]**o + ((-0.977564387269-0.639245819194j))*x_ref[0] + ((-0.827534000192+0.990908853552j))*x_ref[1]**o + ((0.818498058335-0.73213535927j))*x_ref[1]
        arg[(2, 1, 0, 1)]=(-0.22753310475-0.589478732526j)*x[0]**o + ((-0.778181261233-0.17908807084j))*x[0] + ((0.979999725106+0.678329233364j))*x[1]**o + ((0.370876461849+0.477460068945j))*x[1]
        ref[(2, 1, 0, 1)]=(-0.22753310475-0.589478732526j)*x_ref[0]**o + ((-0.778181261233-0.17908807084j))*x_ref[0] + ((0.979999725106+0.678329233364j))*x_ref[1]**o + ((0.370876461849+0.477460068945j))*x_ref[1]
        arg[(2, 1, 1, 0)]=(-0.640499639273+0.258800065864j)*x[0]**o + ((-0.844613771204-0.557599539841j))*x[0] + ((0.257495259319-0.807631869506j))*x[1]**o + ((0.520624320345-0.351424870718j))*x[1]
        ref[(2, 1, 1, 0)]=(-0.640499639273+0.258800065864j)*x_ref[0]**o + ((-0.844613771204-0.557599539841j))*x_ref[0] + ((0.257495259319-0.807631869506j))*x_ref[1]**o + ((0.520624320345-0.351424870718j))*x_ref[1]
        arg[(2, 1, 1, 1)]=(-0.123492578757-0.0823246488971j)*x[0]**o + ((-0.774554666588+0.158632306879j))*x[0] + ((0.973945864685-0.921375124186j))*x[1]**o + ((-0.132781750837-0.0921129266247j))*x[1]
        ref[(2, 1, 1, 1)]=(-0.123492578757-0.0823246488971j)*x_ref[0]**o + ((-0.774554666588+0.158632306879j))*x_ref[0] + ((0.973945864685-0.921375124186j))*x_ref[1]**o + ((-0.132781750837-0.0921129266247j))*x_ref[1]
        arg[(2, 1, 2, 0)]=(-0.4254254622-0.283088056849j)*x[0]**o + ((-0.72778036269+0.605328751125j))*x[0] + ((0.901144360974+0.397954485258j))*x[1]**o + ((-0.372963050466+0.147558941348j))*x[1]
        ref[(2, 1, 2, 0)]=(-0.4254254622-0.283088056849j)*x_ref[0]**o + ((-0.72778036269+0.605328751125j))*x_ref[0] + ((0.901144360974+0.397954485258j))*x_ref[1]**o + ((-0.372963050466+0.147558941348j))*x_ref[1]
        arg[(2, 1, 2, 1)]=(0.789057010554-0.682435045609j)*x[0]**o + ((-0.237609511358-0.943300973601j))*x[0] + ((0.0233587226282-0.657374728278j))*x[1]**o + ((-0.806730316681+0.148974707397j))*x[1]
        ref[(2, 1, 2, 1)]=(0.789057010554-0.682435045609j)*x_ref[0]**o + ((-0.237609511358-0.943300973601j))*x_ref[0] + ((0.0233587226282-0.657374728278j))*x_ref[1]**o + ((-0.806730316681+0.148974707397j))*x_ref[1]
        arg[(2, 2, 0, 0)]=(0.473762618762-0.165603024211j)*x[0]**o + ((-0.610270623658+0.85334948677j))*x[0] + ((0.97359242005-0.539353404449j))*x[1]**o + ((0.240748324283+0.176800951008j))*x[1]
        ref[(2, 2, 0, 0)]=(0.473762618762-0.165603024211j)*x_ref[0]**o + ((-0.610270623658+0.85334948677j))*x_ref[0] + ((0.97359242005-0.539353404449j))*x_ref[1]**o + ((0.240748324283+0.176800951008j))*x_ref[1]
        arg[(2, 2, 0, 1)]=(-0.687577929156-0.804643659235j)*x[0]**o + ((-0.373456934763+0.247774753025j))*x[0] + ((0.214802281873-0.857592690231j))*x[1]**o + ((-0.159312591794-0.659152551952j))*x[1]
        ref[(2, 2, 0, 1)]=(-0.687577929156-0.804643659235j)*x_ref[0]**o + ((-0.373456934763+0.247774753025j))*x_ref[0] + ((0.214802281873-0.857592690231j))*x_ref[1]**o + ((-0.159312591794-0.659152551952j))*x_ref[1]
        arg[(2, 2, 1, 0)]=(0.518903068986+0.331374319006j)*x[0]**o + ((0.237747776103+0.900401192054j))*x[0] + ((0.0580199423257-0.706338167j))*x[1]**o + ((0.411717411986+0.890055648818j))*x[1]
        ref[(2, 2, 1, 0)]=(0.518903068986+0.331374319006j)*x_ref[0]**o + ((0.237747776103+0.900401192054j))*x_ref[0] + ((0.0580199423257-0.706338167j))*x_ref[1]**o + ((0.411717411986+0.890055648818j))*x_ref[1]
        arg[(2, 2, 1, 1)]=(-0.473274240306-0.428100258466j)*x[0]**o + ((-0.195546004055+0.322594290442j))*x[0] + ((0.418040885053-0.480716165213j))*x[1]**o + ((0.770494153877-0.64579218225j))*x[1]
        ref[(2, 2, 1, 1)]=(-0.473274240306-0.428100258466j)*x_ref[0]**o + ((-0.195546004055+0.322594290442j))*x_ref[0] + ((0.418040885053-0.480716165213j))*x_ref[1]**o + ((0.770494153877-0.64579218225j))*x_ref[1]
        arg[(2, 2, 2, 0)]=(-0.652290920498+0.346102837083j)*x[0]**o + ((0.392567316676-0.0264184724083j))*x[0] + ((-0.611131571313-0.823708039889j))*x[1]**o + ((0.600990701055-0.649620660866j))*x[1]
        ref[(2, 2, 2, 0)]=(-0.652290920498+0.346102837083j)*x_ref[0]**o + ((0.392567316676-0.0264184724083j))*x_ref[0] + ((-0.611131571313-0.823708039889j))*x_ref[1]**o + ((0.600990701055-0.649620660866j))*x_ref[1]
        arg[(2, 2, 2, 1)]=(0.128641521759-0.497131147371j)*x[0]**o + ((-0.693003336576+0.974786847037j))*x[0] + ((0.459883518421+0.250982525393j))*x[1]**o + ((0.403928963546-0.651199590831j))*x[1]
        ref[(2, 2, 2, 1)]=(0.128641521759-0.497131147371j)*x_ref[0]**o + ((-0.693003336576+0.974786847037j))*x_ref[0] + ((0.459883518421+0.250982525393j))*x_ref[1]**o + ((0.403928963546-0.651199590831j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(0.65951372781-0.489828713063j)*x[2]**o + ((0.247084086789-0.0282775181289j))*x[2]
            ref[(0, 0, 0, 0)]+=(0.65951372781-0.489828713063j)*x_ref[2]**o + ((0.247084086789-0.0282775181289j))*x_ref[2]
            arg[(0, 0, 0, 1)]+=(-0.471595809412+0.754409053897j)*x[2]**o + ((-0.108754371969-0.0470357460948j))*x[2]
            ref[(0, 0, 0, 1)]+=(-0.471595809412+0.754409053897j)*x_ref[2]**o + ((-0.108754371969-0.0470357460948j))*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.0556262260635+0.520176504223j)*x[2]**o + ((-0.366518407109-0.277149990455j))*x[2]
            ref[(0, 0, 1, 0)]+=(-0.0556262260635+0.520176504223j)*x_ref[2]**o + ((-0.366518407109-0.277149990455j))*x_ref[2]
            arg[(0, 0, 1, 1)]+=(-0.647607737804+0.992315802361j)*x[2]**o + ((-0.0601740805355+0.150203296593j))*x[2]
            ref[(0, 0, 1, 1)]+=(-0.647607737804+0.992315802361j)*x_ref[2]**o + ((-0.0601740805355+0.150203296593j))*x_ref[2]
            arg[(0, 0, 2, 0)]+=(-0.759373849292+0.525511283321j)*x[2]**o + ((0.023060230996+0.792918048848j))*x[2]
            ref[(0, 0, 2, 0)]+=(-0.759373849292+0.525511283321j)*x_ref[2]**o + ((0.023060230996+0.792918048848j))*x_ref[2]
            arg[(0, 0, 2, 1)]+=(-0.752431544046+0.103030288265j)*x[2]**o + ((0.383027429869-0.207191062117j))*x[2]
            ref[(0, 0, 2, 1)]+=(-0.752431544046+0.103030288265j)*x_ref[2]**o + ((0.383027429869-0.207191062117j))*x_ref[2]
            arg[(0, 1, 0, 0)]+=(0.398500350194+0.498924397061j)*x[2]**o + ((-0.267710357534-0.316047942157j))*x[2]
            ref[(0, 1, 0, 0)]+=(0.398500350194+0.498924397061j)*x_ref[2]**o + ((-0.267710357534-0.316047942157j))*x_ref[2]
            arg[(0, 1, 0, 1)]+=(0.506984308917+0.760045871405j)*x[2]**o + ((-0.0862536503082-0.288518475913j))*x[2]
            ref[(0, 1, 0, 1)]+=(0.506984308917+0.760045871405j)*x_ref[2]**o + ((-0.0862536503082-0.288518475913j))*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.516935703039+0.719788307726j)*x[2]**o + ((0.796023868531+0.5671750357j))*x[2]
            ref[(0, 1, 1, 0)]+=(-0.516935703039+0.719788307726j)*x_ref[2]**o + ((0.796023868531+0.5671750357j))*x_ref[2]
            arg[(0, 1, 1, 1)]+=(0.504555591598+0.420607514667j)*x[2]**o + ((0.391512404159-0.307567463045j))*x[2]
            ref[(0, 1, 1, 1)]+=(0.504555591598+0.420607514667j)*x_ref[2]**o + ((0.391512404159-0.307567463045j))*x_ref[2]
            arg[(0, 1, 2, 0)]+=(-0.897976119909-0.909266376351j)*x[2]**o + ((-0.791619324509+0.966231864701j))*x[2]
            ref[(0, 1, 2, 0)]+=(-0.897976119909-0.909266376351j)*x_ref[2]**o + ((-0.791619324509+0.966231864701j))*x_ref[2]
            arg[(0, 1, 2, 1)]+=(0.189859332772-0.404427320221j)*x[2]**o + ((0.368667189872-0.104435603748j))*x[2]
            ref[(0, 1, 2, 1)]+=(0.189859332772-0.404427320221j)*x_ref[2]**o + ((0.368667189872-0.104435603748j))*x_ref[2]
            arg[(0, 2, 0, 0)]+=(-0.18537699589-0.974924346874j)*x[2]**o + ((0.67870450448-0.481295363347j))*x[2]
            ref[(0, 2, 0, 0)]+=(-0.18537699589-0.974924346874j)*x_ref[2]**o + ((0.67870450448-0.481295363347j))*x_ref[2]
            arg[(0, 2, 0, 1)]+=(-0.264570891927-0.0317770761043j)*x[2]**o + ((-0.970801797941-0.174229491657j))*x[2]
            ref[(0, 2, 0, 1)]+=(-0.264570891927-0.0317770761043j)*x_ref[2]**o + ((-0.970801797941-0.174229491657j))*x_ref[2]
            arg[(0, 2, 1, 0)]+=(-0.137811726199+0.772327979954j)*x[2]**o + ((0.122138691759+0.607551120558j))*x[2]
            ref[(0, 2, 1, 0)]+=(-0.137811726199+0.772327979954j)*x_ref[2]**o + ((0.122138691759+0.607551120558j))*x_ref[2]
            arg[(0, 2, 1, 1)]+=(0.517322026519+0.7396880609j)*x[2]**o + ((-0.219612177839+0.210889375382j))*x[2]
            ref[(0, 2, 1, 1)]+=(0.517322026519+0.7396880609j)*x_ref[2]**o + ((-0.219612177839+0.210889375382j))*x_ref[2]
            arg[(0, 2, 2, 0)]+=(-0.150636374113+0.264687470465j)*x[2]**o + ((-0.108945095455-0.108333491307j))*x[2]
            ref[(0, 2, 2, 0)]+=(-0.150636374113+0.264687470465j)*x_ref[2]**o + ((-0.108945095455-0.108333491307j))*x_ref[2]
            arg[(0, 2, 2, 1)]+=(0.449930676579-0.26385976226j)*x[2]**o + ((-0.916381682669+0.458772948827j))*x[2]
            ref[(0, 2, 2, 1)]+=(0.449930676579-0.26385976226j)*x_ref[2]**o + ((-0.916381682669+0.458772948827j))*x_ref[2]
            arg[(1, 0, 0, 0)]+=(0.40153975444+0.257654554506j)*x[2]**o + ((-0.530694366772+0.593680669169j))*x[2]
            ref[(1, 0, 0, 0)]+=(0.40153975444+0.257654554506j)*x_ref[2]**o + ((-0.530694366772+0.593680669169j))*x_ref[2]
            arg[(1, 0, 0, 1)]+=(-0.0552633734213+0.520857633944j)*x[2]**o + ((-0.319147605619-0.537466267893j))*x[2]
            ref[(1, 0, 0, 1)]+=(-0.0552633734213+0.520857633944j)*x_ref[2]**o + ((-0.319147605619-0.537466267893j))*x_ref[2]
            arg[(1, 0, 1, 0)]+=(-0.184361079694-0.78786447717j)*x[2]**o + ((0.529226549568-0.883078544248j))*x[2]
            ref[(1, 0, 1, 0)]+=(-0.184361079694-0.78786447717j)*x_ref[2]**o + ((0.529226549568-0.883078544248j))*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.755523189727+0.807499167726j)*x[2]**o + ((0.39457517705-0.269137363001j))*x[2]
            ref[(1, 0, 1, 1)]+=(0.755523189727+0.807499167726j)*x_ref[2]**o + ((0.39457517705-0.269137363001j))*x_ref[2]
            arg[(1, 0, 2, 0)]+=(0.60091069507+0.727333019583j)*x[2]**o + ((-0.447451556542-0.82219726446j))*x[2]
            ref[(1, 0, 2, 0)]+=(0.60091069507+0.727333019583j)*x_ref[2]**o + ((-0.447451556542-0.82219726446j))*x_ref[2]
            arg[(1, 0, 2, 1)]+=(0.99382998814-0.942129203275j)*x[2]**o + ((0.49702556101-0.850945504163j))*x[2]
            ref[(1, 0, 2, 1)]+=(0.99382998814-0.942129203275j)*x_ref[2]**o + ((0.49702556101-0.850945504163j))*x_ref[2]
            arg[(1, 1, 0, 0)]+=(0.148577134272-0.0923161379281j)*x[2]**o + ((-0.638392103606+0.296293683246j))*x[2]
            ref[(1, 1, 0, 0)]+=(0.148577134272-0.0923161379281j)*x_ref[2]**o + ((-0.638392103606+0.296293683246j))*x_ref[2]
            arg[(1, 1, 0, 1)]+=(0.639044338474-0.0460698596674j)*x[2]**o + ((0.740654036971-0.434183590227j))*x[2]
            ref[(1, 1, 0, 1)]+=(0.639044338474-0.0460698596674j)*x_ref[2]**o + ((0.740654036971-0.434183590227j))*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.52384810363-0.766390197166j)*x[2]**o + ((-0.977525012054-0.0857812165641j))*x[2]
            ref[(1, 1, 1, 0)]+=(0.52384810363-0.766390197166j)*x_ref[2]**o + ((-0.977525012054-0.0857812165641j))*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.349136708829+0.236724580044j)*x[2]**o + ((0.169134182539-0.978317610438j))*x[2]
            ref[(1, 1, 1, 1)]+=(-0.349136708829+0.236724580044j)*x_ref[2]**o + ((0.169134182539-0.978317610438j))*x_ref[2]
            arg[(1, 1, 2, 0)]+=(-0.0540427110008+0.186137656845j)*x[2]**o + ((0.970973151526+0.0228803434771j))*x[2]
            ref[(1, 1, 2, 0)]+=(-0.0540427110008+0.186137656845j)*x_ref[2]**o + ((0.970973151526+0.0228803434771j))*x_ref[2]
            arg[(1, 1, 2, 1)]+=(0.824125578784-0.997244681432j)*x[2]**o + ((-0.723712697899+0.604854627912j))*x[2]
            ref[(1, 1, 2, 1)]+=(0.824125578784-0.997244681432j)*x_ref[2]**o + ((-0.723712697899+0.604854627912j))*x_ref[2]
            arg[(1, 2, 0, 0)]+=(0.263097377236+0.107839531857j)*x[2]**o + ((-0.0664843325364-0.919703361071j))*x[2]
            ref[(1, 2, 0, 0)]+=(0.263097377236+0.107839531857j)*x_ref[2]**o + ((-0.0664843325364-0.919703361071j))*x_ref[2]
            arg[(1, 2, 0, 1)]+=(0.282510298252+0.496666461069j)*x[2]**o + ((-0.129646091974+0.372353171998j))*x[2]
            ref[(1, 2, 0, 1)]+=(0.282510298252+0.496666461069j)*x_ref[2]**o + ((-0.129646091974+0.372353171998j))*x_ref[2]
            arg[(1, 2, 1, 0)]+=(-0.125136237347-0.67766262188j)*x[2]**o + ((-0.584909864337+0.36628654674j))*x[2]
            ref[(1, 2, 1, 0)]+=(-0.125136237347-0.67766262188j)*x_ref[2]**o + ((-0.584909864337+0.36628654674j))*x_ref[2]
            arg[(1, 2, 1, 1)]+=(-0.55595042103+0.441880449178j)*x[2]**o + ((0.0935870493938-0.981688427684j))*x[2]
            ref[(1, 2, 1, 1)]+=(-0.55595042103+0.441880449178j)*x_ref[2]**o + ((0.0935870493938-0.981688427684j))*x_ref[2]
            arg[(1, 2, 2, 0)]+=(0.0118119025528+0.861686872161j)*x[2]**o + ((0.157292370093+0.505574378395j))*x[2]
            ref[(1, 2, 2, 0)]+=(0.0118119025528+0.861686872161j)*x_ref[2]**o + ((0.157292370093+0.505574378395j))*x_ref[2]
            arg[(1, 2, 2, 1)]+=(-0.996526331878-0.919164814722j)*x[2]**o + ((0.181917098762+0.452804920097j))*x[2]
            ref[(1, 2, 2, 1)]+=(-0.996526331878-0.919164814722j)*x_ref[2]**o + ((0.181917098762+0.452804920097j))*x_ref[2]
            arg[(2, 0, 0, 0)]+=(0.0680271809231+0.66671081208j)*x[2]**o + ((-0.168250335315+0.191392850375j))*x[2]
            ref[(2, 0, 0, 0)]+=(0.0680271809231+0.66671081208j)*x_ref[2]**o + ((-0.168250335315+0.191392850375j))*x_ref[2]
            arg[(2, 0, 0, 1)]+=(-0.534061792147+0.127822547331j)*x[2]**o + ((0.94359004341+0.468470825652j))*x[2]
            ref[(2, 0, 0, 1)]+=(-0.534061792147+0.127822547331j)*x_ref[2]**o + ((0.94359004341+0.468470825652j))*x_ref[2]
            arg[(2, 0, 1, 0)]+=(-0.955844104655-0.117165794905j)*x[2]**o + ((-0.0359338723135+0.726040308666j))*x[2]
            ref[(2, 0, 1, 0)]+=(-0.955844104655-0.117165794905j)*x_ref[2]**o + ((-0.0359338723135+0.726040308666j))*x_ref[2]
            arg[(2, 0, 1, 1)]+=(-0.165575987416+0.874521741791j)*x[2]**o + ((-0.876673883262-0.143154947358j))*x[2]
            ref[(2, 0, 1, 1)]+=(-0.165575987416+0.874521741791j)*x_ref[2]**o + ((-0.876673883262-0.143154947358j))*x_ref[2]
            arg[(2, 0, 2, 0)]+=(-0.963076598466+0.0132843284215j)*x[2]**o + ((0.821480653951-0.553184778632j))*x[2]
            ref[(2, 0, 2, 0)]+=(-0.963076598466+0.0132843284215j)*x_ref[2]**o + ((0.821480653951-0.553184778632j))*x_ref[2]
            arg[(2, 0, 2, 1)]+=(0.468359395697-0.567853778505j)*x[2]**o + ((0.561420471981+0.101561859568j))*x[2]
            ref[(2, 0, 2, 1)]+=(0.468359395697-0.567853778505j)*x_ref[2]**o + ((0.561420471981+0.101561859568j))*x_ref[2]
            arg[(2, 1, 0, 0)]+=(0.428249410514-0.77343050087j)*x[2]**o + ((0.37987928735-0.662833183861j))*x[2]
            ref[(2, 1, 0, 0)]+=(0.428249410514-0.77343050087j)*x_ref[2]**o + ((0.37987928735-0.662833183861j))*x_ref[2]
            arg[(2, 1, 0, 1)]+=(-0.341840555537-0.346176364296j)*x[2]**o + ((-0.403986531062+0.805286910878j))*x[2]
            ref[(2, 1, 0, 1)]+=(-0.341840555537-0.346176364296j)*x_ref[2]**o + ((-0.403986531062+0.805286910878j))*x_ref[2]
            arg[(2, 1, 1, 0)]+=(0.40357425662+0.357365789203j)*x[2]**o + ((-0.236284436938+0.313266706137j))*x[2]
            ref[(2, 1, 1, 0)]+=(0.40357425662+0.357365789203j)*x_ref[2]**o + ((-0.236284436938+0.313266706137j))*x_ref[2]
            arg[(2, 1, 1, 1)]+=(-0.42058187268-0.411001058308j)*x[2]**o + ((0.821865188766-0.113058973758j))*x[2]
            ref[(2, 1, 1, 1)]+=(-0.42058187268-0.411001058308j)*x_ref[2]**o + ((0.821865188766-0.113058973758j))*x_ref[2]
            arg[(2, 1, 2, 0)]+=(-0.283289073081+0.0452603387343j)*x[2]**o + ((-0.0747954603814-0.246291612848j))*x[2]
            ref[(2, 1, 2, 0)]+=(-0.283289073081+0.0452603387343j)*x_ref[2]**o + ((-0.0747954603814-0.246291612848j))*x_ref[2]
            arg[(2, 1, 2, 1)]+=(0.0781864491586-0.499941484631j)*x[2]**o + ((0.977299571856-0.0766514729035j))*x[2]
            ref[(2, 1, 2, 1)]+=(0.0781864491586-0.499941484631j)*x_ref[2]**o + ((0.977299571856-0.0766514729035j))*x_ref[2]
            arg[(2, 2, 0, 0)]+=(0.909204483252+0.736554396695j)*x[2]**o + ((0.251470676285+0.756561648847j))*x[2]
            ref[(2, 2, 0, 0)]+=(0.909204483252+0.736554396695j)*x_ref[2]**o + ((0.251470676285+0.756561648847j))*x_ref[2]
            arg[(2, 2, 0, 1)]+=(0.221036536322+0.679660207503j)*x[2]**o + ((0.499461673776-0.555732981117j))*x[2]
            ref[(2, 2, 0, 1)]+=(0.221036536322+0.679660207503j)*x_ref[2]**o + ((0.499461673776-0.555732981117j))*x_ref[2]
            arg[(2, 2, 1, 0)]+=(-0.579643434941+0.496905181104j)*x[2]**o + ((-0.213416929607+0.750511606144j))*x[2]
            ref[(2, 2, 1, 0)]+=(-0.579643434941+0.496905181104j)*x_ref[2]**o + ((-0.213416929607+0.750511606144j))*x_ref[2]
            arg[(2, 2, 1, 1)]+=(0.175183539815+0.193043882757j)*x[2]**o + ((0.834036881509-0.0113423533545j))*x[2]
            ref[(2, 2, 1, 1)]+=(0.175183539815+0.193043882757j)*x_ref[2]**o + ((0.834036881509-0.0113423533545j))*x_ref[2]
            arg[(2, 2, 2, 0)]+=(-0.191029648484-0.575420120666j)*x[2]**o + ((0.759609062314+0.244881181781j))*x[2]
            ref[(2, 2, 2, 0)]+=(-0.191029648484-0.575420120666j)*x_ref[2]**o + ((0.759609062314+0.244881181781j))*x_ref[2]
            arg[(2, 2, 2, 1)]+=(-0.668809634783+0.776440701303j)*x[2]**o + ((-0.657676193915+0.124126411939j))*x[2]
            ref[(2, 2, 2, 1)]+=(-0.668809634783+0.776440701303j)*x_ref[2]**o + ((-0.657676193915+0.124126411939j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3, 3, 3, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedSolution_rank0(self):
        """
        tests interpolation of rank 0 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(0.276788116886-0.916008699501j)*x[0] + ((-0.511011502141+0.0935316671727j))*x[1]
        ref=(0.276788116886-0.916008699501j)*x_ref[0] + ((-0.511011502141+0.0935316671727j))*x_ref[1]
        if dim==3:
            arg+=((0.924475417998+0.164628558327j))*x[2]
            ref+=((0.924475417998+0.164628558327j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedSolution_rank1(self):
        """
        tests interpolation of rank 1 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,),w_ref)
        arg[(0,)]=(0.400041234683-0.566912434483j)*x[0] + ((-0.127916994502+0.809874932187j))*x[1]
        ref[(0,)]=(0.400041234683-0.566912434483j)*x_ref[0] + ((-0.127916994502+0.809874932187j))*x_ref[1]
        arg[(1,)]=(0.143065674676+0.192138174765j)*x[0] + ((-0.811717586622-0.43176498046j))*x[1]
        ref[(1,)]=(0.143065674676+0.192138174765j)*x_ref[0] + ((-0.811717586622-0.43176498046j))*x_ref[1]
        arg[(2,)]=(0.37191906992-0.758121992576j)*x[0] + ((-0.208130336067+0.518441517954j))*x[1]
        ref[(2,)]=(0.37191906992-0.758121992576j)*x_ref[0] + ((-0.208130336067+0.518441517954j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(0.532407558618+0.896706647495j)*x[2]
            ref[(0,)]+=(0.532407558618+0.896706647495j)*x_ref[2]
            arg[(1,)]+=(-0.823537403763+0.772735578063j)*x[2]
            ref[(1,)]+=(-0.823537403763+0.772735578063j)*x_ref[2]
            arg[(2,)]+=(-0.766956374096-0.0290016618175j)*x[2]
            ref[(2,)]+=(-0.766956374096-0.0290016618175j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedSolution_rank2(self):
        """
        tests interpolation of rank 2 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4),w)
        ref = Data(0,(2, 4),w_ref)
        arg[(0, 0)]=(-0.811038244296+0.273340585585j)*x[0] + ((-0.534689443607+0.60200700471j))*x[1]
        ref[(0, 0)]=(-0.811038244296+0.273340585585j)*x_ref[0] + ((-0.534689443607+0.60200700471j))*x_ref[1]
        arg[(0, 1)]=(0.927687463747-0.497469851741j)*x[0] + ((0.833943132579+0.164365583777j))*x[1]
        ref[(0, 1)]=(0.927687463747-0.497469851741j)*x_ref[0] + ((0.833943132579+0.164365583777j))*x_ref[1]
        arg[(0, 2)]=(0.383729662149-0.562366770182j)*x[0] + ((-0.552584721337+0.0847304557927j))*x[1]
        ref[(0, 2)]=(0.383729662149-0.562366770182j)*x_ref[0] + ((-0.552584721337+0.0847304557927j))*x_ref[1]
        arg[(0, 3)]=(-0.804204213021-0.593551013718j)*x[0] + ((0.146748290157+0.809999775082j))*x[1]
        ref[(0, 3)]=(-0.804204213021-0.593551013718j)*x_ref[0] + ((0.146748290157+0.809999775082j))*x_ref[1]
        arg[(1, 0)]=(0.722277894048-0.8011229921j)*x[0] + ((-0.986019804104-0.385838051098j))*x[1]
        ref[(1, 0)]=(0.722277894048-0.8011229921j)*x_ref[0] + ((-0.986019804104-0.385838051098j))*x_ref[1]
        arg[(1, 1)]=(0.0175146574346-0.654745776855j)*x[0] + ((0.784210209382+0.323806394417j))*x[1]
        ref[(1, 1)]=(0.0175146574346-0.654745776855j)*x_ref[0] + ((0.784210209382+0.323806394417j))*x_ref[1]
        arg[(1, 2)]=(-0.573743676867-0.770972941221j)*x[0] + ((-0.672078290552-0.885067743292j))*x[1]
        ref[(1, 2)]=(-0.573743676867-0.770972941221j)*x_ref[0] + ((-0.672078290552-0.885067743292j))*x_ref[1]
        arg[(1, 3)]=(-0.282359439587-0.67399986943j)*x[0] + ((-0.293142782773-0.815348510483j))*x[1]
        ref[(1, 3)]=(-0.282359439587-0.67399986943j)*x_ref[0] + ((-0.293142782773-0.815348510483j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(-0.156852897129-0.523884284923j)*x[2]
            ref[(0, 0)]+=(-0.156852897129-0.523884284923j)*x_ref[2]
            arg[(0, 1)]+=(0.745897787046-0.291765775477j)*x[2]
            ref[(0, 1)]+=(0.745897787046-0.291765775477j)*x_ref[2]
            arg[(0, 2)]+=(0.665575171811+0.116671273587j)*x[2]
            ref[(0, 2)]+=(0.665575171811+0.116671273587j)*x_ref[2]
            arg[(0, 3)]+=(0.605641035302+0.947591202909j)*x[2]
            ref[(0, 3)]+=(0.605641035302+0.947591202909j)*x_ref[2]
            arg[(1, 0)]+=(0.918523225592+0.350654023408j)*x[2]
            ref[(1, 0)]+=(0.918523225592+0.350654023408j)*x_ref[2]
            arg[(1, 1)]+=(0.492242232824-0.94460912257j)*x[2]
            ref[(1, 1)]+=(0.492242232824-0.94460912257j)*x_ref[2]
            arg[(1, 2)]+=(0.87591890879+0.722650218361j)*x[2]
            ref[(1, 2)]+=(0.87591890879+0.722650218361j)*x_ref[2]
            arg[(1, 3)]+=(0.224265316679-0.082110854283j)*x[2]
            ref[(1, 3)]+=(0.224265316679-0.082110854283j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedSolution_rank3(self):
        """
        tests interpolation of rank 3 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 4),w)
        ref = Data(0,(2, 2, 4),w_ref)
        arg[(0, 0, 0)]=(0.0369724156863+0.536225320526j)*x[0] + ((0.725598190982-0.764546966604j))*x[1]
        ref[(0, 0, 0)]=(0.0369724156863+0.536225320526j)*x_ref[0] + ((0.725598190982-0.764546966604j))*x_ref[1]
        arg[(0, 0, 1)]=(0.889224090582+0.572589058909j)*x[0] + ((-0.420012024602-0.591230809238j))*x[1]
        ref[(0, 0, 1)]=(0.889224090582+0.572589058909j)*x_ref[0] + ((-0.420012024602-0.591230809238j))*x_ref[1]
        arg[(0, 0, 2)]=(-0.486452588344+0.910488425702j)*x[0] + ((-0.0759409634363+0.511175053009j))*x[1]
        ref[(0, 0, 2)]=(-0.486452588344+0.910488425702j)*x_ref[0] + ((-0.0759409634363+0.511175053009j))*x_ref[1]
        arg[(0, 0, 3)]=(0.409662181663-0.957787228281j)*x[0] + ((0.179336805164+0.68869784088j))*x[1]
        ref[(0, 0, 3)]=(0.409662181663-0.957787228281j)*x_ref[0] + ((0.179336805164+0.68869784088j))*x_ref[1]
        arg[(0, 1, 0)]=(-0.195880403815+0.14795882198j)*x[0] + ((-0.987727453348+0.143825622116j))*x[1]
        ref[(0, 1, 0)]=(-0.195880403815+0.14795882198j)*x_ref[0] + ((-0.987727453348+0.143825622116j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.698946795262+0.904312985586j)*x[0] + ((-0.171387580518-0.54985613642j))*x[1]
        ref[(0, 1, 1)]=(-0.698946795262+0.904312985586j)*x_ref[0] + ((-0.171387580518-0.54985613642j))*x_ref[1]
        arg[(0, 1, 2)]=(0.362582194967+0.0479017097943j)*x[0] + ((-0.738004297257+0.0164580380333j))*x[1]
        ref[(0, 1, 2)]=(0.362582194967+0.0479017097943j)*x_ref[0] + ((-0.738004297257+0.0164580380333j))*x_ref[1]
        arg[(0, 1, 3)]=(0.843679292272-0.472958253698j)*x[0] + ((-0.463180899942+0.694976668326j))*x[1]
        ref[(0, 1, 3)]=(0.843679292272-0.472958253698j)*x_ref[0] + ((-0.463180899942+0.694976668326j))*x_ref[1]
        arg[(1, 0, 0)]=(-0.299952071691-0.14182920432j)*x[0] + ((-0.420729553172+0.463354139794j))*x[1]
        ref[(1, 0, 0)]=(-0.299952071691-0.14182920432j)*x_ref[0] + ((-0.420729553172+0.463354139794j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.660202231927-0.103828054199j)*x[0] + ((0.405901780116-0.54843910177j))*x[1]
        ref[(1, 0, 1)]=(-0.660202231927-0.103828054199j)*x_ref[0] + ((0.405901780116-0.54843910177j))*x_ref[1]
        arg[(1, 0, 2)]=(-0.0796321961523-0.975613777924j)*x[0] + ((-0.410605998237-0.764753259402j))*x[1]
        ref[(1, 0, 2)]=(-0.0796321961523-0.975613777924j)*x_ref[0] + ((-0.410605998237-0.764753259402j))*x_ref[1]
        arg[(1, 0, 3)]=(-0.741914648241+0.774551934192j)*x[0] + ((-0.630828669893+0.847538285578j))*x[1]
        ref[(1, 0, 3)]=(-0.741914648241+0.774551934192j)*x_ref[0] + ((-0.630828669893+0.847538285578j))*x_ref[1]
        arg[(1, 1, 0)]=(0.401112683433-0.83512643221j)*x[0] + ((-0.0653772615193+0.202573104713j))*x[1]
        ref[(1, 1, 0)]=(0.401112683433-0.83512643221j)*x_ref[0] + ((-0.0653772615193+0.202573104713j))*x_ref[1]
        arg[(1, 1, 1)]=(0.429893948401-0.671658074196j)*x[0] + ((-0.0690337797711+0.823353771886j))*x[1]
        ref[(1, 1, 1)]=(0.429893948401-0.671658074196j)*x_ref[0] + ((-0.0690337797711+0.823353771886j))*x_ref[1]
        arg[(1, 1, 2)]=(0.80092450324+0.131931683095j)*x[0] + ((-0.824818225499+0.923382947599j))*x[1]
        ref[(1, 1, 2)]=(0.80092450324+0.131931683095j)*x_ref[0] + ((-0.824818225499+0.923382947599j))*x_ref[1]
        arg[(1, 1, 3)]=(0.729533172752+0.849675011859j)*x[0] + ((-0.232260192925-0.473090341319j))*x[1]
        ref[(1, 1, 3)]=(0.729533172752+0.849675011859j)*x_ref[0] + ((-0.232260192925-0.473090341319j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(0.965489661481-0.60697265263j)*x[2]
            ref[(0, 0, 0)]+=(0.965489661481-0.60697265263j)*x_ref[2]
            arg[(0, 0, 1)]+=(0.406361604089+0.559895968424j)*x[2]
            ref[(0, 0, 1)]+=(0.406361604089+0.559895968424j)*x_ref[2]
            arg[(0, 0, 2)]+=(-0.152581719741+0.601123785503j)*x[2]
            ref[(0, 0, 2)]+=(-0.152581719741+0.601123785503j)*x_ref[2]
            arg[(0, 0, 3)]+=(0.765110880163+0.273343438827j)*x[2]
            ref[(0, 0, 3)]+=(0.765110880163+0.273343438827j)*x_ref[2]
            arg[(0, 1, 0)]+=(-0.850532052936+0.490078501284j)*x[2]
            ref[(0, 1, 0)]+=(-0.850532052936+0.490078501284j)*x_ref[2]
            arg[(0, 1, 1)]+=(0.219259378239-0.259602350797j)*x[2]
            ref[(0, 1, 1)]+=(0.219259378239-0.259602350797j)*x_ref[2]
            arg[(0, 1, 2)]+=(-0.0451370181153-0.0468212305031j)*x[2]
            ref[(0, 1, 2)]+=(-0.0451370181153-0.0468212305031j)*x_ref[2]
            arg[(0, 1, 3)]+=(0.890840775998+0.78886541686j)*x[2]
            ref[(0, 1, 3)]+=(0.890840775998+0.78886541686j)*x_ref[2]
            arg[(1, 0, 0)]+=(-0.151482541702+0.289199377194j)*x[2]
            ref[(1, 0, 0)]+=(-0.151482541702+0.289199377194j)*x_ref[2]
            arg[(1, 0, 1)]+=(0.901258388401+0.0123205307477j)*x[2]
            ref[(1, 0, 1)]+=(0.901258388401+0.0123205307477j)*x_ref[2]
            arg[(1, 0, 2)]+=(0.482090549618+0.882527353416j)*x[2]
            ref[(1, 0, 2)]+=(0.482090549618+0.882527353416j)*x_ref[2]
            arg[(1, 0, 3)]+=(0.143215853221-0.299441925361j)*x[2]
            ref[(1, 0, 3)]+=(0.143215853221-0.299441925361j)*x_ref[2]
            arg[(1, 1, 0)]+=(0.544451534238+0.137361600371j)*x[2]
            ref[(1, 1, 0)]+=(0.544451534238+0.137361600371j)*x_ref[2]
            arg[(1, 1, 1)]+=(-0.937531811704+0.894142042998j)*x[2]
            ref[(1, 1, 1)]+=(-0.937531811704+0.894142042998j)*x_ref[2]
            arg[(1, 1, 2)]+=(0.873904487415+0.775245064296j)*x[2]
            ref[(1, 1, 2)]+=(0.873904487415+0.775245064296j)*x_ref[2]
            arg[(1, 1, 3)]+=(-0.58161043286-0.250611497482j)*x[2]
            ref[(1, 1, 3)]+=(-0.58161043286-0.250611497482j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedSolution_rank4(self):
        """
        tests interpolation of rank 4 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 2, 2),w)
        ref = Data(0,(4, 4, 2, 2),w_ref)
        arg[(0, 0, 0, 0)]=(0.987432290757-0.499888677865j)*x[0] + ((-0.384347996799+0.71435159715j))*x[1]
        ref[(0, 0, 0, 0)]=(0.987432290757-0.499888677865j)*x_ref[0] + ((-0.384347996799+0.71435159715j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.243748219654-0.852417670751j)*x[0] + ((0.0614073831739+0.394339729319j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.243748219654-0.852417670751j)*x_ref[0] + ((0.0614073831739+0.394339729319j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(0.191526654339-0.453865373388j)*x[0] + ((-0.887006406822-0.296115594593j))*x[1]
        ref[(0, 0, 1, 0)]=(0.191526654339-0.453865373388j)*x_ref[0] + ((-0.887006406822-0.296115594593j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(0.682974729695+0.169935656185j)*x[0] + ((-0.451924330983+0.247486791102j))*x[1]
        ref[(0, 0, 1, 1)]=(0.682974729695+0.169935656185j)*x_ref[0] + ((-0.451924330983+0.247486791102j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.122316917214+0.79079085685j)*x[0] + ((0.703032327623-0.608432723178j))*x[1]
        ref[(0, 1, 0, 0)]=(0.122316917214+0.79079085685j)*x_ref[0] + ((0.703032327623-0.608432723178j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(0.889125859671+0.981479420951j)*x[0] + ((0.0277181322552-0.122896947035j))*x[1]
        ref[(0, 1, 0, 1)]=(0.889125859671+0.981479420951j)*x_ref[0] + ((0.0277181322552-0.122896947035j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.163899095999-0.127268479368j)*x[0] + ((0.567626225475+0.157557583084j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.163899095999-0.127268479368j)*x_ref[0] + ((0.567626225475+0.157557583084j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(0.130505599142+0.549615487779j)*x[0] + ((0.865213761968+0.441838898363j))*x[1]
        ref[(0, 1, 1, 1)]=(0.130505599142+0.549615487779j)*x_ref[0] + ((0.865213761968+0.441838898363j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(-0.698809106576+0.311659211459j)*x[0] + ((0.258546224609+0.118355119065j))*x[1]
        ref[(0, 2, 0, 0)]=(-0.698809106576+0.311659211459j)*x_ref[0] + ((0.258546224609+0.118355119065j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(-0.337680265746+0.88235073218j)*x[0] + ((-0.116777187374+0.97570933088j))*x[1]
        ref[(0, 2, 0, 1)]=(-0.337680265746+0.88235073218j)*x_ref[0] + ((-0.116777187374+0.97570933088j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(0.682479793701+0.214906300408j)*x[0] + ((-0.789251064836-0.260215342855j))*x[1]
        ref[(0, 2, 1, 0)]=(0.682479793701+0.214906300408j)*x_ref[0] + ((-0.789251064836-0.260215342855j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(-0.354936945331-0.806981091087j)*x[0] + ((-0.392832537113-0.419001192291j))*x[1]
        ref[(0, 2, 1, 1)]=(-0.354936945331-0.806981091087j)*x_ref[0] + ((-0.392832537113-0.419001192291j))*x_ref[1]
        arg[(0, 3, 0, 0)]=(0.0188415103237-0.878618405219j)*x[0] + ((-0.267258107439-0.567562108529j))*x[1]
        ref[(0, 3, 0, 0)]=(0.0188415103237-0.878618405219j)*x_ref[0] + ((-0.267258107439-0.567562108529j))*x_ref[1]
        arg[(0, 3, 0, 1)]=(-0.619091519279-0.0345365022896j)*x[0] + ((0.740050507598-0.151139165182j))*x[1]
        ref[(0, 3, 0, 1)]=(-0.619091519279-0.0345365022896j)*x_ref[0] + ((0.740050507598-0.151139165182j))*x_ref[1]
        arg[(0, 3, 1, 0)]=(-0.713937963427-0.727121766755j)*x[0] + ((0.321373243856-0.129450748234j))*x[1]
        ref[(0, 3, 1, 0)]=(-0.713937963427-0.727121766755j)*x_ref[0] + ((0.321373243856-0.129450748234j))*x_ref[1]
        arg[(0, 3, 1, 1)]=(0.969615144894+0.523151143577j)*x[0] + ((-0.972408613482-0.730915661909j))*x[1]
        ref[(0, 3, 1, 1)]=(0.969615144894+0.523151143577j)*x_ref[0] + ((-0.972408613482-0.730915661909j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(-0.177837925198+0.202018082616j)*x[0] + ((-0.595244951957+0.876329932497j))*x[1]
        ref[(1, 0, 0, 0)]=(-0.177837925198+0.202018082616j)*x_ref[0] + ((-0.595244951957+0.876329932497j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(-0.0338146571976-0.749807569366j)*x[0] + ((0.569898900741-0.3359891576j))*x[1]
        ref[(1, 0, 0, 1)]=(-0.0338146571976-0.749807569366j)*x_ref[0] + ((0.569898900741-0.3359891576j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(0.0846138276292+0.754158351518j)*x[0] + ((-0.362406813201+0.207329109205j))*x[1]
        ref[(1, 0, 1, 0)]=(0.0846138276292+0.754158351518j)*x_ref[0] + ((-0.362406813201+0.207329109205j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(-0.0243435497579-0.760858222152j)*x[0] + ((-0.585034507127+0.611612559064j))*x[1]
        ref[(1, 0, 1, 1)]=(-0.0243435497579-0.760858222152j)*x_ref[0] + ((-0.585034507127+0.611612559064j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(0.40416096975-0.676092677627j)*x[0] + ((-0.199558503945+0.149533231978j))*x[1]
        ref[(1, 1, 0, 0)]=(0.40416096975-0.676092677627j)*x_ref[0] + ((-0.199558503945+0.149533231978j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(0.620402205652+0.354416255692j)*x[0] + ((-0.741841240504+0.0878952871453j))*x[1]
        ref[(1, 1, 0, 1)]=(0.620402205652+0.354416255692j)*x_ref[0] + ((-0.741841240504+0.0878952871453j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.940458068982-0.572563591621j)*x[0] + ((-0.619534064628+0.905036611062j))*x[1]
        ref[(1, 1, 1, 0)]=(0.940458068982-0.572563591621j)*x_ref[0] + ((-0.619534064628+0.905036611062j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.088268114331-0.728523331605j)*x[0] + ((-0.269569805417+0.859396294684j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.088268114331-0.728523331605j)*x_ref[0] + ((-0.269569805417+0.859396294684j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(0.0959475788227+0.364612780152j)*x[0] + ((-0.970267600703+0.851804511227j))*x[1]
        ref[(1, 2, 0, 0)]=(0.0959475788227+0.364612780152j)*x_ref[0] + ((-0.970267600703+0.851804511227j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(-0.545741688944-0.153673809193j)*x[0] + ((0.403454015738+0.656005052953j))*x[1]
        ref[(1, 2, 0, 1)]=(-0.545741688944-0.153673809193j)*x_ref[0] + ((0.403454015738+0.656005052953j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(-0.397439136915-0.617047983568j)*x[0] + ((-0.654454078936+0.644110753377j))*x[1]
        ref[(1, 2, 1, 0)]=(-0.397439136915-0.617047983568j)*x_ref[0] + ((-0.654454078936+0.644110753377j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(-0.592973414593+0.810517786873j)*x[0] + ((0.526665110192-0.242746911984j))*x[1]
        ref[(1, 2, 1, 1)]=(-0.592973414593+0.810517786873j)*x_ref[0] + ((0.526665110192-0.242746911984j))*x_ref[1]
        arg[(1, 3, 0, 0)]=(0.533104686286-0.961568239935j)*x[0] + ((-0.374578911726+0.795333702819j))*x[1]
        ref[(1, 3, 0, 0)]=(0.533104686286-0.961568239935j)*x_ref[0] + ((-0.374578911726+0.795333702819j))*x_ref[1]
        arg[(1, 3, 0, 1)]=(-0.969370201117-0.106356252083j)*x[0] + ((-0.750799756405-0.366314949324j))*x[1]
        ref[(1, 3, 0, 1)]=(-0.969370201117-0.106356252083j)*x_ref[0] + ((-0.750799756405-0.366314949324j))*x_ref[1]
        arg[(1, 3, 1, 0)]=(-0.47062461508+0.973613706827j)*x[0] + ((0.460403660941-0.0185957870334j))*x[1]
        ref[(1, 3, 1, 0)]=(-0.47062461508+0.973613706827j)*x_ref[0] + ((0.460403660941-0.0185957870334j))*x_ref[1]
        arg[(1, 3, 1, 1)]=(-0.470876165962+0.619157701644j)*x[0] + ((0.493184860663+0.401337676124j))*x[1]
        ref[(1, 3, 1, 1)]=(-0.470876165962+0.619157701644j)*x_ref[0] + ((0.493184860663+0.401337676124j))*x_ref[1]
        arg[(2, 0, 0, 0)]=(0.321194630343-0.706274275602j)*x[0] + ((0.188036344784-0.574316560039j))*x[1]
        ref[(2, 0, 0, 0)]=(0.321194630343-0.706274275602j)*x_ref[0] + ((0.188036344784-0.574316560039j))*x_ref[1]
        arg[(2, 0, 0, 1)]=(0.755086323892-0.740594838389j)*x[0] + ((-0.709840164227-0.0917569006991j))*x[1]
        ref[(2, 0, 0, 1)]=(0.755086323892-0.740594838389j)*x_ref[0] + ((-0.709840164227-0.0917569006991j))*x_ref[1]
        arg[(2, 0, 1, 0)]=(-0.0131229919853+0.747288541303j)*x[0] + ((0.91412459944+0.984906195966j))*x[1]
        ref[(2, 0, 1, 0)]=(-0.0131229919853+0.747288541303j)*x_ref[0] + ((0.91412459944+0.984906195966j))*x_ref[1]
        arg[(2, 0, 1, 1)]=(0.368303013965+0.19456474529j)*x[0] + ((-0.233374975421-0.494874220549j))*x[1]
        ref[(2, 0, 1, 1)]=(0.368303013965+0.19456474529j)*x_ref[0] + ((-0.233374975421-0.494874220549j))*x_ref[1]
        arg[(2, 1, 0, 0)]=(0.0790994395974-0.275764749739j)*x[0] + ((0.0598609332422-0.570687412764j))*x[1]
        ref[(2, 1, 0, 0)]=(0.0790994395974-0.275764749739j)*x_ref[0] + ((0.0598609332422-0.570687412764j))*x_ref[1]
        arg[(2, 1, 0, 1)]=(-0.788854215458+0.163527128928j)*x[0] + ((-0.993126667422+0.313596960676j))*x[1]
        ref[(2, 1, 0, 1)]=(-0.788854215458+0.163527128928j)*x_ref[0] + ((-0.993126667422+0.313596960676j))*x_ref[1]
        arg[(2, 1, 1, 0)]=(-0.954073201278-0.641929763006j)*x[0] + ((0.153605020064-0.00694861506179j))*x[1]
        ref[(2, 1, 1, 0)]=(-0.954073201278-0.641929763006j)*x_ref[0] + ((0.153605020064-0.00694861506179j))*x_ref[1]
        arg[(2, 1, 1, 1)]=(-0.586099696835-0.524521205901j)*x[0] + ((0.435929103135-0.733496272616j))*x[1]
        ref[(2, 1, 1, 1)]=(-0.586099696835-0.524521205901j)*x_ref[0] + ((0.435929103135-0.733496272616j))*x_ref[1]
        arg[(2, 2, 0, 0)]=(0.220482851361-0.894330462077j)*x[0] + ((0.493243182832+0.0976021805711j))*x[1]
        ref[(2, 2, 0, 0)]=(0.220482851361-0.894330462077j)*x_ref[0] + ((0.493243182832+0.0976021805711j))*x_ref[1]
        arg[(2, 2, 0, 1)]=(-0.787865552817+0.103219128182j)*x[0] + ((0.836035518554+0.661634145426j))*x[1]
        ref[(2, 2, 0, 1)]=(-0.787865552817+0.103219128182j)*x_ref[0] + ((0.836035518554+0.661634145426j))*x_ref[1]
        arg[(2, 2, 1, 0)]=(0.541475028096+0.377641907916j)*x[0] + ((-0.905226046641+0.269618731698j))*x[1]
        ref[(2, 2, 1, 0)]=(0.541475028096+0.377641907916j)*x_ref[0] + ((-0.905226046641+0.269618731698j))*x_ref[1]
        arg[(2, 2, 1, 1)]=(-0.524514225222-0.818821173495j)*x[0] + ((-0.536207361196+0.630901693834j))*x[1]
        ref[(2, 2, 1, 1)]=(-0.524514225222-0.818821173495j)*x_ref[0] + ((-0.536207361196+0.630901693834j))*x_ref[1]
        arg[(2, 3, 0, 0)]=(0.917564512714+0.665700772193j)*x[0] + ((0.288415842136-0.475997904964j))*x[1]
        ref[(2, 3, 0, 0)]=(0.917564512714+0.665700772193j)*x_ref[0] + ((0.288415842136-0.475997904964j))*x_ref[1]
        arg[(2, 3, 0, 1)]=(0.348448151076+0.518523733379j)*x[0] + ((-0.530278386862+0.973163651401j))*x[1]
        ref[(2, 3, 0, 1)]=(0.348448151076+0.518523733379j)*x_ref[0] + ((-0.530278386862+0.973163651401j))*x_ref[1]
        arg[(2, 3, 1, 0)]=(-0.898066792403-0.266545265333j)*x[0] + ((-0.741386663678-0.686308028262j))*x[1]
        ref[(2, 3, 1, 0)]=(-0.898066792403-0.266545265333j)*x_ref[0] + ((-0.741386663678-0.686308028262j))*x_ref[1]
        arg[(2, 3, 1, 1)]=(-0.0346416359945-0.450801197602j)*x[0] + ((-0.189823129973+0.261933734459j))*x[1]
        ref[(2, 3, 1, 1)]=(-0.0346416359945-0.450801197602j)*x_ref[0] + ((-0.189823129973+0.261933734459j))*x_ref[1]
        arg[(3, 0, 0, 0)]=(0.0792902673099+0.444524024316j)*x[0] + ((0.978428973446-0.603825700112j))*x[1]
        ref[(3, 0, 0, 0)]=(0.0792902673099+0.444524024316j)*x_ref[0] + ((0.978428973446-0.603825700112j))*x_ref[1]
        arg[(3, 0, 0, 1)]=(0.88327246967+0.873728920403j)*x[0] + ((-0.517050561489-0.0451087952361j))*x[1]
        ref[(3, 0, 0, 1)]=(0.88327246967+0.873728920403j)*x_ref[0] + ((-0.517050561489-0.0451087952361j))*x_ref[1]
        arg[(3, 0, 1, 0)]=(0.39685182877-0.520447573571j)*x[0] + ((0.743650787681+0.914412226146j))*x[1]
        ref[(3, 0, 1, 0)]=(0.39685182877-0.520447573571j)*x_ref[0] + ((0.743650787681+0.914412226146j))*x_ref[1]
        arg[(3, 0, 1, 1)]=(0.838738729792+0.866573750868j)*x[0] + ((-0.433695532669-0.513943546129j))*x[1]
        ref[(3, 0, 1, 1)]=(0.838738729792+0.866573750868j)*x_ref[0] + ((-0.433695532669-0.513943546129j))*x_ref[1]
        arg[(3, 1, 0, 0)]=(-0.461292134633+0.826886521876j)*x[0] + ((-0.891765114996-0.651253933629j))*x[1]
        ref[(3, 1, 0, 0)]=(-0.461292134633+0.826886521876j)*x_ref[0] + ((-0.891765114996-0.651253933629j))*x_ref[1]
        arg[(3, 1, 0, 1)]=(-0.000760949112875+0.298964660421j)*x[0] + ((0.518603457398-0.806258789407j))*x[1]
        ref[(3, 1, 0, 1)]=(-0.000760949112875+0.298964660421j)*x_ref[0] + ((0.518603457398-0.806258789407j))*x_ref[1]
        arg[(3, 1, 1, 0)]=(-0.723784646391-0.919899167138j)*x[0] + ((0.613956169435-0.620037761562j))*x[1]
        ref[(3, 1, 1, 0)]=(-0.723784646391-0.919899167138j)*x_ref[0] + ((0.613956169435-0.620037761562j))*x_ref[1]
        arg[(3, 1, 1, 1)]=(0.309968126717+0.434051255487j)*x[0] + ((-0.839582761055+0.808262163988j))*x[1]
        ref[(3, 1, 1, 1)]=(0.309968126717+0.434051255487j)*x_ref[0] + ((-0.839582761055+0.808262163988j))*x_ref[1]
        arg[(3, 2, 0, 0)]=(-0.642642491979-0.747809918558j)*x[0] + ((0.697836583681-0.291510279186j))*x[1]
        ref[(3, 2, 0, 0)]=(-0.642642491979-0.747809918558j)*x_ref[0] + ((0.697836583681-0.291510279186j))*x_ref[1]
        arg[(3, 2, 0, 1)]=(-0.141645823761+0.807946733157j)*x[0] + ((-0.572015363496-0.0271347412295j))*x[1]
        ref[(3, 2, 0, 1)]=(-0.141645823761+0.807946733157j)*x_ref[0] + ((-0.572015363496-0.0271347412295j))*x_ref[1]
        arg[(3, 2, 1, 0)]=(0.648034231772+0.801685984977j)*x[0] + ((-0.842871266472-0.174679829348j))*x[1]
        ref[(3, 2, 1, 0)]=(0.648034231772+0.801685984977j)*x_ref[0] + ((-0.842871266472-0.174679829348j))*x_ref[1]
        arg[(3, 2, 1, 1)]=(-0.755458271089-0.700941207229j)*x[0] + ((-0.835332902458+0.146145268585j))*x[1]
        ref[(3, 2, 1, 1)]=(-0.755458271089-0.700941207229j)*x_ref[0] + ((-0.835332902458+0.146145268585j))*x_ref[1]
        arg[(3, 3, 0, 0)]=(-0.18975231827+0.529814551948j)*x[0] + ((-0.212964807735+0.934242986342j))*x[1]
        ref[(3, 3, 0, 0)]=(-0.18975231827+0.529814551948j)*x_ref[0] + ((-0.212964807735+0.934242986342j))*x_ref[1]
        arg[(3, 3, 0, 1)]=(0.80358275417-0.596733386873j)*x[0] + ((-0.994101892659+0.143272925423j))*x[1]
        ref[(3, 3, 0, 1)]=(0.80358275417-0.596733386873j)*x_ref[0] + ((-0.994101892659+0.143272925423j))*x_ref[1]
        arg[(3, 3, 1, 0)]=(-0.985371326665+0.963287382827j)*x[0] + ((0.22031718328+0.440560506071j))*x[1]
        ref[(3, 3, 1, 0)]=(-0.985371326665+0.963287382827j)*x_ref[0] + ((0.22031718328+0.440560506071j))*x_ref[1]
        arg[(3, 3, 1, 1)]=(-0.174378795308-0.627520751925j)*x[0] + ((-0.102002056329+0.337227865243j))*x[1]
        ref[(3, 3, 1, 1)]=(-0.174378795308-0.627520751925j)*x_ref[0] + ((-0.102002056329+0.337227865243j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.499400721948-0.213328461205j)*x[2]
            ref[(0, 0, 0, 0)]+=(-0.499400721948-0.213328461205j)*x_ref[2]
            arg[(0, 0, 0, 1)]+=(-0.625064718439+0.208489975289j)*x[2]
            ref[(0, 0, 0, 1)]+=(-0.625064718439+0.208489975289j)*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.305490348848-0.380960961197j)*x[2]
            ref[(0, 0, 1, 0)]+=(-0.305490348848-0.380960961197j)*x_ref[2]
            arg[(0, 0, 1, 1)]+=(0.113337497729-0.47398967188j)*x[2]
            ref[(0, 0, 1, 1)]+=(0.113337497729-0.47398967188j)*x_ref[2]
            arg[(0, 1, 0, 0)]+=(0.831106900302-0.278320288758j)*x[2]
            ref[(0, 1, 0, 0)]+=(0.831106900302-0.278320288758j)*x_ref[2]
            arg[(0, 1, 0, 1)]+=(0.738770602504-0.369222735715j)*x[2]
            ref[(0, 1, 0, 1)]+=(0.738770602504-0.369222735715j)*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.030337632602+0.933766463408j)*x[2]
            ref[(0, 1, 1, 0)]+=(-0.030337632602+0.933766463408j)*x_ref[2]
            arg[(0, 1, 1, 1)]+=(-0.530882994946-0.178865413204j)*x[2]
            ref[(0, 1, 1, 1)]+=(-0.530882994946-0.178865413204j)*x_ref[2]
            arg[(0, 2, 0, 0)]+=(0.294835606629-0.670100417131j)*x[2]
            ref[(0, 2, 0, 0)]+=(0.294835606629-0.670100417131j)*x_ref[2]
            arg[(0, 2, 0, 1)]+=(0.423454981963-0.801066456951j)*x[2]
            ref[(0, 2, 0, 1)]+=(0.423454981963-0.801066456951j)*x_ref[2]
            arg[(0, 2, 1, 0)]+=(0.916387087602+0.726771545729j)*x[2]
            ref[(0, 2, 1, 0)]+=(0.916387087602+0.726771545729j)*x_ref[2]
            arg[(0, 2, 1, 1)]+=(-0.820880509147-0.252159513704j)*x[2]
            ref[(0, 2, 1, 1)]+=(-0.820880509147-0.252159513704j)*x_ref[2]
            arg[(0, 3, 0, 0)]+=(0.374887585709-0.724915844018j)*x[2]
            ref[(0, 3, 0, 0)]+=(0.374887585709-0.724915844018j)*x_ref[2]
            arg[(0, 3, 0, 1)]+=(0.416787004641+0.570322268165j)*x[2]
            ref[(0, 3, 0, 1)]+=(0.416787004641+0.570322268165j)*x_ref[2]
            arg[(0, 3, 1, 0)]+=(0.0532375261124-0.686105164733j)*x[2]
            ref[(0, 3, 1, 0)]+=(0.0532375261124-0.686105164733j)*x_ref[2]
            arg[(0, 3, 1, 1)]+=(-0.528994699708+0.873517519892j)*x[2]
            ref[(0, 3, 1, 1)]+=(-0.528994699708+0.873517519892j)*x_ref[2]
            arg[(1, 0, 0, 0)]+=(-0.35430324071+0.550472656053j)*x[2]
            ref[(1, 0, 0, 0)]+=(-0.35430324071+0.550472656053j)*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.547555100114+0.126991897071j)*x[2]
            ref[(1, 0, 0, 1)]+=(0.547555100114+0.126991897071j)*x_ref[2]
            arg[(1, 0, 1, 0)]+=(-0.446165822793-0.861464979516j)*x[2]
            ref[(1, 0, 1, 0)]+=(-0.446165822793-0.861464979516j)*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.673607592318+0.874508302632j)*x[2]
            ref[(1, 0, 1, 1)]+=(0.673607592318+0.874508302632j)*x_ref[2]
            arg[(1, 1, 0, 0)]+=(0.505978299517+0.789199689134j)*x[2]
            ref[(1, 1, 0, 0)]+=(0.505978299517+0.789199689134j)*x_ref[2]
            arg[(1, 1, 0, 1)]+=(-0.394836491811-0.0234705775244j)*x[2]
            ref[(1, 1, 0, 1)]+=(-0.394836491811-0.0234705775244j)*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.893239920062-0.169961946669j)*x[2]
            ref[(1, 1, 1, 0)]+=(0.893239920062-0.169961946669j)*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.43673424837+0.655668742961j)*x[2]
            ref[(1, 1, 1, 1)]+=(-0.43673424837+0.655668742961j)*x_ref[2]
            arg[(1, 2, 0, 0)]+=(0.413453534405+0.406328065391j)*x[2]
            ref[(1, 2, 0, 0)]+=(0.413453534405+0.406328065391j)*x_ref[2]
            arg[(1, 2, 0, 1)]+=(0.166043559938+0.813801420854j)*x[2]
            ref[(1, 2, 0, 1)]+=(0.166043559938+0.813801420854j)*x_ref[2]
            arg[(1, 2, 1, 0)]+=(0.628379873124-0.320745203949j)*x[2]
            ref[(1, 2, 1, 0)]+=(0.628379873124-0.320745203949j)*x_ref[2]
            arg[(1, 2, 1, 1)]+=(-0.372781118101-0.349652727467j)*x[2]
            ref[(1, 2, 1, 1)]+=(-0.372781118101-0.349652727467j)*x_ref[2]
            arg[(1, 3, 0, 0)]+=(-0.907395837667+0.241817585482j)*x[2]
            ref[(1, 3, 0, 0)]+=(-0.907395837667+0.241817585482j)*x_ref[2]
            arg[(1, 3, 0, 1)]+=(0.934052715215-0.401698058293j)*x[2]
            ref[(1, 3, 0, 1)]+=(0.934052715215-0.401698058293j)*x_ref[2]
            arg[(1, 3, 1, 0)]+=(0.278977830945-0.857371620498j)*x[2]
            ref[(1, 3, 1, 0)]+=(0.278977830945-0.857371620498j)*x_ref[2]
            arg[(1, 3, 1, 1)]+=(0.273521501252+0.132186446777j)*x[2]
            ref[(1, 3, 1, 1)]+=(0.273521501252+0.132186446777j)*x_ref[2]
            arg[(2, 0, 0, 0)]+=(-0.523817287835+0.57424631311j)*x[2]
            ref[(2, 0, 0, 0)]+=(-0.523817287835+0.57424631311j)*x_ref[2]
            arg[(2, 0, 0, 1)]+=(-0.0333929313067-0.0780535013863j)*x[2]
            ref[(2, 0, 0, 1)]+=(-0.0333929313067-0.0780535013863j)*x_ref[2]
            arg[(2, 0, 1, 0)]+=(0.941471006279+0.360745976292j)*x[2]
            ref[(2, 0, 1, 0)]+=(0.941471006279+0.360745976292j)*x_ref[2]
            arg[(2, 0, 1, 1)]+=(0.163065174707+0.705951256441j)*x[2]
            ref[(2, 0, 1, 1)]+=(0.163065174707+0.705951256441j)*x_ref[2]
            arg[(2, 1, 0, 0)]+=(-0.680533024592+0.0723974090894j)*x[2]
            ref[(2, 1, 0, 0)]+=(-0.680533024592+0.0723974090894j)*x_ref[2]
            arg[(2, 1, 0, 1)]+=(0.570708099082+0.738676951119j)*x[2]
            ref[(2, 1, 0, 1)]+=(0.570708099082+0.738676951119j)*x_ref[2]
            arg[(2, 1, 1, 0)]+=(0.0215314785302-0.820282442532j)*x[2]
            ref[(2, 1, 1, 0)]+=(0.0215314785302-0.820282442532j)*x_ref[2]
            arg[(2, 1, 1, 1)]+=(-0.662270635564+0.089855236186j)*x[2]
            ref[(2, 1, 1, 1)]+=(-0.662270635564+0.089855236186j)*x_ref[2]
            arg[(2, 2, 0, 0)]+=(0.328562529691-0.30316074499j)*x[2]
            ref[(2, 2, 0, 0)]+=(0.328562529691-0.30316074499j)*x_ref[2]
            arg[(2, 2, 0, 1)]+=(0.285015350875+0.86990200552j)*x[2]
            ref[(2, 2, 0, 1)]+=(0.285015350875+0.86990200552j)*x_ref[2]
            arg[(2, 2, 1, 0)]+=(0.914129012399+0.325233132766j)*x[2]
            ref[(2, 2, 1, 0)]+=(0.914129012399+0.325233132766j)*x_ref[2]
            arg[(2, 2, 1, 1)]+=(0.0804180516059-0.848717371878j)*x[2]
            ref[(2, 2, 1, 1)]+=(0.0804180516059-0.848717371878j)*x_ref[2]
            arg[(2, 3, 0, 0)]+=(0.0113965713715-0.160530969763j)*x[2]
            ref[(2, 3, 0, 0)]+=(0.0113965713715-0.160530969763j)*x_ref[2]
            arg[(2, 3, 0, 1)]+=(0.677862927483+0.343225997631j)*x[2]
            ref[(2, 3, 0, 1)]+=(0.677862927483+0.343225997631j)*x_ref[2]
            arg[(2, 3, 1, 0)]+=(0.59873722774+0.534210986486j)*x[2]
            ref[(2, 3, 1, 0)]+=(0.59873722774+0.534210986486j)*x_ref[2]
            arg[(2, 3, 1, 1)]+=(-0.730013831883-0.226040556866j)*x[2]
            ref[(2, 3, 1, 1)]+=(-0.730013831883-0.226040556866j)*x_ref[2]
            arg[(3, 0, 0, 0)]+=(-0.562737663929+0.22314349568j)*x[2]
            ref[(3, 0, 0, 0)]+=(-0.562737663929+0.22314349568j)*x_ref[2]
            arg[(3, 0, 0, 1)]+=(-0.2398522475-0.545882983867j)*x[2]
            ref[(3, 0, 0, 1)]+=(-0.2398522475-0.545882983867j)*x_ref[2]
            arg[(3, 0, 1, 0)]+=(-0.246264986916-0.98849971453j)*x[2]
            ref[(3, 0, 1, 0)]+=(-0.246264986916-0.98849971453j)*x_ref[2]
            arg[(3, 0, 1, 1)]+=(-0.867149052116+0.23526757427j)*x[2]
            ref[(3, 0, 1, 1)]+=(-0.867149052116+0.23526757427j)*x_ref[2]
            arg[(3, 1, 0, 0)]+=(0.227792217011+0.0665501273033j)*x[2]
            ref[(3, 1, 0, 0)]+=(0.227792217011+0.0665501273033j)*x_ref[2]
            arg[(3, 1, 0, 1)]+=(0.187623347917+0.240308094624j)*x[2]
            ref[(3, 1, 0, 1)]+=(0.187623347917+0.240308094624j)*x_ref[2]
            arg[(3, 1, 1, 0)]+=(-0.326930338605-0.305266099301j)*x[2]
            ref[(3, 1, 1, 0)]+=(-0.326930338605-0.305266099301j)*x_ref[2]
            arg[(3, 1, 1, 1)]+=(0.109689397681+0.604053449829j)*x[2]
            ref[(3, 1, 1, 1)]+=(0.109689397681+0.604053449829j)*x_ref[2]
            arg[(3, 2, 0, 0)]+=(0.537962135188-0.209055274935j)*x[2]
            ref[(3, 2, 0, 0)]+=(0.537962135188-0.209055274935j)*x_ref[2]
            arg[(3, 2, 0, 1)]+=(-0.2368555746+0.679951229892j)*x[2]
            ref[(3, 2, 0, 1)]+=(-0.2368555746+0.679951229892j)*x_ref[2]
            arg[(3, 2, 1, 0)]+=(-0.255912389905-0.959954347932j)*x[2]
            ref[(3, 2, 1, 0)]+=(-0.255912389905-0.959954347932j)*x_ref[2]
            arg[(3, 2, 1, 1)]+=(0.999004267177-0.847960462579j)*x[2]
            ref[(3, 2, 1, 1)]+=(0.999004267177-0.847960462579j)*x_ref[2]
            arg[(3, 3, 0, 0)]+=(-0.947804405971-0.916208234003j)*x[2]
            ref[(3, 3, 0, 0)]+=(-0.947804405971-0.916208234003j)*x_ref[2]
            arg[(3, 3, 0, 1)]+=(0.391840787139+0.013730490611j)*x[2]
            ref[(3, 3, 0, 1)]+=(0.391840787139+0.013730490611j)*x_ref[2]
            arg[(3, 3, 1, 0)]+=(-0.0556289973755-0.906923781994j)*x[2]
            ref[(3, 3, 1, 0)]+=(-0.0556289973755-0.906923781994j)*x_ref[2]
            arg[(3, 3, 1, 1)]+=(-0.75631579751-0.370090518879j)*x[2]
            ref[(3, 3, 1, 1)]+=(-0.75631579751-0.370090518879j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 4, 2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests interpolation of rank 0 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(0.956135688969-0.888649396514j)*x[0] + ((0.53304939954-0.293041111034j))*x[1]
        ref=(0.956135688969-0.888649396514j)*x_ref[0] + ((0.53304939954-0.293041111034j))*x_ref[1]
        if dim==3:
            arg+=((0.932641106868+0.328218798334j))*x[2]
            ref+=((0.932641106868+0.328218798334j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests interpolation of rank 1 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,),w_ref)
        arg[(0,)]=(-0.676365473391+0.026964439562j)*x[0] + ((0.738081555972+0.410408638293j))*x[1]
        ref[(0,)]=(-0.676365473391+0.026964439562j)*x_ref[0] + ((0.738081555972+0.410408638293j))*x_ref[1]
        arg[(1,)]=(-0.740195418762+0.256123096937j)*x[0] + ((0.960467453305-0.804164360479j))*x[1]
        ref[(1,)]=(-0.740195418762+0.256123096937j)*x_ref[0] + ((0.960467453305-0.804164360479j))*x_ref[1]
        arg[(2,)]=(-0.195654772705+0.578198584178j)*x[0] + ((0.866284703311+0.0322813865483j))*x[1]
        ref[(2,)]=(-0.195654772705+0.578198584178j)*x_ref[0] + ((0.866284703311+0.0322813865483j))*x_ref[1]
        arg[(3,)]=(-0.256342398747-0.557054414163j)*x[0] + ((0.719712751949+0.907363101608j))*x[1]
        ref[(3,)]=(-0.256342398747-0.557054414163j)*x_ref[0] + ((0.719712751949+0.907363101608j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.960506507628-0.568212037665j)*x[2]
            ref[(0,)]+=(-0.960506507628-0.568212037665j)*x_ref[2]
            arg[(1,)]+=(0.56575193406-0.0893103781036j)*x[2]
            ref[(1,)]+=(0.56575193406-0.0893103781036j)*x_ref[2]
            arg[(2,)]+=(-0.217835806634-0.165302160825j)*x[2]
            ref[(2,)]+=(-0.217835806634-0.165302160825j)*x_ref[2]
            arg[(3,)]+=(0.699723858116-0.661578730153j)*x[2]
            ref[(3,)]+=(0.699723858116-0.661578730153j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests interpolation of rank 2 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4),w_ref)
        arg[(0, 0)]=(-0.240814301918-0.887048322781j)*x[0] + ((-0.94427004856+0.733628508615j))*x[1]
        ref[(0, 0)]=(-0.240814301918-0.887048322781j)*x_ref[0] + ((-0.94427004856+0.733628508615j))*x_ref[1]
        arg[(0, 1)]=(0.951750236869-0.198282416579j)*x[0] + ((-0.565111450398-0.53776480686j))*x[1]
        ref[(0, 1)]=(0.951750236869-0.198282416579j)*x_ref[0] + ((-0.565111450398-0.53776480686j))*x_ref[1]
        arg[(0, 2)]=(-0.730679847433+0.73129906158j)*x[0] + ((-0.234023738555-0.577077014762j))*x[1]
        ref[(0, 2)]=(-0.730679847433+0.73129906158j)*x_ref[0] + ((-0.234023738555-0.577077014762j))*x_ref[1]
        arg[(0, 3)]=(-0.901316318034+0.0104211731045j)*x[0] + ((0.815947050202+0.388281301358j))*x[1]
        ref[(0, 3)]=(-0.901316318034+0.0104211731045j)*x_ref[0] + ((0.815947050202+0.388281301358j))*x_ref[1]
        arg[(1, 0)]=(-0.952994123338+0.562259045344j)*x[0] + ((-0.12672422522+0.759397064752j))*x[1]
        ref[(1, 0)]=(-0.952994123338+0.562259045344j)*x_ref[0] + ((-0.12672422522+0.759397064752j))*x_ref[1]
        arg[(1, 1)]=(-0.0876028285468+0.0962299659881j)*x[0] + ((-0.453954817625+0.531446963363j))*x[1]
        ref[(1, 1)]=(-0.0876028285468+0.0962299659881j)*x_ref[0] + ((-0.453954817625+0.531446963363j))*x_ref[1]
        arg[(1, 2)]=(-0.714238899701-0.258108459031j)*x[0] + ((0.413260215386-0.501445856003j))*x[1]
        ref[(1, 2)]=(-0.714238899701-0.258108459031j)*x_ref[0] + ((0.413260215386-0.501445856003j))*x_ref[1]
        arg[(1, 3)]=(0.334140526046+0.720690598314j)*x[0] + ((0.0649585175003+0.385287340639j))*x[1]
        ref[(1, 3)]=(0.334140526046+0.720690598314j)*x_ref[0] + ((0.0649585175003+0.385287340639j))*x_ref[1]
        arg[(2, 0)]=(-0.105268261113-0.0413867431832j)*x[0] + ((0.120272690539+0.795458235225j))*x[1]
        ref[(2, 0)]=(-0.105268261113-0.0413867431832j)*x_ref[0] + ((0.120272690539+0.795458235225j))*x_ref[1]
        arg[(2, 1)]=(-0.0677382511323+0.714048551423j)*x[0] + ((-0.817966815779-0.211792032305j))*x[1]
        ref[(2, 1)]=(-0.0677382511323+0.714048551423j)*x_ref[0] + ((-0.817966815779-0.211792032305j))*x_ref[1]
        arg[(2, 2)]=(0.622366928452+0.873320752694j)*x[0] + ((0.803727816121+0.848889258707j))*x[1]
        ref[(2, 2)]=(0.622366928452+0.873320752694j)*x_ref[0] + ((0.803727816121+0.848889258707j))*x_ref[1]
        arg[(2, 3)]=(0.0054662692769-0.312635145554j)*x[0] + ((0.49876567853-0.475582064542j))*x[1]
        ref[(2, 3)]=(0.0054662692769-0.312635145554j)*x_ref[0] + ((0.49876567853-0.475582064542j))*x_ref[1]
        arg[(3, 0)]=(0.486375167179+0.887687109909j)*x[0] + ((-0.79938352603+0.203798243441j))*x[1]
        ref[(3, 0)]=(0.486375167179+0.887687109909j)*x_ref[0] + ((-0.79938352603+0.203798243441j))*x_ref[1]
        arg[(3, 1)]=(0.0942996746761-0.737976343541j)*x[0] + ((-0.682086475874+0.469234521125j))*x[1]
        ref[(3, 1)]=(0.0942996746761-0.737976343541j)*x_ref[0] + ((-0.682086475874+0.469234521125j))*x_ref[1]
        arg[(3, 2)]=(-0.104611226434+0.433052142302j)*x[0] + ((-0.620801318245+0.581906629262j))*x[1]
        ref[(3, 2)]=(-0.104611226434+0.433052142302j)*x_ref[0] + ((-0.620801318245+0.581906629262j))*x_ref[1]
        arg[(3, 3)]=(-0.0381487687319+0.528562401891j)*x[0] + ((0.267413230144-0.481841205959j))*x[1]
        ref[(3, 3)]=(-0.0381487687319+0.528562401891j)*x_ref[0] + ((0.267413230144-0.481841205959j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(0.185982183399-0.305705949308j)*x[2]
            ref[(0, 0)]+=(0.185982183399-0.305705949308j)*x_ref[2]
            arg[(0, 1)]+=(-0.141436503698+0.193619656302j)*x[2]
            ref[(0, 1)]+=(-0.141436503698+0.193619656302j)*x_ref[2]
            arg[(0, 2)]+=(-0.216326852087+0.965855929256j)*x[2]
            ref[(0, 2)]+=(-0.216326852087+0.965855929256j)*x_ref[2]
            arg[(0, 3)]+=(0.810814289151-0.74914860825j)*x[2]
            ref[(0, 3)]+=(0.810814289151-0.74914860825j)*x_ref[2]
            arg[(1, 0)]+=(0.564396313381+0.238500666079j)*x[2]
            ref[(1, 0)]+=(0.564396313381+0.238500666079j)*x_ref[2]
            arg[(1, 1)]+=(0.309539600916+0.806779176839j)*x[2]
            ref[(1, 1)]+=(0.309539600916+0.806779176839j)*x_ref[2]
            arg[(1, 2)]+=(0.859245563127-0.182915908656j)*x[2]
            ref[(1, 2)]+=(0.859245563127-0.182915908656j)*x_ref[2]
            arg[(1, 3)]+=(-0.404597139967-0.709465688144j)*x[2]
            ref[(1, 3)]+=(-0.404597139967-0.709465688144j)*x_ref[2]
            arg[(2, 0)]+=(0.0574126757898-0.812974401469j)*x[2]
            ref[(2, 0)]+=(0.0574126757898-0.812974401469j)*x_ref[2]
            arg[(2, 1)]+=(-0.372680946595+0.525574883425j)*x[2]
            ref[(2, 1)]+=(-0.372680946595+0.525574883425j)*x_ref[2]
            arg[(2, 2)]+=(0.780479796466+0.356093736067j)*x[2]
            ref[(2, 2)]+=(0.780479796466+0.356093736067j)*x_ref[2]
            arg[(2, 3)]+=(0.693713947316-0.564220680676j)*x[2]
            ref[(2, 3)]+=(0.693713947316-0.564220680676j)*x_ref[2]
            arg[(3, 0)]+=(-0.540930445245-0.0860915987224j)*x[2]
            ref[(3, 0)]+=(-0.540930445245-0.0860915987224j)*x_ref[2]
            arg[(3, 1)]+=(0.862068251052-0.0586224025383j)*x[2]
            ref[(3, 1)]+=(0.862068251052-0.0586224025383j)*x_ref[2]
            arg[(3, 2)]+=(0.225903422934-0.352563992518j)*x[2]
            ref[(3, 2)]+=(0.225903422934-0.352563992518j)*x_ref[2]
            arg[(3, 3)]+=(-0.29630855462+0.720657827833j)*x[2]
            ref[(3, 3)]+=(-0.29630855462+0.720657827833j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests interpolation of rank 3 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 4),w)
        ref = Data(0,(4, 4, 4),w_ref)
        arg[(0, 0, 0)]=(-0.517019132757+0.0411478432118j)*x[0] + ((-0.67360762307+0.279125203116j))*x[1]
        ref[(0, 0, 0)]=(-0.517019132757+0.0411478432118j)*x_ref[0] + ((-0.67360762307+0.279125203116j))*x_ref[1]
        arg[(0, 0, 1)]=(-0.124589846605+0.557248664247j)*x[0] + ((0.532621424649+0.763613872005j))*x[1]
        ref[(0, 0, 1)]=(-0.124589846605+0.557248664247j)*x_ref[0] + ((0.532621424649+0.763613872005j))*x_ref[1]
        arg[(0, 0, 2)]=(0.732576259178+0.113168427138j)*x[0] + ((0.72102378097+0.0209588283052j))*x[1]
        ref[(0, 0, 2)]=(0.732576259178+0.113168427138j)*x_ref[0] + ((0.72102378097+0.0209588283052j))*x_ref[1]
        arg[(0, 0, 3)]=(0.579825992545-0.785635343373j)*x[0] + ((0.712491553075+0.996233996998j))*x[1]
        ref[(0, 0, 3)]=(0.579825992545-0.785635343373j)*x_ref[0] + ((0.712491553075+0.996233996998j))*x_ref[1]
        arg[(0, 1, 0)]=(0.800836795034-0.634897823962j)*x[0] + ((0.972067870477-0.844485611173j))*x[1]
        ref[(0, 1, 0)]=(0.800836795034-0.634897823962j)*x_ref[0] + ((0.972067870477-0.844485611173j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.453682298889-0.693767806482j)*x[0] + ((-0.568890106316+0.694978038622j))*x[1]
        ref[(0, 1, 1)]=(-0.453682298889-0.693767806482j)*x_ref[0] + ((-0.568890106316+0.694978038622j))*x_ref[1]
        arg[(0, 1, 2)]=(0.210710503482-0.851549757764j)*x[0] + ((-0.744577614128-0.210047292554j))*x[1]
        ref[(0, 1, 2)]=(0.210710503482-0.851549757764j)*x_ref[0] + ((-0.744577614128-0.210047292554j))*x_ref[1]
        arg[(0, 1, 3)]=(0.797940193748-0.771551044584j)*x[0] + ((0.674095648515+0.68423625466j))*x[1]
        ref[(0, 1, 3)]=(0.797940193748-0.771551044584j)*x_ref[0] + ((0.674095648515+0.68423625466j))*x_ref[1]
        arg[(0, 2, 0)]=(0.555465149174+0.618636665679j)*x[0] + ((0.63989710783-0.0151563088024j))*x[1]
        ref[(0, 2, 0)]=(0.555465149174+0.618636665679j)*x_ref[0] + ((0.63989710783-0.0151563088024j))*x_ref[1]
        arg[(0, 2, 1)]=(-0.605659267636+0.181966640686j)*x[0] + ((0.123965761776-0.928558222444j))*x[1]
        ref[(0, 2, 1)]=(-0.605659267636+0.181966640686j)*x_ref[0] + ((0.123965761776-0.928558222444j))*x_ref[1]
        arg[(0, 2, 2)]=(0.788152198497+0.355851460002j)*x[0] + ((-0.520529800821+0.219118481826j))*x[1]
        ref[(0, 2, 2)]=(0.788152198497+0.355851460002j)*x_ref[0] + ((-0.520529800821+0.219118481826j))*x_ref[1]
        arg[(0, 2, 3)]=(-0.00507640578008-0.32311437668j)*x[0] + ((0.824218631132-0.343211895061j))*x[1]
        ref[(0, 2, 3)]=(-0.00507640578008-0.32311437668j)*x_ref[0] + ((0.824218631132-0.343211895061j))*x_ref[1]
        arg[(0, 3, 0)]=(0.678522856904+0.840780763344j)*x[0] + ((0.888945936183+0.327696608344j))*x[1]
        ref[(0, 3, 0)]=(0.678522856904+0.840780763344j)*x_ref[0] + ((0.888945936183+0.327696608344j))*x_ref[1]
        arg[(0, 3, 1)]=(0.105188395535+0.176806147053j)*x[0] + ((0.919683612001+0.0627413902262j))*x[1]
        ref[(0, 3, 1)]=(0.105188395535+0.176806147053j)*x_ref[0] + ((0.919683612001+0.0627413902262j))*x_ref[1]
        arg[(0, 3, 2)]=(-0.413231823874-0.50126060347j)*x[0] + ((0.70387905974-0.243636923591j))*x[1]
        ref[(0, 3, 2)]=(-0.413231823874-0.50126060347j)*x_ref[0] + ((0.70387905974-0.243636923591j))*x_ref[1]
        arg[(0, 3, 3)]=(-0.759564236541-0.0766084890227j)*x[0] + ((0.56728416833-0.907809352761j))*x[1]
        ref[(0, 3, 3)]=(-0.759564236541-0.0766084890227j)*x_ref[0] + ((0.56728416833-0.907809352761j))*x_ref[1]
        arg[(1, 0, 0)]=(0.389544046393-0.536570286414j)*x[0] + ((-0.632664844328-0.334709633548j))*x[1]
        ref[(1, 0, 0)]=(0.389544046393-0.536570286414j)*x_ref[0] + ((-0.632664844328-0.334709633548j))*x_ref[1]
        arg[(1, 0, 1)]=(0.763297700707-0.943017886296j)*x[0] + ((0.790761128449+0.488199059519j))*x[1]
        ref[(1, 0, 1)]=(0.763297700707-0.943017886296j)*x_ref[0] + ((0.790761128449+0.488199059519j))*x_ref[1]
        arg[(1, 0, 2)]=(-0.103192883821-0.0525844618309j)*x[0] + ((0.131983458869+0.386639645954j))*x[1]
        ref[(1, 0, 2)]=(-0.103192883821-0.0525844618309j)*x_ref[0] + ((0.131983458869+0.386639645954j))*x_ref[1]
        arg[(1, 0, 3)]=(0.0826075576447+0.00983939500647j)*x[0] + ((0.176616321969+0.759316257626j))*x[1]
        ref[(1, 0, 3)]=(0.0826075576447+0.00983939500647j)*x_ref[0] + ((0.176616321969+0.759316257626j))*x_ref[1]
        arg[(1, 1, 0)]=(0.34116921179+0.516326245453j)*x[0] + ((-0.00927082801101+0.117162811554j))*x[1]
        ref[(1, 1, 0)]=(0.34116921179+0.516326245453j)*x_ref[0] + ((-0.00927082801101+0.117162811554j))*x_ref[1]
        arg[(1, 1, 1)]=(-0.67039457395+0.55587089765j)*x[0] + ((0.883048106926+0.316339567934j))*x[1]
        ref[(1, 1, 1)]=(-0.67039457395+0.55587089765j)*x_ref[0] + ((0.883048106926+0.316339567934j))*x_ref[1]
        arg[(1, 1, 2)]=(-0.109251046627-0.162394844203j)*x[0] + ((-0.487548952731+0.108205735108j))*x[1]
        ref[(1, 1, 2)]=(-0.109251046627-0.162394844203j)*x_ref[0] + ((-0.487548952731+0.108205735108j))*x_ref[1]
        arg[(1, 1, 3)]=(0.287220039771+0.614387975755j)*x[0] + ((-0.174688763891+0.0072761637379j))*x[1]
        ref[(1, 1, 3)]=(0.287220039771+0.614387975755j)*x_ref[0] + ((-0.174688763891+0.0072761637379j))*x_ref[1]
        arg[(1, 2, 0)]=(0.896841001825-0.865425921332j)*x[0] + ((-0.961175659376-0.368184128575j))*x[1]
        ref[(1, 2, 0)]=(0.896841001825-0.865425921332j)*x_ref[0] + ((-0.961175659376-0.368184128575j))*x_ref[1]
        arg[(1, 2, 1)]=(0.755680515772-0.507197687065j)*x[0] + ((-0.709344806516-0.920845573965j))*x[1]
        ref[(1, 2, 1)]=(0.755680515772-0.507197687065j)*x_ref[0] + ((-0.709344806516-0.920845573965j))*x_ref[1]
        arg[(1, 2, 2)]=(0.0415026038872+0.745319393807j)*x[0] + ((0.52471972023-0.77451954985j))*x[1]
        ref[(1, 2, 2)]=(0.0415026038872+0.745319393807j)*x_ref[0] + ((0.52471972023-0.77451954985j))*x_ref[1]
        arg[(1, 2, 3)]=(0.102667784221-0.79465854439j)*x[0] + ((-0.0374534414289-0.776878196505j))*x[1]
        ref[(1, 2, 3)]=(0.102667784221-0.79465854439j)*x_ref[0] + ((-0.0374534414289-0.776878196505j))*x_ref[1]
        arg[(1, 3, 0)]=(-0.891244055516-0.686348645643j)*x[0] + ((-0.0905027881223+0.29571242476j))*x[1]
        ref[(1, 3, 0)]=(-0.891244055516-0.686348645643j)*x_ref[0] + ((-0.0905027881223+0.29571242476j))*x_ref[1]
        arg[(1, 3, 1)]=(0.0862546492442+0.279187742231j)*x[0] + ((0.0389829739671+0.624044228486j))*x[1]
        ref[(1, 3, 1)]=(0.0862546492442+0.279187742231j)*x_ref[0] + ((0.0389829739671+0.624044228486j))*x_ref[1]
        arg[(1, 3, 2)]=(0.299542311793-0.125307879713j)*x[0] + ((-0.320696461928-0.650360617696j))*x[1]
        ref[(1, 3, 2)]=(0.299542311793-0.125307879713j)*x_ref[0] + ((-0.320696461928-0.650360617696j))*x_ref[1]
        arg[(1, 3, 3)]=(-0.105536808495+0.171119047394j)*x[0] + ((0.00341297340795+0.66820604292j))*x[1]
        ref[(1, 3, 3)]=(-0.105536808495+0.171119047394j)*x_ref[0] + ((0.00341297340795+0.66820604292j))*x_ref[1]
        arg[(2, 0, 0)]=(0.964296450656+0.559579037774j)*x[0] + ((0.885144817158+0.888746182718j))*x[1]
        ref[(2, 0, 0)]=(0.964296450656+0.559579037774j)*x_ref[0] + ((0.885144817158+0.888746182718j))*x_ref[1]
        arg[(2, 0, 1)]=(-0.0403137184293+0.930216003666j)*x[0] + ((0.441838342351-0.993260198587j))*x[1]
        ref[(2, 0, 1)]=(-0.0403137184293+0.930216003666j)*x_ref[0] + ((0.441838342351-0.993260198587j))*x_ref[1]
        arg[(2, 0, 2)]=(-0.219263151914-0.22575897916j)*x[0] + ((0.771168322513-0.659136292791j))*x[1]
        ref[(2, 0, 2)]=(-0.219263151914-0.22575897916j)*x_ref[0] + ((0.771168322513-0.659136292791j))*x_ref[1]
        arg[(2, 0, 3)]=(-0.340394463537+0.262828508228j)*x[0] + ((-0.597562252566+0.959722728957j))*x[1]
        ref[(2, 0, 3)]=(-0.340394463537+0.262828508228j)*x_ref[0] + ((-0.597562252566+0.959722728957j))*x_ref[1]
        arg[(2, 1, 0)]=(0.320898906492+0.471008787333j)*x[0] + ((-0.513041382336+0.27994583967j))*x[1]
        ref[(2, 1, 0)]=(0.320898906492+0.471008787333j)*x_ref[0] + ((-0.513041382336+0.27994583967j))*x_ref[1]
        arg[(2, 1, 1)]=(0.965948093145-0.59421473828j)*x[0] + ((0.0104125801151-0.0716953285501j))*x[1]
        ref[(2, 1, 1)]=(0.965948093145-0.59421473828j)*x_ref[0] + ((0.0104125801151-0.0716953285501j))*x_ref[1]
        arg[(2, 1, 2)]=(0.875626416269-0.483029743794j)*x[0] + ((0.5294927119-0.222066452463j))*x[1]
        ref[(2, 1, 2)]=(0.875626416269-0.483029743794j)*x_ref[0] + ((0.5294927119-0.222066452463j))*x_ref[1]
        arg[(2, 1, 3)]=(0.0999124353419-0.333161943223j)*x[0] + ((-0.992822998466+0.950251870679j))*x[1]
        ref[(2, 1, 3)]=(0.0999124353419-0.333161943223j)*x_ref[0] + ((-0.992822998466+0.950251870679j))*x_ref[1]
        arg[(2, 2, 0)]=(0.54392028184+0.98979407967j)*x[0] + ((-0.319235825891-0.62872511411j))*x[1]
        ref[(2, 2, 0)]=(0.54392028184+0.98979407967j)*x_ref[0] + ((-0.319235825891-0.62872511411j))*x_ref[1]
        arg[(2, 2, 1)]=(0.69517462555-0.0142696334722j)*x[0] + ((0.102170683997+0.0668800373628j))*x[1]
        ref[(2, 2, 1)]=(0.69517462555-0.0142696334722j)*x_ref[0] + ((0.102170683997+0.0668800373628j))*x_ref[1]
        arg[(2, 2, 2)]=(0.060970161035+0.595451555144j)*x[0] + ((-0.557705846639-0.811235387541j))*x[1]
        ref[(2, 2, 2)]=(0.060970161035+0.595451555144j)*x_ref[0] + ((-0.557705846639-0.811235387541j))*x_ref[1]
        arg[(2, 2, 3)]=(0.992225454778+0.19026241092j)*x[0] + ((-0.093126990454+0.526403844525j))*x[1]
        ref[(2, 2, 3)]=(0.992225454778+0.19026241092j)*x_ref[0] + ((-0.093126990454+0.526403844525j))*x_ref[1]
        arg[(2, 3, 0)]=(0.970175960753+0.786676051734j)*x[0] + ((-0.364782340243+0.47904073928j))*x[1]
        ref[(2, 3, 0)]=(0.970175960753+0.786676051734j)*x_ref[0] + ((-0.364782340243+0.47904073928j))*x_ref[1]
        arg[(2, 3, 1)]=(0.137976997314-0.610962136233j)*x[0] + ((-0.622601278281-0.985515566683j))*x[1]
        ref[(2, 3, 1)]=(0.137976997314-0.610962136233j)*x_ref[0] + ((-0.622601278281-0.985515566683j))*x_ref[1]
        arg[(2, 3, 2)]=(0.392708640903-0.316446592408j)*x[0] + ((-0.129882846053-0.508264027898j))*x[1]
        ref[(2, 3, 2)]=(0.392708640903-0.316446592408j)*x_ref[0] + ((-0.129882846053-0.508264027898j))*x_ref[1]
        arg[(2, 3, 3)]=(-0.337155484352-0.818811951512j)*x[0] + ((0.0202008790186+0.832201857322j))*x[1]
        ref[(2, 3, 3)]=(-0.337155484352-0.818811951512j)*x_ref[0] + ((0.0202008790186+0.832201857322j))*x_ref[1]
        arg[(3, 0, 0)]=(0.407402681834+0.685970554947j)*x[0] + ((-0.80606791349-0.932695515827j))*x[1]
        ref[(3, 0, 0)]=(0.407402681834+0.685970554947j)*x_ref[0] + ((-0.80606791349-0.932695515827j))*x_ref[1]
        arg[(3, 0, 1)]=(0.685715978096-0.427598273017j)*x[0] + ((0.798732489652-0.275089186832j))*x[1]
        ref[(3, 0, 1)]=(0.685715978096-0.427598273017j)*x_ref[0] + ((0.798732489652-0.275089186832j))*x_ref[1]
        arg[(3, 0, 2)]=(-0.33057119352+0.44918408477j)*x[0] + ((-0.343302470351-0.584948373425j))*x[1]
        ref[(3, 0, 2)]=(-0.33057119352+0.44918408477j)*x_ref[0] + ((-0.343302470351-0.584948373425j))*x_ref[1]
        arg[(3, 0, 3)]=(-0.519828556865+0.738132301546j)*x[0] + ((0.837388539874+0.302159115772j))*x[1]
        ref[(3, 0, 3)]=(-0.519828556865+0.738132301546j)*x_ref[0] + ((0.837388539874+0.302159115772j))*x_ref[1]
        arg[(3, 1, 0)]=(-0.26008058546-0.414309167102j)*x[0] + ((0.198110560517+0.909722810027j))*x[1]
        ref[(3, 1, 0)]=(-0.26008058546-0.414309167102j)*x_ref[0] + ((0.198110560517+0.909722810027j))*x_ref[1]
        arg[(3, 1, 1)]=(-0.163033344173-0.591969668704j)*x[0] + ((0.440480608581-0.489887683155j))*x[1]
        ref[(3, 1, 1)]=(-0.163033344173-0.591969668704j)*x_ref[0] + ((0.440480608581-0.489887683155j))*x_ref[1]
        arg[(3, 1, 2)]=(-0.501495782934+0.111908752543j)*x[0] + ((0.431023764569-0.00172648928322j))*x[1]
        ref[(3, 1, 2)]=(-0.501495782934+0.111908752543j)*x_ref[0] + ((0.431023764569-0.00172648928322j))*x_ref[1]
        arg[(3, 1, 3)]=(0.745573961774+0.53552447765j)*x[0] + ((0.740753502699-0.0223767525527j))*x[1]
        ref[(3, 1, 3)]=(0.745573961774+0.53552447765j)*x_ref[0] + ((0.740753502699-0.0223767525527j))*x_ref[1]
        arg[(3, 2, 0)]=(0.419343798909+0.745113849314j)*x[0] + ((0.603728913355+0.0375624029137j))*x[1]
        ref[(3, 2, 0)]=(0.419343798909+0.745113849314j)*x_ref[0] + ((0.603728913355+0.0375624029137j))*x_ref[1]
        arg[(3, 2, 1)]=(-0.556756908899+0.909868478186j)*x[0] + ((0.769430023616-0.0209516928675j))*x[1]
        ref[(3, 2, 1)]=(-0.556756908899+0.909868478186j)*x_ref[0] + ((0.769430023616-0.0209516928675j))*x_ref[1]
        arg[(3, 2, 2)]=(-0.218539909726-0.975193729328j)*x[0] + ((0.264192636771+0.561920230991j))*x[1]
        ref[(3, 2, 2)]=(-0.218539909726-0.975193729328j)*x_ref[0] + ((0.264192636771+0.561920230991j))*x_ref[1]
        arg[(3, 2, 3)]=(-0.598705429851+0.731330184238j)*x[0] + ((0.354975442866+0.700725374263j))*x[1]
        ref[(3, 2, 3)]=(-0.598705429851+0.731330184238j)*x_ref[0] + ((0.354975442866+0.700725374263j))*x_ref[1]
        arg[(3, 3, 0)]=(-0.196301450151-0.973357795606j)*x[0] + ((0.00248994110462-0.628259880656j))*x[1]
        ref[(3, 3, 0)]=(-0.196301450151-0.973357795606j)*x_ref[0] + ((0.00248994110462-0.628259880656j))*x_ref[1]
        arg[(3, 3, 1)]=(-0.592629613065-0.97899396468j)*x[0] + ((0.468375316816-0.385966373649j))*x[1]
        ref[(3, 3, 1)]=(-0.592629613065-0.97899396468j)*x_ref[0] + ((0.468375316816-0.385966373649j))*x_ref[1]
        arg[(3, 3, 2)]=(-0.84776944341+0.940660143578j)*x[0] + ((-0.650517654443-0.647058928178j))*x[1]
        ref[(3, 3, 2)]=(-0.84776944341+0.940660143578j)*x_ref[0] + ((-0.650517654443-0.647058928178j))*x_ref[1]
        arg[(3, 3, 3)]=(-0.460172866295+0.470159947583j)*x[0] + ((-0.0875053819816+0.431674703563j))*x[1]
        ref[(3, 3, 3)]=(-0.460172866295+0.470159947583j)*x_ref[0] + ((-0.0875053819816+0.431674703563j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(0.319288548595+0.376000644077j)*x[2]
            ref[(0, 0, 0)]+=(0.319288548595+0.376000644077j)*x_ref[2]
            arg[(0, 0, 1)]+=(-0.775024215675-0.200319765257j)*x[2]
            ref[(0, 0, 1)]+=(-0.775024215675-0.200319765257j)*x_ref[2]
            arg[(0, 0, 2)]+=(0.19134749591-0.466768002647j)*x[2]
            ref[(0, 0, 2)]+=(0.19134749591-0.466768002647j)*x_ref[2]
            arg[(0, 0, 3)]+=(0.638524573508+0.138066798366j)*x[2]
            ref[(0, 0, 3)]+=(0.638524573508+0.138066798366j)*x_ref[2]
            arg[(0, 1, 0)]+=(0.677828848532-0.963440374989j)*x[2]
            ref[(0, 1, 0)]+=(0.677828848532-0.963440374989j)*x_ref[2]
            arg[(0, 1, 1)]+=(0.643850785618+0.844406079708j)*x[2]
            ref[(0, 1, 1)]+=(0.643850785618+0.844406079708j)*x_ref[2]
            arg[(0, 1, 2)]+=(-0.913896840369-0.500088012242j)*x[2]
            ref[(0, 1, 2)]+=(-0.913896840369-0.500088012242j)*x_ref[2]
            arg[(0, 1, 3)]+=(-0.52448050739-0.910092824305j)*x[2]
            ref[(0, 1, 3)]+=(-0.52448050739-0.910092824305j)*x_ref[2]
            arg[(0, 2, 0)]+=(0.779930856009-0.78899907694j)*x[2]
            ref[(0, 2, 0)]+=(0.779930856009-0.78899907694j)*x_ref[2]
            arg[(0, 2, 1)]+=(-0.221443895408+0.887783386826j)*x[2]
            ref[(0, 2, 1)]+=(-0.221443895408+0.887783386826j)*x_ref[2]
            arg[(0, 2, 2)]+=(-0.424363440054-0.664115256745j)*x[2]
            ref[(0, 2, 2)]+=(-0.424363440054-0.664115256745j)*x_ref[2]
            arg[(0, 2, 3)]+=(0.710490830773+0.224297414627j)*x[2]
            ref[(0, 2, 3)]+=(0.710490830773+0.224297414627j)*x_ref[2]
            arg[(0, 3, 0)]+=(-0.34238634217+0.947842610206j)*x[2]
            ref[(0, 3, 0)]+=(-0.34238634217+0.947842610206j)*x_ref[2]
            arg[(0, 3, 1)]+=(0.835456458957-0.348655017j)*x[2]
            ref[(0, 3, 1)]+=(0.835456458957-0.348655017j)*x_ref[2]
            arg[(0, 3, 2)]+=(-0.465250271495-0.556031229495j)*x[2]
            ref[(0, 3, 2)]+=(-0.465250271495-0.556031229495j)*x_ref[2]
            arg[(0, 3, 3)]+=(-0.57282111878-0.424317744709j)*x[2]
            ref[(0, 3, 3)]+=(-0.57282111878-0.424317744709j)*x_ref[2]
            arg[(1, 0, 0)]+=(0.0958370406222+0.760034972259j)*x[2]
            ref[(1, 0, 0)]+=(0.0958370406222+0.760034972259j)*x_ref[2]
            arg[(1, 0, 1)]+=(-0.598636353977+0.774319392737j)*x[2]
            ref[(1, 0, 1)]+=(-0.598636353977+0.774319392737j)*x_ref[2]
            arg[(1, 0, 2)]+=(0.697919082029+0.867390934847j)*x[2]
            ref[(1, 0, 2)]+=(0.697919082029+0.867390934847j)*x_ref[2]
            arg[(1, 0, 3)]+=(-0.756751754361+0.35510043052j)*x[2]
            ref[(1, 0, 3)]+=(-0.756751754361+0.35510043052j)*x_ref[2]
            arg[(1, 1, 0)]+=(0.303458283188+0.253024255045j)*x[2]
            ref[(1, 1, 0)]+=(0.303458283188+0.253024255045j)*x_ref[2]
            arg[(1, 1, 1)]+=(0.950509874111+0.660676996916j)*x[2]
            ref[(1, 1, 1)]+=(0.950509874111+0.660676996916j)*x_ref[2]
            arg[(1, 1, 2)]+=(-0.186854085601-0.664355755808j)*x[2]
            ref[(1, 1, 2)]+=(-0.186854085601-0.664355755808j)*x_ref[2]
            arg[(1, 1, 3)]+=(0.28591539777-0.658624071423j)*x[2]
            ref[(1, 1, 3)]+=(0.28591539777-0.658624071423j)*x_ref[2]
            arg[(1, 2, 0)]+=(0.860576391568+0.220896098166j)*x[2]
            ref[(1, 2, 0)]+=(0.860576391568+0.220896098166j)*x_ref[2]
            arg[(1, 2, 1)]+=(0.88321894618-0.934742600827j)*x[2]
            ref[(1, 2, 1)]+=(0.88321894618-0.934742600827j)*x_ref[2]
            arg[(1, 2, 2)]+=(-0.885917028573-0.701862901649j)*x[2]
            ref[(1, 2, 2)]+=(-0.885917028573-0.701862901649j)*x_ref[2]
            arg[(1, 2, 3)]+=(-0.489901586142-0.430962714786j)*x[2]
            ref[(1, 2, 3)]+=(-0.489901586142-0.430962714786j)*x_ref[2]
            arg[(1, 3, 0)]+=(0.83564240702+0.0093959075119j)*x[2]
            ref[(1, 3, 0)]+=(0.83564240702+0.0093959075119j)*x_ref[2]
            arg[(1, 3, 1)]+=(0.760631764934+0.466220578841j)*x[2]
            ref[(1, 3, 1)]+=(0.760631764934+0.466220578841j)*x_ref[2]
            arg[(1, 3, 2)]+=(-0.99765643139-0.151591399439j)*x[2]
            ref[(1, 3, 2)]+=(-0.99765643139-0.151591399439j)*x_ref[2]
            arg[(1, 3, 3)]+=(-0.0970464397322+0.752917425188j)*x[2]
            ref[(1, 3, 3)]+=(-0.0970464397322+0.752917425188j)*x_ref[2]
            arg[(2, 0, 0)]+=(0.340946191331-0.528625226127j)*x[2]
            ref[(2, 0, 0)]+=(0.340946191331-0.528625226127j)*x_ref[2]
            arg[(2, 0, 1)]+=(-0.631991008454-0.695108480886j)*x[2]
            ref[(2, 0, 1)]+=(-0.631991008454-0.695108480886j)*x_ref[2]
            arg[(2, 0, 2)]+=(-0.218700908626-0.270344822141j)*x[2]
            ref[(2, 0, 2)]+=(-0.218700908626-0.270344822141j)*x_ref[2]
            arg[(2, 0, 3)]+=(0.26708344971-0.501144710072j)*x[2]
            ref[(2, 0, 3)]+=(0.26708344971-0.501144710072j)*x_ref[2]
            arg[(2, 1, 0)]+=(-0.587089128393+0.17602470657j)*x[2]
            ref[(2, 1, 0)]+=(-0.587089128393+0.17602470657j)*x_ref[2]
            arg[(2, 1, 1)]+=(-0.424388632356+0.0806871542138j)*x[2]
            ref[(2, 1, 1)]+=(-0.424388632356+0.0806871542138j)*x_ref[2]
            arg[(2, 1, 2)]+=(-0.815835943557+0.227059858739j)*x[2]
            ref[(2, 1, 2)]+=(-0.815835943557+0.227059858739j)*x_ref[2]
            arg[(2, 1, 3)]+=(0.748188608707-0.970608144862j)*x[2]
            ref[(2, 1, 3)]+=(0.748188608707-0.970608144862j)*x_ref[2]
            arg[(2, 2, 0)]+=(0.724354658657-0.703579971126j)*x[2]
            ref[(2, 2, 0)]+=(0.724354658657-0.703579971126j)*x_ref[2]
            arg[(2, 2, 1)]+=(0.479266622879-0.595241141127j)*x[2]
            ref[(2, 2, 1)]+=(0.479266622879-0.595241141127j)*x_ref[2]
            arg[(2, 2, 2)]+=(-0.644332613063-0.184788371627j)*x[2]
            ref[(2, 2, 2)]+=(-0.644332613063-0.184788371627j)*x_ref[2]
            arg[(2, 2, 3)]+=(0.629840378422+0.448614406674j)*x[2]
            ref[(2, 2, 3)]+=(0.629840378422+0.448614406674j)*x_ref[2]
            arg[(2, 3, 0)]+=(0.275308346343-0.388896802638j)*x[2]
            ref[(2, 3, 0)]+=(0.275308346343-0.388896802638j)*x_ref[2]
            arg[(2, 3, 1)]+=(0.547683374312-0.802978452141j)*x[2]
            ref[(2, 3, 1)]+=(0.547683374312-0.802978452141j)*x_ref[2]
            arg[(2, 3, 2)]+=(0.776922529994-0.68128923166j)*x[2]
            ref[(2, 3, 2)]+=(0.776922529994-0.68128923166j)*x_ref[2]
            arg[(2, 3, 3)]+=(0.0124469071206+0.262948107362j)*x[2]
            ref[(2, 3, 3)]+=(0.0124469071206+0.262948107362j)*x_ref[2]
            arg[(3, 0, 0)]+=(0.197526582884-0.387015909395j)*x[2]
            ref[(3, 0, 0)]+=(0.197526582884-0.387015909395j)*x_ref[2]
            arg[(3, 0, 1)]+=(-0.688996225086+0.471510748271j)*x[2]
            ref[(3, 0, 1)]+=(-0.688996225086+0.471510748271j)*x_ref[2]
            arg[(3, 0, 2)]+=(-0.180998162336+0.74715169785j)*x[2]
            ref[(3, 0, 2)]+=(-0.180998162336+0.74715169785j)*x_ref[2]
            arg[(3, 0, 3)]+=(0.502260253214-0.443133185562j)*x[2]
            ref[(3, 0, 3)]+=(0.502260253214-0.443133185562j)*x_ref[2]
            arg[(3, 1, 0)]+=(-0.279891811021+0.612207234573j)*x[2]
            ref[(3, 1, 0)]+=(-0.279891811021+0.612207234573j)*x_ref[2]
            arg[(3, 1, 1)]+=(0.513141660993+0.242853542448j)*x[2]
            ref[(3, 1, 1)]+=(0.513141660993+0.242853542448j)*x_ref[2]
            arg[(3, 1, 2)]+=(0.841180433655-0.117680879196j)*x[2]
            ref[(3, 1, 2)]+=(0.841180433655-0.117680879196j)*x_ref[2]
            arg[(3, 1, 3)]+=(0.258984868929-0.576810609777j)*x[2]
            ref[(3, 1, 3)]+=(0.258984868929-0.576810609777j)*x_ref[2]
            arg[(3, 2, 0)]+=(0.230376010348-0.748076905017j)*x[2]
            ref[(3, 2, 0)]+=(0.230376010348-0.748076905017j)*x_ref[2]
            arg[(3, 2, 1)]+=(0.504471492047+0.852561168691j)*x[2]
            ref[(3, 2, 1)]+=(0.504471492047+0.852561168691j)*x_ref[2]
            arg[(3, 2, 2)]+=(-0.143739510294+0.489877774134j)*x[2]
            ref[(3, 2, 2)]+=(-0.143739510294+0.489877774134j)*x_ref[2]
            arg[(3, 2, 3)]+=(0.563099000864-0.32337637509j)*x[2]
            ref[(3, 2, 3)]+=(0.563099000864-0.32337637509j)*x_ref[2]
            arg[(3, 3, 0)]+=(0.341476149338+0.394989240017j)*x[2]
            ref[(3, 3, 0)]+=(0.341476149338+0.394989240017j)*x_ref[2]
            arg[(3, 3, 1)]+=(-0.45518153863-0.353844743387j)*x[2]
            ref[(3, 3, 1)]+=(-0.45518153863-0.353844743387j)*x_ref[2]
            arg[(3, 3, 2)]+=(0.0593971057081-0.0634767231609j)*x[2]
            ref[(3, 3, 2)]+=(0.0593971057081-0.0634767231609j)*x_ref[2]
            arg[(3, 3, 3)]+=(0.158841179464-0.890197125947j)*x[2]
            ref[(3, 3, 3)]+=(0.158841179464-0.890197125947j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 4, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedContinuousFunction_rank4(self):
        """
        tests interpolation of rank 4 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 3, 4),w)
        ref = Data(0,(2, 2, 3, 4),w_ref)
        arg[(0, 0, 0, 0)]=(-0.641078084577+0.918973768016j)*x[0] + ((0.261234555848+0.949787092528j))*x[1]
        ref[(0, 0, 0, 0)]=(-0.641078084577+0.918973768016j)*x_ref[0] + ((0.261234555848+0.949787092528j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.655634800965-0.350233430487j)*x[0] + ((-0.627308521836+0.82274947731j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.655634800965-0.350233430487j)*x_ref[0] + ((-0.627308521836+0.82274947731j))*x_ref[1]
        arg[(0, 0, 0, 2)]=(0.950918526529+0.495323278508j)*x[0] + ((0.00562881910014-0.90132379158j))*x[1]
        ref[(0, 0, 0, 2)]=(0.950918526529+0.495323278508j)*x_ref[0] + ((0.00562881910014-0.90132379158j))*x_ref[1]
        arg[(0, 0, 0, 3)]=(0.870632465315+0.994199033594j)*x[0] + ((-0.61981175361+0.0669988772929j))*x[1]
        ref[(0, 0, 0, 3)]=(0.870632465315+0.994199033594j)*x_ref[0] + ((-0.61981175361+0.0669988772929j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(-0.307030774362-0.907836925571j)*x[0] + ((-0.686838445883+0.74426107891j))*x[1]
        ref[(0, 0, 1, 0)]=(-0.307030774362-0.907836925571j)*x_ref[0] + ((-0.686838445883+0.74426107891j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.556424250196-0.0619590775142j)*x[0] + ((-0.293656512577+0.587354856627j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.556424250196-0.0619590775142j)*x_ref[0] + ((-0.293656512577+0.587354856627j))*x_ref[1]
        arg[(0, 0, 1, 2)]=(-0.0498112021853-0.130750670572j)*x[0] + ((-0.984434605573+0.86596901977j))*x[1]
        ref[(0, 0, 1, 2)]=(-0.0498112021853-0.130750670572j)*x_ref[0] + ((-0.984434605573+0.86596901977j))*x_ref[1]
        arg[(0, 0, 1, 3)]=(-0.947149784395+0.302882254002j)*x[0] + ((-0.720959826189+0.609881081339j))*x[1]
        ref[(0, 0, 1, 3)]=(-0.947149784395+0.302882254002j)*x_ref[0] + ((-0.720959826189+0.609881081339j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(-0.116363002458-0.117321102515j)*x[0] + ((0.827406067396+0.913576959643j))*x[1]
        ref[(0, 0, 2, 0)]=(-0.116363002458-0.117321102515j)*x_ref[0] + ((0.827406067396+0.913576959643j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(0.108216710332-0.609801740634j)*x[0] + ((0.722114781225+0.489616180569j))*x[1]
        ref[(0, 0, 2, 1)]=(0.108216710332-0.609801740634j)*x_ref[0] + ((0.722114781225+0.489616180569j))*x_ref[1]
        arg[(0, 0, 2, 2)]=(-0.620270437657+0.705080299055j)*x[0] + ((-0.979914126853+0.00325851625408j))*x[1]
        ref[(0, 0, 2, 2)]=(-0.620270437657+0.705080299055j)*x_ref[0] + ((-0.979914126853+0.00325851625408j))*x_ref[1]
        arg[(0, 0, 2, 3)]=(-0.901042076607-0.319411369224j)*x[0] + ((0.0724991958606+0.969491643698j))*x[1]
        ref[(0, 0, 2, 3)]=(-0.901042076607-0.319411369224j)*x_ref[0] + ((0.0724991958606+0.969491643698j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.627088244737+0.975909048715j)*x[0] + ((-0.00714104438544-0.903725341462j))*x[1]
        ref[(0, 1, 0, 0)]=(0.627088244737+0.975909048715j)*x_ref[0] + ((-0.00714104438544-0.903725341462j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(-0.507015393336+0.643411790727j)*x[0] + ((-0.772767400794-0.0179515241632j))*x[1]
        ref[(0, 1, 0, 1)]=(-0.507015393336+0.643411790727j)*x_ref[0] + ((-0.772767400794-0.0179515241632j))*x_ref[1]
        arg[(0, 1, 0, 2)]=(0.805833106938-0.547377285752j)*x[0] + ((0.694870188547-0.411058024673j))*x[1]
        ref[(0, 1, 0, 2)]=(0.805833106938-0.547377285752j)*x_ref[0] + ((0.694870188547-0.411058024673j))*x_ref[1]
        arg[(0, 1, 0, 3)]=(0.713509869016+0.17148991422j)*x[0] + ((-0.179192051485+0.502636284024j))*x[1]
        ref[(0, 1, 0, 3)]=(0.713509869016+0.17148991422j)*x_ref[0] + ((-0.179192051485+0.502636284024j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(0.671285218399+0.0479087959237j)*x[0] + ((0.312772965235+0.539926896128j))*x[1]
        ref[(0, 1, 1, 0)]=(0.671285218399+0.0479087959237j)*x_ref[0] + ((0.312772965235+0.539926896128j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(0.679331853982-0.61329069829j)*x[0] + ((-0.572026178356+0.89108686495j))*x[1]
        ref[(0, 1, 1, 1)]=(0.679331853982-0.61329069829j)*x_ref[0] + ((-0.572026178356+0.89108686495j))*x_ref[1]
        arg[(0, 1, 1, 2)]=(0.104125378634-0.828442874868j)*x[0] + ((-0.773267848083+0.473750215909j))*x[1]
        ref[(0, 1, 1, 2)]=(0.104125378634-0.828442874868j)*x_ref[0] + ((-0.773267848083+0.473750215909j))*x_ref[1]
        arg[(0, 1, 1, 3)]=(0.711011697083+0.101471094001j)*x[0] + ((0.816952776155-0.626958300746j))*x[1]
        ref[(0, 1, 1, 3)]=(0.711011697083+0.101471094001j)*x_ref[0] + ((0.816952776155-0.626958300746j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(0.420305392433-0.29750811172j)*x[0] + ((0.489913850409-0.729170687449j))*x[1]
        ref[(0, 1, 2, 0)]=(0.420305392433-0.29750811172j)*x_ref[0] + ((0.489913850409-0.729170687449j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(0.370341576663-0.820792916501j)*x[0] + ((0.446688537465-0.477658358203j))*x[1]
        ref[(0, 1, 2, 1)]=(0.370341576663-0.820792916501j)*x_ref[0] + ((0.446688537465-0.477658358203j))*x_ref[1]
        arg[(0, 1, 2, 2)]=(-0.368564924376-0.294431300425j)*x[0] + ((-0.240222178324+0.590467051906j))*x[1]
        ref[(0, 1, 2, 2)]=(-0.368564924376-0.294431300425j)*x_ref[0] + ((-0.240222178324+0.590467051906j))*x_ref[1]
        arg[(0, 1, 2, 3)]=(0.643312744479+0.976958653078j)*x[0] + ((-0.581549246641+0.739319241966j))*x[1]
        ref[(0, 1, 2, 3)]=(0.643312744479+0.976958653078j)*x_ref[0] + ((-0.581549246641+0.739319241966j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.477517020381+0.765210388481j)*x[0] + ((0.746728909363+0.684781965999j))*x[1]
        ref[(1, 0, 0, 0)]=(0.477517020381+0.765210388481j)*x_ref[0] + ((0.746728909363+0.684781965999j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.473155374784-0.348762993871j)*x[0] + ((0.0452049808265-0.204383949893j))*x[1]
        ref[(1, 0, 0, 1)]=(0.473155374784-0.348762993871j)*x_ref[0] + ((0.0452049808265-0.204383949893j))*x_ref[1]
        arg[(1, 0, 0, 2)]=(0.431509917676-0.477805405064j)*x[0] + ((-0.120112591927+0.678442256651j))*x[1]
        ref[(1, 0, 0, 2)]=(0.431509917676-0.477805405064j)*x_ref[0] + ((-0.120112591927+0.678442256651j))*x_ref[1]
        arg[(1, 0, 0, 3)]=(0.522704671993+0.380369574887j)*x[0] + ((0.960021996752-0.90630862976j))*x[1]
        ref[(1, 0, 0, 3)]=(0.522704671993+0.380369574887j)*x_ref[0] + ((0.960021996752-0.90630862976j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.978349945482+0.980715349701j)*x[0] + ((-0.358357772094-0.615804135046j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.978349945482+0.980715349701j)*x_ref[0] + ((-0.358357772094-0.615804135046j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(0.967145523071+0.427932120873j)*x[0] + ((0.404373509335-0.31964167579j))*x[1]
        ref[(1, 0, 1, 1)]=(0.967145523071+0.427932120873j)*x_ref[0] + ((0.404373509335-0.31964167579j))*x_ref[1]
        arg[(1, 0, 1, 2)]=(-0.15970753477+0.857192147963j)*x[0] + ((-0.0260330418234-0.528722920613j))*x[1]
        ref[(1, 0, 1, 2)]=(-0.15970753477+0.857192147963j)*x_ref[0] + ((-0.0260330418234-0.528722920613j))*x_ref[1]
        arg[(1, 0, 1, 3)]=(0.114476525532-0.914466126402j)*x[0] + ((-0.737993453338-0.764446705376j))*x[1]
        ref[(1, 0, 1, 3)]=(0.114476525532-0.914466126402j)*x_ref[0] + ((-0.737993453338-0.764446705376j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(0.787701998056+0.285362161516j)*x[0] + ((-0.522316983514+0.276632007109j))*x[1]
        ref[(1, 0, 2, 0)]=(0.787701998056+0.285362161516j)*x_ref[0] + ((-0.522316983514+0.276632007109j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(-0.984952868941+0.15238863145j)*x[0] + ((-0.293006472917-0.154824722937j))*x[1]
        ref[(1, 0, 2, 1)]=(-0.984952868941+0.15238863145j)*x_ref[0] + ((-0.293006472917-0.154824722937j))*x_ref[1]
        arg[(1, 0, 2, 2)]=(0.72932666836-0.334644033448j)*x[0] + ((0.698148640153+0.392538087596j))*x[1]
        ref[(1, 0, 2, 2)]=(0.72932666836-0.334644033448j)*x_ref[0] + ((0.698148640153+0.392538087596j))*x_ref[1]
        arg[(1, 0, 2, 3)]=(0.39069537336-0.18833832893j)*x[0] + ((-0.283463656149+0.346617330371j))*x[1]
        ref[(1, 0, 2, 3)]=(0.39069537336-0.18833832893j)*x_ref[0] + ((-0.283463656149+0.346617330371j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(-0.284007903642+0.945474280574j)*x[0] + ((0.327167670116-0.199474263381j))*x[1]
        ref[(1, 1, 0, 0)]=(-0.284007903642+0.945474280574j)*x_ref[0] + ((0.327167670116-0.199474263381j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(0.908583517053+0.94373788368j)*x[0] + ((0.276031957787+0.451388594533j))*x[1]
        ref[(1, 1, 0, 1)]=(0.908583517053+0.94373788368j)*x_ref[0] + ((0.276031957787+0.451388594533j))*x_ref[1]
        arg[(1, 1, 0, 2)]=(-0.721870551988+0.983488442205j)*x[0] + ((0.889989269934-0.708654792272j))*x[1]
        ref[(1, 1, 0, 2)]=(-0.721870551988+0.983488442205j)*x_ref[0] + ((0.889989269934-0.708654792272j))*x_ref[1]
        arg[(1, 1, 0, 3)]=(-0.953606025775-0.582089580548j)*x[0] + ((-0.614555685534-0.317962856482j))*x[1]
        ref[(1, 1, 0, 3)]=(-0.953606025775-0.582089580548j)*x_ref[0] + ((-0.614555685534-0.317962856482j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.503053335266+0.876307826923j)*x[0] + ((-0.1831383887-0.16337798398j))*x[1]
        ref[(1, 1, 1, 0)]=(0.503053335266+0.876307826923j)*x_ref[0] + ((-0.1831383887-0.16337798398j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.429139708432+0.9696071421j)*x[0] + ((-0.689599144951+0.870257827666j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.429139708432+0.9696071421j)*x_ref[0] + ((-0.689599144951+0.870257827666j))*x_ref[1]
        arg[(1, 1, 1, 2)]=(-0.0220926906768-0.416245020071j)*x[0] + ((0.401916144618-0.364877815011j))*x[1]
        ref[(1, 1, 1, 2)]=(-0.0220926906768-0.416245020071j)*x_ref[0] + ((0.401916144618-0.364877815011j))*x_ref[1]
        arg[(1, 1, 1, 3)]=(-0.18636773578-0.40934914147j)*x[0] + ((-0.470630514762-0.524198840988j))*x[1]
        ref[(1, 1, 1, 3)]=(-0.18636773578-0.40934914147j)*x_ref[0] + ((-0.470630514762-0.524198840988j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(-0.0138207304835-0.50026072036j)*x[0] + ((-0.679326389476-0.982319532354j))*x[1]
        ref[(1, 1, 2, 0)]=(-0.0138207304835-0.50026072036j)*x_ref[0] + ((-0.679326389476-0.982319532354j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(-0.996973098193-0.495402667751j)*x[0] + ((-0.929019039473+0.821400580667j))*x[1]
        ref[(1, 1, 2, 1)]=(-0.996973098193-0.495402667751j)*x_ref[0] + ((-0.929019039473+0.821400580667j))*x_ref[1]
        arg[(1, 1, 2, 2)]=(-0.78826278975-0.0617158034381j)*x[0] + ((0.708153176864+0.57109641831j))*x[1]
        ref[(1, 1, 2, 2)]=(-0.78826278975-0.0617158034381j)*x_ref[0] + ((0.708153176864+0.57109641831j))*x_ref[1]
        arg[(1, 1, 2, 3)]=(0.165954097174-0.545005480716j)*x[0] + ((0.49666732685-0.80864919339j))*x[1]
        ref[(1, 1, 2, 3)]=(0.165954097174-0.545005480716j)*x_ref[0] + ((0.49666732685-0.80864919339j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.0112225144704+0.573238537809j)*x[2]
            ref[(0, 0, 0, 0)]+=(-0.0112225144704+0.573238537809j)*x_ref[2]
            arg[(0, 0, 0, 1)]+=(0.637225518365+0.725652205538j)*x[2]
            ref[(0, 0, 0, 1)]+=(0.637225518365+0.725652205538j)*x_ref[2]
            arg[(0, 0, 0, 2)]+=(-0.283279997422-0.756386332558j)*x[2]
            ref[(0, 0, 0, 2)]+=(-0.283279997422-0.756386332558j)*x_ref[2]
            arg[(0, 0, 0, 3)]+=(-0.610354063444-0.915931012437j)*x[2]
            ref[(0, 0, 0, 3)]+=(-0.610354063444-0.915931012437j)*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.49481365273+0.197257543888j)*x[2]
            ref[(0, 0, 1, 0)]+=(-0.49481365273+0.197257543888j)*x_ref[2]
            arg[(0, 0, 1, 1)]+=(-0.319823485907+0.176520075089j)*x[2]
            ref[(0, 0, 1, 1)]+=(-0.319823485907+0.176520075089j)*x_ref[2]
            arg[(0, 0, 1, 2)]+=(-0.696544974611+0.342437260206j)*x[2]
            ref[(0, 0, 1, 2)]+=(-0.696544974611+0.342437260206j)*x_ref[2]
            arg[(0, 0, 1, 3)]+=(0.00721202252053-0.0038891438462j)*x[2]
            ref[(0, 0, 1, 3)]+=(0.00721202252053-0.0038891438462j)*x_ref[2]
            arg[(0, 0, 2, 0)]+=(0.643674686781-0.405969029861j)*x[2]
            ref[(0, 0, 2, 0)]+=(0.643674686781-0.405969029861j)*x_ref[2]
            arg[(0, 0, 2, 1)]+=(-0.822386662106+0.678921946502j)*x[2]
            ref[(0, 0, 2, 1)]+=(-0.822386662106+0.678921946502j)*x_ref[2]
            arg[(0, 0, 2, 2)]+=(0.544938206004-0.655782840153j)*x[2]
            ref[(0, 0, 2, 2)]+=(0.544938206004-0.655782840153j)*x_ref[2]
            arg[(0, 0, 2, 3)]+=(-0.364130860525+0.0311202652392j)*x[2]
            ref[(0, 0, 2, 3)]+=(-0.364130860525+0.0311202652392j)*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.430632091916+0.0906710734783j)*x[2]
            ref[(0, 1, 0, 0)]+=(-0.430632091916+0.0906710734783j)*x_ref[2]
            arg[(0, 1, 0, 1)]+=(-0.83603426921+0.132475785794j)*x[2]
            ref[(0, 1, 0, 1)]+=(-0.83603426921+0.132475785794j)*x_ref[2]
            arg[(0, 1, 0, 2)]+=(-0.000692664457461+0.60725840828j)*x[2]
            ref[(0, 1, 0, 2)]+=(-0.000692664457461+0.60725840828j)*x_ref[2]
            arg[(0, 1, 0, 3)]+=(0.871158683182-0.41725924786j)*x[2]
            ref[(0, 1, 0, 3)]+=(0.871158683182-0.41725924786j)*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.110477097231-0.150531391215j)*x[2]
            ref[(0, 1, 1, 0)]+=(-0.110477097231-0.150531391215j)*x_ref[2]
            arg[(0, 1, 1, 1)]+=(0.709961079659+0.12716850581j)*x[2]
            ref[(0, 1, 1, 1)]+=(0.709961079659+0.12716850581j)*x_ref[2]
            arg[(0, 1, 1, 2)]+=(-0.199869826166-0.116895174163j)*x[2]
            ref[(0, 1, 1, 2)]+=(-0.199869826166-0.116895174163j)*x_ref[2]
            arg[(0, 1, 1, 3)]+=(0.0219999972418+0.940973425616j)*x[2]
            ref[(0, 1, 1, 3)]+=(0.0219999972418+0.940973425616j)*x_ref[2]
            arg[(0, 1, 2, 0)]+=(0.43837912863+0.578778692145j)*x[2]
            ref[(0, 1, 2, 0)]+=(0.43837912863+0.578778692145j)*x_ref[2]
            arg[(0, 1, 2, 1)]+=(-0.874079566839+0.719867011038j)*x[2]
            ref[(0, 1, 2, 1)]+=(-0.874079566839+0.719867011038j)*x_ref[2]
            arg[(0, 1, 2, 2)]+=(0.375453436308-0.695984898092j)*x[2]
            ref[(0, 1, 2, 2)]+=(0.375453436308-0.695984898092j)*x_ref[2]
            arg[(0, 1, 2, 3)]+=(0.900793459345+0.902700946159j)*x[2]
            ref[(0, 1, 2, 3)]+=(0.900793459345+0.902700946159j)*x_ref[2]
            arg[(1, 0, 0, 0)]+=(0.874270415385+0.012541785285j)*x[2]
            ref[(1, 0, 0, 0)]+=(0.874270415385+0.012541785285j)*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.387960796699+0.242348643159j)*x[2]
            ref[(1, 0, 0, 1)]+=(0.387960796699+0.242348643159j)*x_ref[2]
            arg[(1, 0, 0, 2)]+=(0.223247116196+0.342930709548j)*x[2]
            ref[(1, 0, 0, 2)]+=(0.223247116196+0.342930709548j)*x_ref[2]
            arg[(1, 0, 0, 3)]+=(-0.769609265424+0.837232455138j)*x[2]
            ref[(1, 0, 0, 3)]+=(-0.769609265424+0.837232455138j)*x_ref[2]
            arg[(1, 0, 1, 0)]+=(0.159442149831+0.15886066558j)*x[2]
            ref[(1, 0, 1, 0)]+=(0.159442149831+0.15886066558j)*x_ref[2]
            arg[(1, 0, 1, 1)]+=(-0.838327896951-0.853137025181j)*x[2]
            ref[(1, 0, 1, 1)]+=(-0.838327896951-0.853137025181j)*x_ref[2]
            arg[(1, 0, 1, 2)]+=(0.0371050704522+0.339700831852j)*x[2]
            ref[(1, 0, 1, 2)]+=(0.0371050704522+0.339700831852j)*x_ref[2]
            arg[(1, 0, 1, 3)]+=(-0.243469128175-0.302700906181j)*x[2]
            ref[(1, 0, 1, 3)]+=(-0.243469128175-0.302700906181j)*x_ref[2]
            arg[(1, 0, 2, 0)]+=(-0.374861425893-0.687306020459j)*x[2]
            ref[(1, 0, 2, 0)]+=(-0.374861425893-0.687306020459j)*x_ref[2]
            arg[(1, 0, 2, 1)]+=(-0.368609270117+0.317636888602j)*x[2]
            ref[(1, 0, 2, 1)]+=(-0.368609270117+0.317636888602j)*x_ref[2]
            arg[(1, 0, 2, 2)]+=(0.394237664947-0.402264651351j)*x[2]
            ref[(1, 0, 2, 2)]+=(0.394237664947-0.402264651351j)*x_ref[2]
            arg[(1, 0, 2, 3)]+=(0.743149846034-0.748283577651j)*x[2]
            ref[(1, 0, 2, 3)]+=(0.743149846034-0.748283577651j)*x_ref[2]
            arg[(1, 1, 0, 0)]+=(-0.20396107528-0.741842439343j)*x[2]
            ref[(1, 1, 0, 0)]+=(-0.20396107528-0.741842439343j)*x_ref[2]
            arg[(1, 1, 0, 1)]+=(0.855740724352+0.589675423646j)*x[2]
            ref[(1, 1, 0, 1)]+=(0.855740724352+0.589675423646j)*x_ref[2]
            arg[(1, 1, 0, 2)]+=(0.806272090926-0.0905730047449j)*x[2]
            ref[(1, 1, 0, 2)]+=(0.806272090926-0.0905730047449j)*x_ref[2]
            arg[(1, 1, 0, 3)]+=(-0.471453658684-0.550670424795j)*x[2]
            ref[(1, 1, 0, 3)]+=(-0.471453658684-0.550670424795j)*x_ref[2]
            arg[(1, 1, 1, 0)]+=(-0.603225095573-0.604960485496j)*x[2]
            ref[(1, 1, 1, 0)]+=(-0.603225095573-0.604960485496j)*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.733219671746-0.441894396534j)*x[2]
            ref[(1, 1, 1, 1)]+=(-0.733219671746-0.441894396534j)*x_ref[2]
            arg[(1, 1, 1, 2)]+=(-0.840732092689-0.0101208260114j)*x[2]
            ref[(1, 1, 1, 2)]+=(-0.840732092689-0.0101208260114j)*x_ref[2]
            arg[(1, 1, 1, 3)]+=(-0.465188251037-0.441787815693j)*x[2]
            ref[(1, 1, 1, 3)]+=(-0.465188251037-0.441787815693j)*x_ref[2]
            arg[(1, 1, 2, 0)]+=(0.659025348823-0.210096371184j)*x[2]
            ref[(1, 1, 2, 0)]+=(0.659025348823-0.210096371184j)*x_ref[2]
            arg[(1, 1, 2, 1)]+=(-0.0687891231289+0.864180909895j)*x[2]
            ref[(1, 1, 2, 1)]+=(-0.0687891231289+0.864180909895j)*x_ref[2]
            arg[(1, 1, 2, 2)]+=(0.573567215772+0.49354282868j)*x[2]
            ref[(1, 1, 2, 2)]+=(0.573567215772+0.49354282868j)*x_ref[2]
            arg[(1, 1, 2, 3)]+=(0.460545956806+0.606184935705j)*x[2]
            ref[(1, 1, 2, 3)]+=(0.460545956806+0.606184935705j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2, 3, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedFunction_rank0(self):
        """
        tests interpolation of rank 0 Data on ReducedFunction

        assumptions: ReducedFunction(self.domain) exists
                     self.domain supports interpolation from ReducedFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.898558125797+0.0543560692468j)*x[0]**o + ((-0.645347625979-0.557630832597j))*x[0] + ((0.516002337343+0.946596329766j))*x[1]**o + ((-0.93509732237-0.218849785834j))*x[1]
        ref=(-0.898558125797+0.0543560692468j)*x_ref[0]**o + ((-0.645347625979-0.557630832597j))*x_ref[0] + ((0.516002337343+0.946596329766j))*x_ref[1]**o + ((-0.93509732237-0.218849785834j))*x_ref[1]
        if dim==3:
            arg+=((-0.0546192050155-0.0237677777274j))*x[2]**o + ((-0.197688052679+0.53842743488j))*x[2]
            ref+=((-0.0546192050155-0.0237677777274j))*x_ref[2]**o + ((-0.197688052679+0.53842743488j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedFunction_rank1(self):
        """
        tests interpolation of rank 1 Data on ReducedFunction

        assumptions: ReducedFunction(self.domain) exists
                     self.domain supports interpolation from ReducedFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,),w_ref)
        arg[(0,)]=(0.684130070327+0.35429164125j)*x[0]**o + ((0.597552808874-0.057308501021j))*x[0] + ((0.718822088787-0.899270381586j))*x[1]**o + ((-0.555812380239-0.474314657352j))*x[1]
        ref[(0,)]=(0.684130070327+0.35429164125j)*x_ref[0]**o + ((0.597552808874-0.057308501021j))*x_ref[0] + ((0.718822088787-0.899270381586j))*x_ref[1]**o + ((-0.555812380239-0.474314657352j))*x_ref[1]
        arg[(1,)]=(-0.530982584516+0.324371235171j)*x[0]**o + ((0.91669675204-0.825755293026j))*x[0] + ((-0.0952207981039+0.299052635581j))*x[1]**o + ((-0.634075962397+0.915623137436j))*x[1]
        ref[(1,)]=(-0.530982584516+0.324371235171j)*x_ref[0]**o + ((0.91669675204-0.825755293026j))*x_ref[0] + ((-0.0952207981039+0.299052635581j))*x_ref[1]**o + ((-0.634075962397+0.915623137436j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(0.821338681701-0.999656559713j)*x[2]**o + ((0.150888806043+0.678559762343j))*x[2]
            ref[(0,)]+=(0.821338681701-0.999656559713j)*x_ref[2]**o + ((0.150888806043+0.678559762343j))*x_ref[2]
            arg[(1,)]+=(0.355700702807+0.0802834699484j)*x[2]**o + ((0.871561236434+0.860447330139j))*x[2]
            ref[(1,)]+=(0.355700702807+0.0802834699484j)*x_ref[2]**o + ((0.871561236434+0.860447330139j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedFunction_rank2(self):
        """
        tests interpolation of rank 2 Data on ReducedFunction

        assumptions: ReducedFunction(self.domain) exists
                     self.domain supports interpolation from ReducedFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3),w_ref)
        arg[(0, 0)]=(0.212980192858+0.638272890605j)*x[0]**o + ((-0.791546520064+0.93701573862j))*x[0] + ((0.354025203829+0.613294080035j))*x[1]**o + ((-0.679631666733-0.832148911041j))*x[1]
        ref[(0, 0)]=(0.212980192858+0.638272890605j)*x_ref[0]**o + ((-0.791546520064+0.93701573862j))*x_ref[0] + ((0.354025203829+0.613294080035j))*x_ref[1]**o + ((-0.679631666733-0.832148911041j))*x_ref[1]
        arg[(0, 1)]=(0.567196778184-0.103933012878j)*x[0]**o + ((0.567175356188+0.973331543011j))*x[0] + ((0.00488814412918+0.109990551308j))*x[1]**o + ((-0.750657172394+0.70101689702j))*x[1]
        ref[(0, 1)]=(0.567196778184-0.103933012878j)*x_ref[0]**o + ((0.567175356188+0.973331543011j))*x_ref[0] + ((0.00488814412918+0.109990551308j))*x_ref[1]**o + ((-0.750657172394+0.70101689702j))*x_ref[1]
        arg[(0, 2)]=(0.0899735474916-0.900916385281j)*x[0]**o + ((0.348990095732-0.129798610284j))*x[0] + ((0.345472221971+0.018341947227j))*x[1]**o + ((0.391384074609+0.0475435423605j))*x[1]
        ref[(0, 2)]=(0.0899735474916-0.900916385281j)*x_ref[0]**o + ((0.348990095732-0.129798610284j))*x_ref[0] + ((0.345472221971+0.018341947227j))*x_ref[1]**o + ((0.391384074609+0.0475435423605j))*x_ref[1]
        arg[(1, 0)]=(0.315320967953+0.502788792564j)*x[0]**o + ((0.425496254728+0.338572182199j))*x[0] + ((-0.791938858556-0.096021945661j))*x[1]**o + ((0.539994243701+0.905299856539j))*x[1]
        ref[(1, 0)]=(0.315320967953+0.502788792564j)*x_ref[0]**o + ((0.425496254728+0.338572182199j))*x_ref[0] + ((-0.791938858556-0.096021945661j))*x_ref[1]**o + ((0.539994243701+0.905299856539j))*x_ref[1]
        arg[(1, 1)]=(-0.0974274226435-0.976092687507j)*x[0]**o + ((-0.767053394916-0.402879809569j))*x[0] + ((-0.34353136656-0.0217068518001j))*x[1]**o + ((0.660127238737+0.725036895188j))*x[1]
        ref[(1, 1)]=(-0.0974274226435-0.976092687507j)*x_ref[0]**o + ((-0.767053394916-0.402879809569j))*x_ref[0] + ((-0.34353136656-0.0217068518001j))*x_ref[1]**o + ((0.660127238737+0.725036895188j))*x_ref[1]
        arg[(1, 2)]=(-0.230492456918-0.874278842903j)*x[0]**o + ((0.193046331434+0.0317192140991j))*x[0] + ((-0.204271009349-0.897717080387j))*x[1]**o + ((-0.743947694599-0.725372739301j))*x[1]
        ref[(1, 2)]=(-0.230492456918-0.874278842903j)*x_ref[0]**o + ((0.193046331434+0.0317192140991j))*x_ref[0] + ((-0.204271009349-0.897717080387j))*x_ref[1]**o + ((-0.743947694599-0.725372739301j))*x_ref[1]
        arg[(2, 0)]=(-0.967918209289+0.377736862071j)*x[0]**o + ((-0.371454204923+0.483922111403j))*x[0] + ((0.873970818229-0.403363470205j))*x[1]**o + ((0.373408175826-0.853125829863j))*x[1]
        ref[(2, 0)]=(-0.967918209289+0.377736862071j)*x_ref[0]**o + ((-0.371454204923+0.483922111403j))*x_ref[0] + ((0.873970818229-0.403363470205j))*x_ref[1]**o + ((0.373408175826-0.853125829863j))*x_ref[1]
        arg[(2, 1)]=(0.395590104863+0.386695076412j)*x[0]**o + ((0.206827147658-0.28639827477j))*x[0] + ((-0.897993010648+0.523870210247j))*x[1]**o + ((0.5695535881+0.440820339875j))*x[1]
        ref[(2, 1)]=(0.395590104863+0.386695076412j)*x_ref[0]**o + ((0.206827147658-0.28639827477j))*x_ref[0] + ((-0.897993010648+0.523870210247j))*x_ref[1]**o + ((0.5695535881+0.440820339875j))*x_ref[1]
        arg[(2, 2)]=(-0.257881903956-0.770311753036j)*x[0]**o + ((-0.210331241142+0.286867212023j))*x[0] + ((-0.667337917161+0.152721789735j))*x[1]**o + ((0.532052894893+0.638428790951j))*x[1]
        ref[(2, 2)]=(-0.257881903956-0.770311753036j)*x_ref[0]**o + ((-0.210331241142+0.286867212023j))*x_ref[0] + ((-0.667337917161+0.152721789735j))*x_ref[1]**o + ((0.532052894893+0.638428790951j))*x_ref[1]
        arg[(3, 0)]=(0.734904441366+0.340105831218j)*x[0]**o + ((-0.567776061327+0.649707791206j))*x[0] + ((-0.572411758588+0.702902582462j))*x[1]**o + ((-0.649083329261+0.145003995874j))*x[1]
        ref[(3, 0)]=(0.734904441366+0.340105831218j)*x_ref[0]**o + ((-0.567776061327+0.649707791206j))*x_ref[0] + ((-0.572411758588+0.702902582462j))*x_ref[1]**o + ((-0.649083329261+0.145003995874j))*x_ref[1]
        arg[(3, 1)]=(-0.429751841942+0.709953981749j)*x[0]**o + ((-0.99627951218-0.295885447663j))*x[0] + ((0.218091111863+0.925204872822j))*x[1]**o + ((-0.406759781468+0.132169537874j))*x[1]
        ref[(3, 1)]=(-0.429751841942+0.709953981749j)*x_ref[0]**o + ((-0.99627951218-0.295885447663j))*x_ref[0] + ((0.218091111863+0.925204872822j))*x_ref[1]**o + ((-0.406759781468+0.132169537874j))*x_ref[1]
        arg[(3, 2)]=(-0.692462081073-0.72135852222j)*x[0]**o + ((0.618427158078+0.228187150303j))*x[0] + ((-0.0573508207357-0.4334934129j))*x[1]**o + ((0.902895044085+0.426410554851j))*x[1]
        ref[(3, 2)]=(-0.692462081073-0.72135852222j)*x_ref[0]**o + ((0.618427158078+0.228187150303j))*x_ref[0] + ((-0.0573508207357-0.4334934129j))*x_ref[1]**o + ((0.902895044085+0.426410554851j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(0.262935380329-0.300127878419j)*x[2]**o + ((-0.486163566593-0.0587435373668j))*x[2]
            ref[(0, 0)]+=(0.262935380329-0.300127878419j)*x_ref[2]**o + ((-0.486163566593-0.0587435373668j))*x_ref[2]
            arg[(0, 1)]+=(-0.249069944584+0.0575276568509j)*x[2]**o + ((0.0127256645697-0.104853970803j))*x[2]
            ref[(0, 1)]+=(-0.249069944584+0.0575276568509j)*x_ref[2]**o + ((0.0127256645697-0.104853970803j))*x_ref[2]
            arg[(0, 2)]+=(0.754425243751-0.468276849509j)*x[2]**o + ((0.269057325199-0.566529879258j))*x[2]
            ref[(0, 2)]+=(0.754425243751-0.468276849509j)*x_ref[2]**o + ((0.269057325199-0.566529879258j))*x_ref[2]
            arg[(1, 0)]+=(-0.653175569185+0.079139591838j)*x[2]**o + ((-0.8828979845-0.13622047647j))*x[2]
            ref[(1, 0)]+=(-0.653175569185+0.079139591838j)*x_ref[2]**o + ((-0.8828979845-0.13622047647j))*x_ref[2]
            arg[(1, 1)]+=(-0.307541161328+0.419373260526j)*x[2]**o + ((-0.465201065397-0.0324334831961j))*x[2]
            ref[(1, 1)]+=(-0.307541161328+0.419373260526j)*x_ref[2]**o + ((-0.465201065397-0.0324334831961j))*x_ref[2]
            arg[(1, 2)]+=(0.473724598634-0.510921239046j)*x[2]**o + ((-0.822427576567-0.320121682356j))*x[2]
            ref[(1, 2)]+=(0.473724598634-0.510921239046j)*x_ref[2]**o + ((-0.822427576567-0.320121682356j))*x_ref[2]
            arg[(2, 0)]+=(-0.478476307697-0.650076519392j)*x[2]**o + ((0.447385154992-0.8073565259j))*x[2]
            ref[(2, 0)]+=(-0.478476307697-0.650076519392j)*x_ref[2]**o + ((0.447385154992-0.8073565259j))*x_ref[2]
            arg[(2, 1)]+=(0.764594049348-0.19675658005j)*x[2]**o + ((0.10851254959-0.462754191918j))*x[2]
            ref[(2, 1)]+=(0.764594049348-0.19675658005j)*x_ref[2]**o + ((0.10851254959-0.462754191918j))*x_ref[2]
            arg[(2, 2)]+=(-0.361953029038-0.0911930886968j)*x[2]**o + ((-0.0126545765333-0.166218143023j))*x[2]
            ref[(2, 2)]+=(-0.361953029038-0.0911930886968j)*x_ref[2]**o + ((-0.0126545765333-0.166218143023j))*x_ref[2]
            arg[(3, 0)]+=(0.841614200238-0.110643437709j)*x[2]**o + ((0.546470320319+0.0795978669632j))*x[2]
            ref[(3, 0)]+=(0.841614200238-0.110643437709j)*x_ref[2]**o + ((0.546470320319+0.0795978669632j))*x_ref[2]
            arg[(3, 1)]+=(-0.752407156367+0.420338277394j)*x[2]**o + ((-0.356022387196-0.222883955668j))*x[2]
            ref[(3, 1)]+=(-0.752407156367+0.420338277394j)*x_ref[2]**o + ((-0.356022387196-0.222883955668j))*x_ref[2]
            arg[(3, 2)]+=(-0.453528694111-0.217310241864j)*x[2]**o + ((-0.674963756091-0.793417782287j))*x[2]
            ref[(3, 2)]+=(-0.453528694111-0.217310241864j)*x_ref[2]**o + ((-0.674963756091-0.793417782287j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedFunction_rank3(self):
        """
        tests interpolation of rank 3 Data on ReducedFunction

        assumptions: ReducedFunction(self.domain) exists
                     self.domain supports interpolation from ReducedFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4, 3),w)
        ref = Data(0,(2, 4, 3),w_ref)
        arg[(0, 0, 0)]=(0.192207883479+0.444277569069j)*x[0]**o + ((-0.346803869883+0.949445389544j))*x[0] + ((0.440357634215-0.97627574168j))*x[1]**o + ((0.192926190585+0.919589806506j))*x[1]
        ref[(0, 0, 0)]=(0.192207883479+0.444277569069j)*x_ref[0]**o + ((-0.346803869883+0.949445389544j))*x_ref[0] + ((0.440357634215-0.97627574168j))*x_ref[1]**o + ((0.192926190585+0.919589806506j))*x_ref[1]
        arg[(0, 0, 1)]=(-0.579194718328-0.618730572326j)*x[0]**o + ((0.707598482015+0.192570000375j))*x[0] + ((0.632121145175-0.738536346735j))*x[1]**o + ((0.692596705094-0.266363239293j))*x[1]
        ref[(0, 0, 1)]=(-0.579194718328-0.618730572326j)*x_ref[0]**o + ((0.707598482015+0.192570000375j))*x_ref[0] + ((0.632121145175-0.738536346735j))*x_ref[1]**o + ((0.692596705094-0.266363239293j))*x_ref[1]
        arg[(0, 0, 2)]=(0.726912364289-0.133510442278j)*x[0]**o + ((-0.715181847224+0.0447372620866j))*x[0] + ((0.107275264902+0.627768277256j))*x[1]**o + ((0.0565525231585-0.981852948934j))*x[1]
        ref[(0, 0, 2)]=(0.726912364289-0.133510442278j)*x_ref[0]**o + ((-0.715181847224+0.0447372620866j))*x_ref[0] + ((0.107275264902+0.627768277256j))*x_ref[1]**o + ((0.0565525231585-0.981852948934j))*x_ref[1]
        arg[(0, 1, 0)]=(-0.605939667922+0.916136314735j)*x[0]**o + ((-0.010526162073-0.39855687064j))*x[0] + ((0.67012531904-0.779130844563j))*x[1]**o + ((0.751141102408-0.0190293237935j))*x[1]
        ref[(0, 1, 0)]=(-0.605939667922+0.916136314735j)*x_ref[0]**o + ((-0.010526162073-0.39855687064j))*x_ref[0] + ((0.67012531904-0.779130844563j))*x_ref[1]**o + ((0.751141102408-0.0190293237935j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.799561597845-0.608986979214j)*x[0]**o + ((-0.906304094374+0.742935439872j))*x[0] + ((0.263714774223+0.0977844386533j))*x[1]**o + ((-0.980351537523+0.850823984447j))*x[1]
        ref[(0, 1, 1)]=(-0.799561597845-0.608986979214j)*x_ref[0]**o + ((-0.906304094374+0.742935439872j))*x_ref[0] + ((0.263714774223+0.0977844386533j))*x_ref[1]**o + ((-0.980351537523+0.850823984447j))*x_ref[1]
        arg[(0, 1, 2)]=(-0.040668781815+0.0624817612524j)*x[0]**o + ((0.0184237154992+0.412454616404j))*x[0] + ((0.0605649605352-0.413394698334j))*x[1]**o + ((0.855223162562+0.506034991204j))*x[1]
        ref[(0, 1, 2)]=(-0.040668781815+0.0624817612524j)*x_ref[0]**o + ((0.0184237154992+0.412454616404j))*x_ref[0] + ((0.0605649605352-0.413394698334j))*x_ref[1]**o + ((0.855223162562+0.506034991204j))*x_ref[1]
        arg[(0, 2, 0)]=(-0.459147141222+0.38226792908j)*x[0]**o + ((0.847344852776-0.282609776642j))*x[0] + ((-0.42234031642-0.799095839296j))*x[1]**o + ((-0.823128544163+0.484515516071j))*x[1]
        ref[(0, 2, 0)]=(-0.459147141222+0.38226792908j)*x_ref[0]**o + ((0.847344852776-0.282609776642j))*x_ref[0] + ((-0.42234031642-0.799095839296j))*x_ref[1]**o + ((-0.823128544163+0.484515516071j))*x_ref[1]
        arg[(0, 2, 1)]=(0.432290931401+0.375970524488j)*x[0]**o + ((0.511640111545+0.264728390411j))*x[0] + ((0.466102244601-0.733537991237j))*x[1]**o + ((-0.800484686699-0.107155528332j))*x[1]
        ref[(0, 2, 1)]=(0.432290931401+0.375970524488j)*x_ref[0]**o + ((0.511640111545+0.264728390411j))*x_ref[0] + ((0.466102244601-0.733537991237j))*x_ref[1]**o + ((-0.800484686699-0.107155528332j))*x_ref[1]
        arg[(0, 2, 2)]=(0.958706421521-0.315286874104j)*x[0]**o + ((0.783195885465+0.325482793917j))*x[0] + ((0.255895191349-0.829630454156j))*x[1]**o + ((-0.39250086062-0.568149899334j))*x[1]
        ref[(0, 2, 2)]=(0.958706421521-0.315286874104j)*x_ref[0]**o + ((0.783195885465+0.325482793917j))*x_ref[0] + ((0.255895191349-0.829630454156j))*x_ref[1]**o + ((-0.39250086062-0.568149899334j))*x_ref[1]
        arg[(0, 3, 0)]=(-0.42462010417-0.395632133126j)*x[0]**o + ((0.00970522056718+0.248673152197j))*x[0] + ((0.845114274369-0.903251931248j))*x[1]**o + ((-0.802728632244-0.38996270013j))*x[1]
        ref[(0, 3, 0)]=(-0.42462010417-0.395632133126j)*x_ref[0]**o + ((0.00970522056718+0.248673152197j))*x_ref[0] + ((0.845114274369-0.903251931248j))*x_ref[1]**o + ((-0.802728632244-0.38996270013j))*x_ref[1]
        arg[(0, 3, 1)]=(-0.599097588592+0.043400140804j)*x[0]**o + ((-0.125584514643-0.361768012521j))*x[0] + ((0.744814166206-0.970166035388j))*x[1]**o + ((-0.249615583225-0.249086645961j))*x[1]
        ref[(0, 3, 1)]=(-0.599097588592+0.043400140804j)*x_ref[0]**o + ((-0.125584514643-0.361768012521j))*x_ref[0] + ((0.744814166206-0.970166035388j))*x_ref[1]**o + ((-0.249615583225-0.249086645961j))*x_ref[1]
        arg[(0, 3, 2)]=(-0.394561188715+0.956203562308j)*x[0]**o + ((-0.141500616157+0.425327815169j))*x[0] + ((-0.704416351234+0.654057476774j))*x[1]**o + ((-0.249963684453-0.89241860522j))*x[1]
        ref[(0, 3, 2)]=(-0.394561188715+0.956203562308j)*x_ref[0]**o + ((-0.141500616157+0.425327815169j))*x_ref[0] + ((-0.704416351234+0.654057476774j))*x_ref[1]**o + ((-0.249963684453-0.89241860522j))*x_ref[1]
        arg[(1, 0, 0)]=(0.883938937775-0.173127610716j)*x[0]**o + ((-0.190475771546-0.90213267271j))*x[0] + ((0.342521088808-0.831685672545j))*x[1]**o + ((0.722232260735-0.407354946012j))*x[1]
        ref[(1, 0, 0)]=(0.883938937775-0.173127610716j)*x_ref[0]**o + ((-0.190475771546-0.90213267271j))*x_ref[0] + ((0.342521088808-0.831685672545j))*x_ref[1]**o + ((0.722232260735-0.407354946012j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.262568217133+0.968355986638j)*x[0]**o + ((0.0323670133571+0.271944273375j))*x[0] + ((-0.662848247399+0.670483278897j))*x[1]**o + ((-0.78793002497-0.171536662895j))*x[1]
        ref[(1, 0, 1)]=(-0.262568217133+0.968355986638j)*x_ref[0]**o + ((0.0323670133571+0.271944273375j))*x_ref[0] + ((-0.662848247399+0.670483278897j))*x_ref[1]**o + ((-0.78793002497-0.171536662895j))*x_ref[1]
        arg[(1, 0, 2)]=(0.252361471404-0.456345510378j)*x[0]**o + ((0.682774489813+0.378756233933j))*x[0] + ((0.795424602086-0.500634824167j))*x[1]**o + ((-0.768681257812-0.260210295042j))*x[1]
        ref[(1, 0, 2)]=(0.252361471404-0.456345510378j)*x_ref[0]**o + ((0.682774489813+0.378756233933j))*x_ref[0] + ((0.795424602086-0.500634824167j))*x_ref[1]**o + ((-0.768681257812-0.260210295042j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.772983425758+0.0480711364048j)*x[0]**o + ((-0.86740426485-0.508601191057j))*x[0] + ((-0.568387739181-0.666028009956j))*x[1]**o + ((0.946264412637+0.75103554442j))*x[1]
        ref[(1, 1, 0)]=(-0.772983425758+0.0480711364048j)*x_ref[0]**o + ((-0.86740426485-0.508601191057j))*x_ref[0] + ((-0.568387739181-0.666028009956j))*x_ref[1]**o + ((0.946264412637+0.75103554442j))*x_ref[1]
        arg[(1, 1, 1)]=(0.867142091513+0.398974104139j)*x[0]**o + ((-0.876965934366+0.760622119733j))*x[0] + ((-0.440723964394+0.185665062604j))*x[1]**o + ((0.418739561034-0.0925290957658j))*x[1]
        ref[(1, 1, 1)]=(0.867142091513+0.398974104139j)*x_ref[0]**o + ((-0.876965934366+0.760622119733j))*x_ref[0] + ((-0.440723964394+0.185665062604j))*x_ref[1]**o + ((0.418739561034-0.0925290957658j))*x_ref[1]
        arg[(1, 1, 2)]=(-0.207607630737+0.356760127772j)*x[0]**o + ((0.429625463623+0.883498284218j))*x[0] + ((0.696543721725+0.778266597124j))*x[1]**o + ((0.304978596042+0.021041493304j))*x[1]
        ref[(1, 1, 2)]=(-0.207607630737+0.356760127772j)*x_ref[0]**o + ((0.429625463623+0.883498284218j))*x_ref[0] + ((0.696543721725+0.778266597124j))*x_ref[1]**o + ((0.304978596042+0.021041493304j))*x_ref[1]
        arg[(1, 2, 0)]=(0.847522172703+0.448382939503j)*x[0]**o + ((0.398591239452+0.219424599464j))*x[0] + ((0.174806929385-0.0196088190939j))*x[1]**o + ((0.164224858203-0.721584990314j))*x[1]
        ref[(1, 2, 0)]=(0.847522172703+0.448382939503j)*x_ref[0]**o + ((0.398591239452+0.219424599464j))*x_ref[0] + ((0.174806929385-0.0196088190939j))*x_ref[1]**o + ((0.164224858203-0.721584990314j))*x_ref[1]
        arg[(1, 2, 1)]=(-0.25393899438+0.297084881177j)*x[0]**o + ((0.708595939261+0.73089143175j))*x[0] + ((0.224426348345-0.130703202979j))*x[1]**o + ((-0.998007823098+0.385306912995j))*x[1]
        ref[(1, 2, 1)]=(-0.25393899438+0.297084881177j)*x_ref[0]**o + ((0.708595939261+0.73089143175j))*x_ref[0] + ((0.224426348345-0.130703202979j))*x_ref[1]**o + ((-0.998007823098+0.385306912995j))*x_ref[1]
        arg[(1, 2, 2)]=(-0.169816845707+0.0625567259455j)*x[0]**o + ((0.585786596595-0.407470580339j))*x[0] + ((0.533401356683+0.273046499296j))*x[1]**o + ((-0.0179921510531+0.120761096979j))*x[1]
        ref[(1, 2, 2)]=(-0.169816845707+0.0625567259455j)*x_ref[0]**o + ((0.585786596595-0.407470580339j))*x_ref[0] + ((0.533401356683+0.273046499296j))*x_ref[1]**o + ((-0.0179921510531+0.120761096979j))*x_ref[1]
        arg[(1, 3, 0)]=(0.723542842963+0.349859986591j)*x[0]**o + ((0.279417793438-0.969162332056j))*x[0] + ((-0.590546958026+0.372525086j))*x[1]**o + ((-0.175211545823+0.674041485018j))*x[1]
        ref[(1, 3, 0)]=(0.723542842963+0.349859986591j)*x_ref[0]**o + ((0.279417793438-0.969162332056j))*x_ref[0] + ((-0.590546958026+0.372525086j))*x_ref[1]**o + ((-0.175211545823+0.674041485018j))*x_ref[1]
        arg[(1, 3, 1)]=(-0.724336432051+0.906837638492j)*x[0]**o + ((-0.638921615656+0.11146967229j))*x[0] + ((0.00847551158182-0.871279215367j))*x[1]**o + ((0.0426949520876+0.00977819872344j))*x[1]
        ref[(1, 3, 1)]=(-0.724336432051+0.906837638492j)*x_ref[0]**o + ((-0.638921615656+0.11146967229j))*x_ref[0] + ((0.00847551158182-0.871279215367j))*x_ref[1]**o + ((0.0426949520876+0.00977819872344j))*x_ref[1]
        arg[(1, 3, 2)]=(-0.696544210804+0.725939742156j)*x[0]**o + ((-0.43201308931-0.973699474944j))*x[0] + ((0.474693477857-0.763573218716j))*x[1]**o + ((-0.800318585344-0.775976807731j))*x[1]
        ref[(1, 3, 2)]=(-0.696544210804+0.725939742156j)*x_ref[0]**o + ((-0.43201308931-0.973699474944j))*x_ref[0] + ((0.474693477857-0.763573218716j))*x_ref[1]**o + ((-0.800318585344-0.775976807731j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.483127009699-0.527278358079j)*x[2]**o + ((-0.54713707029+0.573714264362j))*x[2]
            ref[(0, 0, 0)]+=(-0.483127009699-0.527278358079j)*x_ref[2]**o + ((-0.54713707029+0.573714264362j))*x_ref[2]
            arg[(0, 0, 1)]+=(0.239542515828-0.458206378015j)*x[2]**o + ((0.0505770626939+0.609275714255j))*x[2]
            ref[(0, 0, 1)]+=(0.239542515828-0.458206378015j)*x_ref[2]**o + ((0.0505770626939+0.609275714255j))*x_ref[2]
            arg[(0, 0, 2)]+=(0.69023473775-0.209869986124j)*x[2]**o + ((-0.953271437001-0.848472199774j))*x[2]
            ref[(0, 0, 2)]+=(0.69023473775-0.209869986124j)*x_ref[2]**o + ((-0.953271437001-0.848472199774j))*x_ref[2]
            arg[(0, 1, 0)]+=(-0.356191800225+0.271829931988j)*x[2]**o + ((-0.563938273184-0.530587794968j))*x[2]
            ref[(0, 1, 0)]+=(-0.356191800225+0.271829931988j)*x_ref[2]**o + ((-0.563938273184-0.530587794968j))*x_ref[2]
            arg[(0, 1, 1)]+=(0.838310614902+0.0409224153025j)*x[2]**o + ((0.926192480265-0.583494864427j))*x[2]
            ref[(0, 1, 1)]+=(0.838310614902+0.0409224153025j)*x_ref[2]**o + ((0.926192480265-0.583494864427j))*x_ref[2]
            arg[(0, 1, 2)]+=(0.281855582316-0.465564383703j)*x[2]**o + ((-0.210486204792+0.819365674963j))*x[2]
            ref[(0, 1, 2)]+=(0.281855582316-0.465564383703j)*x_ref[2]**o + ((-0.210486204792+0.819365674963j))*x_ref[2]
            arg[(0, 2, 0)]+=(0.250001205067+0.243637152502j)*x[2]**o + ((0.959919865834-0.684198518899j))*x[2]
            ref[(0, 2, 0)]+=(0.250001205067+0.243637152502j)*x_ref[2]**o + ((0.959919865834-0.684198518899j))*x_ref[2]
            arg[(0, 2, 1)]+=(-0.663470221508+0.695986133186j)*x[2]**o + ((-0.133805379013+0.258882594073j))*x[2]
            ref[(0, 2, 1)]+=(-0.663470221508+0.695986133186j)*x_ref[2]**o + ((-0.133805379013+0.258882594073j))*x_ref[2]
            arg[(0, 2, 2)]+=(0.769718191503-0.338310593864j)*x[2]**o + ((0.316688814103-0.7598848433j))*x[2]
            ref[(0, 2, 2)]+=(0.769718191503-0.338310593864j)*x_ref[2]**o + ((0.316688814103-0.7598848433j))*x_ref[2]
            arg[(0, 3, 0)]+=(-0.293229743348-0.534905211994j)*x[2]**o + ((0.11089476592+0.687410078055j))*x[2]
            ref[(0, 3, 0)]+=(-0.293229743348-0.534905211994j)*x_ref[2]**o + ((0.11089476592+0.687410078055j))*x_ref[2]
            arg[(0, 3, 1)]+=(-0.585440599658-0.564292621162j)*x[2]**o + ((-0.175330184579+0.366649193489j))*x[2]
            ref[(0, 3, 1)]+=(-0.585440599658-0.564292621162j)*x_ref[2]**o + ((-0.175330184579+0.366649193489j))*x_ref[2]
            arg[(0, 3, 2)]+=(0.85303116721+0.218640081406j)*x[2]**o + ((-0.842344760974+0.410775576165j))*x[2]
            ref[(0, 3, 2)]+=(0.85303116721+0.218640081406j)*x_ref[2]**o + ((-0.842344760974+0.410775576165j))*x_ref[2]
            arg[(1, 0, 0)]+=(0.533882140998+0.416301751363j)*x[2]**o + ((-0.4834351174+0.164999981349j))*x[2]
            ref[(1, 0, 0)]+=(0.533882140998+0.416301751363j)*x_ref[2]**o + ((-0.4834351174+0.164999981349j))*x_ref[2]
            arg[(1, 0, 1)]+=(0.961743041992+0.243362699002j)*x[2]**o + ((-0.650174126965-0.359380568449j))*x[2]
            ref[(1, 0, 1)]+=(0.961743041992+0.243362699002j)*x_ref[2]**o + ((-0.650174126965-0.359380568449j))*x_ref[2]
            arg[(1, 0, 2)]+=(0.595856442948-0.195468316465j)*x[2]**o + ((0.936502223619-0.876869720381j))*x[2]
            ref[(1, 0, 2)]+=(0.595856442948-0.195468316465j)*x_ref[2]**o + ((0.936502223619-0.876869720381j))*x_ref[2]
            arg[(1, 1, 0)]+=(0.31307717106-0.067298716493j)*x[2]**o + ((0.599634191886-0.143630119761j))*x[2]
            ref[(1, 1, 0)]+=(0.31307717106-0.067298716493j)*x_ref[2]**o + ((0.599634191886-0.143630119761j))*x_ref[2]
            arg[(1, 1, 1)]+=(0.620382785726-0.934327333041j)*x[2]**o + ((-0.0649152357829+0.334613808339j))*x[2]
            ref[(1, 1, 1)]+=(0.620382785726-0.934327333041j)*x_ref[2]**o + ((-0.0649152357829+0.334613808339j))*x_ref[2]
            arg[(1, 1, 2)]+=(0.647489862639+0.444075357926j)*x[2]**o + ((0.159666607699+0.58187236385j))*x[2]
            ref[(1, 1, 2)]+=(0.647489862639+0.444075357926j)*x_ref[2]**o + ((0.159666607699+0.58187236385j))*x_ref[2]
            arg[(1, 2, 0)]+=(0.521005888098+0.868378410567j)*x[2]**o + ((0.22680066413-0.414733639365j))*x[2]
            ref[(1, 2, 0)]+=(0.521005888098+0.868378410567j)*x_ref[2]**o + ((0.22680066413-0.414733639365j))*x_ref[2]
            arg[(1, 2, 1)]+=(0.084128032176+0.436200358081j)*x[2]**o + ((0.0637149717713-0.603917684987j))*x[2]
            ref[(1, 2, 1)]+=(0.084128032176+0.436200358081j)*x_ref[2]**o + ((0.0637149717713-0.603917684987j))*x_ref[2]
            arg[(1, 2, 2)]+=(-0.961355937362-0.763448977571j)*x[2]**o + ((0.123782299848+0.0843756922102j))*x[2]
            ref[(1, 2, 2)]+=(-0.961355937362-0.763448977571j)*x_ref[2]**o + ((0.123782299848+0.0843756922102j))*x_ref[2]
            arg[(1, 3, 0)]+=(0.0260256718717-0.0568542476141j)*x[2]**o + ((0.266642677757+0.76172985523j))*x[2]
            ref[(1, 3, 0)]+=(0.0260256718717-0.0568542476141j)*x_ref[2]**o + ((0.266642677757+0.76172985523j))*x_ref[2]
            arg[(1, 3, 1)]+=(-0.826959483+0.62810383741j)*x[2]**o + ((-0.226015009679-0.125611554069j))*x[2]
            ref[(1, 3, 1)]+=(-0.826959483+0.62810383741j)*x_ref[2]**o + ((-0.226015009679-0.125611554069j))*x_ref[2]
            arg[(1, 3, 2)]+=(-0.3323255712+0.380605080901j)*x[2]**o + ((-0.35022709987+0.0125220239329j))*x[2]
            ref[(1, 3, 2)]+=(-0.3323255712+0.380605080901j)*x_ref[2]**o + ((-0.35022709987+0.0125220239329j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 4, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onReducedFunction_fromData_ReducedFunction_rank4(self):
        """
        tests interpolation of rank 4 Data on ReducedFunction

        assumptions: ReducedFunction(self.domain) exists
                     self.domain supports interpolation from ReducedFunction to ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 4, 3),w)
        ref = Data(0,(4, 4, 4, 3),w_ref)
        arg[(0, 0, 0, 0)]=(0.43465391275+0.983742483132j)*x[0]**o + ((0.273794553189-0.619114440889j))*x[0] + ((-0.813997133562-0.408645297277j))*x[1]**o + ((-0.778279951529-0.649255144171j))*x[1]
        ref[(0, 0, 0, 0)]=(0.43465391275+0.983742483132j)*x_ref[0]**o + ((0.273794553189-0.619114440889j))*x_ref[0] + ((-0.813997133562-0.408645297277j))*x_ref[1]**o + ((-0.778279951529-0.649255144171j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(0.934972712595-0.888898920484j)*x[0]**o + ((-0.0897579693991+0.638920078261j))*x[0] + ((0.534939808979-0.998857746637j))*x[1]**o + ((0.330343901899-0.1799529906j))*x[1]
        ref[(0, 0, 0, 1)]=(0.934972712595-0.888898920484j)*x_ref[0]**o + ((-0.0897579693991+0.638920078261j))*x_ref[0] + ((0.534939808979-0.998857746637j))*x_ref[1]**o + ((0.330343901899-0.1799529906j))*x_ref[1]
        arg[(0, 0, 0, 2)]=(0.387191341697-0.986771748702j)*x[0]**o + ((0.237419512177+0.735836312016j))*x[0] + ((-0.0936412958505+0.788341973012j))*x[1]**o + ((0.676147164977-0.968381180991j))*x[1]
        ref[(0, 0, 0, 2)]=(0.387191341697-0.986771748702j)*x_ref[0]**o + ((0.237419512177+0.735836312016j))*x_ref[0] + ((-0.0936412958505+0.788341973012j))*x_ref[1]**o + ((0.676147164977-0.968381180991j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(0.291699869162+0.839213166507j)*x[0]**o + ((-0.113104752522-0.943859419254j))*x[0] + ((-0.249618737707+0.378239943416j))*x[1]**o + ((0.312953013192+0.276460392263j))*x[1]
        ref[(0, 0, 1, 0)]=(0.291699869162+0.839213166507j)*x_ref[0]**o + ((-0.113104752522-0.943859419254j))*x_ref[0] + ((-0.249618737707+0.378239943416j))*x_ref[1]**o + ((0.312953013192+0.276460392263j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(0.0613746985789+0.844580420267j)*x[0]**o + ((-0.620001187117-0.984614831617j))*x[0] + ((-0.834675145598+0.150856727384j))*x[1]**o + ((-0.764245315875+0.68349607043j))*x[1]
        ref[(0, 0, 1, 1)]=(0.0613746985789+0.844580420267j)*x_ref[0]**o + ((-0.620001187117-0.984614831617j))*x_ref[0] + ((-0.834675145598+0.150856727384j))*x_ref[1]**o + ((-0.764245315875+0.68349607043j))*x_ref[1]
        arg[(0, 0, 1, 2)]=(0.18191359689+0.372537191744j)*x[0]**o + ((0.771863115814-0.160507443956j))*x[0] + ((0.126276291758-0.0474644401311j))*x[1]**o + ((0.0931005129511-0.0629547996277j))*x[1]
        ref[(0, 0, 1, 2)]=(0.18191359689+0.372537191744j)*x_ref[0]**o + ((0.771863115814-0.160507443956j))*x_ref[0] + ((0.126276291758-0.0474644401311j))*x_ref[1]**o + ((0.0931005129511-0.0629547996277j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(-0.871016019504+0.0176185401021j)*x[0]**o + ((0.69320264875+0.0228475225632j))*x[0] + ((-0.233474175575+0.096308496694j))*x[1]**o + ((-0.227657538897+0.994855192042j))*x[1]
        ref[(0, 0, 2, 0)]=(-0.871016019504+0.0176185401021j)*x_ref[0]**o + ((0.69320264875+0.0228475225632j))*x_ref[0] + ((-0.233474175575+0.096308496694j))*x_ref[1]**o + ((-0.227657538897+0.994855192042j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(-0.256070709022+0.03917321248j)*x[0]**o + ((-0.0353279209778-0.251538532915j))*x[0] + ((0.99030244473-0.581332101232j))*x[1]**o + ((-0.554217394763+0.373636121413j))*x[1]
        ref[(0, 0, 2, 1)]=(-0.256070709022+0.03917321248j)*x_ref[0]**o + ((-0.0353279209778-0.251538532915j))*x_ref[0] + ((0.99030244473-0.581332101232j))*x_ref[1]**o + ((-0.554217394763+0.373636121413j))*x_ref[1]
        arg[(0, 0, 2, 2)]=(0.645556409603-0.809363326378j)*x[0]**o + ((0.403138970163-0.682132459883j))*x[0] + ((0.0450949352313-0.697165953754j))*x[1]**o + ((0.519406653357-0.83077285013j))*x[1]
        ref[(0, 0, 2, 2)]=(0.645556409603-0.809363326378j)*x_ref[0]**o + ((0.403138970163-0.682132459883j))*x_ref[0] + ((0.0450949352313-0.697165953754j))*x_ref[1]**o + ((0.519406653357-0.83077285013j))*x_ref[1]
        arg[(0, 0, 3, 0)]=(0.995331853731-0.980888652713j)*x[0]**o + ((-0.7910879854-0.813856128979j))*x[0] + ((0.464696440535+0.827994407565j))*x[1]**o + ((0.519050100718-0.939499211683j))*x[1]
        ref[(0, 0, 3, 0)]=(0.995331853731-0.980888652713j)*x_ref[0]**o + ((-0.7910879854-0.813856128979j))*x_ref[0] + ((0.464696440535+0.827994407565j))*x_ref[1]**o + ((0.519050100718-0.939499211683j))*x_ref[1]
        arg[(0, 0, 3, 1)]=(0.15811490488-0.348493246106j)*x[0]**o + ((-0.268592070881-0.904593503206j))*x[0] + ((-0.776322367441-0.377008909124j))*x[1]**o + ((0.676744015278+0.285531996675j))*x[1]
        ref[(0, 0, 3, 1)]=(0.15811490488-0.348493246106j)*x_ref[0]**o + ((-0.268592070881-0.904593503206j))*x_ref[0] + ((-0.776322367441-0.377008909124j))*x_ref[1]**o + ((0.676744015278+0.285531996675j))*x_ref[1]
        arg[(0, 0, 3, 2)]=(0.856528139159+0.611318788216j)*x[0]**o + ((0.0123188378482-0.688484405623j))*x[0] + ((-0.864464366334-0.916402203326j))*x[1]**o + ((-0.345756548932-0.765197637434j))*x[1]
        ref[(0, 0, 3, 2)]=(0.856528139159+0.611318788216j)*x_ref[0]**o + ((0.0123188378482-0.688484405623j))*x_ref[0] + ((-0.864464366334-0.916402203326j))*x_ref[1]**o + ((-0.345756548932-0.765197637434j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(-0.475402914303-0.145637517991j)*x[0]**o + ((-0.267002785894+0.486544463672j))*x[0] + ((-0.477363542863+0.748736853957j))*x[1]**o + ((0.275973069567+0.945624855669j))*x[1]
        ref[(0, 1, 0, 0)]=(-0.475402914303-0.145637517991j)*x_ref[0]**o + ((-0.267002785894+0.486544463672j))*x_ref[0] + ((-0.477363542863+0.748736853957j))*x_ref[1]**o + ((0.275973069567+0.945624855669j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(0.493582566226+0.592242877142j)*x[0]**o + ((-0.862965235025+0.579528431288j))*x[0] + ((0.0539613471988+0.71061360596j))*x[1]**o + ((-0.0173485100212-0.171020640756j))*x[1]
        ref[(0, 1, 0, 1)]=(0.493582566226+0.592242877142j)*x_ref[0]**o + ((-0.862965235025+0.579528431288j))*x_ref[0] + ((0.0539613471988+0.71061360596j))*x_ref[1]**o + ((-0.0173485100212-0.171020640756j))*x_ref[1]
        arg[(0, 1, 0, 2)]=(0.305816212653+0.665920091929j)*x[0]**o + ((-0.576424059252+0.190346652606j))*x[0] + ((0.666297086141-0.142551780973j))*x[1]**o + ((-0.762908542283-0.381039762848j))*x[1]
        ref[(0, 1, 0, 2)]=(0.305816212653+0.665920091929j)*x_ref[0]**o + ((-0.576424059252+0.190346652606j))*x_ref[0] + ((0.666297086141-0.142551780973j))*x_ref[1]**o + ((-0.762908542283-0.381039762848j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.131721597261+0.0696817183982j)*x[0]**o + ((-0.84833753749+0.126630992473j))*x[0] + ((-0.373986452326-0.955728729467j))*x[1]**o + ((-0.166145050446-0.699772414466j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.131721597261+0.0696817183982j)*x_ref[0]**o + ((-0.84833753749+0.126630992473j))*x_ref[0] + ((-0.373986452326-0.955728729467j))*x_ref[1]**o + ((-0.166145050446-0.699772414466j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(0.343150589227+0.876650383465j)*x[0]**o + ((-0.703444318786-0.093253487365j))*x[0] + ((0.731039449596+0.367312356797j))*x[1]**o + ((0.356272970632+0.998388421934j))*x[1]
        ref[(0, 1, 1, 1)]=(0.343150589227+0.876650383465j)*x_ref[0]**o + ((-0.703444318786-0.093253487365j))*x_ref[0] + ((0.731039449596+0.367312356797j))*x_ref[1]**o + ((0.356272970632+0.998388421934j))*x_ref[1]
        arg[(0, 1, 1, 2)]=(-0.45219525791+0.20342159498j)*x[0]**o + ((0.543539297853-0.864044965259j))*x[0] + ((0.795465939617-0.177456266103j))*x[1]**o + ((0.230098843695-0.552170481044j))*x[1]
        ref[(0, 1, 1, 2)]=(-0.45219525791+0.20342159498j)*x_ref[0]**o + ((0.543539297853-0.864044965259j))*x_ref[0] + ((0.795465939617-0.177456266103j))*x_ref[1]**o + ((0.230098843695-0.552170481044j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(0.0742334001083-0.0430141065569j)*x[0]**o + ((-0.363445592239+0.377138175834j))*x[0] + ((-0.667906192821-0.823966771519j))*x[1]**o + ((-0.619085216266+0.636900738205j))*x[1]
        ref[(0, 1, 2, 0)]=(0.0742334001083-0.0430141065569j)*x_ref[0]**o + ((-0.363445592239+0.377138175834j))*x_ref[0] + ((-0.667906192821-0.823966771519j))*x_ref[1]**o + ((-0.619085216266+0.636900738205j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(-0.60702274405+0.674673263278j)*x[0]**o + ((-0.347398750818+0.0484166099494j))*x[0] + ((-0.399728893299+0.610287598723j))*x[1]**o + ((0.972187347309-0.0881955260301j))*x[1]
        ref[(0, 1, 2, 1)]=(-0.60702274405+0.674673263278j)*x_ref[0]**o + ((-0.347398750818+0.0484166099494j))*x_ref[0] + ((-0.399728893299+0.610287598723j))*x_ref[1]**o + ((0.972187347309-0.0881955260301j))*x_ref[1]
        arg[(0, 1, 2, 2)]=(0.654021567992-0.59429936938j)*x[0]**o + ((-0.37093775144-0.88219856455j))*x[0] + ((0.822823846672-0.0915745034228j))*x[1]**o + ((0.602161760727+0.366699361807j))*x[1]
        ref[(0, 1, 2, 2)]=(0.654021567992-0.59429936938j)*x_ref[0]**o + ((-0.37093775144-0.88219856455j))*x_ref[0] + ((0.822823846672-0.0915745034228j))*x_ref[1]**o + ((0.602161760727+0.366699361807j))*x_ref[1]
        arg[(0, 1, 3, 0)]=(0.566746554539+0.235820693459j)*x[0]**o + ((0.65185422085+0.0102735416633j))*x[0] + ((-0.182428240433-0.551397972913j))*x[1]**o + ((0.294979827195-0.844983506441j))*x[1]
        ref[(0, 1, 3, 0)]=(0.566746554539+0.235820693459j)*x_ref[0]**o + ((0.65185422085+0.0102735416633j))*x_ref[0] + ((-0.182428240433-0.551397972913j))*x_ref[1]**o + ((0.294979827195-0.844983506441j))*x_ref[1]
        arg[(0, 1, 3, 1)]=(-0.547087353537+0.900089634532j)*x[0]**o + ((0.353502888848-0.296204042138j))*x[0] + ((0.139674350062+0.29515659568j))*x[1]**o + ((-0.243913738606+0.646458817887j))*x[1]
        ref[(0, 1, 3, 1)]=(-0.547087353537+0.900089634532j)*x_ref[0]**o + ((0.353502888848-0.296204042138j))*x_ref[0] + ((0.139674350062+0.29515659568j))*x_ref[1]**o + ((-0.243913738606+0.646458817887j))*x_ref[1]
        arg[(0, 1, 3, 2)]=(-0.465239543759-0.170545389277j)*x[0]**o + ((-0.317557434519-0.638226758156j))*x[0] + ((-0.281846184634+0.136383667679j))*x[1]**o + ((-0.0999920162444+0.727657898328j))*x[1]
        ref[(0, 1, 3, 2)]=(-0.465239543759-0.170545389277j)*x_ref[0]**o + ((-0.317557434519-0.638226758156j))*x_ref[0] + ((-0.281846184634+0.136383667679j))*x_ref[1]**o + ((-0.0999920162444+0.727657898328j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(-0.647184191167-0.0287159904208j)*x[0]**o + ((-0.922054433049-0.0613469208742j))*x[0] + ((0.218465293174+0.386822468642j))*x[1]**o + ((0.448824290626-0.912039055037j))*x[1]
        ref[(0, 2, 0, 0)]=(-0.647184191167-0.0287159904208j)*x_ref[0]**o + ((-0.922054433049-0.0613469208742j))*x_ref[0] + ((0.218465293174+0.386822468642j))*x_ref[1]**o + ((0.448824290626-0.912039055037j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(0.270396670431-0.391361329295j)*x[0]**o + ((-0.96242738243-0.619844582639j))*x[0] + ((-0.537452560633-0.0455632796212j))*x[1]**o + ((0.0616393490316+0.830394255799j))*x[1]
        ref[(0, 2, 0, 1)]=(0.270396670431-0.391361329295j)*x_ref[0]**o + ((-0.96242738243-0.619844582639j))*x_ref[0] + ((-0.537452560633-0.0455632796212j))*x_ref[1]**o + ((0.0616393490316+0.830394255799j))*x_ref[1]
        arg[(0, 2, 0, 2)]=(-0.470426435601-0.591454299633j)*x[0]**o + ((0.0875242132041-0.262172137737j))*x[0] + ((0.725321071149+0.320556332487j))*x[1]**o + ((-0.0750398966355-0.567524443587j))*x[1]
        ref[(0, 2, 0, 2)]=(-0.470426435601-0.591454299633j)*x_ref[0]**o + ((0.0875242132041-0.262172137737j))*x_ref[0] + ((0.725321071149+0.320556332487j))*x_ref[1]**o + ((-0.0750398966355-0.567524443587j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(-0.0677544281211-0.964022843596j)*x[0]**o + ((-0.497169598015+0.665777486527j))*x[0] + ((0.58920080322+0.931526604582j))*x[1]**o + ((-0.197502607223+0.11677582448j))*x[1]
        ref[(0, 2, 1, 0)]=(-0.0677544281211-0.964022843596j)*x_ref[0]**o + ((-0.497169598015+0.665777486527j))*x_ref[0] + ((0.58920080322+0.931526604582j))*x_ref[1]**o + ((-0.197502607223+0.11677582448j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(-0.68533264779-0.654874580102j)*x[0]**o + ((-0.136973220585-0.188374154761j))*x[0] + ((-0.307109622185+0.677759259537j))*x[1]**o + ((0.00353622772658+0.805532465942j))*x[1]
        ref[(0, 2, 1, 1)]=(-0.68533264779-0.654874580102j)*x_ref[0]**o + ((-0.136973220585-0.188374154761j))*x_ref[0] + ((-0.307109622185+0.677759259537j))*x_ref[1]**o + ((0.00353622772658+0.805532465942j))*x_ref[1]
        arg[(0, 2, 1, 2)]=(0.253118620845+0.115136897875j)*x[0]**o + ((0.17944558458+0.211149972594j))*x[0] + ((-0.709051162162-0.330940280398j))*x[1]**o + ((-0.0273215150566-0.97876003102j))*x[1]
        ref[(0, 2, 1, 2)]=(0.253118620845+0.115136897875j)*x_ref[0]**o + ((0.17944558458+0.211149972594j))*x_ref[0] + ((-0.709051162162-0.330940280398j))*x_ref[1]**o + ((-0.0273215150566-0.97876003102j))*x_ref[1]
        arg[(0, 2, 2, 0)]=(-0.790699874121-0.941091988658j)*x[0]**o + ((0.635204683485+0.365935589932j))*x[0] + ((0.0851489688401-0.460998604067j))*x[1]**o + ((-0.427482436305+0.897982559265j))*x[1]
        ref[(0, 2, 2, 0)]=(-0.790699874121-0.941091988658j)*x_ref[0]**o + ((0.635204683485+0.365935589932j))*x_ref[0] + ((0.0851489688401-0.460998604067j))*x_ref[1]**o + ((-0.427482436305+0.897982559265j))*x_ref[1]
        arg[(0, 2, 2, 1)]=(0.516612015186-0.986036863636j)*x[0]**o + ((-0.472955090809-0.555951175394j))*x[0] + ((-0.185629654808+0.733023085419j))*x[1]**o + ((-0.381095093494+0.588531553541j))*x[1]
        ref[(0, 2, 2, 1)]=(0.516612015186-0.986036863636j)*x_ref[0]**o + ((-0.472955090809-0.555951175394j))*x_ref[0] + ((-0.185629654808+0.733023085419j))*x_ref[1]**o + ((-0.381095093494+0.588531553541j))*x_ref[1]
        arg[(0, 2, 2, 2)]=(0.640693535148-0.879001876375j)*x[0]**o + ((0.820559554537+0.892465122465j))*x[0] + ((-0.110715613222-0.435029741026j))*x[1]**o + ((0.319212525544-0.113867425424j))*x[1]
        ref[(0, 2, 2, 2)]=(0.640693535148-0.879001876375j)*x_ref[0]**o + ((0.820559554537+0.892465122465j))*x_ref[0] + ((-0.110715613222-0.435029741026j))*x_ref[1]**o + ((0.319212525544-0.113867425424j))*x_ref[1]
        arg[(0, 2, 3, 0)]=(-0.579604538559+0.936361449491j)*x[0]**o + ((-0.109722318476+0.959636960919j))*x[0] + ((0.156999955446-0.447309173741j))*x[1]**o + ((-0.58480395158+0.444310660831j))*x[1]
        ref[(0, 2, 3, 0)]=(-0.579604538559+0.936361449491j)*x_ref[0]**o + ((-0.109722318476+0.959636960919j))*x_ref[0] + ((0.156999955446-0.447309173741j))*x_ref[1]**o + ((-0.58480395158+0.444310660831j))*x_ref[1]
        arg[(0, 2, 3, 1)]=(0.432864738924-0.335831655379j)*x[0]**o + ((-0.279216670046+0.576804714337j))*x[0] + ((0.31037571952-0.555053922406j))*x[1]**o + ((-0.177456716214+0.560938516825j))*x[1]
        ref[(0, 2, 3, 1)]=(0.432864738924-0.335831655379j)*x_ref[0]**o + ((-0.279216670046+0.576804714337j))*x_ref[0] + ((0.31037571952-0.555053922406j))*x_ref[1]**o + ((-0.177456716214+0.560938516825j))*x_ref[1]
        arg[(0, 2, 3, 2)]=(-0.443418503388+0.378462995548j)*x[0]**o + ((0.641674936037-0.536108921935j))*x[0] + ((0.555563177608-0.544957331024j))*x[1]**o + ((0.42550982012+0.344265196819j))*x[1]
        ref[(0, 2, 3, 2)]=(-0.443418503388+0.378462995548j)*x_ref[0]**o + ((0.641674936037-0.536108921935j))*x_ref[0] + ((0.555563177608-0.544957331024j))*x_ref[1]**o + ((0.42550982012+0.344265196819j))*x_ref[1]
        arg[(0, 3, 0, 0)]=(0.0275214656406-0.194492863148j)*x[0]**o + ((-0.542529016697+0.628812168446j))*x[0] + ((0.242084307955+0.325320241066j))*x[1]**o + ((-0.00448725478467-0.152248968547j))*x[1]
        ref[(0, 3, 0, 0)]=(0.0275214656406-0.194492863148j)*x_ref[0]**o + ((-0.542529016697+0.628812168446j))*x_ref[0] + ((0.242084307955+0.325320241066j))*x_ref[1]**o + ((-0.00448725478467-0.152248968547j))*x_ref[1]
        arg[(0, 3, 0, 1)]=(-0.474317448783+0.928174831001j)*x[0]**o + ((-0.685045142674+0.853357397305j))*x[0] + ((0.587564484107+0.502580970235j))*x[1]**o + ((-0.0183034640522+0.788212225896j))*x[1]
        ref[(0, 3, 0, 1)]=(-0.474317448783+0.928174831001j)*x_ref[0]**o + ((-0.685045142674+0.853357397305j))*x_ref[0] + ((0.587564484107+0.502580970235j))*x_ref[1]**o + ((-0.0183034640522+0.788212225896j))*x_ref[1]
        arg[(0, 3, 0, 2)]=(0.376354621532+0.0719825559729j)*x[0]**o + ((-0.450758522635+0.735609486129j))*x[0] + ((0.144308928599+0.929232783483j))*x[1]**o + ((0.780398703852+0.0084250055326j))*x[1]
        ref[(0, 3, 0, 2)]=(0.376354621532+0.0719825559729j)*x_ref[0]**o + ((-0.450758522635+0.735609486129j))*x_ref[0] + ((0.144308928599+0.929232783483j))*x_ref[1]**o + ((0.780398703852+0.0084250055326j))*x_ref[1]
        arg[(0, 3, 1, 0)]=(0.265684145367+0.604080059482j)*x[0]**o + ((-0.820413245061+0.0616437251241j))*x[0] + ((0.104651490742+0.0111457963155j))*x[1]**o + ((0.268179033756-0.423418417065j))*x[1]
        ref[(0, 3, 1, 0)]=(0.265684145367+0.604080059482j)*x_ref[0]**o + ((-0.820413245061+0.0616437251241j))*x_ref[0] + ((0.104651490742+0.0111457963155j))*x_ref[1]**o + ((0.268179033756-0.423418417065j))*x_ref[1]
        arg[(0, 3, 1, 1)]=(-0.344512422319+0.572125926781j)*x[0]**o + ((-0.516587704202+0.362562049498j))*x[0] + ((-0.541172247771-0.596938698074j))*x[1]**o + ((-0.864097312204+0.924153264565j))*x[1]
        ref[(0, 3, 1, 1)]=(-0.344512422319+0.572125926781j)*x_ref[0]**o + ((-0.516587704202+0.362562049498j))*x_ref[0] + ((-0.541172247771-0.596938698074j))*x_ref[1]**o + ((-0.864097312204+0.924153264565j))*x_ref[1]
        arg[(0, 3, 1, 2)]=(0.191660489129-0.632172817138j)*x[0]**o + ((-0.356985814892+0.517331449031j))*x[0] + ((-0.459597867245-0.914109197181j))*x[1]**o + ((0.611831338294+0.363487726237j))*x[1]
        ref[(0, 3, 1, 2)]=(0.191660489129-0.632172817138j)*x_ref[0]**o + ((-0.356985814892+0.517331449031j))*x_ref[0] + ((-0.459597867245-0.914109197181j))*x_ref[1]**o + ((0.611831338294+0.363487726237j))*x_ref[1]
        arg[(0, 3, 2, 0)]=(0.880874363325-0.438838152036j)*x[0]**o + ((-0.16960219645-0.77048694254j))*x[0] + ((-0.445092353874+0.664051250905j))*x[1]**o + ((-0.630296654685-0.0537556317347j))*x[1]
        ref[(0, 3, 2, 0)]=(0.880874363325-0.438838152036j)*x_ref[0]**o + ((-0.16960219645-0.77048694254j))*x_ref[0] + ((-0.445092353874+0.664051250905j))*x_ref[1]**o + ((-0.630296654685-0.0537556317347j))*x_ref[1]
        arg[(0, 3, 2, 1)]=(-0.740122764589+0.196134280911j)*x[0]**o + ((0.618655035308-0.762591432001j))*x[0] + ((-0.943172439835+0.826650643527j))*x[1]**o + ((0.813577296263-0.110954835266j))*x[1]
        ref[(0, 3, 2, 1)]=(-0.740122764589+0.196134280911j)*x_ref[0]**o + ((0.618655035308-0.762591432001j))*x_ref[0] + ((-0.943172439835+0.826650643527j))*x_ref[1]**o + ((0.813577296263-0.110954835266j))*x_ref[1]
        arg[(0, 3, 2, 2)]=(0.105274271573+0.765804360039j)*x[0]**o + ((0.343483874863+0.390790537898j))*x[0] + ((0.49411412425+0.936604247336j))*x[1]**o + ((0.993344680134-0.804156478088j))*x[1]
        ref[(0, 3, 2, 2)]=(0.105274271573+0.765804360039j)*x_ref[0]**o + ((0.343483874863+0.390790537898j))*x_ref[0] + ((0.49411412425+0.936604247336j))*x_ref[1]**o + ((0.993344680134-0.804156478088j))*x_ref[1]
        arg[(0, 3, 3, 0)]=(-0.279053878827+0.382775327372j)*x[0]**o + ((-0.219586526736-0.124088387367j))*x[0] + ((-0.20291414951+0.631641810653j))*x[1]**o + ((0.0630478172149+0.923311665567j))*x[1]
        ref[(0, 3, 3, 0)]=(-0.279053878827+0.382775327372j)*x_ref[0]**o + ((-0.219586526736-0.124088387367j))*x_ref[0] + ((-0.20291414951+0.631641810653j))*x_ref[1]**o + ((0.0630478172149+0.923311665567j))*x_ref[1]
        arg[(0, 3, 3, 1)]=(0.490278932561-0.0404821142323j)*x[0]**o + ((0.815915071007-0.487188654511j))*x[0] + ((-0.399497475495+0.601984449412j))*x[1]**o + ((-0.868576291018+0.441560196452j))*x[1]
        ref[(0, 3, 3, 1)]=(0.490278932561-0.0404821142323j)*x_ref[0]**o + ((0.815915071007-0.487188654511j))*x_ref[0] + ((-0.399497475495+0.601984449412j))*x_ref[1]**o + ((-0.868576291018+0.441560196452j))*x_ref[1]
        arg[(0, 3, 3, 2)]=(0.0257370479029-0.447352280402j)*x[0]**o + ((-0.231332600385-0.930795822447j))*x[0] + ((-0.468581730788+0.215252637795j))*x[1]**o + ((-0.352632618219+0.974486314621j))*x[1]
        ref[(0, 3, 3, 2)]=(0.0257370479029-0.447352280402j)*x_ref[0]**o + ((-0.231332600385-0.930795822447j))*x_ref[0] + ((-0.468581730788+0.215252637795j))*x_ref[1]**o + ((-0.352632618219+0.974486314621j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(-0.246068150219+0.384911314052j)*x[0]**o + ((0.718707569584+0.551839344178j))*x[0] + ((0.978749834713+0.162474517131j))*x[1]**o + ((-0.0162970603532-0.579400443449j))*x[1]
        ref[(1, 0, 0, 0)]=(-0.246068150219+0.384911314052j)*x_ref[0]**o + ((0.718707569584+0.551839344178j))*x_ref[0] + ((0.978749834713+0.162474517131j))*x_ref[1]**o + ((-0.0162970603532-0.579400443449j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(-0.949338380698+0.357262114227j)*x[0]**o + ((0.722937650386-0.520821730139j))*x[0] + ((-0.326637187199-0.948343863579j))*x[1]**o + ((0.518986481186+0.556856781809j))*x[1]
        ref[(1, 0, 0, 1)]=(-0.949338380698+0.357262114227j)*x_ref[0]**o + ((0.722937650386-0.520821730139j))*x_ref[0] + ((-0.326637187199-0.948343863579j))*x_ref[1]**o + ((0.518986481186+0.556856781809j))*x_ref[1]
        arg[(1, 0, 0, 2)]=(0.374345081882+0.663469456913j)*x[0]**o + ((-0.367121902301+0.752263568876j))*x[0] + ((-0.514405481033+0.508264915653j))*x[1]**o + ((0.359023739535-0.362591151674j))*x[1]
        ref[(1, 0, 0, 2)]=(0.374345081882+0.663469456913j)*x_ref[0]**o + ((-0.367121902301+0.752263568876j))*x_ref[0] + ((-0.514405481033+0.508264915653j))*x_ref[1]**o + ((0.359023739535-0.362591151674j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.558865958216-0.329857594664j)*x[0]**o + ((0.900956386609+0.887957504594j))*x[0] + ((0.772275166309-0.0848877930913j))*x[1]**o + ((-0.247360239804+0.210223104195j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.558865958216-0.329857594664j)*x_ref[0]**o + ((0.900956386609+0.887957504594j))*x_ref[0] + ((0.772275166309-0.0848877930913j))*x_ref[1]**o + ((-0.247360239804+0.210223104195j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(-0.696516444045-0.398824863236j)*x[0]**o + ((0.161235411346-0.904296164145j))*x[0] + ((0.71320599321+0.905782575586j))*x[1]**o + ((-0.272855858141+0.695763641455j))*x[1]
        ref[(1, 0, 1, 1)]=(-0.696516444045-0.398824863236j)*x_ref[0]**o + ((0.161235411346-0.904296164145j))*x_ref[0] + ((0.71320599321+0.905782575586j))*x_ref[1]**o + ((-0.272855858141+0.695763641455j))*x_ref[1]
        arg[(1, 0, 1, 2)]=(0.200141620561-0.10592979308j)*x[0]**o + ((-0.985485577537+0.250065190853j))*x[0] + ((0.219568703135-0.218943089962j))*x[1]**o + ((-0.111989897111-0.948451023185j))*x[1]
        ref[(1, 0, 1, 2)]=(0.200141620561-0.10592979308j)*x_ref[0]**o + ((-0.985485577537+0.250065190853j))*x_ref[0] + ((0.219568703135-0.218943089962j))*x_ref[1]**o + ((-0.111989897111-0.948451023185j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(0.352564576071-0.206819504487j)*x[0]**o + ((0.41579213493-0.75532448407j))*x[0] + ((0.419503215951-0.581957776164j))*x[1]**o + ((-0.460320057142+0.313925071494j))*x[1]
        ref[(1, 0, 2, 0)]=(0.352564576071-0.206819504487j)*x_ref[0]**o + ((0.41579213493-0.75532448407j))*x_ref[0] + ((0.419503215951-0.581957776164j))*x_ref[1]**o + ((-0.460320057142+0.313925071494j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(0.768490119896-0.261892368739j)*x[0]**o + ((0.462690186127-0.300152056244j))*x[0] + ((-0.096729040885-0.452203209454j))*x[1]**o + ((-0.110168408225+0.903426891027j))*x[1]
        ref[(1, 0, 2, 1)]=(0.768490119896-0.261892368739j)*x_ref[0]**o + ((0.462690186127-0.300152056244j))*x_ref[0] + ((-0.096729040885-0.452203209454j))*x_ref[1]**o + ((-0.110168408225+0.903426891027j))*x_ref[1]
        arg[(1, 0, 2, 2)]=(-0.635881553631+0.175428092853j)*x[0]**o + ((-0.380876979071-0.54287013432j))*x[0] + ((-0.573462824151+0.4706236907j))*x[1]**o + ((-0.339866135673-0.123261171076j))*x[1]
        ref[(1, 0, 2, 2)]=(-0.635881553631+0.175428092853j)*x_ref[0]**o + ((-0.380876979071-0.54287013432j))*x_ref[0] + ((-0.573462824151+0.4706236907j))*x_ref[1]**o + ((-0.339866135673-0.123261171076j))*x_ref[1]
        arg[(1, 0, 3, 0)]=(-0.845076747849+0.902410689411j)*x[0]**o + ((0.191897033262-0.298694537051j))*x[0] + ((-0.318618762818-0.973767981166j))*x[1]**o + ((-0.464629090777-0.619275343404j))*x[1]
        ref[(1, 0, 3, 0)]=(-0.845076747849+0.902410689411j)*x_ref[0]**o + ((0.191897033262-0.298694537051j))*x_ref[0] + ((-0.318618762818-0.973767981166j))*x_ref[1]**o + ((-0.464629090777-0.619275343404j))*x_ref[1]
        arg[(1, 0, 3, 1)]=(-0.380118358411+0.40471785283j)*x[0]**o + ((0.430101314905-0.345587303383j))*x[0] + ((-0.735737642239+0.854914193828j))*x[1]**o + ((-0.523953629472+0.20060588858j))*x[1]
        ref[(1, 0, 3, 1)]=(-0.380118358411+0.40471785283j)*x_ref[0]**o + ((0.430101314905-0.345587303383j))*x_ref[0] + ((-0.735737642239+0.854914193828j))*x_ref[1]**o + ((-0.523953629472+0.20060588858j))*x_ref[1]
        arg[(1, 0, 3, 2)]=(-0.0768219768181+0.842660700972j)*x[0]**o + ((0.486781854825+0.9699401333j))*x[0] + ((0.464989837155-0.0413989899967j))*x[1]**o + ((0.236080893173+0.330997910728j))*x[1]
        ref[(1, 0, 3, 2)]=(-0.0768219768181+0.842660700972j)*x_ref[0]**o + ((0.486781854825+0.9699401333j))*x_ref[0] + ((0.464989837155-0.0413989899967j))*x_ref[1]**o + ((0.236080893173+0.330997910728j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(-0.102666902861-0.982390295724j)*x[0]**o + ((-0.495370820854+0.90571044337j))*x[0] + ((-0.728996623637+0.474070043217j))*x[1]**o + ((-0.686263663966-0.696385108017j))*x[1]
        ref[(1, 1, 0, 0)]=(-0.102666902861-0.982390295724j)*x_ref[0]**o + ((-0.495370820854+0.90571044337j))*x_ref[0] + ((-0.728996623637+0.474070043217j))*x_ref[1]**o + ((-0.686263663966-0.696385108017j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(0.268136367576+0.943219257018j)*x[0]**o + ((0.910807705294+0.990415542978j))*x[0] + ((-0.549517974491+0.084232478061j))*x[1]**o + ((0.671093462662+0.381380460695j))*x[1]
        ref[(1, 1, 0, 1)]=(0.268136367576+0.943219257018j)*x_ref[0]**o + ((0.910807705294+0.990415542978j))*x_ref[0] + ((-0.549517974491+0.084232478061j))*x_ref[1]**o + ((0.671093462662+0.381380460695j))*x_ref[1]
        arg[(1, 1, 0, 2)]=(-0.0228956328575+0.757516478233j)*x[0]**o + ((0.132169291728+0.108141195466j))*x[0] + ((-0.148051149936+0.417128536427j))*x[1]**o + ((-0.406727349327+0.898806314059j))*x[1]
        ref[(1, 1, 0, 2)]=(-0.0228956328575+0.757516478233j)*x_ref[0]**o + ((0.132169291728+0.108141195466j))*x_ref[0] + ((-0.148051149936+0.417128536427j))*x_ref[1]**o + ((-0.406727349327+0.898806314059j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(-0.978683372551-0.00709096339911j)*x[0]**o + ((0.914329248435+0.948747956318j))*x[0] + ((0.91228114846-0.437967583988j))*x[1]**o + ((-0.576629837922+0.904162218139j))*x[1]
        ref[(1, 1, 1, 0)]=(-0.978683372551-0.00709096339911j)*x_ref[0]**o + ((0.914329248435+0.948747956318j))*x_ref[0] + ((0.91228114846-0.437967583988j))*x_ref[1]**o + ((-0.576629837922+0.904162218139j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.716448412567-0.309236177685j)*x[0]**o + ((-0.628936159619+0.501768281472j))*x[0] + ((0.661667776885-0.8537801951j))*x[1]**o + ((-0.580286967414-0.670569604138j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.716448412567-0.309236177685j)*x_ref[0]**o + ((-0.628936159619+0.501768281472j))*x_ref[0] + ((0.661667776885-0.8537801951j))*x_ref[1]**o + ((-0.580286967414-0.670569604138j))*x_ref[1]
        arg[(1, 1, 1, 2)]=(0.718805536208-0.0181305814978j)*x[0]**o + ((-0.648104027079-0.953109800266j))*x[0] + ((0.371197486781-0.958443433837j))*x[1]**o + ((0.401757774089-0.038369215353j))*x[1]
        ref[(1, 1, 1, 2)]=(0.718805536208-0.0181305814978j)*x_ref[0]**o + ((-0.648104027079-0.953109800266j))*x_ref[0] + ((0.371197486781-0.958443433837j))*x_ref[1]**o + ((0.401757774089-0.038369215353j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(-0.127716747515+0.456101514214j)*x[0]**o + ((-0.190409038584-0.8368844837j))*x[0] + ((-0.946549532972+0.913465694902j))*x[1]**o + ((0.91554259088+0.365408834273j))*x[1]
        ref[(1, 1, 2, 0)]=(-0.127716747515+0.456101514214j)*x_ref[0]**o + ((-0.190409038584-0.8368844837j))*x_ref[0] + ((-0.946549532972+0.913465694902j))*x_ref[1]**o + ((0.91554259088+0.365408834273j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(-0.524659034817+0.370557227345j)*x[0]**o + ((0.292448000946-0.44437784173j))*x[0] + ((-0.1100403797-0.735222401083j))*x[1]**o + ((-0.875858614953+0.788324487438j))*x[1]
        ref[(1, 1, 2, 1)]=(-0.524659034817+0.370557227345j)*x_ref[0]**o + ((0.292448000946-0.44437784173j))*x_ref[0] + ((-0.1100403797-0.735222401083j))*x_ref[1]**o + ((-0.875858614953+0.788324487438j))*x_ref[1]
        arg[(1, 1, 2, 2)]=(0.955617876681+0.982158625456j)*x[0]**o + ((-0.127995776692-0.03382792832j))*x[0] + ((0.363193182631+0.0808315730093j))*x[1]**o + ((0.507870659112+0.53181997967j))*x[1]
        ref[(1, 1, 2, 2)]=(0.955617876681+0.982158625456j)*x_ref[0]**o + ((-0.127995776692-0.03382792832j))*x_ref[0] + ((0.363193182631+0.0808315730093j))*x_ref[1]**o + ((0.507870659112+0.53181997967j))*x_ref[1]
        arg[(1, 1, 3, 0)]=(-0.613486472515-0.521361286172j)*x[0]**o + ((-0.576367214519-0.0188769014266j))*x[0] + ((-0.402484305563+0.817585662689j))*x[1]**o + ((0.075453027846+0.94138444315j))*x[1]
        ref[(1, 1, 3, 0)]=(-0.613486472515-0.521361286172j)*x_ref[0]**o + ((-0.576367214519-0.0188769014266j))*x_ref[0] + ((-0.402484305563+0.817585662689j))*x_ref[1]**o + ((0.075453027846+0.94138444315j))*x_ref[1]
        arg[(1, 1, 3, 1)]=(0.0415818390118+0.115763255809j)*x[0]**o + ((0.29194748271-0.611739052134j))*x[0] + ((0.624872695544-0.925947456163j))*x[1]**o + ((0.0767546024374-0.622104630592j))*x[1]
        ref[(1, 1, 3, 1)]=(0.0415818390118+0.115763255809j)*x_ref[0]**o + ((0.29194748271-0.611739052134j))*x_ref[0] + ((0.624872695544-0.925947456163j))*x_ref[1]**o + ((0.0767546024374-0.622104630592j))*x_ref[1]
        arg[(1, 1, 3, 2)]=(0.558132636535-0.4839276621j)*x[0]**o + ((-0.769278615762+0.324005875691j))*x[0] + ((-0.39706230076-0.533491997774j))*x[1]**o + ((-0.721836784336-0.520319332198j))*x[1]
        ref[(1, 1, 3, 2)]=(0.558132636535-0.4839276621j)*x_ref[0]**o + ((-0.769278615762+0.324005875691j))*x_ref[0] + ((-0.39706230076-0.533491997774j))*x_ref[1]**o + ((-0.721836784336-0.520319332198j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(-0.940621349738+0.626420071789j)*x[0]**o + ((0.0462383416947-0.225217291014j))*x[0] + ((0.00945661489073+0.640247244634j))*x[1]**o + ((0.475108483747+0.715829911556j))*x[1]
        ref[(1, 2, 0, 0)]=(-0.940621349738+0.626420071789j)*x_ref[0]**o + ((0.0462383416947-0.225217291014j))*x_ref[0] + ((0.00945661489073+0.640247244634j))*x_ref[1]**o + ((0.475108483747+0.715829911556j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(0.0142366741261-0.66846623248j)*x[0]**o + ((0.497204609301-0.654087413411j))*x[0] + ((-0.363761438568+0.278167779569j))*x[1]**o + ((-0.438964865863-0.487113162704j))*x[1]
        ref[(1, 2, 0, 1)]=(0.0142366741261-0.66846623248j)*x_ref[0]**o + ((0.497204609301-0.654087413411j))*x_ref[0] + ((-0.363761438568+0.278167779569j))*x_ref[1]**o + ((-0.438964865863-0.487113162704j))*x_ref[1]
        arg[(1, 2, 0, 2)]=(0.987012326588+0.429874009239j)*x[0]**o + ((0.0551589198002+0.869559125087j))*x[0] + ((-0.275996286023+0.604792804338j))*x[1]**o + ((-0.690283747714-0.495629324908j))*x[1]
        ref[(1, 2, 0, 2)]=(0.987012326588+0.429874009239j)*x_ref[0]**o + ((0.0551589198002+0.869559125087j))*x_ref[0] + ((-0.275996286023+0.604792804338j))*x_ref[1]**o + ((-0.690283747714-0.495629324908j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(0.0336081599906-0.703467809667j)*x[0]**o + ((0.666143619212+0.582804555374j))*x[0] + ((0.427636268179+0.818932898913j))*x[1]**o + ((-0.692059114472+0.196121404035j))*x[1]
        ref[(1, 2, 1, 0)]=(0.0336081599906-0.703467809667j)*x_ref[0]**o + ((0.666143619212+0.582804555374j))*x_ref[0] + ((0.427636268179+0.818932898913j))*x_ref[1]**o + ((-0.692059114472+0.196121404035j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(0.316013363697+0.460862186184j)*x[0]**o + ((0.491612692313+0.392691773101j))*x[0] + ((-0.118024176153-0.342780133952j))*x[1]**o + ((0.867541263102-0.719961696556j))*x[1]
        ref[(1, 2, 1, 1)]=(0.316013363697+0.460862186184j)*x_ref[0]**o + ((0.491612692313+0.392691773101j))*x_ref[0] + ((-0.118024176153-0.342780133952j))*x_ref[1]**o + ((0.867541263102-0.719961696556j))*x_ref[1]
        arg[(1, 2, 1, 2)]=(-0.927447474437-0.329276458382j)*x[0]**o + ((0.311419136407+0.0828004756135j))*x[0] + ((0.544482832546-0.0482906492604j))*x[1]**o + ((-0.756077471876+0.318018509146j))*x[1]
        ref[(1, 2, 1, 2)]=(-0.927447474437-0.329276458382j)*x_ref[0]**o + ((0.311419136407+0.0828004756135j))*x_ref[0] + ((0.544482832546-0.0482906492604j))*x_ref[1]**o + ((-0.756077471876+0.318018509146j))*x_ref[1]
        arg[(1, 2, 2, 0)]=(0.580628505319+0.198372045622j)*x[0]**o + ((0.458096146954-0.628514760695j))*x[0] + ((0.000266288838007+0.443352436935j))*x[1]**o + ((0.431234328666+0.146927168473j))*x[1]
        ref[(1, 2, 2, 0)]=(0.580628505319+0.198372045622j)*x_ref[0]**o + ((0.458096146954-0.628514760695j))*x_ref[0] + ((0.000266288838007+0.443352436935j))*x_ref[1]**o + ((0.431234328666+0.146927168473j))*x_ref[1]
        arg[(1, 2, 2, 1)]=(0.515995686247+0.80828354638j)*x[0]**o + ((0.310514520699+0.227298711383j))*x[0] + ((0.071184719684-0.730176238652j))*x[1]**o + ((-0.0211647517596-0.290524992343j))*x[1]
        ref[(1, 2, 2, 1)]=(0.515995686247+0.80828354638j)*x_ref[0]**o + ((0.310514520699+0.227298711383j))*x_ref[0] + ((0.071184719684-0.730176238652j))*x_ref[1]**o + ((-0.0211647517596-0.290524992343j))*x_ref[1]
        arg[(1, 2, 2, 2)]=(0.124733888114-0.172651183945j)*x[0]**o + ((-0.0330173194462+0.0587264928262j))*x[0] + ((-0.292723194018+0.544417839922j))*x[1]**o + ((0.245534143683-0.83201723901j))*x[1]
        ref[(1, 2, 2, 2)]=(0.124733888114-0.172651183945j)*x_ref[0]**o + ((-0.0330173194462+0.0587264928262j))*x_ref[0] + ((-0.292723194018+0.544417839922j))*x_ref[1]**o + ((0.245534143683-0.83201723901j))*x_ref[1]
        arg[(1, 2, 3, 0)]=(0.6846981502-0.682434374542j)*x[0]**o + ((-0.49732758796-0.0464921351734j))*x[0] + ((-0.00891898453217+0.963549719715j))*x[1]**o + ((-0.582234832618+0.258104373234j))*x[1]
        ref[(1, 2, 3, 0)]=(0.6846981502-0.682434374542j)*x_ref[0]**o + ((-0.49732758796-0.0464921351734j))*x_ref[0] + ((-0.00891898453217+0.963549719715j))*x_ref[1]**o + ((-0.582234832618+0.258104373234j))*x_ref[1]
        arg[(1, 2, 3, 1)]=(-0.829765636522-0.327217299853j)*x[0]**o + ((0.520427407632+0.82059707944j))*x[0] + ((0.268656528446+0.813483527279j))*x[1]**o + ((0.00982737088116+0.405149725508j))*x[1]
        ref[(1, 2, 3, 1)]=(-0.829765636522-0.327217299853j)*x_ref[0]**o + ((0.520427407632+0.82059707944j))*x_ref[0] + ((0.268656528446+0.813483527279j))*x_ref[1]**o + ((0.00982737088116+0.405149725508j))*x_ref[1]
        arg[(1, 2, 3, 2)]=(-0.104714328555-0.197886411518j)*x[0]**o + ((0.849285521304-0.891595424955j))*x[0] + ((0.195588340214-0.288253847526j))*x[1]**o + ((-0.660987636333-0.147252895002j))*x[1]
        ref[(1, 2, 3, 2)]=(-0.104714328555-0.197886411518j)*x_ref[0]**o + ((0.849285521304-0.891595424955j))*x_ref[0] + ((0.195588340214-0.288253847526j))*x_ref[1]**o + ((-0.660987636333-0.147252895002j))*x_ref[1]
        arg[(1, 3, 0, 0)]=(-0.178659769463-0.65962582195j)*x[0]**o + ((-0.76017795524+0.707480465189j))*x[0] + ((-0.787104319603-0.206172077973j))*x[1]**o + ((0.0679717396675-0.588208684877j))*x[1]
        ref[(1, 3, 0, 0)]=(-0.178659769463-0.65962582195j)*x_ref[0]**o + ((-0.76017795524+0.707480465189j))*x_ref[0] + ((-0.787104319603-0.206172077973j))*x_ref[1]**o + ((0.0679717396675-0.588208684877j))*x_ref[1]
        arg[(1, 3, 0, 1)]=(-0.135058637312-0.113247007519j)*x[0]**o + ((-0.0794880341143-0.942075225138j))*x[0] + ((-0.70727065653+0.832117333249j))*x[1]**o + ((-0.305850814988+0.593943752817j))*x[1]
        ref[(1, 3, 0, 1)]=(-0.135058637312-0.113247007519j)*x_ref[0]**o + ((-0.0794880341143-0.942075225138j))*x_ref[0] + ((-0.70727065653+0.832117333249j))*x_ref[1]**o + ((-0.305850814988+0.593943752817j))*x_ref[1]
        arg[(1, 3, 0, 2)]=(0.727754574622+0.218145960091j)*x[0]**o + ((-0.752207984971-0.161418735491j))*x[0] + ((0.501489712345+0.97614015773j))*x[1]**o + ((0.677802735222+0.0578201741502j))*x[1]
        ref[(1, 3, 0, 2)]=(0.727754574622+0.218145960091j)*x_ref[0]**o + ((-0.752207984971-0.161418735491j))*x_ref[0] + ((0.501489712345+0.97614015773j))*x_ref[1]**o + ((0.677802735222+0.0578201741502j))*x_ref[1]
        arg[(1, 3, 1, 0)]=(-0.89922563317+0.559366187758j)*x[0]**o + ((-0.105829674908-0.264240155688j))*x[0] + ((-0.178359652402+0.881831004772j))*x[1]**o + ((0.981839819483+0.409882086259j))*x[1]
        ref[(1, 3, 1, 0)]=(-0.89922563317+0.559366187758j)*x_ref[0]**o + ((-0.105829674908-0.264240155688j))*x_ref[0] + ((-0.178359652402+0.881831004772j))*x_ref[1]**o + ((0.981839819483+0.409882086259j))*x_ref[1]
        arg[(1, 3, 1, 1)]=(-0.59457386844-0.510829837911j)*x[0]**o + ((0.202107799175+0.922505138394j))*x[0] + ((0.504390950551+0.666624885278j))*x[1]**o + ((-0.229799745301+0.00232458366443j))*x[1]
        ref[(1, 3, 1, 1)]=(-0.59457386844-0.510829837911j)*x_ref[0]**o + ((0.202107799175+0.922505138394j))*x_ref[0] + ((0.504390950551+0.666624885278j))*x_ref[1]**o + ((-0.229799745301+0.00232458366443j))*x_ref[1]
        arg[(1, 3, 1, 2)]=(0.517200886609+0.327150309023j)*x[0]**o + ((0.723230827528+0.195351826366j))*x[0] + ((0.372578388016+0.20155694918j))*x[1]**o + ((0.321418239401-0.00261376789582j))*x[1]
        ref[(1, 3, 1, 2)]=(0.517200886609+0.327150309023j)*x_ref[0]**o + ((0.723230827528+0.195351826366j))*x_ref[0] + ((0.372578388016+0.20155694918j))*x_ref[1]**o + ((0.321418239401-0.00261376789582j))*x_ref[1]
        arg[(1, 3, 2, 0)]=(-0.0170144658291+0.69302605741j)*x[0]**o + ((0.0589239275917-0.817264123461j))*x[0] + ((-0.798588689956+0.0487030156603j))*x[1]**o + ((-0.105950399536+0.522666540482j))*x[1]
        ref[(1, 3, 2, 0)]=(-0.0170144658291+0.69302605741j)*x_ref[0]**o + ((0.0589239275917-0.817264123461j))*x_ref[0] + ((-0.798588689956+0.0487030156603j))*x_ref[1]**o + ((-0.105950399536+0.522666540482j))*x_ref[1]
        arg[(1, 3, 2, 1)]=(0.67331788976+0.391065773699j)*x[0]**o + ((-0.33350859032-0.590191091035j))*x[0] + ((0.932778755193-0.817719379765j))*x[1]**o + ((0.887463755279+0.341227429471j))*x[1]
        ref[(1, 3, 2, 1)]=(0.67331788976+0.391065773699j)*x_ref[0]**o + ((-0.33350859032-0.590191091035j))*x_ref[0] + ((0.932778755193-0.817719379765j))*x_ref[1]**o + ((0.887463755279+0.341227429471j))*x_ref[1]
        arg[(1, 3, 2, 2)]=(-0.1946096274+0.271964148735j)*x[0]**o + ((-0.617587021402+0.732088975111j))*x[0] + ((0.429775363062-0.906277801101j))*x[1]**o + ((-0.00681072892559+0.0708520014752j))*x[1]
        ref[(1, 3, 2, 2)]=(-0.1946096274+0.271964148735j)*x_ref[0]**o + ((-0.617587021402+0.732088975111j))*x_ref[0] + ((0.429775363062-0.906277801101j))*x_ref[1]**o + ((-0.00681072892559+0.0708520014752j))*x_ref[1]
        arg[(1, 3, 3, 0)]=(0.459333242828+0.847891731782j)*x[0]**o + ((-0.864287586741+0.345988824468j))*x[0] + ((-0.434516646434-0.310711266254j))*x[1]**o + ((0.344870444236-0.0719724582478j))*x[1]
        ref[(1, 3, 3, 0)]=(0.459333242828+0.847891731782j)*x_ref[0]**o + ((-0.864287586741+0.345988824468j))*x_ref[0] + ((-0.434516646434-0.310711266254j))*x_ref[1]**o + ((0.344870444236-0.0719724582478j))*x_ref[1]
        arg[(1, 3, 3, 1)]=(0.0460318558592+0.0824030222714j)*x[0]**o + ((-0.247271615525+0.996474899413j))*x[0] + ((-0.941127176498+0.40873063651j))*x[1]**o + ((-0.0112614922525+0.52920762109j))*x[1]
        ref[(1, 3, 3, 1)]=(0.0460318558592+0.0824030222714j)*x_ref[0]**o + ((-0.247271615525+0.996474899413j))*x_ref[0] + ((-0.941127176498+0.40873063651j))*x_ref[1]**o + ((-0.0112614922525+0.52920762109j))*x_ref[1]
        arg[(1, 3, 3, 2)]=(-0.908235190237+0.570377318543j)*x[0]**o + ((-0.221935183519-0.301465218721j))*x[0] + ((0.331974534636-0.309985960839j))*x[1]**o + ((-0.775706625225+0.874560605984j))*x[1]
        ref[(1, 3, 3, 2)]=(-0.908235190237+0.570377318543j)*x_ref[0]**o + ((-0.221935183519-0.301465218721j))*x_ref[0] + ((0.331974534636-0.309985960839j))*x_ref[1]**o + ((-0.775706625225+0.874560605984j))*x_ref[1]
        arg[(2, 0, 0, 0)]=(-0.360801548503-0.620217933616j)*x[0]**o + ((0.0436741832722+0.244330589879j))*x[0] + ((-0.322191098896+0.477877930337j))*x[1]**o + ((-0.723033730849-0.0290304442839j))*x[1]
        ref[(2, 0, 0, 0)]=(-0.360801548503-0.620217933616j)*x_ref[0]**o + ((0.0436741832722+0.244330589879j))*x_ref[0] + ((-0.322191098896+0.477877930337j))*x_ref[1]**o + ((-0.723033730849-0.0290304442839j))*x_ref[1]
        arg[(2, 0, 0, 1)]=(-0.537302931203+0.402700412326j)*x[0]**o + ((0.678413799076-0.937446726627j))*x[0] + ((0.123531183062+0.380220547738j))*x[1]**o + ((-0.940691661942+0.994956079857j))*x[1]
        ref[(2, 0, 0, 1)]=(-0.537302931203+0.402700412326j)*x_ref[0]**o + ((0.678413799076-0.937446726627j))*x_ref[0] + ((0.123531183062+0.380220547738j))*x_ref[1]**o + ((-0.940691661942+0.994956079857j))*x_ref[1]
        arg[(2, 0, 0, 2)]=(0.188393294662-0.498382263466j)*x[0]**o + ((0.73707016795-0.440386091641j))*x[0] + ((-0.739260810371-0.551755852167j))*x[1]**o + ((0.400877535474+0.238877632901j))*x[1]
        ref[(2, 0, 0, 2)]=(0.188393294662-0.498382263466j)*x_ref[0]**o + ((0.73707016795-0.440386091641j))*x_ref[0] + ((-0.739260810371-0.551755852167j))*x_ref[1]**o + ((0.400877535474+0.238877632901j))*x_ref[1]
        arg[(2, 0, 1, 0)]=(-0.517980417741+0.579007926491j)*x[0]**o + ((0.797514522181+0.307865773889j))*x[0] + ((0.189848767467-0.859062718904j))*x[1]**o + ((0.220397044142-0.331579233901j))*x[1]
        ref[(2, 0, 1, 0)]=(-0.517980417741+0.579007926491j)*x_ref[0]**o + ((0.797514522181+0.307865773889j))*x_ref[0] + ((0.189848767467-0.859062718904j))*x_ref[1]**o + ((0.220397044142-0.331579233901j))*x_ref[1]
        arg[(2, 0, 1, 1)]=(-0.803707320713+0.98975405495j)*x[0]**o + ((-0.909971440477+0.761450088765j))*x[0] + ((0.316877723454-0.336301666211j))*x[1]**o + ((-0.384930619892+0.901161776594j))*x[1]
        ref[(2, 0, 1, 1)]=(-0.803707320713+0.98975405495j)*x_ref[0]**o + ((-0.909971440477+0.761450088765j))*x_ref[0] + ((0.316877723454-0.336301666211j))*x_ref[1]**o + ((-0.384930619892+0.901161776594j))*x_ref[1]
        arg[(2, 0, 1, 2)]=(0.373587911785+0.885018512122j)*x[0]**o + ((0.858333618106-0.833070584006j))*x[0] + ((-0.663804364788+0.428793059693j))*x[1]**o + ((-0.0688201431327+0.0729185388087j))*x[1]
        ref[(2, 0, 1, 2)]=(0.373587911785+0.885018512122j)*x_ref[0]**o + ((0.858333618106-0.833070584006j))*x_ref[0] + ((-0.663804364788+0.428793059693j))*x_ref[1]**o + ((-0.0688201431327+0.0729185388087j))*x_ref[1]
        arg[(2, 0, 2, 0)]=(-0.835792602155-0.600291623362j)*x[0]**o + ((-0.280182499691-0.221299580605j))*x[0] + ((0.88073936844-0.42765496703j))*x[1]**o + ((0.370166803788-0.0972239302233j))*x[1]
        ref[(2, 0, 2, 0)]=(-0.835792602155-0.600291623362j)*x_ref[0]**o + ((-0.280182499691-0.221299580605j))*x_ref[0] + ((0.88073936844-0.42765496703j))*x_ref[1]**o + ((0.370166803788-0.0972239302233j))*x_ref[1]
        arg[(2, 0, 2, 1)]=(-0.172704141881-0.0689139234205j)*x[0]**o + ((-0.244528840353-0.210072902408j))*x[0] + ((-0.703943070254-0.756013960945j))*x[1]**o + ((0.104854278463-0.0193580423088j))*x[1]
        ref[(2, 0, 2, 1)]=(-0.172704141881-0.0689139234205j)*x_ref[0]**o + ((-0.244528840353-0.210072902408j))*x_ref[0] + ((-0.703943070254-0.756013960945j))*x_ref[1]**o + ((0.104854278463-0.0193580423088j))*x_ref[1]
        arg[(2, 0, 2, 2)]=(0.0456701186039-0.498894319772j)*x[0]**o + ((0.618868641466+0.385815471477j))*x[0] + ((-0.415937847371-0.630994187204j))*x[1]**o + ((0.334034593326-0.231522350458j))*x[1]
        ref[(2, 0, 2, 2)]=(0.0456701186039-0.498894319772j)*x_ref[0]**o + ((0.618868641466+0.385815471477j))*x_ref[0] + ((-0.415937847371-0.630994187204j))*x_ref[1]**o + ((0.334034593326-0.231522350458j))*x_ref[1]
        arg[(2, 0, 3, 0)]=(0.945343139708-0.340299539926j)*x[0]**o + ((0.234669885513+0.0163326852514j))*x[0] + ((0.86497276496-0.117113593121j))*x[1]**o + ((0.180877980614-0.151566138865j))*x[1]
        ref[(2, 0, 3, 0)]=(0.945343139708-0.340299539926j)*x_ref[0]**o + ((0.234669885513+0.0163326852514j))*x_ref[0] + ((0.86497276496-0.117113593121j))*x_ref[1]**o + ((0.180877980614-0.151566138865j))*x_ref[1]
        arg[(2, 0, 3, 1)]=(0.734502221033-0.426302218161j)*x[0]**o + ((-0.752510461649+0.479329909158j))*x[0] + ((-0.417541344514-0.217049317018j))*x[1]**o + ((0.974559120323+0.429313540295j))*x[1]
        ref[(2, 0, 3, 1)]=(0.734502221033-0.426302218161j)*x_ref[0]**o + ((-0.752510461649+0.479329909158j))*x_ref[0] + ((-0.417541344514-0.217049317018j))*x_ref[1]**o + ((0.974559120323+0.429313540295j))*x_ref[1]
        arg[(2, 0, 3, 2)]=(-0.714706010479-0.697629643027j)*x[0]**o + ((-0.81541899086-0.88376040692j))*x[0] + ((0.0465603493769-0.288287107399j))*x[1]**o + ((0.166120319906+0.685823117328j))*x[1]
        ref[(2, 0, 3, 2)]=(-0.714706010479-0.697629643027j)*x_ref[0]**o + ((-0.81541899086-0.88376040692j))*x_ref[0] + ((0.0465603493769-0.288287107399j))*x_ref[1]**o + ((0.166120319906+0.685823117328j))*x_ref[1]
        arg[(2, 1, 0, 0)]=(0.138831999349+0.109737344492j)*x[0]**o + ((-0.306192385176-0.323230211403j))*x[0] + ((-0.436166011086-0.124294938599j))*x[1]**o + ((-0.409822838285+0.963161662596j))*x[1]
        ref[(2, 1, 0, 0)]=(0.138831999349+0.109737344492j)*x_ref[0]**o + ((-0.306192385176-0.323230211403j))*x_ref[0] + ((-0.436166011086-0.124294938599j))*x_ref[1]**o + ((-0.409822838285+0.963161662596j))*x_ref[1]
        arg[(2, 1, 0, 1)]=(0.561670792659-0.230481970412j)*x[0]**o + ((-0.405791439373+0.312887885283j))*x[0] + ((0.635703332394-0.034941681292j))*x[1]**o + ((-0.622250423358-0.63410453892j))*x[1]
        ref[(2, 1, 0, 1)]=(0.561670792659-0.230481970412j)*x_ref[0]**o + ((-0.405791439373+0.312887885283j))*x_ref[0] + ((0.635703332394-0.034941681292j))*x_ref[1]**o + ((-0.622250423358-0.63410453892j))*x_ref[1]
        arg[(2, 1, 0, 2)]=(-0.233984920995+0.136923912608j)*x[0]**o + ((0.183383133098-0.924600888537j))*x[0] + ((0.497158855342+0.912542790981j))*x[1]**o + ((0.489170576447-0.263441906404j))*x[1]
        ref[(2, 1, 0, 2)]=(-0.233984920995+0.136923912608j)*x_ref[0]**o + ((0.183383133098-0.924600888537j))*x_ref[0] + ((0.497158855342+0.912542790981j))*x_ref[1]**o + ((0.489170576447-0.263441906404j))*x_ref[1]
        arg[(2, 1, 1, 0)]=(0.816995506402-0.897413005347j)*x[0]**o + ((-0.96669404458-0.718024760586j))*x[0] + ((-0.534574093872-0.187931096456j))*x[1]**o + ((0.711794245515-0.651559693003j))*x[1]
        ref[(2, 1, 1, 0)]=(0.816995506402-0.897413005347j)*x_ref[0]**o + ((-0.96669404458-0.718024760586j))*x_ref[0] + ((-0.534574093872-0.187931096456j))*x_ref[1]**o + ((0.711794245515-0.651559693003j))*x_ref[1]
        arg[(2, 1, 1, 1)]=(0.808824788796-0.722705643884j)*x[0]**o + ((0.687877411689-0.119126591947j))*x[0] + ((0.124143301587+0.479655039439j))*x[1]**o + ((-0.111549509076+0.819779514162j))*x[1]
        ref[(2, 1, 1, 1)]=(0.808824788796-0.722705643884j)*x_ref[0]**o + ((0.687877411689-0.119126591947j))*x_ref[0] + ((0.124143301587+0.479655039439j))*x_ref[1]**o + ((-0.111549509076+0.819779514162j))*x_ref[1]
        arg[(2, 1, 1, 2)]=(-0.00796709796962+0.850479185909j)*x[0]**o + ((0.869798589954+0.817290938838j))*x[0] + ((-0.64132990087-0.454907277553j))*x[1]**o + ((0.643159151289-0.24723617401j))*x[1]
        ref[(2, 1, 1, 2)]=(-0.00796709796962+0.850479185909j)*x_ref[0]**o + ((0.869798589954+0.817290938838j))*x_ref[0] + ((-0.64132990087-0.454907277553j))*x_ref[1]**o + ((0.643159151289-0.24723617401j))*x_ref[1]
        arg[(2, 1, 2, 0)]=(0.782668462213-0.0260042395535j)*x[0]**o + ((0.342100643298+0.564597619263j))*x[0] + ((0.950148917426-0.957221839874j))*x[1]**o + ((-0.740534679107+0.0704767672017j))*x[1]
        ref[(2, 1, 2, 0)]=(0.782668462213-0.0260042395535j)*x_ref[0]**o + ((0.342100643298+0.564597619263j))*x_ref[0] + ((0.950148917426-0.957221839874j))*x_ref[1]**o + ((-0.740534679107+0.0704767672017j))*x_ref[1]
        arg[(2, 1, 2, 1)]=(-0.31972186106+0.204129227778j)*x[0]**o + ((0.898257438137+0.585030703619j))*x[0] + ((-0.295789838606+0.769770400712j))*x[1]**o + ((-0.0101179434408-0.876072196074j))*x[1]
        ref[(2, 1, 2, 1)]=(-0.31972186106+0.204129227778j)*x_ref[0]**o + ((0.898257438137+0.585030703619j))*x_ref[0] + ((-0.295789838606+0.769770400712j))*x_ref[1]**o + ((-0.0101179434408-0.876072196074j))*x_ref[1]
        arg[(2, 1, 2, 2)]=(-0.635709317918-0.0309167315334j)*x[0]**o + ((-0.731615726769-0.921097252094j))*x[0] + ((-0.802379558558-0.519513798781j))*x[1]**o + ((0.375708685378-0.5805156767j))*x[1]
        ref[(2, 1, 2, 2)]=(-0.635709317918-0.0309167315334j)*x_ref[0]**o + ((-0.731615726769-0.921097252094j))*x_ref[0] + ((-0.802379558558-0.519513798781j))*x_ref[1]**o + ((0.375708685378-0.5805156767j))*x_ref[1]
        arg[(2, 1, 3, 0)]=(0.380851498453-0.559141567589j)*x[0]**o + ((0.759819199312+0.70144599821j))*x[0] + ((-0.692469743647-0.86653791446j))*x[1]**o + ((0.295854097992+0.419393769736j))*x[1]
        ref[(2, 1, 3, 0)]=(0.380851498453-0.559141567589j)*x_ref[0]**o + ((0.759819199312+0.70144599821j))*x_ref[0] + ((-0.692469743647-0.86653791446j))*x_ref[1]**o + ((0.295854097992+0.419393769736j))*x_ref[1]
        arg[(2, 1, 3, 1)]=(-0.891260564267+0.131070105978j)*x[0]**o + ((0.355007664467+0.801617154442j))*x[0] + ((-0.16764478446-0.32991109866j))*x[1]**o + ((-0.743338908314-0.44635675983j))*x[1]
        ref[(2, 1, 3, 1)]=(-0.891260564267+0.131070105978j)*x_ref[0]**o + ((0.355007664467+0.801617154442j))*x_ref[0] + ((-0.16764478446-0.32991109866j))*x_ref[1]**o + ((-0.743338908314-0.44635675983j))*x_ref[1]
        arg[(2, 1, 3, 2)]=(-0.948998003127+0.986427658888j)*x[0]**o + ((0.038315210403+0.454711211573j))*x[0] + ((-0.953091354727-0.287123479159j))*x[1]**o + ((0.527404974896-0.0893491126723j))*x[1]
        ref[(2, 1, 3, 2)]=(-0.948998003127+0.986427658888j)*x_ref[0]**o + ((0.038315210403+0.454711211573j))*x_ref[0] + ((-0.953091354727-0.287123479159j))*x_ref[1]**o + ((0.527404974896-0.0893491126723j))*x_ref[1]
        arg[(2, 2, 0, 0)]=(0.573428160166+0.892789167817j)*x[0]**o + ((-0.0870338427023-0.222927807885j))*x[0] + ((0.34133366267+0.142693601166j))*x[1]**o + ((0.714225724137+0.277062910601j))*x[1]
        ref[(2, 2, 0, 0)]=(0.573428160166+0.892789167817j)*x_ref[0]**o + ((-0.0870338427023-0.222927807885j))*x_ref[0] + ((0.34133366267+0.142693601166j))*x_ref[1]**o + ((0.714225724137+0.277062910601j))*x_ref[1]
        arg[(2, 2, 0, 1)]=(0.701129575268-0.715969837851j)*x[0]**o + ((0.91830887453-0.889220015456j))*x[0] + ((-0.989124278875-0.0323409671023j))*x[1]**o + ((-0.969255434807-0.179330425575j))*x[1]
        ref[(2, 2, 0, 1)]=(0.701129575268-0.715969837851j)*x_ref[0]**o + ((0.91830887453-0.889220015456j))*x_ref[0] + ((-0.989124278875-0.0323409671023j))*x_ref[1]**o + ((-0.969255434807-0.179330425575j))*x_ref[1]
        arg[(2, 2, 0, 2)]=(0.165756614084+0.184903725609j)*x[0]**o + ((0.959341111441+0.432495883329j))*x[0] + ((-0.260231175735-0.765805080451j))*x[1]**o + ((-0.685253353576-0.0197266324423j))*x[1]
        ref[(2, 2, 0, 2)]=(0.165756614084+0.184903725609j)*x_ref[0]**o + ((0.959341111441+0.432495883329j))*x_ref[0] + ((-0.260231175735-0.765805080451j))*x_ref[1]**o + ((-0.685253353576-0.0197266324423j))*x_ref[1]
        arg[(2, 2, 1, 0)]=(0.929953949716-0.120069671561j)*x[0]**o + ((0.796925126118+0.817756057513j))*x[0] + ((0.373099704321-0.797438633147j))*x[1]**o + ((0.498632684526+0.472052113526j))*x[1]
        ref[(2, 2, 1, 0)]=(0.929953949716-0.120069671561j)*x_ref[0]**o + ((0.796925126118+0.817756057513j))*x_ref[0] + ((0.373099704321-0.797438633147j))*x_ref[1]**o + ((0.498632684526+0.472052113526j))*x_ref[1]
        arg[(2, 2, 1, 1)]=(-0.235704719811+0.549628737586j)*x[0]**o + ((0.162129156584-0.566662535017j))*x[0] + ((0.959034410229+0.447489932844j))*x[1]**o + ((0.865066043598-0.820025916505j))*x[1]
        ref[(2, 2, 1, 1)]=(-0.235704719811+0.549628737586j)*x_ref[0]**o + ((0.162129156584-0.566662535017j))*x_ref[0] + ((0.959034410229+0.447489932844j))*x_ref[1]**o + ((0.865066043598-0.820025916505j))*x_ref[1]
        arg[(2, 2, 1, 2)]=(0.852679226107-0.238790636341j)*x[0]**o + ((0.798766483269-0.102202604495j))*x[0] + ((-0.368900641044+0.920447158152j))*x[1]**o + ((-0.31088982997+0.498869999575j))*x[1]
        ref[(2, 2, 1, 2)]=(0.852679226107-0.238790636341j)*x_ref[0]**o + ((0.798766483269-0.102202604495j))*x_ref[0] + ((-0.368900641044+0.920447158152j))*x_ref[1]**o + ((-0.31088982997+0.498869999575j))*x_ref[1]
        arg[(2, 2, 2, 0)]=(-0.28795550916-0.57054713598j)*x[0]**o + ((0.342645749419-0.971019782166j))*x[0] + ((0.324648449778+0.801564386189j))*x[1]**o + ((0.400896111494+0.850769583166j))*x[1]
        ref[(2, 2, 2, 0)]=(-0.28795550916-0.57054713598j)*x_ref[0]**o + ((0.342645749419-0.971019782166j))*x_ref[0] + ((0.324648449778+0.801564386189j))*x_ref[1]**o + ((0.400896111494+0.850769583166j))*x_ref[1]
        arg[(2, 2, 2, 1)]=(-0.526598675601-0.685849945484j)*x[0]**o + ((-0.575537001733+0.382875612443j))*x[0] + ((0.296276074396+0.179670921072j))*x[1]**o + ((-0.177245051749-0.0197168285068j))*x[1]
        ref[(2, 2, 2, 1)]=(-0.526598675601-0.685849945484j)*x_ref[0]**o + ((-0.575537001733+0.382875612443j))*x_ref[0] + ((0.296276074396+0.179670921072j))*x_ref[1]**o + ((-0.177245051749-0.0197168285068j))*x_ref[1]
        arg[(2, 2, 2, 2)]=(-0.0808451090791-0.099388037665j)*x[0]**o + ((-0.504642864485-0.795070424251j))*x[0] + ((-0.620624800328+0.0442331087476j))*x[1]**o + ((-0.216919096866-0.718618582028j))*x[1]
        ref[(2, 2, 2, 2)]=(-0.0808451090791-0.099388037665j)*x_ref[0]**o + ((-0.504642864485-0.795070424251j))*x_ref[0] + ((-0.620624800328+0.0442331087476j))*x_ref[1]**o + ((-0.216919096866-0.718618582028j))*x_ref[1]
        arg[(2, 2, 3, 0)]=(-0.829572233357+0.528192344641j)*x[0]**o + ((0.490155177989+0.353564216276j))*x[0] + ((-0.789783347616+0.191487720269j))*x[1]**o + ((0.0175287771469-0.452648863488j))*x[1]
        ref[(2, 2, 3, 0)]=(-0.829572233357+0.528192344641j)*x_ref[0]**o + ((0.490155177989+0.353564216276j))*x_ref[0] + ((-0.789783347616+0.191487720269j))*x_ref[1]**o + ((0.0175287771469-0.452648863488j))*x_ref[1]
        arg[(2, 2, 3, 1)]=(-0.516927580815-0.238290464318j)*x[0]**o + ((-0.409642329771-0.044131443193j))*x[0] + ((0.7396150398-0.924730141519j))*x[1]**o + ((0.000424516065639-0.0279782302118j))*x[1]
        ref[(2, 2, 3, 1)]=(-0.516927580815-0.238290464318j)*x_ref[0]**o + ((-0.409642329771-0.044131443193j))*x_ref[0] + ((0.7396150398-0.924730141519j))*x_ref[1]**o + ((0.000424516065639-0.0279782302118j))*x_ref[1]
        arg[(2, 2, 3, 2)]=(-0.448082425433+0.452495041671j)*x[0]**o + ((0.562586015349-0.582039176515j))*x[0] + ((0.432190624003-0.254224152988j))*x[1]**o + ((0.0804059083782+0.914914797845j))*x[1]
        ref[(2, 2, 3, 2)]=(-0.448082425433+0.452495041671j)*x_ref[0]**o + ((0.562586015349-0.582039176515j))*x_ref[0] + ((0.432190624003-0.254224152988j))*x_ref[1]**o + ((0.0804059083782+0.914914797845j))*x_ref[1]
        arg[(2, 3, 0, 0)]=(0.813682182973+0.152362825703j)*x[0]**o + ((-0.139601960761-0.667986060586j))*x[0] + ((0.108865757724-0.769549090456j))*x[1]**o + ((0.364311697017-0.252329719997j))*x[1]
        ref[(2, 3, 0, 0)]=(0.813682182973+0.152362825703j)*x_ref[0]**o + ((-0.139601960761-0.667986060586j))*x_ref[0] + ((0.108865757724-0.769549090456j))*x_ref[1]**o + ((0.364311697017-0.252329719997j))*x_ref[1]
        arg[(2, 3, 0, 1)]=(0.394614901498-0.30385516101j)*x[0]**o + ((-0.176412645758-0.979248606847j))*x[0] + ((-0.600967286993-0.203917617665j))*x[1]**o + ((-0.765936787791+0.0192857699164j))*x[1]
        ref[(2, 3, 0, 1)]=(0.394614901498-0.30385516101j)*x_ref[0]**o + ((-0.176412645758-0.979248606847j))*x_ref[0] + ((-0.600967286993-0.203917617665j))*x_ref[1]**o + ((-0.765936787791+0.0192857699164j))*x_ref[1]
        arg[(2, 3, 0, 2)]=(-0.289339685907+0.795282214433j)*x[0]**o + ((-0.415804977834+0.0508881419819j))*x[0] + ((0.0982378806406-0.092775945986j))*x[1]**o + ((-0.319696694663-0.602754181059j))*x[1]
        ref[(2, 3, 0, 2)]=(-0.289339685907+0.795282214433j)*x_ref[0]**o + ((-0.415804977834+0.0508881419819j))*x_ref[0] + ((0.0982378806406-0.092775945986j))*x_ref[1]**o + ((-0.319696694663-0.602754181059j))*x_ref[1]
        arg[(2, 3, 1, 0)]=(-0.481105101387-0.542146303513j)*x[0]**o + ((0.626819867071+0.507981661783j))*x[0] + ((0.413606000867+0.0936549972457j))*x[1]**o + ((-0.273876751239+0.26450112843j))*x[1]
        ref[(2, 3, 1, 0)]=(-0.481105101387-0.542146303513j)*x_ref[0]**o + ((0.626819867071+0.507981661783j))*x_ref[0] + ((0.413606000867+0.0936549972457j))*x_ref[1]**o + ((-0.273876751239+0.26450112843j))*x_ref[1]
        arg[(2, 3, 1, 1)]=(-0.767187395255-0.203530243527j)*x[0]**o + ((-0.245071396612+0.577611097695j))*x[0] + ((-0.0541656611106-0.706637795252j))*x[1]**o + ((-0.50497769715+0.36790289256j))*x[1]
        ref[(2, 3, 1, 1)]=(-0.767187395255-0.203530243527j)*x_ref[0]**o + ((-0.245071396612+0.577611097695j))*x_ref[0] + ((-0.0541656611106-0.706637795252j))*x_ref[1]**o + ((-0.50497769715+0.36790289256j))*x_ref[1]
        arg[(2, 3, 1, 2)]=(0.696280452468+0.541112038738j)*x[0]**o + ((-0.525872159663-0.629409351477j))*x[0] + ((0.225173058299-0.712998502197j))*x[1]**o + ((-0.297056914069-0.431854393818j))*x[1]
        ref[(2, 3, 1, 2)]=(0.696280452468+0.541112038738j)*x_ref[0]**o + ((-0.525872159663-0.629409351477j))*x_ref[0] + ((0.225173058299-0.712998502197j))*x_ref[1]**o + ((-0.297056914069-0.431854393818j))*x_ref[1]
        arg[(2, 3, 2, 0)]=(-0.425299887441+0.772960355546j)*x[0]**o + ((0.214088969966+0.781796205506j))*x[0] + ((-0.468809039368+0.196196652396j))*x[1]**o + ((0.39166159046+0.30389207044j))*x[1]
        ref[(2, 3, 2, 0)]=(-0.425299887441+0.772960355546j)*x_ref[0]**o + ((0.214088969966+0.781796205506j))*x_ref[0] + ((-0.468809039368+0.196196652396j))*x_ref[1]**o + ((0.39166159046+0.30389207044j))*x_ref[1]
        arg[(2, 3, 2, 1)]=(-0.386646686583+0.181202203304j)*x[0]**o + ((-0.644600719283-0.69948109206j))*x[0] + ((-0.332128330395+0.212607465726j))*x[1]**o + ((0.945814684466-0.49344735906j))*x[1]
        ref[(2, 3, 2, 1)]=(-0.386646686583+0.181202203304j)*x_ref[0]**o + ((-0.644600719283-0.69948109206j))*x_ref[0] + ((-0.332128330395+0.212607465726j))*x_ref[1]**o + ((0.945814684466-0.49344735906j))*x_ref[1]
        arg[(2, 3, 2, 2)]=(0.351285410344+0.43563498248j)*x[0]**o + ((0.360166954821-0.828163114726j))*x[0] + ((0.367868410856+0.988382616296j))*x[1]**o + ((0.473116406136-0.343865521897j))*x[1]
        ref[(2, 3, 2, 2)]=(0.351285410344+0.43563498248j)*x_ref[0]**o + ((0.360166954821-0.828163114726j))*x_ref[0] + ((0.367868410856+0.988382616296j))*x_ref[1]**o + ((0.473116406136-0.343865521897j))*x_ref[1]
        arg[(2, 3, 3, 0)]=(-0.21579555841+0.093519947566j)*x[0]**o + ((0.289395608818+0.848044714853j))*x[0] + ((0.319242481683-0.178586816467j))*x[1]**o + ((-0.00752447638719+0.854051273647j))*x[1]
        ref[(2, 3, 3, 0)]=(-0.21579555841+0.093519947566j)*x_ref[0]**o + ((0.289395608818+0.848044714853j))*x_ref[0] + ((0.319242481683-0.178586816467j))*x_ref[1]**o + ((-0.00752447638719+0.854051273647j))*x_ref[1]
        arg[(2, 3, 3, 1)]=(0.721193450089+0.757897589077j)*x[0]**o + ((0.403970578783+0.710742334543j))*x[0] + ((-0.413859539978-0.290045172398j))*x[1]**o + ((-0.958613015528+0.323951743311j))*x[1]
        ref[(2, 3, 3, 1)]=(0.721193450089+0.757897589077j)*x_ref[0]**o + ((0.403970578783+0.710742334543j))*x_ref[0] + ((-0.413859539978-0.290045172398j))*x_ref[1]**o + ((-0.958613015528+0.323951743311j))*x_ref[1]
        arg[(2, 3, 3, 2)]=(0.859278078077+0.507079657976j)*x[0]**o + ((0.405960019001-0.843513275244j))*x[0] + ((-0.85096168307+0.121960183154j))*x[1]**o + ((0.0944488875487-0.953073600314j))*x[1]
        ref[(2, 3, 3, 2)]=(0.859278078077+0.507079657976j)*x_ref[0]**o + ((0.405960019001-0.843513275244j))*x_ref[0] + ((-0.85096168307+0.121960183154j))*x_ref[1]**o + ((0.0944488875487-0.953073600314j))*x_ref[1]
        arg[(3, 0, 0, 0)]=(0.127791758149-0.0928252421482j)*x[0]**o + ((0.905625142132-0.778843712792j))*x[0] + ((0.882950087409+0.637116317991j))*x[1]**o + ((-0.966160333222+0.310050602913j))*x[1]
        ref[(3, 0, 0, 0)]=(0.127791758149-0.0928252421482j)*x_ref[0]**o + ((0.905625142132-0.778843712792j))*x_ref[0] + ((0.882950087409+0.637116317991j))*x_ref[1]**o + ((-0.966160333222+0.310050602913j))*x_ref[1]
        arg[(3, 0, 0, 1)]=(-0.597533838822+0.890809955558j)*x[0]**o + ((0.586925708447-0.38311714547j))*x[0] + ((0.0520852266657-0.530476938506j))*x[1]**o + ((-0.930817860921-0.599173699931j))*x[1]
        ref[(3, 0, 0, 1)]=(-0.597533838822+0.890809955558j)*x_ref[0]**o + ((0.586925708447-0.38311714547j))*x_ref[0] + ((0.0520852266657-0.530476938506j))*x_ref[1]**o + ((-0.930817860921-0.599173699931j))*x_ref[1]
        arg[(3, 0, 0, 2)]=(0.913244323918-0.555084205846j)*x[0]**o + ((0.638629386651-0.251407273154j))*x[0] + ((-0.747903925128+0.590492817331j))*x[1]**o + ((-0.991661570546+0.10205604318j))*x[1]
        ref[(3, 0, 0, 2)]=(0.913244323918-0.555084205846j)*x_ref[0]**o + ((0.638629386651-0.251407273154j))*x_ref[0] + ((-0.747903925128+0.590492817331j))*x_ref[1]**o + ((-0.991661570546+0.10205604318j))*x_ref[1]
        arg[(3, 0, 1, 0)]=(0.634576625821-0.890808306642j)*x[0]**o + ((0.366987517626-0.276438844269j))*x[0] + ((0.447859619622-0.657488879399j))*x[1]**o + ((0.507497315279+0.122592904374j))*x[1]
        ref[(3, 0, 1, 0)]=(0.634576625821-0.890808306642j)*x_ref[0]**o + ((0.366987517626-0.276438844269j))*x_ref[0] + ((0.447859619622-0.657488879399j))*x_ref[1]**o + ((0.507497315279+0.122592904374j))*x_ref[1]
        arg[(3, 0, 1, 1)]=(0.0761470075399-0.351012785868j)*x[0]**o + ((-0.173191480842+0.104916832907j))*x[0] + ((0.319909391989+0.314839789783j))*x[1]**o + ((-0.833583191372-0.53563445211j))*x[1]
        ref[(3, 0, 1, 1)]=(0.0761470075399-0.351012785868j)*x_ref[0]**o + ((-0.173191480842+0.104916832907j))*x_ref[0] + ((0.319909391989+0.314839789783j))*x_ref[1]**o + ((-0.833583191372-0.53563445211j))*x_ref[1]
        arg[(3, 0, 1, 2)]=(0.313132921825-0.84582290368j)*x[0]**o + ((-0.702647630703-0.500976603038j))*x[0] + ((-0.0944753182265-0.9012994005j))*x[1]**o + ((-0.902801042432-0.959701328354j))*x[1]
        ref[(3, 0, 1, 2)]=(0.313132921825-0.84582290368j)*x_ref[0]**o + ((-0.702647630703-0.500976603038j))*x_ref[0] + ((-0.0944753182265-0.9012994005j))*x_ref[1]**o + ((-0.902801042432-0.959701328354j))*x_ref[1]
        arg[(3, 0, 2, 0)]=(0.461665909193+0.507235070214j)*x[0]**o + ((0.302836154294+0.704572368986j))*x[0] + ((0.80113363353+0.672980794979j))*x[1]**o + ((-0.376703705319-0.344359901253j))*x[1]
        ref[(3, 0, 2, 0)]=(0.461665909193+0.507235070214j)*x_ref[0]**o + ((0.302836154294+0.704572368986j))*x_ref[0] + ((0.80113363353+0.672980794979j))*x_ref[1]**o + ((-0.376703705319-0.344359901253j))*x_ref[1]
        arg[(3, 0, 2, 1)]=(-0.8854473329+0.769950496771j)*x[0]**o + ((0.916687149734+0.867878592272j))*x[0] + ((-0.977668648118-0.538569249269j))*x[1]**o + ((0.989422631572-0.0709990857991j))*x[1]
        ref[(3, 0, 2, 1)]=(-0.8854473329+0.769950496771j)*x_ref[0]**o + ((0.916687149734+0.867878592272j))*x_ref[0] + ((-0.977668648118-0.538569249269j))*x_ref[1]**o + ((0.989422631572-0.0709990857991j))*x_ref[1]
        arg[(3, 0, 2, 2)]=(-0.259846811278+0.619650940424j)*x[0]**o + ((-0.0907761891575-0.562370847151j))*x[0] + ((-0.0348313578218-0.761585189338j))*x[1]**o + ((0.410824342266-0.997519178896j))*x[1]
        ref[(3, 0, 2, 2)]=(-0.259846811278+0.619650940424j)*x_ref[0]**o + ((-0.0907761891575-0.562370847151j))*x_ref[0] + ((-0.0348313578218-0.761585189338j))*x_ref[1]**o + ((0.410824342266-0.997519178896j))*x_ref[1]
        arg[(3, 0, 3, 0)]=(0.420181096516+0.734952464725j)*x[0]**o + ((0.39480858136+0.631216754439j))*x[0] + ((0.755396118892+0.754998405931j))*x[1]**o + ((0.957917895083-0.389173832773j))*x[1]
        ref[(3, 0, 3, 0)]=(0.420181096516+0.734952464725j)*x_ref[0]**o + ((0.39480858136+0.631216754439j))*x_ref[0] + ((0.755396118892+0.754998405931j))*x_ref[1]**o + ((0.957917895083-0.389173832773j))*x_ref[1]
        arg[(3, 0, 3, 1)]=(-0.775581437466-0.156056375529j)*x[0]**o + ((0.566584487475+0.259111239661j))*x[0] + ((0.0556032708102-0.487560787456j))*x[1]**o + ((-0.457706574636-0.334307699155j))*x[1]
        ref[(3, 0, 3, 1)]=(-0.775581437466-0.156056375529j)*x_ref[0]**o + ((0.566584487475+0.259111239661j))*x_ref[0] + ((0.0556032708102-0.487560787456j))*x_ref[1]**o + ((-0.457706574636-0.334307699155j))*x_ref[1]
        arg[(3, 0, 3, 2)]=(0.881652181601-0.306807788471j)*x[0]**o + ((0.524966794786-0.867812446342j))*x[0] + ((0.6404128572-0.0328540230554j))*x[1]**o + ((-0.137624828044-0.797969037414j))*x[1]
        ref[(3, 0, 3, 2)]=(0.881652181601-0.306807788471j)*x_ref[0]**o + ((0.524966794786-0.867812446342j))*x_ref[0] + ((0.6404128572-0.0328540230554j))*x_ref[1]**o + ((-0.137624828044-0.797969037414j))*x_ref[1]
        arg[(3, 1, 0, 0)]=(0.402081835527+0.740511625774j)*x[0]**o + ((0.380660478736-0.191126742891j))*x[0] + ((0.518472405817-0.455814252267j))*x[1]**o + ((-0.463422489448+0.877287084533j))*x[1]
        ref[(3, 1, 0, 0)]=(0.402081835527+0.740511625774j)*x_ref[0]**o + ((0.380660478736-0.191126742891j))*x_ref[0] + ((0.518472405817-0.455814252267j))*x_ref[1]**o + ((-0.463422489448+0.877287084533j))*x_ref[1]
        arg[(3, 1, 0, 1)]=(-0.720024141156+0.708843874393j)*x[0]**o + ((-0.892080887163+0.651271199436j))*x[0] + ((-0.499877143332-0.648945744008j))*x[1]**o + ((-0.660698423079+0.481766310449j))*x[1]
        ref[(3, 1, 0, 1)]=(-0.720024141156+0.708843874393j)*x_ref[0]**o + ((-0.892080887163+0.651271199436j))*x_ref[0] + ((-0.499877143332-0.648945744008j))*x_ref[1]**o + ((-0.660698423079+0.481766310449j))*x_ref[1]
        arg[(3, 1, 0, 2)]=(-0.727091851065+0.257871132058j)*x[0]**o + ((0.320829802316-0.915364194817j))*x[0] + ((0.0989640294682+0.161529812162j))*x[1]**o + ((0.807773330501+0.948620830585j))*x[1]
        ref[(3, 1, 0, 2)]=(-0.727091851065+0.257871132058j)*x_ref[0]**o + ((0.320829802316-0.915364194817j))*x_ref[0] + ((0.0989640294682+0.161529812162j))*x_ref[1]**o + ((0.807773330501+0.948620830585j))*x_ref[1]
        arg[(3, 1, 1, 0)]=(0.742000892629-0.078095799245j)*x[0]**o + ((0.267021131659-0.114591841676j))*x[0] + ((0.299206203934+0.737289463559j))*x[1]**o + ((-0.899807122045-0.609848335475j))*x[1]
        ref[(3, 1, 1, 0)]=(0.742000892629-0.078095799245j)*x_ref[0]**o + ((0.267021131659-0.114591841676j))*x_ref[0] + ((0.299206203934+0.737289463559j))*x_ref[1]**o + ((-0.899807122045-0.609848335475j))*x_ref[1]
        arg[(3, 1, 1, 1)]=(-0.00505908381461+0.55528962989j)*x[0]**o + ((0.714810088842-0.235249167875j))*x[0] + ((-0.853940990752+0.955319590129j))*x[1]**o + ((-0.000790306633422+0.893714550875j))*x[1]
        ref[(3, 1, 1, 1)]=(-0.00505908381461+0.55528962989j)*x_ref[0]**o + ((0.714810088842-0.235249167875j))*x_ref[0] + ((-0.853940990752+0.955319590129j))*x_ref[1]**o + ((-0.000790306633422+0.893714550875j))*x_ref[1]
        arg[(3, 1, 1, 2)]=(0.201336528417-0.0606554970023j)*x[0]**o + ((0.743920620485+0.652823480347j))*x[0] + ((-0.331832088243+0.390053511118j))*x[1]**o + ((0.347884372463+0.93373211684j))*x[1]
        ref[(3, 1, 1, 2)]=(0.201336528417-0.0606554970023j)*x_ref[0]**o + ((0.743920620485+0.652823480347j))*x_ref[0] + ((-0.331832088243+0.390053511118j))*x_ref[1]**o + ((0.347884372463+0.93373211684j))*x_ref[1]
        arg[(3, 1, 2, 0)]=(0.17339117305-0.463459890792j)*x[0]**o + ((0.0249817073071-0.940425652492j))*x[0] + ((0.626658583454-0.00442755071317j))*x[1]**o + ((0.29248704358+0.446747406229j))*x[1]
        ref[(3, 1, 2, 0)]=(0.17339117305-0.463459890792j)*x_ref[0]**o + ((0.0249817073071-0.940425652492j))*x_ref[0] + ((0.626658583454-0.00442755071317j))*x_ref[1]**o + ((0.29248704358+0.446747406229j))*x_ref[1]
        arg[(3, 1, 2, 1)]=(0.896492853686+0.241839444973j)*x[0]**o + ((-0.444490110655-0.846139996209j))*x[0] + ((0.344053914049-0.057161668409j))*x[1]**o + ((-0.0942945685929-0.376465505193j))*x[1]
        ref[(3, 1, 2, 1)]=(0.896492853686+0.241839444973j)*x_ref[0]**o + ((-0.444490110655-0.846139996209j))*x_ref[0] + ((0.344053914049-0.057161668409j))*x_ref[1]**o + ((-0.0942945685929-0.376465505193j))*x_ref[1]
        arg[(3, 1, 2, 2)]=(0.382147276598+0.292299830177j)*x[0]**o + ((-0.610323951508+0.402024122601j))*x[0] + ((-0.995837633656-0.711813713997j))*x[1]**o + ((0.0112458604345-0.716703252043j))*x[1]
        ref[(3, 1, 2, 2)]=(0.382147276598+0.292299830177j)*x_ref[0]**o + ((-0.610323951508+0.402024122601j))*x_ref[0] + ((-0.995837633656-0.711813713997j))*x_ref[1]**o + ((0.0112458604345-0.716703252043j))*x_ref[1]
        arg[(3, 1, 3, 0)]=(-0.517678779484-0.534973463803j)*x[0]**o + ((0.924055094929+0.204231641379j))*x[0] + ((-0.287600040007-0.483625323527j))*x[1]**o + ((0.23021404604-0.607891356254j))*x[1]
        ref[(3, 1, 3, 0)]=(-0.517678779484-0.534973463803j)*x_ref[0]**o + ((0.924055094929+0.204231641379j))*x_ref[0] + ((-0.287600040007-0.483625323527j))*x_ref[1]**o + ((0.23021404604-0.607891356254j))*x_ref[1]
        arg[(3, 1, 3, 1)]=(-0.92322650687-0.512103553572j)*x[0]**o + ((0.483518704976+0.467799358317j))*x[0] + ((-0.917828550478-0.172901622887j))*x[1]**o + ((0.150007809343-0.528063590845j))*x[1]
        ref[(3, 1, 3, 1)]=(-0.92322650687-0.512103553572j)*x_ref[0]**o + ((0.483518704976+0.467799358317j))*x_ref[0] + ((-0.917828550478-0.172901622887j))*x_ref[1]**o + ((0.150007809343-0.528063590845j))*x_ref[1]
        arg[(3, 1, 3, 2)]=(0.103824720656+0.593384758256j)*x[0]**o + ((-0.948964946509-0.0384003412334j))*x[0] + ((-0.949305587676-0.295624326639j))*x[1]**o + ((0.839540484505-0.0361771138759j))*x[1]
        ref[(3, 1, 3, 2)]=(0.103824720656+0.593384758256j)*x_ref[0]**o + ((-0.948964946509-0.0384003412334j))*x_ref[0] + ((-0.949305587676-0.295624326639j))*x_ref[1]**o + ((0.839540484505-0.0361771138759j))*x_ref[1]
        arg[(3, 2, 0, 0)]=(0.483304623617-0.698899893911j)*x[0]**o + ((0.974715705881+0.581764783279j))*x[0] + ((0.369758922451-0.321509115224j))*x[1]**o + ((0.398944692107+0.512192637765j))*x[1]
        ref[(3, 2, 0, 0)]=(0.483304623617-0.698899893911j)*x_ref[0]**o + ((0.974715705881+0.581764783279j))*x_ref[0] + ((0.369758922451-0.321509115224j))*x_ref[1]**o + ((0.398944692107+0.512192637765j))*x_ref[1]
        arg[(3, 2, 0, 1)]=(0.368142435241-0.843085731859j)*x[0]**o + ((0.590435301254-0.222759331604j))*x[0] + ((-0.533510698506+0.0773764455431j))*x[1]**o + ((0.669128041183+0.124218627056j))*x[1]
        ref[(3, 2, 0, 1)]=(0.368142435241-0.843085731859j)*x_ref[0]**o + ((0.590435301254-0.222759331604j))*x_ref[0] + ((-0.533510698506+0.0773764455431j))*x_ref[1]**o + ((0.669128041183+0.124218627056j))*x_ref[1]
        arg[(3, 2, 0, 2)]=(0.0699405028001+0.13425286866j)*x[0]**o + ((-0.596390191254+0.323269791659j))*x[0] + ((-0.770845066687+0.382962054956j))*x[1]**o + ((0.674910907255-0.689064769541j))*x[1]
        ref[(3, 2, 0, 2)]=(0.0699405028001+0.13425286866j)*x_ref[0]**o + ((-0.596390191254+0.323269791659j))*x_ref[0] + ((-0.770845066687+0.382962054956j))*x_ref[1]**o + ((0.674910907255-0.689064769541j))*x_ref[1]
        arg[(3, 2, 1, 0)]=(-0.256511395694+0.375054518006j)*x[0]**o + ((-0.645997602972-0.703023052342j))*x[0] + ((-0.64657131507-0.128909860135j))*x[1]**o + ((-0.60845200464-0.908991499583j))*x[1]
        ref[(3, 2, 1, 0)]=(-0.256511395694+0.375054518006j)*x_ref[0]**o + ((-0.645997602972-0.703023052342j))*x_ref[0] + ((-0.64657131507-0.128909860135j))*x_ref[1]**o + ((-0.60845200464-0.908991499583j))*x_ref[1]
        arg[(3, 2, 1, 1)]=(0.448933918669+0.627867954818j)*x[0]**o + ((-0.714037324834+0.60494189631j))*x[0] + ((-0.393872423204-0.649183239407j))*x[1]**o + ((-0.949399208243-0.848257727241j))*x[1]
        ref[(3, 2, 1, 1)]=(0.448933918669+0.627867954818j)*x_ref[0]**o + ((-0.714037324834+0.60494189631j))*x_ref[0] + ((-0.393872423204-0.649183239407j))*x_ref[1]**o + ((-0.949399208243-0.848257727241j))*x_ref[1]
        arg[(3, 2, 1, 2)]=(-0.753085356058+0.760127488704j)*x[0]**o + ((-0.101166161148+0.000518315732045j))*x[0] + ((0.762011541566+0.829506092463j))*x[1]**o + ((0.0310601733585-0.221539353854j))*x[1]
        ref[(3, 2, 1, 2)]=(-0.753085356058+0.760127488704j)*x_ref[0]**o + ((-0.101166161148+0.000518315732045j))*x_ref[0] + ((0.762011541566+0.829506092463j))*x_ref[1]**o + ((0.0310601733585-0.221539353854j))*x_ref[1]
        arg[(3, 2, 2, 0)]=(0.282830365075-0.893052310719j)*x[0]**o + ((-0.0540980547152-0.421346615027j))*x[0] + ((0.859569790125+0.0363983831425j))*x[1]**o + ((-0.249134465648-0.623183762169j))*x[1]
        ref[(3, 2, 2, 0)]=(0.282830365075-0.893052310719j)*x_ref[0]**o + ((-0.0540980547152-0.421346615027j))*x_ref[0] + ((0.859569790125+0.0363983831425j))*x_ref[1]**o + ((-0.249134465648-0.623183762169j))*x_ref[1]
        arg[(3, 2, 2, 1)]=(0.0979761236537-0.452287743791j)*x[0]**o + ((0.174190295834-0.0911238474736j))*x[0] + ((0.76055276605-0.953961062713j))*x[1]**o + ((-0.825222703509-0.933956918029j))*x[1]
        ref[(3, 2, 2, 1)]=(0.0979761236537-0.452287743791j)*x_ref[0]**o + ((0.174190295834-0.0911238474736j))*x_ref[0] + ((0.76055276605-0.953961062713j))*x_ref[1]**o + ((-0.825222703509-0.933956918029j))*x_ref[1]
        arg[(3, 2, 2, 2)]=(0.908296375871-0.32746052669j)*x[0]**o + ((-0.635020053947-0.185280341661j))*x[0] + ((0.342672313577+0.0250859833543j))*x[1]**o + ((0.0202892965586-0.292508235512j))*x[1]
        ref[(3, 2, 2, 2)]=(0.908296375871-0.32746052669j)*x_ref[0]**o + ((-0.635020053947-0.185280341661j))*x_ref[0] + ((0.342672313577+0.0250859833543j))*x_ref[1]**o + ((0.0202892965586-0.292508235512j))*x_ref[1]
        arg[(3, 2, 3, 0)]=(0.315849826189-0.590185744477j)*x[0]**o + ((0.68128770738-0.258234496988j))*x[0] + ((-0.0516572130598+0.0206566342075j))*x[1]**o + ((0.302779023484+0.341487871362j))*x[1]
        ref[(3, 2, 3, 0)]=(0.315849826189-0.590185744477j)*x_ref[0]**o + ((0.68128770738-0.258234496988j))*x_ref[0] + ((-0.0516572130598+0.0206566342075j))*x_ref[1]**o + ((0.302779023484+0.341487871362j))*x_ref[1]
        arg[(3, 2, 3, 1)]=(0.837823203772+0.401640638149j)*x[0]**o + ((-0.401073487931+0.0873737891999j))*x[0] + ((-0.593345715862+0.680105373826j))*x[1]**o + ((-0.649778501418-0.819357178785j))*x[1]
        ref[(3, 2, 3, 1)]=(0.837823203772+0.401640638149j)*x_ref[0]**o + ((-0.401073487931+0.0873737891999j))*x_ref[0] + ((-0.593345715862+0.680105373826j))*x_ref[1]**o + ((-0.649778501418-0.819357178785j))*x_ref[1]
        arg[(3, 2, 3, 2)]=(0.345167448669-0.886847024609j)*x[0]**o + ((0.686013417848-0.306656379146j))*x[0] + ((-0.675621483941+0.170079288217j))*x[1]**o + ((-0.647657341778+0.432197835517j))*x[1]
        ref[(3, 2, 3, 2)]=(0.345167448669-0.886847024609j)*x_ref[0]**o + ((0.686013417848-0.306656379146j))*x_ref[0] + ((-0.675621483941+0.170079288217j))*x_ref[1]**o + ((-0.647657341778+0.432197835517j))*x_ref[1]
        arg[(3, 3, 0, 0)]=(-0.968954366826-0.962070288884j)*x[0]**o + ((0.205120153329-0.496197319386j))*x[0] + ((0.24499066012+0.503766382864j))*x[1]**o + ((0.667238082854-0.0352473724474j))*x[1]
        ref[(3, 3, 0, 0)]=(-0.968954366826-0.962070288884j)*x_ref[0]**o + ((0.205120153329-0.496197319386j))*x_ref[0] + ((0.24499066012+0.503766382864j))*x_ref[1]**o + ((0.667238082854-0.0352473724474j))*x_ref[1]
        arg[(3, 3, 0, 1)]=(-0.581632902817+0.331770549938j)*x[0]**o + ((0.26676788981-0.896122260344j))*x[0] + ((0.766602010626+0.4369121728j))*x[1]**o + ((0.892565085875-0.819599429095j))*x[1]
        ref[(3, 3, 0, 1)]=(-0.581632902817+0.331770549938j)*x_ref[0]**o + ((0.26676788981-0.896122260344j))*x_ref[0] + ((0.766602010626+0.4369121728j))*x_ref[1]**o + ((0.892565085875-0.819599429095j))*x_ref[1]
        arg[(3, 3, 0, 2)]=(0.244706622112-0.820221001951j)*x[0]**o + ((0.310974055646+0.0807644592743j))*x[0] + ((0.770844747955-0.655754052974j))*x[1]**o + ((-0.0282908820222+0.896874407467j))*x[1]
        ref[(3, 3, 0, 2)]=(0.244706622112-0.820221001951j)*x_ref[0]**o + ((0.310974055646+0.0807644592743j))*x_ref[0] + ((0.770844747955-0.655754052974j))*x_ref[1]**o + ((-0.0282908820222+0.896874407467j))*x_ref[1]
        arg[(3, 3, 1, 0)]=(-0.803397847582+0.350527217168j)*x[0]**o + ((-0.716021438345-0.833661262695j))*x[0] + ((0.556516778739-0.995387072541j))*x[1]**o + ((-0.452437557524+0.378899504269j))*x[1]
        ref[(3, 3, 1, 0)]=(-0.803397847582+0.350527217168j)*x_ref[0]**o + ((-0.716021438345-0.833661262695j))*x_ref[0] + ((0.556516778739-0.995387072541j))*x_ref[1]**o + ((-0.452437557524+0.378899504269j))*x_ref[1]
        arg[(3, 3, 1, 1)]=(-0.850082302007-0.219956575632j)*x[0]**o + ((0.412000382693-0.349753926097j))*x[0] + ((0.755933875248-0.675220816254j))*x[1]**o + ((-0.124296142023-0.626455693551j))*x[1]
        ref[(3, 3, 1, 1)]=(-0.850082302007-0.219956575632j)*x_ref[0]**o + ((0.412000382693-0.349753926097j))*x_ref[0] + ((0.755933875248-0.675220816254j))*x_ref[1]**o + ((-0.124296142023-0.626455693551j))*x_ref[1]
        arg[(3, 3, 1, 2)]=(0.547664548168+0.12457979489j)*x[0]**o + ((-0.695145457502-0.378545839638j))*x[0] + ((0.303870802866+0.416411022613j))*x[1]**o + ((-0.34970306565-0.569029355682j))*x[1]
        ref[(3, 3, 1, 2)]=(0.547664548168+0.12457979489j)*x_ref[0]**o + ((-0.695145457502-0.378545839638j))*x_ref[0] + ((0.303870802866+0.416411022613j))*x_ref[1]**o + ((-0.34970306565-0.569029355682j))*x_ref[1]
        arg[(3, 3, 2, 0)]=(-0.742556312621+0.338920577426j)*x[0]**o + ((-0.462364389773+0.00513448465991j))*x[0] + ((0.541778430071+0.963699408185j))*x[1]**o + ((0.516130553931-0.818731100794j))*x[1]
        ref[(3, 3, 2, 0)]=(-0.742556312621+0.338920577426j)*x_ref[0]**o + ((-0.462364389773+0.00513448465991j))*x_ref[0] + ((0.541778430071+0.963699408185j))*x_ref[1]**o + ((0.516130553931-0.818731100794j))*x_ref[1]
        arg[(3, 3, 2, 1)]=(0.828472903962-0.145862369916j)*x[0]**o + ((-0.715554311374-0.386934230215j))*x[0] + ((-0.60471556262-0.907935167681j))*x[1]**o + ((0.139041840785+0.980570692428j))*x[1]
        ref[(3, 3, 2, 1)]=(0.828472903962-0.145862369916j)*x_ref[0]**o + ((-0.715554311374-0.386934230215j))*x_ref[0] + ((-0.60471556262-0.907935167681j))*x_ref[1]**o + ((0.139041840785+0.980570692428j))*x_ref[1]
        arg[(3, 3, 2, 2)]=(-0.842366193618+0.867055207833j)*x[0]**o + ((-0.370155165438+0.962185467985j))*x[0] + ((0.613265368621+0.541663115655j))*x[1]**o + ((0.268961464241+0.338684070232j))*x[1]
        ref[(3, 3, 2, 2)]=(-0.842366193618+0.867055207833j)*x_ref[0]**o + ((-0.370155165438+0.962185467985j))*x_ref[0] + ((0.613265368621+0.541663115655j))*x_ref[1]**o + ((0.268961464241+0.338684070232j))*x_ref[1]
        arg[(3, 3, 3, 0)]=(0.469841905774+0.164923856151j)*x[0]**o + ((-0.246545686915-0.951825627997j))*x[0] + ((0.9186458116+0.118051485411j))*x[1]**o + ((0.7906214985+0.384463242815j))*x[1]
        ref[(3, 3, 3, 0)]=(0.469841905774+0.164923856151j)*x_ref[0]**o + ((-0.246545686915-0.951825627997j))*x_ref[0] + ((0.9186458116+0.118051485411j))*x_ref[1]**o + ((0.7906214985+0.384463242815j))*x_ref[1]
        arg[(3, 3, 3, 1)]=(-0.77295265422+0.970962041647j)*x[0]**o + ((-0.888475467203+0.120332485311j))*x[0] + ((0.426441399906-0.881873322373j))*x[1]**o + ((0.77200728193-0.679794197008j))*x[1]
        ref[(3, 3, 3, 1)]=(-0.77295265422+0.970962041647j)*x_ref[0]**o + ((-0.888475467203+0.120332485311j))*x_ref[0] + ((0.426441399906-0.881873322373j))*x_ref[1]**o + ((0.77200728193-0.679794197008j))*x_ref[1]
        arg[(3, 3, 3, 2)]=(0.320953349686-0.177042718888j)*x[0]**o + ((-0.389685719712-0.92477091507j))*x[0] + ((-0.0283951243763-0.921626927168j))*x[1]**o + ((-0.190368162993-0.603346288014j))*x[1]
        ref[(3, 3, 3, 2)]=(0.320953349686-0.177042718888j)*x_ref[0]**o + ((-0.389685719712-0.92477091507j))*x_ref[0] + ((-0.0283951243763-0.921626927168j))*x_ref[1]**o + ((-0.190368162993-0.603346288014j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.793454924223-0.061124725031j)*x[2]**o + ((0.459455833733-0.337048092481j))*x[2]
            ref[(0, 0, 0, 0)]+=(-0.793454924223-0.061124725031j)*x_ref[2]**o + ((0.459455833733-0.337048092481j))*x_ref[2]
            arg[(0, 0, 0, 1)]+=(-0.296070659043-0.647384883412j)*x[2]**o + ((0.063617089243-0.452823141372j))*x[2]
            ref[(0, 0, 0, 1)]+=(-0.296070659043-0.647384883412j)*x_ref[2]**o + ((0.063617089243-0.452823141372j))*x_ref[2]
            arg[(0, 0, 0, 2)]+=(-0.037202882434-0.15255303366j)*x[2]**o + ((0.147719855823-0.761870538706j))*x[2]
            ref[(0, 0, 0, 2)]+=(-0.037202882434-0.15255303366j)*x_ref[2]**o + ((0.147719855823-0.761870538706j))*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.416053719766+0.658841472464j)*x[2]**o + ((-0.845151084596+0.484958637706j))*x[2]
            ref[(0, 0, 1, 0)]+=(-0.416053719766+0.658841472464j)*x_ref[2]**o + ((-0.845151084596+0.484958637706j))*x_ref[2]
            arg[(0, 0, 1, 1)]+=(0.00724123181422-0.848914558172j)*x[2]**o + ((-0.465062725024+0.424206988158j))*x[2]
            ref[(0, 0, 1, 1)]+=(0.00724123181422-0.848914558172j)*x_ref[2]**o + ((-0.465062725024+0.424206988158j))*x_ref[2]
            arg[(0, 0, 1, 2)]+=(-0.264631608201+0.712629865029j)*x[2]**o + ((-0.481274206705-0.522493905675j))*x[2]
            ref[(0, 0, 1, 2)]+=(-0.264631608201+0.712629865029j)*x_ref[2]**o + ((-0.481274206705-0.522493905675j))*x_ref[2]
            arg[(0, 0, 2, 0)]+=(-0.769063241253-0.048164752186j)*x[2]**o + ((-0.999394372225-0.508281933154j))*x[2]
            ref[(0, 0, 2, 0)]+=(-0.769063241253-0.048164752186j)*x_ref[2]**o + ((-0.999394372225-0.508281933154j))*x_ref[2]
            arg[(0, 0, 2, 1)]+=(-0.971474047819-0.361520233383j)*x[2]**o + ((0.246535101978+0.9843907443j))*x[2]
            ref[(0, 0, 2, 1)]+=(-0.971474047819-0.361520233383j)*x_ref[2]**o + ((0.246535101978+0.9843907443j))*x_ref[2]
            arg[(0, 0, 2, 2)]+=(-0.13535217688-0.369544775273j)*x[2]**o + ((0.0637329773071+0.392283073359j))*x[2]
            ref[(0, 0, 2, 2)]+=(-0.13535217688-0.369544775273j)*x_ref[2]**o + ((0.0637329773071+0.392283073359j))*x_ref[2]
            arg[(0, 0, 3, 0)]+=(-0.113778991129-0.764052293334j)*x[2]**o + ((0.6439431237+0.0353415876511j))*x[2]
            ref[(0, 0, 3, 0)]+=(-0.113778991129-0.764052293334j)*x_ref[2]**o + ((0.6439431237+0.0353415876511j))*x_ref[2]
            arg[(0, 0, 3, 1)]+=(-0.58166354852-0.490256659874j)*x[2]**o + ((-0.583340806266+0.67528664064j))*x[2]
            ref[(0, 0, 3, 1)]+=(-0.58166354852-0.490256659874j)*x_ref[2]**o + ((-0.583340806266+0.67528664064j))*x_ref[2]
            arg[(0, 0, 3, 2)]+=(0.758556112741+0.736973931496j)*x[2]**o + ((-0.106411375504-0.966470199678j))*x[2]
            ref[(0, 0, 3, 2)]+=(0.758556112741+0.736973931496j)*x_ref[2]**o + ((-0.106411375504-0.966470199678j))*x_ref[2]
            arg[(0, 1, 0, 0)]+=(0.245079658655-0.893462317064j)*x[2]**o + ((-0.91134446839+0.0656252674845j))*x[2]
            ref[(0, 1, 0, 0)]+=(0.245079658655-0.893462317064j)*x_ref[2]**o + ((-0.91134446839+0.0656252674845j))*x_ref[2]
            arg[(0, 1, 0, 1)]+=(-0.854350233521-0.352430197642j)*x[2]**o + ((0.177172100064+0.734235879051j))*x[2]
            ref[(0, 1, 0, 1)]+=(-0.854350233521-0.352430197642j)*x_ref[2]**o + ((0.177172100064+0.734235879051j))*x_ref[2]
            arg[(0, 1, 0, 2)]+=(0.963873169225+0.210134160182j)*x[2]**o + ((-0.994654359811-0.566600758492j))*x[2]
            ref[(0, 1, 0, 2)]+=(0.963873169225+0.210134160182j)*x_ref[2]**o + ((-0.994654359811-0.566600758492j))*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.949450722704+0.228790570061j)*x[2]**o + ((-0.939903772331-0.264013978922j))*x[2]
            ref[(0, 1, 1, 0)]+=(-0.949450722704+0.228790570061j)*x_ref[2]**o + ((-0.939903772331-0.264013978922j))*x_ref[2]
            arg[(0, 1, 1, 1)]+=(-0.00398769651065-0.494900667681j)*x[2]**o + ((-0.388163885731-0.554698857386j))*x[2]
            ref[(0, 1, 1, 1)]+=(-0.00398769651065-0.494900667681j)*x_ref[2]**o + ((-0.388163885731-0.554698857386j))*x_ref[2]
            arg[(0, 1, 1, 2)]+=(0.317867351522+0.567222521752j)*x[2]**o + ((0.392901220954-0.423737862483j))*x[2]
            ref[(0, 1, 1, 2)]+=(0.317867351522+0.567222521752j)*x_ref[2]**o + ((0.392901220954-0.423737862483j))*x_ref[2]
            arg[(0, 1, 2, 0)]+=(0.191363445282+0.926203574094j)*x[2]**o + ((-0.815733967639+0.163878448974j))*x[2]
            ref[(0, 1, 2, 0)]+=(0.191363445282+0.926203574094j)*x_ref[2]**o + ((-0.815733967639+0.163878448974j))*x_ref[2]
            arg[(0, 1, 2, 1)]+=(-0.924214774376+0.485779959674j)*x[2]**o + ((-0.153601452145-0.250581356299j))*x[2]
            ref[(0, 1, 2, 1)]+=(-0.924214774376+0.485779959674j)*x_ref[2]**o + ((-0.153601452145-0.250581356299j))*x_ref[2]
            arg[(0, 1, 2, 2)]+=(-0.396242751336-0.971953660493j)*x[2]**o + ((-0.57740352856-0.197852236772j))*x[2]
            ref[(0, 1, 2, 2)]+=(-0.396242751336-0.971953660493j)*x_ref[2]**o + ((-0.57740352856-0.197852236772j))*x_ref[2]
            arg[(0, 1, 3, 0)]+=(-0.849703144701-0.0862498500923j)*x[2]**o + ((0.347373859559+0.175257758761j))*x[2]
            ref[(0, 1, 3, 0)]+=(-0.849703144701-0.0862498500923j)*x_ref[2]**o + ((0.347373859559+0.175257758761j))*x_ref[2]
            arg[(0, 1, 3, 1)]+=(-0.301374936822-0.531680670958j)*x[2]**o + ((0.191259172964+0.0348980696689j))*x[2]
            ref[(0, 1, 3, 1)]+=(-0.301374936822-0.531680670958j)*x_ref[2]**o + ((0.191259172964+0.0348980696689j))*x_ref[2]
            arg[(0, 1, 3, 2)]+=(0.838403164671-0.0170479791346j)*x[2]**o + ((0.711907226868-0.0154423998197j))*x[2]
            ref[(0, 1, 3, 2)]+=(0.838403164671-0.0170479791346j)*x_ref[2]**o + ((0.711907226868-0.0154423998197j))*x_ref[2]
            arg[(0, 2, 0, 0)]+=(-0.0997223520284-0.679146260961j)*x[2]**o + ((-0.745095042909+0.688838819122j))*x[2]
            ref[(0, 2, 0, 0)]+=(-0.0997223520284-0.679146260961j)*x_ref[2]**o + ((-0.745095042909+0.688838819122j))*x_ref[2]
            arg[(0, 2, 0, 1)]+=(-0.218668269472-0.910102677832j)*x[2]**o + ((-0.654513060425-0.303595921072j))*x[2]
            ref[(0, 2, 0, 1)]+=(-0.218668269472-0.910102677832j)*x_ref[2]**o + ((-0.654513060425-0.303595921072j))*x_ref[2]
            arg[(0, 2, 0, 2)]+=(0.897873423526-0.0913971214044j)*x[2]**o + ((0.471616424119-0.115754330585j))*x[2]
            ref[(0, 2, 0, 2)]+=(0.897873423526-0.0913971214044j)*x_ref[2]**o + ((0.471616424119-0.115754330585j))*x_ref[2]
            arg[(0, 2, 1, 0)]+=(-0.789564226591+0.830044561117j)*x[2]**o + ((0.262473422254+0.87709817258j))*x[2]
            ref[(0, 2, 1, 0)]+=(-0.789564226591+0.830044561117j)*x_ref[2]**o + ((0.262473422254+0.87709817258j))*x_ref[2]
            arg[(0, 2, 1, 1)]+=(0.10868765663-0.796661971586j)*x[2]**o + ((0.292465418976-0.611407750889j))*x[2]
            ref[(0, 2, 1, 1)]+=(0.10868765663-0.796661971586j)*x_ref[2]**o + ((0.292465418976-0.611407750889j))*x_ref[2]
            arg[(0, 2, 1, 2)]+=(-0.323764996979+0.285318838914j)*x[2]**o + ((-0.319269482986+0.567945802708j))*x[2]
            ref[(0, 2, 1, 2)]+=(-0.323764996979+0.285318838914j)*x_ref[2]**o + ((-0.319269482986+0.567945802708j))*x_ref[2]
            arg[(0, 2, 2, 0)]+=(-0.953898938035-0.159993117646j)*x[2]**o + ((-0.317111417884-0.639433612694j))*x[2]
            ref[(0, 2, 2, 0)]+=(-0.953898938035-0.159993117646j)*x_ref[2]**o + ((-0.317111417884-0.639433612694j))*x_ref[2]
            arg[(0, 2, 2, 1)]+=(0.553011674507+0.515633831476j)*x[2]**o + ((-0.00793363006999-0.202753423812j))*x[2]
            ref[(0, 2, 2, 1)]+=(0.553011674507+0.515633831476j)*x_ref[2]**o + ((-0.00793363006999-0.202753423812j))*x_ref[2]
            arg[(0, 2, 2, 2)]+=(-0.290651925625+0.997736936092j)*x[2]**o + ((0.683829997125-0.0447417068291j))*x[2]
            ref[(0, 2, 2, 2)]+=(-0.290651925625+0.997736936092j)*x_ref[2]**o + ((0.683829997125-0.0447417068291j))*x_ref[2]
            arg[(0, 2, 3, 0)]+=(-0.97117141017+0.9619619165j)*x[2]**o + ((-0.740920486908+0.309856151718j))*x[2]
            ref[(0, 2, 3, 0)]+=(-0.97117141017+0.9619619165j)*x_ref[2]**o + ((-0.740920486908+0.309856151718j))*x_ref[2]
            arg[(0, 2, 3, 1)]+=(-0.835767171235+0.877950743679j)*x[2]**o + ((-0.960138053884+0.904951705653j))*x[2]
            ref[(0, 2, 3, 1)]+=(-0.835767171235+0.877950743679j)*x_ref[2]**o + ((-0.960138053884+0.904951705653j))*x_ref[2]
            arg[(0, 2, 3, 2)]+=(0.658366845439-0.891701053788j)*x[2]**o + ((0.664407747327+0.264485414509j))*x[2]
            ref[(0, 2, 3, 2)]+=(0.658366845439-0.891701053788j)*x_ref[2]**o + ((0.664407747327+0.264485414509j))*x_ref[2]
            arg[(0, 3, 0, 0)]+=(0.785503207472-0.0158063166194j)*x[2]**o + ((-0.324155904346-0.4155064848j))*x[2]
            ref[(0, 3, 0, 0)]+=(0.785503207472-0.0158063166194j)*x_ref[2]**o + ((-0.324155904346-0.4155064848j))*x_ref[2]
            arg[(0, 3, 0, 1)]+=(0.869087346276-0.627809314093j)*x[2]**o + ((0.911433627681+0.967854905454j))*x[2]
            ref[(0, 3, 0, 1)]+=(0.869087346276-0.627809314093j)*x_ref[2]**o + ((0.911433627681+0.967854905454j))*x_ref[2]
            arg[(0, 3, 0, 2)]+=(0.766859478235+0.956726319957j)*x[2]**o + ((-0.379193739448-0.542421085142j))*x[2]
            ref[(0, 3, 0, 2)]+=(0.766859478235+0.956726319957j)*x_ref[2]**o + ((-0.379193739448-0.542421085142j))*x_ref[2]
            arg[(0, 3, 1, 0)]+=(-0.404122590774+0.0784910958939j)*x[2]**o + ((-0.361106876569-0.206132532695j))*x[2]
            ref[(0, 3, 1, 0)]+=(-0.404122590774+0.0784910958939j)*x_ref[2]**o + ((-0.361106876569-0.206132532695j))*x_ref[2]
            arg[(0, 3, 1, 1)]+=(0.57712536274-0.997492396062j)*x[2]**o + ((0.963139621376+0.45126150135j))*x[2]
            ref[(0, 3, 1, 1)]+=(0.57712536274-0.997492396062j)*x_ref[2]**o + ((0.963139621376+0.45126150135j))*x_ref[2]
            arg[(0, 3, 1, 2)]+=(-0.419286204831+0.0171714046419j)*x[2]**o + ((-0.346651928268-0.819334036146j))*x[2]
            ref[(0, 3, 1, 2)]+=(-0.419286204831+0.0171714046419j)*x_ref[2]**o + ((-0.346651928268-0.819334036146j))*x_ref[2]
            arg[(0, 3, 2, 0)]+=(0.530030960942+0.0706105390142j)*x[2]**o + ((-0.704942121573+0.313402955537j))*x[2]
            ref[(0, 3, 2, 0)]+=(0.530030960942+0.0706105390142j)*x_ref[2]**o + ((-0.704942121573+0.313402955537j))*x_ref[2]
            arg[(0, 3, 2, 1)]+=(0.795055082964+0.248595163796j)*x[2]**o + ((0.730428937272+0.502092985057j))*x[2]
            ref[(0, 3, 2, 1)]+=(0.795055082964+0.248595163796j)*x_ref[2]**o + ((0.730428937272+0.502092985057j))*x_ref[2]
            arg[(0, 3, 2, 2)]+=(0.956118420077+0.623785954815j)*x[2]**o + ((-0.396826461529+0.29006309223j))*x[2]
            ref[(0, 3, 2, 2)]+=(0.956118420077+0.623785954815j)*x_ref[2]**o + ((-0.396826461529+0.29006309223j))*x_ref[2]
            arg[(0, 3, 3, 0)]+=(0.751198072933-0.855258975182j)*x[2]**o + ((-0.955389018054-0.275383480493j))*x[2]
            ref[(0, 3, 3, 0)]+=(0.751198072933-0.855258975182j)*x_ref[2]**o + ((-0.955389018054-0.275383480493j))*x_ref[2]
            arg[(0, 3, 3, 1)]+=(0.289467703992+0.309619497537j)*x[2]**o + ((-0.962403385175+0.115651551346j))*x[2]
            ref[(0, 3, 3, 1)]+=(0.289467703992+0.309619497537j)*x_ref[2]**o + ((-0.962403385175+0.115651551346j))*x_ref[2]
            arg[(0, 3, 3, 2)]+=(-0.642223267903-0.636973568978j)*x[2]**o + ((-0.425864568023-0.773245476575j))*x[2]
            ref[(0, 3, 3, 2)]+=(-0.642223267903-0.636973568978j)*x_ref[2]**o + ((-0.425864568023-0.773245476575j))*x_ref[2]
            arg[(1, 0, 0, 0)]+=(-0.623709253736-0.60435723878j)*x[2]**o + ((-0.996076241279-0.252424098883j))*x[2]
            ref[(1, 0, 0, 0)]+=(-0.623709253736-0.60435723878j)*x_ref[2]**o + ((-0.996076241279-0.252424098883j))*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.605308807437+0.805085676027j)*x[2]**o + ((-0.655565696006+0.552883697016j))*x[2]
            ref[(1, 0, 0, 1)]+=(0.605308807437+0.805085676027j)*x_ref[2]**o + ((-0.655565696006+0.552883697016j))*x_ref[2]
            arg[(1, 0, 0, 2)]+=(-0.167564665222+0.895429586344j)*x[2]**o + ((-0.958409650089+0.534008890155j))*x[2]
            ref[(1, 0, 0, 2)]+=(-0.167564665222+0.895429586344j)*x_ref[2]**o + ((-0.958409650089+0.534008890155j))*x_ref[2]
            arg[(1, 0, 1, 0)]+=(0.283188894579-0.331872235034j)*x[2]**o + ((0.208565758372+0.188973159079j))*x[2]
            ref[(1, 0, 1, 0)]+=(0.283188894579-0.331872235034j)*x_ref[2]**o + ((0.208565758372+0.188973159079j))*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.201414831682+0.0903527797068j)*x[2]**o + ((-0.870360972626+0.389977797016j))*x[2]
            ref[(1, 0, 1, 1)]+=(0.201414831682+0.0903527797068j)*x_ref[2]**o + ((-0.870360972626+0.389977797016j))*x_ref[2]
            arg[(1, 0, 1, 2)]+=(0.381225125458-0.252945707226j)*x[2]**o + ((0.497277142312-0.203989342024j))*x[2]
            ref[(1, 0, 1, 2)]+=(0.381225125458-0.252945707226j)*x_ref[2]**o + ((0.497277142312-0.203989342024j))*x_ref[2]
            arg[(1, 0, 2, 0)]+=(-0.711484918625+0.131202899329j)*x[2]**o + ((0.616382023558+0.930178084544j))*x[2]
            ref[(1, 0, 2, 0)]+=(-0.711484918625+0.131202899329j)*x_ref[2]**o + ((0.616382023558+0.930178084544j))*x_ref[2]
            arg[(1, 0, 2, 1)]+=(-0.772151745455-0.103710646438j)*x[2]**o + ((0.823121766357+0.503911255174j))*x[2]
            ref[(1, 0, 2, 1)]+=(-0.772151745455-0.103710646438j)*x_ref[2]**o + ((0.823121766357+0.503911255174j))*x_ref[2]
            arg[(1, 0, 2, 2)]+=(0.21242463113-0.94472394819j)*x[2]**o + ((0.372782949429-0.472415295013j))*x[2]
            ref[(1, 0, 2, 2)]+=(0.21242463113-0.94472394819j)*x_ref[2]**o + ((0.372782949429-0.472415295013j))*x_ref[2]
            arg[(1, 0, 3, 0)]+=(0.288988238606-0.0675418245876j)*x[2]**o + ((-0.618980177647+0.0940021090895j))*x[2]
            ref[(1, 0, 3, 0)]+=(0.288988238606-0.0675418245876j)*x_ref[2]**o + ((-0.618980177647+0.0940021090895j))*x_ref[2]
            arg[(1, 0, 3, 1)]+=(-0.915556726507+0.703103545853j)*x[2]**o + ((-0.49986705428+0.990193898897j))*x[2]
            ref[(1, 0, 3, 1)]+=(-0.915556726507+0.703103545853j)*x_ref[2]**o + ((-0.49986705428+0.990193898897j))*x_ref[2]
            arg[(1, 0, 3, 2)]+=(-0.755336046517-0.25825852584j)*x[2]**o + ((-0.0166356919586-0.818219201425j))*x[2]
            ref[(1, 0, 3, 2)]+=(-0.755336046517-0.25825852584j)*x_ref[2]**o + ((-0.0166356919586-0.818219201425j))*x_ref[2]
            arg[(1, 1, 0, 0)]+=(-0.138762043822+0.133042894611j)*x[2]**o + ((0.262709539595-0.649360242882j))*x[2]
            ref[(1, 1, 0, 0)]+=(-0.138762043822+0.133042894611j)*x_ref[2]**o + ((0.262709539595-0.649360242882j))*x_ref[2]
            arg[(1, 1, 0, 1)]+=(-0.47396021992-0.856844447182j)*x[2]**o + ((0.624193311065-0.0188350479541j))*x[2]
            ref[(1, 1, 0, 1)]+=(-0.47396021992-0.856844447182j)*x_ref[2]**o + ((0.624193311065-0.0188350479541j))*x_ref[2]
            arg[(1, 1, 0, 2)]+=(0.0986597700445-0.292385348008j)*x[2]**o + ((0.357164551011+0.397195526591j))*x[2]
            ref[(1, 1, 0, 2)]+=(0.0986597700445-0.292385348008j)*x_ref[2]**o + ((0.357164551011+0.397195526591j))*x_ref[2]
            arg[(1, 1, 1, 0)]+=(-0.601922335655+0.909828362657j)*x[2]**o + ((-0.456509023733+0.4926093111j))*x[2]
            ref[(1, 1, 1, 0)]+=(-0.601922335655+0.909828362657j)*x_ref[2]**o + ((-0.456509023733+0.4926093111j))*x_ref[2]
            arg[(1, 1, 1, 1)]+=(0.994111193956-0.579514604225j)*x[2]**o + ((0.184157701238-0.588464104088j))*x[2]
            ref[(1, 1, 1, 1)]+=(0.994111193956-0.579514604225j)*x_ref[2]**o + ((0.184157701238-0.588464104088j))*x_ref[2]
            arg[(1, 1, 1, 2)]+=(0.861617809285-0.858647421154j)*x[2]**o + ((0.807525913288+0.512007652445j))*x[2]
            ref[(1, 1, 1, 2)]+=(0.861617809285-0.858647421154j)*x_ref[2]**o + ((0.807525913288+0.512007652445j))*x_ref[2]
            arg[(1, 1, 2, 0)]+=(0.0586262850943-0.736461964375j)*x[2]**o + ((-0.402692811505-0.551327625417j))*x[2]
            ref[(1, 1, 2, 0)]+=(0.0586262850943-0.736461964375j)*x_ref[2]**o + ((-0.402692811505-0.551327625417j))*x_ref[2]
            arg[(1, 1, 2, 1)]+=(0.259900009802-0.4070979516j)*x[2]**o + ((-0.471599502394+0.237505798268j))*x[2]
            ref[(1, 1, 2, 1)]+=(0.259900009802-0.4070979516j)*x_ref[2]**o + ((-0.471599502394+0.237505798268j))*x_ref[2]
            arg[(1, 1, 2, 2)]+=(0.406690466379+0.663605718947j)*x[2]**o + ((-0.622959459875-0.985440470395j))*x[2]
            ref[(1, 1, 2, 2)]+=(0.406690466379+0.663605718947j)*x_ref[2]**o + ((-0.622959459875-0.985440470395j))*x_ref[2]
            arg[(1, 1, 3, 0)]+=(-0.479051741189-0.766751814256j)*x[2]**o + ((0.605435897639-0.995206383118j))*x[2]
            ref[(1, 1, 3, 0)]+=(-0.479051741189-0.766751814256j)*x_ref[2]**o + ((0.605435897639-0.995206383118j))*x_ref[2]
            arg[(1, 1, 3, 1)]+=(-0.939344502373-0.180524716887j)*x[2]**o + ((0.940628732249+0.0857741434537j))*x[2]
            ref[(1, 1, 3, 1)]+=(-0.939344502373-0.180524716887j)*x_ref[2]**o + ((0.940628732249+0.0857741434537j))*x_ref[2]
            arg[(1, 1, 3, 2)]+=(-0.410728119226-0.758144097256j)*x[2]**o + ((0.343151627652+0.931904473045j))*x[2]
            ref[(1, 1, 3, 2)]+=(-0.410728119226-0.758144097256j)*x_ref[2]**o + ((0.343151627652+0.931904473045j))*x_ref[2]
            arg[(1, 2, 0, 0)]+=(0.338274310298+0.93012276724j)*x[2]**o + ((0.667037606248-0.205102844638j))*x[2]
            ref[(1, 2, 0, 0)]+=(0.338274310298+0.93012276724j)*x_ref[2]**o + ((0.667037606248-0.205102844638j))*x_ref[2]
            arg[(1, 2, 0, 1)]+=(-0.607924337766-0.547258532999j)*x[2]**o + ((-0.261874122455+0.0185045354024j))*x[2]
            ref[(1, 2, 0, 1)]+=(-0.607924337766-0.547258532999j)*x_ref[2]**o + ((-0.261874122455+0.0185045354024j))*x_ref[2]
            arg[(1, 2, 0, 2)]+=(0.109836052972-0.033142280883j)*x[2]**o + ((-0.923248108259+0.891889961013j))*x[2]
            ref[(1, 2, 0, 2)]+=(0.109836052972-0.033142280883j)*x_ref[2]**o + ((-0.923248108259+0.891889961013j))*x_ref[2]
            arg[(1, 2, 1, 0)]+=(0.371462331333+0.395559067562j)*x[2]**o + ((0.128075326985-0.977072403016j))*x[2]
            ref[(1, 2, 1, 0)]+=(0.371462331333+0.395559067562j)*x_ref[2]**o + ((0.128075326985-0.977072403016j))*x_ref[2]
            arg[(1, 2, 1, 1)]+=(0.698638703271+0.327292891363j)*x[2]**o + ((0.715814015822+0.610893022058j))*x[2]
            ref[(1, 2, 1, 1)]+=(0.698638703271+0.327292891363j)*x_ref[2]**o + ((0.715814015822+0.610893022058j))*x_ref[2]
            arg[(1, 2, 1, 2)]+=(-0.327617967634-0.572247397412j)*x[2]**o + ((-0.742041672297-0.217630374059j))*x[2]
            ref[(1, 2, 1, 2)]+=(-0.327617967634-0.572247397412j)*x_ref[2]**o + ((-0.742041672297-0.217630374059j))*x_ref[2]
            arg[(1, 2, 2, 0)]+=(-0.900027250192+0.062360431719j)*x[2]**o + ((0.184795664229+0.255981609123j))*x[2]
            ref[(1, 2, 2, 0)]+=(-0.900027250192+0.062360431719j)*x_ref[2]**o + ((0.184795664229+0.255981609123j))*x_ref[2]
            arg[(1, 2, 2, 1)]+=(0.215925069874-0.00162346751587j)*x[2]**o + ((0.835134254569-0.111134930391j))*x[2]
            ref[(1, 2, 2, 1)]+=(0.215925069874-0.00162346751587j)*x_ref[2]**o + ((0.835134254569-0.111134930391j))*x_ref[2]
            arg[(1, 2, 2, 2)]+=(0.427329687288-0.202078938488j)*x[2]**o + ((0.635847811337-0.35063602398j))*x[2]
            ref[(1, 2, 2, 2)]+=(0.427329687288-0.202078938488j)*x_ref[2]**o + ((0.635847811337-0.35063602398j))*x_ref[2]
            arg[(1, 2, 3, 0)]+=(0.30606810557+0.381224366834j)*x[2]**o + ((-0.941507775143-0.787101513883j))*x[2]
            ref[(1, 2, 3, 0)]+=(0.30606810557+0.381224366834j)*x_ref[2]**o + ((-0.941507775143-0.787101513883j))*x_ref[2]
            arg[(1, 2, 3, 1)]+=(-0.768450064372-0.989802781947j)*x[2]**o + ((-0.176530659503-0.278519469771j))*x[2]
            ref[(1, 2, 3, 1)]+=(-0.768450064372-0.989802781947j)*x_ref[2]**o + ((-0.176530659503-0.278519469771j))*x_ref[2]
            arg[(1, 2, 3, 2)]+=(0.543662164714+0.474958182624j)*x[2]**o + ((0.956766504315-0.0616218878473j))*x[2]
            ref[(1, 2, 3, 2)]+=(0.543662164714+0.474958182624j)*x_ref[2]**o + ((0.956766504315-0.0616218878473j))*x_ref[2]
            arg[(1, 3, 0, 0)]+=(0.708502371488-0.720273241134j)*x[2]**o + ((-0.172472644134+0.811047459164j))*x[2]
            ref[(1, 3, 0, 0)]+=(0.708502371488-0.720273241134j)*x_ref[2]**o + ((-0.172472644134+0.811047459164j))*x_ref[2]
            arg[(1, 3, 0, 1)]+=(0.56474260808+0.756161774814j)*x[2]**o + ((-0.79015973136+0.412625574665j))*x[2]
            ref[(1, 3, 0, 1)]+=(0.56474260808+0.756161774814j)*x_ref[2]**o + ((-0.79015973136+0.412625574665j))*x_ref[2]
            arg[(1, 3, 0, 2)]+=(0.221361261313+0.339763127726j)*x[2]**o + ((-0.556667274657-0.774666343031j))*x[2]
            ref[(1, 3, 0, 2)]+=(0.221361261313+0.339763127726j)*x_ref[2]**o + ((-0.556667274657-0.774666343031j))*x_ref[2]
            arg[(1, 3, 1, 0)]+=(-0.988957738121-0.211993448266j)*x[2]**o + ((0.270906986674-0.535011096263j))*x[2]
            ref[(1, 3, 1, 0)]+=(-0.988957738121-0.211993448266j)*x_ref[2]**o + ((0.270906986674-0.535011096263j))*x_ref[2]
            arg[(1, 3, 1, 1)]+=(0.718823552964-0.854944871798j)*x[2]**o + ((0.793115278708+0.607626125119j))*x[2]
            ref[(1, 3, 1, 1)]+=(0.718823552964-0.854944871798j)*x_ref[2]**o + ((0.793115278708+0.607626125119j))*x_ref[2]
            arg[(1, 3, 1, 2)]+=(0.968331702629+0.726889824013j)*x[2]**o + ((-0.103038119544-0.669857899612j))*x[2]
            ref[(1, 3, 1, 2)]+=(0.968331702629+0.726889824013j)*x_ref[2]**o + ((-0.103038119544-0.669857899612j))*x_ref[2]
            arg[(1, 3, 2, 0)]+=(-0.944897770303-0.902971985628j)*x[2]**o + ((0.932602052116-0.585302675373j))*x[2]
            ref[(1, 3, 2, 0)]+=(-0.944897770303-0.902971985628j)*x_ref[2]**o + ((0.932602052116-0.585302675373j))*x_ref[2]
            arg[(1, 3, 2, 1)]+=(0.241853799713-0.984711733825j)*x[2]**o + ((0.832694218956+0.186441469082j))*x[2]
            ref[(1, 3, 2, 1)]+=(0.241853799713-0.984711733825j)*x_ref[2]**o + ((0.832694218956+0.186441469082j))*x_ref[2]
            arg[(1, 3, 2, 2)]+=(0.971303718847+0.676893524823j)*x[2]**o + ((-0.927992556556-0.484361027729j))*x[2]
            ref[(1, 3, 2, 2)]+=(0.971303718847+0.676893524823j)*x_ref[2]**o + ((-0.927992556556-0.484361027729j))*x_ref[2]
            arg[(1, 3, 3, 0)]+=(0.661995880732-0.850064913551j)*x[2]**o + ((-0.697496736465+0.216308638394j))*x[2]
            ref[(1, 3, 3, 0)]+=(0.661995880732-0.850064913551j)*x_ref[2]**o + ((-0.697496736465+0.216308638394j))*x_ref[2]
            arg[(1, 3, 3, 1)]+=(-0.993715499992+0.59621908731j)*x[2]**o + ((0.0214105874935+0.418955801312j))*x[2]
            ref[(1, 3, 3, 1)]+=(-0.993715499992+0.59621908731j)*x_ref[2]**o + ((0.0214105874935+0.418955801312j))*x_ref[2]
            arg[(1, 3, 3, 2)]+=(-0.842011536683+0.298704009497j)*x[2]**o + ((0.683433265245-0.372397816836j))*x[2]
            ref[(1, 3, 3, 2)]+=(-0.842011536683+0.298704009497j)*x_ref[2]**o + ((0.683433265245-0.372397816836j))*x_ref[2]
            arg[(2, 0, 0, 0)]+=(-0.608647266067+0.428037953376j)*x[2]**o + ((0.621280547536-0.364904440595j))*x[2]
            ref[(2, 0, 0, 0)]+=(-0.608647266067+0.428037953376j)*x_ref[2]**o + ((0.621280547536-0.364904440595j))*x_ref[2]
            arg[(2, 0, 0, 1)]+=(0.125202798593+0.0296752770665j)*x[2]**o + ((-0.459493754684-0.925489892688j))*x[2]
            ref[(2, 0, 0, 1)]+=(0.125202798593+0.0296752770665j)*x_ref[2]**o + ((-0.459493754684-0.925489892688j))*x_ref[2]
            arg[(2, 0, 0, 2)]+=(0.906192722548-0.211867680594j)*x[2]**o + ((0.905687531485+0.45012653782j))*x[2]
            ref[(2, 0, 0, 2)]+=(0.906192722548-0.211867680594j)*x_ref[2]**o + ((0.905687531485+0.45012653782j))*x_ref[2]
            arg[(2, 0, 1, 0)]+=(0.475277276192-0.919604350383j)*x[2]**o + ((0.839439041534-0.185104986298j))*x[2]
            ref[(2, 0, 1, 0)]+=(0.475277276192-0.919604350383j)*x_ref[2]**o + ((0.839439041534-0.185104986298j))*x_ref[2]
            arg[(2, 0, 1, 1)]+=(0.0214461561049+0.0376668529921j)*x[2]**o + ((-0.391218826736-0.668567360958j))*x[2]
            ref[(2, 0, 1, 1)]+=(0.0214461561049+0.0376668529921j)*x_ref[2]**o + ((-0.391218826736-0.668567360958j))*x_ref[2]
            arg[(2, 0, 1, 2)]+=(0.106764898713-0.725330307202j)*x[2]**o + ((-0.532989566316-0.953428668852j))*x[2]
            ref[(2, 0, 1, 2)]+=(0.106764898713-0.725330307202j)*x_ref[2]**o + ((-0.532989566316-0.953428668852j))*x_ref[2]
            arg[(2, 0, 2, 0)]+=(0.736369830716+0.613872901644j)*x[2]**o + ((-0.522364077515+0.159572927591j))*x[2]
            ref[(2, 0, 2, 0)]+=(0.736369830716+0.613872901644j)*x_ref[2]**o + ((-0.522364077515+0.159572927591j))*x_ref[2]
            arg[(2, 0, 2, 1)]+=(0.791052577127-0.769742964431j)*x[2]**o + ((-0.246088443023-0.105931693754j))*x[2]
            ref[(2, 0, 2, 1)]+=(0.791052577127-0.769742964431j)*x_ref[2]**o + ((-0.246088443023-0.105931693754j))*x_ref[2]
            arg[(2, 0, 2, 2)]+=(0.402900939538+0.855950907755j)*x[2]**o + ((-0.300913485724+0.490930385375j))*x[2]
            ref[(2, 0, 2, 2)]+=(0.402900939538+0.855950907755j)*x_ref[2]**o + ((-0.300913485724+0.490930385375j))*x_ref[2]
            arg[(2, 0, 3, 0)]+=(0.405010212863+0.475193651268j)*x[2]**o + ((-0.634747343953-0.0355085240485j))*x[2]
            ref[(2, 0, 3, 0)]+=(0.405010212863+0.475193651268j)*x_ref[2]**o + ((-0.634747343953-0.0355085240485j))*x_ref[2]
            arg[(2, 0, 3, 1)]+=(0.801203847376+0.128405128707j)*x[2]**o + ((-0.334213600164+0.487734724966j))*x[2]
            ref[(2, 0, 3, 1)]+=(0.801203847376+0.128405128707j)*x_ref[2]**o + ((-0.334213600164+0.487734724966j))*x_ref[2]
            arg[(2, 0, 3, 2)]+=(0.394479847683+0.303066375302j)*x[2]**o + ((-0.0965611957855+0.542075342355j))*x[2]
            ref[(2, 0, 3, 2)]+=(0.394479847683+0.303066375302j)*x_ref[2]**o + ((-0.0965611957855+0.542075342355j))*x_ref[2]
            arg[(2, 1, 0, 0)]+=(0.23074651096-0.362481799375j)*x[2]**o + ((0.252946696833-0.856327658667j))*x[2]
            ref[(2, 1, 0, 0)]+=(0.23074651096-0.362481799375j)*x_ref[2]**o + ((0.252946696833-0.856327658667j))*x_ref[2]
            arg[(2, 1, 0, 1)]+=(0.898653231415-0.621981162501j)*x[2]**o + ((0.629020368994-0.145132680558j))*x[2]
            ref[(2, 1, 0, 1)]+=(0.898653231415-0.621981162501j)*x_ref[2]**o + ((0.629020368994-0.145132680558j))*x_ref[2]
            arg[(2, 1, 0, 2)]+=(0.73003239962+0.893329110585j)*x[2]**o + ((0.457152423128-0.275187284621j))*x[2]
            ref[(2, 1, 0, 2)]+=(0.73003239962+0.893329110585j)*x_ref[2]**o + ((0.457152423128-0.275187284621j))*x_ref[2]
            arg[(2, 1, 1, 0)]+=(0.808930503021-0.94770805631j)*x[2]**o + ((0.737453208045-0.496533587227j))*x[2]
            ref[(2, 1, 1, 0)]+=(0.808930503021-0.94770805631j)*x_ref[2]**o + ((0.737453208045-0.496533587227j))*x_ref[2]
            arg[(2, 1, 1, 1)]+=(-0.000961169664982+0.724933464385j)*x[2]**o + ((-0.583109697585-0.00101498509366j))*x[2]
            ref[(2, 1, 1, 1)]+=(-0.000961169664982+0.724933464385j)*x_ref[2]**o + ((-0.583109697585-0.00101498509366j))*x_ref[2]
            arg[(2, 1, 1, 2)]+=(0.933086194438+0.255051468926j)*x[2]**o + ((-0.940818471931+0.290937623331j))*x[2]
            ref[(2, 1, 1, 2)]+=(0.933086194438+0.255051468926j)*x_ref[2]**o + ((-0.940818471931+0.290937623331j))*x_ref[2]
            arg[(2, 1, 2, 0)]+=(0.294000079154+0.305176114395j)*x[2]**o + ((-0.930054860628-0.735320367428j))*x[2]
            ref[(2, 1, 2, 0)]+=(0.294000079154+0.305176114395j)*x_ref[2]**o + ((-0.930054860628-0.735320367428j))*x_ref[2]
            arg[(2, 1, 2, 1)]+=(-0.481842021011-0.0863925095882j)*x[2]**o + ((0.40270641855-0.974667304678j))*x[2]
            ref[(2, 1, 2, 1)]+=(-0.481842021011-0.0863925095882j)*x_ref[2]**o + ((0.40270641855-0.974667304678j))*x_ref[2]
            arg[(2, 1, 2, 2)]+=(-0.161360279388+0.794885808755j)*x[2]**o + ((-0.897494156068-0.945047307638j))*x[2]
            ref[(2, 1, 2, 2)]+=(-0.161360279388+0.794885808755j)*x_ref[2]**o + ((-0.897494156068-0.945047307638j))*x_ref[2]
            arg[(2, 1, 3, 0)]+=(0.470998366641+0.822951168184j)*x[2]**o + ((0.672825310476-0.955333247336j))*x[2]
            ref[(2, 1, 3, 0)]+=(0.470998366641+0.822951168184j)*x_ref[2]**o + ((0.672825310476-0.955333247336j))*x_ref[2]
            arg[(2, 1, 3, 1)]+=(0.626043105143-0.19419822695j)*x[2]**o + ((-0.345239097325+0.591569622j))*x[2]
            ref[(2, 1, 3, 1)]+=(0.626043105143-0.19419822695j)*x_ref[2]**o + ((-0.345239097325+0.591569622j))*x_ref[2]
            arg[(2, 1, 3, 2)]+=(-0.983405897563-0.399466571686j)*x[2]**o + ((-0.0770867883118-0.427213366552j))*x[2]
            ref[(2, 1, 3, 2)]+=(-0.983405897563-0.399466571686j)*x_ref[2]**o + ((-0.0770867883118-0.427213366552j))*x_ref[2]
            arg[(2, 2, 0, 0)]+=(-0.0785296708395+0.585776674156j)*x[2]**o + ((-0.05036939902+0.228836641361j))*x[2]
            ref[(2, 2, 0, 0)]+=(-0.0785296708395+0.585776674156j)*x_ref[2]**o + ((-0.05036939902+0.228836641361j))*x_ref[2]
            arg[(2, 2, 0, 1)]+=(-0.524167789281+0.784330126364j)*x[2]**o + ((0.602714481934+0.298528239423j))*x[2]
            ref[(2, 2, 0, 1)]+=(-0.524167789281+0.784330126364j)*x_ref[2]**o + ((0.602714481934+0.298528239423j))*x_ref[2]
            arg[(2, 2, 0, 2)]+=(-0.183264062972-0.26744027334j)*x[2]**o + ((-0.70440339141+0.12119224913j))*x[2]
            ref[(2, 2, 0, 2)]+=(-0.183264062972-0.26744027334j)*x_ref[2]**o + ((-0.70440339141+0.12119224913j))*x_ref[2]
            arg[(2, 2, 1, 0)]+=(0.0892952040166+0.756299578996j)*x[2]**o + ((-0.818661644461+0.754577023441j))*x[2]
            ref[(2, 2, 1, 0)]+=(0.0892952040166+0.756299578996j)*x_ref[2]**o + ((-0.818661644461+0.754577023441j))*x_ref[2]
            arg[(2, 2, 1, 1)]+=(-0.907142004396+0.890470967184j)*x[2]**o + ((-0.0449586010627-0.755716073593j))*x[2]
            ref[(2, 2, 1, 1)]+=(-0.907142004396+0.890470967184j)*x_ref[2]**o + ((-0.0449586010627-0.755716073593j))*x_ref[2]
            arg[(2, 2, 1, 2)]+=(0.20637733281+0.572847379502j)*x[2]**o + ((0.211079719236+0.834119256574j))*x[2]
            ref[(2, 2, 1, 2)]+=(0.20637733281+0.572847379502j)*x_ref[2]**o + ((0.211079719236+0.834119256574j))*x_ref[2]
            arg[(2, 2, 2, 0)]+=(0.912797479332-0.790524608428j)*x[2]**o + ((-0.0802811843637-0.642476934809j))*x[2]
            ref[(2, 2, 2, 0)]+=(0.912797479332-0.790524608428j)*x_ref[2]**o + ((-0.0802811843637-0.642476934809j))*x_ref[2]
            arg[(2, 2, 2, 1)]+=(-0.995224476255-0.689286963808j)*x[2]**o + ((0.603816907129+0.408663544058j))*x[2]
            ref[(2, 2, 2, 1)]+=(-0.995224476255-0.689286963808j)*x_ref[2]**o + ((0.603816907129+0.408663544058j))*x_ref[2]
            arg[(2, 2, 2, 2)]+=(-0.965880519383+0.363442842831j)*x[2]**o + ((-0.809079999514-0.270655146293j))*x[2]
            ref[(2, 2, 2, 2)]+=(-0.965880519383+0.363442842831j)*x_ref[2]**o + ((-0.809079999514-0.270655146293j))*x_ref[2]
            arg[(2, 2, 3, 0)]+=(-0.218497024658-0.801504440425j)*x[2]**o + ((0.0175021482437-0.101791169741j))*x[2]
            ref[(2, 2, 3, 0)]+=(-0.218497024658-0.801504440425j)*x_ref[2]**o + ((0.0175021482437-0.101791169741j))*x_ref[2]
            arg[(2, 2, 3, 1)]+=(-0.21169815366+0.063333117134j)*x[2]**o + ((0.21695286086+0.135195231351j))*x[2]
            ref[(2, 2, 3, 1)]+=(-0.21169815366+0.063333117134j)*x_ref[2]**o + ((0.21695286086+0.135195231351j))*x_ref[2]
            arg[(2, 2, 3, 2)]+=(-0.846680051492+0.0429571308549j)*x[2]**o + ((0.179656770936-0.74908535894j))*x[2]
            ref[(2, 2, 3, 2)]+=(-0.846680051492+0.0429571308549j)*x_ref[2]**o + ((0.179656770936-0.74908535894j))*x_ref[2]
            arg[(2, 3, 0, 0)]+=(0.223201308631-0.762155616674j)*x[2]**o + ((-0.982025482474-0.588196505296j))*x[2]
            ref[(2, 3, 0, 0)]+=(0.223201308631-0.762155616674j)*x_ref[2]**o + ((-0.982025482474-0.588196505296j))*x_ref[2]
            arg[(2, 3, 0, 1)]+=(0.0398239169033+0.249956956833j)*x[2]**o + ((0.839323410716+0.694096768268j))*x[2]
            ref[(2, 3, 0, 1)]+=(0.0398239169033+0.249956956833j)*x_ref[2]**o + ((0.839323410716+0.694096768268j))*x_ref[2]
            arg[(2, 3, 0, 2)]+=(0.413738633818-0.861373388534j)*x[2]**o + ((-0.109100332033-0.789201008611j))*x[2]
            ref[(2, 3, 0, 2)]+=(0.413738633818-0.861373388534j)*x_ref[2]**o + ((-0.109100332033-0.789201008611j))*x_ref[2]
            arg[(2, 3, 1, 0)]+=(0.642662760149+0.978815487215j)*x[2]**o + ((-0.698022134312-0.049402940783j))*x[2]
            ref[(2, 3, 1, 0)]+=(0.642662760149+0.978815487215j)*x_ref[2]**o + ((-0.698022134312-0.049402940783j))*x_ref[2]
            arg[(2, 3, 1, 1)]+=(0.614518104589-0.52669866441j)*x[2]**o + ((-0.533286490547+0.853460441669j))*x[2]
            ref[(2, 3, 1, 1)]+=(0.614518104589-0.52669866441j)*x_ref[2]**o + ((-0.533286490547+0.853460441669j))*x_ref[2]
            arg[(2, 3, 1, 2)]+=(-0.242481800948-0.83606127136j)*x[2]**o + ((0.931817656904-0.985221279838j))*x[2]
            ref[(2, 3, 1, 2)]+=(-0.242481800948-0.83606127136j)*x_ref[2]**o + ((0.931817656904-0.985221279838j))*x_ref[2]
            arg[(2, 3, 2, 0)]+=(-0.796421057547-0.303818654128j)*x[2]**o + ((0.348926273327-0.155058343596j))*x[2]
            ref[(2, 3, 2, 0)]+=(-0.796421057547-0.303818654128j)*x_ref[2]**o + ((0.348926273327-0.155058343596j))*x_ref[2]
            arg[(2, 3, 2, 1)]+=(-0.824754676905+0.21111048801j)*x[2]**o + ((0.242429889905+0.104859163432j))*x[2]
            ref[(2, 3, 2, 1)]+=(-0.824754676905+0.21111048801j)*x_ref[2]**o + ((0.242429889905+0.104859163432j))*x_ref[2]
            arg[(2, 3, 2, 2)]+=(-0.493007686156-0.395257087597j)*x[2]**o + ((0.34951535504+0.687377718002j))*x[2]
            ref[(2, 3, 2, 2)]+=(-0.493007686156-0.395257087597j)*x_ref[2]**o + ((0.34951535504+0.687377718002j))*x_ref[2]
            arg[(2, 3, 3, 0)]+=(0.588255979279+0.431023450674j)*x[2]**o + ((0.446981309557+0.523982757128j))*x[2]
            ref[(2, 3, 3, 0)]+=(0.588255979279+0.431023450674j)*x_ref[2]**o + ((0.446981309557+0.523982757128j))*x_ref[2]
            arg[(2, 3, 3, 1)]+=(-0.129193182887+0.0406995321761j)*x[2]**o + ((-0.830307748266-0.957102358896j))*x[2]
            ref[(2, 3, 3, 1)]+=(-0.129193182887+0.0406995321761j)*x_ref[2]**o + ((-0.830307748266-0.957102358896j))*x_ref[2]
            arg[(2, 3, 3, 2)]+=(-0.769513245311-0.424864283248j)*x[2]**o + ((0.115617023805-0.949472626581j))*x[2]
            ref[(2, 3, 3, 2)]+=(-0.769513245311-0.424864283248j)*x_ref[2]**o + ((0.115617023805-0.949472626581j))*x_ref[2]
            arg[(3, 0, 0, 0)]+=(-0.946212387714+0.523798275311j)*x[2]**o + ((0.0350617460758+0.407992184187j))*x[2]
            ref[(3, 0, 0, 0)]+=(-0.946212387714+0.523798275311j)*x_ref[2]**o + ((0.0350617460758+0.407992184187j))*x_ref[2]
            arg[(3, 0, 0, 1)]+=(0.0780541040077-0.772947391338j)*x[2]**o + ((-0.747529665621-0.902977691749j))*x[2]
            ref[(3, 0, 0, 1)]+=(0.0780541040077-0.772947391338j)*x_ref[2]**o + ((-0.747529665621-0.902977691749j))*x_ref[2]
            arg[(3, 0, 0, 2)]+=(0.968303731486+0.696401169141j)*x[2]**o + ((-0.264351096201-0.764459776411j))*x[2]
            ref[(3, 0, 0, 2)]+=(0.968303731486+0.696401169141j)*x_ref[2]**o + ((-0.264351096201-0.764459776411j))*x_ref[2]
            arg[(3, 0, 1, 0)]+=(0.102621030623-0.957344200208j)*x[2]**o + ((-0.744915186474+0.11872896206j))*x[2]
            ref[(3, 0, 1, 0)]+=(0.102621030623-0.957344200208j)*x_ref[2]**o + ((-0.744915186474+0.11872896206j))*x_ref[2]
            arg[(3, 0, 1, 1)]+=(0.678137258388+0.0632884037931j)*x[2]**o + ((0.701780826025-0.838527967921j))*x[2]
            ref[(3, 0, 1, 1)]+=(0.678137258388+0.0632884037931j)*x_ref[2]**o + ((0.701780826025-0.838527967921j))*x_ref[2]
            arg[(3, 0, 1, 2)]+=(0.0352675049219+0.504574458707j)*x[2]**o + ((0.224636512301-0.972373007993j))*x[2]
            ref[(3, 0, 1, 2)]+=(0.0352675049219+0.504574458707j)*x_ref[2]**o + ((0.224636512301-0.972373007993j))*x_ref[2]
            arg[(3, 0, 2, 0)]+=(0.801586673892-0.30221608967j)*x[2]**o + ((-0.86218821108-0.222025427209j))*x[2]
            ref[(3, 0, 2, 0)]+=(0.801586673892-0.30221608967j)*x_ref[2]**o + ((-0.86218821108-0.222025427209j))*x_ref[2]
            arg[(3, 0, 2, 1)]+=(-0.5982818305+0.0786604130505j)*x[2]**o + ((-0.837260357025-0.281195389358j))*x[2]
            ref[(3, 0, 2, 1)]+=(-0.5982818305+0.0786604130505j)*x_ref[2]**o + ((-0.837260357025-0.281195389358j))*x_ref[2]
            arg[(3, 0, 2, 2)]+=(-0.201809689083+0.279020039145j)*x[2]**o + ((-0.306232979972-0.480363620903j))*x[2]
            ref[(3, 0, 2, 2)]+=(-0.201809689083+0.279020039145j)*x_ref[2]**o + ((-0.306232979972-0.480363620903j))*x_ref[2]
            arg[(3, 0, 3, 0)]+=(0.455630681025+0.262950322248j)*x[2]**o + ((0.192607439485+0.136339455657j))*x[2]
            ref[(3, 0, 3, 0)]+=(0.455630681025+0.262950322248j)*x_ref[2]**o + ((0.192607439485+0.136339455657j))*x_ref[2]
            arg[(3, 0, 3, 1)]+=(0.443697331918-0.85508317865j)*x[2]**o + ((-0.860526803324+0.219312205584j))*x[2]
            ref[(3, 0, 3, 1)]+=(0.443697331918-0.85508317865j)*x_ref[2]**o + ((-0.860526803324+0.219312205584j))*x_ref[2]
            arg[(3, 0, 3, 2)]+=(-0.271794601367-0.560221469016j)*x[2]**o + ((-0.47078166488-0.033553874218j))*x[2]
            ref[(3, 0, 3, 2)]+=(-0.271794601367-0.560221469016j)*x_ref[2]**o + ((-0.47078166488-0.033553874218j))*x_ref[2]
            arg[(3, 1, 0, 0)]+=(-0.0257653492577+0.306447545895j)*x[2]**o + ((-0.263333463087+0.13277101896j))*x[2]
            ref[(3, 1, 0, 0)]+=(-0.0257653492577+0.306447545895j)*x_ref[2]**o + ((-0.263333463087+0.13277101896j))*x_ref[2]
            arg[(3, 1, 0, 1)]+=(0.720573582683-0.102030580206j)*x[2]**o + ((0.354672875369-0.364762834688j))*x[2]
            ref[(3, 1, 0, 1)]+=(0.720573582683-0.102030580206j)*x_ref[2]**o + ((0.354672875369-0.364762834688j))*x_ref[2]
            arg[(3, 1, 0, 2)]+=(-0.0200368839926-0.57538868869j)*x[2]**o + ((-0.188488618901-0.806309999798j))*x[2]
            ref[(3, 1, 0, 2)]+=(-0.0200368839926-0.57538868869j)*x_ref[2]**o + ((-0.188488618901-0.806309999798j))*x_ref[2]
            arg[(3, 1, 1, 0)]+=(0.971634223532-0.727991360945j)*x[2]**o + ((-0.946773971353+0.208530986434j))*x[2]
            ref[(3, 1, 1, 0)]+=(0.971634223532-0.727991360945j)*x_ref[2]**o + ((-0.946773971353+0.208530986434j))*x_ref[2]
            arg[(3, 1, 1, 1)]+=(-0.77742109403+0.339842565036j)*x[2]**o + ((-0.126418826052+0.444541772092j))*x[2]
            ref[(3, 1, 1, 1)]+=(-0.77742109403+0.339842565036j)*x_ref[2]**o + ((-0.126418826052+0.444541772092j))*x_ref[2]
            arg[(3, 1, 1, 2)]+=(0.483872556029-0.396658375576j)*x[2]**o + ((0.0223839998417+0.850784946668j))*x[2]
            ref[(3, 1, 1, 2)]+=(0.483872556029-0.396658375576j)*x_ref[2]**o + ((0.0223839998417+0.850784946668j))*x_ref[2]
            arg[(3, 1, 2, 0)]+=(0.257585898266-0.982766977387j)*x[2]**o + ((-0.0213051368254-0.246609417563j))*x[2]
            ref[(3, 1, 2, 0)]+=(0.257585898266-0.982766977387j)*x_ref[2]**o + ((-0.0213051368254-0.246609417563j))*x_ref[2]
            arg[(3, 1, 2, 1)]+=(0.695159335118+0.207382606338j)*x[2]**o + ((-0.608029831068-0.429089520762j))*x[2]
            ref[(3, 1, 2, 1)]+=(0.695159335118+0.207382606338j)*x_ref[2]**o + ((-0.608029831068-0.429089520762j))*x_ref[2]
            arg[(3, 1, 2, 2)]+=(-0.574138152813-0.940026080796j)*x[2]**o + ((-0.635494306902+0.635990525458j))*x[2]
            ref[(3, 1, 2, 2)]+=(-0.574138152813-0.940026080796j)*x_ref[2]**o + ((-0.635494306902+0.635990525458j))*x_ref[2]
            arg[(3, 1, 3, 0)]+=(-0.0804440519541+0.781536690467j)*x[2]**o + ((0.503058065228-0.149966792129j))*x[2]
            ref[(3, 1, 3, 0)]+=(-0.0804440519541+0.781536690467j)*x_ref[2]**o + ((0.503058065228-0.149966792129j))*x_ref[2]
            arg[(3, 1, 3, 1)]+=(0.425022013089+0.113446962102j)*x[2]**o + ((-0.593025730439+0.252735605128j))*x[2]
            ref[(3, 1, 3, 1)]+=(0.425022013089+0.113446962102j)*x_ref[2]**o + ((-0.593025730439+0.252735605128j))*x_ref[2]
            arg[(3, 1, 3, 2)]+=(0.302682283043+0.389067186635j)*x[2]**o + ((-0.630818763386+0.0653381307074j))*x[2]
            ref[(3, 1, 3, 2)]+=(0.302682283043+0.389067186635j)*x_ref[2]**o + ((-0.630818763386+0.0653381307074j))*x_ref[2]
            arg[(3, 2, 0, 0)]+=(0.149313209572+0.107814311954j)*x[2]**o + ((0.94435114775-0.543895342949j))*x[2]
            ref[(3, 2, 0, 0)]+=(0.149313209572+0.107814311954j)*x_ref[2]**o + ((0.94435114775-0.543895342949j))*x_ref[2]
            arg[(3, 2, 0, 1)]+=(-0.688871439756+0.701591238513j)*x[2]**o + ((-0.878092333724-0.432420649164j))*x[2]
            ref[(3, 2, 0, 1)]+=(-0.688871439756+0.701591238513j)*x_ref[2]**o + ((-0.878092333724-0.432420649164j))*x_ref[2]
            arg[(3, 2, 0, 2)]+=(-0.173886201912+0.0959546245644j)*x[2]**o + ((-0.617082421286-0.847267623637j))*x[2]
            ref[(3, 2, 0, 2)]+=(-0.173886201912+0.0959546245644j)*x_ref[2]**o + ((-0.617082421286-0.847267623637j))*x_ref[2]
            arg[(3, 2, 1, 0)]+=(-0.481730614197-0.507059474408j)*x[2]**o + ((-0.770530709887-0.0518177187411j))*x[2]
            ref[(3, 2, 1, 0)]+=(-0.481730614197-0.507059474408j)*x_ref[2]**o + ((-0.770530709887-0.0518177187411j))*x_ref[2]
            arg[(3, 2, 1, 1)]+=(-0.375738415888+0.18016109269j)*x[2]**o + ((-0.371812454253-0.39326762195j))*x[2]
            ref[(3, 2, 1, 1)]+=(-0.375738415888+0.18016109269j)*x_ref[2]**o + ((-0.371812454253-0.39326762195j))*x_ref[2]
            arg[(3, 2, 1, 2)]+=(0.0341244544144+0.611415906846j)*x[2]**o + ((-0.109359456366+0.432597125627j))*x[2]
            ref[(3, 2, 1, 2)]+=(0.0341244544144+0.611415906846j)*x_ref[2]**o + ((-0.109359456366+0.432597125627j))*x_ref[2]
            arg[(3, 2, 2, 0)]+=(0.29196238231-0.535085004483j)*x[2]**o + ((-0.961102320969-0.57184427694j))*x[2]
            ref[(3, 2, 2, 0)]+=(0.29196238231-0.535085004483j)*x_ref[2]**o + ((-0.961102320969-0.57184427694j))*x_ref[2]
            arg[(3, 2, 2, 1)]+=(0.433247797883+0.494299898883j)*x[2]**o + ((0.234160873342+0.835275122272j))*x[2]
            ref[(3, 2, 2, 1)]+=(0.433247797883+0.494299898883j)*x_ref[2]**o + ((0.234160873342+0.835275122272j))*x_ref[2]
            arg[(3, 2, 2, 2)]+=(0.32981865579+0.340905723982j)*x[2]**o + ((-0.517360228915+0.48658654118j))*x[2]
            ref[(3, 2, 2, 2)]+=(0.32981865579+0.340905723982j)*x_ref[2]**o + ((-0.517360228915+0.48658654118j))*x_ref[2]
            arg[(3, 2, 3, 0)]+=(0.381737738397+0.180715417497j)*x[2]**o + ((0.839025662897+0.412780871312j))*x[2]
            ref[(3, 2, 3, 0)]+=(0.381737738397+0.180715417497j)*x_ref[2]**o + ((0.839025662897+0.412780871312j))*x_ref[2]
            arg[(3, 2, 3, 1)]+=(0.519312346594-0.753437465877j)*x[2]**o + ((-0.679436123053-0.163124255249j))*x[2]
            ref[(3, 2, 3, 1)]+=(0.519312346594-0.753437465877j)*x_ref[2]**o + ((-0.679436123053-0.163124255249j))*x_ref[2]
            arg[(3, 2, 3, 2)]+=(-0.476165216247+0.25777462975j)*x[2]**o + ((-0.790369684063+0.268617562596j))*x[2]
            ref[(3, 2, 3, 2)]+=(-0.476165216247+0.25777462975j)*x_ref[2]**o + ((-0.790369684063+0.268617562596j))*x_ref[2]
            arg[(3, 3, 0, 0)]+=(-0.699542306729+0.694070015748j)*x[2]**o + ((0.625648537944+0.409647344382j))*x[2]
            ref[(3, 3, 0, 0)]+=(-0.699542306729+0.694070015748j)*x_ref[2]**o + ((0.625648537944+0.409647344382j))*x_ref[2]
            arg[(3, 3, 0, 1)]+=(0.659022819886-0.763605988398j)*x[2]**o + ((0.41657898761-0.720564697036j))*x[2]
            ref[(3, 3, 0, 1)]+=(0.659022819886-0.763605988398j)*x_ref[2]**o + ((0.41657898761-0.720564697036j))*x_ref[2]
            arg[(3, 3, 0, 2)]+=(-0.769348282794-0.332527582636j)*x[2]**o + ((-0.0619621110651+0.948256882124j))*x[2]
            ref[(3, 3, 0, 2)]+=(-0.769348282794-0.332527582636j)*x_ref[2]**o + ((-0.0619621110651+0.948256882124j))*x_ref[2]
            arg[(3, 3, 1, 0)]+=(-0.240533752108+0.924259178036j)*x[2]**o + ((-0.497788459913+0.132747638719j))*x[2]
            ref[(3, 3, 1, 0)]+=(-0.240533752108+0.924259178036j)*x_ref[2]**o + ((-0.497788459913+0.132747638719j))*x_ref[2]
            arg[(3, 3, 1, 1)]+=(-0.175808308662-0.639004491071j)*x[2]**o + ((-0.58398775364-0.852816582065j))*x[2]
            ref[(3, 3, 1, 1)]+=(-0.175808308662-0.639004491071j)*x_ref[2]**o + ((-0.58398775364-0.852816582065j))*x_ref[2]
            arg[(3, 3, 1, 2)]+=(0.752390119059-0.256023919369j)*x[2]**o + ((-0.170306263561+0.997751366798j))*x[2]
            ref[(3, 3, 1, 2)]+=(0.752390119059-0.256023919369j)*x_ref[2]**o + ((-0.170306263561+0.997751366798j))*x_ref[2]
            arg[(3, 3, 2, 0)]+=(-0.958554447335-0.783032329752j)*x[2]**o + ((0.254095056056-0.411261867382j))*x[2]
            ref[(3, 3, 2, 0)]+=(-0.958554447335-0.783032329752j)*x_ref[2]**o + ((0.254095056056-0.411261867382j))*x_ref[2]
            arg[(3, 3, 2, 1)]+=(-0.337619169632-0.259981777701j)*x[2]**o + ((0.0132295173849-0.435177920186j))*x[2]
            ref[(3, 3, 2, 1)]+=(-0.337619169632-0.259981777701j)*x_ref[2]**o + ((0.0132295173849-0.435177920186j))*x_ref[2]
            arg[(3, 3, 2, 2)]+=(0.711468638439+0.02049301113j)*x[2]**o + ((-0.792006441198-0.120033021124j))*x[2]
            ref[(3, 3, 2, 2)]+=(0.711468638439+0.02049301113j)*x_ref[2]**o + ((-0.792006441198-0.120033021124j))*x_ref[2]
            arg[(3, 3, 3, 0)]+=(0.106708803888+0.514553124808j)*x[2]**o + ((0.0981468886747-0.429278553106j))*x[2]
            ref[(3, 3, 3, 0)]+=(0.106708803888+0.514553124808j)*x_ref[2]**o + ((0.0981468886747-0.429278553106j))*x_ref[2]
            arg[(3, 3, 3, 1)]+=(0.853581174234+0.698437755938j)*x[2]**o + ((0.555424665254-0.847014829075j))*x[2]
            ref[(3, 3, 3, 1)]+=(0.853581174234+0.698437755938j)*x_ref[2]**o + ((0.555424665254-0.847014829075j))*x_ref[2]
            arg[(3, 3, 3, 2)]+=(0.438700845343-0.345457056326j)*x[2]**o + ((0.0545497793905-0.120545145325j))*x[2]
            ref[(3, 3, 3, 2)]+=(0.438700845343-0.345457056326j)*x_ref[2]**o + ((0.0545497793905-0.120545145325j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 4, 4, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ContinuousFunction_rank0(self):
        """
        tests interpolation of rank 0 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.797228160776-0.920215164001j)*x[0]**o + ((0.461330640959+0.258142429462j))*x[0] + ((0.570387460239+0.195643787475j))*x[1]**o + ((-0.470088235996+0.650572229349j))*x[1]
        ref=(-0.797228160776-0.920215164001j)*x_ref[0]**o + ((0.461330640959+0.258142429462j))*x_ref[0] + ((0.570387460239+0.195643787475j))*x_ref[1]**o + ((-0.470088235996+0.650572229349j))*x_ref[1]
        if dim==3:
            arg+=((0.317261863965-0.984206029504j))*x[2]**o + ((-0.753770728819+0.796816068739j))*x[2]
            ref+=((0.317261863965-0.984206029504j))*x_ref[2]**o + ((-0.753770728819+0.796816068739j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ContinuousFunction_rank1(self):
        """
        tests interpolation of rank 1 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,),w_ref)
        arg[(0,)]=(0.548416293908-0.987851078266j)*x[0]**o + ((-0.98888005338-0.789990571977j))*x[0] + ((0.430876063775-0.147681768087j))*x[1]**o + ((-0.459574102353-0.85668645874j))*x[1]
        ref[(0,)]=(0.548416293908-0.987851078266j)*x_ref[0]**o + ((-0.98888005338-0.789990571977j))*x_ref[0] + ((0.430876063775-0.147681768087j))*x_ref[1]**o + ((-0.459574102353-0.85668645874j))*x_ref[1]
        arg[(1,)]=(0.265739870052+0.674564986511j)*x[0]**o + ((-0.589925458023-0.955862615754j))*x[0] + ((-0.37228939519+0.428784924513j))*x[1]**o + ((0.913602149178-0.0376290600724j))*x[1]
        ref[(1,)]=(0.265739870052+0.674564986511j)*x_ref[0]**o + ((-0.589925458023-0.955862615754j))*x_ref[0] + ((-0.37228939519+0.428784924513j))*x_ref[1]**o + ((0.913602149178-0.0376290600724j))*x_ref[1]
        arg[(2,)]=(0.574277594879+0.473791925843j)*x[0]**o + ((0.385189347524-0.757879527241j))*x[0] + ((0.712392317456+0.930897952639j))*x[1]**o + ((0.488470496576+0.905317471807j))*x[1]
        ref[(2,)]=(0.574277594879+0.473791925843j)*x_ref[0]**o + ((0.385189347524-0.757879527241j))*x_ref[0] + ((0.712392317456+0.930897952639j))*x_ref[1]**o + ((0.488470496576+0.905317471807j))*x_ref[1]
        arg[(3,)]=(-0.0628596171317+0.426730896758j)*x[0]**o + ((-0.462058343127+0.964968219675j))*x[0] + ((0.0637587070778-0.306281729474j))*x[1]**o + ((-0.205491191507+0.375145632452j))*x[1]
        ref[(3,)]=(-0.0628596171317+0.426730896758j)*x_ref[0]**o + ((-0.462058343127+0.964968219675j))*x_ref[0] + ((0.0637587070778-0.306281729474j))*x_ref[1]**o + ((-0.205491191507+0.375145632452j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.425723940025+0.740466426302j)*x[2]**o + ((-0.0229336899829+0.589755274535j))*x[2]
            ref[(0,)]+=(-0.425723940025+0.740466426302j)*x_ref[2]**o + ((-0.0229336899829+0.589755274535j))*x_ref[2]
            arg[(1,)]+=(0.149882365097-0.354177766177j)*x[2]**o + ((-0.167259806701+0.182168280863j))*x[2]
            ref[(1,)]+=(0.149882365097-0.354177766177j)*x_ref[2]**o + ((-0.167259806701+0.182168280863j))*x_ref[2]
            arg[(2,)]+=(0.488547538948+0.0218281670123j)*x[2]**o + ((0.963941738343-0.206563193552j))*x[2]
            ref[(2,)]+=(0.488547538948+0.0218281670123j)*x_ref[2]**o + ((0.963941738343-0.206563193552j))*x_ref[2]
            arg[(3,)]+=(0.516464494437-0.979436825574j)*x[2]**o + ((-0.46554585419-0.129213139141j))*x[2]
            ref[(3,)]+=(0.516464494437-0.979436825574j)*x_ref[2]**o + ((-0.46554585419-0.129213139141j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ContinuousFunction_rank2(self):
        """
        tests interpolation of rank 2 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3),w)
        ref = Data(0,(2, 3),w_ref)
        arg[(0, 0)]=(-0.299081821452-0.798034307793j)*x[0]**o + ((-0.631434030476+0.0936299601035j))*x[0] + ((0.302310545302-0.80624147386j))*x[1]**o + ((0.0391115261146+0.155859149809j))*x[1]
        ref[(0, 0)]=(-0.299081821452-0.798034307793j)*x_ref[0]**o + ((-0.631434030476+0.0936299601035j))*x_ref[0] + ((0.302310545302-0.80624147386j))*x_ref[1]**o + ((0.0391115261146+0.155859149809j))*x_ref[1]
        arg[(0, 1)]=(0.0300383834531-0.290453580515j)*x[0]**o + ((-0.16699101239-0.524757459192j))*x[0] + ((0.844802955319-0.0133422530254j))*x[1]**o + ((-0.232947381937+0.505253501515j))*x[1]
        ref[(0, 1)]=(0.0300383834531-0.290453580515j)*x_ref[0]**o + ((-0.16699101239-0.524757459192j))*x_ref[0] + ((0.844802955319-0.0133422530254j))*x_ref[1]**o + ((-0.232947381937+0.505253501515j))*x_ref[1]
        arg[(0, 2)]=(0.148668000266+0.0636063569579j)*x[0]**o + ((-0.801119774229-0.680049099107j))*x[0] + ((-0.254756990894+0.268740227435j))*x[1]**o + ((-0.891757975665-0.122274024184j))*x[1]
        ref[(0, 2)]=(0.148668000266+0.0636063569579j)*x_ref[0]**o + ((-0.801119774229-0.680049099107j))*x_ref[0] + ((-0.254756990894+0.268740227435j))*x_ref[1]**o + ((-0.891757975665-0.122274024184j))*x_ref[1]
        arg[(1, 0)]=(-0.847604463218-0.955131960818j)*x[0]**o + ((-0.812618806559-0.588170060449j))*x[0] + ((-0.118479999773-0.80737574958j))*x[1]**o + ((-0.71174218851-0.78275628441j))*x[1]
        ref[(1, 0)]=(-0.847604463218-0.955131960818j)*x_ref[0]**o + ((-0.812618806559-0.588170060449j))*x_ref[0] + ((-0.118479999773-0.80737574958j))*x_ref[1]**o + ((-0.71174218851-0.78275628441j))*x_ref[1]
        arg[(1, 1)]=(0.545641090086+0.705158364453j)*x[0]**o + ((0.368964562821-0.277275452489j))*x[0] + ((0.173309540684+0.763008918537j))*x[1]**o + ((0.46931819603+0.411149531646j))*x[1]
        ref[(1, 1)]=(0.545641090086+0.705158364453j)*x_ref[0]**o + ((0.368964562821-0.277275452489j))*x_ref[0] + ((0.173309540684+0.763008918537j))*x_ref[1]**o + ((0.46931819603+0.411149531646j))*x_ref[1]
        arg[(1, 2)]=(-0.612675919849+0.807995855993j)*x[0]**o + ((-0.8680573534-0.376259948242j))*x[0] + ((-0.382823003657-0.921257697648j))*x[1]**o + ((0.560232321862+0.480953187297j))*x[1]
        ref[(1, 2)]=(-0.612675919849+0.807995855993j)*x_ref[0]**o + ((-0.8680573534-0.376259948242j))*x_ref[0] + ((-0.382823003657-0.921257697648j))*x_ref[1]**o + ((0.560232321862+0.480953187297j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(0.315466079501-0.436669873645j)*x[2]**o + ((0.0917732434472+0.0801985984225j))*x[2]
            ref[(0, 0)]+=(0.315466079501-0.436669873645j)*x_ref[2]**o + ((0.0917732434472+0.0801985984225j))*x_ref[2]
            arg[(0, 1)]+=(-0.559130069165-0.098624695989j)*x[2]**o + ((0.264929206636+0.209570798601j))*x[2]
            ref[(0, 1)]+=(-0.559130069165-0.098624695989j)*x_ref[2]**o + ((0.264929206636+0.209570798601j))*x_ref[2]
            arg[(0, 2)]+=(0.341162580748+0.795740038207j)*x[2]**o + ((0.457741233391+0.971247619333j))*x[2]
            ref[(0, 2)]+=(0.341162580748+0.795740038207j)*x_ref[2]**o + ((0.457741233391+0.971247619333j))*x_ref[2]
            arg[(1, 0)]+=(0.194337354193+0.252875012575j)*x[2]**o + ((-0.765180399508+0.151965599801j))*x[2]
            ref[(1, 0)]+=(0.194337354193+0.252875012575j)*x_ref[2]**o + ((-0.765180399508+0.151965599801j))*x_ref[2]
            arg[(1, 1)]+=(0.925821038621+0.364109666175j)*x[2]**o + ((0.360278531742+0.108304553951j))*x[2]
            ref[(1, 1)]+=(0.925821038621+0.364109666175j)*x_ref[2]**o + ((0.360278531742+0.108304553951j))*x_ref[2]
            arg[(1, 2)]+=(0.924413415784+0.701539253253j)*x[2]**o + ((-0.212259615625-0.387566633931j))*x[2]
            ref[(1, 2)]+=(0.924413415784+0.701539253253j)*x_ref[2]**o + ((-0.212259615625-0.387566633931j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ContinuousFunction_rank3(self):
        """
        tests interpolation of rank 3 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2, 2),w)
        ref = Data(0,(4, 2, 2),w_ref)
        arg[(0, 0, 0)]=(0.666593298939+0.816280729793j)*x[0]**o + ((0.150036605645-0.361597231033j))*x[0] + ((0.956114966053-0.921346673668j))*x[1]**o + ((0.375839947545-0.49292808529j))*x[1]
        ref[(0, 0, 0)]=(0.666593298939+0.816280729793j)*x_ref[0]**o + ((0.150036605645-0.361597231033j))*x_ref[0] + ((0.956114966053-0.921346673668j))*x_ref[1]**o + ((0.375839947545-0.49292808529j))*x_ref[1]
        arg[(0, 0, 1)]=(0.5813274165-0.669976281607j)*x[0]**o + ((0.907091434541+0.651638103445j))*x[0] + ((0.213180945624+0.976042624244j))*x[1]**o + ((-0.389849039362+0.922194761755j))*x[1]
        ref[(0, 0, 1)]=(0.5813274165-0.669976281607j)*x_ref[0]**o + ((0.907091434541+0.651638103445j))*x_ref[0] + ((0.213180945624+0.976042624244j))*x_ref[1]**o + ((-0.389849039362+0.922194761755j))*x_ref[1]
        arg[(0, 1, 0)]=(-0.602470518704+0.959824315044j)*x[0]**o + ((-0.731294452709-0.00361138469734j))*x[0] + ((0.167273937612+0.723861940512j))*x[1]**o + ((-0.756142380089-0.129311848942j))*x[1]
        ref[(0, 1, 0)]=(-0.602470518704+0.959824315044j)*x_ref[0]**o + ((-0.731294452709-0.00361138469734j))*x_ref[0] + ((0.167273937612+0.723861940512j))*x_ref[1]**o + ((-0.756142380089-0.129311848942j))*x_ref[1]
        arg[(0, 1, 1)]=(0.403900104221-0.706965517753j)*x[0]**o + ((0.508915649677-0.162580390508j))*x[0] + ((0.440332845838-0.888403948713j))*x[1]**o + ((0.76478987772+0.522115089563j))*x[1]
        ref[(0, 1, 1)]=(0.403900104221-0.706965517753j)*x_ref[0]**o + ((0.508915649677-0.162580390508j))*x_ref[0] + ((0.440332845838-0.888403948713j))*x_ref[1]**o + ((0.76478987772+0.522115089563j))*x_ref[1]
        arg[(1, 0, 0)]=(-0.59247751756+0.88659838174j)*x[0]**o + ((0.748804842823-0.109951594524j))*x[0] + ((0.945694627814+0.0424978946458j))*x[1]**o + ((-0.153384615717-0.547935786088j))*x[1]
        ref[(1, 0, 0)]=(-0.59247751756+0.88659838174j)*x_ref[0]**o + ((0.748804842823-0.109951594524j))*x_ref[0] + ((0.945694627814+0.0424978946458j))*x_ref[1]**o + ((-0.153384615717-0.547935786088j))*x_ref[1]
        arg[(1, 0, 1)]=(0.044015721411-0.517862839911j)*x[0]**o + ((0.456289637443+0.820683702348j))*x[0] + ((0.41736767008-0.390453076834j))*x[1]**o + ((-0.596063590611-0.563427985067j))*x[1]
        ref[(1, 0, 1)]=(0.044015721411-0.517862839911j)*x_ref[0]**o + ((0.456289637443+0.820683702348j))*x_ref[0] + ((0.41736767008-0.390453076834j))*x_ref[1]**o + ((-0.596063590611-0.563427985067j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.963819607583-0.825603560319j)*x[0]**o + ((-0.683451868813+0.087968941632j))*x[0] + ((-0.329857047487+0.539896992339j))*x[1]**o + ((0.167574880096-0.623485113186j))*x[1]
        ref[(1, 1, 0)]=(-0.963819607583-0.825603560319j)*x_ref[0]**o + ((-0.683451868813+0.087968941632j))*x_ref[0] + ((-0.329857047487+0.539896992339j))*x_ref[1]**o + ((0.167574880096-0.623485113186j))*x_ref[1]
        arg[(1, 1, 1)]=(-0.253304160428-0.150596452572j)*x[0]**o + ((-0.827477192906+0.0613252867354j))*x[0] + ((0.465352071181-0.0434010970026j))*x[1]**o + ((0.878669186469+0.0771488589676j))*x[1]
        ref[(1, 1, 1)]=(-0.253304160428-0.150596452572j)*x_ref[0]**o + ((-0.827477192906+0.0613252867354j))*x_ref[0] + ((0.465352071181-0.0434010970026j))*x_ref[1]**o + ((0.878669186469+0.0771488589676j))*x_ref[1]
        arg[(2, 0, 0)]=(0.0012117286439-0.423914803835j)*x[0]**o + ((-0.56793179097+0.52431276903j))*x[0] + ((-0.131829847788-0.198077467121j))*x[1]**o + ((0.39878339163-0.0470931663003j))*x[1]
        ref[(2, 0, 0)]=(0.0012117286439-0.423914803835j)*x_ref[0]**o + ((-0.56793179097+0.52431276903j))*x_ref[0] + ((-0.131829847788-0.198077467121j))*x_ref[1]**o + ((0.39878339163-0.0470931663003j))*x_ref[1]
        arg[(2, 0, 1)]=(0.933222821787+0.271476666948j)*x[0]**o + ((0.0674506608304+0.262329863653j))*x[0] + ((-0.656239024994-0.875849502015j))*x[1]**o + ((-0.27406954869+0.5563028092j))*x[1]
        ref[(2, 0, 1)]=(0.933222821787+0.271476666948j)*x_ref[0]**o + ((0.0674506608304+0.262329863653j))*x_ref[0] + ((-0.656239024994-0.875849502015j))*x_ref[1]**o + ((-0.27406954869+0.5563028092j))*x_ref[1]
        arg[(2, 1, 0)]=(0.177184255626+0.508383977876j)*x[0]**o + ((0.973718084764-0.54883039458j))*x[0] + ((-0.380714246473+0.608967000499j))*x[1]**o + ((-0.615186804066+0.319552489765j))*x[1]
        ref[(2, 1, 0)]=(0.177184255626+0.508383977876j)*x_ref[0]**o + ((0.973718084764-0.54883039458j))*x_ref[0] + ((-0.380714246473+0.608967000499j))*x_ref[1]**o + ((-0.615186804066+0.319552489765j))*x_ref[1]
        arg[(2, 1, 1)]=(0.0162756976429+0.143807872639j)*x[0]**o + ((0.0718341067285-0.922903106423j))*x[0] + ((0.798983744265-0.759355791447j))*x[1]**o + ((-0.0369917348111+0.45123828384j))*x[1]
        ref[(2, 1, 1)]=(0.0162756976429+0.143807872639j)*x_ref[0]**o + ((0.0718341067285-0.922903106423j))*x_ref[0] + ((0.798983744265-0.759355791447j))*x_ref[1]**o + ((-0.0369917348111+0.45123828384j))*x_ref[1]
        arg[(3, 0, 0)]=(0.517415230616-0.744725180992j)*x[0]**o + ((0.564698357312-0.890227921509j))*x[0] + ((0.104761511086-0.402003557192j))*x[1]**o + ((0.0701268478186-0.609295006272j))*x[1]
        ref[(3, 0, 0)]=(0.517415230616-0.744725180992j)*x_ref[0]**o + ((0.564698357312-0.890227921509j))*x_ref[0] + ((0.104761511086-0.402003557192j))*x_ref[1]**o + ((0.0701268478186-0.609295006272j))*x_ref[1]
        arg[(3, 0, 1)]=(-0.337631172377+0.236567333711j)*x[0]**o + ((0.273755055316+0.701155915561j))*x[0] + ((-0.0538391843042+0.536422431951j))*x[1]**o + ((0.685176989-0.319170331011j))*x[1]
        ref[(3, 0, 1)]=(-0.337631172377+0.236567333711j)*x_ref[0]**o + ((0.273755055316+0.701155915561j))*x_ref[0] + ((-0.0538391843042+0.536422431951j))*x_ref[1]**o + ((0.685176989-0.319170331011j))*x_ref[1]
        arg[(3, 1, 0)]=(-0.404710648215+0.442514285696j)*x[0]**o + ((-0.162924934625+0.862633071804j))*x[0] + ((-0.624731083782-0.794447700845j))*x[1]**o + ((-0.808492081299+0.28389266216j))*x[1]
        ref[(3, 1, 0)]=(-0.404710648215+0.442514285696j)*x_ref[0]**o + ((-0.162924934625+0.862633071804j))*x_ref[0] + ((-0.624731083782-0.794447700845j))*x_ref[1]**o + ((-0.808492081299+0.28389266216j))*x_ref[1]
        arg[(3, 1, 1)]=(0.236417859139+0.6238597133j)*x[0]**o + ((-0.960638660808+0.397951288511j))*x[0] + ((0.062162759184+0.0749424056657j))*x[1]**o + ((0.0370191106982-0.758799226008j))*x[1]
        ref[(3, 1, 1)]=(0.236417859139+0.6238597133j)*x_ref[0]**o + ((-0.960638660808+0.397951288511j))*x_ref[0] + ((0.062162759184+0.0749424056657j))*x_ref[1]**o + ((0.0370191106982-0.758799226008j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(0.461342720187-0.231370889571j)*x[2]**o + ((0.412793967058-0.948187292888j))*x[2]
            ref[(0, 0, 0)]+=(0.461342720187-0.231370889571j)*x_ref[2]**o + ((0.412793967058-0.948187292888j))*x_ref[2]
            arg[(0, 0, 1)]+=(0.976515516709-0.275347628476j)*x[2]**o + ((0.836889193332-0.291014036655j))*x[2]
            ref[(0, 0, 1)]+=(0.976515516709-0.275347628476j)*x_ref[2]**o + ((0.836889193332-0.291014036655j))*x_ref[2]
            arg[(0, 1, 0)]+=(-0.348060705433-0.317582196345j)*x[2]**o + ((-0.275164888185-0.266366699993j))*x[2]
            ref[(0, 1, 0)]+=(-0.348060705433-0.317582196345j)*x_ref[2]**o + ((-0.275164888185-0.266366699993j))*x_ref[2]
            arg[(0, 1, 1)]+=(0.968204389127-0.0539209143901j)*x[2]**o + ((-0.229553795006-0.638140954211j))*x[2]
            ref[(0, 1, 1)]+=(0.968204389127-0.0539209143901j)*x_ref[2]**o + ((-0.229553795006-0.638140954211j))*x_ref[2]
            arg[(1, 0, 0)]+=(-0.587880457541-0.766346483535j)*x[2]**o + ((0.828907127467+0.385317520358j))*x[2]
            ref[(1, 0, 0)]+=(-0.587880457541-0.766346483535j)*x_ref[2]**o + ((0.828907127467+0.385317520358j))*x_ref[2]
            arg[(1, 0, 1)]+=(-0.463665071185+0.827067905077j)*x[2]**o + ((-0.387059354313-0.444226865122j))*x[2]
            ref[(1, 0, 1)]+=(-0.463665071185+0.827067905077j)*x_ref[2]**o + ((-0.387059354313-0.444226865122j))*x_ref[2]
            arg[(1, 1, 0)]+=(0.718679935975+0.380721198622j)*x[2]**o + ((0.976452937237+0.328764928583j))*x[2]
            ref[(1, 1, 0)]+=(0.718679935975+0.380721198622j)*x_ref[2]**o + ((0.976452937237+0.328764928583j))*x_ref[2]
            arg[(1, 1, 1)]+=(0.144869271227-0.43757737201j)*x[2]**o + ((0.319517086082-0.0857576518654j))*x[2]
            ref[(1, 1, 1)]+=(0.144869271227-0.43757737201j)*x_ref[2]**o + ((0.319517086082-0.0857576518654j))*x_ref[2]
            arg[(2, 0, 0)]+=(0.908909632348-0.0564231149278j)*x[2]**o + ((0.803569535948-0.59657680996j))*x[2]
            ref[(2, 0, 0)]+=(0.908909632348-0.0564231149278j)*x_ref[2]**o + ((0.803569535948-0.59657680996j))*x_ref[2]
            arg[(2, 0, 1)]+=(-0.0524727769444-0.763964919036j)*x[2]**o + ((0.489999476084-0.891298807316j))*x[2]
            ref[(2, 0, 1)]+=(-0.0524727769444-0.763964919036j)*x_ref[2]**o + ((0.489999476084-0.891298807316j))*x_ref[2]
            arg[(2, 1, 0)]+=(-0.527259428697-0.0423761540832j)*x[2]**o + ((-0.280997098312+0.867928459467j))*x[2]
            ref[(2, 1, 0)]+=(-0.527259428697-0.0423761540832j)*x_ref[2]**o + ((-0.280997098312+0.867928459467j))*x_ref[2]
            arg[(2, 1, 1)]+=(0.728399527865-0.881407772965j)*x[2]**o + ((0.399349380633-0.192573843665j))*x[2]
            ref[(2, 1, 1)]+=(0.728399527865-0.881407772965j)*x_ref[2]**o + ((0.399349380633-0.192573843665j))*x_ref[2]
            arg[(3, 0, 0)]+=(0.509515866271-0.855937196023j)*x[2]**o + ((0.165435112292-0.380273205397j))*x[2]
            ref[(3, 0, 0)]+=(0.509515866271-0.855937196023j)*x_ref[2]**o + ((0.165435112292-0.380273205397j))*x_ref[2]
            arg[(3, 0, 1)]+=(0.987338239529+0.608306339281j)*x[2]**o + ((-0.265479294265+0.912679840088j))*x[2]
            ref[(3, 0, 1)]+=(0.987338239529+0.608306339281j)*x_ref[2]**o + ((-0.265479294265+0.912679840088j))*x_ref[2]
            arg[(3, 1, 0)]+=(0.257397317017-0.386896682134j)*x[2]**o + ((-0.849898455089-0.919739833881j))*x[2]
            ref[(3, 1, 0)]+=(0.257397317017-0.386896682134j)*x_ref[2]**o + ((-0.849898455089-0.919739833881j))*x_ref[2]
            arg[(3, 1, 1)]+=(-0.300056174132+0.584564842503j)*x[2]**o + ((-0.77887488445-0.231341654803j))*x[2]
            ref[(3, 1, 1)]+=(-0.300056174132+0.584564842503j)*x_ref[2]**o + ((-0.77887488445-0.231341654803j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ContinuousFunction_rank4(self):
        """
        tests interpolation of rank 4 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 3, 3),w)
        ref = Data(0,(2, 2, 3, 3),w_ref)
        arg[(0, 0, 0, 0)]=(0.735313759227+0.700550985529j)*x[0]**o + ((-0.210321469336+0.00822802542784j))*x[0] + ((-0.583277378525+0.565498633905j))*x[1]**o + ((-0.97590780103-0.0408054456745j))*x[1]
        ref[(0, 0, 0, 0)]=(0.735313759227+0.700550985529j)*x_ref[0]**o + ((-0.210321469336+0.00822802542784j))*x_ref[0] + ((-0.583277378525+0.565498633905j))*x_ref[1]**o + ((-0.97590780103-0.0408054456745j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(0.12285142651+0.878427864332j)*x[0]**o + ((-0.132853937659-0.0525040813171j))*x[0] + ((-0.543927108514-0.312149125459j))*x[1]**o + ((-0.345192975118-0.0620041551198j))*x[1]
        ref[(0, 0, 0, 1)]=(0.12285142651+0.878427864332j)*x_ref[0]**o + ((-0.132853937659-0.0525040813171j))*x_ref[0] + ((-0.543927108514-0.312149125459j))*x_ref[1]**o + ((-0.345192975118-0.0620041551198j))*x_ref[1]
        arg[(0, 0, 0, 2)]=(0.0934216602183-0.401162850023j)*x[0]**o + ((0.862886877084+0.137175854797j))*x[0] + ((0.921001603286-0.907639691226j))*x[1]**o + ((0.5966576197-0.0590624021685j))*x[1]
        ref[(0, 0, 0, 2)]=(0.0934216602183-0.401162850023j)*x_ref[0]**o + ((0.862886877084+0.137175854797j))*x_ref[0] + ((0.921001603286-0.907639691226j))*x_ref[1]**o + ((0.5966576197-0.0590624021685j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(-0.569912116913+0.78938267611j)*x[0]**o + ((0.555383447461+0.94714572737j))*x[0] + ((-0.566958105552-0.606432415798j))*x[1]**o + ((-0.0412040624194+0.954150815466j))*x[1]
        ref[(0, 0, 1, 0)]=(-0.569912116913+0.78938267611j)*x_ref[0]**o + ((0.555383447461+0.94714572737j))*x_ref[0] + ((-0.566958105552-0.606432415798j))*x_ref[1]**o + ((-0.0412040624194+0.954150815466j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.97117585845+0.203481872264j)*x[0]**o + ((0.362931428377+0.521062220389j))*x[0] + ((0.799262066945+0.475106334826j))*x[1]**o + ((-0.78451567729-0.939644376714j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.97117585845+0.203481872264j)*x_ref[0]**o + ((0.362931428377+0.521062220389j))*x_ref[0] + ((0.799262066945+0.475106334826j))*x_ref[1]**o + ((-0.78451567729-0.939644376714j))*x_ref[1]
        arg[(0, 0, 1, 2)]=(0.18437769808-0.157565795422j)*x[0]**o + ((-0.736013084351-0.736389802742j))*x[0] + ((0.681228565185-0.857099375647j))*x[1]**o + ((0.125024559536-0.490164158846j))*x[1]
        ref[(0, 0, 1, 2)]=(0.18437769808-0.157565795422j)*x_ref[0]**o + ((-0.736013084351-0.736389802742j))*x_ref[0] + ((0.681228565185-0.857099375647j))*x_ref[1]**o + ((0.125024559536-0.490164158846j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(-0.923687108924+0.400571248365j)*x[0]**o + ((0.41775220265-0.842750699824j))*x[0] + ((0.304084127728-0.146909248499j))*x[1]**o + ((0.175114468899+0.605004730779j))*x[1]
        ref[(0, 0, 2, 0)]=(-0.923687108924+0.400571248365j)*x_ref[0]**o + ((0.41775220265-0.842750699824j))*x_ref[0] + ((0.304084127728-0.146909248499j))*x_ref[1]**o + ((0.175114468899+0.605004730779j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(0.831851702786+0.681585546774j)*x[0]**o + ((-0.105197672233-0.426676296076j))*x[0] + ((-0.00765932348139-0.697106296074j))*x[1]**o + ((0.0021471560653+0.818391985387j))*x[1]
        ref[(0, 0, 2, 1)]=(0.831851702786+0.681585546774j)*x_ref[0]**o + ((-0.105197672233-0.426676296076j))*x_ref[0] + ((-0.00765932348139-0.697106296074j))*x_ref[1]**o + ((0.0021471560653+0.818391985387j))*x_ref[1]
        arg[(0, 0, 2, 2)]=(0.534403836506-0.504269941409j)*x[0]**o + ((-0.105941100075+0.762155653714j))*x[0] + ((0.520792501967-0.73469810387j))*x[1]**o + ((-0.45883843889-0.857685692432j))*x[1]
        ref[(0, 0, 2, 2)]=(0.534403836506-0.504269941409j)*x_ref[0]**o + ((-0.105941100075+0.762155653714j))*x_ref[0] + ((0.520792501967-0.73469810387j))*x_ref[1]**o + ((-0.45883843889-0.857685692432j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.359246166528+0.0278888628067j)*x[0]**o + ((-0.309264422043+0.355626217211j))*x[0] + ((0.211670741562-0.81238700063j))*x[1]**o + ((0.529556930307+0.0111186820819j))*x[1]
        ref[(0, 1, 0, 0)]=(0.359246166528+0.0278888628067j)*x_ref[0]**o + ((-0.309264422043+0.355626217211j))*x_ref[0] + ((0.211670741562-0.81238700063j))*x_ref[1]**o + ((0.529556930307+0.0111186820819j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(0.316799563335+0.806495821435j)*x[0]**o + ((0.132538783863+0.306370431783j))*x[0] + ((-0.473051976693+0.509521120603j))*x[1]**o + ((0.0483364918784-0.360655129445j))*x[1]
        ref[(0, 1, 0, 1)]=(0.316799563335+0.806495821435j)*x_ref[0]**o + ((0.132538783863+0.306370431783j))*x_ref[0] + ((-0.473051976693+0.509521120603j))*x_ref[1]**o + ((0.0483364918784-0.360655129445j))*x_ref[1]
        arg[(0, 1, 0, 2)]=(0.706850971729+0.244910452897j)*x[0]**o + ((0.50860430397+0.95854797676j))*x[0] + ((-0.0362573106741-0.185297118401j))*x[1]**o + ((-0.355606514071+0.586816548471j))*x[1]
        ref[(0, 1, 0, 2)]=(0.706850971729+0.244910452897j)*x_ref[0]**o + ((0.50860430397+0.95854797676j))*x_ref[0] + ((-0.0362573106741-0.185297118401j))*x_ref[1]**o + ((-0.355606514071+0.586816548471j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(0.171154433801+0.933610145362j)*x[0]**o + ((-0.138194168359-0.86561975605j))*x[0] + ((-0.381600851134+0.637089072949j))*x[1]**o + ((-0.983938966334+0.816059498374j))*x[1]
        ref[(0, 1, 1, 0)]=(0.171154433801+0.933610145362j)*x_ref[0]**o + ((-0.138194168359-0.86561975605j))*x_ref[0] + ((-0.381600851134+0.637089072949j))*x_ref[1]**o + ((-0.983938966334+0.816059498374j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(-0.222044365895-0.24703734865j)*x[0]**o + ((0.779942698144+0.344927892443j))*x[0] + ((-0.812358096515-0.69177374869j))*x[1]**o + ((-0.991442234099-0.681552041896j))*x[1]
        ref[(0, 1, 1, 1)]=(-0.222044365895-0.24703734865j)*x_ref[0]**o + ((0.779942698144+0.344927892443j))*x_ref[0] + ((-0.812358096515-0.69177374869j))*x_ref[1]**o + ((-0.991442234099-0.681552041896j))*x_ref[1]
        arg[(0, 1, 1, 2)]=(0.54573193693-0.834169314732j)*x[0]**o + ((0.869648944117-0.391540770903j))*x[0] + ((0.374921033977-0.919145032939j))*x[1]**o + ((0.377738795319-0.757452776871j))*x[1]
        ref[(0, 1, 1, 2)]=(0.54573193693-0.834169314732j)*x_ref[0]**o + ((0.869648944117-0.391540770903j))*x_ref[0] + ((0.374921033977-0.919145032939j))*x_ref[1]**o + ((0.377738795319-0.757452776871j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(-0.139999609905-0.953468544589j)*x[0]**o + ((0.695297546862-0.594395364041j))*x[0] + ((0.881347145595+0.450020426539j))*x[1]**o + ((-0.659051962453+0.348709139414j))*x[1]
        ref[(0, 1, 2, 0)]=(-0.139999609905-0.953468544589j)*x_ref[0]**o + ((0.695297546862-0.594395364041j))*x_ref[0] + ((0.881347145595+0.450020426539j))*x_ref[1]**o + ((-0.659051962453+0.348709139414j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(-0.392029542333-0.871013066144j)*x[0]**o + ((0.872803246753-0.498382961431j))*x[0] + ((-0.981891179865-0.618391900563j))*x[1]**o + ((0.514500670773+0.778760046912j))*x[1]
        ref[(0, 1, 2, 1)]=(-0.392029542333-0.871013066144j)*x_ref[0]**o + ((0.872803246753-0.498382961431j))*x_ref[0] + ((-0.981891179865-0.618391900563j))*x_ref[1]**o + ((0.514500670773+0.778760046912j))*x_ref[1]
        arg[(0, 1, 2, 2)]=(-0.0348495281494-0.696338783098j)*x[0]**o + ((0.331672776743+0.703719081108j))*x[0] + ((0.916065463804-0.759616376551j))*x[1]**o + ((0.232443745717+0.647897726335j))*x[1]
        ref[(0, 1, 2, 2)]=(-0.0348495281494-0.696338783098j)*x_ref[0]**o + ((0.331672776743+0.703719081108j))*x_ref[0] + ((0.916065463804-0.759616376551j))*x_ref[1]**o + ((0.232443745717+0.647897726335j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.375204436097+0.833933816869j)*x[0]**o + ((-0.155522139393-0.501996326241j))*x[0] + ((0.417503388183+0.530793651059j))*x[1]**o + ((-0.830068707411+0.0365759333383j))*x[1]
        ref[(1, 0, 0, 0)]=(0.375204436097+0.833933816869j)*x_ref[0]**o + ((-0.155522139393-0.501996326241j))*x_ref[0] + ((0.417503388183+0.530793651059j))*x_ref[1]**o + ((-0.830068707411+0.0365759333383j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.413136740025+0.220951644843j)*x[0]**o + ((-0.291044601072+0.758164446856j))*x[0] + ((-0.179063802082-0.483993119116j))*x[1]**o + ((-0.0582157957895-0.477953637798j))*x[1]
        ref[(1, 0, 0, 1)]=(0.413136740025+0.220951644843j)*x_ref[0]**o + ((-0.291044601072+0.758164446856j))*x_ref[0] + ((-0.179063802082-0.483993119116j))*x_ref[1]**o + ((-0.0582157957895-0.477953637798j))*x_ref[1]
        arg[(1, 0, 0, 2)]=(0.846248609598-0.94562432562j)*x[0]**o + ((0.0337848191522-0.0841245608397j))*x[0] + ((0.815114640675-0.896164264831j))*x[1]**o + ((-0.705144741154-0.891212699765j))*x[1]
        ref[(1, 0, 0, 2)]=(0.846248609598-0.94562432562j)*x_ref[0]**o + ((0.0337848191522-0.0841245608397j))*x_ref[0] + ((0.815114640675-0.896164264831j))*x_ref[1]**o + ((-0.705144741154-0.891212699765j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.260122326743-0.368148113559j)*x[0]**o + ((0.848937593689-0.114232148658j))*x[0] + ((0.0684195175406+0.842053438754j))*x[1]**o + ((-0.671264477463-0.336270846702j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.260122326743-0.368148113559j)*x_ref[0]**o + ((0.848937593689-0.114232148658j))*x_ref[0] + ((0.0684195175406+0.842053438754j))*x_ref[1]**o + ((-0.671264477463-0.336270846702j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(0.733751376648+0.958391838127j)*x[0]**o + ((0.513309059548+0.60557335028j))*x[0] + ((-0.0108733346472-0.860378502457j))*x[1]**o + ((-0.732517623419+0.917997768115j))*x[1]
        ref[(1, 0, 1, 1)]=(0.733751376648+0.958391838127j)*x_ref[0]**o + ((0.513309059548+0.60557335028j))*x_ref[0] + ((-0.0108733346472-0.860378502457j))*x_ref[1]**o + ((-0.732517623419+0.917997768115j))*x_ref[1]
        arg[(1, 0, 1, 2)]=(-0.0169839591453+0.372329242425j)*x[0]**o + ((-0.485280807457-0.736562398928j))*x[0] + ((-0.182898979627-0.289319835683j))*x[1]**o + ((-0.866475767944-0.477278804519j))*x[1]
        ref[(1, 0, 1, 2)]=(-0.0169839591453+0.372329242425j)*x_ref[0]**o + ((-0.485280807457-0.736562398928j))*x_ref[0] + ((-0.182898979627-0.289319835683j))*x_ref[1]**o + ((-0.866475767944-0.477278804519j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(-0.189910141339-0.495207576473j)*x[0]**o + ((-0.917435291199+0.557829412232j))*x[0] + ((0.637432888828-0.0949187366145j))*x[1]**o + ((0.627530249401+0.807283650241j))*x[1]
        ref[(1, 0, 2, 0)]=(-0.189910141339-0.495207576473j)*x_ref[0]**o + ((-0.917435291199+0.557829412232j))*x_ref[0] + ((0.637432888828-0.0949187366145j))*x_ref[1]**o + ((0.627530249401+0.807283650241j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(-0.364083005575-0.273917101142j)*x[0]**o + ((-0.675286929657-0.993461515497j))*x[0] + ((0.726655041208-0.221735390695j))*x[1]**o + ((0.113103629503-0.0153840353635j))*x[1]
        ref[(1, 0, 2, 1)]=(-0.364083005575-0.273917101142j)*x_ref[0]**o + ((-0.675286929657-0.993461515497j))*x_ref[0] + ((0.726655041208-0.221735390695j))*x_ref[1]**o + ((0.113103629503-0.0153840353635j))*x_ref[1]
        arg[(1, 0, 2, 2)]=(-0.57789104412-0.0886037451338j)*x[0]**o + ((-0.418166530406-0.655113981416j))*x[0] + ((0.00615636466568-0.172536996279j))*x[1]**o + ((-0.555621888137-0.46476325382j))*x[1]
        ref[(1, 0, 2, 2)]=(-0.57789104412-0.0886037451338j)*x_ref[0]**o + ((-0.418166530406-0.655113981416j))*x_ref[0] + ((0.00615636466568-0.172536996279j))*x_ref[1]**o + ((-0.555621888137-0.46476325382j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(-0.147059685401+0.450965459499j)*x[0]**o + ((0.715515590573+0.600488270794j))*x[0] + ((0.704496801592+0.631312325701j))*x[1]**o + ((0.731576860948-0.921415513691j))*x[1]
        ref[(1, 1, 0, 0)]=(-0.147059685401+0.450965459499j)*x_ref[0]**o + ((0.715515590573+0.600488270794j))*x_ref[0] + ((0.704496801592+0.631312325701j))*x_ref[1]**o + ((0.731576860948-0.921415513691j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(-0.0410011997471-0.466090148104j)*x[0]**o + ((0.310905084248-0.786676766956j))*x[0] + ((0.0382599332516-0.983000125741j))*x[1]**o + ((0.790137833587-0.509904712364j))*x[1]
        ref[(1, 1, 0, 1)]=(-0.0410011997471-0.466090148104j)*x_ref[0]**o + ((0.310905084248-0.786676766956j))*x_ref[0] + ((0.0382599332516-0.983000125741j))*x_ref[1]**o + ((0.790137833587-0.509904712364j))*x_ref[1]
        arg[(1, 1, 0, 2)]=(0.0500517620109-0.47956621553j)*x[0]**o + ((-0.343234351333-0.845047068579j))*x[0] + ((0.483945309126-0.210778498409j))*x[1]**o + ((-0.034602027357-0.274410453255j))*x[1]
        ref[(1, 1, 0, 2)]=(0.0500517620109-0.47956621553j)*x_ref[0]**o + ((-0.343234351333-0.845047068579j))*x_ref[0] + ((0.483945309126-0.210778498409j))*x_ref[1]**o + ((-0.034602027357-0.274410453255j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.0460057024476-0.87302717194j)*x[0]**o + ((-0.237078925591-0.802146305704j))*x[0] + ((-0.590478790866-0.618793828742j))*x[1]**o + ((-0.111189944304-0.262272292668j))*x[1]
        ref[(1, 1, 1, 0)]=(0.0460057024476-0.87302717194j)*x_ref[0]**o + ((-0.237078925591-0.802146305704j))*x_ref[0] + ((-0.590478790866-0.618793828742j))*x_ref[1]**o + ((-0.111189944304-0.262272292668j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.181324773426-0.813146662102j)*x[0]**o + ((0.468373695277+0.762558954129j))*x[0] + ((-0.978833398603-0.415483467685j))*x[1]**o + ((-0.100930388695-0.85706423965j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.181324773426-0.813146662102j)*x_ref[0]**o + ((0.468373695277+0.762558954129j))*x_ref[0] + ((-0.978833398603-0.415483467685j))*x_ref[1]**o + ((-0.100930388695-0.85706423965j))*x_ref[1]
        arg[(1, 1, 1, 2)]=(-0.502040979377-0.205367664424j)*x[0]**o + ((0.179794781625-0.860870442825j))*x[0] + ((0.45413373188+0.0192415594231j))*x[1]**o + ((-0.552307731968-0.612517721606j))*x[1]
        ref[(1, 1, 1, 2)]=(-0.502040979377-0.205367664424j)*x_ref[0]**o + ((0.179794781625-0.860870442825j))*x_ref[0] + ((0.45413373188+0.0192415594231j))*x_ref[1]**o + ((-0.552307731968-0.612517721606j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(-0.730640098511-0.475580535568j)*x[0]**o + ((0.355535315087-0.576850502993j))*x[0] + ((-0.963775277858+0.693193522372j))*x[1]**o + ((-0.460066912008+0.753791955957j))*x[1]
        ref[(1, 1, 2, 0)]=(-0.730640098511-0.475580535568j)*x_ref[0]**o + ((0.355535315087-0.576850502993j))*x_ref[0] + ((-0.963775277858+0.693193522372j))*x_ref[1]**o + ((-0.460066912008+0.753791955957j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(-0.550793540625-0.620774936651j)*x[0]**o + ((-0.933872124559-0.294731149386j))*x[0] + ((-0.110370561248-0.810466537225j))*x[1]**o + ((-0.870891690283-0.0342786529528j))*x[1]
        ref[(1, 1, 2, 1)]=(-0.550793540625-0.620774936651j)*x_ref[0]**o + ((-0.933872124559-0.294731149386j))*x_ref[0] + ((-0.110370561248-0.810466537225j))*x_ref[1]**o + ((-0.870891690283-0.0342786529528j))*x_ref[1]
        arg[(1, 1, 2, 2)]=(-0.740751218986+0.933202406711j)*x[0]**o + ((0.493736330595+0.696137939626j))*x[0] + ((0.495384057755+0.0763932318108j))*x[1]**o + ((-0.184227888094+0.17184198156j))*x[1]
        ref[(1, 1, 2, 2)]=(-0.740751218986+0.933202406711j)*x_ref[0]**o + ((0.493736330595+0.696137939626j))*x_ref[0] + ((0.495384057755+0.0763932318108j))*x_ref[1]**o + ((-0.184227888094+0.17184198156j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(0.200613631118-0.154590169264j)*x[2]**o + ((-0.0575050316414+0.658698438416j))*x[2]
            ref[(0, 0, 0, 0)]+=(0.200613631118-0.154590169264j)*x_ref[2]**o + ((-0.0575050316414+0.658698438416j))*x_ref[2]
            arg[(0, 0, 0, 1)]+=(0.0456265357873-0.819823871924j)*x[2]**o + ((-0.202001984681+0.796365088084j))*x[2]
            ref[(0, 0, 0, 1)]+=(0.0456265357873-0.819823871924j)*x_ref[2]**o + ((-0.202001984681+0.796365088084j))*x_ref[2]
            arg[(0, 0, 0, 2)]+=(0.410679811106+0.358852639358j)*x[2]**o + ((0.236587912319-0.609873443214j))*x[2]
            ref[(0, 0, 0, 2)]+=(0.410679811106+0.358852639358j)*x_ref[2]**o + ((0.236587912319-0.609873443214j))*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.846202261735-0.159252976867j)*x[2]**o + ((0.446527274156+0.807689639706j))*x[2]
            ref[(0, 0, 1, 0)]+=(-0.846202261735-0.159252976867j)*x_ref[2]**o + ((0.446527274156+0.807689639706j))*x_ref[2]
            arg[(0, 0, 1, 1)]+=(-0.443818621309-0.398693953547j)*x[2]**o + ((-0.709378911329-0.32100230966j))*x[2]
            ref[(0, 0, 1, 1)]+=(-0.443818621309-0.398693953547j)*x_ref[2]**o + ((-0.709378911329-0.32100230966j))*x_ref[2]
            arg[(0, 0, 1, 2)]+=(0.775915711834-0.305610866737j)*x[2]**o + ((-0.630008065385+0.377697981204j))*x[2]
            ref[(0, 0, 1, 2)]+=(0.775915711834-0.305610866737j)*x_ref[2]**o + ((-0.630008065385+0.377697981204j))*x_ref[2]
            arg[(0, 0, 2, 0)]+=(-0.750240371154+0.602477046924j)*x[2]**o + ((0.785030267094+0.953547128739j))*x[2]
            ref[(0, 0, 2, 0)]+=(-0.750240371154+0.602477046924j)*x_ref[2]**o + ((0.785030267094+0.953547128739j))*x_ref[2]
            arg[(0, 0, 2, 1)]+=(0.770333053552+0.83449594461j)*x[2]**o + ((-0.626391431294-0.195358280865j))*x[2]
            ref[(0, 0, 2, 1)]+=(0.770333053552+0.83449594461j)*x_ref[2]**o + ((-0.626391431294-0.195358280865j))*x_ref[2]
            arg[(0, 0, 2, 2)]+=(-0.729995404826-0.747532272757j)*x[2]**o + ((0.976096707256-0.496339347287j))*x[2]
            ref[(0, 0, 2, 2)]+=(-0.729995404826-0.747532272757j)*x_ref[2]**o + ((0.976096707256-0.496339347287j))*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.572535071994+0.09524844185j)*x[2]**o + ((0.00597828681314+0.566383574513j))*x[2]
            ref[(0, 1, 0, 0)]+=(-0.572535071994+0.09524844185j)*x_ref[2]**o + ((0.00597828681314+0.566383574513j))*x_ref[2]
            arg[(0, 1, 0, 1)]+=(-0.399474586566+0.762592342541j)*x[2]**o + ((-0.73022177962-0.157151403285j))*x[2]
            ref[(0, 1, 0, 1)]+=(-0.399474586566+0.762592342541j)*x_ref[2]**o + ((-0.73022177962-0.157151403285j))*x_ref[2]
            arg[(0, 1, 0, 2)]+=(0.424640802074-0.769867767498j)*x[2]**o + ((-0.573391673697-0.435063407979j))*x[2]
            ref[(0, 1, 0, 2)]+=(0.424640802074-0.769867767498j)*x_ref[2]**o + ((-0.573391673697-0.435063407979j))*x_ref[2]
            arg[(0, 1, 1, 0)]+=(0.989071507471-0.0950725640431j)*x[2]**o + ((-0.497299693941+0.660952860029j))*x[2]
            ref[(0, 1, 1, 0)]+=(0.989071507471-0.0950725640431j)*x_ref[2]**o + ((-0.497299693941+0.660952860029j))*x_ref[2]
            arg[(0, 1, 1, 1)]+=(0.461579093655-0.730367073252j)*x[2]**o + ((0.442281782205-0.530425570354j))*x[2]
            ref[(0, 1, 1, 1)]+=(0.461579093655-0.730367073252j)*x_ref[2]**o + ((0.442281782205-0.530425570354j))*x_ref[2]
            arg[(0, 1, 1, 2)]+=(0.209971329944-0.17296553144j)*x[2]**o + ((-0.390251176426-0.733176950584j))*x[2]
            ref[(0, 1, 1, 2)]+=(0.209971329944-0.17296553144j)*x_ref[2]**o + ((-0.390251176426-0.733176950584j))*x_ref[2]
            arg[(0, 1, 2, 0)]+=(0.721761141282-0.202354204342j)*x[2]**o + ((-0.208543507666-0.679301981487j))*x[2]
            ref[(0, 1, 2, 0)]+=(0.721761141282-0.202354204342j)*x_ref[2]**o + ((-0.208543507666-0.679301981487j))*x_ref[2]
            arg[(0, 1, 2, 1)]+=(-0.619016279157+0.777263298905j)*x[2]**o + ((-0.869073867521-0.15379341003j))*x[2]
            ref[(0, 1, 2, 1)]+=(-0.619016279157+0.777263298905j)*x_ref[2]**o + ((-0.869073867521-0.15379341003j))*x_ref[2]
            arg[(0, 1, 2, 2)]+=(0.965021413061+0.840501358546j)*x[2]**o + ((-0.341252669941-0.461977139862j))*x[2]
            ref[(0, 1, 2, 2)]+=(0.965021413061+0.840501358546j)*x_ref[2]**o + ((-0.341252669941-0.461977139862j))*x_ref[2]
            arg[(1, 0, 0, 0)]+=(-0.527340374959-0.0655185724166j)*x[2]**o + ((0.775176102508+0.958770824514j))*x[2]
            ref[(1, 0, 0, 0)]+=(-0.527340374959-0.0655185724166j)*x_ref[2]**o + ((0.775176102508+0.958770824514j))*x_ref[2]
            arg[(1, 0, 0, 1)]+=(-0.610307004697+0.74363664937j)*x[2]**o + ((0.231736156653+0.353337359453j))*x[2]
            ref[(1, 0, 0, 1)]+=(-0.610307004697+0.74363664937j)*x_ref[2]**o + ((0.231736156653+0.353337359453j))*x_ref[2]
            arg[(1, 0, 0, 2)]+=(-0.502819646101+0.604811582224j)*x[2]**o + ((0.579686728614+0.608685196354j))*x[2]
            ref[(1, 0, 0, 2)]+=(-0.502819646101+0.604811582224j)*x_ref[2]**o + ((0.579686728614+0.608685196354j))*x_ref[2]
            arg[(1, 0, 1, 0)]+=(0.97629779203+0.714948311242j)*x[2]**o + ((-0.537583181344-0.313082434651j))*x[2]
            ref[(1, 0, 1, 0)]+=(0.97629779203+0.714948311242j)*x_ref[2]**o + ((-0.537583181344-0.313082434651j))*x_ref[2]
            arg[(1, 0, 1, 1)]+=(-0.660892905432+0.573775508653j)*x[2]**o + ((-0.423897091277-0.852608785475j))*x[2]
            ref[(1, 0, 1, 1)]+=(-0.660892905432+0.573775508653j)*x_ref[2]**o + ((-0.423897091277-0.852608785475j))*x_ref[2]
            arg[(1, 0, 1, 2)]+=(-0.564049390409-0.321190650955j)*x[2]**o + ((0.153944068378-0.87475304909j))*x[2]
            ref[(1, 0, 1, 2)]+=(-0.564049390409-0.321190650955j)*x_ref[2]**o + ((0.153944068378-0.87475304909j))*x_ref[2]
            arg[(1, 0, 2, 0)]+=(0.700686155926-0.612309016594j)*x[2]**o + ((0.220537946626+0.902620765466j))*x[2]
            ref[(1, 0, 2, 0)]+=(0.700686155926-0.612309016594j)*x_ref[2]**o + ((0.220537946626+0.902620765466j))*x_ref[2]
            arg[(1, 0, 2, 1)]+=(-0.524192673996+0.462609486658j)*x[2]**o + ((0.0199867387977+0.617602463997j))*x[2]
            ref[(1, 0, 2, 1)]+=(-0.524192673996+0.462609486658j)*x_ref[2]**o + ((0.0199867387977+0.617602463997j))*x_ref[2]
            arg[(1, 0, 2, 2)]+=(-0.0392277459672+0.997006005746j)*x[2]**o + ((-0.489289887827+0.574030769938j))*x[2]
            ref[(1, 0, 2, 2)]+=(-0.0392277459672+0.997006005746j)*x_ref[2]**o + ((-0.489289887827+0.574030769938j))*x_ref[2]
            arg[(1, 1, 0, 0)]+=(-0.144724902228-0.761344605793j)*x[2]**o + ((-0.137132464855-0.117837305761j))*x[2]
            ref[(1, 1, 0, 0)]+=(-0.144724902228-0.761344605793j)*x_ref[2]**o + ((-0.137132464855-0.117837305761j))*x_ref[2]
            arg[(1, 1, 0, 1)]+=(0.472538214647+0.190069427633j)*x[2]**o + ((0.882534565548+0.692655009996j))*x[2]
            ref[(1, 1, 0, 1)]+=(0.472538214647+0.190069427633j)*x_ref[2]**o + ((0.882534565548+0.692655009996j))*x_ref[2]
            arg[(1, 1, 0, 2)]+=(-0.905435426255+0.0518203866585j)*x[2]**o + ((0.813109412221-0.747018301069j))*x[2]
            ref[(1, 1, 0, 2)]+=(-0.905435426255+0.0518203866585j)*x_ref[2]**o + ((0.813109412221-0.747018301069j))*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.576946729578+0.123569402989j)*x[2]**o + ((0.939832770961-0.116283922625j))*x[2]
            ref[(1, 1, 1, 0)]+=(0.576946729578+0.123569402989j)*x_ref[2]**o + ((0.939832770961-0.116283922625j))*x_ref[2]
            arg[(1, 1, 1, 1)]+=(0.653073048432-0.936056824466j)*x[2]**o + ((-0.606753061333+0.71971352117j))*x[2]
            ref[(1, 1, 1, 1)]+=(0.653073048432-0.936056824466j)*x_ref[2]**o + ((-0.606753061333+0.71971352117j))*x_ref[2]
            arg[(1, 1, 1, 2)]+=(-0.892568106518+0.254955821541j)*x[2]**o + ((0.858468579792+0.512300913431j))*x[2]
            ref[(1, 1, 1, 2)]+=(-0.892568106518+0.254955821541j)*x_ref[2]**o + ((0.858468579792+0.512300913431j))*x_ref[2]
            arg[(1, 1, 2, 0)]+=(0.402539477715+0.0257186963274j)*x[2]**o + ((-0.407892578895+0.0615149800941j))*x[2]
            ref[(1, 1, 2, 0)]+=(0.402539477715+0.0257186963274j)*x_ref[2]**o + ((-0.407892578895+0.0615149800941j))*x_ref[2]
            arg[(1, 1, 2, 1)]+=(-0.411334680389+0.395985469034j)*x[2]**o + ((-0.984362080156-0.899548586032j))*x[2]
            ref[(1, 1, 2, 1)]+=(-0.411334680389+0.395985469034j)*x_ref[2]**o + ((-0.984362080156-0.899548586032j))*x_ref[2]
            arg[(1, 1, 2, 2)]+=(-0.844791076572-0.689075395442j)*x[2]**o + ((-0.638434790381+0.38495540163j))*x[2]
            ref[(1, 1, 2, 2)]+=(-0.844791076572-0.689075395442j)*x_ref[2]**o + ((-0.638434790381+0.38495540163j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2, 3, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_Solution_rank0(self):
        """
        tests interpolation of rank 0 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.345942137186-0.925636369653j)*x[0]**o + ((-0.765447824093+0.813108750318j))*x[0] + ((0.604808236449+0.158890170744j))*x[1]**o + ((0.213896539416+0.266047775978j))*x[1]
        ref=(-0.345942137186-0.925636369653j)*x_ref[0]**o + ((-0.765447824093+0.813108750318j))*x_ref[0] + ((0.604808236449+0.158890170744j))*x_ref[1]**o + ((0.213896539416+0.266047775978j))*x_ref[1]
        if dim==3:
            arg+=((0.23133255061-0.488457456537j))*x[2]**o + ((-0.967926806957+0.522561691972j))*x[2]
            ref+=((0.23133255061-0.488457456537j))*x_ref[2]**o + ((-0.967926806957+0.522561691972j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_Solution_rank1(self):
        """
        tests interpolation of rank 1 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,),w_ref)
        arg[(0,)]=(-0.534026548325+0.823628161058j)*x[0]**o + ((-0.681453718989-0.107405600086j))*x[0] + ((0.15115309767+0.660583985491j))*x[1]**o + ((-0.533330559391+0.722435922992j))*x[1]
        ref[(0,)]=(-0.534026548325+0.823628161058j)*x_ref[0]**o + ((-0.681453718989-0.107405600086j))*x_ref[0] + ((0.15115309767+0.660583985491j))*x_ref[1]**o + ((-0.533330559391+0.722435922992j))*x_ref[1]
        arg[(1,)]=(0.876204861477+0.391609052829j)*x[0]**o + ((0.856477420313+0.0502331446209j))*x[0] + ((0.339226258451-0.46256156301j))*x[1]**o + ((0.341094620948-0.912185277361j))*x[1]
        ref[(1,)]=(0.876204861477+0.391609052829j)*x_ref[0]**o + ((0.856477420313+0.0502331446209j))*x_ref[0] + ((0.339226258451-0.46256156301j))*x_ref[1]**o + ((0.341094620948-0.912185277361j))*x_ref[1]
        arg[(2,)]=(-0.585418147612-0.698847765909j)*x[0]**o + ((0.367324855894+0.830845266384j))*x[0] + ((-0.468856428895+0.0207415507074j))*x[1]**o + ((0.681010703731-0.0920458616691j))*x[1]
        ref[(2,)]=(-0.585418147612-0.698847765909j)*x_ref[0]**o + ((0.367324855894+0.830845266384j))*x_ref[0] + ((-0.468856428895+0.0207415507074j))*x_ref[1]**o + ((0.681010703731-0.0920458616691j))*x_ref[1]
        arg[(3,)]=(-0.597096528178+0.462102098158j)*x[0]**o + ((-0.0241706514501+0.842377507026j))*x[0] + ((-0.0289682158012+0.392741657713j))*x[1]**o + ((0.350862616652-0.465759620796j))*x[1]
        ref[(3,)]=(-0.597096528178+0.462102098158j)*x_ref[0]**o + ((-0.0241706514501+0.842377507026j))*x_ref[0] + ((-0.0289682158012+0.392741657713j))*x_ref[1]**o + ((0.350862616652-0.465759620796j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.579356681097-0.292960012958j)*x[2]**o + ((0.106619221359-0.17584296177j))*x[2]
            ref[(0,)]+=(-0.579356681097-0.292960012958j)*x_ref[2]**o + ((0.106619221359-0.17584296177j))*x_ref[2]
            arg[(1,)]+=(-0.870316254897-0.881748779215j)*x[2]**o + ((-0.711677772531-0.147680589558j))*x[2]
            ref[(1,)]+=(-0.870316254897-0.881748779215j)*x_ref[2]**o + ((-0.711677772531-0.147680589558j))*x_ref[2]
            arg[(2,)]+=(0.858918356378-0.212719031215j)*x[2]**o + ((0.736051262116-0.954922037555j))*x[2]
            ref[(2,)]+=(0.858918356378-0.212719031215j)*x_ref[2]**o + ((0.736051262116-0.954922037555j))*x_ref[2]
            arg[(3,)]+=(0.743751824306+0.93420375479j)*x[2]**o + ((-0.539852921789-0.859866857256j))*x[2]
            ref[(3,)]+=(0.743751824306+0.93420375479j)*x_ref[2]**o + ((-0.539852921789-0.859866857256j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_Solution_rank2(self):
        """
        tests interpolation of rank 2 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3),w_ref)
        arg[(0, 0)]=(0.101818937056+0.830278008122j)*x[0]**o + ((-0.273444552373+0.326084339812j))*x[0] + ((-0.198305170572-0.301357794034j))*x[1]**o + ((0.587862609402-0.737017426736j))*x[1]
        ref[(0, 0)]=(0.101818937056+0.830278008122j)*x_ref[0]**o + ((-0.273444552373+0.326084339812j))*x_ref[0] + ((-0.198305170572-0.301357794034j))*x_ref[1]**o + ((0.587862609402-0.737017426736j))*x_ref[1]
        arg[(0, 1)]=(-0.917184531766-0.781085376875j)*x[0]**o + ((0.176083921396-0.043999216278j))*x[0] + ((-0.403781322768+0.647980776382j))*x[1]**o + ((-0.747486795102-0.728606614514j))*x[1]
        ref[(0, 1)]=(-0.917184531766-0.781085376875j)*x_ref[0]**o + ((0.176083921396-0.043999216278j))*x_ref[0] + ((-0.403781322768+0.647980776382j))*x_ref[1]**o + ((-0.747486795102-0.728606614514j))*x_ref[1]
        arg[(0, 2)]=(-0.0280690436103-0.390171868454j)*x[0]**o + ((0.675803627791-0.876975878922j))*x[0] + ((-0.429251444254-0.591402119599j))*x[1]**o + ((-0.60168308884-0.412098862671j))*x[1]
        ref[(0, 2)]=(-0.0280690436103-0.390171868454j)*x_ref[0]**o + ((0.675803627791-0.876975878922j))*x_ref[0] + ((-0.429251444254-0.591402119599j))*x_ref[1]**o + ((-0.60168308884-0.412098862671j))*x_ref[1]
        arg[(1, 0)]=(0.733248224233+0.678596053865j)*x[0]**o + ((0.454575315721-0.196534931708j))*x[0] + ((-0.526131771649-0.463822414295j))*x[1]**o + ((0.670548163418+0.725505513549j))*x[1]
        ref[(1, 0)]=(0.733248224233+0.678596053865j)*x_ref[0]**o + ((0.454575315721-0.196534931708j))*x_ref[0] + ((-0.526131771649-0.463822414295j))*x_ref[1]**o + ((0.670548163418+0.725505513549j))*x_ref[1]
        arg[(1, 1)]=(-0.563193367651+0.756018459509j)*x[0]**o + ((-0.0513825088844+0.0172110313046j))*x[0] + ((-0.907134193283+0.280627978105j))*x[1]**o + ((-0.481396822479+0.686998849487j))*x[1]
        ref[(1, 1)]=(-0.563193367651+0.756018459509j)*x_ref[0]**o + ((-0.0513825088844+0.0172110313046j))*x_ref[0] + ((-0.907134193283+0.280627978105j))*x_ref[1]**o + ((-0.481396822479+0.686998849487j))*x_ref[1]
        arg[(1, 2)]=(0.420168996367-0.912966175575j)*x[0]**o + ((0.382902716726+0.897351422989j))*x[0] + ((-0.0907048399739-0.708172756524j))*x[1]**o + ((0.718600774601-0.426906674812j))*x[1]
        ref[(1, 2)]=(0.420168996367-0.912966175575j)*x_ref[0]**o + ((0.382902716726+0.897351422989j))*x_ref[0] + ((-0.0907048399739-0.708172756524j))*x_ref[1]**o + ((0.718600774601-0.426906674812j))*x_ref[1]
        arg[(2, 0)]=(-0.296995359227-0.296185376108j)*x[0]**o + ((-0.664223000995-0.209822211365j))*x[0] + ((-0.844339568205+0.149208206576j))*x[1]**o + ((-0.419344257155-0.620087985377j))*x[1]
        ref[(2, 0)]=(-0.296995359227-0.296185376108j)*x_ref[0]**o + ((-0.664223000995-0.209822211365j))*x_ref[0] + ((-0.844339568205+0.149208206576j))*x_ref[1]**o + ((-0.419344257155-0.620087985377j))*x_ref[1]
        arg[(2, 1)]=(-0.921561432374+0.104987921404j)*x[0]**o + ((0.124875627611-0.659445984487j))*x[0] + ((-0.703520424357-0.688999302901j))*x[1]**o + ((-0.81870952423-0.570730856769j))*x[1]
        ref[(2, 1)]=(-0.921561432374+0.104987921404j)*x_ref[0]**o + ((0.124875627611-0.659445984487j))*x_ref[0] + ((-0.703520424357-0.688999302901j))*x_ref[1]**o + ((-0.81870952423-0.570730856769j))*x_ref[1]
        arg[(2, 2)]=(-0.287588962766-0.630190818851j)*x[0]**o + ((0.569212619822-0.992429853973j))*x[0] + ((-0.8564414261-0.985741678393j))*x[1]**o + ((-0.732554888758+0.966185673186j))*x[1]
        ref[(2, 2)]=(-0.287588962766-0.630190818851j)*x_ref[0]**o + ((0.569212619822-0.992429853973j))*x_ref[0] + ((-0.8564414261-0.985741678393j))*x_ref[1]**o + ((-0.732554888758+0.966185673186j))*x_ref[1]
        arg[(3, 0)]=(-0.75346528047-0.0766371721969j)*x[0]**o + ((-0.511262658866-0.448469948506j))*x[0] + ((0.087794970596+0.789519471766j))*x[1]**o + ((0.200062160314-0.559377554808j))*x[1]
        ref[(3, 0)]=(-0.75346528047-0.0766371721969j)*x_ref[0]**o + ((-0.511262658866-0.448469948506j))*x_ref[0] + ((0.087794970596+0.789519471766j))*x_ref[1]**o + ((0.200062160314-0.559377554808j))*x_ref[1]
        arg[(3, 1)]=(0.92535567273-0.983932331733j)*x[0]**o + ((0.979011533335-0.0173084647605j))*x[0] + ((-0.00810472627548-0.416367886969j))*x[1]**o + ((0.644374342612+0.774975611522j))*x[1]
        ref[(3, 1)]=(0.92535567273-0.983932331733j)*x_ref[0]**o + ((0.979011533335-0.0173084647605j))*x_ref[0] + ((-0.00810472627548-0.416367886969j))*x_ref[1]**o + ((0.644374342612+0.774975611522j))*x_ref[1]
        arg[(3, 2)]=(-0.786028905027-0.911189769152j)*x[0]**o + ((0.866205457142-0.8763553932j))*x[0] + ((0.90548522563-0.482047583482j))*x[1]**o + ((-0.704641918594+0.974879388156j))*x[1]
        ref[(3, 2)]=(-0.786028905027-0.911189769152j)*x_ref[0]**o + ((0.866205457142-0.8763553932j))*x_ref[0] + ((0.90548522563-0.482047583482j))*x_ref[1]**o + ((-0.704641918594+0.974879388156j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(-0.572682727765+0.0378493854313j)*x[2]**o + ((-0.543221093903-0.859964978735j))*x[2]
            ref[(0, 0)]+=(-0.572682727765+0.0378493854313j)*x_ref[2]**o + ((-0.543221093903-0.859964978735j))*x_ref[2]
            arg[(0, 1)]+=(0.329933383568+0.0305466878015j)*x[2]**o + ((-0.550014593377+0.590391838121j))*x[2]
            ref[(0, 1)]+=(0.329933383568+0.0305466878015j)*x_ref[2]**o + ((-0.550014593377+0.590391838121j))*x_ref[2]
            arg[(0, 2)]+=(0.275491781358-0.197469728417j)*x[2]**o + ((0.801527370793-0.59207890324j))*x[2]
            ref[(0, 2)]+=(0.275491781358-0.197469728417j)*x_ref[2]**o + ((0.801527370793-0.59207890324j))*x_ref[2]
            arg[(1, 0)]+=(-0.495422659535+0.735002325217j)*x[2]**o + ((0.898466518732+0.309525873761j))*x[2]
            ref[(1, 0)]+=(-0.495422659535+0.735002325217j)*x_ref[2]**o + ((0.898466518732+0.309525873761j))*x_ref[2]
            arg[(1, 1)]+=(-0.825265098264-0.343357510368j)*x[2]**o + ((-0.577339997764+0.774941474873j))*x[2]
            ref[(1, 1)]+=(-0.825265098264-0.343357510368j)*x_ref[2]**o + ((-0.577339997764+0.774941474873j))*x_ref[2]
            arg[(1, 2)]+=(-0.544589516719+0.504689333295j)*x[2]**o + ((-0.390898073265+0.133855798253j))*x[2]
            ref[(1, 2)]+=(-0.544589516719+0.504689333295j)*x_ref[2]**o + ((-0.390898073265+0.133855798253j))*x_ref[2]
            arg[(2, 0)]+=(0.815475468541+0.662553071506j)*x[2]**o + ((0.876175700341-0.120773539904j))*x[2]
            ref[(2, 0)]+=(0.815475468541+0.662553071506j)*x_ref[2]**o + ((0.876175700341-0.120773539904j))*x_ref[2]
            arg[(2, 1)]+=(0.483089788729+0.984225772717j)*x[2]**o + ((-0.133577118013+0.0679531438476j))*x[2]
            ref[(2, 1)]+=(0.483089788729+0.984225772717j)*x_ref[2]**o + ((-0.133577118013+0.0679531438476j))*x_ref[2]
            arg[(2, 2)]+=(0.520774443374+0.921642066675j)*x[2]**o + ((0.273257304511-0.773559391832j))*x[2]
            ref[(2, 2)]+=(0.520774443374+0.921642066675j)*x_ref[2]**o + ((0.273257304511-0.773559391832j))*x_ref[2]
            arg[(3, 0)]+=(-0.22499466035-0.224477634709j)*x[2]**o + ((-0.0117002599906-0.067306771452j))*x[2]
            ref[(3, 0)]+=(-0.22499466035-0.224477634709j)*x_ref[2]**o + ((-0.0117002599906-0.067306771452j))*x_ref[2]
            arg[(3, 1)]+=(-0.638961786699+0.496202376714j)*x[2]**o + ((0.458474744926-0.254751573298j))*x[2]
            ref[(3, 1)]+=(-0.638961786699+0.496202376714j)*x_ref[2]**o + ((0.458474744926-0.254751573298j))*x_ref[2]
            arg[(3, 2)]+=(0.214272885947-0.393952650381j)*x[2]**o + ((0.999100024871+0.297215674366j))*x[2]
            ref[(3, 2)]+=(0.214272885947-0.393952650381j)*x_ref[2]**o + ((0.999100024871+0.297215674366j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_Solution_rank3(self):
        """
        tests interpolation of rank 3 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 3),w)
        ref = Data(0,(4, 4, 3),w_ref)
        arg[(0, 0, 0)]=(0.200941956423+0.901434203848j)*x[0]**o + ((0.373838164227-0.596766344559j))*x[0] + ((0.678174807341-0.874410449342j))*x[1]**o + ((0.894289553448-0.0881008899774j))*x[1]
        ref[(0, 0, 0)]=(0.200941956423+0.901434203848j)*x_ref[0]**o + ((0.373838164227-0.596766344559j))*x_ref[0] + ((0.678174807341-0.874410449342j))*x_ref[1]**o + ((0.894289553448-0.0881008899774j))*x_ref[1]
        arg[(0, 0, 1)]=(0.00978550663074-0.83915415062j)*x[0]**o + ((0.466026272941-0.977980739618j))*x[0] + ((-0.242609882683-0.0527037117978j))*x[1]**o + ((-0.000194554862066+0.0993894639842j))*x[1]
        ref[(0, 0, 1)]=(0.00978550663074-0.83915415062j)*x_ref[0]**o + ((0.466026272941-0.977980739618j))*x_ref[0] + ((-0.242609882683-0.0527037117978j))*x_ref[1]**o + ((-0.000194554862066+0.0993894639842j))*x_ref[1]
        arg[(0, 0, 2)]=(0.0739414763915+0.24774201703j)*x[0]**o + ((-0.281288419056+0.164035740406j))*x[0] + ((0.587502976926+0.846968969624j))*x[1]**o + ((-0.682050413709+0.225310088646j))*x[1]
        ref[(0, 0, 2)]=(0.0739414763915+0.24774201703j)*x_ref[0]**o + ((-0.281288419056+0.164035740406j))*x_ref[0] + ((0.587502976926+0.846968969624j))*x_ref[1]**o + ((-0.682050413709+0.225310088646j))*x_ref[1]
        arg[(0, 1, 0)]=(-0.485538724892-0.0159022563711j)*x[0]**o + ((0.290893242534+0.8333803406j))*x[0] + ((0.406488720299+0.214187275793j))*x[1]**o + ((-0.825066086994-0.538094507729j))*x[1]
        ref[(0, 1, 0)]=(-0.485538724892-0.0159022563711j)*x_ref[0]**o + ((0.290893242534+0.8333803406j))*x_ref[0] + ((0.406488720299+0.214187275793j))*x_ref[1]**o + ((-0.825066086994-0.538094507729j))*x_ref[1]
        arg[(0, 1, 1)]=(-0.717141967204-0.850644449008j)*x[0]**o + ((0.300267534437+0.652634823012j))*x[0] + ((-0.235346094369-0.0259247052604j))*x[1]**o + ((-0.944835778459+0.989656751335j))*x[1]
        ref[(0, 1, 1)]=(-0.717141967204-0.850644449008j)*x_ref[0]**o + ((0.300267534437+0.652634823012j))*x_ref[0] + ((-0.235346094369-0.0259247052604j))*x_ref[1]**o + ((-0.944835778459+0.989656751335j))*x_ref[1]
        arg[(0, 1, 2)]=(-0.541601524187+0.146205868177j)*x[0]**o + ((0.834551815591+0.123853179359j))*x[0] + ((0.870747853272-0.521567959376j))*x[1]**o + ((-0.0168664397366+0.613364319341j))*x[1]
        ref[(0, 1, 2)]=(-0.541601524187+0.146205868177j)*x_ref[0]**o + ((0.834551815591+0.123853179359j))*x_ref[0] + ((0.870747853272-0.521567959376j))*x_ref[1]**o + ((-0.0168664397366+0.613364319341j))*x_ref[1]
        arg[(0, 2, 0)]=(-0.436616199417+0.0267403930595j)*x[0]**o + ((0.595356278707-0.544412154466j))*x[0] + ((-0.409240836883+0.878320617494j))*x[1]**o + ((0.111749811866+0.699255468768j))*x[1]
        ref[(0, 2, 0)]=(-0.436616199417+0.0267403930595j)*x_ref[0]**o + ((0.595356278707-0.544412154466j))*x_ref[0] + ((-0.409240836883+0.878320617494j))*x_ref[1]**o + ((0.111749811866+0.699255468768j))*x_ref[1]
        arg[(0, 2, 1)]=(0.250216647826-0.375160277823j)*x[0]**o + ((0.652862707445-0.753376031111j))*x[0] + ((0.956521709784-0.237654619247j))*x[1]**o + ((0.805680681752+0.527882635475j))*x[1]
        ref[(0, 2, 1)]=(0.250216647826-0.375160277823j)*x_ref[0]**o + ((0.652862707445-0.753376031111j))*x_ref[0] + ((0.956521709784-0.237654619247j))*x_ref[1]**o + ((0.805680681752+0.527882635475j))*x_ref[1]
        arg[(0, 2, 2)]=(-0.921285628972-0.7827109155j)*x[0]**o + ((-0.203506215104+0.484696261674j))*x[0] + ((0.495914164888-0.712706001722j))*x[1]**o + ((0.29343032465-0.470360043847j))*x[1]
        ref[(0, 2, 2)]=(-0.921285628972-0.7827109155j)*x_ref[0]**o + ((-0.203506215104+0.484696261674j))*x_ref[0] + ((0.495914164888-0.712706001722j))*x_ref[1]**o + ((0.29343032465-0.470360043847j))*x_ref[1]
        arg[(0, 3, 0)]=(0.49614197334+0.331276450485j)*x[0]**o + ((0.469034815444-0.25774375702j))*x[0] + ((0.0932560032293+0.0731914669812j))*x[1]**o + ((-0.496349209508-0.182469990199j))*x[1]
        ref[(0, 3, 0)]=(0.49614197334+0.331276450485j)*x_ref[0]**o + ((0.469034815444-0.25774375702j))*x_ref[0] + ((0.0932560032293+0.0731914669812j))*x_ref[1]**o + ((-0.496349209508-0.182469990199j))*x_ref[1]
        arg[(0, 3, 1)]=(0.783874255102-0.833065542931j)*x[0]**o + ((-0.973393422909+0.451055419337j))*x[0] + ((0.06712340345+0.894964985464j))*x[1]**o + ((-0.652230104767+0.143494031478j))*x[1]
        ref[(0, 3, 1)]=(0.783874255102-0.833065542931j)*x_ref[0]**o + ((-0.973393422909+0.451055419337j))*x_ref[0] + ((0.06712340345+0.894964985464j))*x_ref[1]**o + ((-0.652230104767+0.143494031478j))*x_ref[1]
        arg[(0, 3, 2)]=(0.181500984212-0.83026884682j)*x[0]**o + ((0.93710623942-0.294154569495j))*x[0] + ((0.742598695887+0.153830992719j))*x[1]**o + ((-0.164621421395-0.465333170717j))*x[1]
        ref[(0, 3, 2)]=(0.181500984212-0.83026884682j)*x_ref[0]**o + ((0.93710623942-0.294154569495j))*x_ref[0] + ((0.742598695887+0.153830992719j))*x_ref[1]**o + ((-0.164621421395-0.465333170717j))*x_ref[1]
        arg[(1, 0, 0)]=(-0.370223296806-0.531385755126j)*x[0]**o + ((0.243009535044-0.113376265706j))*x[0] + ((0.501893673545-0.170807969827j))*x[1]**o + ((-0.606836669365+0.295672887852j))*x[1]
        ref[(1, 0, 0)]=(-0.370223296806-0.531385755126j)*x_ref[0]**o + ((0.243009535044-0.113376265706j))*x_ref[0] + ((0.501893673545-0.170807969827j))*x_ref[1]**o + ((-0.606836669365+0.295672887852j))*x_ref[1]
        arg[(1, 0, 1)]=(0.371176521683+0.739008710226j)*x[0]**o + ((0.833772714901-0.782594659894j))*x[0] + ((0.438147020312+0.656553735944j))*x[1]**o + ((-0.275372964538+0.925486505357j))*x[1]
        ref[(1, 0, 1)]=(0.371176521683+0.739008710226j)*x_ref[0]**o + ((0.833772714901-0.782594659894j))*x_ref[0] + ((0.438147020312+0.656553735944j))*x_ref[1]**o + ((-0.275372964538+0.925486505357j))*x_ref[1]
        arg[(1, 0, 2)]=(0.939103634861+0.791442121517j)*x[0]**o + ((0.183886500362+0.596029851551j))*x[0] + ((0.951888442622-0.400012701685j))*x[1]**o + ((-0.242476276941+0.0717713096668j))*x[1]
        ref[(1, 0, 2)]=(0.939103634861+0.791442121517j)*x_ref[0]**o + ((0.183886500362+0.596029851551j))*x_ref[0] + ((0.951888442622-0.400012701685j))*x_ref[1]**o + ((-0.242476276941+0.0717713096668j))*x_ref[1]
        arg[(1, 1, 0)]=(0.135997026891-0.545043088948j)*x[0]**o + ((-0.965790999669+0.81019931186j))*x[0] + ((0.583891347447+0.164133541759j))*x[1]**o + ((0.439630523362-0.181358401654j))*x[1]
        ref[(1, 1, 0)]=(0.135997026891-0.545043088948j)*x_ref[0]**o + ((-0.965790999669+0.81019931186j))*x_ref[0] + ((0.583891347447+0.164133541759j))*x_ref[1]**o + ((0.439630523362-0.181358401654j))*x_ref[1]
        arg[(1, 1, 1)]=(-0.870140582936+0.518281243825j)*x[0]**o + ((0.867090083484+0.278767357805j))*x[0] + ((-0.154401276835-0.771558159791j))*x[1]**o + ((-0.948854426198+0.110048352469j))*x[1]
        ref[(1, 1, 1)]=(-0.870140582936+0.518281243825j)*x_ref[0]**o + ((0.867090083484+0.278767357805j))*x_ref[0] + ((-0.154401276835-0.771558159791j))*x_ref[1]**o + ((-0.948854426198+0.110048352469j))*x_ref[1]
        arg[(1, 1, 2)]=(0.771699013918-0.404929125308j)*x[0]**o + ((-0.429772470433-0.150900502645j))*x[0] + ((0.0516967471824-0.366456394089j))*x[1]**o + ((0.704446220775-0.333065876212j))*x[1]
        ref[(1, 1, 2)]=(0.771699013918-0.404929125308j)*x_ref[0]**o + ((-0.429772470433-0.150900502645j))*x_ref[0] + ((0.0516967471824-0.366456394089j))*x_ref[1]**o + ((0.704446220775-0.333065876212j))*x_ref[1]
        arg[(1, 2, 0)]=(-0.861464969274+0.212294756825j)*x[0]**o + ((0.690428904999+0.336579674973j))*x[0] + ((-0.432944806214-0.467905769445j))*x[1]**o + ((-0.30459391089+0.482407004476j))*x[1]
        ref[(1, 2, 0)]=(-0.861464969274+0.212294756825j)*x_ref[0]**o + ((0.690428904999+0.336579674973j))*x_ref[0] + ((-0.432944806214-0.467905769445j))*x_ref[1]**o + ((-0.30459391089+0.482407004476j))*x_ref[1]
        arg[(1, 2, 1)]=(-0.838773091401-0.372149699902j)*x[0]**o + ((0.374735627606+0.317306112586j))*x[0] + ((-0.815180267445+0.469689771829j))*x[1]**o + ((0.539643598661-0.259414262225j))*x[1]
        ref[(1, 2, 1)]=(-0.838773091401-0.372149699902j)*x_ref[0]**o + ((0.374735627606+0.317306112586j))*x_ref[0] + ((-0.815180267445+0.469689771829j))*x_ref[1]**o + ((0.539643598661-0.259414262225j))*x_ref[1]
        arg[(1, 2, 2)]=(-0.415027354188-0.497354790159j)*x[0]**o + ((-0.299880381887+0.477532320229j))*x[0] + ((0.0230021270268-0.762225741344j))*x[1]**o + ((0.921151152104-0.904037152887j))*x[1]
        ref[(1, 2, 2)]=(-0.415027354188-0.497354790159j)*x_ref[0]**o + ((-0.299880381887+0.477532320229j))*x_ref[0] + ((0.0230021270268-0.762225741344j))*x_ref[1]**o + ((0.921151152104-0.904037152887j))*x_ref[1]
        arg[(1, 3, 0)]=(-0.429695229136-0.598869046469j)*x[0]**o + ((0.36209035488-0.858060406146j))*x[0] + ((-0.640702280399-0.374447537085j))*x[1]**o + ((0.705670406209+0.654979189107j))*x[1]
        ref[(1, 3, 0)]=(-0.429695229136-0.598869046469j)*x_ref[0]**o + ((0.36209035488-0.858060406146j))*x_ref[0] + ((-0.640702280399-0.374447537085j))*x_ref[1]**o + ((0.705670406209+0.654979189107j))*x_ref[1]
        arg[(1, 3, 1)]=(-0.222918412432+0.864476252632j)*x[0]**o + ((-0.733542960489-0.615826484692j))*x[0] + ((0.249193448384+0.584596624538j))*x[1]**o + ((-0.926772133435-0.250766930409j))*x[1]
        ref[(1, 3, 1)]=(-0.222918412432+0.864476252632j)*x_ref[0]**o + ((-0.733542960489-0.615826484692j))*x_ref[0] + ((0.249193448384+0.584596624538j))*x_ref[1]**o + ((-0.926772133435-0.250766930409j))*x_ref[1]
        arg[(1, 3, 2)]=(-0.112122892932-0.531959156025j)*x[0]**o + ((0.826977598956-0.292562901516j))*x[0] + ((-0.697979729456+0.107907186445j))*x[1]**o + ((0.27331653158-0.0830431414505j))*x[1]
        ref[(1, 3, 2)]=(-0.112122892932-0.531959156025j)*x_ref[0]**o + ((0.826977598956-0.292562901516j))*x_ref[0] + ((-0.697979729456+0.107907186445j))*x_ref[1]**o + ((0.27331653158-0.0830431414505j))*x_ref[1]
        arg[(2, 0, 0)]=(-0.126307371631+0.431749098887j)*x[0]**o + ((-0.516946308555+0.936801216411j))*x[0] + ((-0.862501269697-0.673307349514j))*x[1]**o + ((-0.589193786818-0.259159211349j))*x[1]
        ref[(2, 0, 0)]=(-0.126307371631+0.431749098887j)*x_ref[0]**o + ((-0.516946308555+0.936801216411j))*x_ref[0] + ((-0.862501269697-0.673307349514j))*x_ref[1]**o + ((-0.589193786818-0.259159211349j))*x_ref[1]
        arg[(2, 0, 1)]=(-0.894519995594+0.471410639269j)*x[0]**o + ((0.118819122348+0.212634544404j))*x[0] + ((0.684577283733-0.191608025898j))*x[1]**o + ((0.783115160578-0.0280471096537j))*x[1]
        ref[(2, 0, 1)]=(-0.894519995594+0.471410639269j)*x_ref[0]**o + ((0.118819122348+0.212634544404j))*x_ref[0] + ((0.684577283733-0.191608025898j))*x_ref[1]**o + ((0.783115160578-0.0280471096537j))*x_ref[1]
        arg[(2, 0, 2)]=(0.317297513718+0.670628719559j)*x[0]**o + ((0.0319251072587+0.0515338450489j))*x[0] + ((0.570972960997-0.746624609411j))*x[1]**o + ((-0.367296062865-0.302779147166j))*x[1]
        ref[(2, 0, 2)]=(0.317297513718+0.670628719559j)*x_ref[0]**o + ((0.0319251072587+0.0515338450489j))*x_ref[0] + ((0.570972960997-0.746624609411j))*x_ref[1]**o + ((-0.367296062865-0.302779147166j))*x_ref[1]
        arg[(2, 1, 0)]=(0.824095470651-0.000317827218j)*x[0]**o + ((0.890063349981+0.639784675812j))*x[0] + ((0.033755237755-0.150877403689j))*x[1]**o + ((0.65412054537-0.428249936598j))*x[1]
        ref[(2, 1, 0)]=(0.824095470651-0.000317827218j)*x_ref[0]**o + ((0.890063349981+0.639784675812j))*x_ref[0] + ((0.033755237755-0.150877403689j))*x_ref[1]**o + ((0.65412054537-0.428249936598j))*x_ref[1]
        arg[(2, 1, 1)]=(-0.722142439758+0.172342714473j)*x[0]**o + ((0.0592071337863-0.942696255912j))*x[0] + ((0.400684171261-0.866574811663j))*x[1]**o + ((-0.31980592899+0.372537939628j))*x[1]
        ref[(2, 1, 1)]=(-0.722142439758+0.172342714473j)*x_ref[0]**o + ((0.0592071337863-0.942696255912j))*x_ref[0] + ((0.400684171261-0.866574811663j))*x_ref[1]**o + ((-0.31980592899+0.372537939628j))*x_ref[1]
        arg[(2, 1, 2)]=(-0.59150305214-0.21894034977j)*x[0]**o + ((-0.580441498141+0.838907030792j))*x[0] + ((-0.717171204638+0.66134514366j))*x[1]**o + ((-0.528802248087+0.63725043045j))*x[1]
        ref[(2, 1, 2)]=(-0.59150305214-0.21894034977j)*x_ref[0]**o + ((-0.580441498141+0.838907030792j))*x_ref[0] + ((-0.717171204638+0.66134514366j))*x_ref[1]**o + ((-0.528802248087+0.63725043045j))*x_ref[1]
        arg[(2, 2, 0)]=(-0.012590201617+0.749463371388j)*x[0]**o + ((0.306928141288-0.650248399472j))*x[0] + ((-0.345721270173+0.971910099408j))*x[1]**o + ((-0.975680915195+0.989260348307j))*x[1]
        ref[(2, 2, 0)]=(-0.012590201617+0.749463371388j)*x_ref[0]**o + ((0.306928141288-0.650248399472j))*x_ref[0] + ((-0.345721270173+0.971910099408j))*x_ref[1]**o + ((-0.975680915195+0.989260348307j))*x_ref[1]
        arg[(2, 2, 1)]=(-0.726274547899+0.492148483791j)*x[0]**o + ((0.283494163197+0.721055300813j))*x[0] + ((-0.464083145862-0.547305200538j))*x[1]**o + ((-0.828122450232+0.717526260027j))*x[1]
        ref[(2, 2, 1)]=(-0.726274547899+0.492148483791j)*x_ref[0]**o + ((0.283494163197+0.721055300813j))*x_ref[0] + ((-0.464083145862-0.547305200538j))*x_ref[1]**o + ((-0.828122450232+0.717526260027j))*x_ref[1]
        arg[(2, 2, 2)]=(0.888449219672-0.969079827769j)*x[0]**o + ((-0.26792796714+0.153302809825j))*x[0] + ((-0.703891401141-0.0861105129101j))*x[1]**o + ((0.599756541892+0.821760156989j))*x[1]
        ref[(2, 2, 2)]=(0.888449219672-0.969079827769j)*x_ref[0]**o + ((-0.26792796714+0.153302809825j))*x_ref[0] + ((-0.703891401141-0.0861105129101j))*x_ref[1]**o + ((0.599756541892+0.821760156989j))*x_ref[1]
        arg[(2, 3, 0)]=(-0.844726932821-0.985721464539j)*x[0]**o + ((0.391329480674+0.173313383683j))*x[0] + ((-0.193676259782+0.731320723712j))*x[1]**o + ((0.0154640628665-0.267160109222j))*x[1]
        ref[(2, 3, 0)]=(-0.844726932821-0.985721464539j)*x_ref[0]**o + ((0.391329480674+0.173313383683j))*x_ref[0] + ((-0.193676259782+0.731320723712j))*x_ref[1]**o + ((0.0154640628665-0.267160109222j))*x_ref[1]
        arg[(2, 3, 1)]=(0.78642988096+0.524457308012j)*x[0]**o + ((-0.945644823961+0.410938790365j))*x[0] + ((0.755522030785-0.240375547561j))*x[1]**o + ((0.927535550722+0.943195600822j))*x[1]
        ref[(2, 3, 1)]=(0.78642988096+0.524457308012j)*x_ref[0]**o + ((-0.945644823961+0.410938790365j))*x_ref[0] + ((0.755522030785-0.240375547561j))*x_ref[1]**o + ((0.927535550722+0.943195600822j))*x_ref[1]
        arg[(2, 3, 2)]=(-0.551533852516-0.842985798261j)*x[0]**o + ((-0.516618118103-0.214942454099j))*x[0] + ((-0.487452048592+0.59022242562j))*x[1]**o + ((0.791146897797-0.785395697078j))*x[1]
        ref[(2, 3, 2)]=(-0.551533852516-0.842985798261j)*x_ref[0]**o + ((-0.516618118103-0.214942454099j))*x_ref[0] + ((-0.487452048592+0.59022242562j))*x_ref[1]**o + ((0.791146897797-0.785395697078j))*x_ref[1]
        arg[(3, 0, 0)]=(-0.251532025974+0.157846258244j)*x[0]**o + ((-0.199412642313+0.0713841978393j))*x[0] + ((-0.201190931154+0.554561667383j))*x[1]**o + ((-0.0762014481081-0.779942853598j))*x[1]
        ref[(3, 0, 0)]=(-0.251532025974+0.157846258244j)*x_ref[0]**o + ((-0.199412642313+0.0713841978393j))*x_ref[0] + ((-0.201190931154+0.554561667383j))*x_ref[1]**o + ((-0.0762014481081-0.779942853598j))*x_ref[1]
        arg[(3, 0, 1)]=(0.0752357893894+0.781061272629j)*x[0]**o + ((0.390554865349+0.58643453351j))*x[0] + ((0.822793499074+0.138732777002j))*x[1]**o + ((-0.243782825344-0.0255859507384j))*x[1]
        ref[(3, 0, 1)]=(0.0752357893894+0.781061272629j)*x_ref[0]**o + ((0.390554865349+0.58643453351j))*x_ref[0] + ((0.822793499074+0.138732777002j))*x_ref[1]**o + ((-0.243782825344-0.0255859507384j))*x_ref[1]
        arg[(3, 0, 2)]=(0.255078625567-0.01012740377j)*x[0]**o + ((-0.987555725197+0.390406938624j))*x[0] + ((0.11735410247-0.532484868979j))*x[1]**o + ((-0.274024974701-0.455159959231j))*x[1]
        ref[(3, 0, 2)]=(0.255078625567-0.01012740377j)*x_ref[0]**o + ((-0.987555725197+0.390406938624j))*x_ref[0] + ((0.11735410247-0.532484868979j))*x_ref[1]**o + ((-0.274024974701-0.455159959231j))*x_ref[1]
        arg[(3, 1, 0)]=(-0.196509727464-0.344501809871j)*x[0]**o + ((0.660697265497-0.874632656356j))*x[0] + ((0.218974775957-0.301802347582j))*x[1]**o + ((0.444722250508-0.701330719978j))*x[1]
        ref[(3, 1, 0)]=(-0.196509727464-0.344501809871j)*x_ref[0]**o + ((0.660697265497-0.874632656356j))*x_ref[0] + ((0.218974775957-0.301802347582j))*x_ref[1]**o + ((0.444722250508-0.701330719978j))*x_ref[1]
        arg[(3, 1, 1)]=(-0.459212462492-0.589411793398j)*x[0]**o + ((0.6992909805+0.441909979247j))*x[0] + ((-0.234616395001+0.298262002229j))*x[1]**o + ((-0.314096257596-0.402323385572j))*x[1]
        ref[(3, 1, 1)]=(-0.459212462492-0.589411793398j)*x_ref[0]**o + ((0.6992909805+0.441909979247j))*x_ref[0] + ((-0.234616395001+0.298262002229j))*x_ref[1]**o + ((-0.314096257596-0.402323385572j))*x_ref[1]
        arg[(3, 1, 2)]=(0.681863906859+0.973014202821j)*x[0]**o + ((-0.484920073203+0.586522991673j))*x[0] + ((-0.516188821642-0.415957638674j))*x[1]**o + ((-0.610736508056-0.994985390338j))*x[1]
        ref[(3, 1, 2)]=(0.681863906859+0.973014202821j)*x_ref[0]**o + ((-0.484920073203+0.586522991673j))*x_ref[0] + ((-0.516188821642-0.415957638674j))*x_ref[1]**o + ((-0.610736508056-0.994985390338j))*x_ref[1]
        arg[(3, 2, 0)]=(-0.794866671218+0.17125175007j)*x[0]**o + ((0.0599179852878-0.567372511165j))*x[0] + ((0.800853524974+0.526025944687j))*x[1]**o + ((0.0020117409797+0.70340752312j))*x[1]
        ref[(3, 2, 0)]=(-0.794866671218+0.17125175007j)*x_ref[0]**o + ((0.0599179852878-0.567372511165j))*x_ref[0] + ((0.800853524974+0.526025944687j))*x_ref[1]**o + ((0.0020117409797+0.70340752312j))*x_ref[1]
        arg[(3, 2, 1)]=(0.509211221391+0.572163517378j)*x[0]**o + ((0.805362557513-0.489011289014j))*x[0] + ((0.630720597783-0.0595139640392j))*x[1]**o + ((0.481692529832-0.707020688884j))*x[1]
        ref[(3, 2, 1)]=(0.509211221391+0.572163517378j)*x_ref[0]**o + ((0.805362557513-0.489011289014j))*x_ref[0] + ((0.630720597783-0.0595139640392j))*x_ref[1]**o + ((0.481692529832-0.707020688884j))*x_ref[1]
        arg[(3, 2, 2)]=(0.355004282431-0.0169378217647j)*x[0]**o + ((0.848743179876+0.71576239842j))*x[0] + ((0.201338683675+0.6396016667j))*x[1]**o + ((0.778423886197-0.106194756866j))*x[1]
        ref[(3, 2, 2)]=(0.355004282431-0.0169378217647j)*x_ref[0]**o + ((0.848743179876+0.71576239842j))*x_ref[0] + ((0.201338683675+0.6396016667j))*x_ref[1]**o + ((0.778423886197-0.106194756866j))*x_ref[1]
        arg[(3, 3, 0)]=(-0.0799341707689-0.306231879951j)*x[0]**o + ((0.810966617383-0.696190620014j))*x[0] + ((-0.863479610776-0.0580699244758j))*x[1]**o + ((0.763757003573+0.779282892505j))*x[1]
        ref[(3, 3, 0)]=(-0.0799341707689-0.306231879951j)*x_ref[0]**o + ((0.810966617383-0.696190620014j))*x_ref[0] + ((-0.863479610776-0.0580699244758j))*x_ref[1]**o + ((0.763757003573+0.779282892505j))*x_ref[1]
        arg[(3, 3, 1)]=(0.347465905458+0.140854505464j)*x[0]**o + ((0.446052895596+0.380814281236j))*x[0] + ((0.324303254577+0.201440074318j))*x[1]**o + ((-0.971876383082-0.872933331208j))*x[1]
        ref[(3, 3, 1)]=(0.347465905458+0.140854505464j)*x_ref[0]**o + ((0.446052895596+0.380814281236j))*x_ref[0] + ((0.324303254577+0.201440074318j))*x_ref[1]**o + ((-0.971876383082-0.872933331208j))*x_ref[1]
        arg[(3, 3, 2)]=(-0.978681832676-0.868920715117j)*x[0]**o + ((-0.235238757251-0.704479783498j))*x[0] + ((-0.411350631915+0.688541104238j))*x[1]**o + ((-0.797154520044+0.897352848581j))*x[1]
        ref[(3, 3, 2)]=(-0.978681832676-0.868920715117j)*x_ref[0]**o + ((-0.235238757251-0.704479783498j))*x_ref[0] + ((-0.411350631915+0.688541104238j))*x_ref[1]**o + ((-0.797154520044+0.897352848581j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.741789208941-0.877911304942j)*x[2]**o + ((-0.995123761637-0.729474852646j))*x[2]
            ref[(0, 0, 0)]+=(-0.741789208941-0.877911304942j)*x_ref[2]**o + ((-0.995123761637-0.729474852646j))*x_ref[2]
            arg[(0, 0, 1)]+=(-0.664121949604+0.845405473865j)*x[2]**o + ((-0.390962655165-0.0178502105199j))*x[2]
            ref[(0, 0, 1)]+=(-0.664121949604+0.845405473865j)*x_ref[2]**o + ((-0.390962655165-0.0178502105199j))*x_ref[2]
            arg[(0, 0, 2)]+=(-0.0700427259447+0.077701596966j)*x[2]**o + ((0.167736115371-0.106551141553j))*x[2]
            ref[(0, 0, 2)]+=(-0.0700427259447+0.077701596966j)*x_ref[2]**o + ((0.167736115371-0.106551141553j))*x_ref[2]
            arg[(0, 1, 0)]+=(-0.831101659348-0.288138517486j)*x[2]**o + ((-0.160987242031+0.531764590493j))*x[2]
            ref[(0, 1, 0)]+=(-0.831101659348-0.288138517486j)*x_ref[2]**o + ((-0.160987242031+0.531764590493j))*x_ref[2]
            arg[(0, 1, 1)]+=(-0.610663858267+0.644520277094j)*x[2]**o + ((0.723082432816-0.419887095057j))*x[2]
            ref[(0, 1, 1)]+=(-0.610663858267+0.644520277094j)*x_ref[2]**o + ((0.723082432816-0.419887095057j))*x_ref[2]
            arg[(0, 1, 2)]+=(0.937343293525-0.0320725486197j)*x[2]**o + ((-0.0543916930807+0.599825298789j))*x[2]
            ref[(0, 1, 2)]+=(0.937343293525-0.0320725486197j)*x_ref[2]**o + ((-0.0543916930807+0.599825298789j))*x_ref[2]
            arg[(0, 2, 0)]+=(-0.372685058942+0.952661490055j)*x[2]**o + ((-0.24477788024-0.598042913627j))*x[2]
            ref[(0, 2, 0)]+=(-0.372685058942+0.952661490055j)*x_ref[2]**o + ((-0.24477788024-0.598042913627j))*x_ref[2]
            arg[(0, 2, 1)]+=(-0.695014505332-0.905585502914j)*x[2]**o + ((0.435213944932+0.89751547609j))*x[2]
            ref[(0, 2, 1)]+=(-0.695014505332-0.905585502914j)*x_ref[2]**o + ((0.435213944932+0.89751547609j))*x_ref[2]
            arg[(0, 2, 2)]+=(-0.818313711139+0.516258906966j)*x[2]**o + ((-0.413042740628+0.726277691512j))*x[2]
            ref[(0, 2, 2)]+=(-0.818313711139+0.516258906966j)*x_ref[2]**o + ((-0.413042740628+0.726277691512j))*x_ref[2]
            arg[(0, 3, 0)]+=(-0.636473084691-0.970559154878j)*x[2]**o + ((0.861915744299+0.799775628654j))*x[2]
            ref[(0, 3, 0)]+=(-0.636473084691-0.970559154878j)*x_ref[2]**o + ((0.861915744299+0.799775628654j))*x_ref[2]
            arg[(0, 3, 1)]+=(0.555667904298-0.390485906904j)*x[2]**o + ((0.957218176022+0.905396245041j))*x[2]
            ref[(0, 3, 1)]+=(0.555667904298-0.390485906904j)*x_ref[2]**o + ((0.957218176022+0.905396245041j))*x_ref[2]
            arg[(0, 3, 2)]+=(0.399251421297-0.57955347437j)*x[2]**o + ((-0.425915679145-0.306118916637j))*x[2]
            ref[(0, 3, 2)]+=(0.399251421297-0.57955347437j)*x_ref[2]**o + ((-0.425915679145-0.306118916637j))*x_ref[2]
            arg[(1, 0, 0)]+=(-0.925872433444+0.288663988353j)*x[2]**o + ((0.664522592362+0.246541317037j))*x[2]
            ref[(1, 0, 0)]+=(-0.925872433444+0.288663988353j)*x_ref[2]**o + ((0.664522592362+0.246541317037j))*x_ref[2]
            arg[(1, 0, 1)]+=(-0.203757349044+0.0832138180927j)*x[2]**o + ((-0.552073648454+0.791262989455j))*x[2]
            ref[(1, 0, 1)]+=(-0.203757349044+0.0832138180927j)*x_ref[2]**o + ((-0.552073648454+0.791262989455j))*x_ref[2]
            arg[(1, 0, 2)]+=(0.935389625099+0.451193042337j)*x[2]**o + ((0.122382723627+0.0772981221257j))*x[2]
            ref[(1, 0, 2)]+=(0.935389625099+0.451193042337j)*x_ref[2]**o + ((0.122382723627+0.0772981221257j))*x_ref[2]
            arg[(1, 1, 0)]+=(0.0262401431196+0.0536896612609j)*x[2]**o + ((0.567035067997+0.963378640106j))*x[2]
            ref[(1, 1, 0)]+=(0.0262401431196+0.0536896612609j)*x_ref[2]**o + ((0.567035067997+0.963378640106j))*x_ref[2]
            arg[(1, 1, 1)]+=(0.777599534061-0.280657701564j)*x[2]**o + ((-0.337691641584-0.876394218443j))*x[2]
            ref[(1, 1, 1)]+=(0.777599534061-0.280657701564j)*x_ref[2]**o + ((-0.337691641584-0.876394218443j))*x_ref[2]
            arg[(1, 1, 2)]+=(-0.141493209713+0.733903454484j)*x[2]**o + ((-0.193295013924+0.732797190924j))*x[2]
            ref[(1, 1, 2)]+=(-0.141493209713+0.733903454484j)*x_ref[2]**o + ((-0.193295013924+0.732797190924j))*x_ref[2]
            arg[(1, 2, 0)]+=(0.784277472118-0.963913671574j)*x[2]**o + ((-0.79613199347-0.384249503047j))*x[2]
            ref[(1, 2, 0)]+=(0.784277472118-0.963913671574j)*x_ref[2]**o + ((-0.79613199347-0.384249503047j))*x_ref[2]
            arg[(1, 2, 1)]+=(0.469164076376-0.610979202148j)*x[2]**o + ((0.944498834536+0.00570519680225j))*x[2]
            ref[(1, 2, 1)]+=(0.469164076376-0.610979202148j)*x_ref[2]**o + ((0.944498834536+0.00570519680225j))*x_ref[2]
            arg[(1, 2, 2)]+=(0.463952981337+0.67150522751j)*x[2]**o + ((0.591649251812+0.169357256559j))*x[2]
            ref[(1, 2, 2)]+=(0.463952981337+0.67150522751j)*x_ref[2]**o + ((0.591649251812+0.169357256559j))*x_ref[2]
            arg[(1, 3, 0)]+=(-0.513298346652-0.759876907384j)*x[2]**o + ((0.0694894241099-0.457662536198j))*x[2]
            ref[(1, 3, 0)]+=(-0.513298346652-0.759876907384j)*x_ref[2]**o + ((0.0694894241099-0.457662536198j))*x_ref[2]
            arg[(1, 3, 1)]+=(0.827647458442-0.589340173281j)*x[2]**o + ((0.939236407789-0.430735515614j))*x[2]
            ref[(1, 3, 1)]+=(0.827647458442-0.589340173281j)*x_ref[2]**o + ((0.939236407789-0.430735515614j))*x_ref[2]
            arg[(1, 3, 2)]+=(-0.518712910999-0.727767291873j)*x[2]**o + ((0.0214231331001-0.781549561501j))*x[2]
            ref[(1, 3, 2)]+=(-0.518712910999-0.727767291873j)*x_ref[2]**o + ((0.0214231331001-0.781549561501j))*x_ref[2]
            arg[(2, 0, 0)]+=(0.191642569983+0.115150048447j)*x[2]**o + ((-0.388777673502+0.908262014758j))*x[2]
            ref[(2, 0, 0)]+=(0.191642569983+0.115150048447j)*x_ref[2]**o + ((-0.388777673502+0.908262014758j))*x_ref[2]
            arg[(2, 0, 1)]+=(-0.637593704091+0.779576038657j)*x[2]**o + ((-0.776255565463+0.255678184455j))*x[2]
            ref[(2, 0, 1)]+=(-0.637593704091+0.779576038657j)*x_ref[2]**o + ((-0.776255565463+0.255678184455j))*x_ref[2]
            arg[(2, 0, 2)]+=(-0.456393586822-0.809291215355j)*x[2]**o + ((0.840702416315-0.684823607063j))*x[2]
            ref[(2, 0, 2)]+=(-0.456393586822-0.809291215355j)*x_ref[2]**o + ((0.840702416315-0.684823607063j))*x_ref[2]
            arg[(2, 1, 0)]+=(0.74580445951-0.73343414319j)*x[2]**o + ((0.768975069917-0.988311347755j))*x[2]
            ref[(2, 1, 0)]+=(0.74580445951-0.73343414319j)*x_ref[2]**o + ((0.768975069917-0.988311347755j))*x_ref[2]
            arg[(2, 1, 1)]+=(0.070228486202+0.582568884077j)*x[2]**o + ((0.484050736321+0.679195997706j))*x[2]
            ref[(2, 1, 1)]+=(0.070228486202+0.582568884077j)*x_ref[2]**o + ((0.484050736321+0.679195997706j))*x_ref[2]
            arg[(2, 1, 2)]+=(0.0158665749142-0.124279924932j)*x[2]**o + ((0.560730972226+0.283465221394j))*x[2]
            ref[(2, 1, 2)]+=(0.0158665749142-0.124279924932j)*x_ref[2]**o + ((0.560730972226+0.283465221394j))*x_ref[2]
            arg[(2, 2, 0)]+=(-0.60718852624-0.262312347081j)*x[2]**o + ((-0.119095521907+0.616230559284j))*x[2]
            ref[(2, 2, 0)]+=(-0.60718852624-0.262312347081j)*x_ref[2]**o + ((-0.119095521907+0.616230559284j))*x_ref[2]
            arg[(2, 2, 1)]+=(-0.959670483056+0.441454629867j)*x[2]**o + ((-0.60253095043+0.571744391616j))*x[2]
            ref[(2, 2, 1)]+=(-0.959670483056+0.441454629867j)*x_ref[2]**o + ((-0.60253095043+0.571744391616j))*x_ref[2]
            arg[(2, 2, 2)]+=(-0.085005991849-0.320365432534j)*x[2]**o + ((0.143661315674+0.960359129976j))*x[2]
            ref[(2, 2, 2)]+=(-0.085005991849-0.320365432534j)*x_ref[2]**o + ((0.143661315674+0.960359129976j))*x_ref[2]
            arg[(2, 3, 0)]+=(0.0333334521284-0.0909696046937j)*x[2]**o + ((0.772511186677+0.0473558660806j))*x[2]
            ref[(2, 3, 0)]+=(0.0333334521284-0.0909696046937j)*x_ref[2]**o + ((0.772511186677+0.0473558660806j))*x_ref[2]
            arg[(2, 3, 1)]+=(-0.235917889226-0.635185809626j)*x[2]**o + ((-0.692623146889-0.236735009092j))*x[2]
            ref[(2, 3, 1)]+=(-0.235917889226-0.635185809626j)*x_ref[2]**o + ((-0.692623146889-0.236735009092j))*x_ref[2]
            arg[(2, 3, 2)]+=(-0.590852201939-0.367533295361j)*x[2]**o + ((-0.252621596971+0.813734189263j))*x[2]
            ref[(2, 3, 2)]+=(-0.590852201939-0.367533295361j)*x_ref[2]**o + ((-0.252621596971+0.813734189263j))*x_ref[2]
            arg[(3, 0, 0)]+=(0.419922558762-0.287301411157j)*x[2]**o + ((0.928087409821+0.735802596806j))*x[2]
            ref[(3, 0, 0)]+=(0.419922558762-0.287301411157j)*x_ref[2]**o + ((0.928087409821+0.735802596806j))*x_ref[2]
            arg[(3, 0, 1)]+=(0.88915410037+0.829343658088j)*x[2]**o + ((-0.604725300463+0.706853058719j))*x[2]
            ref[(3, 0, 1)]+=(0.88915410037+0.829343658088j)*x_ref[2]**o + ((-0.604725300463+0.706853058719j))*x_ref[2]
            arg[(3, 0, 2)]+=(0.584158898631-0.0771075502207j)*x[2]**o + ((-0.226825672783+0.543311694111j))*x[2]
            ref[(3, 0, 2)]+=(0.584158898631-0.0771075502207j)*x_ref[2]**o + ((-0.226825672783+0.543311694111j))*x_ref[2]
            arg[(3, 1, 0)]+=(-0.0305616113179-0.199166127244j)*x[2]**o + ((-0.114899172054+0.841034046787j))*x[2]
            ref[(3, 1, 0)]+=(-0.0305616113179-0.199166127244j)*x_ref[2]**o + ((-0.114899172054+0.841034046787j))*x_ref[2]
            arg[(3, 1, 1)]+=(0.0789681402367-0.930404085717j)*x[2]**o + ((-0.0817272255707+0.781419978919j))*x[2]
            ref[(3, 1, 1)]+=(0.0789681402367-0.930404085717j)*x_ref[2]**o + ((-0.0817272255707+0.781419978919j))*x_ref[2]
            arg[(3, 1, 2)]+=(-0.088730113265-0.219649431832j)*x[2]**o + ((0.313733610812+0.292894304713j))*x[2]
            ref[(3, 1, 2)]+=(-0.088730113265-0.219649431832j)*x_ref[2]**o + ((0.313733610812+0.292894304713j))*x_ref[2]
            arg[(3, 2, 0)]+=(0.227053340964-0.788823885532j)*x[2]**o + ((0.806204582845+0.810303470055j))*x[2]
            ref[(3, 2, 0)]+=(0.227053340964-0.788823885532j)*x_ref[2]**o + ((0.806204582845+0.810303470055j))*x_ref[2]
            arg[(3, 2, 1)]+=(0.668217842834-0.566899788999j)*x[2]**o + ((-0.142186918602+0.457910071011j))*x[2]
            ref[(3, 2, 1)]+=(0.668217842834-0.566899788999j)*x_ref[2]**o + ((-0.142186918602+0.457910071011j))*x_ref[2]
            arg[(3, 2, 2)]+=(0.714798836518+0.178276730664j)*x[2]**o + ((-0.541191570673-0.217540744799j))*x[2]
            ref[(3, 2, 2)]+=(0.714798836518+0.178276730664j)*x_ref[2]**o + ((-0.541191570673-0.217540744799j))*x_ref[2]
            arg[(3, 3, 0)]+=(-0.379349109304-0.945111557477j)*x[2]**o + ((-0.753581516314-0.174093517437j))*x[2]
            ref[(3, 3, 0)]+=(-0.379349109304-0.945111557477j)*x_ref[2]**o + ((-0.753581516314-0.174093517437j))*x_ref[2]
            arg[(3, 3, 1)]+=(0.357939280295+0.150671612968j)*x[2]**o + ((-0.921112226469+0.0979741620534j))*x[2]
            ref[(3, 3, 1)]+=(0.357939280295+0.150671612968j)*x_ref[2]**o + ((-0.921112226469+0.0979741620534j))*x_ref[2]
            arg[(3, 3, 2)]+=(0.236332602441+0.890521993871j)*x[2]**o + ((-0.434501672604+0.639254812355j))*x[2]
            ref[(3, 3, 2)]+=(0.236332602441+0.890521993871j)*x_ref[2]**o + ((-0.434501672604+0.639254812355j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 4, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_Solution_rank4(self):
        """
        tests interpolation of rank 4 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports interpolation from Solution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 4, 2),w)
        ref = Data(0,(4, 3, 4, 2),w_ref)
        arg[(0, 0, 0, 0)]=(0.688531661721-0.0549094656197j)*x[0]**o + ((0.986674063841-0.855346715123j))*x[0] + ((-0.739265862011-0.461786273975j))*x[1]**o + ((-0.725942444165+0.845762836151j))*x[1]
        ref[(0, 0, 0, 0)]=(0.688531661721-0.0549094656197j)*x_ref[0]**o + ((0.986674063841-0.855346715123j))*x_ref[0] + ((-0.739265862011-0.461786273975j))*x_ref[1]**o + ((-0.725942444165+0.845762836151j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(0.577388869362-0.327022781742j)*x[0]**o + ((0.41757702651-0.953098915913j))*x[0] + ((0.767164206396-0.991805880855j))*x[1]**o + ((-0.12218031107+0.369776626237j))*x[1]
        ref[(0, 0, 0, 1)]=(0.577388869362-0.327022781742j)*x_ref[0]**o + ((0.41757702651-0.953098915913j))*x_ref[0] + ((0.767164206396-0.991805880855j))*x_ref[1]**o + ((-0.12218031107+0.369776626237j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(0.389258577547+0.900526160072j)*x[0]**o + ((-0.52447297424+0.262904938286j))*x[0] + ((-0.510123366669+0.924152451207j))*x[1]**o + ((0.221754877184-0.722026419803j))*x[1]
        ref[(0, 0, 1, 0)]=(0.389258577547+0.900526160072j)*x_ref[0]**o + ((-0.52447297424+0.262904938286j))*x_ref[0] + ((-0.510123366669+0.924152451207j))*x_ref[1]**o + ((0.221754877184-0.722026419803j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.985983715223+0.817538821165j)*x[0]**o + ((0.740866109871-0.182113546834j))*x[0] + ((-0.640727095497+0.383512411094j))*x[1]**o + ((0.995621140753-0.329306349763j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.985983715223+0.817538821165j)*x_ref[0]**o + ((0.740866109871-0.182113546834j))*x_ref[0] + ((-0.640727095497+0.383512411094j))*x_ref[1]**o + ((0.995621140753-0.329306349763j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(0.62484956238+0.5248806332j)*x[0]**o + ((-0.778228006839+0.467450453893j))*x[0] + ((-0.752178818401+0.91334170372j))*x[1]**o + ((0.57547766486+0.511716584288j))*x[1]
        ref[(0, 0, 2, 0)]=(0.62484956238+0.5248806332j)*x_ref[0]**o + ((-0.778228006839+0.467450453893j))*x_ref[0] + ((-0.752178818401+0.91334170372j))*x_ref[1]**o + ((0.57547766486+0.511716584288j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(0.934127699823+0.932269667427j)*x[0]**o + ((-0.934555714083-0.863610236601j))*x[0] + ((-0.0211608832076+0.920062620771j))*x[1]**o + ((0.729251528712-0.18131186167j))*x[1]
        ref[(0, 0, 2, 1)]=(0.934127699823+0.932269667427j)*x_ref[0]**o + ((-0.934555714083-0.863610236601j))*x_ref[0] + ((-0.0211608832076+0.920062620771j))*x_ref[1]**o + ((0.729251528712-0.18131186167j))*x_ref[1]
        arg[(0, 0, 3, 0)]=(-0.402906269002-0.0923964175788j)*x[0]**o + ((-0.0836423031732+0.730597950416j))*x[0] + ((-0.713326059662-0.555966959822j))*x[1]**o + ((-0.519100907569-0.535718933859j))*x[1]
        ref[(0, 0, 3, 0)]=(-0.402906269002-0.0923964175788j)*x_ref[0]**o + ((-0.0836423031732+0.730597950416j))*x_ref[0] + ((-0.713326059662-0.555966959822j))*x_ref[1]**o + ((-0.519100907569-0.535718933859j))*x_ref[1]
        arg[(0, 0, 3, 1)]=(0.989373654884+0.874344940749j)*x[0]**o + ((-0.402179125803-0.791072322147j))*x[0] + ((0.423994867476+0.789715389825j))*x[1]**o + ((0.00024431145031+0.12504768225j))*x[1]
        ref[(0, 0, 3, 1)]=(0.989373654884+0.874344940749j)*x_ref[0]**o + ((-0.402179125803-0.791072322147j))*x_ref[0] + ((0.423994867476+0.789715389825j))*x_ref[1]**o + ((0.00024431145031+0.12504768225j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(-0.18668396538-0.196117655341j)*x[0]**o + ((-0.218493179256-0.59977917304j))*x[0] + ((-0.561514778015+0.167775458651j))*x[1]**o + ((0.320109872461-0.812350560618j))*x[1]
        ref[(0, 1, 0, 0)]=(-0.18668396538-0.196117655341j)*x_ref[0]**o + ((-0.218493179256-0.59977917304j))*x_ref[0] + ((-0.561514778015+0.167775458651j))*x_ref[1]**o + ((0.320109872461-0.812350560618j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(-0.27731258986-0.621580750584j)*x[0]**o + ((0.975712656543-0.392044878497j))*x[0] + ((-0.371140182989-0.688894686429j))*x[1]**o + ((-0.703036644225+0.590909425863j))*x[1]
        ref[(0, 1, 0, 1)]=(-0.27731258986-0.621580750584j)*x_ref[0]**o + ((0.975712656543-0.392044878497j))*x_ref[0] + ((-0.371140182989-0.688894686429j))*x_ref[1]**o + ((-0.703036644225+0.590909425863j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.474530936003-0.856061856693j)*x[0]**o + ((-0.204917268866-0.821489127757j))*x[0] + ((0.968772235221-0.256454125044j))*x[1]**o + ((-0.697045748967+0.0888025395023j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.474530936003-0.856061856693j)*x_ref[0]**o + ((-0.204917268866-0.821489127757j))*x_ref[0] + ((0.968772235221-0.256454125044j))*x_ref[1]**o + ((-0.697045748967+0.0888025395023j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(0.322788928182+0.750217594808j)*x[0]**o + ((-0.580353129694+0.511548434465j))*x[0] + ((0.339343510909+0.943349913057j))*x[1]**o + ((-0.0110349406772+0.84037781623j))*x[1]
        ref[(0, 1, 1, 1)]=(0.322788928182+0.750217594808j)*x_ref[0]**o + ((-0.580353129694+0.511548434465j))*x_ref[0] + ((0.339343510909+0.943349913057j))*x_ref[1]**o + ((-0.0110349406772+0.84037781623j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(0.182202475998+0.552135240138j)*x[0]**o + ((0.647831934807+0.907696467796j))*x[0] + ((-0.314122831231+0.554991025387j))*x[1]**o + ((-0.146241609603-0.278089056643j))*x[1]
        ref[(0, 1, 2, 0)]=(0.182202475998+0.552135240138j)*x_ref[0]**o + ((0.647831934807+0.907696467796j))*x_ref[0] + ((-0.314122831231+0.554991025387j))*x_ref[1]**o + ((-0.146241609603-0.278089056643j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(-0.397887826288+0.506373014315j)*x[0]**o + ((-0.666500781825+0.862450218339j))*x[0] + ((-0.600404297306+0.468589033336j))*x[1]**o + ((-0.411272743259-0.542030974104j))*x[1]
        ref[(0, 1, 2, 1)]=(-0.397887826288+0.506373014315j)*x_ref[0]**o + ((-0.666500781825+0.862450218339j))*x_ref[0] + ((-0.600404297306+0.468589033336j))*x_ref[1]**o + ((-0.411272743259-0.542030974104j))*x_ref[1]
        arg[(0, 1, 3, 0)]=(-0.800855248865-0.507392424816j)*x[0]**o + ((-0.925963156005-0.757245138692j))*x[0] + ((0.409085663923-0.0208147625776j))*x[1]**o + ((0.473440115641-0.836851282244j))*x[1]
        ref[(0, 1, 3, 0)]=(-0.800855248865-0.507392424816j)*x_ref[0]**o + ((-0.925963156005-0.757245138692j))*x_ref[0] + ((0.409085663923-0.0208147625776j))*x_ref[1]**o + ((0.473440115641-0.836851282244j))*x_ref[1]
        arg[(0, 1, 3, 1)]=(-0.911864535586+0.978488616676j)*x[0]**o + ((0.245381866265-0.0636853131904j))*x[0] + ((-0.046531254095+0.686366806529j))*x[1]**o + ((0.17764449141+0.1294539913j))*x[1]
        ref[(0, 1, 3, 1)]=(-0.911864535586+0.978488616676j)*x_ref[0]**o + ((0.245381866265-0.0636853131904j))*x_ref[0] + ((-0.046531254095+0.686366806529j))*x_ref[1]**o + ((0.17764449141+0.1294539913j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(0.0863415388194-0.0349305759757j)*x[0]**o + ((-0.768781423422+0.308454660949j))*x[0] + ((0.839485400104-0.870644878275j))*x[1]**o + ((-0.521271495572-0.289796776786j))*x[1]
        ref[(0, 2, 0, 0)]=(0.0863415388194-0.0349305759757j)*x_ref[0]**o + ((-0.768781423422+0.308454660949j))*x_ref[0] + ((0.839485400104-0.870644878275j))*x_ref[1]**o + ((-0.521271495572-0.289796776786j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(-0.17153852938+0.717966937602j)*x[0]**o + ((-0.880246242967-0.160237276299j))*x[0] + ((0.746767061663-0.596664412694j))*x[1]**o + ((0.367022142081-0.884114999451j))*x[1]
        ref[(0, 2, 0, 1)]=(-0.17153852938+0.717966937602j)*x_ref[0]**o + ((-0.880246242967-0.160237276299j))*x_ref[0] + ((0.746767061663-0.596664412694j))*x_ref[1]**o + ((0.367022142081-0.884114999451j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(-0.293562350452-0.0192209448084j)*x[0]**o + ((-0.555384622014-0.134693089657j))*x[0] + ((-0.968974051829+0.199279810713j))*x[1]**o + ((-0.540257359979+0.523209440849j))*x[1]
        ref[(0, 2, 1, 0)]=(-0.293562350452-0.0192209448084j)*x_ref[0]**o + ((-0.555384622014-0.134693089657j))*x_ref[0] + ((-0.968974051829+0.199279810713j))*x_ref[1]**o + ((-0.540257359979+0.523209440849j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(-0.650101787794+0.788381592781j)*x[0]**o + ((-0.308013760861-0.0743748495112j))*x[0] + ((0.160475389858+0.570289761858j))*x[1]**o + ((-0.98468890355+0.0373213055685j))*x[1]
        ref[(0, 2, 1, 1)]=(-0.650101787794+0.788381592781j)*x_ref[0]**o + ((-0.308013760861-0.0743748495112j))*x_ref[0] + ((0.160475389858+0.570289761858j))*x_ref[1]**o + ((-0.98468890355+0.0373213055685j))*x_ref[1]
        arg[(0, 2, 2, 0)]=(0.358440553459+0.974711589804j)*x[0]**o + ((0.266202576314+0.591754759744j))*x[0] + ((0.499633483112+0.649546368039j))*x[1]**o + ((-0.738659672232+0.794432743694j))*x[1]
        ref[(0, 2, 2, 0)]=(0.358440553459+0.974711589804j)*x_ref[0]**o + ((0.266202576314+0.591754759744j))*x_ref[0] + ((0.499633483112+0.649546368039j))*x_ref[1]**o + ((-0.738659672232+0.794432743694j))*x_ref[1]
        arg[(0, 2, 2, 1)]=(0.731211647867-0.3612855581j)*x[0]**o + ((0.178780277104-0.737428619778j))*x[0] + ((-0.0505989963506-0.502006760039j))*x[1]**o + ((0.432672006889-0.0775420459315j))*x[1]
        ref[(0, 2, 2, 1)]=(0.731211647867-0.3612855581j)*x_ref[0]**o + ((0.178780277104-0.737428619778j))*x_ref[0] + ((-0.0505989963506-0.502006760039j))*x_ref[1]**o + ((0.432672006889-0.0775420459315j))*x_ref[1]
        arg[(0, 2, 3, 0)]=(0.372778707824-0.343268146344j)*x[0]**o + ((-0.199569753945+0.412026715526j))*x[0] + ((0.426609224674-0.868490111232j))*x[1]**o + ((0.826299732929+0.651347823751j))*x[1]
        ref[(0, 2, 3, 0)]=(0.372778707824-0.343268146344j)*x_ref[0]**o + ((-0.199569753945+0.412026715526j))*x_ref[0] + ((0.426609224674-0.868490111232j))*x_ref[1]**o + ((0.826299732929+0.651347823751j))*x_ref[1]
        arg[(0, 2, 3, 1)]=(-0.973541721185+0.0627704039352j)*x[0]**o + ((-0.520544149649+0.0118263655649j))*x[0] + ((0.200929923992+0.82087494814j))*x[1]**o + ((-0.720413689076-0.423170687335j))*x[1]
        ref[(0, 2, 3, 1)]=(-0.973541721185+0.0627704039352j)*x_ref[0]**o + ((-0.520544149649+0.0118263655649j))*x_ref[0] + ((0.200929923992+0.82087494814j))*x_ref[1]**o + ((-0.720413689076-0.423170687335j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.525958190753-0.847246400727j)*x[0]**o + ((0.597043404962-0.536402864376j))*x[0] + ((0.44193833572-0.246731310338j))*x[1]**o + ((0.657600918352+0.884827505424j))*x[1]
        ref[(1, 0, 0, 0)]=(0.525958190753-0.847246400727j)*x_ref[0]**o + ((0.597043404962-0.536402864376j))*x_ref[0] + ((0.44193833572-0.246731310338j))*x_ref[1]**o + ((0.657600918352+0.884827505424j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.442301406201+0.572285723194j)*x[0]**o + ((-0.62217531899-0.896824859285j))*x[0] + ((0.791245476214-0.893312759502j))*x[1]**o + ((0.0310354764587+0.457998256393j))*x[1]
        ref[(1, 0, 0, 1)]=(0.442301406201+0.572285723194j)*x_ref[0]**o + ((-0.62217531899-0.896824859285j))*x_ref[0] + ((0.791245476214-0.893312759502j))*x_ref[1]**o + ((0.0310354764587+0.457998256393j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.39054429038-0.186089428185j)*x[0]**o + ((0.439057244788+0.442936559462j))*x[0] + ((0.176451218555-0.141853046354j))*x[1]**o + ((-0.271514253848-0.920805190163j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.39054429038-0.186089428185j)*x_ref[0]**o + ((0.439057244788+0.442936559462j))*x_ref[0] + ((0.176451218555-0.141853046354j))*x_ref[1]**o + ((-0.271514253848-0.920805190163j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(0.465611676061-0.250137509927j)*x[0]**o + ((-0.427289230481+0.325117057512j))*x[0] + ((0.05306339104+0.574176091515j))*x[1]**o + ((0.518049857448-0.434998811561j))*x[1]
        ref[(1, 0, 1, 1)]=(0.465611676061-0.250137509927j)*x_ref[0]**o + ((-0.427289230481+0.325117057512j))*x_ref[0] + ((0.05306339104+0.574176091515j))*x_ref[1]**o + ((0.518049857448-0.434998811561j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(0.00733842167095-0.173592638452j)*x[0]**o + ((0.231433768891+0.636167262029j))*x[0] + ((0.79760637692+0.574160740319j))*x[1]**o + ((0.132211834616-0.934003449346j))*x[1]
        ref[(1, 0, 2, 0)]=(0.00733842167095-0.173592638452j)*x_ref[0]**o + ((0.231433768891+0.636167262029j))*x_ref[0] + ((0.79760637692+0.574160740319j))*x_ref[1]**o + ((0.132211834616-0.934003449346j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(-0.613172767334-0.148626193388j)*x[0]**o + ((0.52361460732-0.451835336002j))*x[0] + ((-0.187793309564+0.50919629652j))*x[1]**o + ((0.714108158112-0.32422779373j))*x[1]
        ref[(1, 0, 2, 1)]=(-0.613172767334-0.148626193388j)*x_ref[0]**o + ((0.52361460732-0.451835336002j))*x_ref[0] + ((-0.187793309564+0.50919629652j))*x_ref[1]**o + ((0.714108158112-0.32422779373j))*x_ref[1]
        arg[(1, 0, 3, 0)]=(-0.199308208696+0.282442838378j)*x[0]**o + ((0.219319003729-0.156011962089j))*x[0] + ((-0.894164804106-0.611057359859j))*x[1]**o + ((0.738165936186-0.472396433519j))*x[1]
        ref[(1, 0, 3, 0)]=(-0.199308208696+0.282442838378j)*x_ref[0]**o + ((0.219319003729-0.156011962089j))*x_ref[0] + ((-0.894164804106-0.611057359859j))*x_ref[1]**o + ((0.738165936186-0.472396433519j))*x_ref[1]
        arg[(1, 0, 3, 1)]=(0.0763311445176+0.155654619117j)*x[0]**o + ((-0.820866505655-0.773360186464j))*x[0] + ((0.979882666682+0.234160164467j))*x[1]**o + ((-0.780535510174-0.148649989196j))*x[1]
        ref[(1, 0, 3, 1)]=(0.0763311445176+0.155654619117j)*x_ref[0]**o + ((-0.820866505655-0.773360186464j))*x_ref[0] + ((0.979882666682+0.234160164467j))*x_ref[1]**o + ((-0.780535510174-0.148649989196j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(0.357972835469+0.0354650241516j)*x[0]**o + ((0.165833148732+0.141454274208j))*x[0] + ((-0.354680198256+0.954971637247j))*x[1]**o + ((0.715529917339+0.419987482794j))*x[1]
        ref[(1, 1, 0, 0)]=(0.357972835469+0.0354650241516j)*x_ref[0]**o + ((0.165833148732+0.141454274208j))*x_ref[0] + ((-0.354680198256+0.954971637247j))*x_ref[1]**o + ((0.715529917339+0.419987482794j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(0.954137879094-0.362573517219j)*x[0]**o + ((-0.701238098324+0.873825337679j))*x[0] + ((-0.503741185359-0.597659789651j))*x[1]**o + ((-0.0348100716196+0.0375386134666j))*x[1]
        ref[(1, 1, 0, 1)]=(0.954137879094-0.362573517219j)*x_ref[0]**o + ((-0.701238098324+0.873825337679j))*x_ref[0] + ((-0.503741185359-0.597659789651j))*x_ref[1]**o + ((-0.0348100716196+0.0375386134666j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.334635423208+0.155691915381j)*x[0]**o + ((-0.692320793719+0.755037580934j))*x[0] + ((-0.236659221754+0.803674582734j))*x[1]**o + ((0.471464288287+0.435583485501j))*x[1]
        ref[(1, 1, 1, 0)]=(0.334635423208+0.155691915381j)*x_ref[0]**o + ((-0.692320793719+0.755037580934j))*x_ref[0] + ((-0.236659221754+0.803674582734j))*x_ref[1]**o + ((0.471464288287+0.435583485501j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.344431210508+0.941998270782j)*x[0]**o + ((-0.730566754636+0.84468352311j))*x[0] + ((0.687577670972-0.074839030391j))*x[1]**o + ((-0.944622162449-0.491055880027j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.344431210508+0.941998270782j)*x_ref[0]**o + ((-0.730566754636+0.84468352311j))*x_ref[0] + ((0.687577670972-0.074839030391j))*x_ref[1]**o + ((-0.944622162449-0.491055880027j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(-0.505096829158-0.636891931613j)*x[0]**o + ((0.154259409629+0.615428129755j))*x[0] + ((0.576389238789+0.10964101267j))*x[1]**o + ((0.353698342923+0.711336949377j))*x[1]
        ref[(1, 1, 2, 0)]=(-0.505096829158-0.636891931613j)*x_ref[0]**o + ((0.154259409629+0.615428129755j))*x_ref[0] + ((0.576389238789+0.10964101267j))*x_ref[1]**o + ((0.353698342923+0.711336949377j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(-0.956849346026-0.788231689431j)*x[0]**o + ((0.263653280731-0.279382440465j))*x[0] + ((-0.573264186774-0.856767926201j))*x[1]**o + ((-0.530518449627+0.820241637556j))*x[1]
        ref[(1, 1, 2, 1)]=(-0.956849346026-0.788231689431j)*x_ref[0]**o + ((0.263653280731-0.279382440465j))*x_ref[0] + ((-0.573264186774-0.856767926201j))*x_ref[1]**o + ((-0.530518449627+0.820241637556j))*x_ref[1]
        arg[(1, 1, 3, 0)]=(0.199170546226-0.70470849452j)*x[0]**o + ((-0.315991846092-0.185852065205j))*x[0] + ((-0.39180038773-0.543547743721j))*x[1]**o + ((0.0800806684154+0.0780967159141j))*x[1]
        ref[(1, 1, 3, 0)]=(0.199170546226-0.70470849452j)*x_ref[0]**o + ((-0.315991846092-0.185852065205j))*x_ref[0] + ((-0.39180038773-0.543547743721j))*x_ref[1]**o + ((0.0800806684154+0.0780967159141j))*x_ref[1]
        arg[(1, 1, 3, 1)]=(0.849024521815+0.626074712747j)*x[0]**o + ((-0.400826435455+0.72953076645j))*x[0] + ((-0.368888606659-0.655145439106j))*x[1]**o + ((0.745951351002-0.834613882834j))*x[1]
        ref[(1, 1, 3, 1)]=(0.849024521815+0.626074712747j)*x_ref[0]**o + ((-0.400826435455+0.72953076645j))*x_ref[0] + ((-0.368888606659-0.655145439106j))*x_ref[1]**o + ((0.745951351002-0.834613882834j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(-0.994146922749+0.184434732991j)*x[0]**o + ((0.597667860537+0.521702390816j))*x[0] + ((0.976244142329+0.722027096325j))*x[1]**o + ((-0.276895535517+0.427046104066j))*x[1]
        ref[(1, 2, 0, 0)]=(-0.994146922749+0.184434732991j)*x_ref[0]**o + ((0.597667860537+0.521702390816j))*x_ref[0] + ((0.976244142329+0.722027096325j))*x_ref[1]**o + ((-0.276895535517+0.427046104066j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(-0.968382050248+0.949884342748j)*x[0]**o + ((0.0998973537416-0.837747598563j))*x[0] + ((0.0713359697901+0.562723114977j))*x[1]**o + ((-0.647289166115+0.419854937672j))*x[1]
        ref[(1, 2, 0, 1)]=(-0.968382050248+0.949884342748j)*x_ref[0]**o + ((0.0998973537416-0.837747598563j))*x_ref[0] + ((0.0713359697901+0.562723114977j))*x_ref[1]**o + ((-0.647289166115+0.419854937672j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(0.975574141493+0.839883232708j)*x[0]**o + ((0.82220102841+0.81689884088j))*x[0] + ((0.820840511419+0.101954529844j))*x[1]**o + ((-0.893875050603-0.493733999542j))*x[1]
        ref[(1, 2, 1, 0)]=(0.975574141493+0.839883232708j)*x_ref[0]**o + ((0.82220102841+0.81689884088j))*x_ref[0] + ((0.820840511419+0.101954529844j))*x_ref[1]**o + ((-0.893875050603-0.493733999542j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(-0.970403979217-0.937507696439j)*x[0]**o + ((0.596896413936-0.794272093328j))*x[0] + ((-0.774354637826-0.441650442965j))*x[1]**o + ((-0.473623623285+0.278883478304j))*x[1]
        ref[(1, 2, 1, 1)]=(-0.970403979217-0.937507696439j)*x_ref[0]**o + ((0.596896413936-0.794272093328j))*x_ref[0] + ((-0.774354637826-0.441650442965j))*x_ref[1]**o + ((-0.473623623285+0.278883478304j))*x_ref[1]
        arg[(1, 2, 2, 0)]=(-0.593413290835+0.704184734834j)*x[0]**o + ((-0.207181545943-0.93187102772j))*x[0] + ((-0.864261571916-0.759058836111j))*x[1]**o + ((-0.782825887597+0.960741965767j))*x[1]
        ref[(1, 2, 2, 0)]=(-0.593413290835+0.704184734834j)*x_ref[0]**o + ((-0.207181545943-0.93187102772j))*x_ref[0] + ((-0.864261571916-0.759058836111j))*x_ref[1]**o + ((-0.782825887597+0.960741965767j))*x_ref[1]
        arg[(1, 2, 2, 1)]=(-0.275502124603+0.600468947774j)*x[0]**o + ((0.54310606908-0.832230016977j))*x[0] + ((-0.623621477853+0.381191412936j))*x[1]**o + ((-0.50863196992+0.0683980166776j))*x[1]
        ref[(1, 2, 2, 1)]=(-0.275502124603+0.600468947774j)*x_ref[0]**o + ((0.54310606908-0.832230016977j))*x_ref[0] + ((-0.623621477853+0.381191412936j))*x_ref[1]**o + ((-0.50863196992+0.0683980166776j))*x_ref[1]
        arg[(1, 2, 3, 0)]=(-0.347836801742+0.935888686636j)*x[0]**o + ((-0.0372564475431-0.885502421528j))*x[0] + ((0.456847507344-0.345980587701j))*x[1]**o + ((0.974023703496-0.627065855473j))*x[1]
        ref[(1, 2, 3, 0)]=(-0.347836801742+0.935888686636j)*x_ref[0]**o + ((-0.0372564475431-0.885502421528j))*x_ref[0] + ((0.456847507344-0.345980587701j))*x_ref[1]**o + ((0.974023703496-0.627065855473j))*x_ref[1]
        arg[(1, 2, 3, 1)]=(-0.0831810928935+0.0454538578023j)*x[0]**o + ((0.408752865791+0.113462112557j))*x[0] + ((0.989237376223+0.341376488866j))*x[1]**o + ((-0.115959999331-0.509359220463j))*x[1]
        ref[(1, 2, 3, 1)]=(-0.0831810928935+0.0454538578023j)*x_ref[0]**o + ((0.408752865791+0.113462112557j))*x_ref[0] + ((0.989237376223+0.341376488866j))*x_ref[1]**o + ((-0.115959999331-0.509359220463j))*x_ref[1]
        arg[(2, 0, 0, 0)]=(0.453747456575+0.488369501765j)*x[0]**o + ((-0.561802930614-0.73365146233j))*x[0] + ((-0.426526745648+0.0750570187214j))*x[1]**o + ((-0.410411033798-0.498656081878j))*x[1]
        ref[(2, 0, 0, 0)]=(0.453747456575+0.488369501765j)*x_ref[0]**o + ((-0.561802930614-0.73365146233j))*x_ref[0] + ((-0.426526745648+0.0750570187214j))*x_ref[1]**o + ((-0.410411033798-0.498656081878j))*x_ref[1]
        arg[(2, 0, 0, 1)]=(-0.301670176177-0.433852696436j)*x[0]**o + ((0.962371405458-0.00277567179045j))*x[0] + ((0.496304535972+0.545421748178j))*x[1]**o + ((-0.818492570709-0.316722143975j))*x[1]
        ref[(2, 0, 0, 1)]=(-0.301670176177-0.433852696436j)*x_ref[0]**o + ((0.962371405458-0.00277567179045j))*x_ref[0] + ((0.496304535972+0.545421748178j))*x_ref[1]**o + ((-0.818492570709-0.316722143975j))*x_ref[1]
        arg[(2, 0, 1, 0)]=(0.571061564971+0.957109958497j)*x[0]**o + ((-0.396918066948+0.346024666533j))*x[0] + ((0.0673585923817+0.707533529128j))*x[1]**o + ((-0.716431455071-0.142236981985j))*x[1]
        ref[(2, 0, 1, 0)]=(0.571061564971+0.957109958497j)*x_ref[0]**o + ((-0.396918066948+0.346024666533j))*x_ref[0] + ((0.0673585923817+0.707533529128j))*x_ref[1]**o + ((-0.716431455071-0.142236981985j))*x_ref[1]
        arg[(2, 0, 1, 1)]=(-0.310834036516+0.945153525831j)*x[0]**o + ((0.174170375926+0.145153446411j))*x[0] + ((0.989666479313+0.0514580804747j))*x[1]**o + ((-0.398131050987-0.218139427324j))*x[1]
        ref[(2, 0, 1, 1)]=(-0.310834036516+0.945153525831j)*x_ref[0]**o + ((0.174170375926+0.145153446411j))*x_ref[0] + ((0.989666479313+0.0514580804747j))*x_ref[1]**o + ((-0.398131050987-0.218139427324j))*x_ref[1]
        arg[(2, 0, 2, 0)]=(0.781341665764+0.336447620477j)*x[0]**o + ((-0.377359367308+0.580083780454j))*x[0] + ((0.0248754947086-0.483079164987j))*x[1]**o + ((-0.945800555139-0.170153875453j))*x[1]
        ref[(2, 0, 2, 0)]=(0.781341665764+0.336447620477j)*x_ref[0]**o + ((-0.377359367308+0.580083780454j))*x_ref[0] + ((0.0248754947086-0.483079164987j))*x_ref[1]**o + ((-0.945800555139-0.170153875453j))*x_ref[1]
        arg[(2, 0, 2, 1)]=(0.768567133831-0.814375121928j)*x[0]**o + ((-0.588922210582+0.489512479366j))*x[0] + ((0.600024671948-0.713999106039j))*x[1]**o + ((0.974894292926+0.845994056554j))*x[1]
        ref[(2, 0, 2, 1)]=(0.768567133831-0.814375121928j)*x_ref[0]**o + ((-0.588922210582+0.489512479366j))*x_ref[0] + ((0.600024671948-0.713999106039j))*x_ref[1]**o + ((0.974894292926+0.845994056554j))*x_ref[1]
        arg[(2, 0, 3, 0)]=(0.666290351712+0.687081533253j)*x[0]**o + ((0.495260805833+0.12636359055j))*x[0] + ((0.374253203669+0.657265059087j))*x[1]**o + ((0.56273098466-0.646427364409j))*x[1]
        ref[(2, 0, 3, 0)]=(0.666290351712+0.687081533253j)*x_ref[0]**o + ((0.495260805833+0.12636359055j))*x_ref[0] + ((0.374253203669+0.657265059087j))*x_ref[1]**o + ((0.56273098466-0.646427364409j))*x_ref[1]
        arg[(2, 0, 3, 1)]=(-0.451155320886+0.272256785781j)*x[0]**o + ((0.419594096999-0.452561867619j))*x[0] + ((0.0452105778753+0.00671398933924j))*x[1]**o + ((-0.943868446369-0.72009729792j))*x[1]
        ref[(2, 0, 3, 1)]=(-0.451155320886+0.272256785781j)*x_ref[0]**o + ((0.419594096999-0.452561867619j))*x_ref[0] + ((0.0452105778753+0.00671398933924j))*x_ref[1]**o + ((-0.943868446369-0.72009729792j))*x_ref[1]
        arg[(2, 1, 0, 0)]=(0.215142714494+0.476692565064j)*x[0]**o + ((0.97937063044-0.231729411267j))*x[0] + ((-0.96467371791+0.912629004003j))*x[1]**o + ((-0.990501001672+0.239932254656j))*x[1]
        ref[(2, 1, 0, 0)]=(0.215142714494+0.476692565064j)*x_ref[0]**o + ((0.97937063044-0.231729411267j))*x_ref[0] + ((-0.96467371791+0.912629004003j))*x_ref[1]**o + ((-0.990501001672+0.239932254656j))*x_ref[1]
        arg[(2, 1, 0, 1)]=(0.0682593959508-0.0234097170654j)*x[0]**o + ((-0.0705418100022+0.921253511696j))*x[0] + ((0.746612994691+0.268901419411j))*x[1]**o + ((-0.234238631401-0.892883798169j))*x[1]
        ref[(2, 1, 0, 1)]=(0.0682593959508-0.0234097170654j)*x_ref[0]**o + ((-0.0705418100022+0.921253511696j))*x_ref[0] + ((0.746612994691+0.268901419411j))*x_ref[1]**o + ((-0.234238631401-0.892883798169j))*x_ref[1]
        arg[(2, 1, 1, 0)]=(0.80281682488-0.2783413611j)*x[0]**o + ((0.724192847185+0.63937906935j))*x[0] + ((-0.893682594571-0.463249093039j))*x[1]**o + ((-0.461501072906+0.30199550783j))*x[1]
        ref[(2, 1, 1, 0)]=(0.80281682488-0.2783413611j)*x_ref[0]**o + ((0.724192847185+0.63937906935j))*x_ref[0] + ((-0.893682594571-0.463249093039j))*x_ref[1]**o + ((-0.461501072906+0.30199550783j))*x_ref[1]
        arg[(2, 1, 1, 1)]=(0.523352303037+0.359314950904j)*x[0]**o + ((-0.109992756246+0.632719750702j))*x[0] + ((-0.369456932168-0.374531765206j))*x[1]**o + ((0.059511108485+0.731042741206j))*x[1]
        ref[(2, 1, 1, 1)]=(0.523352303037+0.359314950904j)*x_ref[0]**o + ((-0.109992756246+0.632719750702j))*x_ref[0] + ((-0.369456932168-0.374531765206j))*x_ref[1]**o + ((0.059511108485+0.731042741206j))*x_ref[1]
        arg[(2, 1, 2, 0)]=(-0.424050714813+0.291670569248j)*x[0]**o + ((-0.0242453627047-0.300487659017j))*x[0] + ((0.796750812242-0.64910976844j))*x[1]**o + ((0.286127297301-0.491479365402j))*x[1]
        ref[(2, 1, 2, 0)]=(-0.424050714813+0.291670569248j)*x_ref[0]**o + ((-0.0242453627047-0.300487659017j))*x_ref[0] + ((0.796750812242-0.64910976844j))*x_ref[1]**o + ((0.286127297301-0.491479365402j))*x_ref[1]
        arg[(2, 1, 2, 1)]=(-0.991038501883+0.0488849213801j)*x[0]**o + ((0.969903382704-0.7785773473j))*x[0] + ((-0.798744314975+0.259280689301j))*x[1]**o + ((0.0864732212394+0.859999379204j))*x[1]
        ref[(2, 1, 2, 1)]=(-0.991038501883+0.0488849213801j)*x_ref[0]**o + ((0.969903382704-0.7785773473j))*x_ref[0] + ((-0.798744314975+0.259280689301j))*x_ref[1]**o + ((0.0864732212394+0.859999379204j))*x_ref[1]
        arg[(2, 1, 3, 0)]=(-0.217092859548-0.418182021847j)*x[0]**o + ((-0.718515266749+0.157022331318j))*x[0] + ((0.0799784282891-0.546949856638j))*x[1]**o + ((-0.733373167753-0.901740290989j))*x[1]
        ref[(2, 1, 3, 0)]=(-0.217092859548-0.418182021847j)*x_ref[0]**o + ((-0.718515266749+0.157022331318j))*x_ref[0] + ((0.0799784282891-0.546949856638j))*x_ref[1]**o + ((-0.733373167753-0.901740290989j))*x_ref[1]
        arg[(2, 1, 3, 1)]=(0.204767264923+0.544860352131j)*x[0]**o + ((-0.804177656531-0.617665296525j))*x[0] + ((0.0652620180119+0.673611970287j))*x[1]**o + ((0.336807946862-0.432824459538j))*x[1]
        ref[(2, 1, 3, 1)]=(0.204767264923+0.544860352131j)*x_ref[0]**o + ((-0.804177656531-0.617665296525j))*x_ref[0] + ((0.0652620180119+0.673611970287j))*x_ref[1]**o + ((0.336807946862-0.432824459538j))*x_ref[1]
        arg[(2, 2, 0, 0)]=(-0.758006580109-0.496245829401j)*x[0]**o + ((0.845395990168+0.203142891983j))*x[0] + ((0.873376451956+0.762732902454j))*x[1]**o + ((-0.287008078231+0.978195121759j))*x[1]
        ref[(2, 2, 0, 0)]=(-0.758006580109-0.496245829401j)*x_ref[0]**o + ((0.845395990168+0.203142891983j))*x_ref[0] + ((0.873376451956+0.762732902454j))*x_ref[1]**o + ((-0.287008078231+0.978195121759j))*x_ref[1]
        arg[(2, 2, 0, 1)]=(-0.915111385272-0.700411458792j)*x[0]**o + ((0.21495207418+0.9480278085j))*x[0] + ((0.00536490227546+0.233721638694j))*x[1]**o + ((0.64608599743+0.327932317685j))*x[1]
        ref[(2, 2, 0, 1)]=(-0.915111385272-0.700411458792j)*x_ref[0]**o + ((0.21495207418+0.9480278085j))*x_ref[0] + ((0.00536490227546+0.233721638694j))*x_ref[1]**o + ((0.64608599743+0.327932317685j))*x_ref[1]
        arg[(2, 2, 1, 0)]=(0.0608087026109-0.632055489254j)*x[0]**o + ((-0.345814854944+0.909210261625j))*x[0] + ((0.237896021301-0.225971334708j))*x[1]**o + ((0.901053543954-0.401632098334j))*x[1]
        ref[(2, 2, 1, 0)]=(0.0608087026109-0.632055489254j)*x_ref[0]**o + ((-0.345814854944+0.909210261625j))*x_ref[0] + ((0.237896021301-0.225971334708j))*x_ref[1]**o + ((0.901053543954-0.401632098334j))*x_ref[1]
        arg[(2, 2, 1, 1)]=(-0.602488716689-0.769780115453j)*x[0]**o + ((0.990182585354+0.237663577812j))*x[0] + ((-0.0955740197606-0.58497968523j))*x[1]**o + ((0.614570443657+0.676189145997j))*x[1]
        ref[(2, 2, 1, 1)]=(-0.602488716689-0.769780115453j)*x_ref[0]**o + ((0.990182585354+0.237663577812j))*x_ref[0] + ((-0.0955740197606-0.58497968523j))*x_ref[1]**o + ((0.614570443657+0.676189145997j))*x_ref[1]
        arg[(2, 2, 2, 0)]=(0.77157236042-0.0905717987229j)*x[0]**o + ((0.0249818023642-0.175804958357j))*x[0] + ((-0.900075139304-0.814137414995j))*x[1]**o + ((0.598282066511-0.920951484648j))*x[1]
        ref[(2, 2, 2, 0)]=(0.77157236042-0.0905717987229j)*x_ref[0]**o + ((0.0249818023642-0.175804958357j))*x_ref[0] + ((-0.900075139304-0.814137414995j))*x_ref[1]**o + ((0.598282066511-0.920951484648j))*x_ref[1]
        arg[(2, 2, 2, 1)]=(0.13619428649+0.508898801369j)*x[0]**o + ((-0.172876127279+0.00639435803819j))*x[0] + ((-0.32293890825-0.564910800764j))*x[1]**o + ((-0.999215835192+0.711923906496j))*x[1]
        ref[(2, 2, 2, 1)]=(0.13619428649+0.508898801369j)*x_ref[0]**o + ((-0.172876127279+0.00639435803819j))*x_ref[0] + ((-0.32293890825-0.564910800764j))*x_ref[1]**o + ((-0.999215835192+0.711923906496j))*x_ref[1]
        arg[(2, 2, 3, 0)]=(-0.89473972806-0.67321699415j)*x[0]**o + ((-0.468054518769+0.430491826403j))*x[0] + ((0.461587045031-0.36456213109j))*x[1]**o + ((0.715905007197-0.340178484305j))*x[1]
        ref[(2, 2, 3, 0)]=(-0.89473972806-0.67321699415j)*x_ref[0]**o + ((-0.468054518769+0.430491826403j))*x_ref[0] + ((0.461587045031-0.36456213109j))*x_ref[1]**o + ((0.715905007197-0.340178484305j))*x_ref[1]
        arg[(2, 2, 3, 1)]=(0.724905540215+0.851355516056j)*x[0]**o + ((0.581211363328-0.512663714688j))*x[0] + ((-0.0425164480093-0.365910611765j))*x[1]**o + ((0.0471504399045+0.030293269042j))*x[1]
        ref[(2, 2, 3, 1)]=(0.724905540215+0.851355516056j)*x_ref[0]**o + ((0.581211363328-0.512663714688j))*x_ref[0] + ((-0.0425164480093-0.365910611765j))*x_ref[1]**o + ((0.0471504399045+0.030293269042j))*x_ref[1]
        arg[(3, 0, 0, 0)]=(0.641051366901+0.0515897479095j)*x[0]**o + ((-0.225064027487+0.765628643953j))*x[0] + ((0.819150020775-0.832862328892j))*x[1]**o + ((0.12289763122-0.464445876354j))*x[1]
        ref[(3, 0, 0, 0)]=(0.641051366901+0.0515897479095j)*x_ref[0]**o + ((-0.225064027487+0.765628643953j))*x_ref[0] + ((0.819150020775-0.832862328892j))*x_ref[1]**o + ((0.12289763122-0.464445876354j))*x_ref[1]
        arg[(3, 0, 0, 1)]=(-0.907162024316-0.774530909347j)*x[0]**o + ((-0.869174649622-0.681900264126j))*x[0] + ((-0.130150671782+0.172671965637j))*x[1]**o + ((-0.859976142263-0.883683824459j))*x[1]
        ref[(3, 0, 0, 1)]=(-0.907162024316-0.774530909347j)*x_ref[0]**o + ((-0.869174649622-0.681900264126j))*x_ref[0] + ((-0.130150671782+0.172671965637j))*x_ref[1]**o + ((-0.859976142263-0.883683824459j))*x_ref[1]
        arg[(3, 0, 1, 0)]=(0.266512683658+0.379992455791j)*x[0]**o + ((-0.922108469687+0.562651002241j))*x[0] + ((0.638033849901+0.59515015797j))*x[1]**o + ((0.946111743576+0.682937504615j))*x[1]
        ref[(3, 0, 1, 0)]=(0.266512683658+0.379992455791j)*x_ref[0]**o + ((-0.922108469687+0.562651002241j))*x_ref[0] + ((0.638033849901+0.59515015797j))*x_ref[1]**o + ((0.946111743576+0.682937504615j))*x_ref[1]
        arg[(3, 0, 1, 1)]=(-0.940092071724+0.730139911018j)*x[0]**o + ((-0.361491457161-0.783937228551j))*x[0] + ((0.87858656067-0.2067069143j))*x[1]**o + ((0.361130666395-0.371621735303j))*x[1]
        ref[(3, 0, 1, 1)]=(-0.940092071724+0.730139911018j)*x_ref[0]**o + ((-0.361491457161-0.783937228551j))*x_ref[0] + ((0.87858656067-0.2067069143j))*x_ref[1]**o + ((0.361130666395-0.371621735303j))*x_ref[1]
        arg[(3, 0, 2, 0)]=(-0.0335488781055+0.412435191403j)*x[0]**o + ((-0.62840706777-0.669702016536j))*x[0] + ((0.414633345727+0.571070552011j))*x[1]**o + ((-0.14416623211+0.193402650396j))*x[1]
        ref[(3, 0, 2, 0)]=(-0.0335488781055+0.412435191403j)*x_ref[0]**o + ((-0.62840706777-0.669702016536j))*x_ref[0] + ((0.414633345727+0.571070552011j))*x_ref[1]**o + ((-0.14416623211+0.193402650396j))*x_ref[1]
        arg[(3, 0, 2, 1)]=(0.443749084561-0.14469175035j)*x[0]**o + ((0.32994754103-0.326353395335j))*x[0] + ((-0.536289282949-0.168605490323j))*x[1]**o + ((-0.568164297615+0.473925204993j))*x[1]
        ref[(3, 0, 2, 1)]=(0.443749084561-0.14469175035j)*x_ref[0]**o + ((0.32994754103-0.326353395335j))*x_ref[0] + ((-0.536289282949-0.168605490323j))*x_ref[1]**o + ((-0.568164297615+0.473925204993j))*x_ref[1]
        arg[(3, 0, 3, 0)]=(0.3809221492+0.545167757843j)*x[0]**o + ((0.444409910525+0.737720661163j))*x[0] + ((-0.744255659189-0.515563933042j))*x[1]**o + ((0.0963560120575+0.285350703719j))*x[1]
        ref[(3, 0, 3, 0)]=(0.3809221492+0.545167757843j)*x_ref[0]**o + ((0.444409910525+0.737720661163j))*x_ref[0] + ((-0.744255659189-0.515563933042j))*x_ref[1]**o + ((0.0963560120575+0.285350703719j))*x_ref[1]
        arg[(3, 0, 3, 1)]=(0.85225581986+0.16261611211j)*x[0]**o + ((0.434116759916+0.567449024972j))*x[0] + ((-0.442122064114-0.390584606767j))*x[1]**o + ((-0.829722313948+0.639142109243j))*x[1]
        ref[(3, 0, 3, 1)]=(0.85225581986+0.16261611211j)*x_ref[0]**o + ((0.434116759916+0.567449024972j))*x_ref[0] + ((-0.442122064114-0.390584606767j))*x_ref[1]**o + ((-0.829722313948+0.639142109243j))*x_ref[1]
        arg[(3, 1, 0, 0)]=(0.0943041157891+0.837431297904j)*x[0]**o + ((0.646503137132-0.133509855609j))*x[0] + ((-0.498527541448+0.231104236922j))*x[1]**o + ((-0.448770173229+0.330933184465j))*x[1]
        ref[(3, 1, 0, 0)]=(0.0943041157891+0.837431297904j)*x_ref[0]**o + ((0.646503137132-0.133509855609j))*x_ref[0] + ((-0.498527541448+0.231104236922j))*x_ref[1]**o + ((-0.448770173229+0.330933184465j))*x_ref[1]
        arg[(3, 1, 0, 1)]=(0.495585294829+0.686281865919j)*x[0]**o + ((-0.536024464999-0.330325831229j))*x[0] + ((-0.309557143358+0.2302072951j))*x[1]**o + ((0.238626700459-0.530885186333j))*x[1]
        ref[(3, 1, 0, 1)]=(0.495585294829+0.686281865919j)*x_ref[0]**o + ((-0.536024464999-0.330325831229j))*x_ref[0] + ((-0.309557143358+0.2302072951j))*x_ref[1]**o + ((0.238626700459-0.530885186333j))*x_ref[1]
        arg[(3, 1, 1, 0)]=(0.496231383089-0.277300815797j)*x[0]**o + ((0.943192168392+0.98801824354j))*x[0] + ((-0.755296765989+0.340000388214j))*x[1]**o + ((-0.780549116942-0.604052795229j))*x[1]
        ref[(3, 1, 1, 0)]=(0.496231383089-0.277300815797j)*x_ref[0]**o + ((0.943192168392+0.98801824354j))*x_ref[0] + ((-0.755296765989+0.340000388214j))*x_ref[1]**o + ((-0.780549116942-0.604052795229j))*x_ref[1]
        arg[(3, 1, 1, 1)]=(0.521330472125+0.948571738125j)*x[0]**o + ((0.201444693312-0.923661046742j))*x[0] + ((-0.373007193166+0.0707889801408j))*x[1]**o + ((-0.143850591739-0.832591290867j))*x[1]
        ref[(3, 1, 1, 1)]=(0.521330472125+0.948571738125j)*x_ref[0]**o + ((0.201444693312-0.923661046742j))*x_ref[0] + ((-0.373007193166+0.0707889801408j))*x_ref[1]**o + ((-0.143850591739-0.832591290867j))*x_ref[1]
        arg[(3, 1, 2, 0)]=(0.535273795608+0.716901748302j)*x[0]**o + ((-0.906233536713+0.0817470076078j))*x[0] + ((-0.52750399371-0.859857830472j))*x[1]**o + ((0.00899346343056+0.0397753019148j))*x[1]
        ref[(3, 1, 2, 0)]=(0.535273795608+0.716901748302j)*x_ref[0]**o + ((-0.906233536713+0.0817470076078j))*x_ref[0] + ((-0.52750399371-0.859857830472j))*x_ref[1]**o + ((0.00899346343056+0.0397753019148j))*x_ref[1]
        arg[(3, 1, 2, 1)]=(-0.153530786702+0.74520717532j)*x[0]**o + ((-0.47160378297-0.697713455986j))*x[0] + ((-0.985254312083+0.438691498284j))*x[1]**o + ((0.478434959764+0.804684421264j))*x[1]
        ref[(3, 1, 2, 1)]=(-0.153530786702+0.74520717532j)*x_ref[0]**o + ((-0.47160378297-0.697713455986j))*x_ref[0] + ((-0.985254312083+0.438691498284j))*x_ref[1]**o + ((0.478434959764+0.804684421264j))*x_ref[1]
        arg[(3, 1, 3, 0)]=(-0.564549353412-0.917498134234j)*x[0]**o + ((0.597679626159-0.0035149885684j))*x[0] + ((-0.458908239157-0.146424901671j))*x[1]**o + ((0.955231255267+0.867887521497j))*x[1]
        ref[(3, 1, 3, 0)]=(-0.564549353412-0.917498134234j)*x_ref[0]**o + ((0.597679626159-0.0035149885684j))*x_ref[0] + ((-0.458908239157-0.146424901671j))*x_ref[1]**o + ((0.955231255267+0.867887521497j))*x_ref[1]
        arg[(3, 1, 3, 1)]=(0.114935372927-0.795887640589j)*x[0]**o + ((-0.0800654736489+0.940433678987j))*x[0] + ((0.367615021026+0.998202299415j))*x[1]**o + ((-0.0705438775198-0.143178050498j))*x[1]
        ref[(3, 1, 3, 1)]=(0.114935372927-0.795887640589j)*x_ref[0]**o + ((-0.0800654736489+0.940433678987j))*x_ref[0] + ((0.367615021026+0.998202299415j))*x_ref[1]**o + ((-0.0705438775198-0.143178050498j))*x_ref[1]
        arg[(3, 2, 0, 0)]=(-0.821946259282+0.20014305211j)*x[0]**o + ((-0.975311313363-0.467068374411j))*x[0] + ((0.320552678992-0.165089290177j))*x[1]**o + ((0.134522184556+0.732265937071j))*x[1]
        ref[(3, 2, 0, 0)]=(-0.821946259282+0.20014305211j)*x_ref[0]**o + ((-0.975311313363-0.467068374411j))*x_ref[0] + ((0.320552678992-0.165089290177j))*x_ref[1]**o + ((0.134522184556+0.732265937071j))*x_ref[1]
        arg[(3, 2, 0, 1)]=(0.735002383342+0.592740980483j)*x[0]**o + ((0.164054946619-0.0484588561467j))*x[0] + ((0.642553692806+0.104227309723j))*x[1]**o + ((-0.649949873515-0.967796428418j))*x[1]
        ref[(3, 2, 0, 1)]=(0.735002383342+0.592740980483j)*x_ref[0]**o + ((0.164054946619-0.0484588561467j))*x_ref[0] + ((0.642553692806+0.104227309723j))*x_ref[1]**o + ((-0.649949873515-0.967796428418j))*x_ref[1]
        arg[(3, 2, 1, 0)]=(0.778224091045+0.634225026582j)*x[0]**o + ((0.234440366647-0.891345194591j))*x[0] + ((0.404589357761-0.424480768626j))*x[1]**o + ((0.569684924756+0.309613739372j))*x[1]
        ref[(3, 2, 1, 0)]=(0.778224091045+0.634225026582j)*x_ref[0]**o + ((0.234440366647-0.891345194591j))*x_ref[0] + ((0.404589357761-0.424480768626j))*x_ref[1]**o + ((0.569684924756+0.309613739372j))*x_ref[1]
        arg[(3, 2, 1, 1)]=(0.336435385957-0.356596601262j)*x[0]**o + ((0.752618471041+0.0940750518898j))*x[0] + ((0.884812712005+0.317172681778j))*x[1]**o + ((0.729340019533-0.794377705309j))*x[1]
        ref[(3, 2, 1, 1)]=(0.336435385957-0.356596601262j)*x_ref[0]**o + ((0.752618471041+0.0940750518898j))*x_ref[0] + ((0.884812712005+0.317172681778j))*x_ref[1]**o + ((0.729340019533-0.794377705309j))*x_ref[1]
        arg[(3, 2, 2, 0)]=(-0.401718457622+0.810877551039j)*x[0]**o + ((-0.0905449836774-0.906210402026j))*x[0] + ((0.513131070374+0.896251618385j))*x[1]**o + ((-0.997142302062-0.169528518103j))*x[1]
        ref[(3, 2, 2, 0)]=(-0.401718457622+0.810877551039j)*x_ref[0]**o + ((-0.0905449836774-0.906210402026j))*x_ref[0] + ((0.513131070374+0.896251618385j))*x_ref[1]**o + ((-0.997142302062-0.169528518103j))*x_ref[1]
        arg[(3, 2, 2, 1)]=(0.810310105976+0.769501734805j)*x[0]**o + ((-0.585019186948-0.78879880804j))*x[0] + ((-0.288632150957-0.386467038018j))*x[1]**o + ((-0.930873024493-0.241091988368j))*x[1]
        ref[(3, 2, 2, 1)]=(0.810310105976+0.769501734805j)*x_ref[0]**o + ((-0.585019186948-0.78879880804j))*x_ref[0] + ((-0.288632150957-0.386467038018j))*x_ref[1]**o + ((-0.930873024493-0.241091988368j))*x_ref[1]
        arg[(3, 2, 3, 0)]=(0.912346460508-0.442698148397j)*x[0]**o + ((0.718763416949+0.199684325594j))*x[0] + ((-0.531730665732-0.895991506013j))*x[1]**o + ((0.799107256242+0.506788362626j))*x[1]
        ref[(3, 2, 3, 0)]=(0.912346460508-0.442698148397j)*x_ref[0]**o + ((0.718763416949+0.199684325594j))*x_ref[0] + ((-0.531730665732-0.895991506013j))*x_ref[1]**o + ((0.799107256242+0.506788362626j))*x_ref[1]
        arg[(3, 2, 3, 1)]=(-0.372160831315+0.642209686208j)*x[0]**o + ((-0.388464414275+0.117042963684j))*x[0] + ((0.976799295049-0.882475855592j))*x[1]**o + ((-0.281138395587-0.0491399944191j))*x[1]
        ref[(3, 2, 3, 1)]=(-0.372160831315+0.642209686208j)*x_ref[0]**o + ((-0.388464414275+0.117042963684j))*x_ref[0] + ((0.976799295049-0.882475855592j))*x_ref[1]**o + ((-0.281138395587-0.0491399944191j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(-0.512772949936+0.521498878376j)*x[2]**o + ((0.393136504134+0.642991269746j))*x[2]
            ref[(0, 0, 0, 0)]+=(-0.512772949936+0.521498878376j)*x_ref[2]**o + ((0.393136504134+0.642991269746j))*x_ref[2]
            arg[(0, 0, 0, 1)]+=(0.974228335691+0.799048116771j)*x[2]**o + ((-0.174282895338+0.194080785214j))*x[2]
            ref[(0, 0, 0, 1)]+=(0.974228335691+0.799048116771j)*x_ref[2]**o + ((-0.174282895338+0.194080785214j))*x_ref[2]
            arg[(0, 0, 1, 0)]+=(0.922381726229-0.269679659102j)*x[2]**o + ((0.476000238007-0.965363383574j))*x[2]
            ref[(0, 0, 1, 0)]+=(0.922381726229-0.269679659102j)*x_ref[2]**o + ((0.476000238007-0.965363383574j))*x_ref[2]
            arg[(0, 0, 1, 1)]+=(0.969567437184-0.913237822149j)*x[2]**o + ((-0.0126615720289-0.00169690924979j))*x[2]
            ref[(0, 0, 1, 1)]+=(0.969567437184-0.913237822149j)*x_ref[2]**o + ((-0.0126615720289-0.00169690924979j))*x_ref[2]
            arg[(0, 0, 2, 0)]+=(-0.0828081671482+0.548002690871j)*x[2]**o + ((-0.373067147347-0.48578364413j))*x[2]
            ref[(0, 0, 2, 0)]+=(-0.0828081671482+0.548002690871j)*x_ref[2]**o + ((-0.373067147347-0.48578364413j))*x_ref[2]
            arg[(0, 0, 2, 1)]+=(-0.597577470791+0.884172042688j)*x[2]**o + ((-0.102223032374-0.893975741973j))*x[2]
            ref[(0, 0, 2, 1)]+=(-0.597577470791+0.884172042688j)*x_ref[2]**o + ((-0.102223032374-0.893975741973j))*x_ref[2]
            arg[(0, 0, 3, 0)]+=(-0.926679931513+0.472940776251j)*x[2]**o + ((0.217517735596-0.616840152j))*x[2]
            ref[(0, 0, 3, 0)]+=(-0.926679931513+0.472940776251j)*x_ref[2]**o + ((0.217517735596-0.616840152j))*x_ref[2]
            arg[(0, 0, 3, 1)]+=(0.153860264446-0.75239667131j)*x[2]**o + ((0.766058121932-0.744695115136j))*x[2]
            ref[(0, 0, 3, 1)]+=(0.153860264446-0.75239667131j)*x_ref[2]**o + ((0.766058121932-0.744695115136j))*x_ref[2]
            arg[(0, 1, 0, 0)]+=(0.20893181213-0.114573961146j)*x[2]**o + ((-0.216170382353-0.846736955689j))*x[2]
            ref[(0, 1, 0, 0)]+=(0.20893181213-0.114573961146j)*x_ref[2]**o + ((-0.216170382353-0.846736955689j))*x_ref[2]
            arg[(0, 1, 0, 1)]+=(0.61473710329+0.654560313702j)*x[2]**o + ((0.317103204042+0.719378748592j))*x[2]
            ref[(0, 1, 0, 1)]+=(0.61473710329+0.654560313702j)*x_ref[2]**o + ((0.317103204042+0.719378748592j))*x_ref[2]
            arg[(0, 1, 1, 0)]+=(0.975099465576-0.544461066424j)*x[2]**o + ((-0.151804684748-0.23866959026j))*x[2]
            ref[(0, 1, 1, 0)]+=(0.975099465576-0.544461066424j)*x_ref[2]**o + ((-0.151804684748-0.23866959026j))*x_ref[2]
            arg[(0, 1, 1, 1)]+=(0.206392757676-0.874809459204j)*x[2]**o + ((0.799030871025-0.54825219518j))*x[2]
            ref[(0, 1, 1, 1)]+=(0.206392757676-0.874809459204j)*x_ref[2]**o + ((0.799030871025-0.54825219518j))*x_ref[2]
            arg[(0, 1, 2, 0)]+=(-0.118380285189-0.457858920531j)*x[2]**o + ((0.873611867855+0.876450416413j))*x[2]
            ref[(0, 1, 2, 0)]+=(-0.118380285189-0.457858920531j)*x_ref[2]**o + ((0.873611867855+0.876450416413j))*x_ref[2]
            arg[(0, 1, 2, 1)]+=(-0.695315481351+0.353483942685j)*x[2]**o + ((-0.184950155231+0.480623506837j))*x[2]
            ref[(0, 1, 2, 1)]+=(-0.695315481351+0.353483942685j)*x_ref[2]**o + ((-0.184950155231+0.480623506837j))*x_ref[2]
            arg[(0, 1, 3, 0)]+=(0.160823507153-0.763246243044j)*x[2]**o + ((-0.591331569358+0.570533916511j))*x[2]
            ref[(0, 1, 3, 0)]+=(0.160823507153-0.763246243044j)*x_ref[2]**o + ((-0.591331569358+0.570533916511j))*x_ref[2]
            arg[(0, 1, 3, 1)]+=(0.00979927687653-0.60884747182j)*x[2]**o + ((-0.978116394744+0.217160332206j))*x[2]
            ref[(0, 1, 3, 1)]+=(0.00979927687653-0.60884747182j)*x_ref[2]**o + ((-0.978116394744+0.217160332206j))*x_ref[2]
            arg[(0, 2, 0, 0)]+=(0.936502064714-0.312761234868j)*x[2]**o + ((-0.551341018302+0.00527116996548j))*x[2]
            ref[(0, 2, 0, 0)]+=(0.936502064714-0.312761234868j)*x_ref[2]**o + ((-0.551341018302+0.00527116996548j))*x_ref[2]
            arg[(0, 2, 0, 1)]+=(-0.32933868352-0.782370420229j)*x[2]**o + ((-0.498232259793-0.732082592697j))*x[2]
            ref[(0, 2, 0, 1)]+=(-0.32933868352-0.782370420229j)*x_ref[2]**o + ((-0.498232259793-0.732082592697j))*x_ref[2]
            arg[(0, 2, 1, 0)]+=(-0.950190094373-0.722904244259j)*x[2]**o + ((-0.697071985987+0.868194228635j))*x[2]
            ref[(0, 2, 1, 0)]+=(-0.950190094373-0.722904244259j)*x_ref[2]**o + ((-0.697071985987+0.868194228635j))*x_ref[2]
            arg[(0, 2, 1, 1)]+=(0.705022363733-0.884213315258j)*x[2]**o + ((-0.417559221525-0.417068273024j))*x[2]
            ref[(0, 2, 1, 1)]+=(0.705022363733-0.884213315258j)*x_ref[2]**o + ((-0.417559221525-0.417068273024j))*x_ref[2]
            arg[(0, 2, 2, 0)]+=(0.313208754472-0.358937856955j)*x[2]**o + ((-0.923596855684-0.819433563813j))*x[2]
            ref[(0, 2, 2, 0)]+=(0.313208754472-0.358937856955j)*x_ref[2]**o + ((-0.923596855684-0.819433563813j))*x_ref[2]
            arg[(0, 2, 2, 1)]+=(0.681741285497+0.16857545805j)*x[2]**o + ((0.682243980874+0.926772391826j))*x[2]
            ref[(0, 2, 2, 1)]+=(0.681741285497+0.16857545805j)*x_ref[2]**o + ((0.682243980874+0.926772391826j))*x_ref[2]
            arg[(0, 2, 3, 0)]+=(-0.374694931911-0.938309809422j)*x[2]**o + ((0.640895111173+0.33234039544j))*x[2]
            ref[(0, 2, 3, 0)]+=(-0.374694931911-0.938309809422j)*x_ref[2]**o + ((0.640895111173+0.33234039544j))*x_ref[2]
            arg[(0, 2, 3, 1)]+=(-0.736360588789+0.285753300111j)*x[2]**o + ((0.785129354668+0.913657724219j))*x[2]
            ref[(0, 2, 3, 1)]+=(-0.736360588789+0.285753300111j)*x_ref[2]**o + ((0.785129354668+0.913657724219j))*x_ref[2]
            arg[(1, 0, 0, 0)]+=(-0.42514686536-0.992864037731j)*x[2]**o + ((0.776338925159-0.686979500122j))*x[2]
            ref[(1, 0, 0, 0)]+=(-0.42514686536-0.992864037731j)*x_ref[2]**o + ((0.776338925159-0.686979500122j))*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.24729468777-0.251048420405j)*x[2]**o + ((0.191740509959-0.79181112438j))*x[2]
            ref[(1, 0, 0, 1)]+=(0.24729468777-0.251048420405j)*x_ref[2]**o + ((0.191740509959-0.79181112438j))*x_ref[2]
            arg[(1, 0, 1, 0)]+=(0.625246750647-0.208969012008j)*x[2]**o + ((0.78755740158-0.589750069553j))*x[2]
            ref[(1, 0, 1, 0)]+=(0.625246750647-0.208969012008j)*x_ref[2]**o + ((0.78755740158-0.589750069553j))*x_ref[2]
            arg[(1, 0, 1, 1)]+=(-0.186108158782+0.0686091132548j)*x[2]**o + ((0.978357269239+0.0450307917834j))*x[2]
            ref[(1, 0, 1, 1)]+=(-0.186108158782+0.0686091132548j)*x_ref[2]**o + ((0.978357269239+0.0450307917834j))*x_ref[2]
            arg[(1, 0, 2, 0)]+=(-0.44327256909-0.481781757068j)*x[2]**o + ((-0.563951576317+0.354864060187j))*x[2]
            ref[(1, 0, 2, 0)]+=(-0.44327256909-0.481781757068j)*x_ref[2]**o + ((-0.563951576317+0.354864060187j))*x_ref[2]
            arg[(1, 0, 2, 1)]+=(-0.582587395728-0.676242792095j)*x[2]**o + ((-0.540778095127-0.967203869319j))*x[2]
            ref[(1, 0, 2, 1)]+=(-0.582587395728-0.676242792095j)*x_ref[2]**o + ((-0.540778095127-0.967203869319j))*x_ref[2]
            arg[(1, 0, 3, 0)]+=(0.252659928211+0.991520335834j)*x[2]**o + ((0.0338116049659-0.422040075519j))*x[2]
            ref[(1, 0, 3, 0)]+=(0.252659928211+0.991520335834j)*x_ref[2]**o + ((0.0338116049659-0.422040075519j))*x_ref[2]
            arg[(1, 0, 3, 1)]+=(0.560927427125-0.559584971986j)*x[2]**o + ((0.174675859112+0.226714460279j))*x[2]
            ref[(1, 0, 3, 1)]+=(0.560927427125-0.559584971986j)*x_ref[2]**o + ((0.174675859112+0.226714460279j))*x_ref[2]
            arg[(1, 1, 0, 0)]+=(-0.64938985274+0.164814993211j)*x[2]**o + ((0.4435077986-0.774126270764j))*x[2]
            ref[(1, 1, 0, 0)]+=(-0.64938985274+0.164814993211j)*x_ref[2]**o + ((0.4435077986-0.774126270764j))*x_ref[2]
            arg[(1, 1, 0, 1)]+=(0.754204282633+0.29997545639j)*x[2]**o + ((-0.345836824514+0.841474049454j))*x[2]
            ref[(1, 1, 0, 1)]+=(0.754204282633+0.29997545639j)*x_ref[2]**o + ((-0.345836824514+0.841474049454j))*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.802095422816+0.0582918665554j)*x[2]**o + ((0.0867838955068+0.392764493018j))*x[2]
            ref[(1, 1, 1, 0)]+=(0.802095422816+0.0582918665554j)*x_ref[2]**o + ((0.0867838955068+0.392764493018j))*x_ref[2]
            arg[(1, 1, 1, 1)]+=(0.335472554459+0.988933724119j)*x[2]**o + ((0.992489716722-0.788772126881j))*x[2]
            ref[(1, 1, 1, 1)]+=(0.335472554459+0.988933724119j)*x_ref[2]**o + ((0.992489716722-0.788772126881j))*x_ref[2]
            arg[(1, 1, 2, 0)]+=(0.835460660518+0.835699674597j)*x[2]**o + ((-0.788945250446+0.154851778792j))*x[2]
            ref[(1, 1, 2, 0)]+=(0.835460660518+0.835699674597j)*x_ref[2]**o + ((-0.788945250446+0.154851778792j))*x_ref[2]
            arg[(1, 1, 2, 1)]+=(0.332052419734-0.449995813236j)*x[2]**o + ((-0.818677395473+0.150669150733j))*x[2]
            ref[(1, 1, 2, 1)]+=(0.332052419734-0.449995813236j)*x_ref[2]**o + ((-0.818677395473+0.150669150733j))*x_ref[2]
            arg[(1, 1, 3, 0)]+=(0.915581201466-0.536584648032j)*x[2]**o + ((0.0788460064092-0.77787688066j))*x[2]
            ref[(1, 1, 3, 0)]+=(0.915581201466-0.536584648032j)*x_ref[2]**o + ((0.0788460064092-0.77787688066j))*x_ref[2]
            arg[(1, 1, 3, 1)]+=(-0.961956177616+0.620505312642j)*x[2]**o + ((-0.587701000478+0.504852818841j))*x[2]
            ref[(1, 1, 3, 1)]+=(-0.961956177616+0.620505312642j)*x_ref[2]**o + ((-0.587701000478+0.504852818841j))*x_ref[2]
            arg[(1, 2, 0, 0)]+=(-0.68689131437+0.512419196087j)*x[2]**o + ((0.439956844336-0.829616353237j))*x[2]
            ref[(1, 2, 0, 0)]+=(-0.68689131437+0.512419196087j)*x_ref[2]**o + ((0.439956844336-0.829616353237j))*x_ref[2]
            arg[(1, 2, 0, 1)]+=(-0.547746734498+0.13183754321j)*x[2]**o + ((0.85975472629-0.288459510046j))*x[2]
            ref[(1, 2, 0, 1)]+=(-0.547746734498+0.13183754321j)*x_ref[2]**o + ((0.85975472629-0.288459510046j))*x_ref[2]
            arg[(1, 2, 1, 0)]+=(0.830066982439-0.911093926275j)*x[2]**o + ((-0.11714139932+0.936922314626j))*x[2]
            ref[(1, 2, 1, 0)]+=(0.830066982439-0.911093926275j)*x_ref[2]**o + ((-0.11714139932+0.936922314626j))*x_ref[2]
            arg[(1, 2, 1, 1)]+=(-0.0999830115504+0.755641918165j)*x[2]**o + ((-0.281246345124-0.461029467779j))*x[2]
            ref[(1, 2, 1, 1)]+=(-0.0999830115504+0.755641918165j)*x_ref[2]**o + ((-0.281246345124-0.461029467779j))*x_ref[2]
            arg[(1, 2, 2, 0)]+=(0.459859472258-0.136392764404j)*x[2]**o + ((-0.927674011811+0.426052814777j))*x[2]
            ref[(1, 2, 2, 0)]+=(0.459859472258-0.136392764404j)*x_ref[2]**o + ((-0.927674011811+0.426052814777j))*x_ref[2]
            arg[(1, 2, 2, 1)]+=(0.959832960504+0.290718644333j)*x[2]**o + ((0.575709668295-0.635156490962j))*x[2]
            ref[(1, 2, 2, 1)]+=(0.959832960504+0.290718644333j)*x_ref[2]**o + ((0.575709668295-0.635156490962j))*x_ref[2]
            arg[(1, 2, 3, 0)]+=(-0.791451200378-0.715032468956j)*x[2]**o + ((0.470475762976-0.894560548585j))*x[2]
            ref[(1, 2, 3, 0)]+=(-0.791451200378-0.715032468956j)*x_ref[2]**o + ((0.470475762976-0.894560548585j))*x_ref[2]
            arg[(1, 2, 3, 1)]+=(0.281025822403+0.809898199925j)*x[2]**o + ((0.904688987253+0.203458402738j))*x[2]
            ref[(1, 2, 3, 1)]+=(0.281025822403+0.809898199925j)*x_ref[2]**o + ((0.904688987253+0.203458402738j))*x_ref[2]
            arg[(2, 0, 0, 0)]+=(0.00463956656638-0.0853569041892j)*x[2]**o + ((0.641181067414+0.215278989148j))*x[2]
            ref[(2, 0, 0, 0)]+=(0.00463956656638-0.0853569041892j)*x_ref[2]**o + ((0.641181067414+0.215278989148j))*x_ref[2]
            arg[(2, 0, 0, 1)]+=(-0.655525060846+0.679713480864j)*x[2]**o + ((-0.915799867131-0.671231197926j))*x[2]
            ref[(2, 0, 0, 1)]+=(-0.655525060846+0.679713480864j)*x_ref[2]**o + ((-0.915799867131-0.671231197926j))*x_ref[2]
            arg[(2, 0, 1, 0)]+=(-0.636435342913-0.920556184828j)*x[2]**o + ((-0.951250702184-0.481888221417j))*x[2]
            ref[(2, 0, 1, 0)]+=(-0.636435342913-0.920556184828j)*x_ref[2]**o + ((-0.951250702184-0.481888221417j))*x_ref[2]
            arg[(2, 0, 1, 1)]+=(0.92674643755-0.920773435047j)*x[2]**o + ((0.396952480911-0.920399809281j))*x[2]
            ref[(2, 0, 1, 1)]+=(0.92674643755-0.920773435047j)*x_ref[2]**o + ((0.396952480911-0.920399809281j))*x_ref[2]
            arg[(2, 0, 2, 0)]+=(0.190671186452+0.535670409383j)*x[2]**o + ((-0.999825227149-0.156491252169j))*x[2]
            ref[(2, 0, 2, 0)]+=(0.190671186452+0.535670409383j)*x_ref[2]**o + ((-0.999825227149-0.156491252169j))*x_ref[2]
            arg[(2, 0, 2, 1)]+=(0.164813411388+0.860654303125j)*x[2]**o + ((-0.0588739274788+0.451121665895j))*x[2]
            ref[(2, 0, 2, 1)]+=(0.164813411388+0.860654303125j)*x_ref[2]**o + ((-0.0588739274788+0.451121665895j))*x_ref[2]
            arg[(2, 0, 3, 0)]+=(0.547242013424-0.869732289983j)*x[2]**o + ((-0.15017462271+0.752943604802j))*x[2]
            ref[(2, 0, 3, 0)]+=(0.547242013424-0.869732289983j)*x_ref[2]**o + ((-0.15017462271+0.752943604802j))*x_ref[2]
            arg[(2, 0, 3, 1)]+=(0.719606400953+0.482189654808j)*x[2]**o + ((-0.88890273991-0.754799413741j))*x[2]
            ref[(2, 0, 3, 1)]+=(0.719606400953+0.482189654808j)*x_ref[2]**o + ((-0.88890273991-0.754799413741j))*x_ref[2]
            arg[(2, 1, 0, 0)]+=(0.452847276441-0.0961997988272j)*x[2]**o + ((-0.927196232317+0.390501515998j))*x[2]
            ref[(2, 1, 0, 0)]+=(0.452847276441-0.0961997988272j)*x_ref[2]**o + ((-0.927196232317+0.390501515998j))*x_ref[2]
            arg[(2, 1, 0, 1)]+=(-0.697817472916+0.0701443818484j)*x[2]**o + ((-0.685129017868-0.711359760466j))*x[2]
            ref[(2, 1, 0, 1)]+=(-0.697817472916+0.0701443818484j)*x_ref[2]**o + ((-0.685129017868-0.711359760466j))*x_ref[2]
            arg[(2, 1, 1, 0)]+=(0.0012890277993-0.233847543194j)*x[2]**o + ((-0.0708940913532+0.638748666782j))*x[2]
            ref[(2, 1, 1, 0)]+=(0.0012890277993-0.233847543194j)*x_ref[2]**o + ((-0.0708940913532+0.638748666782j))*x_ref[2]
            arg[(2, 1, 1, 1)]+=(-0.128611688005-0.362987113772j)*x[2]**o + ((-0.790628073732-0.782021949052j))*x[2]
            ref[(2, 1, 1, 1)]+=(-0.128611688005-0.362987113772j)*x_ref[2]**o + ((-0.790628073732-0.782021949052j))*x_ref[2]
            arg[(2, 1, 2, 0)]+=(0.0272631122983+0.0720557204073j)*x[2]**o + ((-0.688115986694+0.292169942244j))*x[2]
            ref[(2, 1, 2, 0)]+=(0.0272631122983+0.0720557204073j)*x_ref[2]**o + ((-0.688115986694+0.292169942244j))*x_ref[2]
            arg[(2, 1, 2, 1)]+=(0.837721597229-0.981881011185j)*x[2]**o + ((-0.105833679759+0.683702710898j))*x[2]
            ref[(2, 1, 2, 1)]+=(0.837721597229-0.981881011185j)*x_ref[2]**o + ((-0.105833679759+0.683702710898j))*x_ref[2]
            arg[(2, 1, 3, 0)]+=(0.29051945691-0.578591183943j)*x[2]**o + ((-0.968805343584-0.258074595228j))*x[2]
            ref[(2, 1, 3, 0)]+=(0.29051945691-0.578591183943j)*x_ref[2]**o + ((-0.968805343584-0.258074595228j))*x_ref[2]
            arg[(2, 1, 3, 1)]+=(0.0677296744482+0.0539776218098j)*x[2]**o + ((-0.779692297097-0.624339978505j))*x[2]
            ref[(2, 1, 3, 1)]+=(0.0677296744482+0.0539776218098j)*x_ref[2]**o + ((-0.779692297097-0.624339978505j))*x_ref[2]
            arg[(2, 2, 0, 0)]+=(0.314840556491-0.0858936665436j)*x[2]**o + ((-0.594139941085+0.943949643492j))*x[2]
            ref[(2, 2, 0, 0)]+=(0.314840556491-0.0858936665436j)*x_ref[2]**o + ((-0.594139941085+0.943949643492j))*x_ref[2]
            arg[(2, 2, 0, 1)]+=(0.102549183414-0.613122109473j)*x[2]**o + ((-0.0225359753269+0.206278942279j))*x[2]
            ref[(2, 2, 0, 1)]+=(0.102549183414-0.613122109473j)*x_ref[2]**o + ((-0.0225359753269+0.206278942279j))*x_ref[2]
            arg[(2, 2, 1, 0)]+=(0.944702179131+0.685844607873j)*x[2]**o + ((0.568153756921-0.586985902461j))*x[2]
            ref[(2, 2, 1, 0)]+=(0.944702179131+0.685844607873j)*x_ref[2]**o + ((0.568153756921-0.586985902461j))*x_ref[2]
            arg[(2, 2, 1, 1)]+=(0.925620903394+0.721536497387j)*x[2]**o + ((0.399649489368+0.0449703850484j))*x[2]
            ref[(2, 2, 1, 1)]+=(0.925620903394+0.721536497387j)*x_ref[2]**o + ((0.399649489368+0.0449703850484j))*x_ref[2]
            arg[(2, 2, 2, 0)]+=(0.869221743938-0.363267213393j)*x[2]**o + ((0.496898797215-0.128626248935j))*x[2]
            ref[(2, 2, 2, 0)]+=(0.869221743938-0.363267213393j)*x_ref[2]**o + ((0.496898797215-0.128626248935j))*x_ref[2]
            arg[(2, 2, 2, 1)]+=(-0.0218746125444-0.124809560454j)*x[2]**o + ((-0.452358031111+0.514712849284j))*x[2]
            ref[(2, 2, 2, 1)]+=(-0.0218746125444-0.124809560454j)*x_ref[2]**o + ((-0.452358031111+0.514712849284j))*x_ref[2]
            arg[(2, 2, 3, 0)]+=(0.223304906994-0.0523278391377j)*x[2]**o + ((-0.211907722163+0.944759820925j))*x[2]
            ref[(2, 2, 3, 0)]+=(0.223304906994-0.0523278391377j)*x_ref[2]**o + ((-0.211907722163+0.944759820925j))*x_ref[2]
            arg[(2, 2, 3, 1)]+=(0.874890753085-0.268389438443j)*x[2]**o + ((-0.433929398675+0.764734965871j))*x[2]
            ref[(2, 2, 3, 1)]+=(0.874890753085-0.268389438443j)*x_ref[2]**o + ((-0.433929398675+0.764734965871j))*x_ref[2]
            arg[(3, 0, 0, 0)]+=(-0.806387990133-0.284036500784j)*x[2]**o + ((-0.0554431555938+0.441159907827j))*x[2]
            ref[(3, 0, 0, 0)]+=(-0.806387990133-0.284036500784j)*x_ref[2]**o + ((-0.0554431555938+0.441159907827j))*x_ref[2]
            arg[(3, 0, 0, 1)]+=(0.795648379505-0.48093077512j)*x[2]**o + ((-0.0172578808049-0.316786423354j))*x[2]
            ref[(3, 0, 0, 1)]+=(0.795648379505-0.48093077512j)*x_ref[2]**o + ((-0.0172578808049-0.316786423354j))*x_ref[2]
            arg[(3, 0, 1, 0)]+=(0.838253188019+0.169985675633j)*x[2]**o + ((0.581930411005+0.106378620249j))*x[2]
            ref[(3, 0, 1, 0)]+=(0.838253188019+0.169985675633j)*x_ref[2]**o + ((0.581930411005+0.106378620249j))*x_ref[2]
            arg[(3, 0, 1, 1)]+=(-0.57034230689+0.519536927246j)*x[2]**o + ((0.741090098244+0.893762809721j))*x[2]
            ref[(3, 0, 1, 1)]+=(-0.57034230689+0.519536927246j)*x_ref[2]**o + ((0.741090098244+0.893762809721j))*x_ref[2]
            arg[(3, 0, 2, 0)]+=(0.23486153609-0.658386489092j)*x[2]**o + ((-0.846918742921-0.0177257256734j))*x[2]
            ref[(3, 0, 2, 0)]+=(0.23486153609-0.658386489092j)*x_ref[2]**o + ((-0.846918742921-0.0177257256734j))*x_ref[2]
            arg[(3, 0, 2, 1)]+=(-0.107741886821+0.960339042222j)*x[2]**o + ((-0.0624592370668-0.438100040383j))*x[2]
            ref[(3, 0, 2, 1)]+=(-0.107741886821+0.960339042222j)*x_ref[2]**o + ((-0.0624592370668-0.438100040383j))*x_ref[2]
            arg[(3, 0, 3, 0)]+=(0.717637715272-0.683937770472j)*x[2]**o + ((-0.459091438363-0.109866654721j))*x[2]
            ref[(3, 0, 3, 0)]+=(0.717637715272-0.683937770472j)*x_ref[2]**o + ((-0.459091438363-0.109866654721j))*x_ref[2]
            arg[(3, 0, 3, 1)]+=(0.811167116952-0.749109009947j)*x[2]**o + ((0.530220648483-0.156537866544j))*x[2]
            ref[(3, 0, 3, 1)]+=(0.811167116952-0.749109009947j)*x_ref[2]**o + ((0.530220648483-0.156537866544j))*x_ref[2]
            arg[(3, 1, 0, 0)]+=(0.777298309832-0.68517437081j)*x[2]**o + ((-0.208440709002-0.857952027103j))*x[2]
            ref[(3, 1, 0, 0)]+=(0.777298309832-0.68517437081j)*x_ref[2]**o + ((-0.208440709002-0.857952027103j))*x_ref[2]
            arg[(3, 1, 0, 1)]+=(-0.0119061277981+0.587925606734j)*x[2]**o + ((-0.292694483741-0.56870306766j))*x[2]
            ref[(3, 1, 0, 1)]+=(-0.0119061277981+0.587925606734j)*x_ref[2]**o + ((-0.292694483741-0.56870306766j))*x_ref[2]
            arg[(3, 1, 1, 0)]+=(-0.20456826337+0.163201298617j)*x[2]**o + ((0.946346910055+0.342373550418j))*x[2]
            ref[(3, 1, 1, 0)]+=(-0.20456826337+0.163201298617j)*x_ref[2]**o + ((0.946346910055+0.342373550418j))*x_ref[2]
            arg[(3, 1, 1, 1)]+=(0.108243367996+0.281684198506j)*x[2]**o + ((0.949127676176+0.419628106403j))*x[2]
            ref[(3, 1, 1, 1)]+=(0.108243367996+0.281684198506j)*x_ref[2]**o + ((0.949127676176+0.419628106403j))*x_ref[2]
            arg[(3, 1, 2, 0)]+=(-0.703845987023-0.882360601152j)*x[2]**o + ((0.248846661578+0.486476667823j))*x[2]
            ref[(3, 1, 2, 0)]+=(-0.703845987023-0.882360601152j)*x_ref[2]**o + ((0.248846661578+0.486476667823j))*x_ref[2]
            arg[(3, 1, 2, 1)]+=(0.232397518142-0.12644753743j)*x[2]**o + ((0.988470269173+0.0384933470595j))*x[2]
            ref[(3, 1, 2, 1)]+=(0.232397518142-0.12644753743j)*x_ref[2]**o + ((0.988470269173+0.0384933470595j))*x_ref[2]
            arg[(3, 1, 3, 0)]+=(-0.574758827068+0.0933320051357j)*x[2]**o + ((-0.367614373256+0.204164509406j))*x[2]
            ref[(3, 1, 3, 0)]+=(-0.574758827068+0.0933320051357j)*x_ref[2]**o + ((-0.367614373256+0.204164509406j))*x_ref[2]
            arg[(3, 1, 3, 1)]+=(0.360959894132+0.985451900847j)*x[2]**o + ((0.336942007691+0.468839972962j))*x[2]
            ref[(3, 1, 3, 1)]+=(0.360959894132+0.985451900847j)*x_ref[2]**o + ((0.336942007691+0.468839972962j))*x_ref[2]
            arg[(3, 2, 0, 0)]+=(0.263907971871-0.834598781696j)*x[2]**o + ((0.767567437597+0.656108407015j))*x[2]
            ref[(3, 2, 0, 0)]+=(0.263907971871-0.834598781696j)*x_ref[2]**o + ((0.767567437597+0.656108407015j))*x_ref[2]
            arg[(3, 2, 0, 1)]+=(0.13979542763+0.836484978134j)*x[2]**o + ((-0.903981165025-0.438361279857j))*x[2]
            ref[(3, 2, 0, 1)]+=(0.13979542763+0.836484978134j)*x_ref[2]**o + ((-0.903981165025-0.438361279857j))*x_ref[2]
            arg[(3, 2, 1, 0)]+=(-0.200087011575+0.328501507388j)*x[2]**o + ((-0.704266610077-0.86418777642j))*x[2]
            ref[(3, 2, 1, 0)]+=(-0.200087011575+0.328501507388j)*x_ref[2]**o + ((-0.704266610077-0.86418777642j))*x_ref[2]
            arg[(3, 2, 1, 1)]+=(0.634670636821-0.949372334442j)*x[2]**o + ((0.438965361955+0.799827069357j))*x[2]
            ref[(3, 2, 1, 1)]+=(0.634670636821-0.949372334442j)*x_ref[2]**o + ((0.438965361955+0.799827069357j))*x_ref[2]
            arg[(3, 2, 2, 0)]+=(0.295407473457-0.504383063381j)*x[2]**o + ((0.208099388841-0.0980739345922j))*x[2]
            ref[(3, 2, 2, 0)]+=(0.295407473457-0.504383063381j)*x_ref[2]**o + ((0.208099388841-0.0980739345922j))*x_ref[2]
            arg[(3, 2, 2, 1)]+=(0.813895228968+0.639578436754j)*x[2]**o + ((0.837597355674-0.53664698257j))*x[2]
            ref[(3, 2, 2, 1)]+=(0.813895228968+0.639578436754j)*x_ref[2]**o + ((0.837597355674-0.53664698257j))*x_ref[2]
            arg[(3, 2, 3, 0)]+=(0.752559176624-0.378459300794j)*x[2]**o + ((-0.859546133678-0.163961057087j))*x[2]
            ref[(3, 2, 3, 0)]+=(0.752559176624-0.378459300794j)*x_ref[2]**o + ((-0.859546133678-0.163961057087j))*x_ref[2]
            arg[(3, 2, 3, 1)]+=(-0.66642609243+0.114784820509j)*x[2]**o + ((-0.453997367001-0.131526393578j))*x[2]
            ref[(3, 2, 3, 1)]+=(-0.66642609243+0.114784820509j)*x_ref[2]**o + ((-0.453997367001-0.131526393578j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3, 4, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedSolution_rank0(self):
        """
        tests interpolation of rank 0 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.16835891081-0.929141179073j)*x[0] + ((0.776579311889+0.0439262723291j))*x[1]
        ref=(-0.16835891081-0.929141179073j)*x_ref[0] + ((0.776579311889+0.0439262723291j))*x_ref[1]
        if dim==3:
            arg+=((-0.229169794019+0.698866519728j))*x[2]
            ref+=((-0.229169794019+0.698866519728j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedSolution_rank1(self):
        """
        tests interpolation of rank 1 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,),w_ref)
        arg[(0,)]=(0.811721758484-0.904742893686j)*x[0] + ((0.083484228548+0.492737305224j))*x[1]
        ref[(0,)]=(0.811721758484-0.904742893686j)*x_ref[0] + ((0.083484228548+0.492737305224j))*x_ref[1]
        arg[(1,)]=(0.11170132314+0.612280097033j)*x[0] + ((-0.584252402599+0.476368606705j))*x[1]
        ref[(1,)]=(0.11170132314+0.612280097033j)*x_ref[0] + ((-0.584252402599+0.476368606705j))*x_ref[1]
        arg[(2,)]=(-0.634238528994-0.212424421364j)*x[0] + ((0.00809976721191-0.551823542801j))*x[1]
        ref[(2,)]=(-0.634238528994-0.212424421364j)*x_ref[0] + ((0.00809976721191-0.551823542801j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(0.450990902346+0.51159107014j)*x[2]
            ref[(0,)]+=(0.450990902346+0.51159107014j)*x_ref[2]
            arg[(1,)]+=(-0.0305338815329-0.712081800001j)*x[2]
            ref[(1,)]+=(-0.0305338815329-0.712081800001j)*x_ref[2]
            arg[(2,)]+=(-0.182552160453-0.741566004281j)*x[2]
            ref[(2,)]+=(-0.182552160453-0.741566004281j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedSolution_rank2(self):
        """
        tests interpolation of rank 2 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3),w_ref)
        arg[(0, 0)]=(0.923867632172+0.644111100592j)*x[0] + ((-0.5957283087-0.253637558035j))*x[1]
        ref[(0, 0)]=(0.923867632172+0.644111100592j)*x_ref[0] + ((-0.5957283087-0.253637558035j))*x_ref[1]
        arg[(0, 1)]=(-0.998400586364+0.21565734616j)*x[0] + ((0.545847687395+0.404879903144j))*x[1]
        ref[(0, 1)]=(-0.998400586364+0.21565734616j)*x_ref[0] + ((0.545847687395+0.404879903144j))*x_ref[1]
        arg[(0, 2)]=(0.544156110837-0.639913652868j)*x[0] + ((-0.909419433229+0.368152926259j))*x[1]
        ref[(0, 2)]=(0.544156110837-0.639913652868j)*x_ref[0] + ((-0.909419433229+0.368152926259j))*x_ref[1]
        arg[(1, 0)]=(0.940742516485+0.305803100519j)*x[0] + ((0.799894572992-0.836087932264j))*x[1]
        ref[(1, 0)]=(0.940742516485+0.305803100519j)*x_ref[0] + ((0.799894572992-0.836087932264j))*x_ref[1]
        arg[(1, 1)]=(0.954854745204+0.0605755543341j)*x[0] + ((-0.200244892335-0.656738035093j))*x[1]
        ref[(1, 1)]=(0.954854745204+0.0605755543341j)*x_ref[0] + ((-0.200244892335-0.656738035093j))*x_ref[1]
        arg[(1, 2)]=(0.813911466637+0.774875065783j)*x[0] + ((-0.110850181936+0.40380853445j))*x[1]
        ref[(1, 2)]=(0.813911466637+0.774875065783j)*x_ref[0] + ((-0.110850181936+0.40380853445j))*x_ref[1]
        arg[(2, 0)]=(0.0577906125001-0.474994322359j)*x[0] + ((0.607113474437-0.481388439895j))*x[1]
        ref[(2, 0)]=(0.0577906125001-0.474994322359j)*x_ref[0] + ((0.607113474437-0.481388439895j))*x_ref[1]
        arg[(2, 1)]=(0.73281757115-0.593340734457j)*x[0] + ((-0.200268494436-0.408193670096j))*x[1]
        ref[(2, 1)]=(0.73281757115-0.593340734457j)*x_ref[0] + ((-0.200268494436-0.408193670096j))*x_ref[1]
        arg[(2, 2)]=(-0.716078455992+0.0719876359267j)*x[0] + ((0.367447670484+0.457538231174j))*x[1]
        ref[(2, 2)]=(-0.716078455992+0.0719876359267j)*x_ref[0] + ((0.367447670484+0.457538231174j))*x_ref[1]
        arg[(3, 0)]=(0.23109547493-0.566494463316j)*x[0] + ((0.0823313245089+0.0862201999787j))*x[1]
        ref[(3, 0)]=(0.23109547493-0.566494463316j)*x_ref[0] + ((0.0823313245089+0.0862201999787j))*x_ref[1]
        arg[(3, 1)]=(0.362716606157+0.868738589049j)*x[0] + ((0.106649410181+0.711617609751j))*x[1]
        ref[(3, 1)]=(0.362716606157+0.868738589049j)*x_ref[0] + ((0.106649410181+0.711617609751j))*x_ref[1]
        arg[(3, 2)]=(-0.53199740054-0.40177621375j)*x[0] + ((0.924539116346-0.269863575912j))*x[1]
        ref[(3, 2)]=(-0.53199740054-0.40177621375j)*x_ref[0] + ((0.924539116346-0.269863575912j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(-0.843258788363-0.289088319123j)*x[2]
            ref[(0, 0)]+=(-0.843258788363-0.289088319123j)*x_ref[2]
            arg[(0, 1)]+=(-0.0505803281308+0.578344122227j)*x[2]
            ref[(0, 1)]+=(-0.0505803281308+0.578344122227j)*x_ref[2]
            arg[(0, 2)]+=(-0.316965586588-0.546775031494j)*x[2]
            ref[(0, 2)]+=(-0.316965586588-0.546775031494j)*x_ref[2]
            arg[(1, 0)]+=(0.785138350808-0.813539046359j)*x[2]
            ref[(1, 0)]+=(0.785138350808-0.813539046359j)*x_ref[2]
            arg[(1, 1)]+=(-0.390716499954+0.23079365548j)*x[2]
            ref[(1, 1)]+=(-0.390716499954+0.23079365548j)*x_ref[2]
            arg[(1, 2)]+=(0.831965410793-0.161377860575j)*x[2]
            ref[(1, 2)]+=(0.831965410793-0.161377860575j)*x_ref[2]
            arg[(2, 0)]+=(0.175892234385-0.759442522694j)*x[2]
            ref[(2, 0)]+=(0.175892234385-0.759442522694j)*x_ref[2]
            arg[(2, 1)]+=(-0.190160531148+0.820603004346j)*x[2]
            ref[(2, 1)]+=(-0.190160531148+0.820603004346j)*x_ref[2]
            arg[(2, 2)]+=(0.711536514003+0.0610730294241j)*x[2]
            ref[(2, 2)]+=(0.711536514003+0.0610730294241j)*x_ref[2]
            arg[(3, 0)]+=(-0.430544922656+0.466189106584j)*x[2]
            ref[(3, 0)]+=(-0.430544922656+0.466189106584j)*x_ref[2]
            arg[(3, 1)]+=(0.975368613548+0.451586516875j)*x[2]
            ref[(3, 1)]+=(0.975368613548+0.451586516875j)*x_ref[2]
            arg[(3, 2)]+=(0.908729123953+0.763357179314j)*x[2]
            ref[(3, 2)]+=(0.908729123953+0.763357179314j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedSolution_rank3(self):
        """
        tests interpolation of rank 3 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 4),w)
        ref = Data(0,(3, 4, 4),w_ref)
        arg[(0, 0, 0)]=(0.142757062311+0.554643288674j)*x[0] + ((-0.427848912073-0.840891715186j))*x[1]
        ref[(0, 0, 0)]=(0.142757062311+0.554643288674j)*x_ref[0] + ((-0.427848912073-0.840891715186j))*x_ref[1]
        arg[(0, 0, 1)]=(0.897484814773+0.115287086877j)*x[0] + ((-0.627058140992-0.828788584934j))*x[1]
        ref[(0, 0, 1)]=(0.897484814773+0.115287086877j)*x_ref[0] + ((-0.627058140992-0.828788584934j))*x_ref[1]
        arg[(0, 0, 2)]=(0.493020084765-0.971646048017j)*x[0] + ((-0.998226839783+0.466181515586j))*x[1]
        ref[(0, 0, 2)]=(0.493020084765-0.971646048017j)*x_ref[0] + ((-0.998226839783+0.466181515586j))*x_ref[1]
        arg[(0, 0, 3)]=(0.7833433277+0.556635058622j)*x[0] + ((0.00248011832903-0.123324314524j))*x[1]
        ref[(0, 0, 3)]=(0.7833433277+0.556635058622j)*x_ref[0] + ((0.00248011832903-0.123324314524j))*x_ref[1]
        arg[(0, 1, 0)]=(0.205605212147+0.836628220315j)*x[0] + ((0.651418699941-0.808344560056j))*x[1]
        ref[(0, 1, 0)]=(0.205605212147+0.836628220315j)*x_ref[0] + ((0.651418699941-0.808344560056j))*x_ref[1]
        arg[(0, 1, 1)]=(0.0630894676135-0.184422399026j)*x[0] + ((-0.607352002291-0.970128984283j))*x[1]
        ref[(0, 1, 1)]=(0.0630894676135-0.184422399026j)*x_ref[0] + ((-0.607352002291-0.970128984283j))*x_ref[1]
        arg[(0, 1, 2)]=(0.763842562882-0.157497551617j)*x[0] + ((-0.439975459814-0.00796777402488j))*x[1]
        ref[(0, 1, 2)]=(0.763842562882-0.157497551617j)*x_ref[0] + ((-0.439975459814-0.00796777402488j))*x_ref[1]
        arg[(0, 1, 3)]=(0.44466273656+0.597770907171j)*x[0] + ((-0.744347063919-0.594476732021j))*x[1]
        ref[(0, 1, 3)]=(0.44466273656+0.597770907171j)*x_ref[0] + ((-0.744347063919-0.594476732021j))*x_ref[1]
        arg[(0, 2, 0)]=(-0.163155003845-0.839226463976j)*x[0] + ((-0.922572312562-0.484623899889j))*x[1]
        ref[(0, 2, 0)]=(-0.163155003845-0.839226463976j)*x_ref[0] + ((-0.922572312562-0.484623899889j))*x_ref[1]
        arg[(0, 2, 1)]=(0.530158117888+0.822690220287j)*x[0] + ((-0.639619086473-0.190812256428j))*x[1]
        ref[(0, 2, 1)]=(0.530158117888+0.822690220287j)*x_ref[0] + ((-0.639619086473-0.190812256428j))*x_ref[1]
        arg[(0, 2, 2)]=(0.94700521919-0.847479969163j)*x[0] + ((-0.287134454938-0.712246261697j))*x[1]
        ref[(0, 2, 2)]=(0.94700521919-0.847479969163j)*x_ref[0] + ((-0.287134454938-0.712246261697j))*x_ref[1]
        arg[(0, 2, 3)]=(-0.916472038766+0.897171083775j)*x[0] + ((0.489996014754-0.294072281137j))*x[1]
        ref[(0, 2, 3)]=(-0.916472038766+0.897171083775j)*x_ref[0] + ((0.489996014754-0.294072281137j))*x_ref[1]
        arg[(0, 3, 0)]=(0.579383373893-0.827761487141j)*x[0] + ((0.0758592199662-0.303023594747j))*x[1]
        ref[(0, 3, 0)]=(0.579383373893-0.827761487141j)*x_ref[0] + ((0.0758592199662-0.303023594747j))*x_ref[1]
        arg[(0, 3, 1)]=(0.922742005422-0.411972228647j)*x[0] + ((-0.713746833377-0.275268047204j))*x[1]
        ref[(0, 3, 1)]=(0.922742005422-0.411972228647j)*x_ref[0] + ((-0.713746833377-0.275268047204j))*x_ref[1]
        arg[(0, 3, 2)]=(0.851032696849+0.33473780813j)*x[0] + ((-0.503988818382+0.896527305715j))*x[1]
        ref[(0, 3, 2)]=(0.851032696849+0.33473780813j)*x_ref[0] + ((-0.503988818382+0.896527305715j))*x_ref[1]
        arg[(0, 3, 3)]=(-0.391423427537+0.708292307183j)*x[0] + ((0.831699878804-0.108091159756j))*x[1]
        ref[(0, 3, 3)]=(-0.391423427537+0.708292307183j)*x_ref[0] + ((0.831699878804-0.108091159756j))*x_ref[1]
        arg[(1, 0, 0)]=(0.147449932414-0.901195941338j)*x[0] + ((-0.386608595229-0.583118096871j))*x[1]
        ref[(1, 0, 0)]=(0.147449932414-0.901195941338j)*x_ref[0] + ((-0.386608595229-0.583118096871j))*x_ref[1]
        arg[(1, 0, 1)]=(0.258228223648+0.0238385566345j)*x[0] + ((-0.863859102542+0.759657928052j))*x[1]
        ref[(1, 0, 1)]=(0.258228223648+0.0238385566345j)*x_ref[0] + ((-0.863859102542+0.759657928052j))*x_ref[1]
        arg[(1, 0, 2)]=(-0.774308789833+0.956021169257j)*x[0] + ((-0.00721080667872-0.406043986051j))*x[1]
        ref[(1, 0, 2)]=(-0.774308789833+0.956021169257j)*x_ref[0] + ((-0.00721080667872-0.406043986051j))*x_ref[1]
        arg[(1, 0, 3)]=(0.481214450805-0.0253781088296j)*x[0] + ((-0.152474472057+0.554798214997j))*x[1]
        ref[(1, 0, 3)]=(0.481214450805-0.0253781088296j)*x_ref[0] + ((-0.152474472057+0.554798214997j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.58007971273-0.280212670325j)*x[0] + ((-0.212946750003-0.130922717633j))*x[1]
        ref[(1, 1, 0)]=(-0.58007971273-0.280212670325j)*x_ref[0] + ((-0.212946750003-0.130922717633j))*x_ref[1]
        arg[(1, 1, 1)]=(-0.588258844265+0.166742574279j)*x[0] + ((0.971017736185-0.212961385767j))*x[1]
        ref[(1, 1, 1)]=(-0.588258844265+0.166742574279j)*x_ref[0] + ((0.971017736185-0.212961385767j))*x_ref[1]
        arg[(1, 1, 2)]=(-0.758333797625-0.524994702302j)*x[0] + ((-0.63935805921-0.0838992542059j))*x[1]
        ref[(1, 1, 2)]=(-0.758333797625-0.524994702302j)*x_ref[0] + ((-0.63935805921-0.0838992542059j))*x_ref[1]
        arg[(1, 1, 3)]=(-0.227192044955+0.522752843675j)*x[0] + ((0.943312483626-0.55609698604j))*x[1]
        ref[(1, 1, 3)]=(-0.227192044955+0.522752843675j)*x_ref[0] + ((0.943312483626-0.55609698604j))*x_ref[1]
        arg[(1, 2, 0)]=(-0.273049213193+0.66869599735j)*x[0] + ((-0.726349823583-0.495357140289j))*x[1]
        ref[(1, 2, 0)]=(-0.273049213193+0.66869599735j)*x_ref[0] + ((-0.726349823583-0.495357140289j))*x_ref[1]
        arg[(1, 2, 1)]=(-0.363853776996+0.158406018085j)*x[0] + ((0.854293745986+0.408169940045j))*x[1]
        ref[(1, 2, 1)]=(-0.363853776996+0.158406018085j)*x_ref[0] + ((0.854293745986+0.408169940045j))*x_ref[1]
        arg[(1, 2, 2)]=(-0.958318428077+0.198358634954j)*x[0] + ((0.361712035956-0.975864482014j))*x[1]
        ref[(1, 2, 2)]=(-0.958318428077+0.198358634954j)*x_ref[0] + ((0.361712035956-0.975864482014j))*x_ref[1]
        arg[(1, 2, 3)]=(-0.962838621333-0.0723468307431j)*x[0] + ((-0.0403357050154-0.270970651982j))*x[1]
        ref[(1, 2, 3)]=(-0.962838621333-0.0723468307431j)*x_ref[0] + ((-0.0403357050154-0.270970651982j))*x_ref[1]
        arg[(1, 3, 0)]=(-0.0343278188962+0.496054976855j)*x[0] + ((0.255439835371+0.386568786581j))*x[1]
        ref[(1, 3, 0)]=(-0.0343278188962+0.496054976855j)*x_ref[0] + ((0.255439835371+0.386568786581j))*x_ref[1]
        arg[(1, 3, 1)]=(-0.731579883294+0.857086262509j)*x[0] + ((-0.263221371619+0.872124479733j))*x[1]
        ref[(1, 3, 1)]=(-0.731579883294+0.857086262509j)*x_ref[0] + ((-0.263221371619+0.872124479733j))*x_ref[1]
        arg[(1, 3, 2)]=(-0.974638253181-0.541323661534j)*x[0] + ((0.726193921982-0.961152668279j))*x[1]
        ref[(1, 3, 2)]=(-0.974638253181-0.541323661534j)*x_ref[0] + ((0.726193921982-0.961152668279j))*x_ref[1]
        arg[(1, 3, 3)]=(-0.294818486802-0.590031733029j)*x[0] + ((0.359932983254-0.80768815744j))*x[1]
        ref[(1, 3, 3)]=(-0.294818486802-0.590031733029j)*x_ref[0] + ((0.359932983254-0.80768815744j))*x_ref[1]
        arg[(2, 0, 0)]=(0.287246886578+0.833765637907j)*x[0] + ((0.654080373054-0.792774082085j))*x[1]
        ref[(2, 0, 0)]=(0.287246886578+0.833765637907j)*x_ref[0] + ((0.654080373054-0.792774082085j))*x_ref[1]
        arg[(2, 0, 1)]=(-0.53018142234+0.99442542231j)*x[0] + ((0.412310290314+0.474871595179j))*x[1]
        ref[(2, 0, 1)]=(-0.53018142234+0.99442542231j)*x_ref[0] + ((0.412310290314+0.474871595179j))*x_ref[1]
        arg[(2, 0, 2)]=(-0.688345986974-0.945885654227j)*x[0] + ((-0.576708964986+0.272823142859j))*x[1]
        ref[(2, 0, 2)]=(-0.688345986974-0.945885654227j)*x_ref[0] + ((-0.576708964986+0.272823142859j))*x_ref[1]
        arg[(2, 0, 3)]=(-0.0296138875289-0.212931197359j)*x[0] + ((0.222378789366-0.793672341065j))*x[1]
        ref[(2, 0, 3)]=(-0.0296138875289-0.212931197359j)*x_ref[0] + ((0.222378789366-0.793672341065j))*x_ref[1]
        arg[(2, 1, 0)]=(0.249571755777-0.870663116038j)*x[0] + ((-0.915665926117-0.714694696229j))*x[1]
        ref[(2, 1, 0)]=(0.249571755777-0.870663116038j)*x_ref[0] + ((-0.915665926117-0.714694696229j))*x_ref[1]
        arg[(2, 1, 1)]=(0.93006509708-0.0739008065225j)*x[0] + ((-0.113927183992+0.393879489113j))*x[1]
        ref[(2, 1, 1)]=(0.93006509708-0.0739008065225j)*x_ref[0] + ((-0.113927183992+0.393879489113j))*x_ref[1]
        arg[(2, 1, 2)]=(0.658122805581+0.163321573393j)*x[0] + ((0.63629229977-0.813137697831j))*x[1]
        ref[(2, 1, 2)]=(0.658122805581+0.163321573393j)*x_ref[0] + ((0.63629229977-0.813137697831j))*x_ref[1]
        arg[(2, 1, 3)]=(-0.377746799375-0.354941453645j)*x[0] + ((0.844324255747+0.801013080788j))*x[1]
        ref[(2, 1, 3)]=(-0.377746799375-0.354941453645j)*x_ref[0] + ((0.844324255747+0.801013080788j))*x_ref[1]
        arg[(2, 2, 0)]=(0.391865720899-0.894424336477j)*x[0] + ((0.809209465444+0.203627545669j))*x[1]
        ref[(2, 2, 0)]=(0.391865720899-0.894424336477j)*x_ref[0] + ((0.809209465444+0.203627545669j))*x_ref[1]
        arg[(2, 2, 1)]=(0.916917354581+0.0332834814886j)*x[0] + ((0.799290634819-0.683703452284j))*x[1]
        ref[(2, 2, 1)]=(0.916917354581+0.0332834814886j)*x_ref[0] + ((0.799290634819-0.683703452284j))*x_ref[1]
        arg[(2, 2, 2)]=(-0.441772862702+0.663854034275j)*x[0] + ((-0.0718650410145+0.495244923901j))*x[1]
        ref[(2, 2, 2)]=(-0.441772862702+0.663854034275j)*x_ref[0] + ((-0.0718650410145+0.495244923901j))*x_ref[1]
        arg[(2, 2, 3)]=(-0.692642475529+0.958936991228j)*x[0] + ((-0.0148719672074-0.813841775693j))*x[1]
        ref[(2, 2, 3)]=(-0.692642475529+0.958936991228j)*x_ref[0] + ((-0.0148719672074-0.813841775693j))*x_ref[1]
        arg[(2, 3, 0)]=(0.476246559489-0.292698418632j)*x[0] + ((0.24955083342+0.773629826618j))*x[1]
        ref[(2, 3, 0)]=(0.476246559489-0.292698418632j)*x_ref[0] + ((0.24955083342+0.773629826618j))*x_ref[1]
        arg[(2, 3, 1)]=(0.520658786183-0.0971428559807j)*x[0] + ((-0.319840276291-0.960056689935j))*x[1]
        ref[(2, 3, 1)]=(0.520658786183-0.0971428559807j)*x_ref[0] + ((-0.319840276291-0.960056689935j))*x_ref[1]
        arg[(2, 3, 2)]=(0.332688109833+0.917482767024j)*x[0] + ((0.916771124658-0.160653678233j))*x[1]
        ref[(2, 3, 2)]=(0.332688109833+0.917482767024j)*x_ref[0] + ((0.916771124658-0.160653678233j))*x_ref[1]
        arg[(2, 3, 3)]=(-0.203918032465+0.716192320761j)*x[0] + ((-0.566318689113+0.831005225712j))*x[1]
        ref[(2, 3, 3)]=(-0.203918032465+0.716192320761j)*x_ref[0] + ((-0.566318689113+0.831005225712j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.0441266511011-0.67068627517j)*x[2]
            ref[(0, 0, 0)]+=(-0.0441266511011-0.67068627517j)*x_ref[2]
            arg[(0, 0, 1)]+=(-0.24116664129+0.430753678171j)*x[2]
            ref[(0, 0, 1)]+=(-0.24116664129+0.430753678171j)*x_ref[2]
            arg[(0, 0, 2)]+=(0.795536327659-0.355390546904j)*x[2]
            ref[(0, 0, 2)]+=(0.795536327659-0.355390546904j)*x_ref[2]
            arg[(0, 0, 3)]+=(-0.539204249843+0.310502775595j)*x[2]
            ref[(0, 0, 3)]+=(-0.539204249843+0.310502775595j)*x_ref[2]
            arg[(0, 1, 0)]+=(-0.266550612337+0.802975269246j)*x[2]
            ref[(0, 1, 0)]+=(-0.266550612337+0.802975269246j)*x_ref[2]
            arg[(0, 1, 1)]+=(-0.729463937279+0.308828563577j)*x[2]
            ref[(0, 1, 1)]+=(-0.729463937279+0.308828563577j)*x_ref[2]
            arg[(0, 1, 2)]+=(0.627556473443-0.52737416941j)*x[2]
            ref[(0, 1, 2)]+=(0.627556473443-0.52737416941j)*x_ref[2]
            arg[(0, 1, 3)]+=(0.126944175863-0.168684727444j)*x[2]
            ref[(0, 1, 3)]+=(0.126944175863-0.168684727444j)*x_ref[2]
            arg[(0, 2, 0)]+=(-0.55756669041+0.219196176492j)*x[2]
            ref[(0, 2, 0)]+=(-0.55756669041+0.219196176492j)*x_ref[2]
            arg[(0, 2, 1)]+=(0.263352394666-0.508820360181j)*x[2]
            ref[(0, 2, 1)]+=(0.263352394666-0.508820360181j)*x_ref[2]
            arg[(0, 2, 2)]+=(0.790816604011+0.802141984991j)*x[2]
            ref[(0, 2, 2)]+=(0.790816604011+0.802141984991j)*x_ref[2]
            arg[(0, 2, 3)]+=(-0.133094978652+0.791730582794j)*x[2]
            ref[(0, 2, 3)]+=(-0.133094978652+0.791730582794j)*x_ref[2]
            arg[(0, 3, 0)]+=(-0.402420672842+0.848834439718j)*x[2]
            ref[(0, 3, 0)]+=(-0.402420672842+0.848834439718j)*x_ref[2]
            arg[(0, 3, 1)]+=(-0.196771271952-0.32534978469j)*x[2]
            ref[(0, 3, 1)]+=(-0.196771271952-0.32534978469j)*x_ref[2]
            arg[(0, 3, 2)]+=(0.458194844092+0.360603590802j)*x[2]
            ref[(0, 3, 2)]+=(0.458194844092+0.360603590802j)*x_ref[2]
            arg[(0, 3, 3)]+=(-0.952512062691-0.231292352107j)*x[2]
            ref[(0, 3, 3)]+=(-0.952512062691-0.231292352107j)*x_ref[2]
            arg[(1, 0, 0)]+=(-0.988206481388+0.0998590551517j)*x[2]
            ref[(1, 0, 0)]+=(-0.988206481388+0.0998590551517j)*x_ref[2]
            arg[(1, 0, 1)]+=(0.440962972534+0.775728565917j)*x[2]
            ref[(1, 0, 1)]+=(0.440962972534+0.775728565917j)*x_ref[2]
            arg[(1, 0, 2)]+=(-0.948279343694+0.214486938468j)*x[2]
            ref[(1, 0, 2)]+=(-0.948279343694+0.214486938468j)*x_ref[2]
            arg[(1, 0, 3)]+=(0.5554576098+0.975868297546j)*x[2]
            ref[(1, 0, 3)]+=(0.5554576098+0.975868297546j)*x_ref[2]
            arg[(1, 1, 0)]+=(-0.603692368198+0.0738022272492j)*x[2]
            ref[(1, 1, 0)]+=(-0.603692368198+0.0738022272492j)*x_ref[2]
            arg[(1, 1, 1)]+=(0.314450096685-0.46314742797j)*x[2]
            ref[(1, 1, 1)]+=(0.314450096685-0.46314742797j)*x_ref[2]
            arg[(1, 1, 2)]+=(0.0172145530719-0.988509274921j)*x[2]
            ref[(1, 1, 2)]+=(0.0172145530719-0.988509274921j)*x_ref[2]
            arg[(1, 1, 3)]+=(0.0582303741338-0.715639492127j)*x[2]
            ref[(1, 1, 3)]+=(0.0582303741338-0.715639492127j)*x_ref[2]
            arg[(1, 2, 0)]+=(0.492130991956+0.0946540616289j)*x[2]
            ref[(1, 2, 0)]+=(0.492130991956+0.0946540616289j)*x_ref[2]
            arg[(1, 2, 1)]+=(-0.475534838048-0.286652272266j)*x[2]
            ref[(1, 2, 1)]+=(-0.475534838048-0.286652272266j)*x_ref[2]
            arg[(1, 2, 2)]+=(0.370762807692+0.49928568465j)*x[2]
            ref[(1, 2, 2)]+=(0.370762807692+0.49928568465j)*x_ref[2]
            arg[(1, 2, 3)]+=(0.303400167486-0.132350917206j)*x[2]
            ref[(1, 2, 3)]+=(0.303400167486-0.132350917206j)*x_ref[2]
            arg[(1, 3, 0)]+=(-0.80728208341-0.943308335067j)*x[2]
            ref[(1, 3, 0)]+=(-0.80728208341-0.943308335067j)*x_ref[2]
            arg[(1, 3, 1)]+=(-0.970700752951+0.856558512042j)*x[2]
            ref[(1, 3, 1)]+=(-0.970700752951+0.856558512042j)*x_ref[2]
            arg[(1, 3, 2)]+=(0.301842050427-0.0426587843971j)*x[2]
            ref[(1, 3, 2)]+=(0.301842050427-0.0426587843971j)*x_ref[2]
            arg[(1, 3, 3)]+=(-0.0204599944027-0.854350005741j)*x[2]
            ref[(1, 3, 3)]+=(-0.0204599944027-0.854350005741j)*x_ref[2]
            arg[(2, 0, 0)]+=(-0.189689049255-0.704230041532j)*x[2]
            ref[(2, 0, 0)]+=(-0.189689049255-0.704230041532j)*x_ref[2]
            arg[(2, 0, 1)]+=(-0.534631715052-0.623732056547j)*x[2]
            ref[(2, 0, 1)]+=(-0.534631715052-0.623732056547j)*x_ref[2]
            arg[(2, 0, 2)]+=(-0.843821811722-0.360040662796j)*x[2]
            ref[(2, 0, 2)]+=(-0.843821811722-0.360040662796j)*x_ref[2]
            arg[(2, 0, 3)]+=(-0.100037487391+0.792379396685j)*x[2]
            ref[(2, 0, 3)]+=(-0.100037487391+0.792379396685j)*x_ref[2]
            arg[(2, 1, 0)]+=(0.544479530337+0.672452917315j)*x[2]
            ref[(2, 1, 0)]+=(0.544479530337+0.672452917315j)*x_ref[2]
            arg[(2, 1, 1)]+=(-0.273199135082+0.754830812805j)*x[2]
            ref[(2, 1, 1)]+=(-0.273199135082+0.754830812805j)*x_ref[2]
            arg[(2, 1, 2)]+=(-0.302853242425+0.798270545713j)*x[2]
            ref[(2, 1, 2)]+=(-0.302853242425+0.798270545713j)*x_ref[2]
            arg[(2, 1, 3)]+=(0.152922074402+0.522591328355j)*x[2]
            ref[(2, 1, 3)]+=(0.152922074402+0.522591328355j)*x_ref[2]
            arg[(2, 2, 0)]+=(-0.329341046491-0.976297759342j)*x[2]
            ref[(2, 2, 0)]+=(-0.329341046491-0.976297759342j)*x_ref[2]
            arg[(2, 2, 1)]+=(-0.457808914654-0.982116349196j)*x[2]
            ref[(2, 2, 1)]+=(-0.457808914654-0.982116349196j)*x_ref[2]
            arg[(2, 2, 2)]+=(0.923591727113-0.378123716444j)*x[2]
            ref[(2, 2, 2)]+=(0.923591727113-0.378123716444j)*x_ref[2]
            arg[(2, 2, 3)]+=(0.163399364925-0.46060454295j)*x[2]
            ref[(2, 2, 3)]+=(0.163399364925-0.46060454295j)*x_ref[2]
            arg[(2, 3, 0)]+=(-0.0663410641181-0.354686969363j)*x[2]
            ref[(2, 3, 0)]+=(-0.0663410641181-0.354686969363j)*x_ref[2]
            arg[(2, 3, 1)]+=(0.399462476713-0.637754233315j)*x[2]
            ref[(2, 3, 1)]+=(0.399462476713-0.637754233315j)*x_ref[2]
            arg[(2, 3, 2)]+=(0.601790498313+0.474204832586j)*x[2]
            ref[(2, 3, 2)]+=(0.601790498313+0.474204832586j)*x_ref[2]
            arg[(2, 3, 3)]+=(-0.250838119752-0.670022417138j)*x[2]
            ref[(2, 3, 3)]+=(-0.250838119752-0.670022417138j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3, 4, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedSolution_rank4(self):
        """
        tests interpolation of rank 4 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports interpolation from ReducedSolution to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 3, 2),w)
        ref = Data(0,(2, 2, 3, 2),w_ref)
        arg[(0, 0, 0, 0)]=(-0.195310996678-0.151312294886j)*x[0] + ((0.897006445645-0.629919943588j))*x[1]
        ref[(0, 0, 0, 0)]=(-0.195310996678-0.151312294886j)*x_ref[0] + ((0.897006445645-0.629919943588j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.0719436704666-0.0342862469521j)*x[0] + ((-0.943823509649+0.156847054359j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.0719436704666-0.0342862469521j)*x_ref[0] + ((-0.943823509649+0.156847054359j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(0.473523194395-0.160048730252j)*x[0] + ((-0.762232998017+0.527640905835j))*x[1]
        ref[(0, 0, 1, 0)]=(0.473523194395-0.160048730252j)*x_ref[0] + ((-0.762232998017+0.527640905835j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.383331177392-0.69061791904j)*x[0] + ((0.741736376527-0.249089981423j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.383331177392-0.69061791904j)*x_ref[0] + ((0.741736376527-0.249089981423j))*x_ref[1]
        arg[(0, 0, 2, 0)]=(-0.223114844931+0.304048125018j)*x[0] + ((0.784363724415+0.774350704034j))*x[1]
        ref[(0, 0, 2, 0)]=(-0.223114844931+0.304048125018j)*x_ref[0] + ((0.784363724415+0.774350704034j))*x_ref[1]
        arg[(0, 0, 2, 1)]=(-0.576720296816-0.776657330869j)*x[0] + ((-0.718766553874-0.717496593463j))*x[1]
        ref[(0, 0, 2, 1)]=(-0.576720296816-0.776657330869j)*x_ref[0] + ((-0.718766553874-0.717496593463j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(0.466630067906+0.356977921484j)*x[0] + ((-0.782904934214+0.406340877506j))*x[1]
        ref[(0, 1, 0, 0)]=(0.466630067906+0.356977921484j)*x_ref[0] + ((-0.782904934214+0.406340877506j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(-0.461359321127+0.138220114969j)*x[0] + ((-0.013852792459-0.376869319765j))*x[1]
        ref[(0, 1, 0, 1)]=(-0.461359321127+0.138220114969j)*x_ref[0] + ((-0.013852792459-0.376869319765j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.0625799082294+0.0464945158128j)*x[0] + ((-0.463622899018-0.483456071141j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.0625799082294+0.0464945158128j)*x_ref[0] + ((-0.463622899018-0.483456071141j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(-0.587525138584+0.945814180214j)*x[0] + ((0.291429647694+0.463207968484j))*x[1]
        ref[(0, 1, 1, 1)]=(-0.587525138584+0.945814180214j)*x_ref[0] + ((0.291429647694+0.463207968484j))*x_ref[1]
        arg[(0, 1, 2, 0)]=(-0.143106338987+0.520109111406j)*x[0] + ((-0.970463594093+0.762914888478j))*x[1]
        ref[(0, 1, 2, 0)]=(-0.143106338987+0.520109111406j)*x_ref[0] + ((-0.970463594093+0.762914888478j))*x_ref[1]
        arg[(0, 1, 2, 1)]=(-0.341547900279-0.925948498526j)*x[0] + ((-0.513525007399-0.815494280945j))*x[1]
        ref[(0, 1, 2, 1)]=(-0.341547900279-0.925948498526j)*x_ref[0] + ((-0.513525007399-0.815494280945j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(-0.826055626468+0.929467577986j)*x[0] + ((0.246687737288+0.57057407462j))*x[1]
        ref[(1, 0, 0, 0)]=(-0.826055626468+0.929467577986j)*x_ref[0] + ((0.246687737288+0.57057407462j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.501253431709-0.797274416179j)*x[0] + ((0.739313204754-0.929476466716j))*x[1]
        ref[(1, 0, 0, 1)]=(0.501253431709-0.797274416179j)*x_ref[0] + ((0.739313204754-0.929476466716j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(0.812460292348+0.760725508015j)*x[0] + ((-0.295636049654-0.326357805524j))*x[1]
        ref[(1, 0, 1, 0)]=(0.812460292348+0.760725508015j)*x_ref[0] + ((-0.295636049654-0.326357805524j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(0.559326011032-0.596236577551j)*x[0] + ((0.461390687724+0.73495232348j))*x[1]
        ref[(1, 0, 1, 1)]=(0.559326011032-0.596236577551j)*x_ref[0] + ((0.461390687724+0.73495232348j))*x_ref[1]
        arg[(1, 0, 2, 0)]=(0.959816676813-0.56585333977j)*x[0] + ((0.382886481569+0.711184548778j))*x[1]
        ref[(1, 0, 2, 0)]=(0.959816676813-0.56585333977j)*x_ref[0] + ((0.382886481569+0.711184548778j))*x_ref[1]
        arg[(1, 0, 2, 1)]=(0.78517304736+0.528597683226j)*x[0] + ((0.929966575865+0.978848914366j))*x[1]
        ref[(1, 0, 2, 1)]=(0.78517304736+0.528597683226j)*x_ref[0] + ((0.929966575865+0.978848914366j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(0.845386062226+0.185238375731j)*x[0] + ((-0.330228933501-0.928017858174j))*x[1]
        ref[(1, 1, 0, 0)]=(0.845386062226+0.185238375731j)*x_ref[0] + ((-0.330228933501-0.928017858174j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(0.977787909157+0.03747816188j)*x[0] + ((-0.470623477222+0.716050284114j))*x[1]
        ref[(1, 1, 0, 1)]=(0.977787909157+0.03747816188j)*x_ref[0] + ((-0.470623477222+0.716050284114j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.803070541898-0.323924957494j)*x[0] + ((-0.042765498562+0.0821647982096j))*x[1]
        ref[(1, 1, 1, 0)]=(0.803070541898-0.323924957494j)*x_ref[0] + ((-0.042765498562+0.0821647982096j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(0.41110843076-0.489598985813j)*x[0] + ((0.522011890304+0.722049078554j))*x[1]
        ref[(1, 1, 1, 1)]=(0.41110843076-0.489598985813j)*x_ref[0] + ((0.522011890304+0.722049078554j))*x_ref[1]
        arg[(1, 1, 2, 0)]=(-0.0452256976551-0.0958857393711j)*x[0] + ((-0.219100368541+0.717673964214j))*x[1]
        ref[(1, 1, 2, 0)]=(-0.0452256976551-0.0958857393711j)*x_ref[0] + ((-0.219100368541+0.717673964214j))*x_ref[1]
        arg[(1, 1, 2, 1)]=(-0.133165029569+0.168795274432j)*x[0] + ((0.985778241416-0.208352389993j))*x[1]
        ref[(1, 1, 2, 1)]=(-0.133165029569+0.168795274432j)*x_ref[0] + ((0.985778241416-0.208352389993j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(0.192015655446-0.334634124619j)*x[2]
            ref[(0, 0, 0, 0)]+=(0.192015655446-0.334634124619j)*x_ref[2]
            arg[(0, 0, 0, 1)]+=(-0.164969695663+0.539565048917j)*x[2]
            ref[(0, 0, 0, 1)]+=(-0.164969695663+0.539565048917j)*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.442276351626+0.97919721534j)*x[2]
            ref[(0, 0, 1, 0)]+=(-0.442276351626+0.97919721534j)*x_ref[2]
            arg[(0, 0, 1, 1)]+=(0.217403596737-0.614660815407j)*x[2]
            ref[(0, 0, 1, 1)]+=(0.217403596737-0.614660815407j)*x_ref[2]
            arg[(0, 0, 2, 0)]+=(0.262005663026+0.880751947891j)*x[2]
            ref[(0, 0, 2, 0)]+=(0.262005663026+0.880751947891j)*x_ref[2]
            arg[(0, 0, 2, 1)]+=(-0.23894820938+0.81017231138j)*x[2]
            ref[(0, 0, 2, 1)]+=(-0.23894820938+0.81017231138j)*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.757113942306+0.161561028905j)*x[2]
            ref[(0, 1, 0, 0)]+=(-0.757113942306+0.161561028905j)*x_ref[2]
            arg[(0, 1, 0, 1)]+=(0.0612412983361+0.976666670569j)*x[2]
            ref[(0, 1, 0, 1)]+=(0.0612412983361+0.976666670569j)*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.612086334767-0.553290578591j)*x[2]
            ref[(0, 1, 1, 0)]+=(-0.612086334767-0.553290578591j)*x_ref[2]
            arg[(0, 1, 1, 1)]+=(0.237303721868-0.395907384545j)*x[2]
            ref[(0, 1, 1, 1)]+=(0.237303721868-0.395907384545j)*x_ref[2]
            arg[(0, 1, 2, 0)]+=(0.0575807675738-0.916184435064j)*x[2]
            ref[(0, 1, 2, 0)]+=(0.0575807675738-0.916184435064j)*x_ref[2]
            arg[(0, 1, 2, 1)]+=(0.530522291039+0.925065252377j)*x[2]
            ref[(0, 1, 2, 1)]+=(0.530522291039+0.925065252377j)*x_ref[2]
            arg[(1, 0, 0, 0)]+=(-0.740190577229+0.129239224905j)*x[2]
            ref[(1, 0, 0, 0)]+=(-0.740190577229+0.129239224905j)*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.701596217027+0.879291047148j)*x[2]
            ref[(1, 0, 0, 1)]+=(0.701596217027+0.879291047148j)*x_ref[2]
            arg[(1, 0, 1, 0)]+=(-0.41442054012-0.257576336009j)*x[2]
            ref[(1, 0, 1, 0)]+=(-0.41442054012-0.257576336009j)*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.900302749209+0.918779810764j)*x[2]
            ref[(1, 0, 1, 1)]+=(0.900302749209+0.918779810764j)*x_ref[2]
            arg[(1, 0, 2, 0)]+=(-0.54000046329+0.998220479079j)*x[2]
            ref[(1, 0, 2, 0)]+=(-0.54000046329+0.998220479079j)*x_ref[2]
            arg[(1, 0, 2, 1)]+=(-0.373806607235-0.128837947059j)*x[2]
            ref[(1, 0, 2, 1)]+=(-0.373806607235-0.128837947059j)*x_ref[2]
            arg[(1, 1, 0, 0)]+=(-0.852775624824+0.471829348808j)*x[2]
            ref[(1, 1, 0, 0)]+=(-0.852775624824+0.471829348808j)*x_ref[2]
            arg[(1, 1, 0, 1)]+=(-0.938459914812+0.617950606996j)*x[2]
            ref[(1, 1, 0, 1)]+=(-0.938459914812+0.617950606996j)*x_ref[2]
            arg[(1, 1, 1, 0)]+=(0.174570089758-0.0852807725577j)*x[2]
            ref[(1, 1, 1, 0)]+=(0.174570089758-0.0852807725577j)*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.603589564694-0.473741510776j)*x[2]
            ref[(1, 1, 1, 1)]+=(-0.603589564694-0.473741510776j)*x_ref[2]
            arg[(1, 1, 2, 0)]+=(-0.128233330561+0.395059068231j)*x[2]
            ref[(1, 1, 2, 0)]+=(-0.128233330561+0.395059068231j)*x_ref[2]
            arg[(1, 1, 2, 1)]+=(-0.255876321512+0.644601425588j)*x[2]
            ref[(1, 1, 2, 1)]+=(-0.255876321512+0.644601425588j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2, 3, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests interpolation of rank 0 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(0.453237802057+0.0495428370345j)*x[0] + ((-0.149648569235-0.871478461315j))*x[1]
        ref=(0.453237802057+0.0495428370345j)*x_ref[0] + ((-0.149648569235-0.871478461315j))*x_ref[1]
        if dim==3:
            arg+=((-0.632745813471+0.448784476028j))*x[2]
            ref+=((-0.632745813471+0.448784476028j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests interpolation of rank 1 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,),w_ref)
        arg[(0,)]=(-0.707188711253-0.265701292917j)*x[0] + ((0.743624179223+0.0460964903483j))*x[1]
        ref[(0,)]=(-0.707188711253-0.265701292917j)*x_ref[0] + ((0.743624179223+0.0460964903483j))*x_ref[1]
        arg[(1,)]=(-0.729698710766+0.438352147154j)*x[0] + ((-0.0972213739885+0.313042222293j))*x[1]
        ref[(1,)]=(-0.729698710766+0.438352147154j)*x_ref[0] + ((-0.0972213739885+0.313042222293j))*x_ref[1]
        arg[(2,)]=(-0.949391639257-0.831409289648j)*x[0] + ((0.855758045591-0.613986207377j))*x[1]
        ref[(2,)]=(-0.949391639257-0.831409289648j)*x_ref[0] + ((0.855758045591-0.613986207377j))*x_ref[1]
        arg[(3,)]=(0.3313078969-0.815483228424j)*x[0] + ((0.689509252082+0.00558994941987j))*x[1]
        ref[(3,)]=(0.3313078969-0.815483228424j)*x_ref[0] + ((0.689509252082+0.00558994941987j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(0.198334628459-0.664433865188j)*x[2]
            ref[(0,)]+=(0.198334628459-0.664433865188j)*x_ref[2]
            arg[(1,)]+=(0.0460478854808-0.740887330866j)*x[2]
            ref[(1,)]+=(0.0460478854808-0.740887330866j)*x_ref[2]
            arg[(2,)]+=(-0.188331735836-0.0248168127729j)*x[2]
            ref[(2,)]+=(-0.188331735836-0.0248168127729j)*x_ref[2]
            arg[(3,)]+=(-0.957143998804-0.974260641204j)*x[2]
            ref[(3,)]+=(-0.957143998804-0.974260641204j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests interpolation of rank 2 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2),w_ref)
        arg[(0, 0)]=(-0.400087854119+0.428824074356j)*x[0] + ((-0.659651946695-0.347777419927j))*x[1]
        ref[(0, 0)]=(-0.400087854119+0.428824074356j)*x_ref[0] + ((-0.659651946695-0.347777419927j))*x_ref[1]
        arg[(0, 1)]=(-0.478915423099-0.859242116728j)*x[0] + ((-0.103939198868+0.780393790479j))*x[1]
        ref[(0, 1)]=(-0.478915423099-0.859242116728j)*x_ref[0] + ((-0.103939198868+0.780393790479j))*x_ref[1]
        arg[(1, 0)]=(0.344237277367+0.684348188387j)*x[0] + ((-0.510527659104-0.284669174296j))*x[1]
        ref[(1, 0)]=(0.344237277367+0.684348188387j)*x_ref[0] + ((-0.510527659104-0.284669174296j))*x_ref[1]
        arg[(1, 1)]=(-0.748808168948-0.171619397931j)*x[0] + ((-0.561150521925-0.115832807805j))*x[1]
        ref[(1, 1)]=(-0.748808168948-0.171619397931j)*x_ref[0] + ((-0.561150521925-0.115832807805j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(0.719132012836-0.855306180539j)*x[2]
            ref[(0, 0)]+=(0.719132012836-0.855306180539j)*x_ref[2]
            arg[(0, 1)]+=(0.563066838592+0.740234337337j)*x[2]
            ref[(0, 1)]+=(0.563066838592+0.740234337337j)*x_ref[2]
            arg[(1, 0)]+=(-0.0164663732209+0.400861360906j)*x[2]
            ref[(1, 0)]+=(-0.0164663732209+0.400861360906j)*x_ref[2]
            arg[(1, 1)]+=(0.89995085266-0.589729937869j)*x[2]
            ref[(1, 1)]+=(0.89995085266-0.589729937869j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests interpolation of rank 3 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3, 4),w)
        ref = Data(0,(3, 3, 4),w_ref)
        arg[(0, 0, 0)]=(-0.496783880056-0.731110923177j)*x[0] + ((-0.548083894273-0.503614927877j))*x[1]
        ref[(0, 0, 0)]=(-0.496783880056-0.731110923177j)*x_ref[0] + ((-0.548083894273-0.503614927877j))*x_ref[1]
        arg[(0, 0, 1)]=(-0.317797091897-0.110547930594j)*x[0] + ((-0.908238187924+0.335846697578j))*x[1]
        ref[(0, 0, 1)]=(-0.317797091897-0.110547930594j)*x_ref[0] + ((-0.908238187924+0.335846697578j))*x_ref[1]
        arg[(0, 0, 2)]=(0.111671580169-0.899491944464j)*x[0] + ((-0.99069999717-0.807033862641j))*x[1]
        ref[(0, 0, 2)]=(0.111671580169-0.899491944464j)*x_ref[0] + ((-0.99069999717-0.807033862641j))*x_ref[1]
        arg[(0, 0, 3)]=(0.459236850084+0.152474527166j)*x[0] + ((0.573423829402-0.517809492174j))*x[1]
        ref[(0, 0, 3)]=(0.459236850084+0.152474527166j)*x_ref[0] + ((0.573423829402-0.517809492174j))*x_ref[1]
        arg[(0, 1, 0)]=(-0.403468427753+0.769289267781j)*x[0] + ((-0.574572572673+0.257495793974j))*x[1]
        ref[(0, 1, 0)]=(-0.403468427753+0.769289267781j)*x_ref[0] + ((-0.574572572673+0.257495793974j))*x_ref[1]
        arg[(0, 1, 1)]=(0.628375752508+0.492040095315j)*x[0] + ((-0.409855139174+0.942020068146j))*x[1]
        ref[(0, 1, 1)]=(0.628375752508+0.492040095315j)*x_ref[0] + ((-0.409855139174+0.942020068146j))*x_ref[1]
        arg[(0, 1, 2)]=(0.0935017773455-0.698889576835j)*x[0] + ((-0.203969736084+0.512364535888j))*x[1]
        ref[(0, 1, 2)]=(0.0935017773455-0.698889576835j)*x_ref[0] + ((-0.203969736084+0.512364535888j))*x_ref[1]
        arg[(0, 1, 3)]=(-0.249213095442-0.274480511609j)*x[0] + ((-0.501220638035+0.898551995584j))*x[1]
        ref[(0, 1, 3)]=(-0.249213095442-0.274480511609j)*x_ref[0] + ((-0.501220638035+0.898551995584j))*x_ref[1]
        arg[(0, 2, 0)]=(-0.0457136933687+0.490473627032j)*x[0] + ((0.691759561728+0.650207164728j))*x[1]
        ref[(0, 2, 0)]=(-0.0457136933687+0.490473627032j)*x_ref[0] + ((0.691759561728+0.650207164728j))*x_ref[1]
        arg[(0, 2, 1)]=(-0.585955439865+0.954260062834j)*x[0] + ((0.750263572473-0.358772302815j))*x[1]
        ref[(0, 2, 1)]=(-0.585955439865+0.954260062834j)*x_ref[0] + ((0.750263572473-0.358772302815j))*x_ref[1]
        arg[(0, 2, 2)]=(-0.726058400868+0.161638573213j)*x[0] + ((-0.817989398345+0.178021253496j))*x[1]
        ref[(0, 2, 2)]=(-0.726058400868+0.161638573213j)*x_ref[0] + ((-0.817989398345+0.178021253496j))*x_ref[1]
        arg[(0, 2, 3)]=(0.945108586778-0.160193967942j)*x[0] + ((-0.675764345176+0.366543833974j))*x[1]
        ref[(0, 2, 3)]=(0.945108586778-0.160193967942j)*x_ref[0] + ((-0.675764345176+0.366543833974j))*x_ref[1]
        arg[(1, 0, 0)]=(-0.954316515733+0.0514245976377j)*x[0] + ((-0.449703530164+0.316963991604j))*x[1]
        ref[(1, 0, 0)]=(-0.954316515733+0.0514245976377j)*x_ref[0] + ((-0.449703530164+0.316963991604j))*x_ref[1]
        arg[(1, 0, 1)]=(-0.553048673742-0.784651190034j)*x[0] + ((0.801539627838+0.331547857347j))*x[1]
        ref[(1, 0, 1)]=(-0.553048673742-0.784651190034j)*x_ref[0] + ((0.801539627838+0.331547857347j))*x_ref[1]
        arg[(1, 0, 2)]=(-0.853353988991-0.183462198705j)*x[0] + ((0.713377714733-0.537244353237j))*x[1]
        ref[(1, 0, 2)]=(-0.853353988991-0.183462198705j)*x_ref[0] + ((0.713377714733-0.537244353237j))*x_ref[1]
        arg[(1, 0, 3)]=(0.632167492128-0.705419111544j)*x[0] + ((-0.755725687867+0.969112362456j))*x[1]
        ref[(1, 0, 3)]=(0.632167492128-0.705419111544j)*x_ref[0] + ((-0.755725687867+0.969112362456j))*x_ref[1]
        arg[(1, 1, 0)]=(0.53349357888+0.410302135813j)*x[0] + ((0.321546200317+0.974583846018j))*x[1]
        ref[(1, 1, 0)]=(0.53349357888+0.410302135813j)*x_ref[0] + ((0.321546200317+0.974583846018j))*x_ref[1]
        arg[(1, 1, 1)]=(-0.736071352248-0.677909059035j)*x[0] + ((0.313535614987+0.319032020404j))*x[1]
        ref[(1, 1, 1)]=(-0.736071352248-0.677909059035j)*x_ref[0] + ((0.313535614987+0.319032020404j))*x_ref[1]
        arg[(1, 1, 2)]=(-0.889329896036+0.804290286904j)*x[0] + ((-0.996707329524+0.768035574032j))*x[1]
        ref[(1, 1, 2)]=(-0.889329896036+0.804290286904j)*x_ref[0] + ((-0.996707329524+0.768035574032j))*x_ref[1]
        arg[(1, 1, 3)]=(-0.681799051201-0.399532391457j)*x[0] + ((-0.459206399668+0.74940405327j))*x[1]
        ref[(1, 1, 3)]=(-0.681799051201-0.399532391457j)*x_ref[0] + ((-0.459206399668+0.74940405327j))*x_ref[1]
        arg[(1, 2, 0)]=(-0.210522604397-0.182170213801j)*x[0] + ((-0.599255993582+0.473335875323j))*x[1]
        ref[(1, 2, 0)]=(-0.210522604397-0.182170213801j)*x_ref[0] + ((-0.599255993582+0.473335875323j))*x_ref[1]
        arg[(1, 2, 1)]=(0.564930213545+0.835282165106j)*x[0] + ((0.302293832777+0.242518809922j))*x[1]
        ref[(1, 2, 1)]=(0.564930213545+0.835282165106j)*x_ref[0] + ((0.302293832777+0.242518809922j))*x_ref[1]
        arg[(1, 2, 2)]=(0.706049399528-0.524639317438j)*x[0] + ((-0.404809619536-0.603660566735j))*x[1]
        ref[(1, 2, 2)]=(0.706049399528-0.524639317438j)*x_ref[0] + ((-0.404809619536-0.603660566735j))*x_ref[1]
        arg[(1, 2, 3)]=(-0.737474740975+0.692115433407j)*x[0] + ((-0.0250631663978-0.831026889681j))*x[1]
        ref[(1, 2, 3)]=(-0.737474740975+0.692115433407j)*x_ref[0] + ((-0.0250631663978-0.831026889681j))*x_ref[1]
        arg[(2, 0, 0)]=(0.246190728156-0.0258075551096j)*x[0] + ((-0.395393940455-0.0047113958945j))*x[1]
        ref[(2, 0, 0)]=(0.246190728156-0.0258075551096j)*x_ref[0] + ((-0.395393940455-0.0047113958945j))*x_ref[1]
        arg[(2, 0, 1)]=(-0.493738054992-0.892096727494j)*x[0] + ((0.970898514872+0.709780925996j))*x[1]
        ref[(2, 0, 1)]=(-0.493738054992-0.892096727494j)*x_ref[0] + ((0.970898514872+0.709780925996j))*x_ref[1]
        arg[(2, 0, 2)]=(-0.21476511421-0.756680040784j)*x[0] + ((0.779516849053+0.193464464844j))*x[1]
        ref[(2, 0, 2)]=(-0.21476511421-0.756680040784j)*x_ref[0] + ((0.779516849053+0.193464464844j))*x_ref[1]
        arg[(2, 0, 3)]=(-0.74824781229-0.727589996217j)*x[0] + ((-0.610068793995+0.362949363323j))*x[1]
        ref[(2, 0, 3)]=(-0.74824781229-0.727589996217j)*x_ref[0] + ((-0.610068793995+0.362949363323j))*x_ref[1]
        arg[(2, 1, 0)]=(-0.166995476182+0.269518089384j)*x[0] + ((-0.730126254544+0.425618908894j))*x[1]
        ref[(2, 1, 0)]=(-0.166995476182+0.269518089384j)*x_ref[0] + ((-0.730126254544+0.425618908894j))*x_ref[1]
        arg[(2, 1, 1)]=(-0.252343617765-0.817938420978j)*x[0] + ((0.370335454139-0.66874765844j))*x[1]
        ref[(2, 1, 1)]=(-0.252343617765-0.817938420978j)*x_ref[0] + ((0.370335454139-0.66874765844j))*x_ref[1]
        arg[(2, 1, 2)]=(0.784580893563+0.0689217059091j)*x[0] + ((0.359971526227-0.797499001745j))*x[1]
        ref[(2, 1, 2)]=(0.784580893563+0.0689217059091j)*x_ref[0] + ((0.359971526227-0.797499001745j))*x_ref[1]
        arg[(2, 1, 3)]=(-0.950232789998+0.369349786086j)*x[0] + ((-0.206367542107+0.920227972932j))*x[1]
        ref[(2, 1, 3)]=(-0.950232789998+0.369349786086j)*x_ref[0] + ((-0.206367542107+0.920227972932j))*x_ref[1]
        arg[(2, 2, 0)]=(0.276517561357-0.318768534126j)*x[0] + ((0.981686135858-0.29733611842j))*x[1]
        ref[(2, 2, 0)]=(0.276517561357-0.318768534126j)*x_ref[0] + ((0.981686135858-0.29733611842j))*x_ref[1]
        arg[(2, 2, 1)]=(0.324978320689-0.402614805811j)*x[0] + ((-0.511153868896+0.430376188391j))*x[1]
        ref[(2, 2, 1)]=(0.324978320689-0.402614805811j)*x_ref[0] + ((-0.511153868896+0.430376188391j))*x_ref[1]
        arg[(2, 2, 2)]=(0.0726012628997+0.369435966454j)*x[0] + ((-0.867692111055+0.293889074817j))*x[1]
        ref[(2, 2, 2)]=(0.0726012628997+0.369435966454j)*x_ref[0] + ((-0.867692111055+0.293889074817j))*x_ref[1]
        arg[(2, 2, 3)]=(0.547336733798-0.162418058042j)*x[0] + ((0.592723715147+0.734663078683j))*x[1]
        ref[(2, 2, 3)]=(0.547336733798-0.162418058042j)*x_ref[0] + ((0.592723715147+0.734663078683j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(-0.759563306973+0.544212871263j)*x[2]
            ref[(0, 0, 0)]+=(-0.759563306973+0.544212871263j)*x_ref[2]
            arg[(0, 0, 1)]+=(0.827989666195-0.795950363474j)*x[2]
            ref[(0, 0, 1)]+=(0.827989666195-0.795950363474j)*x_ref[2]
            arg[(0, 0, 2)]+=(-0.502632313855+0.00773467009413j)*x[2]
            ref[(0, 0, 2)]+=(-0.502632313855+0.00773467009413j)*x_ref[2]
            arg[(0, 0, 3)]+=(-0.292041332006+0.385545489063j)*x[2]
            ref[(0, 0, 3)]+=(-0.292041332006+0.385545489063j)*x_ref[2]
            arg[(0, 1, 0)]+=(0.390445359594-0.263502064442j)*x[2]
            ref[(0, 1, 0)]+=(0.390445359594-0.263502064442j)*x_ref[2]
            arg[(0, 1, 1)]+=(-0.655540707536+0.231254051852j)*x[2]
            ref[(0, 1, 1)]+=(-0.655540707536+0.231254051852j)*x_ref[2]
            arg[(0, 1, 2)]+=(0.815094971227+0.430873233823j)*x[2]
            ref[(0, 1, 2)]+=(0.815094971227+0.430873233823j)*x_ref[2]
            arg[(0, 1, 3)]+=(-0.427908889017+0.0175316207874j)*x[2]
            ref[(0, 1, 3)]+=(-0.427908889017+0.0175316207874j)*x_ref[2]
            arg[(0, 2, 0)]+=(-0.80165280133+0.262756458426j)*x[2]
            ref[(0, 2, 0)]+=(-0.80165280133+0.262756458426j)*x_ref[2]
            arg[(0, 2, 1)]+=(0.879730463436-0.646303347298j)*x[2]
            ref[(0, 2, 1)]+=(0.879730463436-0.646303347298j)*x_ref[2]
            arg[(0, 2, 2)]+=(0.616679070107+0.512601795726j)*x[2]
            ref[(0, 2, 2)]+=(0.616679070107+0.512601795726j)*x_ref[2]
            arg[(0, 2, 3)]+=(-0.993811967068-0.386787435483j)*x[2]
            ref[(0, 2, 3)]+=(-0.993811967068-0.386787435483j)*x_ref[2]
            arg[(1, 0, 0)]+=(0.918886803823-0.225279048382j)*x[2]
            ref[(1, 0, 0)]+=(0.918886803823-0.225279048382j)*x_ref[2]
            arg[(1, 0, 1)]+=(-0.31346115806+0.699606587282j)*x[2]
            ref[(1, 0, 1)]+=(-0.31346115806+0.699606587282j)*x_ref[2]
            arg[(1, 0, 2)]+=(-0.587105736654-0.346954465843j)*x[2]
            ref[(1, 0, 2)]+=(-0.587105736654-0.346954465843j)*x_ref[2]
            arg[(1, 0, 3)]+=(-0.322343241796+0.532319887045j)*x[2]
            ref[(1, 0, 3)]+=(-0.322343241796+0.532319887045j)*x_ref[2]
            arg[(1, 1, 0)]+=(0.0166637589902-0.77126692011j)*x[2]
            ref[(1, 1, 0)]+=(0.0166637589902-0.77126692011j)*x_ref[2]
            arg[(1, 1, 1)]+=(-0.70906005922-0.648163774032j)*x[2]
            ref[(1, 1, 1)]+=(-0.70906005922-0.648163774032j)*x_ref[2]
            arg[(1, 1, 2)]+=(0.80707263714+0.871060621606j)*x[2]
            ref[(1, 1, 2)]+=(0.80707263714+0.871060621606j)*x_ref[2]
            arg[(1, 1, 3)]+=(0.739062483095+0.415235795786j)*x[2]
            ref[(1, 1, 3)]+=(0.739062483095+0.415235795786j)*x_ref[2]
            arg[(1, 2, 0)]+=(-0.122267368678+0.0803617115429j)*x[2]
            ref[(1, 2, 0)]+=(-0.122267368678+0.0803617115429j)*x_ref[2]
            arg[(1, 2, 1)]+=(-0.228682188018-0.786401941415j)*x[2]
            ref[(1, 2, 1)]+=(-0.228682188018-0.786401941415j)*x_ref[2]
            arg[(1, 2, 2)]+=(0.296205603152+0.0380514849227j)*x[2]
            ref[(1, 2, 2)]+=(0.296205603152+0.0380514849227j)*x_ref[2]
            arg[(1, 2, 3)]+=(-0.291107348897-0.738936407009j)*x[2]
            ref[(1, 2, 3)]+=(-0.291107348897-0.738936407009j)*x_ref[2]
            arg[(2, 0, 0)]+=(-0.354747539112-0.231241469053j)*x[2]
            ref[(2, 0, 0)]+=(-0.354747539112-0.231241469053j)*x_ref[2]
            arg[(2, 0, 1)]+=(0.731659118851-0.414610140228j)*x[2]
            ref[(2, 0, 1)]+=(0.731659118851-0.414610140228j)*x_ref[2]
            arg[(2, 0, 2)]+=(-0.870643539408-0.6781498581j)*x[2]
            ref[(2, 0, 2)]+=(-0.870643539408-0.6781498581j)*x_ref[2]
            arg[(2, 0, 3)]+=(0.727767491561+0.199033255258j)*x[2]
            ref[(2, 0, 3)]+=(0.727767491561+0.199033255258j)*x_ref[2]
            arg[(2, 1, 0)]+=(0.147824821519-0.386351336011j)*x[2]
            ref[(2, 1, 0)]+=(0.147824821519-0.386351336011j)*x_ref[2]
            arg[(2, 1, 1)]+=(0.833602976748-0.429265568771j)*x[2]
            ref[(2, 1, 1)]+=(0.833602976748-0.429265568771j)*x_ref[2]
            arg[(2, 1, 2)]+=(-0.671259581338+0.506576842481j)*x[2]
            ref[(2, 1, 2)]+=(-0.671259581338+0.506576842481j)*x_ref[2]
            arg[(2, 1, 3)]+=(-0.0502957208924+0.948508134767j)*x[2]
            ref[(2, 1, 3)]+=(-0.0502957208924+0.948508134767j)*x_ref[2]
            arg[(2, 2, 0)]+=(-0.197911620799+0.858212443084j)*x[2]
            ref[(2, 2, 0)]+=(-0.197911620799+0.858212443084j)*x_ref[2]
            arg[(2, 2, 1)]+=(0.0577126950944-0.028222483296j)*x[2]
            ref[(2, 2, 1)]+=(0.0577126950944-0.028222483296j)*x_ref[2]
            arg[(2, 2, 2)]+=(-0.880746649032-0.190227693109j)*x[2]
            ref[(2, 2, 2)]+=(-0.880746649032-0.190227693109j)*x_ref[2]
            arg[(2, 2, 3)]+=(0.770734244653-0.641087282609j)*x[2]
            ref[(2, 2, 3)]+=(0.770734244653-0.641087282609j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (3, 3, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank4(self):
        """
        tests interpolation of rank 4 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports interpolation from ReducedContinuousFunction to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4, 2, 2),w)
        ref = Data(0,(2, 4, 2, 2),w_ref)
        arg[(0, 0, 0, 0)]=(0.254938625975-0.750108738674j)*x[0] + ((0.9795068829+0.170212222208j))*x[1]
        ref[(0, 0, 0, 0)]=(0.254938625975-0.750108738674j)*x_ref[0] + ((0.9795068829+0.170212222208j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.589527202396-0.281887511167j)*x[0] + ((-0.381535286593+0.841955461542j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.589527202396-0.281887511167j)*x_ref[0] + ((-0.381535286593+0.841955461542j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(0.23869745458+0.535385236554j)*x[0] + ((-0.317579036443-0.114456142113j))*x[1]
        ref[(0, 0, 1, 0)]=(0.23869745458+0.535385236554j)*x_ref[0] + ((-0.317579036443-0.114456142113j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(-0.148164777467-0.350948666764j)*x[0] + ((-0.261701997046-0.504439625479j))*x[1]
        ref[(0, 0, 1, 1)]=(-0.148164777467-0.350948666764j)*x_ref[0] + ((-0.261701997046-0.504439625479j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(-0.898104832716+0.0475920664056j)*x[0] + ((-0.105609309168-0.700297536166j))*x[1]
        ref[(0, 1, 0, 0)]=(-0.898104832716+0.0475920664056j)*x_ref[0] + ((-0.105609309168-0.700297536166j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(-0.0568611868973-0.78672033292j)*x[0] + ((0.2948578872-0.168525415997j))*x[1]
        ref[(0, 1, 0, 1)]=(-0.0568611868973-0.78672033292j)*x_ref[0] + ((0.2948578872-0.168525415997j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(-0.14668799596+0.49022399426j)*x[0] + ((0.921575136862-0.0136692299811j))*x[1]
        ref[(0, 1, 1, 0)]=(-0.14668799596+0.49022399426j)*x_ref[0] + ((0.921575136862-0.0136692299811j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(-0.417182294264-0.128883768255j)*x[0] + ((-0.0618785496068+0.0193098489501j))*x[1]
        ref[(0, 1, 1, 1)]=(-0.417182294264-0.128883768255j)*x_ref[0] + ((-0.0618785496068+0.0193098489501j))*x_ref[1]
        arg[(0, 2, 0, 0)]=(0.0241522681524+0.112350424275j)*x[0] + ((-0.382880194747+0.308128779215j))*x[1]
        ref[(0, 2, 0, 0)]=(0.0241522681524+0.112350424275j)*x_ref[0] + ((-0.382880194747+0.308128779215j))*x_ref[1]
        arg[(0, 2, 0, 1)]=(0.115138780236-0.715013109513j)*x[0] + ((0.230132218563+0.893341512267j))*x[1]
        ref[(0, 2, 0, 1)]=(0.115138780236-0.715013109513j)*x_ref[0] + ((0.230132218563+0.893341512267j))*x_ref[1]
        arg[(0, 2, 1, 0)]=(-0.299944122443+0.701815715203j)*x[0] + ((-0.818307724124+0.0960362427325j))*x[1]
        ref[(0, 2, 1, 0)]=(-0.299944122443+0.701815715203j)*x_ref[0] + ((-0.818307724124+0.0960362427325j))*x_ref[1]
        arg[(0, 2, 1, 1)]=(-0.842706330523-0.429394074305j)*x[0] + ((-0.98928112798-0.246867016j))*x[1]
        ref[(0, 2, 1, 1)]=(-0.842706330523-0.429394074305j)*x_ref[0] + ((-0.98928112798-0.246867016j))*x_ref[1]
        arg[(0, 3, 0, 0)]=(-0.105494518838+0.849007009288j)*x[0] + ((-0.578528446191+0.698991837825j))*x[1]
        ref[(0, 3, 0, 0)]=(-0.105494518838+0.849007009288j)*x_ref[0] + ((-0.578528446191+0.698991837825j))*x_ref[1]
        arg[(0, 3, 0, 1)]=(0.356424680024+0.246118721365j)*x[0] + ((-0.35535611253-0.575107426319j))*x[1]
        ref[(0, 3, 0, 1)]=(0.356424680024+0.246118721365j)*x_ref[0] + ((-0.35535611253-0.575107426319j))*x_ref[1]
        arg[(0, 3, 1, 0)]=(-0.913384464353+0.944725594079j)*x[0] + ((-0.974713775288+0.345234878172j))*x[1]
        ref[(0, 3, 1, 0)]=(-0.913384464353+0.944725594079j)*x_ref[0] + ((-0.974713775288+0.345234878172j))*x_ref[1]
        arg[(0, 3, 1, 1)]=(0.728358519746+0.870732666567j)*x[0] + ((0.961164610739+0.581348224686j))*x[1]
        ref[(0, 3, 1, 1)]=(0.728358519746+0.870732666567j)*x_ref[0] + ((0.961164610739+0.581348224686j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.642721471139+0.965474797101j)*x[0] + ((-0.485711477349+0.201992687474j))*x[1]
        ref[(1, 0, 0, 0)]=(0.642721471139+0.965474797101j)*x_ref[0] + ((-0.485711477349+0.201992687474j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(0.975768397435-0.0244275201027j)*x[0] + ((0.184120712292+0.300369461319j))*x[1]
        ref[(1, 0, 0, 1)]=(0.975768397435-0.0244275201027j)*x_ref[0] + ((0.184120712292+0.300369461319j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.0756504675704+0.470505329689j)*x[0] + ((-0.795651246759+0.466457054446j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.0756504675704+0.470505329689j)*x_ref[0] + ((-0.795651246759+0.466457054446j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(-0.209224665295-0.262748768139j)*x[0] + ((-0.238796150597-0.222305248506j))*x[1]
        ref[(1, 0, 1, 1)]=(-0.209224665295-0.262748768139j)*x_ref[0] + ((-0.238796150597-0.222305248506j))*x_ref[1]
        arg[(1, 1, 0, 0)]=(0.541767578754+0.232135861856j)*x[0] + ((-0.419400395955+0.797278053305j))*x[1]
        ref[(1, 1, 0, 0)]=(0.541767578754+0.232135861856j)*x_ref[0] + ((-0.419400395955+0.797278053305j))*x_ref[1]
        arg[(1, 1, 0, 1)]=(-0.206125749948+0.477899082304j)*x[0] + ((-0.108538776189+0.970079034851j))*x[1]
        ref[(1, 1, 0, 1)]=(-0.206125749948+0.477899082304j)*x_ref[0] + ((-0.108538776189+0.970079034851j))*x_ref[1]
        arg[(1, 1, 1, 0)]=(0.0865485921308-0.813972196279j)*x[0] + ((-0.47966356149+0.642111522674j))*x[1]
        ref[(1, 1, 1, 0)]=(0.0865485921308-0.813972196279j)*x_ref[0] + ((-0.47966356149+0.642111522674j))*x_ref[1]
        arg[(1, 1, 1, 1)]=(-0.321842232639+0.758204747755j)*x[0] + ((-0.468932867203+0.656069115608j))*x[1]
        ref[(1, 1, 1, 1)]=(-0.321842232639+0.758204747755j)*x_ref[0] + ((-0.468932867203+0.656069115608j))*x_ref[1]
        arg[(1, 2, 0, 0)]=(0.284971949969+0.0481135418398j)*x[0] + ((-0.0487798642777+0.25294019997j))*x[1]
        ref[(1, 2, 0, 0)]=(0.284971949969+0.0481135418398j)*x_ref[0] + ((-0.0487798642777+0.25294019997j))*x_ref[1]
        arg[(1, 2, 0, 1)]=(-0.843657746205-0.47960424643j)*x[0] + ((-0.693624103633+0.321053333196j))*x[1]
        ref[(1, 2, 0, 1)]=(-0.843657746205-0.47960424643j)*x_ref[0] + ((-0.693624103633+0.321053333196j))*x_ref[1]
        arg[(1, 2, 1, 0)]=(-0.701483238619+0.0354087304193j)*x[0] + ((0.940980130807+0.454058856624j))*x[1]
        ref[(1, 2, 1, 0)]=(-0.701483238619+0.0354087304193j)*x_ref[0] + ((0.940980130807+0.454058856624j))*x_ref[1]
        arg[(1, 2, 1, 1)]=(0.982304635057+0.880900983434j)*x[0] + ((0.585673222632+0.0524405421206j))*x[1]
        ref[(1, 2, 1, 1)]=(0.982304635057+0.880900983434j)*x_ref[0] + ((0.585673222632+0.0524405421206j))*x_ref[1]
        arg[(1, 3, 0, 0)]=(-0.0535438828716+0.93575208527j)*x[0] + ((-0.7230105588-0.902577177639j))*x[1]
        ref[(1, 3, 0, 0)]=(-0.0535438828716+0.93575208527j)*x_ref[0] + ((-0.7230105588-0.902577177639j))*x_ref[1]
        arg[(1, 3, 0, 1)]=(0.656016260432+0.371197022592j)*x[0] + ((0.509875872665-0.39627158072j))*x[1]
        ref[(1, 3, 0, 1)]=(0.656016260432+0.371197022592j)*x_ref[0] + ((0.509875872665-0.39627158072j))*x_ref[1]
        arg[(1, 3, 1, 0)]=(-0.722890460009-0.919116527928j)*x[0] + ((-0.997883506206-0.399200595309j))*x[1]
        ref[(1, 3, 1, 0)]=(-0.722890460009-0.919116527928j)*x_ref[0] + ((-0.997883506206-0.399200595309j))*x_ref[1]
        arg[(1, 3, 1, 1)]=(0.917156148469-0.279245499457j)*x[0] + ((-0.263140116055-0.650049203683j))*x[1]
        ref[(1, 3, 1, 1)]=(0.917156148469-0.279245499457j)*x_ref[0] + ((-0.263140116055-0.650049203683j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0, 0)]+=(0.162945569303+0.184586019098j)*x[2]
            ref[(0, 0, 0, 0)]+=(0.162945569303+0.184586019098j)*x_ref[2]
            arg[(0, 0, 0, 1)]+=(0.441522817839-0.921055314031j)*x[2]
            ref[(0, 0, 0, 1)]+=(0.441522817839-0.921055314031j)*x_ref[2]
            arg[(0, 0, 1, 0)]+=(-0.848912331901-0.721789007952j)*x[2]
            ref[(0, 0, 1, 0)]+=(-0.848912331901-0.721789007952j)*x_ref[2]
            arg[(0, 0, 1, 1)]+=(0.448042061892-0.931249360022j)*x[2]
            ref[(0, 0, 1, 1)]+=(0.448042061892-0.931249360022j)*x_ref[2]
            arg[(0, 1, 0, 0)]+=(-0.0183334774856-0.799467345043j)*x[2]
            ref[(0, 1, 0, 0)]+=(-0.0183334774856-0.799467345043j)*x_ref[2]
            arg[(0, 1, 0, 1)]+=(0.250132563666-0.440418031708j)*x[2]
            ref[(0, 1, 0, 1)]+=(0.250132563666-0.440418031708j)*x_ref[2]
            arg[(0, 1, 1, 0)]+=(-0.0279232999094+0.799011740309j)*x[2]
            ref[(0, 1, 1, 0)]+=(-0.0279232999094+0.799011740309j)*x_ref[2]
            arg[(0, 1, 1, 1)]+=(0.794916649805-0.41223023969j)*x[2]
            ref[(0, 1, 1, 1)]+=(0.794916649805-0.41223023969j)*x_ref[2]
            arg[(0, 2, 0, 0)]+=(-0.638886121262-0.835534411994j)*x[2]
            ref[(0, 2, 0, 0)]+=(-0.638886121262-0.835534411994j)*x_ref[2]
            arg[(0, 2, 0, 1)]+=(0.0616169467268-0.160966298338j)*x[2]
            ref[(0, 2, 0, 1)]+=(0.0616169467268-0.160966298338j)*x_ref[2]
            arg[(0, 2, 1, 0)]+=(-0.46272761447+0.193092916889j)*x[2]
            ref[(0, 2, 1, 0)]+=(-0.46272761447+0.193092916889j)*x_ref[2]
            arg[(0, 2, 1, 1)]+=(-0.633300071109+0.506219138044j)*x[2]
            ref[(0, 2, 1, 1)]+=(-0.633300071109+0.506219138044j)*x_ref[2]
            arg[(0, 3, 0, 0)]+=(0.197651709996+0.620650910411j)*x[2]
            ref[(0, 3, 0, 0)]+=(0.197651709996+0.620650910411j)*x_ref[2]
            arg[(0, 3, 0, 1)]+=(-0.650731496939+0.874835165632j)*x[2]
            ref[(0, 3, 0, 1)]+=(-0.650731496939+0.874835165632j)*x_ref[2]
            arg[(0, 3, 1, 0)]+=(-0.726852289117-0.236088490269j)*x[2]
            ref[(0, 3, 1, 0)]+=(-0.726852289117-0.236088490269j)*x_ref[2]
            arg[(0, 3, 1, 1)]+=(-0.156175302736-0.0109204595885j)*x[2]
            ref[(0, 3, 1, 1)]+=(-0.156175302736-0.0109204595885j)*x_ref[2]
            arg[(1, 0, 0, 0)]+=(-0.487047078215-0.783625739242j)*x[2]
            ref[(1, 0, 0, 0)]+=(-0.487047078215-0.783625739242j)*x_ref[2]
            arg[(1, 0, 0, 1)]+=(0.82473661688+0.237114766138j)*x[2]
            ref[(1, 0, 0, 1)]+=(0.82473661688+0.237114766138j)*x_ref[2]
            arg[(1, 0, 1, 0)]+=(0.0928591496955-0.652664887047j)*x[2]
            ref[(1, 0, 1, 0)]+=(0.0928591496955-0.652664887047j)*x_ref[2]
            arg[(1, 0, 1, 1)]+=(0.837840937445-0.448735574214j)*x[2]
            ref[(1, 0, 1, 1)]+=(0.837840937445-0.448735574214j)*x_ref[2]
            arg[(1, 1, 0, 0)]+=(0.161044729944-0.653859011039j)*x[2]
            ref[(1, 1, 0, 0)]+=(0.161044729944-0.653859011039j)*x_ref[2]
            arg[(1, 1, 0, 1)]+=(-0.115711736022+0.847842834063j)*x[2]
            ref[(1, 1, 0, 1)]+=(-0.115711736022+0.847842834063j)*x_ref[2]
            arg[(1, 1, 1, 0)]+=(-0.241416665023-0.462073689892j)*x[2]
            ref[(1, 1, 1, 0)]+=(-0.241416665023-0.462073689892j)*x_ref[2]
            arg[(1, 1, 1, 1)]+=(-0.587428742967-0.518732664909j)*x[2]
            ref[(1, 1, 1, 1)]+=(-0.587428742967-0.518732664909j)*x_ref[2]
            arg[(1, 2, 0, 0)]+=(0.350139277308+0.780526808108j)*x[2]
            ref[(1, 2, 0, 0)]+=(0.350139277308+0.780526808108j)*x_ref[2]
            arg[(1, 2, 0, 1)]+=(0.371868251942-0.358288011251j)*x[2]
            ref[(1, 2, 0, 1)]+=(0.371868251942-0.358288011251j)*x_ref[2]
            arg[(1, 2, 1, 0)]+=(0.0509869380993+0.0436791692515j)*x[2]
            ref[(1, 2, 1, 0)]+=(0.0509869380993+0.0436791692515j)*x_ref[2]
            arg[(1, 2, 1, 1)]+=(-0.92590019674+0.445717407658j)*x[2]
            ref[(1, 2, 1, 1)]+=(-0.92590019674+0.445717407658j)*x_ref[2]
            arg[(1, 3, 0, 0)]+=(-0.518108956344-0.978141208991j)*x[2]
            ref[(1, 3, 0, 0)]+=(-0.518108956344-0.978141208991j)*x_ref[2]
            arg[(1, 3, 0, 1)]+=(0.598746210059+0.639033657136j)*x[2]
            ref[(1, 3, 0, 1)]+=(0.598746210059+0.639033657136j)*x_ref[2]
            arg[(1, 3, 1, 0)]+=(-0.217568570422-0.0736084170811j)*x[2]
            ref[(1, 3, 1, 0)]+=(-0.217568570422-0.0736084170811j)*x_ref[2]
            arg[(1, 3, 1, 1)]+=(-0.614497416177-0.372983618578j)*x[2]
            ref[(1, 3, 1, 1)]+=(-0.614497416177-0.372983618578j)*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (2, 4, 2, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_FunctionOnBoundary_rank0(self):
        """
        tests interpolation of rank 0 Data on FunctionOnBoundary

        assumptions: FunctionOnBoundary(self.domain) exists
                     self.domain supports interpolation from FunctionOnBoundary to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = FunctionOnBoundary(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,(),w_ref)
        arg=(-0.00167353632305+0.937199962674j)*x[0]**o + ((-0.699180037159-0.77918932974j))*x[0] + ((-0.803131285077-0.891719518309j))*x[1]**o + ((-0.380050024856+0.298803911604j))*x[1]
        ref=(-0.00167353632305+0.937199962674j)*x_ref[0]**o + ((-0.699180037159-0.77918932974j))*x_ref[0] + ((-0.803131285077-0.891719518309j))*x_ref[1]**o + ((-0.380050024856+0.298803911604j))*x_ref[1]
        if dim==3:
            arg+=((0.503219099289-0.19414902301j))*x[2]**o + ((-0.0054066573979-0.342360954916j))*x[2]
            ref+=((0.503219099289-0.19414902301j))*x_ref[2]**o + ((-0.0054066573979-0.342360954916j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_FunctionOnBoundary_rank1(self):
        """
        tests interpolation of rank 1 Data on FunctionOnBoundary

        assumptions: FunctionOnBoundary(self.domain) exists
                     self.domain supports interpolation from FunctionOnBoundary to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = FunctionOnBoundary(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,),w_ref)
        arg[(0,)]=(0.409038231695+0.738542446534j)*x[0]**o + ((-0.620995441609-0.0425117529506j))*x[0] + ((-0.970382704845+0.341289630625j))*x[1]**o + ((-0.244410597482-0.0116346455175j))*x[1]
        ref[(0,)]=(0.409038231695+0.738542446534j)*x_ref[0]**o + ((-0.620995441609-0.0425117529506j))*x_ref[0] + ((-0.970382704845+0.341289630625j))*x_ref[1]**o + ((-0.244410597482-0.0116346455175j))*x_ref[1]
        arg[(1,)]=(-0.930016265696+0.417037062078j)*x[0]**o + ((0.143870896766+0.606053747679j))*x[0] + ((-0.736070436415-0.678009868579j))*x[1]**o + ((0.221047267545+0.519390840598j))*x[1]
        ref[(1,)]=(-0.930016265696+0.417037062078j)*x_ref[0]**o + ((0.143870896766+0.606053747679j))*x_ref[0] + ((-0.736070436415-0.678009868579j))*x_ref[1]**o + ((0.221047267545+0.519390840598j))*x_ref[1]
        arg[(2,)]=(-0.48034333085+0.116969238332j)*x[0]**o + ((0.721343522417+0.943347971454j))*x[0] + ((-0.609557516546+0.682363679043j))*x[1]**o + ((-0.810293049323-0.57790264555j))*x[1]
        ref[(2,)]=(-0.48034333085+0.116969238332j)*x_ref[0]**o + ((0.721343522417+0.943347971454j))*x_ref[0] + ((-0.609557516546+0.682363679043j))*x_ref[1]**o + ((-0.810293049323-0.57790264555j))*x_ref[1]
        arg[(3,)]=(0.398460609539-0.472742903165j)*x[0]**o + ((-0.337508011655+0.138644960467j))*x[0] + ((-0.946340678033-0.913759183023j))*x[1]**o + ((-0.436360366604+0.836377294034j))*x[1]
        ref[(3,)]=(0.398460609539-0.472742903165j)*x_ref[0]**o + ((-0.337508011655+0.138644960467j))*x_ref[0] + ((-0.946340678033-0.913759183023j))*x_ref[1]**o + ((-0.436360366604+0.836377294034j))*x_ref[1]
        if dim==3:
            arg[(0,)]+=(-0.510525633978-0.818529352262j)*x[2]**o + ((0.226104758184+0.436588640899j))*x[2]
            ref[(0,)]+=(-0.510525633978-0.818529352262j)*x_ref[2]**o + ((0.226104758184+0.436588640899j))*x_ref[2]
            arg[(1,)]+=(-0.263323736856-0.30333365549j)*x[2]**o + ((0.444712699611-0.702467571926j))*x[2]
            ref[(1,)]+=(-0.263323736856-0.30333365549j)*x_ref[2]**o + ((0.444712699611-0.702467571926j))*x_ref[2]
            arg[(2,)]+=(0.79239116744-0.103147565959j)*x[2]**o + ((0.366301328854+0.0989548719217j))*x[2]
            ref[(2,)]+=(0.79239116744-0.103147565959j)*x_ref[2]**o + ((0.366301328854+0.0989548719217j))*x_ref[2]
            arg[(3,)]+=(0.96981652896+0.523449526446j)*x[2]**o + ((-0.664958627706+0.823041882365j))*x[2]
            ref[(3,)]+=(0.96981652896+0.523449526446j)*x_ref[2]**o + ((-0.664958627706+0.823041882365j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_FunctionOnBoundary_rank2(self):
        """
        tests interpolation of rank 2 Data on FunctionOnBoundary

        assumptions: FunctionOnBoundary(self.domain) exists
                     self.domain supports interpolation from FunctionOnBoundary to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = FunctionOnBoundary(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2),w)
        ref = Data(0,(4, 2),w_ref)
        arg[(0, 0)]=(0.244205688636-0.771246655387j)*x[0]**o + ((-0.0681853757641+0.39217288985j))*x[0] + ((0.930678951928+0.50822840032j))*x[1]**o + ((0.213616694534+0.612168681696j))*x[1]
        ref[(0, 0)]=(0.244205688636-0.771246655387j)*x_ref[0]**o + ((-0.0681853757641+0.39217288985j))*x_ref[0] + ((0.930678951928+0.50822840032j))*x_ref[1]**o + ((0.213616694534+0.612168681696j))*x_ref[1]
        arg[(0, 1)]=(-0.463468904588+0.541604057159j)*x[0]**o + ((0.457054341561+0.569627625409j))*x[0] + ((-0.420760038419-0.54995767469j))*x[1]**o + ((0.630796195875-0.848972794982j))*x[1]
        ref[(0, 1)]=(-0.463468904588+0.541604057159j)*x_ref[0]**o + ((0.457054341561+0.569627625409j))*x_ref[0] + ((-0.420760038419-0.54995767469j))*x_ref[1]**o + ((0.630796195875-0.848972794982j))*x_ref[1]
        arg[(1, 0)]=(-0.392909751565+0.274775627125j)*x[0]**o + ((0.316088247235-0.682742039159j))*x[0] + ((0.484396109358+0.728924606327j))*x[1]**o + ((0.685978112776+0.333866720782j))*x[1]
        ref[(1, 0)]=(-0.392909751565+0.274775627125j)*x_ref[0]**o + ((0.316088247235-0.682742039159j))*x_ref[0] + ((0.484396109358+0.728924606327j))*x_ref[1]**o + ((0.685978112776+0.333866720782j))*x_ref[1]
        arg[(1, 1)]=(0.675052847128-0.140182959093j)*x[0]**o + ((-0.176483649826+0.111433984829j))*x[0] + ((-0.71725026241+0.45356775968j))*x[1]**o + ((-0.244291664107+0.268703997569j))*x[1]
        ref[(1, 1)]=(0.675052847128-0.140182959093j)*x_ref[0]**o + ((-0.176483649826+0.111433984829j))*x_ref[0] + ((-0.71725026241+0.45356775968j))*x_ref[1]**o + ((-0.244291664107+0.268703997569j))*x_ref[1]
        arg[(2, 0)]=(0.088680332801+0.71398064968j)*x[0]**o + ((0.624731379064-0.698634396874j))*x[0] + ((0.606600717956+0.0737233353049j))*x[1]**o + ((-0.37533604942-0.802048967896j))*x[1]
        ref[(2, 0)]=(0.088680332801+0.71398064968j)*x_ref[0]**o + ((0.624731379064-0.698634396874j))*x_ref[0] + ((0.606600717956+0.0737233353049j))*x_ref[1]**o + ((-0.37533604942-0.802048967896j))*x_ref[1]
        arg[(2, 1)]=(-0.714871140255-0.90438916663j)*x[0]**o + ((0.0742649824858-0.996126278246j))*x[0] + ((-0.167477562871+0.0751063517327j))*x[1]**o + ((-0.156622653966+0.330367702269j))*x[1]
        ref[(2, 1)]=(-0.714871140255-0.90438916663j)*x_ref[0]**o + ((0.0742649824858-0.996126278246j))*x_ref[0] + ((-0.167477562871+0.0751063517327j))*x_ref[1]**o + ((-0.156622653966+0.330367702269j))*x_ref[1]
        arg[(3, 0)]=(-0.427505055412+0.988213375094j)*x[0]**o + ((0.222052333078-0.761492866124j))*x[0] + ((-0.439130316713-0.514891216888j))*x[1]**o + ((-0.31733833116+0.840671043038j))*x[1]
        ref[(3, 0)]=(-0.427505055412+0.988213375094j)*x_ref[0]**o + ((0.222052333078-0.761492866124j))*x_ref[0] + ((-0.439130316713-0.514891216888j))*x_ref[1]**o + ((-0.31733833116+0.840671043038j))*x_ref[1]
        arg[(3, 1)]=(0.167442571617+0.482332708781j)*x[0]**o + ((0.66623900933-0.161250019408j))*x[0] + ((-0.973521191516-0.189877222403j))*x[1]**o + ((0.0388848037279+0.0950165618157j))*x[1]
        ref[(3, 1)]=(0.167442571617+0.482332708781j)*x_ref[0]**o + ((0.66623900933-0.161250019408j))*x_ref[0] + ((-0.973521191516-0.189877222403j))*x_ref[1]**o + ((0.0388848037279+0.0950165618157j))*x_ref[1]
        if dim==3:
            arg[(0, 0)]+=(-0.168228391082+0.643081133273j)*x[2]**o + ((0.914156337976-0.757654911871j))*x[2]
            ref[(0, 0)]+=(-0.168228391082+0.643081133273j)*x_ref[2]**o + ((0.914156337976-0.757654911871j))*x_ref[2]
            arg[(0, 1)]+=(-0.934831097471-0.52152381166j)*x[2]**o + ((-0.0845129881942+0.0373136422947j))*x[2]
            ref[(0, 1)]+=(-0.934831097471-0.52152381166j)*x_ref[2]**o + ((-0.0845129881942+0.0373136422947j))*x_ref[2]
            arg[(1, 0)]+=(-0.783568077086+0.888416650464j)*x[2]**o + ((0.479331337067-0.559187942253j))*x[2]
            ref[(1, 0)]+=(-0.783568077086+0.888416650464j)*x_ref[2]**o + ((0.479331337067-0.559187942253j))*x_ref[2]
            arg[(1, 1)]+=(-0.715075312453+0.46720711745j)*x[2]**o + ((0.661985283977-0.652253559447j))*x[2]
            ref[(1, 1)]+=(-0.715075312453+0.46720711745j)*x_ref[2]**o + ((0.661985283977-0.652253559447j))*x_ref[2]
            arg[(2, 0)]+=(0.628414511086+0.514256104126j)*x[2]**o + ((0.490899063709+0.0284083173152j))*x[2]
            ref[(2, 0)]+=(0.628414511086+0.514256104126j)*x_ref[2]**o + ((0.490899063709+0.0284083173152j))*x_ref[2]
            arg[(2, 1)]+=(0.0595738821725+0.873171937811j)*x[2]**o + ((0.883995952324-0.219508977064j))*x[2]
            ref[(2, 1)]+=(0.0595738821725+0.873171937811j)*x_ref[2]**o + ((0.883995952324-0.219508977064j))*x_ref[2]
            arg[(3, 0)]+=(0.405645690828+0.997121403911j)*x[2]**o + ((-0.00793426905046+0.530391655859j))*x[2]
            ref[(3, 0)]+=(0.405645690828+0.997121403911j)*x_ref[2]**o + ((-0.00793426905046+0.530391655859j))*x_ref[2]
            arg[(3, 1)]+=(0.240168982137-0.544043204666j)*x[2]**o + ((0.901122701512-0.254058040698j))*x[2]
            ref[(3, 1)]+=(0.240168982137-0.544043204666j)*x_ref[2]**o + ((0.901122701512-0.254058040698j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 2),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_FunctionOnBoundary_rank3(self):
        """
        tests interpolation of rank 3 Data on FunctionOnBoundary

        assumptions: FunctionOnBoundary(self.domain) exists
                     self.domain supports interpolation from FunctionOnBoundary to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = FunctionOnBoundary(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 4),w)
        ref = Data(0,(4, 3, 4),w_ref)
        arg[(0, 0, 0)]=(-0.415990018833-0.474126466314j)*x[0]**o + ((0.838686956529+0.914695926042j))*x[0] + ((-0.529873989519-0.373579739403j))*x[1]**o + ((0.192070957086-0.831758558607j))*x[1]
        ref[(0, 0, 0)]=(-0.415990018833-0.474126466314j)*x_ref[0]**o + ((0.838686956529+0.914695926042j))*x_ref[0] + ((-0.529873989519-0.373579739403j))*x_ref[1]**o + ((0.192070957086-0.831758558607j))*x_ref[1]
        arg[(0, 0, 1)]=(0.200562193317-0.309525922422j)*x[0]**o + ((0.418352506417+0.964583643201j))*x[0] + ((-0.439019085282-0.234679941901j))*x[1]**o + ((-0.977979985189+0.330367648618j))*x[1]
        ref[(0, 0, 1)]=(0.200562193317-0.309525922422j)*x_ref[0]**o + ((0.418352506417+0.964583643201j))*x_ref[0] + ((-0.439019085282-0.234679941901j))*x_ref[1]**o + ((-0.977979985189+0.330367648618j))*x_ref[1]
        arg[(0, 0, 2)]=(-0.484335916373+0.324262478303j)*x[0]**o + ((-0.143669725904+0.945847647278j))*x[0] + ((0.990396664818-0.107930475347j))*x[1]**o + ((-0.763918788316-0.248069852845j))*x[1]
        ref[(0, 0, 2)]=(-0.484335916373+0.324262478303j)*x_ref[0]**o + ((-0.143669725904+0.945847647278j))*x_ref[0] + ((0.990396664818-0.107930475347j))*x_ref[1]**o + ((-0.763918788316-0.248069852845j))*x_ref[1]
        arg[(0, 0, 3)]=(-0.0609206032408+0.571275882505j)*x[0]**o + ((0.848100115482-0.0249586625677j))*x[0] + ((0.120828298124-0.675162961554j))*x[1]**o + ((0.979466104994-0.283258790948j))*x[1]
        ref[(0, 0, 3)]=(-0.0609206032408+0.571275882505j)*x_ref[0]**o + ((0.848100115482-0.0249586625677j))*x_ref[0] + ((0.120828298124-0.675162961554j))*x_ref[1]**o + ((0.979466104994-0.283258790948j))*x_ref[1]
        arg[(0, 1, 0)]=(-0.458549535358+0.326097944648j)*x[0]**o + ((-0.290354611557-0.739103763294j))*x[0] + ((0.307330922386+0.0839823421934j))*x[1]**o + ((0.257941060973+0.570950597507j))*x[1]
        ref[(0, 1, 0)]=(-0.458549535358+0.326097944648j)*x_ref[0]**o + ((-0.290354611557-0.739103763294j))*x_ref[0] + ((0.307330922386+0.0839823421934j))*x_ref[1]**o + ((0.257941060973+0.570950597507j))*x_ref[1]
        arg[(0, 1, 1)]=(0.155330477851+0.218240476682j)*x[0]**o + ((-0.228526438792-0.481043864661j))*x[0] + ((0.957408887872-0.714393489962j))*x[1]**o + ((-0.462806309911+0.119471737785j))*x[1]
        ref[(0, 1, 1)]=(0.155330477851+0.218240476682j)*x_ref[0]**o + ((-0.228526438792-0.481043864661j))*x_ref[0] + ((0.957408887872-0.714393489962j))*x_ref[1]**o + ((-0.462806309911+0.119471737785j))*x_ref[1]
        arg[(0, 1, 2)]=(0.591116035531-0.488772657666j)*x[0]**o + ((-0.372942024845-0.128050443434j))*x[0] + ((-0.913322773466-0.891014330705j))*x[1]**o + ((-0.739894210837+0.455919249701j))*x[1]
        ref[(0, 1, 2)]=(0.591116035531-0.488772657666j)*x_ref[0]**o + ((-0.372942024845-0.128050443434j))*x_ref[0] + ((-0.913322773466-0.891014330705j))*x_ref[1]**o + ((-0.739894210837+0.455919249701j))*x_ref[1]
        arg[(0, 1, 3)]=(-0.796454292341+0.0229739052315j)*x[0]**o + ((0.488807015631+0.572401819537j))*x[0] + ((-0.664222231696-0.289456626949j))*x[1]**o + ((0.129433269875-0.118570384811j))*x[1]
        ref[(0, 1, 3)]=(-0.796454292341+0.0229739052315j)*x_ref[0]**o + ((0.488807015631+0.572401819537j))*x_ref[0] + ((-0.664222231696-0.289456626949j))*x_ref[1]**o + ((0.129433269875-0.118570384811j))*x_ref[1]
        arg[(0, 2, 0)]=(0.98836335815-0.400398275487j)*x[0]**o + ((-0.23168038264-0.483058043748j))*x[0] + ((0.0556962081364+0.537324104311j))*x[1]**o + ((0.374387360017+0.509365957073j))*x[1]
        ref[(0, 2, 0)]=(0.98836335815-0.400398275487j)*x_ref[0]**o + ((-0.23168038264-0.483058043748j))*x_ref[0] + ((0.0556962081364+0.537324104311j))*x_ref[1]**o + ((0.374387360017+0.509365957073j))*x_ref[1]
        arg[(0, 2, 1)]=(-0.426088442222+0.056458134772j)*x[0]**o + ((0.111446073359+0.650320356184j))*x[0] + ((-0.475068219-0.184659475052j))*x[1]**o + ((-0.178392275847+0.584508793655j))*x[1]
        ref[(0, 2, 1)]=(-0.426088442222+0.056458134772j)*x_ref[0]**o + ((0.111446073359+0.650320356184j))*x_ref[0] + ((-0.475068219-0.184659475052j))*x_ref[1]**o + ((-0.178392275847+0.584508793655j))*x_ref[1]
        arg[(0, 2, 2)]=(-0.817656251717-0.324846619301j)*x[0]**o + ((-0.194180767901-0.0965879726096j))*x[0] + ((0.256177866621+0.0510464751j))*x[1]**o + ((0.58753328973-0.111061485277j))*x[1]
        ref[(0, 2, 2)]=(-0.817656251717-0.324846619301j)*x_ref[0]**o + ((-0.194180767901-0.0965879726096j))*x_ref[0] + ((0.256177866621+0.0510464751j))*x_ref[1]**o + ((0.58753328973-0.111061485277j))*x_ref[1]
        arg[(0, 2, 3)]=(-0.785045686773-0.679811836523j)*x[0]**o + ((-0.169528568036+0.893546568868j))*x[0] + ((-0.865165807222-0.894144405582j))*x[1]**o + ((0.413546984076+0.274999859844j))*x[1]
        ref[(0, 2, 3)]=(-0.785045686773-0.679811836523j)*x_ref[0]**o + ((-0.169528568036+0.893546568868j))*x_ref[0] + ((-0.865165807222-0.894144405582j))*x_ref[1]**o + ((0.413546984076+0.274999859844j))*x_ref[1]
        arg[(1, 0, 0)]=(0.494407404324-0.849365767763j)*x[0]**o + ((-0.423891009934+0.154396708802j))*x[0] + ((0.943756135964+0.135356657005j))*x[1]**o + ((0.450144866503-0.942308764646j))*x[1]
        ref[(1, 0, 0)]=(0.494407404324-0.849365767763j)*x_ref[0]**o + ((-0.423891009934+0.154396708802j))*x_ref[0] + ((0.943756135964+0.135356657005j))*x_ref[1]**o + ((0.450144866503-0.942308764646j))*x_ref[1]
        arg[(1, 0, 1)]=(0.558607668883+0.185347833341j)*x[0]**o + ((-0.335617850733+0.381140092966j))*x[0] + ((0.896667294953-0.713077196557j))*x[1]**o + ((-0.592129907811-0.546620293577j))*x[1]
        ref[(1, 0, 1)]=(0.558607668883+0.185347833341j)*x_ref[0]**o + ((-0.335617850733+0.381140092966j))*x_ref[0] + ((0.896667294953-0.713077196557j))*x_ref[1]**o + ((-0.592129907811-0.546620293577j))*x_ref[1]
        arg[(1, 0, 2)]=(0.691155831012-0.209180646733j)*x[0]**o + ((0.112265733142-0.0462588947369j))*x[0] + ((-0.944110033215-0.275591107053j))*x[1]**o + ((0.657249262463+0.100246622763j))*x[1]
        ref[(1, 0, 2)]=(0.691155831012-0.209180646733j)*x_ref[0]**o + ((0.112265733142-0.0462588947369j))*x_ref[0] + ((-0.944110033215-0.275591107053j))*x_ref[1]**o + ((0.657249262463+0.100246622763j))*x_ref[1]
        arg[(1, 0, 3)]=(-0.213917149386-0.51678087585j)*x[0]**o + ((-0.429782375801-0.375085036138j))*x[0] + ((0.577015991351+0.725889432785j))*x[1]**o + ((-0.183965129315-0.911836092898j))*x[1]
        ref[(1, 0, 3)]=(-0.213917149386-0.51678087585j)*x_ref[0]**o + ((-0.429782375801-0.375085036138j))*x_ref[0] + ((0.577015991351+0.725889432785j))*x_ref[1]**o + ((-0.183965129315-0.911836092898j))*x_ref[1]
        arg[(1, 1, 0)]=(-0.112201616862-0.770672796518j)*x[0]**o + ((-0.0260482784155+0.975857353837j))*x[0] + ((-0.188339093411-0.929766965495j))*x[1]**o + ((0.160694183663-0.139968930787j))*x[1]
        ref[(1, 1, 0)]=(-0.112201616862-0.770672796518j)*x_ref[0]**o + ((-0.0260482784155+0.975857353837j))*x_ref[0] + ((-0.188339093411-0.929766965495j))*x_ref[1]**o + ((0.160694183663-0.139968930787j))*x_ref[1]
        arg[(1, 1, 1)]=(0.760445247177+0.177963569299j)*x[0]**o + ((-0.995222838632+0.538384243365j))*x[0] + ((-0.718194302972+0.628952415283j))*x[1]**o + ((0.246510958082-0.810682297228j))*x[1]
        ref[(1, 1, 1)]=(0.760445247177+0.177963569299j)*x_ref[0]**o + ((-0.995222838632+0.538384243365j))*x_ref[0] + ((-0.718194302972+0.628952415283j))*x_ref[1]**o + ((0.246510958082-0.810682297228j))*x_ref[1]
        arg[(1, 1, 2)]=(-0.872711916146+0.559865614271j)*x[0]**o + ((-0.984533219995+0.130458085506j))*x[0] + ((0.144007831082+0.782061451394j))*x[1]**o + ((-0.861768048275+0.865363679959j))*x[1]
        ref[(1, 1, 2)]=(-0.872711916146+0.559865614271j)*x_ref[0]**o + ((-0.984533219995+0.130458085506j))*x_ref[0] + ((0.144007831082+0.782061451394j))*x_ref[1]**o + ((-0.861768048275+0.865363679959j))*x_ref[1]
        arg[(1, 1, 3)]=(0.145476651147+0.0820818133107j)*x[0]**o + ((-0.612061693799-0.653084159011j))*x[0] + ((-0.649253047629-0.0387136506882j))*x[1]**o + ((-0.538990133844-0.534078887876j))*x[1]
        ref[(1, 1, 3)]=(0.145476651147+0.0820818133107j)*x_ref[0]**o + ((-0.612061693799-0.653084159011j))*x_ref[0] + ((-0.649253047629-0.0387136506882j))*x_ref[1]**o + ((-0.538990133844-0.534078887876j))*x_ref[1]
        arg[(1, 2, 0)]=(0.575992934419+0.629731692417j)*x[0]**o + ((-0.540385016924-0.847583101651j))*x[0] + ((0.0965739067882-0.864687218408j))*x[1]**o + ((0.720427634575-0.588511733579j))*x[1]
        ref[(1, 2, 0)]=(0.575992934419+0.629731692417j)*x_ref[0]**o + ((-0.540385016924-0.847583101651j))*x_ref[0] + ((0.0965739067882-0.864687218408j))*x_ref[1]**o + ((0.720427634575-0.588511733579j))*x_ref[1]
        arg[(1, 2, 1)]=(0.761553200476-0.702934700449j)*x[0]**o + ((0.0508541971948-0.903926864259j))*x[0] + ((0.26923805159+0.130640473792j))*x[1]**o + ((0.476821061188-0.490189775076j))*x[1]
        ref[(1, 2, 1)]=(0.761553200476-0.702934700449j)*x_ref[0]**o + ((0.0508541971948-0.903926864259j))*x_ref[0] + ((0.26923805159+0.130640473792j))*x_ref[1]**o + ((0.476821061188-0.490189775076j))*x_ref[1]
        arg[(1, 2, 2)]=(0.72099328353-0.366550464907j)*x[0]**o + ((0.230622172284+0.112507451483j))*x[0] + ((0.292516008557+0.991429115676j))*x[1]**o + ((0.798115788396+0.336721252553j))*x[1]
        ref[(1, 2, 2)]=(0.72099328353-0.366550464907j)*x_ref[0]**o + ((0.230622172284+0.112507451483j))*x_ref[0] + ((0.292516008557+0.991429115676j))*x_ref[1]**o + ((0.798115788396+0.336721252553j))*x_ref[1]
        arg[(1, 2, 3)]=(-0.344400038238-0.350164062022j)*x[0]**o + ((0.858840824825-0.771875020809j))*x[0] + ((0.340103764123+0.0756263985967j))*x[1]**o + ((0.0334938276092+0.365714879923j))*x[1]
        ref[(1, 2, 3)]=(-0.344400038238-0.350164062022j)*x_ref[0]**o + ((0.858840824825-0.771875020809j))*x_ref[0] + ((0.340103764123+0.0756263985967j))*x_ref[1]**o + ((0.0334938276092+0.365714879923j))*x_ref[1]
        arg[(2, 0, 0)]=(0.513628158949-0.684235479819j)*x[0]**o + ((0.0213846405233+0.559490884689j))*x[0] + ((0.853093109926-0.147854772149j))*x[1]**o + ((-0.0676222314164-0.86799900014j))*x[1]
        ref[(2, 0, 0)]=(0.513628158949-0.684235479819j)*x_ref[0]**o + ((0.0213846405233+0.559490884689j))*x_ref[0] + ((0.853093109926-0.147854772149j))*x_ref[1]**o + ((-0.0676222314164-0.86799900014j))*x_ref[1]
        arg[(2, 0, 1)]=(-0.46180107505+0.323950113274j)*x[0]**o + ((-0.782542959587+0.824843941282j))*x[0] + ((-0.63919478121-0.206384395116j))*x[1]**o + ((-0.0586356061177+0.710309583722j))*x[1]
        ref[(2, 0, 1)]=(-0.46180107505+0.323950113274j)*x_ref[0]**o + ((-0.782542959587+0.824843941282j))*x_ref[0] + ((-0.63919478121-0.206384395116j))*x_ref[1]**o + ((-0.0586356061177+0.710309583722j))*x_ref[1]
        arg[(2, 0, 2)]=(0.828610292396-0.48059677622j)*x[0]**o + ((-0.477437739088-0.0141386899334j))*x[0] + ((0.280914329515+0.760137682756j))*x[1]**o + ((0.25465954071+0.85679944003j))*x[1]
        ref[(2, 0, 2)]=(0.828610292396-0.48059677622j)*x_ref[0]**o + ((-0.477437739088-0.0141386899334j))*x_ref[0] + ((0.280914329515+0.760137682756j))*x_ref[1]**o + ((0.25465954071+0.85679944003j))*x_ref[1]
        arg[(2, 0, 3)]=(0.231520446959+0.912627104148j)*x[0]**o + ((0.436060702628+0.341092050201j))*x[0] + ((0.25982806327+0.602858071185j))*x[1]**o + ((-0.143740762413+0.499621765167j))*x[1]
        ref[(2, 0, 3)]=(0.231520446959+0.912627104148j)*x_ref[0]**o + ((0.436060702628+0.341092050201j))*x_ref[0] + ((0.25982806327+0.602858071185j))*x_ref[1]**o + ((-0.143740762413+0.499621765167j))*x_ref[1]
        arg[(2, 1, 0)]=(-0.974546697999-0.920829318483j)*x[0]**o + ((-0.561441512877+0.121216031164j))*x[0] + ((0.802795358121+0.709962769609j))*x[1]**o + ((0.346771845282-0.179626406157j))*x[1]
        ref[(2, 1, 0)]=(-0.974546697999-0.920829318483j)*x_ref[0]**o + ((-0.561441512877+0.121216031164j))*x_ref[0] + ((0.802795358121+0.709962769609j))*x_ref[1]**o + ((0.346771845282-0.179626406157j))*x_ref[1]
        arg[(2, 1, 1)]=(-0.540270179915-0.708229500578j)*x[0]**o + ((-0.247319356943+0.67445459341j))*x[0] + ((0.974225924313-0.179861387928j))*x[1]**o + ((-0.807802238701-0.443884627768j))*x[1]
        ref[(2, 1, 1)]=(-0.540270179915-0.708229500578j)*x_ref[0]**o + ((-0.247319356943+0.67445459341j))*x_ref[0] + ((0.974225924313-0.179861387928j))*x_ref[1]**o + ((-0.807802238701-0.443884627768j))*x_ref[1]
        arg[(2, 1, 2)]=(0.712875233768-0.141418342161j)*x[0]**o + ((-0.284313888061+0.0299408794749j))*x[0] + ((0.190271449197-0.0328652933142j))*x[1]**o + ((0.922460818071+0.928253129128j))*x[1]
        ref[(2, 1, 2)]=(0.712875233768-0.141418342161j)*x_ref[0]**o + ((-0.284313888061+0.0299408794749j))*x_ref[0] + ((0.190271449197-0.0328652933142j))*x_ref[1]**o + ((0.922460818071+0.928253129128j))*x_ref[1]
        arg[(2, 1, 3)]=(0.843620645198-0.743210593557j)*x[0]**o + ((0.649642845871-0.999464090994j))*x[0] + ((0.263929048728+0.236794771994j))*x[1]**o + ((-0.934157212482-0.688345647444j))*x[1]
        ref[(2, 1, 3)]=(0.843620645198-0.743210593557j)*x_ref[0]**o + ((0.649642845871-0.999464090994j))*x_ref[0] + ((0.263929048728+0.236794771994j))*x_ref[1]**o + ((-0.934157212482-0.688345647444j))*x_ref[1]
        arg[(2, 2, 0)]=(-0.000927570635815+0.599583098615j)*x[0]**o + ((0.926145716191+0.995065001668j))*x[0] + ((-0.112037675702-0.221372969803j))*x[1]**o + ((-0.312637785256-0.886511039955j))*x[1]
        ref[(2, 2, 0)]=(-0.000927570635815+0.599583098615j)*x_ref[0]**o + ((0.926145716191+0.995065001668j))*x_ref[0] + ((-0.112037675702-0.221372969803j))*x_ref[1]**o + ((-0.312637785256-0.886511039955j))*x_ref[1]
        arg[(2, 2, 1)]=(0.0780245230763-0.248991386369j)*x[0]**o + ((-0.306082378513+0.163569050705j))*x[0] + ((0.804723903841+0.516027112849j))*x[1]**o + ((0.891995138884-0.616256239607j))*x[1]
        ref[(2, 2, 1)]=(0.0780245230763-0.248991386369j)*x_ref[0]**o + ((-0.306082378513+0.163569050705j))*x_ref[0] + ((0.804723903841+0.516027112849j))*x_ref[1]**o + ((0.891995138884-0.616256239607j))*x_ref[1]
        arg[(2, 2, 2)]=(-0.715792697703+0.256829799126j)*x[0]**o + ((0.612208351967-0.181393087082j))*x[0] + ((0.758712511332+0.0224776828061j))*x[1]**o + ((-0.231106859672-0.0187601208512j))*x[1]
        ref[(2, 2, 2)]=(-0.715792697703+0.256829799126j)*x_ref[0]**o + ((0.612208351967-0.181393087082j))*x_ref[0] + ((0.758712511332+0.0224776828061j))*x_ref[1]**o + ((-0.231106859672-0.0187601208512j))*x_ref[1]
        arg[(2, 2, 3)]=(0.697480271746+0.730522576942j)*x[0]**o + ((0.787707097181-0.0109528935609j))*x[0] + ((-0.383814237152+0.448389419056j))*x[1]**o + ((-0.665958991563-0.920504093463j))*x[1]
        ref[(2, 2, 3)]=(0.697480271746+0.730522576942j)*x_ref[0]**o + ((0.787707097181-0.0109528935609j))*x_ref[0] + ((-0.383814237152+0.448389419056j))*x_ref[1]**o + ((-0.665958991563-0.920504093463j))*x_ref[1]
        arg[(3, 0, 0)]=(-0.823312747446+0.592439691877j)*x[0]**o + ((0.776716337852+0.835818105991j))*x[0] + ((0.605690885517-0.352153874693j))*x[1]**o + ((-0.182526452746+0.030898054531j))*x[1]
        ref[(3, 0, 0)]=(-0.823312747446+0.592439691877j)*x_ref[0]**o + ((0.776716337852+0.835818105991j))*x_ref[0] + ((0.605690885517-0.352153874693j))*x_ref[1]**o + ((-0.182526452746+0.030898054531j))*x_ref[1]
        arg[(3, 0, 1)]=(-0.0687950795354+0.533698206895j)*x[0]**o + ((0.712989498642+0.999953389151j))*x[0] + ((-0.427747061402-0.996994137913j))*x[1]**o + ((0.629235159946+0.708997387617j))*x[1]
        ref[(3, 0, 1)]=(-0.0687950795354+0.533698206895j)*x_ref[0]**o + ((0.712989498642+0.999953389151j))*x_ref[0] + ((-0.427747061402-0.996994137913j))*x_ref[1]**o + ((0.629235159946+0.708997387617j))*x_ref[1]
        arg[(3, 0, 2)]=(0.709911497462+0.218576253782j)*x[0]**o + ((-0.667159599307+0.179656269516j))*x[0] + ((0.846297472979-0.134223853525j))*x[1]**o + ((-0.382689203353-0.360174937636j))*x[1]
        ref[(3, 0, 2)]=(0.709911497462+0.218576253782j)*x_ref[0]**o + ((-0.667159599307+0.179656269516j))*x_ref[0] + ((0.846297472979-0.134223853525j))*x_ref[1]**o + ((-0.382689203353-0.360174937636j))*x_ref[1]
        arg[(3, 0, 3)]=(0.0126847432047+0.117849399289j)*x[0]**o + ((0.782445891554-0.591871928119j))*x[0] + ((-0.397763841263+0.127938516306j))*x[1]**o + ((-0.835370446214-0.0789892566219j))*x[1]
        ref[(3, 0, 3)]=(0.0126847432047+0.117849399289j)*x_ref[0]**o + ((0.782445891554-0.591871928119j))*x_ref[0] + ((-0.397763841263+0.127938516306j))*x_ref[1]**o + ((-0.835370446214-0.0789892566219j))*x_ref[1]
        arg[(3, 1, 0)]=(-0.762411602332-0.227242813405j)*x[0]**o + ((-0.992473522629+0.134064639222j))*x[0] + ((0.169196775656+0.55929148266j))*x[1]**o + ((-0.244917135066-0.079635701942j))*x[1]
        ref[(3, 1, 0)]=(-0.762411602332-0.227242813405j)*x_ref[0]**o + ((-0.992473522629+0.134064639222j))*x_ref[0] + ((0.169196775656+0.55929148266j))*x_ref[1]**o + ((-0.244917135066-0.079635701942j))*x_ref[1]
        arg[(3, 1, 1)]=(-0.788466274471+0.420925111584j)*x[0]**o + ((0.460281378312-0.242574135218j))*x[0] + ((0.135768355627-0.00662498685588j))*x[1]**o + ((-0.907259299261+0.0894286279658j))*x[1]
        ref[(3, 1, 1)]=(-0.788466274471+0.420925111584j)*x_ref[0]**o + ((0.460281378312-0.242574135218j))*x_ref[0] + ((0.135768355627-0.00662498685588j))*x_ref[1]**o + ((-0.907259299261+0.0894286279658j))*x_ref[1]
        arg[(3, 1, 2)]=(0.0387260584448+0.464394428501j)*x[0]**o + ((-0.724261589341-0.110495379739j))*x[0] + ((0.438585573014+0.294031522785j))*x[1]**o + ((0.915420632694-0.740131919177j))*x[1]
        ref[(3, 1, 2)]=(0.0387260584448+0.464394428501j)*x_ref[0]**o + ((-0.724261589341-0.110495379739j))*x_ref[0] + ((0.438585573014+0.294031522785j))*x_ref[1]**o + ((0.915420632694-0.740131919177j))*x_ref[1]
        arg[(3, 1, 3)]=(0.0292238886489-0.826028514606j)*x[0]**o + ((0.181898659326-0.410619932911j))*x[0] + ((-0.927850292056-0.407280960329j))*x[1]**o + ((0.945911176196+0.390470680443j))*x[1]
        ref[(3, 1, 3)]=(0.0292238886489-0.826028514606j)*x_ref[0]**o + ((0.181898659326-0.410619932911j))*x_ref[0] + ((-0.927850292056-0.407280960329j))*x_ref[1]**o + ((0.945911176196+0.390470680443j))*x_ref[1]
        arg[(3, 2, 0)]=(-0.934088384368-0.294020755275j)*x[0]**o + ((0.778051813033-0.0185394757687j))*x[0] + ((0.732321526445-0.148230501242j))*x[1]**o + ((0.823476296216+0.208158189412j))*x[1]
        ref[(3, 2, 0)]=(-0.934088384368-0.294020755275j)*x_ref[0]**o + ((0.778051813033-0.0185394757687j))*x_ref[0] + ((0.732321526445-0.148230501242j))*x_ref[1]**o + ((0.823476296216+0.208158189412j))*x_ref[1]
        arg[(3, 2, 1)]=(0.964282435447-0.862534124307j)*x[0]**o + ((0.835572260896-0.921261132705j))*x[0] + ((0.0924149646836-0.928288771507j))*x[1]**o + ((-0.240854453843+0.927091019527j))*x[1]
        ref[(3, 2, 1)]=(0.964282435447-0.862534124307j)*x_ref[0]**o + ((0.835572260896-0.921261132705j))*x_ref[0] + ((0.0924149646836-0.928288771507j))*x_ref[1]**o + ((-0.240854453843+0.927091019527j))*x_ref[1]
        arg[(3, 2, 2)]=(-0.61702157407-0.707932116709j)*x[0]**o + ((0.234650107628+0.916178248132j))*x[0] + ((-0.616537681418-0.231969721801j))*x[1]**o + ((-0.112721015636+0.252053682011j))*x[1]
        ref[(3, 2, 2)]=(-0.61702157407-0.707932116709j)*x_ref[0]**o + ((0.234650107628+0.916178248132j))*x_ref[0] + ((-0.616537681418-0.231969721801j))*x_ref[1]**o + ((-0.112721015636+0.252053682011j))*x_ref[1]
        arg[(3, 2, 3)]=(-0.774401597635-0.705067434598j)*x[0]**o + ((0.786414486086-0.975475618726j))*x[0] + ((-0.631721971498-0.074665943739j))*x[1]**o + ((0.519641896137-0.0143600507066j))*x[1]
        ref[(3, 2, 3)]=(-0.774401597635-0.705067434598j)*x_ref[0]**o + ((0.786414486086-0.975475618726j))*x_ref[0] + ((-0.631721971498-0.074665943739j))*x_ref[1]**o + ((0.519641896137-0.0143600507066j))*x_ref[1]
        if dim==3:
            arg[(0, 0, 0)]+=(0.628891272714-0.273169431348j)*x[2]**o + ((0.954790517826-0.801707960114j))*x[2]
            ref[(0, 0, 0)]+=(0.628891272714-0.273169431348j)*x_ref[2]**o + ((0.954790517826-0.801707960114j))*x_ref[2]
            arg[(0, 0, 1)]+=(0.644605032235+0.322785669518j)*x[2]**o + ((0.644081067683+0.655059695443j))*x[2]
            ref[(0, 0, 1)]+=(0.644605032235+0.322785669518j)*x_ref[2]**o + ((0.644081067683+0.655059695443j))*x_ref[2]
            arg[(0, 0, 2)]+=(8.33378638272e-05+0.44848979828j)*x[2]**o + ((0.757956529801+0.0589622891041j))*x[2]
            ref[(0, 0, 2)]+=(8.33378638272e-05+0.44848979828j)*x_ref[2]**o + ((0.757956529801+0.0589622891041j))*x_ref[2]
            arg[(0, 0, 3)]+=(-0.45329607169+0.853880392747j)*x[2]**o + ((0.758976374147-0.373205496488j))*x[2]
            ref[(0, 0, 3)]+=(-0.45329607169+0.853880392747j)*x_ref[2]**o + ((0.758976374147-0.373205496488j))*x_ref[2]
            arg[(0, 1, 0)]+=(-0.240715489644-0.387440142662j)*x[2]**o + ((0.715374697655-0.0402040796753j))*x[2]
            ref[(0, 1, 0)]+=(-0.240715489644-0.387440142662j)*x_ref[2]**o + ((0.715374697655-0.0402040796753j))*x_ref[2]
            arg[(0, 1, 1)]+=(-0.19565108149+0.683142768249j)*x[2]**o + ((0.121381780381+0.815653489596j))*x[2]
            ref[(0, 1, 1)]+=(-0.19565108149+0.683142768249j)*x_ref[2]**o + ((0.121381780381+0.815653489596j))*x_ref[2]
            arg[(0, 1, 2)]+=(-0.666059809613-0.573275490745j)*x[2]**o + ((-0.477735356292-0.675655175921j))*x[2]
            ref[(0, 1, 2)]+=(-0.666059809613-0.573275490745j)*x_ref[2]**o + ((-0.477735356292-0.675655175921j))*x_ref[2]
            arg[(0, 1, 3)]+=(-0.668963744615+0.721306143489j)*x[2]**o + ((0.426685019318-0.766464557871j))*x[2]
            ref[(0, 1, 3)]+=(-0.668963744615+0.721306143489j)*x_ref[2]**o + ((0.426685019318-0.766464557871j))*x_ref[2]
            arg[(0, 2, 0)]+=(-0.874981106247-0.663514713342j)*x[2]**o + ((0.415874347948+0.194030835306j))*x[2]
            ref[(0, 2, 0)]+=(-0.874981106247-0.663514713342j)*x_ref[2]**o + ((0.415874347948+0.194030835306j))*x_ref[2]
            arg[(0, 2, 1)]+=(-0.726342731991-0.239137520921j)*x[2]**o + ((0.848607363558-0.0996838400009j))*x[2]
            ref[(0, 2, 1)]+=(-0.726342731991-0.239137520921j)*x_ref[2]**o + ((0.848607363558-0.0996838400009j))*x_ref[2]
            arg[(0, 2, 2)]+=(-0.62644211976+0.103143211583j)*x[2]**o + ((0.227852081585-0.150331491472j))*x[2]
            ref[(0, 2, 2)]+=(-0.62644211976+0.103143211583j)*x_ref[2]**o + ((0.227852081585-0.150331491472j))*x_ref[2]
            arg[(0, 2, 3)]+=(-0.390454524886+0.709320411928j)*x[2]**o + ((-0.630217183148-0.75523881545j))*x[2]
            ref[(0, 2, 3)]+=(-0.390454524886+0.709320411928j)*x_ref[2]**o + ((-0.630217183148-0.75523881545j))*x_ref[2]
            arg[(1, 0, 0)]+=(-0.942874471397-0.319768414397j)*x[2]**o + ((0.996583529735-0.231084225913j))*x[2]
            ref[(1, 0, 0)]+=(-0.942874471397-0.319768414397j)*x_ref[2]**o + ((0.996583529735-0.231084225913j))*x_ref[2]
            arg[(1, 0, 1)]+=(0.415889734465-0.0708295001514j)*x[2]**o + ((-0.904548587439-0.639164244676j))*x[2]
            ref[(1, 0, 1)]+=(0.415889734465-0.0708295001514j)*x_ref[2]**o + ((-0.904548587439-0.639164244676j))*x_ref[2]
            arg[(1, 0, 2)]+=(0.096417382201-0.207168475098j)*x[2]**o + ((0.559975270721+0.164014823711j))*x[2]
            ref[(1, 0, 2)]+=(0.096417382201-0.207168475098j)*x_ref[2]**o + ((0.559975270721+0.164014823711j))*x_ref[2]
            arg[(1, 0, 3)]+=(0.109219275125+0.438104863245j)*x[2]**o + ((0.87337460635+0.663647530521j))*x[2]
            ref[(1, 0, 3)]+=(0.109219275125+0.438104863245j)*x_ref[2]**o + ((0.87337460635+0.663647530521j))*x_ref[2]
            arg[(1, 1, 0)]+=(0.838149301645-0.436644837966j)*x[2]**o + ((-0.742119360486-0.634844397444j))*x[2]
            ref[(1, 1, 0)]+=(0.838149301645-0.436644837966j)*x_ref[2]**o + ((-0.742119360486-0.634844397444j))*x_ref[2]
            arg[(1, 1, 1)]+=(0.762521281967-0.669330813713j)*x[2]**o + ((0.685756013737-0.147128608595j))*x[2]
            ref[(1, 1, 1)]+=(0.762521281967-0.669330813713j)*x_ref[2]**o + ((0.685756013737-0.147128608595j))*x_ref[2]
            arg[(1, 1, 2)]+=(-0.711508357982-0.742088253579j)*x[2]**o + ((0.538832808895-0.473069270728j))*x[2]
            ref[(1, 1, 2)]+=(-0.711508357982-0.742088253579j)*x_ref[2]**o + ((0.538832808895-0.473069270728j))*x_ref[2]
            arg[(1, 1, 3)]+=(-0.328369970671-0.885749481202j)*x[2]**o + ((-0.558640233362+0.387548240367j))*x[2]
            ref[(1, 1, 3)]+=(-0.328369970671-0.885749481202j)*x_ref[2]**o + ((-0.558640233362+0.387548240367j))*x_ref[2]
            arg[(1, 2, 0)]+=(0.448115093368-0.900511107576j)*x[2]**o + ((0.731404489529-0.0032375193189j))*x[2]
            ref[(1, 2, 0)]+=(0.448115093368-0.900511107576j)*x_ref[2]**o + ((0.731404489529-0.0032375193189j))*x_ref[2]
            arg[(1, 2, 1)]+=(0.172138295506-0.960715050633j)*x[2]**o + ((-0.0139621042174+0.958027055885j))*x[2]
            ref[(1, 2, 1)]+=(0.172138295506-0.960715050633j)*x_ref[2]**o + ((-0.0139621042174+0.958027055885j))*x_ref[2]
            arg[(1, 2, 2)]+=(0.342232189169-0.65261579548j)*x[2]**o + ((-0.66145796969+0.588384948387j))*x[2]
            ref[(1, 2, 2)]+=(0.342232189169-0.65261579548j)*x_ref[2]**o + ((-0.66145796969+0.588384948387j))*x_ref[2]
            arg[(1, 2, 3)]+=(-0.171159345721+0.227884824584j)*x[2]**o + ((-0.0952040066524-0.703450868724j))*x[2]
            ref[(1, 2, 3)]+=(-0.171159345721+0.227884824584j)*x_ref[2]**o + ((-0.0952040066524-0.703450868724j))*x_ref[2]
            arg[(2, 0, 0)]+=(0.468593041285+0.684938534155j)*x[2]**o + ((-0.960472098384-0.842468236904j))*x[2]
            ref[(2, 0, 0)]+=(0.468593041285+0.684938534155j)*x_ref[2]**o + ((-0.960472098384-0.842468236904j))*x_ref[2]
            arg[(2, 0, 1)]+=(0.503257592574-0.816099264532j)*x[2]**o + ((0.401352822512+0.497547688125j))*x[2]
            ref[(2, 0, 1)]+=(0.503257592574-0.816099264532j)*x_ref[2]**o + ((0.401352822512+0.497547688125j))*x_ref[2]
            arg[(2, 0, 2)]+=(0.886975741526+0.737595128553j)*x[2]**o + ((0.273350639371-0.931687928138j))*x[2]
            ref[(2, 0, 2)]+=(0.886975741526+0.737595128553j)*x_ref[2]**o + ((0.273350639371-0.931687928138j))*x_ref[2]
            arg[(2, 0, 3)]+=(-0.976327592756+0.282160213653j)*x[2]**o + ((0.126803768003-0.494068096762j))*x[2]
            ref[(2, 0, 3)]+=(-0.976327592756+0.282160213653j)*x_ref[2]**o + ((0.126803768003-0.494068096762j))*x_ref[2]
            arg[(2, 1, 0)]+=(-0.942279834517-0.345119839066j)*x[2]**o + ((0.297205419634+0.277796244245j))*x[2]
            ref[(2, 1, 0)]+=(-0.942279834517-0.345119839066j)*x_ref[2]**o + ((0.297205419634+0.277796244245j))*x_ref[2]
            arg[(2, 1, 1)]+=(0.111463396619-0.308833475896j)*x[2]**o + ((-0.467038799032+0.243610358188j))*x[2]
            ref[(2, 1, 1)]+=(0.111463396619-0.308833475896j)*x_ref[2]**o + ((-0.467038799032+0.243610358188j))*x_ref[2]
            arg[(2, 1, 2)]+=(0.0780599018412-0.988479387173j)*x[2]**o + ((-0.316443231395+0.219041786618j))*x[2]
            ref[(2, 1, 2)]+=(0.0780599018412-0.988479387173j)*x_ref[2]**o + ((-0.316443231395+0.219041786618j))*x_ref[2]
            arg[(2, 1, 3)]+=(0.838151131961-0.0117496339768j)*x[2]**o + ((-0.272634588035+0.611886393425j))*x[2]
            ref[(2, 1, 3)]+=(0.838151131961-0.0117496339768j)*x_ref[2]**o + ((-0.272634588035+0.611886393425j))*x_ref[2]
            arg[(2, 2, 0)]+=(0.688217251834-0.760018312481j)*x[2]**o + ((0.278596195391+0.19192530753j))*x[2]
            ref[(2, 2, 0)]+=(0.688217251834-0.760018312481j)*x_ref[2]**o + ((0.278596195391+0.19192530753j))*x_ref[2]
            arg[(2, 2, 1)]+=(0.668568077279+0.15139112824j)*x[2]**o + ((0.0594914072045-0.769450260752j))*x[2]
            ref[(2, 2, 1)]+=(0.668568077279+0.15139112824j)*x_ref[2]**o + ((0.0594914072045-0.769450260752j))*x_ref[2]
            arg[(2, 2, 2)]+=(0.334049040017+0.513881416731j)*x[2]**o + ((-0.899867921304+0.697421728621j))*x[2]
            ref[(2, 2, 2)]+=(0.334049040017+0.513881416731j)*x_ref[2]**o + ((-0.899867921304+0.697421728621j))*x_ref[2]
            arg[(2, 2, 3)]+=(-0.878538804265-0.913881732487j)*x[2]**o + ((-0.29090175603-0.173776012492j))*x[2]
            ref[(2, 2, 3)]+=(-0.878538804265-0.913881732487j)*x_ref[2]**o + ((-0.29090175603-0.173776012492j))*x_ref[2]
            arg[(3, 0, 0)]+=(0.847040111546-0.72932292965j)*x[2]**o + ((-0.267479728957-0.506959918165j))*x[2]
            ref[(3, 0, 0)]+=(0.847040111546-0.72932292965j)*x_ref[2]**o + ((-0.267479728957-0.506959918165j))*x_ref[2]
            arg[(3, 0, 1)]+=(0.783313125524-0.217526838407j)*x[2]**o + ((-0.074189488077-0.265106884999j))*x[2]
            ref[(3, 0, 1)]+=(0.783313125524-0.217526838407j)*x_ref[2]**o + ((-0.074189488077-0.265106884999j))*x_ref[2]
            arg[(3, 0, 2)]+=(-0.823151993741+0.160562364599j)*x[2]**o + ((-0.51788516759+0.175775467266j))*x[2]
            ref[(3, 0, 2)]+=(-0.823151993741+0.160562364599j)*x_ref[2]**o + ((-0.51788516759+0.175775467266j))*x_ref[2]
            arg[(3, 0, 3)]+=(0.242870798793+0.710015341798j)*x[2]**o + ((0.258041697124+0.42348800293j))*x[2]
            ref[(3, 0, 3)]+=(0.242870798793+0.710015341798j)*x_ref[2]**o + ((0.258041697124+0.42348800293j))*x_ref[2]
            arg[(3, 1, 0)]+=(-0.0527158523902+0.427686759531j)*x[2]**o + ((-0.129192111002+0.00413158371936j))*x[2]
            ref[(3, 1, 0)]+=(-0.0527158523902+0.427686759531j)*x_ref[2]**o + ((-0.129192111002+0.00413158371936j))*x_ref[2]
            arg[(3, 1, 1)]+=(0.263673361032-0.220439827915j)*x[2]**o + ((-0.873434059054-0.941159494735j))*x[2]
            ref[(3, 1, 1)]+=(0.263673361032-0.220439827915j)*x_ref[2]**o + ((-0.873434059054-0.941159494735j))*x_ref[2]
            arg[(3, 1, 2)]+=(-0.613824724876-0.851952489928j)*x[2]**o + ((0.0645621357539-0.913612415095j))*x[2]
            ref[(3, 1, 2)]+=(-0.613824724876-0.851952489928j)*x_ref[2]**o + ((0.0645621357539-0.913612415095j))*x_ref[2]
            arg[(3, 1, 3)]+=(-0.14482872368+0.711005151507j)*x[2]**o + ((-0.702313997095-0.37771164889j))*x[2]
            ref[(3, 1, 3)]+=(-0.14482872368+0.711005151507j)*x_ref[2]**o + ((-0.702313997095-0.37771164889j))*x_ref[2]
            arg[(3, 2, 0)]+=(0.379701099896+0.832737335409j)*x[2]**o + ((-0.986078876796-0.843055666632j))*x[2]
            ref[(3, 2, 0)]+=(0.379701099896+0.832737335409j)*x_ref[2]**o + ((-0.986078876796-0.843055666632j))*x_ref[2]
            arg[(3, 2, 1)]+=(-0.926508351459-0.762967517669j)*x[2]**o + ((-0.0922556034784-0.153264855573j))*x[2]
            ref[(3, 2, 1)]+=(-0.926508351459-0.762967517669j)*x_ref[2]**o + ((-0.0922556034784-0.153264855573j))*x_ref[2]
            arg[(3, 2, 2)]+=(-0.705324722449+0.226159778665j)*x[2]**o + ((0.0454596776717-0.942935600738j))*x[2]
            ref[(3, 2, 2)]+=(-0.705324722449+0.226159778665j)*x_ref[2]**o + ((0.0454596776717-0.942935600738j))*x_ref[2]
            arg[(3, 2, 3)]+=(0.508167403948+0.226029121242j)*x[2]**o + ((-0.0962348489666-0.583550982382j))*x[2]
            ref[(3, 2, 3)]+=(0.508167403948+0.226029121242j)*x_ref[2]**o + ((-0.0962348489666-0.583550982382j))*x_ref[2]
        res=interpolate(arg, where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(), (4, 3, 4),'wrong shape of result.')
        self.assertLess(Lsup(res-ref), self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_interpolateC_onFunctionOnBoundary_fromData_FunctionOnBoundary_rank4(self):
        """
        tests interpolation of rank 4 Data on FunctionOnBoundary

        assumptions: FunctionOnBoundary(self.domain) exists
                     self.domain supports interpolation from FunctionOnBoundary to FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = FunctionOnBoundary(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2, 2, 4),w)
        ref = Data(0,(3, 2, 2, 4),w_ref)
        arg[(0, 0, 0, 0)]=(0.932932556965-0.156399099421j)*x[0]**o + ((0.177522896692+0.905949152271j))*x[0] + ((0.446596910044-0.713583453876j))*x[1]**o + ((-0.991377640891-0.843107033381j))*x[1]
        ref[(0, 0, 0, 0)]=(0.932932556965-0.156399099421j)*x_ref[0]**o + ((0.177522896692+0.905949152271j))*x_ref[0] + ((0.446596910044-0.713583453876j))*x_ref[1]**o + ((-0.991377640891-0.843107033381j))*x_ref[1]
        arg[(0, 0, 0, 1)]=(-0.613778670032+0.260232332906j)*x[0]**o + ((-0.436178193308-0.935961289036j))*x[0] + ((0.0321857400082+0.805356842058j))*x[1]**o + ((-0.602663285054+0.0839825174588j))*x[1]
        ref[(0, 0, 0, 1)]=(-0.613778670032+0.260232332906j)*x_ref[0]**o + ((-0.436178193308-0.935961289036j))*x_ref[0] + ((0.0321857400082+0.805356842058j))*x_ref[1]**o + ((-0.602663285054+0.0839825174588j))*x_ref[1]
        arg[(0, 0, 0, 2)]=(-0.157516694328+0.878933826392j)*x[0]**o + ((0.978810371626+0.762109983702j))*x[0] + ((-0.429443118339+0.538382325594j))*x[1]**o + ((0.182995939102-0.632056800568j))*x[1]
        ref[(0, 0, 0, 2)]=(-0.157516694328+0.878933826392j)*x_ref[0]**o + ((0.978810371626+0.762109983702j))*x_ref[0] + ((-0.429443118339+0.538382325594j))*x_ref[1]**o + ((0.182995939102-0.632056800568j))*x_ref[1]
        arg[(0, 0, 0, 3)]=(0.00220866856706+0.224219039658j)*x[0]**o + ((0.191751017375-0.219000999065j))*x[0] + ((0.269469291869+0.106482788084j))*x[1]**o + ((0.865796200313+0.428207624754j))*x[1]
        ref[(0, 0, 0, 3)]=(0.00220866856706+0.224219039658j)*x_ref[0]**o + ((0.191751017375-0.219000999065j))*x_ref[0] + ((0.269469291869+0.106482788084j))*x_ref[1]**o + ((0.865796200313+0.428207624754j))*x_ref[1]
        arg[(0, 0, 1, 0)]=(-0.0700748890642+0.633529236977j)*x[0]**o + ((-0.652384609338-0.283662739153j))*x[0] + ((-0.960857712678-0.951904926361j))*x[1]**o + ((0.100406128787-0.356169998835j))*x[1]
        ref[(0, 0, 1, 0)]=(-0.0700748890642+0.633529236977j)*x_ref[0]**o + ((-0.652384609338-0.283662739153j))*x_ref[0] + ((-0.960857712678-0.951904926361j))*x_ref[1]**o + ((0.100406128787-0.356169998835j))*x_ref[1]
        arg[(0, 0, 1, 1)]=(0.419899887803-0.304049149331j)*x[0]**o + ((0.356571814954+0.462903320585j))*x[0] + ((0.7432053687+0.226735613361j))*x[1]**o + ((0.67969636484+0.676179808441j))*x[1]
        ref[(0, 0, 1, 1)]=(0.419899887803-0.304049149331j)*x_ref[0]**o + ((0.356571814954+0.462903320585j))*x_ref[0] + ((0.7432053687+0.226735613361j))*x_ref[1]**o + ((0.67969636484+0.676179808441j))*x_ref[1]
        arg[(0, 0, 1, 2)]=(-0.58728300581+0.765725265132j)*x[0]**o + ((-0.186816317559-0.575470962069j))*x[0] + ((0.430272579294-0.0297176633095j))*x[1]**o + ((0.665315844017-0.89974211895j))*x[1]
        ref[(0, 0, 1, 2)]=(-0.58728300581+0.765725265132j)*x_ref[0]**o + ((-0.186816317559-0.575470962069j))*x_ref[0] + ((0.430272579294-0.0297176633095j))*x_ref[1]**o + ((0.665315844017-0.89974211895j))*x_ref[1]
        arg[(0, 0, 1, 3)]=(-0.899761144419+0.384645093029j)*x[0]**o + ((-0.157478764439+0.616731684958j))*x[0] + ((-0.66272097941+0.0549116728702j))*x[1]**o + ((0.282455205547-0.95451106318j))*x[1]
        ref[(0, 0, 1, 3)]=(-0.899761144419+0.384645093029j)*x_ref[0]**o + ((-0.157478764439+0.616731684958j))*x_ref[0] + ((-0.66272097941+0.0549116728702j))*x_ref[1]**o + ((0.282455205547-0.95451106318j))*x_ref[1]
        arg[(0, 1, 0, 0)]=(-0.518389523964-0.886244965444j)*x[0]**o + ((-0.563678680959-0.944394478464j))*x[0] + ((-0.862797115916+0.928248856141j))*x[1]**o + ((0.558094485215+0.588753687631j))*x[1]
        ref[(0, 1, 0, 0)]=(-0.518389523964-0.886244965444j)*x_ref[0]**o + ((-0.563678680959-0.944394478464j))*x_ref[0] + ((-0.862797115916+0.928248856141j))*x_ref[1]**o + ((0.558094485215+0.588753687631j))*x_ref[1]
        arg[(0, 1, 0, 1)]=(-0.775177153467+0.653483675785j)*x[0]**o + ((0.593096935615+0.53677197567j))*x[0] + ((0.373654604215-0.143642375178j))*x[1]**o + ((-0.78995240821+0.245605350968j))*x[1]
        ref[(0, 1, 0, 1)]=(-0.775177153467+0.653483675785j)*x_ref[0]**o + ((0.593096935615+0.53677197567j))*x_ref[0] + ((0.373654604215-0.143642375178j))*x_ref[1]**o + ((-0.78995240821+0.245605350968j))*x_ref[1]
        arg[(0, 1, 0, 2)]=(-0.0645839189099+0.85399183776j)*x[0]**o + ((-0.878268944404+0.120459884292j))*x[0] + ((-0.73045092168-0.626857043697j))*x[1]**o + ((-0.554340956029-0.821705643831j))*x[1]
        ref[(0, 1, 0, 2)]=(-0.0645839189099+0.85399183776j)*x_ref[0]**o + ((-0.878268944404+0.120459884292j))*x_ref[0] + ((-0.73045092168-0.626857043697j))*x_ref[1]**o + ((-0.554340956029-0.821705643831j))*x_ref[1]
        arg[(0, 1, 0, 3)]=(-0.40235502957-0.24379584555j)*x[0]**o + ((-0.0851445832479-0.0120167949217j))*x[0] + ((-0.319256692723-0.657179451849j))*x[1]**o + ((0.117072452947-0.147254602014j))*x[1]
        ref[(0, 1, 0, 3)]=(-0.40235502957-0.24379584555j)*x_ref[0]**o + ((-0.0851445832479-0.0120167949217j))*x_ref[0] + ((-0.319256692723-0.657179451849j))*x_ref[1]**o + ((0.117072452947-0.147254602014j))*x_ref[1]
        arg[(0, 1, 1, 0)]=(0.711529201359+0.220798206318j)*x[0]**o + ((-0.409169068349+0.91863054075j))*x[0] + ((0.225464865141-0.072465133928j))*x[1]**o + ((0.850708700705+0.934367580095j))*x[1]
        ref[(0, 1, 1, 0)]=(0.711529201359+0.220798206318j)*x_ref[0]**o + ((-0.409169068349+0.91863054075j))*x_ref[0] + ((0.225464865141-0.072465133928j))*x_ref[1]**o + ((0.850708700705+0.934367580095j))*x_ref[1]
        arg[(0, 1, 1, 1)]=(-0.559856783725+0.257657586537j)*x[0]**o + ((0.395978999145+0.718383130089j))*x[0] + ((-0.392899915269+0.775195464828j))*x[1]**o + ((-0.191433469754+0.951005560821j))*x[1]
        ref[(0, 1, 1, 1)]=(-0.559856783725+0.257657586537j)*x_ref[0]**o + ((0.395978999145+0.718383130089j))*x_ref[0] + ((-0.392899915269+0.775195464828j))*x_ref[1]**o + ((-0.191433469754+0.951005560821j))*x_ref[1]
        arg[(0, 1, 1, 2)]=(-0.0395497647875-0.162835136512j)*x[0]**o + ((0.32000489721+0.089493206321j))*x[0] + ((-0.835508308434+0.678814805456j))*x[1]**o + ((0.469217460263+0.356609753715j))*x[1]
        ref[(0, 1, 1, 2)]=(-0.0395497647875-0.162835136512j)*x_ref[0]**o + ((0.32000489721+0.089493206321j))*x_ref[0] + ((-0.835508308434+0.678814805456j))*x_ref[1]**o + ((0.469217460263+0.356609753715j))*x_ref[1]
        arg[(0, 1, 1, 3)]=(-0.55335891425+0.0437376376568j)*x[0]**o + ((0.0342618779942+0.732944176552j))*x[0] + ((0.102572044742-0.838445033939j))*x[1]**o + ((0.387974830133+0.314491363813j))*x[1]
        ref[(0, 1, 1, 3)]=(-0.55335891425+0.0437376376568j)*x_ref[0]**o + ((0.0342618779942+0.732944176552j))*x_ref[0] + ((0.102572044742-0.838445033939j))*x_ref[1]**o + ((0.387974830133+0.314491363813j))*x_ref[1]
        arg[(1, 0, 0, 0)]=(0.189360043531+0.308758110104j)*x[0]**o + ((-0.0657606445038-0.235911495295j))*x[0] + ((0.997316999253-0.401455277106j))*x[1]**o + ((-0.425957589633+0.654537213831j))*x[1]
        ref[(1, 0, 0, 0)]=(0.189360043531+0.308758110104j)*x_ref[0]**o + ((-0.0657606445038-0.235911495295j))*x_ref[0] + ((0.997316999253-0.401455277106j))*x_ref[1]**o + ((-0.425957589633+0.654537213831j))*x_ref[1]
        arg[(1, 0, 0, 1)]=(-0.698485531456-0.735938106722j)*x[0]**o + ((-0.166970516885+0.61842866682j))*x[0] + ((-0.426611289073+0.511664136269j))*x[1]**o + ((-0.00419977778225-0.256368388334j))*x[1]
        ref[(1, 0, 0, 1)]=(-0.698485531456-0.735938106722j)*x_ref[0]**o + ((-0.166970516885+0.61842866682j))*x_ref[0] + ((-0.426611289073+0.511664136269j))*x_ref[1]**o + ((-0.00419977778225-0.256368388334j))*x_ref[1]
        arg[(1, 0, 0, 2)]=(-0.73563025132-0.103007838025j)*x[0]**o + ((0.44695305555+0.265265644674j))*x[0] + ((-0.605066983859+0.0803820781983j))*x[1]**o + ((0.19300257081-0.638540845129j))*x[1]
        ref[(1, 0, 0, 2)]=(-0.73563025132-0.103007838025j)*x_ref[0]**o + ((0.44695305555+0.265265644674j))*x_ref[0] + ((-0.605066983859+0.0803820781983j))*x_ref[1]**o + ((0.19300257081-0.638540845129j))*x_ref[1]
        arg[(1, 0, 0, 3)]=(-0.0701784413298+0.564962525669j)*x[0]**o + ((-0.675197469912+0.573614488631j))*x[0] + ((-0.700267960124+0.108234392919j))*x[1]**o + ((0.954577136355-0.881287370239j))*x[1]
        ref[(1, 0, 0, 3)]=(-0.0701784413298+0.564962525669j)*x_ref[0]**o + ((-0.675197469912+0.573614488631j))*x_ref[0] + ((-0.700267960124+0.108234392919j))*x_ref[1]**o + ((0.954577136355-0.881287370239j))*x_ref[1]
        arg[(1, 0, 1, 0)]=(-0.639834274933-0.897473777555j)*x[0]**o + ((0.728496903506+0.525732570653j))*x[0] + ((-0.369592606538+0.739502421513j))*x[1]**o + ((0.500892717527+0.45810379473j))*x[1]
        ref[(1, 0, 1, 0)]=(-0.639834274933-0.897473777555j)*x_ref[0]**o + ((0.728496903506+0.525732570653j))*x_ref[0] + ((-0.369592606538+0.739502421513j))*x_ref[1]**o + ((0.500892717527+0.45810379473j))*x_ref[1]
        arg[(1, 0, 1, 1)]=(0.176032272158+0.74726698089j)*x[0]**o + ((0.336379677937+0.120740599762j))*x[0] + ((-0.0486648621572+0.371064215143j))*x[1]**o + ((-0.479299427144-0.658467635609j))*x[1]
        ref[(1, 0, 1, 1)]=(0.176032272158+0.74726698089j)*x_ref[0]**o + ((0.336379677937+0.120740599762j))*x_ref[0] + ((-0.0486648621572+0.371064215143j))*x_ref[1]**o + ((-0.479299427144-0.658467635609j))*x_ref[1]
        arg[(1, 0, 1, 2)]=(-0.336890917599-0.189587994952j)*x[0]**o + ((-0.306491544027+0.227571202019j))*x[0] + ((-0.0521627488798-0.0738521507507j))*x[1]**o + ((0.404644498032+0.384294910427j))*x[1]
        ref[(1, 0, 1, 2)]=(-0.336890917599-0.189587994952j)*x_ref[0]**o + ((-0.306491544027+0.227571202019j))*x_ref[0] + ((-0.0521627488798-0.0738521507507j))*x_ref[1]**o + ((0.404644498032+0.384294910427j))*x_ref[1]
        arg[(1, 0, 1, 3)]=(-0.911375749226+0.0363359943137j)*x[0]**o + ((0.704169991001-0.246011999548j))*x[0] + ((0.310232294963+0.528570075269j))*x[1]**o + ((0.0989582618956-0.219231747968j))*x[1]
        ref[(1, 0, 1, 3)]=(-0.911375749226+0.0363359943137j)*x_ref[0]**o + ((0.704169991001-0.246011999548j))*x_ref[0] + ((0.310232294963+0.528