/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;

public class CSVSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter,
FileSourcedConverter {
    static final long serialVersionUID = 476636654410701807L;

    public CSVSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in csv format";
    }

    public String getFileDescription() {
        return "CSV file: comma separated files";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".csv");
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        PrintWriter outW = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            outW = new PrintWriter(this.getWriter());
        }
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (outW != null) {
                outW.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            this.setWriteMode(0);
            if (this.retrieveFile() == null && outW == null) {
                for (int i = 0; i < structure.numAttributes(); ++i) {
                    System.out.print(structure.attribute(i).name());
                    if (i < structure.numAttributes() - 1) {
                        System.out.print(",");
                        continue;
                    }
                    System.out.println();
                }
            } else {
                for (int i = 0; i < structure.numAttributes(); ++i) {
                    outW.print(structure.attribute(i).name());
                    if (i < structure.numAttributes() - 1) {
                        outW.print(",");
                        continue;
                    }
                    outW.println();
                }
                outW.flush();
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                if (this.retrieveFile() == null && outW == null) {
                    System.out.println(inst);
                } else {
                    outW.println(this.instanceToString(inst));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        outW.flush();
                    }
                }
            } else {
                if (outW != null) {
                    outW.flush();
                    outW.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                outW = null;
                this.resetWriter();
            }
        }
    }

    public void writeBatch() throws IOException {
        int i;
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            int i2;
            for (i2 = 0; i2 < this.getInstances().numAttributes(); ++i2) {
                System.out.print(this.getInstances().attribute(i2).name());
                if (i2 < this.getInstances().numAttributes() - 1) {
                    System.out.print(",");
                    continue;
                }
                System.out.println();
            }
            for (i2 = 0; i2 < this.getInstances().numInstances(); ++i2) {
                System.out.println(this.getInstances().instance(i2));
            }
            this.setWriteMode(1);
            return;
        }
        PrintWriter outW = new PrintWriter(this.getWriter());
        for (i = 0; i < this.getInstances().numAttributes(); ++i) {
            outW.print(Utils.quote(this.getInstances().attribute(i).name()));
            if (i < this.getInstances().numAttributes() - 1) {
                outW.print(",");
                continue;
            }
            outW.println();
        }
        for (i = 0; i < this.getInstances().numInstances(); ++i) {
            outW.println(this.instanceToString(this.getInstances().instance(i)));
        }
        outW.flush();
        outW.close();
        this.setWriteMode(1);
        outW = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    protected String instanceToString(Instance inst) {
        Instance outInst;
        StringBuffer result = new StringBuffer();
        if (inst instanceof SparseInstance) {
            outInst = new Instance(inst.weight(), inst.toDoubleArray());
            outInst.setDataset(inst.dataset());
        } else {
            outInst = inst;
        }
        for (int i = 0; i < outInst.numAttributes(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            if (outInst.isMissing(i)) {
                result.append("?");
                continue;
            }
            result.append(outInst.toString(i));
        }
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7950 $");
    }

    public static void main(String[] args) {
        CSVSaver.runFileSaver(new CSVSaver(), args);
    }
}

