------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                           C O R B A . I M P L                            --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--         Copyright (C) 2001-2010, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

package body CORBA.Impl is

   ---------------------
   -- Execute_Servant --
   ---------------------

   function Execute_Servant
     (Self : not null access Implementation;
      Req  : PolyORB.Requests.Request_Access) return Boolean
   is
   begin
      return Execute_Servant (Self.As_Object, Req);
   end Execute_Servant;

   function Execute_Servant
     (Self : not null access Object;
      Req  : PolyORB.Requests.Request_Access) return Boolean
   is
   begin
      raise Program_Error;
      return False;
   end Execute_Servant;

   ------------------------
   -- To_PolyORB_Servant --
   ------------------------

   function To_PolyORB_Servant
     (S : access Object) return PolyORB.Servants.Servant_Access
   is
   begin
      return S.Neutral_View'Access;
   end To_PolyORB_Servant;

   package body Internals is

      ----------------------
      -- To_CORBA_Servant --
      ----------------------

      function To_CORBA_Servant
        (S : PolyORB.Servants.Servant_Access)
        return Object_Ptr
      is
         use type PolyORB.Servants.Servant_Access;

      begin
         if S = null then
            return null;
         else
            return Object_Ptr (Implementation (S.all).As_Object);
         end if;
      end To_CORBA_Servant;

   end Internals;

end CORBA.Impl;
