package org.codehaus.plexus.metadata.gleaner;

/*
 * Copyright (C) 2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.codehaus.plexus.component.repository.ComponentDescriptor;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;

/**
 * Interface for component gleaners which glean off of source code.
 *
 * @version $Id: SourceComponentGleaner.java 8340 2009-08-17 09:34:27Z bentmann $
 */
public interface SourceComponentGleaner
{
    String ROLE = SourceComponentGleaner.class.getName();

    ComponentDescriptor<?> glean( JavaDocBuilder classCache, JavaClass javaClass )
        throws ComponentGleanerException;
}