/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "option.h"

static Resultat option_ajout_elements(TRAVAIL(Option) option)
{
	/* Fait en sorte qu'en sortie de fonction, au moins une place libre
	 * et rserve en mmoire soit disponible.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si l'allocation ventuelle choue.
	 */
	TABLEAU(STOCKAGE(CommandeOption)) nouveau;
	if(T_S_(CHAMP(option , taille))<T_S_(CHAMP(option , memoire)))
		return RESULTAT_OK;
	if((nouveau=(TABLEAU(STOCKAGE(CommandeOption)))(realloc((void*)(CHAMP(option , option)),SIZEOF(CONTENEUR(STOCKAGE(CommandeOption)))*T_S_(CHAMP(option , memoire))*T_S_(MULTTAILLE))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	CHAMP(option , memoire) *= T_S_(MULTTAILLE);
	CHAMP(option , option)=nouveau;
	return RESULTAT_OK;
}

static Resultat option_rechercheinterne_option(TRAVAIL(Option) option , TRAVAIL_SCALAIRE(NomOption) nomoption , REFERENCE_SCALAIRE(Indice) indice)
{
	/* Renvoie l'indice de la place occupe par une
	 * option, mme si elle est absente.
	 */
	TRAVAIL_SCALAIRE(NomOption) nom;
	TRAVAIL_SCALAIRE(Indice) inferieur;
	TRAVAIL_SCALAIRE(Indice) median;
	TRAVAIL_SCALAIRE(Indice) superieur;
	DEBUTZONESECURISEE
	inferieur=T_S_(0);
	superieur=T_S_(CHAMP(option , taille))-T_S_(1);
	while(inferieur<=superieur)
	{
		median=(inferieur+superieur)/T_S_(2);
		SECURISE(commandeoption_lecture_option(ELEMENT_TRAVAIL(CHAMP(option , option) , median),R_T_(nom)));
		if((strcmp((char*)(nom),(char*)(nomoption)))<T_S_(0))
			inferieur=median+T_S_(1);
		else
			superieur=median-T_S_(1);
	}
	T_R_(indice)=inferieur;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat option_initialisation(TRAVAIL(Option) option)
{
	/* Cre une structure de dclaration d'option vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec de l'allocation,
	 */
	if((S_T(option)=(STOCKAGE(Option))(malloc(SIZEOF(CONTENEUR(Option)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	if((CHAMP(option , option)=(TABLEAU(STOCKAGE(CommandeOption)))(malloc(SIZEOF(CONTENEUR(STOCKAGE(CommandeOption)))*T_S_(TAILLEINIT))))==NULL)
	{
		free(S_T(option));
		S_T(option)=NULL;
		return RESULTAT_ERREUR_MEMOIRE;
	}
	CHAMP(option , memoire)=TAILLEINIT;
	CHAMP(option , taille)=0;
	return RESULTAT_OK;
}

Resultat option_ajout_option(TRAVAIL(Option) option , TRAVAIL(CommandeOption) commandeoption)
{
	/* Ajoute une option  la structure de dclaration d'option.
	 * Les options sont ajoutes dans l'ordre lexicographique.
	 * Si une option du mme nom existe dj, elle est remplace.
	 */
	TRAVAIL_SCALAIRE(Indice) insertion;
	TRAVAIL_SCALAIRE(NomOption) nom;
	TRAVAIL_SCALAIRE(NomOption) nominsertion;
	STOCKAGE_SCALAIRE(Booleen) testnom;
	DEBUTZONESECURISEE
	if(S_T(option)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(commandeoption_lecture_option(commandeoption,R_T_(nom)));
	SECURISE(option_rechercheinterne_option(option,nom,R_T_(insertion)));
	if(insertion<T_S_(CHAMP(option , taille)))
	{
		SECURISE(commandeoption_lecture_option(ELEMENT_TRAVAIL(CHAMP(option , option) , insertion),R_T_(nominsertion)));
		testnom=(((Entier)(strcmp((char*)(nom),(char*)(nominsertion))))!=T_S_(0))?VRAI:FAUX;
	}
	else
		testnom=VRAI;
	if(T_S_(testnom)==T_S_(VRAI))
	{
		SECURISE(option_ajout_elements(option));
		STOCKAGE_SCALAIRE(Indice) indice;
		for(indice=CHAMP(option , taille) ; T_S_(indice)>insertion ; T_S_(indice)--)
			ELEMENT(CHAMP(option , option) , T_S_(indice))=ELEMENT(CHAMP(option , option) , T_S_(indice)-1);
		T_S_(CHAMP(option , taille))++;
		ELEMENT(CHAMP(option , option) , insertion)=NULL;
	}
	SECURISE(commandeoption_copie(commandeoption,ELEMENT_TRAVAIL(CHAMP(option , option) , insertion)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat option_lecture_taille(TRAVAIL(Option) option , REFERENCE_SCALAIRE(Taille) taille)
{
	/* Renvoie la taille du tableau d'options.
	 * Renvoie RESULTAT_ERREUR si option est NULL.
	 */
	if(S_T(option)==NULL)
		return RESULTAT_ERREUR;
	T_R_(taille)=T_S_(CHAMP(option , taille));
	return RESULTAT_OK;
}

Resultat option_lecture_option(TRAVAIL(Option) option , TRAVAIL_SCALAIRE(Indice) indice , REFERENCE(CommandeOption) commandeoption)
{
	/* Retourne la commande d'option enregistre  l'indice indiqu.
	 * Renvoie RESULTAT_ERREUR si option est NULL.
	 * Renvoie RESULTAT_ERREUR_DEPASSEMENT si l'indice est incorrect.
	 */
	if(S_T(option)==NULL)
		return RESULTAT_ERREUR;
	if(indice<T_S_(0))
		return RESULTAT_ERREUR_DEPASSEMENT;
	if(indice>=T_S_(CHAMP(option , taille)))
		return RESULTAT_ERREUR_DEPASSEMENT;
	T_R(commandeoption)=ELEMENT_TRAVAIL(CHAMP(option , option) , indice);
	return RESULTAT_OK;
}

Resultat option_recherche_option(TRAVAIL(Option) option , TRAVAIL_SCALAIRE(NomOption) nomoption , REFERENCE_SCALAIRE(Indice) indice)
{
	/* Renvoie l'indice de la option passe en paramtre. Si elle n'est pas prsente,
	 * la fonction renvoie MACRO_NON_TROUVEE  la place de l'indice.
	 */
	TRAVAIL_SCALAIRE(NomOption) nom;
	DEBUTZONESECURISEE
	SECURISE(option_rechercheinterne_option(option,nomoption,indice));
	if(T_R_(indice)>=T_S_(CHAMP(option , taille)))
		T_R_(indice)=T_S_(OPTION_NON_TROUVEE);
	else
	{
		SECURISE(commandeoption_lecture_option(ELEMENT_TRAVAIL(CHAMP(option , option) , T_R_(indice)),R_T_(nom)));
		if((Entier)(strcmp((char*)(nom),(char*)(nomoption)))!=T_S_(0))
		T_R_(indice)=T_S_(OPTION_NON_TROUVEE);
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat option_fusion(TRAVAIL(Option) destination , TRAVAIL(Option) ajout)
{
	/* Fusionne deux listes de dclaration d'option, en ajoutant
	 * les options dclares dans ajout  celles de la destination.
	 * Les options restent dans l'ordre lexicographique.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */
	STOCKAGE_SCALAIRE(Indice) indice;
	DEBUTZONESECURISEE
	for(indice=0 ; T_S_(indice)<T_S_(CHAMP(ajout , taille)) ; T_S_(indice)++)
		SECURISE(option_ajout_option(destination,ELEMENT_TRAVAIL(CHAMP(ajout , option) , T_S_(indice))));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat option_copie(TRAVAIL(Option) option , TRAVAIL(Option) copie)
{
	/* Cre une copie de la option donne en paramtre.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec de l'allocation,
	 * Attention ! Si *copie est diffrent de NULL, la copie tente une
	 * destruction pralable de la valeur prsume dans la copie.
	 */
	STOCKAGE_SCALAIRE(Indice) indice;
	DEBUTZONESECURISEE
	SECURISE(option_destruction(copie));
	SECURISE(option_initialisation(copie));
	for(indice=0 ; T_S_(indice)<T_S_(CHAMP(option , taille)) ; T_S_(indice)++)
		SECURISE(option_ajout_option(copie,ELEMENT_TRAVAIL(CHAMP(option , option) , T_S_(indice))));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat option_destruction(TRAVAIL(Option) option)
{
	/* Dtruit une liste de dclaration d'options.
	 */
	STOCKAGE_SCALAIRE(Indice) indice;
	DEBUTZONESECURISEE
	if(S_T(option)==NULL)
		return RESULTAT_OK;
	for(indice=0 ; T_S_(indice)<T_S_(CHAMP(option , taille)) ; T_S_(indice)++)
	{
		SECURISE(commandeoption_destruction(ELEMENT_TRAVAIL(CHAMP(option , option) , T_S_(indice))));
	}
	free(CHAMP(option , option));
	free(S_T(option));
	S_T(option)=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

