sub Source_AlertNb($)
{
	my $SourceIP = shift;

	my $Filter = Filter->new();

	my $Crit1 = Criteria->new();
	$Crit1->Table( 'Address' );
	$Crit1->Field( 'parent_type' );
	$Crit1->Operator( '=' );
	$Crit1->Value( 'S' );
	$Filter->add_Criteria( $Crit1 );

	my $Crit2 = Criteria->new();
	$Crit2->Table( 'Address' );
	$Crit2->Field( 'address' );
	$Crit2->Operator( '=' );
	$Crit2->Value( $SourceIP );
	$Filter->add_Criteria( $Crit2 );

	$Filter->Formula('A AND B');

	$Filter->get_SQL();
	my $Statement_NL = $Filter->SQL_EltNb();

	my $Sth = $dbh->prepare( $Statement_NL );
	$Sth->execute();
	my $Count = $Sth->fetchrow_array();
	$Sth->finish();

	return $Count;
}

sub Source_AlertTypeNb($)
{
  my $SourceIP=shift;

  my $SQL='SELECT count(DISTINCT Prelude_Classification.name) FROM Prelude_Classification,Prelude_Address WHERE ';
  $SQL.='Prelude_Classification.alert_ident=Prelude_Address.Alert_ident AND ';
  $SQL.="((Prelude_Address.parent_type='S') AND (Prelude_Address.address=?));";

  my $Sth=$dbh->prepare($SQL);
  $Sth->execute($SourceIP);
  my $Count=$Sth->fetchrow_array();
  $Sth->finish();

  return $Count;
}

sub Source_TargetNb($)
{
	my $SourceIP = shift;

	my %Target;

	my $SQL = 'SELECT DISTINCT Prelude_Address.alert_ident FROM Prelude_Address WHERE ';
	$SQL .= "((Prelude_Address.parent_type='S') AND (Prelude_Address.address=?));";

	my $Sth = $dbh->prepare( $SQL );
	$Sth->execute( $SourceIP );
	while( my $AlertId = $Sth->fetchrow_array() )
	{
		my $SQL = 'SELECT DISTINCT Prelude_Address.address FROM Prelude_Address WHERE ';
		$SQL .= "Prelude_Address.parent_type='T' AND Prelude_Address.alert_ident=?;";

		my $Sth = $dbh->prepare( $SQL );
		$Sth->execute( $AlertId );
		if ( $Sth->rows() )
		{
			my $Target = $Sth->fetchrow_array();
			$Target{$Target} = 1;
		}
		$Sth->finish();
	}
	$Sth->finish();

	my @Target = keys %Target;
	my $Count = $#Target + 1;

	return $Count;
}

1;
