###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wireshark_mult_vuln_jul09_win.nasl 3593 2009-07-22 12:18:24Z jul $
#
# Wireshark Multiple Vulnerabilities - July09 (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900590);
  script_version("$ Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2559", "CVE-2009-2560", "CVE-2009-2561");
  script_bugtraq_id(35748);
  script_name("Wireshark Multiple Vulnerabilities - July09 (Win)");
  desc = "

  Overview: This host is installed with Wireshark and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - An array index error in the IPMI dissector may lead to buffer overflow via
    unspecified vectors.
  - Multiple unspecified vulnerabilities in the Bluetooth L2CAP, MIOP or sFlow
    dissectors and RADIUS which can be exploited via specially crafted network
    packets.

  Impact:
  Successful exploitation could result in denial of serivce condition.

  Impact Level: Application

  Affected Software/OS:
  Wireshark version 1.2.0 on Windows

  Fix: Upgrade to Wireshark 1.2.1 or later.
  http://www.wireshark.org/download.html

  References:
  http://secunia.com/advisories/35884
  http://www.vupen.com/english/advisories/2009/1970
  http://www.wireshark.org/security/wnpa-sec-2009-04.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_win.nasl");
  script_require_keys("Wireshark/Win/Ver");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Win/Ver");
if(!sharkVer){
  exit(0);
}

# Grep for Wireshark version 1.2.0
if(version_is_equal(version:sharkVer, test_version:"1.2.0")){
  security_warning(0);
}
