#
#VID c87aa2d2-c3c4-11de-ab08-000f20797ede
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID c87aa2d2-c3c4-11de-ab08-000f20797ede
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66159);
 script_cve_id("CVE-2009-3380", "CVE-2009-3381", "CVE-2009-3382", "CVE-2009-3383", "CVE-2009-3379", "CVE-2009-3378", "CVE-2009-3377", "CVE-2009-3376", "CVE-2009-3375", "CVE-2009-1563", "CVE-2009-3374", "CVE-2009-3373", "CVE-2009-3372", "CVE-2009-3371", "CVE-2009-3274", "CVE-2009-3370");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("FreeBSD Ports: firefox");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   firefox
   linux-firefox
   seamonkey
   linux-seamonkey

For details on the issues addressed with this update,
please visit the referenced security advisories.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.mozilla.org/security/announce/2009/mfsa2009-64.html
http://www.mozilla.org/security/announce/2009/mfsa2009-63.html
http://www.mozilla.org/security/announce/2009/mfsa2009-62.html
http://www.mozilla.org/security/announce/2009/mfsa2009-61.html
http://www.mozilla.org/security/announce/2009/mfsa2009-59.html
http://www.mozilla.org/security/announce/2009/mfsa2009-57.html
http://www.mozilla.org/security/announce/2009/mfsa2009-56.html
http://www.mozilla.org/security/announce/2009/mfsa2009-55.html
http://www.mozilla.org/security/announce/2009/mfsa2009-54.html
http://www.mozilla.org/security/announce/2009/mfsa2009-53.html
http://www.mozilla.org/security/announce/2009/mfsa2009-52.html
http://www.vuxml.org/freebsd/c87aa2d2-c3c4-11de-ab08-000f20797ede.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: firefox");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"firefox");
if(!isnull(bver) && revcomp(a:bver, b:"3.5.*,1")>0 && revcomp(a:bver, b:"3.5.4,1")<0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"3.*,1")>0 && revcomp(a:bver, b:"3.0.15,1")<0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.15")<0) {
    security_note(0, data:"Package linux-firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
