# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2688 (glib2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63725);
 script_cve_id("CVE-2008-4316");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Fedora Core 9 FEDORA-2009-2688 (glib2)";
 script_name(name);

 desc = "The remote host is missing an update to glib2
announced via advisory FEDORA-2009-2688.

GLib is the low-level core library that forms the basis
for projects such as GTK+ and GNOME. It provides data structure
handling for C, portability wrappers, and interfaces for such runtime
functionality as an event loop, threads, dynamic loading, and an
object system.

This package provides version 2 of GLib.

Update Information:

This update fixes possible integer overflows in the base64 handling functions.
This has been reported in CVE-2008-4316.

ChangeLog:

* Thu Mar 12 2009 Matthias Clasen  - 2.16.6-3
- Fix integer overflows in the base64 handling functions. CVE-2008-4316

References:

[ 1 ] Bug #474770 - CVE-2008-4316 glib2: integer overflows in the base64 handling functions (oCERT-2008-015)
https://bugzilla.redhat.com/show_bug.cgi?id=474770

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update glib2' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2688

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-2688 (glib2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"glib2", rpm:"glib2~2.16.6~3.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-devel", rpm:"glib2-devel~2.16.6~3.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-static", rpm:"glib2-static~2.16.6~3.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"glib2-debuginfo", rpm:"glib2-debuginfo~2.16.6~3.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
