# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1435-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60046);
 script_cve_id("CVE-2007-6335", "CVE-2007-6336");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1435-1 (clamav)";
 script_name(name);

 desc = "The remote host is missing an update to clamav
announced via advisory DSA 1435-1.

Several remote vulnerabilities have been discovered in the Clam
anti-virus toolkit. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2007-6335

It was discovered that an integer overflow in the decompression code
for MEW archives may lead to the execution of arbitrary code.

CVE-2007-6336

It was discovered that on off-by-one in the MS-ZIP decompression
code may lead to the execution of arbitrary code.

For the stable distribution (etch), these problems have been fixed in
version 0.90.1-3etch8.

The old stable distribution (sarge) is not affected by these problems.
However, since the clamav version from Sarge cannot process all current
Clam malware signatures any longer, support for the ClamAV in Sarge is
now discontinued. We recommend to upgrade the the stable distribution
or run a backport of the stable version.

The unstable distribution (sid) will be fixed soon.

We recommend that you upgrade your clamav packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201435-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1435-1 (clamav)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"clamav-docs", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-base", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-dbg", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav2", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav-milter", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"clamav", ver:"0.90.1-3etch8", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
