// --------------------------------------------------------------------------
//                   OpenMS -- Open-Source Mass Spectrometry
// --------------------------------------------------------------------------
// Copyright The OpenMS Team -- Eberhard Karls University Tuebingen,
// ETH Zurich, and Freie Universitaet Berlin 2002-2013.
//
// This software is released under a three-clause BSD license:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of any author or any participating institution
//    may be used to endorse or promote products derived from this software
//    without specific prior written permission.
// For a full list of authors, refer to the file AUTHORS.
// --------------------------------------------------------------------------
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL ANY OF THE AUTHORS OR THE CONTRIBUTING
// INSTITUTIONS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
// OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
// WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
// OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
// ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// --------------------------------------------------------------------------
// $Maintainer: Florian Zeller $
// $Authors: Lukas Mueller, Markus Mueller $
// --------------------------------------------------------------------------
//
/*
 *  IsotopicDist.cpp
 *  PeakDetection
 *
 *  Created by Markus Mueller on 10/19/06.
 *
 *  Ported to OpenMS by Florian Zeller, florian.zeller@bsse.ethz.ch
 *  December 2010
 *
 */

#include <list>
#include <map>

#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/SUPERHIRN/SuperHirnParameters.h>
#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/SUPERHIRN/CentroidPeak.h>

#include <iomanip>

#include <OpenMS/TRANSFORMATIONS/FEATUREFINDER/SUPERHIRN/IsotopicDist.h>

namespace OpenMS
{

// double IsotopicDist::sfDetectableIsoFact = 0.05; // determines which isotopes must match for peak detection
// double IsotopicDist::sfIntensityCV = 0.3; // maximal deviation between expected and measured isotopic intensities
// NOTE the sfIntensityCV is overwritten from config!


//////////////////////////////////////////////////////////////////////
// Static members
//////////////////////////////////////////////////////////////////////

// Isotopic tables. The values contain 50, 10 and 90 percentiles of the mass and intensity values. These values were calculated from 100 human peptides that fall within the mass bins.
// The isotopic patterns of these peptides were calculated by Rockwoods method (Rockwood et al. Rapid Comm. Mass Spectrom. 1995, 68, 2027-2030) with a mass bin of 0.0001 Da.
// The mass values correpond to the centroids of all masses within an isotopic group (same additional number of neutrons). Intensity values of one isotopic group were summed up
// and then, the intensity values of each isotopic group was devided by the total intensity of all groups.

  double IsotopicDist::sfIsoDist10[96][20] =
  {
    { 0.71805, 0.18724, 0.03415, 0.00459, 0.00050, 0.00005, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 500 Da
    { 0.68071, 0.21222, 0.04383, 0.00663, 0.00082, 0.00009, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 600 Da
    { 0.64259, 0.23484, 0.05476, 0.00919, 0.00131, 0.00016, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 700 Da
    { 0.60638, 0.25793, 0.06604, 0.01247, 0.00193, 0.00025, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 800 Da
    { 0.57230, 0.27528, 0.07759, 0.01615, 0.00271, 0.00039, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 900 Da
    { 0.54048, 0.29197, 0.08915, 0.02024, 0.00369, 0.00058, 0.00008, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1000 Da
    { 0.51047, 0.30488, 0.10099, 0.02471, 0.00488, 0.00082, 0.00012, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1100 Da
    { 0.48152, 0.31598, 0.11275, 0.02965, 0.00628, 0.00113, 0.00018, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1200 Da
    { 0.45403, 0.32521, 0.12425, 0.03486, 0.00789, 0.00150, 0.00025, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1300 Da
    { 0.42947, 0.33244, 0.13520, 0.04032, 0.00968, 0.00196, 0.00035, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1400 Da
    { 0.40498, 0.33813, 0.14619, 0.04614, 0.01171, 0.00251, 0.00047, 0.00008, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1500 Da
    { 0.38267, 0.34221, 0.15664, 0.05221, 0.01395, 0.00315, 0.00062, 0.00011, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1600 Da
    { 0.36062, 0.34507, 0.16671, 0.05841, 0.01643, 0.00390, 0.00081, 0.00015, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1700 Da
    { 0.34030, 0.34642, 0.17634, 0.06497, 0.01913, 0.00475, 0.00103, 0.00020, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1800 Da
    { 0.32090, 0.34663, 0.18510, 0.07129, 0.02195, 0.00569, 0.00128, 0.00026, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1900 Da
    { 0.30282, 0.34551, 0.19378, 0.07797, 0.02505, 0.00677, 0.00159, 0.00033, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2000 Da
    { 0.28535, 0.34292, 0.20181, 0.08476, 0.02834, 0.00797, 0.00195, 0.00042, 0.00008, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2100 Da
    { 0.26925, 0.33925, 0.20915, 0.09143, 0.03178, 0.00927, 0.00235, 0.00053, 0.00011, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2200 Da
    { 0.25364, 0.33448, 0.21601, 0.09815, 0.03544, 0.01074, 0.00282, 0.00066, 0.00014, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2300 Da
    { 0.23877, 0.32899, 0.22252, 0.10495, 0.03924, 0.01231, 0.00335, 0.00081, 0.00018, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2400 Da
    { 0.22504, 0.32305, 0.22794, 0.11138, 0.04312, 0.01398, 0.00393, 0.00098, 0.00022, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2500 Da
    { 0.21201, 0.31666, 0.23344, 0.11808, 0.04725, 0.01583, 0.00460, 0.00118, 0.00027, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2600 Da
    { 0.19947, 0.30974, 0.23782, 0.12447, 0.05149, 0.01779, 0.00533, 0.00142, 0.00034, 0.00007, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2700 Da
    { 0.18863, 0.30301, 0.24165, 0.13061, 0.05574, 0.01986, 0.00613, 0.00168, 0.00041, 0.00009, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2800 Da
    { 0.17665, 0.29514, 0.24554, 0.13680, 0.06009, 0.02205, 0.00700, 0.00197, 0.00050, 0.00012, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2900 Da
    { 0.16653, 0.28775, 0.24850, 0.14287, 0.06461, 0.02438, 0.00796, 0.00230, 0.00060, 0.00014, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3000 Da
    { 0.15672, 0.28000, 0.25101, 0.14841, 0.06899, 0.02676, 0.00897, 0.00266, 0.00071, 0.00017, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3100 Da
    { 0.14840, 0.27278, 0.25287, 0.15387, 0.07357, 0.02931, 0.01010, 0.00308, 0.00084, 0.00021, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3200 Da
    { 0.13999, 0.26503, 0.25473, 0.15978, 0.07864, 0.03223, 0.01139, 0.00356, 0.00100, 0.00026, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3300 Da
    { 0.13221, 0.25776, 0.25566, 0.16444, 0.08293, 0.03475, 0.01257, 0.00402, 0.00116, 0.00030, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3400 Da
    { 0.12341, 0.24893, 0.25642, 0.16931, 0.08762, 0.03766, 0.01398, 0.00458, 0.00136, 0.00036, 0.00009, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3500 Da
    { 0.11648, 0.24143, 0.25673, 0.17410, 0.09236, 0.04069, 0.01546, 0.00518, 0.00156, 0.00043, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3600 Da
    { 0.11040, 0.23448, 0.25634, 0.17834, 0.09701, 0.04378, 0.01704, 0.00586, 0.00181, 0.00051, 0.00013, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3700 Da
    { 0.10480, 0.22781, 0.25524, 0.18276, 0.10174, 0.04695, 0.01863, 0.00653, 0.00206, 0.00059, 0.00016, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3800 Da
    { 0.09852, 0.21992, 0.25350, 0.18617, 0.10568, 0.04981, 0.02024, 0.00725, 0.00233, 0.00069, 0.00019, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3900 Da
    { 0.09295, 0.21292, 0.25134, 0.18975, 0.11033, 0.05325, 0.02213, 0.00811, 0.00267, 0.00080, 0.00022, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4000 Da
    { 0.08864, 0.20679, 0.24914, 0.19318, 0.11481, 0.05651, 0.02395, 0.00893, 0.00299, 0.00091, 0.00026, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4100 Da
    { 0.08313, 0.19917, 0.24599, 0.19608, 0.11914, 0.05981, 0.02583, 0.00983, 0.00336, 0.00105, 0.00030, 0.00008, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4200 Da
    { 0.07824, 0.19206, 0.24292, 0.19891, 0.12322, 0.06328, 0.02790, 0.01086, 0.00380, 0.00120, 0.00035, 0.00010, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4300 Da
    { 0.07367, 0.18492, 0.23949, 0.20154, 0.12751, 0.06674, 0.03013, 0.01196, 0.00425, 0.00137, 0.00041, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4400 Da
    { 0.06978, 0.17879, 0.23623, 0.20354, 0.13129, 0.07000, 0.03202, 0.01294, 0.00470, 0.00155, 0.00047, 0.00013, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4500 Da
    { 0.06504, 0.17132, 0.23206, 0.20531, 0.13517, 0.07351, 0.03433, 0.01410, 0.00521, 0.00175, 0.00054, 0.00016, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4600 Da
    { 0.06205, 0.16625, 0.22868, 0.20724, 0.13876, 0.07679, 0.03647, 0.01524, 0.00571, 0.00194, 0.00061, 0.00018, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4700 Da
    { 0.05829, 0.15966, 0.22460, 0.20891, 0.14331, 0.08095, 0.03923, 0.01674, 0.00640, 0.00222, 0.00071, 0.00021, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4800 Da
    { 0.05451, 0.15292, 0.21996, 0.21021, 0.14664, 0.08429, 0.04155, 0.01804, 0.00702, 0.00247, 0.00080, 0.00024, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4900 Da
    { 0.05239, 0.14863, 0.21657, 0.21110, 0.15017, 0.08799, 0.04416, 0.01946, 0.00768, 0.00276, 0.00091, 0.00028, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5000 Da
    { 0.04922, 0.14265, 0.21245, 0.21175, 0.15265, 0.09105, 0.04645, 0.02085, 0.00837, 0.00304, 0.00102, 0.00032, 0.00009, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5100 Da
    { 0.04606, 0.13675, 0.20797, 0.21221, 0.15557, 0.09395, 0.04871, 0.02219, 0.00902, 0.00334, 0.00114, 0.00036, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5200 Da
    { 0.04368, 0.13171, 0.20375, 0.21261, 0.15894, 0.09780, 0.05156, 0.02392, 0.00994, 0.00374, 0.00130, 0.00041, 0.00012, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5300 Da
    { 0.04050, 0.12521, 0.19828, 0.21231, 0.16112, 0.10065, 0.05377, 0.02528, 0.01066, 0.00409, 0.00144, 0.00047, 0.00014, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5400 Da
    { 0.03852, 0.12098, 0.19442, 0.21204, 0.16465, 0.10431, 0.05660, 0.02705, 0.01158, 0.00450, 0.00160, 0.00053, 0.00016, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5500 Da
    { 0.03619, 0.11575, 0.18947, 0.21099, 0.16710, 0.10805, 0.05972, 0.02902, 0.01262, 0.00497, 0.00180, 0.00060, 0.00019, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5600 Da
    { 0.03399, 0.11085, 0.18481, 0.20960, 0.16908, 0.11048, 0.06179, 0.03035, 0.01338, 0.00534, 0.00196, 0.00066, 0.00021, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5700 Da
    { 0.03215, 0.10673, 0.18077, 0.20813, 0.17119, 0.11404, 0.06502, 0.03245, 0.01455, 0.00589, 0.00220, 0.00076, 0.00025, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5800 Da
    { 0.03011, 0.10176, 0.17572, 0.20617, 0.17307, 0.11669, 0.06718, 0.03395, 0.01537, 0.00631, 0.00238, 0.00084, 0.00027, 0.00008, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5900 Da
    { 0.02847, 0.09761, 0.17104, 0.20388, 0.17523, 0.12015, 0.07026, 0.03623, 0.01676, 0.00701, 0.00269, 0.00095, 0.00031, 0.00010, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6000 Da
    { 0.02688, 0.09368, 0.16677, 0.20203, 0.17626, 0.12208, 0.07259, 0.03769, 0.01751, 0.00737, 0.00285, 0.00102, 0.00034, 0.00011, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6100 Da
    { 0.02525, 0.08956, 0.16211, 0.19959, 0.17910, 0.12729, 0.07714, 0.04090, 0.01941, 0.00833, 0.00328, 0.00119, 0.00041, 0.00013, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6200 Da
    { 0.02369, 0.08565, 0.15764, 0.19718, 0.18059, 0.13019, 0.08009, 0.04321, 0.02084, 0.00910, 0.00364, 0.00134, 0.00046, 0.00015, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6300 Da
    { 0.02214, 0.08136, 0.15254, 0.19408, 0.18136, 0.13186, 0.08208, 0.04489, 0.02188, 0.00966, 0.00390, 0.00146, 0.00051, 0.00017, 0.00005, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6400 Da
    { 0.02103, 0.07834, 0.14873, 0.19178, 0.18227, 0.13429, 0.08466, 0.04665, 0.02304, 0.01026, 0.00418, 0.00160, 0.00056, 0.00019, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6500 Da
    { 0.01970, 0.07475, 0.14448, 0.18898, 0.18342, 0.13751, 0.08795, 0.04915, 0.02461, 0.01113, 0.00464, 0.00178, 0.00064, 0.00021, 0.00007, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6600 Da
    { 0.01863, 0.07166, 0.14024, 0.18634, 0.18425, 0.13979, 0.09071, 0.05169, 0.02624, 0.01208, 0.00507, 0.00198, 0.00072, 0.00024, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6700 Da
    { 0.01806, 0.06982, 0.13769, 0.18435, 0.18421, 0.14129, 0.09248, 0.05298, 0.02703, 0.01263, 0.00538, 0.00211, 0.00077, 0.00027, 0.00009, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6800 Da
    { 0.01635, 0.06485, 0.13104, 0.17964, 0.18508, 0.14379, 0.09509, 0.05515, 0.02864, 0.01346, 0.00579, 0.00229, 0.00085, 0.00029, 0.00010, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6900 Da
    { 0.01619, 0.06440, 0.13019, 0.17864, 0.18547, 0.14648, 0.09873, 0.05824, 0.03066, 0.01461, 0.00640, 0.00260, 0.00098, 0.00034, 0.00011, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000 }, // 7000 Da
    { 0.01493, 0.06060, 0.12497, 0.17483, 0.18521, 0.14780, 0.10047, 0.05968, 0.03166, 0.01528, 0.00673, 0.00273, 0.00102, 0.00036, 0.00012, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000 }, // 7100 Da
    { 0.01378, 0.05686, 0.11951, 0.17050, 0.18466, 0.14961, 0.10292, 0.06209, 0.03344, 0.01630, 0.00729, 0.00301, 0.00116, 0.00042, 0.00014, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000 }, // 7200 Da
    { 0.01280, 0.05383, 0.11519, 0.16708, 0.18416, 0.15255, 0.10637, 0.06480, 0.03538, 0.01748, 0.00791, 0.00331, 0.00129, 0.00047, 0.00016, 0.00005, 0.00002, 0.00000, 0.00000, 0.00000 }, // 7300 Da
    { 0.01262, 0.05325, 0.11428, 0.16602, 0.18357, 0.15398, 0.10884, 0.06736, 0.03721, 0.01866, 0.00856, 0.00362, 0.00142, 0.00052, 0.00018, 0.00006, 0.00002, 0.00001, 0.00000, 0.00000 }, // 7400 Da
    { 0.01203, 0.05123, 0.11098, 0.16320, 0.18240, 0.15560, 0.11127, 0.06963, 0.03900, 0.01973, 0.00913, 0.00389, 0.00154, 0.00057, 0.00020, 0.00007, 0.00002, 0.00001, 0.00000, 0.00000 }, // 7500 Da
    { 0.01140, 0.04905, 0.10739, 0.15973, 0.18104, 0.15605, 0.11233, 0.07096, 0.03991, 0.02032, 0.00946, 0.00407, 0.00163, 0.00061, 0.00022, 0.00007, 0.00002, 0.00001, 0.00000, 0.00000 }, // 7600 Da
    { 0.01084, 0.04731, 0.10494, 0.15731, 0.17987, 0.15702, 0.11396, 0.07257, 0.04121, 0.02121, 0.00998, 0.00435, 0.00177, 0.00067, 0.00024, 0.00008, 0.00003, 0.00001, 0.00000, 0.00000 }, // 7700 Da
    { 0.00983, 0.04380, 0.09929, 0.15218, 0.17781, 0.15886, 0.11675, 0.07493, 0.04296, 0.02238, 0.01069, 0.00469, 0.00193, 0.00074, 0.00027, 0.00009, 0.00003, 0.00001, 0.00000, 0.00000 }, // 7800 Da
    { 0.00961, 0.04297, 0.09765, 0.15061, 0.17692, 0.16133, 0.12117, 0.07938, 0.04646, 0.02458, 0.01189, 0.00530, 0.00221, 0.00085, 0.00031, 0.00011, 0.00004, 0.00001, 0.00000, 0.00000 }, // 7900 Da
    { 0.00879, 0.04008, 0.09291, 0.14588, 0.17443, 0.16172, 0.12219, 0.08066, 0.04732, 0.02516, 0.01228, 0.00549, 0.00228, 0.00089, 0.00033, 0.00012, 0.00004, 0.00001, 0.00000, 0.00000 }, // 8000 Da
    { 0.00835, 0.03854, 0.09038, 0.14342, 0.17303, 0.16268, 0.12445, 0.08323, 0.04946, 0.02657, 0.01307, 0.00594, 0.00251, 0.00099, 0.00037, 0.00013, 0.00004, 0.00001, 0.00000, 0.00000 }, // 8100 Da
    { 0.00818, 0.03782, 0.08896, 0.14171, 0.17181, 0.16396, 0.12684, 0.08577, 0.05168, 0.02799, 0.01393, 0.00641, 0.00273, 0.00109, 0.00041, 0.00015, 0.00005, 0.00002, 0.00000, 0.00000 }, // 8200 Da
    { 0.00725, 0.03446, 0.08319, 0.13588, 0.16861, 0.16395, 0.12793, 0.08721, 0.05305, 0.02934, 0.01476, 0.00689, 0.00300, 0.00122, 0.00046, 0.00017, 0.00006, 0.00002, 0.00001, 0.00000 }, // 8300 Da
    { 0.00715, 0.03412, 0.08244, 0.13484, 0.16773, 0.16549, 0.13057, 0.08992, 0.05513, 0.03054, 0.01551, 0.00729, 0.00319, 0.00131, 0.00050, 0.00018, 0.00006, 0.00002, 0.00001, 0.00000 }, // 8400 Da
    { 0.00667, 0.03224, 0.07892, 0.13086, 0.16531, 0.16567, 0.13238, 0.09237, 0.05747, 0.03231, 0.01660, 0.00784, 0.00346, 0.00143, 0.00055, 0.00020, 0.00007, 0.00002, 0.00001, 0.00000 }, // 8500 Da
    { 0.00609, 0.02990, 0.07452, 0.12571, 0.16165, 0.16539, 0.13380, 0.09382, 0.05887, 0.03360, 0.01747, 0.00842, 0.00375, 0.00157, 0.00062, 0.00023, 0.00008, 0.00003, 0.00001, 0.00000 }, // 8600 Da
    { 0.00577, 0.02863, 0.07221, 0.12323, 0.15984, 0.16635, 0.13542, 0.09618, 0.06084, 0.03477, 0.01816, 0.00875, 0.00392, 0.00165, 0.00065, 0.00024, 0.00009, 0.00003, 0.00001, 0.00000 }, // 8700 Da
    { 0.00554, 0.02773, 0.07048, 0.12112, 0.15831, 0.16675, 0.13814, 0.10001, 0.06448, 0.03763, 0.02009, 0.00987, 0.00449, 0.00191, 0.00076, 0.00029, 0.00010, 0.00003, 0.00001, 0.00000 }, // 8800 Da
    { 0.00527, 0.02659, 0.06815, 0.11819, 0.15591, 0.16604, 0.13866, 0.10045, 0.06469, 0.03762, 0.01998, 0.00979, 0.00446, 0.00190, 0.00076, 0.00029, 0.00010, 0.00004, 0.00001, 0.00000 }, // 8900 Da
    { 0.00460, 0.02398, 0.06324, 0.11246, 0.15176, 0.16536, 0.14213, 0.10551, 0.06917, 0.04116, 0.02223, 0.01107, 0.00513, 0.00222, 0.00091, 0.00035, 0.00013, 0.00004, 0.00001, 0.00000 }, // 9000 Da
    { 0.00452, 0.02353, 0.06216, 0.11093, 0.15034, 0.16495, 0.14143, 0.10503, 0.06954, 0.04136, 0.02245, 0.01124, 0.00524, 0.00229, 0.00094, 0.00037, 0.00014, 0.00005, 0.00002, 0.00001 }, // 9100 Da
    { 0.00405, 0.02151, 0.05797, 0.10551, 0.14585, 0.16326, 0.14158, 0.10496, 0.06935, 0.04144, 0.02255, 0.01132, 0.00528, 0.00231, 0.00096, 0.00038, 0.00014, 0.00005, 0.00002, 0.00001 }, // 9200 Da
    { 0.00407, 0.02156, 0.05798, 0.10541, 0.14573, 0.16316, 0.14425, 0.10892, 0.07298, 0.04411, 0.02432, 0.01236, 0.00585, 0.00259, 0.00108, 0.00043, 0.00016, 0.00006, 0.00002, 0.00001 }, // 9300 Da
    { 0.00368, 0.01990, 0.05462, 0.10124, 0.14202, 0.16151, 0.14518, 0.11050, 0.07508, 0.04617, 0.02584, 0.01328, 0.00636, 0.00285, 0.00120, 0.00048, 0.00018, 0.00006, 0.00002, 0.00001 }, // 9400 Da
    { 0.00369, 0.01989, 0.05440, 0.10058, 0.14128, 0.16080, 0.14637, 0.11311, 0.07772, 0.04798, 0.02703, 0.01403, 0.00676, 0.00305, 0.00130, 0.00053, 0.00020, 0.00007, 0.00003, 0.00001 }, // 9500 Da
    { 0.00328, 0.01811, 0.05067, 0.09565, 0.13704, 0.15891, 0.14694, 0.11432, 0.07907, 0.04938, 0.02809, 0.01471, 0.00715, 0.00327, 0.00140, 0.00057, 0.00022, 0.00008, 0.00003, 0.00001 }, // 9600 Da
    { 0.00364, 0.01964, 0.05372, 0.09942, 0.13998, 0.15986, 0.14809, 0.11599, 0.08081, 0.05083, 0.02921, 0.01548, 0.00763, 0.00351, 0.00152, 0.00062, 0.00024, 0.00009, 0.00003, 0.00001 }, // 9700 Da
    { 0.00291, 0.01637, 0.04673, 0.09001, 0.13164, 0.15590, 0.14859, 0.11703, 0.08245, 0.05251, 0.03058, 0.01635, 0.00810, 0.00375, 0.00163, 0.00067, 0.00026, 0.00010, 0.00003, 0.00001 }, // 9800 Da
    { 0.00287, 0.01620, 0.04630, 0.08935, 0.13090, 0.15525, 0.14815, 0.11638, 0.08160, 0.05144, 0.02961, 0.01572, 0.00775, 0.00358, 0.00157, 0.00065, 0.00026, 0.00010, 0.00003, 0.00001 }, // 9900 Da
    { 0.00285, 0.01605, 0.04581, 0.08840, 0.12970, 0.15424, 0.15088, 0.12209, 0.08781, 0.05689, 0.03326, 0.01786, 0.00888, 0.00412, 0.00179, 0.00073, 0.00029, 0.00011, 0.00004, 0.00001 }, // 10000 Da
  };

  double IsotopicDist::sfIsoDist50[96][20] =
  {
    { 0.74709, 0.20677, 0.03954, 0.00566, 0.00067, 0.00007, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 500 Da
    { 0.70836, 0.23414, 0.04996, 0.00811, 0.00105, 0.00012, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 600 Da
    { 0.67087, 0.25483, 0.06127, 0.01106, 0.00161, 0.00020, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 700 Da
    { 0.63457, 0.27559, 0.07320, 0.01457, 0.00236, 0.00032, 0.00004, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 800 Da
    { 0.59990, 0.29183, 0.08550, 0.01856, 0.00330, 0.00049, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 900 Da
    { 0.56781, 0.30638, 0.09775, 0.02302, 0.00441, 0.00071, 0.00010, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1000 Da
    { 0.53693, 0.31843, 0.10995, 0.02792, 0.00573, 0.00100, 0.00015, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1100 Da
    { 0.50761, 0.32817, 0.12210, 0.03324, 0.00730, 0.00136, 0.00022, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1200 Da
    { 0.47986, 0.33602, 0.13401, 0.03893, 0.00909, 0.00180, 0.00031, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1300 Da
    { 0.45460, 0.34184, 0.14510, 0.04473, 0.01106, 0.00231, 0.00042, 0.00007, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1400 Da
    { 0.42963, 0.34617, 0.15627, 0.05102, 0.01333, 0.00294, 0.00057, 0.00010, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1500 Da
    { 0.40614, 0.34915, 0.16689, 0.05753, 0.01583, 0.00367, 0.00074, 0.00013, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1600 Da
    { 0.38417, 0.35055, 0.17692, 0.06417, 0.01853, 0.00451, 0.00095, 0.00018, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1700 Da
    { 0.36312, 0.35085, 0.18652, 0.07099, 0.02149, 0.00547, 0.00121, 0.00024, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1800 Da
    { 0.34324, 0.34986, 0.19551, 0.07795, 0.02468, 0.00656, 0.00151, 0.00031, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1900 Da
    { 0.32484, 0.34807, 0.20371, 0.08486, 0.02802, 0.00776, 0.00187, 0.00040, 0.00008, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2000 Da
    { 0.30715, 0.34545, 0.21145, 0.09190, 0.03158, 0.00910, 0.00227, 0.00050, 0.00010, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2100 Da
    { 0.29064, 0.34223, 0.21851, 0.09878, 0.03529, 0.01055, 0.00274, 0.00063, 0.00013, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2200 Da
    { 0.27434, 0.33833, 0.22529, 0.10597, 0.03934, 0.01220, 0.00328, 0.00078, 0.00017, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2300 Da
    { 0.25924, 0.33383, 0.23105, 0.11301, 0.04352, 0.01399, 0.00389, 0.00096, 0.00021, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2400 Da
    { 0.24526, 0.32889, 0.23635, 0.11971, 0.04770, 0.01585, 0.00456, 0.00116, 0.00027, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2500 Da
    { 0.23158, 0.32332, 0.24126, 0.12662, 0.05221, 0.01794, 0.00532, 0.00140, 0.00033, 0.00007, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2600 Da
    { 0.21912, 0.31743, 0.24526, 0.13309, 0.05668, 0.02010, 0.00615, 0.00167, 0.00041, 0.00009, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2700 Da
    { 0.20712, 0.31130, 0.24876, 0.13943, 0.06129, 0.02238, 0.00706, 0.00197, 0.00049, 0.00011, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2800 Da
    { 0.19580, 0.30481, 0.25180, 0.14561, 0.06597, 0.02484, 0.00806, 0.00231, 0.00060, 0.00014, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2900 Da
    { 0.18490, 0.29799, 0.25428, 0.15177, 0.07085, 0.02745, 0.00916, 0.00270, 0.00072, 0.00017, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3000 Da
    { 0.17498, 0.29110, 0.25615, 0.15740, 0.07562, 0.03014, 0.01035, 0.00314, 0.00085, 0.00021, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3100 Da
    { 0.16533, 0.28410, 0.25755, 0.16296, 0.08049, 0.03296, 0.01162, 0.00361, 0.00101, 0.00026, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3200 Da
    { 0.15609, 0.27684, 0.25860, 0.16834, 0.08545, 0.03591, 0.01298, 0.00414, 0.00119, 0.00031, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3300 Da
    { 0.14760, 0.26979, 0.25913, 0.17330, 0.09026, 0.03890, 0.01443, 0.00471, 0.00138, 0.00037, 0.00009, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3400 Da
    { 0.13922, 0.26236, 0.25918, 0.17820, 0.09527, 0.04215, 0.01601, 0.00537, 0.00162, 0.00044, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3500 Da
    { 0.13170, 0.25504, 0.25869, 0.18256, 0.10013, 0.04540, 0.01766, 0.00606, 0.00186, 0.00052, 0.00013, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3600 Da
    { 0.12463, 0.24790, 0.25787, 0.18664, 0.10482, 0.04866, 0.01936, 0.00678, 0.00214, 0.00061, 0.00016, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3700 Da
    { 0.11844, 0.24120, 0.25676, 0.19013, 0.10923, 0.05185, 0.02111, 0.00757, 0.00243, 0.00071, 0.00019, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3800 Da
    { 0.11168, 0.23377, 0.25541, 0.19389, 0.11411, 0.05543, 0.02309, 0.00846, 0.00278, 0.00083, 0.00023, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3900 Da
    { 0.10538, 0.22646, 0.25382, 0.19722, 0.11881, 0.05904, 0.02514, 0.00941, 0.00316, 0.00096, 0.00027, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4000 Da
    { 0.10041, 0.22034, 0.25205, 0.19978, 0.12272, 0.06217, 0.02696, 0.01030, 0.00352, 0.00109, 0.00031, 0.00008, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4100 Da
    { 0.09436, 0.21273, 0.24976, 0.20285, 0.12759, 0.06617, 0.02942, 0.01147, 0.00400, 0.00127, 0.00037, 0.00010, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4200 Da
    { 0.08928, 0.20588, 0.24730, 0.20510, 0.13188, 0.06977, 0.03160, 0.01257, 0.00448, 0.00145, 0.00043, 0.00012, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4300 Da
    { 0.08484, 0.19987, 0.24479, 0.20715, 0.13555, 0.07308, 0.03373, 0.01367, 0.00496, 0.00163, 0.00050, 0.00014, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4400 Da
    { 0.08000, 0.19295, 0.24181, 0.20913, 0.13979, 0.07699, 0.03625, 0.01498, 0.00553, 0.00186, 0.00057, 0.00016, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4500 Da
    { 0.07530, 0.18614, 0.23857, 0.21081, 0.14399, 0.08086, 0.03882, 0.01635, 0.00616, 0.00211, 0.00066, 0.00019, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4600 Da
    { 0.07176, 0.18058, 0.23563, 0.21188, 0.14723, 0.08410, 0.04101, 0.01759, 0.00674, 0.00234, 0.00075, 0.00022, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4700 Da
    { 0.06758, 0.17387, 0.23193, 0.21306, 0.15111, 0.08808, 0.04387, 0.01916, 0.00748, 0.00264, 0.00086, 0.00026, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4800 Da
    { 0.06433, 0.16848, 0.22872, 0.21375, 0.15415, 0.09143, 0.04624, 0.02054, 0.00816, 0.00294, 0.00097, 0.00030, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4900 Da
    { 0.06013, 0.16147, 0.22439, 0.21444, 0.15811, 0.09568, 0.04944, 0.02239, 0.00906, 0.00332, 0.00112, 0.00035, 0.00010, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5000 Da
    { 0.05755, 0.15699, 0.22140, 0.21461, 0.16049, 0.09848, 0.05157, 0.02369, 0.00972, 0.00362, 0.00124, 0.00039, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5100 Da
    { 0.05454, 0.15172, 0.21773, 0.21465, 0.16335, 0.10188, 0.05422, 0.02532, 0.01054, 0.00399, 0.00139, 0.00045, 0.00013, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5200 Da
    { 0.05160, 0.14593, 0.21350, 0.21445, 0.16613, 0.10559, 0.05730, 0.02717, 0.01152, 0.00443, 0.00156, 0.00051, 0.00015, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5300 Da
    { 0.04843, 0.13986, 0.20893, 0.21396, 0.16911, 0.10956, 0.06049, 0.02927, 0.01265, 0.00495, 0.00177, 0.00059, 0.00018, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5400 Da
    { 0.04598, 0.13508, 0.20522, 0.21334, 0.17132, 0.11281, 0.06310, 0.03098, 0.01357, 0.00538, 0.00196, 0.00066, 0.00021, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5500 Da
    { 0.04351, 0.13028, 0.20115, 0.21259, 0.17359, 0.11589, 0.06593, 0.03290, 0.01463, 0.00589, 0.00217, 0.00074, 0.00024, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5600 Da
    { 0.04114, 0.12532, 0.19680, 0.21168, 0.17571, 0.11933, 0.06901, 0.03498, 0.01578, 0.00647, 0.00243, 0.00084, 0.00027, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5700 Da
    { 0.03878, 0.12019, 0.19234, 0.21059, 0.17768, 0.12273, 0.07218, 0.03705, 0.01699, 0.00705, 0.00268, 0.00094, 0.00031, 0.00009, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5800 Da
    { 0.03678, 0.11597, 0.18826, 0.20933, 0.17923, 0.12564, 0.07501, 0.03909, 0.01824, 0.00768, 0.00296, 0.00106, 0.00035, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5900 Da
    { 0.03485, 0.11176, 0.18440, 0.20800, 0.18091, 0.12848, 0.07768, 0.04111, 0.01941, 0.00830, 0.00325, 0.00118, 0.00040, 0.00013, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6000 Da
    { 0.03316, 0.10769, 0.18033, 0.20658, 0.18203, 0.13126, 0.08050, 0.04326, 0.02071, 0.00898, 0.00356, 0.00130, 0.00044, 0.00014, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6100 Da
    { 0.03059, 0.10196, 0.17466, 0.20440, 0.18391, 0.13516, 0.08450, 0.04615, 0.02246, 0.00990, 0.00400, 0.00149, 0.00052, 0.00017, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6200 Da
    { 0.02899, 0.09824, 0.17065, 0.20250, 0.18488, 0.13771, 0.08727, 0.04841, 0.02391, 0.01070, 0.00438, 0.00165, 0.00058, 0.00019, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6300 Da
    { 0.02739, 0.09410, 0.16611, 0.20048, 0.18564, 0.14051, 0.09044, 0.05091, 0.02551, 0.01153, 0.00477, 0.00182, 0.00065, 0.00022, 0.00007, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6400 Da
    { 0.02635, 0.09157, 0.16329, 0.19890, 0.18610, 0.14219, 0.09239, 0.05243, 0.02653, 0.01213, 0.00508, 0.00196, 0.00071, 0.00024, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6500 Da
    { 0.02476, 0.08740, 0.15827, 0.19639, 0.18669, 0.14490, 0.09587, 0.05532, 0.02843, 0.01317, 0.00558, 0.00218, 0.00080, 0.00027, 0.00009, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6600 Da
    { 0.02316, 0.08318, 0.15369, 0.19383, 0.18714, 0.14764, 0.09903, 0.05790, 0.03016, 0.01417, 0.00609, 0.00242, 0.00090, 0.00031, 0.00010, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6700 Da
    { 0.02256, 0.08176, 0.15181, 0.19248, 0.18702, 0.14869, 0.10031, 0.05920, 0.03104, 0.01471, 0.00638, 0.00255, 0.00095, 0.00033, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6800 Da
    { 0.02089, 0.07741, 0.14659, 0.18922, 0.18733, 0.15152, 0.10388, 0.06225, 0.03322, 0.01603, 0.00707, 0.00287, 0.00108, 0.00038, 0.00013, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6900 Da
    { 0.01945, 0.07314, 0.14142, 0.18609, 0.18715, 0.15401, 0.10750, 0.06536, 0.03538, 0.01730, 0.00773, 0.00319, 0.00122, 0.00044, 0.00015, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000 }, // 7000 Da
    { 0.01893, 0.07164, 0.13953, 0.18467, 0.18677, 0.15488, 0.10876, 0.06654, 0.03629, 0.01788, 0.00806, 0.00336, 0.00130, 0.00047, 0.00016, 0.00005, 0.00002, 0.00000, 0.00000, 0.00000 }, // 7100 Da
    { 0.01739, 0.06757, 0.13386, 0.18075, 0.18621, 0.15759, 0.11256, 0.07019, 0.03893, 0.01946, 0.00887, 0.00372, 0.00146, 0.00054, 0.00018, 0.00006, 0.00002, 0.00001, 0.00000, 0.00000 }, // 7200 Da
    { 0.01643, 0.06464, 0.13004, 0.17766, 0.18576, 0.15899, 0.11517, 0.07277, 0.04099, 0.02080, 0.00964, 0.00412, 0.00164, 0.00061, 0.00021, 0.00007, 0.00002, 0.00001, 0.00000, 0.00000 }, // 7300 Da
    { 0.01578, 0.06251, 0.12681, 0.17534, 0.18530, 0.16002, 0.11724, 0.07488, 0.04253, 0.02181, 0.01022, 0.00443, 0.00178, 0.00066, 0.00023, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000 }, // 7400 Da
    { 0.01489, 0.05996, 0.12358, 0.17266, 0.18465, 0.16149, 0.11953, 0.07707, 0.04432, 0.02295, 0.01086, 0.00473, 0.00192, 0.00073, 0.00026, 0.00009, 0.00003, 0.00001, 0.00000, 0.00000 }, // 7500 Da
    { 0.01429, 0.05796, 0.12026, 0.17009, 0.18397, 0.16232, 0.12156, 0.07935, 0.04604, 0.02412, 0.01154, 0.00509, 0.00208, 0.00080, 0.00029, 0.00010, 0.00003, 0.00001, 0.00000, 0.00000 }, // 7600 Da
    { 0.01372, 0.05617, 0.11752, 0.16788, 0.18307, 0.16313, 0.12323, 0.08114, 0.04753, 0.02511, 0.01212, 0.00541, 0.00223, 0.00086, 0.00031, 0.00011, 0.00004, 0.00001, 0.00000, 0.00000 }, // 7700 Da
    { 0.01273, 0.05325, 0.11336, 0.16412, 0.18197, 0.16461, 0.12606, 0.08414, 0.05003, 0.02676, 0.01309, 0.00591, 0.00249, 0.00097, 0.00036, 0.00012, 0.00004, 0.00001, 0.00000, 0.00000 }, // 7800 Da
    { 0.01216, 0.05120, 0.11017, 0.16142, 0.18095, 0.16531, 0.12797, 0.08652, 0.05183, 0.02801, 0.01389, 0.00633, 0.00268, 0.00106, 0.00039, 0.00014, 0.00005, 0.00001, 0.00000, 0.00000 }, // 7900 Da
    { 0.01158, 0.04947, 0.10758, 0.15899, 0.17995, 0.16605, 0.12956, 0.08829, 0.05349, 0.02916, 0.01452, 0.00667, 0.00286, 0.00114, 0.00043, 0.00015, 0.00005, 0.00002, 0.00001, 0.00000 }, // 8000 Da
    { 0.01073, 0.04666, 0.10331, 0.15505, 0.17831, 0.16681, 0.13232, 0.09131, 0.05621, 0.03113, 0.01572, 0.00731, 0.00316, 0.00127, 0.00048, 0.00017, 0.00006, 0.00002, 0.00001, 0.00000 }, // 8100 Da
    { 0.01054, 0.04582, 0.10164, 0.15398, 0.17734, 0.16702, 0.13315, 0.09242, 0.05688, 0.03157, 0.01611, 0.00760, 0.00332, 0.00135, 0.00052, 0.00019, 0.00007, 0.00002, 0.00001, 0.00000 }, // 8200 Da
    { 0.01008, 0.04408, 0.09854, 0.15063, 0.17600, 0.16731, 0.13479, 0.09490, 0.05924, 0.03343, 0.01721, 0.00817, 0.00357, 0.00146, 0.00057, 0.00021, 0.00007, 0.00002, 0.00001, 0.00000 }, // 8300 Da
    { 0.00874, 0.03981, 0.09186, 0.14410, 0.17266, 0.16842, 0.13902, 0.09987, 0.06374, 0.03665, 0.01920, 0.00928, 0.00416, 0.00174, 0.00068, 0.00025, 0.00009, 0.00003, 0.00001, 0.00000 }, // 8400 Da
    { 0.00887, 0.04018, 0.09245, 0.14446, 0.17267, 0.16810, 0.13854, 0.09941, 0.06343, 0.03652, 0.01913, 0.00926, 0.00416, 0.00175, 0.00069, 0.00026, 0.00009, 0.00003, 0.00001, 0.00000 }, // 8500 Da
    { 0.00780, 0.03631, 0.08600, 0.13833, 0.16938, 0.16844, 0.14221, 0.10419, 0.06767, 0.03965, 0.02119, 0.01042, 0.00476, 0.00203, 0.00081, 0.00031, 0.00011, 0.00004, 0.00001, 0.00000 }, // 8600 Da
    { 0.00782, 0.03616, 0.08545, 0.13739, 0.16870, 0.16803, 0.14218, 0.10472, 0.06837, 0.04022, 0.02157, 0.01066, 0.00490, 0.00211, 0.00085, 0.00032, 0.00012, 0.00004, 0.00001, 0.00000 }, // 8700 Da
    { 0.00732, 0.03443, 0.08258, 0.13440, 0.16663, 0.16790, 0.14386, 0.10689, 0.07047, 0.04195, 0.02279, 0.01137, 0.00525, 0.00227, 0.00093, 0.00036, 0.00013, 0.00004, 0.00001, 0.00000 }, // 8800 Da
    { 0.00671, 0.03205, 0.07806, 0.12916, 0.16337, 0.16739, 0.14580, 0.11041, 0.07419, 0.04488, 0.02473, 0.01253, 0.00588, 0.00258, 0.00106, 0.00041, 0.00015, 0.00005, 0.00002, 0.00001 }, // 8900 Da
    { 0.00620, 0.03015, 0.07502, 0.12587, 0.16144, 0.16703, 0.14751, 0.11276, 0.07647, 0.04660, 0.02586, 0.01319, 0.00625, 0.00278, 0.00116, 0.00046, 0.00017, 0.00006, 0.00002, 0.00001 }, // 9000 Da
    { 0.00622, 0.03019, 0.07466, 0.12517, 0.16029, 0.16680, 0.14737, 0.11306, 0.07712, 0.04738, 0.02653, 0.01367, 0.00655, 0.00293, 0.00123, 0.00049, 0.00018, 0.00006, 0.00002, 0.00001 }, // 9100 Da
    { 0.00579, 0.02845, 0.07130, 0.12150, 0.15796, 0.16616, 0.14865, 0.11563, 0.07964, 0.04936, 0.02791, 0.01456, 0.00706, 0.00320, 0.00136, 0.00055, 0.00021, 0.00008, 0.00003, 0.00001 }, // 9200 Da
    { 0.00574, 0.02839, 0.07142, 0.12156, 0.15776, 0.16594, 0.14893, 0.11553, 0.07964, 0.04948, 0.02803, 0.01461, 0.00708, 0.00320, 0.00136, 0.00054, 0.00021, 0.00007, 0.00003, 0.00001 }, // 9300 Da
    { 0.00540, 0.02694, 0.06838, 0.11806, 0.15541, 0.16533, 0.14999, 0.11788, 0.08212, 0.05146, 0.02942, 0.01552, 0.00761, 0.00349, 0.00151, 0.00061, 0.00023, 0.00009, 0.00003, 0.00001 }, // 9400 Da
    { 0.00513, 0.02591, 0.06642, 0.11532, 0.15314, 0.16517, 0.15078, 0.11938, 0.08416, 0.05331, 0.03076, 0.01632, 0.00801, 0.00367, 0.00158, 0.00064, 0.00025, 0.00009, 0.00003, 0.00001 }, // 9500 Da
    { 0.00485, 0.02467, 0.06391, 0.11264, 0.15086, 0.16402, 0.15147, 0.12131, 0.08605, 0.05500, 0.03219, 0.01735, 0.00868, 0.00405, 0.00177, 0.00073, 0.00029, 0.00011, 0.00004, 0.00001 }, // 9600 Da
    { 0.00447, 0.02310, 0.06080, 0.10843, 0.14742, 0.16304, 0.15223, 0.12368, 0.08913, 0.05786, 0.03421, 0.01859, 0.00936, 0.00440, 0.00194, 0.00081, 0.00032, 0.00012, 0.00004, 0.00001 }, // 9700 Da
    { 0.00415, 0.02174, 0.05792, 0.10467, 0.14429, 0.16191, 0.15286, 0.12581, 0.09187, 0.06038, 0.03611, 0.01990, 0.01013, 0.00481, 0.00214, 0.00090, 0.00035, 0.00013, 0.00005, 0.00002 }, // 9800 Da
    { 0.00392, 0.02082, 0.05622, 0.10278, 0.14281, 0.16073, 0.15336, 0.12720, 0.09323, 0.06153, 0.03705, 0.02055, 0.01057, 0.00508, 0.00229, 0.00097, 0.00039, 0.00015, 0.00005, 0.00002 }, // 9900 Da
    { 0.00372, 0.01993, 0.05422, 0.09993, 0.14025, 0.15977, 0.15412, 0.12860, 0.09531, 0.06357, 0.03861, 0.02157, 0.01117, 0.00540, 0.00245, 0.00105, 0.00042, 0.00016, 0.00006, 0.00002 }, // 10000 Da
  };

  double IsotopicDist::sfIsoDist90[96][20] =
  {
    { 0.77310, 0.22965, 0.04533, 0.00683, 0.00085, 0.00009, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 500 Da
    { 0.73558, 0.25131, 0.05667, 0.00957, 0.00132, 0.00016, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 600 Da
    { 0.69794, 0.27335, 0.06899, 0.01293, 0.00198, 0.00026, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 700 Da
    { 0.66102, 0.29216, 0.08172, 0.01689, 0.00283, 0.00041, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 800 Da
    { 0.62716, 0.30778, 0.09456, 0.02134, 0.00388, 0.00061, 0.00008, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 900 Da
    { 0.59350, 0.32034, 0.10732, 0.02624, 0.00518, 0.00087, 0.00013, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1000 Da
    { 0.56287, 0.33062, 0.11989, 0.03160, 0.00670, 0.00121, 0.00019, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1100 Da
    { 0.53316, 0.33892, 0.13239, 0.03740, 0.00847, 0.00162, 0.00027, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1200 Da
    { 0.50527, 0.34532, 0.14460, 0.04356, 0.01049, 0.00213, 0.00038, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1300 Da
    { 0.47917, 0.34958, 0.15573, 0.04979, 0.01269, 0.00272, 0.00051, 0.00009, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1400 Da
    { 0.45392, 0.35263, 0.16705, 0.05656, 0.01523, 0.00345, 0.00068, 0.00012, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1500 Da
    { 0.43039, 0.35411, 0.17735, 0.06336, 0.01796, 0.00427, 0.00088, 0.00016, 0.00003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1600 Da
    { 0.40780, 0.35447, 0.18756, 0.07050, 0.02098, 0.00523, 0.00114, 0.00022, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1700 Da
    { 0.38616, 0.35382, 0.19689, 0.07781, 0.02426, 0.00634, 0.00144, 0.00029, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1800 Da
    { 0.36654, 0.35229, 0.20573, 0.08512, 0.02776, 0.00757, 0.00179, 0.00037, 0.00007, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1900 Da
    { 0.34703, 0.35027, 0.21378, 0.09240, 0.03143, 0.00893, 0.00219, 0.00048, 0.00009, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2000 Da
    { 0.32870, 0.34770, 0.22124, 0.09984, 0.03540, 0.01046, 0.00267, 0.00060, 0.00012, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2100 Da
    { 0.31169, 0.34477, 0.22788, 0.10714, 0.03948, 0.01212, 0.00321, 0.00075, 0.00016, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2200 Da
    { 0.29530, 0.34130, 0.23416, 0.11463, 0.04393, 0.01399, 0.00384, 0.00093, 0.00020, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2300 Da
    { 0.27941, 0.33742, 0.23996, 0.12191, 0.04848, 0.01599, 0.00455, 0.00114, 0.00026, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2400 Da
    { 0.26525, 0.33321, 0.24470, 0.12903, 0.05308, 0.01813, 0.00533, 0.00138, 0.00032, 0.00007, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2500 Da
    { 0.25099, 0.32838, 0.24881, 0.13594, 0.05789, 0.02041, 0.00619, 0.00166, 0.00040, 0.00009, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2600 Da
    { 0.23777, 0.32328, 0.25240, 0.14286, 0.06290, 0.02292, 0.00718, 0.00199, 0.00049, 0.00011, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2700 Da
    { 0.22572, 0.31784, 0.25507, 0.14900, 0.06766, 0.02541, 0.00820, 0.00233, 0.00060, 0.00014, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2800 Da
    { 0.21370, 0.31208, 0.25776, 0.15585, 0.07317, 0.02836, 0.00941, 0.00276, 0.00072, 0.00017, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2900 Da
    { 0.20228, 0.30607, 0.25949, 0.16180, 0.07827, 0.03125, 0.01069, 0.00322, 0.00087, 0.00021, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3000 Da
    { 0.19213, 0.29992, 0.26071, 0.16766, 0.08352, 0.03432, 0.01208, 0.00374, 0.00104, 0.00026, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3100 Da
    { 0.18226, 0.29348, 0.26126, 0.17261, 0.08845, 0.03730, 0.01350, 0.00429, 0.00122, 0.00032, 0.00008, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3200 Da
    { 0.17174, 0.28634, 0.26140, 0.17767, 0.09361, 0.04061, 0.01508, 0.00492, 0.00144, 0.00038, 0.00009, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3300 Da
    { 0.16345, 0.28011, 0.26115, 0.18231, 0.09847, 0.04378, 0.01668, 0.00557, 0.00167, 0.00045, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3400 Da
    { 0.15492, 0.27332, 0.26065, 0.18754, 0.10435, 0.04773, 0.01866, 0.00640, 0.00197, 0.00055, 0.00014, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3500 Da
    { 0.14655, 0.26625, 0.25989, 0.19154, 0.10928, 0.05124, 0.02055, 0.00723, 0.00227, 0.00065, 0.00017, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3600 Da
    { 0.13905, 0.25942, 0.25907, 0.19498, 0.11381, 0.05465, 0.02241, 0.00806, 0.00259, 0.00076, 0.00020, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3700 Da
    { 0.13125, 0.25230, 0.25803, 0.19803, 0.11815, 0.05786, 0.02419, 0.00886, 0.00291, 0.00087, 0.00024, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3800 Da
    { 0.12519, 0.24635, 0.25677, 0.20142, 0.12321, 0.06185, 0.02650, 0.00996, 0.00333, 0.00101, 0.00028, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3900 Da
    { 0.11861, 0.23921, 0.25546, 0.20423, 0.12770, 0.06551, 0.02870, 0.01101, 0.00377, 0.00117, 0.00034, 0.00009, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4000 Da
    { 0.11225, 0.23231, 0.25399, 0.20624, 0.13150, 0.06877, 0.03068, 0.01200, 0.00418, 0.00132, 0.00038, 0.00010, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4100 Da
    { 0.10659, 0.22566, 0.25221, 0.20882, 0.13636, 0.07301, 0.03330, 0.01334, 0.00477, 0.00154, 0.00046, 0.00013, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4200 Da
    { 0.10098, 0.21920, 0.25031, 0.21077, 0.14070, 0.07698, 0.03589, 0.01464, 0.00533, 0.00176, 0.00053, 0.00015, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4300 Da
    { 0.09556, 0.21244, 0.24814, 0.21242, 0.14499, 0.08105, 0.03856, 0.01606, 0.00597, 0.00201, 0.00062, 0.00018, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4400 Da
    { 0.09091, 0.20639, 0.24582, 0.21373, 0.14858, 0.08460, 0.04097, 0.01739, 0.00657, 0.00225, 0.00071, 0.00020, 0.00006, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4500 Da
    { 0.08640, 0.20003, 0.24321, 0.21512, 0.15307, 0.08913, 0.04416, 0.01912, 0.00738, 0.00259, 0.00083, 0.00025, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4600 Da
    { 0.08209, 0.19402, 0.24083, 0.21563, 0.15596, 0.09234, 0.04652, 0.02054, 0.00809, 0.00288, 0.00094, 0.00028, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4700 Da
    { 0.07694, 0.18661, 0.23738, 0.21615, 0.15960, 0.09632, 0.04951, 0.02224, 0.00891, 0.00323, 0.00107, 0.00033, 0.00009, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4800 Da
    { 0.07311, 0.18094, 0.23439, 0.21648, 0.16329, 0.10070, 0.05281, 0.02420, 0.00987, 0.00365, 0.00123, 0.00038, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4900 Da
    { 0.06907, 0.17474, 0.23116, 0.21629, 0.16536, 0.10350, 0.05514, 0.02567, 0.01064, 0.00398, 0.00137, 0.00043, 0.00013, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5000 Da
    { 0.06628, 0.16990, 0.22794, 0.21609, 0.16847, 0.10736, 0.05813, 0.02750, 0.01159, 0.00441, 0.00153, 0.00049, 0.00015, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5100 Da
    { 0.06310, 0.16500, 0.22493, 0.21577, 0.17149, 0.11124, 0.06124, 0.02948, 0.01264, 0.00489, 0.00174, 0.00057, 0.00017, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5200 Da
    { 0.05939, 0.15875, 0.22108, 0.21539, 0.17365, 0.11466, 0.06424, 0.03140, 0.01368, 0.00538, 0.00194, 0.00064, 0.00020, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5300 Da
    { 0.05711, 0.15451, 0.21801, 0.21482, 0.17665, 0.11902, 0.06805, 0.03400, 0.01510, 0.00606, 0.00222, 0.00075, 0.00024, 0.00007, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5400 Da
    { 0.05321, 0.14818, 0.21407, 0.21427, 0.17838, 0.12199, 0.07074, 0.03581, 0.01612, 0.00655, 0.00244, 0.00084, 0.00027, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5500 Da
    { 0.05048, 0.14273, 0.20979, 0.21366, 0.18047, 0.12560, 0.07419, 0.03819, 0.01751, 0.00722, 0.00273, 0.00095, 0.00031, 0.00009, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5600 Da
    { 0.04823, 0.13884, 0.20685, 0.21294, 0.18234, 0.12896, 0.07744, 0.04064, 0.01898, 0.00798, 0.00306, 0.00108, 0.00035, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5700 Da
    { 0.04582, 0.13359, 0.20244, 0.21199, 0.18363, 0.13183, 0.08026, 0.04255, 0.02013, 0.00857, 0.00333, 0.00119, 0.00040, 0.00012, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5800 Da
    { 0.04366, 0.12946, 0.19928, 0.21121, 0.18497, 0.13529, 0.08377, 0.04511, 0.02161, 0.00935, 0.00369, 0.00135, 0.00046, 0.00014, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5900 Da
    { 0.04112, 0.12428, 0.19485, 0.21003, 0.18605, 0.13818, 0.08703, 0.04782, 0.02334, 0.01029, 0.00414, 0.00153, 0.00053, 0.00017, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6000 Da
    { 0.03970, 0.12157, 0.19166, 0.20924, 0.18699, 0.14088, 0.09001, 0.05007, 0.02477, 0.01102, 0.00448, 0.00168, 0.00059, 0.00019, 0.00006, 0.00002, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6100 Da
    { 0.03619, 0.11366, 0.18519, 0.20757, 0.18763, 0.14370, 0.09325, 0.05265, 0.02641, 0.01195, 0.00494, 0.00188, 0.00066, 0.00022, 0.00007, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6200 Da
    { 0.03416, 0.10936, 0.18093, 0.20596, 0.18818, 0.14644, 0.09635, 0.05519, 0.02808, 0.01289, 0.00539, 0.00208, 0.00074, 0.00025, 0.00008, 0.00002, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6300 Da
    { 0.03320, 0.10688, 0.17804, 0.20462, 0.18876, 0.14925, 0.09989, 0.05822, 0.03011, 0.01408, 0.00599, 0.00235, 0.00086, 0.00029, 0.00009, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6400 Da
    { 0.03170, 0.10324, 0.17439, 0.20300, 0.18881, 0.15122, 0.10250, 0.06055, 0.03172, 0.01496, 0.00643, 0.00255, 0.00094, 0.00032, 0.00010, 0.00003, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6500 Da
    { 0.02945, 0.09843, 0.16963, 0.20099, 0.18880, 0.15359, 0.10546, 0.06307, 0.03355, 0.01605, 0.00699, 0.00281, 0.00104, 0.00036, 0.00012, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6600 Da
    { 0.02805, 0.09499, 0.16561, 0.19892, 0.18868, 0.15550, 0.10838, 0.06565, 0.03529, 0.01713, 0.00761, 0.00310, 0.00117, 0.00041, 0.00014, 0.00004, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6700 Da
    { 0.02723, 0.09268, 0.16308, 0.19744, 0.18835, 0.15645, 0.11009, 0.06740, 0.03661, 0.01786, 0.00796, 0.00327, 0.00125, 0.00045, 0.00015, 0.00005, 0.00001, 0.00000, 0.00000, 0.00000 }, // 6800 Da
    { 0.02560, 0.08897, 0.15928, 0.19549, 0.18806, 0.15950, 0.11463, 0.07163, 0.03970, 0.01980, 0.00899, 0.00376, 0.00146, 0.00053, 0.00018, 0.00006, 0.00002, 0.00001, 0.00000, 0.00000 }, // 6900 Da
    { 0.02399, 0.08467, 0.15402, 0.19268, 0.18788, 0.15970, 0.11516, 0.07231, 0.04035, 0.02032, 0.00932, 0.00393, 0.00153, 0.00056, 0.00019, 0.00006, 0.00002, 0.00001, 0.00000, 0.00000 }, // 7000 Da
    { 0.02322, 0.08250, 0.15147, 0.19105, 0.18740, 0.16193, 0.11868, 0.07573, 0.04286, 0.02185, 0.01017, 0.00434, 0.00171, 0.00063, 0.00022, 0.00007, 0.00002, 0.00001, 0.00000, 0.00000 }, // 7100 Da
    { 0.02213, 0.07958, 0.14785, 0.18860, 0.18722, 0.16368, 0.12229, 0.07946, 0.04570, 0.02367, 0.01119, 0.00488, 0.00197, 0.00074, 0.00026, 0.00009, 0.00003, 0.00001, 0.00000, 0.00000 }, // 7200 Da
    { 0.02032, 0.07511, 0.14291, 0.18580, 0.18665, 0.16521, 0.12519, 0.08231, 0.04800, 0.02524, 0.01210, 0.00533, 0.00218, 0.00083, 0.00030, 0.00010, 0.00003, 0.00001, 0.00000, 0.00000 }, // 7300 Da
    { 0.01945, 0.07255, 0.13913, 0.18310, 0.18631, 0.16540, 0.12575, 0.08307, 0.04870, 0.02572, 0.01240, 0.00552, 0.00228, 0.00088, 0.00032, 0.00011, 0.00003, 0.00001, 0.00000, 0.00000 }, // 7400 Da
    { 0.01844, 0.06959, 0.13558, 0.18050, 0.18562, 0.16617, 0.12779, 0.08537, 0.05060, 0.02705, 0.01317, 0.00590, 0.00245, 0.00095, 0.00035, 0.00012, 0.00004, 0.00001, 0.00000, 0.00000 }, // 7500 Da
    { 0.01812, 0.06861, 0.13384, 0.17912, 0.18511, 0.16702, 0.12995, 0.08812, 0.05294, 0.02866, 0.01415, 0.00643, 0.00271, 0.00106, 0.00039, 0.00014, 0.00005, 0.00001, 0.00000, 0.00000 }, // 7600 Da
    { 0.01749, 0.06665, 0.13132, 0.17719, 0.18476, 0.16769, 0.13163, 0.08987, 0.05459, 0.02990, 0.01493, 0.00687, 0.00291, 0.00115, 0.00043, 0.00015, 0.00005, 0.00002, 0.00000, 0.00000 }, // 7700 Da
    { 0.01635, 0.06348, 0.12735, 0.17458, 0.18380, 0.16866, 0.13510, 0.09400, 0.05806, 0.03227, 0.01630, 0.00757, 0.00326, 0.00131, 0.00050, 0.00018, 0.00006, 0.00002, 0.00001, 0.00000 }, // 7800 Da
    { 0.01472, 0.05864, 0.12055, 0.16946, 0.18308, 0.16878, 0.13591, 0.09524, 0.05911, 0.03304, 0.01680, 0.00786, 0.00341, 0.00138, 0.00053, 0.00019, 0.00006, 0.00002, 0.00001, 0.00000 }, // 7900 Da
    { 0.01438, 0.05762, 0.11880, 0.16819, 0.18206, 0.16973, 0.13875, 0.09881, 0.06236, 0.03538, 0.01826, 0.00867, 0.00384, 0.00158, 0.00061, 0.00022, 0.00008, 0.00002, 0.00001, 0.00000 }, // 8000 Da
    { 0.01359, 0.05526, 0.11507, 0.16502, 0.18133, 0.16941, 0.14026, 0.10069, 0.06404, 0.03668, 0.01913, 0.00917, 0.00408, 0.00169, 0.00066, 0.00024, 0.00008, 0.00003, 0.00001, 0.00000 }, // 8100 Da
    { 0.01267, 0.05245, 0.11156, 0.16174, 0.18023, 0.16926, 0.14090, 0.10185, 0.06528, 0.03768, 0.01981, 0.00958, 0.00430, 0.00180, 0.00070, 0.00026, 0.00009, 0.00003, 0.00001, 0.00000 }, // 8200 Da
    { 0.01239, 0.05142, 0.10968, 0.15974, 0.17891, 0.16963, 0.14415, 0.10625, 0.06931, 0.04068, 0.02172, 0.01066, 0.00484, 0.00205, 0.00082, 0.00031, 0.00011, 0.00004, 0.00001, 0.00000 }, // 8300 Da
    { 0.01145, 0.04857, 0.10559, 0.15668, 0.17782, 0.16943, 0.14450, 0.10687, 0.07006, 0.04137, 0.02219, 0.01096, 0.00503, 0.00215, 0.00086, 0.00033, 0.00012, 0.00004, 0.00001, 0.00000 }, // 8400 Da
    { 0.01089, 0.04665, 0.10239, 0.15330, 0.17648, 0.16911, 0.14618, 0.10964, 0.07285, 0.04349, 0.02362, 0.01179, 0.00545, 0.00235, 0.00095, 0.00036, 0.00013, 0.00004, 0.00001, 0.00000 }, // 8500 Da
    { 0.01053, 0.04511, 0.10012, 0.15136, 0.17488, 0.16909, 0.14813, 0.11309, 0.07657, 0.04654, 0.02574, 0.01308, 0.00615, 0.00270, 0.00111, 0.00043, 0.00016, 0.00005, 0.00002, 0.00001 }, // 8600 Da
    { 0.00994, 0.04339, 0.09712, 0.14840, 0.17395, 0.16864, 0.14913, 0.11489, 0.07831, 0.04799, 0.02678, 0.01375, 0.00654, 0.00290, 0.00121, 0.00047, 0.00018, 0.00006, 0.00002, 0.00001 }, // 8700 Da
    { 0.00909, 0.04044, 0.09214, 0.14317, 0.17091, 0.16846, 0.14980, 0.11626, 0.07984, 0.04928, 0.02767, 0.01428, 0.00682, 0.00304, 0.00127, 0.00050, 0.00019, 0.00007, 0.00002, 0.00001 }, // 8800 Da
    { 0.00893, 0.03988, 0.09136, 0.14281, 0.17113, 0.16817, 0.15073, 0.11808, 0.08198, 0.05118, 0.02909, 0.01519, 0.00735, 0.00332, 0.00140, 0.00056, 0.00021, 0.00008, 0.00003, 0.00001 }, // 8900 Da
    { 0.00783, 0.03589, 0.08440, 0.13626, 0.16753, 0.16795, 0.15294, 0.12197, 0.08609, 0.05461, 0.03149, 0.01666, 0.00817, 0.00374, 0.00160, 0.00065, 0.00025, 0.00009, 0.00003, 0.00001 }, // 9000 Da
    { 0.00806, 0.03662, 0.08538, 0.13599, 0.16710, 0.16774, 0.15292, 0.12278, 0.08722, 0.05570, 0.03236, 0.01726, 0.00853, 0.00393, 0.00169, 0.00069, 0.00026, 0.00010, 0.00003, 0.00001 }, // 9100 Da
    { 0.00801, 0.03658, 0.08542, 0.13623, 0.16684, 0.16736, 0.15407, 0.12602, 0.09119, 0.05927, 0.03503, 0.01901, 0.00955, 0.00447, 0.00196, 0.00081, 0.00031, 0.00012, 0.00004, 0.00001 }, // 9200 Da
    { 0.00715, 0.03344, 0.08011, 0.13097, 0.16399, 0.16713, 0.15388, 0.12597, 0.09127, 0.05936, 0.03511, 0.01907, 0.00958, 0.00449, 0.00197, 0.00081, 0.00032, 0.00012, 0.00004, 0.00001 }, // 9300 Da
    { 0.00685, 0.03233, 0.07807, 0.12817, 0.16144, 0.16657, 0.15473, 0.12861, 0.09431, 0.06228, 0.03737, 0.02056, 0.01046, 0.00496, 0.00221, 0.00092, 0.00036, 0.00014, 0.00005, 0.00002 }, // 9400 Da
    { 0.00643, 0.03059, 0.07464, 0.12431, 0.15944, 0.16588, 0.15446, 0.12865, 0.09482, 0.06283, 0.03787, 0.02097, 0.01075, 0.00514, 0.00230, 0.00097, 0.00039, 0.00015, 0.00005, 0.00002 }, // 9500 Da
    { 0.00621, 0.02972, 0.07304, 0.12252, 0.15765, 0.16521, 0.15510, 0.13151, 0.09844, 0.06618, 0.04044, 0.02268, 0.01178, 0.00569, 0.00257, 0.00110, 0.00044, 0.00017, 0.00006, 0.00002 }, // 9600 Da
    { 0.00586, 0.02847, 0.07083, 0.12007, 0.15580, 0.16496, 0.15448, 0.12905, 0.09568, 0.06381, 0.03873, 0.02161, 0.01117, 0.00538, 0.00243, 0.00104, 0.00042, 0.00016, 0.00006, 0.00002 }, // 9700 Da
    { 0.00561, 0.02762, 0.06942, 0.11785, 0.15357, 0.16426, 0.15531, 0.13424, 0.10257, 0.07037, 0.04383, 0.02505, 0.01324, 0.00652, 0.00301, 0.00131, 0.00054, 0.00021, 0.00008, 0.00003 }, // 9800 Da
    { 0.00584, 0.02835, 0.07029, 0.11901, 0.15512, 0.16417, 0.15522, 0.13448, 0.10305, 0.07092, 0.04437, 0.02548, 0.01354, 0.00671, 0.00311, 0.00136, 0.00056, 0.00022, 0.00008, 0.00003 }, // 9900 Da
    { 0.00480, 0.02427, 0.06273, 0.11031, 0.14882, 0.16386, 0.15515, 0.13462, 0.10370, 0.07181, 0.04522, 0.02616, 0.01401, 0.00700, 0.00327, 0.00144, 0.00060, 0.00024, 0.00009, 0.00003 }, // 10000 Da
  };

  double IsotopicDist::sfIsoMass10[96][20] =
  {
    { 0.00000, 1.00253, 2.00030, 3.00121, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 500 Da
    { 0.00000, 1.00261, 2.00130, 3.00216, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 600 Da
    { 0.00000, 1.00267, 2.00201, 3.00286, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 700 Da
    { 0.00000, 1.00270, 2.00247, 3.00332, 4.00439, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 800 Da
    { 0.00000, 1.00273, 2.00273, 3.00368, 4.00482, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 900 Da
    { 0.00000, 1.00266, 2.00205, 3.00269, 4.00289, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1000 Da
    { 0.00000, 1.00271, 2.00243, 3.00307, 4.00352, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1100 Da
    { 0.00000, 1.00275, 2.00381, 3.00494, 4.00630, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1200 Da
    { 0.00000, 1.00274, 2.00383, 3.00510, 4.00660, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1300 Da
    { 0.00000, 1.00275, 2.00329, 3.00411, 4.00493, 5.00594, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1400 Da
    { 0.00000, 1.00274, 2.00367, 3.00453, 4.00546, 5.00645, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1500 Da
    { 0.00000, 1.00274, 2.00374, 3.00470, 4.00570, 5.00675, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1600 Da
    { 0.00000, 1.00278, 2.00396, 3.00507, 4.00616, 5.00736, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1700 Da
    { 0.00000, 1.00276, 2.00414, 3.00529, 4.00644, 5.00777, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1800 Da
    { 0.00000, 1.00274, 2.00379, 3.00479, 4.00562, 5.00648, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1900 Da
    { 0.00000, 1.00278, 2.00438, 3.00567, 4.00693, 5.00835, 6.00960, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2000 Da
    { 0.00000, 1.00276, 2.00415, 3.00532, 4.00643, 5.00767, 6.00878, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2100 Da
    { 0.00000, 1.00277, 2.00450, 3.00591, 4.00729, 5.00878, 6.01014, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2200 Da
    { 0.00000, 1.00280, 2.00459, 3.00608, 4.00750, 5.00899, 6.01045, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2300 Da
    { 0.00000, 1.00278, 2.00463, 3.00617, 4.00765, 5.00917, 6.01065, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2400 Da
    { 0.00000, 1.00277, 2.00428, 3.00553, 4.00668, 5.00785, 6.00887, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2500 Da
    { 0.00000, 1.00278, 2.00467, 3.00629, 4.00780, 5.00936, 6.01106, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2600 Da
    { 0.00000, 1.00275, 2.00445, 3.00581, 4.00706, 5.00827, 6.00955, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2700 Da
    { 0.00000, 1.00279, 2.00470, 3.00621, 4.00757, 5.00887, 6.01024, 7.01119, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2800 Da
    { 0.00000, 1.00280, 2.00464, 3.00623, 4.00769, 5.00916, 6.01063, 7.01217, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2900 Da
    { 0.00000, 1.00278, 2.00474, 3.00642, 4.00793, 5.00944, 6.01107, 7.01253, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3000 Da
    { 0.00000, 1.00278, 2.00482, 3.00648, 4.00797, 5.00938, 6.01089, 7.01203, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3100 Da
    { 0.00000, 1.00280, 2.00487, 3.00657, 4.00810, 5.00954, 6.01110, 7.01227, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3200 Da
    { 0.00000, 1.00282, 2.00479, 3.00647, 4.00798, 5.00943, 6.01099, 7.01232, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3300 Da
    { 0.00000, 1.00281, 2.00493, 3.00675, 4.00837, 5.00991, 6.01149, 7.01287, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3400 Da
    { 0.00000, 1.00280, 2.00473, 3.00631, 4.00769, 5.00896, 6.01029, 7.01160, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3500 Da
    { 0.00000, 1.00277, 2.00470, 3.00624, 4.00756, 5.00875, 6.00999, 7.01118, 4.00348, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3600 Da
    { 0.00000, 1.00279, 2.00489, 3.00662, 4.00818, 5.00963, 6.01116, 7.01252, 8.01429, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3700 Da
    { 0.00000, 1.00281, 2.00501, 3.00689, 4.00860, 5.01021, 6.01188, 7.01342, 8.01529, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3800 Da
    { 0.00000, 1.00281, 2.00498, 3.00677, 4.00836, 5.00980, 6.01128, 7.01277, 8.01403, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3900 Da
    { 0.00000, 1.00280, 2.00498, 3.00679, 4.00839, 5.00986, 6.01133, 7.01287, 8.01402, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4000 Da
    { 0.00000, 1.00280, 2.00500, 3.00689, 4.00859, 5.01018, 6.01179, 7.01342, 8.01462, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4100 Da
    { 0.00000, 1.00281, 2.00514, 3.00717, 4.00901, 5.01079, 6.01251, 7.01426, 8.01595, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4200 Da
    { 0.00000, 1.00282, 2.00504, 3.00693, 4.00861, 5.01018, 6.01171, 7.01333, 8.01480, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4300 Da
    { 0.00000, 1.00281, 2.00514, 3.00715, 4.00894, 5.01058, 6.01219, 7.01385, 8.01543, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4400 Da
    { 0.00000, 1.00278, 2.00508, 3.00710, 4.00888, 5.01054, 6.01214, 7.01381, 8.01538, 4.50685, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4500 Da
    { 0.00000, 1.00282, 2.00512, 3.00702, 4.00873, 5.01034, 6.01194, 7.01362, 8.01515, 9.01684, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4600 Da
    { 0.00000, 1.00282, 2.00511, 3.00711, 4.00890, 5.01057, 6.01221, 7.01392, 8.01550, 9.01712, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4700 Da
    { 0.00000, 1.00279, 2.00509, 3.00713, 4.00898, 5.01067, 6.01233, 7.01404, 8.01579, 9.01739, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4800 Da
    { 0.00000, 1.00280, 2.00511, 3.00704, 4.00876, 5.01036, 6.01194, 7.01354, 8.01514, 9.01667, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4900 Da
    { 0.00000, 1.00281, 2.00516, 3.00721, 4.00906, 5.01074, 6.01240, 7.01402, 8.01573, 9.01716, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5000 Da
    { 0.00000, 1.00279, 2.00508, 3.00703, 4.00873, 5.01029, 6.01178, 7.01326, 8.01482, 9.01614, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5100 Da
    { 0.00000, 1.00281, 2.00514, 3.00717, 4.00898, 5.01063, 6.01223, 7.01384, 8.01549, 9.01718, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5200 Da
    { 0.00000, 1.00280, 2.00522, 3.00736, 4.00928, 5.01108, 6.01285, 7.01459, 8.01640, 9.01804, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5300 Da
    { 0.00000, 1.00281, 2.00520, 3.00726, 4.00910, 5.01076, 6.01238, 7.01392, 8.01556, 9.01718, 10.01365, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5400 Da
    { 0.00000, 1.00282, 2.00531, 3.00754, 4.00960, 5.01159, 6.01354, 7.01545, 8.01748, 9.01942, 5.00870, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5500 Da
    { 0.00000, 1.00281, 2.00524, 3.00731, 4.00917, 5.01086, 6.01251, 7.01414, 8.01577, 9.01757, 10.01910, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5600 Da
    { 0.00000, 1.00280, 2.00524, 3.00735, 4.00929, 5.01109, 6.01287, 7.01459, 8.01636, 9.01820, 10.01995, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5700 Da
    { 0.00000, 1.00280, 2.00524, 3.00737, 4.00928, 5.01103, 6.01274, 7.01436, 8.01605, 9.01778, 10.01955, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5800 Da
    { 0.00000, 1.00282, 2.00528, 3.00749, 4.00950, 5.01138, 6.01321, 7.01499, 8.01682, 9.01878, 10.02039, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5900 Da
    { 0.00000, 1.00282, 2.00531, 3.00756, 4.00961, 5.01154, 6.01342, 7.01527, 8.01718, 9.01912, 10.02077, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6000 Da
    { 0.00000, 1.00280, 2.00525, 3.00746, 4.00946, 5.01129, 6.01308, 7.01483, 8.01664, 9.01861, 10.02028, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6100 Da
    { 0.00000, 1.00280, 2.00524, 3.00740, 4.00938, 5.01120, 6.01301, 7.01475, 8.01655, 9.01854, 10.02013, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6200 Da
    { 0.00000, 1.00282, 2.00528, 3.00750, 4.00950, 5.01135, 6.01315, 7.01488, 8.01662, 9.01853, 10.02003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6300 Da
    { 0.00000, 1.00279, 2.00525, 3.00743, 4.00943, 5.01129, 6.01311, 7.01488, 8.01654, 9.01825, 10.01988, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6400 Da
    { 0.00000, 1.00279, 2.00524, 3.00737, 4.00931, 5.01108, 6.01280, 7.01447, 8.01617, 9.01779, 10.01907, 11.00936, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6500 Da
    { 0.00000, 1.00280, 2.00527, 3.00749, 4.00950, 5.01135, 6.01318, 7.01497, 8.01683, 9.01873, 10.02009, 5.50804, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6600 Da
    { 0.00000, 1.00281, 2.00527, 3.00747, 4.00949, 5.01135, 6.01317, 7.01496, 8.01673, 9.01854, 10.02004, 11.02222, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6700 Da
    { 0.00000, 1.00282, 2.00532, 3.00754, 4.00962, 5.01155, 6.01343, 7.01528, 8.01711, 9.01891, 10.02061, 11.02269, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6800 Da
    { 0.00000, 1.00283, 2.00535, 3.00760, 4.00965, 5.01152, 6.01337, 7.01516, 8.01691, 9.01857, 10.02036, 11.02217, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6900 Da
    { 0.00000, 1.00280, 2.00532, 3.00759, 4.00970, 5.01159, 6.01345, 7.01529, 8.01697, 9.01873, 10.02051, 11.02221, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7000 Da
    { 0.00000, 1.00281, 2.00534, 3.00761, 4.00970, 5.01164, 6.01352, 7.01537, 8.01727, 9.01895, 10.02093, 11.02258, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7100 Da
    { 0.00000, 1.00281, 2.00531, 3.00755, 4.00956, 5.01141, 6.01326, 7.01506, 8.01681, 9.01860, 10.02041, 11.02201, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7200 Da
    { 0.00000, 1.00282, 2.00535, 3.00766, 4.00979, 5.01175, 6.01358, 7.01533, 8.01704, 9.01871, 10.02054, 11.02231, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7300 Da
    { 0.00000, 1.00281, 2.00529, 3.00755, 4.00960, 5.01151, 6.01338, 7.01514, 8.01680, 9.01843, 10.02032, 11.02177, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7400 Da
    { 0.00000, 1.00280, 2.00525, 3.00741, 4.00939, 5.01118, 6.01292, 7.01453, 8.01603, 9.01764, 10.01928, 11.02064, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7500 Da
    { 0.00000, 1.00280, 2.00531, 3.00758, 4.00963, 5.01153, 6.01336, 7.01506, 8.01670, 9.01830, 10.02000, 11.02158, 12.01554, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7600 Da
    { 0.00000, 1.00279, 2.00532, 3.00756, 4.00960, 5.01147, 6.01332, 7.01509, 8.01677, 9.01839, 10.02022, 11.02168, 12.02217, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7700 Da
    { 0.00000, 1.00281, 2.00532, 3.00766, 4.00976, 5.01172, 6.01361, 7.01546, 8.01718, 9.01882, 10.02071, 11.02250, 12.02389, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7800 Da
    { 0.00000, 1.00282, 2.00532, 3.00763, 4.00978, 5.01180, 6.01369, 7.01554, 8.01723, 9.01889, 10.02076, 11.02258, 12.02410, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7900 Da
    { 0.00000, 1.00281, 2.00532, 3.00764, 4.00976, 5.01171, 6.01364, 7.01549, 8.01719, 9.01880, 10.02069, 11.02242, 12.02397, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8000 Da
    { 0.00000, 1.00281, 2.00530, 3.00758, 4.00968, 5.01162, 6.01348, 7.01525, 8.01691, 9.01855, 10.02034, 11.02202, 12.02371, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8100 Da
    { 0.00000, 1.00281, 2.00544, 3.00793, 4.01025, 5.01245, 6.01458, 7.01670, 8.01872, 9.02074, 10.02283, 11.02498, 12.02696, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8200 Da
    { 0.00000, 1.00281, 2.00539, 3.00777, 4.00999, 5.01206, 6.01405, 7.01600, 8.01786, 9.01961, 10.02152, 11.02344, 12.02532, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8300 Da
    { 0.00000, 1.00281, 2.00535, 3.00765, 4.00976, 5.01165, 6.01347, 7.01520, 8.01688, 9.01852, 10.02020, 11.02189, 12.02352, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8400 Da
    { 0.00000, 1.00280, 2.00541, 3.00783, 4.01010, 5.01218, 6.01423, 7.01623, 8.01819, 9.02002, 10.02204, 11.02407, 12.02591, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8500 Da
    { 0.00000, 1.00282, 2.00542, 3.00780, 4.01000, 5.01202, 6.01395, 7.01586, 8.01768, 9.01944, 10.02118, 11.02294, 12.02468, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8600 Da
    { 0.00000, 1.00283, 2.00544, 3.00787, 4.01017, 5.01237, 6.01445, 7.01649, 8.01845, 9.02027, 10.02219, 11.02427, 12.02641, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8700 Da
    { 0.00000, 1.00282, 2.00547, 3.00795, 4.01030, 5.01248, 6.01455, 7.01662, 8.01859, 9.02045, 10.02243, 11.02451, 12.02672, 13.02800, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8800 Da
    { 0.00000, 1.00281, 2.00542, 3.00774, 4.00993, 5.01193, 6.01385, 7.01573, 8.01745, 9.01918, 10.02088, 11.02273, 12.02439, 13.02537, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8900 Da
    { 0.00000, 1.00280, 2.00541, 3.00778, 4.00998, 5.01200, 6.01395, 7.01586, 8.01766, 9.01944, 10.02127, 11.02321, 12.02494, 13.02605, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9000 Da
    { 0.00000, 1.00282, 2.00542, 3.00781, 4.01006, 5.01212, 6.01407, 7.01597, 8.01774, 9.01952, 10.02118, 11.02292, 12.02470, 13.02648, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9100 Da
    { 0.00000, 1.00280, 2.00541, 3.00768, 4.00989, 5.01197, 6.01390, 7.01576, 8.01747, 9.01919, 10.02084, 11.02259, 12.02426, 13.02595, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9200 Da
    { 0.00000, 1.00280, 2.00541, 3.00782, 4.01011, 5.01224, 6.01426, 7.01624, 8.01814, 9.02003, 10.02194, 11.02397, 12.02583, 13.02782, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9300 Da
    { 0.00000, 1.00281, 2.00543, 3.00780, 4.01000, 5.01203, 6.01394, 7.01579, 8.01753, 9.01923, 10.02089, 11.02265, 12.02434, 13.02578, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9400 Da
    { 0.00000, 1.00279, 2.00532, 3.00760, 4.00975, 5.01176, 6.01370, 7.01555, 8.01731, 9.01904, 10.02077, 11.02271, 12.02431, 13.02628, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9500 Da
    { 0.00000, 1.00278, 2.00529, 3.00761, 4.00978, 5.01179, 6.01373, 7.01560, 8.01736, 9.01908, 10.02085, 11.02276, 12.02442, 13.02622, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9600 Da
    { 0.00000, 1.00280, 2.00537, 3.00768, 4.00985, 5.01184, 6.01373, 7.01555, 8.01727, 9.01895, 10.02062, 11.02235, 12.02393, 13.02533, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9700 Da
    { 0.00000, 1.00282, 2.00549, 3.00794, 4.01024, 5.01241, 6.01446, 7.01652, 8.01846, 9.02032, 10.02225, 11.02433, 12.02635, 13.02849, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9800 Da
    { 0.00000, 1.00281, 2.00539, 3.00776, 4.01001, 5.01211, 6.01414, 7.01610, 8.01799, 9.01982, 10.02168, 11.02355, 12.02554, 13.02734, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9900 Da
    { 0.00000, 1.00277, 2.00546, 3.00792, 4.01020, 5.01234, 6.01438, 7.01640, 8.01826, 9.02014, 10.02198, 11.02388, 12.02594, 13.02773, 14.03017, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 10000 Da
  };

  double IsotopicDist::sfIsoMass50[96][20] =
  {
    { 0.00000, 1.00276, 2.00510, 3.00740, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 500 Da
    { 0.00000, 1.00280, 2.00518, 3.00763, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 600 Da
    { 0.00000, 1.00280, 2.00527, 3.00772, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 700 Da
    { 0.00000, 1.00284, 2.00534, 3.00782, 4.01012, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 800 Da
    { 0.00000, 1.00282, 2.00517, 3.00759, 4.00987, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 900 Da
    { 0.00000, 1.00283, 2.00531, 3.00779, 4.01015, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1000 Da
    { 0.00000, 1.00283, 2.00532, 3.00782, 4.01034, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1100 Da
    { 0.00000, 1.00284, 2.00545, 3.00799, 4.01055, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1200 Da
    { 0.00000, 1.00285, 2.00530, 3.00779, 4.01030, 5.00857, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1300 Da
    { 0.00000, 1.00286, 2.00540, 3.00795, 4.01052, 5.01304, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1400 Da
    { 0.00000, 1.00285, 2.00545, 3.00801, 4.01058, 5.01312, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1500 Da
    { 0.00000, 1.00283, 2.00545, 3.00801, 4.01059, 5.01311, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1600 Da
    { 0.00000, 1.00284, 2.00484, 3.00653, 4.00827, 5.01017, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1700 Da
    { 0.00000, 1.00286, 2.00484, 3.00656, 4.00833, 5.01022, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1800 Da
    { 0.00000, 1.00284, 2.00489, 3.00668, 4.00850, 5.01044, 6.00641, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1900 Da
    { 0.00000, 1.00285, 2.00512, 3.00704, 4.00893, 5.01093, 6.01281, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2000 Da
    { 0.00000, 1.00284, 2.00519, 3.00729, 4.00925, 5.01132, 6.01329, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2100 Da
    { 0.00000, 1.00285, 2.00511, 3.00708, 4.00901, 5.01111, 6.01299, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2200 Da
    { 0.00000, 1.00287, 2.00516, 3.00719, 4.00917, 5.01129, 6.01328, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2300 Da
    { 0.00000, 1.00287, 2.00521, 3.00728, 4.00930, 5.01146, 6.01372, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2400 Da
    { 0.00000, 1.00287, 2.00514, 3.00721, 4.00923, 5.01134, 6.01356, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2500 Da
    { 0.00000, 1.00286, 2.00528, 3.00743, 4.00951, 5.01164, 6.01391, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2600 Da
    { 0.00000, 1.00288, 2.00522, 3.00737, 4.00944, 5.01159, 6.01365, 7.01365, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2700 Da
    { 0.00000, 1.00286, 2.00525, 3.00744, 4.00954, 5.01171, 6.01386, 7.01628, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2800 Da
    { 0.00000, 1.00287, 2.00534, 3.00758, 4.00972, 5.01192, 6.01407, 7.01648, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2900 Da
    { 0.00000, 1.00285, 2.00530, 3.00754, 4.00969, 5.01190, 6.01403, 7.01648, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3000 Da
    { 0.00000, 1.00285, 2.00516, 3.00717, 4.00903, 5.01079, 6.01278, 7.01453, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3100 Da
    { 0.00000, 1.00286, 2.00530, 3.00759, 4.00976, 5.01195, 6.01417, 7.01632, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3200 Da
    { 0.00000, 1.00287, 2.00538, 3.00771, 4.00993, 5.01215, 6.01440, 7.01667, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3300 Da
    { 0.00000, 1.00287, 2.00537, 3.00766, 4.00989, 5.01205, 6.01434, 7.01644, 8.01523, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3400 Da
    { 0.00000, 1.00286, 2.00538, 3.00774, 4.00999, 5.01220, 6.01450, 7.01663, 8.01749, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3500 Da
    { 0.00000, 1.00285, 2.00534, 3.00761, 4.00977, 5.01191, 6.01409, 7.01642, 8.01777, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3600 Da
    { 0.00000, 1.00287, 2.00542, 3.00782, 4.01006, 5.01220, 6.01438, 7.01668, 8.01891, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3700 Da
    { 0.00000, 1.00286, 2.00537, 3.00766, 4.00978, 5.01177, 6.01381, 7.01593, 8.01801, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3800 Da
    { 0.00000, 1.00288, 2.00539, 3.00778, 4.01003, 5.01216, 6.01435, 7.01665, 8.01895, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3900 Da
    { 0.00000, 1.00287, 2.00539, 3.00774, 4.00993, 5.01211, 6.01439, 7.01684, 8.01892, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4000 Da
    { 0.00000, 1.00288, 2.00546, 3.00793, 4.01029, 5.01261, 6.01488, 7.01740, 8.01948, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4100 Da
    { 0.00000, 1.00287, 2.00540, 3.00774, 4.00998, 5.01205, 6.01415, 7.01630, 8.01853, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4200 Da
    { 0.00000, 1.00287, 2.00539, 3.00770, 4.00983, 5.01189, 6.01395, 7.01616, 8.01822, 9.01270, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4300 Da
    { 0.00000, 1.00287, 2.00552, 3.00800, 4.01039, 5.01273, 6.01503, 7.01752, 8.01976, 9.02142, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4400 Da
    { 0.00000, 1.00287, 2.00539, 3.00770, 4.00988, 5.01198, 6.01406, 7.01629, 8.01826, 9.02078, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4500 Da
    { 0.00000, 1.00288, 2.00541, 3.00776, 4.00995, 5.01207, 6.01416, 7.01638, 8.01848, 9.02120, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4600 Da
    { 0.00000, 1.00287, 2.00545, 3.00785, 4.01007, 5.01221, 6.01434, 7.01655, 8.01880, 9.02132, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4700 Da
    { 0.00000, 1.00287, 2.00547, 3.00792, 4.01024, 5.01242, 6.01459, 7.01681, 8.01910, 9.02146, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4800 Da
    { 0.00000, 1.00286, 2.00540, 3.00776, 4.00999, 5.01213, 6.01426, 7.01642, 8.01875, 9.02093, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4900 Da
    { 0.00000, 1.00288, 2.00550, 3.00798, 4.01032, 5.01253, 6.01474, 7.01694, 8.01928, 9.02165, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5000 Da
    { 0.00000, 1.00286, 2.00546, 3.00788, 4.01020, 5.01238, 6.01452, 7.01669, 8.01904, 9.02140, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5100 Da
    { 0.00000, 1.00287, 2.00548, 3.00795, 4.01035, 5.01259, 6.01481, 7.01700, 8.01940, 9.02189, 10.01797, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5200 Da
    { 0.00000, 1.00286, 2.00550, 3.00798, 4.01035, 5.01262, 6.01486, 7.01708, 8.01942, 9.02193, 10.02013, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5300 Da
    { 0.00000, 1.00288, 2.00544, 3.00789, 4.01017, 5.01231, 6.01439, 7.01643, 8.01850, 9.02054, 10.02283, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5400 Da
    { 0.00000, 1.00288, 2.00552, 3.00802, 4.01039, 5.01265, 6.01491, 7.01711, 8.01951, 9.02195, 10.02452, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5500 Da
    { 0.00000, 1.00287, 2.00554, 3.00805, 4.01045, 5.01274, 6.01501, 7.01725, 8.01970, 9.02220, 10.02474, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5600 Da
    { 0.00000, 1.00286, 2.00553, 3.00799, 4.01036, 5.01259, 6.01484, 7.01706, 8.01940, 9.02192, 10.02433, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5700 Da
    { 0.00000, 1.00287, 2.00551, 3.00806, 4.01044, 5.01272, 6.01495, 7.01720, 8.01950, 9.02201, 10.02433, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5800 Da
    { 0.00000, 1.00288, 2.00551, 3.00798, 4.01034, 5.01256, 6.01478, 7.01702, 8.01934, 9.02183, 10.02401, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5900 Da
    { 0.00000, 1.00288, 2.00552, 3.00799, 4.01031, 5.01252, 6.01469, 7.01691, 8.01920, 9.02159, 10.02398, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6000 Da
    { 0.00000, 1.00288, 2.00560, 3.00819, 4.01064, 5.01296, 6.01529, 7.01762, 8.01991, 9.02246, 10.02494, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6100 Da
    { 0.00000, 1.00286, 2.00547, 3.00797, 4.01034, 5.01264, 6.01489, 7.01712, 8.01937, 9.02176, 10.02408, 11.01745, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6200 Da
    { 0.00000, 1.00289, 2.00557, 3.00812, 4.01052, 5.01283, 6.01514, 7.01740, 8.01971, 9.02218, 10.02460, 11.02477, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6300 Da
    { 0.00000, 1.00288, 2.00553, 3.00805, 4.01051, 5.01282, 6.01505, 7.01726, 8.01945, 9.02171, 10.02424, 11.02472, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6400 Da
    { 0.00000, 1.00287, 2.00546, 3.00797, 4.01027, 5.01243, 6.01450, 7.01662, 8.01874, 9.02093, 10.02342, 11.02520, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6500 Da
    { 0.00000, 1.00287, 2.00551, 3.00801, 4.01035, 5.01260, 6.01484, 7.01709, 8.01944, 9.02195, 10.02426, 11.02650, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6600 Da
    { 0.00000, 1.00287, 2.00555, 3.00814, 4.01055, 5.01285, 6.01509, 7.01729, 8.01947, 9.02181, 10.02426, 11.02676, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6700 Da
    { 0.00000, 1.00288, 2.00560, 3.00819, 4.01067, 5.01306, 6.01543, 7.01778, 8.02017, 9.02265, 10.02527, 11.02749, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6800 Da
    { 0.00000, 1.00287, 2.00560, 3.00825, 4.01078, 5.01315, 6.01545, 7.01776, 8.02010, 9.02254, 10.02517, 11.02748, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6900 Da
    { 0.00000, 1.00288, 2.00556, 3.00810, 4.01051, 5.01282, 6.01508, 7.01731, 8.01954, 9.02180, 10.02430, 11.02688, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7000 Da
    { 0.00000, 1.00288, 2.00559, 3.00816, 4.01062, 5.01300, 6.01532, 7.01759, 8.01990, 9.02220, 10.02478, 11.02721, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7100 Da
    { 0.00000, 1.00287, 2.00555, 3.00809, 4.01057, 5.01290, 6.01524, 7.01749, 8.01977, 9.02202, 10.02436, 11.02703, 12.01437, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7200 Da
    { 0.00000, 1.00288, 2.00558, 3.00816, 4.01061, 5.01294, 6.01523, 7.01749, 8.01979, 9.02203, 10.02439, 11.02704, 12.02343, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7300 Da
    { 0.00000, 1.00287, 2.00555, 3.00812, 4.01054, 5.01285, 6.01511, 7.01736, 8.01957, 9.02180, 10.02417, 11.02672, 12.02635, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7400 Da
    { 0.00000, 1.00287, 2.00558, 3.00815, 4.01062, 5.01299, 6.01528, 7.01756, 8.01985, 9.02207, 10.02447, 11.02725, 12.02895, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7500 Da
    { 0.00000, 1.00287, 2.00557, 3.00813, 4.01057, 5.01292, 6.01518, 7.01744, 8.01969, 9.02193, 10.02437, 11.02716, 12.02937, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7600 Da
    { 0.00000, 1.00287, 2.00557, 3.00814, 4.01064, 5.01303, 6.01534, 7.01765, 8.01994, 9.02219, 10.02468, 11.02745, 12.02991, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7700 Da
    { 0.00000, 1.00288, 2.00558, 3.00819, 4.01063, 5.01299, 6.01531, 7.01759, 8.01984, 9.02208, 10.02447, 11.02715, 12.02986, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7800 Da
    { 0.00000, 1.00287, 2.00558, 3.00817, 4.01066, 5.01309, 6.01546, 7.01778, 8.02005, 9.02228, 10.02467, 11.02733, 12.02996, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7900 Da
    { 0.00000, 1.00287, 2.00559, 3.00818, 4.01066, 5.01305, 6.01532, 7.01762, 8.01988, 9.02212, 10.02452, 11.02715, 12.02998, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8000 Da
    { 0.00000, 1.00286, 2.00559, 3.00819, 4.01071, 5.01314, 6.01551, 7.01784, 8.02012, 9.02238, 10.02469, 11.02728, 12.03026, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8100 Da
    { 0.00000, 1.00287, 2.00561, 3.00825, 4.01077, 5.01325, 6.01566, 7.01804, 8.02042, 9.02271, 10.02521, 11.02789, 12.03065, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8200 Da
    { 0.00000, 1.00288, 2.00562, 3.00826, 4.01077, 5.01317, 6.01551, 7.01783, 8.02023, 9.02260, 10.02490, 11.02730, 12.03019, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8300 Da
    { 0.00000, 1.00287, 2.00559, 3.00820, 4.01071, 5.01315, 6.01549, 7.01785, 8.02013, 9.02244, 10.02480, 11.02736, 12.03023, 13.02645, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8400 Da
    { 0.00000, 1.00288, 2.00561, 3.00824, 4.01076, 5.01318, 6.01557, 7.01793, 8.02022, 9.02253, 10.02487, 11.02744, 12.03026, 13.03021, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8500 Da
    { 0.00000, 1.00288, 2.00561, 3.00824, 4.01079, 5.01320, 6.01559, 7.01796, 8.02028, 9.02258, 10.02495, 11.02742, 12.03029, 13.03226, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8600 Da
    { 0.00000, 1.00288, 2.00562, 3.00824, 4.01075, 5.01317, 6.01554, 7.01788, 8.02020, 9.02252, 10.02481, 11.02738, 12.02998, 13.03127, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8700 Da
    { 0.00000, 1.00288, 2.00561, 3.00820, 4.01076, 5.01318, 6.01553, 7.01785, 8.02014, 9.02247, 10.02471, 11.02725, 12.02969, 13.03296, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8800 Da
    { 0.00000, 1.00288, 2.00560, 3.00821, 4.01074, 5.01317, 6.01557, 7.01790, 8.02018, 9.02247, 10.02472, 11.02719, 12.02972, 13.03268, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8900 Da
    { 0.00000, 1.00289, 2.00560, 3.00817, 4.01067, 5.01309, 6.01535, 7.01767, 8.01989, 9.02221, 10.02447, 11.02698, 12.02940, 13.03229, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9000 Da
    { 0.00000, 1.00288, 2.00559, 3.00816, 4.01067, 5.01304, 6.01536, 7.01763, 8.01984, 9.02208, 10.02432, 11.02671, 12.02909, 13.03229, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9100 Da
    { 0.00000, 1.00289, 2.00562, 3.00824, 4.01081, 5.01329, 6.01573, 7.01820, 8.02052, 9.02288, 10.02521, 11.02770, 12.03046, 13.03324, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9200 Da
    { 0.00000, 1.00287, 2.00558, 3.00814, 4.01061, 5.01298, 6.01534, 7.01764, 8.01989, 9.02213, 10.02444, 11.02688, 12.02931, 13.03157, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9300 Da
    { 0.00000, 1.00287, 2.00563, 3.00825, 4.01083, 5.01326, 6.01569, 7.01808, 8.02043, 9.02278, 10.02508, 11.02757, 12.03019, 13.03283, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9400 Da
    { 0.00000, 1.00287, 2.00559, 3.00823, 4.01079, 5.01326, 6.01566, 7.01808, 8.02041, 9.02274, 10.02506, 11.02748, 12.03005, 13.03247, 14.01399, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9500 Da
    { 0.00000, 1.00288, 2.00561, 3.00823, 4.01077, 5.01319, 6.01555, 7.01788, 8.02017, 9.02249, 10.02477, 11.02725, 12.02974, 13.03213, 14.02763, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9600 Da
    { 0.00000, 1.00287, 2.00560, 3.00821, 4.01076, 5.01317, 6.01551, 7.01785, 8.02010, 9.02234, 10.02463, 11.02696, 12.02948, 13.03167, 14.03073, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9700 Da
    { 0.00000, 1.00288, 2.00564, 3.00826, 4.01083, 5.01329, 6.01569, 7.01807, 8.02041, 9.02275, 10.02508, 11.02750, 12.03020, 13.03250, 14.03377, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9800 Da
    { 0.00000, 1.00287, 2.00561, 3.00823, 4.01078, 5.01323, 6.01563, 7.01797, 8.02024, 9.02251, 10.02481, 11.02719, 12.02965, 13.03196, 14.03510, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9900 Da
    { 0.00000, 1.00289, 2.00562, 3.00829, 4.01088, 5.01338, 6.01586, 7.01833, 8.02072, 9.02311, 10.02544, 11.02784, 12.03061, 13.03293, 14.03620, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 10000 Da
  };

  double IsotopicDist::sfIsoMass90[96][20] =
  {
    { 0.00000, 1.00291, 2.00540, 3.00785, 4.00014, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 500 Da
    { 0.00000, 1.00296, 2.00546, 3.00801, 4.00308, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 600 Da
    { 0.00000, 1.00295, 2.00551, 3.00809, 4.00406, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 700 Da
    { 0.00000, 1.00296, 2.00561, 3.00823, 4.01057, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 800 Da
    { 0.00000, 1.00291, 2.00553, 3.00807, 4.01044, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 900 Da
    { 0.00000, 1.00296, 2.00565, 3.00827, 4.01086, 5.00022, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1000 Da
    { 0.00000, 1.00292, 2.00560, 3.00820, 4.01083, 5.00365, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1100 Da
    { 0.00000, 1.00292, 2.00564, 3.00828, 4.01093, 5.00815, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1200 Da
    { 0.00000, 1.00293, 2.00567, 3.00833, 4.01098, 5.01350, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1300 Da
    { 0.00000, 1.00290, 2.00562, 3.00825, 4.01087, 5.01336, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1400 Da
    { 0.00000, 1.00293, 2.00568, 3.00837, 4.01103, 5.01357, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1500 Da
    { 0.00000, 1.00291, 2.00565, 3.00832, 4.01099, 5.01378, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1600 Da
    { 0.00000, 1.00293, 2.00562, 3.00826, 4.01090, 5.01367, 6.00839, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1700 Da
    { 0.00000, 1.00295, 2.00574, 3.00845, 4.01115, 5.01384, 6.00920, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1800 Da
    { 0.00000, 1.00292, 2.00564, 3.00830, 4.01094, 5.01364, 6.01620, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 1900 Da
    { 0.00000, 1.00292, 2.00567, 3.00834, 4.01100, 5.01371, 6.01636, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2000 Da
    { 0.00000, 1.00292, 2.00570, 3.00842, 4.01111, 5.01384, 6.01646, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2100 Da
    { 0.00000, 1.00294, 2.00574, 3.00849, 4.01121, 5.01396, 6.01670, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2200 Da
    { 0.00000, 1.00292, 2.00569, 3.00840, 4.01109, 5.01382, 6.01661, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2300 Da
    { 0.00000, 1.00294, 2.00571, 3.00844, 4.01113, 5.01387, 6.01675, 7.01247, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2400 Da
    { 0.00000, 1.00294, 2.00569, 3.00842, 4.01112, 5.01378, 6.01659, 7.01353, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2500 Da
    { 0.00000, 1.00292, 2.00566, 3.00837, 4.01105, 5.01369, 6.01648, 7.01645, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2600 Da
    { 0.00000, 1.00293, 2.00570, 3.00843, 4.01111, 5.01376, 6.01661, 7.01930, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2700 Da
    { 0.00000, 1.00294, 2.00563, 3.00835, 4.01099, 5.01365, 6.01631, 7.01928, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2800 Da
    { 0.00000, 1.00294, 2.00571, 3.00847, 4.01118, 5.01388, 6.01658, 7.01947, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 2900 Da
    { 0.00000, 1.00290, 2.00568, 3.00841, 4.01109, 5.01377, 6.01645, 7.01934, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3000 Da
    { 0.00000, 1.00292, 2.00563, 3.00834, 4.01099, 5.01363, 6.01627, 7.01905, 8.00862, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3100 Da
    { 0.00000, 1.00293, 2.00565, 3.00835, 4.01100, 5.01361, 6.01626, 7.01906, 8.01474, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3200 Da
    { 0.00000, 1.00294, 2.00566, 3.00838, 4.01107, 5.01373, 6.01641, 7.01896, 8.01755, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3300 Da
    { 0.00000, 1.00292, 2.00570, 3.00846, 4.01117, 5.01385, 6.01656, 7.01916, 8.02245, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3400 Da
    { 0.00000, 1.00294, 2.00566, 3.00840, 4.01109, 5.01375, 6.01642, 7.01899, 8.02230, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3500 Da
    { 0.00000, 1.00291, 2.00559, 3.00829, 4.01095, 5.01357, 6.01624, 7.01886, 8.02222, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3600 Da
    { 0.00000, 1.00294, 2.00576, 3.00854, 4.01128, 5.01397, 6.01664, 7.01937, 8.02215, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3700 Da
    { 0.00000, 1.00291, 2.00564, 3.00839, 4.01107, 5.01371, 6.01642, 7.01912, 8.02195, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3800 Da
    { 0.00000, 1.00294, 2.00571, 3.00845, 4.01115, 5.01382, 6.01652, 7.01923, 8.02193, 9.01349, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 3900 Da
    { 0.00000, 1.00293, 2.00576, 3.00852, 4.01125, 5.01395, 6.01666, 7.01940, 8.02217, 9.01576, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4000 Da
    { 0.00000, 1.00292, 2.00571, 3.00846, 4.01117, 5.01385, 6.01651, 7.01927, 8.02186, 9.01398, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4100 Da
    { 0.00000, 1.00294, 2.00569, 3.00840, 4.01108, 5.01373, 6.01635, 7.01912, 8.02162, 9.02284, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4200 Da
    { 0.00000, 1.00293, 2.00569, 3.00842, 4.01111, 5.01378, 6.01641, 7.01917, 8.02177, 9.02398, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4300 Da
    { 0.00000, 1.00293, 2.00567, 3.00844, 4.01115, 5.01385, 6.01649, 7.01929, 8.02193, 9.02504, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4400 Da
    { 0.00000, 1.00293, 2.00577, 3.00852, 4.01126, 5.01397, 6.01662, 7.01942, 8.02210, 9.02500, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4500 Da
    { 0.00000, 1.00292, 2.00564, 3.00835, 4.01103, 5.01368, 6.01629, 7.01906, 8.02170, 9.02463, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4600 Da
    { 0.00000, 1.00293, 2.00566, 3.00830, 4.01082, 5.01330, 6.01571, 7.01823, 8.02081, 9.02368, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4700 Da
    { 0.00000, 1.00292, 2.00568, 3.00844, 4.01115, 5.01382, 6.01646, 7.01920, 8.02190, 9.02458, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4800 Da
    { 0.00000, 1.00291, 2.00565, 3.00834, 4.01100, 5.01364, 6.01627, 7.01895, 8.02170, 9.02406, 10.01354, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 4900 Da
    { 0.00000, 1.00292, 2.00573, 3.00852, 4.01126, 5.01396, 6.01665, 7.01934, 8.02217, 9.02460, 10.02083, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5000 Da
    { 0.00000, 1.00291, 2.00573, 3.00848, 4.01120, 5.01388, 6.01658, 7.01925, 8.02207, 9.02448, 10.02328, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5100 Da
    { 0.00000, 1.00293, 2.00574, 3.00850, 4.01119, 5.01389, 6.01659, 7.01926, 8.02209, 9.02476, 10.02745, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5200 Da
    { 0.00000, 1.00292, 2.00572, 3.00850, 4.01123, 5.01394, 6.01665, 7.01932, 8.02217, 9.02480, 10.02760, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5300 Da
    { 0.00000, 1.00292, 2.00565, 3.00832, 4.01095, 5.01347, 6.01596, 7.01843, 8.02110, 9.02358, 10.02704, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5400 Da
    { 0.00000, 1.00291, 2.00572, 3.00847, 4.01118, 5.01388, 6.01656, 7.01924, 8.02200, 9.02474, 10.02761, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5500 Da
    { 0.00000, 1.00292, 2.00570, 3.00843, 4.01107, 5.01369, 6.01632, 7.01896, 8.02172, 9.02440, 10.02715, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5600 Da
    { 0.00000, 1.00293, 2.00569, 3.00839, 4.01107, 5.01374, 6.01639, 7.01903, 8.02180, 9.02449, 10.02703, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5700 Da
    { 0.00000, 1.00292, 2.00570, 3.00849, 4.01119, 5.01385, 6.01654, 7.01923, 8.02193, 9.02486, 10.02719, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5800 Da
    { 0.00000, 1.00293, 2.00574, 3.00849, 4.01115, 5.01381, 6.01649, 7.01917, 8.02187, 9.02478, 10.02720, 11.02270, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 5900 Da
    { 0.00000, 1.00292, 2.00567, 3.00834, 4.01091, 5.01344, 6.01593, 7.01846, 8.02099, 9.02381, 10.02613, 11.02393, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6000 Da
    { 0.00000, 1.00294, 2.00574, 3.00854, 4.01128, 5.01401, 6.01672, 7.01944, 8.02214, 9.02506, 10.02752, 11.02714, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6100 Da
    { 0.00000, 1.00291, 2.00571, 3.00844, 4.01111, 5.01377, 6.01640, 7.01904, 8.02167, 9.02447, 10.02699, 11.02833, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6200 Da
    { 0.00000, 1.00294, 2.00576, 3.00854, 4.01127, 5.01400, 6.01671, 7.01943, 8.02214, 9.02504, 10.02755, 11.03090, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6300 Da
    { 0.00000, 1.00293, 2.00571, 3.00848, 4.01116, 5.01377, 6.01633, 7.01890, 8.02147, 9.02419, 10.02686, 11.03042, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6400 Da
    { 0.00000, 1.00292, 2.00569, 3.00839, 4.01102, 5.01363, 6.01620, 7.01879, 8.02138, 9.02410, 10.02676, 11.03031, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6500 Da
    { 0.00000, 1.00292, 2.00571, 3.00849, 4.01121, 5.01393, 6.01664, 7.01936, 8.02206, 9.02480, 10.02771, 11.03017, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6600 Da
    { 0.00000, 1.00291, 2.00572, 3.00848, 4.01120, 5.01390, 6.01660, 7.01930, 8.02195, 9.02471, 10.02763, 11.03016, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6700 Da
    { 0.00000, 1.00291, 2.00571, 3.00845, 4.01109, 5.01370, 6.01630, 7.01891, 8.02154, 9.02416, 10.02708, 11.02978, 12.01406, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6800 Da
    { 0.00000, 1.00294, 2.00575, 3.00852, 4.01128, 5.01402, 6.01674, 7.01942, 8.02206, 9.02477, 10.02774, 11.03036, 12.02269, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 6900 Da
    { 0.00000, 1.00292, 2.00571, 3.00848, 4.01116, 5.01380, 6.01645, 7.01907, 8.02169, 9.02439, 10.02722, 11.02986, 12.02777, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7000 Da
    { 0.00000, 1.00293, 2.00576, 3.00854, 4.01128, 5.01399, 6.01670, 7.01939, 8.02202, 9.02476, 10.02767, 11.03026, 12.03057, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7100 Da
    { 0.00000, 1.00293, 2.00572, 3.00845, 4.01110, 5.01373, 6.01630, 7.01888, 8.02148, 9.02412, 10.02699, 11.02963, 12.03079, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7200 Da
    { 0.00000, 1.00293, 2.00573, 3.00844, 4.01114, 5.01375, 6.01633, 7.01891, 8.02151, 9.02410, 10.02706, 11.02965, 12.03152, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7300 Da
    { 0.00000, 1.00293, 2.00571, 3.00842, 4.01108, 5.01375, 6.01633, 7.01892, 8.02149, 9.02409, 10.02684, 11.02958, 12.03273, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7400 Da
    { 0.00000, 1.00292, 2.00572, 3.00845, 4.01114, 5.01379, 6.01637, 7.01897, 8.02155, 9.02414, 10.02693, 11.02977, 12.03317, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7500 Da
    { 0.00000, 1.00292, 2.00571, 3.00845, 4.01115, 5.01381, 6.01640, 7.01900, 8.02159, 9.02418, 10.02696, 11.02980, 12.03309, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7600 Da
    { 0.00000, 1.00292, 2.00574, 3.00851, 4.01123, 5.01391, 6.01660, 7.01924, 8.02188, 9.02450, 10.02724, 11.03019, 12.03315, 10.40638, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7700 Da
    { 0.00000, 1.00293, 2.00574, 3.00853, 4.01125, 5.01391, 6.01656, 7.01919, 8.02183, 9.02444, 10.02718, 11.03014, 12.03318, 13.02625, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7800 Da
    { 0.00000, 1.00292, 2.00574, 3.00851, 4.01124, 5.01389, 6.01650, 7.01912, 8.02171, 9.02430, 10.02701, 11.03014, 12.03307, 13.02785, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 7900 Da
    { 0.00000, 1.00292, 2.00572, 3.00846, 4.01117, 5.01382, 6.01642, 7.01902, 8.02161, 9.02422, 10.02691, 11.02982, 12.03297, 13.02656, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8000 Da
    { 0.00000, 1.00294, 2.00574, 3.00853, 4.01126, 5.01397, 6.01670, 7.01937, 8.02202, 9.02466, 10.02738, 11.03041, 12.03313, 13.03003, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8100 Da
    { 0.00000, 1.00293, 2.00574, 3.00852, 4.01124, 5.01393, 6.01663, 7.01931, 8.02196, 9.02460, 10.02725, 11.03022, 12.03307, 13.03278, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8200 Da
    { 0.00000, 1.00293, 2.00576, 3.00857, 4.01131, 5.01400, 6.01662, 7.01925, 8.02187, 9.02449, 10.02717, 11.03008, 12.03277, 13.03407, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8300 Da
    { 0.00000, 1.00293, 2.00573, 3.00849, 4.01119, 5.01385, 6.01650, 7.01913, 8.02172, 9.02428, 10.02690, 11.02990, 12.03273, 13.03448, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8400 Da
    { 0.00000, 1.00293, 2.00574, 3.00852, 4.01126, 5.01393, 6.01657, 7.01921, 8.02183, 9.02444, 10.02709, 11.03001, 12.03284, 13.03635, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8500 Da
    { 0.00000, 1.00292, 2.00574, 3.00853, 4.01125, 5.01392, 6.01659, 7.01923, 8.02185, 9.02447, 10.02709, 11.02995, 12.03294, 13.03619, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8600 Da
    { 0.00000, 1.00293, 2.00574, 3.00849, 4.01121, 5.01388, 6.01654, 7.01919, 8.02182, 9.02442, 10.02706, 11.02986, 12.03268, 13.03622, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8700 Da
    { 0.00000, 1.00293, 2.00575, 3.00851, 4.01125, 5.01392, 6.01657, 7.01919, 8.02182, 9.02439, 10.02696, 11.02978, 12.03273, 13.03598, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8800 Da
    { 0.00000, 1.00292, 2.00574, 3.00850, 4.01125, 5.01391, 6.01659, 7.01921, 8.02183, 9.02444, 10.02706, 11.02978, 12.03290, 13.03601, 14.02370, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 8900 Da
    { 0.00000, 1.00294, 2.00575, 3.00852, 4.01126, 5.01390, 6.01651, 7.01911, 8.02173, 9.02433, 10.02691, 11.02966, 12.03255, 13.03610, 14.02909, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9000 Da
    { 0.00000, 1.00292, 2.00573, 3.00847, 4.01118, 5.01385, 6.01649, 7.01909, 8.02169, 9.02424, 10.02684, 11.02954, 12.03251, 13.03556, 14.02936, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9100 Da
    { 0.00000, 1.00294, 2.00578, 3.00853, 4.01125, 5.01388, 6.01650, 7.01911, 8.02172, 9.02433, 10.02693, 11.02971, 12.03255, 13.03587, 14.03217, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9200 Da
    { 0.00000, 1.00292, 2.00571, 3.00844, 4.01115, 5.01375, 6.01637, 7.01894, 8.02151, 9.02405, 10.02663, 11.02937, 12.03218, 13.03534, 14.03281, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9300 Da
    { 0.00000, 1.00293, 2.00574, 3.00850, 4.01125, 5.01398, 6.01671, 7.01942, 8.02210, 9.02477, 10.02738, 11.03014, 12.03299, 13.03572, 14.03648, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9400 Da
    { 0.00000, 1.00292, 2.00573, 3.00848, 4.01119, 5.01387, 6.01653, 7.01916, 8.02178, 9.02440, 10.02705, 11.02966, 12.03258, 13.03551, 14.03737, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9500 Da
    { 0.00000, 1.00292, 2.00576, 3.00857, 4.01132, 5.01400, 6.01665, 7.01927, 8.02189, 9.02451, 10.02717, 11.02977, 12.03280, 13.03562, 14.03885, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9600 Da
    { 0.00000, 1.00293, 2.00571, 3.00848, 4.01122, 5.01390, 6.01657, 7.01923, 8.02187, 9.02452, 10.02717, 11.02981, 12.03262, 13.03552, 14.03895, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9700 Da
    { 0.00000, 1.00293, 2.00576, 3.00853, 4.01131, 5.01398, 6.01671, 7.01942, 8.02208, 9.02469, 10.02733, 11.03008, 12.03278, 13.03562, 14.03888, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9800 Da
    { 0.00000, 1.00294, 2.00580, 3.00861, 4.01137, 5.01411, 6.01681, 7.01949, 8.02212, 9.02476, 10.02740, 11.03004, 12.03289, 13.03583, 14.03877, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000 }, // 9900 Da
    { 0.00000, 1.00294, 2.00576, 3.00848, 4.01117, 5.01377, 6.01635, 7.01891, 8.02143, 9.02400, 10.02659, 11.02918, 12.03184, 13.03495, 14.03812, 15.02369, 0.00000, 0.00000, 0.00000, 0.00000 }, // 10000 Da
  };

  int IsotopicDist::sfNrIsotopes[96];
  int IsotopicDist::sfMaxIsotopeIndex = 19;   // Highest first index in isotopic tables above
  int IsotopicDist::sfMaxMassIndex = 95;   // Highest second index in isotopic tables above
  double IsotopicDist::sfMinMass = 500.0;   // Min mass of isotopic tables
  double IsotopicDist::sfMaxMass = 10000.0;   // Max mass of isotopic tables
  double IsotopicDist::sfMassStep = 100.0;   // Mass bin size in isotopic tables

  //bool IsotopicDist::sfDebug = false;
  //std::ostream* IsotopicDist::sfStream = 0;

#include <cmath>
#include <iostream>

  using namespace std;

// initialises several attributes and MUST be called before use of the other functions
  void IsotopicDist::init()
  {
    if (SuperHirnParameters::instance()->isInitIsotopeDist())
    {
      return;
    }

    int i, j;
    double fact;

    fact = SuperHirnParameters::instance()->getDetectableIsotopeFactor();

    for (i = 0; i <= sfMaxMassIndex; i++)
    {
      double max_intens = 0.0;
      for (j = 0; j <= sfMaxIsotopeIndex; j++)
      {
        max_intens = (max_intens > sfIsoDist50[i][j]) ? max_intens : sfIsoDist50[i][j];
        if (sfIsoDist50[i][j] < max_intens * fact && j > 1)
          break;
      }

      sfNrIsotopes[i] = j;
    }
    SuperHirnParameters::instance()->setInitIsotopeDist();
  }

// Returns median isotopic distribtion for a given mass and charge 1
// NEVER USED
  /*
   void IsotopicDist::getDistribution(
   double pMass, // mass of monoisotopic peak
   double*& pMasses, // iso dist masses as C array, monoisotopic peak is set to 0 mass
   double*& pIntens) // iso dist intensities as C array
   {


   int idx = getIndex(pMass,1);

   pMasses = sfIsoDist50[idx];
   pIntens = sfIsoMass50[idx];
   }
   */

// Iterates over an list of CentroidPeak objects and finds those ones that match a isotopic m/z value. It also calculates the 'best'
// match of a isotopic pattern to these peaks.
  bool IsotopicDist::getMatchingPeaks(list<CentroidPeak>::iterator pMono,   // potential monoisotopic peak
                                      list<CentroidPeak>::iterator pEnd, // end of peak group
                                      int pCharge, // charge of the isotopic pattern
                                      double & pAlpha, // best fit factor
                                      double pTheta, // noise level
                                      list<list<CentroidPeak>::iterator> & pMatchedPeaks) // matching peaks
  {
    init();

    int idx, i, cnt;
    double tol, m, alpha, min_alpha, mono_alpha, mono, dist;
    bool matched;
    list<CentroidPeak>::iterator piter, match_peak;
    list<double> alpha_values;
    list<double>::iterator avi;

    mono = pMono->getMass();
    tol = SuperHirnParameters::instance()->getMassTolPpm() * mono / 1.0e6
          + SuperHirnParameters::instance()->getMassTolDa();
    piter = pMono;
    mono_alpha = 0.0;

    //  if (sfDebug) (*sfStream) << fixed << setprecision(4) << mono << " " ;

    //////////////////////////////////////////////////////////
    // get the local isotopic distribution:
    idx = getIndex(mono, pCharge);

    // get the extracted x percentile distribution:
    //double* sfIsoDist10Local = IsotopicDist::sfIsoDist10[idx];
    double * sfIsoDist50Local = IsotopicDist::sfIsoDist50[idx];
    //double* sfIsoDist90Local = IsotopicDist::sfIsoDist90[idx];

    // check for external distributions: ****PK : EXTERNAL_ISOTOPIC_PROFILES is always false, remove
    /*
    PeptideIsotopeDisribution* extrenalIsoDist = NULL;
    if (ExternalIsotopicDistribution::EXTERNAL_ISOTOPIC_PROFILES)
    {
        extrenalIsoDist = ExternalIsotopicDistribution::extractExternalIsotopicProfile(mono, pCharge,
                pMono->getRetentionTime());

        if (extrenalIsoDist != NULL)
        {
            sfIsoDist50Local = extrenalIsoDist->getIntensityArray();
        }
    }
    */

    double intens = pMono->getIntensity();
    double theoIntensMono = sfIsoDist50Local[0];
    pAlpha = (intens + pTheta) / theoIntensMono;

    // Markus-Fix, applied 2011-05-06
    int maxNbIsotopes = sfNrIsotopes[idx];     // number of isotopes used for quantification
    int maxMaxNbIsotopes = (maxNbIsotopes > 6) ? maxNbIsotopes : 6;     // number of isotopes to be removed

    /*
     if( CentroidData::MonoIsoDebugging ){
     if( ( CentroidData::DebugMonoIsoMassMin <= mono) && ( CentroidData::DebugMonoIsoMassMax >= mono) ){
     idx = getIndex(mono,pCharge);
     maxNbIsotopes = sfNrIsotopes[idx];
     //maxNbIsotopes = 5;
     cout<<maxNbIsotopes<<endl;
     }
     }
     */

    for (i = 0; i < maxMaxNbIsotopes; i++) // find matching isotopes
    {
      double m_low, m_high, max_alpha, theta, dm,dist_min;
      theta = (sfIsoDist50Local[i] < SuperHirnParameters::instance()->getDetectableIsotopeFactor()) ? pTheta : 0.0;       // this only requires intense isotpic peaks to match exp. peaks

      //m_low = mono + sfIsoDist10Local[i]/pCharge - tol;
      //m_high = mono + sfIsoDist90Local[i]/pCharge + tol;
      m_low = mono + sfIsoMass10[idx][i] / pCharge - tol;
      m_high = mono + sfIsoMass90[idx][i] / pCharge + tol;

      matched = false;
      dist_min = 100.0;
      dm = 1.0;
      max_alpha = 0.0;
      for (; piter != pEnd; ++piter)
      {
        m = piter->getMass();

        if (m >= m_low && m <= m_high) // matching mass
        {
          dm = abs(piter->getMass() - mono - sfIsoMass50[idx][i] / pCharge);
          alpha = (piter->getIntensity() + theta) / sfIsoDist50Local[i];
          if (i > 0)  // second and higher isotop
          {
            dist = abs((alpha - mono_alpha) / mono_alpha) + 10.0 * dm / tol;             // score to evaluate distance between expected and measured values
            if (dist < dist_min) // take minimum distance within same isotop mass range
            {
              max_alpha = alpha;
              match_peak = piter;
              match_peak->setIsotopIdx(i);
              dist_min = dist;
              matched = true;
            }
          }
          else        // first (C12) isotop
          {
            if (piter == pMono)
            {
              mono_alpha = alpha;               // take only peak itself within C12 isotop mass range
              max_alpha = alpha;
              match_peak = pMono;
              pMono->setIsotopIdx(0);
              matched = true;
            }
          }
        }
        else if (m > m_high) // out of mass bounds: go to next isotope
        {
          if (!matched)
          {
            alpha = theta / sfIsoDist50Local[i];
            max_alpha = (alpha > max_alpha) ? alpha : max_alpha;             // take maximum within same isotop
          }
          break;
        }
      }

      if (matched)
      {
        /*
         if( CentroidData::MonoIsoDebugging ){
         if( ( CentroidData::DebugMonoIsoMassMin <= mono) && ( CentroidData::DebugMonoIsoMassMax >= mono) ){
         cout<<endl<<"*Mass: "<<mono<<":: "<<piter->getIntensity()<<"::"<<pCharge<<endl;
         }
         }
         */

        /** PK never used
        if (extrenalIsoDist != NULL)
        {
            match_peak->setExtraPeakInfo(extrenalIsoDist->getSummary());
            // match_peak->show_info();
            // extrenalIsoDist->show_info();
            extrenalIsoDist = NULL;
        }
        */

        pMatchedPeaks.push_back(match_peak);
      }

      if (piter == pEnd) // stop if no peaks are left
      {
        if (!matched)
        {
          alpha = theta / sfIsoDist50Local[i];
          max_alpha = (alpha > max_alpha) ? alpha : max_alpha;           // take maximum within same isotop
        }
      }

      if (i < maxNbIsotopes)
        alpha_values.push_back(max_alpha);
      //if (i<maxNbIsotopes && sfDebug) sfStream << i << ":" << max_alpha << " ";

//    if (max_alpha < 1.0) break;
    }

    // calculate final alpha
    pAlpha = 0.0;
    min_alpha = *(alpha_values.begin());
    cnt = 0;
    matched = true;
    for (avi = alpha_values.begin(); avi != alpha_values.end(); ++avi)
    {
      if (abs(*avi - mono_alpha) / mono_alpha < SuperHirnParameters::instance()->getIntensityCV()) // alpha close to value from first isotope
      {
        pAlpha += *avi;
        cnt++;
      }
      else if ((mono_alpha - *avi) / mono_alpha > SuperHirnParameters::instance()->getIntensityCV()) // small alpha in case of missing peak
      {
        min_alpha = (min_alpha > *avi) ? *avi : min_alpha;
        matched = false;
      }
    }

    if (matched)
    {
      pAlpha /= cnt;       // calculate the avg alpha values for all alphas close to the one of the monoisotopic peak
    }
    else
    {
      pAlpha = min_alpha;       // otherwise take smallest
    }

//if (sfDebug) sfStream << " " << pAlpha << endl;

    return pAlpha > 1.0;
  }

// Subtracts fitted isotopic distribution from the spectrum and defines monoisotopic peak
  void IsotopicDist::subtractMatchingPeaks(list<list<CentroidPeak>::iterator> & pMatchedPeaks,  // pointers to matching peaks
                                           int pCharge, // charge
                                           double pAlpha, // fit constant
                                           DeconvPeak & pMonoPeak) // object to store info about monoisotopic peak
  {
    init();
    list<list<CentroidPeak>::iterator>::iterator mpi;
    int idx, cnt;
    double mono, h_tot, dmC13;
    vector<CentroidPeak> isotopicDist;

    mono = (*pMatchedPeaks.begin())->getMass();
    idx = getIndex(mono, pCharge);

    h_tot = 0.0;
    cnt = 0;
    dmC13 = 0.0;
    for (mpi = pMatchedPeaks.begin(); mpi != pMatchedPeaks.end(); ++mpi) // go through list of all matched peaks
    {
      int i = (*mpi)->getIsotopIdx();
      h_tot += pAlpha * sfIsoDist50[idx][i];       // sum up fitted intensities
      cnt++;

      //    if (sfDebug) (*sfStream) << (*mpi)->getMass() << " " << (*mpi)->getIntensity() << " " << pAlpha*sfIsoDist50[idx][i] << ":";

      (*mpi)->subtractIntensity(pAlpha * sfIsoDist50[idx][i]);
      (*mpi)->setFittedIntensity(pAlpha * sfIsoDist50[idx][i]);
      isotopicDist.push_back(**mpi);

      if (i == 1)
      {
        dmC13 = (*mpi)->getMass() - mono - sfIsoMass50[idx][1] / pCharge;         // useful quantity for score
      }
    }

    //  if (sfDebug) (*sfStream)  << pCharge << endl;

    pMonoPeak.setNrIsotopes(cnt);
    pMonoPeak.setCharge(pCharge);
    // pMonoPeak.setIntensity(pAlpha*sfIsoDist50[idx][0]);
    pMonoPeak.setIntensity(h_tot);
    pMonoPeak.setC13MassError(dmC13);
    pMonoPeak.setScore(h_tot);
    pMonoPeak.setIsotopicPeaks(isotopicDist);
    // pMonoPeak.setScore(h_tot/(abs(dmC13)+0.000001));
  }

}
