/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_BootConfigSettingData.h"

CMPIObjectPath* Boot_OpenDRIM_BootConfigSettingData_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BootConfigSettingData& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_BootConfigSettingData_classnames[0], OpenDRIM_BootConfigSettingData_NAMESPACE);

	if (!instance.ManagedElement_isNULL)
		op.addKey("ManagedElement", instance.ManagedElement);

	if (!instance.SettingData_isNULL)
		op.addKey("SettingData", instance.SettingData);

	_L_;
	return op.getHdl();
}

CMPIInstance* Boot_OpenDRIM_BootConfigSettingData_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BootConfigSettingData& instance) {
	_E_;
	Objectpath op(broker, Boot_OpenDRIM_BootConfigSettingData_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.IsDefault_isNULL)
		ci.setProperty("IsDefault", instance.IsDefault);

	if (!instance.IsCurrent_isNULL)
		ci.setProperty("IsCurrent", instance.IsCurrent);

	if (!instance.IsNext_isNULL)
		ci.setProperty("IsNext", instance.IsNext);

	_L_;
	return ci.getHdl();
}

void Boot_OpenDRIM_BootConfigSettingData_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BootConfigSettingData& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("SettingData", instance.SettingData) == OK)
		instance.SettingData_isNULL = false;

	if (op.getKey("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	_L_;
}

void Boot_OpenDRIM_BootConfigSettingData_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BootConfigSettingData& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	if (inst.getProperty("SettingData", instance.SettingData) == OK)
		instance.SettingData_isNULL = false;

	if (inst.getProperty("IsDefault", instance.IsDefault) == OK)
		instance.IsDefault_isNULL = false;

	if (inst.getProperty("IsCurrent", instance.IsCurrent) == OK)
		instance.IsCurrent_isNULL = false;

	if (inst.getProperty("IsNext", instance.IsNext) == OK)
		instance.IsNext_isNULL = false;

	_L_;
}

