# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.composite_data_set import CompositeDataSet


class UniformGridAMR(CompositeDataSet):
    r"""
    UniformGridAMR - a concrete implementation of CompositeDataSet
    
    Superclass: CompositeDataSet
    
    UniformGridAMR is an AMR (hierarchical) composite dataset that
    holds UniformGrids.
    
    @sa
    UniformGridAMRDataIterator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkUniformGridAMR, obj, update, **traits)
    
    def get_data_set(self, *args):
        """
        get_data_set(self, iter:CompositeDataIterator) -> DataObject
        C++: DataObject *get_data_set(CompositeDataIterator *iter)
            override;
        get_data_set(self, level:int, idx:int) -> UniformGrid
        C++: UniformGrid *get_data_set(unsigned int level,
            unsigned int idx)
        get_data_set(self, flatIndex:int) -> DataObject
        C++: virtual DataObject *get_data_set(unsigned int flatIndex)
        Get the data set pointed to by iter
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetDataSet, *my_args)
        return wrap_vtk(ret)

    def set_data_set(self, *args):
        """
        set_data_set(self, iter:CompositeDataIterator,
            dataObj:DataObject) -> None
        C++: void set_data_set(CompositeDataIterator *iter,
            DataObject *dataObj) override;
        set_data_set(self, level:int, idx:int, grid:UniformGrid) -> None
        C++: virtual void set_data_set(unsigned int level, unsigned int idx,
             UniformGrid *grid)
        Overriding superclass method.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetDataSet, *my_args)
        return ret

    grid_description = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the data description of this uniform grid instance, e.g.
        VTK_XYZ_GRID
        """
    )

    def _grid_description_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGridDescription,
                        self.grid_description)

    def get_composite_index(self, *args):
        """
        get_composite_index(self, level:int, index:int) -> int
        C++: int get_composite_index(const unsigned int level,
            const unsigned int index)
        Retrieves the composite index associated with the data at the
        given (level,index) pair.
        """
        ret = self._wrap_call(self._vtk_obj.GetCompositeIndex, *args)
        return ret

    def get_level_and_index(self, *args):
        """
        get_level_and_index(self, compositeIdx:int, level:int, idx:int)
            -> None
        C++: void get_level_and_index(const unsigned int compositeIdx,
            unsigned int &level, unsigned int &idx)
        Given the compositeIdx (as set by set_composite_idx) this method
        returns the corresponding level and dataset index within the
        level.
        """
        ret = self._wrap_call(self._vtk_obj.GetLevelAndIndex, *args)
        return ret

    def get_max(self, *args):
        """
        get_max(self, max:[float, float, float]) -> None
        C++: void get_max(double max[3])"""
        ret = self._wrap_call(self._vtk_obj.GetMax, *args)
        return ret

    def get_min(self, *args):
        """
        get_min(self, min:[float, float, float]) -> None
        C++: void get_min(double min[3])"""
        ret = self._wrap_call(self._vtk_obj.GetMin, *args)
        return ret

    def get_number_of_data_sets(self, *args):
        """
        get_number_of_data_sets(self, level:int) -> int
        C++: unsigned int get_number_of_data_sets(const unsigned int level)
        Get the number of datasets at the given level, including null
        blocks
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfDataSets, *args)
        return ret

    def _get_number_of_levels(self):
        return self._vtk_obj.GetNumberOfLevels()
    number_of_levels = traits.Property(_get_number_of_levels, desc=\
        r"""
        Get number of levels.
        """
    )

    def _get_total_number_of_blocks(self):
        return self._vtk_obj.GetTotalNumberOfBlocks()
    total_number_of_blocks = traits.Property(_get_total_number_of_blocks, desc=\
        r"""
        Get the total number of blocks, including nullptr blocks
        """
    )

    _updateable_traits_ = \
    (('global_release_data_flag', 'GetGlobalReleaseDataFlag'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('grid_description', 'GetGridDescription'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_release_data_flag', 'global_warning_display',
    'grid_description', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(UniformGridAMR, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit UniformGridAMR properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['global_release_data_flag'], [], ['grid_description',
            'object_name']),
            title='Edit UniformGridAMR properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit UniformGridAMR properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

