/*
  This file was generated automatically with ./scripts/maple2c.pl.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_rlda.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


static inline void
func_unpol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t3, t4, t5, t6, t7, t9, t10, t12;
  double t14, t16, t17, t18, t21, t22, t23, t24;
  double t25, t26, t27, t28, t30, t33, t36, t39;
  double t42;

#ifndef XC_DONT_COMPILE_VXC
  double t43, t48, t49, t50, t51, t52, t54, t59;
  double t61, t65, t70, t71, t73, t74, t76, t79;

#ifndef XC_DONT_COMPILE_FXC
  double t86, t90, t91, t93, t96, t98, t103, t105;
  double t109, t115, t116, t118, t120, t121, t124, t130;
  double t135, t137, t138, t140, t143, t146;

#ifndef XC_DONT_COMPILE_KXC
  double t153, t160, t161, t162, t164, t167, t169, t172;
  double t174, t179, t181, t185, t192, t193, t195, t199;
  double t200, t203, t204, t207, t216, t221, t223, t225;
  double t227, t229, t234, t238, t242, t243, t244, t246;
  double t249, t252, t255;

#ifndef XC_DONT_COMPILE_LXC
  double t276, t277, t287, t296, t298, t308, t309, t317;
  double t319, t321, t323, t325, t328, t335, t339, t342;
  double t354, t361, t363, t368, t372, t375, t384, t393;
  double t397, t403, t406, t412, t418, t424, t433, t435;
  double t438, t441, t444, t447;
#endif

#endif

#endif

#endif

#endif


  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRTPI;
  t5 = t4 * t4;
  t6 = 0.1e1 <= p->zeta_threshold;
  t7 = p->zeta_threshold - 0.1e1;
  t9 = my_piecewise5(t6, t7, t6, -t7, 0);
  t10 = 0.1e1 + t9;
  t12 = POW_1_3(p->zeta_threshold);
  t14 = POW_1_3(t10);
  t16 = my_piecewise3(t10 <= p->zeta_threshold, t12 * p->zeta_threshold, t14 * t10);
  t17 = t5 * t16;
  t18 = POW_1_3(rho[0]);
  t21 = POW_1_3(0.1e1 / M_PI);
  t22 = 0.1e1 / t21;
  t23 = params->prefactor * t22;
  t24 = M_CBRT4;
  t25 = M_CBRT2;
  t26 = t25 * t25;
  t27 = tau[0] * t26;
  t28 = t18 * t18;
  t30 = 0.1e1 / t28 / rho[0];
  t33 = lapl[0] * t26;
  t36 = 0.2e1 * t27 * t30 - t33 * t30 / 0.4e1;
  t39 = t23 * t24 / t36;
  t42 = my_piecewise3(t3, 0, -0.15e2 / 0.16e2 * t17 * t18 * t39);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = 0.2e1 * t42;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t43 = 0.1e1 / t28;
  t48 = t17 * t18 * params->prefactor;
  t49 = t22 * t24;
  t50 = t36 * t36;
  t51 = 0.1e1 / t50;
  t52 = rho[0] * rho[0];
  t54 = 0.1e1 / t28 / t52;
  t59 = -0.10e2 / 0.3e1 * t27 * t54 + 0.5e1 / 0.12e2 * t33 * t54;
  t61 = t49 * t51 * t59;
  t65 = my_piecewise3(t3, 0, -0.5e1 / 0.16e2 * t17 * t43 * t39 + 0.15e2 / 0.16e2 * t48 * t61);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = 0.2e1 * rho[0] * t65 + 0.2e1 * t42;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.0e0;

  t70 = 0.1e1 / t18 / rho[0] * params->prefactor;
  t71 = t17 * t70;
  t73 = t49 * t51 * t26;
  t74 = t71 * t73;
  t76 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t74);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = 0.2e1 * rho[0] * t76;

  t79 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t74);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = 0.2e1 * rho[0] * t79;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t86 = t17 * t43 * params->prefactor;
  t90 = 0.1e1 / t50 / t36;
  t91 = t59 * t59;
  t93 = t49 * t90 * t91;
  t96 = t52 * rho[0];
  t98 = 0.1e1 / t28 / t96;
  t103 = 0.80e2 / 0.9e1 * t27 * t98 - 0.10e2 / 0.9e1 * t33 * t98;
  t105 = t49 * t51 * t103;
  t109 = my_piecewise3(t3, 0, 0.5e1 / 0.24e2 * t17 * t30 * t39 + 0.5e1 / 0.8e1 * t86 * t61 - 0.15e2 / 0.8e1 * t48 * t93 + 0.15e2 / 0.16e2 * t48 * t105);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * rho[0] * t109 + 0.4e1 * t65;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.0e0;

  t115 = t17 / t18 / t52 * params->prefactor;
  t116 = t115 * t73;
  t118 = t90 * t26;
  t120 = t49 * t118 * t59;
  t121 = t71 * t120;
  t124 = my_piecewise3(t3, 0, 0.5e1 / 0.16e2 * t116 + 0.15e2 / 0.32e2 * t121);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = 0.2e1 * rho[0] * t124 + 0.2e1 * t76;

  t130 = my_piecewise3(t3, 0, -0.5e1 / 0.2e1 * t116 - 0.15e2 / 0.4e1 * t121);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = 0.2e1 * rho[0] * t130 + 0.2e1 * t79;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  t135 = t17 / t96 * params->prefactor;
  t137 = t49 * t90 * t25;
  t138 = t135 * t137;
  t140 = my_piecewise3(t3, 0, -0.15e2 / 0.64e2 * t138);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = 0.2e1 * rho[0] * t140;

  t143 = my_piecewise3(t3, 0, 0.15e2 / 0.8e1 * t138);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = 0.2e1 * rho[0] * t143;

  t146 = my_piecewise3(t3, 0, -0.15e2 * t138);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = 0.2e1 * rho[0] * t146;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t153 = t17 * t30 * params->prefactor;
  t160 = t50 * t50;
  t161 = 0.1e1 / t160;
  t162 = t91 * t59;
  t164 = t49 * t161 * t162;
  t167 = t90 * t59;
  t169 = t49 * t167 * t103;
  t172 = t52 * t52;
  t174 = 0.1e1 / t28 / t172;
  t179 = -0.880e3 / 0.27e2 * t27 * t174 + 0.110e3 / 0.27e2 * t33 * t174;
  t181 = t49 * t51 * t179;
  t185 = my_piecewise3(t3, 0, -0.25e2 / 0.72e2 * t17 * t54 * t39 - 0.5e1 / 0.8e1 * t153 * t61 - 0.15e2 / 0.8e1 * t86 * t93 + 0.15e2 / 0.16e2 * t86 * t105 + 0.45e2 / 0.8e1 * t48 * t164 - 0.45e2 / 0.8e1 * t48 * t169 + 0.15e2 / 0.16e2 * t48 * t181);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.2e1 * rho[0] * t185 + 0.6e1 * t109;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.0e0;

  t192 = t17 / t18 / t96 * params->prefactor;
  t193 = t192 * t73;
  t195 = t115 * t120;
  t199 = t49 * t161 * t26 * t91;
  t200 = t71 * t199;
  t203 = t49 * t118 * t103;
  t204 = t71 * t203;
  t207 = my_piecewise3(t3, 0, -0.35e2 / 0.48e2 * t193 - 0.5e1 / 0.4e1 * t195 - 0.45e2 / 0.32e2 * t200 + 0.15e2 / 0.32e2 * t204);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = 0.2e1 * rho[0] * t207 + 0.4e1 * t124;

  t216 = my_piecewise3(t3, 0, 0.35e2 / 0.6e1 * t193 + 0.10e2 * t195 + 0.45e2 / 0.4e1 * t200 - 0.15e2 / 0.4e1 * t204);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = 0.2e1 * rho[0] * t216 + 0.4e1 * t130;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  t221 = t17 / t172 * params->prefactor;
  t223 = t161 * t25;
  t225 = t49 * t223 * t59;
  t227 = t135 * t225 + t221 * t137;
  t229 = my_piecewise3(t3, 0, 0.45e2 / 0.64e2 * t227);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = 0.2e1 * rho[0] * t229 + 0.2e1 * t140;

  t234 = my_piecewise3(t3, 0, -0.45e2 / 0.8e1 * t227);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = 0.2e1 * rho[0] * t234 + 0.2e1 * t143;

  t238 = my_piecewise3(t3, 0, 0.45e2 * t227);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = 0.2e1 * rho[0] * t238 + 0.2e1 * t146;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  t242 = t24 * t161;
  t243 = t23 * t242;
  t244 = t17 * t174 * t243;
  t246 = my_piecewise3(t3, 0, -0.45e2 / 0.128e3 * t244);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = 0.2e1 * rho[0] * t246;

  t249 = my_piecewise3(t3, 0, 0.45e2 / 0.16e2 * t244);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = 0.2e1 * rho[0] * t249;

  t252 = my_piecewise3(t3, 0, -0.45e2 / 0.2e1 * t244);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = 0.2e1 * rho[0] * t252;

  t255 = my_piecewise3(t3, 0, 0.180e3 * t244);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = 0.2e1 * rho[0] * t255;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t276 = 0.1e1 / t160 / t36;
  t277 = t91 * t91;
  t287 = t103 * t103;
  t296 = t172 * rho[0];
  t298 = 0.1e1 / t28 / t296;
  t308 = 0.25e2 / 0.27e2 * t17 * t98 * t39 + 0.25e2 / 0.18e2 * t17 * t54 * params->prefactor * t61 + 0.5e1 / 0.2e1 * t153 * t93 - 0.5e1 / 0.4e1 * t153 * t105 + 0.15e2 / 0.2e1 * t86 * t164 - 0.15e2 / 0.2e1 * t86 * t169 + 0.5e1 / 0.4e1 * t86 * t181 - 0.45e2 / 0.2e1 * t48 * t49 * t276 * t277 + 0.135e3 / 0.4e1 * t48 * t49 * t161 * t91 * t103 - 0.45e2 / 0.8e1 * t48 * t49 * t90 * t287 - 0.15e2 / 0.2e1 * t48 * t49 * t167 * t179 + 0.15e2 / 0.16e2 * t48 * t49 * t51 * (0.12320e5 / 0.81e2 * t27 * t298 - 0.1540e4 / 0.81e2 * t33 * t298);
  t309 = my_piecewise3(t3, 0, t308);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.2e1 * rho[0] * t309 + 0.8e1 * t185;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.0e0;

  t317 = t17 / t18 / t172 * params->prefactor * t73;
  t319 = t192 * t120;
  t321 = t115 * t199;
  t323 = t115 * t203;
  t325 = t276 * t26;
  t328 = t71 * t49 * t325 * t162;
  t335 = t17 * t70 * t22 * t242 * t26 * t59 * t103;
  t339 = t71 * t49 * t118 * t179;
  t342 = my_piecewise3(t3, 0, 0.175e3 / 0.72e2 * t317 + 0.35e2 / 0.8e1 * t319 + 0.45e2 / 0.8e1 * t321 - 0.15e2 / 0.8e1 * t323 + 0.45e2 / 0.8e1 * t328 - 0.135e3 / 0.32e2 * t335 + 0.15e2 / 0.32e2 * t339);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = 0.2e1 * rho[0] * t342 + 0.6e1 * t207;

  t354 = my_piecewise3(t3, 0, -0.175e3 / 0.9e1 * t317 - 0.35e2 * t319 - 0.45e2 * t321 + 0.15e2 * t323 - 0.45e2 * t328 + 0.135e3 / 0.4e1 * t335 - 0.15e2 / 0.4e1 * t339);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = 0.2e1 * rho[0] * t354 + 0.6e1 * t216;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  t361 = t17 / t296 * params->prefactor * t137;
  t363 = t221 * t225;
  t368 = t135 * t49 * t276 * t25 * t91;
  t372 = t135 * t49 * t223 * t103;
  t375 = my_piecewise3(t3, 0, -0.45e2 / 0.16e2 * t361 - 0.135e3 / 0.32e2 * t363 - 0.45e2 / 0.16e2 * t368 + 0.45e2 / 0.64e2 * t372);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = 0.2e1 * rho[0] * t375 + 0.4e1 * t229;

  t384 = my_piecewise3(t3, 0, 0.45e2 / 0.2e1 * t361 + 0.135e3 / 0.4e1 * t363 + 0.45e2 / 0.2e1 * t368 - 0.45e2 / 0.8e1 * t372);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = 0.2e1 * rho[0] * t384 + 0.4e1 * t234;

  t393 = my_piecewise3(t3, 0, -0.180e3 * t361 - 0.270e3 * t363 - 0.180e3 * t368 + 0.45e2 * t372);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = 0.2e1 * rho[0] * t393 + 0.4e1 * t238;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  t397 = t17 * t298 * t243;
  t403 = t17 * t174 * params->prefactor * t49 * t276 * t59;
  t406 = my_piecewise3(t3, 0, 0.105e3 / 0.64e2 * t397 + 0.45e2 / 0.32e2 * t403);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = 0.2e1 * rho[0] * t406 + 0.2e1 * t246;

  t412 = my_piecewise3(t3, 0, -0.105e3 / 0.8e1 * t397 - 0.45e2 / 0.4e1 * t403);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = 0.2e1 * rho[0] * t412 + 0.2e1 * t249;

  t418 = my_piecewise3(t3, 0, 0.105e3 * t397 + 0.90e2 * t403);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = 0.2e1 * rho[0] * t418 + 0.2e1 * t252;

  t424 = my_piecewise3(t3, 0, -0.840e3 * t397 - 0.720e3 * t403);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = 0.2e1 * rho[0] * t424 + 0.2e1 * t255;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  t433 = t17 / t18 / t172 / t52 * params->prefactor * t49 * t325;
  t435 = my_piecewise3(t3, 0, -0.45e2 / 0.128e3 * t433);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = 0.2e1 * rho[0] * t435;

  t438 = my_piecewise3(t3, 0, 0.45e2 / 0.16e2 * t433);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = 0.2e1 * rho[0] * t438;

  t441 = my_piecewise3(t3, 0, -0.45e2 / 0.2e1 * t433);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = 0.2e1 * rho[0] * t441;

  t444 = my_piecewise3(t3, 0, 0.180e3 * t433);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = 0.2e1 * rho[0] * t444;

  t447 = my_piecewise3(t3, 0, -0.1440e4 * t433);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = 0.2e1 * rho[0] * t447;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}


static inline void
func_pol(const xc_func_type *p, int order, const double *rho, const double *sigma, const double *lapl, const double *tau , double *zk MGGA_OUT_PARAMS_NO_EXC(XC_COMMA double *, ))
{

#ifndef XC_DONT_COMPILE_EXC
  double t2, t3, t4, t5, t6, t9, t10, t13;
  double t14, t15, t17, t18, t19, t20, t21, t22;
  double t24, t25, t26, t29, t30, t31, t32, t33;
  double t34, t36, t41, t44, t47, t48, t49, t51;
  double t52, t53, t54, t56, t57, t59, t60, t62;
  double t67, t70, t73;

#ifndef XC_DONT_COMPILE_VXC
  double t74, t75, t76, t78, t81, t82, t86, t87;
  double t90, t91, t92, t93, t94, t95, t96, t98;
  double t103, t105, t109, t110, t112, t115, t116, t122;
  double t124, t128, t131, t132, t137, t139, t142, t143;
  double t147, t148, t149, t150, t152, t157, t159, t163;
  double t167, t168, t170, t172, t173, t175, t177, t179;

#ifndef XC_DONT_COMPILE_FXC
  double t182, t183, t184, t187, t188, t189, t192, t196;
  double t197, t202, t204, t208, t211, t212, t213, t214;
  double t217, t218, t220, t223, t225, t230, t232, t236;
  double t237, t238, t239, t242, t245, t249, t250, t255;
  double t259, t261, t264, t268, t272, t273, t278, t280;
  double t286, t287, t291, t295, t296, t301, t304, t307;
  double t308, t311, t316, t321, t325, t326, t332, t333;
  double t338, t342, t343, t348, t353, t354, t356, t359;
  double t361, t366, t368, t372, t375, t377, t378, t379;
  double t381, t382, t385, t386, t389, t391, t393, t394;
  double t396, t398, t401, t403, t405, t407, t408, t411;
  double t412, t415, t418, t422, t425, t427, t431, t437;
  double t440, t442, t443, t445, t447, t449, t450, t452;
  double t454, t456, t458, t460;

#ifndef XC_DONT_COMPILE_KXC
  double t464, t465, t468, t471, t472, t473, t476, t480;
  double t481, t487, t489, t490, t491, t493, t496, t498;
  double t502, t504, t508, t510, t511, t516, t519, t520;
  double t521, t522, t524, t526, t528, t533, t535, t538;
  double t539, t541, t542, t545, t548, t551, t555, t556;
  double t561, t564, t568, t570, t573, t574, t575, t578;
  double t583, t584, t586, t590, t591, t597, t598, t602;
  double t604, t606, t617, t618, t619, t622, t627, t629;
  double t633, t634, t640, t642, t646, t649, t651, t652;
  double t653, t656, t659, t664, t668, t672, t673, t678;
  double t680, t687, t688, t693, t697, t701, t702, t707;
  double t710, t713, t714, t720, t724, t726, t727, t732;
  double t739, t743, t744, t751, t752, t759, t763, t764;
  double t770, t771, t772, t774, t777, t779, t788, t793;
  double t795, t800, t802, t805, t806, t810, t812, t814;
  double t816, t818, t819, t820, t822, t826, t827, t829;
  double t831, t832, t835, t836, t839, t840, t842, t843;
  double t846, t848, t850, t851, t853, t855, t857, t859;
  double t861, t867, t869, t871, t874, t876, t878, t880;
  double t883, t886, t890, t893, t896, t898, t904, t905;
  double t907, t909, t910, t913, t914, t917, t918, t920;
  double t921, t928, t935, t936, t941, t943, t953, t963;
  double t969, t982, t983, t985, t987, t988, t989, t991;
  double t992, t995, t997, t998, t1001, t1003, t1005, t1006;
  double t1008, t1010, t1013, t1015, t1017, t1019, t1020, t1023;
  double t1025, t1026, t1029, t1032, t1036, t1039, t1041, t1045;
  double t1051, t1054, t1058, t1061, t1063, t1067, t1073, t1075;
  double t1076, t1078, t1079, t1081, t1082, t1083, t1085, t1086;
  double t1088, t1090, t1092, t1094, t1096, t1098, t1100;

#ifndef XC_DONT_COMPILE_LXC
  double t1103, t1104, t1108, t1109, t1112, t1113, t1118, t1123;
  double t1127, t1129, t1131, t1135, t1136, t1137, t1139, t1141;
  double t1142, t1145, t1155, t1162, t1174, t1177, t1179, t1182;
  double t1185, t1187, t1189, t1190, t1196, t1202, t1203, t1206;
  double t1210, t1215, t1217, t1218, t1220, t1221, t1227, t1232;
  double t1235, t1239, t1245, t1248, t1251, t1255, t1257, t1264;
  double t1273, t1274, t1278, t1279, t1280, t1281, t1285, t1288;
  double t1300, t1303, t1306, t1307, t1324, t1325, t1327, t1331;
  double t1336, t1338, t1355, t1357, t1361, t1367, t1370, t1371;
  double t1373, t1378, t1381, t1382, t1384, t1385, t1386, t1387;
  double t1388, t1390, t1391, t1399, t1401, t1405, t1407, t1408;
  double t1436, t1449, t1453, t1458, t1460, t1466, t1469, t1471;
  double t1480, t1482, t1484, t1485, t1487, t1488, t1490, t1492;
  double t1505, t1518, t1522, t1527, t1529, t1550, t1554, t1560;
  double t1562, t1571, t1572, t1577, t1584, t1585, t1587, t1589;
  double t1591, t1593, t1599, t1603, t1623, t1627, t1635, t1639;
  double t1641, t1646, t1651, t1658, t1662, t1671, t1677, t1687;
  double t1695, t1696, t1701, t1711, t1728, t1733, t1740, t1744;
  double t1752, t1754, t1760, t1762, t1764, t1765, t1766, t1768;
  double t1770, t1772, t1774, t1776, t1778, t1780, t1782, t1784;
  double t1785, t1787, t1789, t1791, t1796, t1801, t1806, t1808;
  double t1810, t1814, t1818, t1820, t1822, t1828, t1830, t1832;
  double t1835, t1837, t1839, t1841, t1842, t1844, t1846, t1847;
  double t1849, t1851, t1852, t1853, t1855, t1857, t1859, t1860;
  double t1861, t1862, t1865, t1872, t1874, t1878, t1880, t1882;
  double t1884, t1885, t1887, t1888, t1889, t1893, t1895, t1896;
  double t1897, t1899, t1901, t1902, t1903, t1905, t1906, t1908;
  double t1910, t1912, t1914, t1920, t1921, t1923, t1925, t1928;
  double t1930, t1932, t1934, t1937, t1940, t1942, t1944, t1946;
  double t1948, t1950, t1952, t1954, t1956, t1958, t1961, t1966;
  double t1972, t1974, t1976, t1978, t1987, t1992, t1994, t1998;
  double t2000, t2002, t2009, t2013, t2015, t2017, t2026, t2028;
  double t2030, t2035, t2045, t2059, t2061, t2067, t2069, t2071;
  double t2074, t2078, t2079, t2082, t2094, t2096, t2098, t2100;
  double t2105, t2108, t2110, t2111, t2121, t2122, t2132, t2143;
  double t2145, t2152, t2166, t2180, t2182, t2185, t2187, t2189;
  double t2191, t2193, t2194, t2195, t2197, t2202, t2207, t2211;
  double t2217, t2219, t2220, t2223, t2225, t2227, t2228, t2230;
  double t2232, t2234, t2236, t2238, t2244, t2246, t2248, t2251;
  double t2253, t2255, t2257, t2260, t2263, t2267, t2270, t2273;
  double t2275, t2282, t2287, t2291, t2297, t2299, t2300, t2307;
  double t2314, t2315, t2320, t2322, t2332, t2342, t2348, t2361;
  double t2362, t2369, t2376, t2377, t2382, t2384, t2394, t2404;
  double t2410, t2423, t2424, t2426, t2428, t2429, t2433, t2435;
  double t2439, t2442, t2444, t2446, t2447, t2449, t2451, t2454;
  double t2456, t2461, t2463, t2467, t2470, t2473, t2477, t2480;
  double t2482, t2486, t2492, t2495, t2499, t2502, t2504, t2508;
  double t2514, t2517, t2521, t2524, t2526, t2530, t2536, t2542;
  double t2544, t2549, t2551, t2553, t2555, t2557, t2559, t2561;
  double t2563, t2565, t2567;
#endif

#endif

#endif

#endif

#endif


  mgga_x_rlda_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rlda_params * )(p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRTPI;
  t4 = t3 * t3;
  t5 = rho[0] + rho[1];
  t6 = 0.1e1 / t5;
  t9 = 0.2e1 * rho[0] * t6 <= p->zeta_threshold;
  t10 = p->zeta_threshold - 0.1e1;
  t13 = 0.2e1 * rho[1] * t6 <= p->zeta_threshold;
  t14 = -t10;
  t15 = rho[0] - rho[1];
  t17 = my_piecewise5(t9, t10, t13, t14, t15 * t6);
  t18 = 0.1e1 + t17;
  t19 = t18 <= p->zeta_threshold;
  t20 = POW_1_3(p->zeta_threshold);
  t21 = t20 * p->zeta_threshold;
  t22 = POW_1_3(t18);
  t24 = my_piecewise3(t19, t21, t22 * t18);
  t25 = t4 * t24;
  t26 = POW_1_3(t5);
  t29 = POW_1_3(0.1e1 / M_PI);
  t30 = 0.1e1 / t29;
  t31 = params->prefactor * t30;
  t32 = M_CBRT4;
  t33 = POW_1_3(rho[0]);
  t34 = t33 * t33;
  t36 = 0.1e1 / t34 / rho[0];
  t41 = 0.2e1 * tau[0] * t36 - lapl[0] * t36 / 0.4e1;
  t44 = t31 * t32 / t41;
  t47 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t25 * t26 * t44);
  t48 = rho[1] <= p->dens_threshold;
  t49 = -t15;
  t51 = my_piecewise5(t13, t10, t9, t14, t49 * t6);
  t52 = 0.1e1 + t51;
  t53 = t52 <= p->zeta_threshold;
  t54 = POW_1_3(t52);
  t56 = my_piecewise3(t53, t21, t54 * t52);
  t57 = t4 * t56;
  t59 = POW_1_3(rho[1]);
  t60 = t59 * t59;
  t62 = 0.1e1 / t60 / rho[1];
  t67 = 0.2e1 * tau[1] * t62 - lapl[1] * t62 / 0.4e1;
  t70 = t31 * t32 / t67;
  t73 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t57 * t26 * t70);
  if(zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    zk[0] = t47 + t73;

#ifndef XC_DONT_COMPILE_VXC

  if(order < 1) return;


  t74 = t5 * t5;
  t75 = 0.1e1 / t74;
  t76 = t15 * t75;
  t78 = my_piecewise5(t9, 0, t13, 0, t6 - t76);
  t81 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t78);
  t82 = t4 * t81;
  t86 = t26 * t26;
  t87 = 0.1e1 / t86;
  t90 = 0.5e1 / 0.16e2 * t25 * t87 * t44;
  t91 = t26 * params->prefactor;
  t92 = t25 * t91;
  t93 = t30 * t32;
  t94 = t41 * t41;
  t95 = 0.1e1 / t94;
  t96 = rho[0] * rho[0];
  t98 = 0.1e1 / t34 / t96;
  t103 = -0.10e2 / 0.3e1 * tau[0] * t98 + 0.5e1 / 0.12e2 * lapl[0] * t98;
  t105 = t93 * t95 * t103;
  t109 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t82 * t26 * t44 - t90 + 0.15e2 / 0.16e2 * t92 * t105);
  t110 = t49 * t75;
  t112 = my_piecewise5(t13, 0, t9, 0, -t6 - t110);
  t115 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t112);
  t116 = t4 * t115;
  t122 = 0.5e1 / 0.16e2 * t57 * t87 * t70;
  t124 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t116 * t26 * t70 - t122);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[0] = t47 + t73 + t5 * (t109 + t124);

  t128 = my_piecewise5(t9, 0, t13, 0, -t6 - t76);
  t131 = my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t22 * t128);
  t132 = t4 * t131;
  t137 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t132 * t26 * t44 - t90);
  t139 = my_piecewise5(t13, 0, t9, 0, t6 - t110);
  t142 = my_piecewise3(t53, 0, 0.4e1 / 0.3e1 * t54 * t139);
  t143 = t4 * t142;
  t147 = t57 * t91;
  t148 = t67 * t67;
  t149 = 0.1e1 / t148;
  t150 = rho[1] * rho[1];
  t152 = 0.1e1 / t60 / t150;
  t157 = -0.10e2 / 0.3e1 * tau[1] * t152 + 0.5e1 / 0.12e2 * lapl[1] * t152;
  t159 = t93 * t149 * t157;
  t163 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t143 * t26 * t70 - t122 + 0.15e2 / 0.16e2 * t147 * t159);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vrho[1] = t47 + t73 + t5 * (t137 + t163);

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[0] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[1] = 0.0e0;

  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vsigma[2] = 0.0e0;

  t167 = t93 * t95 * t36;
  t168 = t92 * t167;
  t170 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t168);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[0] = t5 * t170;

  t172 = t93 * t149 * t62;
  t173 = t147 * t172;
  t175 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t173);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vlapl[1] = t5 * t175;

  t177 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t168);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[0] = t5 * t177;

  t179 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t173);
  if(vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    vtau[1] = t5 * t179;

#ifndef XC_DONT_COMPILE_FXC

  if(order < 2) return;


  t182 = t22 * t22;
  t183 = 0.1e1 / t182;
  t184 = t78 * t78;
  t187 = t74 * t5;
  t188 = 0.1e1 / t187;
  t189 = t15 * t188;
  t192 = my_piecewise5(t9, 0, t13, 0, -0.2e1 * t75 + 0.2e1 * t189);
  t196 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t183 * t184 + 0.4e1 / 0.3e1 * t22 * t192);
  t197 = t4 * t196;
  t202 = t82 * t87 * t44;
  t204 = t82 * t91;
  t208 = 0.1e1 / t86 / t5;
  t211 = 0.5e1 / 0.24e2 * t25 * t208 * t44;
  t212 = t87 * params->prefactor;
  t213 = t25 * t212;
  t214 = t213 * t105;
  t217 = 0.1e1 / t94 / t41;
  t218 = t103 * t103;
  t220 = t93 * t217 * t218;
  t223 = t96 * rho[0];
  t225 = 0.1e1 / t34 / t223;
  t230 = 0.80e2 / 0.9e1 * tau[0] * t225 - 0.10e2 / 0.9e1 * lapl[0] * t225;
  t232 = t93 * t95 * t230;
  t236 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t197 * t26 * t44 - 0.5e1 / 0.8e1 * t202 + 0.15e2 / 0.8e1 * t204 * t105 + t211 + 0.5e1 / 0.8e1 * t214 - 0.15e2 / 0.8e1 * t92 * t220 + 0.15e2 / 0.16e2 * t92 * t232);
  t237 = t54 * t54;
  t238 = 0.1e1 / t237;
  t239 = t112 * t112;
  t242 = t49 * t188;
  t245 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t75 + 0.2e1 * t242);
  t249 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t238 * t239 + 0.4e1 / 0.3e1 * t54 * t245);
  t250 = t4 * t249;
  t255 = t116 * t87 * t70;
  t259 = 0.5e1 / 0.24e2 * t57 * t208 * t70;
  t261 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t250 * t26 * t70 - 0.5e1 / 0.8e1 * t255 + t259);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[0] = 0.2e1 * t109 + 0.2e1 * t124 + t5 * (t236 + t261);

  t264 = t183 * t128;
  t268 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t189);
  t272 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t264 * t78 + 0.4e1 / 0.3e1 * t22 * t268);
  t273 = t4 * t272;
  t278 = t132 * t87 * t44;
  t280 = t132 * t91;
  t286 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t273 * t26 * t44 - 0.5e1 / 0.16e2 * t278 + 0.15e2 / 0.16e2 * t280 * t105 - 0.5e1 / 0.16e2 * t202 + t211 + 0.5e1 / 0.16e2 * t214);
  t287 = t238 * t139;
  t291 = my_piecewise5(t13, 0, t9, 0, 0.2e1 * t242);
  t295 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t287 * t112 + 0.4e1 / 0.3e1 * t54 * t291);
  t296 = t4 * t295;
  t301 = t143 * t87 * t70;
  t304 = t116 * t91;
  t307 = t57 * t212;
  t308 = t307 * t159;
  t311 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t296 * t26 * t70 - 0.5e1 / 0.16e2 * t301 - 0.5e1 / 0.16e2 * t255 + t259 + 0.15e2 / 0.16e2 * t304 * t159 + 0.5e1 / 0.16e2 * t308);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[1] = t109 + t124 + t137 + t163 + t5 * (t286 + t311);

  t316 = t128 * t128;
  t321 = my_piecewise5(t9, 0, t13, 0, 0.2e1 * t75 + 0.2e1 * t189);
  t325 = my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t183 * t316 + 0.4e1 / 0.3e1 * t22 * t321);
  t326 = t4 * t325;
  t332 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t326 * t26 * t44 - 0.5e1 / 0.8e1 * t278 + t211);
  t333 = t139 * t139;
  t338 = my_piecewise5(t13, 0, t9, 0, -0.2e1 * t75 + 0.2e1 * t242);
  t342 = my_piecewise3(t53, 0, 0.4e1 / 0.9e1 * t238 * t333 + 0.4e1 / 0.3e1 * t54 * t338);
  t343 = t4 * t342;
  t348 = t143 * t91;
  t353 = 0.1e1 / t148 / t67;
  t354 = t157 * t157;
  t356 = t93 * t353 * t354;
  t359 = t150 * rho[1];
  t361 = 0.1e1 / t60 / t359;
  t366 = 0.80e2 / 0.9e1 * tau[1] * t361 - 0.10e2 / 0.9e1 * lapl[1] * t361;
  t368 = t93 * t149 * t366;
  t372 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t343 * t26 * t70 - 0.5e1 / 0.8e1 * t301 + 0.15e2 / 0.8e1 * t348 * t159 + t259 + 0.5e1 / 0.8e1 * t308 - 0.15e2 / 0.8e1 * t147 * t356 + 0.15e2 / 0.16e2 * t147 * t368);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rho2[2] = 0.2e1 * t137 + 0.2e1 * t163 + t5 * (t332 + t372);

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhosigma[5] = 0.0e0;

  t375 = t204 * t167;
  t377 = t213 * t167;
  t378 = 0.5e1 / 0.64e2 * t377;
  t379 = t217 * t36;
  t381 = t93 * t379 * t103;
  t382 = t92 * t381;
  t385 = t93 * t95 * t98;
  t386 = t92 * t385;
  t389 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t375 - t378 + 0.15e2 / 0.32e2 * t382 + 0.25e2 / 0.64e2 * t386);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[0] = t5 * t389 + t170;

  t391 = t304 * t172;
  t393 = t307 * t172;
  t394 = 0.5e1 / 0.64e2 * t393;
  t396 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t391 - t394);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[1] = t5 * t396 + t175;

  t398 = t280 * t167;
  t401 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t398 - t378);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[2] = t5 * t401 + t170;

  t403 = t348 * t172;
  t405 = t353 * t62;
  t407 = t93 * t405 * t157;
  t408 = t147 * t407;
  t411 = t93 * t149 * t152;
  t412 = t147 * t411;
  t415 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t403 - t394 + 0.15e2 / 0.32e2 * t408 + 0.25e2 / 0.64e2 * t412);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rholapl[3] = t5 * t415 + t175;

  t418 = 0.5e1 / 0.8e1 * t377;
  t422 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t375 + t418 - 0.15e2 / 0.4e1 * t382 - 0.25e2 / 0.8e1 * t386);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[0] = t5 * t422 + t177;

  t425 = 0.5e1 / 0.8e1 * t393;
  t427 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t391 + t425);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[1] = t5 * t427 + t179;

  t431 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t398 + t418);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[2] = t5 * t431 + t177;

  t437 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t403 + t425 - 0.15e2 / 0.4e1 * t408 - 0.25e2 / 0.8e1 * t412);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2rhotau[3] = t5 * t437 + t179;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigma2[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmalapl[5] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[0] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[2] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[3] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[4] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2sigmatau[5] = 0.0e0;

  t440 = 0.1e1 / t33 / t223;
  t442 = t93 * t217 * t440;
  t443 = t92 * t442;
  t445 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t443);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[0] = t5 * t445;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[1] = 0.0e0;

  t447 = 0.1e1 / t59 / t359;
  t449 = t93 * t353 * t447;
  t450 = t147 * t449;
  t452 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t450);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapl2[2] = t5 * t452;

  t454 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t443);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[0] = t5 * t454;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[1] = 0.0e0;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[2] = 0.0e0;

  t456 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t450);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2lapltau[3] = t5 * t456;

  t458 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t443);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[0] = t5 * t458;

  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[1] = 0.0e0;

  t460 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t450);
  if(v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    v2tau2[2] = t5 * t460;

#ifndef XC_DONT_COMPILE_KXC

  if(order < 3) return;


  t464 = 0.1e1 / t182 / t18;
  t465 = t184 * t78;
  t468 = t183 * t78;
  t471 = t74 * t74;
  t472 = 0.1e1 / t471;
  t473 = t15 * t472;
  t476 = my_piecewise5(t9, 0, t13, 0, 0.6e1 * t188 - 0.6e1 * t473);
  t480 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t464 * t465 + 0.4e1 / 0.3e1 * t468 * t192 + 0.4e1 / 0.3e1 * t22 * t476);
  t481 = t4 * t480;
  t487 = t213 * t220;
  t489 = t94 * t94;
  t490 = 0.1e1 / t489;
  t491 = t218 * t103;
  t493 = t93 * t490 * t491;
  t496 = t217 * t103;
  t498 = t93 * t496 * t230;
  t502 = t197 * t87 * t44;
  t504 = t197 * t91;
  t508 = t82 * t208 * t44;
  t510 = t82 * t212;
  t511 = t510 * t105;
  t516 = 0.1e1 / t86 / t74;
  t519 = 0.25e2 / 0.72e2 * t25 * t516 * t44;
  t520 = t208 * params->prefactor;
  t521 = t25 * t520;
  t522 = t521 * t105;
  t524 = t213 * t232;
  t526 = t96 * t96;
  t528 = 0.1e1 / t34 / t526;
  t533 = -0.880e3 / 0.27e2 * tau[0] * t528 + 0.110e3 / 0.27e2 * lapl[0] * t528;
  t535 = t93 * t95 * t533;
  t538 = -0.15e2 / 0.16e2 * t481 * t26 * t44 - 0.45e2 / 0.8e1 * t204 * t220 - 0.15e2 / 0.8e1 * t487 + 0.45e2 / 0.8e1 * t92 * t493 - 0.45e2 / 0.8e1 * t92 * t498 - 0.15e2 / 0.16e2 * t502 + 0.45e2 / 0.16e2 * t504 * t105 + 0.5e1 / 0.8e1 * t508 + 0.15e2 / 0.8e1 * t511 + 0.45e2 / 0.16e2 * t204 * t232 - t519 - 0.5e1 / 0.8e1 * t522 + 0.15e2 / 0.16e2 * t524 + 0.15e2 / 0.16e2 * t92 * t535;
  t539 = my_piecewise3(t2, 0, t538);
  t541 = 0.1e1 / t237 / t52;
  t542 = t239 * t112;
  t545 = t238 * t112;
  t548 = t49 * t472;
  t551 = my_piecewise5(t13, 0, t9, 0, -0.6e1 * t188 - 0.6e1 * t548);
  t555 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t541 * t542 + 0.4e1 / 0.3e1 * t545 * t245 + 0.4e1 / 0.3e1 * t54 * t551);
  t556 = t4 * t555;
  t561 = t250 * t87 * t70;
  t564 = t116 * t208 * t70;
  t568 = 0.25e2 / 0.72e2 * t57 * t516 * t70;
  t570 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t556 * t26 * t70 - 0.15e2 / 0.16e2 * t561 + 0.5e1 / 0.8e1 * t564 - t568);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[0] = 0.3e1 * t236 + 0.3e1 * t261 + t5 * (t539 + t570);

  t573 = 0.2e1 * t286;
  t574 = 0.2e1 * t311;
  t575 = t464 * t128;
  t578 = t183 * t268;
  t583 = 0.2e1 * t188;
  t584 = 0.6e1 * t473;
  t586 = my_piecewise5(t9, 0, t13, 0, t583 - t584);
  t590 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t575 * t184 + 0.8e1 / 0.9e1 * t578 * t78 + 0.4e1 / 0.9e1 * t264 * t192 + 0.4e1 / 0.3e1 * t22 * t586);
  t591 = t4 * t590;
  t597 = 0.5e1 / 0.8e1 * t273 * t87 * t44;
  t598 = t273 * t91;
  t602 = t132 * t208 * t44;
  t604 = t132 * t212;
  t606 = 0.5e1 / 0.8e1 * t604 * t105;
  t617 = -0.15e2 / 0.16e2 * t591 * t26 * t44 - t597 + 0.15e2 / 0.8e1 * t598 * t105 + 0.5e1 / 0.24e2 * t602 + t606 - 0.15e2 / 0.8e1 * t280 * t220 + 0.15e2 / 0.16e2 * t280 * t232 - 0.5e1 / 0.16e2 * t502 + 0.5e1 / 0.12e2 * t508 + 0.5e1 / 0.8e1 * t511 - t519 - 0.5e1 / 0.12e2 * t522 - 0.5e1 / 0.8e1 * t487 + 0.5e1 / 0.16e2 * t524;
  t618 = my_piecewise3(t2, 0, t617);
  t619 = t541 * t139;
  t622 = t238 * t291;
  t627 = 0.6e1 * t548;
  t629 = my_piecewise5(t13, 0, t9, 0, -t583 - t627);
  t633 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t619 * t239 + 0.8e1 / 0.9e1 * t622 * t112 + 0.4e1 / 0.9e1 * t287 * t245 + 0.4e1 / 0.3e1 * t54 * t629);
  t634 = t4 * t633;
  t640 = 0.5e1 / 0.8e1 * t296 * t87 * t70;
  t642 = t143 * t208 * t70;
  t646 = t250 * t91;
  t649 = t116 * t212;
  t651 = 0.5e1 / 0.8e1 * t649 * t159;
  t652 = t57 * t520;
  t653 = t652 * t159;
  t656 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t634 * t26 * t70 - t640 + 0.5e1 / 0.24e2 * t642 - 0.5e1 / 0.16e2 * t561 + 0.5e1 / 0.12e2 * t564 - t568 + 0.15e2 / 0.16e2 * t646 * t159 + t651 - 0.5e1 / 0.24e2 * t653);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[1] = t236 + t261 + t573 + t574 + t5 * (t618 + t656);

  t659 = t464 * t316;
  t664 = t183 * t321;
  t668 = my_piecewise5(t9, 0, t13, 0, -t583 - t584);
  t672 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t659 * t78 + 0.8e1 / 0.9e1 * t264 * t268 + 0.4e1 / 0.9e1 * t664 * t78 + 0.4e1 / 0.3e1 * t22 * t668);
  t673 = t4 * t672;
  t678 = t326 * t87 * t44;
  t680 = t326 * t91;
  t687 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t673 * t26 * t44 - 0.5e1 / 0.16e2 * t678 + 0.15e2 / 0.16e2 * t680 * t105 - t597 + 0.5e1 / 0.12e2 * t602 + t606 + 0.5e1 / 0.24e2 * t508 - t519 - 0.5e1 / 0.24e2 * t522);
  t688 = t541 * t333;
  t693 = t238 * t338;
  t697 = my_piecewise5(t13, 0, t9, 0, t583 - t627);
  t701 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t688 * t112 + 0.8e1 / 0.9e1 * t287 * t291 + 0.4e1 / 0.9e1 * t693 * t112 + 0.4e1 / 0.3e1 * t54 * t697);
  t702 = t4 * t701;
  t707 = t343 * t87 * t70;
  t710 = t296 * t91;
  t713 = t143 * t212;
  t714 = t713 * t159;
  t720 = t307 * t356;
  t724 = t307 * t368;
  t726 = -0.15e2 / 0.16e2 * t702 * t26 * t70 - 0.5e1 / 0.16e2 * t707 - t640 + 0.5e1 / 0.12e2 * t642 + 0.15e2 / 0.8e1 * t710 * t159 + 0.5e1 / 0.8e1 * t714 + 0.5e1 / 0.24e2 * t564 - t568 + t651 - 0.5e1 / 0.12e2 * t653 - 0.15e2 / 0.8e1 * t304 * t356 - 0.5e1 / 0.8e1 * t720 + 0.15e2 / 0.16e2 * t304 * t368 + 0.5e1 / 0.16e2 * t724;
  t727 = my_piecewise3(t48, 0, t726);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[2] = t573 + t574 + t332 + t372 + t5 * (t687 + t727);

  t732 = t316 * t128;
  t739 = my_piecewise5(t9, 0, t13, 0, -0.6e1 * t188 - 0.6e1 * t473);
  t743 = my_piecewise3(t19, 0, -0.8e1 / 0.27e2 * t464 * t732 + 0.4e1 / 0.3e1 * t264 * t321 + 0.4e1 / 0.3e1 * t22 * t739);
  t744 = t4 * t743;
  t751 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t744 * t26 * t44 - 0.15e2 / 0.16e2 * t678 + 0.5e1 / 0.8e1 * t602 - t519);
  t752 = t333 * t139;
  t759 = my_piecewise5(t13, 0, t9, 0, 0.6e1 * t188 - 0.6e1 * t548);
  t763 = my_piecewise3(t53, 0, -0.8e1 / 0.27e2 * t541 * t752 + 0.4e1 / 0.3e1 * t287 * t338 + 0.4e1 / 0.3e1 * t54 * t759);
  t764 = t4 * t763;
  t770 = t148 * t148;
  t771 = 0.1e1 / t770;
  t772 = t354 * t157;
  t774 = t93 * t771 * t772;
  t777 = t353 * t157;
  t779 = t93 * t777 * t366;
  t788 = t343 * t91;
  t793 = t150 * t150;
  t795 = 0.1e1 / t60 / t793;
  t800 = -0.880e3 / 0.27e2 * tau[1] * t795 + 0.110e3 / 0.27e2 * lapl[1] * t795;
  t802 = t93 * t149 * t800;
  t805 = -0.15e2 / 0.16e2 * t764 * t26 * t70 - 0.45e2 / 0.8e1 * t348 * t356 + 0.45e2 / 0.8e1 * t147 * t774 - 0.45e2 / 0.8e1 * t147 * t779 + 0.15e2 / 0.8e1 * t714 - 0.15e2 / 0.8e1 * t720 + 0.15e2 / 0.16e2 * t724 - 0.5e1 / 0.8e1 * t653 - t568 + 0.5e1 / 0.8e1 * t642 - 0.15e2 / 0.16e2 * t707 + 0.45e2 / 0.16e2 * t788 * t159 + 0.45e2 / 0.16e2 * t348 * t368 + 0.15e2 / 0.16e2 * t147 * t802;
  t806 = my_piecewise3(t48, 0, t805);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho3[3] = 0.3e1 * t332 + 0.3e1 * t372 + t5 * (t751 + t806);

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2sigma[8] = 0.0e0;

  t810 = t504 * t167;
  t812 = t510 * t167;
  t814 = t204 * t381;
  t816 = t204 * t385;
  t818 = t521 * t167;
  t819 = 0.5e1 / 0.96e2 * t818;
  t820 = t213 * t381;
  t822 = t213 * t385;
  t826 = t93 * t490 * t36 * t218;
  t827 = t92 * t826;
  t829 = t217 * t98;
  t831 = t93 * t829 * t103;
  t832 = t92 * t831;
  t835 = t93 * t379 * t230;
  t836 = t92 * t835;
  t839 = t93 * t95 * t225;
  t840 = t92 * t839;
  t842 = -0.15e2 / 0.64e2 * t810 - 0.5e1 / 0.32e2 * t812 + 0.15e2 / 0.16e2 * t814 + 0.25e2 / 0.32e2 * t816 + t819 + 0.5e1 / 0.16e2 * t820 + 0.25e2 / 0.96e2 * t822 - 0.45e2 / 0.32e2 * t827 - 0.25e2 / 0.16e2 * t832 + 0.15e2 / 0.32e2 * t836 - 0.25e2 / 0.24e2 * t840;
  t843 = my_piecewise3(t2, 0, t842);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[0] = t5 * t843 + 0.2e1 * t389;

  t846 = t646 * t172;
  t848 = t649 * t172;
  t850 = t652 * t172;
  t851 = 0.5e1 / 0.96e2 * t850;
  t853 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t846 - 0.5e1 / 0.32e2 * t848 + t851);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[1] = t5 * t853 + 0.2e1 * t396;

  t855 = t598 * t167;
  t857 = t604 * t167;
  t859 = t280 * t381;
  t861 = t280 * t385;
  t867 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t855 - 0.5e1 / 0.64e2 * t857 + 0.15e2 / 0.32e2 * t859 + 0.25e2 / 0.64e2 * t861 - 0.5e1 / 0.64e2 * t812 + t819 + 0.5e1 / 0.32e2 * t820 + 0.25e2 / 0.192e3 * t822);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[2] = t5 * t867 + t389 + t401;

  t869 = t710 * t172;
  t871 = t713 * t172;
  t874 = t304 * t407;
  t876 = t307 * t407;
  t878 = t304 * t411;
  t880 = t307 * t411;
  t883 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t869 - 0.5e1 / 0.64e2 * t871 - 0.5e1 / 0.64e2 * t848 + t851 + 0.15e2 / 0.32e2 * t874 + 0.5e1 / 0.32e2 * t876 + 0.25e2 / 0.64e2 * t878 + 0.25e2 / 0.192e3 * t880);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[3] = t5 * t883 + t396 + t415;

  t886 = t680 * t167;
  t890 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t886 - 0.5e1 / 0.32e2 * t857 + t819);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[4] = t5 * t890 + 0.2e1 * t401;

  t893 = t788 * t172;
  t896 = t348 * t407;
  t898 = t348 * t411;
  t904 = t93 * t771 * t62 * t354;
  t905 = t147 * t904;
  t907 = t353 * t152;
  t909 = t93 * t907 * t157;
  t910 = t147 * t909;
  t913 = t93 * t405 * t366;
  t914 = t147 * t913;
  t917 = t93 * t149 * t361;
  t918 = t147 * t917;
  t920 = -0.15e2 / 0.64e2 * t893 - 0.5e1 / 0.32e2 * t871 + 0.15e2 / 0.16e2 * t896 + 0.25e2 / 0.32e2 * t898 + t851 + 0.5e1 / 0.16e2 * t876 + 0.25e2 / 0.96e2 * t880 - 0.45e2 / 0.32e2 * t905 - 0.25e2 / 0.16e2 * t910 + 0.15e2 / 0.32e2 * t914 - 0.25e2 / 0.24e2 * t918;
  t921 = my_piecewise3(t48, 0, t920);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2lapl[5] = t5 * t921 + 0.2e1 * t415;

  t928 = 0.5e1 / 0.12e2 * t818;
  t935 = 0.15e2 / 0.8e1 * t810 + 0.5e1 / 0.4e1 * t812 - 0.15e2 / 0.2e1 * t814 - 0.25e2 / 0.4e1 * t816 - t928 - 0.5e1 / 0.2e1 * t820 - 0.25e2 / 0.12e2 * t822 + 0.45e2 / 0.4e1 * t827 + 0.25e2 / 0.2e1 * t832 - 0.15e2 / 0.4e1 * t836 + 0.25e2 / 0.3e1 * t840;
  t936 = my_piecewise3(t2, 0, t935);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[0] = t5 * t936 + 0.2e1 * t422;

  t941 = 0.5e1 / 0.12e2 * t850;
  t943 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t846 + 0.5e1 / 0.4e1 * t848 - t941);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[1] = t5 * t943 + 0.2e1 * t427;

  t953 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t855 + 0.5e1 / 0.8e1 * t857 - 0.15e2 / 0.4e1 * t859 - 0.25e2 / 0.8e1 * t861 + 0.5e1 / 0.8e1 * t812 - t928 - 0.5e1 / 0.4e1 * t820 - 0.25e2 / 0.24e2 * t822);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[2] = t5 * t953 + t422 + t431;

  t963 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t869 + 0.5e1 / 0.8e1 * t871 + 0.5e1 / 0.8e1 * t848 - t941 - 0.15e2 / 0.4e1 * t874 - 0.5e1 / 0.4e1 * t876 - 0.25e2 / 0.8e1 * t878 - 0.25e2 / 0.24e2 * t880);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[3] = t5 * t963 + t427 + t437;

  t969 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t886 + 0.5e1 / 0.4e1 * t857 - t928);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[4] = t5 * t969 + 0.2e1 * t431;

  t982 = 0.15e2 / 0.8e1 * t893 + 0.5e1 / 0.4e1 * t871 - 0.15e2 / 0.2e1 * t896 - 0.25e2 / 0.4e1 * t898 - t941 - 0.5e1 / 0.2e1 * t876 - 0.25e2 / 0.12e2 * t880 + 0.45e2 / 0.4e1 * t905 + 0.25e2 / 0.2e1 * t910 - 0.15e2 / 0.4e1 * t914 + 0.25e2 / 0.3e1 * t918;
  t983 = my_piecewise3(t48, 0, t982);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rho2tau[5] = t5 * t983 + 0.2e1 * t437;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigma2[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmalapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhosigmatau[11] = 0.0e0;

  t985 = t204 * t442;
  t987 = t213 * t442;
  t988 = 0.5e1 / 0.128e3 * t987;
  t989 = t490 * t440;
  t991 = t93 * t989 * t103;
  t992 = t92 * t991;
  t995 = 0.1e1 / t33 / t526;
  t997 = t93 * t217 * t995;
  t998 = t92 * t997;
  t1001 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t985 - t988 + 0.45e2 / 0.128e3 * t992 + 0.25e2 / 0.64e2 * t998);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[0] = t5 * t1001 + t445;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[1] = 0.0e0;

  t1003 = t304 * t449;
  t1005 = t307 * t449;
  t1006 = 0.5e1 / 0.128e3 * t1005;
  t1008 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t1003 - t1006);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[2] = t5 * t1008 + t452;

  t1010 = t280 * t442;
  t1013 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t1010 - t988);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[3] = t5 * t1013 + t445;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[4] = 0.0e0;

  t1015 = t348 * t449;
  t1017 = t771 * t447;
  t1019 = t93 * t1017 * t157;
  t1020 = t147 * t1019;
  t1023 = 0.1e1 / t59 / t793;
  t1025 = t93 * t353 * t1023;
  t1026 = t147 * t1025;
  t1029 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t1015 - t1006 + 0.45e2 / 0.128e3 * t1020 + 0.25e2 / 0.64e2 * t1026);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapl2[5] = t5 * t1029 + t452;

  t1032 = 0.5e1 / 0.16e2 * t987;
  t1036 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t985 + t1032 - 0.45e2 / 0.16e2 * t992 - 0.25e2 / 0.8e1 * t998);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[0] = t5 * t1036 + t454;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[2] = 0.0e0;

  t1039 = 0.5e1 / 0.16e2 * t1005;
  t1041 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t1003 + t1039);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[3] = t5 * t1041 + t456;

  t1045 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t1010 + t1032);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[4] = t5 * t1045 + t454;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[6] = 0.0e0;

  t1051 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t1015 + t1039 - 0.45e2 / 0.16e2 * t1020 - 0.25e2 / 0.8e1 * t1026);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rholapltau[7] = t5 * t1051 + t456;

  t1054 = 0.5e1 / 0.2e1 * t987;
  t1058 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t985 - t1054 + 0.45e2 / 0.2e1 * t992 + 0.25e2 * t998);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[0] = t5 * t1058 + t458;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[1] = 0.0e0;

  t1061 = 0.5e1 / 0.2e1 * t1005;
  t1063 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t1003 - t1061);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[2] = t5 * t1063 + t460;

  t1067 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t1010 - t1054);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[3] = t5 * t1067 + t458;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[4] = 0.0e0;

  t1073 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t1015 - t1061 + 0.45e2 / 0.2e1 * t1020 + 0.25e2 * t1026);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3rhotau2[5] = t5 * t1073 + t460;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma3[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2lapl[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigma2tau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapl2[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[8] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[9] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[10] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmalapltau[11] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[0] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[4] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[5] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[6] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[7] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3sigmatau2[8] = 0.0e0;

  t1075 = t526 * rho[0];
  t1076 = 0.1e1 / t1075;
  t1078 = t93 * t490 * t1076;
  t1079 = t92 * t1078;
  t1081 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t1079);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[0] = t5 * t1081;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[2] = 0.0e0;

  t1082 = t793 * rho[1];
  t1083 = 0.1e1 / t1082;
  t1085 = t93 * t771 * t1083;
  t1086 = t147 * t1085;
  t1088 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t1086);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl3[3] = t5 * t1088;

  t1090 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t1079);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[0] = t5 * t1090;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[4] = 0.0e0;

  t1092 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t1086);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapl2tau[5] = t5 * t1092;

  t1094 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t1079);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[0] = t5 * t1094;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[2] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[3] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[4] = 0.0e0;

  t1096 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t1086);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3lapltau2[5] = t5 * t1096;

  t1098 = my_piecewise3(t2, 0, 0.45e2 * t1079);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[0] = t5 * t1098;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[1] = 0.0e0;

  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[2] = 0.0e0;

  t1100 = my_piecewise3(t48, 0, 0.45e2 * t1086);
  if(v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    v3tau3[3] = t5 * t1100;

#ifndef XC_DONT_COMPILE_LXC

  if(order < 4) return;


  t1103 = t197 * t212;
  t1104 = t1103 * t105;
  t1108 = t82 * t520;
  t1109 = t1108 * t105;
  t1112 = 0.1e1 / t489 / t41;
  t1113 = t218 * t218;
  t1118 = t230 * t230;
  t1123 = t510 * t220;
  t1127 = t521 * t220;
  t1129 = t213 * t493;
  t1131 = t510 * t232;
  t1135 = t516 * params->prefactor;
  t1136 = t25 * t1135;
  t1137 = t1136 * t105;
  t1139 = t521 * t232;
  t1141 = 0.15e2 / 0.4e1 * t1104 + 0.45e2 / 0.8e1 * t504 * t232 - 0.5e1 / 0.2e1 * t1109 - 0.45e2 / 0.2e1 * t92 * t93 * t1112 * t1113 - 0.45e2 / 0.8e1 * t92 * t93 * t217 * t1118 - 0.15e2 / 0.2e1 * t1123 + 0.45e2 / 0.2e1 * t204 * t493 + 0.5e1 / 0.2e1 * t1127 + 0.15e2 / 0.2e1 * t1129 + 0.15e2 / 0.4e1 * t1131 + 0.15e2 / 0.4e1 * t204 * t535 + 0.25e2 / 0.18e2 * t1137 - 0.5e1 / 0.4e1 * t1139;
  t1142 = t213 * t535;
  t1145 = 0.1e1 / t34 / t1075;
  t1155 = t481 * t91;
  t1162 = t213 * t498;
  t1174 = 0.1e1 / t86 / t187;
  t1177 = 0.25e2 / 0.27e2 * t25 * t1174 * t44;
  t1179 = t197 * t208 * t44;
  t1182 = t82 * t516 * t44;
  t1185 = t481 * t87 * t44;
  t1187 = t18 * t18;
  t1189 = 0.1e1 / t182 / t1187;
  t1190 = t184 * t184;
  t1196 = t192 * t192;
  t1202 = 0.1e1 / t471 / t5;
  t1203 = t15 * t1202;
  t1206 = my_piecewise5(t9, 0, t13, 0, -0.24e2 * t472 + 0.24e2 * t1203);
  t1210 = my_piecewise3(t19, 0, 0.40e2 / 0.81e2 * t1189 * t1190 - 0.16e2 / 0.9e1 * t464 * t184 * t192 + 0.4e1 / 0.3e1 * t183 * t1196 + 0.16e2 / 0.9e1 * t468 * t476 + 0.4e1 / 0.3e1 * t22 * t1206);
  t1215 = 0.5e1 / 0.4e1 * t1142 + 0.15e2 / 0.16e2 * t92 * t93 * t95 * (0.12320e5 / 0.81e2 * tau[0] * t1145 - 0.1540e4 / 0.81e2 * lapl[0] * t1145) + 0.15e2 / 0.4e1 * t1155 * t105 - 0.45e2 / 0.4e1 * t504 * t220 - 0.45e2 / 0.2e1 * t204 * t498 - 0.15e2 / 0.2e1 * t1162 + 0.135e3 / 0.4e1 * t92 * t93 * t490 * t218 * t230 - 0.15e2 / 0.2e1 * t92 * t93 * t496 * t533 + t1177 + 0.5e1 / 0.4e1 * t1179 - 0.25e2 / 0.18e2 * t1182 - 0.5e1 / 0.4e1 * t1185 - 0.15e2 / 0.16e2 * t4 * t1210 * t26 * t44;
  t1217 = my_piecewise3(t2, 0, t1141 + t1215);
  t1218 = t52 * t52;
  t1220 = 0.1e1 / t237 / t1218;
  t1221 = t239 * t239;
  t1227 = t245 * t245;
  t1232 = t49 * t1202;
  t1235 = my_piecewise5(t13, 0, t9, 0, 0.24e2 * t472 + 0.24e2 * t1232);
  t1239 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1220 * t1221 - 0.16e2 / 0.9e1 * t541 * t239 * t245 + 0.4e1 / 0.3e1 * t238 * t1227 + 0.16e2 / 0.9e1 * t545 * t551 + 0.4e1 / 0.3e1 * t54 * t1235);
  t1245 = t556 * t87 * t70;
  t1248 = t250 * t208 * t70;
  t1251 = t116 * t516 * t70;
  t1255 = 0.25e2 / 0.27e2 * t57 * t1174 * t70;
  t1257 = my_piecewise3(t48, 0, -0.15e2 / 0.16e2 * t4 * t1239 * t26 * t70 - 0.5e1 / 0.4e1 * t1245 + 0.5e1 / 0.4e1 * t1248 - 0.25e2 / 0.18e2 * t1251 + t1255);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[0] = 0.4e1 * t539 + 0.4e1 * t570 + t5 * (t1217 + t1257);

  t1264 = t604 * t220;
  t1273 = t273 * t212;
  t1274 = t1273 * t105;
  t1278 = t132 * t520;
  t1279 = t1278 * t105;
  t1280 = 0.5e1 / 0.8e1 * t1279;
  t1281 = t604 * t232;
  t1285 = t591 * t91;
  t1288 = -0.45e2 / 0.8e1 * t598 * t220 - 0.15e2 / 0.8e1 * t1264 + 0.45e2 / 0.8e1 * t280 * t493 + 0.15e2 / 0.16e2 * t1104 - 0.5e1 / 0.4e1 * t1109 - 0.15e2 / 0.8e1 * t1123 + 0.5e1 / 0.4e1 * t1127 + 0.15e2 / 0.8e1 * t1129 + 0.15e2 / 0.8e1 * t1274 + 0.45e2 / 0.16e2 * t598 * t232 - t1280 + 0.15e2 / 0.16e2 * t1281 + 0.15e2 / 0.16e2 * t280 * t535 + 0.45e2 / 0.16e2 * t1285 * t105;
  t1300 = t132 * t516 * t44;
  t1303 = t591 * t87 * t44;
  t1306 = t273 * t208 * t44;
  t1307 = 0.5e1 / 0.8e1 * t1306;
  t1324 = 0.12e2 * t472;
  t1325 = 0.24e2 * t1203;
  t1327 = my_piecewise5(t9, 0, t13, 0, -t1324 + t1325);
  t1331 = my_piecewise3(t19, 0, 0.40e2 / 0.81e2 * t1189 * t128 * t465 - 0.8e1 / 0.9e1 * t464 * t268 * t184 - 0.8e1 / 0.9e1 * t575 * t78 * t192 + 0.4e1 / 0.3e1 * t183 * t586 * t78 + 0.4e1 / 0.3e1 * t578 * t192 + 0.4e1 / 0.9e1 * t264 * t476 + 0.4e1 / 0.3e1 * t22 * t1327);
  t1336 = 0.15e2 / 0.16e2 * t1131 + 0.25e2 / 0.24e2 * t1137 - 0.5e1 / 0.8e1 * t1139 + 0.5e1 / 0.16e2 * t1142 - 0.45e2 / 0.8e1 * t280 * t498 - 0.15e2 / 0.8e1 * t1162 + t1177 + 0.5e1 / 0.8e1 * t1179 - 0.25e2 / 0.24e2 * t1182 - 0.5e1 / 0.16e2 * t1185 - 0.25e2 / 0.72e2 * t1300 - 0.15e2 / 0.16e2 * t1303 + t1307 - 0.15e2 / 0.16e2 * t4 * t1331 * t26 * t44;
  t1338 = my_piecewise3(t2, 0, t1288 + t1336);
  t1355 = 0.24e2 * t1232;
  t1357 = my_piecewise5(t13, 0, t9, 0, t1324 + t1355);
  t1361 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1220 * t139 * t542 - 0.8e1 / 0.9e1 * t541 * t291 * t239 - 0.8e1 / 0.9e1 * t619 * t112 * t245 + 0.4e1 / 0.3e1 * t238 * t629 * t112 + 0.4e1 / 0.3e1 * t622 * t245 + 0.4e1 / 0.9e1 * t287 * t551 + 0.4e1 / 0.3e1 * t54 * t1357);
  t1367 = t634 * t87 * t70;
  t1370 = t296 * t208 * t70;
  t1371 = 0.5e1 / 0.8e1 * t1370;
  t1373 = t143 * t516 * t70;
  t1378 = t556 * t91;
  t1381 = t250 * t212;
  t1382 = t1381 * t159;
  t1384 = t116 * t520;
  t1385 = t1384 * t159;
  t1386 = 0.5e1 / 0.8e1 * t1385;
  t1387 = t57 * t1135;
  t1388 = t1387 * t159;
  t1390 = -0.15e2 / 0.16e2 * t4 * t1361 * t26 * t70 - 0.15e2 / 0.16e2 * t1367 + t1371 - 0.25e2 / 0.72e2 * t1373 - 0.5e1 / 0.16e2 * t1245 + 0.5e1 / 0.8e1 * t1248 - 0.25e2 / 0.24e2 * t1251 + t1255 + 0.15e2 / 0.16e2 * t1378 * t159 + 0.15e2 / 0.16e2 * t1382 - t1386 + 0.25e2 / 0.72e2 * t1388;
  t1391 = my_piecewise3(t48, 0, t1390);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[1] = t539 + t570 + 0.3e1 * t618 + 0.3e1 * t656 + t5 * (t1338 + t1391);

  t1399 = t673 * t87 * t44;
  t1401 = t673 * t91;
  t1405 = t326 * t208 * t44;
  t1407 = t326 * t212;
  t1408 = t1407 * t105;
  t1436 = t268 * t268;
  t1449 = my_piecewise5(t9, 0, t13, 0, t1325);
  t1453 = my_piecewise3(t19, 0, 0.40e2 / 0.81e2 * t1189 * t316 * t184 - 0.32e2 / 0.27e2 * t575 * t78 * t268 - 0.8e1 / 0.27e2 * t659 * t192 + 0.8e1 / 0.9e1 * t183 * t1436 + 0.8e1 / 0.9e1 * t264 * t586 - 0.8e1 / 0.27e2 * t464 * t321 * t184 + 0.8e1 / 0.9e1 * t183 * t668 * t78 + 0.4e1 / 0.9e1 * t664 * t192 + 0.4e1 / 0.3e1 * t22 * t1449);
  t1458 = 0.5e1 / 0.6e1 * t1306 + t1177 + 0.25e2 / 0.36e2 * t1137 - 0.5e1 / 0.24e2 * t1139 + 0.5e1 / 0.24e2 * t1179 - 0.25e2 / 0.36e2 * t1182 - 0.5e1 / 0.12e2 * t1109 - 0.15e2 / 0.8e1 * t680 * t220 - 0.5e1 / 0.4e1 * t1264 + 0.5e1 / 0.12e2 * t1127 - 0.15e2 / 0.16e2 * t4 * t1453 * t26 * t44;
  t1460 = my_piecewise3(t2, 0, -0.5e1 / 0.8e1 * t1399 + 0.15e2 / 0.8e1 * t1401 * t105 + 0.5e1 / 0.24e2 * t1405 + 0.5e1 / 0.8e1 * t1408 + 0.15e2 / 0.16e2 * t680 * t232 + 0.5e1 / 0.4e1 * t1274 - 0.25e2 / 0.36e2 * t1300 - 0.5e1 / 0.6e1 * t1279 + 0.5e1 / 0.8e1 * t1281 - 0.5e1 / 0.8e1 * t1303 + t1458);
  t1466 = t702 * t87 * t70;
  t1469 = t343 * t208 * t70;
  t1471 = t634 * t91;
  t1480 = t649 * t368;
  t1482 = t652 * t368;
  t1484 = t296 * t212;
  t1485 = t1484 * t159;
  t1487 = t143 * t520;
  t1488 = t1487 * t159;
  t1490 = t649 * t356;
  t1492 = t652 * t356;
  t1505 = t291 * t291;
  t1518 = my_piecewise5(t13, 0, t9, 0, t1355);
  t1522 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1220 * t333 * t239 - 0.32e2 / 0.27e2 * t619 * t112 * t291 - 0.8e1 / 0.27e2 * t688 * t245 + 0.8e1 / 0.9e1 * t238 * t1505 + 0.8e1 / 0.9e1 * t287 * t629 - 0.8e1 / 0.27e2 * t541 * t338 * t239 + 0.8e1 / 0.9e1 * t238 * t697 * t112 + 0.4e1 / 0.9e1 * t693 * t245 + 0.4e1 / 0.3e1 * t54 * t1518);
  t1527 = t1255 + 0.5e1 / 0.8e1 * t1480 - 0.5e1 / 0.24e2 * t1482 + 0.5e1 / 0.4e1 * t1485 - 0.5e1 / 0.12e2 * t1488 - 0.5e1 / 0.4e1 * t1490 + 0.5e1 / 0.12e2 * t1492 + 0.5e1 / 0.8e1 * t1382 - 0.5e1 / 0.6e1 * t1385 + 0.25e2 / 0.36e2 * t1388 - 0.15e2 / 0.16e2 * t4 * t1522 * t26 * t70;
  t1529 = my_piecewise3(t48, 0, -0.15e2 / 0.8e1 * t646 * t356 + 0.15e2 / 0.16e2 * t646 * t368 - 0.5e1 / 0.8e1 * t1466 + 0.5e1 / 0.24e2 * t1469 + 0.15e2 / 0.8e1 * t1471 * t159 + 0.5e1 / 0.6e1 * t1370 - 0.25e2 / 0.36e2 * t1373 - 0.5e1 / 0.8e1 * t1367 + 0.5e1 / 0.24e2 * t1248 - 0.25e2 / 0.36e2 * t1251 + t1527);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[2] = 0.2e1 * t618 + 0.2e1 * t656 + 0.2e1 * t687 + 0.2e1 * t727 + t5 * (t1460 + t1529);

  t1550 = my_piecewise5(t9, 0, t13, 0, t1324 + t1325);
  t1554 = my_piecewise3(t19, 0, 0.40e2 / 0.81e2 * t1189 * t732 * t78 - 0.8e1 / 0.9e1 * t659 * t268 - 0.8e1 / 0.9e1 * t575 * t321 * t78 + 0.4e1 / 0.3e1 * t578 * t321 + 0.4e1 / 0.3e1 * t264 * t668 + 0.4e1 / 0.9e1 * t183 * t739 * t78 + 0.4e1 / 0.3e1 * t22 * t1550);
  t1560 = t744 * t87 * t44;
  t1562 = t744 * t91;
  t1571 = -0.15e2 / 0.16e2 * t4 * t1554 * t26 * t44 - 0.5e1 / 0.16e2 * t1560 + 0.15e2 / 0.16e2 * t1562 * t105 - 0.15e2 / 0.16e2 * t1399 + 0.5e1 / 0.8e1 * t1405 + 0.15e2 / 0.16e2 * t1408 + t1307 - 0.25e2 / 0.24e2 * t1300 - t1280 - 0.25e2 / 0.72e2 * t1182 + t1177 + 0.25e2 / 0.72e2 * t1137;
  t1572 = my_piecewise3(t2, 0, t1571);
  t1577 = t702 * t91;
  t1584 = t343 * t212;
  t1585 = t1584 * t159;
  t1587 = t713 * t368;
  t1589 = t307 * t802;
  t1591 = t713 * t356;
  t1593 = t307 * t774;
  t1599 = -0.45e2 / 0.8e1 * t710 * t356 + 0.45e2 / 0.8e1 * t304 * t774 + 0.45e2 / 0.16e2 * t1577 * t159 + 0.45e2 / 0.16e2 * t710 * t368 + 0.15e2 / 0.16e2 * t304 * t802 + 0.15e2 / 0.16e2 * t1585 + 0.15e2 / 0.16e2 * t1587 + 0.5e1 / 0.16e2 * t1589 - 0.15e2 / 0.8e1 * t1591 + 0.15e2 / 0.8e1 * t1593 + 0.15e2 / 0.16e2 * t1480 - 0.5e1 / 0.8e1 * t1482 + 0.15e2 / 0.8e1 * t1485 - 0.5e1 / 0.4e1 * t1488;
  t1603 = t307 * t779;
  t1623 = my_piecewise5(t13, 0, t9, 0, -t1324 + t1355);
  t1627 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1220 * t752 * t112 - 0.8e1 / 0.9e1 * t688 * t291 - 0.8e1 / 0.9e1 * t619 * t338 * t112 + 0.4e1 / 0.3e1 * t622 * t338 + 0.4e1 / 0.3e1 * t287 * t697 + 0.4e1 / 0.9e1 * t238 * t759 * t112 + 0.4e1 / 0.3e1 * t54 * t1623);
  t1635 = t764 * t87 * t70;
  t1639 = -0.15e2 / 0.8e1 * t1490 + 0.5e1 / 0.4e1 * t1492 + 0.25e2 / 0.24e2 * t1388 - t1386 - 0.15e2 / 0.8e1 * t1603 - 0.45e2 / 0.8e1 * t304 * t779 - 0.15e2 / 0.16e2 * t4 * t1627 * t26 * t70 - 0.15e2 / 0.16e2 * t1466 + 0.5e1 / 0.8e1 * t1469 - 0.5e1 / 0.16e2 * t1635 - 0.25e2 / 0.72e2 * t1251 + t1255 + t1371 - 0.25e2 / 0.24e2 * t1373;
  t1641 = my_piecewise3(t48, 0, t1599 + t1639);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[3] = 0.3e1 * t687 + 0.3e1 * t727 + t751 + t806 + t5 * (t1572 + t1641);

  t1646 = t316 * t316;
  t1651 = t321 * t321;
  t1658 = my_piecewise5(t9, 0, t13, 0, 0.24e2 * t472 + 0.24e2 * t1203);
  t1662 = my_piecewise3(t19, 0, 0.40e2 / 0.81e2 * t1189 * t1646 - 0.16e2 / 0.9e1 * t659 * t321 + 0.4e1 / 0.3e1 * t183 * t1651 + 0.16e2 / 0.9e1 * t264 * t739 + 0.4e1 / 0.3e1 * t22 * t1658);
  t1671 = my_piecewise3(t2, 0, -0.15e2 / 0.16e2 * t4 * t1662 * t26 * t44 - 0.5e1 / 0.4e1 * t1560 + 0.5e1 / 0.4e1 * t1405 - 0.25e2 / 0.18e2 * t1300 + t1177);
  t1677 = 0.1e1 / t60 / t1082;
  t1687 = t764 * t91;
  t1695 = 0.1e1 / t770 / t67;
  t1696 = t354 * t354;
  t1701 = t366 * t366;
  t1711 = 0.45e2 / 0.8e1 * t788 * t368 + 0.15e2 / 0.4e1 * t348 * t802 + 0.15e2 / 0.16e2 * t147 * t93 * t149 * (0.12320e5 / 0.81e2 * tau[1] * t1677 - 0.1540e4 / 0.81e2 * lapl[1] * t1677) + 0.15e2 / 0.4e1 * t1687 * t159 - 0.45e2 / 0.4e1 * t788 * t356 + 0.45e2 / 0.2e1 * t348 * t774 - 0.45e2 / 0.2e1 * t147 * t93 * t1695 * t1696 - 0.45e2 / 0.8e1 * t147 * t93 * t353 * t1701 + 0.15e2 / 0.4e1 * t1585 + 0.15e2 / 0.4e1 * t1587 + 0.5e1 / 0.4e1 * t1589 - 0.15e2 / 0.2e1 * t1591 + 0.15e2 / 0.2e1 * t1593;
  t1728 = t333 * t333;
  t1733 = t338 * t338;
  t1740 = my_piecewise5(t13, 0, t9, 0, -0.24e2 * t472 + 0.24e2 * t1232);
  t1744 = my_piecewise3(t53, 0, 0.40e2 / 0.81e2 * t1220 * t1728 - 0.16e2 / 0.9e1 * t688 * t338 + 0.4e1 / 0.3e1 * t238 * t1733 + 0.16e2 / 0.9e1 * t287 * t759 + 0.4e1 / 0.3e1 * t54 * t1740);
  t1752 = -0.5e1 / 0.4e1 * t1482 - 0.5e1 / 0.2e1 * t1488 + 0.5e1 / 0.2e1 * t1492 + 0.25e2 / 0.18e2 * t1388 - 0.45e2 / 0.2e1 * t348 * t779 + 0.135e3 / 0.4e1 * t147 * t93 * t771 * t354 * t366 - 0.15e2 / 0.2e1 * t147 * t93 * t777 * t800 - 0.15e2 / 0.2e1 * t1603 - 0.15e2 / 0.16e2 * t4 * t1744 * t26 * t70 + 0.5e1 / 0.4e1 * t1469 - 0.5e1 / 0.4e1 * t1635 + t1255 - 0.25e2 / 0.18e2 * t1373;
  t1754 = my_piecewise3(t48, 0, t1711 + t1752);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho4[4] = 0.4e1 * t751 + 0.4e1 * t806 + t5 * (t1671 + t1754);

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3sigma[11] = 0.0e0;

  t1760 = t92 * t93 * t95 * t528;
  t1762 = t204 * t839;
  t1764 = t1136 * t167;
  t1765 = 0.25e2 / 0.288e3 * t1764;
  t1766 = t521 * t385;
  t1768 = t213 * t839;
  t1770 = t1103 * t167;
  t1772 = t504 * t385;
  t1774 = t1108 * t167;
  t1776 = t510 * t385;
  t1778 = t1155 * t167;
  t1780 = t521 * t381;
  t1782 = t213 * t835;
  t1784 = 0.275e3 / 0.72e2 * t1760 - 0.25e2 / 0.8e1 * t1762 - t1765 - 0.25e2 / 0.96e2 * t1766 - 0.25e2 / 0.24e2 * t1768 - 0.15e2 / 0.64e2 * t1770 + 0.75e2 / 0.64e2 * t1772 + 0.5e1 / 0.32e2 * t1774 + 0.25e2 / 0.32e2 * t1776 - 0.15e2 / 0.64e2 * t1778 - 0.5e1 / 0.16e2 * t1780 + 0.15e2 / 0.32e2 * t1782;
  t1785 = t504 * t381;
  t1787 = t510 * t381;
  t1789 = t213 * t826;
  t1791 = t213 * t831;
  t1796 = t92 * t93 * t1112 * t36 * t491;
  t1801 = t92 * t93 * t490 * t98 * t218;
  t1806 = t92 * t93 * t217 * t225 * t103;
  t1808 = t204 * t826;
  t1810 = t204 * t831;
  t1814 = t92 * t93 * t829 * t230;
  t1818 = t92 * t93 * t379 * t533;
  t1820 = t204 * t835;
  t1822 = t91 * t30;
  t1828 = t25 * t1822 * t32 * t490 * t36 * t103 * t230;
  t1830 = 0.45e2 / 0.32e2 * t1785 + 0.15e2 / 0.16e2 * t1787 - 0.45e2 / 0.32e2 * t1789 - 0.25e2 / 0.16e2 * t1791 + 0.45e2 / 0.8e1 * t1796 + 0.225e3 / 0.32e2 * t1801 + 0.25e2 / 0.4e1 * t1806 - 0.135e3 / 0.32e2 * t1808 - 0.75e2 / 0.16e2 * t1810 - 0.75e2 / 0.32e2 * t1814 + 0.15e2 / 0.32e2 * t1818 + 0.45e2 / 0.32e2 * t1820 - 0.135e3 / 0.32e2 * t1828;
  t1832 = my_piecewise3(t2, 0, t1784 + t1830);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[0] = t5 * t1832 + 0.3e1 * t843;

  t1835 = t1378 * t172;
  t1837 = t1381 * t172;
  t1839 = t1384 * t172;
  t1841 = t1387 * t172;
  t1842 = 0.25e2 / 0.288e3 * t1841;
  t1844 = my_piecewise3(t48, 0, -0.15e2 / 0.64e2 * t1835 - 0.15e2 / 0.64e2 * t1837 + 0.5e1 / 0.32e2 * t1839 - t1842);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[1] = t5 * t1844 + 0.3e1 * t853;

  t1846 = 0.2e1 * t867;
  t1847 = t280 * t835;
  t1849 = t280 * t839;
  t1851 = t1273 * t167;
  t1852 = 0.5e1 / 0.32e2 * t1851;
  t1853 = t598 * t381;
  t1855 = t598 * t385;
  t1857 = t1278 * t167;
  t1859 = t604 * t381;
  t1860 = 0.5e1 / 0.16e2 * t1859;
  t1861 = t604 * t385;
  t1862 = 0.25e2 / 0.96e2 * t1861;
  t1865 = 0.15e2 / 0.32e2 * t1847 - 0.25e2 / 0.24e2 * t1849 - t1852 + 0.15e2 / 0.16e2 * t1853 + 0.25e2 / 0.32e2 * t1855 + 0.5e1 / 0.96e2 * t1857 + t1860 + t1862 - t1765 - 0.5e1 / 0.24e2 * t1780 - 0.25e2 / 0.144e3 * t1766;
  t1872 = t280 * t826;
  t1874 = t280 * t831;
  t1878 = t1285 * t167;
  t1880 = 0.5e1 / 0.32e2 * t1782 - 0.25e2 / 0.72e2 * t1768 - 0.5e1 / 0.64e2 * t1770 + 0.5e1 / 0.48e2 * t1774 + 0.5e1 / 0.16e2 * t1787 + 0.25e2 / 0.96e2 * t1776 - 0.45e2 / 0.32e2 * t1872 - 0.25e2 / 0.16e2 * t1874 - 0.15e2 / 0.32e2 * t1789 - 0.25e2 / 0.48e2 * t1791 - 0.15e2 / 0.64e2 * t1878;
  t1882 = my_piecewise3(t2, 0, t1865 + t1880);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[2] = t5 * t1882 + t1846 + t843;

  t1884 = 0.2e1 * t883;
  t1885 = t1471 * t172;
  t1887 = t1484 * t172;
  t1888 = 0.5e1 / 0.32e2 * t1887;
  t1889 = t1487 * t172;
  t1893 = t646 * t407;
  t1895 = t649 * t407;
  t1896 = 0.5e1 / 0.16e2 * t1895;
  t1897 = t652 * t407;
  t1899 = t646 * t411;
  t1901 = t649 * t411;
  t1902 = 0.25e2 / 0.96e2 * t1901;
  t1903 = t652 * t411;
  t1905 = -0.15e2 / 0.64e2 * t1885 - t1888 + 0.5e1 / 0.96e2 * t1889 - 0.5e1 / 0.64e2 * t1837 + 0.5e1 / 0.48e2 * t1839 - t1842 + 0.15e2 / 0.32e2 * t1893 + t1896 - 0.5e1 / 0.48e2 * t1897 + 0.25e2 / 0.64e2 * t1899 + t1902 - 0.25e2 / 0.288e3 * t1903;
  t1906 = my_piecewise3(t48, 0, t1905);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[3] = t5 * t1906 + t1884 + t853;

  t1908 = t1401 * t167;
  t1910 = t1407 * t167;
  t1912 = t680 * t381;
  t1914 = t680 * t385;
  t1920 = -0.15e2 / 0.64e2 * t1908 - 0.5e1 / 0.64e2 * t1910 + 0.15e2 / 0.32e2 * t1912 + 0.25e2 / 0.64e2 * t1914 - t1852 + 0.5e1 / 0.48e2 * t1857 + t1860 + t1862 + 0.5e1 / 0.96e2 * t1774 - t1765 - 0.5e1 / 0.48e2 * t1780 - 0.25e2 / 0.288e3 * t1766;
  t1921 = my_piecewise3(t2, 0, t1920);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[4] = t5 * t1921 + t1846 + t890;

  t1923 = t1577 * t172;
  t1925 = t1584 * t172;
  t1928 = t710 * t407;
  t1930 = t713 * t407;
  t1932 = t710 * t411;
  t1934 = t713 * t411;
  t1937 = -0.15e2 / 0.64e2 * t1923 - 0.5e1 / 0.64e2 * t1925 - t1888 + 0.5e1 / 0.48e2 * t1889 + 0.15e2 / 0.16e2 * t1928 + 0.5e1 / 0.16e2 * t1930 + 0.25e2 / 0.32e2 * t1932 + 0.25e2 / 0.96e2 * t1934 + 0.5e1 / 0.96e2 * t1839 - t1842 + t1896;
  t1940 = t304 * t904;
  t1942 = t307 * t904;
  t1944 = t304 * t909;
  t1946 = t307 * t909;
  t1948 = t304 * t913;
  t1950 = t307 * t913;
  t1952 = t304 * t917;
  t1954 = t307 * t917;
  t1956 = -0.5e1 / 0.24e2 * t1897 + t1902 - 0.25e2 / 0.144e3 * t1903 - 0.45e2 / 0.32e2 * t1940 - 0.15e2 / 0.32e2 * t1942 - 0.25e2 / 0.16e2 * t1944 - 0.25e2 / 0.48e2 * t1946 + 0.15e2 / 0.32e2 * t1948 + 0.5e1 / 0.32e2 * t1950 - 0.25e2 / 0.24e2 * t1952 - 0.25e2 / 0.72e2 * t1954;
  t1958 = my_piecewise3(t48, 0, t1937 + t1956);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[5] = t5 * t1958 + t1884 + t921;

  t1961 = t1562 * t167;
  t1966 = my_piecewise3(t2, 0, -0.15e2 / 0.64e2 * t1961 - 0.15e2 / 0.64e2 * t1910 + 0.5e1 / 0.32e2 * t1857 - t1765);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[6] = t5 * t1966 + 0.3e1 * t890;

  t1972 = t147 * t93 * t149 * t795;
  t1974 = t348 * t917;
  t1976 = t788 * t411;
  t1978 = t1687 * t172;
  t1987 = t147 * t93 * t1695 * t62 * t772;
  t1992 = t147 * t93 * t771 * t152 * t354;
  t1994 = -0.25e2 / 0.24e2 * t1954 + 0.275e3 / 0.72e2 * t1972 - 0.25e2 / 0.8e1 * t1974 + 0.75e2 / 0.64e2 * t1976 - 0.15e2 / 0.64e2 * t1978 + 0.5e1 / 0.32e2 * t1889 - 0.25e2 / 0.96e2 * t1903 - 0.15e2 / 0.64e2 * t1925 + 0.25e2 / 0.32e2 * t1934 - t1842 + 0.45e2 / 0.8e1 * t1987 + 0.225e3 / 0.32e2 * t1992;
  t1998 = t147 * t93 * t353 * t361 * t157;
  t2000 = t348 * t904;
  t2002 = t348 * t909;
  t2009 = t147 * t93 * t907 * t366;
  t2013 = t147 * t93 * t405 * t800;
  t2015 = t348 * t913;
  t2017 = t788 * t407;
  t2026 = t57 * t1822 * t32 * t771 * t62 * t157 * t366;
  t2028 = 0.25e2 / 0.4e1 * t1998 - 0.135e3 / 0.32e2 * t2000 - 0.75e2 / 0.16e2 * t2002 - 0.45e2 / 0.32e2 * t1942 - 0.25e2 / 0.16e2 * t1946 + 0.15e2 / 0.32e2 * t1950 - 0.75e2 / 0.32e2 * t2009 + 0.15e2 / 0.32e2 * t2013 + 0.45e2 / 0.32e2 * t2015 + 0.45e2 / 0.32e2 * t2017 - 0.5e1 / 0.16e2 * t1897 + 0.15e2 / 0.16e2 * t1930 - 0.135e3 / 0.32e2 * t2026;
  t2030 = my_piecewise3(t48, 0, t1994 + t2028);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3lapl[7] = t5 * t2030 + 0.3e1 * t921;

  t2035 = 0.25e2 / 0.36e2 * t1764;
  t2045 = -0.275e3 / 0.9e1 * t1760 + 0.25e2 * t1762 + t2035 + 0.25e2 / 0.12e2 * t1766 + 0.25e2 / 0.3e1 * t1768 + 0.15e2 / 0.8e1 * t1770 - 0.75e2 / 0.8e1 * t1772 - 0.5e1 / 0.4e1 * t1774 - 0.25e2 / 0.4e1 * t1776 + 0.15e2 / 0.8e1 * t1778 + 0.5e1 / 0.2e1 * t1780 - 0.15e2 / 0.4e1 * t1782;
  t2059 = -0.45e2 / 0.4e1 * t1785 - 0.15e2 / 0.2e1 * t1787 + 0.45e2 / 0.4e1 * t1789 + 0.25e2 / 0.2e1 * t1791 - 0.45e2 * t1796 - 0.225e3 / 0.4e1 * t1801 - 0.50e2 * t1806 + 0.135e3 / 0.4e1 * t1808 + 0.75e2 / 0.2e1 * t1810 + 0.75e2 / 0.4e1 * t1814 - 0.15e2 / 0.4e1 * t1818 - 0.45e2 / 0.4e1 * t1820 + 0.135e3 / 0.4e1 * t1828;
  t2061 = my_piecewise3(t2, 0, t2045 + t2059);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[0] = t5 * t2061 + 0.3e1 * t936;

  t2067 = 0.25e2 / 0.36e2 * t1841;
  t2069 = my_piecewise3(t48, 0, 0.15e2 / 0.8e1 * t1835 + 0.15e2 / 0.8e1 * t1837 - 0.5e1 / 0.4e1 * t1839 + t2067);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[1] = t5 * t2069 + 0.3e1 * t943;

  t2071 = 0.2e1 * t953;
  t2074 = 0.5e1 / 0.4e1 * t1851;
  t2078 = 0.5e1 / 0.2e1 * t1859;
  t2079 = 0.25e2 / 0.12e2 * t1861;
  t2082 = -0.15e2 / 0.4e1 * t1847 + 0.25e2 / 0.3e1 * t1849 + t2074 - 0.15e2 / 0.2e1 * t1853 - 0.25e2 / 0.4e1 * t1855 - 0.5e1 / 0.12e2 * t1857 - t2078 - t2079 + t2035 + 0.5e1 / 0.3e1 * t1780 + 0.25e2 / 0.18e2 * t1766;
  t2094 = -0.5e1 / 0.4e1 * t1782 + 0.25e2 / 0.9e1 * t1768 + 0.5e1 / 0.8e1 * t1770 - 0.5e1 / 0.6e1 * t1774 - 0.5e1 / 0.2e1 * t1787 - 0.25e2 / 0.12e2 * t1776 + 0.45e2 / 0.4e1 * t1872 + 0.25e2 / 0.2e1 * t1874 + 0.15e2 / 0.4e1 * t1789 + 0.25e2 / 0.6e1 * t1791 + 0.15e2 / 0.8e1 * t1878;
  t2096 = my_piecewise3(t2, 0, t2082 + t2094);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[2] = t5 * t2096 + t2071 + t936;

  t2098 = 0.2e1 * t963;
  t2100 = 0.5e1 / 0.4e1 * t1887;
  t2105 = 0.5e1 / 0.2e1 * t1895;
  t2108 = 0.25e2 / 0.12e2 * t1901;
  t2110 = 0.15e2 / 0.8e1 * t1885 + t2100 - 0.5e1 / 0.12e2 * t1889 + 0.5e1 / 0.8e1 * t1837 - 0.5e1 / 0.6e1 * t1839 + t2067 - 0.15e2 / 0.4e1 * t1893 - t2105 + 0.5e1 / 0.6e1 * t1897 - 0.25e2 / 0.8e1 * t1899 - t2108 + 0.25e2 / 0.36e2 * t1903;
  t2111 = my_piecewise3(t48, 0, t2110);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[3] = t5 * t2111 + t2098 + t943;

  t2121 = 0.15e2 / 0.8e1 * t1908 + 0.5e1 / 0.8e1 * t1910 - 0.15e2 / 0.4e1 * t1912 - 0.25e2 / 0.8e1 * t1914 + t2074 - 0.5e1 / 0.6e1 * t1857 - t2078 - t2079 - 0.5e1 / 0.12e2 * t1774 + t2035 + 0.5e1 / 0.6e1 * t1780 + 0.25e2 / 0.36e2 * t1766;
  t2122 = my_piecewise3(t2, 0, t2121);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[4] = t5 * t2122 + t2071 + t969;

  t2132 = 0.15e2 / 0.8e1 * t1923 + 0.5e1 / 0.8e1 * t1925 + t2100 - 0.5e1 / 0.6e1 * t1889 - 0.15e2 / 0.2e1 * t1928 - 0.5e1 / 0.2e1 * t1930 - 0.25e2 / 0.4e1 * t1932 - 0.25e2 / 0.12e2 * t1934 - 0.5e1 / 0.12e2 * t1839 + t2067 - t2105;
  t2143 = 0.5e1 / 0.3e1 * t1897 - t2108 + 0.25e2 / 0.18e2 * t1903 + 0.45e2 / 0.4e1 * t1940 + 0.15e2 / 0.4e1 * t1942 + 0.25e2 / 0.2e1 * t1944 + 0.25e2 / 0.6e1 * t1946 - 0.15e2 / 0.4e1 * t1948 - 0.5e1 / 0.4e1 * t1950 + 0.25e2 / 0.3e1 * t1952 + 0.25e2 / 0.9e1 * t1954;
  t2145 = my_piecewise3(t48, 0, t2132 + t2143);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[5] = t5 * t2145 + t2098 + t983;

  t2152 = my_piecewise3(t2, 0, 0.15e2 / 0.8e1 * t1961 + 0.15e2 / 0.8e1 * t1910 - 0.5e1 / 0.4e1 * t1857 + t2035);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[6] = t5 * t2152 + 0.3e1 * t969;

  t2166 = 0.25e2 / 0.3e1 * t1954 - 0.275e3 / 0.9e1 * t1972 + 0.25e2 * t1974 - 0.75e2 / 0.8e1 * t1976 + 0.15e2 / 0.8e1 * t1978 - 0.5e1 / 0.4e1 * t1889 + 0.25e2 / 0.12e2 * t1903 + 0.15e2 / 0.8e1 * t1925 - 0.25e2 / 0.4e1 * t1934 + t2067 - 0.45e2 * t1987 - 0.225e3 / 0.4e1 * t1992;
  t2180 = -0.50e2 * t1998 + 0.135e3 / 0.4e1 * t2000 + 0.75e2 / 0.2e1 * t2002 + 0.45e2 / 0.4e1 * t1942 + 0.25e2 / 0.2e1 * t1946 - 0.15e2 / 0.4e1 * t1950 + 0.75e2 / 0.4e1 * t2009 - 0.15e2 / 0.4e1 * t2013 - 0.45e2 / 0.4e1 * t2015 - 0.45e2 / 0.4e1 * t2017 + 0.5e1 / 0.2e1 * t1897 - 0.15e2 / 0.2e1 * t1930 + 0.135e3 / 0.4e1 * t2026;
  t2182 = my_piecewise3(t48, 0, t2166 + t2180);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho3tau[7] = t5 * t2182 + 0.3e1 * t983;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigma2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmalapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2sigmatau[17] = 0.0e0;

  t2185 = t504 * t442;
  t2187 = t510 * t442;
  t2189 = t204 * t991;
  t2191 = t204 * t997;
  t2193 = t521 * t442;
  t2194 = 0.5e1 / 0.192e3 * t2193;
  t2195 = t213 * t991;
  t2197 = t213 * t997;
  t2202 = t92 * t93 * t1112 * t440 * t218;
  t2207 = t92 * t93 * t490 * t995 * t103;
  t2211 = t92 * t93 * t989 * t230;
  t2217 = t92 * t93 * t217 / t33 / t1075;
  t2219 = -0.15e2 / 0.128e3 * t2185 - 0.5e1 / 0.64e2 * t2187 + 0.45e2 / 0.64e2 * t2189 + 0.25e2 / 0.32e2 * t2191 + t2194 + 0.15e2 / 0.64e2 * t2195 + 0.25e2 / 0.96e2 * t2197 - 0.45e2 / 0.32e2 * t2202 - 0.75e2 / 0.32e2 * t2207 + 0.45e2 / 0.128e3 * t2211 - 0.325e3 / 0.192e3 * t2217;
  t2220 = my_piecewise3(t2, 0, t2219);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[0] = t5 * t2220 + 0.2e1 * t1001;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[1] = 0.0e0;

  t2223 = t646 * t449;
  t2225 = t649 * t449;
  t2227 = t652 * t449;
  t2228 = 0.5e1 / 0.192e3 * t2227;
  t2230 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t2223 - 0.5e1 / 0.64e2 * t2225 + t2228);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[2] = t5 * t2230 + 0.2e1 * t1008;

  t2232 = t598 * t442;
  t2234 = t604 * t442;
  t2236 = t280 * t991;
  t2238 = t280 * t997;
  t2244 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t2232 - 0.5e1 / 0.128e3 * t2234 + 0.45e2 / 0.128e3 * t2236 + 0.25e2 / 0.64e2 * t2238 - 0.5e1 / 0.128e3 * t2187 + t2194 + 0.15e2 / 0.128e3 * t2195 + 0.25e2 / 0.192e3 * t2197);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[3] = t5 * t2244 + t1001 + t1013;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[4] = 0.0e0;

  t2246 = t710 * t449;
  t2248 = t713 * t449;
  t2251 = t304 * t1019;
  t2253 = t307 * t1019;
  t2255 = t304 * t1025;
  t2257 = t307 * t1025;
  t2260 = my_piecewise3(t48, 0, -0.15e2 / 0.128e3 * t2246 - 0.5e1 / 0.128e3 * t2248 - 0.5e1 / 0.128e3 * t2225 + t2228 + 0.45e2 / 0.128e3 * t2251 + 0.15e2 / 0.128e3 * t2253 + 0.25e2 / 0.64e2 * t2255 + 0.25e2 / 0.192e3 * t2257);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[5] = t5 * t2260 + t1008 + t1029;

  t2263 = t680 * t442;
  t2267 = my_piecewise3(t2, 0, -0.15e2 / 0.128e3 * t2263 - 0.5e1 / 0.64e2 * t2234 + t2194);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[6] = t5 * t2267 + 0.2e1 * t1013;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[7] = 0.0e0;

  t2270 = t788 * t449;
  t2273 = t348 * t1019;
  t2275 = t348 * t1025;
  t2282 = t147 * t93 * t1695 * t447 * t354;
  t2287 = t147 * t93 * t771 * t1023 * t157;
  t2291 = t147 * t93 * t1017 * t366;
  t2297 = t147 * t93 * t353 / t59 / t1082;
  t2299 = -0.15e2 / 0.128e3 * t2270 - 0.5e1 / 0.64e2 * t2248 + 0.45e2 / 0.64e2 * t2273 + 0.25e2 / 0.32e2 * t2275 + t2228 + 0.15e2 / 0.64e2 * t2253 + 0.25e2 / 0.96e2 * t2257 - 0.45e2 / 0.32e2 * t2282 - 0.75e2 / 0.32e2 * t2287 + 0.45e2 / 0.128e3 * t2291 - 0.325e3 / 0.192e3 * t2297;
  t2300 = my_piecewise3(t48, 0, t2299);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapl2[8] = t5 * t2300 + 0.2e1 * t1029;

  t2307 = 0.5e1 / 0.24e2 * t2193;
  t2314 = 0.15e2 / 0.16e2 * t2185 + 0.5e1 / 0.8e1 * t2187 - 0.45e2 / 0.8e1 * t2189 - 0.25e2 / 0.4e1 * t2191 - t2307 - 0.15e2 / 0.8e1 * t2195 - 0.25e2 / 0.12e2 * t2197 + 0.45e2 / 0.4e1 * t2202 + 0.75e2 / 0.4e1 * t2207 - 0.45e2 / 0.16e2 * t2211 + 0.325e3 / 0.24e2 * t2217;
  t2315 = my_piecewise3(t2, 0, t2314);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[0] = t5 * t2315 + 0.2e1 * t1036;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[2] = 0.0e0;

  t2320 = 0.5e1 / 0.24e2 * t2227;
  t2322 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t2223 + 0.5e1 / 0.8e1 * t2225 - t2320);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[3] = t5 * t2322 + 0.2e1 * t1041;

  t2332 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t2232 + 0.5e1 / 0.16e2 * t2234 - 0.45e2 / 0.16e2 * t2236 - 0.25e2 / 0.8e1 * t2238 + 0.5e1 / 0.16e2 * t2187 - t2307 - 0.15e2 / 0.16e2 * t2195 - 0.25e2 / 0.24e2 * t2197);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[4] = t5 * t2332 + t1036 + t1045;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[6] = 0.0e0;

  t2342 = my_piecewise3(t48, 0, 0.15e2 / 0.16e2 * t2246 + 0.5e1 / 0.16e2 * t2248 + 0.5e1 / 0.16e2 * t2225 - t2320 - 0.45e2 / 0.16e2 * t2251 - 0.15e2 / 0.16e2 * t2253 - 0.25e2 / 0.8e1 * t2255 - 0.25e2 / 0.24e2 * t2257);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[7] = t5 * t2342 + t1041 + t1051;

  t2348 = my_piecewise3(t2, 0, 0.15e2 / 0.16e2 * t2263 + 0.5e1 / 0.8e1 * t2234 - t2307);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[8] = t5 * t2348 + 0.2e1 * t1045;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[10] = 0.0e0;

  t2361 = 0.15e2 / 0.16e2 * t2270 + 0.5e1 / 0.8e1 * t2248 - 0.45e2 / 0.8e1 * t2273 - 0.25e2 / 0.4e1 * t2275 - t2320 - 0.15e2 / 0.8e1 * t2253 - 0.25e2 / 0.12e2 * t2257 + 0.45e2 / 0.4e1 * t2282 + 0.75e2 / 0.4e1 * t2287 - 0.45e2 / 0.16e2 * t2291 + 0.325e3 / 0.24e2 * t2297;
  t2362 = my_piecewise3(t48, 0, t2361);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2lapltau[11] = t5 * t2362 + 0.2e1 * t1051;

  t2369 = 0.5e1 / 0.3e1 * t2193;
  t2376 = -0.15e2 / 0.2e1 * t2185 - 0.5e1 * t2187 + 0.45e2 * t2189 + 0.50e2 * t2191 + t2369 + 0.15e2 * t2195 + 0.50e2 / 0.3e1 * t2197 - 0.90e2 * t2202 - 0.150e3 * t2207 + 0.45e2 / 0.2e1 * t2211 - 0.325e3 / 0.3e1 * t2217;
  t2377 = my_piecewise3(t2, 0, t2376);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[0] = t5 * t2377 + 0.2e1 * t1058;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[1] = 0.0e0;

  t2382 = 0.5e1 / 0.3e1 * t2227;
  t2384 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t2223 - 0.5e1 * t2225 + t2382);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[2] = t5 * t2384 + 0.2e1 * t1063;

  t2394 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t2232 - 0.5e1 / 0.2e1 * t2234 + 0.45e2 / 0.2e1 * t2236 + 0.25e2 * t2238 - 0.5e1 / 0.2e1 * t2187 + t2369 + 0.15e2 / 0.2e1 * t2195 + 0.25e2 / 0.3e1 * t2197);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[3] = t5 * t2394 + t1058 + t1067;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[4] = 0.0e0;

  t2404 = my_piecewise3(t48, 0, -0.15e2 / 0.2e1 * t2246 - 0.5e1 / 0.2e1 * t2248 - 0.5e1 / 0.2e1 * t2225 + t2382 + 0.45e2 / 0.2e1 * t2251 + 0.15e2 / 0.2e1 * t2253 + 0.25e2 * t2255 + 0.25e2 / 0.3e1 * t2257);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[5] = t5 * t2404 + t1063 + t1073;

  t2410 = my_piecewise3(t2, 0, -0.15e2 / 0.2e1 * t2263 - 0.5e1 * t2234 + t2369);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[6] = t5 * t2410 + 0.2e1 * t1067;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[7] = 0.0e0;

  t2423 = -0.15e2 / 0.2e1 * t2270 - 0.5e1 * t2248 + 0.45e2 * t2273 + 0.50e2 * t2275 + t2382 + 0.15e2 * t2253 + 0.50e2 / 0.3e1 * t2257 - 0.90e2 * t2282 - 0.150e3 * t2287 + 0.45e2 / 0.2e1 * t2291 - 0.325e3 / 0.3e1 * t2297;
  t2424 = my_piecewise3(t48, 0, t2423);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rho2tau2[8] = t5 * t2424 + 0.2e1 * t1073;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma3[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2lapl[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigma2tau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmalapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhosigmatau2[17] = 0.0e0;

  t2426 = t204 * t1078;
  t2428 = t213 * t1078;
  t2429 = 0.15e2 / 0.512e3 * t2428;
  t2433 = t92 * t93 * t1112 * t1076 * t103;
  t2435 = t526 * t96;
  t2439 = t92 * t93 * t490 / t2435;
  t2442 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2426 - t2429 + 0.45e2 / 0.128e3 * t2433 + 0.225e3 / 0.512e3 * t2439);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[0] = t5 * t2442 + t1081;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[2] = 0.0e0;

  t2444 = t304 * t1085;
  t2446 = t307 * t1085;
  t2447 = 0.15e2 / 0.512e3 * t2446;
  t2449 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t2444 - t2447);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[3] = t5 * t2449 + t1088;

  t2451 = t280 * t1078;
  t2454 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2451 - t2429);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[4] = t5 * t2454 + t1081;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[6] = 0.0e0;

  t2456 = t348 * t1085;
  t2461 = t147 * t93 * t1695 * t1083 * t157;
  t2463 = t793 * t150;
  t2467 = t147 * t93 * t771 / t2463;
  t2470 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t2456 - t2447 + 0.45e2 / 0.128e3 * t2461 + 0.225e3 / 0.512e3 * t2467);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl3[7] = t5 * t2470 + t1088;

  t2473 = 0.15e2 / 0.64e2 * t2428;
  t2477 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2426 + t2473 - 0.45e2 / 0.16e2 * t2433 - 0.225e3 / 0.64e2 * t2439);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[0] = t5 * t2477 + t1090;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[4] = 0.0e0;

  t2480 = 0.15e2 / 0.64e2 * t2446;
  t2482 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t2444 + t2480);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[5] = t5 * t2482 + t1092;

  t2486 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2451 + t2473);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[6] = t5 * t2486 + t1090;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[10] = 0.0e0;

  t2492 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t2456 + t2480 - 0.45e2 / 0.16e2 * t2461 - 0.225e3 / 0.64e2 * t2467);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapl2tau[11] = t5 * t2492 + t1092;

  t2495 = 0.15e2 / 0.8e1 * t2428;
  t2499 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2426 - t2495 + 0.45e2 / 0.2e1 * t2433 + 0.225e3 / 0.8e1 * t2439);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[0] = t5 * t2499 + t1094;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[4] = 0.0e0;

  t2502 = 0.15e2 / 0.8e1 * t2446;
  t2504 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t2444 - t2502);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[5] = t5 * t2504 + t1096;

  t2508 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2451 - t2495);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[6] = t5 * t2508 + t1094;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[10] = 0.0e0;

  t2514 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t2456 - t2502 + 0.45e2 / 0.2e1 * t2461 + 0.225e3 / 0.8e1 * t2467);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rholapltau2[11] = t5 * t2514 + t1096;

  t2517 = 0.15e2 * t2428;
  t2521 = my_piecewise3(t2, 0, 0.45e2 * t2426 + t2517 - 0.180e3 * t2433 - 0.225e3 * t2439);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[0] = t5 * t2521 + t1098;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[2] = 0.0e0;

  t2524 = 0.15e2 * t2446;
  t2526 = my_piecewise3(t48, 0, 0.45e2 * t2444 + t2524);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[3] = t5 * t2526 + t1100;

  t2530 = my_piecewise3(t2, 0, 0.45e2 * t2451 + t2517);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[4] = t5 * t2530 + t1098;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[6] = 0.0e0;

  t2536 = my_piecewise3(t48, 0, 0.45e2 * t2456 + t2524 - 0.180e3 * t2461 - 0.225e3 * t2467);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4rhotau3[7] = t5 * t2536 + t1100;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma4[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3lapl[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma3tau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapl2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[18] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[19] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[20] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[21] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[22] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2lapltau[23] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigma2tau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl3[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapl2tau[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[11] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[12] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[13] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[14] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[15] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[16] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmalapltau2[17] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[0] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[7] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[8] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[9] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[10] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4sigmatau3[11] = 0.0e0;

  t2542 = t92 * t93 * t1112 / t34 / t2435;
  t2544 = my_piecewise3(t2, 0, -0.45e2 / 0.512e3 * t2542);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[0] = t5 * t2544;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[3] = 0.0e0;

  t2549 = t147 * t93 * t1695 / t60 / t2463;
  t2551 = my_piecewise3(t48, 0, -0.45e2 / 0.512e3 * t2549);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl4[4] = t5 * t2551;

  t2553 = my_piecewise3(t2, 0, 0.45e2 / 0.64e2 * t2542);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[0] = t5 * t2553;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[6] = 0.0e0;

  t2555 = my_piecewise3(t48, 0, 0.45e2 / 0.64e2 * t2549);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl3tau[7] = t5 * t2555;

  t2557 = my_piecewise3(t2, 0, -0.45e2 / 0.8e1 * t2542);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[0] = t5 * t2557;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[6] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[7] = 0.0e0;

  t2559 = my_piecewise3(t48, 0, -0.45e2 / 0.8e1 * t2549);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapl2tau2[8] = t5 * t2559;

  t2561 = my_piecewise3(t2, 0, 0.45e2 * t2542);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[0] = t5 * t2561;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[3] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[4] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[5] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[6] = 0.0e0;

  t2563 = my_piecewise3(t48, 0, 0.45e2 * t2549);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4lapltau3[7] = t5 * t2563;

  t2565 = my_piecewise3(t2, 0, -0.360e3 * t2542);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[0] = t5 * t2565;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[1] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[2] = 0.0e0;

  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[3] = 0.0e0;

  t2567 = my_piecewise3(t48, 0, -0.360e3 * t2549);
  if(v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    v4tau4[4] = t5 * t2567;

#ifndef XC_DONT_COMPILE_MXC

  if(order < 5) return;


#endif

#endif

#endif

#endif

#endif


}

