/* recursiveDoUndoMove.h
 */
#ifndef _RECURSIVEDOUNDOMOVE_H
#define _RECURSIVEDOUNDOMOVE_H

#include "osl/square.h"
#include "osl/move.h"
#include <cppunit/extensions/HelperMacros.h>
#include <cstddef>
#include <iostream>
namespace osl
{
  template <Player P,class State>
  struct RecursiveDoUndoMove
  {
    State& state;
    const Move *cur;
    const Move *last;
    size_t *depth;
  public:
    RecursiveDoUndoMove(State& s, const Move *c, const Move *l, size_t *d)
      : state(s), cur(c), last(l), depth(d)
    {
      *depth+=1;
    }
    void operator()(Square lastTo);
  };

  template <Player P,class State>
  void RecursiveDoUndoMove<P,State>::operator()(Square lastTo)
  {
    CPPUNIT_ASSERT_EQUAL(cur->to(), lastTo);
    CPPUNIT_ASSERT(state.isConsistent(true) ||
		   (std::cerr << state << std::endl,0));

    State backupState(state);
    if(++cur==last) 
      return;
    CPPUNIT_ASSERT(state.isValidMove(*cur));
    typedef RecursiveDoUndoMove<PlayerTraits<P>::opponent,State> next_t;
    next_t nextCall(state, cur,last, depth);
    state.makeUnmakeMove(*cur,nextCall);
    CPPUNIT_ASSERT(state.isConsistent(true));
    CPPUNIT_ASSERT_EQUAL(state, backupState);
  }

} // namespace osl


#endif /* _RECURSIVEDOUNDOMOVE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
