package org.jboss.cache.notifications.event;

import java.util.Map;

/**
 * This event is passed in to any method annotated with {@link org.jboss.cache.notifications.annotation.NodeLoaded}.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.0.0
 */
public interface NodeLoadedEvent extends NodeEvent
{
   /**
    * @return an unmodifiable {@link Map} of data loaded from a cache loader and into the cache.  If the
    *         {@link org.jboss.cache.Node} is loaded but the data isn't (for example when calling {@link org.jboss.cache.Node#getChildren()})
    *         this method returns <tt>null</tt>.
    */
   Map getData();
}
