/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantNumeric;

public class ConstantFloatInfo
extends ConstantNumeric {
    public byte getTag() {
        return 4;
    }

    public String getTagVerbose() {
        return "CONSTANT_Float_info";
    }

    public String getVerbose() throws InvalidByteCodeException {
        return String.valueOf(this.getFloat());
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.bytes);
    }

    public void setFloat(float f) {
        this.bytes = Float.floatToIntBits(f);
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeByte(4);
        super.write(dataOutput);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + this.getTagVerbose() + " with bytes " + this.bytes);
    }
}

