return require('lib/tap')(function (test)

  test("simple prepare", function (print, p, expect, uv)
    local prepare = uv.new_prepare()
    uv.prepare_start(prepare, expect(function ()
      p("prepare", prepare)
      uv.prepare_stop(prepare)
      uv.close(prepare, expect(function ()
      end))
    end))
  end)

  test("simple check", function (print, p, expect, uv)
    local check = uv.new_check()
    uv.check_start(check, expect(function ()
      p("check", check)
      uv.check_stop(check)
      uv.close(check, expect(function ()
      end))
    end))

    -- Trigger with a timer
    local timer = uv.new_timer()
    uv.timer_start(timer, 10, 0, expect(function()
      p("timeout", timer)
      uv.timer_stop(timer)
      uv.close(timer)
    end))
  end)

  test("simple idle", function (print, p, expect, uv)
    local idle = uv.new_idle()
    uv.idle_start(idle, expect(function ()
      p("idle", idle)
      uv.idle_stop(idle)
      uv.close(idle, expect(function ()
      end))
    end))
  end)

  test("simple async", function (print, p, expect, uv)
    local async
    async = uv.new_async(expect(function ()
      uv.close(async)
    end))
    uv.async_send(async)
  end)

end)
