###################################################################################
# LAVA QA tool - Command to show the job output (log)
# Copyright (C) 2015, 2016, 2017 Collabora Ltd.

# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.

# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.

# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  US
###################################################################################

from lqa_api.outputlog import OutputLog, OutputLogError
from lqa_api.exit_codes import APPLICATION_ERROR
from lqa_tool.settings import lqa_logger
from lqa_tool.commands import Command

class OutputCmd(Command):

    def __init__(self, args):
        Command.__init__(self, args)

    def run(self):
        try:
            OutputLog(self.args.job_id, self.server, self.args.live, \
                      self.args.file, lqa_logger).run()
        except OutputLogError as e:
            lqa_logger.error("lqa output: error: {}".format(e))
            exit(APPLICATION_ERROR)
