; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+zve64x -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV32,LMULMAX2-RV32I
; RUN: llc -mtriple=riscv64 -mattr=+m,+zve64x -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV64,LMULMAX2-RV64I
; RUN: llc -mtriple=riscv32 -mattr=+m,+zve64x -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+zve64x -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV64
; RUN: llc -mtriple=riscv32 -mattr=+m,+zve64f,+f -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV32,LMULMAX2-RV32F
; RUN: llc -mtriple=riscv64 -mattr=+m,+zve64f,+f -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV64,LMULMAX2-RV64F
; RUN: llc -mtriple=riscv32 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV32,LMULMAX2-RV32D
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV64,LMULMAX2-RV64D
; RUN: llc -mtriple=riscv32 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV64
; RUN: llc -mtriple=riscv32 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=8 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX8,LMULMAX8-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+v,+d -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=8 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX8,LMULMAX8-RV64

define void @cttz_v16i8(ptr %x, ptr %y) nounwind {
; CHECK-LABEL: cttz_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    li a1, 1
; CHECK-NEXT:    vsub.vx v9, v8, a1
; CHECK-NEXT:    vnot.v v8, v8
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a1, 85
; CHECK-NEXT:    vand.vx v9, v9, a1
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    li a1, 51
; CHECK-NEXT:    vand.vx v9, v8, a1
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vadd.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v9
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
;
; LMULMAX8-LABEL: cttz_v16i8:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; LMULMAX8-NEXT:    vle8.v v8, (a0)
; LMULMAX8-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX8-NEXT:    vand.vv v9, v8, v9
; LMULMAX8-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; LMULMAX8-NEXT:    vzext.vf2 v10, v9
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v12, v10
; LMULMAX8-NEXT:    vnsrl.wi v10, v12, 23
; LMULMAX8-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; LMULMAX8-NEXT:    vnsrl.wi v9, v10, 0
; LMULMAX8-NEXT:    li a1, 127
; LMULMAX8-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX8-NEXT:    vsub.vx v8, v9, a1
; LMULMAX8-NEXT:    vmerge.vim v8, v8, 8, v0
; LMULMAX8-NEXT:    vse8.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <16 x i8>, ptr %x
  %b = load <16 x i8>, ptr %y
  %c = call <16 x i8> @llvm.cttz.v16i8(<16 x i8> %a, i1 false)
  store <16 x i8> %c, ptr %x
  ret void
}
declare <16 x i8> @llvm.cttz.v16i8(<16 x i8>, i1)

define void @cttz_v8i16(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: cttz_v8i16:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    li a1, 1
; LMULMAX2-RV32I-NEXT:    vsub.vx v9, v8, a1
; LMULMAX2-RV32I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 5
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 3
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 1
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    li a1, 257
; LMULMAX2-RV32I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX2-RV32I-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: cttz_v8i16:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV64I-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    li a1, 1
; LMULMAX2-RV64I-NEXT:    vsub.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 5
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 3
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 1
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    li a1, 257
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX2-RV64I-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    li a1, 1
; LMULMAX1-RV32-NEXT:    vsub.vx v9, v8, a1
; LMULMAX1-RV32-NEXT:    vnot.v v8, v8
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV32-NEXT:    lui a1, 5
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vsub.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    lui a1, 3
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vand.vx v9, v8, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    lui a1, 1
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    li a1, 257
; LMULMAX1-RV32-NEXT:    vmul.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    li a1, 1
; LMULMAX1-RV64-NEXT:    vsub.vx v9, v8, a1
; LMULMAX1-RV64-NEXT:    vnot.v v8, v8
; LMULMAX1-RV64-NEXT:    vand.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV64-NEXT:    lui a1, 5
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vsub.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    lui a1, 3
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v9, v8, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    lui a1, 1
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    li a1, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: cttz_v8i16:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV32F-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV32F-NEXT:    vfwcvt.f.xu.v v10, v9
; LMULMAX2-RV32F-NEXT:    vnsrl.wi v9, v10, 23
; LMULMAX2-RV32F-NEXT:    li a1, 127
; LMULMAX2-RV32F-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV32F-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV32F-NEXT:    li a1, 16
; LMULMAX2-RV32F-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV32F-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: cttz_v8i16:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV64F-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV64F-NEXT:    vfwcvt.f.xu.v v10, v9
; LMULMAX2-RV64F-NEXT:    vnsrl.wi v9, v10, 23
; LMULMAX2-RV64F-NEXT:    li a1, 127
; LMULMAX2-RV64F-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV64F-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64F-NEXT:    li a1, 16
; LMULMAX2-RV64F-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV64F-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: cttz_v8i16:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV32D-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV32D-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV32D-NEXT:    vfwcvt.f.xu.v v10, v9
; LMULMAX2-RV32D-NEXT:    vnsrl.wi v9, v10, 23
; LMULMAX2-RV32D-NEXT:    li a1, 127
; LMULMAX2-RV32D-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV32D-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV32D-NEXT:    li a1, 16
; LMULMAX2-RV32D-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV32D-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: cttz_v8i16:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX2-RV64D-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV64D-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV64D-NEXT:    vfwcvt.f.xu.v v10, v9
; LMULMAX2-RV64D-NEXT:    vnsrl.wi v9, v10, 23
; LMULMAX2-RV64D-NEXT:    li a1, 127
; LMULMAX2-RV64D-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV64D-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64D-NEXT:    li a1, 16
; LMULMAX2-RV64D-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV64D-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-LABEL: cttz_v8i16:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX8-NEXT:    vle16.v v8, (a0)
; LMULMAX8-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX8-NEXT:    vand.vv v9, v8, v9
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v10, v9
; LMULMAX8-NEXT:    vnsrl.wi v9, v10, 23
; LMULMAX8-NEXT:    li a1, 127
; LMULMAX8-NEXT:    vsub.vx v9, v9, a1
; LMULMAX8-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX8-NEXT:    li a1, 16
; LMULMAX8-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX8-NEXT:    vse16.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <8 x i16>, ptr %x
  %b = load <8 x i16>, ptr %y
  %c = call <8 x i16> @llvm.cttz.v8i16(<8 x i16> %a, i1 false)
  store <8 x i16> %c, ptr %x
  ret void
}
declare <8 x i16> @llvm.cttz.v8i16(<8 x i16>, i1)

define void @cttz_v4i32(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: cttz_v4i32:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    li a1, 1
; LMULMAX2-RV32I-NEXT:    vsub.vx v9, v8, a1
; LMULMAX2-RV32I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 349525
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 209715
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 61681
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    lui a1, 4112
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 24
; LMULMAX2-RV32I-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: cttz_v4i32:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV64I-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    li a1, 1
; LMULMAX2-RV64I-NEXT:    vsub.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 349525
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 209715
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 61681
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    lui a1, 4112
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 24
; LMULMAX2-RV64I-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: cttz_v4i32:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV32F-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV32F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32F-NEXT:    vfcvt.f.xu.v v9, v9
; LMULMAX2-RV32F-NEXT:    fsrm a1
; LMULMAX2-RV32F-NEXT:    vsrl.vi v9, v9, 23
; LMULMAX2-RV32F-NEXT:    li a1, 127
; LMULMAX2-RV32F-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV32F-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV32F-NEXT:    li a1, 32
; LMULMAX2-RV32F-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV32F-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: cttz_v4i32:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV64F-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV64F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64F-NEXT:    vfcvt.f.xu.v v9, v9
; LMULMAX2-RV64F-NEXT:    fsrm a1
; LMULMAX2-RV64F-NEXT:    vsrl.vi v9, v9, 23
; LMULMAX2-RV64F-NEXT:    li a1, 127
; LMULMAX2-RV64F-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV64F-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64F-NEXT:    li a1, 32
; LMULMAX2-RV64F-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV64F-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: cttz_v4i32:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32D-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV32D-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV32D-NEXT:    vfwcvt.f.xu.v v10, v9
; LMULMAX2-RV32D-NEXT:    li a1, 52
; LMULMAX2-RV32D-NEXT:    vnsrl.wx v9, v10, a1
; LMULMAX2-RV32D-NEXT:    li a1, 1023
; LMULMAX2-RV32D-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV32D-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV32D-NEXT:    li a1, 32
; LMULMAX2-RV32D-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV32D-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: cttz_v4i32:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV64D-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV64D-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV64D-NEXT:    vfwcvt.f.xu.v v10, v9
; LMULMAX2-RV64D-NEXT:    li a1, 52
; LMULMAX2-RV64D-NEXT:    vnsrl.wx v9, v10, a1
; LMULMAX2-RV64D-NEXT:    li a1, 1023
; LMULMAX2-RV64D-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV64D-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64D-NEXT:    li a1, 32
; LMULMAX2-RV64D-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV64D-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-LABEL: cttz_v4i32:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX8-NEXT:    vle32.v v8, (a0)
; LMULMAX8-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX8-NEXT:    vand.vv v9, v8, v9
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v10, v9
; LMULMAX8-NEXT:    li a1, 52
; LMULMAX8-NEXT:    vnsrl.wx v9, v10, a1
; LMULMAX8-NEXT:    li a1, 1023
; LMULMAX8-NEXT:    vsub.vx v9, v9, a1
; LMULMAX8-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX8-NEXT:    li a1, 32
; LMULMAX8-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX8-NEXT:    vse32.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <4 x i32>, ptr %x
  %b = load <4 x i32>, ptr %y
  %c = call <4 x i32> @llvm.cttz.v4i32(<4 x i32> %a, i1 false)
  store <4 x i32> %c, ptr %x
  ret void
}
declare <4 x i32> @llvm.cttz.v4i32(<4 x i32>, i1)

define void @cttz_v2i64(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: cttz_v2i64:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    li a1, 1
; LMULMAX2-RV32I-NEXT:    vsub.vx v9, v8, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.i v10, -1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vxor.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 349525
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v9, v9, v10
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 209715
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v9, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v10, v8, v9
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 61681
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v9, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    lui a1, 4112
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v9, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32I-NEXT:    vmul.vv v8, v8, v9
; LMULMAX2-RV32I-NEXT:    li a1, 56
; LMULMAX2-RV32I-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: cttz_v2i64:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV64I-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    li a1, 1
; LMULMAX2-RV64I-NEXT:    vsub.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vand.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 349525
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 209715
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v9, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v9, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v9
; LMULMAX2-RV64I-NEXT:    lui a1, 61681
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    lui a1, 4112
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    li a1, 56
; LMULMAX2-RV64I-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: cttz_v2i64:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vmv.v.i v9, 0
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vsub.vv v10, v9, v8
; LMULMAX2-RV32F-NEXT:    vand.vv v10, v8, v10
; LMULMAX2-RV32F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32F-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; LMULMAX2-RV32F-NEXT:    vfncvt.f.xu.w v11, v10
; LMULMAX2-RV32F-NEXT:    fsrm a1
; LMULMAX2-RV32F-NEXT:    vsrl.vi v10, v11, 23
; LMULMAX2-RV32F-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vzext.vf2 v11, v10
; LMULMAX2-RV32F-NEXT:    li a1, 127
; LMULMAX2-RV32F-NEXT:    vsub.vx v10, v11, a1
; LMULMAX2-RV32F-NEXT:    vmseq.vv v0, v8, v9
; LMULMAX2-RV32F-NEXT:    li a1, 64
; LMULMAX2-RV32F-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX2-RV32F-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: cttz_v2i64:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV64F-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV64F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64F-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; LMULMAX2-RV64F-NEXT:    vfncvt.f.xu.w v10, v9
; LMULMAX2-RV64F-NEXT:    fsrm a1
; LMULMAX2-RV64F-NEXT:    vsrl.vi v9, v10, 23
; LMULMAX2-RV64F-NEXT:    li a1, 127
; LMULMAX2-RV64F-NEXT:    vwsubu.vx v10, v9, a1
; LMULMAX2-RV64F-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64F-NEXT:    li a1, 64
; LMULMAX2-RV64F-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX2-RV64F-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: cttz_v2i64:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32D-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX2-RV32D-NEXT:    vmv.v.i v9, 0
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV32D-NEXT:    vsub.vv v10, v9, v8
; LMULMAX2-RV32D-NEXT:    vand.vv v10, v8, v10
; LMULMAX2-RV32D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32D-NEXT:    vfcvt.f.xu.v v10, v10
; LMULMAX2-RV32D-NEXT:    fsrm a1
; LMULMAX2-RV32D-NEXT:    li a1, 52
; LMULMAX2-RV32D-NEXT:    vsrl.vx v10, v10, a1
; LMULMAX2-RV32D-NEXT:    li a1, 1023
; LMULMAX2-RV32D-NEXT:    vsub.vx v10, v10, a1
; LMULMAX2-RV32D-NEXT:    vmseq.vv v0, v8, v9
; LMULMAX2-RV32D-NEXT:    li a1, 64
; LMULMAX2-RV32D-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX2-RV32D-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: cttz_v2i64:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX2-RV64D-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX2-RV64D-NEXT:    vand.vv v9, v8, v9
; LMULMAX2-RV64D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64D-NEXT:    vfcvt.f.xu.v v9, v9
; LMULMAX2-RV64D-NEXT:    fsrm a1
; LMULMAX2-RV64D-NEXT:    li a1, 52
; LMULMAX2-RV64D-NEXT:    vsrl.vx v9, v9, a1
; LMULMAX2-RV64D-NEXT:    li a1, 1023
; LMULMAX2-RV64D-NEXT:    vsub.vx v9, v9, a1
; LMULMAX2-RV64D-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64D-NEXT:    li a1, 64
; LMULMAX2-RV64D-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX2-RV64D-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-RV32-LABEL: cttz_v2i64:
; LMULMAX8-RV32:       # %bb.0:
; LMULMAX8-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX8-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX8-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; LMULMAX8-RV32-NEXT:    vmv.v.i v9, 0
; LMULMAX8-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX8-RV32-NEXT:    vsub.vv v10, v9, v8
; LMULMAX8-RV32-NEXT:    vand.vv v10, v8, v10
; LMULMAX8-RV32-NEXT:    fsrmi a1, 1
; LMULMAX8-RV32-NEXT:    vfcvt.f.xu.v v10, v10
; LMULMAX8-RV32-NEXT:    fsrm a1
; LMULMAX8-RV32-NEXT:    li a1, 52
; LMULMAX8-RV32-NEXT:    vsrl.vx v10, v10, a1
; LMULMAX8-RV32-NEXT:    li a1, 1023
; LMULMAX8-RV32-NEXT:    vsub.vx v10, v10, a1
; LMULMAX8-RV32-NEXT:    vmseq.vv v0, v8, v9
; LMULMAX8-RV32-NEXT:    li a1, 64
; LMULMAX8-RV32-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX8-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX8-RV32-NEXT:    ret
;
; LMULMAX8-RV64-LABEL: cttz_v2i64:
; LMULMAX8-RV64:       # %bb.0:
; LMULMAX8-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; LMULMAX8-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX8-RV64-NEXT:    vrsub.vi v9, v8, 0
; LMULMAX8-RV64-NEXT:    vand.vv v9, v8, v9
; LMULMAX8-RV64-NEXT:    fsrmi a1, 1
; LMULMAX8-RV64-NEXT:    vfcvt.f.xu.v v9, v9
; LMULMAX8-RV64-NEXT:    fsrm a1
; LMULMAX8-RV64-NEXT:    li a1, 52
; LMULMAX8-RV64-NEXT:    vsrl.vx v9, v9, a1
; LMULMAX8-RV64-NEXT:    li a1, 1023
; LMULMAX8-RV64-NEXT:    vsub.vx v9, v9, a1
; LMULMAX8-RV64-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX8-RV64-NEXT:    li a1, 64
; LMULMAX8-RV64-NEXT:    vmerge.vxm v8, v9, a1, v0
; LMULMAX8-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX8-RV64-NEXT:    ret
  %a = load <2 x i64>, ptr %x
  %b = load <2 x i64>, ptr %y
  %c = call <2 x i64> @llvm.cttz.v2i64(<2 x i64> %a, i1 false)
  store <2 x i64> %c, ptr %x
  ret void
}
declare <2 x i64> @llvm.cttz.v2i64(<2 x i64>, i1)

define void @cttz_v32i8(ptr %x, ptr %y) nounwind {
; LMULMAX2-LABEL: cttz_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    li a1, 32
; LMULMAX2-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; LMULMAX2-NEXT:    vle8.v v8, (a0)
; LMULMAX2-NEXT:    li a1, 1
; LMULMAX2-NEXT:    vsub.vx v10, v8, a1
; LMULMAX2-NEXT:    vnot.v v8, v8
; LMULMAX2-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-NEXT:    li a1, 85
; LMULMAX2-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-NEXT:    li a1, 51
; LMULMAX2-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-NEXT:    vand.vi v8, v8, 15
; LMULMAX2-NEXT:    vse8.v v8, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: cttz_v32i8:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle8.v v8, (a1)
; LMULMAX1-NEXT:    vle8.v v9, (a0)
; LMULMAX1-NEXT:    li a2, 1
; LMULMAX1-NEXT:    vsub.vx v10, v8, a2
; LMULMAX1-NEXT:    vnot.v v8, v8
; LMULMAX1-NEXT:    vand.vv v8, v8, v10
; LMULMAX1-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-NEXT:    li a3, 85
; LMULMAX1-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-NEXT:    vsub.vv v8, v8, v10
; LMULMAX1-NEXT:    li a4, 51
; LMULMAX1-NEXT:    vand.vx v10, v8, a4
; LMULMAX1-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-NEXT:    vadd.vv v8, v10, v8
; LMULMAX1-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-NEXT:    vadd.vv v8, v8, v10
; LMULMAX1-NEXT:    vand.vi v8, v8, 15
; LMULMAX1-NEXT:    vsub.vx v10, v9, a2
; LMULMAX1-NEXT:    vnot.v v9, v9
; LMULMAX1-NEXT:    vand.vv v9, v9, v10
; LMULMAX1-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-NEXT:    vsub.vv v9, v9, v10
; LMULMAX1-NEXT:    vand.vx v10, v9, a4
; LMULMAX1-NEXT:    vsrl.vi v9, v9, 2
; LMULMAX1-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-NEXT:    vadd.vv v9, v10, v9
; LMULMAX1-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-NEXT:    vadd.vv v9, v9, v10
; LMULMAX1-NEXT:    vand.vi v9, v9, 15
; LMULMAX1-NEXT:    vse8.v v9, (a0)
; LMULMAX1-NEXT:    vse8.v v8, (a1)
; LMULMAX1-NEXT:    ret
;
; LMULMAX8-LABEL: cttz_v32i8:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    li a1, 32
; LMULMAX8-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; LMULMAX8-NEXT:    vle8.v v8, (a0)
; LMULMAX8-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX8-NEXT:    vand.vv v10, v8, v10
; LMULMAX8-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; LMULMAX8-NEXT:    vzext.vf2 v12, v10
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v16, v12
; LMULMAX8-NEXT:    vnsrl.wi v12, v16, 23
; LMULMAX8-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; LMULMAX8-NEXT:    vnsrl.wi v10, v12, 0
; LMULMAX8-NEXT:    li a1, 127
; LMULMAX8-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX8-NEXT:    vsub.vx v8, v10, a1
; LMULMAX8-NEXT:    vmerge.vim v8, v8, 8, v0
; LMULMAX8-NEXT:    vse8.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <32 x i8>, ptr %x
  %b = load <32 x i8>, ptr %y
  %c = call <32 x i8> @llvm.cttz.v32i8(<32 x i8> %a, i1 false)
  store <32 x i8> %c, ptr %x
  ret void
}
declare <32 x i8> @llvm.cttz.v32i8(<32 x i8>, i1)

define void @cttz_v16i16(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32-LABEL: cttz_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX2-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    li a1, 1
; LMULMAX2-RV32-NEXT:    vsub.vx v10, v8, a1
; LMULMAX2-RV32-NEXT:    vnot.v v8, v8
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    li a1, 257
; LMULMAX2-RV32-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX2-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: cttz_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX2-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    li a1, 1
; LMULMAX2-RV64-NEXT:    vsub.vx v10, v8, a1
; LMULMAX2-RV64-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    li a1, 257
; LMULMAX2-RV64-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX2-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: cttz_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a1)
; LMULMAX1-RV32-NEXT:    vle16.v v9, (a0)
; LMULMAX1-RV32-NEXT:    li a2, 1
; LMULMAX1-RV32-NEXT:    vsub.vx v10, v8, a2
; LMULMAX1-RV32-NEXT:    vnot.v v8, v8
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV32-NEXT:    lui a3, 5
; LMULMAX1-RV32-NEXT:    addi a3, a3, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vsub.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    lui a4, 3
; LMULMAX1-RV32-NEXT:    addi a4, a4, 819
; LMULMAX1-RV32-NEXT:    vand.vx v10, v8, a4
; LMULMAX1-RV32-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    lui a5, 1
; LMULMAX1-RV32-NEXT:    addi a5, a5, -241
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a5
; LMULMAX1-RV32-NEXT:    li a6, 257
; LMULMAX1-RV32-NEXT:    vmul.vx v8, v8, a6
; LMULMAX1-RV32-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX1-RV32-NEXT:    vsub.vx v10, v9, a2
; LMULMAX1-RV32-NEXT:    vnot.v v9, v9
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vsub.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vand.vx v10, v9, a4
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v9, 2
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV32-NEXT:    vadd.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a5
; LMULMAX1-RV32-NEXT:    vmul.vx v9, v9, a6
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v9, 8
; LMULMAX1-RV32-NEXT:    vse16.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: cttz_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a1)
; LMULMAX1-RV64-NEXT:    vle16.v v9, (a0)
; LMULMAX1-RV64-NEXT:    li a2, 1
; LMULMAX1-RV64-NEXT:    vsub.vx v10, v8, a2
; LMULMAX1-RV64-NEXT:    vnot.v v8, v8
; LMULMAX1-RV64-NEXT:    vand.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    lui a3, 5
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vsub.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    lui a4, 3
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 819
; LMULMAX1-RV64-NEXT:    vand.vx v10, v8, a4
; LMULMAX1-RV64-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    lui a5, 1
; LMULMAX1-RV64-NEXT:    addiw a5, a5, -241
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a5
; LMULMAX1-RV64-NEXT:    li a6, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v8, v8, a6
; LMULMAX1-RV64-NEXT:    vsrl.vi v8, v8, 8
; LMULMAX1-RV64-NEXT:    vsub.vx v10, v9, a2
; LMULMAX1-RV64-NEXT:    vnot.v v9, v9
; LMULMAX1-RV64-NEXT:    vand.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vsub.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vand.vx v10, v9, a4
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v9, 2
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a5
; LMULMAX1-RV64-NEXT:    vmul.vx v9, v9, a6
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v9, 8
; LMULMAX1-RV64-NEXT:    vse16.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a1)
; LMULMAX1-RV64-NEXT:    ret
;
; LMULMAX8-LABEL: cttz_v16i16:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; LMULMAX8-NEXT:    vle16.v v8, (a0)
; LMULMAX8-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX8-NEXT:    vand.vv v10, v8, v10
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v12, v10
; LMULMAX8-NEXT:    vnsrl.wi v10, v12, 23
; LMULMAX8-NEXT:    li a1, 127
; LMULMAX8-NEXT:    vsub.vx v10, v10, a1
; LMULMAX8-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX8-NEXT:    li a1, 16
; LMULMAX8-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX8-NEXT:    vse16.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <16 x i16>, ptr %x
  %b = load <16 x i16>, ptr %y
  %c = call <16 x i16> @llvm.cttz.v16i16(<16 x i16> %a, i1 false)
  store <16 x i16> %c, ptr %x
  ret void
}
declare <16 x i16> @llvm.cttz.v16i16(<16 x i16>, i1)

define void @cttz_v8i32(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: cttz_v8i32:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    li a1, 1
; LMULMAX2-RV32I-NEXT:    vsub.vx v10, v8, a1
; LMULMAX2-RV32I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 349525
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 209715
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 61681
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    lui a1, 4112
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 24
; LMULMAX2-RV32I-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: cttz_v8i32:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV64I-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    li a1, 1
; LMULMAX2-RV64I-NEXT:    vsub.vx v10, v8, a1
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 349525
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    lui a1, 209715
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    lui a1, 61681
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    lui a1, 4112
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 24
; LMULMAX2-RV64I-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: cttz_v8i32:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32F-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX2-RV32F-NEXT:    vand.vv v10, v8, v10
; LMULMAX2-RV32F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32F-NEXT:    vfcvt.f.xu.v v10, v10
; LMULMAX2-RV32F-NEXT:    fsrm a1
; LMULMAX2-RV32F-NEXT:    vsrl.vi v10, v10, 23
; LMULMAX2-RV32F-NEXT:    li a1, 127
; LMULMAX2-RV32F-NEXT:    vsub.vx v10, v10, a1
; LMULMAX2-RV32F-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV32F-NEXT:    li a1, 32
; LMULMAX2-RV32F-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX2-RV32F-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: cttz_v8i32:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV64F-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX2-RV64F-NEXT:    vand.vv v10, v8, v10
; LMULMAX2-RV64F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64F-NEXT:    vfcvt.f.xu.v v10, v10
; LMULMAX2-RV64F-NEXT:    fsrm a1
; LMULMAX2-RV64F-NEXT:    vsrl.vi v10, v10, 23
; LMULMAX2-RV64F-NEXT:    li a1, 127
; LMULMAX2-RV64F-NEXT:    vsub.vx v10, v10, a1
; LMULMAX2-RV64F-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64F-NEXT:    li a1, 32
; LMULMAX2-RV64F-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX2-RV64F-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: cttz_v8i32:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32D-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX2-RV32D-NEXT:    vand.vv v10, v8, v10
; LMULMAX2-RV32D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32D-NEXT:    vfcvt.f.xu.v v10, v10
; LMULMAX2-RV32D-NEXT:    fsrm a1
; LMULMAX2-RV32D-NEXT:    vsrl.vi v10, v10, 23
; LMULMAX2-RV32D-NEXT:    li a1, 127
; LMULMAX2-RV32D-NEXT:    vsub.vx v10, v10, a1
; LMULMAX2-RV32D-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV32D-NEXT:    li a1, 32
; LMULMAX2-RV32D-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX2-RV32D-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: cttz_v8i32:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV64D-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX2-RV64D-NEXT:    vand.vv v10, v8, v10
; LMULMAX2-RV64D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64D-NEXT:    vfcvt.f.xu.v v10, v10
; LMULMAX2-RV64D-NEXT:    fsrm a1
; LMULMAX2-RV64D-NEXT:    vsrl.vi v10, v10, 23
; LMULMAX2-RV64D-NEXT:    li a1, 127
; LMULMAX2-RV64D-NEXT:    vsub.vx v10, v10, a1
; LMULMAX2-RV64D-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64D-NEXT:    li a1, 32
; LMULMAX2-RV64D-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX2-RV64D-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-LABEL: cttz_v8i32:
; LMULMAX8:       # %bb.0:
; LMULMAX8-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX8-NEXT:    vle32.v v8, (a0)
; LMULMAX8-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX8-NEXT:    vand.vv v10, v8, v10
; LMULMAX8-NEXT:    vfwcvt.f.xu.v v12, v10
; LMULMAX8-NEXT:    li a1, 52
; LMULMAX8-NEXT:    vnsrl.wx v10, v12, a1
; LMULMAX8-NEXT:    li a1, 1023
; LMULMAX8-NEXT:    vsub.vx v10, v10, a1
; LMULMAX8-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX8-NEXT:    li a1, 32
; LMULMAX8-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX8-NEXT:    vse32.v v8, (a0)
; LMULMAX8-NEXT:    ret
  %a = load <8 x i32>, ptr %x
  %b = load <8 x i32>, ptr %y
  %c = call <8 x i32> @llvm.cttz.v8i32(<8 x i32> %a, i1 false)
  store <8 x i32> %c, ptr %x
  ret void
}
declare <8 x i32> @llvm.cttz.v8i32(<8 x i32>, i1)

define void @cttz_v4i64(ptr %x, ptr %y) nounwind {
; LMULMAX2-RV32I-LABEL: cttz_v4i64:
; LMULMAX2-RV32I:       # %bb.0:
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    li a1, 1
; LMULMAX2-RV32I-NEXT:    vsub.vx v10, v8, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.i v12, -1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vxor.vv v8, v8, v12
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32I-NEXT:    lui a1, 349525
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v12, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v10, v10, v12
; LMULMAX2-RV32I-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 209715
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v12, v8, v10
; LMULMAX2-RV32I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v12, v8
; LMULMAX2-RV32I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32I-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 61681
; LMULMAX2-RV32I-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    lui a1, 4112
; LMULMAX2-RV32I-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32I-NEXT:    vmul.vv v8, v8, v10
; LMULMAX2-RV32I-NEXT:    li a1, 56
; LMULMAX2-RV32I-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV32I-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32I-NEXT:    ret
;
; LMULMAX2-RV64I-LABEL: cttz_v4i64:
; LMULMAX2-RV64I:       # %bb.0:
; LMULMAX2-RV64I-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV64I-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    li a1, 1
; LMULMAX2-RV64I-NEXT:    vsub.vx v10, v8, a1
; LMULMAX2-RV64I-NEXT:    vnot.v v8, v8
; LMULMAX2-RV64I-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64I-NEXT:    lui a1, 349525
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64I-NEXT:    vsub.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    lui a1, 209715
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v10, v8, a1
; LMULMAX2-RV64I-NEXT:    vsrl.vi v8, v8, 2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v10, v8
; LMULMAX2-RV64I-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64I-NEXT:    vadd.vv v8, v8, v10
; LMULMAX2-RV64I-NEXT:    lui a1, 61681
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    lui a1, 4112
; LMULMAX2-RV64I-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64I-NEXT:    slli a2, a1, 32
; LMULMAX2-RV64I-NEXT:    add a1, a1, a2
; LMULMAX2-RV64I-NEXT:    vmul.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    li a1, 56
; LMULMAX2-RV64I-NEXT:    vsrl.vx v8, v8, a1
; LMULMAX2-RV64I-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64I-NEXT:    ret
;
; LMULMAX2-RV32F-LABEL: cttz_v4i64:
; LMULMAX2-RV32F:       # %bb.0:
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32F-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32F-NEXT:    vmv.v.i v10, 0
; LMULMAX2-RV32F-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32F-NEXT:    vsub.vv v12, v10, v8
; LMULMAX2-RV32F-NEXT:    vand.vv v12, v8, v12
; LMULMAX2-RV32F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32F-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; LMULMAX2-RV32F-NEXT:    vfncvt.f.xu.w v14, v12
; LMULMAX2-RV32F-NEXT:    fsrm a1
; LMULMAX2-RV32F-NEXT:    vsrl.vi v12, v14, 23
; LMULMAX2-RV32F-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; LMULMAX2-RV32F-NEXT:    vzext.vf2 v14, v12
; LMULMAX2-RV32F-NEXT:    li a1, 127
; LMULMAX2-RV32F-NEXT:    vsub.vx v12, v14, a1
; LMULMAX2-RV32F-NEXT:    vmseq.vv v0, v8, v10
; LMULMAX2-RV32F-NEXT:    li a1, 64
; LMULMAX2-RV32F-NEXT:    vmerge.vxm v8, v12, a1, v0
; LMULMAX2-RV32F-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32F-NEXT:    ret
;
; LMULMAX2-RV64F-LABEL: cttz_v4i64:
; LMULMAX2-RV64F:       # %bb.0:
; LMULMAX2-RV64F-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV64F-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX2-RV64F-NEXT:    vand.vv v10, v8, v10
; LMULMAX2-RV64F-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64F-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; LMULMAX2-RV64F-NEXT:    vfncvt.f.xu.w v12, v10
; LMULMAX2-RV64F-NEXT:    fsrm a1
; LMULMAX2-RV64F-NEXT:    vsrl.vi v10, v12, 23
; LMULMAX2-RV64F-NEXT:    li a1, 127
; LMULMAX2-RV64F-NEXT:    vwsubu.vx v12, v10, a1
; LMULMAX2-RV64F-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; LMULMAX2-RV64F-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64F-NEXT:    li a1, 64
; LMULMAX2-RV64F-NEXT:    vmerge.vxm v8, v12, a1, v0
; LMULMAX2-RV64F-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64F-NEXT:    ret
;
; LMULMAX2-RV32D-LABEL: cttz_v4i64:
; LMULMAX2-RV32D:       # %bb.0:
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32D-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX2-RV32D-NEXT:    vmv.v.i v10, 0
; LMULMAX2-RV32D-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV32D-NEXT:    vsub.vv v12, v10, v8
; LMULMAX2-RV32D-NEXT:    vand.vv v12, v8, v12
; LMULMAX2-RV32D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV32D-NEXT:    vfcvt.f.xu.v v12, v12
; LMULMAX2-RV32D-NEXT:    fsrm a1
; LMULMAX2-RV32D-NEXT:    li a1, 52
; LMULMAX2-RV32D-NEXT:    vsrl.vx v12, v12, a1
; LMULMAX2-RV32D-NEXT:    li a1, 1023
; LMULMAX2-RV32D-NEXT:    vsub.vx v12, v12, a1
; LMULMAX2-RV32D-NEXT:    vmseq.vv v0, v8, v10
; LMULMAX2-RV32D-NEXT:    li a1, 64
; LMULMAX2-RV32D-NEXT:    vmerge.vxm v8, v12, a1, v0
; LMULMAX2-RV32D-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32D-NEXT:    ret
;
; LMULMAX2-RV64D-LABEL: cttz_v4i64:
; LMULMAX2-RV64D:       # %bb.0:
; LMULMAX2-RV64D-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX2-RV64D-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX2-RV64D-NEXT:    vand.vv v10, v8, v10
; LMULMAX2-RV64D-NEXT:    fsrmi a1, 1
; LMULMAX2-RV64D-NEXT:    vfcvt.f.xu.v v10, v10
; LMULMAX2-RV64D-NEXT:    fsrm a1
; LMULMAX2-RV64D-NEXT:    li a1, 52
; LMULMAX2-RV64D-NEXT:    vsrl.vx v10, v10, a1
; LMULMAX2-RV64D-NEXT:    li a1, 1023
; LMULMAX2-RV64D-NEXT:    vsub.vx v10, v10, a1
; LMULMAX2-RV64D-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX2-RV64D-NEXT:    li a1, 64
; LMULMAX2-RV64D-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX2-RV64D-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64D-NEXT:    ret
;
; LMULMAX8-RV32-LABEL: cttz_v4i64:
; LMULMAX8-RV32:       # %bb.0:
; LMULMAX8-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX8-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX8-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; LMULMAX8-RV32-NEXT:    vmv.v.i v10, 0
; LMULMAX8-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX8-RV32-NEXT:    vsub.vv v12, v10, v8
; LMULMAX8-RV32-NEXT:    vand.vv v12, v8, v12
; LMULMAX8-RV32-NEXT:    fsrmi a1, 1
; LMULMAX8-RV32-NEXT:    vfcvt.f.xu.v v12, v12
; LMULMAX8-RV32-NEXT:    fsrm a1
; LMULMAX8-RV32-NEXT:    li a1, 52
; LMULMAX8-RV32-NEXT:    vsrl.vx v12, v12, a1
; LMULMAX8-RV32-NEXT:    li a1, 1023
; LMULMAX8-RV32-NEXT:    vsub.vx v12, v12, a1
; LMULMAX8-RV32-NEXT:    vmseq.vv v0, v8, v10
; LMULMAX8-RV32-NEXT:    li a1, 64
; LMULMAX8-RV32-NEXT:    vmerge.vxm v8, v12, a1, v0
; LMULMAX8-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX8-RV32-NEXT:    ret
;
; LMULMAX8-RV64-LABEL: cttz_v4i64:
; LMULMAX8-RV64:       # %bb.0:
; LMULMAX8-RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; LMULMAX8-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX8-RV64-NEXT:    vrsub.vi v10, v8, 0
; LMULMAX8-RV64-NEXT:    vand.vv v10, v8, v10
; LMULMAX8-RV64-NEXT:    fsrmi a1, 1
; LMULMAX8-RV64-NEXT:    vfcvt.f.xu.v v10, v10
; LMULMAX8-RV64-NEXT:    fsrm a1
; LMULMAX8-RV64-NEXT:    li a1, 52
; LMULMAX8-RV64-NEXT:    vsrl.vx v10, v10, a1
; LMULMAX8-RV64-NEXT:    li a1, 1023
; LMULMAX8-RV64-NEXT:    vsub.vx v10, v10, a1
; LMULMAX8-RV64-NEXT:    vmseq.vi v0, v8, 0
; LMULMAX8-RV64-NEXT:    li a1, 64
; LMULMAX8-RV64-NEXT:    vmerge.vxm v8, v10, a1, v0
; LMULMAX8-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX8-RV64-NEXT:    ret
  %a = load <4 x i64>, ptr %x
  %b = load <4 x i64>, ptr %y
  %c = call <4 x i64> @llvm.cttz.v4i64(<4 x i64> %a, i1 false)
  store <4 x i64> %c, ptr %x
  ret void
}
declare <4 x i64> @llvm.cttz.v4i64(<4 x i64>, i1)
