; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+v -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s

define <2 x i16> @vwmaccu_v2i16(<2 x i8>* %x, <2 x i8>* %y, <2 x i16> %z) {
; CHECK-LABEL: vwmaccu_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, mu
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vle8.v v10, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v9, v10
; CHECK-NEXT:    ret
  %a = load <2 x i8>, <2 x i8>* %x
  %b = load <2 x i8>, <2 x i8>* %y
  %c = zext <2 x i8> %a to <2 x i16>
  %d = zext <2 x i8> %b to <2 x i16>
  %e = mul <2 x i16> %c, %d
  %f = add <2 x i16> %e, %z
  ret <2 x i16> %f
}

define <4 x i16> @vwmaccu_v4i16(<4 x i8>* %x, <4 x i8>* %y, <4 x i16> %z) {
; CHECK-LABEL: vwmaccu_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, mu
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vle8.v v10, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v9, v10
; CHECK-NEXT:    ret
  %a = load <4 x i8>, <4 x i8>* %x
  %b = load <4 x i8>, <4 x i8>* %y
  %c = zext <4 x i8> %a to <4 x i16>
  %d = zext <4 x i8> %b to <4 x i16>
  %e = mul <4 x i16> %c, %d
  %f = add <4 x i16> %e, %z
  ret <4 x i16> %f
}

define <2 x i32> @vwmaccu_v2i32(<2 x i16>* %x, <2 x i16>* %y, <2 x i32> %z) {
; CHECK-LABEL: vwmaccu_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v9, v10
; CHECK-NEXT:    ret
  %a = load <2 x i16>, <2 x i16>* %x
  %b = load <2 x i16>, <2 x i16>* %y
  %c = zext <2 x i16> %a to <2 x i32>
  %d = zext <2 x i16> %b to <2 x i32>
  %e = mul <2 x i32> %c, %d
  %f = add <2 x i32> %e, %z
  ret <2 x i32> %f
}

define <8 x i16> @vwmaccu_v8i16(<8 x i8>* %x, <8 x i8>* %y, <8 x i16> %z) {
; CHECK-LABEL: vwmaccu_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vle8.v v10, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v9, v10
; CHECK-NEXT:    ret
  %a = load <8 x i8>, <8 x i8>* %x
  %b = load <8 x i8>, <8 x i8>* %y
  %c = zext <8 x i8> %a to <8 x i16>
  %d = zext <8 x i8> %b to <8 x i16>
  %e = mul <8 x i16> %c, %d
  %f = add <8 x i16> %e, %z
  ret <8 x i16> %f
}

define <4 x i32> @vwmaccu_v4i32(<4 x i16>* %x, <4 x i16>* %y, <4 x i32> %z) {
; CHECK-LABEL: vwmaccu_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vle16.v v10, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v9, v10
; CHECK-NEXT:    ret
  %a = load <4 x i16>, <4 x i16>* %x
  %b = load <4 x i16>, <4 x i16>* %y
  %c = zext <4 x i16> %a to <4 x i32>
  %d = zext <4 x i16> %b to <4 x i32>
  %e = mul <4 x i32> %c, %d
  %f = add <4 x i32> %e, %z
  ret <4 x i32> %f
}

define <2 x i64> @vwmaccu_v2i64(<2 x i32>* %x, <2 x i32>* %y, <2 x i64> %z) {
; CHECK-LABEL: vwmaccu_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v9, (a0)
; CHECK-NEXT:    vle32.v v10, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v9, v10
; CHECK-NEXT:    ret
  %a = load <2 x i32>, <2 x i32>* %x
  %b = load <2 x i32>, <2 x i32>* %y
  %c = zext <2 x i32> %a to <2 x i64>
  %d = zext <2 x i32> %b to <2 x i64>
  %e = mul <2 x i64> %c, %d
  %f = add <2 x i64> %e, %z
  ret <2 x i64> %f
}

define <16 x i16> @vwmaccu_v16i16(<16 x i8>* %x, <16 x i8>* %y, <16 x i16> %z) {
; CHECK-LABEL: vwmaccu_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; CHECK-NEXT:    vle8.v v10, (a0)
; CHECK-NEXT:    vle8.v v11, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v10, v11
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = zext <16 x i8> %a to <16 x i16>
  %d = zext <16 x i8> %b to <16 x i16>
  %e = mul <16 x i16> %c, %d
  %f = add <16 x i16> %e, %z
  ret <16 x i16> %f
}

define <8 x i32> @vwmaccu_v8i32(<8 x i16>* %x, <8 x i16>* %y, <8 x i32> %z) {
; CHECK-LABEL: vwmaccu_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vle16.v v11, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v10, v11
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = zext <8 x i16> %a to <8 x i32>
  %d = zext <8 x i16> %b to <8 x i32>
  %e = mul <8 x i32> %c, %d
  %f = add <8 x i32> %e, %z
  ret <8 x i32> %f
}

define <4 x i64> @vwmaccu_v4i64(<4 x i32>* %x, <4 x i32>* %y, <4 x i64> %z) {
; CHECK-LABEL: vwmaccu_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v10, (a0)
; CHECK-NEXT:    vle32.v v11, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v10, v11
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = zext <4 x i32> %a to <4 x i64>
  %d = zext <4 x i32> %b to <4 x i64>
  %e = mul <4 x i64> %c, %d
  %f = add <4 x i64> %e, %z
  ret <4 x i64> %f
}

define <32 x i16> @vwmaccu_v32i16(<32 x i8>* %x, <32 x i8>* %y, <32 x i16> %z) {
; CHECK-LABEL: vwmaccu_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, mu
; CHECK-NEXT:    vle8.v v12, (a0)
; CHECK-NEXT:    vle8.v v14, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v12, v14
; CHECK-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = zext <32 x i8> %a to <32 x i16>
  %d = zext <32 x i8> %b to <32 x i16>
  %e = mul <32 x i16> %c, %d
  %f = add <32 x i16> %e, %z
  ret <32 x i16> %f
}

define <16 x i32> @vwmaccu_v16i32(<16 x i16>* %x, <16 x i16>* %y, <16 x i32> %z) {
; CHECK-LABEL: vwmaccu_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vle16.v v14, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v12, v14
; CHECK-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = zext <16 x i16> %a to <16 x i32>
  %d = zext <16 x i16> %b to <16 x i32>
  %e = mul <16 x i32> %c, %d
  %f = add <16 x i32> %e, %z
  ret <16 x i32> %f
}

define <8 x i64> @vwmaccu_v8i64(<8 x i32>* %x, <8 x i32>* %y, <8 x i64> %z) {
; CHECK-LABEL: vwmaccu_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v12, (a0)
; CHECK-NEXT:    vle32.v v14, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v12, v14
; CHECK-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = zext <8 x i32> %a to <8 x i64>
  %d = zext <8 x i32> %b to <8 x i64>
  %e = mul <8 x i64> %c, %d
  %f = add <8 x i64> %e, %z
  ret <8 x i64> %f
}

define <64 x i16> @vwmaccu_v64i16(<64 x i8>* %x, <64 x i8>* %y, <64 x i16> %z) {
; CHECK-LABEL: vwmaccu_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, mu
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vle8.v v20, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v16, v20
; CHECK-NEXT:    ret
  %a = load <64 x i8>, <64 x i8>* %x
  %b = load <64 x i8>, <64 x i8>* %y
  %c = zext <64 x i8> %a to <64 x i16>
  %d = zext <64 x i8> %b to <64 x i16>
  %e = mul <64 x i16> %c, %d
  %f = add <64 x i16> %e, %z
  ret <64 x i16> %f
}

define <32 x i32> @vwmaccu_v32i32(<32 x i16>* %x, <32 x i16>* %y, <32 x i32> %z) {
; CHECK-LABEL: vwmaccu_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vle16.v v20, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v16, v20
; CHECK-NEXT:    ret
  %a = load <32 x i16>, <32 x i16>* %x
  %b = load <32 x i16>, <32 x i16>* %y
  %c = zext <32 x i16> %a to <32 x i32>
  %d = zext <32 x i16> %b to <32 x i32>
  %e = mul <32 x i32> %c, %d
  %f = add <32 x i32> %e, %z
  ret <32 x i32> %f
}

define <16 x i64> @vwmaccu_v16i64(<16 x i32>* %x, <16 x i32>* %y, <16 x i64> %z) {
; CHECK-LABEL: vwmaccu_v16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vle32.v v20, (a1)
; CHECK-NEXT:    vwmaccu.vv v8, v16, v20
; CHECK-NEXT:    ret
  %a = load <16 x i32>, <16 x i32>* %x
  %b = load <16 x i32>, <16 x i32>* %y
  %c = zext <16 x i32> %a to <16 x i64>
  %d = zext <16 x i32> %b to <16 x i64>
  %e = mul <16 x i64> %c, %d
  %f = add <16 x i64> %e, %z
  ret <16 x i64> %f
}

define <2 x i16> @vwmaccu_vx_v2i16(<2 x i8>* %x, i8 %y, <2 x i16> %z) {
; CHECK-LABEL: vwmaccu_vx_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e8, mf8, ta, mu
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v9
; CHECK-NEXT:    ret
  %a = load <2 x i8>, <2 x i8>* %x
  %b = insertelement <2 x i8> poison, i8 %y, i32 0
  %c = shufflevector <2 x i8> %b, <2 x i8> poison, <2 x i32> zeroinitializer
  %d = zext <2 x i8> %a to <2 x i16>
  %e = zext <2 x i8> %c to <2 x i16>
  %f = mul <2 x i16> %d, %e
  %g = add <2 x i16> %f, %z
  ret <2 x i16> %g
}

define <4 x i16> @vwmaccu_vx_v4i16(<4 x i8>* %x, i8 %y, <4 x i16> %z) {
; CHECK-LABEL: vwmaccu_vx_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, mu
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v9
; CHECK-NEXT:    ret
  %a = load <4 x i8>, <4 x i8>* %x
  %b = insertelement <4 x i8> poison, i8 %y, i32 0
  %c = shufflevector <4 x i8> %b, <4 x i8> poison, <4 x i32> zeroinitializer
  %d = zext <4 x i8> %a to <4 x i16>
  %e = zext <4 x i8> %c to <4 x i16>
  %f = mul <4 x i16> %d, %e
  %g = add <4 x i16> %f, %z
  ret <4 x i16> %g
}

define <2 x i32> @vwmaccu_vx_v2i32(<2 x i16>* %x, i16 %y, <2 x i32> %z) {
; CHECK-LABEL: vwmaccu_vx_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v9
; CHECK-NEXT:    ret
  %a = load <2 x i16>, <2 x i16>* %x
  %b = insertelement <2 x i16> poison, i16 %y, i32 0
  %c = shufflevector <2 x i16> %b, <2 x i16> poison, <2 x i32> zeroinitializer
  %d = zext <2 x i16> %a to <2 x i32>
  %e = zext <2 x i16> %c to <2 x i32>
  %f = mul <2 x i32> %d, %e
  %g = add <2 x i32> %f, %z
  ret <2 x i32> %g
}

define <8 x i16> @vwmaccu_vx_v8i16(<8 x i8>* %x, i8 %y, <8 x i16> %z) {
; CHECK-LABEL: vwmaccu_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v9
; CHECK-NEXT:    ret
  %a = load <8 x i8>, <8 x i8>* %x
  %b = insertelement <8 x i8> poison, i8 %y, i32 0
  %c = shufflevector <8 x i8> %b, <8 x i8> poison, <8 x i32> zeroinitializer
  %d = zext <8 x i8> %a to <8 x i16>
  %e = zext <8 x i8> %c to <8 x i16>
  %f = mul <8 x i16> %d, %e
  %g = add <8 x i16> %f, %z
  ret <8 x i16> %g
}

define <4 x i32> @vwmaccu_vx_v4i32(<4 x i16>* %x, i16 %y, <4 x i32> %z) {
; CHECK-LABEL: vwmaccu_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v9
; CHECK-NEXT:    ret
  %a = load <4 x i16>, <4 x i16>* %x
  %b = insertelement <4 x i16> poison, i16 %y, i32 0
  %c = shufflevector <4 x i16> %b, <4 x i16> poison, <4 x i32> zeroinitializer
  %d = zext <4 x i16> %a to <4 x i32>
  %e = zext <4 x i16> %c to <4 x i32>
  %f = mul <4 x i32> %d, %e
  %g = add <4 x i32> %f, %z
  ret <4 x i32> %g
}

define <2 x i64> @vwmaccu_vx_v2i64(<2 x i32>* %x, i32 %y, <2 x i64> %z) {
; CHECK-LABEL: vwmaccu_vx_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; CHECK-NEXT:    vle32.v v9, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v9
; CHECK-NEXT:    ret
  %a = load <2 x i32>, <2 x i32>* %x
  %b = insertelement <2 x i32> poison, i32 %y, i64 0
  %c = shufflevector <2 x i32> %b, <2 x i32> poison, <2 x i32> zeroinitializer
  %d = zext <2 x i32> %a to <2 x i64>
  %e = zext <2 x i32> %c to <2 x i64>
  %f = mul <2 x i64> %d, %e
  %g = add <2 x i64> %f, %z
  ret <2 x i64> %g
}

define <16 x i16> @vwmaccu_vx_v16i16(<16 x i8>* %x, i8 %y, <16 x i16> %z) {
; CHECK-LABEL: vwmaccu_vx_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; CHECK-NEXT:    vle8.v v10, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v10
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> poison, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> poison, <16 x i32> zeroinitializer
  %d = zext <16 x i8> %a to <16 x i16>
  %e = zext <16 x i8> %c to <16 x i16>
  %f = mul <16 x i16> %d, %e
  %g = add <16 x i16> %f, %z
  ret <16 x i16> %g
}

define <8 x i32> @vwmaccu_vx_v8i32(<8 x i16>* %x, i16 %y, <8 x i32> %z) {
; CHECK-LABEL: vwmaccu_vx_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v10
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> poison, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> poison, <8 x i32> zeroinitializer
  %d = zext <8 x i16> %a to <8 x i32>
  %e = zext <8 x i16> %c to <8 x i32>
  %f = mul <8 x i32> %d, %e
  %g = add <8 x i32> %f, %z
  ret <8 x i32> %g
}

define <4 x i64> @vwmaccu_vx_v4i64(<4 x i32>* %x, i32 %y, <4 x i64> %z) {
; CHECK-LABEL: vwmaccu_vx_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; CHECK-NEXT:    vle32.v v10, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v10
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> poison, i32 %y, i64 0
  %c = shufflevector <4 x i32> %b, <4 x i32> poison, <4 x i32> zeroinitializer
  %d = zext <4 x i32> %a to <4 x i64>
  %e = zext <4 x i32> %c to <4 x i64>
  %f = mul <4 x i64> %d, %e
  %g = add <4 x i64> %f, %z
  ret <4 x i64> %g
}

define <32 x i16> @vwmaccu_vx_v32i16(<32 x i8>* %x, i8 %y, <32 x i16> %z) {
; CHECK-LABEL: vwmaccu_vx_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e8, m2, ta, mu
; CHECK-NEXT:    vle8.v v12, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v12
; CHECK-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = insertelement <32 x i8> poison, i8 %y, i32 0
  %c = shufflevector <32 x i8> %b, <32 x i8> poison, <32 x i32> zeroinitializer
  %d = zext <32 x i8> %a to <32 x i16>
  %e = zext <32 x i8> %c to <32 x i16>
  %f = mul <32 x i16> %d, %e
  %g = add <32 x i16> %f, %z
  ret <32 x i16> %g
}

define <16 x i32> @vwmaccu_vx_v16i32(<16 x i16>* %x, i16 %y, <16 x i32> %z) {
; CHECK-LABEL: vwmaccu_vx_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; CHECK-NEXT:    vle16.v v12, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v12
; CHECK-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = insertelement <16 x i16> poison, i16 %y, i32 0
  %c = shufflevector <16 x i16> %b, <16 x i16> poison, <16 x i32> zeroinitializer
  %d = zext <16 x i16> %a to <16 x i32>
  %e = zext <16 x i16> %c to <16 x i32>
  %f = mul <16 x i32> %d, %e
  %g = add <16 x i32> %f, %z
  ret <16 x i32> %g
}

define <8 x i64> @vwmaccu_vx_v8i64(<8 x i32>* %x, i32 %y, <8 x i64> %z) {
; CHECK-LABEL: vwmaccu_vx_v8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; CHECK-NEXT:    vle32.v v12, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v12
; CHECK-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = insertelement <8 x i32> poison, i32 %y, i64 0
  %c = shufflevector <8 x i32> %b, <8 x i32> poison, <8 x i32> zeroinitializer
  %d = zext <8 x i32> %a to <8 x i64>
  %e = zext <8 x i32> %c to <8 x i64>
  %f = mul <8 x i64> %d, %e
  %g = add <8 x i64> %f, %z
  ret <8 x i64> %g
}

define <64 x i16> @vwmaccu_vx_v64i16(<64 x i8>* %x, i8 %y, <64 x i16> %z) {
; CHECK-LABEL: vwmaccu_vx_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e8, m4, ta, mu
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v16
; CHECK-NEXT:    ret
  %a = load <64 x i8>, <64 x i8>* %x
  %b = insertelement <64 x i8> poison, i8 %y, i32 0
  %c = shufflevector <64 x i8> %b, <64 x i8> poison, <64 x i32> zeroinitializer
  %d = zext <64 x i8> %a to <64 x i16>
  %e = zext <64 x i8> %c to <64 x i16>
  %f = mul <64 x i16> %d, %e
  %g = add <64 x i16> %f, %z
  ret <64 x i16> %g
}

define <32 x i32> @vwmaccu_vx_v32i32(<32 x i16>* %x, i16 %y, <32 x i32> %z) {
; CHECK-LABEL: vwmaccu_vx_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v16
; CHECK-NEXT:    ret
  %a = load <32 x i16>, <32 x i16>* %x
  %b = insertelement <32 x i16> poison, i16 %y, i32 0
  %c = shufflevector <32 x i16> %b, <32 x i16> poison, <32 x i32> zeroinitializer
  %d = zext <32 x i16> %a to <32 x i32>
  %e = zext <32 x i16> %c to <32 x i32>
  %f = mul <32 x i32> %d, %e
  %g = add <32 x i32> %f, %z
  ret <32 x i32> %g
}

define <16 x i64> @vwmaccu_vx_v16i64(<16 x i32>* %x, i32 %y, <16 x i64> %z) {
; CHECK-LABEL: vwmaccu_vx_v16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vwmaccu.vx v8, a1, v16
; CHECK-NEXT:    ret
  %a = load <16 x i32>, <16 x i32>* %x
  %b = insertelement <16 x i32> poison, i32 %y, i64 0
  %c = shufflevector <16 x i32> %b, <16 x i32> poison, <16 x i32> zeroinitializer
  %d = zext <16 x i32> %a to <16 x i64>
  %e = zext <16 x i32> %c to <16 x i64>
  %f = mul <16 x i64> %d, %e
  %g = add <16 x i64> %f, %z
  ret <16 x i64> %g
}
