/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#ifndef HEADER_TABDIALOG
#define HEADER_TABDIALOG

#include <QDialog>
#include <QLineEdit>
#include <QGridLayout>
#include <QPushButton>
#include <QCloseEvent>
#include <QLabel>
#include <QMessageBox>
#include <QCompleter>
#include <QStandardItemModel>
#include <QStandardItem>
#include <QHostInfo>
#include <QDesktopWidget>
#include <QList>
#include <QHostAddress>
#include <QIntValidator>
#include <QNetworkInterface>
#include "../../commons/constants.h"
#include "../core/bean/remote_computer_info.h"

class TabDialog : public QDialog
{
    Q_OBJECT

public:
    TabDialog(QList<RemoteComputerInfo*> clientsList);
    QLineEdit *ipAddress;
    QLineEdit *port;
    QLineEdit *portFile;
    QLineEdit *password;
    void centerOnScreen();

public slots:
    void hideDialogBox();

signals:
    void add_tab_signal(QString ip, QString port, QString portFile, QString password);
protected:
    void closeEvent(QCloseEvent *event);
    QList<RemoteComputerInfo*> remote_info_list;
};

#endif
