/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.util.bean.EvaluationException;
import net.sourceforge.stripes.util.bean.NoSuchPropertyException;
import net.sourceforge.stripes.util.bean.Node;
import net.sourceforge.stripes.util.bean.NodeEvaluation;
import net.sourceforge.stripes.util.bean.NodeType;
import net.sourceforge.stripes.util.bean.PropertyAccessor;
import net.sourceforge.stripes.util.bean.PropertyExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyExpressionEvaluation {
    private PropertyExpression expression;
    private Object bean;
    private NodeEvaluation root;
    private NodeEvaluation leaf;

    public PropertyExpressionEvaluation(PropertyExpression expression, Object bean) {
        this.expression = expression;
        this.bean = bean;
        for (Node node = expression.getRootNode(); node != null; node = node.getNext()) {
            NodeEvaluation evaluation = new NodeEvaluation(this, node);
            if (this.root == null) {
                this.root = evaluation;
                this.leaf = evaluation;
                continue;
            }
            this.leaf.setNext(evaluation);
            evaluation.setPrevious(this.leaf);
            this.leaf = evaluation;
        }
        this.fillInTypeInformation();
    }

    public Object getBean() {
        return this.bean;
    }

    public NodeEvaluation getRootNode() {
        return this.root;
    }

    public PropertyExpression getExpression() {
        return this.expression;
    }

    void fillInTypeInformation() {
        Type type = this.bean.getClass();
        for (NodeEvaluation current = this.root; current != null; current = current.getNext()) {
            String property;
            Class clazz;
            while (type instanceof WildcardType || type instanceof TypeVariable) {
                if (type instanceof WildcardType) {
                    type = this.getWildcardTypeBound((WildcardType)type);
                    continue;
                }
                type = this.getTypeVariableValue(current, (TypeVariable)type);
            }
            if (type instanceof GenericArrayType) {
                type = ((GenericArrayType)type).getGenericComponentType();
                current.setValueType(type);
                current.setKeyType(Integer.class);
                current.setType(NodeType.ArrayEntry);
                continue;
            }
            if (type instanceof Class && ((Class)type).isArray()) {
                type = ((Class)type).getComponentType();
                current.setValueType(type);
                current.setKeyType(Integer.class);
                current.setType(NodeType.ArrayEntry);
                continue;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                Class<?> rawType = this.convertToClass(type, current);
                if (!(rawType instanceof Class)) break;
                Class<?> rawClass = rawType;
                if (List.class.isAssignableFrom(rawClass)) {
                    type = ptype.getActualTypeArguments()[0];
                    current.setValueType(type);
                    current.setKeyType(Integer.class);
                    current.setType(NodeType.ListEntry);
                    continue;
                }
                if (Map.class.isAssignableFrom(rawClass)) {
                    type = ptype.getActualTypeArguments()[1];
                    current.setValueType(type);
                    current.setKeyType(this.convertToClass(ptype.getActualTypeArguments()[0], current));
                    current.setType(NodeType.MapEntry);
                    continue;
                }
                type = rawClass;
            }
            if (type instanceof Class && (type = this.getBeanPropertyType(clazz = (Class)type, property = current.getNode().getStringValue())) != null) {
                current.setValueType(type);
                current.setType(NodeType.BeanProperty);
            }
            if (type == null && (type = this.getTypeViaInstances(current)) != null) continue;
        }
    }

    protected Type getBeanPropertyType(Class<?> beanClass, String property) {
        PropertyDescriptor pd = ReflectUtil.getPropertyDescriptor(beanClass, property);
        if (pd != null) {
            if (pd.getReadMethod() != null) {
                return this.untangleBridgeMethod(pd.getReadMethod()).getGenericReturnType();
            }
            return this.untangleBridgeMethod(pd.getWriteMethod()).getGenericParameterTypes()[0];
        }
        Field field = ReflectUtil.getField(beanClass, property);
        if (field == null) {
            return null;
        }
        return field.getGenericType();
    }

    protected Method untangleBridgeMethod(Method m) {
        block5: {
            if (!m.isBridge()) {
                return m;
            }
            try {
                if (m.getParameterTypes().length == 1) {
                    String name = m.getName();
                    for (Method m2 : m.getDeclaringClass().getMethods()) {
                        if (!name.equals(m2.getName()) || m2 == m || m2.getParameterTypes().length != m.getParameterTypes().length) continue;
                        return m2;
                    }
                    break block5;
                }
                return m.getDeclaringClass().getMethod(m.getName(), new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m;
    }

    protected Type getTypeViaInstances(NodeEvaluation end) throws EvaluationException, NoSuchPropertyException {
        Object previous;
        Object value = this.bean;
        for (NodeEvaluation node = this.root; node != end; node = node.getNext()) {
            PropertyAccessor accessor = node.getType().getPropertyAccessor();
            value = accessor.getValue(node, previous = value);
            if (value != null) continue;
            value = this.getDefaultValue(node);
        }
        previous = value;
        if (value instanceof Map) {
            if ((value = ((Map)value).get(end.getNode().getTypedValue())) != null) {
                end.setType(NodeType.MapEntry);
                end.setValueType(value.getClass());
                end.setKeyType(end.getNode().getTypedValue().getClass());
                return value.getClass();
            }
            throw new EvaluationException("Not enough type information available to evaluate expression. Expression: '" + this.expression + "'. Type information ran " + "out at node '" + end.getNode().getStringValue() + "', which represents a Map " + "entry. Please ensure that either the getter for the Map contains appropriate " + "generic type information or that it contains a value with the key type " + end.getNode().getTypedValue().getClass().getName() + " and value " + end.getNode().getStringValue());
        }
        if (value instanceof List) {
            Integer index;
            List list = (List)value;
            if (end.getNode().getTypedValue() instanceof Integer && (index = (Integer)end.getNode().getTypedValue()) < list.size() && (value = list.get(index)) != null) {
                end.setType(NodeType.ListEntry);
                end.setValueType(value.getClass());
                end.setKeyType(Integer.class);
                return value.getClass();
            }
            throw new EvaluationException("Not enough type information available to evaluate expression. Expression: '" + this.expression + "'. Type information ran " + "out at node '" + end.getNode().getStringValue() + "', which represents a List " + "entry. Please ensure that either the getter for the List contains appropriate " + "generic type information or that the index is numeric and a value exists at " + "the supplied index (" + end.getNode().getStringValue() + ").");
        }
        Type type = this.getBeanPropertyType(value.getClass(), end.getNode().getStringValue());
        if (type != null) {
            end.setType(NodeType.BeanProperty);
            end.setValueType(type);
            return type;
        }
        throw new NoSuchPropertyException("Bean class " + previous.getClass().getName() + " does not contain a property called '" + end.getNode().getStringValue() + "'. As a result the following expression could not be evaluated: " + this.expression);
    }

    protected Class<?> convertToClass(Type type, NodeEvaluation evaluation) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        while (type instanceof WildcardType || type instanceof TypeVariable) {
            if (type instanceof WildcardType) {
                type = this.getWildcardTypeBound((WildcardType)type);
                continue;
            }
            if (!(type instanceof TypeVariable)) continue;
            type = this.getTypeVariableValue(evaluation, (TypeVariable)type);
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    protected Type getTypeVariableValue(NodeEvaluation evaluation, TypeVariable<?> typeVar) {
        Type type;
        ArrayList typemap1 = new ArrayList();
        ArrayList typemap2 = new ArrayList();
        Class lastBean = this.bean.getClass();
        for (NodeEvaluation n = evaluation.getPrevious(); n != null; n = n.getPrevious()) {
            type = n.getValueType();
            if (type instanceof Class) {
                lastBean = (Class)n.getValueType();
                break;
            }
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType ptype = (ParameterizedType)type;
            while (ptype != null) {
                this.addTypeMappings(typemap1, ptype);
                Type rawtype = ptype.getRawType();
                if (!(rawtype instanceof Class)) continue;
                Class superclass = (Class)rawtype;
                Type supertype = superclass.getGenericSuperclass();
                ptype = supertype instanceof ParameterizedType ? (ParameterizedType)supertype : null;
            }
        }
        for (Class c = lastBean; c != null; c = c.getSuperclass()) {
            Type t = c.getGenericSuperclass();
            if (!(t instanceof ParameterizedType)) continue;
            this.addTypeMappings(typemap2, (ParameterizedType)t);
        }
        Class declaration = (Class)typeVar.getGenericDeclaration();
        type = null;
        if (!declaration.isAssignableFrom(lastBean)) {
            for (int i = typemap1.size() - 1; i >= 0; --i) {
                type = (Type)((HashMap)typemap1.get(i)).get(typeVar);
                if (type == null) continue;
                if (type instanceof Class) {
                    return type;
                }
                if (!(type instanceof TypeVariable)) continue;
                typeVar = (TypeVariable)type;
            }
        }
        for (int i = typemap2.size() - 1; i >= 0; --i) {
            type = (Type)((HashMap)typemap2.get(i)).get(typeVar);
            if (type == null) continue;
            if (type instanceof Class) {
                return type;
            }
            if (!(type instanceof TypeVariable)) continue;
            typeVar = (TypeVariable)type;
        }
        return type;
    }

    private void addTypeMappings(List<HashMap<TypeVariable<?>, Type>> typemap, ParameterizedType paramType) {
        Type rawType = paramType.getRawType();
        if (rawType instanceof Class) {
            Class rawClass = (Class)rawType;
            TypeVariable<Class<T>>[] vars = rawClass.getTypeParameters();
            Type[] args = paramType.getActualTypeArguments();
            HashMap entry = new HashMap(vars.length);
            for (int i = 0; i < vars.length && i < args.length; ++i) {
                entry.put(vars[i], args[i]);
            }
            typemap.add(entry);
        }
    }

    protected Type getWildcardTypeBound(WildcardType wtype) {
        Type[] bounds = wtype.getLowerBounds();
        if (bounds.length == 0) {
            bounds = wtype.getUpperBounds();
        }
        if (bounds.length > 0) {
            return bounds[0];
        }
        return null;
    }

    public Class<?> getType() {
        return this.convertToClass(this.leaf.getValueType(), this.leaf);
    }

    public Class<?> getScalarType() {
        Type type = this.leaf.getValueType();
        Class<?> clazz = this.convertToClass(type, this.leaf);
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (type instanceof ParameterizedType) {
                return this.convertToClass(((ParameterizedType)type).getActualTypeArguments()[0], this.leaf);
            }
            return String.class;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (type instanceof ParameterizedType) {
                return this.convertToClass(((ParameterizedType)type).getActualTypeArguments()[1], this.leaf);
            }
            return String.class;
        }
        return clazz;
    }

    public Object getValue() {
        Object nodeValue = this.bean;
        for (NodeEvaluation node = this.root; node != null && nodeValue != null; node = node.getNext()) {
            nodeValue = node.getType().getPropertyAccessor().getValue(node, nodeValue);
        }
        return nodeValue;
    }

    public void setValue(Object propertyValue) throws EvaluationException {
        Object nodeValue = this.bean;
        for (NodeEvaluation node = this.root; node != this.leaf && nodeValue != null; node = node.getNext()) {
            Object previous;
            PropertyAccessor accessor = node.getType().getPropertyAccessor();
            nodeValue = accessor.getValue(node, previous = nodeValue);
            if (nodeValue != null) continue;
            nodeValue = this.getDefaultValue(node);
            node.getType().getPropertyAccessor().setValue(node, previous, nodeValue);
        }
        this.leaf.getType().getPropertyAccessor().setValue(this.leaf, nodeValue, propertyValue);
    }

    private Object getDefaultValue(NodeEvaluation node) throws EvaluationException {
        try {
            Class<?> clazz = this.convertToClass(node.getValueType(), node);
            if (clazz.isArray()) {
                return Array.newInstance(clazz.getComponentType(), 0);
            }
            if (clazz.isEnum()) {
                return clazz.getEnumConstants()[0];
            }
            if (clazz.isInterface()) {
                return ReflectUtil.getInterfaceInstance(clazz);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new EvaluationException("Encountered an exception while trying to create  a default instance for property '" + node.getNode().getStringValue() + "' in " + "expression '" + this.expression.getSource() + "'.", e);
        }
    }

    public void setToNull() throws EvaluationException {
        Object nodeValue = this.bean;
        for (NodeEvaluation node = this.root; node != this.leaf && nodeValue != null; node = node.getNext()) {
            nodeValue = node.getType().getPropertyAccessor().getValue(node, nodeValue);
        }
        if (nodeValue != null) {
            Class<?> leafType = this.convertToClass(this.leaf.getValueType(), this.leaf);
            if (Map.class.isAssignableFrom(leafType) || Collection.class.isAssignableFrom(leafType)) {
                nodeValue = this.leaf.getType().getPropertyAccessor().getValue(this.leaf, nodeValue);
                if (nodeValue != null && Map.class.isAssignableFrom(leafType)) {
                    ((Map)nodeValue).clear();
                } else if (nodeValue != null && Collection.class.isAssignableFrom(leafType)) {
                    ((Collection)nodeValue).clear();
                }
            } else {
                try {
                    Object nvl = ReflectUtil.getDefaultValue(leafType);
                    this.leaf.getType().getPropertyAccessor().setValue(this.leaf, nodeValue, nvl);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new EvaluationException("Could not set a null value for property '" + this.expression + "' on bean of type " + this.bean.getClass().getName(), e);
                }
            }
        }
    }
}

