/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.ui;

import jonelo.jacksum.util.Service;

public class Summary {
    private long files = 0L;
    private long errorFiles = 0L;
    private long modifiedFiles = 0L;
    private long removedFiles = 0L;
    private long addedFiles = 0L;
    private long dirs = 0L;
    private long begin = 0L;
    private long errorDirs = 0L;
    private long bytes = 0L;
    private boolean check = false;
    private boolean enabled = false;

    public void reset() {
        this.files = 0L;
        this.errorFiles = 0L;
        this.modifiedFiles = 0L;
        this.removedFiles = 0L;
        this.addedFiles = 0L;
        this.dirs = 0L;
        this.begin = 0L;
        this.errorDirs = 0L;
        this.bytes = 0L;
        this.check = false;
        this.enabled = false;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.begin = System.currentTimeMillis();
    }

    public void setFiles(long l) {
        this.files = l;
    }

    public void addFile() {
        ++this.files;
    }

    public long getFiles() {
        return this.files;
    }

    public void setErrorFiles(long l) {
        this.errorFiles = l;
    }

    public void addErrorFile() {
        ++this.errorFiles;
    }

    public long getErrorFiles() {
        return this.errorFiles;
    }

    public void setModifiedFiles(long l) {
        this.modifiedFiles = l;
    }

    public long getModifiedFiles() {
        return this.modifiedFiles;
    }

    public void setRemovedFiles(long l) {
        this.removedFiles = l;
    }

    public long getRemovedFiles() {
        return this.removedFiles;
    }

    public void setAddedFiles(long l) {
        this.addedFiles = l;
    }

    public long getAddedFiles() {
        return this.addedFiles;
    }

    public void setBytes(long l) {
        this.bytes = l;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void addBytes(long l) {
        this.bytes += l;
    }

    public void setDirs(long l) {
        this.dirs = l;
    }

    public void addDir() {
        ++this.dirs;
    }

    public long getDirs() {
        return this.dirs;
    }

    public void setErrorDirs(long l) {
        this.errorDirs = l;
    }

    public void addErrorDir() {
        ++this.errorDirs;
    }

    public long getErrorDirs() {
        return this.errorDirs;
    }

    public void setCheck(boolean bl) {
        this.check = bl;
    }

    public boolean isCheck() {
        return this.check;
    }

    public void print() {
        if (!this.enabled) {
            return;
        }
        long l = System.currentTimeMillis();
        System.err.println();
        if (!this.isCheck()) {
            System.err.println("Jacksum: processed directories: " + this.dirs);
            System.err.println("Jacksum: directory read errors: " + this.errorDirs);
        }
        System.err.println("Jacksum: processed files: " + this.files);
        System.err.println("Jacksum: processed bytes: " + this.bytes);
        System.err.println("Jacksum: file read errors: " + this.errorFiles);
        if (this.isCheck()) {
            System.err.println("Jacksum: removed files:  " + this.removedFiles);
            System.err.println("Jacksum: modified files: " + this.modifiedFiles);
            System.err.println("Jacksum: added files:  " + this.addedFiles);
        }
        System.err.println("Jacksum: elapsed time: " + Service.duration(l - this.begin));
    }
}

