#!perl
# vim:ts=4:sw=4:expandtab
#
# Please read the following documents before working on tests:
# • https://build.i3wm.org/docs/testsuite.html
#   (or docs/testsuite)
#
# • https://build.i3wm.org/docs/lib-i3test.html
#   (alternatively: perldoc ./testcases/lib/i3test.pm)
#
# • https://build.i3wm.org/docs/ipc.html
#   (or docs/ipc)
#
# • http://onyxneon.com/books/modern_perl/modern_perl_a4.pdf
#   (unless you are already familiar with Perl)
#
# Regression test to check if mark and restart commands crash i3
#
use i3test;

cmd 'open';
cmd 'mark foo';
cmd 'open';
cmd 'mark bar';

cmd 'restart';

diag('Checking if i3 still lives');

does_i3_live;

done_testing;
