#!/usr/bin/env runhaskell
> import Distribution.Simple
> import System.Cmd (system)
> import System.Exit (ExitCode(..))
> import Distribution.PackageDescription (emptyHookedBuildInfo)
>
> main = defaultMainWithHooks simpleUserHooks
>   { runTests = runUnitTests
>   }
>
>
> runUnitTests _ _ _ _ =
>   system "runhaskell -lzip -fno-warn-warnings-deprecations runTests.hs" >>=
>   onExit "\nSome tests did not pass." ()
>
> onExit :: String -> a -> ExitCode -> IO a
> onExit errmsg okvalue r =
>   case r of
>     ExitSuccess -> return okvalue
>     _           -> fail errmsg
