//
// File: PanelSaisieSlider.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Sun Oct 15 19:31:56 2006
//

#include "PanelSaisieSlider.h"

PanelSaisieSlider::PanelSaisieSlider(wxWindow *parent,int id,wxString label,float minslider,float maxslider, float valeurslider, int nombredecimales):wxPanel(parent, id)

{
    nombre_decimales=nombredecimales;
    valeur= (int)(pow(10,nombre_decimales)*valeurslider);
    min= (int)(pow(10,nombre_decimales)*minslider);
    max=(int)(pow(10,nombre_decimales)*maxslider);
    sizer= new wxBoxSizer(wxHORIZONTAL);
	
    label_valeur= new wxStaticText(this, -1, label);
    slider_valeur= new wxSlider(this, -1, valeur,min,max);
    text_ctrl= new wxTextCtrl(this, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_READONLY);
    spin_button_reglage_fin= new wxSpinButton(this, -1, wxDefaultPosition, wxDefaultSize,
        wxSP_VERTICAL| wxSP_ARROW_KEYS|wxSP_WRAP);

    AfficheValeurSlider();
 	
    sizer->Add(label_valeur, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer->Add(slider_valeur, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer->Add(text_ctrl, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer->Add(spin_button_reglage_fin, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
	
    SetSizer(sizer);
    
	// on connecte les événements
    Connect(slider_valeur->GetId( ), wxEVT_SCROLL_THUMBTRACK,(wxObjectEventFunction) &PanelSaisieSlider::AfficheValeurSlider);
    Connect(spin_button_reglage_fin->GetId( ), wxEVT_SCROLL_LINEUP,(wxObjectEventFunction) &PanelSaisieSlider::OnSpinButtonUpReglageFin);
    Connect(spin_button_reglage_fin->GetId( ), wxEVT_SCROLL_LINEDOWN,(wxObjectEventFunction) &PanelSaisieSlider::OnSpinButtonDownReglageFin);
}

PanelSaisieSlider::~PanelSaisieSlider()
{
	// TODO: put destructor code here
}

void PanelSaisieSlider::AfficheValeurSlider()
{
	double valeur=((double)(slider_valeur->GetValue()))/pow(10,nombre_decimales);
	wxString stemp(wxT(""));stemp<<valeur;
    
	// on recherche la taille du text_ctrl pour contenir la valeur
	int x,y;
	wxTextCtrl* temp = new wxTextCtrl(this, -1, wxT(""));
	temp->GetTextExtent(stemp+wxT("  "), &x, &y);
	delete temp;

	// on affiche la valeur correspondant à la position du slider
	text_ctrl->SetMinSize(wxSize(x+2, y+5));
	text_ctrl->SetValue(stemp);
    Layout();// on retrace le panel pour mettre à jour la taille du textctrl
}

void  PanelSaisieSlider::OnSpinButtonUpReglageFin(wxCommandEvent& event)
{
    if (slider_valeur->GetValue()!=max) 
    {
        slider_valeur->SetValue(slider_valeur->GetValue()+1);
        AfficheValeurSlider();
    }   
}    

void  PanelSaisieSlider::OnSpinButtonDownReglageFin(wxCommandEvent& event)
{
    if (slider_valeur->GetValue()!=min) 
    {
        slider_valeur->SetValue(slider_valeur->GetValue()-1);
        AfficheValeurSlider();
    }   
}    

int PanelSaisieSlider::GetValeurEntiere()
{
	return ((int)(slider_valeur->GetValue()/pow(10,nombre_decimales)));
}

double PanelSaisieSlider::GetValeurReelle()
{
    return 	((double)(slider_valeur->GetValue()/pow(10,nombre_decimales)));
}
