﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Source files represent a source generated JsonSerializerContext as produced by the .NET 8 SDK.
// Used to validate correctness of contexts generated by previous SDKs against the current System.Text.Json runtime components.
// Unless absolutely necessary DO NOT MODIFY any of these files -- it would invalidate the purpose of the regression tests.

// <auto-generated/>

#nullable enable annotations
#nullable disable warnings

// Suppress warnings about [Obsolete] member usage in generated code.
#pragma warning disable CS0612, CS0618

namespace System.Text.Json.Tests.SourceGenRegressionTests.Net80
{
    public partial class Net80GeneratedContext
    {
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>>? _DictionaryStringHighLowTemps;
        
        /// <summary>
        /// Defines the source generated JSON serialization contract metadata for a given type.
        /// </summary>
        public global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>> DictionaryStringHighLowTemps
        {
            get => _DictionaryStringHighLowTemps ??= (global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>>)Options.GetTypeInfo(typeof(global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>));
        }
        
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>> Create_DictionaryStringHighLowTemps(global::System.Text.Json.JsonSerializerOptions options)
        {
            if (!TryGetTypeInfoForRuntimeCustomConverter<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>>(options, out global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>> jsonTypeInfo))
            {
                var info = new global::System.Text.Json.Serialization.Metadata.JsonCollectionInfoValues<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>>
                {
                    ObjectCreator = () => new global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>(),
                    SerializeHandler = DictionaryStringHighLowTempsSerializeHandler
                };
                
                jsonTypeInfo = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateDictionaryInfo<global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>, string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>(options, info);
                jsonTypeInfo.NumberHandling = null;
            }
        
            jsonTypeInfo.OriginatingResolver = this;
            return jsonTypeInfo;
        }

        // Intentionally not a static method because we create a delegate to it. Invoking delegates to instance
        // methods is almost as fast as virtual calls. Static methods need to go through a shuffle thunk.
        private void DictionaryStringHighLowTempsSerializeHandler(global::System.Text.Json.Utf8JsonWriter writer, global::System.Collections.Generic.Dictionary<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps>? value)
        {
            if (value == null)
            {
                writer.WriteNullValue();
                return;
            }
            
            writer.WriteStartObject();

            foreach (global::System.Collections.Generic.KeyValuePair<string, global::System.Text.Json.Tests.SourceGenRegressionTests.Net80.HighLowTemps> entry in value)
            {
                writer.WritePropertyName(entry.Key);
                HighLowTempsSerializeHandler(writer, entry.Value);
            }

            writer.WriteEndObject();
        }
    }
}
