// Generated by `wit-bindgen` 0.29.0. DO NOT EDIT!
// <auto-generated />
#nullable enable

using System;
using System.Runtime.CompilerServices;
using System.Collections;
using System.Runtime.InteropServices;
using System.Text;
using System.Collections.Generic;
using System.Diagnostics;
using System.Diagnostics.CodeAnalysis;

namespace WasiHttpWorld.wit.imports.wasi.http.v0_2_1;

internal interface ITypes {

    /**
    * This type corresponds to HTTP standard Methods.
    */

    internal class Method {
        internal readonly byte Tag;
        private readonly object? value;

        private Method(byte tag, object? value) {
            this.Tag = tag;
            this.value = value;
        }

        internal static Method get() {
            return new Method(GET, null);
        }

        internal static Method head() {
            return new Method(HEAD, null);
        }

        internal static Method post() {
            return new Method(POST, null);
        }

        internal static Method put() {
            return new Method(PUT, null);
        }

        internal static Method delete() {
            return new Method(DELETE, null);
        }

        internal static Method connect() {
            return new Method(CONNECT, null);
        }

        internal static Method options() {
            return new Method(OPTIONS, null);
        }

        internal static Method trace() {
            return new Method(TRACE, null);
        }

        internal static Method patch() {
            return new Method(PATCH, null);
        }

        internal static Method other(string other) {
            return new Method(OTHER, other);
        }

        internal string AsOther
        {
            get
            {
                if (Tag == OTHER)
                return (string)value!;
                else
                throw new ArgumentException("expected OTHER, got " + Tag);
            }
        }

        internal const byte GET = 0;
        internal const byte HEAD = 1;
        internal const byte POST = 2;
        internal const byte PUT = 3;
        internal const byte DELETE = 4;
        internal const byte CONNECT = 5;
        internal const byte OPTIONS = 6;
        internal const byte TRACE = 7;
        internal const byte PATCH = 8;
        internal const byte OTHER = 9;
    }

    /**
    * This type corresponds to HTTP standard Related Schemes.
    */

    internal class Scheme {
        internal readonly byte Tag;
        private readonly object? value;

        private Scheme(byte tag, object? value) {
            this.Tag = tag;
            this.value = value;
        }

        internal static Scheme http() {
            return new Scheme(HTTP, null);
        }

        internal static Scheme https() {
            return new Scheme(HTTPS, null);
        }

        internal static Scheme other(string other) {
            return new Scheme(OTHER, other);
        }

        internal string AsOther
        {
            get
            {
                if (Tag == OTHER)
                return (string)value!;
                else
                throw new ArgumentException("expected OTHER, got " + Tag);
            }
        }

        internal const byte HTTP = 0;
        internal const byte HTTPS = 1;
        internal const byte OTHER = 2;
    }

    /**
    * Defines the case payload type for `DNS-error` above:
    */

    internal class DnsErrorPayload {
        internal readonly string? rcode;
        internal readonly ushort? infoCode;

        internal DnsErrorPayload(string? rcode, ushort? infoCode) {
            this.rcode = rcode;
            this.infoCode = infoCode;
        }
    }

    /**
    * Defines the case payload type for `TLS-alert-received` above:
    */

    internal class TlsAlertReceivedPayload {
        internal readonly byte? alertId;
        internal readonly string? alertMessage;

        internal TlsAlertReceivedPayload(byte? alertId, string? alertMessage) {
            this.alertId = alertId;
            this.alertMessage = alertMessage;
        }
    }

    /**
    * Defines the case payload type for `HTTP-response-{header,trailer}-size` above:
    */

    internal class FieldSizePayload {
        internal readonly string? fieldName;
        internal readonly uint? fieldSize;

        internal FieldSizePayload(string? fieldName, uint? fieldSize) {
            this.fieldName = fieldName;
            this.fieldSize = fieldSize;
        }
    }

    /**
    * These cases are inspired by the IANA HTTP Proxy Error Types:
    * https://www.iana.org/assignments/http-proxy-status/http-proxy-status.xhtml#table-http-proxy-error-types
    */

    internal class ErrorCode {
        internal readonly byte Tag;
        private readonly object? value;

        private ErrorCode(byte tag, object? value) {
            this.Tag = tag;
            this.value = value;
        }

        internal static ErrorCode dnsTimeout() {
            return new ErrorCode(DNS_TIMEOUT, null);
        }

        internal static ErrorCode dnsError(DnsErrorPayload dnsError) {
            return new ErrorCode(DNS_ERROR, dnsError);
        }

        internal static ErrorCode destinationNotFound() {
            return new ErrorCode(DESTINATION_NOT_FOUND, null);
        }

        internal static ErrorCode destinationUnavailable() {
            return new ErrorCode(DESTINATION_UNAVAILABLE, null);
        }

        internal static ErrorCode destinationIpProhibited() {
            return new ErrorCode(DESTINATION_IP_PROHIBITED, null);
        }

        internal static ErrorCode destinationIpUnroutable() {
            return new ErrorCode(DESTINATION_IP_UNROUTABLE, null);
        }

        internal static ErrorCode connectionRefused() {
            return new ErrorCode(CONNECTION_REFUSED, null);
        }

        internal static ErrorCode connectionTerminated() {
            return new ErrorCode(CONNECTION_TERMINATED, null);
        }

        internal static ErrorCode connectionTimeout() {
            return new ErrorCode(CONNECTION_TIMEOUT, null);
        }

        internal static ErrorCode connectionReadTimeout() {
            return new ErrorCode(CONNECTION_READ_TIMEOUT, null);
        }

        internal static ErrorCode connectionWriteTimeout() {
            return new ErrorCode(CONNECTION_WRITE_TIMEOUT, null);
        }

        internal static ErrorCode connectionLimitReached() {
            return new ErrorCode(CONNECTION_LIMIT_REACHED, null);
        }

        internal static ErrorCode tlsProtocolError() {
            return new ErrorCode(TLS_PROTOCOL_ERROR, null);
        }

        internal static ErrorCode tlsCertificateError() {
            return new ErrorCode(TLS_CERTIFICATE_ERROR, null);
        }

        internal static ErrorCode tlsAlertReceived(TlsAlertReceivedPayload tlsAlertReceived) {
            return new ErrorCode(TLS_ALERT_RECEIVED, tlsAlertReceived);
        }

        internal static ErrorCode httpRequestDenied() {
            return new ErrorCode(HTTP_REQUEST_DENIED, null);
        }

        internal static ErrorCode httpRequestLengthRequired() {
            return new ErrorCode(HTTP_REQUEST_LENGTH_REQUIRED, null);
        }

        internal static ErrorCode httpRequestBodySize(ulong? httpRequestBodySize) {
            return new ErrorCode(HTTP_REQUEST_BODY_SIZE, httpRequestBodySize);
        }

        internal static ErrorCode httpRequestMethodInvalid() {
            return new ErrorCode(HTTP_REQUEST_METHOD_INVALID, null);
        }

        internal static ErrorCode httpRequestUriInvalid() {
            return new ErrorCode(HTTP_REQUEST_URI_INVALID, null);
        }

        internal static ErrorCode httpRequestUriTooLong() {
            return new ErrorCode(HTTP_REQUEST_URI_TOO_LONG, null);
        }

        internal static ErrorCode httpRequestHeaderSectionSize(uint? httpRequestHeaderSectionSize) {
            return new ErrorCode(HTTP_REQUEST_HEADER_SECTION_SIZE, httpRequestHeaderSectionSize);
        }

        internal static ErrorCode httpRequestHeaderSize(FieldSizePayload? httpRequestHeaderSize) {
            return new ErrorCode(HTTP_REQUEST_HEADER_SIZE, httpRequestHeaderSize);
        }

        internal static ErrorCode httpRequestTrailerSectionSize(uint? httpRequestTrailerSectionSize) {
            return new ErrorCode(HTTP_REQUEST_TRAILER_SECTION_SIZE, httpRequestTrailerSectionSize);
        }

        internal static ErrorCode httpRequestTrailerSize(FieldSizePayload httpRequestTrailerSize) {
            return new ErrorCode(HTTP_REQUEST_TRAILER_SIZE, httpRequestTrailerSize);
        }

        internal static ErrorCode httpResponseIncomplete() {
            return new ErrorCode(HTTP_RESPONSE_INCOMPLETE, null);
        }

        internal static ErrorCode httpResponseHeaderSectionSize(uint? httpResponseHeaderSectionSize) {
            return new ErrorCode(HTTP_RESPONSE_HEADER_SECTION_SIZE, httpResponseHeaderSectionSize);
        }

        internal static ErrorCode httpResponseHeaderSize(FieldSizePayload httpResponseHeaderSize) {
            return new ErrorCode(HTTP_RESPONSE_HEADER_SIZE, httpResponseHeaderSize);
        }

        internal static ErrorCode httpResponseBodySize(ulong? httpResponseBodySize) {
            return new ErrorCode(HTTP_RESPONSE_BODY_SIZE, httpResponseBodySize);
        }

        internal static ErrorCode httpResponseTrailerSectionSize(uint? httpResponseTrailerSectionSize) {
            return new ErrorCode(HTTP_RESPONSE_TRAILER_SECTION_SIZE, httpResponseTrailerSectionSize);
        }

        internal static ErrorCode httpResponseTrailerSize(FieldSizePayload httpResponseTrailerSize) {
            return new ErrorCode(HTTP_RESPONSE_TRAILER_SIZE, httpResponseTrailerSize);
        }

        internal static ErrorCode httpResponseTransferCoding(string? httpResponseTransferCoding) {
            return new ErrorCode(HTTP_RESPONSE_TRANSFER_CODING, httpResponseTransferCoding);
        }

        internal static ErrorCode httpResponseContentCoding(string? httpResponseContentCoding) {
            return new ErrorCode(HTTP_RESPONSE_CONTENT_CODING, httpResponseContentCoding);
        }

        internal static ErrorCode httpResponseTimeout() {
            return new ErrorCode(HTTP_RESPONSE_TIMEOUT, null);
        }

        internal static ErrorCode httpUpgradeFailed() {
            return new ErrorCode(HTTP_UPGRADE_FAILED, null);
        }

        internal static ErrorCode httpProtocolError() {
            return new ErrorCode(HTTP_PROTOCOL_ERROR, null);
        }

        internal static ErrorCode loopDetected() {
            return new ErrorCode(LOOP_DETECTED, null);
        }

        internal static ErrorCode configurationError() {
            return new ErrorCode(CONFIGURATION_ERROR, null);
        }

        internal static ErrorCode internalError(string? internalError) {
            return new ErrorCode(INTERNAL_ERROR, internalError);
        }

        internal DnsErrorPayload AsDnsError
        {
            get
            {
                if (Tag == DNS_ERROR)
                return (DnsErrorPayload)value!;
                else
                throw new ArgumentException("expected DNS_ERROR, got " + Tag);
            }
        }

        internal TlsAlertReceivedPayload AsTlsAlertReceived
        {
            get
            {
                if (Tag == TLS_ALERT_RECEIVED)
                return (TlsAlertReceivedPayload)value!;
                else
                throw new ArgumentException("expected TLS_ALERT_RECEIVED, got " + Tag);
            }
        }

        internal ulong? AsHttpRequestBodySize
        {
            get
            {
                if (Tag == HTTP_REQUEST_BODY_SIZE)
                return (ulong?)value!;
                else
                throw new ArgumentException("expected HTTP_REQUEST_BODY_SIZE, got " + Tag);
            }
        }

        internal uint? AsHttpRequestHeaderSectionSize
        {
            get
            {
                if (Tag == HTTP_REQUEST_HEADER_SECTION_SIZE)
                return (uint?)value!;
                else
                throw new ArgumentException("expected HTTP_REQUEST_HEADER_SECTION_SIZE, got " + Tag);
            }
        }

        internal FieldSizePayload? AsHttpRequestHeaderSize
        {
            get
            {
                if (Tag == HTTP_REQUEST_HEADER_SIZE)
                return (FieldSizePayload?)value!;
                else
                throw new ArgumentException("expected HTTP_REQUEST_HEADER_SIZE, got " + Tag);
            }
        }

        internal uint? AsHttpRequestTrailerSectionSize
        {
            get
            {
                if (Tag == HTTP_REQUEST_TRAILER_SECTION_SIZE)
                return (uint?)value!;
                else
                throw new ArgumentException("expected HTTP_REQUEST_TRAILER_SECTION_SIZE, got " + Tag);
            }
        }

        internal FieldSizePayload AsHttpRequestTrailerSize
        {
            get
            {
                if (Tag == HTTP_REQUEST_TRAILER_SIZE)
                return (FieldSizePayload)value!;
                else
                throw new ArgumentException("expected HTTP_REQUEST_TRAILER_SIZE, got " + Tag);
            }
        }

        internal uint? AsHttpResponseHeaderSectionSize
        {
            get
            {
                if (Tag == HTTP_RESPONSE_HEADER_SECTION_SIZE)
                return (uint?)value!;
                else
                throw new ArgumentException("expected HTTP_RESPONSE_HEADER_SECTION_SIZE, got " + Tag);
            }
        }

        internal FieldSizePayload AsHttpResponseHeaderSize
        {
            get
            {
                if (Tag == HTTP_RESPONSE_HEADER_SIZE)
                return (FieldSizePayload)value!;
                else
                throw new ArgumentException("expected HTTP_RESPONSE_HEADER_SIZE, got " + Tag);
            }
        }

        internal ulong? AsHttpResponseBodySize
        {
            get
            {
                if (Tag == HTTP_RESPONSE_BODY_SIZE)
                return (ulong?)value!;
                else
                throw new ArgumentException("expected HTTP_RESPONSE_BODY_SIZE, got " + Tag);
            }
        }

        internal uint? AsHttpResponseTrailerSectionSize
        {
            get
            {
                if (Tag == HTTP_RESPONSE_TRAILER_SECTION_SIZE)
                return (uint?)value!;
                else
                throw new ArgumentException("expected HTTP_RESPONSE_TRAILER_SECTION_SIZE, got " + Tag);
            }
        }

        internal FieldSizePayload AsHttpResponseTrailerSize
        {
            get
            {
                if (Tag == HTTP_RESPONSE_TRAILER_SIZE)
                return (FieldSizePayload)value!;
                else
                throw new ArgumentException("expected HTTP_RESPONSE_TRAILER_SIZE, got " + Tag);
            }
        }

        internal string? AsHttpResponseTransferCoding
        {
            get
            {
                if (Tag == HTTP_RESPONSE_TRANSFER_CODING)
                return (string?)value!;
                else
                throw new ArgumentException("expected HTTP_RESPONSE_TRANSFER_CODING, got " + Tag);
            }
        }

        internal string? AsHttpResponseContentCoding
        {
            get
            {
                if (Tag == HTTP_RESPONSE_CONTENT_CODING)
                return (string?)value!;
                else
                throw new ArgumentException("expected HTTP_RESPONSE_CONTENT_CODING, got " + Tag);
            }
        }

        internal string? AsInternalError
        {
            get
            {
                if (Tag == INTERNAL_ERROR)
                return (string?)value!;
                else
                throw new ArgumentException("expected INTERNAL_ERROR, got " + Tag);
            }
        }

        internal const byte DNS_TIMEOUT = 0;
        internal const byte DNS_ERROR = 1;
        internal const byte DESTINATION_NOT_FOUND = 2;
        internal const byte DESTINATION_UNAVAILABLE = 3;
        internal const byte DESTINATION_IP_PROHIBITED = 4;
        internal const byte DESTINATION_IP_UNROUTABLE = 5;
        internal const byte CONNECTION_REFUSED = 6;
        internal const byte CONNECTION_TERMINATED = 7;
        internal const byte CONNECTION_TIMEOUT = 8;
        internal const byte CONNECTION_READ_TIMEOUT = 9;
        internal const byte CONNECTION_WRITE_TIMEOUT = 10;
        internal const byte CONNECTION_LIMIT_REACHED = 11;
        internal const byte TLS_PROTOCOL_ERROR = 12;
        internal const byte TLS_CERTIFICATE_ERROR = 13;
        internal const byte TLS_ALERT_RECEIVED = 14;
        internal const byte HTTP_REQUEST_DENIED = 15;
        internal const byte HTTP_REQUEST_LENGTH_REQUIRED = 16;
        internal const byte HTTP_REQUEST_BODY_SIZE = 17;
        internal const byte HTTP_REQUEST_METHOD_INVALID = 18;
        internal const byte HTTP_REQUEST_URI_INVALID = 19;
        internal const byte HTTP_REQUEST_URI_TOO_LONG = 20;
        internal const byte HTTP_REQUEST_HEADER_SECTION_SIZE = 21;
        internal const byte HTTP_REQUEST_HEADER_SIZE = 22;
        internal const byte HTTP_REQUEST_TRAILER_SECTION_SIZE = 23;
        internal const byte HTTP_REQUEST_TRAILER_SIZE = 24;
        internal const byte HTTP_RESPONSE_INCOMPLETE = 25;
        internal const byte HTTP_RESPONSE_HEADER_SECTION_SIZE = 26;
        internal const byte HTTP_RESPONSE_HEADER_SIZE = 27;
        internal const byte HTTP_RESPONSE_BODY_SIZE = 28;
        internal const byte HTTP_RESPONSE_TRAILER_SECTION_SIZE = 29;
        internal const byte HTTP_RESPONSE_TRAILER_SIZE = 30;
        internal const byte HTTP_RESPONSE_TRANSFER_CODING = 31;
        internal const byte HTTP_RESPONSE_CONTENT_CODING = 32;
        internal const byte HTTP_RESPONSE_TIMEOUT = 33;
        internal const byte HTTP_UPGRADE_FAILED = 34;
        internal const byte HTTP_PROTOCOL_ERROR = 35;
        internal const byte LOOP_DETECTED = 36;
        internal const byte CONFIGURATION_ERROR = 37;
        internal const byte INTERNAL_ERROR = 38;
    }

    /**
    * This type enumerates the different kinds of errors that may occur when
    * setting or appending to a `fields` resource.
    */

    internal class HeaderError {
        internal readonly byte Tag;
        private readonly object? value;

        private HeaderError(byte tag, object? value) {
            this.Tag = tag;
            this.value = value;
        }

        internal static HeaderError invalidSyntax() {
            return new HeaderError(INVALID_SYNTAX, null);
        }

        internal static HeaderError forbidden() {
            return new HeaderError(FORBIDDEN, null);
        }

        internal static HeaderError immutable() {
            return new HeaderError(IMMUTABLE, null);
        }

        internal const byte INVALID_SYNTAX = 0;
        internal const byte FORBIDDEN = 1;
        internal const byte IMMUTABLE = 2;
    }

    /**
    * This following block defines the `fields` resource which corresponds to
    * HTTP standard Fields. Fields are a common representation used for both
    * Headers and Trailers.
    *
    * A `fields` may be mutable or immutable. A `fields` created using the
    * constructor, `from-list`, or `clone` will be mutable, but a `fields`
    * resource given by other means (including, but not limited to,
    * `incoming-request.headers`, `outgoing-request.headers`) might be be
    * immutable. In an immutable fields, the `set`, `append`, and `delete`
    * operations will fail with `header-error.immutable`.
    */

    internal class Fields: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal Fields(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]fields"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~Fields() {
            Dispose(false);
        }

        internal static class ConstructorWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[constructor]fields"), WasmImportLinkage]
            internal static extern int wasmImportConstructor();

        }

        internal   unsafe  Fields()
        {
            var result =  ConstructorWasmInterop.wasmImportConstructor();
            this.Handle = result;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class FromListWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[static]fields.from-list"), WasmImportLinkage]
            internal static extern void wasmImportFromList(nint p0, int p1, nint p2);

        }

        internal  static unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields FromList(List<(string, byte[])> entries)
        {

            byte[] buffer0 = new byte[16 * entries.Count];
            var gcHandle = GCHandle.Alloc(buffer0, GCHandleType.Pinned);
            var address = gcHandle.AddrOfPinnedObject();

            for (int index = 0; index < entries.Count; ++index) {
                (string, byte[]) element = entries[index];
                int basePtr = (int)address + (index * 16);

                var result = element.Item1;
                IntPtr interopString = InteropString.FromString(result, out int lengthresult);
                BitConverter.TryWriteBytes(new Span<byte>((void*)(basePtr + 4), 4), unchecked((int)lengthresult));
                BitConverter.TryWriteBytes(new Span<byte>((void*)(basePtr + 0), 4), unchecked((int)interopString.ToInt32()));

                void* buffer = stackalloc byte[(element.Item2).Length];
                element.Item2.AsSpan<byte>().CopyTo(new Span<byte>(buffer, element.Item2.Length));
                BitConverter.TryWriteBytes(new Span<byte>((void*)(basePtr + 12), 4), unchecked((int)(element.Item2).Length));
                BitConverter.TryWriteBytes(new Span<byte>((void*)(basePtr + 8), 4), unchecked((int)(int)buffer));

            }

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                FromListWasmInterop.wasmImportFromList((int)address, entries.Count, ptr);

                Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError> lifted11;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))));

                        lifted11 = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError>.ok(resource);
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.invalidSyntax();
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.forbidden();
                                break;
                            }
                            case 2: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.immutable();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted11 = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                gcHandle.Free();
                if (lifted11.IsOk) {
                    var tmp = lifted11.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted11.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class GetWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]fields.get"), WasmImportLinkage]
            internal static extern void wasmImportGet(int p0, nint p1, int p2, nint p3);

        }

        internal   unsafe List<byte[]> Get(string name)
        {
            var handle = this.Handle;

            var result = name;
            IntPtr interopString = InteropString.FromString(result, out int lengthresult);

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                GetWasmInterop.wasmImportGet(handle, interopString.ToInt32(), lengthresult, ptr);

                var array0 = new List<byte[]>(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)));
                for (int index = 0; index < BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)); ++index) {
                    nint basePtr = BitConverter.ToInt32(new Span<byte>((void*)(ptr + 0), 4)) + (index * 8);

                    var array = new byte[BitConverter.ToInt32(new Span<byte>((void*)(basePtr + 4), 4))];
                    new Span<byte>((void*)(BitConverter.ToInt32(new Span<byte>((void*)(basePtr + 0), 4))), BitConverter.ToInt32(new Span<byte>((void*)(basePtr + 4), 4))).CopyTo(new Span<byte>(array));

                    array0.Add(array);
                }
                return array0;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class HasWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]fields.has"), WasmImportLinkage]
            internal static extern int wasmImportHas(int p0, nint p1, int p2);

        }

        internal   unsafe bool Has(string name)
        {
            var handle = this.Handle;

            var result = name;
            IntPtr interopString = InteropString.FromString(result, out int lengthresult);
            var result0 =  HasWasmInterop.wasmImportHas(handle, interopString.ToInt32(), lengthresult);
            return (result0 != 0);

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]fields.set"), WasmImportLinkage]
            internal static extern void wasmImportSet(int p0, nint p1, int p2, nint p3, int p4, nint p5);

        }

        internal   unsafe void Set(string name, List<byte[]> value)
        {
            var handle = this.Handle;

            var result = name;
            IntPtr interopString = InteropString.FromString(result, out int lengthresult);

            byte[] buffer0 = new byte[8 * value.Count];
            var gcHandle = GCHandle.Alloc(buffer0, GCHandleType.Pinned);
            var address = gcHandle.AddrOfPinnedObject();

            for (int index = 0; index < value.Count; ++index) {
                byte[] element = value[index];
                int basePtr = (int)address + (index * 8);

                void* buffer = stackalloc byte[(element).Length];
                element.AsSpan<byte>().CopyTo(new Span<byte>(buffer, element.Length));
                BitConverter.TryWriteBytes(new Span<byte>((void*)(basePtr + 4), 4), unchecked((int)(element).Length));
                BitConverter.TryWriteBytes(new Span<byte>((void*)(basePtr + 0), 4), unchecked((int)(int)buffer));

            }

            var retArea = new byte[2];
            fixed (byte* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                SetWasmInterop.wasmImportSet(handle, interopString.ToInt32(), lengthresult, (int)address, value.Count, ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError> lifted11;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted11 = Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError lifted;

                        switch (new Span<byte>((void*)(ptr + 1), 1)[0]) {
                            case 0: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.invalidSyntax();
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.forbidden();
                                break;
                            }
                            case 2: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.immutable();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 1), 1)[0]}");
                        }

                        lifted11 = Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                gcHandle.Free();
                if (lifted11.IsOk) {
                    var tmp = lifted11.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted11.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class DeleteWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]fields.delete"), WasmImportLinkage]
            internal static extern void wasmImportDelete(int p0, nint p1, int p2, nint p3);

        }

        internal   unsafe void Delete(string name)
        {
            var handle = this.Handle;

            var result = name;
            IntPtr interopString = InteropString.FromString(result, out int lengthresult);

            var retArea = new byte[2];
            fixed (byte* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                DeleteWasmInterop.wasmImportDelete(handle, interopString.ToInt32(), lengthresult, ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError> lifted8;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted8 = Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError lifted;

                        switch (new Span<byte>((void*)(ptr + 1), 1)[0]) {
                            case 0: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.invalidSyntax();
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.forbidden();
                                break;
                            }
                            case 2: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.immutable();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 1), 1)[0]}");
                        }

                        lifted8 = Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted8.IsOk) {
                    var tmp = lifted8.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted8.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class AppendWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]fields.append"), WasmImportLinkage]
            internal static extern void wasmImportAppend(int p0, nint p1, int p2, nint p3, int p4, nint p5);

        }

        internal   unsafe void Append(string name, byte[] value)
        {
            var handle = this.Handle;

            var result = name;
            IntPtr interopString = InteropString.FromString(result, out int lengthresult);

            void* buffer = stackalloc byte[(value).Length];
            value.AsSpan<byte>().CopyTo(new Span<byte>(buffer, value.Length));

            var retArea = new byte[2];
            fixed (byte* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                AppendWasmInterop.wasmImportAppend(handle, interopString.ToInt32(), lengthresult, (int)buffer, (value).Length, ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError> lifted8;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted8 = Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError lifted;

                        switch (new Span<byte>((void*)(ptr + 1), 1)[0]) {
                            case 0: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.invalidSyntax();
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.forbidden();
                                break;
                            }
                            case 2: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError.immutable();
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 1), 1)[0]}");
                        }

                        lifted8 = Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.HeaderError>.err(lifted);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted8.IsOk) {
                    var tmp = lifted8.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted8.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class EntriesWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]fields.entries"), WasmImportLinkage]
            internal static extern void wasmImportEntries(int p0, nint p1);

        }

        internal   unsafe List<(string, byte[])> Entries()
        {
            var handle = this.Handle;

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                EntriesWasmInterop.wasmImportEntries(handle, ptr);

                var array0 = new List<(string, byte[])>(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)));
                for (int index = 0; index < BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)); ++index) {
                    nint basePtr = BitConverter.ToInt32(new Span<byte>((void*)(ptr + 0), 4)) + (index * 16);

                    var array = new byte[BitConverter.ToInt32(new Span<byte>((void*)(basePtr + 12), 4))];
                    new Span<byte>((void*)(BitConverter.ToInt32(new Span<byte>((void*)(basePtr + 8), 4))), BitConverter.ToInt32(new Span<byte>((void*)(basePtr + 12), 4))).CopyTo(new Span<byte>(array));

                    array0.Add((Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(basePtr + 0), 4)), BitConverter.ToInt32(new Span<byte>((void*)(basePtr + 4), 4))), array
                    ));
                }
                return array0;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class CloneWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]fields.clone"), WasmImportLinkage]
            internal static extern int wasmImportClone(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields Clone()
        {
            var handle = this.Handle;
            var result =  CloneWasmInterop.wasmImportClone(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents an incoming HTTP Request.
    */

    internal class IncomingRequest: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal IncomingRequest(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]incoming-request"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~IncomingRequest() {
            Dispose(false);
        }

        internal static class MethodWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-request.method"), WasmImportLinkage]
            internal static extern void wasmImportMethod(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method Method()
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                MethodWasmInterop.wasmImportMethod(handle, ptr);

                global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.get();
                        break;
                    }
                    case 1: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.head();
                        break;
                    }
                    case 2: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.post();
                        break;
                    }
                    case 3: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.put();
                        break;
                    }
                    case 4: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.delete();
                        break;
                    }
                    case 5: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.connect();
                        break;
                    }
                    case 6: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.options();
                        break;
                    }
                    case 7: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.trace();
                        break;
                    }
                    case 8: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.patch();
                        break;
                    }
                    case 9: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.other(Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class PathWithQueryWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-request.path-with-query"), WasmImportLinkage]
            internal static extern void wasmImportPathWithQuery(int p0, nint p1);

        }

        internal   unsafe string? PathWithQuery()
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                PathWithQueryWasmInterop.wasmImportPathWithQuery(handle, ptr);

                string? lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted = null;
                        break;
                    }

                    case 1: {

                        lifted = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4)));
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SchemeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-request.scheme"), WasmImportLinkage]
            internal static extern void wasmImportScheme(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme? Scheme()
        {
            var handle = this.Handle;

            var retArea = new uint[4];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                SchemeWasmInterop.wasmImportScheme(handle, ptr);

                global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme? lifted8;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted8 = null;
                        break;
                    }

                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme.http();
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme.https();
                                break;
                            }
                            case 2: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme.other(Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 12), 4))));
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted8 = lifted;
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted8;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class AuthorityWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-request.authority"), WasmImportLinkage]
            internal static extern void wasmImportAuthority(int p0, nint p1);

        }

        internal   unsafe string? Authority()
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                AuthorityWasmInterop.wasmImportAuthority(handle, ptr);

                string? lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted = null;
                        break;
                    }

                    case 1: {

                        lifted = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4)));
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class HeadersWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-request.headers"), WasmImportLinkage]
            internal static extern int wasmImportHeaders(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields Headers()
        {
            var handle = this.Handle;
            var result =  HeadersWasmInterop.wasmImportHeaders(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class ConsumeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-request.consume"), WasmImportLinkage]
            internal static extern void wasmImportConsume(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody Consume()
        {
            var handle = this.Handle;

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                ConsumeWasmInterop.wasmImportConsume(handle, ptr);

                Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody, None> lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))));

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody, None>.ok(resource);
                        break;
                    }
                    case 1: {

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody, None>.err(new global::WasiHttpWorld.None());
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted.IsOk) {
                    var tmp = lifted.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents an outgoing HTTP Request.
    */

    internal class OutgoingRequest: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal OutgoingRequest(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]outgoing-request"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~OutgoingRequest() {
            Dispose(false);
        }

        internal static class ConstructorWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[constructor]outgoing-request"), WasmImportLinkage]
            internal static extern int wasmImportConstructor(int p0);

        }

        internal   unsafe  OutgoingRequest(global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields headers)
        {
            var handle = headers.Handle;
            headers.Handle = 0;
            var result =  ConstructorWasmInterop.wasmImportConstructor(handle);
            this.Handle = result;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BodyWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.body"), WasmImportLinkage]
            internal static extern void wasmImportBody(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody Body()
        {
            var handle = this.Handle;

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BodyWasmInterop.wasmImportBody(handle, ptr);

                Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody, None> lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))));

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody, None>.ok(resource);
                        break;
                    }
                    case 1: {

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody, None>.err(new global::WasiHttpWorld.None());
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted.IsOk) {
                    var tmp = lifted.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class MethodWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.method"), WasmImportLinkage]
            internal static extern void wasmImportMethod(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method Method()
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                MethodWasmInterop.wasmImportMethod(handle, ptr);

                global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.get();
                        break;
                    }
                    case 1: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.head();
                        break;
                    }
                    case 2: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.post();
                        break;
                    }
                    case 3: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.put();
                        break;
                    }
                    case 4: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.delete();
                        break;
                    }
                    case 5: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.connect();
                        break;
                    }
                    case 6: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.options();
                        break;
                    }
                    case 7: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.trace();
                        break;
                    }
                    case 8: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.patch();
                        break;
                    }
                    case 9: {

                        lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method.other(Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4))));
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetMethodWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.set-method"), WasmImportLinkage]
            internal static extern int wasmImportSetMethod(int p0, int p1, nint p2, int p3);

        }

        internal   unsafe void SetMethod(global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Method method)
        {
            var handle = this.Handle;

            int lowered;
            nint lowered27;
            int lowered28;

            switch (method.Tag) {
                case 0: {

                    lowered = 0;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 1: {

                    lowered = 1;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 2: {

                    lowered = 2;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 3: {

                    lowered = 3;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 4: {

                    lowered = 4;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 5: {

                    lowered = 5;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 6: {

                    lowered = 6;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 7: {

                    lowered = 7;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 8: {

                    lowered = 8;
                    lowered27 = 0;
                    lowered28 = 0;

                    break;
                }
                case 9: {
                    string payload26 = method.AsOther;

                    var result = payload26;
                    IntPtr interopString = InteropString.FromString(result, out int lengthresult);

                    lowered = 9;
                    lowered27 = interopString.ToInt32();
                    lowered28 = lengthresult;

                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {method}");
            }
            var result29 =  SetMethodWasmInterop.wasmImportSetMethod(handle, lowered, lowered27, lowered28);

            Result<None, None> lifted;

            switch (result29) {
                case 0: {

                    lifted = Result<None, None>.ok(new global::WasiHttpWorld.None());
                    break;
                }
                case 1: {

                    lifted = Result<None, None>.err(new global::WasiHttpWorld.None());
                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {result29}");
            }
            if (lifted.IsOk) {
                var tmp = lifted.AsOk;
                return ;
            } else {
                throw new WitException(lifted.AsErr!, 0);
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class PathWithQueryWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.path-with-query"), WasmImportLinkage]
            internal static extern void wasmImportPathWithQuery(int p0, nint p1);

        }

        internal   unsafe string? PathWithQuery()
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                PathWithQueryWasmInterop.wasmImportPathWithQuery(handle, ptr);

                string? lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted = null;
                        break;
                    }

                    case 1: {

                        lifted = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4)));
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetPathWithQueryWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.set-path-with-query"), WasmImportLinkage]
            internal static extern int wasmImportSetPathWithQuery(int p0, int p1, nint p2, int p3);

        }

        internal   unsafe void SetPathWithQuery(string? pathWithQuery)
        {
            var handle = this.Handle;

            int lowered;
            nint lowered3;
            int lowered4;

            if (pathWithQuery != null) {
                var payload2 = (string) pathWithQuery;

                var result = payload2;
                IntPtr interopString = InteropString.FromString(result, out int lengthresult);

                lowered = 1;
                lowered3 = interopString.ToInt32();
                lowered4 = lengthresult;

            } else {

                lowered = 0;
                lowered3 = 0;
                lowered4 = 0;

            }
            var result5 =  SetPathWithQueryWasmInterop.wasmImportSetPathWithQuery(handle, lowered, lowered3, lowered4);

            Result<None, None> lifted;

            switch (result5) {
                case 0: {

                    lifted = Result<None, None>.ok(new global::WasiHttpWorld.None());
                    break;
                }
                case 1: {

                    lifted = Result<None, None>.err(new global::WasiHttpWorld.None());
                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {result5}");
            }
            if (lifted.IsOk) {
                var tmp = lifted.AsOk;
                return ;
            } else {
                throw new WitException(lifted.AsErr!, 0);
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SchemeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.scheme"), WasmImportLinkage]
            internal static extern void wasmImportScheme(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme? Scheme()
        {
            var handle = this.Handle;

            var retArea = new uint[4];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                SchemeWasmInterop.wasmImportScheme(handle, ptr);

                global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme? lifted8;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted8 = null;
                        break;
                    }

                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme lifted;

                        switch (new Span<byte>((void*)(ptr + 4), 1)[0]) {
                            case 0: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme.http();
                                break;
                            }
                            case 1: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme.https();
                                break;
                            }
                            case 2: {

                                lifted = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme.other(Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 12), 4))));
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 4), 1)[0]}");
                        }

                        lifted8 = lifted;
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted8;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetSchemeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.set-scheme"), WasmImportLinkage]
            internal static extern int wasmImportSetScheme(int p0, int p1, int p2, nint p3, int p4);

        }

        internal   unsafe void SetScheme(global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme? scheme)
        {
            var handle = this.Handle;

            int lowered14;
            int lowered15;
            nint lowered16;
            int lowered17;

            if (scheme != null) {
                var payload2 = (global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Scheme) scheme;

                int lowered;
                nint lowered12;
                int lowered13;

                switch (payload2.Tag) {
                    case 0: {

                        lowered = 0;
                        lowered12 = 0;
                        lowered13 = 0;

                        break;
                    }
                    case 1: {

                        lowered = 1;
                        lowered12 = 0;
                        lowered13 = 0;

                        break;
                    }
                    case 2: {
                        string payload11 = payload2.AsOther;

                        var result = payload11;
                        IntPtr interopString = InteropString.FromString(result, out int lengthresult);

                        lowered = 2;
                        lowered12 = interopString.ToInt32();
                        lowered13 = lengthresult;

                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {payload2}");
                }

                lowered14 = 1;
                lowered15 = lowered;
                lowered16 = lowered12;
                lowered17 = lowered13;

            } else {

                lowered14 = 0;
                lowered15 = 0;
                lowered16 = 0;
                lowered17 = 0;

            }
            var result18 =  SetSchemeWasmInterop.wasmImportSetScheme(handle, lowered14, lowered15, lowered16, lowered17);

            Result<None, None> lifted;

            switch (result18) {
                case 0: {

                    lifted = Result<None, None>.ok(new global::WasiHttpWorld.None());
                    break;
                }
                case 1: {

                    lifted = Result<None, None>.err(new global::WasiHttpWorld.None());
                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {result18}");
            }
            if (lifted.IsOk) {
                var tmp = lifted.AsOk;
                return ;
            } else {
                throw new WitException(lifted.AsErr!, 0);
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class AuthorityWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.authority"), WasmImportLinkage]
            internal static extern void wasmImportAuthority(int p0, nint p1);

        }

        internal   unsafe string? Authority()
        {
            var handle = this.Handle;

            var retArea = new uint[3];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                AuthorityWasmInterop.wasmImportAuthority(handle, ptr);

                string? lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted = null;
                        break;
                    }

                    case 1: {

                        lifted = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 8), 4)));
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetAuthorityWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.set-authority"), WasmImportLinkage]
            internal static extern int wasmImportSetAuthority(int p0, int p1, nint p2, int p3);

        }

        internal   unsafe void SetAuthority(string? authority)
        {
            var handle = this.Handle;

            int lowered;
            nint lowered3;
            int lowered4;

            if (authority != null) {
                var payload2 = (string) authority;

                var result = payload2;
                IntPtr interopString = InteropString.FromString(result, out int lengthresult);

                lowered = 1;
                lowered3 = interopString.ToInt32();
                lowered4 = lengthresult;

            } else {

                lowered = 0;
                lowered3 = 0;
                lowered4 = 0;

            }
            var result5 =  SetAuthorityWasmInterop.wasmImportSetAuthority(handle, lowered, lowered3, lowered4);

            Result<None, None> lifted;

            switch (result5) {
                case 0: {

                    lifted = Result<None, None>.ok(new global::WasiHttpWorld.None());
                    break;
                }
                case 1: {

                    lifted = Result<None, None>.err(new global::WasiHttpWorld.None());
                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {result5}");
            }
            if (lifted.IsOk) {
                var tmp = lifted.AsOk;
                return ;
            } else {
                throw new WitException(lifted.AsErr!, 0);
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class HeadersWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-request.headers"), WasmImportLinkage]
            internal static extern int wasmImportHeaders(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields Headers()
        {
            var handle = this.Handle;
            var result =  HeadersWasmInterop.wasmImportHeaders(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Parameters for making an HTTP Request. Each of these parameters is
    * currently an optional timeout applicable to the transport layer of the
    * HTTP protocol.
    *
    * These timeouts are separate from any the user may use to bound a
    * blocking call to `wasi:io/poll.poll`.
    */

    internal class RequestOptions: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal RequestOptions(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]request-options"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~RequestOptions() {
            Dispose(false);
        }

        internal static class ConstructorWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[constructor]request-options"), WasmImportLinkage]
            internal static extern int wasmImportConstructor();

        }

        internal   unsafe  RequestOptions()
        {
            var result =  ConstructorWasmInterop.wasmImportConstructor();
            this.Handle = result;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class ConnectTimeoutWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]request-options.connect-timeout"), WasmImportLinkage]
            internal static extern void wasmImportConnectTimeout(int p0, nint p1);

        }

        internal   unsafe ulong? ConnectTimeout()
        {
            var handle = this.Handle;

            var retArea = new ulong[2];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                ConnectTimeoutWasmInterop.wasmImportConnectTimeout(handle, ptr);

                ulong? lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted = null;
                        break;
                    }

                    case 1: {

                        lifted = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 8), 8))));
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetConnectTimeoutWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]request-options.set-connect-timeout"), WasmImportLinkage]
            internal static extern int wasmImportSetConnectTimeout(int p0, int p1, long p2);

        }

        internal   unsafe void SetConnectTimeout(ulong? duration)
        {
            var handle = this.Handle;

            int lowered;
            long lowered3;

            if (duration != null) {
                var payload2 = (ulong) duration;

                lowered = 1;
                lowered3 = unchecked((long)(payload2));

            } else {

                lowered = 0;
                lowered3 = 0L;

            }
            var result =  SetConnectTimeoutWasmInterop.wasmImportSetConnectTimeout(handle, lowered, lowered3);

            Result<None, None> lifted;

            switch (result) {
                case 0: {

                    lifted = Result<None, None>.ok(new global::WasiHttpWorld.None());
                    break;
                }
                case 1: {

                    lifted = Result<None, None>.err(new global::WasiHttpWorld.None());
                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {result}");
            }
            if (lifted.IsOk) {
                var tmp = lifted.AsOk;
                return ;
            } else {
                throw new WitException(lifted.AsErr!, 0);
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class FirstByteTimeoutWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]request-options.first-byte-timeout"), WasmImportLinkage]
            internal static extern void wasmImportFirstByteTimeout(int p0, nint p1);

        }

        internal   unsafe ulong? FirstByteTimeout()
        {
            var handle = this.Handle;

            var retArea = new ulong[2];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                FirstByteTimeoutWasmInterop.wasmImportFirstByteTimeout(handle, ptr);

                ulong? lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted = null;
                        break;
                    }

                    case 1: {

                        lifted = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 8), 8))));
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetFirstByteTimeoutWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]request-options.set-first-byte-timeout"), WasmImportLinkage]
            internal static extern int wasmImportSetFirstByteTimeout(int p0, int p1, long p2);

        }

        internal   unsafe void SetFirstByteTimeout(ulong? duration)
        {
            var handle = this.Handle;

            int lowered;
            long lowered3;

            if (duration != null) {
                var payload2 = (ulong) duration;

                lowered = 1;
                lowered3 = unchecked((long)(payload2));

            } else {

                lowered = 0;
                lowered3 = 0L;

            }
            var result =  SetFirstByteTimeoutWasmInterop.wasmImportSetFirstByteTimeout(handle, lowered, lowered3);

            Result<None, None> lifted;

            switch (result) {
                case 0: {

                    lifted = Result<None, None>.ok(new global::WasiHttpWorld.None());
                    break;
                }
                case 1: {

                    lifted = Result<None, None>.err(new global::WasiHttpWorld.None());
                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {result}");
            }
            if (lifted.IsOk) {
                var tmp = lifted.AsOk;
                return ;
            } else {
                throw new WitException(lifted.AsErr!, 0);
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BetweenBytesTimeoutWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]request-options.between-bytes-timeout"), WasmImportLinkage]
            internal static extern void wasmImportBetweenBytesTimeout(int p0, nint p1);

        }

        internal   unsafe ulong? BetweenBytesTimeout()
        {
            var handle = this.Handle;

            var retArea = new ulong[2];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BetweenBytesTimeoutWasmInterop.wasmImportBetweenBytesTimeout(handle, ptr);

                ulong? lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted = null;
                        break;
                    }

                    case 1: {

                        lifted = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 8), 8))));
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted;
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetBetweenBytesTimeoutWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]request-options.set-between-bytes-timeout"), WasmImportLinkage]
            internal static extern int wasmImportSetBetweenBytesTimeout(int p0, int p1, long p2);

        }

        internal   unsafe void SetBetweenBytesTimeout(ulong? duration)
        {
            var handle = this.Handle;

            int lowered;
            long lowered3;

            if (duration != null) {
                var payload2 = (ulong) duration;

                lowered = 1;
                lowered3 = unchecked((long)(payload2));

            } else {

                lowered = 0;
                lowered3 = 0L;

            }
            var result =  SetBetweenBytesTimeoutWasmInterop.wasmImportSetBetweenBytesTimeout(handle, lowered, lowered3);

            Result<None, None> lifted;

            switch (result) {
                case 0: {

                    lifted = Result<None, None>.ok(new global::WasiHttpWorld.None());
                    break;
                }
                case 1: {

                    lifted = Result<None, None>.err(new global::WasiHttpWorld.None());
                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {result}");
            }
            if (lifted.IsOk) {
                var tmp = lifted.AsOk;
                return ;
            } else {
                throw new WitException(lifted.AsErr!, 0);
            }

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents the ability to send an HTTP Response.
    *
    * This resource is used by the `wasi:http/incoming-handler` interface to
    * allow a Response to be sent corresponding to the Request provided as the
    * other argument to `incoming-handler.handle`.
    */

    internal class ResponseOutparam: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal ResponseOutparam(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]response-outparam"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~ResponseOutparam() {
            Dispose(false);
        }

        internal static class SetWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[static]response-outparam.set"), WasmImportLinkage]
            internal static extern void wasmImportSet(int p0, int p1, int p2, int p3, long p4, nint p5, nint p6, int p7, int p8);

        }

        internal  static unsafe void Set(global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ResponseOutparam param, Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode> response)
        {
            var handle = param.Handle;
            param.Handle = 0;

            int lowered332;
            int lowered333;
            int lowered334;
            long lowered335;
            nint lowered336;
            nint lowered337;
            int lowered338;
            int lowered339;

            switch (response.Tag) {
                case 0: {
                    global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingResponse payload = response.AsOk;
                    var handle0 = payload.Handle;
                    payload.Handle = 0;

                    lowered332 = 0;
                    lowered333 = handle0;
                    lowered334 = 0;
                    lowered335 = 0L;
                    lowered336 = 0;
                    lowered337 = 0;
                    lowered338 = 0;
                    lowered339 = 0;

                    break;
                }
                case 1: {
                    global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode payload3 = response.AsErr;

                    int lowered325;
                    int lowered326;
                    long lowered327;
                    nint lowered328;
                    nint lowered329;
                    int lowered330;
                    int lowered331;

                    switch (payload3.Tag) {
                        case 0: {

                            lowered325 = 0;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 1: {
                            global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.DnsErrorPayload payload9 = payload3.AsDnsError;

                            int lowered;
                            nint lowered16;
                            int lowered17;

                            if (payload9.rcode != null) {
                                var payload15 = (string) payload9.rcode;

                                var result = payload15;
                                IntPtr interopString = InteropString.FromString(result, out int lengthresult);

                                lowered = 1;
                                lowered16 = interopString.ToInt32();
                                lowered17 = lengthresult;

                            } else {

                                lowered = 0;
                                lowered16 = 0;
                                lowered17 = 0;

                            }

                            int lowered24;
                            int lowered25;

                            if (payload9.infoCode != null) {
                                var payload23 = (ushort) payload9.infoCode;

                                lowered24 = 1;
                                lowered25 = payload23;

                            } else {

                                lowered24 = 0;
                                lowered25 = 0;

                            }

                            lowered325 = 1;
                            lowered326 = lowered;
                            lowered327 = (long) (lowered16);
                            lowered328 = lowered17;
                            lowered329 = lowered24;
                            lowered330 = lowered25;
                            lowered331 = 0;

                            break;
                        }
                        case 2: {

                            lowered325 = 2;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 3: {

                            lowered325 = 3;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 4: {

                            lowered325 = 4;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 5: {

                            lowered325 = 5;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 6: {

                            lowered325 = 6;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 7: {

                            lowered325 = 7;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 8: {

                            lowered325 = 8;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 9: {

                            lowered325 = 9;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 10: {

                            lowered325 = 10;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 11: {

                            lowered325 = 11;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 12: {

                            lowered325 = 12;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 13: {

                            lowered325 = 13;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 14: {
                            global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.TlsAlertReceivedPayload payload64 = payload3.AsTlsAlertReceived;

                            int lowered71;
                            int lowered72;

                            if (payload64.alertId != null) {
                                var payload70 = (byte) payload64.alertId;

                                lowered71 = 1;
                                lowered72 = payload70;

                            } else {

                                lowered71 = 0;
                                lowered72 = 0;

                            }

                            int lowered81;
                            nint lowered82;
                            int lowered83;

                            if (payload64.alertMessage != null) {
                                var payload78 = (string) payload64.alertMessage;

                                var result80 = payload78;
                                IntPtr interopString79 = InteropString.FromString(result80, out int lengthresult80);

                                lowered81 = 1;
                                lowered82 = interopString79.ToInt32();
                                lowered83 = lengthresult80;

                            } else {

                                lowered81 = 0;
                                lowered82 = 0;
                                lowered83 = 0;

                            }

                            lowered325 = 14;
                            lowered326 = lowered71;
                            lowered327 = (long) (lowered72);
                            lowered328 = lowered81;
                            lowered329 = lowered82;
                            lowered330 = lowered83;
                            lowered331 = 0;

                            break;
                        }
                        case 15: {

                            lowered325 = 15;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 16: {

                            lowered325 = 16;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 17: {
                            ulong? payload92 = payload3.AsHttpRequestBodySize;

                            int lowered99;
                            long lowered100;

                            if (payload92 != null) {
                                var payload98 = (ulong) payload92;

                                lowered99 = 1;
                                lowered100 = unchecked((long)(payload98));

                            } else {

                                lowered99 = 0;
                                lowered100 = 0L;

                            }

                            lowered325 = 17;
                            lowered326 = lowered99;
                            lowered327 = lowered100;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 18: {

                            lowered325 = 18;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 19: {

                            lowered325 = 19;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 20: {

                            lowered325 = 20;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 21: {
                            uint? payload112 = payload3.AsHttpRequestHeaderSectionSize;

                            int lowered119;
                            int lowered120;

                            if (payload112 != null) {
                                var payload118 = (uint) payload112;

                                lowered119 = 1;
                                lowered120 = unchecked((int)(payload118));

                            } else {

                                lowered119 = 0;
                                lowered120 = 0;

                            }

                            lowered325 = 21;
                            lowered326 = lowered119;
                            lowered327 = (long) (lowered120);
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 22: {
                            global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload? payload123 = payload3.AsHttpRequestHeaderSize;

                            int lowered149;
                            int lowered150;
                            nint lowered151;
                            int lowered152;
                            int lowered153;
                            int lowered154;

                            if (payload123 != null) {
                                var payload129 = (global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload) payload123;

                                int lowered138;
                                nint lowered139;
                                int lowered140;

                                if (payload129.fieldName != null) {
                                    var payload135 = (string) payload129.fieldName;

                                    var result137 = payload135;
                                    IntPtr interopString136 = InteropString.FromString(result137, out int lengthresult137);

                                    lowered138 = 1;
                                    lowered139 = interopString136.ToInt32();
                                    lowered140 = lengthresult137;

                                } else {

                                    lowered138 = 0;
                                    lowered139 = 0;
                                    lowered140 = 0;

                                }

                                int lowered147;
                                int lowered148;

                                if (payload129.fieldSize != null) {
                                    var payload146 = (uint) payload129.fieldSize;

                                    lowered147 = 1;
                                    lowered148 = unchecked((int)(payload146));

                                } else {

                                    lowered147 = 0;
                                    lowered148 = 0;

                                }

                                lowered149 = 1;
                                lowered150 = lowered138;
                                lowered151 = lowered139;
                                lowered152 = lowered140;
                                lowered153 = lowered147;
                                lowered154 = lowered148;

                            } else {

                                lowered149 = 0;
                                lowered150 = 0;
                                lowered151 = 0;
                                lowered152 = 0;
                                lowered153 = 0;
                                lowered154 = 0;

                            }

                            lowered325 = 22;
                            lowered326 = lowered149;
                            lowered327 = (long) (lowered150);
                            lowered328 = lowered151;
                            lowered329 = lowered152;
                            lowered330 = lowered153;
                            lowered331 = lowered154;

                            break;
                        }
                        case 23: {
                            uint? payload157 = payload3.AsHttpRequestTrailerSectionSize;

                            int lowered164;
                            int lowered165;

                            if (payload157 != null) {
                                var payload163 = (uint) payload157;

                                lowered164 = 1;
                                lowered165 = unchecked((int)(payload163));

                            } else {

                                lowered164 = 0;
                                lowered165 = 0;

                            }

                            lowered325 = 23;
                            lowered326 = lowered164;
                            lowered327 = (long) (lowered165);
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 24: {
                            global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload payload168 = payload3.AsHttpRequestTrailerSize;

                            int lowered177;
                            nint lowered178;
                            int lowered179;

                            if (payload168.fieldName != null) {
                                var payload174 = (string) payload168.fieldName;

                                var result176 = payload174;
                                IntPtr interopString175 = InteropString.FromString(result176, out int lengthresult176);

                                lowered177 = 1;
                                lowered178 = interopString175.ToInt32();
                                lowered179 = lengthresult176;

                            } else {

                                lowered177 = 0;
                                lowered178 = 0;
                                lowered179 = 0;

                            }

                            int lowered186;
                            int lowered187;

                            if (payload168.fieldSize != null) {
                                var payload185 = (uint) payload168.fieldSize;

                                lowered186 = 1;
                                lowered187 = unchecked((int)(payload185));

                            } else {

                                lowered186 = 0;
                                lowered187 = 0;

                            }

                            lowered325 = 24;
                            lowered326 = lowered177;
                            lowered327 = (long) (lowered178);
                            lowered328 = lowered179;
                            lowered329 = lowered186;
                            lowered330 = lowered187;
                            lowered331 = 0;

                            break;
                        }
                        case 25: {

                            lowered325 = 25;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 26: {
                            uint? payload193 = payload3.AsHttpResponseHeaderSectionSize;

                            int lowered200;
                            int lowered201;

                            if (payload193 != null) {
                                var payload199 = (uint) payload193;

                                lowered200 = 1;
                                lowered201 = unchecked((int)(payload199));

                            } else {

                                lowered200 = 0;
                                lowered201 = 0;

                            }

                            lowered325 = 26;
                            lowered326 = lowered200;
                            lowered327 = (long) (lowered201);
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 27: {
                            global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload payload204 = payload3.AsHttpResponseHeaderSize;

                            int lowered213;
                            nint lowered214;
                            int lowered215;

                            if (payload204.fieldName != null) {
                                var payload210 = (string) payload204.fieldName;

                                var result212 = payload210;
                                IntPtr interopString211 = InteropString.FromString(result212, out int lengthresult212);

                                lowered213 = 1;
                                lowered214 = interopString211.ToInt32();
                                lowered215 = lengthresult212;

                            } else {

                                lowered213 = 0;
                                lowered214 = 0;
                                lowered215 = 0;

                            }

                            int lowered222;
                            int lowered223;

                            if (payload204.fieldSize != null) {
                                var payload221 = (uint) payload204.fieldSize;

                                lowered222 = 1;
                                lowered223 = unchecked((int)(payload221));

                            } else {

                                lowered222 = 0;
                                lowered223 = 0;

                            }

                            lowered325 = 27;
                            lowered326 = lowered213;
                            lowered327 = (long) (lowered214);
                            lowered328 = lowered215;
                            lowered329 = lowered222;
                            lowered330 = lowered223;
                            lowered331 = 0;

                            break;
                        }
                        case 28: {
                            ulong? payload226 = payload3.AsHttpResponseBodySize;

                            int lowered233;
                            long lowered234;

                            if (payload226 != null) {
                                var payload232 = (ulong) payload226;

                                lowered233 = 1;
                                lowered234 = unchecked((long)(payload232));

                            } else {

                                lowered233 = 0;
                                lowered234 = 0L;

                            }

                            lowered325 = 28;
                            lowered326 = lowered233;
                            lowered327 = lowered234;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 29: {
                            uint? payload237 = payload3.AsHttpResponseTrailerSectionSize;

                            int lowered244;
                            int lowered245;

                            if (payload237 != null) {
                                var payload243 = (uint) payload237;

                                lowered244 = 1;
                                lowered245 = unchecked((int)(payload243));

                            } else {

                                lowered244 = 0;
                                lowered245 = 0;

                            }

                            lowered325 = 29;
                            lowered326 = lowered244;
                            lowered327 = (long) (lowered245);
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 30: {
                            global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload payload248 = payload3.AsHttpResponseTrailerSize;

                            int lowered257;
                            nint lowered258;
                            int lowered259;

                            if (payload248.fieldName != null) {
                                var payload254 = (string) payload248.fieldName;

                                var result256 = payload254;
                                IntPtr interopString255 = InteropString.FromString(result256, out int lengthresult256);

                                lowered257 = 1;
                                lowered258 = interopString255.ToInt32();
                                lowered259 = lengthresult256;

                            } else {

                                lowered257 = 0;
                                lowered258 = 0;
                                lowered259 = 0;

                            }

                            int lowered266;
                            int lowered267;

                            if (payload248.fieldSize != null) {
                                var payload265 = (uint) payload248.fieldSize;

                                lowered266 = 1;
                                lowered267 = unchecked((int)(payload265));

                            } else {

                                lowered266 = 0;
                                lowered267 = 0;

                            }

                            lowered325 = 30;
                            lowered326 = lowered257;
                            lowered327 = (long) (lowered258);
                            lowered328 = lowered259;
                            lowered329 = lowered266;
                            lowered330 = lowered267;
                            lowered331 = 0;

                            break;
                        }
                        case 31: {
                            string? payload270 = payload3.AsHttpResponseTransferCoding;

                            int lowered279;
                            nint lowered280;
                            int lowered281;

                            if (payload270 != null) {
                                var payload276 = (string) payload270;

                                var result278 = payload276;
                                IntPtr interopString277 = InteropString.FromString(result278, out int lengthresult278);

                                lowered279 = 1;
                                lowered280 = interopString277.ToInt32();
                                lowered281 = lengthresult278;

                            } else {

                                lowered279 = 0;
                                lowered280 = 0;
                                lowered281 = 0;

                            }

                            lowered325 = 31;
                            lowered326 = lowered279;
                            lowered327 = (long) (lowered280);
                            lowered328 = lowered281;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 32: {
                            string? payload284 = payload3.AsHttpResponseContentCoding;

                            int lowered293;
                            nint lowered294;
                            int lowered295;

                            if (payload284 != null) {
                                var payload290 = (string) payload284;

                                var result292 = payload290;
                                IntPtr interopString291 = InteropString.FromString(result292, out int lengthresult292);

                                lowered293 = 1;
                                lowered294 = interopString291.ToInt32();
                                lowered295 = lengthresult292;

                            } else {

                                lowered293 = 0;
                                lowered294 = 0;
                                lowered295 = 0;

                            }

                            lowered325 = 32;
                            lowered326 = lowered293;
                            lowered327 = (long) (lowered294);
                            lowered328 = lowered295;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 33: {

                            lowered325 = 33;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 34: {

                            lowered325 = 34;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 35: {

                            lowered325 = 35;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 36: {

                            lowered325 = 36;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 37: {

                            lowered325 = 37;
                            lowered326 = 0;
                            lowered327 = 0L;
                            lowered328 = 0;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }
                        case 38: {
                            string? payload313 = payload3.AsInternalError;

                            int lowered322;
                            nint lowered323;
                            int lowered324;

                            if (payload313 != null) {
                                var payload319 = (string) payload313;

                                var result321 = payload319;
                                IntPtr interopString320 = InteropString.FromString(result321, out int lengthresult321);

                                lowered322 = 1;
                                lowered323 = interopString320.ToInt32();
                                lowered324 = lengthresult321;

                            } else {

                                lowered322 = 0;
                                lowered323 = 0;
                                lowered324 = 0;

                            }

                            lowered325 = 38;
                            lowered326 = lowered322;
                            lowered327 = (long) (lowered323);
                            lowered328 = lowered324;
                            lowered329 = 0;
                            lowered330 = 0;
                            lowered331 = 0;

                            break;
                        }

                        default: throw new ArgumentException($"invalid discriminant: {payload3}");
                    }

                    lowered332 = 1;
                    lowered333 = lowered325;
                    lowered334 = lowered326;
                    lowered335 = lowered327;
                    lowered336 = lowered328;
                    lowered337 = lowered329;
                    lowered338 = lowered330;
                    lowered339 = lowered331;

                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {response}");
            }
            SetWasmInterop.wasmImportSet(handle, lowered332, lowered333, lowered334, lowered335, lowered336, lowered337, lowered338, lowered339);

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents an incoming HTTP Response.
    */

    internal class IncomingResponse: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal IncomingResponse(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]incoming-response"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~IncomingResponse() {
            Dispose(false);
        }

        internal static class StatusWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-response.status"), WasmImportLinkage]
            internal static extern int wasmImportStatus(int p0);

        }

        internal   unsafe ushort Status()
        {
            var handle = this.Handle;
            var result =  StatusWasmInterop.wasmImportStatus(handle);
            return ((ushort)result);

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class HeadersWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-response.headers"), WasmImportLinkage]
            internal static extern int wasmImportHeaders(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields Headers()
        {
            var handle = this.Handle;
            var result =  HeadersWasmInterop.wasmImportHeaders(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class ConsumeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-response.consume"), WasmImportLinkage]
            internal static extern void wasmImportConsume(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody Consume()
        {
            var handle = this.Handle;

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                ConsumeWasmInterop.wasmImportConsume(handle, ptr);

                Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody, None> lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))));

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody, None>.ok(resource);
                        break;
                    }
                    case 1: {

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody, None>.err(new global::WasiHttpWorld.None());
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted.IsOk) {
                    var tmp = lifted.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents an incoming HTTP Request or Response's Body.
    *
    * A body has both its contents - a stream of bytes - and a (possibly
    * empty) set of trailers, indicating that the full contents of the
    * body have been received. This resource represents the contents as
    * an `input-stream` and the delivery of trailers as a `future-trailers`,
    * and ensures that the user of this interface may only be consuming either
    * the body contents or waiting on trailers at any given time.
    */

    internal class IncomingBody: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal IncomingBody(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]incoming-body"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~IncomingBody() {
            Dispose(false);
        }

        internal static class StreamWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]incoming-body.stream"), WasmImportLinkage]
            internal static extern void wasmImportStream(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.InputStream Stream()
        {
            var handle = this.Handle;

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                StreamWasmInterop.wasmImportStream(handle, ptr);

                Result<global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.InputStream, None> lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.InputStream(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.InputStream.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))));

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.InputStream, None>.ok(resource);
                        break;
                    }
                    case 1: {

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.InputStream, None>.err(new global::WasiHttpWorld.None());
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted.IsOk) {
                    var tmp = lifted.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class FinishWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[static]incoming-body.finish"), WasmImportLinkage]
            internal static extern int wasmImportFinish(int p0);

        }

        internal  static unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FutureTrailers Finish(global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingBody @this)
        {
            var handle = @this.Handle;
            @this.Handle = 0;
            var result =  FinishWasmInterop.wasmImportFinish(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FutureTrailers(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FutureTrailers.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents a future which may eventually return trailers, or an error.
    *
    * In the case that the incoming HTTP Request or Response did not have any
    * trailers, this future will resolve to the empty set of trailers once the
    * complete Request or Response body has been received.
    */

    internal class FutureTrailers: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal FutureTrailers(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]future-trailers"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~FutureTrailers() {
            Dispose(false);
        }

        internal static class SubscribeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]future-trailers.subscribe"), WasmImportLinkage]
            internal static extern int wasmImportSubscribe(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable Subscribe()
        {
            var handle = this.Handle;
            var result =  SubscribeWasmInterop.wasmImportSubscribe(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class GetWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]future-trailers.get"), WasmImportLinkage]
            internal static extern void wasmImportGet(int p0, nint p1);

        }

        internal   unsafe Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields?, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None>? Get()
        {
            var handle = this.Handle;

            var retArea = new ulong[7];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                GetWasmInterop.wasmImportGet(handle, ptr);

                Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields?, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None>? lifted205;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted205 = null;
                        break;
                    }

                    case 1: {

                        Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields?, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None> lifted204;

                        switch (new Span<byte>((void*)(ptr + 8), 1)[0]) {
                            case 0: {

                                Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields?, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode> lifted201;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {

                                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields? lifted;

                                        switch (new Span<byte>((void*)(ptr + 24), 1)[0]) {
                                            case 0: {
                                                lifted = null;
                                                break;
                                            }

                                            case 1: {
                                                var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 28), 4))));

                                                lifted = resource;
                                                break;
                                            }

                                            default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 24), 1)[0]));
                                        }

                                        lifted201 = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields?, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>.ok(lifted);
                                        break;
                                    }
                                    case 1: {

                                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode lifted200;

                                        switch (new Span<byte>((void*)(ptr + 24), 1)[0]) {
                                            case 0: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.dnsTimeout();
                                                break;
                                            }
                                            case 1: {

                                                string? lifted20;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted20 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted20 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                ushort? lifted25;

                                                switch (new Span<byte>((void*)(ptr + 44), 1)[0]) {
                                                    case 0: {
                                                        lifted25 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted25 = ((ushort)BitConverter.ToUInt16(new Span<byte>((void*)(ptr + 46), 2)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 44), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.dnsError(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.DnsErrorPayload (
                                                lifted20, lifted25));
                                                break;
                                            }
                                            case 2: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationNotFound();
                                                break;
                                            }
                                            case 3: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationUnavailable();
                                                break;
                                            }
                                            case 4: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationIpProhibited();
                                                break;
                                            }
                                            case 5: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationIpUnroutable();
                                                break;
                                            }
                                            case 6: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionRefused();
                                                break;
                                            }
                                            case 7: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionTerminated();
                                                break;
                                            }
                                            case 8: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionTimeout();
                                                break;
                                            }
                                            case 9: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionReadTimeout();
                                                break;
                                            }
                                            case 10: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionWriteTimeout();
                                                break;
                                            }
                                            case 11: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionLimitReached();
                                                break;
                                            }
                                            case 12: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsProtocolError();
                                                break;
                                            }
                                            case 13: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsCertificateError();
                                                break;
                                            }
                                            case 14: {

                                                byte? lifted56;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted56 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted56 = ((byte)new Span<byte>((void*)(ptr + 33), 1)[0]);
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                string? lifted61;

                                                switch (new Span<byte>((void*)(ptr + 36), 1)[0]) {
                                                    case 0: {
                                                        lifted61 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted61 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 44), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 36), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsAlertReceived(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.TlsAlertReceivedPayload (
                                                lifted56, lifted61));
                                                break;
                                            }
                                            case 15: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestDenied();
                                                break;
                                            }
                                            case 16: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestLengthRequired();
                                                break;
                                            }
                                            case 17: {

                                                ulong? lifted72;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted72 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted72 = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 40), 8))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestBodySize(lifted72);
                                                break;
                                            }
                                            case 18: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestMethodInvalid();
                                                break;
                                            }
                                            case 19: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestUriInvalid();
                                                break;
                                            }
                                            case 20: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestUriTooLong();
                                                break;
                                            }
                                            case 21: {

                                                uint? lifted85;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted85 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted85 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestHeaderSectionSize(lifted85);
                                                break;
                                            }
                                            case 22: {

                                                global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload? lifted102;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted102 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        string? lifted96;

                                                        switch (new Span<byte>((void*)(ptr + 36), 1)[0]) {
                                                            case 0: {
                                                                lifted96 = null;
                                                                break;
                                                            }

                                                            case 1: {

                                                                lifted96 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 44), 4)));
                                                                break;
                                                            }

                                                            default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 36), 1)[0]));
                                                        }

                                                        uint? lifted101;

                                                        switch (new Span<byte>((void*)(ptr + 48), 1)[0]) {
                                                            case 0: {
                                                                lifted101 = null;
                                                                break;
                                                            }

                                                            case 1: {

                                                                lifted101 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 52), 4))));
                                                                break;
                                                            }

                                                            default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 48), 1)[0]));
                                                        }

                                                        lifted102 = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                                        lifted96, lifted101);
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestHeaderSize(lifted102);
                                                break;
                                            }
                                            case 23: {

                                                uint? lifted109;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted109 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted109 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestTrailerSectionSize(lifted109);
                                                break;
                                            }
                                            case 24: {

                                                string? lifted116;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted116 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted116 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                uint? lifted121;

                                                switch (new Span<byte>((void*)(ptr + 44), 1)[0]) {
                                                    case 0: {
                                                        lifted121 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted121 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 48), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 44), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestTrailerSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                                lifted116, lifted121));
                                                break;
                                            }
                                            case 25: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseIncomplete();
                                                break;
                                            }
                                            case 26: {

                                                uint? lifted130;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted130 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted130 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseHeaderSectionSize(lifted130);
                                                break;
                                            }
                                            case 27: {

                                                string? lifted137;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted137 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted137 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                uint? lifted142;

                                                switch (new Span<byte>((void*)(ptr + 44), 1)[0]) {
                                                    case 0: {
                                                        lifted142 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted142 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 48), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 44), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseHeaderSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                                lifted137, lifted142));
                                                break;
                                            }
                                            case 28: {

                                                ulong? lifted149;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted149 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted149 = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 40), 8))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseBodySize(lifted149);
                                                break;
                                            }
                                            case 29: {

                                                uint? lifted156;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted156 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted156 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTrailerSectionSize(lifted156);
                                                break;
                                            }
                                            case 30: {

                                                string? lifted163;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted163 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted163 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                uint? lifted168;

                                                switch (new Span<byte>((void*)(ptr + 44), 1)[0]) {
                                                    case 0: {
                                                        lifted168 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted168 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 48), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 44), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTrailerSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                                lifted163, lifted168));
                                                break;
                                            }
                                            case 31: {

                                                string? lifted175;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted175 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted175 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTransferCoding(lifted175);
                                                break;
                                            }
                                            case 32: {

                                                string? lifted182;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted182 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted182 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseContentCoding(lifted182);
                                                break;
                                            }
                                            case 33: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTimeout();
                                                break;
                                            }
                                            case 34: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpUpgradeFailed();
                                                break;
                                            }
                                            case 35: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpProtocolError();
                                                break;
                                            }
                                            case 36: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.loopDetected();
                                                break;
                                            }
                                            case 37: {

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.configurationError();
                                                break;
                                            }
                                            case 38: {

                                                string? lifted199;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted199 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted199 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted200 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.internalError(lifted199);
                                                break;
                                            }

                                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 24), 1)[0]}");
                                        }

                                        lifted201 = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields?, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>.err(lifted200);
                                        break;
                                    }

                                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 16), 1)[0]}");
                                }

                                lifted204 = Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields?, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None>.ok(lifted201);
                                break;
                            }
                            case 1: {

                                lifted204 = Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields?, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None>.err(new global::WasiHttpWorld.None());
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 8), 1)[0]}");
                        }

                        lifted205 = lifted204;
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted205;
            }

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents an outgoing HTTP Response.
    */

    internal class OutgoingResponse: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal OutgoingResponse(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]outgoing-response"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~OutgoingResponse() {
            Dispose(false);
        }

        internal static class ConstructorWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[constructor]outgoing-response"), WasmImportLinkage]
            internal static extern int wasmImportConstructor(int p0);

        }

        internal   unsafe  OutgoingResponse(global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields headers)
        {
            var handle = headers.Handle;
            headers.Handle = 0;
            var result =  ConstructorWasmInterop.wasmImportConstructor(handle);
            this.Handle = result;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class StatusCodeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-response.status-code"), WasmImportLinkage]
            internal static extern int wasmImportStatusCode(int p0);

        }

        internal   unsafe ushort StatusCode()
        {
            var handle = this.Handle;
            var result =  StatusCodeWasmInterop.wasmImportStatusCode(handle);
            return ((ushort)result);

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class SetStatusCodeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-response.set-status-code"), WasmImportLinkage]
            internal static extern int wasmImportSetStatusCode(int p0, int p1);

        }

        internal   unsafe void SetStatusCode(ushort statusCode)
        {
            var handle = this.Handle;
            var result =  SetStatusCodeWasmInterop.wasmImportSetStatusCode(handle, statusCode);

            Result<None, None> lifted;

            switch (result) {
                case 0: {

                    lifted = Result<None, None>.ok(new global::WasiHttpWorld.None());
                    break;
                }
                case 1: {

                    lifted = Result<None, None>.err(new global::WasiHttpWorld.None());
                    break;
                }

                default: throw new ArgumentException($"invalid discriminant: {result}");
            }
            if (lifted.IsOk) {
                var tmp = lifted.AsOk;
                return ;
            } else {
                throw new WitException(lifted.AsErr!, 0);
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class HeadersWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-response.headers"), WasmImportLinkage]
            internal static extern int wasmImportHeaders(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields Headers()
        {
            var handle = this.Handle;
            var result =  HeadersWasmInterop.wasmImportHeaders(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class BodyWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-response.body"), WasmImportLinkage]
            internal static extern void wasmImportBody(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody Body()
        {
            var handle = this.Handle;

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                BodyWasmInterop.wasmImportBody(handle, ptr);

                Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody, None> lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))));

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody, None>.ok(resource);
                        break;
                    }
                    case 1: {

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody, None>.err(new global::WasiHttpWorld.None());
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted.IsOk) {
                    var tmp = lifted.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents an outgoing HTTP Request or Response's Body.
    *
    * A body has both its contents - a stream of bytes - and a (possibly
    * empty) set of trailers, inducating the full contents of the body
    * have been sent. This resource represents the contents as an
    * `output-stream` child resource, and the completion of the body (with
    * optional trailers) with a static function that consumes the
    * `outgoing-body` resource, and ensures that the user of this interface
    * may not write to the body contents after the body has been finished.
    *
    * If the user code drops this resource, as opposed to calling the static
    * method `finish`, the implementation should treat the body as incomplete,
    * and that an error has occurred. The implementation should propagate this
    * error to the HTTP protocol by whatever means it has available,
    * including: corrupting the body on the wire, aborting the associated
    * Request, or sending a late status code for the Response.
    */

    internal class OutgoingBody: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal OutgoingBody(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]outgoing-body"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~OutgoingBody() {
            Dispose(false);
        }

        internal static class WriteWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]outgoing-body.write"), WasmImportLinkage]
            internal static extern void wasmImportWrite(int p0, nint p1);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.OutputStream Write()
        {
            var handle = this.Handle;

            var retArea = new uint[2];
            fixed (uint* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                WriteWasmInterop.wasmImportWrite(handle, ptr);

                Result<global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.OutputStream, None> lifted;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.OutputStream(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.OutputStream.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 4), 4))));

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.OutputStream, None>.ok(resource);
                        break;
                    }
                    case 1: {

                        lifted = Result<global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IStreams.OutputStream, None>.err(new global::WasiHttpWorld.None());
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted.IsOk) {
                    var tmp = lifted.AsOk;
                    return tmp;
                } else {
                    throw new WitException(lifted.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class FinishWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[static]outgoing-body.finish"), WasmImportLinkage]
            internal static extern void wasmImportFinish(int p0, int p1, int p2, nint p3);

        }

        internal  static unsafe void Finish(global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.OutgoingBody @this, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields? trailers)
        {
            var handle = @this.Handle;
            @this.Handle = 0;

            int lowered;
            int lowered4;

            if (trailers != null) {
                var payload2 = (global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.Fields) trailers;
                var handle3 = payload2.Handle;
                payload2.Handle = 0;

                lowered = 1;
                lowered4 = handle3;

            } else {

                lowered = 0;
                lowered4 = 0;

            }

            var retArea = new ulong[5];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                FinishWasmInterop.wasmImportFinish(handle, lowered, lowered4, ptr);

                Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode> lifted197;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {

                        lifted197 = Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>.ok(new global::WasiHttpWorld.None());
                        break;
                    }
                    case 1: {

                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode lifted196;

                        switch (new Span<byte>((void*)(ptr + 8), 1)[0]) {
                            case 0: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.dnsTimeout();
                                break;
                            }
                            case 1: {

                                string? lifted;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                ushort? lifted21;

                                switch (new Span<byte>((void*)(ptr + 28), 1)[0]) {
                                    case 0: {
                                        lifted21 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted21 = ((ushort)BitConverter.ToUInt16(new Span<byte>((void*)(ptr + 30), 2)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 28), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.dnsError(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.DnsErrorPayload (
                                lifted, lifted21));
                                break;
                            }
                            case 2: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationNotFound();
                                break;
                            }
                            case 3: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationUnavailable();
                                break;
                            }
                            case 4: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationIpProhibited();
                                break;
                            }
                            case 5: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationIpUnroutable();
                                break;
                            }
                            case 6: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionRefused();
                                break;
                            }
                            case 7: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionTerminated();
                                break;
                            }
                            case 8: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionTimeout();
                                break;
                            }
                            case 9: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionReadTimeout();
                                break;
                            }
                            case 10: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionWriteTimeout();
                                break;
                            }
                            case 11: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionLimitReached();
                                break;
                            }
                            case 12: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsProtocolError();
                                break;
                            }
                            case 13: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsCertificateError();
                                break;
                            }
                            case 14: {

                                byte? lifted52;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted52 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted52 = ((byte)new Span<byte>((void*)(ptr + 17), 1)[0]);
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                string? lifted57;

                                switch (new Span<byte>((void*)(ptr + 20), 1)[0]) {
                                    case 0: {
                                        lifted57 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted57 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 28), 4)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 20), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsAlertReceived(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.TlsAlertReceivedPayload (
                                lifted52, lifted57));
                                break;
                            }
                            case 15: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestDenied();
                                break;
                            }
                            case 16: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestLengthRequired();
                                break;
                            }
                            case 17: {

                                ulong? lifted68;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted68 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted68 = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 24), 8))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestBodySize(lifted68);
                                break;
                            }
                            case 18: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestMethodInvalid();
                                break;
                            }
                            case 19: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestUriInvalid();
                                break;
                            }
                            case 20: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestUriTooLong();
                                break;
                            }
                            case 21: {

                                uint? lifted81;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted81 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted81 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestHeaderSectionSize(lifted81);
                                break;
                            }
                            case 22: {

                                global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload? lifted98;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted98 = null;
                                        break;
                                    }

                                    case 1: {

                                        string? lifted92;

                                        switch (new Span<byte>((void*)(ptr + 20), 1)[0]) {
                                            case 0: {
                                                lifted92 = null;
                                                break;
                                            }

                                            case 1: {

                                                lifted92 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 28), 4)));
                                                break;
                                            }

                                            default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 20), 1)[0]));
                                        }

                                        uint? lifted97;

                                        switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                            case 0: {
                                                lifted97 = null;
                                                break;
                                            }

                                            case 1: {

                                                lifted97 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                break;
                                            }

                                            default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                        }

                                        lifted98 = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                        lifted92, lifted97);
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestHeaderSize(lifted98);
                                break;
                            }
                            case 23: {

                                uint? lifted105;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted105 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted105 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestTrailerSectionSize(lifted105);
                                break;
                            }
                            case 24: {

                                string? lifted112;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted112 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted112 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                uint? lifted117;

                                switch (new Span<byte>((void*)(ptr + 28), 1)[0]) {
                                    case 0: {
                                        lifted117 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted117 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 32), 4))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 28), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestTrailerSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                lifted112, lifted117));
                                break;
                            }
                            case 25: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseIncomplete();
                                break;
                            }
                            case 26: {

                                uint? lifted126;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted126 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted126 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseHeaderSectionSize(lifted126);
                                break;
                            }
                            case 27: {

                                string? lifted133;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted133 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted133 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                uint? lifted138;

                                switch (new Span<byte>((void*)(ptr + 28), 1)[0]) {
                                    case 0: {
                                        lifted138 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted138 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 32), 4))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 28), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseHeaderSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                lifted133, lifted138));
                                break;
                            }
                            case 28: {

                                ulong? lifted145;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted145 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted145 = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 24), 8))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseBodySize(lifted145);
                                break;
                            }
                            case 29: {

                                uint? lifted152;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted152 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted152 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTrailerSectionSize(lifted152);
                                break;
                            }
                            case 30: {

                                string? lifted159;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted159 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted159 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                uint? lifted164;

                                switch (new Span<byte>((void*)(ptr + 28), 1)[0]) {
                                    case 0: {
                                        lifted164 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted164 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 32), 4))));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 28), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTrailerSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                lifted159, lifted164));
                                break;
                            }
                            case 31: {

                                string? lifted171;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted171 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted171 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTransferCoding(lifted171);
                                break;
                            }
                            case 32: {

                                string? lifted178;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted178 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted178 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseContentCoding(lifted178);
                                break;
                            }
                            case 33: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTimeout();
                                break;
                            }
                            case 34: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpUpgradeFailed();
                                break;
                            }
                            case 35: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpProtocolError();
                                break;
                            }
                            case 36: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.loopDetected();
                                break;
                            }
                            case 37: {

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.configurationError();
                                break;
                            }
                            case 38: {

                                string? lifted195;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        lifted195 = null;
                                        break;
                                    }

                                    case 1: {

                                        lifted195 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 20), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4)));
                                        break;
                                    }

                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 16), 1)[0]));
                                }

                                lifted196 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.internalError(lifted195);
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 8), 1)[0]}");
                        }

                        lifted197 = Result<None, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>.err(lifted196);
                        break;
                    }

                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 0), 1)[0]}");
                }
                if (lifted197.IsOk) {
                    var tmp = lifted197.AsOk;
                    return ;
                } else {
                    throw new WitException(lifted197.AsErr!, 0);
                }
            }

            //TODO: free alloc handle (interopString) if exists
        }

    }

    /**
    * Represents a future which may eventually return an incoming HTTP
    * Response, or an error.
    *
    * This resource is returned by the `wasi:http/outgoing-handler` interface to
    * provide the HTTP Response corresponding to the sent Request.
    */

    internal class FutureIncomingResponse: IDisposable {
        internal int Handle { get; set; }

        internal readonly record struct THandle(int Handle);

        internal FutureIncomingResponse(THandle handle) {
            Handle = handle.Handle;
        }

        public void Dispose() {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        [DllImport("wasi:http/types@0.2.1", EntryPoint = "[resource-drop]future-incoming-response"), WasmImportLinkage]
        private static extern void wasmImportResourceDrop(int p0);

        protected virtual void Dispose(bool disposing) {
            if (Handle != 0) {
                wasmImportResourceDrop(Handle);
                Handle = 0;
            }
        }

        ~FutureIncomingResponse() {
            Dispose(false);
        }

        internal static class SubscribeWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]future-incoming-response.subscribe"), WasmImportLinkage]
            internal static extern int wasmImportSubscribe(int p0);

        }

        internal   unsafe global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable Subscribe()
        {
            var handle = this.Handle;
            var result =  SubscribeWasmInterop.wasmImportSubscribe(handle);
            var resource = new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable(new global::WasiHttpWorld.wit.imports.wasi.io.v0_2_1.IPoll.Pollable.THandle(result));
            return resource;

            //TODO: free alloc handle (interopString) if exists
        }

        internal static class GetWasmInterop
        {
            [DllImport("wasi:http/types@0.2.1", EntryPoint = "[method]future-incoming-response.get"), WasmImportLinkage]
            internal static extern void wasmImportGet(int p0, nint p1);

        }

        internal   unsafe Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None>? Get()
        {
            var handle = this.Handle;

            var retArea = new ulong[7];
            fixed (ulong* retAreaByte0 = &retArea[0])
            {
                var ptr = (nint)retAreaByte0;
                GetWasmInterop.wasmImportGet(handle, ptr);

                Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None>? lifted200;

                switch (new Span<byte>((void*)(ptr + 0), 1)[0]) {
                    case 0: {
                        lifted200 = null;
                        break;
                    }

                    case 1: {

                        Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None> lifted199;

                        switch (new Span<byte>((void*)(ptr + 8), 1)[0]) {
                            case 0: {

                                Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode> lifted196;

                                switch (new Span<byte>((void*)(ptr + 16), 1)[0]) {
                                    case 0: {
                                        var resource = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse.THandle(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 24), 4))));

                                        lifted196 = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>.ok(resource);
                                        break;
                                    }
                                    case 1: {

                                        global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode lifted195;

                                        switch (new Span<byte>((void*)(ptr + 24), 1)[0]) {
                                            case 0: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.dnsTimeout();
                                                break;
                                            }
                                            case 1: {

                                                string? lifted;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                ushort? lifted20;

                                                switch (new Span<byte>((void*)(ptr + 44), 1)[0]) {
                                                    case 0: {
                                                        lifted20 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted20 = ((ushort)BitConverter.ToUInt16(new Span<byte>((void*)(ptr + 46), 2)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 44), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.dnsError(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.DnsErrorPayload (
                                                lifted, lifted20));
                                                break;
                                            }
                                            case 2: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationNotFound();
                                                break;
                                            }
                                            case 3: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationUnavailable();
                                                break;
                                            }
                                            case 4: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationIpProhibited();
                                                break;
                                            }
                                            case 5: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.destinationIpUnroutable();
                                                break;
                                            }
                                            case 6: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionRefused();
                                                break;
                                            }
                                            case 7: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionTerminated();
                                                break;
                                            }
                                            case 8: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionTimeout();
                                                break;
                                            }
                                            case 9: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionReadTimeout();
                                                break;
                                            }
                                            case 10: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionWriteTimeout();
                                                break;
                                            }
                                            case 11: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.connectionLimitReached();
                                                break;
                                            }
                                            case 12: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsProtocolError();
                                                break;
                                            }
                                            case 13: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsCertificateError();
                                                break;
                                            }
                                            case 14: {

                                                byte? lifted51;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted51 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted51 = ((byte)new Span<byte>((void*)(ptr + 33), 1)[0]);
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                string? lifted56;

                                                switch (new Span<byte>((void*)(ptr + 36), 1)[0]) {
                                                    case 0: {
                                                        lifted56 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted56 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 44), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 36), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.tlsAlertReceived(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.TlsAlertReceivedPayload (
                                                lifted51, lifted56));
                                                break;
                                            }
                                            case 15: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestDenied();
                                                break;
                                            }
                                            case 16: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestLengthRequired();
                                                break;
                                            }
                                            case 17: {

                                                ulong? lifted67;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted67 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted67 = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 40), 8))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestBodySize(lifted67);
                                                break;
                                            }
                                            case 18: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestMethodInvalid();
                                                break;
                                            }
                                            case 19: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestUriInvalid();
                                                break;
                                            }
                                            case 20: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestUriTooLong();
                                                break;
                                            }
                                            case 21: {

                                                uint? lifted80;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted80 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted80 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestHeaderSectionSize(lifted80);
                                                break;
                                            }
                                            case 22: {

                                                global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload? lifted97;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted97 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        string? lifted91;

                                                        switch (new Span<byte>((void*)(ptr + 36), 1)[0]) {
                                                            case 0: {
                                                                lifted91 = null;
                                                                break;
                                                            }

                                                            case 1: {

                                                                lifted91 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 44), 4)));
                                                                break;
                                                            }

                                                            default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 36), 1)[0]));
                                                        }

                                                        uint? lifted96;

                                                        switch (new Span<byte>((void*)(ptr + 48), 1)[0]) {
                                                            case 0: {
                                                                lifted96 = null;
                                                                break;
                                                            }

                                                            case 1: {

                                                                lifted96 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 52), 4))));
                                                                break;
                                                            }

                                                            default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 48), 1)[0]));
                                                        }

                                                        lifted97 = new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                                        lifted91, lifted96);
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestHeaderSize(lifted97);
                                                break;
                                            }
                                            case 23: {

                                                uint? lifted104;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted104 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted104 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestTrailerSectionSize(lifted104);
                                                break;
                                            }
                                            case 24: {

                                                string? lifted111;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted111 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted111 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                uint? lifted116;

                                                switch (new Span<byte>((void*)(ptr + 44), 1)[0]) {
                                                    case 0: {
                                                        lifted116 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted116 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 48), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 44), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpRequestTrailerSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                                lifted111, lifted116));
                                                break;
                                            }
                                            case 25: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseIncomplete();
                                                break;
                                            }
                                            case 26: {

                                                uint? lifted125;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted125 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted125 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseHeaderSectionSize(lifted125);
                                                break;
                                            }
                                            case 27: {

                                                string? lifted132;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted132 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted132 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                uint? lifted137;

                                                switch (new Span<byte>((void*)(ptr + 44), 1)[0]) {
                                                    case 0: {
                                                        lifted137 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted137 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 48), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 44), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseHeaderSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                                lifted132, lifted137));
                                                break;
                                            }
                                            case 28: {

                                                ulong? lifted144;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted144 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted144 = unchecked((ulong)(BitConverter.ToInt64(new Span<byte>((void*)(ptr + 40), 8))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseBodySize(lifted144);
                                                break;
                                            }
                                            case 29: {

                                                uint? lifted151;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted151 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted151 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTrailerSectionSize(lifted151);
                                                break;
                                            }
                                            case 30: {

                                                string? lifted158;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted158 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted158 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                uint? lifted163;

                                                switch (new Span<byte>((void*)(ptr + 44), 1)[0]) {
                                                    case 0: {
                                                        lifted163 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted163 = unchecked((uint)(BitConverter.ToInt32(new Span<byte>((void*)(ptr + 48), 4))));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 44), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTrailerSize(new global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.FieldSizePayload (
                                                lifted158, lifted163));
                                                break;
                                            }
                                            case 31: {

                                                string? lifted170;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted170 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted170 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTransferCoding(lifted170);
                                                break;
                                            }
                                            case 32: {

                                                string? lifted177;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted177 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted177 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseContentCoding(lifted177);
                                                break;
                                            }
                                            case 33: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpResponseTimeout();
                                                break;
                                            }
                                            case 34: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpUpgradeFailed();
                                                break;
                                            }
                                            case 35: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.httpProtocolError();
                                                break;
                                            }
                                            case 36: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.loopDetected();
                                                break;
                                            }
                                            case 37: {

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.configurationError();
                                                break;
                                            }
                                            case 38: {

                                                string? lifted194;

                                                switch (new Span<byte>((void*)(ptr + 32), 1)[0]) {
                                                    case 0: {
                                                        lifted194 = null;
                                                        break;
                                                    }

                                                    case 1: {

                                                        lifted194 = Encoding.UTF8.GetString((byte*)BitConverter.ToInt32(new Span<byte>((void*)(ptr + 36), 4)), BitConverter.ToInt32(new Span<byte>((void*)(ptr + 40), 4)));
                                                        break;
                                                    }

                                                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 32), 1)[0]));
                                                }

                                                lifted195 = global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode.internalError(lifted194);
                                                break;
                                            }

                                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 24), 1)[0]}");
                                        }

                                        lifted196 = Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>.err(lifted195);
                                        break;
                                    }

                                    default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 16), 1)[0]}");
                                }

                                lifted199 = Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None>.ok(lifted196);
                                break;
                            }
                            case 1: {

                                lifted199 = Result<Result<global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.IncomingResponse, global::WasiHttpWorld.wit.imports.wasi.http.v0_2_1.ITypes.ErrorCode>, None>.err(new global::WasiHttpWorld.None());
                                break;
                            }

                            default: throw new ArgumentException($"invalid discriminant: {new Span<byte>((void*)(ptr + 8), 1)[0]}");
                        }

                        lifted200 = lifted199;
                        break;
                    }

                    default: throw new ArgumentException("invalid discriminant: " + (new Span<byte>((void*)(ptr + 0), 1)[0]));
                }
                return lifted200;
            }

            //TODO: free alloc handle (interopString) if exists
        }

    }

}
