/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef IPV4_H
#define IPV4_H

#include "config.h"

typedef uint32_t ipv4_t;

typedef char ipv4_string_t[15 + 3 + 1];
/* Sufficient length for both addresses and prefixes. */

typedef unsigned prefix_len_t;

typedef struct {
  ipv4_t network;
  prefix_len_t length;
} ipv4_prefix_t;

int ipv4_string_to_address (const char *, ipv4_t *);
void ipv4_address_to_string (ipv4_t, ipv4_string_t);
int ipv4_string_to_prefix (const char *, ipv4_prefix_t *);
void ipv4_prefix_to_string (const ipv4_prefix_t *, char *);

#endif /* IPV4_H */

/* arch-tag: 2f6c4dfe-796d-4227-b35e-0e99c64e495f
 */
