(* $Id: test-caseMap.ml,v 1.4 2006/08/13 21:23:08 yori Exp $ *)
(* Copyright 2003 Yamagata Yoriyuki *)

open Printf
open Blender
open CamomileLibraryTest.Camomile

module UTF8Casing = CaseMap.Make (UTF8)

(* little hack to maintain 4.02.3 compat with warnings *)
module String = struct
  [@@@ocaml.warning "-3-32"]
  let lowercase_ascii = StringLabels.lowercase
  include String
end

let _ = random_test
    ~desc:"ASCII"
    ~log:"caseMap_ASCII"
    ~data:(fun size ->
        let s = Bytes.create size in
        for i = 0 to size - 1 do
          Bytes.set s i (Char.chr (Random.int 0x80))
        done;
        Bytes.to_string s)
    ~body:(fun s -> expect_pass ~body:(fun () ->
        let s1 = UTF8Casing.lowercase s in
        let s2 = String.lowercase_ascii s in
        expect_equal
          ~msg:(lazy (sprintf "lowercase: %s <> %s" s1 s2))
          s1
          s2;
        let s1 = UTF8Casing.uppercase s in
        let s2 = String.uppercase_ascii s in
        expect_equal
          ~msg:(lazy (sprintf "uppercase: %s <> %s" s1 s2))
          s1
          s2))

let _ = test ~desc:"German" ~body:(fun () -> expect_pass ~body:(fun () ->
    let s = "daß mann" in
    let s1 = UTF8Casing.lowercase s in
    let s2 = UTF8Casing.uppercase s in
    let s3 = UTF8Casing.titlecase s in
    expect_equal 
      ~msg:(lazy (sprintf "lowercase of %s: %s" s s1))
      s1 
      "daß mann";
    expect_equal 
      ~msg:(lazy (sprintf "uppercase of %s: %s" s s2))
      s2
      "DASS MANN";
    expect_equal 
      ~msg:(lazy (sprintf "titlecase of %s: %s" s s3))
      s3
      "Daß Mann"))

let _ = test ~desc:"Greek" ~body:(fun () -> expect_pass ~body:(fun () ->
    let s = "ΜΙΣΕΙ ΓΑΡ Ο ΘΕΟΣ ΤΑΣ ΑΓΑΝ ΠΡΟΘΥΜΙΑΣ." in
    let s1 = UTF8Casing.lowercase s in
    let s2 = UTF8Casing.uppercase s in
    let s3 = UTF8Casing.titlecase s in
    expect_equal 
      ~msg:(lazy (sprintf "lowercase of %s: %s" s s1))
      s1 
      "μισει γαρ ο θεος τας αγαν προθυμιας.";
    expect_equal 
      ~msg:(lazy (sprintf "uppercase of %s: %s" s s2))
      s2
      "ΜΙΣΕΙ ΓΑΡ Ο ΘΕΟΣ ΤΑΣ ΑΓΑΝ ΠΡΟΘΥΜΙΑΣ.";
    expect_equal 
      ~msg:(lazy (sprintf "titlecase of %s: %s" s s3))
      s3
      "Μισει Γαρ Ο Θεος Τας Αγαν Προθυμιας."))

let _ = test ~desc:"Turkish" ~body:(fun () -> expect_pass ~body:(fun () ->
    let s = "Iİıi" in
    let s1 = UTF8Casing.lowercase ~locale:"tr" s in
    let s2 = UTF8Casing.uppercase ~locale:"tr" s in
    let s3 = UTF8Casing.titlecase ~locale:"tr" s in
    expect_equal 
      ~msg:(lazy (sprintf "lowercase of %s: %s" s s1))
      s1 
      "ıiıi";
    expect_equal 
      ~msg:(lazy (sprintf "uppercase of %s: %s" s s2))
      s2
      "IİIİ";
    expect_equal 
      ~msg:(lazy (sprintf "titlecase of %s: %s" s s3))
      s3
      "Iiıi"))

(* Fix me: Tests for Azeri,  Lithuanian. *)
