//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/Coord/ICoordSystem.h
//! @brief     Defines interface ICoordSystem and possible axis units.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_DEVICE_COORD_ICOORDSYSTEM_H
#define BORNAGAIN_DEVICE_COORD_ICOORDSYSTEM_H

#include "Base/Axis/Frame.h"
#include "Device/Coord/Tags.h"
#include <string>

//! Interface to provide axis translations to different units for simulation output

class ICoordSystem : public Frame {
public:
    ICoordSystem(std::vector<const Scale*>&& axes);
    ~ICoordSystem() override;

    ICoordSystem* clone() const override = 0;

    virtual double calculateMin(size_t i_axis, Coords units) const = 0;
    virtual double calculateMax(size_t i_axis, Coords units) const = 0;

    virtual std::string nameOfAxis(size_t i_axis, Coords units) const = 0;

    virtual std::vector<Coords> availableUnits() const = 0;
    virtual Coords defaultUnits() const = 0;

    virtual Scale* convertedAxis(size_t i_axis, Coords units) const = 0;

    std::vector<const Scale*> defaultAxes() const;
    std::vector<const Scale*> convertedAxes(Coords units) const;

protected:
    Coords substituteDefaultUnits(Coords units) const;
};

#endif // BORNAGAIN_DEVICE_COORD_ICOORDSYSTEM_H
