/*
    Copyright (C) 2010 UFO Coders <info@ufocoders.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef SERVICEOPTION_H
#define SERVICEOPTION_H

#include "ui_serviceOption.h"

#include <QWidget>
#include <QButtonGroup>

class KService;
class ServiceOption : public QWidget
, Ui::ServiceOption
{
Q_OBJECT

public:
    ServiceOption(const KService* service, QButtonGroup&,  QWidget *parent = 0);
    ServiceOption(const QString& radioText, const QString& descText, QButtonGroup& buttonGroup, QWidget* parent = 0);

    void setChecked(bool);

private Q_SLOTS:
    void toggled(bool);

private:
    void init(const QString& radioText, const QString& descText, QButtonGroup& buttonGroup);

private:
    const KService *m_service;

Q_SIGNALS:
    void selected(const KService*);
};

#endif // SERVICEOPTION_H
