/* EntryMultiCompletion.c generated by valac 0.36.6, the Vala compiler
 * generated from EntryMultiCompletion.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Entry completion for values separated by separators (e.g. comma in the case of tags)*/
/* Partly inspired by the class of the same name in gtkmm-utils by Marko Anastasov*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_ENTRY_MULTI_COMPLETION (entry_multi_completion_get_type ())
#define ENTRY_MULTI_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion))
#define ENTRY_MULTI_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletionClass))
#define IS_ENTRY_MULTI_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENTRY_MULTI_COMPLETION))
#define IS_ENTRY_MULTI_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENTRY_MULTI_COMPLETION))
#define ENTRY_MULTI_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletionClass))

typedef struct _EntryMultiCompletion EntryMultiCompletion;
typedef struct _EntryMultiCompletionClass EntryMultiCompletionClass;
typedef struct _EntryMultiCompletionPrivate EntryMultiCompletionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EntryMultiCompletion {
	GtkEntryCompletion parent_instance;
	EntryMultiCompletionPrivate * priv;
};

struct _EntryMultiCompletionClass {
	GtkEntryCompletionClass parent_class;
};

struct _EntryMultiCompletionPrivate {
	gchar* delimiter;
};


static gpointer entry_multi_completion_parent_class = NULL;

GType entry_multi_completion_get_type (void) G_GNUC_CONST;
#define ENTRY_MULTI_COMPLETION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletionPrivate))
enum  {
	ENTRY_MULTI_COMPLETION_DUMMY_PROPERTY
};
EntryMultiCompletion* entry_multi_completion_new (GeeCollection* completion_list, const gchar* delimiter);
EntryMultiCompletion* entry_multi_completion_construct (GType object_type, GeeCollection* completion_list, const gchar* delimiter);
static GtkListStore* entry_multi_completion_create_completion_store (GeeCollection* completion_list);
static gboolean entry_multi_completion_match_func (EntryMultiCompletion* self, GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter);
static gboolean _entry_multi_completion_match_func_gtk_entry_completion_match_func (GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter, gpointer self);
static gchar* entry_multi_completion_get_last_part (const gchar* s, const gchar* delimiter);
static gboolean entry_multi_completion_real_match_selected (GtkEntryCompletion* base, GtkTreeModel* model, GtkTreeIter* iter);
static void entry_multi_completion_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean _entry_multi_completion_match_func_gtk_entry_completion_match_func (GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = entry_multi_completion_match_func ((EntryMultiCompletion*) self, completion, key, iter);
#line 19 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return result;
#line 78 "EntryMultiCompletion.c"
}


EntryMultiCompletion* entry_multi_completion_construct (GType object_type, GeeCollection* completion_list, const gchar* delimiter) {
	EntryMultiCompletion * self = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GeeCollection* _tmp7_;
	GtkListStore* _tmp8_;
	GtkListStore* _tmp9_;
#line 13 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (completion_list), NULL);
#line 13 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self = (EntryMultiCompletion*) g_object_new (object_type, NULL);
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = delimiter;
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp1_ == NULL) {
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp0_ = TRUE;
#line 101 "EntryMultiCompletion.c"
	} else {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp2_ = delimiter;
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp3_ = strlen (_tmp2_);
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp4_ = _tmp3_;
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp0_ = _tmp4_ == 1;
#line 114 "EntryMultiCompletion.c"
	}
#line 14 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_vala_assert (_tmp0_, "delimiter == null || delimiter.length == 1");
#line 15 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp5_ = delimiter;
#line 15 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 15 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (self->priv->delimiter);
#line 15 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self->priv->delimiter = _tmp6_;
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp7_ = completion_list;
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp8_ = entry_multi_completion_create_completion_store (_tmp7_);
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp9_ = _tmp8_;
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_entry_completion_set_model (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_TREE_MODEL, GtkTreeModel));
#line 17 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_object_unref0 (_tmp9_);
#line 18 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_entry_completion_set_text_column (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), 0);
#line 19 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_entry_completion_set_match_func (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion), _entry_multi_completion_match_func_gtk_entry_completion_match_func, g_object_ref (self), g_object_unref);
#line 13 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return self;
#line 142 "EntryMultiCompletion.c"
}


EntryMultiCompletion* entry_multi_completion_new (GeeCollection* completion_list, const gchar* delimiter) {
#line 13 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return entry_multi_completion_construct (TYPE_ENTRY_MULTI_COMPLETION, completion_list, delimiter);
#line 149 "EntryMultiCompletion.c"
}


static GtkListStore* entry_multi_completion_create_completion_store (GeeCollection* completion_list) {
	GtkListStore* result = NULL;
	GtkListStore* completion_store = NULL;
	GtkListStore* _tmp0_;
	GtkTreeIter store_iter = {0};
	GeeIterator* completion_iter = NULL;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_;
#line 22 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (completion_list), NULL);
#line 23 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp0_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
#line 23 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	completion_store = _tmp0_;
#line 25 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = completion_list;
#line 25 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 25 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	completion_iter = _tmp2_;
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	while (TRUE) {
#line 175 "EntryMultiCompletion.c"
		GeeIterator* _tmp3_;
		gboolean _tmp4_;
		GtkListStore* _tmp5_;
		GtkTreeIter _tmp6_ = {0};
		GtkListStore* _tmp7_;
		GtkTreeIter _tmp8_;
		GeeIterator* _tmp9_;
		gpointer _tmp10_;
		gchar* _tmp11_;
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp3_ = completion_iter;
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp4_ = gee_iterator_next (_tmp3_);
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		if (!_tmp4_) {
#line 26 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			break;
#line 193 "EntryMultiCompletion.c"
		}
#line 27 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp5_ = completion_store;
#line 27 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		gtk_list_store_append (_tmp5_, &_tmp6_);
#line 27 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		store_iter = _tmp6_;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp7_ = completion_store;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp8_ = store_iter;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp9_ = completion_iter;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp10_ = gee_iterator_get (_tmp9_);
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp11_ = (gchar*) _tmp10_;
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		gtk_list_store_set (_tmp7_, &_tmp8_, 0, _tmp11_, -1, -1);
#line 28 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (_tmp11_);
#line 215 "EntryMultiCompletion.c"
	}
#line 31 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	result = completion_store;
#line 31 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_object_unref0 (completion_iter);
#line 31 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return result;
#line 223 "EntryMultiCompletion.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return self ? g_object_ref (self) : NULL;
#line 230 "EntryMultiCompletion.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1234 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1235 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1235 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1236 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1236 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1237 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _result_;
#line 1237 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 253 "EntryMultiCompletion.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 1403 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1403 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1404 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1404 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1404 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1404 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 273 "EntryMultiCompletion.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1041 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1042 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1042 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1042 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1042 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1044 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1044 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 298 "EntryMultiCompletion.c"
		gchar* _tmp4_;
#line 1045 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1045 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1045 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 306 "EntryMultiCompletion.c"
	} else {
#line 1047 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = -1;
#line 1047 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 312 "EntryMultiCompletion.c"
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1110 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 331 "EntryMultiCompletion.c"
}


static gboolean entry_multi_completion_match_func (EntryMultiCompletion* self, GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GtkTreeModel* model = NULL;
	GtkEntryCompletion* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	gchar* possible_match = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* normed_key = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (IS_ENTRY_MULTI_COMPLETION (self), FALSE);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (GTK_IS_ENTRY_COMPLETION (completion), FALSE);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp0_ = completion;
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = gtk_entry_completion_get_model (_tmp0_);
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 35 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	model = _tmp2_;
#line 37 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp3_ = model;
#line 37 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp4_ = *iter;
#line 37 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_tree_model_get (_tmp3_, &_tmp4_, 0, &possible_match, -1);
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp5_ = possible_match;
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp6_ = g_utf8_casefold (_tmp5_, (gssize) -1);
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp7_ = _tmp6_;
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp8_ = g_utf8_normalize (_tmp7_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (possible_match);
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	possible_match = _tmp8_;
#line 43 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (_tmp7_);
#line 44 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp9_ = key;
#line 44 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp10_ = g_utf8_normalize (_tmp9_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
#line 44 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	normed_key = _tmp10_;
#line 46 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp11_ = self->priv->delimiter;
#line 46 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp11_ == NULL) {
#line 398 "EntryMultiCompletion.c"
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp12_ = possible_match;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp13_ = normed_key;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp14_ = string_strip (_tmp13_);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp15_ = _tmp14_;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp16_ = g_str_has_prefix (_tmp12_, _tmp15_);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp17_ = _tmp16_;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (_tmp15_);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		result = _tmp17_;
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (normed_key);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (possible_match);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_object_unref0 (model);
#line 47 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		return result;
#line 429 "EntryMultiCompletion.c"
	} else {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp20_;
		gchar* last_part = NULL;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
#line 49 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp18_ = normed_key;
#line 49 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp19_ = self->priv->delimiter;
#line 49 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp20_ = string_contains (_tmp18_, _tmp19_);
#line 49 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		if (_tmp20_) {
#line 458 "EntryMultiCompletion.c"
			gint offset = 0;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint position = 0;
			GtkWidget* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp21_ = normed_key;
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp22_ = normed_key;
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp23_ = self->priv->delimiter;
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp24_ = string_get (_tmp23_, (glong) 0);
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp25_ = string_last_index_of_char (_tmp22_, (gunichar) _tmp24_, 0);
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp26_ = g_utf8_strlen (_tmp21_, (gssize) _tmp25_);
#line 51 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			offset = _tmp26_;
#line 52 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp27_ = gtk_entry_completion_get_entry (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion));
#line 52 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp28_ = gtk_editable_get_position (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_entry_get_type (), GtkEntry), GTK_TYPE_EDITABLE, GtkEditable));
#line 52 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			position = _tmp28_;
#line 53 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp29_ = position;
#line 53 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp30_ = offset;
#line 53 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			if (_tmp29_ <= _tmp30_) {
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				result = FALSE;
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_g_free0 (normed_key);
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_g_free0 (possible_match);
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_g_object_unref0 (model);
#line 54 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				return result;
#line 507 "EntryMultiCompletion.c"
			}
		}
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp31_ = normed_key;
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp32_ = string_strip (_tmp31_);
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp33_ = _tmp32_;
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp34_ = self->priv->delimiter;
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp35_ = entry_multi_completion_get_last_part (_tmp33_, _tmp34_);
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp36_ = _tmp35_;
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (_tmp33_);
#line 57 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		last_part = _tmp36_;
#line 59 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp37_ = last_part;
#line 59 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp38_ = strlen (_tmp37_);
#line 59 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp39_ = _tmp38_;
#line 59 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		if (_tmp39_ == 0) {
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			result = FALSE;
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (last_part);
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (normed_key);
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (possible_match);
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_object_unref0 (model);
#line 60 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			return result;
#line 546 "EntryMultiCompletion.c"
		}
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp40_ = possible_match;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp41_ = last_part;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp42_ = string_strip (_tmp41_);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp43_ = _tmp42_;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp44_ = g_str_has_prefix (_tmp40_, _tmp43_);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp45_ = _tmp44_;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (_tmp43_);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		result = _tmp45_;
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (last_part);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (normed_key);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_free0 (possible_match);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_g_object_unref0 (model);
#line 62 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		return result;
#line 574 "EntryMultiCompletion.c"
	}
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (normed_key);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (possible_match);
#line 34 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_object_unref0 (model);
#line 582 "EntryMultiCompletion.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 605 "EntryMultiCompletion.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 613 "EntryMultiCompletion.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 625 "EntryMultiCompletion.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 649 "EntryMultiCompletion.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 655 "EntryMultiCompletion.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 659 "EntryMultiCompletion.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 663 "EntryMultiCompletion.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 675 "EntryMultiCompletion.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 685 "EntryMultiCompletion.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 691 "EntryMultiCompletion.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 705 "EntryMultiCompletion.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 715 "EntryMultiCompletion.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 721 "EntryMultiCompletion.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 730 "EntryMultiCompletion.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 750 "EntryMultiCompletion.c"
}


static gboolean entry_multi_completion_real_match_selected (GtkEntryCompletion* base, GtkTreeModel* model, GtkTreeIter* iter) {
	EntryMultiCompletion * self;
	gboolean result = FALSE;
	gchar* match = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkEntry* entry = NULL;
	GtkWidget* _tmp2_;
	GtkEntry* _tmp3_;
	gchar* old_text = NULL;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_;
	gchar* new_text = NULL;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GtkEntry* _tmp35_;
	GtkEntry* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
#line 66 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion);
#line 66 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), FALSE);
#line 66 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 68 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp0_ = model;
#line 68 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = *iter;
#line 68 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_tree_model_get (_tmp0_, &_tmp1_, 0, &match, -1);
#line 70 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp2_ = gtk_entry_completion_get_entry (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_entry_completion_get_type (), GtkEntryCompletion));
#line 70 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_entry_get_type (), GtkEntry));
#line 70 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	entry = _tmp3_;
#line 72 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp4_ = entry;
#line 72 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp5_ = gtk_entry_get_text (_tmp4_);
#line 72 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp6_ = g_utf8_normalize (_tmp5_, (gssize) -1, G_NORMALIZE_ALL_COMPOSE);
#line 72 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	old_text = _tmp6_;
#line 73 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp7_ = old_text;
#line 73 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp8_ = strlen (_tmp7_);
#line 73 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp9_ = _tmp8_;
#line 73 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp9_ > 0) {
#line 820 "EntryMultiCompletion.c"
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_;
#line 74 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp10_ = old_text;
#line 74 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp11_ = self->priv->delimiter;
#line 74 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp12_ = string_contains (_tmp10_, _tmp11_);
#line 74 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		if (_tmp12_) {
#line 832 "EntryMultiCompletion.c"
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp14_ = self->priv->delimiter;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			if (g_strcmp0 (_tmp14_, " ") != 0) {
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_tmp13_ = " ";
#line 849 "EntryMultiCompletion.c"
			} else {
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
				_tmp13_ = "";
#line 853 "EntryMultiCompletion.c"
			}
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp15_ = old_text;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp16_ = old_text;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp17_ = self->priv->delimiter;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp18_ = string_get (_tmp17_, (glong) 0);
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp19_ = string_last_index_of_char (_tmp16_, (gunichar) _tmp18_, 0);
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp20_ = string_substring (_tmp15_, (glong) 0, (glong) (_tmp19_ + 1));
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp21_ = _tmp20_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp22_ = g_strconcat (_tmp21_, _tmp13_, NULL);
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (old_text);
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			old_text = _tmp22_;
#line 75 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (_tmp21_);
#line 877 "EntryMultiCompletion.c"
		} else {
			gchar* _tmp23_;
#line 77 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_tmp23_ = g_strdup ("");
#line 77 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			_g_free0 (old_text);
#line 77 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
			old_text = _tmp23_;
#line 886 "EntryMultiCompletion.c"
		}
	}
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp25_ = self->priv->delimiter;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (g_strcmp0 (_tmp25_, " ") != 0) {
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp24_ = " ";
#line 895 "EntryMultiCompletion.c"
	} else {
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp24_ = "";
#line 899 "EntryMultiCompletion.c"
	}
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp26_ = old_text;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp27_ = match;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp29_ = _tmp28_;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp30_ = self->priv->delimiter;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp32_ = _tmp31_;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp33_ = g_strconcat (_tmp32_, _tmp24_, NULL);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp34_ = _tmp33_;
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (_tmp32_);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (_tmp29_);
#line 80 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	new_text = _tmp34_;
#line 81 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp35_ = entry;
#line 81 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_entry_set_text (_tmp35_, new_text);
#line 82 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp36_ = entry;
#line 82 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp37_ = strlen (new_text);
#line 82 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp38_ = _tmp37_;
#line 82 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	gtk_editable_set_position (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GTK_TYPE_EDITABLE, GtkEditable), (gint) _tmp38_);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	result = TRUE;
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (new_text);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (old_text);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_object_unref0 (entry);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (match);
#line 84 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	return result;
#line 949 "EntryMultiCompletion.c"
}


static gchar* entry_multi_completion_get_last_part (const gchar* s, const gchar* delimiter) {
	gchar* result = NULL;
	gchar** split = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint split_length1;
	gint _split_size_;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
#line 88 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 88 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_return_val_if_fail (delimiter != NULL, NULL);
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp0_ = s;
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp1_ = delimiter;
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp0_, _tmp1_, 0);
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	split = _tmp3_;
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	split_length1 = _vala_array_length (_tmp2_);
#line 89 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_split_size_ = split_length1;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp5_ = split;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_tmp5__length1 = split_length1;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp5_ != NULL) {
#line 987 "EntryMultiCompletion.c"
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp6_ = split;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp6__length1 = split_length1;
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp7_ = _tmp6_[0];
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp4_ = _tmp7_ != NULL;
#line 999 "EntryMultiCompletion.c"
	} else {
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp4_ = FALSE;
#line 1003 "EntryMultiCompletion.c"
	}
#line 91 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	if (_tmp4_) {
#line 1007 "EntryMultiCompletion.c"
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp8_ = split;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp8__length1 = split_length1;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp9_ = split;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp9__length1 = split_length1;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp10_ = _tmp8_[_tmp9__length1 - 1];
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		result = _tmp11_;
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
#line 92 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		return result;
#line 1032 "EntryMultiCompletion.c"
	} else {
		gchar* _tmp12_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		_tmp12_ = g_strdup ("");
#line 94 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		result = _tmp12_;
#line 94 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
#line 94 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
		return result;
#line 1043 "EntryMultiCompletion.c"
	}
#line 88 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
#line 1047 "EntryMultiCompletion.c"
}


static void entry_multi_completion_class_init (EntryMultiCompletionClass * klass) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	entry_multi_completion_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	g_type_class_add_private (klass, sizeof (EntryMultiCompletionPrivate));
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	((GtkEntryCompletionClass *) klass)->match_selected = (gboolean (*) (GtkEntryCompletion *, GtkTreeModel*, GtkTreeIter*)) entry_multi_completion_real_match_selected;
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	G_OBJECT_CLASS (klass)->finalize = entry_multi_completion_finalize;
#line 1060 "EntryMultiCompletion.c"
}


static void entry_multi_completion_instance_init (EntryMultiCompletion * self) {
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self->priv = ENTRY_MULTI_COMPLETION_GET_PRIVATE (self);
#line 1067 "EntryMultiCompletion.c"
}


static void entry_multi_completion_finalize (GObject * obj) {
	EntryMultiCompletion * self;
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENTRY_MULTI_COMPLETION, EntryMultiCompletion);
#line 11 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	_g_free0 (self->priv->delimiter);
#line 10 "/home/jens/Source/shotwell/src/dialogs/EntryMultiCompletion.vala"
	G_OBJECT_CLASS (entry_multi_completion_parent_class)->finalize (obj);
#line 1079 "EntryMultiCompletion.c"
}


GType entry_multi_completion_get_type (void) {
	static volatile gsize entry_multi_completion_type_id__volatile = 0;
	if (g_once_init_enter (&entry_multi_completion_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EntryMultiCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) entry_multi_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EntryMultiCompletion), 0, (GInstanceInitFunc) entry_multi_completion_instance_init, NULL };
		GType entry_multi_completion_type_id;
		entry_multi_completion_type_id = g_type_register_static (gtk_entry_completion_get_type (), "EntryMultiCompletion", &g_define_type_info, 0);
		g_once_init_leave (&entry_multi_completion_type_id__volatile, entry_multi_completion_type_id);
	}
	return entry_multi_completion_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



