//===-- main.c --------------------------------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
#include <stdio.h>

int g_common_1; // Not initialized on purpose to cause it to be undefined external in .o file
int g_file_global_int = 42;
static const int g_file_static_int = 2;
const char *g_file_global_cstr = "g_file_global_cstr";
static const char *g_file_static_cstr = "g_file_static_cstr";
int *g_ptr = &g_file_global_int;

extern int g_a;
int main (int argc, char const *argv[])
{
    g_common_1 = g_file_global_int / g_file_static_int;
    static const char *g_func_static_cstr = "g_func_static_cstr";
    printf ("%s %s\n", g_file_global_cstr, g_file_static_cstr);
    return g_file_global_int + g_a + g_common_1 + *g_ptr; // Set break point at this line.  //// break $source:$line; continue; var -global g_a -global g_global_int
}
