// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 %s -cl-std=CL2.0 -emit-llvm -O3 -o - -triple=amdgcn-amd-amdhsa \
// RUN:   | FileCheck %s --check-prefix=AMDGCN
// RUN: %clang_cc1 %s -cl-std=CL2.0 -emit-llvm -O3 -o - -triple=spirv64-unknown-unknown \
// RUN:   | FileCheck %s --check-prefix=SPIRV

// AMDGCN-LABEL: define dso_local i32 @load(
// AMDGCN-SAME: ptr nocapture noundef readonly [[P:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = load atomic i32, ptr [[P]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @load(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef readonly [[P:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = load atomic i32, ptr addrspace(4) [[P]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int load(int *p) { return __atomic_load_n(p, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local void @store(
// AMDGCN-SAME: ptr nocapture noundef writeonly [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    store atomic i32 [[X]], ptr [[P]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret void
//
// SPIRV-LABEL: define spir_func void @store(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef writeonly [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    store atomic i32 [[X]], ptr addrspace(4) [[P]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret void
//
void store(int *p, int x) { return __atomic_store_n(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @add(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw add ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @add(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw add ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int add(int *p, int x) { return __atomic_fetch_add(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local float @fadd(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], float noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw fadd ptr [[P]], float [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret float [[TMP0]]
//
// SPIRV-LABEL: define spir_func float @fadd(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], float noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw fadd ptr addrspace(4) [[P]], float [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret float [[TMP0]]
//
float fadd(float *p, float x) { return __atomic_fetch_add(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @sub(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw sub ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @sub(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw sub ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int sub(int *p, int x) { return __atomic_fetch_sub(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local float @fsub(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], float noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw fsub ptr [[P]], float [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret float [[TMP0]]
//
// SPIRV-LABEL: define spir_func float @fsub(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], float noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw fsub ptr addrspace(4) [[P]], float [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret float [[TMP0]]
//
float fsub(float *p, float x) { return __atomic_fetch_sub(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @and(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw and ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @and(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw and ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int and(int *p, int x) { return __atomic_fetch_and(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @nand(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw nand ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @nand(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw nand ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int nand(int *p, int x) { return __atomic_fetch_nand(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @or(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw or ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @or(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw or ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int or(int *p, int x) { return __atomic_fetch_or(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @xor(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw xor ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @xor(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw xor ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int xor(int *p, int x) { return __atomic_fetch_xor(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @min(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw min ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @min(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw min ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int min(int *p, int x) { return __atomic_fetch_min(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local float @fmin(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], float noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw fmin ptr [[P]], float [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret float [[TMP0]]
//
// SPIRV-LABEL: define spir_func float @fmin(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], float noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw fmin ptr addrspace(4) [[P]], float [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret float [[TMP0]]
//
float fmin(float *p, float x) { return __atomic_fetch_min(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @max(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw max ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @max(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw max ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int max(int *p, int x) { return __atomic_fetch_max(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local float @fmax(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], float noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw fmax ptr [[P]], float [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret float [[TMP0]]
//
// SPIRV-LABEL: define spir_func float @fmax(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], float noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw fmax ptr addrspace(4) [[P]], float [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret float [[TMP0]]
//
float fmax(float *p, float x) { return __atomic_fetch_max(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local i32 @xchg(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = atomicrmw xchg ptr [[P]], i32 [[X]] syncscope("agent") seq_cst, align 4
// AMDGCN-NEXT:    ret i32 [[TMP0]]
//
// SPIRV-LABEL: define spir_func i32 @xchg(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = atomicrmw xchg ptr addrspace(4) [[P]], i32 [[X]] syncscope("device") seq_cst, align 4
// SPIRV-NEXT:    ret i32 [[TMP0]]
//
int xchg(int *p, int x) { return __atomic_exchange_n(p, x, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local range(i32 0, 2) i32 @cmpxchg(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[P]], i32 [[X]], i32 [[Y]] syncscope("agent") seq_cst seq_cst, align 4
// AMDGCN-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1
// AMDGCN-NEXT:    [[CONV:%.*]] = zext i1 [[TMP1]] to i32
// AMDGCN-NEXT:    ret i32 [[CONV]]
//
// SPIRV-LABEL: define spir_func range(i32 0, 2) i32 @cmpxchg(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = cmpxchg ptr addrspace(4) [[P]], i32 [[X]], i32 [[Y]] syncscope("device") seq_cst seq_cst, align 4
// SPIRV-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1
// SPIRV-NEXT:    [[CONV:%.*]] = zext i1 [[TMP1]] to i32
// SPIRV-NEXT:    ret i32 [[CONV]]
//
int cmpxchg(int *p, int x, int y) { return __atomic_compare_exchange(p, &x, &y, 0, __ATOMIC_SEQ_CST, __ATOMIC_SEQ_CST); }
// AMDGCN-LABEL: define dso_local range(i32 0, 2) i32 @cmpxchg_weak(
// AMDGCN-SAME: ptr nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// AMDGCN-NEXT:  [[ENTRY:.*:]]
// AMDGCN-NEXT:    [[TMP0:%.*]] = cmpxchg weak ptr [[P]], i32 [[X]], i32 [[Y]] syncscope("agent") seq_cst seq_cst, align 4
// AMDGCN-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1
// AMDGCN-NEXT:    [[CONV:%.*]] = zext i1 [[TMP1]] to i32
// AMDGCN-NEXT:    ret i32 [[CONV]]
//
// SPIRV-LABEL: define spir_func range(i32 0, 2) i32 @cmpxchg_weak(
// SPIRV-SAME: ptr addrspace(4) nocapture noundef [[P:%.*]], i32 noundef [[X:%.*]], i32 noundef [[Y:%.*]]) local_unnamed_addr #[[ATTR0]] {
// SPIRV-NEXT:  [[ENTRY:.*:]]
// SPIRV-NEXT:    [[TMP0:%.*]] = cmpxchg weak ptr addrspace(4) [[P]], i32 [[X]], i32 [[Y]] syncscope("device") seq_cst seq_cst, align 4
// SPIRV-NEXT:    [[TMP1:%.*]] = extractvalue { i32, i1 } [[TMP0]], 1
// SPIRV-NEXT:    [[CONV:%.*]] = zext i1 [[TMP1]] to i32
// SPIRV-NEXT:    ret i32 [[CONV]]
//
int cmpxchg_weak(int *p, int x, int y) { return __atomic_compare_exchange(p, &x, &y, 1, __ATOMIC_SEQ_CST, __ATOMIC_SEQ_CST); }
