; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-attributes
; RUN: opt -passes=function-attrs -S < %s | FileCheck %s

; Atomic load/store to local doesn't affect whether a function is
; readnone/readonly.
define i32 @test1(i32 %x) uwtable ssp {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind ssp willreturn memory(none) uwtable
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[X_ADDR:%.*]] = alloca i32, align 4
; CHECK-NEXT:    store atomic i32 [[X:%.*]], ptr [[X_ADDR]] seq_cst, align 4
; CHECK-NEXT:    [[R:%.*]] = load atomic i32, ptr [[X_ADDR]] seq_cst, align 4
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  %x.addr = alloca i32, align 4
  store atomic i32 %x, ptr %x.addr seq_cst, align 4
  %r = load atomic i32, ptr %x.addr seq_cst, align 4
  ret i32 %r
}

; A function with an Acquire load is not readonly.
define i32 @test2(ptr %x) uwtable ssp {
; CHECK: Function Attrs: mustprogress nofree norecurse nounwind ssp willreturn memory(argmem: readwrite) uwtable
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[R:%.*]] = load atomic i32, ptr [[X:%.*]] seq_cst, align 4
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  %r = load atomic i32, ptr %x seq_cst, align 4
  ret i32 %r
}
