; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+f -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck %s

define float @select_fcmp_false(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_false:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:    ret
  %1 = fcmp false float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_oeq(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_oeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.s a0, fa0, fa1
; CHECK-NEXT:    bnez a0, .LBB1_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB1_2:
; CHECK-NEXT:    ret
  %1 = fcmp oeq float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_ogt(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_ogt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.s a0, fa1, fa0
; CHECK-NEXT:    bnez a0, .LBB2_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:    ret
  %1 = fcmp ogt float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_oge(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_oge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.s a0, fa1, fa0
; CHECK-NEXT:    bnez a0, .LBB3_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB3_2:
; CHECK-NEXT:    ret
  %1 = fcmp oge float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_olt(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_olt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.s a0, fa0, fa1
; CHECK-NEXT:    bnez a0, .LBB4_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB4_2:
; CHECK-NEXT:    ret
  %1 = fcmp olt float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_ole(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_ole:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.s a0, fa0, fa1
; CHECK-NEXT:    bnez a0, .LBB5_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB5_2:
; CHECK-NEXT:    ret
  %1 = fcmp ole float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_one(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.s a0, fa0, fa1
; CHECK-NEXT:    flt.s a1, fa1, fa0
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    bnez a0, .LBB6_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB6_2:
; CHECK-NEXT:    ret
  %1 = fcmp one float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_ord(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_ord:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.s a0, fa1, fa1
; CHECK-NEXT:    feq.s a1, fa0, fa0
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    bnez a0, .LBB7_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB7_2:
; CHECK-NEXT:    ret
  %1 = fcmp ord float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_ueq(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_ueq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.s a0, fa0, fa1
; CHECK-NEXT:    flt.s a1, fa1, fa0
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    beqz a0, .LBB8_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB8_2:
; CHECK-NEXT:    ret
  %1 = fcmp ueq float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_ugt(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.s a0, fa0, fa1
; CHECK-NEXT:    beqz a0, .LBB9_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB9_2:
; CHECK-NEXT:    ret
  %1 = fcmp ugt float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_uge(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.s a0, fa0, fa1
; CHECK-NEXT:    beqz a0, .LBB10_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB10_2:
; CHECK-NEXT:    ret
  %1 = fcmp uge float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_ult(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.s a0, fa1, fa0
; CHECK-NEXT:    beqz a0, .LBB11_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB11_2:
; CHECK-NEXT:    ret
  %1 = fcmp ult float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_ule(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.s a0, fa1, fa0
; CHECK-NEXT:    beqz a0, .LBB12_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB12_2:
; CHECK-NEXT:    ret
  %1 = fcmp ule float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_une(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_une:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.s a0, fa0, fa1
; CHECK-NEXT:    beqz a0, .LBB13_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB13_2:
; CHECK-NEXT:    ret
  %1 = fcmp une float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_uno(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_uno:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.s a0, fa1, fa1
; CHECK-NEXT:    feq.s a1, fa0, fa0
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    beqz a0, .LBB14_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    fmv.s fa0, fa1
; CHECK-NEXT:  .LBB14_2:
; CHECK-NEXT:    ret
  %1 = fcmp uno float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

define float @select_fcmp_true(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_true:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret
  %1 = fcmp true float %a, %b
  %2 = select i1 %1, float %a, float %b
  ret float %2
}

; Ensure that ISel succeeds for a select+fcmp that has an i32 result type.
define i32 @i32_select_fcmp_oeq(float %a, float %b, i32 %c, i32 %d) nounwind {
; CHECK-LABEL: i32_select_fcmp_oeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.s a2, fa0, fa1
; CHECK-NEXT:    bnez a2, .LBB16_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB16_2:
; CHECK-NEXT:    ret
  %1 = fcmp oeq float %a, %b
  %2 = select i1 %1, i32 %c, i32 %d
  ret i32 %2
}

define i32 @select_fcmp_oeq_1_2(float %a, float %b) {
; CHECK-LABEL: select_fcmp_oeq_1_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.s a0, fa0, fa1
; CHECK-NEXT:    li a1, 2
; CHECK-NEXT:    sub a0, a1, a0
; CHECK-NEXT:    ret
  %1 = fcmp fast oeq float %a, %b
  %2 = select i1 %1, i32 1, i32 2
  ret i32 %2
}

define signext i32 @select_fcmp_uge_negone_zero(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_uge_negone_zero:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.s a0, fa0, fa1
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    ret
  %1 = fcmp ugt float %a, %b
  %2 = select i1 %1, i32 -1, i32 0
  ret i32 %2
}

define signext i32 @select_fcmp_uge_1_2(float %a, float %b) nounwind {
; CHECK-LABEL: select_fcmp_uge_1_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.s a0, fa0, fa1
; CHECK-NEXT:    addi a0, a0, 1
; CHECK-NEXT:    ret
  %1 = fcmp ugt float %a, %b
  %2 = select i1 %1, i32 1, i32 2
  ret i32 %2
}
