/* AMD K8 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 1991, 1993, 1994, 2000-2012, 2014 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

// #undef mpn_sublsh_n
// #define mpn_sublsh_n(rp,up,vp,n,c)					\
//    (((rp) == (up)) ? mpn_submul_1 (rp, vp, n, CNST_LIMB(1) << (c))	\
//      : MPN(mpn_sublsh_n)(rp,up,vp,n,c))

/* 2500 MHz K8 Brisbane */
/* FFT tuning limit = 25000000 */
/* Generated by tuneup.c, 2014-03-12, gcc 4.5 */

#define MOD_1_NORM_THRESHOLD                 0  /* always */
#define MOD_1_UNNORM_THRESHOLD               0  /* always */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          4
#define MOD_1U_TO_MOD_1_1_THRESHOLD          3
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        13
#define MOD_1_2_TO_MOD_1_4_THRESHOLD        35
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD      9
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1_NORM_THRESHOLD              1
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           16

#define MUL_TOOM22_THRESHOLD                28
#define MUL_TOOM33_THRESHOLD                81
#define MUL_TOOM44_THRESHOLD               242
#define MUL_TOOM6H_THRESHOLD               345
#define MUL_TOOM8H_THRESHOLD               482

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      97
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     153
#define MUL_TOOM42_TO_TOOM53_THRESHOLD     161
#define MUL_TOOM42_TO_TOOM63_THRESHOLD     175
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     166

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 34
#define SQR_TOOM3_THRESHOLD                129
#define SQR_TOOM4_THRESHOLD                527
#define SQR_TOOM6_THRESHOLD                562
#define SQR_TOOM8_THRESHOLD                  0  /* always */

#define MULMID_TOOM42_THRESHOLD             36

#define MULMOD_BNM1_THRESHOLD               18
#define SQRMOD_BNM1_THRESHOLD               22

#define MUL_FFT_MODF_THRESHOLD             654  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    654, 5}, {     21, 6}, {     11, 5}, {     23, 6}, \
    {     12, 5}, {     25, 6}, {     13, 5}, {     27, 6}, \
    {     15, 5}, {     31, 6}, {     27, 7}, {     15, 6}, \
    {     31, 7}, {     19, 6}, {     39, 7}, {     29, 8}, \
    {     15, 7}, {     33, 8}, {     17, 7}, {     37, 8}, \
    {     19, 7}, {     39, 8}, {     23, 7}, {     47, 8}, \
    {     25, 7}, {     51, 8}, {     43, 9}, {     23, 8}, \
    {     51, 9}, {     27, 8}, {     57, 9}, {     31, 8}, \
    {     65, 9}, {     35, 8}, {     71, 9}, {     39, 8}, \
    {     79, 9}, {     43,10}, {     23, 9}, {     59, 8}, \
    {    119,10}, {     31, 8}, {    125, 9}, {     71,10}, \
    {     39, 9}, {     87,10}, {     47, 9}, {     99,10}, \
    {     55, 9}, {    123,11}, {     31,10}, {     63, 9}, \
    {    131,10}, {     71, 9}, {    143,10}, {     79, 9}, \
    {    159,10}, {     87,11}, {     47,10}, {    119,11}, \
    {     63,10}, {    143,11}, {     79,10}, {    175,11}, \
    {     95,10}, {    199,11}, {    111,10}, {    223,12}, \
    {     63,11}, {    143,10}, {    287, 9}, {    575,10}, \
    {    295,11}, {    159,10}, {    319,11}, {    175,12}, \
    {     95,11}, {    191,10}, {    383,11}, {    207,10}, \
    {    415, 9}, {    831,11}, {    223,10}, {    447,13}, \
    {     63,12}, {    127,11}, {    255,10}, {    511,11}, \
    {    271,10}, {    543, 9}, {   1087,11}, {    287,10}, \
    {    575, 9}, {   1151,12}, {    159,11}, {    319,10}, \
    {    639,11}, {    335,10}, {    671,11}, {    351,10}, \
    {    703,11}, {    367,12}, {    191,11}, {    383,10}, \
    {    767,11}, {    399,10}, {    799,11}, {    415,10}, \
    {    831,12}, {    223,11}, {    447,10}, {    895,11}, \
    {    479,13}, {    127,12}, {    255,11}, {    511,10}, \
    {   1023,11}, {    543,10}, {   1087,12}, {    287,11}, \
    {    575,10}, {   1151,11}, {    607,12}, {    319,11}, \
    {    639,10}, {   1279,11}, {    671,12}, {    351,11}, \
    {    703,10}, {   1407,13}, {    191,12}, {    383,11}, \
    {    767,12}, {    415,11}, {    831,12}, {    447,11}, \
    {    895,12}, {    479,11}, {    959,14}, {    127,13}, \
    {    255,12}, {    511,11}, {   1023,12}, {    543,11}, \
    {   1087,12}, {    575,11}, {   1151,12}, {    607,11}, \
    {   1215,13}, {    319,12}, {    671,11}, {   1343,12}, \
    {    735,13}, {    383,12}, {    799,11}, {   1599,12}, \
    {    863,13}, {    447,12}, {    895,11}, {   1791,12}, \
    {    991,13}, {    511,12}, {   1087,13}, {    575,12}, \
    {   1215,13}, {    639,12}, {   1343,13}, {    703,12}, \
    {   1471,14}, {    383,13}, {    767,12}, {   1599,13}, \
    {    831,12}, {   1663,13}, {    895,12}, {   1791,13}, \
    {    959,12}, {   1919,14}, {    511,13}, {   1087,12}, \
    {   2175,13}, {   1215,14}, {    639,13}, {   1471,14}, \
    {    767,13}, {   1663,14}, {    895,13}, {   1919,15}, \
    {    511,14}, {   1023,13}, {   2175,14}, {   1151,13}, \
    {   2367,14}, {   1279,13}, {   2559,14}, {   1407,15}, \
    {  32768,16}, {  65536,17}, { 131072,18}, { 262144,19}, \
    { 524288,20}, {1048576,21}, {2097152,22}, {4194304,23}, \
    {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 205
#define MUL_FFT_THRESHOLD                11520

#define SQR_FFT_MODF_THRESHOLD             570  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    570, 5}, {     21, 6}, {     11, 5}, {     23, 6}, \
    {     12, 5}, {     25, 6}, {     13, 5}, {     27, 6}, \
    {     14, 5}, {     29, 6}, {     16, 5}, {     33, 6}, \
    {     29, 7}, {     15, 6}, {     31, 7}, {     16, 6}, \
    {     33, 7}, {     17, 6}, {     35, 7}, {     33, 8}, \
    {     17, 7}, {     37, 8}, {     19, 7}, {     40, 8}, \
    {     21, 7}, {     43, 8}, {     23, 7}, {     47, 8}, \
    {     25, 7}, {     51, 8}, {     29, 9}, {     15, 8}, \
    {     37, 9}, {     19, 8}, {     43, 9}, {     23, 8}, \
    {     51, 9}, {     27, 8}, {     55, 9}, {     31, 8}, \
    {     63, 9}, {     35, 8}, {     71, 9}, {     39, 8}, \
    {     79, 9}, {     43,10}, {     23, 9}, {     55,10}, \
    {     31, 9}, {     71,10}, {     39, 9}, {     83,10}, \
    {     47, 9}, {     99,10}, {     55, 9}, {    123,11}, \
    {     31,10}, {     63, 9}, {    127,10}, {     71, 9}, \
    {    143,10}, {     87,11}, {     47,10}, {    111,12}, \
    {     31,11}, {     63,10}, {    143,11}, {     79,10}, \
    {    167,11}, {     95,10}, {    199,11}, {    111,12}, \
    {     63,11}, {    127, 9}, {    511,11}, {    143,10}, \
    {    287, 9}, {    575, 8}, {   1151,11}, {    159,10}, \
    {    319, 9}, {    639,11}, {    175,12}, {     95,11}, \
    {    191,10}, {    383, 9}, {    767,11}, {    207,10}, \
    {    415, 9}, {    831,10}, {    431,11}, {    223,10}, \
    {    447,13}, {     63,12}, {    127,10}, {    511, 9}, \
    {   1023,10}, {    543, 9}, {   1087,11}, {    287,10}, \
    {    575, 9}, {   1151,12}, {    159,11}, {    319,10}, \
    {    639, 9}, {   1279,11}, {    335,10}, {    671,11}, \
    {    351,10}, {    703,11}, {    367,12}, {    191,11}, \
    {    383,10}, {    767,11}, {    399,10}, {    799,11}, \
    {    415,10}, {    831,11}, {    431,12}, {    223,11}, \
    {    447,10}, {    895,11}, {    463,13}, {    127,11}, \
    {    511,10}, {   1023,11}, {    543,10}, {   1087,12}, \
    {    287,11}, {    575,10}, {   1151,11}, {    607,10}, \
    {   1215,12}, {    319,11}, {    639,10}, {   1279,11}, \
    {    671,12}, {    351,11}, {    703,10}, {   1407,13}, \
    {    191,12}, {    383,11}, {    767,10}, {   1535,11}, \
    {    799,12}, {    415,11}, {    831,12}, {    447,11}, \
    {    895,12}, {    479,14}, {    127,12}, {    511,11}, \
    {   1023,12}, {    543,11}, {   1087,12}, {    575,11}, \
    {   1151,12}, {    607,11}, {   1215,13}, {    319,12}, \
    {    639,11}, {   1279,12}, {    671,11}, {   1343,12}, \
    {    703,11}, {   1407,12}, {    735,13}, {    383,12}, \
    {    799,11}, {   1599,12}, {    863,13}, {    447,12}, \
    {    959,13}, {    511,12}, {   1087,13}, {    575,12}, \
    {   1215,13}, {    639,12}, {   1343,13}, {    703,12}, \
    {   1471,14}, {    383,13}, {    767,12}, {   1599,13}, \
    {    831,12}, {   1663,13}, {    895,12}, {   1791,13}, \
    {    959,14}, {    511,13}, {   1023,12}, {   2047,13}, \
    {   1215,14}, {    639,13}, {   1471,14}, {    767,13}, \
    {   1663,14}, {    895,13}, {   1855,15}, {    511,14}, \
    {   1023,13}, {   2111,14}, {   1151,13}, {   2303,14}, \
    {   1407,15}, {  32768,16}, {  65536,17}, { 131072,18}, \
    { 262144,19}, { 524288,20}, {1048576,21}, {2097152,22}, \
    {4194304,23}, {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 214
#define SQR_FFT_THRESHOLD                 5760

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  61
#define MULLO_MUL_N_THRESHOLD            22906

#define DC_DIV_QR_THRESHOLD                 51
#define DC_DIVAPPR_Q_THRESHOLD             264
#define DC_BDIV_QR_THRESHOLD                38
#define DC_BDIV_Q_THRESHOLD                170

#define INV_MULMOD_BNM1_THRESHOLD           67
#define INV_NEWTON_THRESHOLD               246
#define INV_APPR_THRESHOLD                 244

#define BINV_NEWTON_THRESHOLD              252
#define REDC_1_TO_REDC_2_THRESHOLD          35
#define REDC_2_TO_REDC_N_THRESHOLD          84

#define MU_DIV_QR_THRESHOLD               2089
#define MU_DIVAPPR_Q_THRESHOLD            1752
#define MUPI_DIV_QR_THRESHOLD               93
#define MU_BDIV_QR_THRESHOLD              1718
#define MU_BDIV_Q_THRESHOLD               1895

#define POWM_SEC_TABLE  2,16,194,904,2177

#define MATRIX22_STRASSEN_THRESHOLD         21
#define HGCD_THRESHOLD                     148
#define HGCD_APPR_THRESHOLD                185
#define HGCD_REDUCE_THRESHOLD             4120
#define GCD_DC_THRESHOLD                   562
#define GCDEXT_DC_THRESHOLD                501
#define JACOBI_BASE_METHOD                   4

#define GET_STR_DC_THRESHOLD                17
#define GET_STR_PRECOMPUTE_THRESHOLD        29
#define SET_STR_DC_THRESHOLD               268
#define SET_STR_PRECOMPUTE_THRESHOLD      1787

#define FAC_DSC_THRESHOLD                 1240
#define FAC_ODD_THRESHOLD                    0  /* always */
