/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimphelp_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimphelp
 * @title: gimphelp
 * @short_description: Loading help pages using gimp_help.
 *
 * Loading help pages using gimp_help.
 **/


/**
 * gimp_help:
 * @help_domain: The help domain in which help_id is registered.
 * @help_id: The help page's ID.
 *
 * Load a help page.
 *
 * This procedure loads the specified help page into the helpbrowser or
 * what ever is configured as help viewer. The help page is identified
 * by its domain and ID: if help_domain is NULL, we use the help_domain
 * which was registered using the gimp_plugin_help_register()
 * procedure. If help_domain is NULL and no help domain was registered,
 * the help domain of the main GIMP installation is used.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_help (const gchar *help_domain,
           const gchar *help_id)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp-help",
                                    &nreturn_vals,
                                    GIMP_PDB_STRING, help_domain,
                                    GIMP_PDB_STRING, help_id,
                                    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
